// Copyright lowRISC contributors.
// Licensed under the Apache License, Version 2.0, see LICENSE for details.
// SPDX-License-Identifier: Apache-2.0
//
// SECDED decoder generated by util/design/secded_gen.py

module prim_secded_hamming_39_32_dec (
  input        [38:0] data_i,
  output logic [31:0] data_o,
  output logic [6:0] syndrome_o,
  output logic [1:0] err_o
);


  // Syndrome calculation
  assign syndrome_o[0] = ^(data_i & 39'h0156AAAD5B);
  assign syndrome_o[1] = ^(data_i & 39'h029B33366D);
  assign syndrome_o[2] = ^(data_i & 39'h04E3C3C78E);
  assign syndrome_o[3] = ^(data_i & 39'h0803FC07F0);
  assign syndrome_o[4] = ^(data_i & 39'h1003FFF800);
  assign syndrome_o[5] = ^(data_i & 39'h20FC000000);
  assign syndrome_o[6] = ^(data_i & 39'h7FFFFFFFFF);

  // Corrected output calculation
  assign data_o[0] = (syndrome_o == 7'h43) ^ data_i[0];
  assign data_o[1] = (syndrome_o == 7'h45) ^ data_i[1];
  assign data_o[2] = (syndrome_o == 7'h46) ^ data_i[2];
  assign data_o[3] = (syndrome_o == 7'h47) ^ data_i[3];
  assign data_o[4] = (syndrome_o == 7'h49) ^ data_i[4];
  assign data_o[5] = (syndrome_o == 7'h4a) ^ data_i[5];
  assign data_o[6] = (syndrome_o == 7'h4b) ^ data_i[6];
  assign data_o[7] = (syndrome_o == 7'h4c) ^ data_i[7];
  assign data_o[8] = (syndrome_o == 7'h4d) ^ data_i[8];
  assign data_o[9] = (syndrome_o == 7'h4e) ^ data_i[9];
  assign data_o[10] = (syndrome_o == 7'h4f) ^ data_i[10];
  assign data_o[11] = (syndrome_o == 7'h51) ^ data_i[11];
  assign data_o[12] = (syndrome_o == 7'h52) ^ data_i[12];
  assign data_o[13] = (syndrome_o == 7'h53) ^ data_i[13];
  assign data_o[14] = (syndrome_o == 7'h54) ^ data_i[14];
  assign data_o[15] = (syndrome_o == 7'h55) ^ data_i[15];
  assign data_o[16] = (syndrome_o == 7'h56) ^ data_i[16];
  assign data_o[17] = (syndrome_o == 7'h57) ^ data_i[17];
  assign data_o[18] = (syndrome_o == 7'h58) ^ data_i[18];
  assign data_o[19] = (syndrome_o == 7'h59) ^ data_i[19];
  assign data_o[20] = (syndrome_o == 7'h5a) ^ data_i[20];
  assign data_o[21] = (syndrome_o == 7'h5b) ^ data_i[21];
  assign data_o[22] = (syndrome_o == 7'h5c) ^ data_i[22];
  assign data_o[23] = (syndrome_o == 7'h5d) ^ data_i[23];
  assign data_o[24] = (syndrome_o == 7'h5e) ^ data_i[24];
  assign data_o[25] = (syndrome_o == 7'h5f) ^ data_i[25];
  assign data_o[26] = (syndrome_o == 7'h61) ^ data_i[26];
  assign data_o[27] = (syndrome_o == 7'h62) ^ data_i[27];
  assign data_o[28] = (syndrome_o == 7'h63) ^ data_i[28];
  assign data_o[29] = (syndrome_o == 7'h64) ^ data_i[29];
  assign data_o[30] = (syndrome_o == 7'h65) ^ data_i[30];
  assign data_o[31] = (syndrome_o == 7'h66) ^ data_i[31];

  // err_o calc. bit0: single error, bit1: double error
  assign err_o[0] = syndrome_o[6];
  assign err_o[1] = |syndrome_o[5:0] & ~syndrome_o[6];

endmodule : prim_secded_hamming_39_32_dec
