// Copyright lowRISC contributors.
// Licensed under the Apache License, Version 2.0, see LICENSE for details.
// SPDX-License-Identifier: Apache-2.0
//
// SECDED decoder generated by util/design/secded_gen.py

module prim_secded_22_16_dec (
  input        [21:0] data_i,
  output logic [15:0] data_o,
  output logic [5:0] syndrome_o,
  output logic [1:0] err_o
);

  logic single_error;

  // Syndrome calculation
  assign syndrome_o[0] = ^(data_i & 22'h01496E);
  assign syndrome_o[1] = ^(data_i & 22'h02F20B);
  assign syndrome_o[2] = ^(data_i & 22'h048ED8);
  assign syndrome_o[3] = ^(data_i & 22'h087714);
  assign syndrome_o[4] = ^(data_i & 22'h10ACA5);
  assign syndrome_o[5] = ^(data_i & 22'h2011F3);

  // Corrected output calculation
  assign data_o[0] = (syndrome_o == 6'h32) ^ data_i[0];
  assign data_o[1] = (syndrome_o == 6'h23) ^ data_i[1];
  assign data_o[2] = (syndrome_o == 6'h19) ^ data_i[2];
  assign data_o[3] = (syndrome_o == 6'h7) ^ data_i[3];
  assign data_o[4] = (syndrome_o == 6'h2c) ^ data_i[4];
  assign data_o[5] = (syndrome_o == 6'h31) ^ data_i[5];
  assign data_o[6] = (syndrome_o == 6'h25) ^ data_i[6];
  assign data_o[7] = (syndrome_o == 6'h34) ^ data_i[7];
  assign data_o[8] = (syndrome_o == 6'h29) ^ data_i[8];
  assign data_o[9] = (syndrome_o == 6'he) ^ data_i[9];
  assign data_o[10] = (syndrome_o == 6'h1c) ^ data_i[10];
  assign data_o[11] = (syndrome_o == 6'h15) ^ data_i[11];
  assign data_o[12] = (syndrome_o == 6'h2a) ^ data_i[12];
  assign data_o[13] = (syndrome_o == 6'h1a) ^ data_i[13];
  assign data_o[14] = (syndrome_o == 6'hb) ^ data_i[14];
  assign data_o[15] = (syndrome_o == 6'h16) ^ data_i[15];

  // err_o calc. bit0: single error, bit1: double error
  assign single_error = ^syndrome_o;
  assign err_o[0] = single_error;
  assign err_o[1] = ~single_error & (|syndrome_o);

endmodule : prim_secded_22_16_dec
