# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['qiita_sync']

package_data = \
{'': ['*']}

entry_points = \
{'console_scripts': ['qiita_sync = qiita_sync:main']}

setup_kwargs = {
    'name': 'qiita-sync',
    'version': '1.3.1',
    'description': 'Synchronize GitHub with Qiita',
    'long_description': '# Qiita-Sync\n\n![pytest](https://github.com/ryokat3/Qiita-Sync/actions/workflows/pytest.yml/badge.svg)\n[![PyPI version](https://badge.fury.io/py/qiita-sync.svg)](https://badge.fury.io/py/qiita-sync)\n![PyPI - Python Version](https://img.shields.io/pypi/pyversions/qiita-sync)\n![GitHub Workflow Status (branch)](https://img.shields.io/github/workflow/status/ryokat3/Qiita-Sync/Python%20Test/main)\n![Codecov branch](https://img.shields.io/codecov/c/github/ryokat3/Qiita-Sync/main)\n![GitHub](https://img.shields.io/github/license/ryokat3/Qiita-Sync)\n[![Downloads](https://pepy.tech/badge/qiita-sync)](https://pepy.tech/project/qiita-sync)\n\nQiita-Sync is a GitHub Actions that can synchronize your markdown files in GitHub repository with Qiita articles.\n\nIt can be also used as a command line tool.\nSee more details [Qiita-Sync Command Usage](https://github.com/ryokat3/qiita-sync/blob/main/doc/command_usage.md) for command usage.\n\n# Installation\n\n## Qiita Access Token\n\n1. Generate your access token\n\n   1. Open [Qiita Account Applications](https://qiita.com/settings/applications)\n   2. Click "Generate new token"\n   3. Copy the access token displayed.\n\n2. Save the access token to GitHub\n\n   1. Open your GitHub repository\n   2. Go "Settings" >> "Secrets"\n   3. Click "New repository secrets"\n   4. Save the access token with the name `QIITA_ACCESS_TOKEN`\n\n## GitHub Actions\n\n1. Download 2 YAML files of GitHub Actions\n\n   - [qiita_sync.yml](https://raw.githubusercontent.com/ryokat3/qiita-sync/main/github_actions/qiita_sync.yml)\n   - [qiita_sync_check.yml](https://raw.githubusercontent.com/ryokat3/qiita-sync/main/github_actions/qiita_sync_check.yml)\n\n2. Save them in your repository as:\n\n   - `.github/workflow/qiita_sync.yml`\n   - `.github/workflow/qiita_sync_check.yml`\n\n   **NOTE**: Change the cron time `cron: "29 17 * * *"` of `qiita_sync_check.yml` which is the time\n             when this action is sheduled to be executed. `29 17 * * *` indicates that this action is\n             executed every day at 17:29 UTC, which is kind of inactive time for me who is living in Japan.\n             Please adjust it to your convenience.\n\n3. Push them to GitHub\n\n## Badge\n\nYou can add the link to badge in your README file to show if Qiita and GitHub are successfully synchronized or not.\nPlease replaece `<Your-ID>` and `<Your-Respository>` of your own.\n\n```markdown\n![Qiita Sync](https://github.com/<Your-ID>/<Your-Repository>/actions/workflows/qiita_sync_check.yml/badge.svg)\n```\n\nThen the badge will be displayed in your README file.\n\n- synchronized badge:\n\n  ![Passing Badge](https://raw.githubusercontent.com/ryokat3/qiita-sync/main/img/qiita_sync_badge_passing.png)\n\n- unsynchronized badge:\n\n  ![Failing Badge](https://raw.githubusercontent.com/ryokat3/qiita-sync/main/img/qiita_sync_badge_failing.png)\n\n# Synchronization\n\nWhen you notice the failure of synchronization by the badge in README or e-mail notification from GitHub,\nyou can manually run Qiita-Sync GitHub Actions to synchronize them again.\n\n1. Open your GitHub repository\n2. Go "Actions" >> "Qiita Sync" (in left pane)\n3. Click "Run workflow" (in right pane)\n\n# Writing Articles\n\nPlease note some features of Qiita-Sync when writing articles.\n\n## File Name\n\nWhen downloading Qiita article files at first, their file names are like `a5b5328c93bad615c5b2.md` whose\nnaming convention is "\\<Qiita-Article-ID\\>.md". For your convenience,\nyou can rename those files as you like and can move them to any subdirectories within your git repository directory.\n\n## Article Header\n\nEach downloaded article file has a header. This header is automatically generated when downloaded from Qiita site.\nAnd it is automatically removed when uploaded to Qiita site.\n\nYou can cange `title` and `tags` as you like. However **you must not remove `id`** from the header.\nIt\'s a key information for synchronization with Qiita site.\n\nAnd this `id` must be unique. Only one file can included it in the header.\nPlease not to create article files that have same `id`, which can happen when copying an article file.\n\n```markdown\n<!--\ntitle: This header is automatically generated by Qiita-Sync when downloading Qiita articles\ntags:  Qiita-Sync\nid:    a5b5328c93bad615c5b2\n-->\n```\n\nWhen creating new article file, you don\'t need `id` in the header.\n\n```markdown\n<!--\ntitle: No id is necessary in the header when writing new articles\ntags:  Qiita-Sync\n-->\n```\n\nThe `id` will be automatically added to the header after uploaded to Qiita site.\n\n## Links to Qiita article\n\nYou can use a relative file path as a link to another your article file.\n\n```markdown\n<!-- An example of link to another Qiita article when writing -->\n[My Article](../my-article.md)\n```\n\nThis link will be automatically changed to the URL when uploaded to Qiita site.\n\n```markdown\n<!-- An example of link to another Qiita article when published to Qiita site -->\n[My Article](https://qiita.com/ryokat3/items/a5b5328c93bad615c5b2)\n```\n\nAnd it will be automatically changed to the relative file path when downloaded from Qiita site.\n\n## Links to image file\n\nYou can use a relative file path as a link to an image file.\n\n```markdown\n<!-- An example of link to image file \'earth.png\' when writing-->\n![My Image](../image/earth.png)\n```\n\nThis link will be automatically changed to the URL when uploaded to Qiita site.\n\n```markdown\n<!-- An example of link to image file \'earth.png\' when published to Qiita site -->\n![My Image](https://raw.githubusercontent.com/ryokat3/qiita-articles/main/image/earth.png)\n```\n\nAnd it will be automatically changed to the relative file path when downloaded from Qiita site.\n\n# Revision History\n\n| Version  | Date       | Summary                                                           |\n|----------|------------|-------------------------------------------------------------------|\n| v1.3.1   | 2021-01-15 | - Fixed many issues when used as CLI                              |\n| v1.3.0   | 2021-01-15 | - Withdrawn from PyPI                                             |\n| v1.2.0   | 2021-01-11 | - Fixed getting Git timestamp and branch name                     |\n| v1.1.1   | 2021-01-11 | - Withdrawn from PyPI                                             |\n| v1.1.0   | 2021-01-10 | - Initial release                                                 |\n',
    'author': 'Ryoji Kato',
    'author_email': 'ryokat3@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/ryokat3/qiita-sync',
    'packages': packages,
    'package_data': package_data,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
