/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
/**
 * Options for python sample code generation
 */
export interface PythonSampleCodeOptions {
    /**
     * The package name which exports the OpenApiGatewayRestApi construct (ie this pdk package!)
     */
    readonly openApiGatewayPackageName: string;
    /**
     * The name of the generated python client package
     */
    readonly pythonClientPackageName: string;
    /**
     * Whether or not to generate sample code
     */
    readonly sampleCode?: boolean;
    /**
     * Directory where the parsed spec is output
     */
    readonly specDir: string;
    /**
     * Name of the parsed spec file
     */
    readonly parsedSpecFileName: string;
    /**
     * Name of the module
     */
    readonly moduleName: string;
}
/**
 * Return a map of file name to contents for the sample python source code
 */
export declare const getPythonSampleSource: (options: PythonSampleCodeOptions) => {
    [fileName: string]: string;
};
