import { Component } from "projen";
import { TypeScriptProject } from "projen/lib/typescript";
/**
 * Configuration for the GeneratedTypescriptClient component
 */
export interface GeneratedTypescriptClientSourceCodeOptions {
    /**
     * Absolute path to the OpenAPI specification (spec.yaml)
     */
    readonly specPath: string;
    /**
     * Control if generator needs to be invoked
     */
    readonly invokeGenerator: boolean;
}
/**
 * Generates the typescript client using OpenAPI Generator
 */
export declare class GeneratedTypescriptClientSourceCode extends Component {
    private options;
    constructor(project: TypeScriptProject, options: GeneratedTypescriptClientSourceCodeOptions);
    /**
     * @inheritDoc
     */
    synthesize(): void;
}
