"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getAuthorizerFunctions = void 0;
const api_gateway_auth_1 = require("./api-gateway-auth");
const predicates_1 = require("../authorizers/predicates");
/**
 * Return all lambda functions used as authorizers, labelled by authorizer id
 */
exports.getAuthorizerFunctions = (options) => api_gateway_auth_1.getAllAuthorizers(options.integrations, options.defaultAuthorizer)
    .filter((authorizer) => predicates_1.isCustomAuthorizer(authorizer))
    .map((authorizer) => ({
    label: authorizer.authorizerId,
    function: authorizer.function,
}));
//# sourceMappingURL=data:application/json;base64,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