"""
    splitit-web-api-v3

    Splitit's API  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://konfigthis.com
"""


import os
import unittest
import uuid

from splitit_client import Splitit


class TestInstallmentPlanApiSimple(unittest.TestCase):
    """InstallmentPlanApi unit test stubs"""

    def setUp(self):
        client_id = os.environ["SPLITIT_CLIENT_ID"]
        client_secret = os.environ["SPLITIT_CLIENT_SECRET"]
        self.api = Splitit(client_id=client_id, client_secret=client_secret)

    def tearDown(self):
        pass

    def test_post(self):
        """Test case for post
        """
        response = self.api.installment_plan.post(
            header_params={
                'X-Splitit-IdempotencyKey': str(uuid.uuid4()),
            },
            body={
                "AutoCapture": True,
                "Attempt3dSecure": True,
                "Shopper": {
                    "Email": "fake@email.com"
                },
                "BillingAddress": {
                    "AddressLine1": "144 Union St",
                    "City": "Brooklyn",
                    "State": "North Dakota",
                    "Zip": "11231",
                    "Country": "United States",
                },
                "PlanData": {
                    "TotalAmount": 10.0,
                    "NumberOfInstallements": 10,
                    "Currency": "USD",
                    "PurchaseMethod": "InStore",
                },
                "RedirectUrls": {}
            }
        )
        print(response)
        assert response is not None, "Received null response"


if __name__ == '__main__':
    unittest.main()
