# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel


class AccessTokenRequest(TeaModel):
    def __init__(self, app_key=None, app_secret=None):
        self.app_key = app_key  # type: str
        self.app_secret = app_secret  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AccessTokenRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_key is not None:
            result['app_key'] = self.app_key
        if self.app_secret is not None:
            result['app_secret'] = self.app_secret
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('app_key') is not None:
            self.app_key = m.get('app_key')
        if m.get('app_secret') is not None:
            self.app_secret = m.get('app_secret')
        return self


class AccessTokenResponseBodyData(TeaModel):
    def __init__(self, expire=None, token=None):
        self.expire = expire  # type: long
        self.token = token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AccessTokenResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.expire is not None:
            result['expire'] = self.expire
        if self.token is not None:
            result['token'] = self.token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('expire') is not None:
            self.expire = m.get('expire')
        if m.get('token') is not None:
            self.token = m.get('token')
        return self


class AccessTokenResponseBodyModule(TeaModel):
    def __init__(self, expire=None, start=None, token=None):
        self.expire = expire  # type: long
        self.start = start  # type: long
        self.token = token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AccessTokenResponseBodyModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.expire is not None:
            result['expire'] = self.expire
        if self.start is not None:
            result['start'] = self.start
        if self.token is not None:
            result['token'] = self.token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('expire') is not None:
            self.expire = m.get('expire')
        if m.get('start') is not None:
            self.start = m.get('start')
        if m.get('token') is not None:
            self.token = m.get('token')
        return self


class AccessTokenResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, module=None, request_id=None, trace_id=None):
        self.code = code  # type: str
        self.data = data  # type: AccessTokenResponseBodyData
        self.message = message  # type: str
        self.module = module  # type: AccessTokenResponseBodyModule
        self.request_id = request_id  # type: str
        # traceId
        self.trace_id = trace_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super(AccessTokenResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.data is not None:
            result['data'] = self.data.to_map()
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('data') is not None:
            temp_model = AccessTokenResponseBodyData()
            self.data = temp_model.from_map(m['data'])
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = AccessTokenResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class AccessTokenResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AccessTokenResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AccessTokenResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AccessTokenResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddressGetHeaders(TeaModel):
    def __init__(self, common_headers=None, x_acs_btrip_so_corp_token=None):
        self.common_headers = common_headers  # type: dict[str, str]
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddressGetHeaders, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class AddressGetRequest(TeaModel):
    def __init__(self, action_type=None, itinerary_id=None, phone=None, type=None, user_id=None):
        self.action_type = action_type  # type: int
        self.itinerary_id = itinerary_id  # type: str
        self.phone = phone  # type: str
        self.type = type  # type: int
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddressGetRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.action_type is not None:
            result['action_type'] = self.action_type
        if self.itinerary_id is not None:
            result['itinerary_id'] = self.itinerary_id
        if self.phone is not None:
            result['phone'] = self.phone
        if self.type is not None:
            result['type'] = self.type
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('action_type') is not None:
            self.action_type = m.get('action_type')
        if m.get('itinerary_id') is not None:
            self.itinerary_id = m.get('itinerary_id')
        if m.get('phone') is not None:
            self.phone = m.get('phone')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class AddressGetResponseBodyModule(TeaModel):
    def __init__(self, url=None):
        self.url = url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddressGetResponseBodyModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.url is not None:
            result['url'] = self.url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('url') is not None:
            self.url = m.get('url')
        return self


class AddressGetResponseBody(TeaModel):
    def __init__(self, code=None, message=None, module=None, request_id=None, success=None, trace_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.module = module  # type: AddressGetResponseBodyModule
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.trace_id = trace_id  # type: str

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super(AddressGetResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = AddressGetResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class AddressGetResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddressGetResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddressGetResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddressGetResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AirportSearchHeaders(TeaModel):
    def __init__(self, common_headers=None, x_acs_btrip_so_corp_token=None):
        self.common_headers = common_headers  # type: dict[str, str]
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AirportSearchHeaders, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class AirportSearchRequest(TeaModel):
    def __init__(self, keyword=None, type=None):
        self.keyword = keyword  # type: str
        self.type = type  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(AirportSearchRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.keyword is not None:
            result['keyword'] = self.keyword
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('keyword') is not None:
            self.keyword = m.get('keyword')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class AirportSearchResponseBodyModuleCities(TeaModel):
    def __init__(self, code=None, distance=None, name=None, travel_name=None):
        self.code = code  # type: str
        self.distance = distance  # type: int
        self.name = name  # type: str
        self.travel_name = travel_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AirportSearchResponseBodyModuleCities, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.distance is not None:
            result['distance'] = self.distance
        if self.name is not None:
            result['name'] = self.name
        if self.travel_name is not None:
            result['travel_name'] = self.travel_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('distance') is not None:
            self.distance = m.get('distance')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('travel_name') is not None:
            self.travel_name = m.get('travel_name')
        return self


class AirportSearchResponseBodyModule(TeaModel):
    def __init__(self, cities=None, nearby=None):
        self.cities = cities  # type: list[AirportSearchResponseBodyModuleCities]
        self.nearby = nearby  # type: bool

    def validate(self):
        if self.cities:
            for k in self.cities:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(AirportSearchResponseBodyModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['cities'] = []
        if self.cities is not None:
            for k in self.cities:
                result['cities'].append(k.to_map() if k else None)
        if self.nearby is not None:
            result['nearby'] = self.nearby
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.cities = []
        if m.get('cities') is not None:
            for k in m.get('cities'):
                temp_model = AirportSearchResponseBodyModuleCities()
                self.cities.append(temp_model.from_map(k))
        if m.get('nearby') is not None:
            self.nearby = m.get('nearby')
        return self


class AirportSearchResponseBody(TeaModel):
    def __init__(self, code=None, message=None, module=None, request_id=None, success=None, trace_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        # module。
        self.module = module  # type: AirportSearchResponseBodyModule
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.trace_id = trace_id  # type: str

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super(AirportSearchResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = AirportSearchResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class AirportSearchResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AirportSearchResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AirportSearchResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AirportSearchResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AllBaseCityInfoQueryHeaders(TeaModel):
    def __init__(self, common_headers=None, x_acs_btrip_access_token=None):
        self.common_headers = common_headers  # type: dict[str, str]
        self.x_acs_btrip_access_token = x_acs_btrip_access_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AllBaseCityInfoQueryHeaders, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_access_token is not None:
            result['x-acs-btrip-access-token'] = self.x_acs_btrip_access_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-access-token') is not None:
            self.x_acs_btrip_access_token = m.get('x-acs-btrip-access-token')
        return self


class AllBaseCityInfoQueryResponseBodyModuleAllCityBaseInfoList(TeaModel):
    def __init__(self, adcode=None, city_code=None, city_level=None, city_name=None, cn_name_tree=None, id=None,
                 other_name_list=None):
        self.adcode = adcode  # type: str
        self.city_code = city_code  # type: str
        self.city_level = city_level  # type: str
        self.city_name = city_name  # type: str
        self.cn_name_tree = cn_name_tree  # type: str
        self.id = id  # type: long
        self.other_name_list = other_name_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(AllBaseCityInfoQueryResponseBodyModuleAllCityBaseInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adcode is not None:
            result['adcode'] = self.adcode
        if self.city_code is not None:
            result['city_code'] = self.city_code
        if self.city_level is not None:
            result['city_level'] = self.city_level
        if self.city_name is not None:
            result['city_name'] = self.city_name
        if self.cn_name_tree is not None:
            result['cn_name_tree'] = self.cn_name_tree
        if self.id is not None:
            result['id'] = self.id
        if self.other_name_list is not None:
            result['other_name_list'] = self.other_name_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('adcode') is not None:
            self.adcode = m.get('adcode')
        if m.get('city_code') is not None:
            self.city_code = m.get('city_code')
        if m.get('city_level') is not None:
            self.city_level = m.get('city_level')
        if m.get('city_name') is not None:
            self.city_name = m.get('city_name')
        if m.get('cn_name_tree') is not None:
            self.cn_name_tree = m.get('cn_name_tree')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('other_name_list') is not None:
            self.other_name_list = m.get('other_name_list')
        return self


class AllBaseCityInfoQueryResponseBodyModule(TeaModel):
    def __init__(self, all_city_base_info_list=None):
        self.all_city_base_info_list = all_city_base_info_list  # type: list[AllBaseCityInfoQueryResponseBodyModuleAllCityBaseInfoList]

    def validate(self):
        if self.all_city_base_info_list:
            for k in self.all_city_base_info_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(AllBaseCityInfoQueryResponseBodyModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['all_city_base_info_list'] = []
        if self.all_city_base_info_list is not None:
            for k in self.all_city_base_info_list:
                result['all_city_base_info_list'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.all_city_base_info_list = []
        if m.get('all_city_base_info_list') is not None:
            for k in m.get('all_city_base_info_list'):
                temp_model = AllBaseCityInfoQueryResponseBodyModuleAllCityBaseInfoList()
                self.all_city_base_info_list.append(temp_model.from_map(k))
        return self


class AllBaseCityInfoQueryResponseBody(TeaModel):
    def __init__(self, code=None, message=None, module=None, request_id=None, success=None, trace_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.module = module  # type: AllBaseCityInfoQueryResponseBodyModule
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        # traceId
        self.trace_id = trace_id  # type: str

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super(AllBaseCityInfoQueryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = AllBaseCityInfoQueryResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class AllBaseCityInfoQueryResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AllBaseCityInfoQueryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AllBaseCityInfoQueryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AllBaseCityInfoQueryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ApplyAddHeaders(TeaModel):
    def __init__(self, common_headers=None, x_acs_btrip_so_corp_token=None):
        self.common_headers = common_headers  # type: dict[str, str]
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ApplyAddHeaders, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class ApplyAddRequestExternalTravelerList(TeaModel):
    def __init__(self, user_name=None):
        self.user_name = user_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ApplyAddRequestExternalTravelerList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.user_name is not None:
            result['user_name'] = self.user_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        return self


class ApplyAddRequestExternalTravelerStandardHotelCitys(TeaModel):
    def __init__(self, city_code=None, city_name=None, fee=None):
        self.city_code = city_code  # type: str
        self.city_name = city_name  # type: str
        self.fee = fee  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ApplyAddRequestExternalTravelerStandardHotelCitys, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city_code is not None:
            result['city_code'] = self.city_code
        if self.city_name is not None:
            result['city_name'] = self.city_name
        if self.fee is not None:
            result['fee'] = self.fee
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('city_code') is not None:
            self.city_code = m.get('city_code')
        if m.get('city_name') is not None:
            self.city_name = m.get('city_name')
        if m.get('fee') is not None:
            self.fee = m.get('fee')
        return self


class ApplyAddRequestExternalTravelerStandard(TeaModel):
    def __init__(self, business_discount=None, economy_discount=None, first_discount=None, flight_cabins=None,
                 hotel_citys=None, premium_economy_discount=None, reserve_type=None, train_seats=None):
        self.business_discount = business_discount  # type: int
        self.economy_discount = economy_discount  # type: int
        self.first_discount = first_discount  # type: int
        self.flight_cabins = flight_cabins  # type: str
        self.hotel_citys = hotel_citys  # type: list[ApplyAddRequestExternalTravelerStandardHotelCitys]
        self.premium_economy_discount = premium_economy_discount  # type: int
        self.reserve_type = reserve_type  # type: int
        self.train_seats = train_seats  # type: str

    def validate(self):
        if self.hotel_citys:
            for k in self.hotel_citys:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ApplyAddRequestExternalTravelerStandard, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_discount is not None:
            result['business_discount'] = self.business_discount
        if self.economy_discount is not None:
            result['economy_discount'] = self.economy_discount
        if self.first_discount is not None:
            result['first_discount'] = self.first_discount
        if self.flight_cabins is not None:
            result['flight_cabins'] = self.flight_cabins
        result['hotel_citys'] = []
        if self.hotel_citys is not None:
            for k in self.hotel_citys:
                result['hotel_citys'].append(k.to_map() if k else None)
        if self.premium_economy_discount is not None:
            result['premium_economy_discount'] = self.premium_economy_discount
        if self.reserve_type is not None:
            result['reserve_type'] = self.reserve_type
        if self.train_seats is not None:
            result['train_seats'] = self.train_seats
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('business_discount') is not None:
            self.business_discount = m.get('business_discount')
        if m.get('economy_discount') is not None:
            self.economy_discount = m.get('economy_discount')
        if m.get('first_discount') is not None:
            self.first_discount = m.get('first_discount')
        if m.get('flight_cabins') is not None:
            self.flight_cabins = m.get('flight_cabins')
        self.hotel_citys = []
        if m.get('hotel_citys') is not None:
            for k in m.get('hotel_citys'):
                temp_model = ApplyAddRequestExternalTravelerStandardHotelCitys()
                self.hotel_citys.append(temp_model.from_map(k))
        if m.get('premium_economy_discount') is not None:
            self.premium_economy_discount = m.get('premium_economy_discount')
        if m.get('reserve_type') is not None:
            self.reserve_type = m.get('reserve_type')
        if m.get('train_seats') is not None:
            self.train_seats = m.get('train_seats')
        return self


class ApplyAddRequestHotelShare(TeaModel):
    def __init__(self, param=None, type=None):
        self.param = param  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ApplyAddRequestHotelShare, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.param is not None:
            result['param'] = self.param
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('param') is not None:
            self.param = m.get('param')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class ApplyAddRequestItineraryList(TeaModel):
    def __init__(self, arr_city=None, arr_city_code=None, arr_date=None, cost_center_id=None, dep_city=None,
                 dep_city_code=None, dep_date=None, invoice_id=None, itinerary_id=None, need_hotel=None, need_traffic=None,
                 project_code=None, project_title=None, third_part_invoice_id=None, thirdpart_cost_center_id=None,
                 traffic_type=None, trip_way=None):
        self.arr_city = arr_city  # type: str
        self.arr_city_code = arr_city_code  # type: str
        self.arr_date = arr_date  # type: str
        self.cost_center_id = cost_center_id  # type: long
        self.dep_city = dep_city  # type: str
        self.dep_city_code = dep_city_code  # type: str
        self.dep_date = dep_date  # type: str
        self.invoice_id = invoice_id  # type: long
        self.itinerary_id = itinerary_id  # type: str
        self.need_hotel = need_hotel  # type: bool
        self.need_traffic = need_traffic  # type: bool
        self.project_code = project_code  # type: str
        self.project_title = project_title  # type: str
        self.third_part_invoice_id = third_part_invoice_id  # type: str
        self.thirdpart_cost_center_id = thirdpart_cost_center_id  # type: str
        self.traffic_type = traffic_type  # type: int
        self.trip_way = trip_way  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ApplyAddRequestItineraryList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arr_city is not None:
            result['arr_city'] = self.arr_city
        if self.arr_city_code is not None:
            result['arr_city_code'] = self.arr_city_code
        if self.arr_date is not None:
            result['arr_date'] = self.arr_date
        if self.cost_center_id is not None:
            result['cost_center_id'] = self.cost_center_id
        if self.dep_city is not None:
            result['dep_city'] = self.dep_city
        if self.dep_city_code is not None:
            result['dep_city_code'] = self.dep_city_code
        if self.dep_date is not None:
            result['dep_date'] = self.dep_date
        if self.invoice_id is not None:
            result['invoice_id'] = self.invoice_id
        if self.itinerary_id is not None:
            result['itinerary_id'] = self.itinerary_id
        if self.need_hotel is not None:
            result['need_hotel'] = self.need_hotel
        if self.need_traffic is not None:
            result['need_traffic'] = self.need_traffic
        if self.project_code is not None:
            result['project_code'] = self.project_code
        if self.project_title is not None:
            result['project_title'] = self.project_title
        if self.third_part_invoice_id is not None:
            result['third_part_invoice_id'] = self.third_part_invoice_id
        if self.thirdpart_cost_center_id is not None:
            result['thirdpart_cost_center_id'] = self.thirdpart_cost_center_id
        if self.traffic_type is not None:
            result['traffic_type'] = self.traffic_type
        if self.trip_way is not None:
            result['trip_way'] = self.trip_way
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('arr_city') is not None:
            self.arr_city = m.get('arr_city')
        if m.get('arr_city_code') is not None:
            self.arr_city_code = m.get('arr_city_code')
        if m.get('arr_date') is not None:
            self.arr_date = m.get('arr_date')
        if m.get('cost_center_id') is not None:
            self.cost_center_id = m.get('cost_center_id')
        if m.get('dep_city') is not None:
            self.dep_city = m.get('dep_city')
        if m.get('dep_city_code') is not None:
            self.dep_city_code = m.get('dep_city_code')
        if m.get('dep_date') is not None:
            self.dep_date = m.get('dep_date')
        if m.get('invoice_id') is not None:
            self.invoice_id = m.get('invoice_id')
        if m.get('itinerary_id') is not None:
            self.itinerary_id = m.get('itinerary_id')
        if m.get('need_hotel') is not None:
            self.need_hotel = m.get('need_hotel')
        if m.get('need_traffic') is not None:
            self.need_traffic = m.get('need_traffic')
        if m.get('project_code') is not None:
            self.project_code = m.get('project_code')
        if m.get('project_title') is not None:
            self.project_title = m.get('project_title')
        if m.get('third_part_invoice_id') is not None:
            self.third_part_invoice_id = m.get('third_part_invoice_id')
        if m.get('thirdpart_cost_center_id') is not None:
            self.thirdpart_cost_center_id = m.get('thirdpart_cost_center_id')
        if m.get('traffic_type') is not None:
            self.traffic_type = m.get('traffic_type')
        if m.get('trip_way') is not None:
            self.trip_way = m.get('trip_way')
        return self


class ApplyAddRequestItinerarySetList(TeaModel):
    def __init__(self, arr_date=None, city_code_set=None, city_set=None, cost_center_id=None, dep_date=None,
                 invoice_id=None, itinerary_id=None, project_code=None, project_title=None, third_part_invoice_id=None,
                 thirdpart_cost_center_id=None, traffic_type=None):
        self.arr_date = arr_date  # type: str
        self.city_code_set = city_code_set  # type: str
        self.city_set = city_set  # type: str
        self.cost_center_id = cost_center_id  # type: long
        self.dep_date = dep_date  # type: str
        self.invoice_id = invoice_id  # type: long
        self.itinerary_id = itinerary_id  # type: str
        self.project_code = project_code  # type: str
        self.project_title = project_title  # type: str
        self.third_part_invoice_id = third_part_invoice_id  # type: str
        self.thirdpart_cost_center_id = thirdpart_cost_center_id  # type: str
        self.traffic_type = traffic_type  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ApplyAddRequestItinerarySetList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arr_date is not None:
            result['arr_date'] = self.arr_date
        if self.city_code_set is not None:
            result['city_code_set'] = self.city_code_set
        if self.city_set is not None:
            result['city_set'] = self.city_set
        if self.cost_center_id is not None:
            result['cost_center_id'] = self.cost_center_id
        if self.dep_date is not None:
            result['dep_date'] = self.dep_date
        if self.invoice_id is not None:
            result['invoice_id'] = self.invoice_id
        if self.itinerary_id is not None:
            result['itinerary_id'] = self.itinerary_id
        if self.project_code is not None:
            result['project_code'] = self.project_code
        if self.project_title is not None:
            result['project_title'] = self.project_title
        if self.third_part_invoice_id is not None:
            result['third_part_invoice_id'] = self.third_part_invoice_id
        if self.thirdpart_cost_center_id is not None:
            result['thirdpart_cost_center_id'] = self.thirdpart_cost_center_id
        if self.traffic_type is not None:
            result['traffic_type'] = self.traffic_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('arr_date') is not None:
            self.arr_date = m.get('arr_date')
        if m.get('city_code_set') is not None:
            self.city_code_set = m.get('city_code_set')
        if m.get('city_set') is not None:
            self.city_set = m.get('city_set')
        if m.get('cost_center_id') is not None:
            self.cost_center_id = m.get('cost_center_id')
        if m.get('dep_date') is not None:
            self.dep_date = m.get('dep_date')
        if m.get('invoice_id') is not None:
            self.invoice_id = m.get('invoice_id')
        if m.get('itinerary_id') is not None:
            self.itinerary_id = m.get('itinerary_id')
        if m.get('project_code') is not None:
            self.project_code = m.get('project_code')
        if m.get('project_title') is not None:
            self.project_title = m.get('project_title')
        if m.get('third_part_invoice_id') is not None:
            self.third_part_invoice_id = m.get('third_part_invoice_id')
        if m.get('thirdpart_cost_center_id') is not None:
            self.thirdpart_cost_center_id = m.get('thirdpart_cost_center_id')
        if m.get('traffic_type') is not None:
            self.traffic_type = m.get('traffic_type')
        return self


class ApplyAddRequestTravelerList(TeaModel):
    def __init__(self, user_id=None, user_name=None):
        self.user_id = user_id  # type: str
        self.user_name = user_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ApplyAddRequestTravelerList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        return self


class ApplyAddRequestTravelerStandardHotelCitys(TeaModel):
    def __init__(self, city_code=None, city_name=None, fee=None):
        self.city_code = city_code  # type: str
        self.city_name = city_name  # type: str
        self.fee = fee  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ApplyAddRequestTravelerStandardHotelCitys, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city_code is not None:
            result['city_code'] = self.city_code
        if self.city_name is not None:
            result['city_name'] = self.city_name
        if self.fee is not None:
            result['fee'] = self.fee
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('city_code') is not None:
            self.city_code = m.get('city_code')
        if m.get('city_name') is not None:
            self.city_name = m.get('city_name')
        if m.get('fee') is not None:
            self.fee = m.get('fee')
        return self


class ApplyAddRequestTravelerStandard(TeaModel):
    def __init__(self, business_discount=None, economy_discount=None, first_discount=None, flight_cabins=None,
                 hotel_citys=None, premium_economy_discount=None, reserve_type=None, train_seats=None, user_id=None):
        self.business_discount = business_discount  # type: int
        self.economy_discount = economy_discount  # type: int
        self.first_discount = first_discount  # type: int
        self.flight_cabins = flight_cabins  # type: str
        self.hotel_citys = hotel_citys  # type: list[ApplyAddRequestTravelerStandardHotelCitys]
        self.premium_economy_discount = premium_economy_discount  # type: int
        self.reserve_type = reserve_type  # type: int
        self.train_seats = train_seats  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        if self.hotel_citys:
            for k in self.hotel_citys:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ApplyAddRequestTravelerStandard, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_discount is not None:
            result['business_discount'] = self.business_discount
        if self.economy_discount is not None:
            result['economy_discount'] = self.economy_discount
        if self.first_discount is not None:
            result['first_discount'] = self.first_discount
        if self.flight_cabins is not None:
            result['flight_cabins'] = self.flight_cabins
        result['hotel_citys'] = []
        if self.hotel_citys is not None:
            for k in self.hotel_citys:
                result['hotel_citys'].append(k.to_map() if k else None)
        if self.premium_economy_discount is not None:
            result['premium_economy_discount'] = self.premium_economy_discount
        if self.reserve_type is not None:
            result['reserve_type'] = self.reserve_type
        if self.train_seats is not None:
            result['train_seats'] = self.train_seats
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('business_discount') is not None:
            self.business_discount = m.get('business_discount')
        if m.get('economy_discount') is not None:
            self.economy_discount = m.get('economy_discount')
        if m.get('first_discount') is not None:
            self.first_discount = m.get('first_discount')
        if m.get('flight_cabins') is not None:
            self.flight_cabins = m.get('flight_cabins')
        self.hotel_citys = []
        if m.get('hotel_citys') is not None:
            for k in m.get('hotel_citys'):
                temp_model = ApplyAddRequestTravelerStandardHotelCitys()
                self.hotel_citys.append(temp_model.from_map(k))
        if m.get('premium_economy_discount') is not None:
            self.premium_economy_discount = m.get('premium_economy_discount')
        if m.get('reserve_type') is not None:
            self.reserve_type = m.get('reserve_type')
        if m.get('train_seats') is not None:
            self.train_seats = m.get('train_seats')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class ApplyAddRequest(TeaModel):
    def __init__(self, budget=None, budget_merge=None, corp_name=None, depart_id=None, depart_name=None,
                 external_traveler_list=None, external_traveler_standard=None, flight_budget=None, hotel_budget=None, hotel_share=None,
                 international_flight_cabins=None, itinerary_list=None, itinerary_rule=None, itinerary_set_list=None, limit_traveler=None,
                 status=None, thirdpart_apply_id=None, thirdpart_business_id=None, thirdpart_depart_id=None,
                 together_book_rule=None, train_budget=None, traveler_list=None, traveler_standard=None, trip_cause=None,
                 trip_day=None, trip_title=None, type=None, union_no=None, user_id=None, user_name=None, vehicle_budget=None):
        self.budget = budget  # type: long
        self.budget_merge = budget_merge  # type: int
        self.corp_name = corp_name  # type: str
        self.depart_id = depart_id  # type: str
        self.depart_name = depart_name  # type: str
        self.external_traveler_list = external_traveler_list  # type: list[ApplyAddRequestExternalTravelerList]
        self.external_traveler_standard = external_traveler_standard  # type: ApplyAddRequestExternalTravelerStandard
        self.flight_budget = flight_budget  # type: long
        self.hotel_budget = hotel_budget  # type: long
        self.hotel_share = hotel_share  # type: ApplyAddRequestHotelShare
        self.international_flight_cabins = international_flight_cabins  # type: str
        self.itinerary_list = itinerary_list  # type: list[ApplyAddRequestItineraryList]
        self.itinerary_rule = itinerary_rule  # type: int
        self.itinerary_set_list = itinerary_set_list  # type: list[ApplyAddRequestItinerarySetList]
        self.limit_traveler = limit_traveler  # type: int
        self.status = status  # type: int
        self.thirdpart_apply_id = thirdpart_apply_id  # type: str
        self.thirdpart_business_id = thirdpart_business_id  # type: str
        self.thirdpart_depart_id = thirdpart_depart_id  # type: str
        self.together_book_rule = together_book_rule  # type: int
        self.train_budget = train_budget  # type: long
        self.traveler_list = traveler_list  # type: list[ApplyAddRequestTravelerList]
        self.traveler_standard = traveler_standard  # type: list[ApplyAddRequestTravelerStandard]
        self.trip_cause = trip_cause  # type: str
        self.trip_day = trip_day  # type: int
        self.trip_title = trip_title  # type: str
        self.type = type  # type: int
        self.union_no = union_no  # type: str
        self.user_id = user_id  # type: str
        self.user_name = user_name  # type: str
        self.vehicle_budget = vehicle_budget  # type: long

    def validate(self):
        if self.external_traveler_list:
            for k in self.external_traveler_list:
                if k:
                    k.validate()
        if self.external_traveler_standard:
            self.external_traveler_standard.validate()
        if self.hotel_share:
            self.hotel_share.validate()
        if self.itinerary_list:
            for k in self.itinerary_list:
                if k:
                    k.validate()
        if self.itinerary_set_list:
            for k in self.itinerary_set_list:
                if k:
                    k.validate()
        if self.traveler_list:
            for k in self.traveler_list:
                if k:
                    k.validate()
        if self.traveler_standard:
            for k in self.traveler_standard:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ApplyAddRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.budget is not None:
            result['budget'] = self.budget
        if self.budget_merge is not None:
            result['budget_merge'] = self.budget_merge
        if self.corp_name is not None:
            result['corp_name'] = self.corp_name
        if self.depart_id is not None:
            result['depart_id'] = self.depart_id
        if self.depart_name is not None:
            result['depart_name'] = self.depart_name
        result['external_traveler_list'] = []
        if self.external_traveler_list is not None:
            for k in self.external_traveler_list:
                result['external_traveler_list'].append(k.to_map() if k else None)
        if self.external_traveler_standard is not None:
            result['external_traveler_standard'] = self.external_traveler_standard.to_map()
        if self.flight_budget is not None:
            result['flight_budget'] = self.flight_budget
        if self.hotel_budget is not None:
            result['hotel_budget'] = self.hotel_budget
        if self.hotel_share is not None:
            result['hotel_share'] = self.hotel_share.to_map()
        if self.international_flight_cabins is not None:
            result['international_flight_cabins'] = self.international_flight_cabins
        result['itinerary_list'] = []
        if self.itinerary_list is not None:
            for k in self.itinerary_list:
                result['itinerary_list'].append(k.to_map() if k else None)
        if self.itinerary_rule is not None:
            result['itinerary_rule'] = self.itinerary_rule
        result['itinerary_set_list'] = []
        if self.itinerary_set_list is not None:
            for k in self.itinerary_set_list:
                result['itinerary_set_list'].append(k.to_map() if k else None)
        if self.limit_traveler is not None:
            result['limit_traveler'] = self.limit_traveler
        if self.status is not None:
            result['status'] = self.status
        if self.thirdpart_apply_id is not None:
            result['thirdpart_apply_id'] = self.thirdpart_apply_id
        if self.thirdpart_business_id is not None:
            result['thirdpart_business_id'] = self.thirdpart_business_id
        if self.thirdpart_depart_id is not None:
            result['thirdpart_depart_id'] = self.thirdpart_depart_id
        if self.together_book_rule is not None:
            result['together_book_rule'] = self.together_book_rule
        if self.train_budget is not None:
            result['train_budget'] = self.train_budget
        result['traveler_list'] = []
        if self.traveler_list is not None:
            for k in self.traveler_list:
                result['traveler_list'].append(k.to_map() if k else None)
        result['traveler_standard'] = []
        if self.traveler_standard is not None:
            for k in self.traveler_standard:
                result['traveler_standard'].append(k.to_map() if k else None)
        if self.trip_cause is not None:
            result['trip_cause'] = self.trip_cause
        if self.trip_day is not None:
            result['trip_day'] = self.trip_day
        if self.trip_title is not None:
            result['trip_title'] = self.trip_title
        if self.type is not None:
            result['type'] = self.type
        if self.union_no is not None:
            result['union_no'] = self.union_no
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        if self.vehicle_budget is not None:
            result['vehicle_budget'] = self.vehicle_budget
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('budget') is not None:
            self.budget = m.get('budget')
        if m.get('budget_merge') is not None:
            self.budget_merge = m.get('budget_merge')
        if m.get('corp_name') is not None:
            self.corp_name = m.get('corp_name')
        if m.get('depart_id') is not None:
            self.depart_id = m.get('depart_id')
        if m.get('depart_name') is not None:
            self.depart_name = m.get('depart_name')
        self.external_traveler_list = []
        if m.get('external_traveler_list') is not None:
            for k in m.get('external_traveler_list'):
                temp_model = ApplyAddRequestExternalTravelerList()
                self.external_traveler_list.append(temp_model.from_map(k))
        if m.get('external_traveler_standard') is not None:
            temp_model = ApplyAddRequestExternalTravelerStandard()
            self.external_traveler_standard = temp_model.from_map(m['external_traveler_standard'])
        if m.get('flight_budget') is not None:
            self.flight_budget = m.get('flight_budget')
        if m.get('hotel_budget') is not None:
            self.hotel_budget = m.get('hotel_budget')
        if m.get('hotel_share') is not None:
            temp_model = ApplyAddRequestHotelShare()
            self.hotel_share = temp_model.from_map(m['hotel_share'])
        if m.get('international_flight_cabins') is not None:
            self.international_flight_cabins = m.get('international_flight_cabins')
        self.itinerary_list = []
        if m.get('itinerary_list') is not None:
            for k in m.get('itinerary_list'):
                temp_model = ApplyAddRequestItineraryList()
                self.itinerary_list.append(temp_model.from_map(k))
        if m.get('itinerary_rule') is not None:
            self.itinerary_rule = m.get('itinerary_rule')
        self.itinerary_set_list = []
        if m.get('itinerary_set_list') is not None:
            for k in m.get('itinerary_set_list'):
                temp_model = ApplyAddRequestItinerarySetList()
                self.itinerary_set_list.append(temp_model.from_map(k))
        if m.get('limit_traveler') is not None:
            self.limit_traveler = m.get('limit_traveler')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('thirdpart_apply_id') is not None:
            self.thirdpart_apply_id = m.get('thirdpart_apply_id')
        if m.get('thirdpart_business_id') is not None:
            self.thirdpart_business_id = m.get('thirdpart_business_id')
        if m.get('thirdpart_depart_id') is not None:
            self.thirdpart_depart_id = m.get('thirdpart_depart_id')
        if m.get('together_book_rule') is not None:
            self.together_book_rule = m.get('together_book_rule')
        if m.get('train_budget') is not None:
            self.train_budget = m.get('train_budget')
        self.traveler_list = []
        if m.get('traveler_list') is not None:
            for k in m.get('traveler_list'):
                temp_model = ApplyAddRequestTravelerList()
                self.traveler_list.append(temp_model.from_map(k))
        self.traveler_standard = []
        if m.get('traveler_standard') is not None:
            for k in m.get('traveler_standard'):
                temp_model = ApplyAddRequestTravelerStandard()
                self.traveler_standard.append(temp_model.from_map(k))
        if m.get('trip_cause') is not None:
            self.trip_cause = m.get('trip_cause')
        if m.get('trip_day') is not None:
            self.trip_day = m.get('trip_day')
        if m.get('trip_title') is not None:
            self.trip_title = m.get('trip_title')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('union_no') is not None:
            self.union_no = m.get('union_no')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        if m.get('vehicle_budget') is not None:
            self.vehicle_budget = m.get('vehicle_budget')
        return self


class ApplyAddShrinkRequest(TeaModel):
    def __init__(self, budget=None, budget_merge=None, corp_name=None, depart_id=None, depart_name=None,
                 external_traveler_list_shrink=None, external_traveler_standard_shrink=None, flight_budget=None, hotel_budget=None,
                 hotel_share_shrink=None, international_flight_cabins=None, itinerary_list_shrink=None, itinerary_rule=None,
                 itinerary_set_list_shrink=None, limit_traveler=None, status=None, thirdpart_apply_id=None, thirdpart_business_id=None,
                 thirdpart_depart_id=None, together_book_rule=None, train_budget=None, traveler_list_shrink=None,
                 traveler_standard_shrink=None, trip_cause=None, trip_day=None, trip_title=None, type=None, union_no=None, user_id=None,
                 user_name=None, vehicle_budget=None):
        self.budget = budget  # type: long
        self.budget_merge = budget_merge  # type: int
        self.corp_name = corp_name  # type: str
        self.depart_id = depart_id  # type: str
        self.depart_name = depart_name  # type: str
        self.external_traveler_list_shrink = external_traveler_list_shrink  # type: str
        self.external_traveler_standard_shrink = external_traveler_standard_shrink  # type: str
        self.flight_budget = flight_budget  # type: long
        self.hotel_budget = hotel_budget  # type: long
        self.hotel_share_shrink = hotel_share_shrink  # type: str
        self.international_flight_cabins = international_flight_cabins  # type: str
        self.itinerary_list_shrink = itinerary_list_shrink  # type: str
        self.itinerary_rule = itinerary_rule  # type: int
        self.itinerary_set_list_shrink = itinerary_set_list_shrink  # type: str
        self.limit_traveler = limit_traveler  # type: int
        self.status = status  # type: int
        self.thirdpart_apply_id = thirdpart_apply_id  # type: str
        self.thirdpart_business_id = thirdpart_business_id  # type: str
        self.thirdpart_depart_id = thirdpart_depart_id  # type: str
        self.together_book_rule = together_book_rule  # type: int
        self.train_budget = train_budget  # type: long
        self.traveler_list_shrink = traveler_list_shrink  # type: str
        self.traveler_standard_shrink = traveler_standard_shrink  # type: str
        self.trip_cause = trip_cause  # type: str
        self.trip_day = trip_day  # type: int
        self.trip_title = trip_title  # type: str
        self.type = type  # type: int
        self.union_no = union_no  # type: str
        self.user_id = user_id  # type: str
        self.user_name = user_name  # type: str
        self.vehicle_budget = vehicle_budget  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ApplyAddShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.budget is not None:
            result['budget'] = self.budget
        if self.budget_merge is not None:
            result['budget_merge'] = self.budget_merge
        if self.corp_name is not None:
            result['corp_name'] = self.corp_name
        if self.depart_id is not None:
            result['depart_id'] = self.depart_id
        if self.depart_name is not None:
            result['depart_name'] = self.depart_name
        if self.external_traveler_list_shrink is not None:
            result['external_traveler_list'] = self.external_traveler_list_shrink
        if self.external_traveler_standard_shrink is not None:
            result['external_traveler_standard'] = self.external_traveler_standard_shrink
        if self.flight_budget is not None:
            result['flight_budget'] = self.flight_budget
        if self.hotel_budget is not None:
            result['hotel_budget'] = self.hotel_budget
        if self.hotel_share_shrink is not None:
            result['hotel_share'] = self.hotel_share_shrink
        if self.international_flight_cabins is not None:
            result['international_flight_cabins'] = self.international_flight_cabins
        if self.itinerary_list_shrink is not None:
            result['itinerary_list'] = self.itinerary_list_shrink
        if self.itinerary_rule is not None:
            result['itinerary_rule'] = self.itinerary_rule
        if self.itinerary_set_list_shrink is not None:
            result['itinerary_set_list'] = self.itinerary_set_list_shrink
        if self.limit_traveler is not None:
            result['limit_traveler'] = self.limit_traveler
        if self.status is not None:
            result['status'] = self.status
        if self.thirdpart_apply_id is not None:
            result['thirdpart_apply_id'] = self.thirdpart_apply_id
        if self.thirdpart_business_id is not None:
            result['thirdpart_business_id'] = self.thirdpart_business_id
        if self.thirdpart_depart_id is not None:
            result['thirdpart_depart_id'] = self.thirdpart_depart_id
        if self.together_book_rule is not None:
            result['together_book_rule'] = self.together_book_rule
        if self.train_budget is not None:
            result['train_budget'] = self.train_budget
        if self.traveler_list_shrink is not None:
            result['traveler_list'] = self.traveler_list_shrink
        if self.traveler_standard_shrink is not None:
            result['traveler_standard'] = self.traveler_standard_shrink
        if self.trip_cause is not None:
            result['trip_cause'] = self.trip_cause
        if self.trip_day is not None:
            result['trip_day'] = self.trip_day
        if self.trip_title is not None:
            result['trip_title'] = self.trip_title
        if self.type is not None:
            result['type'] = self.type
        if self.union_no is not None:
            result['union_no'] = self.union_no
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        if self.vehicle_budget is not None:
            result['vehicle_budget'] = self.vehicle_budget
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('budget') is not None:
            self.budget = m.get('budget')
        if m.get('budget_merge') is not None:
            self.budget_merge = m.get('budget_merge')
        if m.get('corp_name') is not None:
            self.corp_name = m.get('corp_name')
        if m.get('depart_id') is not None:
            self.depart_id = m.get('depart_id')
        if m.get('depart_name') is not None:
            self.depart_name = m.get('depart_name')
        if m.get('external_traveler_list') is not None:
            self.external_traveler_list_shrink = m.get('external_traveler_list')
        if m.get('external_traveler_standard') is not None:
            self.external_traveler_standard_shrink = m.get('external_traveler_standard')
        if m.get('flight_budget') is not None:
            self.flight_budget = m.get('flight_budget')
        if m.get('hotel_budget') is not None:
            self.hotel_budget = m.get('hotel_budget')
        if m.get('hotel_share') is not None:
            self.hotel_share_shrink = m.get('hotel_share')
        if m.get('international_flight_cabins') is not None:
            self.international_flight_cabins = m.get('international_flight_cabins')
        if m.get('itinerary_list') is not None:
            self.itinerary_list_shrink = m.get('itinerary_list')
        if m.get('itinerary_rule') is not None:
            self.itinerary_rule = m.get('itinerary_rule')
        if m.get('itinerary_set_list') is not None:
            self.itinerary_set_list_shrink = m.get('itinerary_set_list')
        if m.get('limit_traveler') is not None:
            self.limit_traveler = m.get('limit_traveler')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('thirdpart_apply_id') is not None:
            self.thirdpart_apply_id = m.get('thirdpart_apply_id')
        if m.get('thirdpart_business_id') is not None:
            self.thirdpart_business_id = m.get('thirdpart_business_id')
        if m.get('thirdpart_depart_id') is not None:
            self.thirdpart_depart_id = m.get('thirdpart_depart_id')
        if m.get('together_book_rule') is not None:
            self.together_book_rule = m.get('together_book_rule')
        if m.get('train_budget') is not None:
            self.train_budget = m.get('train_budget')
        if m.get('traveler_list') is not None:
            self.traveler_list_shrink = m.get('traveler_list')
        if m.get('traveler_standard') is not None:
            self.traveler_standard_shrink = m.get('traveler_standard')
        if m.get('trip_cause') is not None:
            self.trip_cause = m.get('trip_cause')
        if m.get('trip_day') is not None:
            self.trip_day = m.get('trip_day')
        if m.get('trip_title') is not None:
            self.trip_title = m.get('trip_title')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('union_no') is not None:
            self.union_no = m.get('union_no')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        if m.get('vehicle_budget') is not None:
            self.vehicle_budget = m.get('vehicle_budget')
        return self


class ApplyAddResponseBodyModule(TeaModel):
    def __init__(self, apply_id=None, thirdpart_apply_id=None, thirdpart_business_id=None):
        self.apply_id = apply_id  # type: long
        self.thirdpart_apply_id = thirdpart_apply_id  # type: str
        self.thirdpart_business_id = thirdpart_business_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ApplyAddResponseBodyModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.thirdpart_apply_id is not None:
            result['thirdpart_apply_id'] = self.thirdpart_apply_id
        if self.thirdpart_business_id is not None:
            result['thirdpart_business_id'] = self.thirdpart_business_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('thirdpart_apply_id') is not None:
            self.thirdpart_apply_id = m.get('thirdpart_apply_id')
        if m.get('thirdpart_business_id') is not None:
            self.thirdpart_business_id = m.get('thirdpart_business_id')
        return self


class ApplyAddResponseBody(TeaModel):
    def __init__(self, code=None, message=None, module=None, request_id=None, success=None, trace_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        # module。
        self.module = module  # type: ApplyAddResponseBodyModule
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.trace_id = trace_id  # type: str

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super(ApplyAddResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = ApplyAddResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class ApplyAddResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ApplyAddResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ApplyAddResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ApplyAddResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ApplyApproveHeaders(TeaModel):
    def __init__(self, common_headers=None, x_acs_btrip_so_corp_token=None):
        self.common_headers = common_headers  # type: dict[str, str]
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ApplyApproveHeaders, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class ApplyApproveRequest(TeaModel):
    def __init__(self, apply_id=None, note=None, operate_time=None, status=None, user_id=None, user_name=None):
        self.apply_id = apply_id  # type: str
        self.note = note  # type: str
        self.operate_time = operate_time  # type: str
        self.status = status  # type: int
        self.user_id = user_id  # type: str
        self.user_name = user_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ApplyApproveRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.note is not None:
            result['note'] = self.note
        if self.operate_time is not None:
            result['operate_time'] = self.operate_time
        if self.status is not None:
            result['status'] = self.status
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('note') is not None:
            self.note = m.get('note')
        if m.get('operate_time') is not None:
            self.operate_time = m.get('operate_time')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        return self


class ApplyApproveResponseBody(TeaModel):
    def __init__(self, code=None, message=None, module=None, request_id=None, success=None, trace_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        # module。
        self.module = module  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.trace_id = trace_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ApplyApproveResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            self.module = m.get('module')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class ApplyApproveResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ApplyApproveResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ApplyApproveResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ApplyApproveResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ApplyInvoiceTaskHeaders(TeaModel):
    def __init__(self, common_headers=None, x_acs_btrip_so_corp_token=None):
        self.common_headers = common_headers  # type: dict[str, str]
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ApplyInvoiceTaskHeaders, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class ApplyInvoiceTaskRequestInvoiceTaskList(TeaModel):
    def __init__(self, contact=None, email=None, flight_invoice_fee=None, fu_point_invoice_fee=None,
                 hotel_normal_invoice_fee=None, hotel_special_invoice_fee=None, international_flight_invoice_fee=None,
                 invoice_third_part_id=None, mail_address=None, mail_city=None, mail_full_address=None, mail_province=None,
                 penalty_fee=None, remark=None, service_fee=None, telephone=None, train_invoice_fee=None,
                 vehicle_invoice_fee=None):
        self.contact = contact  # type: str
        self.email = email  # type: str
        self.flight_invoice_fee = flight_invoice_fee  # type: str
        self.fu_point_invoice_fee = fu_point_invoice_fee  # type: str
        self.hotel_normal_invoice_fee = hotel_normal_invoice_fee  # type: str
        self.hotel_special_invoice_fee = hotel_special_invoice_fee  # type: str
        self.international_flight_invoice_fee = international_flight_invoice_fee  # type: str
        self.invoice_third_part_id = invoice_third_part_id  # type: str
        self.mail_address = mail_address  # type: str
        self.mail_city = mail_city  # type: str
        self.mail_full_address = mail_full_address  # type: str
        self.mail_province = mail_province  # type: str
        self.penalty_fee = penalty_fee  # type: str
        self.remark = remark  # type: str
        self.service_fee = service_fee  # type: str
        self.telephone = telephone  # type: str
        self.train_invoice_fee = train_invoice_fee  # type: str
        self.vehicle_invoice_fee = vehicle_invoice_fee  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ApplyInvoiceTaskRequestInvoiceTaskList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact is not None:
            result['contact'] = self.contact
        if self.email is not None:
            result['email'] = self.email
        if self.flight_invoice_fee is not None:
            result['flight_invoice_fee'] = self.flight_invoice_fee
        if self.fu_point_invoice_fee is not None:
            result['fu_point_invoice_fee'] = self.fu_point_invoice_fee
        if self.hotel_normal_invoice_fee is not None:
            result['hotel_normal_invoice_fee'] = self.hotel_normal_invoice_fee
        if self.hotel_special_invoice_fee is not None:
            result['hotel_special_invoice_fee'] = self.hotel_special_invoice_fee
        if self.international_flight_invoice_fee is not None:
            result['international_flight_invoice_fee'] = self.international_flight_invoice_fee
        if self.invoice_third_part_id is not None:
            result['invoice_third_part_id'] = self.invoice_third_part_id
        if self.mail_address is not None:
            result['mail_address'] = self.mail_address
        if self.mail_city is not None:
            result['mail_city'] = self.mail_city
        if self.mail_full_address is not None:
            result['mail_full_address'] = self.mail_full_address
        if self.mail_province is not None:
            result['mail_province'] = self.mail_province
        if self.penalty_fee is not None:
            result['penalty_fee'] = self.penalty_fee
        if self.remark is not None:
            result['remark'] = self.remark
        if self.service_fee is not None:
            result['service_fee'] = self.service_fee
        if self.telephone is not None:
            result['telephone'] = self.telephone
        if self.train_invoice_fee is not None:
            result['train_invoice_fee'] = self.train_invoice_fee
        if self.vehicle_invoice_fee is not None:
            result['vehicle_invoice_fee'] = self.vehicle_invoice_fee
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('contact') is not None:
            self.contact = m.get('contact')
        if m.get('email') is not None:
            self.email = m.get('email')
        if m.get('flight_invoice_fee') is not None:
            self.flight_invoice_fee = m.get('flight_invoice_fee')
        if m.get('fu_point_invoice_fee') is not None:
            self.fu_point_invoice_fee = m.get('fu_point_invoice_fee')
        if m.get('hotel_normal_invoice_fee') is not None:
            self.hotel_normal_invoice_fee = m.get('hotel_normal_invoice_fee')
        if m.get('hotel_special_invoice_fee') is not None:
            self.hotel_special_invoice_fee = m.get('hotel_special_invoice_fee')
        if m.get('international_flight_invoice_fee') is not None:
            self.international_flight_invoice_fee = m.get('international_flight_invoice_fee')
        if m.get('invoice_third_part_id') is not None:
            self.invoice_third_part_id = m.get('invoice_third_part_id')
        if m.get('mail_address') is not None:
            self.mail_address = m.get('mail_address')
        if m.get('mail_city') is not None:
            self.mail_city = m.get('mail_city')
        if m.get('mail_full_address') is not None:
            self.mail_full_address = m.get('mail_full_address')
        if m.get('mail_province') is not None:
            self.mail_province = m.get('mail_province')
        if m.get('penalty_fee') is not None:
            self.penalty_fee = m.get('penalty_fee')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        if m.get('service_fee') is not None:
            self.service_fee = m.get('service_fee')
        if m.get('telephone') is not None:
            self.telephone = m.get('telephone')
        if m.get('train_invoice_fee') is not None:
            self.train_invoice_fee = m.get('train_invoice_fee')
        if m.get('vehicle_invoice_fee') is not None:
            self.vehicle_invoice_fee = m.get('vehicle_invoice_fee')
        return self


class ApplyInvoiceTaskRequest(TeaModel):
    def __init__(self, bill_date=None, invoice_task_list=None):
        self.bill_date = bill_date  # type: str
        self.invoice_task_list = invoice_task_list  # type: list[ApplyInvoiceTaskRequestInvoiceTaskList]

    def validate(self):
        if self.invoice_task_list:
            for k in self.invoice_task_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ApplyInvoiceTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bill_date is not None:
            result['bill_date'] = self.bill_date
        result['invoice_task_list'] = []
        if self.invoice_task_list is not None:
            for k in self.invoice_task_list:
                result['invoice_task_list'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('bill_date') is not None:
            self.bill_date = m.get('bill_date')
        self.invoice_task_list = []
        if m.get('invoice_task_list') is not None:
            for k in m.get('invoice_task_list'):
                temp_model = ApplyInvoiceTaskRequestInvoiceTaskList()
                self.invoice_task_list.append(temp_model.from_map(k))
        return self


class ApplyInvoiceTaskShrinkRequest(TeaModel):
    def __init__(self, bill_date=None, invoice_task_list_shrink=None):
        self.bill_date = bill_date  # type: str
        self.invoice_task_list_shrink = invoice_task_list_shrink  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ApplyInvoiceTaskShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bill_date is not None:
            result['bill_date'] = self.bill_date
        if self.invoice_task_list_shrink is not None:
            result['invoice_task_list'] = self.invoice_task_list_shrink
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('bill_date') is not None:
            self.bill_date = m.get('bill_date')
        if m.get('invoice_task_list') is not None:
            self.invoice_task_list_shrink = m.get('invoice_task_list')
        return self


class ApplyInvoiceTaskResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None, trace_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        # requestId
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        # traceId
        self.trace_id = trace_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ApplyInvoiceTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class ApplyInvoiceTaskResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ApplyInvoiceTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ApplyInvoiceTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ApplyInvoiceTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ApplyListQueryHeaders(TeaModel):
    def __init__(self, common_headers=None, x_acs_btrip_so_corp_token=None):
        self.common_headers = common_headers  # type: dict[str, str]
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ApplyListQueryHeaders, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class ApplyListQueryRequest(TeaModel):
    def __init__(self, all_apply=None, depart_id=None, end_time=None, gmt_modified=None, only_shang_lv_apply=None,
                 page=None, page_size=None, start_time=None, type=None, union_no=None, user_id=None):
        self.all_apply = all_apply  # type: bool
        self.depart_id = depart_id  # type: str
        self.end_time = end_time  # type: str
        self.gmt_modified = gmt_modified  # type: str
        self.only_shang_lv_apply = only_shang_lv_apply  # type: bool
        self.page = page  # type: int
        self.page_size = page_size  # type: int
        self.start_time = start_time  # type: str
        self.type = type  # type: int
        self.union_no = union_no  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ApplyListQueryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.all_apply is not None:
            result['all_apply'] = self.all_apply
        if self.depart_id is not None:
            result['depart_id'] = self.depart_id
        if self.end_time is not None:
            result['end_time'] = self.end_time
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        if self.only_shang_lv_apply is not None:
            result['only_shang_lv_apply'] = self.only_shang_lv_apply
        if self.page is not None:
            result['page'] = self.page
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.start_time is not None:
            result['start_time'] = self.start_time
        if self.type is not None:
            result['type'] = self.type
        if self.union_no is not None:
            result['union_no'] = self.union_no
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('all_apply') is not None:
            self.all_apply = m.get('all_apply')
        if m.get('depart_id') is not None:
            self.depart_id = m.get('depart_id')
        if m.get('end_time') is not None:
            self.end_time = m.get('end_time')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        if m.get('only_shang_lv_apply') is not None:
            self.only_shang_lv_apply = m.get('only_shang_lv_apply')
        if m.get('page') is not None:
            self.page = m.get('page')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('start_time') is not None:
            self.start_time = m.get('start_time')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('union_no') is not None:
            self.union_no = m.get('union_no')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class ApplyListQueryResponseBodyModuleListApproverList(TeaModel):
    def __init__(self, note=None, operate_time=None, order=None, status=None, status_desc=None, user_id=None,
                 user_name=None):
        self.note = note  # type: str
        self.operate_time = operate_time  # type: str
        self.order = order  # type: int
        self.status = status  # type: int
        self.status_desc = status_desc  # type: str
        self.user_id = user_id  # type: str
        self.user_name = user_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ApplyListQueryResponseBodyModuleListApproverList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.note is not None:
            result['note'] = self.note
        if self.operate_time is not None:
            result['operate_time'] = self.operate_time
        if self.order is not None:
            result['order'] = self.order
        if self.status is not None:
            result['status'] = self.status
        if self.status_desc is not None:
            result['status_desc'] = self.status_desc
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('note') is not None:
            self.note = m.get('note')
        if m.get('operate_time') is not None:
            self.operate_time = m.get('operate_time')
        if m.get('order') is not None:
            self.order = m.get('order')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('status_desc') is not None:
            self.status_desc = m.get('status_desc')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        return self


class ApplyListQueryResponseBodyModuleListExternalTravelerList(TeaModel):
    def __init__(self, user_name=None):
        self.user_name = user_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ApplyListQueryResponseBodyModuleListExternalTravelerList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.user_name is not None:
            result['user_name'] = self.user_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        return self


class ApplyListQueryResponseBodyModuleListItineraryList(TeaModel):
    def __init__(self, arr_city=None, arr_date=None, cost_center_name=None, dep_city=None, dep_date=None,
                 invoice_name=None, itinerary_id=None, project_code=None, project_title=None, traffic_type=None, trip_way=None):
        self.arr_city = arr_city  # type: str
        self.arr_date = arr_date  # type: str
        self.cost_center_name = cost_center_name  # type: str
        self.dep_city = dep_city  # type: str
        self.dep_date = dep_date  # type: str
        self.invoice_name = invoice_name  # type: str
        self.itinerary_id = itinerary_id  # type: str
        self.project_code = project_code  # type: str
        self.project_title = project_title  # type: str
        self.traffic_type = traffic_type  # type: int
        self.trip_way = trip_way  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ApplyListQueryResponseBodyModuleListItineraryList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arr_city is not None:
            result['arr_city'] = self.arr_city
        if self.arr_date is not None:
            result['arr_date'] = self.arr_date
        if self.cost_center_name is not None:
            result['cost_center_name'] = self.cost_center_name
        if self.dep_city is not None:
            result['dep_city'] = self.dep_city
        if self.dep_date is not None:
            result['dep_date'] = self.dep_date
        if self.invoice_name is not None:
            result['invoice_name'] = self.invoice_name
        if self.itinerary_id is not None:
            result['itinerary_id'] = self.itinerary_id
        if self.project_code is not None:
            result['project_code'] = self.project_code
        if self.project_title is not None:
            result['project_title'] = self.project_title
        if self.traffic_type is not None:
            result['traffic_type'] = self.traffic_type
        if self.trip_way is not None:
            result['trip_way'] = self.trip_way
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('arr_city') is not None:
            self.arr_city = m.get('arr_city')
        if m.get('arr_date') is not None:
            self.arr_date = m.get('arr_date')
        if m.get('cost_center_name') is not None:
            self.cost_center_name = m.get('cost_center_name')
        if m.get('dep_city') is not None:
            self.dep_city = m.get('dep_city')
        if m.get('dep_date') is not None:
            self.dep_date = m.get('dep_date')
        if m.get('invoice_name') is not None:
            self.invoice_name = m.get('invoice_name')
        if m.get('itinerary_id') is not None:
            self.itinerary_id = m.get('itinerary_id')
        if m.get('project_code') is not None:
            self.project_code = m.get('project_code')
        if m.get('project_title') is not None:
            self.project_title = m.get('project_title')
        if m.get('traffic_type') is not None:
            self.traffic_type = m.get('traffic_type')
        if m.get('trip_way') is not None:
            self.trip_way = m.get('trip_way')
        return self


class ApplyListQueryResponseBodyModuleListItinerarySetList(TeaModel):
    def __init__(self, arr_date=None, city_code_set=None, city_set=None, cost_center_name=None, dep_date=None,
                 invoice_name=None, itinerary_id=None, project_code=None, project_title=None, traffic_type=None):
        self.arr_date = arr_date  # type: str
        self.city_code_set = city_code_set  # type: str
        self.city_set = city_set  # type: str
        self.cost_center_name = cost_center_name  # type: str
        self.dep_date = dep_date  # type: str
        self.invoice_name = invoice_name  # type: str
        self.itinerary_id = itinerary_id  # type: str
        self.project_code = project_code  # type: str
        self.project_title = project_title  # type: str
        self.traffic_type = traffic_type  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ApplyListQueryResponseBodyModuleListItinerarySetList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arr_date is not None:
            result['arr_date'] = self.arr_date
        if self.city_code_set is not None:
            result['city_code_set'] = self.city_code_set
        if self.city_set is not None:
            result['city_set'] = self.city_set
        if self.cost_center_name is not None:
            result['cost_center_name'] = self.cost_center_name
        if self.dep_date is not None:
            result['dep_date'] = self.dep_date
        if self.invoice_name is not None:
            result['invoice_name'] = self.invoice_name
        if self.itinerary_id is not None:
            result['itinerary_id'] = self.itinerary_id
        if self.project_code is not None:
            result['project_code'] = self.project_code
        if self.project_title is not None:
            result['project_title'] = self.project_title
        if self.traffic_type is not None:
            result['traffic_type'] = self.traffic_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('arr_date') is not None:
            self.arr_date = m.get('arr_date')
        if m.get('city_code_set') is not None:
            self.city_code_set = m.get('city_code_set')
        if m.get('city_set') is not None:
            self.city_set = m.get('city_set')
        if m.get('cost_center_name') is not None:
            self.cost_center_name = m.get('cost_center_name')
        if m.get('dep_date') is not None:
            self.dep_date = m.get('dep_date')
        if m.get('invoice_name') is not None:
            self.invoice_name = m.get('invoice_name')
        if m.get('itinerary_id') is not None:
            self.itinerary_id = m.get('itinerary_id')
        if m.get('project_code') is not None:
            self.project_code = m.get('project_code')
        if m.get('project_title') is not None:
            self.project_title = m.get('project_title')
        if m.get('traffic_type') is not None:
            self.traffic_type = m.get('traffic_type')
        return self


class ApplyListQueryResponseBodyModuleListTravelerList(TeaModel):
    def __init__(self, user_id=None, user_name=None):
        self.user_id = user_id  # type: str
        self.user_name = user_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ApplyListQueryResponseBodyModuleListTravelerList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        return self


class ApplyListQueryResponseBodyModuleList(TeaModel):
    def __init__(self, apply_show_id=None, approver_list=None, corp_id=None, corp_name=None, depart_id=None,
                 depart_name=None, external_traveler_list=None, flow_code=None, gmt_create=None, gmt_modified=None, id=None,
                 itinerary_list=None, itinerary_rule=None, itinerary_set_list=None, status=None, status_desc=None,
                 thirdpart_business_id=None, thirdpart_id=None, traveler_list=None, trip_cause=None, trip_day=None, trip_title=None,
                 type=None, union_no=None, user_id=None, user_name=None):
        self.apply_show_id = apply_show_id  # type: str
        self.approver_list = approver_list  # type: list[ApplyListQueryResponseBodyModuleListApproverList]
        self.corp_id = corp_id  # type: str
        self.corp_name = corp_name  # type: str
        self.depart_id = depart_id  # type: str
        self.depart_name = depart_name  # type: str
        self.external_traveler_list = external_traveler_list  # type: list[ApplyListQueryResponseBodyModuleListExternalTravelerList]
        self.flow_code = flow_code  # type: str
        self.gmt_create = gmt_create  # type: str
        self.gmt_modified = gmt_modified  # type: str
        self.id = id  # type: long
        self.itinerary_list = itinerary_list  # type: list[ApplyListQueryResponseBodyModuleListItineraryList]
        self.itinerary_rule = itinerary_rule  # type: int
        self.itinerary_set_list = itinerary_set_list  # type: list[ApplyListQueryResponseBodyModuleListItinerarySetList]
        self.status = status  # type: int
        self.status_desc = status_desc  # type: str
        self.thirdpart_business_id = thirdpart_business_id  # type: str
        self.thirdpart_id = thirdpart_id  # type: str
        self.traveler_list = traveler_list  # type: list[ApplyListQueryResponseBodyModuleListTravelerList]
        self.trip_cause = trip_cause  # type: str
        self.trip_day = trip_day  # type: int
        self.trip_title = trip_title  # type: str
        self.type = type  # type: int
        self.union_no = union_no  # type: str
        self.user_id = user_id  # type: str
        self.user_name = user_name  # type: str

    def validate(self):
        if self.approver_list:
            for k in self.approver_list:
                if k:
                    k.validate()
        if self.external_traveler_list:
            for k in self.external_traveler_list:
                if k:
                    k.validate()
        if self.itinerary_list:
            for k in self.itinerary_list:
                if k:
                    k.validate()
        if self.itinerary_set_list:
            for k in self.itinerary_set_list:
                if k:
                    k.validate()
        if self.traveler_list:
            for k in self.traveler_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ApplyListQueryResponseBodyModuleList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_show_id is not None:
            result['apply_show_id'] = self.apply_show_id
        result['approver_list'] = []
        if self.approver_list is not None:
            for k in self.approver_list:
                result['approver_list'].append(k.to_map() if k else None)
        if self.corp_id is not None:
            result['corp_id'] = self.corp_id
        if self.corp_name is not None:
            result['corp_name'] = self.corp_name
        if self.depart_id is not None:
            result['depart_id'] = self.depart_id
        if self.depart_name is not None:
            result['depart_name'] = self.depart_name
        result['external_traveler_list'] = []
        if self.external_traveler_list is not None:
            for k in self.external_traveler_list:
                result['external_traveler_list'].append(k.to_map() if k else None)
        if self.flow_code is not None:
            result['flow_code'] = self.flow_code
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        if self.id is not None:
            result['id'] = self.id
        result['itinerary_list'] = []
        if self.itinerary_list is not None:
            for k in self.itinerary_list:
                result['itinerary_list'].append(k.to_map() if k else None)
        if self.itinerary_rule is not None:
            result['itinerary_rule'] = self.itinerary_rule
        result['itinerary_set_list'] = []
        if self.itinerary_set_list is not None:
            for k in self.itinerary_set_list:
                result['itinerary_set_list'].append(k.to_map() if k else None)
        if self.status is not None:
            result['status'] = self.status
        if self.status_desc is not None:
            result['status_desc'] = self.status_desc
        if self.thirdpart_business_id is not None:
            result['thirdpart_business_id'] = self.thirdpart_business_id
        if self.thirdpart_id is not None:
            result['thirdpart_id'] = self.thirdpart_id
        result['traveler_list'] = []
        if self.traveler_list is not None:
            for k in self.traveler_list:
                result['traveler_list'].append(k.to_map() if k else None)
        if self.trip_cause is not None:
            result['trip_cause'] = self.trip_cause
        if self.trip_day is not None:
            result['trip_day'] = self.trip_day
        if self.trip_title is not None:
            result['trip_title'] = self.trip_title
        if self.type is not None:
            result['type'] = self.type
        if self.union_no is not None:
            result['union_no'] = self.union_no
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('apply_show_id') is not None:
            self.apply_show_id = m.get('apply_show_id')
        self.approver_list = []
        if m.get('approver_list') is not None:
            for k in m.get('approver_list'):
                temp_model = ApplyListQueryResponseBodyModuleListApproverList()
                self.approver_list.append(temp_model.from_map(k))
        if m.get('corp_id') is not None:
            self.corp_id = m.get('corp_id')
        if m.get('corp_name') is not None:
            self.corp_name = m.get('corp_name')
        if m.get('depart_id') is not None:
            self.depart_id = m.get('depart_id')
        if m.get('depart_name') is not None:
            self.depart_name = m.get('depart_name')
        self.external_traveler_list = []
        if m.get('external_traveler_list') is not None:
            for k in m.get('external_traveler_list'):
                temp_model = ApplyListQueryResponseBodyModuleListExternalTravelerList()
                self.external_traveler_list.append(temp_model.from_map(k))
        if m.get('flow_code') is not None:
            self.flow_code = m.get('flow_code')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        if m.get('id') is not None:
            self.id = m.get('id')
        self.itinerary_list = []
        if m.get('itinerary_list') is not None:
            for k in m.get('itinerary_list'):
                temp_model = ApplyListQueryResponseBodyModuleListItineraryList()
                self.itinerary_list.append(temp_model.from_map(k))
        if m.get('itinerary_rule') is not None:
            self.itinerary_rule = m.get('itinerary_rule')
        self.itinerary_set_list = []
        if m.get('itinerary_set_list') is not None:
            for k in m.get('itinerary_set_list'):
                temp_model = ApplyListQueryResponseBodyModuleListItinerarySetList()
                self.itinerary_set_list.append(temp_model.from_map(k))
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('status_desc') is not None:
            self.status_desc = m.get('status_desc')
        if m.get('thirdpart_business_id') is not None:
            self.thirdpart_business_id = m.get('thirdpart_business_id')
        if m.get('thirdpart_id') is not None:
            self.thirdpart_id = m.get('thirdpart_id')
        self.traveler_list = []
        if m.get('traveler_list') is not None:
            for k in m.get('traveler_list'):
                temp_model = ApplyListQueryResponseBodyModuleListTravelerList()
                self.traveler_list.append(temp_model.from_map(k))
        if m.get('trip_cause') is not None:
            self.trip_cause = m.get('trip_cause')
        if m.get('trip_day') is not None:
            self.trip_day = m.get('trip_day')
        if m.get('trip_title') is not None:
            self.trip_title = m.get('trip_title')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('union_no') is not None:
            self.union_no = m.get('union_no')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        return self


class ApplyListQueryResponseBody(TeaModel):
    def __init__(self, code=None, message=None, module_list=None, request_id=None, success=None, trace_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.module_list = module_list  # type: list[ApplyListQueryResponseBodyModuleList]
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.trace_id = trace_id  # type: str

    def validate(self):
        if self.module_list:
            for k in self.module_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ApplyListQueryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        result['module_list'] = []
        if self.module_list is not None:
            for k in self.module_list:
                result['module_list'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        self.module_list = []
        if m.get('module_list') is not None:
            for k in m.get('module_list'):
                temp_model = ApplyListQueryResponseBodyModuleList()
                self.module_list.append(temp_model.from_map(k))
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class ApplyListQueryResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ApplyListQueryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ApplyListQueryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ApplyListQueryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ApplyModifyHeaders(TeaModel):
    def __init__(self, common_headers=None, x_acs_btrip_so_corp_token=None):
        self.common_headers = common_headers  # type: dict[str, str]
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ApplyModifyHeaders, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class ApplyModifyRequestExternalTravelerList(TeaModel):
    def __init__(self, user_name=None):
        self.user_name = user_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ApplyModifyRequestExternalTravelerList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.user_name is not None:
            result['user_name'] = self.user_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        return self


class ApplyModifyRequestExternalTravelerStandardHotelCitys(TeaModel):
    def __init__(self, city_code=None, city_name=None, fee=None):
        self.city_code = city_code  # type: str
        self.city_name = city_name  # type: str
        self.fee = fee  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ApplyModifyRequestExternalTravelerStandardHotelCitys, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city_code is not None:
            result['city_code'] = self.city_code
        if self.city_name is not None:
            result['city_name'] = self.city_name
        if self.fee is not None:
            result['fee'] = self.fee
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('city_code') is not None:
            self.city_code = m.get('city_code')
        if m.get('city_name') is not None:
            self.city_name = m.get('city_name')
        if m.get('fee') is not None:
            self.fee = m.get('fee')
        return self


class ApplyModifyRequestExternalTravelerStandard(TeaModel):
    def __init__(self, business_discount=None, economy_discount=None, first_discount=None, flight_cabins=None,
                 hotel_citys=None, premium_economy_discount=None, reserve_type=None, train_seats=None):
        self.business_discount = business_discount  # type: int
        self.economy_discount = economy_discount  # type: int
        self.first_discount = first_discount  # type: int
        self.flight_cabins = flight_cabins  # type: str
        self.hotel_citys = hotel_citys  # type: list[ApplyModifyRequestExternalTravelerStandardHotelCitys]
        self.premium_economy_discount = premium_economy_discount  # type: int
        self.reserve_type = reserve_type  # type: int
        self.train_seats = train_seats  # type: str

    def validate(self):
        if self.hotel_citys:
            for k in self.hotel_citys:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ApplyModifyRequestExternalTravelerStandard, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_discount is not None:
            result['business_discount'] = self.business_discount
        if self.economy_discount is not None:
            result['economy_discount'] = self.economy_discount
        if self.first_discount is not None:
            result['first_discount'] = self.first_discount
        if self.flight_cabins is not None:
            result['flight_cabins'] = self.flight_cabins
        result['hotel_citys'] = []
        if self.hotel_citys is not None:
            for k in self.hotel_citys:
                result['hotel_citys'].append(k.to_map() if k else None)
        if self.premium_economy_discount is not None:
            result['premium_economy_discount'] = self.premium_economy_discount
        if self.reserve_type is not None:
            result['reserve_type'] = self.reserve_type
        if self.train_seats is not None:
            result['train_seats'] = self.train_seats
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('business_discount') is not None:
            self.business_discount = m.get('business_discount')
        if m.get('economy_discount') is not None:
            self.economy_discount = m.get('economy_discount')
        if m.get('first_discount') is not None:
            self.first_discount = m.get('first_discount')
        if m.get('flight_cabins') is not None:
            self.flight_cabins = m.get('flight_cabins')
        self.hotel_citys = []
        if m.get('hotel_citys') is not None:
            for k in m.get('hotel_citys'):
                temp_model = ApplyModifyRequestExternalTravelerStandardHotelCitys()
                self.hotel_citys.append(temp_model.from_map(k))
        if m.get('premium_economy_discount') is not None:
            self.premium_economy_discount = m.get('premium_economy_discount')
        if m.get('reserve_type') is not None:
            self.reserve_type = m.get('reserve_type')
        if m.get('train_seats') is not None:
            self.train_seats = m.get('train_seats')
        return self


class ApplyModifyRequestHotelShare(TeaModel):
    def __init__(self, param=None, type=None):
        self.param = param  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ApplyModifyRequestHotelShare, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.param is not None:
            result['param'] = self.param
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('param') is not None:
            self.param = m.get('param')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class ApplyModifyRequestItineraryList(TeaModel):
    def __init__(self, arr_city=None, arr_city_code=None, arr_date=None, cost_center_id=None, dep_city=None,
                 dep_city_code=None, dep_date=None, invoice_id=None, itinerary_id=None, need_hotel=None, need_traffic=None,
                 project_code=None, project_title=None, third_part_invoice_id=None, thirdpart_cost_center_id=None,
                 traffic_type=None, trip_way=None):
        self.arr_city = arr_city  # type: str
        self.arr_city_code = arr_city_code  # type: str
        self.arr_date = arr_date  # type: str
        self.cost_center_id = cost_center_id  # type: long
        self.dep_city = dep_city  # type: str
        self.dep_city_code = dep_city_code  # type: str
        self.dep_date = dep_date  # type: str
        self.invoice_id = invoice_id  # type: long
        self.itinerary_id = itinerary_id  # type: str
        self.need_hotel = need_hotel  # type: bool
        self.need_traffic = need_traffic  # type: bool
        self.project_code = project_code  # type: str
        self.project_title = project_title  # type: str
        self.third_part_invoice_id = third_part_invoice_id  # type: str
        self.thirdpart_cost_center_id = thirdpart_cost_center_id  # type: str
        self.traffic_type = traffic_type  # type: int
        self.trip_way = trip_way  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ApplyModifyRequestItineraryList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arr_city is not None:
            result['arr_city'] = self.arr_city
        if self.arr_city_code is not None:
            result['arr_city_code'] = self.arr_city_code
        if self.arr_date is not None:
            result['arr_date'] = self.arr_date
        if self.cost_center_id is not None:
            result['cost_center_id'] = self.cost_center_id
        if self.dep_city is not None:
            result['dep_city'] = self.dep_city
        if self.dep_city_code is not None:
            result['dep_city_code'] = self.dep_city_code
        if self.dep_date is not None:
            result['dep_date'] = self.dep_date
        if self.invoice_id is not None:
            result['invoice_id'] = self.invoice_id
        if self.itinerary_id is not None:
            result['itinerary_id'] = self.itinerary_id
        if self.need_hotel is not None:
            result['need_hotel'] = self.need_hotel
        if self.need_traffic is not None:
            result['need_traffic'] = self.need_traffic
        if self.project_code is not None:
            result['project_code'] = self.project_code
        if self.project_title is not None:
            result['project_title'] = self.project_title
        if self.third_part_invoice_id is not None:
            result['third_part_invoice_id'] = self.third_part_invoice_id
        if self.thirdpart_cost_center_id is not None:
            result['thirdpart_cost_center_id'] = self.thirdpart_cost_center_id
        if self.traffic_type is not None:
            result['traffic_type'] = self.traffic_type
        if self.trip_way is not None:
            result['trip_way'] = self.trip_way
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('arr_city') is not None:
            self.arr_city = m.get('arr_city')
        if m.get('arr_city_code') is not None:
            self.arr_city_code = m.get('arr_city_code')
        if m.get('arr_date') is not None:
            self.arr_date = m.get('arr_date')
        if m.get('cost_center_id') is not None:
            self.cost_center_id = m.get('cost_center_id')
        if m.get('dep_city') is not None:
            self.dep_city = m.get('dep_city')
        if m.get('dep_city_code') is not None:
            self.dep_city_code = m.get('dep_city_code')
        if m.get('dep_date') is not None:
            self.dep_date = m.get('dep_date')
        if m.get('invoice_id') is not None:
            self.invoice_id = m.get('invoice_id')
        if m.get('itinerary_id') is not None:
            self.itinerary_id = m.get('itinerary_id')
        if m.get('need_hotel') is not None:
            self.need_hotel = m.get('need_hotel')
        if m.get('need_traffic') is not None:
            self.need_traffic = m.get('need_traffic')
        if m.get('project_code') is not None:
            self.project_code = m.get('project_code')
        if m.get('project_title') is not None:
            self.project_title = m.get('project_title')
        if m.get('third_part_invoice_id') is not None:
            self.third_part_invoice_id = m.get('third_part_invoice_id')
        if m.get('thirdpart_cost_center_id') is not None:
            self.thirdpart_cost_center_id = m.get('thirdpart_cost_center_id')
        if m.get('traffic_type') is not None:
            self.traffic_type = m.get('traffic_type')
        if m.get('trip_way') is not None:
            self.trip_way = m.get('trip_way')
        return self


class ApplyModifyRequestItinerarySetList(TeaModel):
    def __init__(self, arr_date=None, city_code_set=None, city_set=None, cost_center_id=None, dep_date=None,
                 invoice_id=None, itinerary_id=None, project_code=None, project_title=None, third_part_invoice_id=None,
                 thirdpart_cost_center_id=None, traffic_type=None):
        self.arr_date = arr_date  # type: str
        self.city_code_set = city_code_set  # type: str
        self.city_set = city_set  # type: str
        self.cost_center_id = cost_center_id  # type: long
        self.dep_date = dep_date  # type: str
        self.invoice_id = invoice_id  # type: long
        self.itinerary_id = itinerary_id  # type: str
        self.project_code = project_code  # type: str
        self.project_title = project_title  # type: str
        self.third_part_invoice_id = third_part_invoice_id  # type: str
        self.thirdpart_cost_center_id = thirdpart_cost_center_id  # type: str
        self.traffic_type = traffic_type  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ApplyModifyRequestItinerarySetList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arr_date is not None:
            result['arr_date'] = self.arr_date
        if self.city_code_set is not None:
            result['city_code_set'] = self.city_code_set
        if self.city_set is not None:
            result['city_set'] = self.city_set
        if self.cost_center_id is not None:
            result['cost_center_id'] = self.cost_center_id
        if self.dep_date is not None:
            result['dep_date'] = self.dep_date
        if self.invoice_id is not None:
            result['invoice_id'] = self.invoice_id
        if self.itinerary_id is not None:
            result['itinerary_id'] = self.itinerary_id
        if self.project_code is not None:
            result['project_code'] = self.project_code
        if self.project_title is not None:
            result['project_title'] = self.project_title
        if self.third_part_invoice_id is not None:
            result['third_part_invoice_id'] = self.third_part_invoice_id
        if self.thirdpart_cost_center_id is not None:
            result['thirdpart_cost_center_id'] = self.thirdpart_cost_center_id
        if self.traffic_type is not None:
            result['traffic_type'] = self.traffic_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('arr_date') is not None:
            self.arr_date = m.get('arr_date')
        if m.get('city_code_set') is not None:
            self.city_code_set = m.get('city_code_set')
        if m.get('city_set') is not None:
            self.city_set = m.get('city_set')
        if m.get('cost_center_id') is not None:
            self.cost_center_id = m.get('cost_center_id')
        if m.get('dep_date') is not None:
            self.dep_date = m.get('dep_date')
        if m.get('invoice_id') is not None:
            self.invoice_id = m.get('invoice_id')
        if m.get('itinerary_id') is not None:
            self.itinerary_id = m.get('itinerary_id')
        if m.get('project_code') is not None:
            self.project_code = m.get('project_code')
        if m.get('project_title') is not None:
            self.project_title = m.get('project_title')
        if m.get('third_part_invoice_id') is not None:
            self.third_part_invoice_id = m.get('third_part_invoice_id')
        if m.get('thirdpart_cost_center_id') is not None:
            self.thirdpart_cost_center_id = m.get('thirdpart_cost_center_id')
        if m.get('traffic_type') is not None:
            self.traffic_type = m.get('traffic_type')
        return self


class ApplyModifyRequestTravelerList(TeaModel):
    def __init__(self, user_id=None, user_name=None):
        self.user_id = user_id  # type: str
        self.user_name = user_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ApplyModifyRequestTravelerList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        return self


class ApplyModifyRequestTravelerStandardHotelCitys(TeaModel):
    def __init__(self, city_code=None, city_name=None, fee=None):
        self.city_code = city_code  # type: str
        self.city_name = city_name  # type: str
        self.fee = fee  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ApplyModifyRequestTravelerStandardHotelCitys, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city_code is not None:
            result['city_code'] = self.city_code
        if self.city_name is not None:
            result['city_name'] = self.city_name
        if self.fee is not None:
            result['fee'] = self.fee
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('city_code') is not None:
            self.city_code = m.get('city_code')
        if m.get('city_name') is not None:
            self.city_name = m.get('city_name')
        if m.get('fee') is not None:
            self.fee = m.get('fee')
        return self


class ApplyModifyRequestTravelerStandard(TeaModel):
    def __init__(self, business_discount=None, economy_discount=None, first_discount=None, flight_cabins=None,
                 hotel_citys=None, premium_economy_discount=None, reserve_type=None, train_seats=None, user_id=None):
        self.business_discount = business_discount  # type: int
        self.economy_discount = economy_discount  # type: int
        self.first_discount = first_discount  # type: int
        self.flight_cabins = flight_cabins  # type: str
        self.hotel_citys = hotel_citys  # type: list[ApplyModifyRequestTravelerStandardHotelCitys]
        self.premium_economy_discount = premium_economy_discount  # type: int
        self.reserve_type = reserve_type  # type: int
        self.train_seats = train_seats  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        if self.hotel_citys:
            for k in self.hotel_citys:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ApplyModifyRequestTravelerStandard, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_discount is not None:
            result['business_discount'] = self.business_discount
        if self.economy_discount is not None:
            result['economy_discount'] = self.economy_discount
        if self.first_discount is not None:
            result['first_discount'] = self.first_discount
        if self.flight_cabins is not None:
            result['flight_cabins'] = self.flight_cabins
        result['hotel_citys'] = []
        if self.hotel_citys is not None:
            for k in self.hotel_citys:
                result['hotel_citys'].append(k.to_map() if k else None)
        if self.premium_economy_discount is not None:
            result['premium_economy_discount'] = self.premium_economy_discount
        if self.reserve_type is not None:
            result['reserve_type'] = self.reserve_type
        if self.train_seats is not None:
            result['train_seats'] = self.train_seats
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('business_discount') is not None:
            self.business_discount = m.get('business_discount')
        if m.get('economy_discount') is not None:
            self.economy_discount = m.get('economy_discount')
        if m.get('first_discount') is not None:
            self.first_discount = m.get('first_discount')
        if m.get('flight_cabins') is not None:
            self.flight_cabins = m.get('flight_cabins')
        self.hotel_citys = []
        if m.get('hotel_citys') is not None:
            for k in m.get('hotel_citys'):
                temp_model = ApplyModifyRequestTravelerStandardHotelCitys()
                self.hotel_citys.append(temp_model.from_map(k))
        if m.get('premium_economy_discount') is not None:
            self.premium_economy_discount = m.get('premium_economy_discount')
        if m.get('reserve_type') is not None:
            self.reserve_type = m.get('reserve_type')
        if m.get('train_seats') is not None:
            self.train_seats = m.get('train_seats')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class ApplyModifyRequest(TeaModel):
    def __init__(self, budget=None, budget_merge=None, corp_name=None, depart_id=None, depart_name=None,
                 external_traveler_list=None, external_traveler_standard=None, flight_budget=None, hotel_budget=None, hotel_share=None,
                 itinerary_list=None, itinerary_rule=None, itinerary_set_list=None, limit_traveler=None, status=None,
                 thirdpart_apply_id=None, thirdpart_business_id=None, thirdpart_depart_id=None, together_book_rule=None,
                 train_budget=None, traveler_list=None, traveler_standard=None, trip_cause=None, trip_day=None, trip_title=None,
                 union_no=None, user_id=None, user_name=None, vehicle_budget=None):
        self.budget = budget  # type: long
        self.budget_merge = budget_merge  # type: int
        self.corp_name = corp_name  # type: str
        self.depart_id = depart_id  # type: str
        self.depart_name = depart_name  # type: str
        self.external_traveler_list = external_traveler_list  # type: list[ApplyModifyRequestExternalTravelerList]
        self.external_traveler_standard = external_traveler_standard  # type: ApplyModifyRequestExternalTravelerStandard
        self.flight_budget = flight_budget  # type: long
        self.hotel_budget = hotel_budget  # type: long
        self.hotel_share = hotel_share  # type: ApplyModifyRequestHotelShare
        self.itinerary_list = itinerary_list  # type: list[ApplyModifyRequestItineraryList]
        self.itinerary_rule = itinerary_rule  # type: int
        self.itinerary_set_list = itinerary_set_list  # type: list[ApplyModifyRequestItinerarySetList]
        self.limit_traveler = limit_traveler  # type: int
        self.status = status  # type: int
        self.thirdpart_apply_id = thirdpart_apply_id  # type: str
        self.thirdpart_business_id = thirdpart_business_id  # type: str
        self.thirdpart_depart_id = thirdpart_depart_id  # type: str
        self.together_book_rule = together_book_rule  # type: int
        self.train_budget = train_budget  # type: long
        self.traveler_list = traveler_list  # type: list[ApplyModifyRequestTravelerList]
        self.traveler_standard = traveler_standard  # type: list[ApplyModifyRequestTravelerStandard]
        self.trip_cause = trip_cause  # type: str
        self.trip_day = trip_day  # type: int
        self.trip_title = trip_title  # type: str
        self.union_no = union_no  # type: str
        self.user_id = user_id  # type: str
        self.user_name = user_name  # type: str
        self.vehicle_budget = vehicle_budget  # type: long

    def validate(self):
        if self.external_traveler_list:
            for k in self.external_traveler_list:
                if k:
                    k.validate()
        if self.external_traveler_standard:
            self.external_traveler_standard.validate()
        if self.hotel_share:
            self.hotel_share.validate()
        if self.itinerary_list:
            for k in self.itinerary_list:
                if k:
                    k.validate()
        if self.itinerary_set_list:
            for k in self.itinerary_set_list:
                if k:
                    k.validate()
        if self.traveler_list:
            for k in self.traveler_list:
                if k:
                    k.validate()
        if self.traveler_standard:
            for k in self.traveler_standard:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ApplyModifyRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.budget is not None:
            result['budget'] = self.budget
        if self.budget_merge is not None:
            result['budget_merge'] = self.budget_merge
        if self.corp_name is not None:
            result['corp_name'] = self.corp_name
        if self.depart_id is not None:
            result['depart_id'] = self.depart_id
        if self.depart_name is not None:
            result['depart_name'] = self.depart_name
        result['external_traveler_list'] = []
        if self.external_traveler_list is not None:
            for k in self.external_traveler_list:
                result['external_traveler_list'].append(k.to_map() if k else None)
        if self.external_traveler_standard is not None:
            result['external_traveler_standard'] = self.external_traveler_standard.to_map()
        if self.flight_budget is not None:
            result['flight_budget'] = self.flight_budget
        if self.hotel_budget is not None:
            result['hotel_budget'] = self.hotel_budget
        if self.hotel_share is not None:
            result['hotel_share'] = self.hotel_share.to_map()
        result['itinerary_list'] = []
        if self.itinerary_list is not None:
            for k in self.itinerary_list:
                result['itinerary_list'].append(k.to_map() if k else None)
        if self.itinerary_rule is not None:
            result['itinerary_rule'] = self.itinerary_rule
        result['itinerary_set_list'] = []
        if self.itinerary_set_list is not None:
            for k in self.itinerary_set_list:
                result['itinerary_set_list'].append(k.to_map() if k else None)
        if self.limit_traveler is not None:
            result['limit_traveler'] = self.limit_traveler
        if self.status is not None:
            result['status'] = self.status
        if self.thirdpart_apply_id is not None:
            result['thirdpart_apply_id'] = self.thirdpart_apply_id
        if self.thirdpart_business_id is not None:
            result['thirdpart_business_id'] = self.thirdpart_business_id
        if self.thirdpart_depart_id is not None:
            result['thirdpart_depart_id'] = self.thirdpart_depart_id
        if self.together_book_rule is not None:
            result['together_book_rule'] = self.together_book_rule
        if self.train_budget is not None:
            result['train_budget'] = self.train_budget
        result['traveler_list'] = []
        if self.traveler_list is not None:
            for k in self.traveler_list:
                result['traveler_list'].append(k.to_map() if k else None)
        result['traveler_standard'] = []
        if self.traveler_standard is not None:
            for k in self.traveler_standard:
                result['traveler_standard'].append(k.to_map() if k else None)
        if self.trip_cause is not None:
            result['trip_cause'] = self.trip_cause
        if self.trip_day is not None:
            result['trip_day'] = self.trip_day
        if self.trip_title is not None:
            result['trip_title'] = self.trip_title
        if self.union_no is not None:
            result['union_no'] = self.union_no
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        if self.vehicle_budget is not None:
            result['vehicle_budget'] = self.vehicle_budget
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('budget') is not None:
            self.budget = m.get('budget')
        if m.get('budget_merge') is not None:
            self.budget_merge = m.get('budget_merge')
        if m.get('corp_name') is not None:
            self.corp_name = m.get('corp_name')
        if m.get('depart_id') is not None:
            self.depart_id = m.get('depart_id')
        if m.get('depart_name') is not None:
            self.depart_name = m.get('depart_name')
        self.external_traveler_list = []
        if m.get('external_traveler_list') is not None:
            for k in m.get('external_traveler_list'):
                temp_model = ApplyModifyRequestExternalTravelerList()
                self.external_traveler_list.append(temp_model.from_map(k))
        if m.get('external_traveler_standard') is not None:
            temp_model = ApplyModifyRequestExternalTravelerStandard()
            self.external_traveler_standard = temp_model.from_map(m['external_traveler_standard'])
        if m.get('flight_budget') is not None:
            self.flight_budget = m.get('flight_budget')
        if m.get('hotel_budget') is not None:
            self.hotel_budget = m.get('hotel_budget')
        if m.get('hotel_share') is not None:
            temp_model = ApplyModifyRequestHotelShare()
            self.hotel_share = temp_model.from_map(m['hotel_share'])
        self.itinerary_list = []
        if m.get('itinerary_list') is not None:
            for k in m.get('itinerary_list'):
                temp_model = ApplyModifyRequestItineraryList()
                self.itinerary_list.append(temp_model.from_map(k))
        if m.get('itinerary_rule') is not None:
            self.itinerary_rule = m.get('itinerary_rule')
        self.itinerary_set_list = []
        if m.get('itinerary_set_list') is not None:
            for k in m.get('itinerary_set_list'):
                temp_model = ApplyModifyRequestItinerarySetList()
                self.itinerary_set_list.append(temp_model.from_map(k))
        if m.get('limit_traveler') is not None:
            self.limit_traveler = m.get('limit_traveler')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('thirdpart_apply_id') is not None:
            self.thirdpart_apply_id = m.get('thirdpart_apply_id')
        if m.get('thirdpart_business_id') is not None:
            self.thirdpart_business_id = m.get('thirdpart_business_id')
        if m.get('thirdpart_depart_id') is not None:
            self.thirdpart_depart_id = m.get('thirdpart_depart_id')
        if m.get('together_book_rule') is not None:
            self.together_book_rule = m.get('together_book_rule')
        if m.get('train_budget') is not None:
            self.train_budget = m.get('train_budget')
        self.traveler_list = []
        if m.get('traveler_list') is not None:
            for k in m.get('traveler_list'):
                temp_model = ApplyModifyRequestTravelerList()
                self.traveler_list.append(temp_model.from_map(k))
        self.traveler_standard = []
        if m.get('traveler_standard') is not None:
            for k in m.get('traveler_standard'):
                temp_model = ApplyModifyRequestTravelerStandard()
                self.traveler_standard.append(temp_model.from_map(k))
        if m.get('trip_cause') is not None:
            self.trip_cause = m.get('trip_cause')
        if m.get('trip_day') is not None:
            self.trip_day = m.get('trip_day')
        if m.get('trip_title') is not None:
            self.trip_title = m.get('trip_title')
        if m.get('union_no') is not None:
            self.union_no = m.get('union_no')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        if m.get('vehicle_budget') is not None:
            self.vehicle_budget = m.get('vehicle_budget')
        return self


class ApplyModifyShrinkRequest(TeaModel):
    def __init__(self, budget=None, budget_merge=None, corp_name=None, depart_id=None, depart_name=None,
                 external_traveler_list_shrink=None, external_traveler_standard_shrink=None, flight_budget=None, hotel_budget=None,
                 hotel_share_shrink=None, itinerary_list_shrink=None, itinerary_rule=None, itinerary_set_list_shrink=None,
                 limit_traveler=None, status=None, thirdpart_apply_id=None, thirdpart_business_id=None, thirdpart_depart_id=None,
                 together_book_rule=None, train_budget=None, traveler_list_shrink=None, traveler_standard_shrink=None,
                 trip_cause=None, trip_day=None, trip_title=None, union_no=None, user_id=None, user_name=None,
                 vehicle_budget=None):
        self.budget = budget  # type: long
        self.budget_merge = budget_merge  # type: int
        self.corp_name = corp_name  # type: str
        self.depart_id = depart_id  # type: str
        self.depart_name = depart_name  # type: str
        self.external_traveler_list_shrink = external_traveler_list_shrink  # type: str
        self.external_traveler_standard_shrink = external_traveler_standard_shrink  # type: str
        self.flight_budget = flight_budget  # type: long
        self.hotel_budget = hotel_budget  # type: long
        self.hotel_share_shrink = hotel_share_shrink  # type: str
        self.itinerary_list_shrink = itinerary_list_shrink  # type: str
        self.itinerary_rule = itinerary_rule  # type: int
        self.itinerary_set_list_shrink = itinerary_set_list_shrink  # type: str
        self.limit_traveler = limit_traveler  # type: int
        self.status = status  # type: int
        self.thirdpart_apply_id = thirdpart_apply_id  # type: str
        self.thirdpart_business_id = thirdpart_business_id  # type: str
        self.thirdpart_depart_id = thirdpart_depart_id  # type: str
        self.together_book_rule = together_book_rule  # type: int
        self.train_budget = train_budget  # type: long
        self.traveler_list_shrink = traveler_list_shrink  # type: str
        self.traveler_standard_shrink = traveler_standard_shrink  # type: str
        self.trip_cause = trip_cause  # type: str
        self.trip_day = trip_day  # type: int
        self.trip_title = trip_title  # type: str
        self.union_no = union_no  # type: str
        self.user_id = user_id  # type: str
        self.user_name = user_name  # type: str
        self.vehicle_budget = vehicle_budget  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ApplyModifyShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.budget is not None:
            result['budget'] = self.budget
        if self.budget_merge is not None:
            result['budget_merge'] = self.budget_merge
        if self.corp_name is not None:
            result['corp_name'] = self.corp_name
        if self.depart_id is not None:
            result['depart_id'] = self.depart_id
        if self.depart_name is not None:
            result['depart_name'] = self.depart_name
        if self.external_traveler_list_shrink is not None:
            result['external_traveler_list'] = self.external_traveler_list_shrink
        if self.external_traveler_standard_shrink is not None:
            result['external_traveler_standard'] = self.external_traveler_standard_shrink
        if self.flight_budget is not None:
            result['flight_budget'] = self.flight_budget
        if self.hotel_budget is not None:
            result['hotel_budget'] = self.hotel_budget
        if self.hotel_share_shrink is not None:
            result['hotel_share'] = self.hotel_share_shrink
        if self.itinerary_list_shrink is not None:
            result['itinerary_list'] = self.itinerary_list_shrink
        if self.itinerary_rule is not None:
            result['itinerary_rule'] = self.itinerary_rule
        if self.itinerary_set_list_shrink is not None:
            result['itinerary_set_list'] = self.itinerary_set_list_shrink
        if self.limit_traveler is not None:
            result['limit_traveler'] = self.limit_traveler
        if self.status is not None:
            result['status'] = self.status
        if self.thirdpart_apply_id is not None:
            result['thirdpart_apply_id'] = self.thirdpart_apply_id
        if self.thirdpart_business_id is not None:
            result['thirdpart_business_id'] = self.thirdpart_business_id
        if self.thirdpart_depart_id is not None:
            result['thirdpart_depart_id'] = self.thirdpart_depart_id
        if self.together_book_rule is not None:
            result['together_book_rule'] = self.together_book_rule
        if self.train_budget is not None:
            result['train_budget'] = self.train_budget
        if self.traveler_list_shrink is not None:
            result['traveler_list'] = self.traveler_list_shrink
        if self.traveler_standard_shrink is not None:
            result['traveler_standard'] = self.traveler_standard_shrink
        if self.trip_cause is not None:
            result['trip_cause'] = self.trip_cause
        if self.trip_day is not None:
            result['trip_day'] = self.trip_day
        if self.trip_title is not None:
            result['trip_title'] = self.trip_title
        if self.union_no is not None:
            result['union_no'] = self.union_no
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        if self.vehicle_budget is not None:
            result['vehicle_budget'] = self.vehicle_budget
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('budget') is not None:
            self.budget = m.get('budget')
        if m.get('budget_merge') is not None:
            self.budget_merge = m.get('budget_merge')
        if m.get('corp_name') is not None:
            self.corp_name = m.get('corp_name')
        if m.get('depart_id') is not None:
            self.depart_id = m.get('depart_id')
        if m.get('depart_name') is not None:
            self.depart_name = m.get('depart_name')
        if m.get('external_traveler_list') is not None:
            self.external_traveler_list_shrink = m.get('external_traveler_list')
        if m.get('external_traveler_standard') is not None:
            self.external_traveler_standard_shrink = m.get('external_traveler_standard')
        if m.get('flight_budget') is not None:
            self.flight_budget = m.get('flight_budget')
        if m.get('hotel_budget') is not None:
            self.hotel_budget = m.get('hotel_budget')
        if m.get('hotel_share') is not None:
            self.hotel_share_shrink = m.get('hotel_share')
        if m.get('itinerary_list') is not None:
            self.itinerary_list_shrink = m.get('itinerary_list')
        if m.get('itinerary_rule') is not None:
            self.itinerary_rule = m.get('itinerary_rule')
        if m.get('itinerary_set_list') is not None:
            self.itinerary_set_list_shrink = m.get('itinerary_set_list')
        if m.get('limit_traveler') is not None:
            self.limit_traveler = m.get('limit_traveler')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('thirdpart_apply_id') is not None:
            self.thirdpart_apply_id = m.get('thirdpart_apply_id')
        if m.get('thirdpart_business_id') is not None:
            self.thirdpart_business_id = m.get('thirdpart_business_id')
        if m.get('thirdpart_depart_id') is not None:
            self.thirdpart_depart_id = m.get('thirdpart_depart_id')
        if m.get('together_book_rule') is not None:
            self.together_book_rule = m.get('together_book_rule')
        if m.get('train_budget') is not None:
            self.train_budget = m.get('train_budget')
        if m.get('traveler_list') is not None:
            self.traveler_list_shrink = m.get('traveler_list')
        if m.get('traveler_standard') is not None:
            self.traveler_standard_shrink = m.get('traveler_standard')
        if m.get('trip_cause') is not None:
            self.trip_cause = m.get('trip_cause')
        if m.get('trip_day') is not None:
            self.trip_day = m.get('trip_day')
        if m.get('trip_title') is not None:
            self.trip_title = m.get('trip_title')
        if m.get('union_no') is not None:
            self.union_no = m.get('union_no')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        if m.get('vehicle_budget') is not None:
            self.vehicle_budget = m.get('vehicle_budget')
        return self


class ApplyModifyResponseBodyModule(TeaModel):
    def __init__(self, apply_id=None, thirdpart_apply_id=None, thirdpart_business_id=None):
        self.apply_id = apply_id  # type: long
        self.thirdpart_apply_id = thirdpart_apply_id  # type: str
        self.thirdpart_business_id = thirdpart_business_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ApplyModifyResponseBodyModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.thirdpart_apply_id is not None:
            result['thirdpart_apply_id'] = self.thirdpart_apply_id
        if self.thirdpart_business_id is not None:
            result['thirdpart_business_id'] = self.thirdpart_business_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('thirdpart_apply_id') is not None:
            self.thirdpart_apply_id = m.get('thirdpart_apply_id')
        if m.get('thirdpart_business_id') is not None:
            self.thirdpart_business_id = m.get('thirdpart_business_id')
        return self


class ApplyModifyResponseBody(TeaModel):
    def __init__(self, code=None, message=None, module=None, request_id=None, success=None, trace_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        # module。
        self.module = module  # type: ApplyModifyResponseBodyModule
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.trace_id = trace_id  # type: str

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super(ApplyModifyResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = ApplyModifyResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class ApplyModifyResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ApplyModifyResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ApplyModifyResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ApplyModifyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ApplyQueryHeaders(TeaModel):
    def __init__(self, common_headers=None, x_acs_btrip_so_corp_token=None):
        self.common_headers = common_headers  # type: dict[str, str]
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ApplyQueryHeaders, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class ApplyQueryRequest(TeaModel):
    def __init__(self, apply_id=None, apply_show_id=None, thirdpart_apply_id=None, type=None):
        self.apply_id = apply_id  # type: int
        self.apply_show_id = apply_show_id  # type: str
        self.thirdpart_apply_id = thirdpart_apply_id  # type: str
        self.type = type  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ApplyQueryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.apply_show_id is not None:
            result['apply_show_id'] = self.apply_show_id
        if self.thirdpart_apply_id is not None:
            result['thirdpart_apply_id'] = self.thirdpart_apply_id
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('apply_show_id') is not None:
            self.apply_show_id = m.get('apply_show_id')
        if m.get('thirdpart_apply_id') is not None:
            self.thirdpart_apply_id = m.get('thirdpart_apply_id')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class ApplyQueryResponseBodyModuleApproverList(TeaModel):
    def __init__(self, note=None, operate_time=None, order=None, status=None, status_desc=None, user_id=None,
                 user_name=None):
        self.note = note  # type: str
        self.operate_time = operate_time  # type: str
        self.order = order  # type: int
        self.status = status  # type: int
        self.status_desc = status_desc  # type: str
        self.user_id = user_id  # type: str
        self.user_name = user_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ApplyQueryResponseBodyModuleApproverList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.note is not None:
            result['note'] = self.note
        if self.operate_time is not None:
            result['operate_time'] = self.operate_time
        if self.order is not None:
            result['order'] = self.order
        if self.status is not None:
            result['status'] = self.status
        if self.status_desc is not None:
            result['status_desc'] = self.status_desc
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('note') is not None:
            self.note = m.get('note')
        if m.get('operate_time') is not None:
            self.operate_time = m.get('operate_time')
        if m.get('order') is not None:
            self.order = m.get('order')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('status_desc') is not None:
            self.status_desc = m.get('status_desc')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        return self


class ApplyQueryResponseBodyModuleExternalTravelerListHotelCitys(TeaModel):
    def __init__(self, city_code=None, city_name=None, fee=None):
        self.city_code = city_code  # type: str
        self.city_name = city_name  # type: str
        self.fee = fee  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ApplyQueryResponseBodyModuleExternalTravelerListHotelCitys, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city_code is not None:
            result['city_code'] = self.city_code
        if self.city_name is not None:
            result['city_name'] = self.city_name
        if self.fee is not None:
            result['fee'] = self.fee
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('city_code') is not None:
            self.city_code = m.get('city_code')
        if m.get('city_name') is not None:
            self.city_name = m.get('city_name')
        if m.get('fee') is not None:
            self.fee = m.get('fee')
        return self


class ApplyQueryResponseBodyModuleExternalTravelerList(TeaModel):
    def __init__(self, business_discount=None, economy_discount=None, first_discount=None, flight_cabins=None,
                 hotel_citys=None, premium_economy_discount=None, reserve_type=None, train_seats=None, user_name=None):
        self.business_discount = business_discount  # type: int
        self.economy_discount = economy_discount  # type: int
        self.first_discount = first_discount  # type: int
        self.flight_cabins = flight_cabins  # type: str
        self.hotel_citys = hotel_citys  # type: list[ApplyQueryResponseBodyModuleExternalTravelerListHotelCitys]
        self.premium_economy_discount = premium_economy_discount  # type: int
        self.reserve_type = reserve_type  # type: int
        self.train_seats = train_seats  # type: str
        self.user_name = user_name  # type: str

    def validate(self):
        if self.hotel_citys:
            for k in self.hotel_citys:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ApplyQueryResponseBodyModuleExternalTravelerList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_discount is not None:
            result['business_discount'] = self.business_discount
        if self.economy_discount is not None:
            result['economy_discount'] = self.economy_discount
        if self.first_discount is not None:
            result['first_discount'] = self.first_discount
        if self.flight_cabins is not None:
            result['flight_cabins'] = self.flight_cabins
        result['hotel_citys'] = []
        if self.hotel_citys is not None:
            for k in self.hotel_citys:
                result['hotel_citys'].append(k.to_map() if k else None)
        if self.premium_economy_discount is not None:
            result['premium_economy_discount'] = self.premium_economy_discount
        if self.reserve_type is not None:
            result['reserve_type'] = self.reserve_type
        if self.train_seats is not None:
            result['train_seats'] = self.train_seats
        if self.user_name is not None:
            result['user_name'] = self.user_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('business_discount') is not None:
            self.business_discount = m.get('business_discount')
        if m.get('economy_discount') is not None:
            self.economy_discount = m.get('economy_discount')
        if m.get('first_discount') is not None:
            self.first_discount = m.get('first_discount')
        if m.get('flight_cabins') is not None:
            self.flight_cabins = m.get('flight_cabins')
        self.hotel_citys = []
        if m.get('hotel_citys') is not None:
            for k in m.get('hotel_citys'):
                temp_model = ApplyQueryResponseBodyModuleExternalTravelerListHotelCitys()
                self.hotel_citys.append(temp_model.from_map(k))
        if m.get('premium_economy_discount') is not None:
            self.premium_economy_discount = m.get('premium_economy_discount')
        if m.get('reserve_type') is not None:
            self.reserve_type = m.get('reserve_type')
        if m.get('train_seats') is not None:
            self.train_seats = m.get('train_seats')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        return self


class ApplyQueryResponseBodyModuleHotelShare(TeaModel):
    def __init__(self, param=None, type=None):
        self.param = param  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ApplyQueryResponseBodyModuleHotelShare, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.param is not None:
            result['param'] = self.param
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('param') is not None:
            self.param = m.get('param')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class ApplyQueryResponseBodyModuleItineraryList(TeaModel):
    def __init__(self, arr_city=None, arr_city_code=None, arr_date=None, cost_center_name=None, dep_city=None,
                 dep_city_code=None, dep_date=None, invoice_name=None, itinerary_id=None, project_code=None, project_title=None,
                 traffic_type=None, trip_way=None):
        self.arr_city = arr_city  # type: str
        self.arr_city_code = arr_city_code  # type: str
        self.arr_date = arr_date  # type: str
        self.cost_center_name = cost_center_name  # type: str
        self.dep_city = dep_city  # type: str
        self.dep_city_code = dep_city_code  # type: str
        self.dep_date = dep_date  # type: str
        self.invoice_name = invoice_name  # type: str
        self.itinerary_id = itinerary_id  # type: str
        self.project_code = project_code  # type: str
        self.project_title = project_title  # type: str
        self.traffic_type = traffic_type  # type: int
        self.trip_way = trip_way  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ApplyQueryResponseBodyModuleItineraryList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arr_city is not None:
            result['arr_city'] = self.arr_city
        if self.arr_city_code is not None:
            result['arr_city_code'] = self.arr_city_code
        if self.arr_date is not None:
            result['arr_date'] = self.arr_date
        if self.cost_center_name is not None:
            result['cost_center_name'] = self.cost_center_name
        if self.dep_city is not None:
            result['dep_city'] = self.dep_city
        if self.dep_city_code is not None:
            result['dep_city_code'] = self.dep_city_code
        if self.dep_date is not None:
            result['dep_date'] = self.dep_date
        if self.invoice_name is not None:
            result['invoice_name'] = self.invoice_name
        if self.itinerary_id is not None:
            result['itinerary_id'] = self.itinerary_id
        if self.project_code is not None:
            result['project_code'] = self.project_code
        if self.project_title is not None:
            result['project_title'] = self.project_title
        if self.traffic_type is not None:
            result['traffic_type'] = self.traffic_type
        if self.trip_way is not None:
            result['trip_way'] = self.trip_way
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('arr_city') is not None:
            self.arr_city = m.get('arr_city')
        if m.get('arr_city_code') is not None:
            self.arr_city_code = m.get('arr_city_code')
        if m.get('arr_date') is not None:
            self.arr_date = m.get('arr_date')
        if m.get('cost_center_name') is not None:
            self.cost_center_name = m.get('cost_center_name')
        if m.get('dep_city') is not None:
            self.dep_city = m.get('dep_city')
        if m.get('dep_city_code') is not None:
            self.dep_city_code = m.get('dep_city_code')
        if m.get('dep_date') is not None:
            self.dep_date = m.get('dep_date')
        if m.get('invoice_name') is not None:
            self.invoice_name = m.get('invoice_name')
        if m.get('itinerary_id') is not None:
            self.itinerary_id = m.get('itinerary_id')
        if m.get('project_code') is not None:
            self.project_code = m.get('project_code')
        if m.get('project_title') is not None:
            self.project_title = m.get('project_title')
        if m.get('traffic_type') is not None:
            self.traffic_type = m.get('traffic_type')
        if m.get('trip_way') is not None:
            self.trip_way = m.get('trip_way')
        return self


class ApplyQueryResponseBodyModuleItinerarySetList(TeaModel):
    def __init__(self, arr_date=None, city_code_set=None, city_set=None, cost_center_name=None, dep_date=None,
                 invoice_name=None, itinerary_id=None, project_code=None, project_title=None, traffic_type=None):
        self.arr_date = arr_date  # type: str
        self.city_code_set = city_code_set  # type: str
        self.city_set = city_set  # type: str
        self.cost_center_name = cost_center_name  # type: str
        self.dep_date = dep_date  # type: str
        self.invoice_name = invoice_name  # type: str
        self.itinerary_id = itinerary_id  # type: str
        self.project_code = project_code  # type: str
        self.project_title = project_title  # type: str
        self.traffic_type = traffic_type  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ApplyQueryResponseBodyModuleItinerarySetList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arr_date is not None:
            result['arr_date'] = self.arr_date
        if self.city_code_set is not None:
            result['city_code_set'] = self.city_code_set
        if self.city_set is not None:
            result['city_set'] = self.city_set
        if self.cost_center_name is not None:
            result['cost_center_name'] = self.cost_center_name
        if self.dep_date is not None:
            result['dep_date'] = self.dep_date
        if self.invoice_name is not None:
            result['invoice_name'] = self.invoice_name
        if self.itinerary_id is not None:
            result['itinerary_id'] = self.itinerary_id
        if self.project_code is not None:
            result['project_code'] = self.project_code
        if self.project_title is not None:
            result['project_title'] = self.project_title
        if self.traffic_type is not None:
            result['traffic_type'] = self.traffic_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('arr_date') is not None:
            self.arr_date = m.get('arr_date')
        if m.get('city_code_set') is not None:
            self.city_code_set = m.get('city_code_set')
        if m.get('city_set') is not None:
            self.city_set = m.get('city_set')
        if m.get('cost_center_name') is not None:
            self.cost_center_name = m.get('cost_center_name')
        if m.get('dep_date') is not None:
            self.dep_date = m.get('dep_date')
        if m.get('invoice_name') is not None:
            self.invoice_name = m.get('invoice_name')
        if m.get('itinerary_id') is not None:
            self.itinerary_id = m.get('itinerary_id')
        if m.get('project_code') is not None:
            self.project_code = m.get('project_code')
        if m.get('project_title') is not None:
            self.project_title = m.get('project_title')
        if m.get('traffic_type') is not None:
            self.traffic_type = m.get('traffic_type')
        return self


class ApplyQueryResponseBodyModuleTravelerListHotelCitys(TeaModel):
    def __init__(self, city_code=None, city_name=None, fee=None):
        self.city_code = city_code  # type: str
        self.city_name = city_name  # type: str
        self.fee = fee  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ApplyQueryResponseBodyModuleTravelerListHotelCitys, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city_code is not None:
            result['city_code'] = self.city_code
        if self.city_name is not None:
            result['city_name'] = self.city_name
        if self.fee is not None:
            result['fee'] = self.fee
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('city_code') is not None:
            self.city_code = m.get('city_code')
        if m.get('city_name') is not None:
            self.city_name = m.get('city_name')
        if m.get('fee') is not None:
            self.fee = m.get('fee')
        return self


class ApplyQueryResponseBodyModuleTravelerList(TeaModel):
    def __init__(self, business_discount=None, economy_discount=None, first_discount=None, flight_cabins=None,
                 hotel_citys=None, premium_economy_discount=None, reserve_type=None, train_seats=None, user_id=None,
                 user_name=None):
        self.business_discount = business_discount  # type: int
        self.economy_discount = economy_discount  # type: int
        self.first_discount = first_discount  # type: int
        self.flight_cabins = flight_cabins  # type: str
        self.hotel_citys = hotel_citys  # type: list[ApplyQueryResponseBodyModuleTravelerListHotelCitys]
        self.premium_economy_discount = premium_economy_discount  # type: int
        self.reserve_type = reserve_type  # type: int
        self.train_seats = train_seats  # type: str
        self.user_id = user_id  # type: str
        self.user_name = user_name  # type: str

    def validate(self):
        if self.hotel_citys:
            for k in self.hotel_citys:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ApplyQueryResponseBodyModuleTravelerList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_discount is not None:
            result['business_discount'] = self.business_discount
        if self.economy_discount is not None:
            result['economy_discount'] = self.economy_discount
        if self.first_discount is not None:
            result['first_discount'] = self.first_discount
        if self.flight_cabins is not None:
            result['flight_cabins'] = self.flight_cabins
        result['hotel_citys'] = []
        if self.hotel_citys is not None:
            for k in self.hotel_citys:
                result['hotel_citys'].append(k.to_map() if k else None)
        if self.premium_economy_discount is not None:
            result['premium_economy_discount'] = self.premium_economy_discount
        if self.reserve_type is not None:
            result['reserve_type'] = self.reserve_type
        if self.train_seats is not None:
            result['train_seats'] = self.train_seats
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('business_discount') is not None:
            self.business_discount = m.get('business_discount')
        if m.get('economy_discount') is not None:
            self.economy_discount = m.get('economy_discount')
        if m.get('first_discount') is not None:
            self.first_discount = m.get('first_discount')
        if m.get('flight_cabins') is not None:
            self.flight_cabins = m.get('flight_cabins')
        self.hotel_citys = []
        if m.get('hotel_citys') is not None:
            for k in m.get('hotel_citys'):
                temp_model = ApplyQueryResponseBodyModuleTravelerListHotelCitys()
                self.hotel_citys.append(temp_model.from_map(k))
        if m.get('premium_economy_discount') is not None:
            self.premium_economy_discount = m.get('premium_economy_discount')
        if m.get('reserve_type') is not None:
            self.reserve_type = m.get('reserve_type')
        if m.get('train_seats') is not None:
            self.train_seats = m.get('train_seats')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        return self


class ApplyQueryResponseBodyModule(TeaModel):
    def __init__(self, apply_show_id=None, approver_list=None, budget=None, budget_merge=None, corp_id=None,
                 corp_name=None, depart_id=None, depart_name=None, external_traveler_list=None, flight_budget=None,
                 gmt_create=None, gmt_modified=None, hotel_budget=None, hotel_share=None, id=None, itinerary_list=None,
                 itinerary_rule=None, itinerary_set_list=None, limit_traveler=None, status=None, status_desc=None,
                 thirdpart_business_id=None, thirdpart_id=None, together_book_rule=None, train_budget=None, traveler_list=None,
                 trip_cause=None, trip_day=None, trip_title=None, type=None, union_no=None, user_id=None, user_name=None,
                 vehicle_budget=None):
        self.apply_show_id = apply_show_id  # type: str
        self.approver_list = approver_list  # type: list[ApplyQueryResponseBodyModuleApproverList]
        self.budget = budget  # type: long
        self.budget_merge = budget_merge  # type: int
        self.corp_id = corp_id  # type: str
        self.corp_name = corp_name  # type: str
        self.depart_id = depart_id  # type: str
        self.depart_name = depart_name  # type: str
        self.external_traveler_list = external_traveler_list  # type: list[ApplyQueryResponseBodyModuleExternalTravelerList]
        self.flight_budget = flight_budget  # type: long
        self.gmt_create = gmt_create  # type: str
        self.gmt_modified = gmt_modified  # type: str
        self.hotel_budget = hotel_budget  # type: long
        self.hotel_share = hotel_share  # type: ApplyQueryResponseBodyModuleHotelShare
        self.id = id  # type: long
        self.itinerary_list = itinerary_list  # type: list[ApplyQueryResponseBodyModuleItineraryList]
        self.itinerary_rule = itinerary_rule  # type: int
        self.itinerary_set_list = itinerary_set_list  # type: list[ApplyQueryResponseBodyModuleItinerarySetList]
        self.limit_traveler = limit_traveler  # type: int
        self.status = status  # type: int
        self.status_desc = status_desc  # type: str
        self.thirdpart_business_id = thirdpart_business_id  # type: str
        self.thirdpart_id = thirdpart_id  # type: str
        self.together_book_rule = together_book_rule  # type: int
        self.train_budget = train_budget  # type: long
        self.traveler_list = traveler_list  # type: list[ApplyQueryResponseBodyModuleTravelerList]
        self.trip_cause = trip_cause  # type: str
        self.trip_day = trip_day  # type: int
        self.trip_title = trip_title  # type: str
        self.type = type  # type: int
        self.union_no = union_no  # type: str
        self.user_id = user_id  # type: str
        self.user_name = user_name  # type: str
        self.vehicle_budget = vehicle_budget  # type: long

    def validate(self):
        if self.approver_list:
            for k in self.approver_list:
                if k:
                    k.validate()
        if self.external_traveler_list:
            for k in self.external_traveler_list:
                if k:
                    k.validate()
        if self.hotel_share:
            self.hotel_share.validate()
        if self.itinerary_list:
            for k in self.itinerary_list:
                if k:
                    k.validate()
        if self.itinerary_set_list:
            for k in self.itinerary_set_list:
                if k:
                    k.validate()
        if self.traveler_list:
            for k in self.traveler_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ApplyQueryResponseBodyModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_show_id is not None:
            result['apply_show_id'] = self.apply_show_id
        result['approver_list'] = []
        if self.approver_list is not None:
            for k in self.approver_list:
                result['approver_list'].append(k.to_map() if k else None)
        if self.budget is not None:
            result['budget'] = self.budget
        if self.budget_merge is not None:
            result['budget_merge'] = self.budget_merge
        if self.corp_id is not None:
            result['corp_id'] = self.corp_id
        if self.corp_name is not None:
            result['corp_name'] = self.corp_name
        if self.depart_id is not None:
            result['depart_id'] = self.depart_id
        if self.depart_name is not None:
            result['depart_name'] = self.depart_name
        result['external_traveler_list'] = []
        if self.external_traveler_list is not None:
            for k in self.external_traveler_list:
                result['external_traveler_list'].append(k.to_map() if k else None)
        if self.flight_budget is not None:
            result['flight_budget'] = self.flight_budget
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        if self.hotel_budget is not None:
            result['hotel_budget'] = self.hotel_budget
        if self.hotel_share is not None:
            result['hotel_share'] = self.hotel_share.to_map()
        if self.id is not None:
            result['id'] = self.id
        result['itinerary_list'] = []
        if self.itinerary_list is not None:
            for k in self.itinerary_list:
                result['itinerary_list'].append(k.to_map() if k else None)
        if self.itinerary_rule is not None:
            result['itinerary_rule'] = self.itinerary_rule
        result['itinerary_set_list'] = []
        if self.itinerary_set_list is not None:
            for k in self.itinerary_set_list:
                result['itinerary_set_list'].append(k.to_map() if k else None)
        if self.limit_traveler is not None:
            result['limit_traveler'] = self.limit_traveler
        if self.status is not None:
            result['status'] = self.status
        if self.status_desc is not None:
            result['status_desc'] = self.status_desc
        if self.thirdpart_business_id is not None:
            result['thirdpart_business_id'] = self.thirdpart_business_id
        if self.thirdpart_id is not None:
            result['thirdpart_id'] = self.thirdpart_id
        if self.together_book_rule is not None:
            result['together_book_rule'] = self.together_book_rule
        if self.train_budget is not None:
            result['train_budget'] = self.train_budget
        result['traveler_list'] = []
        if self.traveler_list is not None:
            for k in self.traveler_list:
                result['traveler_list'].append(k.to_map() if k else None)
        if self.trip_cause is not None:
            result['trip_cause'] = self.trip_cause
        if self.trip_day is not None:
            result['trip_day'] = self.trip_day
        if self.trip_title is not None:
            result['trip_title'] = self.trip_title
        if self.type is not None:
            result['type'] = self.type
        if self.union_no is not None:
            result['union_no'] = self.union_no
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        if self.vehicle_budget is not None:
            result['vehicle_budget'] = self.vehicle_budget
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('apply_show_id') is not None:
            self.apply_show_id = m.get('apply_show_id')
        self.approver_list = []
        if m.get('approver_list') is not None:
            for k in m.get('approver_list'):
                temp_model = ApplyQueryResponseBodyModuleApproverList()
                self.approver_list.append(temp_model.from_map(k))
        if m.get('budget') is not None:
            self.budget = m.get('budget')
        if m.get('budget_merge') is not None:
            self.budget_merge = m.get('budget_merge')
        if m.get('corp_id') is not None:
            self.corp_id = m.get('corp_id')
        if m.get('corp_name') is not None:
            self.corp_name = m.get('corp_name')
        if m.get('depart_id') is not None:
            self.depart_id = m.get('depart_id')
        if m.get('depart_name') is not None:
            self.depart_name = m.get('depart_name')
        self.external_traveler_list = []
        if m.get('external_traveler_list') is not None:
            for k in m.get('external_traveler_list'):
                temp_model = ApplyQueryResponseBodyModuleExternalTravelerList()
                self.external_traveler_list.append(temp_model.from_map(k))
        if m.get('flight_budget') is not None:
            self.flight_budget = m.get('flight_budget')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        if m.get('hotel_budget') is not None:
            self.hotel_budget = m.get('hotel_budget')
        if m.get('hotel_share') is not None:
            temp_model = ApplyQueryResponseBodyModuleHotelShare()
            self.hotel_share = temp_model.from_map(m['hotel_share'])
        if m.get('id') is not None:
            self.id = m.get('id')
        self.itinerary_list = []
        if m.get('itinerary_list') is not None:
            for k in m.get('itinerary_list'):
                temp_model = ApplyQueryResponseBodyModuleItineraryList()
                self.itinerary_list.append(temp_model.from_map(k))
        if m.get('itinerary_rule') is not None:
            self.itinerary_rule = m.get('itinerary_rule')
        self.itinerary_set_list = []
        if m.get('itinerary_set_list') is not None:
            for k in m.get('itinerary_set_list'):
                temp_model = ApplyQueryResponseBodyModuleItinerarySetList()
                self.itinerary_set_list.append(temp_model.from_map(k))
        if m.get('limit_traveler') is not None:
            self.limit_traveler = m.get('limit_traveler')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('status_desc') is not None:
            self.status_desc = m.get('status_desc')
        if m.get('thirdpart_business_id') is not None:
            self.thirdpart_business_id = m.get('thirdpart_business_id')
        if m.get('thirdpart_id') is not None:
            self.thirdpart_id = m.get('thirdpart_id')
        if m.get('together_book_rule') is not None:
            self.together_book_rule = m.get('together_book_rule')
        if m.get('train_budget') is not None:
            self.train_budget = m.get('train_budget')
        self.traveler_list = []
        if m.get('traveler_list') is not None:
            for k in m.get('traveler_list'):
                temp_model = ApplyQueryResponseBodyModuleTravelerList()
                self.traveler_list.append(temp_model.from_map(k))
        if m.get('trip_cause') is not None:
            self.trip_cause = m.get('trip_cause')
        if m.get('trip_day') is not None:
            self.trip_day = m.get('trip_day')
        if m.get('trip_title') is not None:
            self.trip_title = m.get('trip_title')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('union_no') is not None:
            self.union_no = m.get('union_no')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        if m.get('vehicle_budget') is not None:
            self.vehicle_budget = m.get('vehicle_budget')
        return self


class ApplyQueryResponseBody(TeaModel):
    def __init__(self, code=None, message=None, module=None, request_id=None, success=None, trace_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.module = module  # type: ApplyQueryResponseBodyModule
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.trace_id = trace_id  # type: str

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super(ApplyQueryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = ApplyQueryResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class ApplyQueryResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ApplyQueryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ApplyQueryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ApplyQueryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BtripBillInfoAdjustHeaders(TeaModel):
    def __init__(self, common_headers=None, x_acs_btrip_corp_token=None):
        self.common_headers = common_headers  # type: dict[str, str]
        self.x_acs_btrip_corp_token = x_acs_btrip_corp_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BtripBillInfoAdjustHeaders, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_corp_token is not None:
            result['x-acs-btrip-corp-token'] = self.x_acs_btrip_corp_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-corp-token') is not None:
            self.x_acs_btrip_corp_token = m.get('x-acs-btrip-corp-token')
        return self


class BtripBillInfoAdjustRequest(TeaModel):
    def __init__(self, primary_id=None, third_part_cost_center_id=None, third_part_department_id=None,
                 third_part_invoice_id=None, third_part_project_id=None, user_id=None):
        self.primary_id = primary_id  # type: long
        self.third_part_cost_center_id = third_part_cost_center_id  # type: str
        self.third_part_department_id = third_part_department_id  # type: str
        self.third_part_invoice_id = third_part_invoice_id  # type: str
        self.third_part_project_id = third_part_project_id  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BtripBillInfoAdjustRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.primary_id is not None:
            result['primary_id'] = self.primary_id
        if self.third_part_cost_center_id is not None:
            result['third_part_cost_center_id'] = self.third_part_cost_center_id
        if self.third_part_department_id is not None:
            result['third_part_department_id'] = self.third_part_department_id
        if self.third_part_invoice_id is not None:
            result['third_part_invoice_id'] = self.third_part_invoice_id
        if self.third_part_project_id is not None:
            result['third_part_project_id'] = self.third_part_project_id
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('primary_id') is not None:
            self.primary_id = m.get('primary_id')
        if m.get('third_part_cost_center_id') is not None:
            self.third_part_cost_center_id = m.get('third_part_cost_center_id')
        if m.get('third_part_department_id') is not None:
            self.third_part_department_id = m.get('third_part_department_id')
        if m.get('third_part_invoice_id') is not None:
            self.third_part_invoice_id = m.get('third_part_invoice_id')
        if m.get('third_part_project_id') is not None:
            self.third_part_project_id = m.get('third_part_project_id')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class BtripBillInfoAdjustResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None, trace_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.trace_id = trace_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BtripBillInfoAdjustResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class BtripBillInfoAdjustResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BtripBillInfoAdjustResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BtripBillInfoAdjustResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BtripBillInfoAdjustResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CarApplyAddHeaders(TeaModel):
    def __init__(self, common_headers=None, x_acs_btrip_so_corp_token=None):
        self.common_headers = common_headers  # type: dict[str, str]
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CarApplyAddHeaders, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class CarApplyAddRequest(TeaModel):
    def __init__(self, cause=None, city=None, date=None, finished_date=None, project_code=None, project_name=None,
                 status=None, third_part_apply_id=None, third_part_cost_center_id=None, third_part_invoice_id=None,
                 times_total=None, times_type=None, times_used=None, title=None, user_id=None):
        self.cause = cause  # type: str
        self.city = city  # type: str
        self.date = date  # type: str
        self.finished_date = finished_date  # type: str
        self.project_code = project_code  # type: str
        self.project_name = project_name  # type: str
        self.status = status  # type: int
        self.third_part_apply_id = third_part_apply_id  # type: str
        self.third_part_cost_center_id = third_part_cost_center_id  # type: str
        self.third_part_invoice_id = third_part_invoice_id  # type: str
        self.times_total = times_total  # type: int
        self.times_type = times_type  # type: int
        self.times_used = times_used  # type: int
        self.title = title  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CarApplyAddRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cause is not None:
            result['cause'] = self.cause
        if self.city is not None:
            result['city'] = self.city
        if self.date is not None:
            result['date'] = self.date
        if self.finished_date is not None:
            result['finished_date'] = self.finished_date
        if self.project_code is not None:
            result['project_code'] = self.project_code
        if self.project_name is not None:
            result['project_name'] = self.project_name
        if self.status is not None:
            result['status'] = self.status
        if self.third_part_apply_id is not None:
            result['third_part_apply_id'] = self.third_part_apply_id
        if self.third_part_cost_center_id is not None:
            result['third_part_cost_center_id'] = self.third_part_cost_center_id
        if self.third_part_invoice_id is not None:
            result['third_part_invoice_id'] = self.third_part_invoice_id
        if self.times_total is not None:
            result['times_total'] = self.times_total
        if self.times_type is not None:
            result['times_type'] = self.times_type
        if self.times_used is not None:
            result['times_used'] = self.times_used
        if self.title is not None:
            result['title'] = self.title
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('cause') is not None:
            self.cause = m.get('cause')
        if m.get('city') is not None:
            self.city = m.get('city')
        if m.get('date') is not None:
            self.date = m.get('date')
        if m.get('finished_date') is not None:
            self.finished_date = m.get('finished_date')
        if m.get('project_code') is not None:
            self.project_code = m.get('project_code')
        if m.get('project_name') is not None:
            self.project_name = m.get('project_name')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('third_part_apply_id') is not None:
            self.third_part_apply_id = m.get('third_part_apply_id')
        if m.get('third_part_cost_center_id') is not None:
            self.third_part_cost_center_id = m.get('third_part_cost_center_id')
        if m.get('third_part_invoice_id') is not None:
            self.third_part_invoice_id = m.get('third_part_invoice_id')
        if m.get('times_total') is not None:
            self.times_total = m.get('times_total')
        if m.get('times_type') is not None:
            self.times_type = m.get('times_type')
        if m.get('times_used') is not None:
            self.times_used = m.get('times_used')
        if m.get('title') is not None:
            self.title = m.get('title')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class CarApplyAddResponseBody(TeaModel):
    def __init__(self, code=None, message=None, module=None, request_id=None, success=None, trace_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.module = module  # type: long
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.trace_id = trace_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CarApplyAddResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            self.module = m.get('module')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class CarApplyAddResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CarApplyAddResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CarApplyAddResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CarApplyAddResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CarApplyModifyHeaders(TeaModel):
    def __init__(self, common_headers=None, x_acs_btrip_so_corp_token=None):
        self.common_headers = common_headers  # type: dict[str, str]
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CarApplyModifyHeaders, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class CarApplyModifyRequest(TeaModel):
    def __init__(self, operate_time=None, remark=None, status=None, third_part_apply_id=None, user_id=None):
        self.operate_time = operate_time  # type: str
        self.remark = remark  # type: str
        self.status = status  # type: int
        self.third_part_apply_id = third_part_apply_id  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CarApplyModifyRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.operate_time is not None:
            result['operate_time'] = self.operate_time
        if self.remark is not None:
            result['remark'] = self.remark
        if self.status is not None:
            result['status'] = self.status
        if self.third_part_apply_id is not None:
            result['third_part_apply_id'] = self.third_part_apply_id
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('operate_time') is not None:
            self.operate_time = m.get('operate_time')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('third_part_apply_id') is not None:
            self.third_part_apply_id = m.get('third_part_apply_id')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class CarApplyModifyResponseBody(TeaModel):
    def __init__(self, code=None, message=None, module=None, request_id=None, success=None, trace_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        # module。
        self.module = module  # type: bool
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.trace_id = trace_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CarApplyModifyResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            self.module = m.get('module')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class CarApplyModifyResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CarApplyModifyResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CarApplyModifyResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CarApplyModifyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CarApplyQueryHeaders(TeaModel):
    def __init__(self, common_headers=None, x_acs_btrip_so_corp_token=None):
        self.common_headers = common_headers  # type: dict[str, str]
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CarApplyQueryHeaders, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class CarApplyQueryRequest(TeaModel):
    def __init__(self, created_end_at=None, created_start_at=None, page_number=None, page_size=None,
                 third_part_apply_id=None, user_id=None):
        self.created_end_at = created_end_at  # type: str
        self.created_start_at = created_start_at  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.third_part_apply_id = third_part_apply_id  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CarApplyQueryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.created_end_at is not None:
            result['created_end_at'] = self.created_end_at
        if self.created_start_at is not None:
            result['created_start_at'] = self.created_start_at
        if self.page_number is not None:
            result['page_number'] = self.page_number
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.third_part_apply_id is not None:
            result['third_part_apply_id'] = self.third_part_apply_id
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('created_end_at') is not None:
            self.created_end_at = m.get('created_end_at')
        if m.get('created_start_at') is not None:
            self.created_start_at = m.get('created_start_at')
        if m.get('page_number') is not None:
            self.page_number = m.get('page_number')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('third_part_apply_id') is not None:
            self.third_part_apply_id = m.get('third_part_apply_id')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class CarApplyQueryResponseBodyApplyListApproverList(TeaModel):
    def __init__(self, note=None, operate_time=None, order=None, status=None, status_desc=None, user_id=None,
                 user_name=None):
        self.note = note  # type: str
        self.operate_time = operate_time  # type: str
        self.order = order  # type: int
        self.status = status  # type: int
        self.status_desc = status_desc  # type: str
        self.user_id = user_id  # type: str
        self.user_name = user_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CarApplyQueryResponseBodyApplyListApproverList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.note is not None:
            result['note'] = self.note
        if self.operate_time is not None:
            result['operate_time'] = self.operate_time
        if self.order is not None:
            result['order'] = self.order
        if self.status is not None:
            result['status'] = self.status
        if self.status_desc is not None:
            result['status_desc'] = self.status_desc
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('note') is not None:
            self.note = m.get('note')
        if m.get('operate_time') is not None:
            self.operate_time = m.get('operate_time')
        if m.get('order') is not None:
            self.order = m.get('order')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('status_desc') is not None:
            self.status_desc = m.get('status_desc')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        return self


class CarApplyQueryResponseBodyApplyListItineraryList(TeaModel):
    def __init__(self, arr_city=None, arr_city_code=None, arr_date=None, cost_center_id=None, cost_center_name=None,
                 dep_city=None, dep_city_code=None, dep_date=None, invoice_id=None, invoice_name=None, itinerary_id=None,
                 project_code=None, project_title=None, traffic_type=None):
        self.arr_city = arr_city  # type: str
        self.arr_city_code = arr_city_code  # type: str
        self.arr_date = arr_date  # type: str
        self.cost_center_id = cost_center_id  # type: long
        self.cost_center_name = cost_center_name  # type: str
        self.dep_city = dep_city  # type: str
        self.dep_city_code = dep_city_code  # type: str
        self.dep_date = dep_date  # type: str
        self.invoice_id = invoice_id  # type: long
        self.invoice_name = invoice_name  # type: str
        self.itinerary_id = itinerary_id  # type: str
        self.project_code = project_code  # type: str
        self.project_title = project_title  # type: str
        self.traffic_type = traffic_type  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(CarApplyQueryResponseBodyApplyListItineraryList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arr_city is not None:
            result['arr_city'] = self.arr_city
        if self.arr_city_code is not None:
            result['arr_city_code'] = self.arr_city_code
        if self.arr_date is not None:
            result['arr_date'] = self.arr_date
        if self.cost_center_id is not None:
            result['cost_center_id'] = self.cost_center_id
        if self.cost_center_name is not None:
            result['cost_center_name'] = self.cost_center_name
        if self.dep_city is not None:
            result['dep_city'] = self.dep_city
        if self.dep_city_code is not None:
            result['dep_city_code'] = self.dep_city_code
        if self.dep_date is not None:
            result['dep_date'] = self.dep_date
        if self.invoice_id is not None:
            result['invoice_id'] = self.invoice_id
        if self.invoice_name is not None:
            result['invoice_name'] = self.invoice_name
        if self.itinerary_id is not None:
            result['itinerary_id'] = self.itinerary_id
        if self.project_code is not None:
            result['project_code'] = self.project_code
        if self.project_title is not None:
            result['project_title'] = self.project_title
        if self.traffic_type is not None:
            result['traffic_type'] = self.traffic_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('arr_city') is not None:
            self.arr_city = m.get('arr_city')
        if m.get('arr_city_code') is not None:
            self.arr_city_code = m.get('arr_city_code')
        if m.get('arr_date') is not None:
            self.arr_date = m.get('arr_date')
        if m.get('cost_center_id') is not None:
            self.cost_center_id = m.get('cost_center_id')
        if m.get('cost_center_name') is not None:
            self.cost_center_name = m.get('cost_center_name')
        if m.get('dep_city') is not None:
            self.dep_city = m.get('dep_city')
        if m.get('dep_city_code') is not None:
            self.dep_city_code = m.get('dep_city_code')
        if m.get('dep_date') is not None:
            self.dep_date = m.get('dep_date')
        if m.get('invoice_id') is not None:
            self.invoice_id = m.get('invoice_id')
        if m.get('invoice_name') is not None:
            self.invoice_name = m.get('invoice_name')
        if m.get('itinerary_id') is not None:
            self.itinerary_id = m.get('itinerary_id')
        if m.get('project_code') is not None:
            self.project_code = m.get('project_code')
        if m.get('project_title') is not None:
            self.project_title = m.get('project_title')
        if m.get('traffic_type') is not None:
            self.traffic_type = m.get('traffic_type')
        return self


class CarApplyQueryResponseBodyApplyList(TeaModel):
    def __init__(self, approver_list=None, depart_id=None, depart_name=None, gmt_create=None, gmt_modified=None,
                 itinerary_list=None, status=None, status_desc=None, thirdpart_id=None, trip_cause=None, trip_title=None,
                 user_id=None, user_name=None):
        self.approver_list = approver_list  # type: list[CarApplyQueryResponseBodyApplyListApproverList]
        self.depart_id = depart_id  # type: str
        self.depart_name = depart_name  # type: str
        self.gmt_create = gmt_create  # type: str
        self.gmt_modified = gmt_modified  # type: str
        self.itinerary_list = itinerary_list  # type: list[CarApplyQueryResponseBodyApplyListItineraryList]
        self.status = status  # type: int
        self.status_desc = status_desc  # type: str
        self.thirdpart_id = thirdpart_id  # type: str
        self.trip_cause = trip_cause  # type: str
        self.trip_title = trip_title  # type: str
        self.user_id = user_id  # type: str
        self.user_name = user_name  # type: str

    def validate(self):
        if self.approver_list:
            for k in self.approver_list:
                if k:
                    k.validate()
        if self.itinerary_list:
            for k in self.itinerary_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CarApplyQueryResponseBodyApplyList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['approver_list'] = []
        if self.approver_list is not None:
            for k in self.approver_list:
                result['approver_list'].append(k.to_map() if k else None)
        if self.depart_id is not None:
            result['depart_id'] = self.depart_id
        if self.depart_name is not None:
            result['depart_name'] = self.depart_name
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        result['itinerary_list'] = []
        if self.itinerary_list is not None:
            for k in self.itinerary_list:
                result['itinerary_list'].append(k.to_map() if k else None)
        if self.status is not None:
            result['status'] = self.status
        if self.status_desc is not None:
            result['status_desc'] = self.status_desc
        if self.thirdpart_id is not None:
            result['thirdpart_id'] = self.thirdpart_id
        if self.trip_cause is not None:
            result['trip_cause'] = self.trip_cause
        if self.trip_title is not None:
            result['trip_title'] = self.trip_title
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.approver_list = []
        if m.get('approver_list') is not None:
            for k in m.get('approver_list'):
                temp_model = CarApplyQueryResponseBodyApplyListApproverList()
                self.approver_list.append(temp_model.from_map(k))
        if m.get('depart_id') is not None:
            self.depart_id = m.get('depart_id')
        if m.get('depart_name') is not None:
            self.depart_name = m.get('depart_name')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        self.itinerary_list = []
        if m.get('itinerary_list') is not None:
            for k in m.get('itinerary_list'):
                temp_model = CarApplyQueryResponseBodyApplyListItineraryList()
                self.itinerary_list.append(temp_model.from_map(k))
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('status_desc') is not None:
            self.status_desc = m.get('status_desc')
        if m.get('thirdpart_id') is not None:
            self.thirdpart_id = m.get('thirdpart_id')
        if m.get('trip_cause') is not None:
            self.trip_cause = m.get('trip_cause')
        if m.get('trip_title') is not None:
            self.trip_title = m.get('trip_title')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        return self


class CarApplyQueryResponseBody(TeaModel):
    def __init__(self, apply_list=None, code=None, message=None, request_id=None, success=None, total=None,
                 trace_id=None):
        self.apply_list = apply_list  # type: list[CarApplyQueryResponseBodyApplyList]
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.total = total  # type: int
        self.trace_id = trace_id  # type: str

    def validate(self):
        if self.apply_list:
            for k in self.apply_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CarApplyQueryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['apply_list'] = []
        if self.apply_list is not None:
            for k in self.apply_list:
                result['apply_list'].append(k.to_map() if k else None)
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.total is not None:
            result['total'] = self.total
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.apply_list = []
        if m.get('apply_list') is not None:
            for k in m.get('apply_list'):
                temp_model = CarApplyQueryResponseBodyApplyList()
                self.apply_list.append(temp_model.from_map(k))
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('total') is not None:
            self.total = m.get('total')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class CarApplyQueryResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CarApplyQueryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CarApplyQueryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CarApplyQueryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CarBillSettlementQueryHeaders(TeaModel):
    def __init__(self, common_headers=None, x_acs_btrip_so_corp_token=None):
        self.common_headers = common_headers  # type: dict[str, str]
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CarBillSettlementQueryHeaders, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class CarBillSettlementQueryRequest(TeaModel):
    def __init__(self, page_no=None, page_size=None, period_end=None, period_start=None):
        self.page_no = page_no  # type: int
        self.page_size = page_size  # type: int
        self.period_end = period_end  # type: str
        self.period_start = period_start  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CarBillSettlementQueryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_no is not None:
            result['page_no'] = self.page_no
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.period_end is not None:
            result['period_end'] = self.period_end
        if self.period_start is not None:
            result['period_start'] = self.period_start
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('page_no') is not None:
            self.page_no = m.get('page_no')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('period_end') is not None:
            self.period_end = m.get('period_end')
        if m.get('period_start') is not None:
            self.period_start = m.get('period_start')
        return self


class CarBillSettlementQueryResponseBodyModuleDataList(TeaModel):
    def __init__(self, alipay_trade_no=None, apply_id=None, arr_city=None, arr_date=None, arr_location=None,
                 arr_time=None, bill_record_time=None, book_time=None, booker_id=None, booker_job_no=None, booker_name=None,
                 business_category=None, capital_direction=None, car_level=None, cascade_department=None, cost_center=None,
                 cost_center_number=None, coupon=None, coupon_price=None, department=None, department_id=None, dept_city=None,
                 dept_date=None, dept_location=None, dept_time=None, estimate_drive_distance=None, estimate_price=None,
                 fee_type=None, index=None, invoice_title=None, memo=None, order_id=None, order_price=None,
                 over_apply_id=None, person_settle_fee=None, primary_id=None, project_code=None, project_name=None,
                 provider_name=None, real_drive_distance=None, real_from_addr=None, real_to_addr=None, remark=None,
                 service_fee=None, settlement_fee=None, settlement_grant_fee=None, settlement_time=None, settlement_type=None,
                 special_order=None, special_reason=None, status=None, sub_order_id=None, traveler_id=None, traveler_job_no=None,
                 traveler_name=None, user_confirm_desc=None, voucher_type=None):
        self.alipay_trade_no = alipay_trade_no  # type: str
        self.apply_id = apply_id  # type: str
        self.arr_city = arr_city  # type: str
        self.arr_date = arr_date  # type: str
        self.arr_location = arr_location  # type: str
        self.arr_time = arr_time  # type: str
        self.bill_record_time = bill_record_time  # type: str
        self.book_time = book_time  # type: str
        self.booker_id = booker_id  # type: str
        self.booker_job_no = booker_job_no  # type: str
        self.booker_name = booker_name  # type: str
        self.business_category = business_category  # type: str
        self.capital_direction = capital_direction  # type: str
        self.car_level = car_level  # type: str
        self.cascade_department = cascade_department  # type: str
        self.cost_center = cost_center  # type: str
        self.cost_center_number = cost_center_number  # type: str
        self.coupon = coupon  # type: float
        self.coupon_price = coupon_price  # type: float
        self.department = department  # type: str
        self.department_id = department_id  # type: str
        self.dept_city = dept_city  # type: str
        self.dept_date = dept_date  # type: str
        self.dept_location = dept_location  # type: str
        self.dept_time = dept_time  # type: str
        self.estimate_drive_distance = estimate_drive_distance  # type: str
        self.estimate_price = estimate_price  # type: float
        self.fee_type = fee_type  # type: str
        self.index = index  # type: str
        self.invoice_title = invoice_title  # type: str
        self.memo = memo  # type: str
        self.order_id = order_id  # type: str
        self.order_price = order_price  # type: float
        self.over_apply_id = over_apply_id  # type: str
        self.person_settle_fee = person_settle_fee  # type: float
        self.primary_id = primary_id  # type: long
        self.project_code = project_code  # type: str
        self.project_name = project_name  # type: str
        self.provider_name = provider_name  # type: str
        self.real_drive_distance = real_drive_distance  # type: str
        self.real_from_addr = real_from_addr  # type: str
        self.real_to_addr = real_to_addr  # type: str
        self.remark = remark  # type: str
        self.service_fee = service_fee  # type: float
        self.settlement_fee = settlement_fee  # type: float
        self.settlement_grant_fee = settlement_grant_fee  # type: float
        self.settlement_time = settlement_time  # type: str
        self.settlement_type = settlement_type  # type: str
        self.special_order = special_order  # type: str
        self.special_reason = special_reason  # type: str
        self.status = status  # type: int
        self.sub_order_id = sub_order_id  # type: str
        self.traveler_id = traveler_id  # type: str
        self.traveler_job_no = traveler_job_no  # type: str
        self.traveler_name = traveler_name  # type: str
        self.user_confirm_desc = user_confirm_desc  # type: str
        self.voucher_type = voucher_type  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(CarBillSettlementQueryResponseBodyModuleDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alipay_trade_no is not None:
            result['alipay_trade_no'] = self.alipay_trade_no
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.arr_city is not None:
            result['arr_city'] = self.arr_city
        if self.arr_date is not None:
            result['arr_date'] = self.arr_date
        if self.arr_location is not None:
            result['arr_location'] = self.arr_location
        if self.arr_time is not None:
            result['arr_time'] = self.arr_time
        if self.bill_record_time is not None:
            result['bill_record_time'] = self.bill_record_time
        if self.book_time is not None:
            result['book_time'] = self.book_time
        if self.booker_id is not None:
            result['booker_id'] = self.booker_id
        if self.booker_job_no is not None:
            result['booker_job_no'] = self.booker_job_no
        if self.booker_name is not None:
            result['booker_name'] = self.booker_name
        if self.business_category is not None:
            result['business_category'] = self.business_category
        if self.capital_direction is not None:
            result['capital_direction'] = self.capital_direction
        if self.car_level is not None:
            result['car_level'] = self.car_level
        if self.cascade_department is not None:
            result['cascade_department'] = self.cascade_department
        if self.cost_center is not None:
            result['cost_center'] = self.cost_center
        if self.cost_center_number is not None:
            result['cost_center_number'] = self.cost_center_number
        if self.coupon is not None:
            result['coupon'] = self.coupon
        if self.coupon_price is not None:
            result['coupon_price'] = self.coupon_price
        if self.department is not None:
            result['department'] = self.department
        if self.department_id is not None:
            result['department_id'] = self.department_id
        if self.dept_city is not None:
            result['dept_city'] = self.dept_city
        if self.dept_date is not None:
            result['dept_date'] = self.dept_date
        if self.dept_location is not None:
            result['dept_location'] = self.dept_location
        if self.dept_time is not None:
            result['dept_time'] = self.dept_time
        if self.estimate_drive_distance is not None:
            result['estimate_drive_distance'] = self.estimate_drive_distance
        if self.estimate_price is not None:
            result['estimate_price'] = self.estimate_price
        if self.fee_type is not None:
            result['fee_type'] = self.fee_type
        if self.index is not None:
            result['index'] = self.index
        if self.invoice_title is not None:
            result['invoice_title'] = self.invoice_title
        if self.memo is not None:
            result['memo'] = self.memo
        if self.order_id is not None:
            result['order_id'] = self.order_id
        if self.order_price is not None:
            result['order_price'] = self.order_price
        if self.over_apply_id is not None:
            result['over_apply_id'] = self.over_apply_id
        if self.person_settle_fee is not None:
            result['person_settle_fee'] = self.person_settle_fee
        if self.primary_id is not None:
            result['primary_id'] = self.primary_id
        if self.project_code is not None:
            result['project_code'] = self.project_code
        if self.project_name is not None:
            result['project_name'] = self.project_name
        if self.provider_name is not None:
            result['provider_name'] = self.provider_name
        if self.real_drive_distance is not None:
            result['real_drive_distance'] = self.real_drive_distance
        if self.real_from_addr is not None:
            result['real_from_addr'] = self.real_from_addr
        if self.real_to_addr is not None:
            result['real_to_addr'] = self.real_to_addr
        if self.remark is not None:
            result['remark'] = self.remark
        if self.service_fee is not None:
            result['service_fee'] = self.service_fee
        if self.settlement_fee is not None:
            result['settlement_fee'] = self.settlement_fee
        if self.settlement_grant_fee is not None:
            result['settlement_grant_fee'] = self.settlement_grant_fee
        if self.settlement_time is not None:
            result['settlement_time'] = self.settlement_time
        if self.settlement_type is not None:
            result['settlement_type'] = self.settlement_type
        if self.special_order is not None:
            result['special_order'] = self.special_order
        if self.special_reason is not None:
            result['special_reason'] = self.special_reason
        if self.status is not None:
            result['status'] = self.status
        if self.sub_order_id is not None:
            result['sub_order_id'] = self.sub_order_id
        if self.traveler_id is not None:
            result['traveler_id'] = self.traveler_id
        if self.traveler_job_no is not None:
            result['traveler_job_no'] = self.traveler_job_no
        if self.traveler_name is not None:
            result['traveler_name'] = self.traveler_name
        if self.user_confirm_desc is not None:
            result['user_confirm_desc'] = self.user_confirm_desc
        if self.voucher_type is not None:
            result['voucher_type'] = self.voucher_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('alipay_trade_no') is not None:
            self.alipay_trade_no = m.get('alipay_trade_no')
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('arr_city') is not None:
            self.arr_city = m.get('arr_city')
        if m.get('arr_date') is not None:
            self.arr_date = m.get('arr_date')
        if m.get('arr_location') is not None:
            self.arr_location = m.get('arr_location')
        if m.get('arr_time') is not None:
            self.arr_time = m.get('arr_time')
        if m.get('bill_record_time') is not None:
            self.bill_record_time = m.get('bill_record_time')
        if m.get('book_time') is not None:
            self.book_time = m.get('book_time')
        if m.get('booker_id') is not None:
            self.booker_id = m.get('booker_id')
        if m.get('booker_job_no') is not None:
            self.booker_job_no = m.get('booker_job_no')
        if m.get('booker_name') is not None:
            self.booker_name = m.get('booker_name')
        if m.get('business_category') is not None:
            self.business_category = m.get('business_category')
        if m.get('capital_direction') is not None:
            self.capital_direction = m.get('capital_direction')
        if m.get('car_level') is not None:
            self.car_level = m.get('car_level')
        if m.get('cascade_department') is not None:
            self.cascade_department = m.get('cascade_department')
        if m.get('cost_center') is not None:
            self.cost_center = m.get('cost_center')
        if m.get('cost_center_number') is not None:
            self.cost_center_number = m.get('cost_center_number')
        if m.get('coupon') is not None:
            self.coupon = m.get('coupon')
        if m.get('coupon_price') is not None:
            self.coupon_price = m.get('coupon_price')
        if m.get('department') is not None:
            self.department = m.get('department')
        if m.get('department_id') is not None:
            self.department_id = m.get('department_id')
        if m.get('dept_city') is not None:
            self.dept_city = m.get('dept_city')
        if m.get('dept_date') is not None:
            self.dept_date = m.get('dept_date')
        if m.get('dept_location') is not None:
            self.dept_location = m.get('dept_location')
        if m.get('dept_time') is not None:
            self.dept_time = m.get('dept_time')
        if m.get('estimate_drive_distance') is not None:
            self.estimate_drive_distance = m.get('estimate_drive_distance')
        if m.get('estimate_price') is not None:
            self.estimate_price = m.get('estimate_price')
        if m.get('fee_type') is not None:
            self.fee_type = m.get('fee_type')
        if m.get('index') is not None:
            self.index = m.get('index')
        if m.get('invoice_title') is not None:
            self.invoice_title = m.get('invoice_title')
        if m.get('memo') is not None:
            self.memo = m.get('memo')
        if m.get('order_id') is not None:
            self.order_id = m.get('order_id')
        if m.get('order_price') is not None:
            self.order_price = m.get('order_price')
        if m.get('over_apply_id') is not None:
            self.over_apply_id = m.get('over_apply_id')
        if m.get('person_settle_fee') is not None:
            self.person_settle_fee = m.get('person_settle_fee')
        if m.get('primary_id') is not None:
            self.primary_id = m.get('primary_id')
        if m.get('project_code') is not None:
            self.project_code = m.get('project_code')
        if m.get('project_name') is not None:
            self.project_name = m.get('project_name')
        if m.get('provider_name') is not None:
            self.provider_name = m.get('provider_name')
        if m.get('real_drive_distance') is not None:
            self.real_drive_distance = m.get('real_drive_distance')
        if m.get('real_from_addr') is not None:
            self.real_from_addr = m.get('real_from_addr')
        if m.get('real_to_addr') is not None:
            self.real_to_addr = m.get('real_to_addr')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        if m.get('service_fee') is not None:
            self.service_fee = m.get('service_fee')
        if m.get('settlement_fee') is not None:
            self.settlement_fee = m.get('settlement_fee')
        if m.get('settlement_grant_fee') is not None:
            self.settlement_grant_fee = m.get('settlement_grant_fee')
        if m.get('settlement_time') is not None:
            self.settlement_time = m.get('settlement_time')
        if m.get('settlement_type') is not None:
            self.settlement_type = m.get('settlement_type')
        if m.get('special_order') is not None:
            self.special_order = m.get('special_order')
        if m.get('special_reason') is not None:
            self.special_reason = m.get('special_reason')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('sub_order_id') is not None:
            self.sub_order_id = m.get('sub_order_id')
        if m.get('traveler_id') is not None:
            self.traveler_id = m.get('traveler_id')
        if m.get('traveler_job_no') is not None:
            self.traveler_job_no = m.get('traveler_job_no')
        if m.get('traveler_name') is not None:
            self.traveler_name = m.get('traveler_name')
        if m.get('user_confirm_desc') is not None:
            self.user_confirm_desc = m.get('user_confirm_desc')
        if m.get('voucher_type') is not None:
            self.voucher_type = m.get('voucher_type')
        return self


class CarBillSettlementQueryResponseBodyModule(TeaModel):
    def __init__(self, category=None, corp_id=None, data_list=None, period_end=None, period_start=None,
                 total_num=None):
        self.category = category  # type: int
        self.corp_id = corp_id  # type: str
        self.data_list = data_list  # type: list[CarBillSettlementQueryResponseBodyModuleDataList]
        self.period_end = period_end  # type: str
        self.period_start = period_start  # type: str
        self.total_num = total_num  # type: long

    def validate(self):
        if self.data_list:
            for k in self.data_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CarBillSettlementQueryResponseBodyModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['category'] = self.category
        if self.corp_id is not None:
            result['corp_id'] = self.corp_id
        result['data_list'] = []
        if self.data_list is not None:
            for k in self.data_list:
                result['data_list'].append(k.to_map() if k else None)
        if self.period_end is not None:
            result['period_end'] = self.period_end
        if self.period_start is not None:
            result['period_start'] = self.period_start
        if self.total_num is not None:
            result['total_num'] = self.total_num
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('category') is not None:
            self.category = m.get('category')
        if m.get('corp_id') is not None:
            self.corp_id = m.get('corp_id')
        self.data_list = []
        if m.get('data_list') is not None:
            for k in m.get('data_list'):
                temp_model = CarBillSettlementQueryResponseBodyModuleDataList()
                self.data_list.append(temp_model.from_map(k))
        if m.get('period_end') is not None:
            self.period_end = m.get('period_end')
        if m.get('period_start') is not None:
            self.period_start = m.get('period_start')
        if m.get('total_num') is not None:
            self.total_num = m.get('total_num')
        return self


class CarBillSettlementQueryResponseBody(TeaModel):
    def __init__(self, code=None, message=None, module=None, request_id=None, success=None, trace_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.module = module  # type: CarBillSettlementQueryResponseBodyModule
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.trace_id = trace_id  # type: str

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super(CarBillSettlementQueryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = CarBillSettlementQueryResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class CarBillSettlementQueryResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CarBillSettlementQueryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CarBillSettlementQueryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CarBillSettlementQueryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CarOrderListQueryHeaders(TeaModel):
    def __init__(self, common_headers=None, x_acs_btrip_so_corp_token=None):
        self.common_headers = common_headers  # type: dict[str, str]
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CarOrderListQueryHeaders, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class CarOrderListQueryRequest(TeaModel):
    def __init__(self, all_apply=None, apply_id=None, depart_id=None, end_time=None, page=None, page_size=None,
                 start_time=None, thirdpart_apply_id=None, update_end_time=None, update_start_time=None, user_id=None):
        self.all_apply = all_apply  # type: bool
        self.apply_id = apply_id  # type: long
        self.depart_id = depart_id  # type: str
        self.end_time = end_time  # type: str
        self.page = page  # type: int
        self.page_size = page_size  # type: int
        self.start_time = start_time  # type: str
        self.thirdpart_apply_id = thirdpart_apply_id  # type: str
        self.update_end_time = update_end_time  # type: str
        self.update_start_time = update_start_time  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CarOrderListQueryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.all_apply is not None:
            result['all_apply'] = self.all_apply
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.depart_id is not None:
            result['depart_id'] = self.depart_id
        if self.end_time is not None:
            result['end_time'] = self.end_time
        if self.page is not None:
            result['page'] = self.page
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.start_time is not None:
            result['start_time'] = self.start_time
        if self.thirdpart_apply_id is not None:
            result['thirdpart_apply_id'] = self.thirdpart_apply_id
        if self.update_end_time is not None:
            result['update_end_time'] = self.update_end_time
        if self.update_start_time is not None:
            result['update_start_time'] = self.update_start_time
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('all_apply') is not None:
            self.all_apply = m.get('all_apply')
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('depart_id') is not None:
            self.depart_id = m.get('depart_id')
        if m.get('end_time') is not None:
            self.end_time = m.get('end_time')
        if m.get('page') is not None:
            self.page = m.get('page')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('start_time') is not None:
            self.start_time = m.get('start_time')
        if m.get('thirdpart_apply_id') is not None:
            self.thirdpart_apply_id = m.get('thirdpart_apply_id')
        if m.get('update_end_time') is not None:
            self.update_end_time = m.get('update_end_time')
        if m.get('update_start_time') is not None:
            self.update_start_time = m.get('update_start_time')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class CarOrderListQueryResponseBodyModulePriceInfoList(TeaModel):
    def __init__(self, category_code=None, category_type=None, gmt_create=None, passenger_name=None, pay_type=None,
                 person_price=None, price=None, trade_id=None, type=None):
        self.category_code = category_code  # type: int
        self.category_type = category_type  # type: int
        self.gmt_create = gmt_create  # type: str
        self.passenger_name = passenger_name  # type: str
        self.pay_type = pay_type  # type: int
        self.person_price = person_price  # type: float
        self.price = price  # type: float
        self.trade_id = trade_id  # type: str
        self.type = type  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(CarOrderListQueryResponseBodyModulePriceInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category_code is not None:
            result['category_code'] = self.category_code
        if self.category_type is not None:
            result['category_type'] = self.category_type
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.passenger_name is not None:
            result['passenger_name'] = self.passenger_name
        if self.pay_type is not None:
            result['pay_type'] = self.pay_type
        if self.person_price is not None:
            result['person_price'] = self.person_price
        if self.price is not None:
            result['price'] = self.price
        if self.trade_id is not None:
            result['trade_id'] = self.trade_id
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('category_code') is not None:
            self.category_code = m.get('category_code')
        if m.get('category_type') is not None:
            self.category_type = m.get('category_type')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('passenger_name') is not None:
            self.passenger_name = m.get('passenger_name')
        if m.get('pay_type') is not None:
            self.pay_type = m.get('pay_type')
        if m.get('person_price') is not None:
            self.person_price = m.get('person_price')
        if m.get('price') is not None:
            self.price = m.get('price')
        if m.get('trade_id') is not None:
            self.trade_id = m.get('trade_id')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class CarOrderListQueryResponseBodyModuleUserAffiliateList(TeaModel):
    def __init__(self, user_id=None, user_name=None):
        self.user_id = user_id  # type: str
        self.user_name = user_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CarOrderListQueryResponseBodyModuleUserAffiliateList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        return self


class CarOrderListQueryResponseBodyModule(TeaModel):
    def __init__(self, apply_id=None, apply_show_id=None, btrip_title=None, business_category=None,
                 cancel_time=None, car_info=None, car_level=None, corp_id=None, corp_name=None, cost_center_id=None,
                 cost_center_name=None, cost_center_number=None, dept_id=None, dept_name=None, driver_confirm_time=None,
                 estimate_price=None, from_address=None, from_city_name=None, gmt_create=None, gmt_modified=None, id=None,
                 invoice_id=None, invoice_title=None, is_special=None, memo=None, order_status=None, passenger_name=None,
                 pay_time=None, price_info_list=None, project_code=None, project_id=None, project_title=None, provider=None,
                 publish_time=None, real_from_address=None, real_from_city_name=None, real_to_address=None,
                 real_to_city_name=None, service_type=None, special_types=None, taken_time=None, thirdpart_apply_id=None,
                 thirdpart_itinerary_id=None, to_address=None, to_city_name=None, travel_distance=None, user_affiliate_list=None,
                 user_confirm=None, user_id=None, user_name=None):
        self.apply_id = apply_id  # type: long
        self.apply_show_id = apply_show_id  # type: str
        self.btrip_title = btrip_title  # type: str
        self.business_category = business_category  # type: str
        self.cancel_time = cancel_time  # type: str
        self.car_info = car_info  # type: str
        self.car_level = car_level  # type: int
        self.corp_id = corp_id  # type: str
        self.corp_name = corp_name  # type: str
        self.cost_center_id = cost_center_id  # type: long
        self.cost_center_name = cost_center_name  # type: str
        self.cost_center_number = cost_center_number  # type: str
        self.dept_id = dept_id  # type: long
        self.dept_name = dept_name  # type: str
        self.driver_confirm_time = driver_confirm_time  # type: str
        self.estimate_price = estimate_price  # type: float
        self.from_address = from_address  # type: str
        self.from_city_name = from_city_name  # type: str
        self.gmt_create = gmt_create  # type: str
        self.gmt_modified = gmt_modified  # type: str
        self.id = id  # type: long
        self.invoice_id = invoice_id  # type: long
        self.invoice_title = invoice_title  # type: str
        self.is_special = is_special  # type: bool
        self.memo = memo  # type: str
        self.order_status = order_status  # type: int
        self.passenger_name = passenger_name  # type: str
        self.pay_time = pay_time  # type: str
        self.price_info_list = price_info_list  # type: list[CarOrderListQueryResponseBodyModulePriceInfoList]
        self.project_code = project_code  # type: str
        self.project_id = project_id  # type: long
        self.project_title = project_title  # type: str
        self.provider = provider  # type: int
        self.publish_time = publish_time  # type: str
        self.real_from_address = real_from_address  # type: str
        self.real_from_city_name = real_from_city_name  # type: str
        self.real_to_address = real_to_address  # type: str
        self.real_to_city_name = real_to_city_name  # type: str
        self.service_type = service_type  # type: int
        self.special_types = special_types  # type: list[str]
        self.taken_time = taken_time  # type: str
        self.thirdpart_apply_id = thirdpart_apply_id  # type: str
        self.thirdpart_itinerary_id = thirdpart_itinerary_id  # type: str
        self.to_address = to_address  # type: str
        self.to_city_name = to_city_name  # type: str
        self.travel_distance = travel_distance  # type: float
        self.user_affiliate_list = user_affiliate_list  # type: list[CarOrderListQueryResponseBodyModuleUserAffiliateList]
        self.user_confirm = user_confirm  # type: int
        self.user_id = user_id  # type: str
        self.user_name = user_name  # type: str

    def validate(self):
        if self.price_info_list:
            for k in self.price_info_list:
                if k:
                    k.validate()
        if self.user_affiliate_list:
            for k in self.user_affiliate_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CarOrderListQueryResponseBodyModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.apply_show_id is not None:
            result['apply_show_id'] = self.apply_show_id
        if self.btrip_title is not None:
            result['btrip_title'] = self.btrip_title
        if self.business_category is not None:
            result['business_category'] = self.business_category
        if self.cancel_time is not None:
            result['cancel_time'] = self.cancel_time
        if self.car_info is not None:
            result['car_info'] = self.car_info
        if self.car_level is not None:
            result['car_level'] = self.car_level
        if self.corp_id is not None:
            result['corp_id'] = self.corp_id
        if self.corp_name is not None:
            result['corp_name'] = self.corp_name
        if self.cost_center_id is not None:
            result['cost_center_id'] = self.cost_center_id
        if self.cost_center_name is not None:
            result['cost_center_name'] = self.cost_center_name
        if self.cost_center_number is not None:
            result['cost_center_number'] = self.cost_center_number
        if self.dept_id is not None:
            result['dept_id'] = self.dept_id
        if self.dept_name is not None:
            result['dept_name'] = self.dept_name
        if self.driver_confirm_time is not None:
            result['driver_confirm_time'] = self.driver_confirm_time
        if self.estimate_price is not None:
            result['estimate_price'] = self.estimate_price
        if self.from_address is not None:
            result['from_address'] = self.from_address
        if self.from_city_name is not None:
            result['from_city_name'] = self.from_city_name
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        if self.id is not None:
            result['id'] = self.id
        if self.invoice_id is not None:
            result['invoice_id'] = self.invoice_id
        if self.invoice_title is not None:
            result['invoice_title'] = self.invoice_title
        if self.is_special is not None:
            result['is_special'] = self.is_special
        if self.memo is not None:
            result['memo'] = self.memo
        if self.order_status is not None:
            result['order_status'] = self.order_status
        if self.passenger_name is not None:
            result['passenger_name'] = self.passenger_name
        if self.pay_time is not None:
            result['pay_time'] = self.pay_time
        result['price_info_list'] = []
        if self.price_info_list is not None:
            for k in self.price_info_list:
                result['price_info_list'].append(k.to_map() if k else None)
        if self.project_code is not None:
            result['project_code'] = self.project_code
        if self.project_id is not None:
            result['project_id'] = self.project_id
        if self.project_title is not None:
            result['project_title'] = self.project_title
        if self.provider is not None:
            result['provider'] = self.provider
        if self.publish_time is not None:
            result['publish_time'] = self.publish_time
        if self.real_from_address is not None:
            result['real_from_address'] = self.real_from_address
        if self.real_from_city_name is not None:
            result['real_from_city_name'] = self.real_from_city_name
        if self.real_to_address is not None:
            result['real_to_address'] = self.real_to_address
        if self.real_to_city_name is not None:
            result['real_to_city_name'] = self.real_to_city_name
        if self.service_type is not None:
            result['service_type'] = self.service_type
        if self.special_types is not None:
            result['special_types'] = self.special_types
        if self.taken_time is not None:
            result['taken_time'] = self.taken_time
        if self.thirdpart_apply_id is not None:
            result['thirdpart_apply_id'] = self.thirdpart_apply_id
        if self.thirdpart_itinerary_id is not None:
            result['thirdpart_itinerary_id'] = self.thirdpart_itinerary_id
        if self.to_address is not None:
            result['to_address'] = self.to_address
        if self.to_city_name is not None:
            result['to_city_name'] = self.to_city_name
        if self.travel_distance is not None:
            result['travel_distance'] = self.travel_distance
        result['user_affiliate_list'] = []
        if self.user_affiliate_list is not None:
            for k in self.user_affiliate_list:
                result['user_affiliate_list'].append(k.to_map() if k else None)
        if self.user_confirm is not None:
            result['user_confirm'] = self.user_confirm
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('apply_show_id') is not None:
            self.apply_show_id = m.get('apply_show_id')
        if m.get('btrip_title') is not None:
            self.btrip_title = m.get('btrip_title')
        if m.get('business_category') is not None:
            self.business_category = m.get('business_category')
        if m.get('cancel_time') is not None:
            self.cancel_time = m.get('cancel_time')
        if m.get('car_info') is not None:
            self.car_info = m.get('car_info')
        if m.get('car_level') is not None:
            self.car_level = m.get('car_level')
        if m.get('corp_id') is not None:
            self.corp_id = m.get('corp_id')
        if m.get('corp_name') is not None:
            self.corp_name = m.get('corp_name')
        if m.get('cost_center_id') is not None:
            self.cost_center_id = m.get('cost_center_id')
        if m.get('cost_center_name') is not None:
            self.cost_center_name = m.get('cost_center_name')
        if m.get('cost_center_number') is not None:
            self.cost_center_number = m.get('cost_center_number')
        if m.get('dept_id') is not None:
            self.dept_id = m.get('dept_id')
        if m.get('dept_name') is not None:
            self.dept_name = m.get('dept_name')
        if m.get('driver_confirm_time') is not None:
            self.driver_confirm_time = m.get('driver_confirm_time')
        if m.get('estimate_price') is not None:
            self.estimate_price = m.get('estimate_price')
        if m.get('from_address') is not None:
            self.from_address = m.get('from_address')
        if m.get('from_city_name') is not None:
            self.from_city_name = m.get('from_city_name')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('invoice_id') is not None:
            self.invoice_id = m.get('invoice_id')
        if m.get('invoice_title') is not None:
            self.invoice_title = m.get('invoice_title')
        if m.get('is_special') is not None:
            self.is_special = m.get('is_special')
        if m.get('memo') is not None:
            self.memo = m.get('memo')
        if m.get('order_status') is not None:
            self.order_status = m.get('order_status')
        if m.get('passenger_name') is not None:
            self.passenger_name = m.get('passenger_name')
        if m.get('pay_time') is not None:
            self.pay_time = m.get('pay_time')
        self.price_info_list = []
        if m.get('price_info_list') is not None:
            for k in m.get('price_info_list'):
                temp_model = CarOrderListQueryResponseBodyModulePriceInfoList()
                self.price_info_list.append(temp_model.from_map(k))
        if m.get('project_code') is not None:
            self.project_code = m.get('project_code')
        if m.get('project_id') is not None:
            self.project_id = m.get('project_id')
        if m.get('project_title') is not None:
            self.project_title = m.get('project_title')
        if m.get('provider') is not None:
            self.provider = m.get('provider')
        if m.get('publish_time') is not None:
            self.publish_time = m.get('publish_time')
        if m.get('real_from_address') is not None:
            self.real_from_address = m.get('real_from_address')
        if m.get('real_from_city_name') is not None:
            self.real_from_city_name = m.get('real_from_city_name')
        if m.get('real_to_address') is not None:
            self.real_to_address = m.get('real_to_address')
        if m.get('real_to_city_name') is not None:
            self.real_to_city_name = m.get('real_to_city_name')
        if m.get('service_type') is not None:
            self.service_type = m.get('service_type')
        if m.get('special_types') is not None:
            self.special_types = m.get('special_types')
        if m.get('taken_time') is not None:
            self.taken_time = m.get('taken_time')
        if m.get('thirdpart_apply_id') is not None:
            self.thirdpart_apply_id = m.get('thirdpart_apply_id')
        if m.get('thirdpart_itinerary_id') is not None:
            self.thirdpart_itinerary_id = m.get('thirdpart_itinerary_id')
        if m.get('to_address') is not None:
            self.to_address = m.get('to_address')
        if m.get('to_city_name') is not None:
            self.to_city_name = m.get('to_city_name')
        if m.get('travel_distance') is not None:
            self.travel_distance = m.get('travel_distance')
        self.user_affiliate_list = []
        if m.get('user_affiliate_list') is not None:
            for k in m.get('user_affiliate_list'):
                temp_model = CarOrderListQueryResponseBodyModuleUserAffiliateList()
                self.user_affiliate_list.append(temp_model.from_map(k))
        if m.get('user_confirm') is not None:
            self.user_confirm = m.get('user_confirm')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        return self


class CarOrderListQueryResponseBodyPageInfo(TeaModel):
    def __init__(self, page=None, page_size=None, total_number=None):
        self.page = page  # type: int
        self.page_size = page_size  # type: int
        self.total_number = total_number  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(CarOrderListQueryResponseBodyPageInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page is not None:
            result['page'] = self.page
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.total_number is not None:
            result['total_number'] = self.total_number
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('page') is not None:
            self.page = m.get('page')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('total_number') is not None:
            self.total_number = m.get('total_number')
        return self


class CarOrderListQueryResponseBody(TeaModel):
    def __init__(self, code=None, message=None, module=None, page_info=None, request_id=None, success=None,
                 trace_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.module = module  # type: list[CarOrderListQueryResponseBodyModule]
        self.page_info = page_info  # type: CarOrderListQueryResponseBodyPageInfo
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        # traceId
        self.trace_id = trace_id  # type: str

    def validate(self):
        if self.module:
            for k in self.module:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super(CarOrderListQueryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        result['module'] = []
        if self.module is not None:
            for k in self.module:
                result['module'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['page_info'] = self.page_info.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        self.module = []
        if m.get('module') is not None:
            for k in m.get('module'):
                temp_model = CarOrderListQueryResponseBodyModule()
                self.module.append(temp_model.from_map(k))
        if m.get('page_info') is not None:
            temp_model = CarOrderListQueryResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['page_info'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class CarOrderListQueryResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CarOrderListQueryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CarOrderListQueryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CarOrderListQueryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CarOrderQueryHeaders(TeaModel):
    def __init__(self, common_headers=None, x_acs_btrip_so_corp_token=None):
        self.common_headers = common_headers  # type: dict[str, str]
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CarOrderQueryHeaders, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class CarOrderQueryRequest(TeaModel):
    def __init__(self, order_id=None, sub_order_id=None):
        self.order_id = order_id  # type: long
        self.sub_order_id = sub_order_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CarOrderQueryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.order_id is not None:
            result['order_id'] = self.order_id
        if self.sub_order_id is not None:
            result['sub_order_id'] = self.sub_order_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('order_id') is not None:
            self.order_id = m.get('order_id')
        if m.get('sub_order_id') is not None:
            self.sub_order_id = m.get('sub_order_id')
        return self


class CarOrderQueryResponseBodyModuleCarInfo(TeaModel):
    def __init__(self, business_category=None, cancel_time=None, car_info=None, car_level=None,
                 driver_confirm_time=None, estimate_price=None, from_address=None, from_city_name=None, is_special=None, memo=None,
                 pay_time=None, publish_time=None, real_from_address=None, real_from_city_name=None, real_to_address=None,
                 real_to_city_name=None, service_type=None, special_types=None, taken_time=None, to_address=None, to_city_name=None,
                 travel_distance=None):
        self.business_category = business_category  # type: str
        self.cancel_time = cancel_time  # type: long
        self.car_info = car_info  # type: str
        self.car_level = car_level  # type: int
        self.driver_confirm_time = driver_confirm_time  # type: long
        self.estimate_price = estimate_price  # type: long
        self.from_address = from_address  # type: str
        self.from_city_name = from_city_name  # type: str
        self.is_special = is_special  # type: bool
        self.memo = memo  # type: str
        self.pay_time = pay_time  # type: long
        self.publish_time = publish_time  # type: long
        self.real_from_address = real_from_address  # type: str
        self.real_from_city_name = real_from_city_name  # type: str
        self.real_to_address = real_to_address  # type: str
        self.real_to_city_name = real_to_city_name  # type: str
        self.service_type = service_type  # type: int
        self.special_types = special_types  # type: str
        self.taken_time = taken_time  # type: long
        self.to_address = to_address  # type: str
        self.to_city_name = to_city_name  # type: str
        self.travel_distance = travel_distance  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CarOrderQueryResponseBodyModuleCarInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_category is not None:
            result['business_category'] = self.business_category
        if self.cancel_time is not None:
            result['cancel_time'] = self.cancel_time
        if self.car_info is not None:
            result['car_info'] = self.car_info
        if self.car_level is not None:
            result['car_level'] = self.car_level
        if self.driver_confirm_time is not None:
            result['driver_confirm_time'] = self.driver_confirm_time
        if self.estimate_price is not None:
            result['estimate_price'] = self.estimate_price
        if self.from_address is not None:
            result['from_address'] = self.from_address
        if self.from_city_name is not None:
            result['from_city_name'] = self.from_city_name
        if self.is_special is not None:
            result['is_special'] = self.is_special
        if self.memo is not None:
            result['memo'] = self.memo
        if self.pay_time is not None:
            result['pay_time'] = self.pay_time
        if self.publish_time is not None:
            result['publish_time'] = self.publish_time
        if self.real_from_address is not None:
            result['real_from_address'] = self.real_from_address
        if self.real_from_city_name is not None:
            result['real_from_city_name'] = self.real_from_city_name
        if self.real_to_address is not None:
            result['real_to_address'] = self.real_to_address
        if self.real_to_city_name is not None:
            result['real_to_city_name'] = self.real_to_city_name
        if self.service_type is not None:
            result['service_type'] = self.service_type
        if self.special_types is not None:
            result['special_types'] = self.special_types
        if self.taken_time is not None:
            result['taken_time'] = self.taken_time
        if self.to_address is not None:
            result['to_address'] = self.to_address
        if self.to_city_name is not None:
            result['to_city_name'] = self.to_city_name
        if self.travel_distance is not None:
            result['travel_distance'] = self.travel_distance
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('business_category') is not None:
            self.business_category = m.get('business_category')
        if m.get('cancel_time') is not None:
            self.cancel_time = m.get('cancel_time')
        if m.get('car_info') is not None:
            self.car_info = m.get('car_info')
        if m.get('car_level') is not None:
            self.car_level = m.get('car_level')
        if m.get('driver_confirm_time') is not None:
            self.driver_confirm_time = m.get('driver_confirm_time')
        if m.get('estimate_price') is not None:
            self.estimate_price = m.get('estimate_price')
        if m.get('from_address') is not None:
            self.from_address = m.get('from_address')
        if m.get('from_city_name') is not None:
            self.from_city_name = m.get('from_city_name')
        if m.get('is_special') is not None:
            self.is_special = m.get('is_special')
        if m.get('memo') is not None:
            self.memo = m.get('memo')
        if m.get('pay_time') is not None:
            self.pay_time = m.get('pay_time')
        if m.get('publish_time') is not None:
            self.publish_time = m.get('publish_time')
        if m.get('real_from_address') is not None:
            self.real_from_address = m.get('real_from_address')
        if m.get('real_from_city_name') is not None:
            self.real_from_city_name = m.get('real_from_city_name')
        if m.get('real_to_address') is not None:
            self.real_to_address = m.get('real_to_address')
        if m.get('real_to_city_name') is not None:
            self.real_to_city_name = m.get('real_to_city_name')
        if m.get('service_type') is not None:
            self.service_type = m.get('service_type')
        if m.get('special_types') is not None:
            self.special_types = m.get('special_types')
        if m.get('taken_time') is not None:
            self.taken_time = m.get('taken_time')
        if m.get('to_address') is not None:
            self.to_address = m.get('to_address')
        if m.get('to_city_name') is not None:
            self.to_city_name = m.get('to_city_name')
        if m.get('travel_distance') is not None:
            self.travel_distance = m.get('travel_distance')
        return self


class CarOrderQueryResponseBodyModuleInvoiceInfo(TeaModel):
    def __init__(self, id=None, title=None):
        self.id = id  # type: long
        self.title = title  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CarOrderQueryResponseBodyModuleInvoiceInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class CarOrderQueryResponseBodyModuleOrderBaseInfo(TeaModel):
    def __init__(self, apply_id=None, btrip_cause=None, btrip_title=None, corp_id=None, corp_name=None,
                 depart_id=None, depart_name=None, gmt_create=None, gmt_modified=None, itinerary_id=None, order_id=None,
                 order_status=None, sub_order_id=None, third_depart_id=None, thirdpart_apply_id=None,
                 thirdpart_itinerary_id=None, user_id=None, user_name=None):
        self.apply_id = apply_id  # type: str
        self.btrip_cause = btrip_cause  # type: str
        self.btrip_title = btrip_title  # type: str
        self.corp_id = corp_id  # type: str
        self.corp_name = corp_name  # type: str
        self.depart_id = depart_id  # type: str
        self.depart_name = depart_name  # type: str
        self.gmt_create = gmt_create  # type: long
        self.gmt_modified = gmt_modified  # type: long
        self.itinerary_id = itinerary_id  # type: str
        self.order_id = order_id  # type: long
        self.order_status = order_status  # type: int
        self.sub_order_id = sub_order_id  # type: long
        self.third_depart_id = third_depart_id  # type: str
        self.thirdpart_apply_id = thirdpart_apply_id  # type: str
        self.thirdpart_itinerary_id = thirdpart_itinerary_id  # type: str
        self.user_id = user_id  # type: str
        self.user_name = user_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CarOrderQueryResponseBodyModuleOrderBaseInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.btrip_cause is not None:
            result['btrip_cause'] = self.btrip_cause
        if self.btrip_title is not None:
            result['btrip_title'] = self.btrip_title
        if self.corp_id is not None:
            result['corp_id'] = self.corp_id
        if self.corp_name is not None:
            result['corp_name'] = self.corp_name
        if self.depart_id is not None:
            result['depart_id'] = self.depart_id
        if self.depart_name is not None:
            result['depart_name'] = self.depart_name
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        if self.itinerary_id is not None:
            result['itinerary_id'] = self.itinerary_id
        if self.order_id is not None:
            result['order_id'] = self.order_id
        if self.order_status is not None:
            result['order_status'] = self.order_status
        if self.sub_order_id is not None:
            result['sub_order_id'] = self.sub_order_id
        if self.third_depart_id is not None:
            result['third_depart_id'] = self.third_depart_id
        if self.thirdpart_apply_id is not None:
            result['thirdpart_apply_id'] = self.thirdpart_apply_id
        if self.thirdpart_itinerary_id is not None:
            result['thirdpart_itinerary_id'] = self.thirdpart_itinerary_id
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('btrip_cause') is not None:
            self.btrip_cause = m.get('btrip_cause')
        if m.get('btrip_title') is not None:
            self.btrip_title = m.get('btrip_title')
        if m.get('corp_id') is not None:
            self.corp_id = m.get('corp_id')
        if m.get('corp_name') is not None:
            self.corp_name = m.get('corp_name')
        if m.get('depart_id') is not None:
            self.depart_id = m.get('depart_id')
        if m.get('depart_name') is not None:
            self.depart_name = m.get('depart_name')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        if m.get('itinerary_id') is not None:
            self.itinerary_id = m.get('itinerary_id')
        if m.get('order_id') is not None:
            self.order_id = m.get('order_id')
        if m.get('order_status') is not None:
            self.order_status = m.get('order_status')
        if m.get('sub_order_id') is not None:
            self.sub_order_id = m.get('sub_order_id')
        if m.get('third_depart_id') is not None:
            self.third_depart_id = m.get('third_depart_id')
        if m.get('thirdpart_apply_id') is not None:
            self.thirdpart_apply_id = m.get('thirdpart_apply_id')
        if m.get('thirdpart_itinerary_id') is not None:
            self.thirdpart_itinerary_id = m.get('thirdpart_itinerary_id')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        return self


class CarOrderQueryResponseBodyModulePassengerList(TeaModel):
    def __init__(self, cost_center_id=None, cost_center_name=None, cost_center_number=None, project_code=None,
                 project_id=None, project_title=None, thirdpart_cost_center_id=None, thirdpart_project_id=None, user_id=None,
                 user_name=None, user_type=None):
        self.cost_center_id = cost_center_id  # type: long
        self.cost_center_name = cost_center_name  # type: str
        self.cost_center_number = cost_center_number  # type: str
        self.project_code = project_code  # type: str
        self.project_id = project_id  # type: long
        self.project_title = project_title  # type: str
        self.thirdpart_cost_center_id = thirdpart_cost_center_id  # type: str
        self.thirdpart_project_id = thirdpart_project_id  # type: str
        self.user_id = user_id  # type: str
        self.user_name = user_name  # type: str
        self.user_type = user_type  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(CarOrderQueryResponseBodyModulePassengerList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cost_center_id is not None:
            result['cost_center_id'] = self.cost_center_id
        if self.cost_center_name is not None:
            result['cost_center_name'] = self.cost_center_name
        if self.cost_center_number is not None:
            result['cost_center_number'] = self.cost_center_number
        if self.project_code is not None:
            result['project_code'] = self.project_code
        if self.project_id is not None:
            result['project_id'] = self.project_id
        if self.project_title is not None:
            result['project_title'] = self.project_title
        if self.thirdpart_cost_center_id is not None:
            result['thirdpart_cost_center_id'] = self.thirdpart_cost_center_id
        if self.thirdpart_project_id is not None:
            result['thirdpart_project_id'] = self.thirdpart_project_id
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        if self.user_type is not None:
            result['user_type'] = self.user_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('cost_center_id') is not None:
            self.cost_center_id = m.get('cost_center_id')
        if m.get('cost_center_name') is not None:
            self.cost_center_name = m.get('cost_center_name')
        if m.get('cost_center_number') is not None:
            self.cost_center_number = m.get('cost_center_number')
        if m.get('project_code') is not None:
            self.project_code = m.get('project_code')
        if m.get('project_id') is not None:
            self.project_id = m.get('project_id')
        if m.get('project_title') is not None:
            self.project_title = m.get('project_title')
        if m.get('thirdpart_cost_center_id') is not None:
            self.thirdpart_cost_center_id = m.get('thirdpart_cost_center_id')
        if m.get('thirdpart_project_id') is not None:
            self.thirdpart_project_id = m.get('thirdpart_project_id')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        if m.get('user_type') is not None:
            self.user_type = m.get('user_type')
        return self


class CarOrderQueryResponseBodyModulePriceInfoList(TeaModel):
    def __init__(self, category_code=None, gmt_create=None, pay_type=None, person_price=None, price=None,
                 trade_id=None, type=None):
        self.category_code = category_code  # type: int
        self.gmt_create = gmt_create  # type: long
        self.pay_type = pay_type  # type: int
        self.person_price = person_price  # type: long
        self.price = price  # type: long
        self.trade_id = trade_id  # type: str
        self.type = type  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(CarOrderQueryResponseBodyModulePriceInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category_code is not None:
            result['category_code'] = self.category_code
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.pay_type is not None:
            result['pay_type'] = self.pay_type
        if self.person_price is not None:
            result['person_price'] = self.person_price
        if self.price is not None:
            result['price'] = self.price
        if self.trade_id is not None:
            result['trade_id'] = self.trade_id
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('category_code') is not None:
            self.category_code = m.get('category_code')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('pay_type') is not None:
            self.pay_type = m.get('pay_type')
        if m.get('person_price') is not None:
            self.person_price = m.get('person_price')
        if m.get('price') is not None:
            self.price = m.get('price')
        if m.get('trade_id') is not None:
            self.trade_id = m.get('trade_id')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class CarOrderQueryResponseBodyModule(TeaModel):
    def __init__(self, car_info=None, invoice_info=None, order_base_info=None, passenger_list=None,
                 price_info_list=None):
        self.car_info = car_info  # type: CarOrderQueryResponseBodyModuleCarInfo
        self.invoice_info = invoice_info  # type: CarOrderQueryResponseBodyModuleInvoiceInfo
        self.order_base_info = order_base_info  # type: CarOrderQueryResponseBodyModuleOrderBaseInfo
        self.passenger_list = passenger_list  # type: list[CarOrderQueryResponseBodyModulePassengerList]
        self.price_info_list = price_info_list  # type: list[CarOrderQueryResponseBodyModulePriceInfoList]

    def validate(self):
        if self.car_info:
            self.car_info.validate()
        if self.invoice_info:
            self.invoice_info.validate()
        if self.order_base_info:
            self.order_base_info.validate()
        if self.passenger_list:
            for k in self.passenger_list:
                if k:
                    k.validate()
        if self.price_info_list:
            for k in self.price_info_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CarOrderQueryResponseBodyModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.car_info is not None:
            result['car_info'] = self.car_info.to_map()
        if self.invoice_info is not None:
            result['invoice_info'] = self.invoice_info.to_map()
        if self.order_base_info is not None:
            result['order_base_info'] = self.order_base_info.to_map()
        result['passenger_list'] = []
        if self.passenger_list is not None:
            for k in self.passenger_list:
                result['passenger_list'].append(k.to_map() if k else None)
        result['price_info_list'] = []
        if self.price_info_list is not None:
            for k in self.price_info_list:
                result['price_info_list'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('car_info') is not None:
            temp_model = CarOrderQueryResponseBodyModuleCarInfo()
            self.car_info = temp_model.from_map(m['car_info'])
        if m.get('invoice_info') is not None:
            temp_model = CarOrderQueryResponseBodyModuleInvoiceInfo()
            self.invoice_info = temp_model.from_map(m['invoice_info'])
        if m.get('order_base_info') is not None:
            temp_model = CarOrderQueryResponseBodyModuleOrderBaseInfo()
            self.order_base_info = temp_model.from_map(m['order_base_info'])
        self.passenger_list = []
        if m.get('passenger_list') is not None:
            for k in m.get('passenger_list'):
                temp_model = CarOrderQueryResponseBodyModulePassengerList()
                self.passenger_list.append(temp_model.from_map(k))
        self.price_info_list = []
        if m.get('price_info_list') is not None:
            for k in m.get('price_info_list'):
                temp_model = CarOrderQueryResponseBodyModulePriceInfoList()
                self.price_info_list.append(temp_model.from_map(k))
        return self


class CarOrderQueryResponseBody(TeaModel):
    def __init__(self, code=None, message=None, module=None, request_id=None, success=None, trace_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.module = module  # type: CarOrderQueryResponseBodyModule
        # requestId
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        # traceId
        self.trace_id = trace_id  # type: str

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super(CarOrderQueryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = CarOrderQueryResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class CarOrderQueryResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CarOrderQueryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CarOrderQueryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CarOrderQueryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CitySearchHeaders(TeaModel):
    def __init__(self, common_headers=None, x_acs_btrip_so_corp_token=None):
        self.common_headers = common_headers  # type: dict[str, str]
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CitySearchHeaders, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class CitySearchRequest(TeaModel):
    def __init__(self, keyword=None):
        self.keyword = keyword  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CitySearchRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.keyword is not None:
            result['keyword'] = self.keyword
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('keyword') is not None:
            self.keyword = m.get('keyword')
        return self


class CitySearchResponseBodyModuleCities(TeaModel):
    def __init__(self, code=None, name=None, region=None):
        self.code = code  # type: str
        self.name = name  # type: str
        self.region = region  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(CitySearchResponseBodyModuleCities, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.name is not None:
            result['name'] = self.name
        if self.region is not None:
            result['region'] = self.region
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('region') is not None:
            self.region = m.get('region')
        return self


class CitySearchResponseBodyModule(TeaModel):
    def __init__(self, cities=None):
        self.cities = cities  # type: list[CitySearchResponseBodyModuleCities]

    def validate(self):
        if self.cities:
            for k in self.cities:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CitySearchResponseBodyModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['cities'] = []
        if self.cities is not None:
            for k in self.cities:
                result['cities'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.cities = []
        if m.get('cities') is not None:
            for k in m.get('cities'):
                temp_model = CitySearchResponseBodyModuleCities()
                self.cities.append(temp_model.from_map(k))
        return self


class CitySearchResponseBody(TeaModel):
    def __init__(self, code=None, message=None, module=None, request_id=None, success=None, trace_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        # module
        self.module = module  # type: CitySearchResponseBodyModule
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.trace_id = trace_id  # type: str

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super(CitySearchResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = CitySearchResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class CitySearchResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CitySearchResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CitySearchResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CitySearchResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CommonApplyQueryHeaders(TeaModel):
    def __init__(self, common_headers=None, x_acs_btrip_so_corp_token=None):
        self.common_headers = common_headers  # type: dict[str, str]
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CommonApplyQueryHeaders, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class CommonApplyQueryRequest(TeaModel):
    def __init__(self, apply_id=None, biz_category=None, user_id=None):
        self.apply_id = apply_id  # type: long
        self.biz_category = biz_category  # type: int
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CommonApplyQueryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.biz_category is not None:
            result['biz_category'] = self.biz_category
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('biz_category') is not None:
            self.biz_category = m.get('biz_category')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class CommonApplyQueryResponseBodyModule(TeaModel):
    def __init__(self, apply_id=None, biz_category=None, cause=None, corp_id=None, extend_value=None,
                 gmt_create=None, status=None, thirdpart_corp_id=None, thirdpart_id=None, trip_cause=None, user_id=None):
        self.apply_id = apply_id  # type: long
        self.biz_category = biz_category  # type: int
        self.cause = cause  # type: str
        self.corp_id = corp_id  # type: str
        self.extend_value = extend_value  # type: str
        self.gmt_create = gmt_create  # type: str
        self.status = status  # type: int
        self.thirdpart_corp_id = thirdpart_corp_id  # type: str
        self.thirdpart_id = thirdpart_id  # type: str
        self.trip_cause = trip_cause  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CommonApplyQueryResponseBodyModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.biz_category is not None:
            result['biz_category'] = self.biz_category
        if self.cause is not None:
            result['cause'] = self.cause
        if self.corp_id is not None:
            result['corp_id'] = self.corp_id
        if self.extend_value is not None:
            result['extend_value'] = self.extend_value
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.status is not None:
            result['status'] = self.status
        if self.thirdpart_corp_id is not None:
            result['thirdpart_corp_id'] = self.thirdpart_corp_id
        if self.thirdpart_id is not None:
            result['thirdpart_id'] = self.thirdpart_id
        if self.trip_cause is not None:
            result['trip_cause'] = self.trip_cause
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('biz_category') is not None:
            self.biz_category = m.get('biz_category')
        if m.get('cause') is not None:
            self.cause = m.get('cause')
        if m.get('corp_id') is not None:
            self.corp_id = m.get('corp_id')
        if m.get('extend_value') is not None:
            self.extend_value = m.get('extend_value')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('thirdpart_corp_id') is not None:
            self.thirdpart_corp_id = m.get('thirdpart_corp_id')
        if m.get('thirdpart_id') is not None:
            self.thirdpart_id = m.get('thirdpart_id')
        if m.get('trip_cause') is not None:
            self.trip_cause = m.get('trip_cause')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class CommonApplyQueryResponseBody(TeaModel):
    def __init__(self, code=None, message=None, module=None, request_id=None, success=None, trace_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.module = module  # type: CommonApplyQueryResponseBodyModule
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.trace_id = trace_id  # type: str

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super(CommonApplyQueryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = CommonApplyQueryResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class CommonApplyQueryResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CommonApplyQueryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CommonApplyQueryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CommonApplyQueryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CommonApplySyncHeaders(TeaModel):
    def __init__(self, common_headers=None, x_acs_btrip_so_corp_token=None):
        self.common_headers = common_headers  # type: dict[str, str]
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CommonApplySyncHeaders, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class CommonApplySyncRequest(TeaModel):
    def __init__(self, apply_id=None, biz_category=None, remark=None, status=None, thirdparty_flow_id=None,
                 user_id=None):
        self.apply_id = apply_id  # type: long
        self.biz_category = biz_category  # type: int
        self.remark = remark  # type: str
        self.status = status  # type: int
        self.thirdparty_flow_id = thirdparty_flow_id  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CommonApplySyncRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.biz_category is not None:
            result['biz_category'] = self.biz_category
        if self.remark is not None:
            result['remark'] = self.remark
        if self.status is not None:
            result['status'] = self.status
        if self.thirdparty_flow_id is not None:
            result['thirdparty_flow_id'] = self.thirdparty_flow_id
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('biz_category') is not None:
            self.biz_category = m.get('biz_category')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('thirdparty_flow_id') is not None:
            self.thirdparty_flow_id = m.get('thirdparty_flow_id')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class CommonApplySyncResponseBody(TeaModel):
    def __init__(self, code=None, message=None, module=None, request_id=None, success=None, trace_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        # module。
        self.module = module  # type: bool
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.trace_id = trace_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CommonApplySyncResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            self.module = m.get('module')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class CommonApplySyncResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CommonApplySyncResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CommonApplySyncResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CommonApplySyncResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CorpAuthLinkInfoQueryResponseBodyModuleLinkCorps(TeaModel):
    def __init__(self, corp_name=None, open_corp_id=None, true_corp_id=None):
        self.corp_name = corp_name  # type: str
        self.open_corp_id = open_corp_id  # type: str
        self.true_corp_id = true_corp_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CorpAuthLinkInfoQueryResponseBodyModuleLinkCorps, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_name is not None:
            result['corp_name'] = self.corp_name
        if self.open_corp_id is not None:
            result['open_corp_id'] = self.open_corp_id
        if self.true_corp_id is not None:
            result['true_corp_id'] = self.true_corp_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('corp_name') is not None:
            self.corp_name = m.get('corp_name')
        if m.get('open_corp_id') is not None:
            self.open_corp_id = m.get('open_corp_id')
        if m.get('true_corp_id') is not None:
            self.true_corp_id = m.get('true_corp_id')
        return self


class CorpAuthLinkInfoQueryResponseBodyModuleOrgCorp(TeaModel):
    def __init__(self, corp_name=None, open_corp_id=None, true_corp_id=None):
        self.corp_name = corp_name  # type: str
        self.open_corp_id = open_corp_id  # type: str
        self.true_corp_id = true_corp_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CorpAuthLinkInfoQueryResponseBodyModuleOrgCorp, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_name is not None:
            result['corp_name'] = self.corp_name
        if self.open_corp_id is not None:
            result['open_corp_id'] = self.open_corp_id
        if self.true_corp_id is not None:
            result['true_corp_id'] = self.true_corp_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('corp_name') is not None:
            self.corp_name = m.get('corp_name')
        if m.get('open_corp_id') is not None:
            self.open_corp_id = m.get('open_corp_id')
        if m.get('true_corp_id') is not None:
            self.true_corp_id = m.get('true_corp_id')
        return self


class CorpAuthLinkInfoQueryResponseBodyModule(TeaModel):
    def __init__(self, link_corps=None, org_corp=None):
        self.link_corps = link_corps  # type: list[CorpAuthLinkInfoQueryResponseBodyModuleLinkCorps]
        self.org_corp = org_corp  # type: CorpAuthLinkInfoQueryResponseBodyModuleOrgCorp

    def validate(self):
        if self.link_corps:
            for k in self.link_corps:
                if k:
                    k.validate()
        if self.org_corp:
            self.org_corp.validate()

    def to_map(self):
        _map = super(CorpAuthLinkInfoQueryResponseBodyModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['link_corps'] = []
        if self.link_corps is not None:
            for k in self.link_corps:
                result['link_corps'].append(k.to_map() if k else None)
        if self.org_corp is not None:
            result['org_corp'] = self.org_corp.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.link_corps = []
        if m.get('link_corps') is not None:
            for k in m.get('link_corps'):
                temp_model = CorpAuthLinkInfoQueryResponseBodyModuleLinkCorps()
                self.link_corps.append(temp_model.from_map(k))
        if m.get('org_corp') is not None:
            temp_model = CorpAuthLinkInfoQueryResponseBodyModuleOrgCorp()
            self.org_corp = temp_model.from_map(m['org_corp'])
        return self


class CorpAuthLinkInfoQueryResponseBody(TeaModel):
    def __init__(self, code=None, message=None, module=None, request_id=None, trace_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.module = module  # type: CorpAuthLinkInfoQueryResponseBodyModule
        self.request_id = request_id  # type: str
        self.trace_id = trace_id  # type: str

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super(CorpAuthLinkInfoQueryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = CorpAuthLinkInfoQueryResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class CorpAuthLinkInfoQueryResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CorpAuthLinkInfoQueryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CorpAuthLinkInfoQueryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CorpAuthLinkInfoQueryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CorpTokenHeaders(TeaModel):
    def __init__(self, common_headers=None, x_acs_btrip_access_token=None):
        self.common_headers = common_headers  # type: dict[str, str]
        self.x_acs_btrip_access_token = x_acs_btrip_access_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CorpTokenHeaders, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_access_token is not None:
            result['x-acs-btrip-access-token'] = self.x_acs_btrip_access_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-access-token') is not None:
            self.x_acs_btrip_access_token = m.get('x-acs-btrip-access-token')
        return self


class CorpTokenRequest(TeaModel):
    def __init__(self, app_secret=None, corp_id=None, type=None):
        self.app_secret = app_secret  # type: str
        self.corp_id = corp_id  # type: str
        self.type = type  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(CorpTokenRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_secret is not None:
            result['app_secret'] = self.app_secret
        if self.corp_id is not None:
            result['corp_id'] = self.corp_id
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('app_secret') is not None:
            self.app_secret = m.get('app_secret')
        if m.get('corp_id') is not None:
            self.corp_id = m.get('corp_id')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class CorpTokenResponseBodyData(TeaModel):
    def __init__(self, expire=None, token=None):
        self.expire = expire  # type: long
        self.token = token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CorpTokenResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.expire is not None:
            result['expire'] = self.expire
        if self.token is not None:
            result['token'] = self.token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('expire') is not None:
            self.expire = m.get('expire')
        if m.get('token') is not None:
            self.token = m.get('token')
        return self


class CorpTokenResponseBodyModule(TeaModel):
    def __init__(self, expire=None, start=None, token=None):
        self.expire = expire  # type: long
        self.start = start  # type: long
        self.token = token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CorpTokenResponseBodyModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.expire is not None:
            result['expire'] = self.expire
        if self.start is not None:
            result['start'] = self.start
        if self.token is not None:
            result['token'] = self.token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('expire') is not None:
            self.expire = m.get('expire')
        if m.get('start') is not None:
            self.start = m.get('start')
        if m.get('token') is not None:
            self.token = m.get('token')
        return self


class CorpTokenResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, module=None, request_id=None, trace_id=None):
        self.code = code  # type: str
        self.data = data  # type: CorpTokenResponseBodyData
        self.message = message  # type: str
        self.module = module  # type: CorpTokenResponseBodyModule
        self.request_id = request_id  # type: str
        # traceId
        self.trace_id = trace_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super(CorpTokenResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.data is not None:
            result['data'] = self.data.to_map()
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('data') is not None:
            temp_model = CorpTokenResponseBodyData()
            self.data = temp_model.from_map(m['data'])
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = CorpTokenResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class CorpTokenResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CorpTokenResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CorpTokenResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CorpTokenResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CostCenterDeleteHeaders(TeaModel):
    def __init__(self, common_headers=None, x_acs_btrip_so_corp_token=None):
        self.common_headers = common_headers  # type: dict[str, str]
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CostCenterDeleteHeaders, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class CostCenterDeleteRequest(TeaModel):
    def __init__(self, thirdpart_id=None):
        self.thirdpart_id = thirdpart_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CostCenterDeleteRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.thirdpart_id is not None:
            result['thirdpart_id'] = self.thirdpart_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('thirdpart_id') is not None:
            self.thirdpart_id = m.get('thirdpart_id')
        return self


class CostCenterDeleteResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None, trace_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        # traceId
        self.trace_id = trace_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CostCenterDeleteResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class CostCenterDeleteResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CostCenterDeleteResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CostCenterDeleteResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CostCenterDeleteResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CostCenterModifyHeaders(TeaModel):
    def __init__(self, common_headers=None, x_acs_btrip_so_corp_token=None):
        self.common_headers = common_headers  # type: dict[str, str]
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CostCenterModifyHeaders, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class CostCenterModifyRequest(TeaModel):
    def __init__(self, alipay_no=None, number=None, scope=None, thirdpart_id=None, title=None):
        self.alipay_no = alipay_no  # type: str
        self.number = number  # type: str
        self.scope = scope  # type: long
        self.thirdpart_id = thirdpart_id  # type: str
        self.title = title  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CostCenterModifyRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alipay_no is not None:
            result['alipay_no'] = self.alipay_no
        if self.number is not None:
            result['number'] = self.number
        if self.scope is not None:
            result['scope'] = self.scope
        if self.thirdpart_id is not None:
            result['thirdpart_id'] = self.thirdpart_id
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('alipay_no') is not None:
            self.alipay_no = m.get('alipay_no')
        if m.get('number') is not None:
            self.number = m.get('number')
        if m.get('scope') is not None:
            self.scope = m.get('scope')
        if m.get('thirdpart_id') is not None:
            self.thirdpart_id = m.get('thirdpart_id')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class CostCenterModifyResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None, trace_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.trace_id = trace_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CostCenterModifyResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class CostCenterModifyResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CostCenterModifyResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CostCenterModifyResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CostCenterModifyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CostCenterQueryHeaders(TeaModel):
    def __init__(self, common_headers=None, x_acs_btrip_so_corp_token=None):
        self.common_headers = common_headers  # type: dict[str, str]
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CostCenterQueryHeaders, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class CostCenterQueryRequest(TeaModel):
    def __init__(self, need_org_entity=None, thirdpart_id=None, title=None, user_id=None):
        self.need_org_entity = need_org_entity  # type: bool
        self.thirdpart_id = thirdpart_id  # type: str
        self.title = title  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CostCenterQueryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.need_org_entity is not None:
            result['need_org_entity'] = self.need_org_entity
        if self.thirdpart_id is not None:
            result['thirdpart_id'] = self.thirdpart_id
        if self.title is not None:
            result['title'] = self.title
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('need_org_entity') is not None:
            self.need_org_entity = m.get('need_org_entity')
        if m.get('thirdpart_id') is not None:
            self.thirdpart_id = m.get('thirdpart_id')
        if m.get('title') is not None:
            self.title = m.get('title')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class CostCenterQueryResponseBodyModuleEntityDOS(TeaModel):
    def __init__(self, corp_id=None, entity_id=None, entity_type=None, name=None, user_num=None):
        self.corp_id = corp_id  # type: str
        self.entity_id = entity_id  # type: str
        self.entity_type = entity_type  # type: str
        self.name = name  # type: str
        self.user_num = user_num  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(CostCenterQueryResponseBodyModuleEntityDOS, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['corp_id'] = self.corp_id
        if self.entity_id is not None:
            result['entity_id'] = self.entity_id
        if self.entity_type is not None:
            result['entity_type'] = self.entity_type
        if self.name is not None:
            result['name'] = self.name
        if self.user_num is not None:
            result['user_num'] = self.user_num
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('corp_id') is not None:
            self.corp_id = m.get('corp_id')
        if m.get('entity_id') is not None:
            self.entity_id = m.get('entity_id')
        if m.get('entity_type') is not None:
            self.entity_type = m.get('entity_type')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('user_num') is not None:
            self.user_num = m.get('user_num')
        return self


class CostCenterQueryResponseBodyModule(TeaModel):
    def __init__(self, alipay_no=None, corp_id=None, entity_dos=None, id=None, number=None, rule_code=None,
                 scope=None, thirdpart_id=None, title=None):
        self.alipay_no = alipay_no  # type: str
        self.corp_id = corp_id  # type: str
        self.entity_dos = entity_dos  # type: list[CostCenterQueryResponseBodyModuleEntityDOS]
        self.id = id  # type: long
        self.number = number  # type: str
        # rule code
        self.rule_code = rule_code  # type: long
        self.scope = scope  # type: long
        self.thirdpart_id = thirdpart_id  # type: str
        self.title = title  # type: str

    def validate(self):
        if self.entity_dos:
            for k in self.entity_dos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CostCenterQueryResponseBodyModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alipay_no is not None:
            result['alipay_no'] = self.alipay_no
        if self.corp_id is not None:
            result['corp_id'] = self.corp_id
        result['entity_d_o_s'] = []
        if self.entity_dos is not None:
            for k in self.entity_dos:
                result['entity_d_o_s'].append(k.to_map() if k else None)
        if self.id is not None:
            result['id'] = self.id
        if self.number is not None:
            result['number'] = self.number
        if self.rule_code is not None:
            result['rule_code'] = self.rule_code
        if self.scope is not None:
            result['scope'] = self.scope
        if self.thirdpart_id is not None:
            result['thirdpart_id'] = self.thirdpart_id
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('alipay_no') is not None:
            self.alipay_no = m.get('alipay_no')
        if m.get('corp_id') is not None:
            self.corp_id = m.get('corp_id')
        self.entity_dos = []
        if m.get('entity_d_o_s') is not None:
            for k in m.get('entity_d_o_s'):
                temp_model = CostCenterQueryResponseBodyModuleEntityDOS()
                self.entity_dos.append(temp_model.from_map(k))
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('number') is not None:
            self.number = m.get('number')
        if m.get('rule_code') is not None:
            self.rule_code = m.get('rule_code')
        if m.get('scope') is not None:
            self.scope = m.get('scope')
        if m.get('thirdpart_id') is not None:
            self.thirdpart_id = m.get('thirdpart_id')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class CostCenterQueryResponseBody(TeaModel):
    def __init__(self, code=None, message=None, module=None, more_page=None, request_id=None, success=None,
                 trace_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.module = module  # type: list[CostCenterQueryResponseBodyModule]
        self.more_page = more_page  # type: bool
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        # traceId
        self.trace_id = trace_id  # type: str

    def validate(self):
        if self.module:
            for k in self.module:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CostCenterQueryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        result['module'] = []
        if self.module is not None:
            for k in self.module:
                result['module'].append(k.to_map() if k else None)
        if self.more_page is not None:
            result['more_page'] = self.more_page
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        self.module = []
        if m.get('module') is not None:
            for k in m.get('module'):
                temp_model = CostCenterQueryResponseBodyModule()
                self.module.append(temp_model.from_map(k))
        if m.get('more_page') is not None:
            self.more_page = m.get('more_page')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class CostCenterQueryResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CostCenterQueryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CostCenterQueryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CostCenterQueryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CostCenterSaveHeaders(TeaModel):
    def __init__(self, common_headers=None, x_acs_btrip_so_corp_token=None):
        self.common_headers = common_headers  # type: dict[str, str]
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CostCenterSaveHeaders, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class CostCenterSaveRequest(TeaModel):
    def __init__(self, alipay_no=None, number=None, scope=None, thirdpart_id=None, title=None):
        self.alipay_no = alipay_no  # type: str
        self.number = number  # type: str
        self.scope = scope  # type: long
        self.thirdpart_id = thirdpart_id  # type: str
        self.title = title  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CostCenterSaveRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alipay_no is not None:
            result['alipay_no'] = self.alipay_no
        if self.number is not None:
            result['number'] = self.number
        if self.scope is not None:
            result['scope'] = self.scope
        if self.thirdpart_id is not None:
            result['thirdpart_id'] = self.thirdpart_id
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('alipay_no') is not None:
            self.alipay_no = m.get('alipay_no')
        if m.get('number') is not None:
            self.number = m.get('number')
        if m.get('scope') is not None:
            self.scope = m.get('scope')
        if m.get('thirdpart_id') is not None:
            self.thirdpart_id = m.get('thirdpart_id')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class CostCenterSaveResponseBodyModule(TeaModel):
    def __init__(self, id=None):
        self.id = id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CostCenterSaveResponseBodyModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['id'] = self.id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        return self


class CostCenterSaveResponseBody(TeaModel):
    def __init__(self, code=None, message=None, module=None, request_id=None, success=None, trace_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.module = module  # type: CostCenterSaveResponseBodyModule
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        # traceId
        self.trace_id = trace_id  # type: str

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super(CostCenterSaveResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = CostCenterSaveResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class CostCenterSaveResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CostCenterSaveResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CostCenterSaveResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CostCenterSaveResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DepartmentSaveHeaders(TeaModel):
    def __init__(self, common_headers=None, x_acs_btrip_so_corp_token=None):
        self.common_headers = common_headers  # type: dict[str, str]
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DepartmentSaveHeaders, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class DepartmentSaveRequestDepartList(TeaModel):
    def __init__(self, depart_id=None, depart_name=None, depart_pid=None, manager_ids=None, status=None,
                 third_depart_id=None, third_depart_pid=None):
        self.depart_id = depart_id  # type: long
        self.depart_name = depart_name  # type: str
        self.depart_pid = depart_pid  # type: long
        self.manager_ids = manager_ids  # type: str
        self.status = status  # type: int
        self.third_depart_id = third_depart_id  # type: str
        self.third_depart_pid = third_depart_pid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DepartmentSaveRequestDepartList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.depart_id is not None:
            result['depart_id'] = self.depart_id
        if self.depart_name is not None:
            result['depart_name'] = self.depart_name
        if self.depart_pid is not None:
            result['depart_pid'] = self.depart_pid
        if self.manager_ids is not None:
            result['manager_ids'] = self.manager_ids
        if self.status is not None:
            result['status'] = self.status
        if self.third_depart_id is not None:
            result['third_depart_id'] = self.third_depart_id
        if self.third_depart_pid is not None:
            result['third_depart_pid'] = self.third_depart_pid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('depart_id') is not None:
            self.depart_id = m.get('depart_id')
        if m.get('depart_name') is not None:
            self.depart_name = m.get('depart_name')
        if m.get('depart_pid') is not None:
            self.depart_pid = m.get('depart_pid')
        if m.get('manager_ids') is not None:
            self.manager_ids = m.get('manager_ids')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('third_depart_id') is not None:
            self.third_depart_id = m.get('third_depart_id')
        if m.get('third_depart_pid') is not None:
            self.third_depart_pid = m.get('third_depart_pid')
        return self


class DepartmentSaveRequest(TeaModel):
    def __init__(self, depart_list=None):
        self.depart_list = depart_list  # type: list[DepartmentSaveRequestDepartList]

    def validate(self):
        if self.depart_list:
            for k in self.depart_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DepartmentSaveRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['depart_list'] = []
        if self.depart_list is not None:
            for k in self.depart_list:
                result['depart_list'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.depart_list = []
        if m.get('depart_list') is not None:
            for k in m.get('depart_list'):
                temp_model = DepartmentSaveRequestDepartList()
                self.depart_list.append(temp_model.from_map(k))
        return self


class DepartmentSaveShrinkRequest(TeaModel):
    def __init__(self, depart_list_shrink=None):
        self.depart_list_shrink = depart_list_shrink  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DepartmentSaveShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.depart_list_shrink is not None:
            result['depart_list'] = self.depart_list_shrink
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('depart_list') is not None:
            self.depart_list_shrink = m.get('depart_list')
        return self


class DepartmentSaveResponseBody(TeaModel):
    def __init__(self, code=None, message=None, module=None, request_id=None, success=None, trace_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.module = module  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        # traceId
        self.trace_id = trace_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DepartmentSaveResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            self.module = m.get('module')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class DepartmentSaveResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DepartmentSaveResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DepartmentSaveResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DepartmentSaveResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EntityAddHeaders(TeaModel):
    def __init__(self, common_headers=None, x_acs_btrip_so_corp_token=None):
        self.common_headers = common_headers  # type: dict[str, str]
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(EntityAddHeaders, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class EntityAddRequestEntityDOList(TeaModel):
    def __init__(self, entity_id=None, entity_type=None):
        self.entity_id = entity_id  # type: str
        self.entity_type = entity_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(EntityAddRequestEntityDOList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.entity_id is not None:
            result['entity_id'] = self.entity_id
        if self.entity_type is not None:
            result['entity_type'] = self.entity_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('entity_id') is not None:
            self.entity_id = m.get('entity_id')
        if m.get('entity_type') is not None:
            self.entity_type = m.get('entity_type')
        return self


class EntityAddRequest(TeaModel):
    def __init__(self, entity_dolist=None, thirdpart_id=None):
        self.entity_dolist = entity_dolist  # type: list[EntityAddRequestEntityDOList]
        self.thirdpart_id = thirdpart_id  # type: str

    def validate(self):
        if self.entity_dolist:
            for k in self.entity_dolist:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(EntityAddRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['entity_d_o_list'] = []
        if self.entity_dolist is not None:
            for k in self.entity_dolist:
                result['entity_d_o_list'].append(k.to_map() if k else None)
        if self.thirdpart_id is not None:
            result['thirdpart_id'] = self.thirdpart_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.entity_dolist = []
        if m.get('entity_d_o_list') is not None:
            for k in m.get('entity_d_o_list'):
                temp_model = EntityAddRequestEntityDOList()
                self.entity_dolist.append(temp_model.from_map(k))
        if m.get('thirdpart_id') is not None:
            self.thirdpart_id = m.get('thirdpart_id')
        return self


class EntityAddShrinkRequest(TeaModel):
    def __init__(self, entity_dolist_shrink=None, thirdpart_id=None):
        self.entity_dolist_shrink = entity_dolist_shrink  # type: str
        self.thirdpart_id = thirdpart_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(EntityAddShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.entity_dolist_shrink is not None:
            result['entity_d_o_list'] = self.entity_dolist_shrink
        if self.thirdpart_id is not None:
            result['thirdpart_id'] = self.thirdpart_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('entity_d_o_list') is not None:
            self.entity_dolist_shrink = m.get('entity_d_o_list')
        if m.get('thirdpart_id') is not None:
            self.thirdpart_id = m.get('thirdpart_id')
        return self


class EntityAddResponseBodyModule(TeaModel):
    def __init__(self, add_num=None, selected_user_num=None):
        self.add_num = add_num  # type: int
        self.selected_user_num = selected_user_num  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(EntityAddResponseBodyModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.add_num is not None:
            result['add_num'] = self.add_num
        if self.selected_user_num is not None:
            result['selected_user_num'] = self.selected_user_num
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('add_num') is not None:
            self.add_num = m.get('add_num')
        if m.get('selected_user_num') is not None:
            self.selected_user_num = m.get('selected_user_num')
        return self


class EntityAddResponseBody(TeaModel):
    def __init__(self, code=None, message=None, module=None, request_id=None, success=None, trace_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.module = module  # type: EntityAddResponseBodyModule
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        # traceId
        self.trace_id = trace_id  # type: str

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super(EntityAddResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = EntityAddResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class EntityAddResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: EntityAddResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(EntityAddResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = EntityAddResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EntityDeleteHeaders(TeaModel):
    def __init__(self, common_headers=None, x_acs_btrip_so_corp_token=None):
        self.common_headers = common_headers  # type: dict[str, str]
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(EntityDeleteHeaders, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class EntityDeleteRequestEntityDOList(TeaModel):
    def __init__(self, entity_id=None, entity_type=None):
        self.entity_id = entity_id  # type: str
        self.entity_type = entity_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(EntityDeleteRequestEntityDOList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.entity_id is not None:
            result['entity_id'] = self.entity_id
        if self.entity_type is not None:
            result['entity_type'] = self.entity_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('entity_id') is not None:
            self.entity_id = m.get('entity_id')
        if m.get('entity_type') is not None:
            self.entity_type = m.get('entity_type')
        return self


class EntityDeleteRequest(TeaModel):
    def __init__(self, del_all=None, entity_dolist=None, thirdpart_id=None):
        self.del_all = del_all  # type: bool
        self.entity_dolist = entity_dolist  # type: list[EntityDeleteRequestEntityDOList]
        self.thirdpart_id = thirdpart_id  # type: str

    def validate(self):
        if self.entity_dolist:
            for k in self.entity_dolist:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(EntityDeleteRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.del_all is not None:
            result['del_all'] = self.del_all
        result['entity_d_o_list'] = []
        if self.entity_dolist is not None:
            for k in self.entity_dolist:
                result['entity_d_o_list'].append(k.to_map() if k else None)
        if self.thirdpart_id is not None:
            result['thirdpart_id'] = self.thirdpart_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('del_all') is not None:
            self.del_all = m.get('del_all')
        self.entity_dolist = []
        if m.get('entity_d_o_list') is not None:
            for k in m.get('entity_d_o_list'):
                temp_model = EntityDeleteRequestEntityDOList()
                self.entity_dolist.append(temp_model.from_map(k))
        if m.get('thirdpart_id') is not None:
            self.thirdpart_id = m.get('thirdpart_id')
        return self


class EntityDeleteShrinkRequest(TeaModel):
    def __init__(self, del_all=None, entity_dolist_shrink=None, thirdpart_id=None):
        self.del_all = del_all  # type: bool
        self.entity_dolist_shrink = entity_dolist_shrink  # type: str
        self.thirdpart_id = thirdpart_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(EntityDeleteShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.del_all is not None:
            result['del_all'] = self.del_all
        if self.entity_dolist_shrink is not None:
            result['entity_d_o_list'] = self.entity_dolist_shrink
        if self.thirdpart_id is not None:
            result['thirdpart_id'] = self.thirdpart_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('del_all') is not None:
            self.del_all = m.get('del_all')
        if m.get('entity_d_o_list') is not None:
            self.entity_dolist_shrink = m.get('entity_d_o_list')
        if m.get('thirdpart_id') is not None:
            self.thirdpart_id = m.get('thirdpart_id')
        return self


class EntityDeleteResponseBodyModule(TeaModel):
    def __init__(self, remove_num=None, selected_user_num=None):
        self.remove_num = remove_num  # type: int
        self.selected_user_num = selected_user_num  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(EntityDeleteResponseBodyModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.remove_num is not None:
            result['remove_num'] = self.remove_num
        if self.selected_user_num is not None:
            result['selected_user_num'] = self.selected_user_num
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('remove_num') is not None:
            self.remove_num = m.get('remove_num')
        if m.get('selected_user_num') is not None:
            self.selected_user_num = m.get('selected_user_num')
        return self


class EntityDeleteResponseBody(TeaModel):
    def __init__(self, code=None, message=None, module=None, more_page=None, request_id=None, success=None,
                 trace_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.module = module  # type: EntityDeleteResponseBodyModule
        self.more_page = more_page  # type: bool
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        # traceId
        self.trace_id = trace_id  # type: str

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super(EntityDeleteResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.more_page is not None:
            result['more_page'] = self.more_page
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = EntityDeleteResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('more_page') is not None:
            self.more_page = m.get('more_page')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class EntityDeleteResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: EntityDeleteResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(EntityDeleteResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = EntityDeleteResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EntitySetHeaders(TeaModel):
    def __init__(self, common_headers=None, x_acs_btrip_so_corp_token=None):
        self.common_headers = common_headers  # type: dict[str, str]
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(EntitySetHeaders, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class EntitySetRequestEntityDOList(TeaModel):
    def __init__(self, entity_id=None, entity_type=None):
        self.entity_id = entity_id  # type: str
        self.entity_type = entity_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(EntitySetRequestEntityDOList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.entity_id is not None:
            result['entity_id'] = self.entity_id
        if self.entity_type is not None:
            result['entity_type'] = self.entity_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('entity_id') is not None:
            self.entity_id = m.get('entity_id')
        if m.get('entity_type') is not None:
            self.entity_type = m.get('entity_type')
        return self


class EntitySetRequest(TeaModel):
    def __init__(self, entity_dolist=None, thirdpart_id=None):
        self.entity_dolist = entity_dolist  # type: list[EntitySetRequestEntityDOList]
        self.thirdpart_id = thirdpart_id  # type: str

    def validate(self):
        if self.entity_dolist:
            for k in self.entity_dolist:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(EntitySetRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['entity_d_o_list'] = []
        if self.entity_dolist is not None:
            for k in self.entity_dolist:
                result['entity_d_o_list'].append(k.to_map() if k else None)
        if self.thirdpart_id is not None:
            result['thirdpart_id'] = self.thirdpart_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.entity_dolist = []
        if m.get('entity_d_o_list') is not None:
            for k in m.get('entity_d_o_list'):
                temp_model = EntitySetRequestEntityDOList()
                self.entity_dolist.append(temp_model.from_map(k))
        if m.get('thirdpart_id') is not None:
            self.thirdpart_id = m.get('thirdpart_id')
        return self


class EntitySetShrinkRequest(TeaModel):
    def __init__(self, entity_dolist_shrink=None, thirdpart_id=None):
        self.entity_dolist_shrink = entity_dolist_shrink  # type: str
        self.thirdpart_id = thirdpart_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(EntitySetShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.entity_dolist_shrink is not None:
            result['entity_d_o_list'] = self.entity_dolist_shrink
        if self.thirdpart_id is not None:
            result['thirdpart_id'] = self.thirdpart_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('entity_d_o_list') is not None:
            self.entity_dolist_shrink = m.get('entity_d_o_list')
        if m.get('thirdpart_id') is not None:
            self.thirdpart_id = m.get('thirdpart_id')
        return self


class EntitySetResponseBodyModule(TeaModel):
    def __init__(self, add_num=None, remove_num=None, selected_user_num=None):
        self.add_num = add_num  # type: int
        self.remove_num = remove_num  # type: int
        self.selected_user_num = selected_user_num  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(EntitySetResponseBodyModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.add_num is not None:
            result['add_num'] = self.add_num
        if self.remove_num is not None:
            result['remove_num'] = self.remove_num
        if self.selected_user_num is not None:
            result['selected_user_num'] = self.selected_user_num
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('add_num') is not None:
            self.add_num = m.get('add_num')
        if m.get('remove_num') is not None:
            self.remove_num = m.get('remove_num')
        if m.get('selected_user_num') is not None:
            self.selected_user_num = m.get('selected_user_num')
        return self


class EntitySetResponseBody(TeaModel):
    def __init__(self, code=None, message=None, module=None, more_page=None, request_id=None, success=None,
                 trace_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.module = module  # type: EntitySetResponseBodyModule
        self.more_page = more_page  # type: bool
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        # traceId
        self.trace_id = trace_id  # type: str

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super(EntitySetResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.more_page is not None:
            result['more_page'] = self.more_page
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = EntitySetResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('more_page') is not None:
            self.more_page = m.get('more_page')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class EntitySetResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: EntitySetResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(EntitySetResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = EntitySetResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EstimatedPriceQueryHeaders(TeaModel):
    def __init__(self, common_headers=None, x_acs_btrip_so_corp_token=None):
        self.common_headers = common_headers  # type: dict[str, str]
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(EstimatedPriceQueryHeaders, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class EstimatedPriceQueryRequest(TeaModel):
    def __init__(self, arr_city=None, category=None, dep_city=None, end_time=None, itinerary_id=None,
                 start_time=None, sub_corp_id=None, user_id=None):
        self.arr_city = arr_city  # type: str
        self.category = category  # type: str
        self.dep_city = dep_city  # type: str
        self.end_time = end_time  # type: long
        self.itinerary_id = itinerary_id  # type: str
        self.start_time = start_time  # type: long
        self.sub_corp_id = sub_corp_id  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(EstimatedPriceQueryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arr_city is not None:
            result['arr_city'] = self.arr_city
        if self.category is not None:
            result['category'] = self.category
        if self.dep_city is not None:
            result['dep_city'] = self.dep_city
        if self.end_time is not None:
            result['end_time'] = self.end_time
        if self.itinerary_id is not None:
            result['itinerary_id'] = self.itinerary_id
        if self.start_time is not None:
            result['start_time'] = self.start_time
        if self.sub_corp_id is not None:
            result['sub_corp_id'] = self.sub_corp_id
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('arr_city') is not None:
            self.arr_city = m.get('arr_city')
        if m.get('category') is not None:
            self.category = m.get('category')
        if m.get('dep_city') is not None:
            self.dep_city = m.get('dep_city')
        if m.get('end_time') is not None:
            self.end_time = m.get('end_time')
        if m.get('itinerary_id') is not None:
            self.itinerary_id = m.get('itinerary_id')
        if m.get('start_time') is not None:
            self.start_time = m.get('start_time')
        if m.get('sub_corp_id') is not None:
            self.sub_corp_id = m.get('sub_corp_id')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class EstimatedPriceQueryResponseBodyModuleHotelFeeDetail(TeaModel):
    def __init__(self, city=None, criterion=None, itinerary_id=None, total=None, trip_days=None):
        self.city = city  # type: str
        self.criterion = criterion  # type: long
        self.itinerary_id = itinerary_id  # type: str
        self.total = total  # type: long
        self.trip_days = trip_days  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(EstimatedPriceQueryResponseBodyModuleHotelFeeDetail, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city is not None:
            result['city'] = self.city
        if self.criterion is not None:
            result['criterion'] = self.criterion
        if self.itinerary_id is not None:
            result['itinerary_id'] = self.itinerary_id
        if self.total is not None:
            result['total'] = self.total
        if self.trip_days is not None:
            result['trip_days'] = self.trip_days
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('city') is not None:
            self.city = m.get('city')
        if m.get('criterion') is not None:
            self.criterion = m.get('criterion')
        if m.get('itinerary_id') is not None:
            self.itinerary_id = m.get('itinerary_id')
        if m.get('total') is not None:
            self.total = m.get('total')
        if m.get('trip_days') is not None:
            self.trip_days = m.get('trip_days')
        return self


class EstimatedPriceQueryResponseBodyModuleTrafficFeeBtripRoutesCheapest(TeaModel):
    def __init__(self, arr_time=None, dep_time=None, fee=None, seat_grade=None, vehicle_no=None):
        self.arr_time = arr_time  # type: str
        self.dep_time = dep_time  # type: str
        self.fee = fee  # type: long
        self.seat_grade = seat_grade  # type: str
        self.vehicle_no = vehicle_no  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(EstimatedPriceQueryResponseBodyModuleTrafficFeeBtripRoutesCheapest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arr_time is not None:
            result['arr_time'] = self.arr_time
        if self.dep_time is not None:
            result['dep_time'] = self.dep_time
        if self.fee is not None:
            result['fee'] = self.fee
        if self.seat_grade is not None:
            result['seat_grade'] = self.seat_grade
        if self.vehicle_no is not None:
            result['vehicle_no'] = self.vehicle_no
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('arr_time') is not None:
            self.arr_time = m.get('arr_time')
        if m.get('dep_time') is not None:
            self.dep_time = m.get('dep_time')
        if m.get('fee') is not None:
            self.fee = m.get('fee')
        if m.get('seat_grade') is not None:
            self.seat_grade = m.get('seat_grade')
        if m.get('vehicle_no') is not None:
            self.vehicle_no = m.get('vehicle_no')
        return self


class EstimatedPriceQueryResponseBodyModuleTrafficFeeBtripRoutesMostExpensive(TeaModel):
    def __init__(self, arr_time=None, dep_time=None, fee=None, seat_grade=None, vehicle_no=None):
        self.arr_time = arr_time  # type: str
        self.dep_time = dep_time  # type: str
        self.fee = fee  # type: long
        self.seat_grade = seat_grade  # type: str
        self.vehicle_no = vehicle_no  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(EstimatedPriceQueryResponseBodyModuleTrafficFeeBtripRoutesMostExpensive, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arr_time is not None:
            result['arr_time'] = self.arr_time
        if self.dep_time is not None:
            result['dep_time'] = self.dep_time
        if self.fee is not None:
            result['fee'] = self.fee
        if self.seat_grade is not None:
            result['seat_grade'] = self.seat_grade
        if self.vehicle_no is not None:
            result['vehicle_no'] = self.vehicle_no
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('arr_time') is not None:
            self.arr_time = m.get('arr_time')
        if m.get('dep_time') is not None:
            self.dep_time = m.get('dep_time')
        if m.get('fee') is not None:
            self.fee = m.get('fee')
        if m.get('seat_grade') is not None:
            self.seat_grade = m.get('seat_grade')
        if m.get('vehicle_no') is not None:
            self.vehicle_no = m.get('vehicle_no')
        return self


class EstimatedPriceQueryResponseBodyModuleTrafficFeeBtripRoutes(TeaModel):
    def __init__(self, arr_city=None, arr_date=None, cheapest=None, dep_city=None, dep_date=None, err_msg=None,
                 itinerary_id=None, most_expensive=None, success=None):
        self.arr_city = arr_city  # type: str
        self.arr_date = arr_date  # type: long
        # cheapest
        self.cheapest = cheapest  # type: EstimatedPriceQueryResponseBodyModuleTrafficFeeBtripRoutesCheapest
        self.dep_city = dep_city  # type: str
        self.dep_date = dep_date  # type: long
        self.err_msg = err_msg  # type: str
        self.itinerary_id = itinerary_id  # type: str
        self.most_expensive = most_expensive  # type: EstimatedPriceQueryResponseBodyModuleTrafficFeeBtripRoutesMostExpensive
        self.success = success  # type: bool

    def validate(self):
        if self.cheapest:
            self.cheapest.validate()
        if self.most_expensive:
            self.most_expensive.validate()

    def to_map(self):
        _map = super(EstimatedPriceQueryResponseBodyModuleTrafficFeeBtripRoutes, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arr_city is not None:
            result['arr_city'] = self.arr_city
        if self.arr_date is not None:
            result['arr_date'] = self.arr_date
        if self.cheapest is not None:
            result['cheapest'] = self.cheapest.to_map()
        if self.dep_city is not None:
            result['dep_city'] = self.dep_city
        if self.dep_date is not None:
            result['dep_date'] = self.dep_date
        if self.err_msg is not None:
            result['err_msg'] = self.err_msg
        if self.itinerary_id is not None:
            result['itinerary_id'] = self.itinerary_id
        if self.most_expensive is not None:
            result['most_expensive'] = self.most_expensive.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('arr_city') is not None:
            self.arr_city = m.get('arr_city')
        if m.get('arr_date') is not None:
            self.arr_date = m.get('arr_date')
        if m.get('cheapest') is not None:
            temp_model = EstimatedPriceQueryResponseBodyModuleTrafficFeeBtripRoutesCheapest()
            self.cheapest = temp_model.from_map(m['cheapest'])
        if m.get('dep_city') is not None:
            self.dep_city = m.get('dep_city')
        if m.get('dep_date') is not None:
            self.dep_date = m.get('dep_date')
        if m.get('err_msg') is not None:
            self.err_msg = m.get('err_msg')
        if m.get('itinerary_id') is not None:
            self.itinerary_id = m.get('itinerary_id')
        if m.get('most_expensive') is not None:
            temp_model = EstimatedPriceQueryResponseBodyModuleTrafficFeeBtripRoutesMostExpensive()
            self.most_expensive = temp_model.from_map(m['most_expensive'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class EstimatedPriceQueryResponseBodyModuleTrafficFee(TeaModel):
    def __init__(self, btrip_routes=None, err_msg=None, max_fee=None, min_fee=None, success=None):
        self.btrip_routes = btrip_routes  # type: list[EstimatedPriceQueryResponseBodyModuleTrafficFeeBtripRoutes]
        self.err_msg = err_msg  # type: str
        self.max_fee = max_fee  # type: long
        self.min_fee = min_fee  # type: long
        self.success = success  # type: bool

    def validate(self):
        if self.btrip_routes:
            for k in self.btrip_routes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(EstimatedPriceQueryResponseBodyModuleTrafficFee, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['btrip_routes'] = []
        if self.btrip_routes is not None:
            for k in self.btrip_routes:
                result['btrip_routes'].append(k.to_map() if k else None)
        if self.err_msg is not None:
            result['err_msg'] = self.err_msg
        if self.max_fee is not None:
            result['max_fee'] = self.max_fee
        if self.min_fee is not None:
            result['min_fee'] = self.min_fee
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.btrip_routes = []
        if m.get('btrip_routes') is not None:
            for k in m.get('btrip_routes'):
                temp_model = EstimatedPriceQueryResponseBodyModuleTrafficFeeBtripRoutes()
                self.btrip_routes.append(temp_model.from_map(k))
        if m.get('err_msg') is not None:
            self.err_msg = m.get('err_msg')
        if m.get('max_fee') is not None:
            self.max_fee = m.get('max_fee')
        if m.get('min_fee') is not None:
            self.min_fee = m.get('min_fee')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class EstimatedPriceQueryResponseBodyModule(TeaModel):
    def __init__(self, hotel_fee_detail=None, total_hotel_fee=None, traffic_fee=None):
        self.hotel_fee_detail = hotel_fee_detail  # type: list[EstimatedPriceQueryResponseBodyModuleHotelFeeDetail]
        self.total_hotel_fee = total_hotel_fee  # type: long
        self.traffic_fee = traffic_fee  # type: EstimatedPriceQueryResponseBodyModuleTrafficFee

    def validate(self):
        if self.hotel_fee_detail:
            for k in self.hotel_fee_detail:
                if k:
                    k.validate()
        if self.traffic_fee:
            self.traffic_fee.validate()

    def to_map(self):
        _map = super(EstimatedPriceQueryResponseBodyModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['hotel_fee_detail'] = []
        if self.hotel_fee_detail is not None:
            for k in self.hotel_fee_detail:
                result['hotel_fee_detail'].append(k.to_map() if k else None)
        if self.total_hotel_fee is not None:
            result['total_hotel_fee'] = self.total_hotel_fee
        if self.traffic_fee is not None:
            result['traffic_fee'] = self.traffic_fee.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.hotel_fee_detail = []
        if m.get('hotel_fee_detail') is not None:
            for k in m.get('hotel_fee_detail'):
                temp_model = EstimatedPriceQueryResponseBodyModuleHotelFeeDetail()
                self.hotel_fee_detail.append(temp_model.from_map(k))
        if m.get('total_hotel_fee') is not None:
            self.total_hotel_fee = m.get('total_hotel_fee')
        if m.get('traffic_fee') is not None:
            temp_model = EstimatedPriceQueryResponseBodyModuleTrafficFee()
            self.traffic_fee = temp_model.from_map(m['traffic_fee'])
        return self


class EstimatedPriceQueryResponseBody(TeaModel):
    def __init__(self, code=None, message=None, module=None, request_id=None, success=None, trace_id=None):
        self.code = code  # type: int
        self.message = message  # type: str
        self.module = module  # type: EstimatedPriceQueryResponseBodyModule
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        # traceId
        self.trace_id = trace_id  # type: str

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super(EstimatedPriceQueryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = EstimatedPriceQueryResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class EstimatedPriceQueryResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: EstimatedPriceQueryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(EstimatedPriceQueryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = EstimatedPriceQueryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ExceedApplySyncHeaders(TeaModel):
    def __init__(self, common_headers=None, x_acs_btrip_so_corp_token=None):
        self.common_headers = common_headers  # type: dict[str, str]
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ExceedApplySyncHeaders, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class ExceedApplySyncRequest(TeaModel):
    def __init__(self, apply_id=None, biz_category=None, remark=None, status=None, thirdparty_flow_id=None,
                 user_id=None):
        self.apply_id = apply_id  # type: long
        self.biz_category = biz_category  # type: int
        self.remark = remark  # type: str
        self.status = status  # type: int
        self.thirdparty_flow_id = thirdparty_flow_id  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ExceedApplySyncRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.biz_category is not None:
            result['biz_category'] = self.biz_category
        if self.remark is not None:
            result['remark'] = self.remark
        if self.status is not None:
            result['status'] = self.status
        if self.thirdparty_flow_id is not None:
            result['thirdparty_flow_id'] = self.thirdparty_flow_id
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('biz_category') is not None:
            self.biz_category = m.get('biz_category')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('thirdparty_flow_id') is not None:
            self.thirdparty_flow_id = m.get('thirdparty_flow_id')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class ExceedApplySyncResponseBody(TeaModel):
    def __init__(self, code=None, message=None, module=None, request_id=None, success=None, trace_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        # module。
        self.module = module  # type: bool
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.trace_id = trace_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ExceedApplySyncResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            self.module = m.get('module')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class ExceedApplySyncResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ExceedApplySyncResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ExceedApplySyncResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ExceedApplySyncResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class FlightBillSettlementQueryHeaders(TeaModel):
    def __init__(self, common_headers=None, x_acs_btrip_so_corp_token=None):
        self.common_headers = common_headers  # type: dict[str, str]
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightBillSettlementQueryHeaders, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class FlightBillSettlementQueryRequest(TeaModel):
    def __init__(self, page_no=None, page_size=None, period_end=None, period_start=None):
        self.page_no = page_no  # type: int
        self.page_size = page_size  # type: int
        self.period_end = period_end  # type: str
        self.period_start = period_start  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightBillSettlementQueryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_no is not None:
            result['page_no'] = self.page_no
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.period_end is not None:
            result['period_end'] = self.period_end
        if self.period_start is not None:
            result['period_start'] = self.period_start
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('page_no') is not None:
            self.page_no = m.get('page_no')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('period_end') is not None:
            self.period_end = m.get('period_end')
        if m.get('period_start') is not None:
            self.period_start = m.get('period_start')
        return self


class FlightBillSettlementQueryResponseBodyModuleDataList(TeaModel):
    def __init__(self, advance_day=None, airline_corp_code=None, airline_corp_name=None, alipay_trade_no=None,
                 apply_id=None, arr_airport_code=None, arr_city=None, arr_date=None, arr_station=None, arr_time=None,
                 bill_record_time=None, book_time=None, booker_id=None, booker_job_no=None, booker_name=None, btrip_coupon_fee=None,
                 build_fee=None, cabin=None, cabin_class=None, capital_direction=None, cascade_department=None,
                 change_fee=None, corp_pay_order_fee=None, cost_center=None, cost_center_number=None, coupon=None,
                 dep_airport_code=None, department=None, department_id=None, dept_city=None, dept_date=None, dept_station=None,
                 dept_time=None, discount=None, fee_type=None, flight_no=None, index=None, insurance_fee=None,
                 invoice_title=None, itinerary_num=None, itinerary_price=None, most_difference_dept_time=None,
                 most_difference_discount=None, most_difference_flight_no=None, most_difference_price=None, most_difference_reason=None,
                 most_price=None, negotiation_coupon_fee=None, oil_fee=None, order_id=None, over_apply_id=None,
                 primary_id=None, project_code=None, project_name=None, refund_fee=None, refund_upgrade_cost=None, remark=None,
                 repeat_refund=None, seal_price=None, service_fee=None, settlement_fee=None, settlement_grant_fee=None,
                 settlement_time=None, settlement_type=None, status=None, ticket_id=None, traveler_id=None, traveler_job_no=None,
                 traveler_name=None, upgrade_cost=None, voucher_type=None):
        self.advance_day = advance_day  # type: int
        self.airline_corp_code = airline_corp_code  # type: str
        self.airline_corp_name = airline_corp_name  # type: str
        self.alipay_trade_no = alipay_trade_no  # type: str
        self.apply_id = apply_id  # type: str
        self.arr_airport_code = arr_airport_code  # type: str
        self.arr_city = arr_city  # type: str
        self.arr_date = arr_date  # type: str
        self.arr_station = arr_station  # type: str
        self.arr_time = arr_time  # type: str
        self.bill_record_time = bill_record_time  # type: str
        self.book_time = book_time  # type: str
        self.booker_id = booker_id  # type: str
        self.booker_job_no = booker_job_no  # type: str
        self.booker_name = booker_name  # type: str
        self.btrip_coupon_fee = btrip_coupon_fee  # type: float
        self.build_fee = build_fee  # type: float
        self.cabin = cabin  # type: str
        self.cabin_class = cabin_class  # type: str
        self.capital_direction = capital_direction  # type: str
        self.cascade_department = cascade_department  # type: str
        self.change_fee = change_fee  # type: float
        self.corp_pay_order_fee = corp_pay_order_fee  # type: float
        self.cost_center = cost_center  # type: str
        self.cost_center_number = cost_center_number  # type: str
        self.coupon = coupon  # type: float
        self.dep_airport_code = dep_airport_code  # type: str
        self.department = department  # type: str
        self.department_id = department_id  # type: str
        self.dept_city = dept_city  # type: str
        self.dept_date = dept_date  # type: str
        self.dept_station = dept_station  # type: str
        self.dept_time = dept_time  # type: str
        self.discount = discount  # type: str
        self.fee_type = fee_type  # type: str
        self.flight_no = flight_no  # type: str
        self.index = index  # type: str
        self.insurance_fee = insurance_fee  # type: float
        self.invoice_title = invoice_title  # type: str
        self.itinerary_num = itinerary_num  # type: str
        self.itinerary_price = itinerary_price  # type: float
        self.most_difference_dept_time = most_difference_dept_time  # type: str
        self.most_difference_discount = most_difference_discount  # type: str
        self.most_difference_flight_no = most_difference_flight_no  # type: str
        self.most_difference_price = most_difference_price  # type: float
        self.most_difference_reason = most_difference_reason  # type: str
        self.most_price = most_price  # type: float
        self.negotiation_coupon_fee = negotiation_coupon_fee  # type: float
        self.oil_fee = oil_fee  # type: float
        self.order_id = order_id  # type: str
        self.over_apply_id = over_apply_id  # type: str
        self.primary_id = primary_id  # type: long
        self.project_code = project_code  # type: str
        self.project_name = project_name  # type: str
        self.refund_fee = refund_fee  # type: float
        self.refund_upgrade_cost = refund_upgrade_cost  # type: float
        self.remark = remark  # type: str
        self.repeat_refund = repeat_refund  # type: str
        self.seal_price = seal_price  # type: float
        self.service_fee = service_fee  # type: float
        self.settlement_fee = settlement_fee  # type: float
        self.settlement_grant_fee = settlement_grant_fee  # type: float
        self.settlement_time = settlement_time  # type: str
        self.settlement_type = settlement_type  # type: str
        self.status = status  # type: int
        self.ticket_id = ticket_id  # type: str
        self.traveler_id = traveler_id  # type: str
        self.traveler_job_no = traveler_job_no  # type: str
        self.traveler_name = traveler_name  # type: str
        self.upgrade_cost = upgrade_cost  # type: float
        self.voucher_type = voucher_type  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightBillSettlementQueryResponseBodyModuleDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.advance_day is not None:
            result['advance_day'] = self.advance_day
        if self.airline_corp_code is not None:
            result['airline_corp_code'] = self.airline_corp_code
        if self.airline_corp_name is not None:
            result['airline_corp_name'] = self.airline_corp_name
        if self.alipay_trade_no is not None:
            result['alipay_trade_no'] = self.alipay_trade_no
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.arr_airport_code is not None:
            result['arr_airport_code'] = self.arr_airport_code
        if self.arr_city is not None:
            result['arr_city'] = self.arr_city
        if self.arr_date is not None:
            result['arr_date'] = self.arr_date
        if self.arr_station is not None:
            result['arr_station'] = self.arr_station
        if self.arr_time is not None:
            result['arr_time'] = self.arr_time
        if self.bill_record_time is not None:
            result['bill_record_time'] = self.bill_record_time
        if self.book_time is not None:
            result['book_time'] = self.book_time
        if self.booker_id is not None:
            result['booker_id'] = self.booker_id
        if self.booker_job_no is not None:
            result['booker_job_no'] = self.booker_job_no
        if self.booker_name is not None:
            result['booker_name'] = self.booker_name
        if self.btrip_coupon_fee is not None:
            result['btrip_coupon_fee'] = self.btrip_coupon_fee
        if self.build_fee is not None:
            result['build_fee'] = self.build_fee
        if self.cabin is not None:
            result['cabin'] = self.cabin
        if self.cabin_class is not None:
            result['cabin_class'] = self.cabin_class
        if self.capital_direction is not None:
            result['capital_direction'] = self.capital_direction
        if self.cascade_department is not None:
            result['cascade_department'] = self.cascade_department
        if self.change_fee is not None:
            result['change_fee'] = self.change_fee
        if self.corp_pay_order_fee is not None:
            result['corp_pay_order_fee'] = self.corp_pay_order_fee
        if self.cost_center is not None:
            result['cost_center'] = self.cost_center
        if self.cost_center_number is not None:
            result['cost_center_number'] = self.cost_center_number
        if self.coupon is not None:
            result['coupon'] = self.coupon
        if self.dep_airport_code is not None:
            result['dep_airport_code'] = self.dep_airport_code
        if self.department is not None:
            result['department'] = self.department
        if self.department_id is not None:
            result['department_id'] = self.department_id
        if self.dept_city is not None:
            result['dept_city'] = self.dept_city
        if self.dept_date is not None:
            result['dept_date'] = self.dept_date
        if self.dept_station is not None:
            result['dept_station'] = self.dept_station
        if self.dept_time is not None:
            result['dept_time'] = self.dept_time
        if self.discount is not None:
            result['discount'] = self.discount
        if self.fee_type is not None:
            result['fee_type'] = self.fee_type
        if self.flight_no is not None:
            result['flight_no'] = self.flight_no
        if self.index is not None:
            result['index'] = self.index
        if self.insurance_fee is not None:
            result['insurance_fee'] = self.insurance_fee
        if self.invoice_title is not None:
            result['invoice_title'] = self.invoice_title
        if self.itinerary_num is not None:
            result['itinerary_num'] = self.itinerary_num
        if self.itinerary_price is not None:
            result['itinerary_price'] = self.itinerary_price
        if self.most_difference_dept_time is not None:
            result['most_difference_dept_time'] = self.most_difference_dept_time
        if self.most_difference_discount is not None:
            result['most_difference_discount'] = self.most_difference_discount
        if self.most_difference_flight_no is not None:
            result['most_difference_flight_no'] = self.most_difference_flight_no
        if self.most_difference_price is not None:
            result['most_difference_price'] = self.most_difference_price
        if self.most_difference_reason is not None:
            result['most_difference_reason'] = self.most_difference_reason
        if self.most_price is not None:
            result['most_price'] = self.most_price
        if self.negotiation_coupon_fee is not None:
            result['negotiation_coupon_fee'] = self.negotiation_coupon_fee
        if self.oil_fee is not None:
            result['oil_fee'] = self.oil_fee
        if self.order_id is not None:
            result['order_id'] = self.order_id
        if self.over_apply_id is not None:
            result['over_apply_id'] = self.over_apply_id
        if self.primary_id is not None:
            result['primary_id'] = self.primary_id
        if self.project_code is not None:
            result['project_code'] = self.project_code
        if self.project_name is not None:
            result['project_name'] = self.project_name
        if self.refund_fee is not None:
            result['refund_fee'] = self.refund_fee
        if self.refund_upgrade_cost is not None:
            result['refund_upgrade_cost'] = self.refund_upgrade_cost
        if self.remark is not None:
            result['remark'] = self.remark
        if self.repeat_refund is not None:
            result['repeat_refund'] = self.repeat_refund
        if self.seal_price is not None:
            result['seal_price'] = self.seal_price
        if self.service_fee is not None:
            result['service_fee'] = self.service_fee
        if self.settlement_fee is not None:
            result['settlement_fee'] = self.settlement_fee
        if self.settlement_grant_fee is not None:
            result['settlement_grant_fee'] = self.settlement_grant_fee
        if self.settlement_time is not None:
            result['settlement_time'] = self.settlement_time
        if self.settlement_type is not None:
            result['settlement_type'] = self.settlement_type
        if self.status is not None:
            result['status'] = self.status
        if self.ticket_id is not None:
            result['ticket_id'] = self.ticket_id
        if self.traveler_id is not None:
            result['traveler_id'] = self.traveler_id
        if self.traveler_job_no is not None:
            result['traveler_job_no'] = self.traveler_job_no
        if self.traveler_name is not None:
            result['traveler_name'] = self.traveler_name
        if self.upgrade_cost is not None:
            result['upgrade_cost'] = self.upgrade_cost
        if self.voucher_type is not None:
            result['voucher_type'] = self.voucher_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('advance_day') is not None:
            self.advance_day = m.get('advance_day')
        if m.get('airline_corp_code') is not None:
            self.airline_corp_code = m.get('airline_corp_code')
        if m.get('airline_corp_name') is not None:
            self.airline_corp_name = m.get('airline_corp_name')
        if m.get('alipay_trade_no') is not None:
            self.alipay_trade_no = m.get('alipay_trade_no')
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('arr_airport_code') is not None:
            self.arr_airport_code = m.get('arr_airport_code')
        if m.get('arr_city') is not None:
            self.arr_city = m.get('arr_city')
        if m.get('arr_date') is not None:
            self.arr_date = m.get('arr_date')
        if m.get('arr_station') is not None:
            self.arr_station = m.get('arr_station')
        if m.get('arr_time') is not None:
            self.arr_time = m.get('arr_time')
        if m.get('bill_record_time') is not None:
            self.bill_record_time = m.get('bill_record_time')
        if m.get('book_time') is not None:
            self.book_time = m.get('book_time')
        if m.get('booker_id') is not None:
            self.booker_id = m.get('booker_id')
        if m.get('booker_job_no') is not None:
            self.booker_job_no = m.get('booker_job_no')
        if m.get('booker_name') is not None:
            self.booker_name = m.get('booker_name')
        if m.get('btrip_coupon_fee') is not None:
            self.btrip_coupon_fee = m.get('btrip_coupon_fee')
        if m.get('build_fee') is not None:
            self.build_fee = m.get('build_fee')
        if m.get('cabin') is not None:
            self.cabin = m.get('cabin')
        if m.get('cabin_class') is not None:
            self.cabin_class = m.get('cabin_class')
        if m.get('capital_direction') is not None:
            self.capital_direction = m.get('capital_direction')
        if m.get('cascade_department') is not None:
            self.cascade_department = m.get('cascade_department')
        if m.get('change_fee') is not None:
            self.change_fee = m.get('change_fee')
        if m.get('corp_pay_order_fee') is not None:
            self.corp_pay_order_fee = m.get('corp_pay_order_fee')
        if m.get('cost_center') is not None:
            self.cost_center = m.get('cost_center')
        if m.get('cost_center_number') is not None:
            self.cost_center_number = m.get('cost_center_number')
        if m.get('coupon') is not None:
            self.coupon = m.get('coupon')
        if m.get('dep_airport_code') is not None:
            self.dep_airport_code = m.get('dep_airport_code')
        if m.get('department') is not None:
            self.department = m.get('department')
        if m.get('department_id') is not None:
            self.department_id = m.get('department_id')
        if m.get('dept_city') is not None:
            self.dept_city = m.get('dept_city')
        if m.get('dept_date') is not None:
            self.dept_date = m.get('dept_date')
        if m.get('dept_station') is not None:
            self.dept_station = m.get('dept_station')
        if m.get('dept_time') is not None:
            self.dept_time = m.get('dept_time')
        if m.get('discount') is not None:
            self.discount = m.get('discount')
        if m.get('fee_type') is not None:
            self.fee_type = m.get('fee_type')
        if m.get('flight_no') is not None:
            self.flight_no = m.get('flight_no')
        if m.get('index') is not None:
            self.index = m.get('index')
        if m.get('insurance_fee') is not None:
            self.insurance_fee = m.get('insurance_fee')
        if m.get('invoice_title') is not None:
            self.invoice_title = m.get('invoice_title')
        if m.get('itinerary_num') is not None:
            self.itinerary_num = m.get('itinerary_num')
        if m.get('itinerary_price') is not None:
            self.itinerary_price = m.get('itinerary_price')
        if m.get('most_difference_dept_time') is not None:
            self.most_difference_dept_time = m.get('most_difference_dept_time')
        if m.get('most_difference_discount') is not None:
            self.most_difference_discount = m.get('most_difference_discount')
        if m.get('most_difference_flight_no') is not None:
            self.most_difference_flight_no = m.get('most_difference_flight_no')
        if m.get('most_difference_price') is not None:
            self.most_difference_price = m.get('most_difference_price')
        if m.get('most_difference_reason') is not None:
            self.most_difference_reason = m.get('most_difference_reason')
        if m.get('most_price') is not None:
            self.most_price = m.get('most_price')
        if m.get('negotiation_coupon_fee') is not None:
            self.negotiation_coupon_fee = m.get('negotiation_coupon_fee')
        if m.get('oil_fee') is not None:
            self.oil_fee = m.get('oil_fee')
        if m.get('order_id') is not None:
            self.order_id = m.get('order_id')
        if m.get('over_apply_id') is not None:
            self.over_apply_id = m.get('over_apply_id')
        if m.get('primary_id') is not None:
            self.primary_id = m.get('primary_id')
        if m.get('project_code') is not None:
            self.project_code = m.get('project_code')
        if m.get('project_name') is not None:
            self.project_name = m.get('project_name')
        if m.get('refund_fee') is not None:
            self.refund_fee = m.get('refund_fee')
        if m.get('refund_upgrade_cost') is not None:
            self.refund_upgrade_cost = m.get('refund_upgrade_cost')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        if m.get('repeat_refund') is not None:
            self.repeat_refund = m.get('repeat_refund')
        if m.get('seal_price') is not None:
            self.seal_price = m.get('seal_price')
        if m.get('service_fee') is not None:
            self.service_fee = m.get('service_fee')
        if m.get('settlement_fee') is not None:
            self.settlement_fee = m.get('settlement_fee')
        if m.get('settlement_grant_fee') is not None:
            self.settlement_grant_fee = m.get('settlement_grant_fee')
        if m.get('settlement_time') is not None:
            self.settlement_time = m.get('settlement_time')
        if m.get('settlement_type') is not None:
            self.settlement_type = m.get('settlement_type')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('ticket_id') is not None:
            self.ticket_id = m.get('ticket_id')
        if m.get('traveler_id') is not None:
            self.traveler_id = m.get('traveler_id')
        if m.get('traveler_job_no') is not None:
            self.traveler_job_no = m.get('traveler_job_no')
        if m.get('traveler_name') is not None:
            self.traveler_name = m.get('traveler_name')
        if m.get('upgrade_cost') is not None:
            self.upgrade_cost = m.get('upgrade_cost')
        if m.get('voucher_type') is not None:
            self.voucher_type = m.get('voucher_type')
        return self


class FlightBillSettlementQueryResponseBodyModule(TeaModel):
    def __init__(self, category=None, corp_id=None, data_list=None, period_end=None, period_start=None,
                 total_num=None):
        self.category = category  # type: int
        self.corp_id = corp_id  # type: str
        self.data_list = data_list  # type: list[FlightBillSettlementQueryResponseBodyModuleDataList]
        self.period_end = period_end  # type: str
        self.period_start = period_start  # type: str
        self.total_num = total_num  # type: long

    def validate(self):
        if self.data_list:
            for k in self.data_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(FlightBillSettlementQueryResponseBodyModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['category'] = self.category
        if self.corp_id is not None:
            result['corp_id'] = self.corp_id
        result['data_list'] = []
        if self.data_list is not None:
            for k in self.data_list:
                result['data_list'].append(k.to_map() if k else None)
        if self.period_end is not None:
            result['period_end'] = self.period_end
        if self.period_start is not None:
            result['period_start'] = self.period_start
        if self.total_num is not None:
            result['total_num'] = self.total_num
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('category') is not None:
            self.category = m.get('category')
        if m.get('corp_id') is not None:
            self.corp_id = m.get('corp_id')
        self.data_list = []
        if m.get('data_list') is not None:
            for k in m.get('data_list'):
                temp_model = FlightBillSettlementQueryResponseBodyModuleDataList()
                self.data_list.append(temp_model.from_map(k))
        if m.get('period_end') is not None:
            self.period_end = m.get('period_end')
        if m.get('period_start') is not None:
            self.period_start = m.get('period_start')
        if m.get('total_num') is not None:
            self.total_num = m.get('total_num')
        return self


class FlightBillSettlementQueryResponseBody(TeaModel):
    def __init__(self, code=None, message=None, module=None, request_id=None, success=None, trace_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.module = module  # type: FlightBillSettlementQueryResponseBodyModule
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.trace_id = trace_id  # type: str

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super(FlightBillSettlementQueryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = FlightBillSettlementQueryResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class FlightBillSettlementQueryResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: FlightBillSettlementQueryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(FlightBillSettlementQueryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = FlightBillSettlementQueryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class FlightCancelOrderHeaders(TeaModel):
    def __init__(self, common_headers=None, x_acs_btrip_corp_token=None):
        self.common_headers = common_headers  # type: dict[str, str]
        self.x_acs_btrip_corp_token = x_acs_btrip_corp_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightCancelOrderHeaders, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_corp_token is not None:
            result['x-acs-btrip-corp-token'] = self.x_acs_btrip_corp_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-corp-token') is not None:
            self.x_acs_btrip_corp_token = m.get('x-acs-btrip-corp-token')
        return self


class FlightCancelOrderRequest(TeaModel):
    def __init__(self, dis_order_id=None):
        self.dis_order_id = dis_order_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightCancelOrderRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dis_order_id is not None:
            result['dis_order_id'] = self.dis_order_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('dis_order_id') is not None:
            self.dis_order_id = m.get('dis_order_id')
        return self


class FlightCancelOrderResponseBodyModule(TeaModel):
    def __init__(self, cancel_time=None, fail_code=None, fail_reason=None, order_status=None):
        self.cancel_time = cancel_time  # type: str
        self.fail_code = fail_code  # type: str
        self.fail_reason = fail_reason  # type: str
        self.order_status = order_status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightCancelOrderResponseBodyModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cancel_time is not None:
            result['cancel_time'] = self.cancel_time
        if self.fail_code is not None:
            result['fail_code'] = self.fail_code
        if self.fail_reason is not None:
            result['fail_reason'] = self.fail_reason
        if self.order_status is not None:
            result['order_status'] = self.order_status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('cancel_time') is not None:
            self.cancel_time = m.get('cancel_time')
        if m.get('fail_code') is not None:
            self.fail_code = m.get('fail_code')
        if m.get('fail_reason') is not None:
            self.fail_reason = m.get('fail_reason')
        if m.get('order_status') is not None:
            self.order_status = m.get('order_status')
        return self


class FlightCancelOrderResponseBody(TeaModel):
    def __init__(self, code=None, message=None, module=None, request_id=None, success=None, trace_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.module = module  # type: FlightCancelOrderResponseBodyModule
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.trace_id = trace_id  # type: str

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super(FlightCancelOrderResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = FlightCancelOrderResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class FlightCancelOrderResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: FlightCancelOrderResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(FlightCancelOrderResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = FlightCancelOrderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class FlightCreateOrderHeaders(TeaModel):
    def __init__(self, common_headers=None, x_acs_btrip_corp_token=None):
        self.common_headers = common_headers  # type: dict[str, str]
        self.x_acs_btrip_corp_token = x_acs_btrip_corp_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightCreateOrderHeaders, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_corp_token is not None:
            result['x-acs-btrip-corp-token'] = self.x_acs_btrip_corp_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-corp-token') is not None:
            self.x_acs_btrip_corp_token = m.get('x-acs-btrip-corp-token')
        return self


class FlightCreateOrderRequestContactInfo(TeaModel):
    def __init__(self, contact_email=None, contact_name=None, contact_phone=None):
        self.contact_email = contact_email  # type: str
        self.contact_name = contact_name  # type: str
        self.contact_phone = contact_phone  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightCreateOrderRequestContactInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_email is not None:
            result['contact_email'] = self.contact_email
        if self.contact_name is not None:
            result['contact_name'] = self.contact_name
        if self.contact_phone is not None:
            result['contact_phone'] = self.contact_phone
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('contact_email') is not None:
            self.contact_email = m.get('contact_email')
        if m.get('contact_name') is not None:
            self.contact_name = m.get('contact_name')
        if m.get('contact_phone') is not None:
            self.contact_phone = m.get('contact_phone')
        return self


class FlightCreateOrderRequestTravelerInfoList(TeaModel):
    def __init__(self, birthday=None, cert_nation=None, cert_no=None, cert_type=None, cert_valid_date=None,
                 name=None, out_user_id=None, phone=None, sex=None, type=None):
        self.birthday = birthday  # type: str
        self.cert_nation = cert_nation  # type: str
        self.cert_no = cert_no  # type: str
        self.cert_type = cert_type  # type: str
        self.cert_valid_date = cert_valid_date  # type: str
        self.name = name  # type: str
        self.out_user_id = out_user_id  # type: str
        self.phone = phone  # type: str
        self.sex = sex  # type: int
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightCreateOrderRequestTravelerInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.birthday is not None:
            result['birthday'] = self.birthday
        if self.cert_nation is not None:
            result['cert_nation'] = self.cert_nation
        if self.cert_no is not None:
            result['cert_no'] = self.cert_no
        if self.cert_type is not None:
            result['cert_type'] = self.cert_type
        if self.cert_valid_date is not None:
            result['cert_valid_date'] = self.cert_valid_date
        if self.name is not None:
            result['name'] = self.name
        if self.out_user_id is not None:
            result['out_user_id'] = self.out_user_id
        if self.phone is not None:
            result['phone'] = self.phone
        if self.sex is not None:
            result['sex'] = self.sex
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('birthday') is not None:
            self.birthday = m.get('birthday')
        if m.get('cert_nation') is not None:
            self.cert_nation = m.get('cert_nation')
        if m.get('cert_no') is not None:
            self.cert_no = m.get('cert_no')
        if m.get('cert_type') is not None:
            self.cert_type = m.get('cert_type')
        if m.get('cert_valid_date') is not None:
            self.cert_valid_date = m.get('cert_valid_date')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('out_user_id') is not None:
            self.out_user_id = m.get('out_user_id')
        if m.get('phone') is not None:
            self.phone = m.get('phone')
        if m.get('sex') is not None:
            self.sex = m.get('sex')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class FlightCreateOrderRequest(TeaModel):
    def __init__(self, arr_airport_code=None, arr_city_code=None, auto_pay=None, buyer_name=None,
                 buyer_unique_key=None, contact_info=None, dep_airport_code=None, dep_city_code=None, dep_date=None,
                 dis_order_id=None, order_attr=None, order_params=None, ota_item_id=None, price=None, receipt_address=None,
                 receipt_target=None, receipt_title=None, traveler_info_list=None, trip_type=None):
        self.arr_airport_code = arr_airport_code  # type: str
        self.arr_city_code = arr_city_code  # type: str
        self.auto_pay = auto_pay  # type: int
        self.buyer_name = buyer_name  # type: str
        self.buyer_unique_key = buyer_unique_key  # type: str
        self.contact_info = contact_info  # type: FlightCreateOrderRequestContactInfo
        self.dep_airport_code = dep_airport_code  # type: str
        self.dep_city_code = dep_city_code  # type: str
        self.dep_date = dep_date  # type: str
        self.dis_order_id = dis_order_id  # type: str
        self.order_attr = order_attr  # type: dict[str, any]
        self.order_params = order_params  # type: str
        self.ota_item_id = ota_item_id  # type: str
        self.price = price  # type: long
        self.receipt_address = receipt_address  # type: str
        self.receipt_target = receipt_target  # type: int
        self.receipt_title = receipt_title  # type: str
        self.traveler_info_list = traveler_info_list  # type: list[FlightCreateOrderRequestTravelerInfoList]
        self.trip_type = trip_type  # type: int

    def validate(self):
        if self.contact_info:
            self.contact_info.validate()
        if self.traveler_info_list:
            for k in self.traveler_info_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(FlightCreateOrderRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arr_airport_code is not None:
            result['arr_airport_code'] = self.arr_airport_code
        if self.arr_city_code is not None:
            result['arr_city_code'] = self.arr_city_code
        if self.auto_pay is not None:
            result['auto_pay'] = self.auto_pay
        if self.buyer_name is not None:
            result['buyer_name'] = self.buyer_name
        if self.buyer_unique_key is not None:
            result['buyer_unique_key'] = self.buyer_unique_key
        if self.contact_info is not None:
            result['contact_info'] = self.contact_info.to_map()
        if self.dep_airport_code is not None:
            result['dep_airport_code'] = self.dep_airport_code
        if self.dep_city_code is not None:
            result['dep_city_code'] = self.dep_city_code
        if self.dep_date is not None:
            result['dep_date'] = self.dep_date
        if self.dis_order_id is not None:
            result['dis_order_id'] = self.dis_order_id
        if self.order_attr is not None:
            result['order_attr'] = self.order_attr
        if self.order_params is not None:
            result['order_params'] = self.order_params
        if self.ota_item_id is not None:
            result['ota_item_id'] = self.ota_item_id
        if self.price is not None:
            result['price'] = self.price
        if self.receipt_address is not None:
            result['receipt_address'] = self.receipt_address
        if self.receipt_target is not None:
            result['receipt_target'] = self.receipt_target
        if self.receipt_title is not None:
            result['receipt_title'] = self.receipt_title
        result['traveler_info_list'] = []
        if self.traveler_info_list is not None:
            for k in self.traveler_info_list:
                result['traveler_info_list'].append(k.to_map() if k else None)
        if self.trip_type is not None:
            result['trip_type'] = self.trip_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('arr_airport_code') is not None:
            self.arr_airport_code = m.get('arr_airport_code')
        if m.get('arr_city_code') is not None:
            self.arr_city_code = m.get('arr_city_code')
        if m.get('auto_pay') is not None:
            self.auto_pay = m.get('auto_pay')
        if m.get('buyer_name') is not None:
            self.buyer_name = m.get('buyer_name')
        if m.get('buyer_unique_key') is not None:
            self.buyer_unique_key = m.get('buyer_unique_key')
        if m.get('contact_info') is not None:
            temp_model = FlightCreateOrderRequestContactInfo()
            self.contact_info = temp_model.from_map(m['contact_info'])
        if m.get('dep_airport_code') is not None:
            self.dep_airport_code = m.get('dep_airport_code')
        if m.get('dep_city_code') is not None:
            self.dep_city_code = m.get('dep_city_code')
        if m.get('dep_date') is not None:
            self.dep_date = m.get('dep_date')
        if m.get('dis_order_id') is not None:
            self.dis_order_id = m.get('dis_order_id')
        if m.get('order_attr') is not None:
            self.order_attr = m.get('order_attr')
        if m.get('order_params') is not None:
            self.order_params = m.get('order_params')
        if m.get('ota_item_id') is not None:
            self.ota_item_id = m.get('ota_item_id')
        if m.get('price') is not None:
            self.price = m.get('price')
        if m.get('receipt_address') is not None:
            self.receipt_address = m.get('receipt_address')
        if m.get('receipt_target') is not None:
            self.receipt_target = m.get('receipt_target')
        if m.get('receipt_title') is not None:
            self.receipt_title = m.get('receipt_title')
        self.traveler_info_list = []
        if m.get('traveler_info_list') is not None:
            for k in m.get('traveler_info_list'):
                temp_model = FlightCreateOrderRequestTravelerInfoList()
                self.traveler_info_list.append(temp_model.from_map(k))
        if m.get('trip_type') is not None:
            self.trip_type = m.get('trip_type')
        return self


class FlightCreateOrderShrinkRequest(TeaModel):
    def __init__(self, arr_airport_code=None, arr_city_code=None, auto_pay=None, buyer_name=None,
                 buyer_unique_key=None, contact_info_shrink=None, dep_airport_code=None, dep_city_code=None, dep_date=None,
                 dis_order_id=None, order_attr_shrink=None, order_params=None, ota_item_id=None, price=None,
                 receipt_address=None, receipt_target=None, receipt_title=None, traveler_info_list_shrink=None, trip_type=None):
        self.arr_airport_code = arr_airport_code  # type: str
        self.arr_city_code = arr_city_code  # type: str
        self.auto_pay = auto_pay  # type: int
        self.buyer_name = buyer_name  # type: str
        self.buyer_unique_key = buyer_unique_key  # type: str
        self.contact_info_shrink = contact_info_shrink  # type: str
        self.dep_airport_code = dep_airport_code  # type: str
        self.dep_city_code = dep_city_code  # type: str
        self.dep_date = dep_date  # type: str
        self.dis_order_id = dis_order_id  # type: str
        self.order_attr_shrink = order_attr_shrink  # type: str
        self.order_params = order_params  # type: str
        self.ota_item_id = ota_item_id  # type: str
        self.price = price  # type: long
        self.receipt_address = receipt_address  # type: str
        self.receipt_target = receipt_target  # type: int
        self.receipt_title = receipt_title  # type: str
        self.traveler_info_list_shrink = traveler_info_list_shrink  # type: str
        self.trip_type = trip_type  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightCreateOrderShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arr_airport_code is not None:
            result['arr_airport_code'] = self.arr_airport_code
        if self.arr_city_code is not None:
            result['arr_city_code'] = self.arr_city_code
        if self.auto_pay is not None:
            result['auto_pay'] = self.auto_pay
        if self.buyer_name is not None:
            result['buyer_name'] = self.buyer_name
        if self.buyer_unique_key is not None:
            result['buyer_unique_key'] = self.buyer_unique_key
        if self.contact_info_shrink is not None:
            result['contact_info'] = self.contact_info_shrink
        if self.dep_airport_code is not None:
            result['dep_airport_code'] = self.dep_airport_code
        if self.dep_city_code is not None:
            result['dep_city_code'] = self.dep_city_code
        if self.dep_date is not None:
            result['dep_date'] = self.dep_date
        if self.dis_order_id is not None:
            result['dis_order_id'] = self.dis_order_id
        if self.order_attr_shrink is not None:
            result['order_attr'] = self.order_attr_shrink
        if self.order_params is not None:
            result['order_params'] = self.order_params
        if self.ota_item_id is not None:
            result['ota_item_id'] = self.ota_item_id
        if self.price is not None:
            result['price'] = self.price
        if self.receipt_address is not None:
            result['receipt_address'] = self.receipt_address
        if self.receipt_target is not None:
            result['receipt_target'] = self.receipt_target
        if self.receipt_title is not None:
            result['receipt_title'] = self.receipt_title
        if self.traveler_info_list_shrink is not None:
            result['traveler_info_list'] = self.traveler_info_list_shrink
        if self.trip_type is not None:
            result['trip_type'] = self.trip_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('arr_airport_code') is not None:
            self.arr_airport_code = m.get('arr_airport_code')
        if m.get('arr_city_code') is not None:
            self.arr_city_code = m.get('arr_city_code')
        if m.get('auto_pay') is not None:
            self.auto_pay = m.get('auto_pay')
        if m.get('buyer_name') is not None:
            self.buyer_name = m.get('buyer_name')
        if m.get('buyer_unique_key') is not None:
            self.buyer_unique_key = m.get('buyer_unique_key')
        if m.get('contact_info') is not None:
            self.contact_info_shrink = m.get('contact_info')
        if m.get('dep_airport_code') is not None:
            self.dep_airport_code = m.get('dep_airport_code')
        if m.get('dep_city_code') is not None:
            self.dep_city_code = m.get('dep_city_code')
        if m.get('dep_date') is not None:
            self.dep_date = m.get('dep_date')
        if m.get('dis_order_id') is not None:
            self.dis_order_id = m.get('dis_order_id')
        if m.get('order_attr') is not None:
            self.order_attr_shrink = m.get('order_attr')
        if m.get('order_params') is not None:
            self.order_params = m.get('order_params')
        if m.get('ota_item_id') is not None:
            self.ota_item_id = m.get('ota_item_id')
        if m.get('price') is not None:
            self.price = m.get('price')
        if m.get('receipt_address') is not None:
            self.receipt_address = m.get('receipt_address')
        if m.get('receipt_target') is not None:
            self.receipt_target = m.get('receipt_target')
        if m.get('receipt_title') is not None:
            self.receipt_title = m.get('receipt_title')
        if m.get('traveler_info_list') is not None:
            self.traveler_info_list_shrink = m.get('traveler_info_list')
        if m.get('trip_type') is not None:
            self.trip_type = m.get('trip_type')
        return self


class FlightCreateOrderResponseBodyModule(TeaModel):
    def __init__(self, alipay_trade_no=None, btrip_order_id=None, dis_order_id=None, last_pay_time=None,
                 order_status=None, pay_status=None, payment_price=None, total_price=None):
        self.alipay_trade_no = alipay_trade_no  # type: str
        self.btrip_order_id = btrip_order_id  # type: long
        self.dis_order_id = dis_order_id  # type: str
        self.last_pay_time = last_pay_time  # type: str
        self.order_status = order_status  # type: int
        self.pay_status = pay_status  # type: int
        self.payment_price = payment_price  # type: long
        self.total_price = total_price  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightCreateOrderResponseBodyModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alipay_trade_no is not None:
            result['alipay_trade_no'] = self.alipay_trade_no
        if self.btrip_order_id is not None:
            result['btrip_order_id'] = self.btrip_order_id
        if self.dis_order_id is not None:
            result['dis_order_id'] = self.dis_order_id
        if self.last_pay_time is not None:
            result['last_pay_time'] = self.last_pay_time
        if self.order_status is not None:
            result['order_status'] = self.order_status
        if self.pay_status is not None:
            result['pay_status'] = self.pay_status
        if self.payment_price is not None:
            result['payment_price'] = self.payment_price
        if self.total_price is not None:
            result['total_price'] = self.total_price
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('alipay_trade_no') is not None:
            self.alipay_trade_no = m.get('alipay_trade_no')
        if m.get('btrip_order_id') is not None:
            self.btrip_order_id = m.get('btrip_order_id')
        if m.get('dis_order_id') is not None:
            self.dis_order_id = m.get('dis_order_id')
        if m.get('last_pay_time') is not None:
            self.last_pay_time = m.get('last_pay_time')
        if m.get('order_status') is not None:
            self.order_status = m.get('order_status')
        if m.get('pay_status') is not None:
            self.pay_status = m.get('pay_status')
        if m.get('payment_price') is not None:
            self.payment_price = m.get('payment_price')
        if m.get('total_price') is not None:
            self.total_price = m.get('total_price')
        return self


class FlightCreateOrderResponseBody(TeaModel):
    def __init__(self, code=None, message=None, module=None, request_id=None, success=None, trace_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.module = module  # type: FlightCreateOrderResponseBodyModule
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.trace_id = trace_id  # type: str

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super(FlightCreateOrderResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = FlightCreateOrderResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class FlightCreateOrderResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: FlightCreateOrderResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(FlightCreateOrderResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = FlightCreateOrderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class FlightExceedApplyQueryHeaders(TeaModel):
    def __init__(self, common_headers=None, x_acs_btrip_so_corp_token=None):
        self.common_headers = common_headers  # type: dict[str, str]
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightExceedApplyQueryHeaders, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class FlightExceedApplyQueryRequest(TeaModel):
    def __init__(self, apply_id=None):
        self.apply_id = apply_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightExceedApplyQueryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        return self


class FlightExceedApplyQueryResponseBodyModuleApplyIntentionInfoDo(TeaModel):
    def __init__(self, arr_city=None, arr_city_name=None, arr_time=None, cabin=None, cabin_class=None,
                 cabin_class_str=None, dep_city=None, dep_city_name=None, dep_time=None, discount=None, flight_no=None, price=None,
                 type=None):
        self.arr_city = arr_city  # type: str
        self.arr_city_name = arr_city_name  # type: str
        self.arr_time = arr_time  # type: str
        self.cabin = cabin  # type: str
        self.cabin_class = cabin_class  # type: int
        self.cabin_class_str = cabin_class_str  # type: str
        self.dep_city = dep_city  # type: str
        self.dep_city_name = dep_city_name  # type: str
        self.dep_time = dep_time  # type: str
        self.discount = discount  # type: str
        self.flight_no = flight_no  # type: str
        self.price = price  # type: long
        self.type = type  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightExceedApplyQueryResponseBodyModuleApplyIntentionInfoDo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arr_city is not None:
            result['arr_city'] = self.arr_city
        if self.arr_city_name is not None:
            result['arr_city_name'] = self.arr_city_name
        if self.arr_time is not None:
            result['arr_time'] = self.arr_time
        if self.cabin is not None:
            result['cabin'] = self.cabin
        if self.cabin_class is not None:
            result['cabin_class'] = self.cabin_class
        if self.cabin_class_str is not None:
            result['cabin_class_str'] = self.cabin_class_str
        if self.dep_city is not None:
            result['dep_city'] = self.dep_city
        if self.dep_city_name is not None:
            result['dep_city_name'] = self.dep_city_name
        if self.dep_time is not None:
            result['dep_time'] = self.dep_time
        if self.discount is not None:
            result['discount'] = self.discount
        if self.flight_no is not None:
            result['flight_no'] = self.flight_no
        if self.price is not None:
            result['price'] = self.price
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('arr_city') is not None:
            self.arr_city = m.get('arr_city')
        if m.get('arr_city_name') is not None:
            self.arr_city_name = m.get('arr_city_name')
        if m.get('arr_time') is not None:
            self.arr_time = m.get('arr_time')
        if m.get('cabin') is not None:
            self.cabin = m.get('cabin')
        if m.get('cabin_class') is not None:
            self.cabin_class = m.get('cabin_class')
        if m.get('cabin_class_str') is not None:
            self.cabin_class_str = m.get('cabin_class_str')
        if m.get('dep_city') is not None:
            self.dep_city = m.get('dep_city')
        if m.get('dep_city_name') is not None:
            self.dep_city_name = m.get('dep_city_name')
        if m.get('dep_time') is not None:
            self.dep_time = m.get('dep_time')
        if m.get('discount') is not None:
            self.discount = m.get('discount')
        if m.get('flight_no') is not None:
            self.flight_no = m.get('flight_no')
        if m.get('price') is not None:
            self.price = m.get('price')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class FlightExceedApplyQueryResponseBodyModule(TeaModel):
    def __init__(self, apply_id=None, apply_intention_info_do=None, btrip_cause=None, corp_id=None,
                 exceed_reason=None, exceed_type=None, origin_standard=None, status=None, submit_time=None,
                 thirdpart_apply_id=None, thirdpart_corp_id=None, user_id=None):
        self.apply_id = apply_id  # type: long
        self.apply_intention_info_do = apply_intention_info_do  # type: FlightExceedApplyQueryResponseBodyModuleApplyIntentionInfoDo
        self.btrip_cause = btrip_cause  # type: str
        self.corp_id = corp_id  # type: str
        self.exceed_reason = exceed_reason  # type: str
        self.exceed_type = exceed_type  # type: int
        self.origin_standard = origin_standard  # type: str
        self.status = status  # type: int
        self.submit_time = submit_time  # type: str
        self.thirdpart_apply_id = thirdpart_apply_id  # type: str
        self.thirdpart_corp_id = thirdpart_corp_id  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        if self.apply_intention_info_do:
            self.apply_intention_info_do.validate()

    def to_map(self):
        _map = super(FlightExceedApplyQueryResponseBodyModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.apply_intention_info_do is not None:
            result['apply_intention_info_do'] = self.apply_intention_info_do.to_map()
        if self.btrip_cause is not None:
            result['btrip_cause'] = self.btrip_cause
        if self.corp_id is not None:
            result['corp_id'] = self.corp_id
        if self.exceed_reason is not None:
            result['exceed_reason'] = self.exceed_reason
        if self.exceed_type is not None:
            result['exceed_type'] = self.exceed_type
        if self.origin_standard is not None:
            result['origin_standard'] = self.origin_standard
        if self.status is not None:
            result['status'] = self.status
        if self.submit_time is not None:
            result['submit_time'] = self.submit_time
        if self.thirdpart_apply_id is not None:
            result['thirdpart_apply_id'] = self.thirdpart_apply_id
        if self.thirdpart_corp_id is not None:
            result['thirdpart_corp_id'] = self.thirdpart_corp_id
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('apply_intention_info_do') is not None:
            temp_model = FlightExceedApplyQueryResponseBodyModuleApplyIntentionInfoDo()
            self.apply_intention_info_do = temp_model.from_map(m['apply_intention_info_do'])
        if m.get('btrip_cause') is not None:
            self.btrip_cause = m.get('btrip_cause')
        if m.get('corp_id') is not None:
            self.corp_id = m.get('corp_id')
        if m.get('exceed_reason') is not None:
            self.exceed_reason = m.get('exceed_reason')
        if m.get('exceed_type') is not None:
            self.exceed_type = m.get('exceed_type')
        if m.get('origin_standard') is not None:
            self.origin_standard = m.get('origin_standard')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('submit_time') is not None:
            self.submit_time = m.get('submit_time')
        if m.get('thirdpart_apply_id') is not None:
            self.thirdpart_apply_id = m.get('thirdpart_apply_id')
        if m.get('thirdpart_corp_id') is not None:
            self.thirdpart_corp_id = m.get('thirdpart_corp_id')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class FlightExceedApplyQueryResponseBody(TeaModel):
    def __init__(self, code=None, message=None, module=None, request_id=None, success=None, trace_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.module = module  # type: FlightExceedApplyQueryResponseBodyModule
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.trace_id = trace_id  # type: str

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super(FlightExceedApplyQueryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = FlightExceedApplyQueryResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class FlightExceedApplyQueryResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: FlightExceedApplyQueryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(FlightExceedApplyQueryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = FlightExceedApplyQueryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class FlightItineraryScanQueryHeaders(TeaModel):
    def __init__(self, common_headers=None, x_acs_btrip_so_corp_token=None):
        self.common_headers = common_headers  # type: dict[str, str]
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightItineraryScanQueryHeaders, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class FlightItineraryScanQueryRequest(TeaModel):
    def __init__(self, bill_date=None, bill_id=None, invoice_sub_task_id=None, page_no=None, page_size=None):
        self.bill_date = bill_date  # type: str
        self.bill_id = bill_id  # type: long
        self.invoice_sub_task_id = invoice_sub_task_id  # type: long
        self.page_no = page_no  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightItineraryScanQueryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bill_date is not None:
            result['bill_date'] = self.bill_date
        if self.bill_id is not None:
            result['bill_id'] = self.bill_id
        if self.invoice_sub_task_id is not None:
            result['invoice_sub_task_id'] = self.invoice_sub_task_id
        if self.page_no is not None:
            result['page_no'] = self.page_no
        if self.page_size is not None:
            result['page_size'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('bill_date') is not None:
            self.bill_date = m.get('bill_date')
        if m.get('bill_id') is not None:
            self.bill_id = m.get('bill_id')
        if m.get('invoice_sub_task_id') is not None:
            self.invoice_sub_task_id = m.get('invoice_sub_task_id')
        if m.get('page_no') is not None:
            self.page_no = m.get('page_no')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        return self


class FlightItineraryScanQueryResponseBodyModuleItems(TeaModel):
    def __init__(self, bill_date=None, build=None, cost_center=None, department=None, fuel_surcharge=None,
                 insurance=None, invoice_title=None, itinerary_num=None, order_id=None, oss_url=None, passenger_name=None,
                 project=None, tax_amount=None, tax_rate=None, ticket_no=None, ticket_price=None, total_price=None):
        self.bill_date = bill_date  # type: str
        self.build = build  # type: str
        self.cost_center = cost_center  # type: str
        self.department = department  # type: str
        self.fuel_surcharge = fuel_surcharge  # type: str
        self.insurance = insurance  # type: str
        self.invoice_title = invoice_title  # type: str
        self.itinerary_num = itinerary_num  # type: str
        self.order_id = order_id  # type: long
        self.oss_url = oss_url  # type: str
        self.passenger_name = passenger_name  # type: str
        self.project = project  # type: str
        self.tax_amount = tax_amount  # type: str
        self.tax_rate = tax_rate  # type: str
        self.ticket_no = ticket_no  # type: str
        self.ticket_price = ticket_price  # type: str
        self.total_price = total_price  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightItineraryScanQueryResponseBodyModuleItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bill_date is not None:
            result['bill_date'] = self.bill_date
        if self.build is not None:
            result['build'] = self.build
        if self.cost_center is not None:
            result['cost_center'] = self.cost_center
        if self.department is not None:
            result['department'] = self.department
        if self.fuel_surcharge is not None:
            result['fuel_surcharge'] = self.fuel_surcharge
        if self.insurance is not None:
            result['insurance'] = self.insurance
        if self.invoice_title is not None:
            result['invoice_title'] = self.invoice_title
        if self.itinerary_num is not None:
            result['itinerary_num'] = self.itinerary_num
        if self.order_id is not None:
            result['order_id'] = self.order_id
        if self.oss_url is not None:
            result['oss_url'] = self.oss_url
        if self.passenger_name is not None:
            result['passenger_name'] = self.passenger_name
        if self.project is not None:
            result['project'] = self.project
        if self.tax_amount is not None:
            result['tax_amount'] = self.tax_amount
        if self.tax_rate is not None:
            result['tax_rate'] = self.tax_rate
        if self.ticket_no is not None:
            result['ticket_no'] = self.ticket_no
        if self.ticket_price is not None:
            result['ticket_price'] = self.ticket_price
        if self.total_price is not None:
            result['total_price'] = self.total_price
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('bill_date') is not None:
            self.bill_date = m.get('bill_date')
        if m.get('build') is not None:
            self.build = m.get('build')
        if m.get('cost_center') is not None:
            self.cost_center = m.get('cost_center')
        if m.get('department') is not None:
            self.department = m.get('department')
        if m.get('fuel_surcharge') is not None:
            self.fuel_surcharge = m.get('fuel_surcharge')
        if m.get('insurance') is not None:
            self.insurance = m.get('insurance')
        if m.get('invoice_title') is not None:
            self.invoice_title = m.get('invoice_title')
        if m.get('itinerary_num') is not None:
            self.itinerary_num = m.get('itinerary_num')
        if m.get('order_id') is not None:
            self.order_id = m.get('order_id')
        if m.get('oss_url') is not None:
            self.oss_url = m.get('oss_url')
        if m.get('passenger_name') is not None:
            self.passenger_name = m.get('passenger_name')
        if m.get('project') is not None:
            self.project = m.get('project')
        if m.get('tax_amount') is not None:
            self.tax_amount = m.get('tax_amount')
        if m.get('tax_rate') is not None:
            self.tax_rate = m.get('tax_rate')
        if m.get('ticket_no') is not None:
            self.ticket_no = m.get('ticket_no')
        if m.get('ticket_price') is not None:
            self.ticket_price = m.get('ticket_price')
        if m.get('total_price') is not None:
            self.total_price = m.get('total_price')
        return self


class FlightItineraryScanQueryResponseBodyModule(TeaModel):
    def __init__(self, items=None, page_no=None, page_size=None, total_page=None, total_size=None):
        self.items = items  # type: list[FlightItineraryScanQueryResponseBodyModuleItems]
        self.page_no = page_no  # type: int
        self.page_size = page_size  # type: int
        self.total_page = total_page  # type: int
        self.total_size = total_size  # type: int

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(FlightItineraryScanQueryResponseBodyModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['items'] = []
        if self.items is not None:
            for k in self.items:
                result['items'].append(k.to_map() if k else None)
        if self.page_no is not None:
            result['page_no'] = self.page_no
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.total_page is not None:
            result['total_page'] = self.total_page
        if self.total_size is not None:
            result['total_size'] = self.total_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.items = []
        if m.get('items') is not None:
            for k in m.get('items'):
                temp_model = FlightItineraryScanQueryResponseBodyModuleItems()
                self.items.append(temp_model.from_map(k))
        if m.get('page_no') is not None:
            self.page_no = m.get('page_no')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('total_page') is not None:
            self.total_page = m.get('total_page')
        if m.get('total_size') is not None:
            self.total_size = m.get('total_size')
        return self


class FlightItineraryScanQueryResponseBody(TeaModel):
    def __init__(self, code=None, message=None, module=None, request_id=None, success=None, trace_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.module = module  # type: FlightItineraryScanQueryResponseBodyModule
        # requestId
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        # traceId
        self.trace_id = trace_id  # type: str

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super(FlightItineraryScanQueryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = FlightItineraryScanQueryResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class FlightItineraryScanQueryResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: FlightItineraryScanQueryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(FlightItineraryScanQueryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = FlightItineraryScanQueryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class FlightOrderDetailInfoHeaders(TeaModel):
    def __init__(self, common_headers=None, x_acs_btrip_corp_token=None):
        self.common_headers = common_headers  # type: dict[str, str]
        self.x_acs_btrip_corp_token = x_acs_btrip_corp_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightOrderDetailInfoHeaders, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_corp_token is not None:
            result['x-acs-btrip-corp-token'] = self.x_acs_btrip_corp_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-corp-token') is not None:
            self.x_acs_btrip_corp_token = m.get('x-acs-btrip-corp-token')
        return self


class FlightOrderDetailInfoRequest(TeaModel):
    def __init__(self, dis_order_id=None):
        self.dis_order_id = dis_order_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightOrderDetailInfoRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dis_order_id is not None:
            result['dis_order_id'] = self.dis_order_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('dis_order_id') is not None:
            self.dis_order_id = m.get('dis_order_id')
        return self


class FlightOrderDetailInfoResponseBodyModuleFlightInfoList(TeaModel):
    def __init__(self, airline_code=None, airline_name=None, airline_simple_name=None, arr_airport=None,
                 arr_airport_code=None, arr_airport_code_name=None, arr_city=None, arr_city_code=None, arr_terminal=None,
                 arr_time=None, baggage=None, build_price=None, cabin=None, cabin_class=None, carrier=None, dep_airport=None,
                 dep_airport_code=None, dep_airport_code_name=None, dep_city=None, dep_city_code=None, dep_terminal=None,
                 dep_time=None, flight_no=None, last_cabin=None, last_flight_no=None, meal=None, oil_price=None,
                 segment_type=None, stop_arr_time=None, stop_city=None, stop_dep_time=None, ticket_price=None,
                 tuigaiqian_info=None):
        self.airline_code = airline_code  # type: str
        self.airline_name = airline_name  # type: str
        self.airline_simple_name = airline_simple_name  # type: str
        self.arr_airport = arr_airport  # type: str
        self.arr_airport_code = arr_airport_code  # type: str
        self.arr_airport_code_name = arr_airport_code_name  # type: str
        self.arr_city = arr_city  # type: str
        self.arr_city_code = arr_city_code  # type: str
        self.arr_terminal = arr_terminal  # type: str
        self.arr_time = arr_time  # type: str
        self.baggage = baggage  # type: str
        self.build_price = build_price  # type: long
        self.cabin = cabin  # type: str
        self.cabin_class = cabin_class  # type: str
        self.carrier = carrier  # type: str
        self.dep_airport = dep_airport  # type: str
        self.dep_airport_code = dep_airport_code  # type: str
        self.dep_airport_code_name = dep_airport_code_name  # type: str
        self.dep_city = dep_city  # type: str
        self.dep_city_code = dep_city_code  # type: str
        self.dep_terminal = dep_terminal  # type: str
        self.dep_time = dep_time  # type: str
        self.flight_no = flight_no  # type: str
        self.last_cabin = last_cabin  # type: str
        self.last_flight_no = last_flight_no  # type: str
        self.meal = meal  # type: str
        self.oil_price = oil_price  # type: long
        self.segment_type = segment_type  # type: int
        self.stop_arr_time = stop_arr_time  # type: str
        self.stop_city = stop_city  # type: str
        self.stop_dep_time = stop_dep_time  # type: str
        self.ticket_price = ticket_price  # type: long
        self.tuigaiqian_info = tuigaiqian_info  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightOrderDetailInfoResponseBodyModuleFlightInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.airline_code is not None:
            result['airline_code'] = self.airline_code
        if self.airline_name is not None:
            result['airline_name'] = self.airline_name
        if self.airline_simple_name is not None:
            result['airline_simple_name'] = self.airline_simple_name
        if self.arr_airport is not None:
            result['arr_airport'] = self.arr_airport
        if self.arr_airport_code is not None:
            result['arr_airport_code'] = self.arr_airport_code
        if self.arr_airport_code_name is not None:
            result['arr_airport_code_name'] = self.arr_airport_code_name
        if self.arr_city is not None:
            result['arr_city'] = self.arr_city
        if self.arr_city_code is not None:
            result['arr_city_code'] = self.arr_city_code
        if self.arr_terminal is not None:
            result['arr_terminal'] = self.arr_terminal
        if self.arr_time is not None:
            result['arr_time'] = self.arr_time
        if self.baggage is not None:
            result['baggage'] = self.baggage
        if self.build_price is not None:
            result['build_price'] = self.build_price
        if self.cabin is not None:
            result['cabin'] = self.cabin
        if self.cabin_class is not None:
            result['cabin_class'] = self.cabin_class
        if self.carrier is not None:
            result['carrier'] = self.carrier
        if self.dep_airport is not None:
            result['dep_airport'] = self.dep_airport
        if self.dep_airport_code is not None:
            result['dep_airport_code'] = self.dep_airport_code
        if self.dep_airport_code_name is not None:
            result['dep_airport_code_name'] = self.dep_airport_code_name
        if self.dep_city is not None:
            result['dep_city'] = self.dep_city
        if self.dep_city_code is not None:
            result['dep_city_code'] = self.dep_city_code
        if self.dep_terminal is not None:
            result['dep_terminal'] = self.dep_terminal
        if self.dep_time is not None:
            result['dep_time'] = self.dep_time
        if self.flight_no is not None:
            result['flight_no'] = self.flight_no
        if self.last_cabin is not None:
            result['last_cabin'] = self.last_cabin
        if self.last_flight_no is not None:
            result['last_flight_no'] = self.last_flight_no
        if self.meal is not None:
            result['meal'] = self.meal
        if self.oil_price is not None:
            result['oil_price'] = self.oil_price
        if self.segment_type is not None:
            result['segment_type'] = self.segment_type
        if self.stop_arr_time is not None:
            result['stop_arr_time'] = self.stop_arr_time
        if self.stop_city is not None:
            result['stop_city'] = self.stop_city
        if self.stop_dep_time is not None:
            result['stop_dep_time'] = self.stop_dep_time
        if self.ticket_price is not None:
            result['ticket_price'] = self.ticket_price
        if self.tuigaiqian_info is not None:
            result['tuigaiqian_info'] = self.tuigaiqian_info
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('airline_code') is not None:
            self.airline_code = m.get('airline_code')
        if m.get('airline_name') is not None:
            self.airline_name = m.get('airline_name')
        if m.get('airline_simple_name') is not None:
            self.airline_simple_name = m.get('airline_simple_name')
        if m.get('arr_airport') is not None:
            self.arr_airport = m.get('arr_airport')
        if m.get('arr_airport_code') is not None:
            self.arr_airport_code = m.get('arr_airport_code')
        if m.get('arr_airport_code_name') is not None:
            self.arr_airport_code_name = m.get('arr_airport_code_name')
        if m.get('arr_city') is not None:
            self.arr_city = m.get('arr_city')
        if m.get('arr_city_code') is not None:
            self.arr_city_code = m.get('arr_city_code')
        if m.get('arr_terminal') is not None:
            self.arr_terminal = m.get('arr_terminal')
        if m.get('arr_time') is not None:
            self.arr_time = m.get('arr_time')
        if m.get('baggage') is not None:
            self.baggage = m.get('baggage')
        if m.get('build_price') is not None:
            self.build_price = m.get('build_price')
        if m.get('cabin') is not None:
            self.cabin = m.get('cabin')
        if m.get('cabin_class') is not None:
            self.cabin_class = m.get('cabin_class')
        if m.get('carrier') is not None:
            self.carrier = m.get('carrier')
        if m.get('dep_airport') is not None:
            self.dep_airport = m.get('dep_airport')
        if m.get('dep_airport_code') is not None:
            self.dep_airport_code = m.get('dep_airport_code')
        if m.get('dep_airport_code_name') is not None:
            self.dep_airport_code_name = m.get('dep_airport_code_name')
        if m.get('dep_city') is not None:
            self.dep_city = m.get('dep_city')
        if m.get('dep_city_code') is not None:
            self.dep_city_code = m.get('dep_city_code')
        if m.get('dep_terminal') is not None:
            self.dep_terminal = m.get('dep_terminal')
        if m.get('dep_time') is not None:
            self.dep_time = m.get('dep_time')
        if m.get('flight_no') is not None:
            self.flight_no = m.get('flight_no')
        if m.get('last_cabin') is not None:
            self.last_cabin = m.get('last_cabin')
        if m.get('last_flight_no') is not None:
            self.last_flight_no = m.get('last_flight_no')
        if m.get('meal') is not None:
            self.meal = m.get('meal')
        if m.get('oil_price') is not None:
            self.oil_price = m.get('oil_price')
        if m.get('segment_type') is not None:
            self.segment_type = m.get('segment_type')
        if m.get('stop_arr_time') is not None:
            self.stop_arr_time = m.get('stop_arr_time')
        if m.get('stop_city') is not None:
            self.stop_city = m.get('stop_city')
        if m.get('stop_dep_time') is not None:
            self.stop_dep_time = m.get('stop_dep_time')
        if m.get('ticket_price') is not None:
            self.ticket_price = m.get('ticket_price')
        if m.get('tuigaiqian_info') is not None:
            self.tuigaiqian_info = m.get('tuigaiqian_info')
        return self


class FlightOrderDetailInfoResponseBodyModuleTicketInfoList(TeaModel):
    def __init__(self, open_ticket_status=None, pnr_code=None, ticket_no=None, ticket_status=None):
        self.open_ticket_status = open_ticket_status  # type: str
        self.pnr_code = pnr_code  # type: str
        self.ticket_no = ticket_no  # type: str
        self.ticket_status = ticket_status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightOrderDetailInfoResponseBodyModuleTicketInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.open_ticket_status is not None:
            result['open_ticket_status'] = self.open_ticket_status
        if self.pnr_code is not None:
            result['pnr_code'] = self.pnr_code
        if self.ticket_no is not None:
            result['ticket_no'] = self.ticket_no
        if self.ticket_status is not None:
            result['ticket_status'] = self.ticket_status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('open_ticket_status') is not None:
            self.open_ticket_status = m.get('open_ticket_status')
        if m.get('pnr_code') is not None:
            self.pnr_code = m.get('pnr_code')
        if m.get('ticket_no') is not None:
            self.ticket_no = m.get('ticket_no')
        if m.get('ticket_status') is not None:
            self.ticket_status = m.get('ticket_status')
        return self


class FlightOrderDetailInfoResponseBodyModuleTravelerInfoList(TeaModel):
    def __init__(self, birth_date=None, cert_no=None, cert_type=None, open_ticket_status=None, passenger_name=None,
                 passenger_type=None, phone=None, ticket_no=None, user_id=None):
        self.birth_date = birth_date  # type: str
        self.cert_no = cert_no  # type: str
        self.cert_type = cert_type  # type: str
        self.open_ticket_status = open_ticket_status  # type: int
        self.passenger_name = passenger_name  # type: str
        self.passenger_type = passenger_type  # type: str
        self.phone = phone  # type: str
        self.ticket_no = ticket_no  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightOrderDetailInfoResponseBodyModuleTravelerInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.birth_date is not None:
            result['birth_date'] = self.birth_date
        if self.cert_no is not None:
            result['cert_no'] = self.cert_no
        if self.cert_type is not None:
            result['cert_type'] = self.cert_type
        if self.open_ticket_status is not None:
            result['open_ticket_status'] = self.open_ticket_status
        if self.passenger_name is not None:
            result['passenger_name'] = self.passenger_name
        if self.passenger_type is not None:
            result['passenger_type'] = self.passenger_type
        if self.phone is not None:
            result['phone'] = self.phone
        if self.ticket_no is not None:
            result['ticket_no'] = self.ticket_no
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('birth_date') is not None:
            self.birth_date = m.get('birth_date')
        if m.get('cert_no') is not None:
            self.cert_no = m.get('cert_no')
        if m.get('cert_type') is not None:
            self.cert_type = m.get('cert_type')
        if m.get('open_ticket_status') is not None:
            self.open_ticket_status = m.get('open_ticket_status')
        if m.get('passenger_name') is not None:
            self.passenger_name = m.get('passenger_name')
        if m.get('passenger_type') is not None:
            self.passenger_type = m.get('passenger_type')
        if m.get('phone') is not None:
            self.phone = m.get('phone')
        if m.get('ticket_no') is not None:
            self.ticket_no = m.get('ticket_no')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class FlightOrderDetailInfoResponseBodyModule(TeaModel):
    def __init__(self, alipay_trade_no=None, book_user_id=None, btrip_order_id=None, contact_name=None,
                 contact_phone=None, dis_order_id=None, extra=None, flight_info_list=None, last_pay_time=None, pay_status=None,
                 pay_time=None, promotion_price=None, settle_amount=None, settle_type=None, status=None,
                 ticket_info_list=None, total_build_price=None, total_oil_price=None, total_order_price=None,
                 traveler_info_list=None):
        self.alipay_trade_no = alipay_trade_no  # type: str
        self.book_user_id = book_user_id  # type: str
        self.btrip_order_id = btrip_order_id  # type: long
        self.contact_name = contact_name  # type: str
        self.contact_phone = contact_phone  # type: str
        self.dis_order_id = dis_order_id  # type: str
        self.extra = extra  # type: str
        self.flight_info_list = flight_info_list  # type: list[FlightOrderDetailInfoResponseBodyModuleFlightInfoList]
        self.last_pay_time = last_pay_time  # type: str
        self.pay_status = pay_status  # type: int
        self.pay_time = pay_time  # type: str
        self.promotion_price = promotion_price  # type: long
        self.settle_amount = settle_amount  # type: long
        self.settle_type = settle_type  # type: int
        self.status = status  # type: int
        self.ticket_info_list = ticket_info_list  # type: list[FlightOrderDetailInfoResponseBodyModuleTicketInfoList]
        self.total_build_price = total_build_price  # type: long
        self.total_oil_price = total_oil_price  # type: long
        self.total_order_price = total_order_price  # type: long
        self.traveler_info_list = traveler_info_list  # type: list[FlightOrderDetailInfoResponseBodyModuleTravelerInfoList]

    def validate(self):
        if self.flight_info_list:
            for k in self.flight_info_list:
                if k:
                    k.validate()
        if self.ticket_info_list:
            for k in self.ticket_info_list:
                if k:
                    k.validate()
        if self.traveler_info_list:
            for k in self.traveler_info_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(FlightOrderDetailInfoResponseBodyModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alipay_trade_no is not None:
            result['alipay_trade_no'] = self.alipay_trade_no
        if self.book_user_id is not None:
            result['book_user_id'] = self.book_user_id
        if self.btrip_order_id is not None:
            result['btrip_order_id'] = self.btrip_order_id
        if self.contact_name is not None:
            result['contact_name'] = self.contact_name
        if self.contact_phone is not None:
            result['contact_phone'] = self.contact_phone
        if self.dis_order_id is not None:
            result['dis_order_id'] = self.dis_order_id
        if self.extra is not None:
            result['extra'] = self.extra
        result['flight_info_list'] = []
        if self.flight_info_list is not None:
            for k in self.flight_info_list:
                result['flight_info_list'].append(k.to_map() if k else None)
        if self.last_pay_time is not None:
            result['last_pay_time'] = self.last_pay_time
        if self.pay_status is not None:
            result['pay_status'] = self.pay_status
        if self.pay_time is not None:
            result['pay_time'] = self.pay_time
        if self.promotion_price is not None:
            result['promotion_price'] = self.promotion_price
        if self.settle_amount is not None:
            result['settle_amount'] = self.settle_amount
        if self.settle_type is not None:
            result['settle_type'] = self.settle_type
        if self.status is not None:
            result['status'] = self.status
        result['ticket_info_list'] = []
        if self.ticket_info_list is not None:
            for k in self.ticket_info_list:
                result['ticket_info_list'].append(k.to_map() if k else None)
        if self.total_build_price is not None:
            result['total_build_price'] = self.total_build_price
        if self.total_oil_price is not None:
            result['total_oil_price'] = self.total_oil_price
        if self.total_order_price is not None:
            result['total_order_price'] = self.total_order_price
        result['traveler_info_list'] = []
        if self.traveler_info_list is not None:
            for k in self.traveler_info_list:
                result['traveler_info_list'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('alipay_trade_no') is not None:
            self.alipay_trade_no = m.get('alipay_trade_no')
        if m.get('book_user_id') is not None:
            self.book_user_id = m.get('book_user_id')
        if m.get('btrip_order_id') is not None:
            self.btrip_order_id = m.get('btrip_order_id')
        if m.get('contact_name') is not None:
            self.contact_name = m.get('contact_name')
        if m.get('contact_phone') is not None:
            self.contact_phone = m.get('contact_phone')
        if m.get('dis_order_id') is not None:
            self.dis_order_id = m.get('dis_order_id')
        if m.get('extra') is not None:
            self.extra = m.get('extra')
        self.flight_info_list = []
        if m.get('flight_info_list') is not None:
            for k in m.get('flight_info_list'):
                temp_model = FlightOrderDetailInfoResponseBodyModuleFlightInfoList()
                self.flight_info_list.append(temp_model.from_map(k))
        if m.get('last_pay_time') is not None:
            self.last_pay_time = m.get('last_pay_time')
        if m.get('pay_status') is not None:
            self.pay_status = m.get('pay_status')
        if m.get('pay_time') is not None:
            self.pay_time = m.get('pay_time')
        if m.get('promotion_price') is not None:
            self.promotion_price = m.get('promotion_price')
        if m.get('settle_amount') is not None:
            self.settle_amount = m.get('settle_amount')
        if m.get('settle_type') is not None:
            self.settle_type = m.get('settle_type')
        if m.get('status') is not None:
            self.status = m.get('status')
        self.ticket_info_list = []
        if m.get('ticket_info_list') is not None:
            for k in m.get('ticket_info_list'):
                temp_model = FlightOrderDetailInfoResponseBodyModuleTicketInfoList()
                self.ticket_info_list.append(temp_model.from_map(k))
        if m.get('total_build_price') is not None:
            self.total_build_price = m.get('total_build_price')
        if m.get('total_oil_price') is not None:
            self.total_oil_price = m.get('total_oil_price')
        if m.get('total_order_price') is not None:
            self.total_order_price = m.get('total_order_price')
        self.traveler_info_list = []
        if m.get('traveler_info_list') is not None:
            for k in m.get('traveler_info_list'):
                temp_model = FlightOrderDetailInfoResponseBodyModuleTravelerInfoList()
                self.traveler_info_list.append(temp_model.from_map(k))
        return self


class FlightOrderDetailInfoResponseBody(TeaModel):
    def __init__(self, code=None, message=None, module=None, request_id=None, success=None, trace_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.module = module  # type: FlightOrderDetailInfoResponseBodyModule
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.trace_id = trace_id  # type: str

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super(FlightOrderDetailInfoResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = FlightOrderDetailInfoResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class FlightOrderDetailInfoResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: FlightOrderDetailInfoResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(FlightOrderDetailInfoResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = FlightOrderDetailInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class FlightOrderListQueryHeaders(TeaModel):
    def __init__(self, common_headers=None, x_acs_btrip_so_corp_token=None):
        self.common_headers = common_headers  # type: dict[str, str]
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightOrderListQueryHeaders, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class FlightOrderListQueryRequest(TeaModel):
    def __init__(self, all_apply=None, apply_id=None, depart_id=None, end_time=None, page=None, page_size=None,
                 start_time=None, thirdpart_apply_id=None, update_end_time=None, update_start_time=None, user_id=None):
        self.all_apply = all_apply  # type: bool
        self.apply_id = apply_id  # type: long
        self.depart_id = depart_id  # type: str
        self.end_time = end_time  # type: str
        self.page = page  # type: int
        self.page_size = page_size  # type: int
        self.start_time = start_time  # type: str
        self.thirdpart_apply_id = thirdpart_apply_id  # type: str
        self.update_end_time = update_end_time  # type: str
        self.update_start_time = update_start_time  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightOrderListQueryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.all_apply is not None:
            result['all_apply'] = self.all_apply
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.depart_id is not None:
            result['depart_id'] = self.depart_id
        if self.end_time is not None:
            result['end_time'] = self.end_time
        if self.page is not None:
            result['page'] = self.page
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.start_time is not None:
            result['start_time'] = self.start_time
        if self.thirdpart_apply_id is not None:
            result['thirdpart_apply_id'] = self.thirdpart_apply_id
        if self.update_end_time is not None:
            result['update_end_time'] = self.update_end_time
        if self.update_start_time is not None:
            result['update_start_time'] = self.update_start_time
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('all_apply') is not None:
            self.all_apply = m.get('all_apply')
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('depart_id') is not None:
            self.depart_id = m.get('depart_id')
        if m.get('end_time') is not None:
            self.end_time = m.get('end_time')
        if m.get('page') is not None:
            self.page = m.get('page')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('start_time') is not None:
            self.start_time = m.get('start_time')
        if m.get('thirdpart_apply_id') is not None:
            self.thirdpart_apply_id = m.get('thirdpart_apply_id')
        if m.get('update_end_time') is not None:
            self.update_end_time = m.get('update_end_time')
        if m.get('update_start_time') is not None:
            self.update_start_time = m.get('update_start_time')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class FlightOrderListQueryResponseBodyModuleCostCenter(TeaModel):
    def __init__(self, corp_id=None, id=None, name=None, number=None):
        self.corp_id = corp_id  # type: str
        self.id = id  # type: long
        self.name = name  # type: str
        self.number = number  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightOrderListQueryResponseBodyModuleCostCenter, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['corp_id'] = self.corp_id
        if self.id is not None:
            result['id'] = self.id
        if self.name is not None:
            result['name'] = self.name
        if self.number is not None:
            result['number'] = self.number
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('corp_id') is not None:
            self.corp_id = m.get('corp_id')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('number') is not None:
            self.number = m.get('number')
        return self


class FlightOrderListQueryResponseBodyModuleInsureInfoList(TeaModel):
    def __init__(self, insure_no=None, name=None, status=None):
        self.insure_no = insure_no  # type: str
        self.name = name  # type: str
        self.status = status  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightOrderListQueryResponseBodyModuleInsureInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.insure_no is not None:
            result['insure_no'] = self.insure_no
        if self.name is not None:
            result['name'] = self.name
        if self.status is not None:
            result['status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('insure_no') is not None:
            self.insure_no = m.get('insure_no')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('status') is not None:
            self.status = m.get('status')
        return self


class FlightOrderListQueryResponseBodyModuleInvoice(TeaModel):
    def __init__(self, id=None, title=None):
        self.id = id  # type: long
        self.title = title  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightOrderListQueryResponseBodyModuleInvoice, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightOrderListQueryResponseBodyModulePriceInfoList(TeaModel):
    def __init__(self, category_code=None, category_type=None, change_flight_no=None, discount=None, end_time=None,
                 gmt_create=None, original_ticket_no=None, passenger_name=None, pay_type=None, price=None, start_time=None,
                 ticket_no=None, trade_id=None, type=None):
        self.category_code = category_code  # type: int
        self.category_type = category_type  # type: int
        self.change_flight_no = change_flight_no  # type: str
        self.discount = discount  # type: str
        self.end_time = end_time  # type: str
        self.gmt_create = gmt_create  # type: str
        self.original_ticket_no = original_ticket_no  # type: str
        self.passenger_name = passenger_name  # type: str
        self.pay_type = pay_type  # type: int
        self.price = price  # type: float
        self.start_time = start_time  # type: str
        self.ticket_no = ticket_no  # type: str
        self.trade_id = trade_id  # type: str
        self.type = type  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightOrderListQueryResponseBodyModulePriceInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category_code is not None:
            result['category_code'] = self.category_code
        if self.category_type is not None:
            result['category_type'] = self.category_type
        if self.change_flight_no is not None:
            result['change_flight_no'] = self.change_flight_no
        if self.discount is not None:
            result['discount'] = self.discount
        if self.end_time is not None:
            result['end_time'] = self.end_time
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.original_ticket_no is not None:
            result['original_ticket_no'] = self.original_ticket_no
        if self.passenger_name is not None:
            result['passenger_name'] = self.passenger_name
        if self.pay_type is not None:
            result['pay_type'] = self.pay_type
        if self.price is not None:
            result['price'] = self.price
        if self.start_time is not None:
            result['start_time'] = self.start_time
        if self.ticket_no is not None:
            result['ticket_no'] = self.ticket_no
        if self.trade_id is not None:
            result['trade_id'] = self.trade_id
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('category_code') is not None:
            self.category_code = m.get('category_code')
        if m.get('category_type') is not None:
            self.category_type = m.get('category_type')
        if m.get('change_flight_no') is not None:
            self.change_flight_no = m.get('change_flight_no')
        if m.get('discount') is not None:
            self.discount = m.get('discount')
        if m.get('end_time') is not None:
            self.end_time = m.get('end_time')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('original_ticket_no') is not None:
            self.original_ticket_no = m.get('original_ticket_no')
        if m.get('passenger_name') is not None:
            self.passenger_name = m.get('passenger_name')
        if m.get('pay_type') is not None:
            self.pay_type = m.get('pay_type')
        if m.get('price') is not None:
            self.price = m.get('price')
        if m.get('start_time') is not None:
            self.start_time = m.get('start_time')
        if m.get('ticket_no') is not None:
            self.ticket_no = m.get('ticket_no')
        if m.get('trade_id') is not None:
            self.trade_id = m.get('trade_id')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class FlightOrderListQueryResponseBodyModuleUserAffiliateList(TeaModel):
    def __init__(self, user_id=None, user_name=None):
        self.user_id = user_id  # type: str
        self.user_name = user_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightOrderListQueryResponseBodyModuleUserAffiliateList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        return self


class FlightOrderListQueryResponseBodyModule(TeaModel):
    def __init__(self, apply_id=None, arr_airport=None, arr_city=None, btrip_title=None, cabin_class=None,
                 contact_name=None, corp_id=None, corp_name=None, cost_center=None, dep_airport=None, dep_city=None,
                 dep_date=None, depart_id=None, depart_name=None, discount=None, flight_no=None, gmt_create=None,
                 gmt_modified=None, id=None, insure_info_list=None, invoice=None, passenger_count=None, passenger_name=None,
                 price_info_list=None, project_code=None, project_id=None, project_title=None, ret_date=None, status=None,
                 third_part_project_id=None, thirdpart_apply_id=None, thirdpart_itinerary_id=None, trip_type=None,
                 user_affiliate_list=None, user_id=None, user_name=None):
        self.apply_id = apply_id  # type: long
        self.arr_airport = arr_airport  # type: str
        self.arr_city = arr_city  # type: str
        self.btrip_title = btrip_title  # type: str
        self.cabin_class = cabin_class  # type: str
        self.contact_name = contact_name  # type: str
        self.corp_id = corp_id  # type: str
        self.corp_name = corp_name  # type: str
        self.cost_center = cost_center  # type: FlightOrderListQueryResponseBodyModuleCostCenter
        self.dep_airport = dep_airport  # type: str
        self.dep_city = dep_city  # type: str
        self.dep_date = dep_date  # type: str
        self.depart_id = depart_id  # type: str
        self.depart_name = depart_name  # type: str
        self.discount = discount  # type: str
        self.flight_no = flight_no  # type: str
        self.gmt_create = gmt_create  # type: str
        self.gmt_modified = gmt_modified  # type: str
        self.id = id  # type: long
        self.insure_info_list = insure_info_list  # type: list[FlightOrderListQueryResponseBodyModuleInsureInfoList]
        self.invoice = invoice  # type: FlightOrderListQueryResponseBodyModuleInvoice
        self.passenger_count = passenger_count  # type: int
        self.passenger_name = passenger_name  # type: str
        self.price_info_list = price_info_list  # type: list[FlightOrderListQueryResponseBodyModulePriceInfoList]
        self.project_code = project_code  # type: str
        self.project_id = project_id  # type: long
        self.project_title = project_title  # type: str
        self.ret_date = ret_date  # type: str
        self.status = status  # type: int
        self.third_part_project_id = third_part_project_id  # type: str
        self.thirdpart_apply_id = thirdpart_apply_id  # type: str
        self.thirdpart_itinerary_id = thirdpart_itinerary_id  # type: str
        self.trip_type = trip_type  # type: int
        self.user_affiliate_list = user_affiliate_list  # type: list[FlightOrderListQueryResponseBodyModuleUserAffiliateList]
        self.user_id = user_id  # type: str
        self.user_name = user_name  # type: str

    def validate(self):
        if self.cost_center:
            self.cost_center.validate()
        if self.insure_info_list:
            for k in self.insure_info_list:
                if k:
                    k.validate()
        if self.invoice:
            self.invoice.validate()
        if self.price_info_list:
            for k in self.price_info_list:
                if k:
                    k.validate()
        if self.user_affiliate_list:
            for k in self.user_affiliate_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(FlightOrderListQueryResponseBodyModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.arr_airport is not None:
            result['arr_airport'] = self.arr_airport
        if self.arr_city is not None:
            result['arr_city'] = self.arr_city
        if self.btrip_title is not None:
            result['btrip_title'] = self.btrip_title
        if self.cabin_class is not None:
            result['cabin_class'] = self.cabin_class
        if self.contact_name is not None:
            result['contact_name'] = self.contact_name
        if self.corp_id is not None:
            result['corp_id'] = self.corp_id
        if self.corp_name is not None:
            result['corp_name'] = self.corp_name
        if self.cost_center is not None:
            result['cost_center'] = self.cost_center.to_map()
        if self.dep_airport is not None:
            result['dep_airport'] = self.dep_airport
        if self.dep_city is not None:
            result['dep_city'] = self.dep_city
        if self.dep_date is not None:
            result['dep_date'] = self.dep_date
        if self.depart_id is not None:
            result['depart_id'] = self.depart_id
        if self.depart_name is not None:
            result['depart_name'] = self.depart_name
        if self.discount is not None:
            result['discount'] = self.discount
        if self.flight_no is not None:
            result['flight_no'] = self.flight_no
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        if self.id is not None:
            result['id'] = self.id
        result['insure_info_list'] = []
        if self.insure_info_list is not None:
            for k in self.insure_info_list:
                result['insure_info_list'].append(k.to_map() if k else None)
        if self.invoice is not None:
            result['invoice'] = self.invoice.to_map()
        if self.passenger_count is not None:
            result['passenger_count'] = self.passenger_count
        if self.passenger_name is not None:
            result['passenger_name'] = self.passenger_name
        result['price_info_list'] = []
        if self.price_info_list is not None:
            for k in self.price_info_list:
                result['price_info_list'].append(k.to_map() if k else None)
        if self.project_code is not None:
            result['project_code'] = self.project_code
        if self.project_id is not None:
            result['project_id'] = self.project_id
        if self.project_title is not None:
            result['project_title'] = self.project_title
        if self.ret_date is not None:
            result['ret_date'] = self.ret_date
        if self.status is not None:
            result['status'] = self.status
        if self.third_part_project_id is not None:
            result['third_part_project_id'] = self.third_part_project_id
        if self.thirdpart_apply_id is not None:
            result['thirdpart_apply_id'] = self.thirdpart_apply_id
        if self.thirdpart_itinerary_id is not None:
            result['thirdpart_itinerary_id'] = self.thirdpart_itinerary_id
        if self.trip_type is not None:
            result['trip_type'] = self.trip_type
        result['user_affiliate_list'] = []
        if self.user_affiliate_list is not None:
            for k in self.user_affiliate_list:
                result['user_affiliate_list'].append(k.to_map() if k else None)
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('arr_airport') is not None:
            self.arr_airport = m.get('arr_airport')
        if m.get('arr_city') is not None:
            self.arr_city = m.get('arr_city')
        if m.get('btrip_title') is not None:
            self.btrip_title = m.get('btrip_title')
        if m.get('cabin_class') is not None:
            self.cabin_class = m.get('cabin_class')
        if m.get('contact_name') is not None:
            self.contact_name = m.get('contact_name')
        if m.get('corp_id') is not None:
            self.corp_id = m.get('corp_id')
        if m.get('corp_name') is not None:
            self.corp_name = m.get('corp_name')
        if m.get('cost_center') is not None:
            temp_model = FlightOrderListQueryResponseBodyModuleCostCenter()
            self.cost_center = temp_model.from_map(m['cost_center'])
        if m.get('dep_airport') is not None:
            self.dep_airport = m.get('dep_airport')
        if m.get('dep_city') is not None:
            self.dep_city = m.get('dep_city')
        if m.get('dep_date') is not None:
            self.dep_date = m.get('dep_date')
        if m.get('depart_id') is not None:
            self.depart_id = m.get('depart_id')
        if m.get('depart_name') is not None:
            self.depart_name = m.get('depart_name')
        if m.get('discount') is not None:
            self.discount = m.get('discount')
        if m.get('flight_no') is not None:
            self.flight_no = m.get('flight_no')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        if m.get('id') is not None:
            self.id = m.get('id')
        self.insure_info_list = []
        if m.get('insure_info_list') is not None:
            for k in m.get('insure_info_list'):
                temp_model = FlightOrderListQueryResponseBodyModuleInsureInfoList()
                self.insure_info_list.append(temp_model.from_map(k))
        if m.get('invoice') is not None:
            temp_model = FlightOrderListQueryResponseBodyModuleInvoice()
            self.invoice = temp_model.from_map(m['invoice'])
        if m.get('passenger_count') is not None:
            self.passenger_count = m.get('passenger_count')
        if m.get('passenger_name') is not None:
            self.passenger_name = m.get('passenger_name')
        self.price_info_list = []
        if m.get('price_info_list') is not None:
            for k in m.get('price_info_list'):
                temp_model = FlightOrderListQueryResponseBodyModulePriceInfoList()
                self.price_info_list.append(temp_model.from_map(k))
        if m.get('project_code') is not None:
            self.project_code = m.get('project_code')
        if m.get('project_id') is not None:
            self.project_id = m.get('project_id')
        if m.get('project_title') is not None:
            self.project_title = m.get('project_title')
        if m.get('ret_date') is not None:
            self.ret_date = m.get('ret_date')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('third_part_project_id') is not None:
            self.third_part_project_id = m.get('third_part_project_id')
        if m.get('thirdpart_apply_id') is not None:
            self.thirdpart_apply_id = m.get('thirdpart_apply_id')
        if m.get('thirdpart_itinerary_id') is not None:
            self.thirdpart_itinerary_id = m.get('thirdpart_itinerary_id')
        if m.get('trip_type') is not None:
            self.trip_type = m.get('trip_type')
        self.user_affiliate_list = []
        if m.get('user_affiliate_list') is not None:
            for k in m.get('user_affiliate_list'):
                temp_model = FlightOrderListQueryResponseBodyModuleUserAffiliateList()
                self.user_affiliate_list.append(temp_model.from_map(k))
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        return self


class FlightOrderListQueryResponseBodyPageInfo(TeaModel):
    def __init__(self, page=None, page_size=None, total_number=None):
        self.page = page  # type: int
        self.page_size = page_size  # type: int
        self.total_number = total_number  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightOrderListQueryResponseBodyPageInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page is not None:
            result['page'] = self.page
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.total_number is not None:
            result['total_number'] = self.total_number
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('page') is not None:
            self.page = m.get('page')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('total_number') is not None:
            self.total_number = m.get('total_number')
        return self


class FlightOrderListQueryResponseBody(TeaModel):
    def __init__(self, code=None, message=None, module=None, page_info=None, request_id=None, success=None,
                 trace_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.module = module  # type: list[FlightOrderListQueryResponseBodyModule]
        self.page_info = page_info  # type: FlightOrderListQueryResponseBodyPageInfo
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.trace_id = trace_id  # type: str

    def validate(self):
        if self.module:
            for k in self.module:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super(FlightOrderListQueryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        result['module'] = []
        if self.module is not None:
            for k in self.module:
                result['module'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['page_info'] = self.page_info.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        self.module = []
        if m.get('module') is not None:
            for k in m.get('module'):
                temp_model = FlightOrderListQueryResponseBodyModule()
                self.module.append(temp_model.from_map(k))
        if m.get('page_info') is not None:
            temp_model = FlightOrderListQueryResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['page_info'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class FlightOrderListQueryResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: FlightOrderListQueryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(FlightOrderListQueryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = FlightOrderListQueryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class FlightOrderQueryHeaders(TeaModel):
    def __init__(self, common_headers=None, x_acs_btrip_so_corp_token=None):
        self.common_headers = common_headers  # type: dict[str, str]
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightOrderQueryHeaders, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class FlightOrderQueryRequest(TeaModel):
    def __init__(self, order_id=None, user_id=None):
        self.order_id = order_id  # type: long
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightOrderQueryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.order_id is not None:
            result['order_id'] = self.order_id
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('order_id') is not None:
            self.order_id = m.get('order_id')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class FlightOrderQueryResponseBodyModuleFlightChangeTicketInfoList(TeaModel):
    def __init__(self, arr_time=None, change_cabin=None, change_cabin_level=None, change_fee=None,
                 change_flight_no=None, change_order_id=None, change_reason=None, change_type=None, dep_time=None, gmt_create=None,
                 gmt_modify=None, origin_ticket_no=None, ticket_no=None, upgrade_fee=None):
        self.arr_time = arr_time  # type: str
        self.change_cabin = change_cabin  # type: str
        self.change_cabin_level = change_cabin_level  # type: str
        self.change_fee = change_fee  # type: float
        self.change_flight_no = change_flight_no  # type: str
        self.change_order_id = change_order_id  # type: long
        self.change_reason = change_reason  # type: str
        self.change_type = change_type  # type: int
        self.dep_time = dep_time  # type: str
        self.gmt_create = gmt_create  # type: str
        self.gmt_modify = gmt_modify  # type: str
        self.origin_ticket_no = origin_ticket_no  # type: str
        self.ticket_no = ticket_no  # type: str
        self.upgrade_fee = upgrade_fee  # type: float

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightOrderQueryResponseBodyModuleFlightChangeTicketInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arr_time is not None:
            result['arr_time'] = self.arr_time
        if self.change_cabin is not None:
            result['change_cabin'] = self.change_cabin
        if self.change_cabin_level is not None:
            result['change_cabin_level'] = self.change_cabin_level
        if self.change_fee is not None:
            result['change_fee'] = self.change_fee
        if self.change_flight_no is not None:
            result['change_flight_no'] = self.change_flight_no
        if self.change_order_id is not None:
            result['change_order_id'] = self.change_order_id
        if self.change_reason is not None:
            result['change_reason'] = self.change_reason
        if self.change_type is not None:
            result['change_type'] = self.change_type
        if self.dep_time is not None:
            result['dep_time'] = self.dep_time
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modify is not None:
            result['gmt_modify'] = self.gmt_modify
        if self.origin_ticket_no is not None:
            result['origin_ticket_no'] = self.origin_ticket_no
        if self.ticket_no is not None:
            result['ticket_no'] = self.ticket_no
        if self.upgrade_fee is not None:
            result['upgrade_fee'] = self.upgrade_fee
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('arr_time') is not None:
            self.arr_time = m.get('arr_time')
        if m.get('change_cabin') is not None:
            self.change_cabin = m.get('change_cabin')
        if m.get('change_cabin_level') is not None:
            self.change_cabin_level = m.get('change_cabin_level')
        if m.get('change_fee') is not None:
            self.change_fee = m.get('change_fee')
        if m.get('change_flight_no') is not None:
            self.change_flight_no = m.get('change_flight_no')
        if m.get('change_order_id') is not None:
            self.change_order_id = m.get('change_order_id')
        if m.get('change_reason') is not None:
            self.change_reason = m.get('change_reason')
        if m.get('change_type') is not None:
            self.change_type = m.get('change_type')
        if m.get('dep_time') is not None:
            self.dep_time = m.get('dep_time')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modify') is not None:
            self.gmt_modify = m.get('gmt_modify')
        if m.get('origin_ticket_no') is not None:
            self.origin_ticket_no = m.get('origin_ticket_no')
        if m.get('ticket_no') is not None:
            self.ticket_no = m.get('ticket_no')
        if m.get('upgrade_fee') is not None:
            self.upgrade_fee = m.get('upgrade_fee')
        return self


class FlightOrderQueryResponseBodyModuleFlightInfoList(TeaModel):
    def __init__(self, airline_code=None, airline_name=None, arr_airport_code=None, arr_airport_name=None,
                 arr_city_code=None, arr_city_name=None, arr_time=None, cabin=None, cabin_level=None, dep_airport_code=None,
                 dep_airport_name=None, dep_city_code=None, dep_city_name=None, dep_time=None, flight_mile=None, flight_no=None):
        self.airline_code = airline_code  # type: str
        self.airline_name = airline_name  # type: str
        self.arr_airport_code = arr_airport_code  # type: str
        self.arr_airport_name = arr_airport_name  # type: str
        self.arr_city_code = arr_city_code  # type: str
        self.arr_city_name = arr_city_name  # type: str
        self.arr_time = arr_time  # type: str
        self.cabin = cabin  # type: str
        self.cabin_level = cabin_level  # type: str
        self.dep_airport_code = dep_airport_code  # type: str
        self.dep_airport_name = dep_airport_name  # type: str
        self.dep_city_code = dep_city_code  # type: str
        self.dep_city_name = dep_city_name  # type: str
        self.dep_time = dep_time  # type: str
        self.flight_mile = flight_mile  # type: int
        self.flight_no = flight_no  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightOrderQueryResponseBodyModuleFlightInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.airline_code is not None:
            result['airline_code'] = self.airline_code
        if self.airline_name is not None:
            result['airline_name'] = self.airline_name
        if self.arr_airport_code is not None:
            result['arr_airport_code'] = self.arr_airport_code
        if self.arr_airport_name is not None:
            result['arr_airport_name'] = self.arr_airport_name
        if self.arr_city_code is not None:
            result['arr_city_code'] = self.arr_city_code
        if self.arr_city_name is not None:
            result['arr_city_name'] = self.arr_city_name
        if self.arr_time is not None:
            result['arr_time'] = self.arr_time
        if self.cabin is not None:
            result['cabin'] = self.cabin
        if self.cabin_level is not None:
            result['cabin_level'] = self.cabin_level
        if self.dep_airport_code is not None:
            result['dep_airport_code'] = self.dep_airport_code
        if self.dep_airport_name is not None:
            result['dep_airport_name'] = self.dep_airport_name
        if self.dep_city_code is not None:
            result['dep_city_code'] = self.dep_city_code
        if self.dep_city_name is not None:
            result['dep_city_name'] = self.dep_city_name
        if self.dep_time is not None:
            result['dep_time'] = self.dep_time
        if self.flight_mile is not None:
            result['flight_mile'] = self.flight_mile
        if self.flight_no is not None:
            result['flight_no'] = self.flight_no
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('airline_code') is not None:
            self.airline_code = m.get('airline_code')
        if m.get('airline_name') is not None:
            self.airline_name = m.get('airline_name')
        if m.get('arr_airport_code') is not None:
            self.arr_airport_code = m.get('arr_airport_code')
        if m.get('arr_airport_name') is not None:
            self.arr_airport_name = m.get('arr_airport_name')
        if m.get('arr_city_code') is not None:
            self.arr_city_code = m.get('arr_city_code')
        if m.get('arr_city_name') is not None:
            self.arr_city_name = m.get('arr_city_name')
        if m.get('arr_time') is not None:
            self.arr_time = m.get('arr_time')
        if m.get('cabin') is not None:
            self.cabin = m.get('cabin')
        if m.get('cabin_level') is not None:
            self.cabin_level = m.get('cabin_level')
        if m.get('dep_airport_code') is not None:
            self.dep_airport_code = m.get('dep_airport_code')
        if m.get('dep_airport_name') is not None:
            self.dep_airport_name = m.get('dep_airport_name')
        if m.get('dep_city_code') is not None:
            self.dep_city_code = m.get('dep_city_code')
        if m.get('dep_city_name') is not None:
            self.dep_city_name = m.get('dep_city_name')
        if m.get('dep_time') is not None:
            self.dep_time = m.get('dep_time')
        if m.get('flight_mile') is not None:
            self.flight_mile = m.get('flight_mile')
        if m.get('flight_no') is not None:
            self.flight_no = m.get('flight_no')
        return self


class FlightOrderQueryResponseBodyModuleFlightRefundTicketInfoList(TeaModel):
    def __init__(self, gmt_create=None, gmt_modify=None, refund_order_id=None, refund_reason=None,
                 refund_ticket_fee=None, refund_type=None, ticket_no=None):
        self.gmt_create = gmt_create  # type: str
        self.gmt_modify = gmt_modify  # type: str
        self.refund_order_id = refund_order_id  # type: long
        self.refund_reason = refund_reason  # type: str
        self.refund_ticket_fee = refund_ticket_fee  # type: float
        self.refund_type = refund_type  # type: int
        self.ticket_no = ticket_no  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightOrderQueryResponseBodyModuleFlightRefundTicketInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modify is not None:
            result['gmt_modify'] = self.gmt_modify
        if self.refund_order_id is not None:
            result['refund_order_id'] = self.refund_order_id
        if self.refund_reason is not None:
            result['refund_reason'] = self.refund_reason
        if self.refund_ticket_fee is not None:
            result['refund_ticket_fee'] = self.refund_ticket_fee
        if self.refund_type is not None:
            result['refund_type'] = self.refund_type
        if self.ticket_no is not None:
            result['ticket_no'] = self.ticket_no
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modify') is not None:
            self.gmt_modify = m.get('gmt_modify')
        if m.get('refund_order_id') is not None:
            self.refund_order_id = m.get('refund_order_id')
        if m.get('refund_reason') is not None:
            self.refund_reason = m.get('refund_reason')
        if m.get('refund_ticket_fee') is not None:
            self.refund_ticket_fee = m.get('refund_ticket_fee')
        if m.get('refund_type') is not None:
            self.refund_type = m.get('refund_type')
        if m.get('ticket_no') is not None:
            self.ticket_no = m.get('ticket_no')
        return self


class FlightOrderQueryResponseBodyModuleFlightTicketInfoList(TeaModel):
    def __init__(self, build_price=None, changed=None, discount=None, gmt_create=None, gmt_modify=None,
                 oil_price=None, pay_type=None, settle_price=None, ticket_no=None, ticket_price=None, ticket_status=None,
                 ticket_status_code=None, user_id=None):
        self.build_price = build_price  # type: float
        self.changed = changed  # type: bool
        self.discount = discount  # type: int
        self.gmt_create = gmt_create  # type: str
        self.gmt_modify = gmt_modify  # type: str
        self.oil_price = oil_price  # type: float
        self.pay_type = pay_type  # type: int
        self.settle_price = settle_price  # type: float
        self.ticket_no = ticket_no  # type: str
        self.ticket_price = ticket_price  # type: float
        self.ticket_status = ticket_status  # type: str
        self.ticket_status_code = ticket_status_code  # type: int
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightOrderQueryResponseBodyModuleFlightTicketInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.build_price is not None:
            result['build_price'] = self.build_price
        if self.changed is not None:
            result['changed'] = self.changed
        if self.discount is not None:
            result['discount'] = self.discount
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modify is not None:
            result['gmt_modify'] = self.gmt_modify
        if self.oil_price is not None:
            result['oil_price'] = self.oil_price
        if self.pay_type is not None:
            result['pay_type'] = self.pay_type
        if self.settle_price is not None:
            result['settle_price'] = self.settle_price
        if self.ticket_no is not None:
            result['ticket_no'] = self.ticket_no
        if self.ticket_price is not None:
            result['ticket_price'] = self.ticket_price
        if self.ticket_status is not None:
            result['ticket_status'] = self.ticket_status
        if self.ticket_status_code is not None:
            result['ticket_status_code'] = self.ticket_status_code
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('build_price') is not None:
            self.build_price = m.get('build_price')
        if m.get('changed') is not None:
            self.changed = m.get('changed')
        if m.get('discount') is not None:
            self.discount = m.get('discount')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modify') is not None:
            self.gmt_modify = m.get('gmt_modify')
        if m.get('oil_price') is not None:
            self.oil_price = m.get('oil_price')
        if m.get('pay_type') is not None:
            self.pay_type = m.get('pay_type')
        if m.get('settle_price') is not None:
            self.settle_price = m.get('settle_price')
        if m.get('ticket_no') is not None:
            self.ticket_no = m.get('ticket_no')
        if m.get('ticket_price') is not None:
            self.ticket_price = m.get('ticket_price')
        if m.get('ticket_status') is not None:
            self.ticket_status = m.get('ticket_status')
        if m.get('ticket_status_code') is not None:
            self.ticket_status_code = m.get('ticket_status_code')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class FlightOrderQueryResponseBodyModuleInsuranceInfoList(TeaModel):
    def __init__(self, amount=None, insurance_no=None, status=None, type=None):
        self.amount = amount  # type: float
        self.insurance_no = insurance_no  # type: str
        self.status = status  # type: int
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightOrderQueryResponseBodyModuleInsuranceInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.amount is not None:
            result['amount'] = self.amount
        if self.insurance_no is not None:
            result['insurance_no'] = self.insurance_no
        if self.status is not None:
            result['status'] = self.status
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('amount') is not None:
            self.amount = m.get('amount')
        if m.get('insurance_no') is not None:
            self.insurance_no = m.get('insurance_no')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class FlightOrderQueryResponseBodyModuleInvoiceInfo(TeaModel):
    def __init__(self, id=None, title=None):
        self.id = id  # type: long
        self.title = title  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightOrderQueryResponseBodyModuleInvoiceInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightOrderQueryResponseBodyModuleOrderBaseInfo(TeaModel):
    def __init__(self, apply_id=None, btrip_title=None, contact_name=None, corp_id=None, corp_name=None,
                 depart_id=None, depart_name=None, gmt_create=None, gmt_modify=None, itinerary_id=None, order_id=None,
                 order_status=None, thirdpart_apply_id=None, thirdpart_corp_id=None, thirdpart_itinerary_id=None,
                 trip_type=None, user_id=None):
        self.apply_id = apply_id  # type: str
        self.btrip_title = btrip_title  # type: str
        self.contact_name = contact_name  # type: str
        self.corp_id = corp_id  # type: str
        self.corp_name = corp_name  # type: str
        self.depart_id = depart_id  # type: str
        self.depart_name = depart_name  # type: str
        self.gmt_create = gmt_create  # type: str
        self.gmt_modify = gmt_modify  # type: str
        self.itinerary_id = itinerary_id  # type: str
        self.order_id = order_id  # type: long
        self.order_status = order_status  # type: int
        self.thirdpart_apply_id = thirdpart_apply_id  # type: str
        self.thirdpart_corp_id = thirdpart_corp_id  # type: str
        self.thirdpart_itinerary_id = thirdpart_itinerary_id  # type: str
        self.trip_type = trip_type  # type: int
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightOrderQueryResponseBodyModuleOrderBaseInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.btrip_title is not None:
            result['btrip_title'] = self.btrip_title
        if self.contact_name is not None:
            result['contact_name'] = self.contact_name
        if self.corp_id is not None:
            result['corp_id'] = self.corp_id
        if self.corp_name is not None:
            result['corp_name'] = self.corp_name
        if self.depart_id is not None:
            result['depart_id'] = self.depart_id
        if self.depart_name is not None:
            result['depart_name'] = self.depart_name
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modify is not None:
            result['gmt_modify'] = self.gmt_modify
        if self.itinerary_id is not None:
            result['itinerary_id'] = self.itinerary_id
        if self.order_id is not None:
            result['order_id'] = self.order_id
        if self.order_status is not None:
            result['order_status'] = self.order_status
        if self.thirdpart_apply_id is not None:
            result['thirdpart_apply_id'] = self.thirdpart_apply_id
        if self.thirdpart_corp_id is not None:
            result['thirdpart_corp_id'] = self.thirdpart_corp_id
        if self.thirdpart_itinerary_id is not None:
            result['thirdpart_itinerary_id'] = self.thirdpart_itinerary_id
        if self.trip_type is not None:
            result['trip_type'] = self.trip_type
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('btrip_title') is not None:
            self.btrip_title = m.get('btrip_title')
        if m.get('contact_name') is not None:
            self.contact_name = m.get('contact_name')
        if m.get('corp_id') is not None:
            self.corp_id = m.get('corp_id')
        if m.get('corp_name') is not None:
            self.corp_name = m.get('corp_name')
        if m.get('depart_id') is not None:
            self.depart_id = m.get('depart_id')
        if m.get('depart_name') is not None:
            self.depart_name = m.get('depart_name')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modify') is not None:
            self.gmt_modify = m.get('gmt_modify')
        if m.get('itinerary_id') is not None:
            self.itinerary_id = m.get('itinerary_id')
        if m.get('order_id') is not None:
            self.order_id = m.get('order_id')
        if m.get('order_status') is not None:
            self.order_status = m.get('order_status')
        if m.get('thirdpart_apply_id') is not None:
            self.thirdpart_apply_id = m.get('thirdpart_apply_id')
        if m.get('thirdpart_corp_id') is not None:
            self.thirdpart_corp_id = m.get('thirdpart_corp_id')
        if m.get('thirdpart_itinerary_id') is not None:
            self.thirdpart_itinerary_id = m.get('thirdpart_itinerary_id')
        if m.get('trip_type') is not None:
            self.trip_type = m.get('trip_type')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class FlightOrderQueryResponseBodyModulePassengerInfoList(TeaModel):
    def __init__(self, cost_center_id=None, cost_center_name=None, cost_center_number=None, project_code=None,
                 project_id=None, project_title=None, thirdpart_project_id=None, user_id=None, user_name=None, user_type=None):
        self.cost_center_id = cost_center_id  # type: long
        self.cost_center_name = cost_center_name  # type: str
        self.cost_center_number = cost_center_number  # type: str
        self.project_code = project_code  # type: str
        self.project_id = project_id  # type: long
        self.project_title = project_title  # type: str
        self.thirdpart_project_id = thirdpart_project_id  # type: str
        self.user_id = user_id  # type: str
        self.user_name = user_name  # type: str
        self.user_type = user_type  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightOrderQueryResponseBodyModulePassengerInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cost_center_id is not None:
            result['cost_center_id'] = self.cost_center_id
        if self.cost_center_name is not None:
            result['cost_center_name'] = self.cost_center_name
        if self.cost_center_number is not None:
            result['cost_center_number'] = self.cost_center_number
        if self.project_code is not None:
            result['project_code'] = self.project_code
        if self.project_id is not None:
            result['project_id'] = self.project_id
        if self.project_title is not None:
            result['project_title'] = self.project_title
        if self.thirdpart_project_id is not None:
            result['thirdpart_project_id'] = self.thirdpart_project_id
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        if self.user_type is not None:
            result['user_type'] = self.user_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('cost_center_id') is not None:
            self.cost_center_id = m.get('cost_center_id')
        if m.get('cost_center_name') is not None:
            self.cost_center_name = m.get('cost_center_name')
        if m.get('cost_center_number') is not None:
            self.cost_center_number = m.get('cost_center_number')
        if m.get('project_code') is not None:
            self.project_code = m.get('project_code')
        if m.get('project_id') is not None:
            self.project_id = m.get('project_id')
        if m.get('project_title') is not None:
            self.project_title = m.get('project_title')
        if m.get('thirdpart_project_id') is not None:
            self.thirdpart_project_id = m.get('thirdpart_project_id')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        if m.get('user_type') is not None:
            self.user_type = m.get('user_type')
        return self


class FlightOrderQueryResponseBodyModulePriceInfoList(TeaModel):
    def __init__(self, category_code=None, gmt_create=None, passenger_name=None, pay_type=None, price=None,
                 trade_id=None, type=None):
        self.category_code = category_code  # type: int
        self.gmt_create = gmt_create  # type: str
        self.passenger_name = passenger_name  # type: str
        self.pay_type = pay_type  # type: int
        self.price = price  # type: float
        self.trade_id = trade_id  # type: str
        self.type = type  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightOrderQueryResponseBodyModulePriceInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category_code is not None:
            result['category_code'] = self.category_code
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.passenger_name is not None:
            result['passenger_name'] = self.passenger_name
        if self.pay_type is not None:
            result['pay_type'] = self.pay_type
        if self.price is not None:
            result['price'] = self.price
        if self.trade_id is not None:
            result['trade_id'] = self.trade_id
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('category_code') is not None:
            self.category_code = m.get('category_code')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('passenger_name') is not None:
            self.passenger_name = m.get('passenger_name')
        if m.get('pay_type') is not None:
            self.pay_type = m.get('pay_type')
        if m.get('price') is not None:
            self.price = m.get('price')
        if m.get('trade_id') is not None:
            self.trade_id = m.get('trade_id')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class FlightOrderQueryResponseBodyModule(TeaModel):
    def __init__(self, flight_change_ticket_info_list=None, flight_info_list=None,
                 flight_refund_ticket_info_list=None, flight_ticket_info_list=None, insurance_info_list=None, invoice_info=None,
                 order_base_info=None, passenger_info_list=None, price_info_list=None):
        self.flight_change_ticket_info_list = flight_change_ticket_info_list  # type: list[FlightOrderQueryResponseBodyModuleFlightChangeTicketInfoList]
        self.flight_info_list = flight_info_list  # type: list[FlightOrderQueryResponseBodyModuleFlightInfoList]
        self.flight_refund_ticket_info_list = flight_refund_ticket_info_list  # type: list[FlightOrderQueryResponseBodyModuleFlightRefundTicketInfoList]
        self.flight_ticket_info_list = flight_ticket_info_list  # type: list[FlightOrderQueryResponseBodyModuleFlightTicketInfoList]
        self.insurance_info_list = insurance_info_list  # type: list[FlightOrderQueryResponseBodyModuleInsuranceInfoList]
        self.invoice_info = invoice_info  # type: FlightOrderQueryResponseBodyModuleInvoiceInfo
        self.order_base_info = order_base_info  # type: FlightOrderQueryResponseBodyModuleOrderBaseInfo
        self.passenger_info_list = passenger_info_list  # type: list[FlightOrderQueryResponseBodyModulePassengerInfoList]
        self.price_info_list = price_info_list  # type: list[FlightOrderQueryResponseBodyModulePriceInfoList]

    def validate(self):
        if self.flight_change_ticket_info_list:
            for k in self.flight_change_ticket_info_list:
                if k:
                    k.validate()
        if self.flight_info_list:
            for k in self.flight_info_list:
                if k:
                    k.validate()
        if self.flight_refund_ticket_info_list:
            for k in self.flight_refund_ticket_info_list:
                if k:
                    k.validate()
        if self.flight_ticket_info_list:
            for k in self.flight_ticket_info_list:
                if k:
                    k.validate()
        if self.insurance_info_list:
            for k in self.insurance_info_list:
                if k:
                    k.validate()
        if self.invoice_info:
            self.invoice_info.validate()
        if self.order_base_info:
            self.order_base_info.validate()
        if self.passenger_info_list:
            for k in self.passenger_info_list:
                if k:
                    k.validate()
        if self.price_info_list:
            for k in self.price_info_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(FlightOrderQueryResponseBodyModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['flight_change_ticket_info_list'] = []
        if self.flight_change_ticket_info_list is not None:
            for k in self.flight_change_ticket_info_list:
                result['flight_change_ticket_info_list'].append(k.to_map() if k else None)
        result['flight_info_list'] = []
        if self.flight_info_list is not None:
            for k in self.flight_info_list:
                result['flight_info_list'].append(k.to_map() if k else None)
        result['flight_refund_ticket_info_list'] = []
        if self.flight_refund_ticket_info_list is not None:
            for k in self.flight_refund_ticket_info_list:
                result['flight_refund_ticket_info_list'].append(k.to_map() if k else None)
        result['flight_ticket_info_list'] = []
        if self.flight_ticket_info_list is not None:
            for k in self.flight_ticket_info_list:
                result['flight_ticket_info_list'].append(k.to_map() if k else None)
        result['insurance_info_list'] = []
        if self.insurance_info_list is not None:
            for k in self.insurance_info_list:
                result['insurance_info_list'].append(k.to_map() if k else None)
        if self.invoice_info is not None:
            result['invoice_info'] = self.invoice_info.to_map()
        if self.order_base_info is not None:
            result['order_base_info'] = self.order_base_info.to_map()
        result['passenger_info_list'] = []
        if self.passenger_info_list is not None:
            for k in self.passenger_info_list:
                result['passenger_info_list'].append(k.to_map() if k else None)
        result['price_info_list'] = []
        if self.price_info_list is not None:
            for k in self.price_info_list:
                result['price_info_list'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.flight_change_ticket_info_list = []
        if m.get('flight_change_ticket_info_list') is not None:
            for k in m.get('flight_change_ticket_info_list'):
                temp_model = FlightOrderQueryResponseBodyModuleFlightChangeTicketInfoList()
                self.flight_change_ticket_info_list.append(temp_model.from_map(k))
        self.flight_info_list = []
        if m.get('flight_info_list') is not None:
            for k in m.get('flight_info_list'):
                temp_model = FlightOrderQueryResponseBodyModuleFlightInfoList()
                self.flight_info_list.append(temp_model.from_map(k))
        self.flight_refund_ticket_info_list = []
        if m.get('flight_refund_ticket_info_list') is not None:
            for k in m.get('flight_refund_ticket_info_list'):
                temp_model = FlightOrderQueryResponseBodyModuleFlightRefundTicketInfoList()
                self.flight_refund_ticket_info_list.append(temp_model.from_map(k))
        self.flight_ticket_info_list = []
        if m.get('flight_ticket_info_list') is not None:
            for k in m.get('flight_ticket_info_list'):
                temp_model = FlightOrderQueryResponseBodyModuleFlightTicketInfoList()
                self.flight_ticket_info_list.append(temp_model.from_map(k))
        self.insurance_info_list = []
        if m.get('insurance_info_list') is not None:
            for k in m.get('insurance_info_list'):
                temp_model = FlightOrderQueryResponseBodyModuleInsuranceInfoList()
                self.insurance_info_list.append(temp_model.from_map(k))
        if m.get('invoice_info') is not None:
            temp_model = FlightOrderQueryResponseBodyModuleInvoiceInfo()
            self.invoice_info = temp_model.from_map(m['invoice_info'])
        if m.get('order_base_info') is not None:
            temp_model = FlightOrderQueryResponseBodyModuleOrderBaseInfo()
            self.order_base_info = temp_model.from_map(m['order_base_info'])
        self.passenger_info_list = []
        if m.get('passenger_info_list') is not None:
            for k in m.get('passenger_info_list'):
                temp_model = FlightOrderQueryResponseBodyModulePassengerInfoList()
                self.passenger_info_list.append(temp_model.from_map(k))
        self.price_info_list = []
        if m.get('price_info_list') is not None:
            for k in m.get('price_info_list'):
                temp_model = FlightOrderQueryResponseBodyModulePriceInfoList()
                self.price_info_list.append(temp_model.from_map(k))
        return self


class FlightOrderQueryResponseBody(TeaModel):
    def __init__(self, code=None, message=None, module=None, request_id=None, success=None, trace_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.module = module  # type: FlightOrderQueryResponseBodyModule
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.trace_id = trace_id  # type: str

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super(FlightOrderQueryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = FlightOrderQueryResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class FlightOrderQueryResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: FlightOrderQueryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(FlightOrderQueryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = FlightOrderQueryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class FlightPayOrderHeaders(TeaModel):
    def __init__(self, common_headers=None, x_acs_btrip_corp_token=None):
        self.common_headers = common_headers  # type: dict[str, str]
        self.x_acs_btrip_corp_token = x_acs_btrip_corp_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightPayOrderHeaders, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_corp_token is not None:
            result['x-acs-btrip-corp-token'] = self.x_acs_btrip_corp_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-corp-token') is not None:
            self.x_acs_btrip_corp_token = m.get('x-acs-btrip-corp-token')
        return self


class FlightPayOrderRequest(TeaModel):
    def __init__(self, corp_pay_price=None, dis_order_id=None, extra=None, personal_pay_price=None,
                 total_pay_price=None):
        self.corp_pay_price = corp_pay_price  # type: long
        self.dis_order_id = dis_order_id  # type: str
        self.extra = extra  # type: dict[str, str]
        self.personal_pay_price = personal_pay_price  # type: long
        self.total_pay_price = total_pay_price  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightPayOrderRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_pay_price is not None:
            result['corp_pay_price'] = self.corp_pay_price
        if self.dis_order_id is not None:
            result['dis_order_id'] = self.dis_order_id
        if self.extra is not None:
            result['extra'] = self.extra
        if self.personal_pay_price is not None:
            result['personal_pay_price'] = self.personal_pay_price
        if self.total_pay_price is not None:
            result['total_pay_price'] = self.total_pay_price
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('corp_pay_price') is not None:
            self.corp_pay_price = m.get('corp_pay_price')
        if m.get('dis_order_id') is not None:
            self.dis_order_id = m.get('dis_order_id')
        if m.get('extra') is not None:
            self.extra = m.get('extra')
        if m.get('personal_pay_price') is not None:
            self.personal_pay_price = m.get('personal_pay_price')
        if m.get('total_pay_price') is not None:
            self.total_pay_price = m.get('total_pay_price')
        return self


class FlightPayOrderShrinkRequest(TeaModel):
    def __init__(self, corp_pay_price=None, dis_order_id=None, extra_shrink=None, personal_pay_price=None,
                 total_pay_price=None):
        self.corp_pay_price = corp_pay_price  # type: long
        self.dis_order_id = dis_order_id  # type: str
        self.extra_shrink = extra_shrink  # type: str
        self.personal_pay_price = personal_pay_price  # type: long
        self.total_pay_price = total_pay_price  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightPayOrderShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_pay_price is not None:
            result['corp_pay_price'] = self.corp_pay_price
        if self.dis_order_id is not None:
            result['dis_order_id'] = self.dis_order_id
        if self.extra_shrink is not None:
            result['extra'] = self.extra_shrink
        if self.personal_pay_price is not None:
            result['personal_pay_price'] = self.personal_pay_price
        if self.total_pay_price is not None:
            result['total_pay_price'] = self.total_pay_price
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('corp_pay_price') is not None:
            self.corp_pay_price = m.get('corp_pay_price')
        if m.get('dis_order_id') is not None:
            self.dis_order_id = m.get('dis_order_id')
        if m.get('extra') is not None:
            self.extra_shrink = m.get('extra')
        if m.get('personal_pay_price') is not None:
            self.personal_pay_price = m.get('personal_pay_price')
        if m.get('total_pay_price') is not None:
            self.total_pay_price = m.get('total_pay_price')
        return self


class FlightPayOrderResponseBodyModule(TeaModel):
    def __init__(self, actual_pay_price=None, alipay_trade_no=None, last_pay_time=None, pay_status=None):
        self.actual_pay_price = actual_pay_price  # type: long
        self.alipay_trade_no = alipay_trade_no  # type: str
        self.last_pay_time = last_pay_time  # type: str
        self.pay_status = pay_status  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightPayOrderResponseBodyModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.actual_pay_price is not None:
            result['actual_pay_price'] = self.actual_pay_price
        if self.alipay_trade_no is not None:
            result['alipay_trade_no'] = self.alipay_trade_no
        if self.last_pay_time is not None:
            result['last_pay_time'] = self.last_pay_time
        if self.pay_status is not None:
            result['pay_status'] = self.pay_status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('actual_pay_price') is not None:
            self.actual_pay_price = m.get('actual_pay_price')
        if m.get('alipay_trade_no') is not None:
            self.alipay_trade_no = m.get('alipay_trade_no')
        if m.get('last_pay_time') is not None:
            self.last_pay_time = m.get('last_pay_time')
        if m.get('pay_status') is not None:
            self.pay_status = m.get('pay_status')
        return self


class FlightPayOrderResponseBody(TeaModel):
    def __init__(self, code=None, message=None, module=None, request_id=None, success=None, trace_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.module = module  # type: FlightPayOrderResponseBodyModule
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.trace_id = trace_id  # type: str

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super(FlightPayOrderResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = FlightPayOrderResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class FlightPayOrderResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: FlightPayOrderResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(FlightPayOrderResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = FlightPayOrderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class FlightRefundApplyHeaders(TeaModel):
    def __init__(self, common_headers=None, x_acs_btrip_corp_token=None):
        self.common_headers = common_headers  # type: dict[str, str]
        self.x_acs_btrip_corp_token = x_acs_btrip_corp_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightRefundApplyHeaders, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_corp_token is not None:
            result['x-acs-btrip-corp-token'] = self.x_acs_btrip_corp_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-corp-token') is not None:
            self.x_acs_btrip_corp_token = m.get('x-acs-btrip-corp-token')
        return self


class FlightRefundApplyRequestPassengerSegmentInfoList(TeaModel):
    def __init__(self, flight_no=None, passenger_name=None, user_id=None):
        self.flight_no = flight_no  # type: str
        self.passenger_name = passenger_name  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightRefundApplyRequestPassengerSegmentInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.flight_no is not None:
            result['flight_no'] = self.flight_no
        if self.passenger_name is not None:
            result['passenger_name'] = self.passenger_name
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('flight_no') is not None:
            self.flight_no = m.get('flight_no')
        if m.get('passenger_name') is not None:
            self.passenger_name = m.get('passenger_name')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class FlightRefundApplyRequest(TeaModel):
    def __init__(self, corp_refund_price=None, dis_order_id=None, dis_sub_order_id=None, display_refund_money=None,
                 extra=None, is_voluntary=None, item_unit_ids=None, passenger_segment_info_list=None,
                 personal_refund_price=None, reason_detail=None, reason_type=None, refund_voucher_info=None, session_id=None,
                 total_refund_price=None):
        self.corp_refund_price = corp_refund_price  # type: long
        self.dis_order_id = dis_order_id  # type: str
        self.dis_sub_order_id = dis_sub_order_id  # type: str
        self.display_refund_money = display_refund_money  # type: str
        self.extra = extra  # type: dict[str, str]
        self.is_voluntary = is_voluntary  # type: int
        self.item_unit_ids = item_unit_ids  # type: str
        self.passenger_segment_info_list = passenger_segment_info_list  # type: list[FlightRefundApplyRequestPassengerSegmentInfoList]
        self.personal_refund_price = personal_refund_price  # type: long
        self.reason_detail = reason_detail  # type: str
        self.reason_type = reason_type  # type: int
        self.refund_voucher_info = refund_voucher_info  # type: list[str]
        self.session_id = session_id  # type: str
        self.total_refund_price = total_refund_price  # type: long

    def validate(self):
        if self.passenger_segment_info_list:
            for k in self.passenger_segment_info_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(FlightRefundApplyRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_refund_price is not None:
            result['corp_refund_price'] = self.corp_refund_price
        if self.dis_order_id is not None:
            result['dis_order_id'] = self.dis_order_id
        if self.dis_sub_order_id is not None:
            result['dis_sub_order_id'] = self.dis_sub_order_id
        if self.display_refund_money is not None:
            result['display_refund_money'] = self.display_refund_money
        if self.extra is not None:
            result['extra'] = self.extra
        if self.is_voluntary is not None:
            result['is_voluntary'] = self.is_voluntary
        if self.item_unit_ids is not None:
            result['item_unit_ids'] = self.item_unit_ids
        result['passenger_segment_info_list'] = []
        if self.passenger_segment_info_list is not None:
            for k in self.passenger_segment_info_list:
                result['passenger_segment_info_list'].append(k.to_map() if k else None)
        if self.personal_refund_price is not None:
            result['personal_refund_price'] = self.personal_refund_price
        if self.reason_detail is not None:
            result['reason_detail'] = self.reason_detail
        if self.reason_type is not None:
            result['reason_type'] = self.reason_type
        if self.refund_voucher_info is not None:
            result['refund_voucher_info'] = self.refund_voucher_info
        if self.session_id is not None:
            result['session_id'] = self.session_id
        if self.total_refund_price is not None:
            result['total_refund_price'] = self.total_refund_price
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('corp_refund_price') is not None:
            self.corp_refund_price = m.get('corp_refund_price')
        if m.get('dis_order_id') is not None:
            self.dis_order_id = m.get('dis_order_id')
        if m.get('dis_sub_order_id') is not None:
            self.dis_sub_order_id = m.get('dis_sub_order_id')
        if m.get('display_refund_money') is not None:
            self.display_refund_money = m.get('display_refund_money')
        if m.get('extra') is not None:
            self.extra = m.get('extra')
        if m.get('is_voluntary') is not None:
            self.is_voluntary = m.get('is_voluntary')
        if m.get('item_unit_ids') is not None:
            self.item_unit_ids = m.get('item_unit_ids')
        self.passenger_segment_info_list = []
        if m.get('passenger_segment_info_list') is not None:
            for k in m.get('passenger_segment_info_list'):
                temp_model = FlightRefundApplyRequestPassengerSegmentInfoList()
                self.passenger_segment_info_list.append(temp_model.from_map(k))
        if m.get('personal_refund_price') is not None:
            self.personal_refund_price = m.get('personal_refund_price')
        if m.get('reason_detail') is not None:
            self.reason_detail = m.get('reason_detail')
        if m.get('reason_type') is not None:
            self.reason_type = m.get('reason_type')
        if m.get('refund_voucher_info') is not None:
            self.refund_voucher_info = m.get('refund_voucher_info')
        if m.get('session_id') is not None:
            self.session_id = m.get('session_id')
        if m.get('total_refund_price') is not None:
            self.total_refund_price = m.get('total_refund_price')
        return self


class FlightRefundApplyShrinkRequest(TeaModel):
    def __init__(self, corp_refund_price=None, dis_order_id=None, dis_sub_order_id=None, display_refund_money=None,
                 extra_shrink=None, is_voluntary=None, item_unit_ids=None, passenger_segment_info_list_shrink=None,
                 personal_refund_price=None, reason_detail=None, reason_type=None, refund_voucher_info_shrink=None, session_id=None,
                 total_refund_price=None):
        self.corp_refund_price = corp_refund_price  # type: long
        self.dis_order_id = dis_order_id  # type: str
        self.dis_sub_order_id = dis_sub_order_id  # type: str
        self.display_refund_money = display_refund_money  # type: str
        self.extra_shrink = extra_shrink  # type: str
        self.is_voluntary = is_voluntary  # type: int
        self.item_unit_ids = item_unit_ids  # type: str
        self.passenger_segment_info_list_shrink = passenger_segment_info_list_shrink  # type: str
        self.personal_refund_price = personal_refund_price  # type: long
        self.reason_detail = reason_detail  # type: str
        self.reason_type = reason_type  # type: int
        self.refund_voucher_info_shrink = refund_voucher_info_shrink  # type: str
        self.session_id = session_id  # type: str
        self.total_refund_price = total_refund_price  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightRefundApplyShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_refund_price is not None:
            result['corp_refund_price'] = self.corp_refund_price
        if self.dis_order_id is not None:
            result['dis_order_id'] = self.dis_order_id
        if self.dis_sub_order_id is not None:
            result['dis_sub_order_id'] = self.dis_sub_order_id
        if self.display_refund_money is not None:
            result['display_refund_money'] = self.display_refund_money
        if self.extra_shrink is not None:
            result['extra'] = self.extra_shrink
        if self.is_voluntary is not None:
            result['is_voluntary'] = self.is_voluntary
        if self.item_unit_ids is not None:
            result['item_unit_ids'] = self.item_unit_ids
        if self.passenger_segment_info_list_shrink is not None:
            result['passenger_segment_info_list'] = self.passenger_segment_info_list_shrink
        if self.personal_refund_price is not None:
            result['personal_refund_price'] = self.personal_refund_price
        if self.reason_detail is not None:
            result['reason_detail'] = self.reason_detail
        if self.reason_type is not None:
            result['reason_type'] = self.reason_type
        if self.refund_voucher_info_shrink is not None:
            result['refund_voucher_info'] = self.refund_voucher_info_shrink
        if self.session_id is not None:
            result['session_id'] = self.session_id
        if self.total_refund_price is not None:
            result['total_refund_price'] = self.total_refund_price
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('corp_refund_price') is not None:
            self.corp_refund_price = m.get('corp_refund_price')
        if m.get('dis_order_id') is not None:
            self.dis_order_id = m.get('dis_order_id')
        if m.get('dis_sub_order_id') is not None:
            self.dis_sub_order_id = m.get('dis_sub_order_id')
        if m.get('display_refund_money') is not None:
            self.display_refund_money = m.get('display_refund_money')
        if m.get('extra') is not None:
            self.extra_shrink = m.get('extra')
        if m.get('is_voluntary') is not None:
            self.is_voluntary = m.get('is_voluntary')
        if m.get('item_unit_ids') is not None:
            self.item_unit_ids = m.get('item_unit_ids')
        if m.get('passenger_segment_info_list') is not None:
            self.passenger_segment_info_list_shrink = m.get('passenger_segment_info_list')
        if m.get('personal_refund_price') is not None:
            self.personal_refund_price = m.get('personal_refund_price')
        if m.get('reason_detail') is not None:
            self.reason_detail = m.get('reason_detail')
        if m.get('reason_type') is not None:
            self.reason_type = m.get('reason_type')
        if m.get('refund_voucher_info') is not None:
            self.refund_voucher_info_shrink = m.get('refund_voucher_info')
        if m.get('session_id') is not None:
            self.session_id = m.get('session_id')
        if m.get('total_refund_price') is not None:
            self.total_refund_price = m.get('total_refund_price')
        return self


class FlightRefundApplyResponseBodyModule(TeaModel):
    def __init__(self, dis_order_id=None, dis_sub_order_id=None, refund_apply_id=None, refund_fee=None,
                 refund_money=None):
        self.dis_order_id = dis_order_id  # type: str
        self.dis_sub_order_id = dis_sub_order_id  # type: str
        self.refund_apply_id = refund_apply_id  # type: long
        self.refund_fee = refund_fee  # type: long
        self.refund_money = refund_money  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightRefundApplyResponseBodyModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dis_order_id is not None:
            result['dis_order_id'] = self.dis_order_id
        if self.dis_sub_order_id is not None:
            result['dis_sub_order_id'] = self.dis_sub_order_id
        if self.refund_apply_id is not None:
            result['refund_apply_id'] = self.refund_apply_id
        if self.refund_fee is not None:
            result['refund_fee'] = self.refund_fee
        if self.refund_money is not None:
            result['refund_money'] = self.refund_money
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('dis_order_id') is not None:
            self.dis_order_id = m.get('dis_order_id')
        if m.get('dis_sub_order_id') is not None:
            self.dis_sub_order_id = m.get('dis_sub_order_id')
        if m.get('refund_apply_id') is not None:
            self.refund_apply_id = m.get('refund_apply_id')
        if m.get('refund_fee') is not None:
            self.refund_fee = m.get('refund_fee')
        if m.get('refund_money') is not None:
            self.refund_money = m.get('refund_money')
        return self


class FlightRefundApplyResponseBody(TeaModel):
    def __init__(self, code=None, message=None, module=None, request_id=None, success=None, trace_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.module = module  # type: FlightRefundApplyResponseBodyModule
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.trace_id = trace_id  # type: str

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super(FlightRefundApplyResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = FlightRefundApplyResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class FlightRefundApplyResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: FlightRefundApplyResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(FlightRefundApplyResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = FlightRefundApplyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class FlightRefundDetailHeaders(TeaModel):
    def __init__(self, common_headers=None, x_acs_btrip_corp_token=None):
        self.common_headers = common_headers  # type: dict[str, str]
        self.x_acs_btrip_corp_token = x_acs_btrip_corp_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightRefundDetailHeaders, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_corp_token is not None:
            result['x-acs-btrip-corp-token'] = self.x_acs_btrip_corp_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-corp-token') is not None:
            self.x_acs_btrip_corp_token = m.get('x-acs-btrip-corp-token')
        return self


class FlightRefundDetailRequest(TeaModel):
    def __init__(self, dis_order_id=None, dis_sub_order_id=None):
        self.dis_order_id = dis_order_id  # type: str
        self.dis_sub_order_id = dis_sub_order_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightRefundDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dis_order_id is not None:
            result['dis_order_id'] = self.dis_order_id
        if self.dis_sub_order_id is not None:
            result['dis_sub_order_id'] = self.dis_sub_order_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('dis_order_id') is not None:
            self.dis_order_id = m.get('dis_order_id')
        if m.get('dis_sub_order_id') is not None:
            self.dis_sub_order_id = m.get('dis_sub_order_id')
        return self


class FlightRefundDetailResponseBodyModuleRefundFeeList(TeaModel):
    def __init__(self, alipay_trade_no=None, refund_fee=None, refund_price=None, status=None):
        self.alipay_trade_no = alipay_trade_no  # type: str
        self.refund_fee = refund_fee  # type: long
        self.refund_price = refund_price  # type: long
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightRefundDetailResponseBodyModuleRefundFeeList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alipay_trade_no is not None:
            result['alipay_trade_no'] = self.alipay_trade_no
        if self.refund_fee is not None:
            result['refund_fee'] = self.refund_fee
        if self.refund_price is not None:
            result['refund_price'] = self.refund_price
        if self.status is not None:
            result['status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('alipay_trade_no') is not None:
            self.alipay_trade_no = m.get('alipay_trade_no')
        if m.get('refund_fee') is not None:
            self.refund_fee = m.get('refund_fee')
        if m.get('refund_price') is not None:
            self.refund_price = m.get('refund_price')
        if m.get('status') is not None:
            self.status = m.get('status')
        return self


class FlightRefundDetailResponseBodyModule(TeaModel):
    def __init__(self, btrip_order_id=None, btrip_sub_order_id=None, dis_order_id=None, dis_sub_order_id=None,
                 is_voluntary=None, reason=None, refund_fee=None, refund_fee_list=None, refund_price=None, status=None):
        self.btrip_order_id = btrip_order_id  # type: long
        self.btrip_sub_order_id = btrip_sub_order_id  # type: long
        self.dis_order_id = dis_order_id  # type: str
        self.dis_sub_order_id = dis_sub_order_id  # type: str
        self.is_voluntary = is_voluntary  # type: int
        self.reason = reason  # type: str
        self.refund_fee = refund_fee  # type: long
        self.refund_fee_list = refund_fee_list  # type: list[FlightRefundDetailResponseBodyModuleRefundFeeList]
        self.refund_price = refund_price  # type: long
        self.status = status  # type: str

    def validate(self):
        if self.refund_fee_list:
            for k in self.refund_fee_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(FlightRefundDetailResponseBodyModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.btrip_order_id is not None:
            result['btrip_order_id'] = self.btrip_order_id
        if self.btrip_sub_order_id is not None:
            result['btrip_sub_order_id'] = self.btrip_sub_order_id
        if self.dis_order_id is not None:
            result['dis_order_id'] = self.dis_order_id
        if self.dis_sub_order_id is not None:
            result['dis_sub_order_id'] = self.dis_sub_order_id
        if self.is_voluntary is not None:
            result['is_voluntary'] = self.is_voluntary
        if self.reason is not None:
            result['reason'] = self.reason
        if self.refund_fee is not None:
            result['refund_fee'] = self.refund_fee
        result['refund_fee_list'] = []
        if self.refund_fee_list is not None:
            for k in self.refund_fee_list:
                result['refund_fee_list'].append(k.to_map() if k else None)
        if self.refund_price is not None:
            result['refund_price'] = self.refund_price
        if self.status is not None:
            result['status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('btrip_order_id') is not None:
            self.btrip_order_id = m.get('btrip_order_id')
        if m.get('btrip_sub_order_id') is not None:
            self.btrip_sub_order_id = m.get('btrip_sub_order_id')
        if m.get('dis_order_id') is not None:
            self.dis_order_id = m.get('dis_order_id')
        if m.get('dis_sub_order_id') is not None:
            self.dis_sub_order_id = m.get('dis_sub_order_id')
        if m.get('is_voluntary') is not None:
            self.is_voluntary = m.get('is_voluntary')
        if m.get('reason') is not None:
            self.reason = m.get('reason')
        if m.get('refund_fee') is not None:
            self.refund_fee = m.get('refund_fee')
        self.refund_fee_list = []
        if m.get('refund_fee_list') is not None:
            for k in m.get('refund_fee_list'):
                temp_model = FlightRefundDetailResponseBodyModuleRefundFeeList()
                self.refund_fee_list.append(temp_model.from_map(k))
        if m.get('refund_price') is not None:
            self.refund_price = m.get('refund_price')
        if m.get('status') is not None:
            self.status = m.get('status')
        return self


class FlightRefundDetailResponseBody(TeaModel):
    def __init__(self, code=None, message=None, module=None, request_id=None, success=None, trace_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.module = module  # type: FlightRefundDetailResponseBodyModule
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.trace_id = trace_id  # type: str

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super(FlightRefundDetailResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = FlightRefundDetailResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class FlightRefundDetailResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: FlightRefundDetailResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(FlightRefundDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = FlightRefundDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class FlightRefundPreCalHeaders(TeaModel):
    def __init__(self, common_headers=None, x_acs_btrip_corp_token=None):
        self.common_headers = common_headers  # type: dict[str, str]
        self.x_acs_btrip_corp_token = x_acs_btrip_corp_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightRefundPreCalHeaders, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_corp_token is not None:
            result['x-acs-btrip-corp-token'] = self.x_acs_btrip_corp_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-corp-token') is not None:
            self.x_acs_btrip_corp_token = m.get('x-acs-btrip-corp-token')
        return self


class FlightRefundPreCalRequestPassengerSegmentInfoList(TeaModel):
    def __init__(self, flight_no=None, passenger_name=None, user_id=None):
        self.flight_no = flight_no  # type: str
        self.passenger_name = passenger_name  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightRefundPreCalRequestPassengerSegmentInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.flight_no is not None:
            result['flight_no'] = self.flight_no
        if self.passenger_name is not None:
            result['passenger_name'] = self.passenger_name
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('flight_no') is not None:
            self.flight_no = m.get('flight_no')
        if m.get('passenger_name') is not None:
            self.passenger_name = m.get('passenger_name')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class FlightRefundPreCalRequest(TeaModel):
    def __init__(self, dis_order_id=None, is_voluntary=None, passenger_segment_info_list=None):
        self.dis_order_id = dis_order_id  # type: str
        self.is_voluntary = is_voluntary  # type: str
        self.passenger_segment_info_list = passenger_segment_info_list  # type: list[FlightRefundPreCalRequestPassengerSegmentInfoList]

    def validate(self):
        if self.passenger_segment_info_list:
            for k in self.passenger_segment_info_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(FlightRefundPreCalRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dis_order_id is not None:
            result['dis_order_id'] = self.dis_order_id
        if self.is_voluntary is not None:
            result['is_voluntary'] = self.is_voluntary
        result['passenger_segment_info_list'] = []
        if self.passenger_segment_info_list is not None:
            for k in self.passenger_segment_info_list:
                result['passenger_segment_info_list'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('dis_order_id') is not None:
            self.dis_order_id = m.get('dis_order_id')
        if m.get('is_voluntary') is not None:
            self.is_voluntary = m.get('is_voluntary')
        self.passenger_segment_info_list = []
        if m.get('passenger_segment_info_list') is not None:
            for k in m.get('passenger_segment_info_list'):
                temp_model = FlightRefundPreCalRequestPassengerSegmentInfoList()
                self.passenger_segment_info_list.append(temp_model.from_map(k))
        return self


class FlightRefundPreCalShrinkRequest(TeaModel):
    def __init__(self, dis_order_id=None, is_voluntary=None, passenger_segment_info_list_shrink=None):
        self.dis_order_id = dis_order_id  # type: str
        self.is_voluntary = is_voluntary  # type: str
        self.passenger_segment_info_list_shrink = passenger_segment_info_list_shrink  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightRefundPreCalShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dis_order_id is not None:
            result['dis_order_id'] = self.dis_order_id
        if self.is_voluntary is not None:
            result['is_voluntary'] = self.is_voluntary
        if self.passenger_segment_info_list_shrink is not None:
            result['passenger_segment_info_list'] = self.passenger_segment_info_list_shrink
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('dis_order_id') is not None:
            self.dis_order_id = m.get('dis_order_id')
        if m.get('is_voluntary') is not None:
            self.is_voluntary = m.get('is_voluntary')
        if m.get('passenger_segment_info_list') is not None:
            self.passenger_segment_info_list_shrink = m.get('passenger_segment_info_list')
        return self


class FlightRefundPreCalResponseBodyModuleMultiRefundCalList(TeaModel):
    def __init__(self, can_apply_refund=None, name=None, pre_refund_money=None, refund_fee=None, user_id=None):
        self.can_apply_refund = can_apply_refund  # type: bool
        self.name = name  # type: str
        self.pre_refund_money = pre_refund_money  # type: long
        self.refund_fee = refund_fee  # type: long
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightRefundPreCalResponseBodyModuleMultiRefundCalList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.can_apply_refund is not None:
            result['can_apply_refund'] = self.can_apply_refund
        if self.name is not None:
            result['name'] = self.name
        if self.pre_refund_money is not None:
            result['pre_refund_money'] = self.pre_refund_money
        if self.refund_fee is not None:
            result['refund_fee'] = self.refund_fee
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('can_apply_refund') is not None:
            self.can_apply_refund = m.get('can_apply_refund')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('pre_refund_money') is not None:
            self.pre_refund_money = m.get('pre_refund_money')
        if m.get('refund_fee') is not None:
            self.refund_fee = m.get('refund_fee')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class FlightRefundPreCalResponseBodyModuleReturnReason(TeaModel):
    def __init__(self, extend_desc=None, person=None, reason_code=None, reason_show=None, reason_type=None,
                 volunteer=None):
        self.extend_desc = extend_desc  # type: str
        self.person = person  # type: int
        self.reason_code = reason_code  # type: int
        self.reason_show = reason_show  # type: str
        self.reason_type = reason_type  # type: int
        self.volunteer = volunteer  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightRefundPreCalResponseBodyModuleReturnReason, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extend_desc is not None:
            result['extend_desc'] = self.extend_desc
        if self.person is not None:
            result['person'] = self.person
        if self.reason_code is not None:
            result['reason_code'] = self.reason_code
        if self.reason_show is not None:
            result['reason_show'] = self.reason_show
        if self.reason_type is not None:
            result['reason_type'] = self.reason_type
        if self.volunteer is not None:
            result['volunteer'] = self.volunteer
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('extend_desc') is not None:
            self.extend_desc = m.get('extend_desc')
        if m.get('person') is not None:
            self.person = m.get('person')
        if m.get('reason_code') is not None:
            self.reason_code = m.get('reason_code')
        if m.get('reason_show') is not None:
            self.reason_show = m.get('reason_show')
        if m.get('reason_type') is not None:
            self.reason_type = m.get('reason_type')
        if m.get('volunteer') is not None:
            self.volunteer = m.get('volunteer')
        return self


class FlightRefundPreCalResponseBodyModule(TeaModel):
    def __init__(self, flight_change=None, item_unit_id=None, multi_refund_cal_list=None, pre_refund_money=None,
                 refund_fee=None, return_reason=None, session_id=None, tips=None):
        self.flight_change = flight_change  # type: bool
        self.item_unit_id = item_unit_id  # type: str
        self.multi_refund_cal_list = multi_refund_cal_list  # type: list[FlightRefundPreCalResponseBodyModuleMultiRefundCalList]
        self.pre_refund_money = pre_refund_money  # type: long
        self.refund_fee = refund_fee  # type: long
        self.return_reason = return_reason  # type: list[FlightRefundPreCalResponseBodyModuleReturnReason]
        self.session_id = session_id  # type: str
        self.tips = tips  # type: str

    def validate(self):
        if self.multi_refund_cal_list:
            for k in self.multi_refund_cal_list:
                if k:
                    k.validate()
        if self.return_reason:
            for k in self.return_reason:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(FlightRefundPreCalResponseBodyModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.flight_change is not None:
            result['flight_change'] = self.flight_change
        if self.item_unit_id is not None:
            result['item_unit_id'] = self.item_unit_id
        result['multi_refund_cal_list'] = []
        if self.multi_refund_cal_list is not None:
            for k in self.multi_refund_cal_list:
                result['multi_refund_cal_list'].append(k.to_map() if k else None)
        if self.pre_refund_money is not None:
            result['pre_refund_money'] = self.pre_refund_money
        if self.refund_fee is not None:
            result['refund_fee'] = self.refund_fee
        result['return_reason'] = []
        if self.return_reason is not None:
            for k in self.return_reason:
                result['return_reason'].append(k.to_map() if k else None)
        if self.session_id is not None:
            result['session_id'] = self.session_id
        if self.tips is not None:
            result['tips'] = self.tips
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('flight_change') is not None:
            self.flight_change = m.get('flight_change')
        if m.get('item_unit_id') is not None:
            self.item_unit_id = m.get('item_unit_id')
        self.multi_refund_cal_list = []
        if m.get('multi_refund_cal_list') is not None:
            for k in m.get('multi_refund_cal_list'):
                temp_model = FlightRefundPreCalResponseBodyModuleMultiRefundCalList()
                self.multi_refund_cal_list.append(temp_model.from_map(k))
        if m.get('pre_refund_money') is not None:
            self.pre_refund_money = m.get('pre_refund_money')
        if m.get('refund_fee') is not None:
            self.refund_fee = m.get('refund_fee')
        self.return_reason = []
        if m.get('return_reason') is not None:
            for k in m.get('return_reason'):
                temp_model = FlightRefundPreCalResponseBodyModuleReturnReason()
                self.return_reason.append(temp_model.from_map(k))
        if m.get('session_id') is not None:
            self.session_id = m.get('session_id')
        if m.get('tips') is not None:
            self.tips = m.get('tips')
        return self


class FlightRefundPreCalResponseBody(TeaModel):
    def __init__(self, code=None, message=None, module=None, request_id=None, success=None, trace_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.module = module  # type: FlightRefundPreCalResponseBodyModule
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.trace_id = trace_id  # type: str

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super(FlightRefundPreCalResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = FlightRefundPreCalResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class FlightRefundPreCalResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: FlightRefundPreCalResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(FlightRefundPreCalResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = FlightRefundPreCalResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class FlightSearchListHeaders(TeaModel):
    def __init__(self, common_headers=None, x_acs_btrip_corp_token=None):
        self.common_headers = common_headers  # type: dict[str, str]
        self.x_acs_btrip_corp_token = x_acs_btrip_corp_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightSearchListHeaders, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_corp_token is not None:
            result['x-acs-btrip-corp-token'] = self.x_acs_btrip_corp_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-corp-token') is not None:
            self.x_acs_btrip_corp_token = m.get('x-acs-btrip-corp-token')
        return self


class FlightSearchListRequest(TeaModel):
    def __init__(self, airline_code=None, arr_city_code=None, arr_city_name=None, arr_date=None, cabin_class=None,
                 dep_city_code=None, dep_city_name=None, dep_date=None, flight_no=None, need_multi_class_price=None,
                 transfer_city_code=None, transfer_flight_no=None, transfer_leave_date=None, trip_type=None):
        self.airline_code = airline_code  # type: str
        self.arr_city_code = arr_city_code  # type: str
        self.arr_city_name = arr_city_name  # type: str
        self.arr_date = arr_date  # type: str
        self.cabin_class = cabin_class  # type: str
        self.dep_city_code = dep_city_code  # type: str
        self.dep_city_name = dep_city_name  # type: str
        self.dep_date = dep_date  # type: str
        self.flight_no = flight_no  # type: str
        self.need_multi_class_price = need_multi_class_price  # type: bool
        self.transfer_city_code = transfer_city_code  # type: str
        self.transfer_flight_no = transfer_flight_no  # type: str
        self.transfer_leave_date = transfer_leave_date  # type: str
        self.trip_type = trip_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightSearchListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.airline_code is not None:
            result['airline_code'] = self.airline_code
        if self.arr_city_code is not None:
            result['arr_city_code'] = self.arr_city_code
        if self.arr_city_name is not None:
            result['arr_city_name'] = self.arr_city_name
        if self.arr_date is not None:
            result['arr_date'] = self.arr_date
        if self.cabin_class is not None:
            result['cabin_class'] = self.cabin_class
        if self.dep_city_code is not None:
            result['dep_city_code'] = self.dep_city_code
        if self.dep_city_name is not None:
            result['dep_city_name'] = self.dep_city_name
        if self.dep_date is not None:
            result['dep_date'] = self.dep_date
        if self.flight_no is not None:
            result['flight_no'] = self.flight_no
        if self.need_multi_class_price is not None:
            result['need_multi_class_price'] = self.need_multi_class_price
        if self.transfer_city_code is not None:
            result['transfer_city_code'] = self.transfer_city_code
        if self.transfer_flight_no is not None:
            result['transfer_flight_no'] = self.transfer_flight_no
        if self.transfer_leave_date is not None:
            result['transfer_leave_date'] = self.transfer_leave_date
        if self.trip_type is not None:
            result['trip_type'] = self.trip_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('airline_code') is not None:
            self.airline_code = m.get('airline_code')
        if m.get('arr_city_code') is not None:
            self.arr_city_code = m.get('arr_city_code')
        if m.get('arr_city_name') is not None:
            self.arr_city_name = m.get('arr_city_name')
        if m.get('arr_date') is not None:
            self.arr_date = m.get('arr_date')
        if m.get('cabin_class') is not None:
            self.cabin_class = m.get('cabin_class')
        if m.get('dep_city_code') is not None:
            self.dep_city_code = m.get('dep_city_code')
        if m.get('dep_city_name') is not None:
            self.dep_city_name = m.get('dep_city_name')
        if m.get('dep_date') is not None:
            self.dep_date = m.get('dep_date')
        if m.get('flight_no') is not None:
            self.flight_no = m.get('flight_no')
        if m.get('need_multi_class_price') is not None:
            self.need_multi_class_price = m.get('need_multi_class_price')
        if m.get('transfer_city_code') is not None:
            self.transfer_city_code = m.get('transfer_city_code')
        if m.get('transfer_flight_no') is not None:
            self.transfer_flight_no = m.get('transfer_flight_no')
        if m.get('transfer_leave_date') is not None:
            self.transfer_leave_date = m.get('transfer_leave_date')
        if m.get('trip_type') is not None:
            self.trip_type = m.get('trip_type')
        return self


class FlightSearchListResponseBodyModuleFlightListAirlineInfo(TeaModel):
    def __init__(self, airline_code=None, airline_name=None, airline_simple_name=None):
        self.airline_code = airline_code  # type: str
        self.airline_name = airline_name  # type: str
        self.airline_simple_name = airline_simple_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListAirlineInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.airline_code is not None:
            result['airline_code'] = self.airline_code
        if self.airline_name is not None:
            result['airline_name'] = self.airline_name
        if self.airline_simple_name is not None:
            result['airline_simple_name'] = self.airline_simple_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('airline_code') is not None:
            self.airline_code = m.get('airline_code')
        if m.get('airline_name') is not None:
            self.airline_name = m.get('airline_name')
        if m.get('airline_simple_name') is not None:
            self.airline_simple_name = m.get('airline_simple_name')
        return self


class FlightSearchListResponseBodyModuleFlightListArrAirportInfo(TeaModel):
    def __init__(self, airport_code=None, airport_name=None, city_code=None, city_name=None, terminal=None):
        self.airport_code = airport_code  # type: str
        self.airport_name = airport_name  # type: str
        self.city_code = city_code  # type: str
        self.city_name = city_name  # type: str
        self.terminal = terminal  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListArrAirportInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.airport_code is not None:
            result['airport_code'] = self.airport_code
        if self.airport_name is not None:
            result['airport_name'] = self.airport_name
        if self.city_code is not None:
            result['city_code'] = self.city_code
        if self.city_name is not None:
            result['city_name'] = self.city_name
        if self.terminal is not None:
            result['terminal'] = self.terminal
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('airport_code') is not None:
            self.airport_code = m.get('airport_code')
        if m.get('airport_name') is not None:
            self.airport_name = m.get('airport_name')
        if m.get('city_code') is not None:
            self.city_code = m.get('city_code')
        if m.get('city_name') is not None:
            self.city_name = m.get('city_name')
        if m.get('terminal') is not None:
            self.terminal = m.get('terminal')
        return self


class FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizesDescription(TeaModel):
    def __init__(self, desc=None, icon=None, image=None, title=None):
        self.desc = desc  # type: str
        self.icon = icon  # type: str
        self.image = image  # type: str
        self.title = title  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizesDescription, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desc is not None:
            result['desc'] = self.desc
        if self.icon is not None:
            result['icon'] = self.icon
        if self.image is not None:
            result['image'] = self.image
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('desc') is not None:
            self.desc = m.get('desc')
        if m.get('icon') is not None:
            self.icon = m.get('icon')
        if m.get('image') is not None:
            self.image = m.get('image')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizesImageDO(TeaModel):
    def __init__(self, image=None, largest=None, middle=None, smallest=None):
        self.image = image  # type: str
        self.largest = largest  # type: str
        self.middle = middle  # type: str
        self.smallest = smallest  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizesImageDO, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image is not None:
            result['image'] = self.image
        if self.largest is not None:
            result['largest'] = self.largest
        if self.middle is not None:
            result['middle'] = self.middle
        if self.smallest is not None:
            result['smallest'] = self.smallest
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('image') is not None:
            self.image = m.get('image')
        if m.get('largest') is not None:
            self.largest = m.get('largest')
        if m.get('middle') is not None:
            self.middle = m.get('middle')
        if m.get('smallest') is not None:
            self.smallest = m.get('smallest')
        return self


class FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizes(TeaModel):
    def __init__(self, baggage_desc=None, baggage_sub_content_type=None, description=None, image_do=None,
                 is_highlight=None, sub_title=None):
        self.baggage_desc = baggage_desc  # type: list[str]
        self.baggage_sub_content_type = baggage_sub_content_type  # type: int
        self.description = description  # type: FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizesDescription
        self.image_do = image_do  # type: FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizesImageDO
        self.is_highlight = is_highlight  # type: bool
        self.sub_title = sub_title  # type: str

    def validate(self):
        if self.description:
            self.description.validate()
        if self.image_do:
            self.image_do.validate()

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizes, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baggage_desc is not None:
            result['baggage_desc'] = self.baggage_desc
        if self.baggage_sub_content_type is not None:
            result['baggage_sub_content_type'] = self.baggage_sub_content_type
        if self.description is not None:
            result['description'] = self.description.to_map()
        if self.image_do is not None:
            result['image_d_o'] = self.image_do.to_map()
        if self.is_highlight is not None:
            result['is_highlight'] = self.is_highlight
        if self.sub_title is not None:
            result['sub_title'] = self.sub_title
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('baggage_desc') is not None:
            self.baggage_desc = m.get('baggage_desc')
        if m.get('baggage_sub_content_type') is not None:
            self.baggage_sub_content_type = m.get('baggage_sub_content_type')
        if m.get('description') is not None:
            temp_model = FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizesDescription()
            self.description = temp_model.from_map(m['description'])
        if m.get('image_d_o') is not None:
            temp_model = FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizesImageDO()
            self.image_do = temp_model.from_map(m['image_d_o'])
        if m.get('is_highlight') is not None:
            self.is_highlight = m.get('is_highlight')
        if m.get('sub_title') is not None:
            self.sub_title = m.get('sub_title')
        return self


class FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListBaggageItemBaggageSubItems(TeaModel):
    def __init__(self, baggage_sub_content_visualizes=None, extra_content_visualizes=None, is_struct=None,
                 ptc=None, title=None):
        self.baggage_sub_content_visualizes = baggage_sub_content_visualizes  # type: list[FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizes]
        self.extra_content_visualizes = extra_content_visualizes  # type: list[any]
        self.is_struct = is_struct  # type: bool
        # PTC
        self.ptc = ptc  # type: str
        self.title = title  # type: str

    def validate(self):
        if self.baggage_sub_content_visualizes:
            for k in self.baggage_sub_content_visualizes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListBaggageItemBaggageSubItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['baggage_sub_content_visualizes'] = []
        if self.baggage_sub_content_visualizes is not None:
            for k in self.baggage_sub_content_visualizes:
                result['baggage_sub_content_visualizes'].append(k.to_map() if k else None)
        if self.extra_content_visualizes is not None:
            result['extra_content_visualizes'] = self.extra_content_visualizes
        if self.is_struct is not None:
            result['is_struct'] = self.is_struct
        if self.ptc is not None:
            result['ptc'] = self.ptc
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.baggage_sub_content_visualizes = []
        if m.get('baggage_sub_content_visualizes') is not None:
            for k in m.get('baggage_sub_content_visualizes'):
                temp_model = FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizes()
                self.baggage_sub_content_visualizes.append(temp_model.from_map(k))
        if m.get('extra_content_visualizes') is not None:
            self.extra_content_visualizes = m.get('extra_content_visualizes')
        if m.get('is_struct') is not None:
            self.is_struct = m.get('is_struct')
        if m.get('ptc') is not None:
            self.ptc = m.get('ptc')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListBaggageItemTips(TeaModel):
    def __init__(self, logo=None, tips_desc=None, tips_image=None):
        self.logo = logo  # type: str
        self.tips_desc = tips_desc  # type: str
        self.tips_image = tips_image  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListBaggageItemTips, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.logo is not None:
            result['logo'] = self.logo
        if self.tips_desc is not None:
            result['tips_desc'] = self.tips_desc
        if self.tips_image is not None:
            result['tips_image'] = self.tips_image
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('logo') is not None:
            self.logo = m.get('logo')
        if m.get('tips_desc') is not None:
            self.tips_desc = m.get('tips_desc')
        if m.get('tips_image') is not None:
            self.tips_image = m.get('tips_image')
        return self


class FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListBaggageItem(TeaModel):
    def __init__(self, baggage_sub_items=None, index=None, table_head=None, tips=None, title=None, type=None):
        self.baggage_sub_items = baggage_sub_items  # type: list[FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListBaggageItemBaggageSubItems]
        self.index = index  # type: int
        self.table_head = table_head  # type: str
        self.tips = tips  # type: FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListBaggageItemTips
        self.title = title  # type: str
        self.type = type  # type: int

    def validate(self):
        if self.baggage_sub_items:
            for k in self.baggage_sub_items:
                if k:
                    k.validate()
        if self.tips:
            self.tips.validate()

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListBaggageItem, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['baggage_sub_items'] = []
        if self.baggage_sub_items is not None:
            for k in self.baggage_sub_items:
                result['baggage_sub_items'].append(k.to_map() if k else None)
        if self.index is not None:
            result['index'] = self.index
        if self.table_head is not None:
            result['table_head'] = self.table_head
        if self.tips is not None:
            result['tips'] = self.tips.to_map()
        if self.title is not None:
            result['title'] = self.title
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.baggage_sub_items = []
        if m.get('baggage_sub_items') is not None:
            for k in m.get('baggage_sub_items'):
                temp_model = FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListBaggageItemBaggageSubItems()
                self.baggage_sub_items.append(temp_model.from_map(k))
        if m.get('index') is not None:
            self.index = m.get('index')
        if m.get('table_head') is not None:
            self.table_head = m.get('table_head')
        if m.get('tips') is not None:
            temp_model = FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListBaggageItemTips()
            self.tips = temp_model.from_map(m['tips'])
        if m.get('title') is not None:
            self.title = m.get('title')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListChangeRuleInfo(TeaModel):
    def __init__(self, content=None, cost=None, cost_percent=None, time_stamp=None, time_type=None, title=None):
        self.content = content  # type: str
        self.cost = cost  # type: int
        self.cost_percent = cost_percent  # type: int
        self.time_stamp = time_stamp  # type: int
        self.time_type = time_type  # type: str
        self.title = title  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListChangeRuleInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['content'] = self.content
        if self.cost is not None:
            result['cost'] = self.cost
        if self.cost_percent is not None:
            result['cost_percent'] = self.cost_percent
        if self.time_stamp is not None:
            result['time_stamp'] = self.time_stamp
        if self.time_type is not None:
            result['time_type'] = self.time_type
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('cost') is not None:
            self.cost = m.get('cost')
        if m.get('cost_percent') is not None:
            self.cost_percent = m.get('cost_percent')
        if m.get('time_stamp') is not None:
            self.time_stamp = m.get('time_stamp')
        if m.get('time_type') is not None:
            self.time_type = m.get('time_type')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListChangeRule(TeaModel):
    def __init__(self, able=None, info=None):
        self.able = able  # type: bool
        self.info = info  # type: list[FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListChangeRuleInfo]

    def validate(self):
        if self.info:
            for k in self.info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListChangeRule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.able is not None:
            result['able'] = self.able
        result['info'] = []
        if self.info is not None:
            for k in self.info:
                result['info'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('able') is not None:
            self.able = m.get('able')
        self.info = []
        if m.get('info') is not None:
            for k in m.get('info'):
                temp_model = FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListChangeRuleInfo()
                self.info.append(temp_model.from_map(k))
        return self


class FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListChangeRuleItemExtraContents(TeaModel):
    def __init__(self, content=None, title=None):
        self.content = content  # type: str
        self.title = title  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListChangeRuleItemExtraContents, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['content'] = self.content
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListChangeRuleItemRefundSubItemsRefundSubContents(TeaModel):
    def __init__(self, fee_desc=None, fee_range=None, style=None):
        self.fee_desc = fee_desc  # type: str
        self.fee_range = fee_range  # type: str
        self.style = style  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListChangeRuleItemRefundSubItemsRefundSubContents, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fee_desc is not None:
            result['fee_desc'] = self.fee_desc
        if self.fee_range is not None:
            result['fee_range'] = self.fee_range
        if self.style is not None:
            result['style'] = self.style
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('fee_desc') is not None:
            self.fee_desc = m.get('fee_desc')
        if m.get('fee_range') is not None:
            self.fee_range = m.get('fee_range')
        if m.get('style') is not None:
            self.style = m.get('style')
        return self


class FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListChangeRuleItemRefundSubItems(TeaModel):
    def __init__(self, is_struct=None, ptc=None, refund_sub_contents=None, title=None):
        self.is_struct = is_struct  # type: bool
        # PTC
        self.ptc = ptc  # type: str
        self.refund_sub_contents = refund_sub_contents  # type: list[FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListChangeRuleItemRefundSubItemsRefundSubContents]
        self.title = title  # type: str

    def validate(self):
        if self.refund_sub_contents:
            for k in self.refund_sub_contents:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListChangeRuleItemRefundSubItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_struct is not None:
            result['is_struct'] = self.is_struct
        if self.ptc is not None:
            result['ptc'] = self.ptc
        result['refund_sub_contents'] = []
        if self.refund_sub_contents is not None:
            for k in self.refund_sub_contents:
                result['refund_sub_contents'].append(k.to_map() if k else None)
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('is_struct') is not None:
            self.is_struct = m.get('is_struct')
        if m.get('ptc') is not None:
            self.ptc = m.get('ptc')
        self.refund_sub_contents = []
        if m.get('refund_sub_contents') is not None:
            for k in m.get('refund_sub_contents'):
                temp_model = FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListChangeRuleItemRefundSubItemsRefundSubContents()
                self.refund_sub_contents.append(temp_model.from_map(k))
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListChangeRuleItem(TeaModel):
    def __init__(self, extra_contents=None, index=None, refund_sub_items=None, sub_table_head=None, table_head=None,
                 title=None, type=None):
        self.extra_contents = extra_contents  # type: list[FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListChangeRuleItemExtraContents]
        self.index = index  # type: int
        self.refund_sub_items = refund_sub_items  # type: list[FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListChangeRuleItemRefundSubItems]
        self.sub_table_head = sub_table_head  # type: list[str]
        self.table_head = table_head  # type: str
        self.title = title  # type: str
        self.type = type  # type: int

    def validate(self):
        if self.extra_contents:
            for k in self.extra_contents:
                if k:
                    k.validate()
        if self.refund_sub_items:
            for k in self.refund_sub_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListChangeRuleItem, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['extra_contents'] = []
        if self.extra_contents is not None:
            for k in self.extra_contents:
                result['extra_contents'].append(k.to_map() if k else None)
        if self.index is not None:
            result['index'] = self.index
        result['refund_sub_items'] = []
        if self.refund_sub_items is not None:
            for k in self.refund_sub_items:
                result['refund_sub_items'].append(k.to_map() if k else None)
        if self.sub_table_head is not None:
            result['sub_table_head'] = self.sub_table_head
        if self.table_head is not None:
            result['table_head'] = self.table_head
        if self.title is not None:
            result['title'] = self.title
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.extra_contents = []
        if m.get('extra_contents') is not None:
            for k in m.get('extra_contents'):
                temp_model = FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListChangeRuleItemExtraContents()
                self.extra_contents.append(temp_model.from_map(k))
        if m.get('index') is not None:
            self.index = m.get('index')
        self.refund_sub_items = []
        if m.get('refund_sub_items') is not None:
            for k in m.get('refund_sub_items'):
                temp_model = FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListChangeRuleItemRefundSubItems()
                self.refund_sub_items.append(temp_model.from_map(k))
        if m.get('sub_table_head') is not None:
            self.sub_table_head = m.get('sub_table_head')
        if m.get('table_head') is not None:
            self.table_head = m.get('table_head')
        if m.get('title') is not None:
            self.title = m.get('title')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListRefundRuleInfo(TeaModel):
    def __init__(self, content=None, cost=None, cost_percent=None, time_stamp=None, time_type=None, title=None):
        self.content = content  # type: str
        self.cost = cost  # type: int
        self.cost_percent = cost_percent  # type: int
        self.time_stamp = time_stamp  # type: int
        self.time_type = time_type  # type: str
        self.title = title  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListRefundRuleInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['content'] = self.content
        if self.cost is not None:
            result['cost'] = self.cost
        if self.cost_percent is not None:
            result['cost_percent'] = self.cost_percent
        if self.time_stamp is not None:
            result['time_stamp'] = self.time_stamp
        if self.time_type is not None:
            result['time_type'] = self.time_type
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('cost') is not None:
            self.cost = m.get('cost')
        if m.get('cost_percent') is not None:
            self.cost_percent = m.get('cost_percent')
        if m.get('time_stamp') is not None:
            self.time_stamp = m.get('time_stamp')
        if m.get('time_type') is not None:
            self.time_type = m.get('time_type')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListRefundRule(TeaModel):
    def __init__(self, able=None, info=None):
        self.able = able  # type: bool
        self.info = info  # type: list[FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListRefundRuleInfo]

    def validate(self):
        if self.info:
            for k in self.info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListRefundRule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.able is not None:
            result['able'] = self.able
        result['info'] = []
        if self.info is not None:
            for k in self.info:
                result['info'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('able') is not None:
            self.able = m.get('able')
        self.info = []
        if m.get('info') is not None:
            for k in m.get('info'):
                temp_model = FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListRefundRuleInfo()
                self.info.append(temp_model.from_map(k))
        return self


class FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListRefundRuleItemExtraContents(TeaModel):
    def __init__(self, content=None, title=None):
        self.content = content  # type: str
        self.title = title  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListRefundRuleItemExtraContents, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['content'] = self.content
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListRefundRuleItemRefundSubItemsRefundSubContents(TeaModel):
    def __init__(self, fee_desc=None, fee_range=None, style=None):
        self.fee_desc = fee_desc  # type: str
        self.fee_range = fee_range  # type: str
        self.style = style  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListRefundRuleItemRefundSubItemsRefundSubContents, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fee_desc is not None:
            result['fee_desc'] = self.fee_desc
        if self.fee_range is not None:
            result['fee_range'] = self.fee_range
        if self.style is not None:
            result['style'] = self.style
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('fee_desc') is not None:
            self.fee_desc = m.get('fee_desc')
        if m.get('fee_range') is not None:
            self.fee_range = m.get('fee_range')
        if m.get('style') is not None:
            self.style = m.get('style')
        return self


class FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListRefundRuleItemRefundSubItems(TeaModel):
    def __init__(self, is_struct=None, ptc=None, refund_sub_contents=None, title=None):
        self.is_struct = is_struct  # type: bool
        # PTC
        self.ptc = ptc  # type: str
        self.refund_sub_contents = refund_sub_contents  # type: list[FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListRefundRuleItemRefundSubItemsRefundSubContents]
        self.title = title  # type: str

    def validate(self):
        if self.refund_sub_contents:
            for k in self.refund_sub_contents:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListRefundRuleItemRefundSubItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_struct is not None:
            result['is_struct'] = self.is_struct
        if self.ptc is not None:
            result['ptc'] = self.ptc
        result['refund_sub_contents'] = []
        if self.refund_sub_contents is not None:
            for k in self.refund_sub_contents:
                result['refund_sub_contents'].append(k.to_map() if k else None)
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('is_struct') is not None:
            self.is_struct = m.get('is_struct')
        if m.get('ptc') is not None:
            self.ptc = m.get('ptc')
        self.refund_sub_contents = []
        if m.get('refund_sub_contents') is not None:
            for k in m.get('refund_sub_contents'):
                temp_model = FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListRefundRuleItemRefundSubItemsRefundSubContents()
                self.refund_sub_contents.append(temp_model.from_map(k))
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListRefundRuleItem(TeaModel):
    def __init__(self, extra_contents=None, index=None, refund_sub_items=None, sub_table_head=None, table_head=None,
                 title=None, type=None):
        self.extra_contents = extra_contents  # type: list[FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListRefundRuleItemExtraContents]
        self.index = index  # type: int
        self.refund_sub_items = refund_sub_items  # type: list[FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListRefundRuleItemRefundSubItems]
        self.sub_table_head = sub_table_head  # type: list[str]
        self.table_head = table_head  # type: str
        self.title = title  # type: str
        self.type = type  # type: int

    def validate(self):
        if self.extra_contents:
            for k in self.extra_contents:
                if k:
                    k.validate()
        if self.refund_sub_items:
            for k in self.refund_sub_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListRefundRuleItem, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['extra_contents'] = []
        if self.extra_contents is not None:
            for k in self.extra_contents:
                result['extra_contents'].append(k.to_map() if k else None)
        if self.index is not None:
            result['index'] = self.index
        result['refund_sub_items'] = []
        if self.refund_sub_items is not None:
            for k in self.refund_sub_items:
                result['refund_sub_items'].append(k.to_map() if k else None)
        if self.sub_table_head is not None:
            result['sub_table_head'] = self.sub_table_head
        if self.table_head is not None:
            result['table_head'] = self.table_head
        if self.title is not None:
            result['title'] = self.title
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.extra_contents = []
        if m.get('extra_contents') is not None:
            for k in m.get('extra_contents'):
                temp_model = FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListRefundRuleItemExtraContents()
                self.extra_contents.append(temp_model.from_map(k))
        if m.get('index') is not None:
            self.index = m.get('index')
        self.refund_sub_items = []
        if m.get('refund_sub_items') is not None:
            for k in m.get('refund_sub_items'):
                temp_model = FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListRefundRuleItemRefundSubItems()
                self.refund_sub_items.append(temp_model.from_map(k))
        if m.get('sub_table_head') is not None:
            self.sub_table_head = m.get('sub_table_head')
        if m.get('table_head') is not None:
            self.table_head = m.get('table_head')
        if m.get('title') is not None:
            self.title = m.get('title')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListSignRuleInfo(TeaModel):
    def __init__(self, content=None, cost=None, cost_percent=None, time_stamp=None, time_type=None, title=None):
        self.content = content  # type: str
        self.cost = cost  # type: int
        self.cost_percent = cost_percent  # type: int
        self.time_stamp = time_stamp  # type: int
        self.time_type = time_type  # type: str
        self.title = title  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListSignRuleInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['content'] = self.content
        if self.cost is not None:
            result['cost'] = self.cost
        if self.cost_percent is not None:
            result['cost_percent'] = self.cost_percent
        if self.time_stamp is not None:
            result['time_stamp'] = self.time_stamp
        if self.time_type is not None:
            result['time_type'] = self.time_type
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('cost') is not None:
            self.cost = m.get('cost')
        if m.get('cost_percent') is not None:
            self.cost_percent = m.get('cost_percent')
        if m.get('time_stamp') is not None:
            self.time_stamp = m.get('time_stamp')
        if m.get('time_type') is not None:
            self.time_type = m.get('time_type')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListSignRule(TeaModel):
    def __init__(self, able=None, info=None):
        self.able = able  # type: bool
        self.info = info  # type: list[FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListSignRuleInfo]

    def validate(self):
        if self.info:
            for k in self.info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListSignRule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.able is not None:
            result['able'] = self.able
        result['info'] = []
        if self.info is not None:
            for k in self.info:
                result['info'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('able') is not None:
            self.able = m.get('able')
        self.info = []
        if m.get('info') is not None:
            for k in m.get('info'):
                temp_model = FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListSignRuleInfo()
                self.info.append(temp_model.from_map(k))
        return self


class FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListUpgradeRuleInfo(TeaModel):
    def __init__(self, content=None, cost=None, cost_percent=None, time_stamp=None, time_type=None, title=None):
        self.content = content  # type: str
        self.cost = cost  # type: int
        self.cost_percent = cost_percent  # type: int
        self.time_stamp = time_stamp  # type: int
        self.time_type = time_type  # type: str
        self.title = title  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListUpgradeRuleInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['content'] = self.content
        if self.cost is not None:
            result['cost'] = self.cost
        if self.cost_percent is not None:
            result['cost_percent'] = self.cost_percent
        if self.time_stamp is not None:
            result['time_stamp'] = self.time_stamp
        if self.time_type is not None:
            result['time_type'] = self.time_type
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('cost') is not None:
            self.cost = m.get('cost')
        if m.get('cost_percent') is not None:
            self.cost_percent = m.get('cost_percent')
        if m.get('time_stamp') is not None:
            self.time_stamp = m.get('time_stamp')
        if m.get('time_type') is not None:
            self.time_type = m.get('time_type')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListUpgradeRule(TeaModel):
    def __init__(self, able=None, info=None):
        self.able = able  # type: bool
        self.info = info  # type: list[FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListUpgradeRuleInfo]

    def validate(self):
        if self.info:
            for k in self.info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListUpgradeRule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.able is not None:
            result['able'] = self.able
        result['info'] = []
        if self.info is not None:
            for k in self.info:
                result['info'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('able') is not None:
            self.able = m.get('able')
        self.info = []
        if m.get('info') is not None:
            for k in m.get('info'):
                temp_model = FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListUpgradeRuleInfo()
                self.info.append(temp_model.from_map(k))
        return self


class FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleList(TeaModel):
    def __init__(self, baggage_info=None, baggage_item=None, change_rule=None, change_rule_item=None, extra=None,
                 refund_rule=None, refund_rule_item=None, sign_rule=None, tuigaiqian_info=None, upgrade_rule=None):
        self.baggage_info = baggage_info  # type: str
        self.baggage_item = baggage_item  # type: FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListBaggageItem
        self.change_rule = change_rule  # type: FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListChangeRule
        self.change_rule_item = change_rule_item  # type: FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListChangeRuleItem
        self.extra = extra  # type: str
        self.refund_rule = refund_rule  # type: FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListRefundRule
        self.refund_rule_item = refund_rule_item  # type: FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListRefundRuleItem
        self.sign_rule = sign_rule  # type: FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListSignRule
        self.tuigaiqian_info = tuigaiqian_info  # type: str
        self.upgrade_rule = upgrade_rule  # type: FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListUpgradeRule

    def validate(self):
        if self.baggage_item:
            self.baggage_item.validate()
        if self.change_rule:
            self.change_rule.validate()
        if self.change_rule_item:
            self.change_rule_item.validate()
        if self.refund_rule:
            self.refund_rule.validate()
        if self.refund_rule_item:
            self.refund_rule_item.validate()
        if self.sign_rule:
            self.sign_rule.validate()
        if self.upgrade_rule:
            self.upgrade_rule.validate()

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baggage_info is not None:
            result['baggage_info'] = self.baggage_info
        if self.baggage_item is not None:
            result['baggage_item'] = self.baggage_item.to_map()
        if self.change_rule is not None:
            result['change_rule'] = self.change_rule.to_map()
        if self.change_rule_item is not None:
            result['change_rule_item'] = self.change_rule_item.to_map()
        if self.extra is not None:
            result['extra'] = self.extra
        if self.refund_rule is not None:
            result['refund_rule'] = self.refund_rule.to_map()
        if self.refund_rule_item is not None:
            result['refund_rule_item'] = self.refund_rule_item.to_map()
        if self.sign_rule is not None:
            result['sign_rule'] = self.sign_rule.to_map()
        if self.tuigaiqian_info is not None:
            result['tuigaiqian_info'] = self.tuigaiqian_info
        if self.upgrade_rule is not None:
            result['upgrade_rule'] = self.upgrade_rule.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('baggage_info') is not None:
            self.baggage_info = m.get('baggage_info')
        if m.get('baggage_item') is not None:
            temp_model = FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListBaggageItem()
            self.baggage_item = temp_model.from_map(m['baggage_item'])
        if m.get('change_rule') is not None:
            temp_model = FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListChangeRule()
            self.change_rule = temp_model.from_map(m['change_rule'])
        if m.get('change_rule_item') is not None:
            temp_model = FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListChangeRuleItem()
            self.change_rule_item = temp_model.from_map(m['change_rule_item'])
        if m.get('extra') is not None:
            self.extra = m.get('extra')
        if m.get('refund_rule') is not None:
            temp_model = FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListRefundRule()
            self.refund_rule = temp_model.from_map(m['refund_rule'])
        if m.get('refund_rule_item') is not None:
            temp_model = FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListRefundRuleItem()
            self.refund_rule_item = temp_model.from_map(m['refund_rule_item'])
        if m.get('sign_rule') is not None:
            temp_model = FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListSignRule()
            self.sign_rule = temp_model.from_map(m['sign_rule'])
        if m.get('tuigaiqian_info') is not None:
            self.tuigaiqian_info = m.get('tuigaiqian_info')
        if m.get('upgrade_rule') is not None:
            temp_model = FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListUpgradeRule()
            self.upgrade_rule = temp_model.from_map(m['upgrade_rule'])
        return self


class FlightSearchListResponseBodyModuleFlightListCabinInfoList(TeaModel):
    def __init__(self, agent_id=None, basic_cabin_price=None, build_price=None, cabin=None, cabin_class=None,
                 cabin_class_name=None, child_cabin=None, class_name=None, class_rule=None, discount=None, flight_rule_list=None,
                 flight_rule_list_str=None, invoice_type=None, is_protocol=None, memo=None, oil_price=None, order_params=None,
                 ota_item_id=None, price=None, product_type=None, product_type_desc=None, promotion_price=None,
                 remained_seat_count=None, ticket_price=None, total_price=None):
        self.agent_id = agent_id  # type: long
        self.basic_cabin_price = basic_cabin_price  # type: int
        self.build_price = build_price  # type: int
        self.cabin = cabin  # type: str
        self.cabin_class = cabin_class  # type: str
        self.cabin_class_name = cabin_class_name  # type: str
        self.child_cabin = child_cabin  # type: str
        self.class_name = class_name  # type: str
        self.class_rule = class_rule  # type: str
        self.discount = discount  # type: str
        self.flight_rule_list = flight_rule_list  # type: list[FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleList]
        self.flight_rule_list_str = flight_rule_list_str  # type: str
        self.invoice_type = invoice_type  # type: int
        self.is_protocol = is_protocol  # type: bool
        self.memo = memo  # type: str
        self.oil_price = oil_price  # type: int
        self.order_params = order_params  # type: str
        self.ota_item_id = ota_item_id  # type: str
        self.price = price  # type: int
        self.product_type = product_type  # type: long
        self.product_type_desc = product_type_desc  # type: str
        self.promotion_price = promotion_price  # type: str
        self.remained_seat_count = remained_seat_count  # type: str
        self.ticket_price = ticket_price  # type: int
        self.total_price = total_price  # type: int

    def validate(self):
        if self.flight_rule_list:
            for k in self.flight_rule_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListCabinInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_id is not None:
            result['agent_id'] = self.agent_id
        if self.basic_cabin_price is not None:
            result['basic_cabin_price'] = self.basic_cabin_price
        if self.build_price is not None:
            result['build_price'] = self.build_price
        if self.cabin is not None:
            result['cabin'] = self.cabin
        if self.cabin_class is not None:
            result['cabin_class'] = self.cabin_class
        if self.cabin_class_name is not None:
            result['cabin_class_name'] = self.cabin_class_name
        if self.child_cabin is not None:
            result['child_cabin'] = self.child_cabin
        if self.class_name is not None:
            result['class_name'] = self.class_name
        if self.class_rule is not None:
            result['class_rule'] = self.class_rule
        if self.discount is not None:
            result['discount'] = self.discount
        result['flight_rule_list'] = []
        if self.flight_rule_list is not None:
            for k in self.flight_rule_list:
                result['flight_rule_list'].append(k.to_map() if k else None)
        if self.flight_rule_list_str is not None:
            result['flight_rule_list_str'] = self.flight_rule_list_str
        if self.invoice_type is not None:
            result['invoice_type'] = self.invoice_type
        if self.is_protocol is not None:
            result['is_protocol'] = self.is_protocol
        if self.memo is not None:
            result['memo'] = self.memo
        if self.oil_price is not None:
            result['oil_price'] = self.oil_price
        if self.order_params is not None:
            result['order_params'] = self.order_params
        if self.ota_item_id is not None:
            result['ota_item_id'] = self.ota_item_id
        if self.price is not None:
            result['price'] = self.price
        if self.product_type is not None:
            result['product_type'] = self.product_type
        if self.product_type_desc is not None:
            result['product_type_desc'] = self.product_type_desc
        if self.promotion_price is not None:
            result['promotion_price'] = self.promotion_price
        if self.remained_seat_count is not None:
            result['remained_seat_count'] = self.remained_seat_count
        if self.ticket_price is not None:
            result['ticket_price'] = self.ticket_price
        if self.total_price is not None:
            result['total_price'] = self.total_price
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('agent_id') is not None:
            self.agent_id = m.get('agent_id')
        if m.get('basic_cabin_price') is not None:
            self.basic_cabin_price = m.get('basic_cabin_price')
        if m.get('build_price') is not None:
            self.build_price = m.get('build_price')
        if m.get('cabin') is not None:
            self.cabin = m.get('cabin')
        if m.get('cabin_class') is not None:
            self.cabin_class = m.get('cabin_class')
        if m.get('cabin_class_name') is not None:
            self.cabin_class_name = m.get('cabin_class_name')
        if m.get('child_cabin') is not None:
            self.child_cabin = m.get('child_cabin')
        if m.get('class_name') is not None:
            self.class_name = m.get('class_name')
        if m.get('class_rule') is not None:
            self.class_rule = m.get('class_rule')
        if m.get('discount') is not None:
            self.discount = m.get('discount')
        self.flight_rule_list = []
        if m.get('flight_rule_list') is not None:
            for k in m.get('flight_rule_list'):
                temp_model = FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleList()
                self.flight_rule_list.append(temp_model.from_map(k))
        if m.get('flight_rule_list_str') is not None:
            self.flight_rule_list_str = m.get('flight_rule_list_str')
        if m.get('invoice_type') is not None:
            self.invoice_type = m.get('invoice_type')
        if m.get('is_protocol') is not None:
            self.is_protocol = m.get('is_protocol')
        if m.get('memo') is not None:
            self.memo = m.get('memo')
        if m.get('oil_price') is not None:
            self.oil_price = m.get('oil_price')
        if m.get('order_params') is not None:
            self.order_params = m.get('order_params')
        if m.get('ota_item_id') is not None:
            self.ota_item_id = m.get('ota_item_id')
        if m.get('price') is not None:
            self.price = m.get('price')
        if m.get('product_type') is not None:
            self.product_type = m.get('product_type')
        if m.get('product_type_desc') is not None:
            self.product_type_desc = m.get('product_type_desc')
        if m.get('promotion_price') is not None:
            self.promotion_price = m.get('promotion_price')
        if m.get('remained_seat_count') is not None:
            self.remained_seat_count = m.get('remained_seat_count')
        if m.get('ticket_price') is not None:
            self.ticket_price = m.get('ticket_price')
        if m.get('total_price') is not None:
            self.total_price = m.get('total_price')
        return self


class FlightSearchListResponseBodyModuleFlightListDepAirportInfo(TeaModel):
    def __init__(self, airport_code=None, airport_name=None, city_code=None, city_name=None, terminal=None):
        self.airport_code = airport_code  # type: str
        self.airport_name = airport_name  # type: str
        self.city_code = city_code  # type: str
        self.city_name = city_name  # type: str
        self.terminal = terminal  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListDepAirportInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.airport_code is not None:
            result['airport_code'] = self.airport_code
        if self.airport_name is not None:
            result['airport_name'] = self.airport_name
        if self.city_code is not None:
            result['city_code'] = self.city_code
        if self.city_name is not None:
            result['city_name'] = self.city_name
        if self.terminal is not None:
            result['terminal'] = self.terminal
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('airport_code') is not None:
            self.airport_code = m.get('airport_code')
        if m.get('airport_name') is not None:
            self.airport_name = m.get('airport_name')
        if m.get('city_code') is not None:
            self.city_code = m.get('city_code')
        if m.get('city_name') is not None:
            self.city_name = m.get('city_name')
        if m.get('terminal') is not None:
            self.terminal = m.get('terminal')
        return self


class FlightSearchListResponseBodyModuleFlightListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizesDescription(TeaModel):
    def __init__(self, desc=None, icon=None, image=None, title=None):
        self.desc = desc  # type: str
        self.icon = icon  # type: str
        self.image = image  # type: str
        self.title = title  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizesDescription, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desc is not None:
            result['desc'] = self.desc
        if self.icon is not None:
            result['icon'] = self.icon
        if self.image is not None:
            result['image'] = self.image
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('desc') is not None:
            self.desc = m.get('desc')
        if m.get('icon') is not None:
            self.icon = m.get('icon')
        if m.get('image') is not None:
            self.image = m.get('image')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightSearchListResponseBodyModuleFlightListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizesImageDO(TeaModel):
    def __init__(self, image=None, largest=None, middle=None, smallest=None):
        self.image = image  # type: str
        self.largest = largest  # type: str
        self.middle = middle  # type: str
        self.smallest = smallest  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizesImageDO, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image is not None:
            result['image'] = self.image
        if self.largest is not None:
            result['largest'] = self.largest
        if self.middle is not None:
            result['middle'] = self.middle
        if self.smallest is not None:
            result['smallest'] = self.smallest
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('image') is not None:
            self.image = m.get('image')
        if m.get('largest') is not None:
            self.largest = m.get('largest')
        if m.get('middle') is not None:
            self.middle = m.get('middle')
        if m.get('smallest') is not None:
            self.smallest = m.get('smallest')
        return self


class FlightSearchListResponseBodyModuleFlightListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizes(TeaModel):
    def __init__(self, baggage_desc=None, baggage_sub_content_type=None, description=None, image_do=None,
                 is_highlight=None, sub_title=None):
        self.baggage_desc = baggage_desc  # type: list[str]
        self.baggage_sub_content_type = baggage_sub_content_type  # type: int
        self.description = description  # type: FlightSearchListResponseBodyModuleFlightListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizesDescription
        self.image_do = image_do  # type: FlightSearchListResponseBodyModuleFlightListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizesImageDO
        self.is_highlight = is_highlight  # type: bool
        self.sub_title = sub_title  # type: str

    def validate(self):
        if self.description:
            self.description.validate()
        if self.image_do:
            self.image_do.validate()

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizes, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baggage_desc is not None:
            result['baggage_desc'] = self.baggage_desc
        if self.baggage_sub_content_type is not None:
            result['baggage_sub_content_type'] = self.baggage_sub_content_type
        if self.description is not None:
            result['description'] = self.description.to_map()
        if self.image_do is not None:
            result['image_d_o'] = self.image_do.to_map()
        if self.is_highlight is not None:
            result['is_highlight'] = self.is_highlight
        if self.sub_title is not None:
            result['sub_title'] = self.sub_title
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('baggage_desc') is not None:
            self.baggage_desc = m.get('baggage_desc')
        if m.get('baggage_sub_content_type') is not None:
            self.baggage_sub_content_type = m.get('baggage_sub_content_type')
        if m.get('description') is not None:
            temp_model = FlightSearchListResponseBodyModuleFlightListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizesDescription()
            self.description = temp_model.from_map(m['description'])
        if m.get('image_d_o') is not None:
            temp_model = FlightSearchListResponseBodyModuleFlightListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizesImageDO()
            self.image_do = temp_model.from_map(m['image_d_o'])
        if m.get('is_highlight') is not None:
            self.is_highlight = m.get('is_highlight')
        if m.get('sub_title') is not None:
            self.sub_title = m.get('sub_title')
        return self


class FlightSearchListResponseBodyModuleFlightListFlightRuleListBaggageItemBaggageSubItems(TeaModel):
    def __init__(self, baggage_sub_content_visualizes=None, extra_content_visualizes=None, is_struct=None,
                 ptc=None, title=None):
        self.baggage_sub_content_visualizes = baggage_sub_content_visualizes  # type: list[FlightSearchListResponseBodyModuleFlightListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizes]
        self.extra_content_visualizes = extra_content_visualizes  # type: list[any]
        self.is_struct = is_struct  # type: bool
        # PTC
        self.ptc = ptc  # type: str
        self.title = title  # type: str

    def validate(self):
        if self.baggage_sub_content_visualizes:
            for k in self.baggage_sub_content_visualizes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListFlightRuleListBaggageItemBaggageSubItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['baggage_sub_content_visualizes'] = []
        if self.baggage_sub_content_visualizes is not None:
            for k in self.baggage_sub_content_visualizes:
                result['baggage_sub_content_visualizes'].append(k.to_map() if k else None)
        if self.extra_content_visualizes is not None:
            result['extra_content_visualizes'] = self.extra_content_visualizes
        if self.is_struct is not None:
            result['is_struct'] = self.is_struct
        if self.ptc is not None:
            result['ptc'] = self.ptc
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.baggage_sub_content_visualizes = []
        if m.get('baggage_sub_content_visualizes') is not None:
            for k in m.get('baggage_sub_content_visualizes'):
                temp_model = FlightSearchListResponseBodyModuleFlightListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizes()
                self.baggage_sub_content_visualizes.append(temp_model.from_map(k))
        if m.get('extra_content_visualizes') is not None:
            self.extra_content_visualizes = m.get('extra_content_visualizes')
        if m.get('is_struct') is not None:
            self.is_struct = m.get('is_struct')
        if m.get('ptc') is not None:
            self.ptc = m.get('ptc')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightSearchListResponseBodyModuleFlightListFlightRuleListBaggageItemTips(TeaModel):
    def __init__(self, logo=None, tips_desc=None, tips_image=None):
        self.logo = logo  # type: str
        self.tips_desc = tips_desc  # type: str
        self.tips_image = tips_image  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListFlightRuleListBaggageItemTips, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.logo is not None:
            result['logo'] = self.logo
        if self.tips_desc is not None:
            result['tips_desc'] = self.tips_desc
        if self.tips_image is not None:
            result['tips_image'] = self.tips_image
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('logo') is not None:
            self.logo = m.get('logo')
        if m.get('tips_desc') is not None:
            self.tips_desc = m.get('tips_desc')
        if m.get('tips_image') is not None:
            self.tips_image = m.get('tips_image')
        return self


class FlightSearchListResponseBodyModuleFlightListFlightRuleListBaggageItem(TeaModel):
    def __init__(self, baggage_sub_items=None, index=None, table_head=None, tips=None, title=None, type=None):
        self.baggage_sub_items = baggage_sub_items  # type: list[FlightSearchListResponseBodyModuleFlightListFlightRuleListBaggageItemBaggageSubItems]
        self.index = index  # type: int
        self.table_head = table_head  # type: str
        self.tips = tips  # type: FlightSearchListResponseBodyModuleFlightListFlightRuleListBaggageItemTips
        self.title = title  # type: str
        self.type = type  # type: int

    def validate(self):
        if self.baggage_sub_items:
            for k in self.baggage_sub_items:
                if k:
                    k.validate()
        if self.tips:
            self.tips.validate()

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListFlightRuleListBaggageItem, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['baggage_sub_items'] = []
        if self.baggage_sub_items is not None:
            for k in self.baggage_sub_items:
                result['baggage_sub_items'].append(k.to_map() if k else None)
        if self.index is not None:
            result['index'] = self.index
        if self.table_head is not None:
            result['table_head'] = self.table_head
        if self.tips is not None:
            result['tips'] = self.tips.to_map()
        if self.title is not None:
            result['title'] = self.title
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.baggage_sub_items = []
        if m.get('baggage_sub_items') is not None:
            for k in m.get('baggage_sub_items'):
                temp_model = FlightSearchListResponseBodyModuleFlightListFlightRuleListBaggageItemBaggageSubItems()
                self.baggage_sub_items.append(temp_model.from_map(k))
        if m.get('index') is not None:
            self.index = m.get('index')
        if m.get('table_head') is not None:
            self.table_head = m.get('table_head')
        if m.get('tips') is not None:
            temp_model = FlightSearchListResponseBodyModuleFlightListFlightRuleListBaggageItemTips()
            self.tips = temp_model.from_map(m['tips'])
        if m.get('title') is not None:
            self.title = m.get('title')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class FlightSearchListResponseBodyModuleFlightListFlightRuleListChangeRuleInfo(TeaModel):
    def __init__(self, content=None, cost=None, cost_percent=None, time_stamp=None, time_type=None, title=None):
        self.content = content  # type: str
        self.cost = cost  # type: int
        self.cost_percent = cost_percent  # type: int
        self.time_stamp = time_stamp  # type: int
        self.time_type = time_type  # type: str
        self.title = title  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListFlightRuleListChangeRuleInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['content'] = self.content
        if self.cost is not None:
            result['cost'] = self.cost
        if self.cost_percent is not None:
            result['cost_percent'] = self.cost_percent
        if self.time_stamp is not None:
            result['time_stamp'] = self.time_stamp
        if self.time_type is not None:
            result['time_type'] = self.time_type
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('cost') is not None:
            self.cost = m.get('cost')
        if m.get('cost_percent') is not None:
            self.cost_percent = m.get('cost_percent')
        if m.get('time_stamp') is not None:
            self.time_stamp = m.get('time_stamp')
        if m.get('time_type') is not None:
            self.time_type = m.get('time_type')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightSearchListResponseBodyModuleFlightListFlightRuleListChangeRule(TeaModel):
    def __init__(self, able=None, info=None):
        self.able = able  # type: bool
        self.info = info  # type: list[FlightSearchListResponseBodyModuleFlightListFlightRuleListChangeRuleInfo]

    def validate(self):
        if self.info:
            for k in self.info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListFlightRuleListChangeRule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.able is not None:
            result['able'] = self.able
        result['info'] = []
        if self.info is not None:
            for k in self.info:
                result['info'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('able') is not None:
            self.able = m.get('able')
        self.info = []
        if m.get('info') is not None:
            for k in m.get('info'):
                temp_model = FlightSearchListResponseBodyModuleFlightListFlightRuleListChangeRuleInfo()
                self.info.append(temp_model.from_map(k))
        return self


class FlightSearchListResponseBodyModuleFlightListFlightRuleListChangeRuleItemExtraContents(TeaModel):
    def __init__(self, content=None, title=None):
        self.content = content  # type: str
        self.title = title  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListFlightRuleListChangeRuleItemExtraContents, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['content'] = self.content
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightSearchListResponseBodyModuleFlightListFlightRuleListChangeRuleItemRefundSubItemsRefundSubContents(TeaModel):
    def __init__(self, fee_desc=None, fee_range=None, style=None):
        self.fee_desc = fee_desc  # type: str
        self.fee_range = fee_range  # type: str
        self.style = style  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListFlightRuleListChangeRuleItemRefundSubItemsRefundSubContents, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fee_desc is not None:
            result['fee_desc'] = self.fee_desc
        if self.fee_range is not None:
            result['fee_range'] = self.fee_range
        if self.style is not None:
            result['style'] = self.style
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('fee_desc') is not None:
            self.fee_desc = m.get('fee_desc')
        if m.get('fee_range') is not None:
            self.fee_range = m.get('fee_range')
        if m.get('style') is not None:
            self.style = m.get('style')
        return self


class FlightSearchListResponseBodyModuleFlightListFlightRuleListChangeRuleItemRefundSubItems(TeaModel):
    def __init__(self, is_struct=None, ptc=None, refund_sub_contents=None, title=None):
        self.is_struct = is_struct  # type: bool
        # PTC
        self.ptc = ptc  # type: str
        self.refund_sub_contents = refund_sub_contents  # type: list[FlightSearchListResponseBodyModuleFlightListFlightRuleListChangeRuleItemRefundSubItemsRefundSubContents]
        self.title = title  # type: str

    def validate(self):
        if self.refund_sub_contents:
            for k in self.refund_sub_contents:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListFlightRuleListChangeRuleItemRefundSubItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_struct is not None:
            result['is_struct'] = self.is_struct
        if self.ptc is not None:
            result['ptc'] = self.ptc
        result['refund_sub_contents'] = []
        if self.refund_sub_contents is not None:
            for k in self.refund_sub_contents:
                result['refund_sub_contents'].append(k.to_map() if k else None)
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('is_struct') is not None:
            self.is_struct = m.get('is_struct')
        if m.get('ptc') is not None:
            self.ptc = m.get('ptc')
        self.refund_sub_contents = []
        if m.get('refund_sub_contents') is not None:
            for k in m.get('refund_sub_contents'):
                temp_model = FlightSearchListResponseBodyModuleFlightListFlightRuleListChangeRuleItemRefundSubItemsRefundSubContents()
                self.refund_sub_contents.append(temp_model.from_map(k))
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightSearchListResponseBodyModuleFlightListFlightRuleListChangeRuleItem(TeaModel):
    def __init__(self, extra_contents=None, index=None, refund_sub_items=None, sub_table_head=None, table_head=None,
                 title=None, type=None):
        self.extra_contents = extra_contents  # type: list[FlightSearchListResponseBodyModuleFlightListFlightRuleListChangeRuleItemExtraContents]
        self.index = index  # type: int
        self.refund_sub_items = refund_sub_items  # type: list[FlightSearchListResponseBodyModuleFlightListFlightRuleListChangeRuleItemRefundSubItems]
        self.sub_table_head = sub_table_head  # type: list[str]
        self.table_head = table_head  # type: str
        self.title = title  # type: str
        self.type = type  # type: int

    def validate(self):
        if self.extra_contents:
            for k in self.extra_contents:
                if k:
                    k.validate()
        if self.refund_sub_items:
            for k in self.refund_sub_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListFlightRuleListChangeRuleItem, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['extra_contents'] = []
        if self.extra_contents is not None:
            for k in self.extra_contents:
                result['extra_contents'].append(k.to_map() if k else None)
        if self.index is not None:
            result['index'] = self.index
        result['refund_sub_items'] = []
        if self.refund_sub_items is not None:
            for k in self.refund_sub_items:
                result['refund_sub_items'].append(k.to_map() if k else None)
        if self.sub_table_head is not None:
            result['sub_table_head'] = self.sub_table_head
        if self.table_head is not None:
            result['table_head'] = self.table_head
        if self.title is not None:
            result['title'] = self.title
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.extra_contents = []
        if m.get('extra_contents') is not None:
            for k in m.get('extra_contents'):
                temp_model = FlightSearchListResponseBodyModuleFlightListFlightRuleListChangeRuleItemExtraContents()
                self.extra_contents.append(temp_model.from_map(k))
        if m.get('index') is not None:
            self.index = m.get('index')
        self.refund_sub_items = []
        if m.get('refund_sub_items') is not None:
            for k in m.get('refund_sub_items'):
                temp_model = FlightSearchListResponseBodyModuleFlightListFlightRuleListChangeRuleItemRefundSubItems()
                self.refund_sub_items.append(temp_model.from_map(k))
        if m.get('sub_table_head') is not None:
            self.sub_table_head = m.get('sub_table_head')
        if m.get('table_head') is not None:
            self.table_head = m.get('table_head')
        if m.get('title') is not None:
            self.title = m.get('title')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class FlightSearchListResponseBodyModuleFlightListFlightRuleListRefundRuleInfo(TeaModel):
    def __init__(self, content=None, cost=None, cost_percent=None, time_stamp=None, time_type=None, title=None):
        self.content = content  # type: str
        self.cost = cost  # type: int
        self.cost_percent = cost_percent  # type: int
        self.time_stamp = time_stamp  # type: int
        self.time_type = time_type  # type: str
        self.title = title  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListFlightRuleListRefundRuleInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['content'] = self.content
        if self.cost is not None:
            result['cost'] = self.cost
        if self.cost_percent is not None:
            result['cost_percent'] = self.cost_percent
        if self.time_stamp is not None:
            result['time_stamp'] = self.time_stamp
        if self.time_type is not None:
            result['time_type'] = self.time_type
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('cost') is not None:
            self.cost = m.get('cost')
        if m.get('cost_percent') is not None:
            self.cost_percent = m.get('cost_percent')
        if m.get('time_stamp') is not None:
            self.time_stamp = m.get('time_stamp')
        if m.get('time_type') is not None:
            self.time_type = m.get('time_type')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightSearchListResponseBodyModuleFlightListFlightRuleListRefundRule(TeaModel):
    def __init__(self, able=None, info=None):
        self.able = able  # type: bool
        self.info = info  # type: list[FlightSearchListResponseBodyModuleFlightListFlightRuleListRefundRuleInfo]

    def validate(self):
        if self.info:
            for k in self.info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListFlightRuleListRefundRule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.able is not None:
            result['able'] = self.able
        result['info'] = []
        if self.info is not None:
            for k in self.info:
                result['info'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('able') is not None:
            self.able = m.get('able')
        self.info = []
        if m.get('info') is not None:
            for k in m.get('info'):
                temp_model = FlightSearchListResponseBodyModuleFlightListFlightRuleListRefundRuleInfo()
                self.info.append(temp_model.from_map(k))
        return self


class FlightSearchListResponseBodyModuleFlightListFlightRuleListRefundRuleItemExtraContents(TeaModel):
    def __init__(self, content=None, title=None):
        self.content = content  # type: str
        self.title = title  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListFlightRuleListRefundRuleItemExtraContents, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['content'] = self.content
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightSearchListResponseBodyModuleFlightListFlightRuleListRefundRuleItemRefundSubItemsRefundSubContents(TeaModel):
    def __init__(self, fee_desc=None, fee_range=None, style=None):
        self.fee_desc = fee_desc  # type: str
        self.fee_range = fee_range  # type: str
        self.style = style  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListFlightRuleListRefundRuleItemRefundSubItemsRefundSubContents, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fee_desc is not None:
            result['fee_desc'] = self.fee_desc
        if self.fee_range is not None:
            result['fee_range'] = self.fee_range
        if self.style is not None:
            result['style'] = self.style
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('fee_desc') is not None:
            self.fee_desc = m.get('fee_desc')
        if m.get('fee_range') is not None:
            self.fee_range = m.get('fee_range')
        if m.get('style') is not None:
            self.style = m.get('style')
        return self


class FlightSearchListResponseBodyModuleFlightListFlightRuleListRefundRuleItemRefundSubItems(TeaModel):
    def __init__(self, is_struct=None, ptc=None, refund_sub_contents=None, title=None):
        self.is_struct = is_struct  # type: bool
        # PTC
        self.ptc = ptc  # type: str
        self.refund_sub_contents = refund_sub_contents  # type: list[FlightSearchListResponseBodyModuleFlightListFlightRuleListRefundRuleItemRefundSubItemsRefundSubContents]
        self.title = title  # type: str

    def validate(self):
        if self.refund_sub_contents:
            for k in self.refund_sub_contents:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListFlightRuleListRefundRuleItemRefundSubItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_struct is not None:
            result['is_struct'] = self.is_struct
        if self.ptc is not None:
            result['ptc'] = self.ptc
        result['refund_sub_contents'] = []
        if self.refund_sub_contents is not None:
            for k in self.refund_sub_contents:
                result['refund_sub_contents'].append(k.to_map() if k else None)
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('is_struct') is not None:
            self.is_struct = m.get('is_struct')
        if m.get('ptc') is not None:
            self.ptc = m.get('ptc')
        self.refund_sub_contents = []
        if m.get('refund_sub_contents') is not None:
            for k in m.get('refund_sub_contents'):
                temp_model = FlightSearchListResponseBodyModuleFlightListFlightRuleListRefundRuleItemRefundSubItemsRefundSubContents()
                self.refund_sub_contents.append(temp_model.from_map(k))
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightSearchListResponseBodyModuleFlightListFlightRuleListRefundRuleItem(TeaModel):
    def __init__(self, extra_contents=None, index=None, refund_sub_items=None, sub_table_head=None, table_head=None,
                 title=None, type=None):
        self.extra_contents = extra_contents  # type: list[FlightSearchListResponseBodyModuleFlightListFlightRuleListRefundRuleItemExtraContents]
        self.index = index  # type: int
        self.refund_sub_items = refund_sub_items  # type: list[FlightSearchListResponseBodyModuleFlightListFlightRuleListRefundRuleItemRefundSubItems]
        self.sub_table_head = sub_table_head  # type: list[str]
        self.table_head = table_head  # type: str
        self.title = title  # type: str
        self.type = type  # type: int

    def validate(self):
        if self.extra_contents:
            for k in self.extra_contents:
                if k:
                    k.validate()
        if self.refund_sub_items:
            for k in self.refund_sub_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListFlightRuleListRefundRuleItem, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['extra_contents'] = []
        if self.extra_contents is not None:
            for k in self.extra_contents:
                result['extra_contents'].append(k.to_map() if k else None)
        if self.index is not None:
            result['index'] = self.index
        result['refund_sub_items'] = []
        if self.refund_sub_items is not None:
            for k in self.refund_sub_items:
                result['refund_sub_items'].append(k.to_map() if k else None)
        if self.sub_table_head is not None:
            result['sub_table_head'] = self.sub_table_head
        if self.table_head is not None:
            result['table_head'] = self.table_head
        if self.title is not None:
            result['title'] = self.title
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.extra_contents = []
        if m.get('extra_contents') is not None:
            for k in m.get('extra_contents'):
                temp_model = FlightSearchListResponseBodyModuleFlightListFlightRuleListRefundRuleItemExtraContents()
                self.extra_contents.append(temp_model.from_map(k))
        if m.get('index') is not None:
            self.index = m.get('index')
        self.refund_sub_items = []
        if m.get('refund_sub_items') is not None:
            for k in m.get('refund_sub_items'):
                temp_model = FlightSearchListResponseBodyModuleFlightListFlightRuleListRefundRuleItemRefundSubItems()
                self.refund_sub_items.append(temp_model.from_map(k))
        if m.get('sub_table_head') is not None:
            self.sub_table_head = m.get('sub_table_head')
        if m.get('table_head') is not None:
            self.table_head = m.get('table_head')
        if m.get('title') is not None:
            self.title = m.get('title')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class FlightSearchListResponseBodyModuleFlightListFlightRuleListSignRuleInfo(TeaModel):
    def __init__(self, content=None, cost=None, cost_percent=None, time_stamp=None, time_type=None, title=None):
        self.content = content  # type: str
        self.cost = cost  # type: int
        self.cost_percent = cost_percent  # type: int
        self.time_stamp = time_stamp  # type: int
        self.time_type = time_type  # type: str
        self.title = title  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListFlightRuleListSignRuleInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['content'] = self.content
        if self.cost is not None:
            result['cost'] = self.cost
        if self.cost_percent is not None:
            result['cost_percent'] = self.cost_percent
        if self.time_stamp is not None:
            result['time_stamp'] = self.time_stamp
        if self.time_type is not None:
            result['time_type'] = self.time_type
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('cost') is not None:
            self.cost = m.get('cost')
        if m.get('cost_percent') is not None:
            self.cost_percent = m.get('cost_percent')
        if m.get('time_stamp') is not None:
            self.time_stamp = m.get('time_stamp')
        if m.get('time_type') is not None:
            self.time_type = m.get('time_type')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightSearchListResponseBodyModuleFlightListFlightRuleListSignRule(TeaModel):
    def __init__(self, able=None, info=None):
        self.able = able  # type: bool
        self.info = info  # type: list[FlightSearchListResponseBodyModuleFlightListFlightRuleListSignRuleInfo]

    def validate(self):
        if self.info:
            for k in self.info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListFlightRuleListSignRule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.able is not None:
            result['able'] = self.able
        result['info'] = []
        if self.info is not None:
            for k in self.info:
                result['info'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('able') is not None:
            self.able = m.get('able')
        self.info = []
        if m.get('info') is not None:
            for k in m.get('info'):
                temp_model = FlightSearchListResponseBodyModuleFlightListFlightRuleListSignRuleInfo()
                self.info.append(temp_model.from_map(k))
        return self


class FlightSearchListResponseBodyModuleFlightListFlightRuleListUpgradeRuleInfo(TeaModel):
    def __init__(self, content=None, cost=None, cost_percent=None, time_stamp=None, time_type=None, title=None):
        self.content = content  # type: str
        self.cost = cost  # type: int
        self.cost_percent = cost_percent  # type: int
        self.time_stamp = time_stamp  # type: int
        self.time_type = time_type  # type: str
        self.title = title  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListFlightRuleListUpgradeRuleInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['content'] = self.content
        if self.cost is not None:
            result['cost'] = self.cost
        if self.cost_percent is not None:
            result['cost_percent'] = self.cost_percent
        if self.time_stamp is not None:
            result['time_stamp'] = self.time_stamp
        if self.time_type is not None:
            result['time_type'] = self.time_type
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('cost') is not None:
            self.cost = m.get('cost')
        if m.get('cost_percent') is not None:
            self.cost_percent = m.get('cost_percent')
        if m.get('time_stamp') is not None:
            self.time_stamp = m.get('time_stamp')
        if m.get('time_type') is not None:
            self.time_type = m.get('time_type')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightSearchListResponseBodyModuleFlightListFlightRuleListUpgradeRule(TeaModel):
    def __init__(self, able=None, info=None):
        self.able = able  # type: bool
        self.info = info  # type: list[FlightSearchListResponseBodyModuleFlightListFlightRuleListUpgradeRuleInfo]

    def validate(self):
        if self.info:
            for k in self.info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListFlightRuleListUpgradeRule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.able is not None:
            result['able'] = self.able
        result['info'] = []
        if self.info is not None:
            for k in self.info:
                result['info'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('able') is not None:
            self.able = m.get('able')
        self.info = []
        if m.get('info') is not None:
            for k in m.get('info'):
                temp_model = FlightSearchListResponseBodyModuleFlightListFlightRuleListUpgradeRuleInfo()
                self.info.append(temp_model.from_map(k))
        return self


class FlightSearchListResponseBodyModuleFlightListFlightRuleList(TeaModel):
    def __init__(self, baggage_info=None, baggage_item=None, change_rule=None, change_rule_item=None, extra=None,
                 refund_rule=None, refund_rule_item=None, sign_rule=None, tuigaiqian_info=None, upgrade_rule=None):
        self.baggage_info = baggage_info  # type: str
        self.baggage_item = baggage_item  # type: FlightSearchListResponseBodyModuleFlightListFlightRuleListBaggageItem
        self.change_rule = change_rule  # type: FlightSearchListResponseBodyModuleFlightListFlightRuleListChangeRule
        self.change_rule_item = change_rule_item  # type: FlightSearchListResponseBodyModuleFlightListFlightRuleListChangeRuleItem
        self.extra = extra  # type: str
        self.refund_rule = refund_rule  # type: FlightSearchListResponseBodyModuleFlightListFlightRuleListRefundRule
        self.refund_rule_item = refund_rule_item  # type: FlightSearchListResponseBodyModuleFlightListFlightRuleListRefundRuleItem
        self.sign_rule = sign_rule  # type: FlightSearchListResponseBodyModuleFlightListFlightRuleListSignRule
        self.tuigaiqian_info = tuigaiqian_info  # type: str
        self.upgrade_rule = upgrade_rule  # type: FlightSearchListResponseBodyModuleFlightListFlightRuleListUpgradeRule

    def validate(self):
        if self.baggage_item:
            self.baggage_item.validate()
        if self.change_rule:
            self.change_rule.validate()
        if self.change_rule_item:
            self.change_rule_item.validate()
        if self.refund_rule:
            self.refund_rule.validate()
        if self.refund_rule_item:
            self.refund_rule_item.validate()
        if self.sign_rule:
            self.sign_rule.validate()
        if self.upgrade_rule:
            self.upgrade_rule.validate()

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListFlightRuleList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baggage_info is not None:
            result['baggage_info'] = self.baggage_info
        if self.baggage_item is not None:
            result['baggage_item'] = self.baggage_item.to_map()
        if self.change_rule is not None:
            result['change_rule'] = self.change_rule.to_map()
        if self.change_rule_item is not None:
            result['change_rule_item'] = self.change_rule_item.to_map()
        if self.extra is not None:
            result['extra'] = self.extra
        if self.refund_rule is not None:
            result['refund_rule'] = self.refund_rule.to_map()
        if self.refund_rule_item is not None:
            result['refund_rule_item'] = self.refund_rule_item.to_map()
        if self.sign_rule is not None:
            result['sign_rule'] = self.sign_rule.to_map()
        if self.tuigaiqian_info is not None:
            result['tuigaiqian_info'] = self.tuigaiqian_info
        if self.upgrade_rule is not None:
            result['upgrade_rule'] = self.upgrade_rule.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('baggage_info') is not None:
            self.baggage_info = m.get('baggage_info')
        if m.get('baggage_item') is not None:
            temp_model = FlightSearchListResponseBodyModuleFlightListFlightRuleListBaggageItem()
            self.baggage_item = temp_model.from_map(m['baggage_item'])
        if m.get('change_rule') is not None:
            temp_model = FlightSearchListResponseBodyModuleFlightListFlightRuleListChangeRule()
            self.change_rule = temp_model.from_map(m['change_rule'])
        if m.get('change_rule_item') is not None:
            temp_model = FlightSearchListResponseBodyModuleFlightListFlightRuleListChangeRuleItem()
            self.change_rule_item = temp_model.from_map(m['change_rule_item'])
        if m.get('extra') is not None:
            self.extra = m.get('extra')
        if m.get('refund_rule') is not None:
            temp_model = FlightSearchListResponseBodyModuleFlightListFlightRuleListRefundRule()
            self.refund_rule = temp_model.from_map(m['refund_rule'])
        if m.get('refund_rule_item') is not None:
            temp_model = FlightSearchListResponseBodyModuleFlightListFlightRuleListRefundRuleItem()
            self.refund_rule_item = temp_model.from_map(m['refund_rule_item'])
        if m.get('sign_rule') is not None:
            temp_model = FlightSearchListResponseBodyModuleFlightListFlightRuleListSignRule()
            self.sign_rule = temp_model.from_map(m['sign_rule'])
        if m.get('tuigaiqian_info') is not None:
            self.tuigaiqian_info = m.get('tuigaiqian_info')
        if m.get('upgrade_rule') is not None:
            temp_model = FlightSearchListResponseBodyModuleFlightListFlightRuleListUpgradeRule()
            self.upgrade_rule = temp_model.from_map(m['upgrade_rule'])
        return self


class FlightSearchListResponseBodyModuleFlightListTransferInfoTransferAirlineInfo(TeaModel):
    def __init__(self, airline_code=None, airline_name=None, airline_simple_name=None):
        self.airline_code = airline_code  # type: str
        self.airline_name = airline_name  # type: str
        self.airline_simple_name = airline_simple_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListTransferInfoTransferAirlineInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.airline_code is not None:
            result['airline_code'] = self.airline_code
        if self.airline_name is not None:
            result['airline_name'] = self.airline_name
        if self.airline_simple_name is not None:
            result['airline_simple_name'] = self.airline_simple_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('airline_code') is not None:
            self.airline_code = m.get('airline_code')
        if m.get('airline_name') is not None:
            self.airline_name = m.get('airline_name')
        if m.get('airline_simple_name') is not None:
            self.airline_simple_name = m.get('airline_simple_name')
        return self


class FlightSearchListResponseBodyModuleFlightListTransferInfoTransferArrAirportInfo(TeaModel):
    def __init__(self, airport_code=None, airport_name=None, city_code=None, city_name=None, terminal=None):
        self.airport_code = airport_code  # type: str
        self.airport_name = airport_name  # type: str
        self.city_code = city_code  # type: str
        self.city_name = city_name  # type: str
        self.terminal = terminal  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListTransferInfoTransferArrAirportInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.airport_code is not None:
            result['airport_code'] = self.airport_code
        if self.airport_name is not None:
            result['airport_name'] = self.airport_name
        if self.city_code is not None:
            result['city_code'] = self.city_code
        if self.city_name is not None:
            result['city_name'] = self.city_name
        if self.terminal is not None:
            result['terminal'] = self.terminal
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('airport_code') is not None:
            self.airport_code = m.get('airport_code')
        if m.get('airport_name') is not None:
            self.airport_name = m.get('airport_name')
        if m.get('city_code') is not None:
            self.city_code = m.get('city_code')
        if m.get('city_name') is not None:
            self.city_name = m.get('city_name')
        if m.get('terminal') is not None:
            self.terminal = m.get('terminal')
        return self


class FlightSearchListResponseBodyModuleFlightListTransferInfoTransferDepAirportInfo(TeaModel):
    def __init__(self, airport_code=None, airport_name=None, city_code=None, city_name=None, terminal=None):
        self.airport_code = airport_code  # type: str
        self.airport_name = airport_name  # type: str
        self.city_code = city_code  # type: str
        self.city_name = city_name  # type: str
        self.terminal = terminal  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListTransferInfoTransferDepAirportInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.airport_code is not None:
            result['airport_code'] = self.airport_code
        if self.airport_name is not None:
            result['airport_name'] = self.airport_name
        if self.city_code is not None:
            result['city_code'] = self.city_code
        if self.city_name is not None:
            result['city_name'] = self.city_name
        if self.terminal is not None:
            result['terminal'] = self.terminal
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('airport_code') is not None:
            self.airport_code = m.get('airport_code')
        if m.get('airport_name') is not None:
            self.airport_name = m.get('airport_name')
        if m.get('city_code') is not None:
            self.city_code = m.get('city_code')
        if m.get('city_name') is not None:
            self.city_name = m.get('city_name')
        if m.get('terminal') is not None:
            self.terminal = m.get('terminal')
        return self


class FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizesDescription(TeaModel):
    def __init__(self, desc=None, icon=None, image=None, title=None):
        self.desc = desc  # type: str
        self.icon = icon  # type: str
        self.image = image  # type: str
        self.title = title  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizesDescription, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desc is not None:
            result['desc'] = self.desc
        if self.icon is not None:
            result['icon'] = self.icon
        if self.image is not None:
            result['image'] = self.image
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('desc') is not None:
            self.desc = m.get('desc')
        if m.get('icon') is not None:
            self.icon = m.get('icon')
        if m.get('image') is not None:
            self.image = m.get('image')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizesImageDO(TeaModel):
    def __init__(self, image=None, largest=None, middle=None, smallest=None):
        self.image = image  # type: str
        self.largest = largest  # type: str
        self.middle = middle  # type: str
        self.smallest = smallest  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizesImageDO, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image is not None:
            result['image'] = self.image
        if self.largest is not None:
            result['largest'] = self.largest
        if self.middle is not None:
            result['middle'] = self.middle
        if self.smallest is not None:
            result['smallest'] = self.smallest
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('image') is not None:
            self.image = m.get('image')
        if m.get('largest') is not None:
            self.largest = m.get('largest')
        if m.get('middle') is not None:
            self.middle = m.get('middle')
        if m.get('smallest') is not None:
            self.smallest = m.get('smallest')
        return self


class FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizes(TeaModel):
    def __init__(self, baggage_desc=None, baggage_sub_content_type=None, description=None, image_do=None,
                 is_highlight=None, sub_title=None):
        self.baggage_desc = baggage_desc  # type: list[str]
        self.baggage_sub_content_type = baggage_sub_content_type  # type: int
        self.description = description  # type: FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizesDescription
        self.image_do = image_do  # type: FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizesImageDO
        self.is_highlight = is_highlight  # type: bool
        self.sub_title = sub_title  # type: str

    def validate(self):
        if self.description:
            self.description.validate()
        if self.image_do:
            self.image_do.validate()

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizes, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baggage_desc is not None:
            result['baggage_desc'] = self.baggage_desc
        if self.baggage_sub_content_type is not None:
            result['baggage_sub_content_type'] = self.baggage_sub_content_type
        if self.description is not None:
            result['description'] = self.description.to_map()
        if self.image_do is not None:
            result['image_d_o'] = self.image_do.to_map()
        if self.is_highlight is not None:
            result['is_highlight'] = self.is_highlight
        if self.sub_title is not None:
            result['sub_title'] = self.sub_title
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('baggage_desc') is not None:
            self.baggage_desc = m.get('baggage_desc')
        if m.get('baggage_sub_content_type') is not None:
            self.baggage_sub_content_type = m.get('baggage_sub_content_type')
        if m.get('description') is not None:
            temp_model = FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizesDescription()
            self.description = temp_model.from_map(m['description'])
        if m.get('image_d_o') is not None:
            temp_model = FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizesImageDO()
            self.image_do = temp_model.from_map(m['image_d_o'])
        if m.get('is_highlight') is not None:
            self.is_highlight = m.get('is_highlight')
        if m.get('sub_title') is not None:
            self.sub_title = m.get('sub_title')
        return self


class FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListBaggageItemBaggageSubItems(TeaModel):
    def __init__(self, baggage_sub_content_visualizes=None, extra_content_visualizes=None, is_struct=None,
                 ptc=None, title=None):
        self.baggage_sub_content_visualizes = baggage_sub_content_visualizes  # type: list[FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizes]
        self.extra_content_visualizes = extra_content_visualizes  # type: list[any]
        self.is_struct = is_struct  # type: bool
        # PTC
        self.ptc = ptc  # type: str
        self.title = title  # type: str

    def validate(self):
        if self.baggage_sub_content_visualizes:
            for k in self.baggage_sub_content_visualizes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListBaggageItemBaggageSubItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['baggage_sub_content_visualizes'] = []
        if self.baggage_sub_content_visualizes is not None:
            for k in self.baggage_sub_content_visualizes:
                result['baggage_sub_content_visualizes'].append(k.to_map() if k else None)
        if self.extra_content_visualizes is not None:
            result['extra_content_visualizes'] = self.extra_content_visualizes
        if self.is_struct is not None:
            result['is_struct'] = self.is_struct
        if self.ptc is not None:
            result['ptc'] = self.ptc
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.baggage_sub_content_visualizes = []
        if m.get('baggage_sub_content_visualizes') is not None:
            for k in m.get('baggage_sub_content_visualizes'):
                temp_model = FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizes()
                self.baggage_sub_content_visualizes.append(temp_model.from_map(k))
        if m.get('extra_content_visualizes') is not None:
            self.extra_content_visualizes = m.get('extra_content_visualizes')
        if m.get('is_struct') is not None:
            self.is_struct = m.get('is_struct')
        if m.get('ptc') is not None:
            self.ptc = m.get('ptc')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListBaggageItemTips(TeaModel):
    def __init__(self, logo=None, tips_desc=None, tips_image=None):
        self.logo = logo  # type: str
        self.tips_desc = tips_desc  # type: str
        self.tips_image = tips_image  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListBaggageItemTips, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.logo is not None:
            result['logo'] = self.logo
        if self.tips_desc is not None:
            result['tips_desc'] = self.tips_desc
        if self.tips_image is not None:
            result['tips_image'] = self.tips_image
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('logo') is not None:
            self.logo = m.get('logo')
        if m.get('tips_desc') is not None:
            self.tips_desc = m.get('tips_desc')
        if m.get('tips_image') is not None:
            self.tips_image = m.get('tips_image')
        return self


class FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListBaggageItem(TeaModel):
    def __init__(self, baggage_sub_items=None, index=None, table_head=None, tips=None, title=None, type=None):
        self.baggage_sub_items = baggage_sub_items  # type: list[FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListBaggageItemBaggageSubItems]
        self.index = index  # type: int
        self.table_head = table_head  # type: str
        self.tips = tips  # type: FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListBaggageItemTips
        self.title = title  # type: str
        self.type = type  # type: int

    def validate(self):
        if self.baggage_sub_items:
            for k in self.baggage_sub_items:
                if k:
                    k.validate()
        if self.tips:
            self.tips.validate()

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListBaggageItem, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['baggage_sub_items'] = []
        if self.baggage_sub_items is not None:
            for k in self.baggage_sub_items:
                result['baggage_sub_items'].append(k.to_map() if k else None)
        if self.index is not None:
            result['index'] = self.index
        if self.table_head is not None:
            result['table_head'] = self.table_head
        if self.tips is not None:
            result['tips'] = self.tips.to_map()
        if self.title is not None:
            result['title'] = self.title
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.baggage_sub_items = []
        if m.get('baggage_sub_items') is not None:
            for k in m.get('baggage_sub_items'):
                temp_model = FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListBaggageItemBaggageSubItems()
                self.baggage_sub_items.append(temp_model.from_map(k))
        if m.get('index') is not None:
            self.index = m.get('index')
        if m.get('table_head') is not None:
            self.table_head = m.get('table_head')
        if m.get('tips') is not None:
            temp_model = FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListBaggageItemTips()
            self.tips = temp_model.from_map(m['tips'])
        if m.get('title') is not None:
            self.title = m.get('title')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListChangeRuleInfo(TeaModel):
    def __init__(self, content=None, cost=None, cost_percent=None, time_stamp=None, time_type=None, title=None):
        self.content = content  # type: str
        self.cost = cost  # type: int
        self.cost_percent = cost_percent  # type: int
        self.time_stamp = time_stamp  # type: int
        self.time_type = time_type  # type: str
        self.title = title  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListChangeRuleInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['content'] = self.content
        if self.cost is not None:
            result['cost'] = self.cost
        if self.cost_percent is not None:
            result['cost_percent'] = self.cost_percent
        if self.time_stamp is not None:
            result['time_stamp'] = self.time_stamp
        if self.time_type is not None:
            result['time_type'] = self.time_type
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('cost') is not None:
            self.cost = m.get('cost')
        if m.get('cost_percent') is not None:
            self.cost_percent = m.get('cost_percent')
        if m.get('time_stamp') is not None:
            self.time_stamp = m.get('time_stamp')
        if m.get('time_type') is not None:
            self.time_type = m.get('time_type')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListChangeRule(TeaModel):
    def __init__(self, able=None, info=None):
        self.able = able  # type: bool
        self.info = info  # type: list[FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListChangeRuleInfo]

    def validate(self):
        if self.info:
            for k in self.info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListChangeRule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.able is not None:
            result['able'] = self.able
        result['info'] = []
        if self.info is not None:
            for k in self.info:
                result['info'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('able') is not None:
            self.able = m.get('able')
        self.info = []
        if m.get('info') is not None:
            for k in m.get('info'):
                temp_model = FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListChangeRuleInfo()
                self.info.append(temp_model.from_map(k))
        return self


class FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListChangeRuleItemExtraContents(TeaModel):
    def __init__(self, content=None, title=None):
        self.content = content  # type: str
        self.title = title  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListChangeRuleItemExtraContents, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['content'] = self.content
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListChangeRuleItemRefundSubItemsRefundSubContents(TeaModel):
    def __init__(self, fee_desc=None, fee_range=None, style=None):
        self.fee_desc = fee_desc  # type: str
        self.fee_range = fee_range  # type: str
        self.style = style  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListChangeRuleItemRefundSubItemsRefundSubContents, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fee_desc is not None:
            result['fee_desc'] = self.fee_desc
        if self.fee_range is not None:
            result['fee_range'] = self.fee_range
        if self.style is not None:
            result['style'] = self.style
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('fee_desc') is not None:
            self.fee_desc = m.get('fee_desc')
        if m.get('fee_range') is not None:
            self.fee_range = m.get('fee_range')
        if m.get('style') is not None:
            self.style = m.get('style')
        return self


class FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListChangeRuleItemRefundSubItems(TeaModel):
    def __init__(self, is_struct=None, ptc=None, refund_sub_contents=None, title=None):
        self.is_struct = is_struct  # type: bool
        # PTC
        self.ptc = ptc  # type: str
        self.refund_sub_contents = refund_sub_contents  # type: list[FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListChangeRuleItemRefundSubItemsRefundSubContents]
        self.title = title  # type: str

    def validate(self):
        if self.refund_sub_contents:
            for k in self.refund_sub_contents:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListChangeRuleItemRefundSubItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_struct is not None:
            result['is_struct'] = self.is_struct
        if self.ptc is not None:
            result['ptc'] = self.ptc
        result['refund_sub_contents'] = []
        if self.refund_sub_contents is not None:
            for k in self.refund_sub_contents:
                result['refund_sub_contents'].append(k.to_map() if k else None)
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('is_struct') is not None:
            self.is_struct = m.get('is_struct')
        if m.get('ptc') is not None:
            self.ptc = m.get('ptc')
        self.refund_sub_contents = []
        if m.get('refund_sub_contents') is not None:
            for k in m.get('refund_sub_contents'):
                temp_model = FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListChangeRuleItemRefundSubItemsRefundSubContents()
                self.refund_sub_contents.append(temp_model.from_map(k))
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListChangeRuleItem(TeaModel):
    def __init__(self, extra_contents=None, index=None, refund_sub_items=None, sub_table_head=None, table_head=None,
                 title=None, type=None):
        self.extra_contents = extra_contents  # type: list[FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListChangeRuleItemExtraContents]
        self.index = index  # type: int
        self.refund_sub_items = refund_sub_items  # type: list[FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListChangeRuleItemRefundSubItems]
        self.sub_table_head = sub_table_head  # type: list[str]
        self.table_head = table_head  # type: str
        self.title = title  # type: str
        self.type = type  # type: int

    def validate(self):
        if self.extra_contents:
            for k in self.extra_contents:
                if k:
                    k.validate()
        if self.refund_sub_items:
            for k in self.refund_sub_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListChangeRuleItem, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['extra_contents'] = []
        if self.extra_contents is not None:
            for k in self.extra_contents:
                result['extra_contents'].append(k.to_map() if k else None)
        if self.index is not None:
            result['index'] = self.index
        result['refund_sub_items'] = []
        if self.refund_sub_items is not None:
            for k in self.refund_sub_items:
                result['refund_sub_items'].append(k.to_map() if k else None)
        if self.sub_table_head is not None:
            result['sub_table_head'] = self.sub_table_head
        if self.table_head is not None:
            result['table_head'] = self.table_head
        if self.title is not None:
            result['title'] = self.title
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.extra_contents = []
        if m.get('extra_contents') is not None:
            for k in m.get('extra_contents'):
                temp_model = FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListChangeRuleItemExtraContents()
                self.extra_contents.append(temp_model.from_map(k))
        if m.get('index') is not None:
            self.index = m.get('index')
        self.refund_sub_items = []
        if m.get('refund_sub_items') is not None:
            for k in m.get('refund_sub_items'):
                temp_model = FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListChangeRuleItemRefundSubItems()
                self.refund_sub_items.append(temp_model.from_map(k))
        if m.get('sub_table_head') is not None:
            self.sub_table_head = m.get('sub_table_head')
        if m.get('table_head') is not None:
            self.table_head = m.get('table_head')
        if m.get('title') is not None:
            self.title = m.get('title')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListRefundRuleInfo(TeaModel):
    def __init__(self, content=None, cost=None, cost_percent=None, time_stamp=None, time_type=None, title=None):
        self.content = content  # type: str
        self.cost = cost  # type: int
        self.cost_percent = cost_percent  # type: int
        self.time_stamp = time_stamp  # type: int
        self.time_type = time_type  # type: str
        self.title = title  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListRefundRuleInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['content'] = self.content
        if self.cost is not None:
            result['cost'] = self.cost
        if self.cost_percent is not None:
            result['cost_percent'] = self.cost_percent
        if self.time_stamp is not None:
            result['time_stamp'] = self.time_stamp
        if self.time_type is not None:
            result['time_type'] = self.time_type
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('cost') is not None:
            self.cost = m.get('cost')
        if m.get('cost_percent') is not None:
            self.cost_percent = m.get('cost_percent')
        if m.get('time_stamp') is not None:
            self.time_stamp = m.get('time_stamp')
        if m.get('time_type') is not None:
            self.time_type = m.get('time_type')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListRefundRule(TeaModel):
    def __init__(self, able=None, info=None):
        self.able = able  # type: bool
        self.info = info  # type: list[FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListRefundRuleInfo]

    def validate(self):
        if self.info:
            for k in self.info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListRefundRule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.able is not None:
            result['able'] = self.able
        result['info'] = []
        if self.info is not None:
            for k in self.info:
                result['info'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('able') is not None:
            self.able = m.get('able')
        self.info = []
        if m.get('info') is not None:
            for k in m.get('info'):
                temp_model = FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListRefundRuleInfo()
                self.info.append(temp_model.from_map(k))
        return self


class FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListRefundRuleItemExtraContents(TeaModel):
    def __init__(self, content=None, title=None):
        self.content = content  # type: str
        self.title = title  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListRefundRuleItemExtraContents, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['content'] = self.content
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListRefundRuleItemRefundSubItemsRefundSubContents(TeaModel):
    def __init__(self, fee_desc=None, fee_range=None, style=None):
        self.fee_desc = fee_desc  # type: str
        self.fee_range = fee_range  # type: str
        self.style = style  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListRefundRuleItemRefundSubItemsRefundSubContents, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fee_desc is not None:
            result['fee_desc'] = self.fee_desc
        if self.fee_range is not None:
            result['fee_range'] = self.fee_range
        if self.style is not None:
            result['style'] = self.style
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('fee_desc') is not None:
            self.fee_desc = m.get('fee_desc')
        if m.get('fee_range') is not None:
            self.fee_range = m.get('fee_range')
        if m.get('style') is not None:
            self.style = m.get('style')
        return self


class FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListRefundRuleItemRefundSubItems(TeaModel):
    def __init__(self, is_struct=None, ptc=None, refund_sub_contents=None, title=None):
        self.is_struct = is_struct  # type: bool
        # PTC
        self.ptc = ptc  # type: str
        self.refund_sub_contents = refund_sub_contents  # type: list[FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListRefundRuleItemRefundSubItemsRefundSubContents]
        self.title = title  # type: str

    def validate(self):
        if self.refund_sub_contents:
            for k in self.refund_sub_contents:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListRefundRuleItemRefundSubItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_struct is not None:
            result['is_struct'] = self.is_struct
        if self.ptc is not None:
            result['ptc'] = self.ptc
        result['refund_sub_contents'] = []
        if self.refund_sub_contents is not None:
            for k in self.refund_sub_contents:
                result['refund_sub_contents'].append(k.to_map() if k else None)
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('is_struct') is not None:
            self.is_struct = m.get('is_struct')
        if m.get('ptc') is not None:
            self.ptc = m.get('ptc')
        self.refund_sub_contents = []
        if m.get('refund_sub_contents') is not None:
            for k in m.get('refund_sub_contents'):
                temp_model = FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListRefundRuleItemRefundSubItemsRefundSubContents()
                self.refund_sub_contents.append(temp_model.from_map(k))
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListRefundRuleItem(TeaModel):
    def __init__(self, extra_contents=None, index=None, refund_sub_items=None, sub_table_head=None, table_head=None,
                 title=None, type=None):
        self.extra_contents = extra_contents  # type: list[FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListRefundRuleItemExtraContents]
        self.index = index  # type: int
        self.refund_sub_items = refund_sub_items  # type: list[FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListRefundRuleItemRefundSubItems]
        self.sub_table_head = sub_table_head  # type: list[str]
        self.table_head = table_head  # type: str
        self.title = title  # type: str
        self.type = type  # type: int

    def validate(self):
        if self.extra_contents:
            for k in self.extra_contents:
                if k:
                    k.validate()
        if self.refund_sub_items:
            for k in self.refund_sub_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListRefundRuleItem, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['extra_contents'] = []
        if self.extra_contents is not None:
            for k in self.extra_contents:
                result['extra_contents'].append(k.to_map() if k else None)
        if self.index is not None:
            result['index'] = self.index
        result['refund_sub_items'] = []
        if self.refund_sub_items is not None:
            for k in self.refund_sub_items:
                result['refund_sub_items'].append(k.to_map() if k else None)
        if self.sub_table_head is not None:
            result['sub_table_head'] = self.sub_table_head
        if self.table_head is not None:
            result['table_head'] = self.table_head
        if self.title is not None:
            result['title'] = self.title
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.extra_contents = []
        if m.get('extra_contents') is not None:
            for k in m.get('extra_contents'):
                temp_model = FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListRefundRuleItemExtraContents()
                self.extra_contents.append(temp_model.from_map(k))
        if m.get('index') is not None:
            self.index = m.get('index')
        self.refund_sub_items = []
        if m.get('refund_sub_items') is not None:
            for k in m.get('refund_sub_items'):
                temp_model = FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListRefundRuleItemRefundSubItems()
                self.refund_sub_items.append(temp_model.from_map(k))
        if m.get('sub_table_head') is not None:
            self.sub_table_head = m.get('sub_table_head')
        if m.get('table_head') is not None:
            self.table_head = m.get('table_head')
        if m.get('title') is not None:
            self.title = m.get('title')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListSignRuleInfo(TeaModel):
    def __init__(self, content=None, cost=None, cost_percent=None, time_stamp=None, time_type=None, title=None):
        self.content = content  # type: str
        self.cost = cost  # type: int
        self.cost_percent = cost_percent  # type: int
        self.time_stamp = time_stamp  # type: int
        self.time_type = time_type  # type: str
        self.title = title  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListSignRuleInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['content'] = self.content
        if self.cost is not None:
            result['cost'] = self.cost
        if self.cost_percent is not None:
            result['cost_percent'] = self.cost_percent
        if self.time_stamp is not None:
            result['time_stamp'] = self.time_stamp
        if self.time_type is not None:
            result['time_type'] = self.time_type
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('cost') is not None:
            self.cost = m.get('cost')
        if m.get('cost_percent') is not None:
            self.cost_percent = m.get('cost_percent')
        if m.get('time_stamp') is not None:
            self.time_stamp = m.get('time_stamp')
        if m.get('time_type') is not None:
            self.time_type = m.get('time_type')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListSignRule(TeaModel):
    def __init__(self, able=None, info=None):
        self.able = able  # type: bool
        self.info = info  # type: list[FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListSignRuleInfo]

    def validate(self):
        if self.info:
            for k in self.info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListSignRule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.able is not None:
            result['able'] = self.able
        result['info'] = []
        if self.info is not None:
            for k in self.info:
                result['info'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('able') is not None:
            self.able = m.get('able')
        self.info = []
        if m.get('info') is not None:
            for k in m.get('info'):
                temp_model = FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListSignRuleInfo()
                self.info.append(temp_model.from_map(k))
        return self


class FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListUpgradeRuleInfo(TeaModel):
    def __init__(self, content=None, cost=None, cost_percent=None, time_stamp=None, time_type=None, title=None):
        self.content = content  # type: str
        self.cost = cost  # type: int
        self.cost_percent = cost_percent  # type: int
        self.time_stamp = time_stamp  # type: int
        self.time_type = time_type  # type: str
        self.title = title  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListUpgradeRuleInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['content'] = self.content
        if self.cost is not None:
            result['cost'] = self.cost
        if self.cost_percent is not None:
            result['cost_percent'] = self.cost_percent
        if self.time_stamp is not None:
            result['time_stamp'] = self.time_stamp
        if self.time_type is not None:
            result['time_type'] = self.time_type
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('cost') is not None:
            self.cost = m.get('cost')
        if m.get('cost_percent') is not None:
            self.cost_percent = m.get('cost_percent')
        if m.get('time_stamp') is not None:
            self.time_stamp = m.get('time_stamp')
        if m.get('time_type') is not None:
            self.time_type = m.get('time_type')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListUpgradeRule(TeaModel):
    def __init__(self, able=None, info=None):
        self.able = able  # type: bool
        self.info = info  # type: list[FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListUpgradeRuleInfo]

    def validate(self):
        if self.info:
            for k in self.info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListUpgradeRule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.able is not None:
            result['able'] = self.able
        result['info'] = []
        if self.info is not None:
            for k in self.info:
                result['info'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('able') is not None:
            self.able = m.get('able')
        self.info = []
        if m.get('info') is not None:
            for k in m.get('info'):
                temp_model = FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListUpgradeRuleInfo()
                self.info.append(temp_model.from_map(k))
        return self


class FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleList(TeaModel):
    def __init__(self, baggage_info=None, baggage_item=None, change_rule=None, change_rule_item=None, extra=None,
                 refund_rule=None, refund_rule_item=None, sign_rule=None, tuigaiqian_info=None, upgrade_rule=None):
        self.baggage_info = baggage_info  # type: str
        self.baggage_item = baggage_item  # type: FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListBaggageItem
        self.change_rule = change_rule  # type: FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListChangeRule
        self.change_rule_item = change_rule_item  # type: FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListChangeRuleItem
        self.extra = extra  # type: str
        self.refund_rule = refund_rule  # type: FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListRefundRule
        self.refund_rule_item = refund_rule_item  # type: FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListRefundRuleItem
        self.sign_rule = sign_rule  # type: FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListSignRule
        self.tuigaiqian_info = tuigaiqian_info  # type: str
        self.upgrade_rule = upgrade_rule  # type: FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListUpgradeRule

    def validate(self):
        if self.baggage_item:
            self.baggage_item.validate()
        if self.change_rule:
            self.change_rule.validate()
        if self.change_rule_item:
            self.change_rule_item.validate()
        if self.refund_rule:
            self.refund_rule.validate()
        if self.refund_rule_item:
            self.refund_rule_item.validate()
        if self.sign_rule:
            self.sign_rule.validate()
        if self.upgrade_rule:
            self.upgrade_rule.validate()

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baggage_info is not None:
            result['baggage_info'] = self.baggage_info
        if self.baggage_item is not None:
            result['baggage_item'] = self.baggage_item.to_map()
        if self.change_rule is not None:
            result['change_rule'] = self.change_rule.to_map()
        if self.change_rule_item is not None:
            result['change_rule_item'] = self.change_rule_item.to_map()
        if self.extra is not None:
            result['extra'] = self.extra
        if self.refund_rule is not None:
            result['refund_rule'] = self.refund_rule.to_map()
        if self.refund_rule_item is not None:
            result['refund_rule_item'] = self.refund_rule_item.to_map()
        if self.sign_rule is not None:
            result['sign_rule'] = self.sign_rule.to_map()
        if self.tuigaiqian_info is not None:
            result['tuigaiqian_info'] = self.tuigaiqian_info
        if self.upgrade_rule is not None:
            result['upgrade_rule'] = self.upgrade_rule.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('baggage_info') is not None:
            self.baggage_info = m.get('baggage_info')
        if m.get('baggage_item') is not None:
            temp_model = FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListBaggageItem()
            self.baggage_item = temp_model.from_map(m['baggage_item'])
        if m.get('change_rule') is not None:
            temp_model = FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListChangeRule()
            self.change_rule = temp_model.from_map(m['change_rule'])
        if m.get('change_rule_item') is not None:
            temp_model = FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListChangeRuleItem()
            self.change_rule_item = temp_model.from_map(m['change_rule_item'])
        if m.get('extra') is not None:
            self.extra = m.get('extra')
        if m.get('refund_rule') is not None:
            temp_model = FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListRefundRule()
            self.refund_rule = temp_model.from_map(m['refund_rule'])
        if m.get('refund_rule_item') is not None:
            temp_model = FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListRefundRuleItem()
            self.refund_rule_item = temp_model.from_map(m['refund_rule_item'])
        if m.get('sign_rule') is not None:
            temp_model = FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListSignRule()
            self.sign_rule = temp_model.from_map(m['sign_rule'])
        if m.get('tuigaiqian_info') is not None:
            self.tuigaiqian_info = m.get('tuigaiqian_info')
        if m.get('upgrade_rule') is not None:
            temp_model = FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListUpgradeRule()
            self.upgrade_rule = temp_model.from_map(m['upgrade_rule'])
        return self


class FlightSearchListResponseBodyModuleFlightListTransferInfo(TeaModel):
    def __init__(self, flight_size=None, flight_type=None, transfer_airline_info=None,
                 transfer_arr_airport_info=None, transfer_arr_date=None, transfer_dep_airport_info=None, transfer_dep_date=None,
                 transfer_flight_no=None, transfer_flight_rule_list=None):
        self.flight_size = flight_size  # type: str
        self.flight_type = flight_type  # type: str
        self.transfer_airline_info = transfer_airline_info  # type: FlightSearchListResponseBodyModuleFlightListTransferInfoTransferAirlineInfo
        self.transfer_arr_airport_info = transfer_arr_airport_info  # type: FlightSearchListResponseBodyModuleFlightListTransferInfoTransferArrAirportInfo
        self.transfer_arr_date = transfer_arr_date  # type: str
        self.transfer_dep_airport_info = transfer_dep_airport_info  # type: FlightSearchListResponseBodyModuleFlightListTransferInfoTransferDepAirportInfo
        self.transfer_dep_date = transfer_dep_date  # type: str
        self.transfer_flight_no = transfer_flight_no  # type: str
        self.transfer_flight_rule_list = transfer_flight_rule_list  # type: list[FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleList]

    def validate(self):
        if self.transfer_airline_info:
            self.transfer_airline_info.validate()
        if self.transfer_arr_airport_info:
            self.transfer_arr_airport_info.validate()
        if self.transfer_dep_airport_info:
            self.transfer_dep_airport_info.validate()
        if self.transfer_flight_rule_list:
            for k in self.transfer_flight_rule_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightListTransferInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.flight_size is not None:
            result['flight_size'] = self.flight_size
        if self.flight_type is not None:
            result['flight_type'] = self.flight_type
        if self.transfer_airline_info is not None:
            result['transfer_airline_info'] = self.transfer_airline_info.to_map()
        if self.transfer_arr_airport_info is not None:
            result['transfer_arr_airport_info'] = self.transfer_arr_airport_info.to_map()
        if self.transfer_arr_date is not None:
            result['transfer_arr_date'] = self.transfer_arr_date
        if self.transfer_dep_airport_info is not None:
            result['transfer_dep_airport_info'] = self.transfer_dep_airport_info.to_map()
        if self.transfer_dep_date is not None:
            result['transfer_dep_date'] = self.transfer_dep_date
        if self.transfer_flight_no is not None:
            result['transfer_flight_no'] = self.transfer_flight_no
        result['transfer_flight_rule_list'] = []
        if self.transfer_flight_rule_list is not None:
            for k in self.transfer_flight_rule_list:
                result['transfer_flight_rule_list'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('flight_size') is not None:
            self.flight_size = m.get('flight_size')
        if m.get('flight_type') is not None:
            self.flight_type = m.get('flight_type')
        if m.get('transfer_airline_info') is not None:
            temp_model = FlightSearchListResponseBodyModuleFlightListTransferInfoTransferAirlineInfo()
            self.transfer_airline_info = temp_model.from_map(m['transfer_airline_info'])
        if m.get('transfer_arr_airport_info') is not None:
            temp_model = FlightSearchListResponseBodyModuleFlightListTransferInfoTransferArrAirportInfo()
            self.transfer_arr_airport_info = temp_model.from_map(m['transfer_arr_airport_info'])
        if m.get('transfer_arr_date') is not None:
            self.transfer_arr_date = m.get('transfer_arr_date')
        if m.get('transfer_dep_airport_info') is not None:
            temp_model = FlightSearchListResponseBodyModuleFlightListTransferInfoTransferDepAirportInfo()
            self.transfer_dep_airport_info = temp_model.from_map(m['transfer_dep_airport_info'])
        if m.get('transfer_dep_date') is not None:
            self.transfer_dep_date = m.get('transfer_dep_date')
        if m.get('transfer_flight_no') is not None:
            self.transfer_flight_no = m.get('transfer_flight_no')
        self.transfer_flight_rule_list = []
        if m.get('transfer_flight_rule_list') is not None:
            for k in m.get('transfer_flight_rule_list'):
                temp_model = FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleList()
                self.transfer_flight_rule_list.append(temp_model.from_map(k))
        return self


class FlightSearchListResponseBodyModuleFlightList(TeaModel):
    def __init__(self, airline_info=None, arr_airport_info=None, arr_date=None, basic_cabin_price=None,
                 build_price=None, cabin=None, cabin_class=None, cabin_info_list=None, carrier_airline=None, carrier_no=None,
                 class_rule=None, dep_airport_info=None, dep_city_code=None, dep_date=None, discount=None, flight_no=None,
                 flight_rule_list=None, flight_rule_list_str=None, flight_size=None, flight_type=None, invoice_type=None,
                 is_protocol=None, is_share=None, is_stop=None, is_transfer=None, meal_desc=None, memo=None, oil_price=None,
                 ota_item_id=None, price=None, product_type=None, product_type_desc=None, promotion_price=None,
                 remained_seat_count=None, secret_params=None, segment_number=None, stop_arr_time=None, stop_city=None,
                 stop_dep_time=None, ticket_price=None, total_price=None, transfer_info=None, trip_type=None):
        self.airline_info = airline_info  # type: FlightSearchListResponseBodyModuleFlightListAirlineInfo
        self.arr_airport_info = arr_airport_info  # type: FlightSearchListResponseBodyModuleFlightListArrAirportInfo
        self.arr_date = arr_date  # type: str
        self.basic_cabin_price = basic_cabin_price  # type: int
        self.build_price = build_price  # type: int
        self.cabin = cabin  # type: str
        self.cabin_class = cabin_class  # type: str
        self.cabin_info_list = cabin_info_list  # type: list[FlightSearchListResponseBodyModuleFlightListCabinInfoList]
        self.carrier_airline = carrier_airline  # type: str
        self.carrier_no = carrier_no  # type: str
        self.class_rule = class_rule  # type: str
        self.dep_airport_info = dep_airport_info  # type: FlightSearchListResponseBodyModuleFlightListDepAirportInfo
        self.dep_city_code = dep_city_code  # type: str
        self.dep_date = dep_date  # type: str
        self.discount = discount  # type: int
        self.flight_no = flight_no  # type: str
        self.flight_rule_list = flight_rule_list  # type: list[FlightSearchListResponseBodyModuleFlightListFlightRuleList]
        self.flight_rule_list_str = flight_rule_list_str  # type: str
        self.flight_size = flight_size  # type: str
        self.flight_type = flight_type  # type: str
        self.invoice_type = invoice_type  # type: int
        self.is_protocol = is_protocol  # type: bool
        self.is_share = is_share  # type: bool
        self.is_stop = is_stop  # type: bool
        self.is_transfer = is_transfer  # type: bool
        self.meal_desc = meal_desc  # type: str
        self.memo = memo  # type: str
        self.oil_price = oil_price  # type: int
        self.ota_item_id = ota_item_id  # type: str
        self.price = price  # type: int
        self.product_type = product_type  # type: long
        self.product_type_desc = product_type_desc  # type: str
        self.promotion_price = promotion_price  # type: str
        self.remained_seat_count = remained_seat_count  # type: str
        self.secret_params = secret_params  # type: str
        self.segment_number = segment_number  # type: str
        self.stop_arr_time = stop_arr_time  # type: str
        self.stop_city = stop_city  # type: str
        self.stop_dep_time = stop_dep_time  # type: str
        self.ticket_price = ticket_price  # type: int
        self.total_price = total_price  # type: str
        self.transfer_info = transfer_info  # type: FlightSearchListResponseBodyModuleFlightListTransferInfo
        self.trip_type = trip_type  # type: int

    def validate(self):
        if self.airline_info:
            self.airline_info.validate()
        if self.arr_airport_info:
            self.arr_airport_info.validate()
        if self.cabin_info_list:
            for k in self.cabin_info_list:
                if k:
                    k.validate()
        if self.dep_airport_info:
            self.dep_airport_info.validate()
        if self.flight_rule_list:
            for k in self.flight_rule_list:
                if k:
                    k.validate()
        if self.transfer_info:
            self.transfer_info.validate()

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModuleFlightList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.airline_info is not None:
            result['airline_info'] = self.airline_info.to_map()
        if self.arr_airport_info is not None:
            result['arr_airport_info'] = self.arr_airport_info.to_map()
        if self.arr_date is not None:
            result['arr_date'] = self.arr_date
        if self.basic_cabin_price is not None:
            result['basic_cabin_price'] = self.basic_cabin_price
        if self.build_price is not None:
            result['build_price'] = self.build_price
        if self.cabin is not None:
            result['cabin'] = self.cabin
        if self.cabin_class is not None:
            result['cabin_class'] = self.cabin_class
        result['cabin_info_list'] = []
        if self.cabin_info_list is not None:
            for k in self.cabin_info_list:
                result['cabin_info_list'].append(k.to_map() if k else None)
        if self.carrier_airline is not None:
            result['carrier_airline'] = self.carrier_airline
        if self.carrier_no is not None:
            result['carrier_no'] = self.carrier_no
        if self.class_rule is not None:
            result['class_rule'] = self.class_rule
        if self.dep_airport_info is not None:
            result['dep_airport_info'] = self.dep_airport_info.to_map()
        if self.dep_city_code is not None:
            result['dep_city_code'] = self.dep_city_code
        if self.dep_date is not None:
            result['dep_date'] = self.dep_date
        if self.discount is not None:
            result['discount'] = self.discount
        if self.flight_no is not None:
            result['flight_no'] = self.flight_no
        result['flight_rule_list'] = []
        if self.flight_rule_list is not None:
            for k in self.flight_rule_list:
                result['flight_rule_list'].append(k.to_map() if k else None)
        if self.flight_rule_list_str is not None:
            result['flight_rule_list_str'] = self.flight_rule_list_str
        if self.flight_size is not None:
            result['flight_size'] = self.flight_size
        if self.flight_type is not None:
            result['flight_type'] = self.flight_type
        if self.invoice_type is not None:
            result['invoice_type'] = self.invoice_type
        if self.is_protocol is not None:
            result['is_protocol'] = self.is_protocol
        if self.is_share is not None:
            result['is_share'] = self.is_share
        if self.is_stop is not None:
            result['is_stop'] = self.is_stop
        if self.is_transfer is not None:
            result['is_transfer'] = self.is_transfer
        if self.meal_desc is not None:
            result['meal_desc'] = self.meal_desc
        if self.memo is not None:
            result['memo'] = self.memo
        if self.oil_price is not None:
            result['oil_price'] = self.oil_price
        if self.ota_item_id is not None:
            result['ota_item_id'] = self.ota_item_id
        if self.price is not None:
            result['price'] = self.price
        if self.product_type is not None:
            result['product_type'] = self.product_type
        if self.product_type_desc is not None:
            result['product_type_desc'] = self.product_type_desc
        if self.promotion_price is not None:
            result['promotion_price'] = self.promotion_price
        if self.remained_seat_count is not None:
            result['remained_seat_count'] = self.remained_seat_count
        if self.secret_params is not None:
            result['secret_params'] = self.secret_params
        if self.segment_number is not None:
            result['segment_number'] = self.segment_number
        if self.stop_arr_time is not None:
            result['stop_arr_time'] = self.stop_arr_time
        if self.stop_city is not None:
            result['stop_city'] = self.stop_city
        if self.stop_dep_time is not None:
            result['stop_dep_time'] = self.stop_dep_time
        if self.ticket_price is not None:
            result['ticket_price'] = self.ticket_price
        if self.total_price is not None:
            result['total_price'] = self.total_price
        if self.transfer_info is not None:
            result['transfer_info'] = self.transfer_info.to_map()
        if self.trip_type is not None:
            result['trip_type'] = self.trip_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('airline_info') is not None:
            temp_model = FlightSearchListResponseBodyModuleFlightListAirlineInfo()
            self.airline_info = temp_model.from_map(m['airline_info'])
        if m.get('arr_airport_info') is not None:
            temp_model = FlightSearchListResponseBodyModuleFlightListArrAirportInfo()
            self.arr_airport_info = temp_model.from_map(m['arr_airport_info'])
        if m.get('arr_date') is not None:
            self.arr_date = m.get('arr_date')
        if m.get('basic_cabin_price') is not None:
            self.basic_cabin_price = m.get('basic_cabin_price')
        if m.get('build_price') is not None:
            self.build_price = m.get('build_price')
        if m.get('cabin') is not None:
            self.cabin = m.get('cabin')
        if m.get('cabin_class') is not None:
            self.cabin_class = m.get('cabin_class')
        self.cabin_info_list = []
        if m.get('cabin_info_list') is not None:
            for k in m.get('cabin_info_list'):
                temp_model = FlightSearchListResponseBodyModuleFlightListCabinInfoList()
                self.cabin_info_list.append(temp_model.from_map(k))
        if m.get('carrier_airline') is not None:
            self.carrier_airline = m.get('carrier_airline')
        if m.get('carrier_no') is not None:
            self.carrier_no = m.get('carrier_no')
        if m.get('class_rule') is not None:
            self.class_rule = m.get('class_rule')
        if m.get('dep_airport_info') is not None:
            temp_model = FlightSearchListResponseBodyModuleFlightListDepAirportInfo()
            self.dep_airport_info = temp_model.from_map(m['dep_airport_info'])
        if m.get('dep_city_code') is not None:
            self.dep_city_code = m.get('dep_city_code')
        if m.get('dep_date') is not None:
            self.dep_date = m.get('dep_date')
        if m.get('discount') is not None:
            self.discount = m.get('discount')
        if m.get('flight_no') is not None:
            self.flight_no = m.get('flight_no')
        self.flight_rule_list = []
        if m.get('flight_rule_list') is not None:
            for k in m.get('flight_rule_list'):
                temp_model = FlightSearchListResponseBodyModuleFlightListFlightRuleList()
                self.flight_rule_list.append(temp_model.from_map(k))
        if m.get('flight_rule_list_str') is not None:
            self.flight_rule_list_str = m.get('flight_rule_list_str')
        if m.get('flight_size') is not None:
            self.flight_size = m.get('flight_size')
        if m.get('flight_type') is not None:
            self.flight_type = m.get('flight_type')
        if m.get('invoice_type') is not None:
            self.invoice_type = m.get('invoice_type')
        if m.get('is_protocol') is not None:
            self.is_protocol = m.get('is_protocol')
        if m.get('is_share') is not None:
            self.is_share = m.get('is_share')
        if m.get('is_stop') is not None:
            self.is_stop = m.get('is_stop')
        if m.get('is_transfer') is not None:
            self.is_transfer = m.get('is_transfer')
        if m.get('meal_desc') is not None:
            self.meal_desc = m.get('meal_desc')
        if m.get('memo') is not None:
            self.memo = m.get('memo')
        if m.get('oil_price') is not None:
            self.oil_price = m.get('oil_price')
        if m.get('ota_item_id') is not None:
            self.ota_item_id = m.get('ota_item_id')
        if m.get('price') is not None:
            self.price = m.get('price')
        if m.get('product_type') is not None:
            self.product_type = m.get('product_type')
        if m.get('product_type_desc') is not None:
            self.product_type_desc = m.get('product_type_desc')
        if m.get('promotion_price') is not None:
            self.promotion_price = m.get('promotion_price')
        if m.get('remained_seat_count') is not None:
            self.remained_seat_count = m.get('remained_seat_count')
        if m.get('secret_params') is not None:
            self.secret_params = m.get('secret_params')
        if m.get('segment_number') is not None:
            self.segment_number = m.get('segment_number')
        if m.get('stop_arr_time') is not None:
            self.stop_arr_time = m.get('stop_arr_time')
        if m.get('stop_city') is not None:
            self.stop_city = m.get('stop_city')
        if m.get('stop_dep_time') is not None:
            self.stop_dep_time = m.get('stop_dep_time')
        if m.get('ticket_price') is not None:
            self.ticket_price = m.get('ticket_price')
        if m.get('total_price') is not None:
            self.total_price = m.get('total_price')
        if m.get('transfer_info') is not None:
            temp_model = FlightSearchListResponseBodyModuleFlightListTransferInfo()
            self.transfer_info = temp_model.from_map(m['transfer_info'])
        if m.get('trip_type') is not None:
            self.trip_type = m.get('trip_type')
        return self


class FlightSearchListResponseBodyModule(TeaModel):
    def __init__(self, flight_list=None, is_replace_pnr=None):
        self.flight_list = flight_list  # type: list[FlightSearchListResponseBodyModuleFlightList]
        self.is_replace_pnr = is_replace_pnr  # type: bool

    def validate(self):
        if self.flight_list:
            for k in self.flight_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(FlightSearchListResponseBodyModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['flight_list'] = []
        if self.flight_list is not None:
            for k in self.flight_list:
                result['flight_list'].append(k.to_map() if k else None)
        if self.is_replace_pnr is not None:
            result['is_replace_pnr'] = self.is_replace_pnr
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.flight_list = []
        if m.get('flight_list') is not None:
            for k in m.get('flight_list'):
                temp_model = FlightSearchListResponseBodyModuleFlightList()
                self.flight_list.append(temp_model.from_map(k))
        if m.get('is_replace_pnr') is not None:
            self.is_replace_pnr = m.get('is_replace_pnr')
        return self


class FlightSearchListResponseBody(TeaModel):
    def __init__(self, code=None, message=None, module=None, request_id=None, success=None, trace_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.module = module  # type: FlightSearchListResponseBodyModule
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.trace_id = trace_id  # type: str

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super(FlightSearchListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = FlightSearchListResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class FlightSearchListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: FlightSearchListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(FlightSearchListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = FlightSearchListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class HotelBillSettlementQueryHeaders(TeaModel):
    def __init__(self, common_headers=None, x_acs_btrip_so_corp_token=None):
        self.common_headers = common_headers  # type: dict[str, str]
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(HotelBillSettlementQueryHeaders, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class HotelBillSettlementQueryRequest(TeaModel):
    def __init__(self, page_no=None, page_size=None, period_end=None, period_start=None):
        self.page_no = page_no  # type: int
        self.page_size = page_size  # type: int
        self.period_end = period_end  # type: str
        self.period_start = period_start  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(HotelBillSettlementQueryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_no is not None:
            result['page_no'] = self.page_no
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.period_end is not None:
            result['period_end'] = self.period_end
        if self.period_start is not None:
            result['period_start'] = self.period_start
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('page_no') is not None:
            self.page_no = m.get('page_no')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('period_end') is not None:
            self.period_end = m.get('period_end')
        if m.get('period_start') is not None:
            self.period_start = m.get('period_start')
        return self


class HotelBillSettlementQueryResponseBodyModuleDataList(TeaModel):
    def __init__(self, alipay_trade_no=None, apply_id=None, bill_record_time=None, book_time=None, booker_id=None,
                 booker_job_no=None, booker_name=None, capital_direction=None, cascade_department=None, check_in_date=None,
                 checkout_date=None, city=None, city_code=None, corp_refund_fee=None, corp_total_fee=None, cost_center=None,
                 cost_center_number=None, department=None, department_id=None, fee_type=None, fees=None, fu_point_fee=None,
                 hotel_name=None, index=None, invoice_title=None, is_negotiation=None, is_share_str=None, nights=None,
                 order_id=None, order_price=None, order_type=None, over_apply_id=None, person_refund_fee=None,
                 person_settle_price=None, primary_id=None, project_code=None, project_name=None, promotion_fee=None, remark=None,
                 room_number=None, room_price=None, room_type=None, service_fee=None, settlement_fee=None,
                 settlement_grant_fee=None, settlement_time=None, settlement_type=None, status=None, total_nights=None, traveler_id=None,
                 traveler_job_no=None, traveler_name=None, voucher_type=None):
        self.alipay_trade_no = alipay_trade_no  # type: str
        self.apply_id = apply_id  # type: str
        self.bill_record_time = bill_record_time  # type: str
        self.book_time = book_time  # type: str
        self.booker_id = booker_id  # type: str
        self.booker_job_no = booker_job_no  # type: str
        self.booker_name = booker_name  # type: str
        self.capital_direction = capital_direction  # type: str
        self.cascade_department = cascade_department  # type: str
        self.check_in_date = check_in_date  # type: str
        self.checkout_date = checkout_date  # type: str
        self.city = city  # type: str
        self.city_code = city_code  # type: str
        self.corp_refund_fee = corp_refund_fee  # type: float
        self.corp_total_fee = corp_total_fee  # type: float
        self.cost_center = cost_center  # type: str
        self.cost_center_number = cost_center_number  # type: str
        self.department = department  # type: str
        self.department_id = department_id  # type: str
        self.fee_type = fee_type  # type: str
        self.fees = fees  # type: float
        self.fu_point_fee = fu_point_fee  # type: float
        self.hotel_name = hotel_name  # type: str
        self.index = index  # type: str
        self.invoice_title = invoice_title  # type: str
        self.is_negotiation = is_negotiation  # type: str
        self.is_share_str = is_share_str  # type: str
        self.nights = nights  # type: int
        self.order_id = order_id  # type: str
        self.order_price = order_price  # type: float
        self.order_type = order_type  # type: str
        self.over_apply_id = over_apply_id  # type: str
        self.person_refund_fee = person_refund_fee  # type: float
        self.person_settle_price = person_settle_price  # type: float
        self.primary_id = primary_id  # type: long
        self.project_code = project_code  # type: str
        self.project_name = project_name  # type: str
        self.promotion_fee = promotion_fee  # type: float
        self.remark = remark  # type: str
        self.room_number = room_number  # type: int
        self.room_price = room_price  # type: float
        self.room_type = room_type  # type: str
        self.service_fee = service_fee  # type: float
        self.settlement_fee = settlement_fee  # type: float
        self.settlement_grant_fee = settlement_grant_fee  # type: float
        self.settlement_time = settlement_time  # type: str
        self.settlement_type = settlement_type  # type: str
        self.status = status  # type: int
        self.total_nights = total_nights  # type: int
        self.traveler_id = traveler_id  # type: str
        self.traveler_job_no = traveler_job_no  # type: str
        self.traveler_name = traveler_name  # type: str
        self.voucher_type = voucher_type  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(HotelBillSettlementQueryResponseBodyModuleDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alipay_trade_no is not None:
            result['alipay_trade_no'] = self.alipay_trade_no
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.bill_record_time is not None:
            result['bill_record_time'] = self.bill_record_time
        if self.book_time is not None:
            result['book_time'] = self.book_time
        if self.booker_id is not None:
            result['booker_id'] = self.booker_id
        if self.booker_job_no is not None:
            result['booker_job_no'] = self.booker_job_no
        if self.booker_name is not None:
            result['booker_name'] = self.booker_name
        if self.capital_direction is not None:
            result['capital_direction'] = self.capital_direction
        if self.cascade_department is not None:
            result['cascade_department'] = self.cascade_department
        if self.check_in_date is not None:
            result['check_in_date'] = self.check_in_date
        if self.checkout_date is not None:
            result['checkout_date'] = self.checkout_date
        if self.city is not None:
            result['city'] = self.city
        if self.city_code is not None:
            result['city_code'] = self.city_code
        if self.corp_refund_fee is not None:
            result['corp_refund_fee'] = self.corp_refund_fee
        if self.corp_total_fee is not None:
            result['corp_total_fee'] = self.corp_total_fee
        if self.cost_center is not None:
            result['cost_center'] = self.cost_center
        if self.cost_center_number is not None:
            result['cost_center_number'] = self.cost_center_number
        if self.department is not None:
            result['department'] = self.department
        if self.department_id is not None:
            result['department_id'] = self.department_id
        if self.fee_type is not None:
            result['fee_type'] = self.fee_type
        if self.fees is not None:
            result['fees'] = self.fees
        if self.fu_point_fee is not None:
            result['fu_point_fee'] = self.fu_point_fee
        if self.hotel_name is not None:
            result['hotel_name'] = self.hotel_name
        if self.index is not None:
            result['index'] = self.index
        if self.invoice_title is not None:
            result['invoice_title'] = self.invoice_title
        if self.is_negotiation is not None:
            result['is_negotiation'] = self.is_negotiation
        if self.is_share_str is not None:
            result['is_share_str'] = self.is_share_str
        if self.nights is not None:
            result['nights'] = self.nights
        if self.order_id is not None:
            result['order_id'] = self.order_id
        if self.order_price is not None:
            result['order_price'] = self.order_price
        if self.order_type is not None:
            result['order_type'] = self.order_type
        if self.over_apply_id is not None:
            result['over_apply_id'] = self.over_apply_id
        if self.person_refund_fee is not None:
            result['person_refund_fee'] = self.person_refund_fee
        if self.person_settle_price is not None:
            result['person_settle_price'] = self.person_settle_price
        if self.primary_id is not None:
            result['primary_id'] = self.primary_id
        if self.project_code is not None:
            result['project_code'] = self.project_code
        if self.project_name is not None:
            result['project_name'] = self.project_name
        if self.promotion_fee is not None:
            result['promotion_fee'] = self.promotion_fee
        if self.remark is not None:
            result['remark'] = self.remark
        if self.room_number is not None:
            result['room_number'] = self.room_number
        if self.room_price is not None:
            result['room_price'] = self.room_price
        if self.room_type is not None:
            result['room_type'] = self.room_type
        if self.service_fee is not None:
            result['service_fee'] = self.service_fee
        if self.settlement_fee is not None:
            result['settlement_fee'] = self.settlement_fee
        if self.settlement_grant_fee is not None:
            result['settlement_grant_fee'] = self.settlement_grant_fee
        if self.settlement_time is not None:
            result['settlement_time'] = self.settlement_time
        if self.settlement_type is not None:
            result['settlement_type'] = self.settlement_type
        if self.status is not None:
            result['status'] = self.status
        if self.total_nights is not None:
            result['total_nights'] = self.total_nights
        if self.traveler_id is not None:
            result['traveler_id'] = self.traveler_id
        if self.traveler_job_no is not None:
            result['traveler_job_no'] = self.traveler_job_no
        if self.traveler_name is not None:
            result['traveler_name'] = self.traveler_name
        if self.voucher_type is not None:
            result['voucher_type'] = self.voucher_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('alipay_trade_no') is not None:
            self.alipay_trade_no = m.get('alipay_trade_no')
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('bill_record_time') is not None:
            self.bill_record_time = m.get('bill_record_time')
        if m.get('book_time') is not None:
            self.book_time = m.get('book_time')
        if m.get('booker_id') is not None:
            self.booker_id = m.get('booker_id')
        if m.get('booker_job_no') is not None:
            self.booker_job_no = m.get('booker_job_no')
        if m.get('booker_name') is not None:
            self.booker_name = m.get('booker_name')
        if m.get('capital_direction') is not None:
            self.capital_direction = m.get('capital_direction')
        if m.get('cascade_department') is not None:
            self.cascade_department = m.get('cascade_department')
        if m.get('check_in_date') is not None:
            self.check_in_date = m.get('check_in_date')
        if m.get('checkout_date') is not None:
            self.checkout_date = m.get('checkout_date')
        if m.get('city') is not None:
            self.city = m.get('city')
        if m.get('city_code') is not None:
            self.city_code = m.get('city_code')
        if m.get('corp_refund_fee') is not None:
            self.corp_refund_fee = m.get('corp_refund_fee')
        if m.get('corp_total_fee') is not None:
            self.corp_total_fee = m.get('corp_total_fee')
        if m.get('cost_center') is not None:
            self.cost_center = m.get('cost_center')
        if m.get('cost_center_number') is not None:
            self.cost_center_number = m.get('cost_center_number')
        if m.get('department') is not None:
            self.department = m.get('department')
        if m.get('department_id') is not None:
            self.department_id = m.get('department_id')
        if m.get('fee_type') is not None:
            self.fee_type = m.get('fee_type')
        if m.get('fees') is not None:
            self.fees = m.get('fees')
        if m.get('fu_point_fee') is not None:
            self.fu_point_fee = m.get('fu_point_fee')
        if m.get('hotel_name') is not None:
            self.hotel_name = m.get('hotel_name')
        if m.get('index') is not None:
            self.index = m.get('index')
        if m.get('invoice_title') is not None:
            self.invoice_title = m.get('invoice_title')
        if m.get('is_negotiation') is not None:
            self.is_negotiation = m.get('is_negotiation')
        if m.get('is_share_str') is not None:
            self.is_share_str = m.get('is_share_str')
        if m.get('nights') is not None:
            self.nights = m.get('nights')
        if m.get('order_id') is not None:
            self.order_id = m.get('order_id')
        if m.get('order_price') is not None:
            self.order_price = m.get('order_price')
        if m.get('order_type') is not None:
            self.order_type = m.get('order_type')
        if m.get('over_apply_id') is not None:
            self.over_apply_id = m.get('over_apply_id')
        if m.get('person_refund_fee') is not None:
            self.person_refund_fee = m.get('person_refund_fee')
        if m.get('person_settle_price') is not None:
            self.person_settle_price = m.get('person_settle_price')
        if m.get('primary_id') is not None:
            self.primary_id = m.get('primary_id')
        if m.get('project_code') is not None:
            self.project_code = m.get('project_code')
        if m.get('project_name') is not None:
            self.project_name = m.get('project_name')
        if m.get('promotion_fee') is not None:
            self.promotion_fee = m.get('promotion_fee')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        if m.get('room_number') is not None:
            self.room_number = m.get('room_number')
        if m.get('room_price') is not None:
            self.room_price = m.get('room_price')
        if m.get('room_type') is not None:
            self.room_type = m.get('room_type')
        if m.get('service_fee') is not None:
            self.service_fee = m.get('service_fee')
        if m.get('settlement_fee') is not None:
            self.settlement_fee = m.get('settlement_fee')
        if m.get('settlement_grant_fee') is not None:
            self.settlement_grant_fee = m.get('settlement_grant_fee')
        if m.get('settlement_time') is not None:
            self.settlement_time = m.get('settlement_time')
        if m.get('settlement_type') is not None:
            self.settlement_type = m.get('settlement_type')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('total_nights') is not None:
            self.total_nights = m.get('total_nights')
        if m.get('traveler_id') is not None:
            self.traveler_id = m.get('traveler_id')
        if m.get('traveler_job_no') is not None:
            self.traveler_job_no = m.get('traveler_job_no')
        if m.get('traveler_name') is not None:
            self.traveler_name = m.get('traveler_name')
        if m.get('voucher_type') is not None:
            self.voucher_type = m.get('voucher_type')
        return self


class HotelBillSettlementQueryResponseBodyModule(TeaModel):
    def __init__(self, category=None, corp_id=None, data_list=None, period_end=None, period_start=None,
                 total_num=None):
        self.category = category  # type: int
        self.corp_id = corp_id  # type: str
        self.data_list = data_list  # type: list[HotelBillSettlementQueryResponseBodyModuleDataList]
        self.period_end = period_end  # type: str
        self.period_start = period_start  # type: str
        self.total_num = total_num  # type: long

    def validate(self):
        if self.data_list:
            for k in self.data_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(HotelBillSettlementQueryResponseBodyModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['category'] = self.category
        if self.corp_id is not None:
            result['corp_id'] = self.corp_id
        result['data_list'] = []
        if self.data_list is not None:
            for k in self.data_list:
                result['data_list'].append(k.to_map() if k else None)
        if self.period_end is not None:
            result['period_end'] = self.period_end
        if self.period_start is not None:
            result['period_start'] = self.period_start
        if self.total_num is not None:
            result['total_num'] = self.total_num
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('category') is not None:
            self.category = m.get('category')
        if m.get('corp_id') is not None:
            self.corp_id = m.get('corp_id')
        self.data_list = []
        if m.get('data_list') is not None:
            for k in m.get('data_list'):
                temp_model = HotelBillSettlementQueryResponseBodyModuleDataList()
                self.data_list.append(temp_model.from_map(k))
        if m.get('period_end') is not None:
            self.period_end = m.get('period_end')
        if m.get('period_start') is not None:
            self.period_start = m.get('period_start')
        if m.get('total_num') is not None:
            self.total_num = m.get('total_num')
        return self


class HotelBillSettlementQueryResponseBody(TeaModel):
    def __init__(self, code=None, message=None, module=None, request_id=None, success=None, trace_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.module = module  # type: HotelBillSettlementQueryResponseBodyModule
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.trace_id = trace_id  # type: str

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super(HotelBillSettlementQueryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = HotelBillSettlementQueryResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class HotelBillSettlementQueryResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: HotelBillSettlementQueryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(HotelBillSettlementQueryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = HotelBillSettlementQueryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class HotelExceedApplyQueryHeaders(TeaModel):
    def __init__(self, common_headers=None, x_acs_btrip_so_corp_token=None):
        self.common_headers = common_headers  # type: dict[str, str]
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(HotelExceedApplyQueryHeaders, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class HotelExceedApplyQueryRequest(TeaModel):
    def __init__(self, apply_id=None):
        self.apply_id = apply_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(HotelExceedApplyQueryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        return self


class HotelExceedApplyQueryResponseBodyModuleApplyIntentionInfoDo(TeaModel):
    def __init__(self, check_in=None, check_out=None, city_code=None, city_name=None, price=None, together=None,
                 type=None):
        self.check_in = check_in  # type: str
        self.check_out = check_out  # type: str
        self.city_code = city_code  # type: str
        self.city_name = city_name  # type: str
        self.price = price  # type: long
        self.together = together  # type: bool
        self.type = type  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(HotelExceedApplyQueryResponseBodyModuleApplyIntentionInfoDo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_in is not None:
            result['check_in'] = self.check_in
        if self.check_out is not None:
            result['check_out'] = self.check_out
        if self.city_code is not None:
            result['city_code'] = self.city_code
        if self.city_name is not None:
            result['city_name'] = self.city_name
        if self.price is not None:
            result['price'] = self.price
        if self.together is not None:
            result['together'] = self.together
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('check_in') is not None:
            self.check_in = m.get('check_in')
        if m.get('check_out') is not None:
            self.check_out = m.get('check_out')
        if m.get('city_code') is not None:
            self.city_code = m.get('city_code')
        if m.get('city_name') is not None:
            self.city_name = m.get('city_name')
        if m.get('price') is not None:
            self.price = m.get('price')
        if m.get('together') is not None:
            self.together = m.get('together')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class HotelExceedApplyQueryResponseBodyModule(TeaModel):
    def __init__(self, apply_id=None, apply_intention_info_do=None, btrip_cause=None, corp_id=None,
                 exceed_reason=None, exceed_type=None, origin_standard=None, status=None, submit_time=None,
                 thirdpart_apply_id=None, thirdpart_corp_id=None, user_id=None):
        self.apply_id = apply_id  # type: long
        self.apply_intention_info_do = apply_intention_info_do  # type: HotelExceedApplyQueryResponseBodyModuleApplyIntentionInfoDo
        self.btrip_cause = btrip_cause  # type: str
        self.corp_id = corp_id  # type: str
        self.exceed_reason = exceed_reason  # type: str
        self.exceed_type = exceed_type  # type: int
        self.origin_standard = origin_standard  # type: str
        self.status = status  # type: int
        self.submit_time = submit_time  # type: str
        self.thirdpart_apply_id = thirdpart_apply_id  # type: str
        self.thirdpart_corp_id = thirdpart_corp_id  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        if self.apply_intention_info_do:
            self.apply_intention_info_do.validate()

    def to_map(self):
        _map = super(HotelExceedApplyQueryResponseBodyModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.apply_intention_info_do is not None:
            result['apply_intention_info_do'] = self.apply_intention_info_do.to_map()
        if self.btrip_cause is not None:
            result['btrip_cause'] = self.btrip_cause
        if self.corp_id is not None:
            result['corp_id'] = self.corp_id
        if self.exceed_reason is not None:
            result['exceed_reason'] = self.exceed_reason
        if self.exceed_type is not None:
            result['exceed_type'] = self.exceed_type
        if self.origin_standard is not None:
            result['origin_standard'] = self.origin_standard
        if self.status is not None:
            result['status'] = self.status
        if self.submit_time is not None:
            result['submit_time'] = self.submit_time
        if self.thirdpart_apply_id is not None:
            result['thirdpart_apply_id'] = self.thirdpart_apply_id
        if self.thirdpart_corp_id is not None:
            result['thirdpart_corp_id'] = self.thirdpart_corp_id
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('apply_intention_info_do') is not None:
            temp_model = HotelExceedApplyQueryResponseBodyModuleApplyIntentionInfoDo()
            self.apply_intention_info_do = temp_model.from_map(m['apply_intention_info_do'])
        if m.get('btrip_cause') is not None:
            self.btrip_cause = m.get('btrip_cause')
        if m.get('corp_id') is not None:
            self.corp_id = m.get('corp_id')
        if m.get('exceed_reason') is not None:
            self.exceed_reason = m.get('exceed_reason')
        if m.get('exceed_type') is not None:
            self.exceed_type = m.get('exceed_type')
        if m.get('origin_standard') is not None:
            self.origin_standard = m.get('origin_standard')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('submit_time') is not None:
            self.submit_time = m.get('submit_time')
        if m.get('thirdpart_apply_id') is not None:
            self.thirdpart_apply_id = m.get('thirdpart_apply_id')
        if m.get('thirdpart_corp_id') is not None:
            self.thirdpart_corp_id = m.get('thirdpart_corp_id')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class HotelExceedApplyQueryResponseBody(TeaModel):
    def __init__(self, code=None, message=None, module=None, request_id=None, success=None, trace_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.module = module  # type: HotelExceedApplyQueryResponseBodyModule
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.trace_id = trace_id  # type: str

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super(HotelExceedApplyQueryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = HotelExceedApplyQueryResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class HotelExceedApplyQueryResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: HotelExceedApplyQueryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(HotelExceedApplyQueryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = HotelExceedApplyQueryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class HotelOrderListQueryHeaders(TeaModel):
    def __init__(self, common_headers=None, x_acs_btrip_so_corp_token=None):
        self.common_headers = common_headers  # type: dict[str, str]
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(HotelOrderListQueryHeaders, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class HotelOrderListQueryRequest(TeaModel):
    def __init__(self, all_apply=None, apply_id=None, depart_id=None, end_time=None, page=None, page_size=None,
                 start_time=None, thirdpart_apply_id=None, update_end_time=None, update_start_time=None, user_id=None):
        self.all_apply = all_apply  # type: bool
        self.apply_id = apply_id  # type: long
        self.depart_id = depart_id  # type: str
        self.end_time = end_time  # type: str
        self.page = page  # type: int
        self.page_size = page_size  # type: int
        self.start_time = start_time  # type: str
        self.thirdpart_apply_id = thirdpart_apply_id  # type: str
        self.update_end_time = update_end_time  # type: str
        self.update_start_time = update_start_time  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(HotelOrderListQueryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.all_apply is not None:
            result['all_apply'] = self.all_apply
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.depart_id is not None:
            result['depart_id'] = self.depart_id
        if self.end_time is not None:
            result['end_time'] = self.end_time
        if self.page is not None:
            result['page'] = self.page
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.start_time is not None:
            result['start_time'] = self.start_time
        if self.thirdpart_apply_id is not None:
            result['thirdpart_apply_id'] = self.thirdpart_apply_id
        if self.update_end_time is not None:
            result['update_end_time'] = self.update_end_time
        if self.update_start_time is not None:
            result['update_start_time'] = self.update_start_time
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('all_apply') is not None:
            self.all_apply = m.get('all_apply')
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('depart_id') is not None:
            self.depart_id = m.get('depart_id')
        if m.get('end_time') is not None:
            self.end_time = m.get('end_time')
        if m.get('page') is not None:
            self.page = m.get('page')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('start_time') is not None:
            self.start_time = m.get('start_time')
        if m.get('thirdpart_apply_id') is not None:
            self.thirdpart_apply_id = m.get('thirdpart_apply_id')
        if m.get('update_end_time') is not None:
            self.update_end_time = m.get('update_end_time')
        if m.get('update_start_time') is not None:
            self.update_start_time = m.get('update_start_time')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class HotelOrderListQueryResponseBodyModuleCostCenter(TeaModel):
    def __init__(self, corp_id=None, id=None, name=None, number=None):
        self.corp_id = corp_id  # type: str
        self.id = id  # type: long
        self.name = name  # type: str
        self.number = number  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(HotelOrderListQueryResponseBodyModuleCostCenter, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['corp_id'] = self.corp_id
        if self.id is not None:
            result['id'] = self.id
        if self.name is not None:
            result['name'] = self.name
        if self.number is not None:
            result['number'] = self.number
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('corp_id') is not None:
            self.corp_id = m.get('corp_id')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('number') is not None:
            self.number = m.get('number')
        return self


class HotelOrderListQueryResponseBodyModuleInvoice(TeaModel):
    def __init__(self, id=None, invoice_type=None, title=None):
        self.id = id  # type: long
        self.invoice_type = invoice_type  # type: int
        self.title = title  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(HotelOrderListQueryResponseBodyModuleInvoice, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.invoice_type is not None:
            result['invoice_type'] = self.invoice_type
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('invoice_type') is not None:
            self.invoice_type = m.get('invoice_type')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class HotelOrderListQueryResponseBodyModulePriceInfoList(TeaModel):
    def __init__(self, category_code=None, category_type=None, gmt_create=None, passenger_name=None, pay_type=None,
                 price=None, trade_id=None, type=None):
        self.category_code = category_code  # type: int
        self.category_type = category_type  # type: int
        self.gmt_create = gmt_create  # type: str
        self.passenger_name = passenger_name  # type: str
        self.pay_type = pay_type  # type: int
        self.price = price  # type: float
        self.trade_id = trade_id  # type: str
        self.type = type  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(HotelOrderListQueryResponseBodyModulePriceInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category_code is not None:
            result['category_code'] = self.category_code
        if self.category_type is not None:
            result['category_type'] = self.category_type
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.passenger_name is not None:
            result['passenger_name'] = self.passenger_name
        if self.pay_type is not None:
            result['pay_type'] = self.pay_type
        if self.price is not None:
            result['price'] = self.price
        if self.trade_id is not None:
            result['trade_id'] = self.trade_id
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('category_code') is not None:
            self.category_code = m.get('category_code')
        if m.get('category_type') is not None:
            self.category_type = m.get('category_type')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('passenger_name') is not None:
            self.passenger_name = m.get('passenger_name')
        if m.get('pay_type') is not None:
            self.pay_type = m.get('pay_type')
        if m.get('price') is not None:
            self.price = m.get('price')
        if m.get('trade_id') is not None:
            self.trade_id = m.get('trade_id')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class HotelOrderListQueryResponseBodyModuleUserAffiliateList(TeaModel):
    def __init__(self, user_id=None, user_name=None):
        self.user_id = user_id  # type: str
        self.user_name = user_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(HotelOrderListQueryResponseBodyModuleUserAffiliateList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        return self


class HotelOrderListQueryResponseBodyModule(TeaModel):
    def __init__(self, apply_id=None, btrip_title=None, check_in=None, check_out=None, city=None, contact_name=None,
                 corp_id=None, corp_name=None, cost_center=None, depart_id=None, depart_name=None, gmt_create=None,
                 gmt_modified=None, guest=None, hotel_name=None, hotel_support_vat_invoice_type=None, id=None, invoice=None,
                 night=None, order_status=None, order_status_desc=None, order_type=None, order_type_desc=None,
                 price_info_list=None, project_code=None, project_id=None, project_title=None, room_num=None, room_type=None,
                 thirdpart_apply_id=None, thirdpart_itinerary_id=None, thirdpart_project_id=None, user_affiliate_list=None,
                 user_id=None, user_name=None):
        self.apply_id = apply_id  # type: long
        self.btrip_title = btrip_title  # type: str
        self.check_in = check_in  # type: str
        self.check_out = check_out  # type: str
        self.city = city  # type: str
        self.contact_name = contact_name  # type: str
        self.corp_id = corp_id  # type: str
        self.corp_name = corp_name  # type: str
        self.cost_center = cost_center  # type: HotelOrderListQueryResponseBodyModuleCostCenter
        self.depart_id = depart_id  # type: str
        self.depart_name = depart_name  # type: str
        self.gmt_create = gmt_create  # type: str
        self.gmt_modified = gmt_modified  # type: str
        self.guest = guest  # type: str
        self.hotel_name = hotel_name  # type: str
        self.hotel_support_vat_invoice_type = hotel_support_vat_invoice_type  # type: int
        self.id = id  # type: long
        self.invoice = invoice  # type: HotelOrderListQueryResponseBodyModuleInvoice
        self.night = night  # type: int
        self.order_status = order_status  # type: int
        self.order_status_desc = order_status_desc  # type: str
        self.order_type = order_type  # type: int
        self.order_type_desc = order_type_desc  # type: str
        self.price_info_list = price_info_list  # type: list[HotelOrderListQueryResponseBodyModulePriceInfoList]
        self.project_code = project_code  # type: str
        self.project_id = project_id  # type: long
        self.project_title = project_title  # type: str
        self.room_num = room_num  # type: int
        self.room_type = room_type  # type: str
        self.thirdpart_apply_id = thirdpart_apply_id  # type: str
        self.thirdpart_itinerary_id = thirdpart_itinerary_id  # type: str
        self.thirdpart_project_id = thirdpart_project_id  # type: str
        self.user_affiliate_list = user_affiliate_list  # type: list[HotelOrderListQueryResponseBodyModuleUserAffiliateList]
        self.user_id = user_id  # type: str
        self.user_name = user_name  # type: str

    def validate(self):
        if self.cost_center:
            self.cost_center.validate()
        if self.invoice:
            self.invoice.validate()
        if self.price_info_list:
            for k in self.price_info_list:
                if k:
                    k.validate()
        if self.user_affiliate_list:
            for k in self.user_affiliate_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(HotelOrderListQueryResponseBodyModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.btrip_title is not None:
            result['btrip_title'] = self.btrip_title
        if self.check_in is not None:
            result['check_in'] = self.check_in
        if self.check_out is not None:
            result['check_out'] = self.check_out
        if self.city is not None:
            result['city'] = self.city
        if self.contact_name is not None:
            result['contact_name'] = self.contact_name
        if self.corp_id is not None:
            result['corp_id'] = self.corp_id
        if self.corp_name is not None:
            result['corp_name'] = self.corp_name
        if self.cost_center is not None:
            result['cost_center'] = self.cost_center.to_map()
        if self.depart_id is not None:
            result['depart_id'] = self.depart_id
        if self.depart_name is not None:
            result['depart_name'] = self.depart_name
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        if self.guest is not None:
            result['guest'] = self.guest
        if self.hotel_name is not None:
            result['hotel_name'] = self.hotel_name
        if self.hotel_support_vat_invoice_type is not None:
            result['hotel_support_vat_invoice_type'] = self.hotel_support_vat_invoice_type
        if self.id is not None:
            result['id'] = self.id
        if self.invoice is not None:
            result['invoice'] = self.invoice.to_map()
        if self.night is not None:
            result['night'] = self.night
        if self.order_status is not None:
            result['order_status'] = self.order_status
        if self.order_status_desc is not None:
            result['order_status_desc'] = self.order_status_desc
        if self.order_type is not None:
            result['order_type'] = self.order_type
        if self.order_type_desc is not None:
            result['order_type_desc'] = self.order_type_desc
        result['price_info_list'] = []
        if self.price_info_list is not None:
            for k in self.price_info_list:
                result['price_info_list'].append(k.to_map() if k else None)
        if self.project_code is not None:
            result['project_code'] = self.project_code
        if self.project_id is not None:
            result['project_id'] = self.project_id
        if self.project_title is not None:
            result['project_title'] = self.project_title
        if self.room_num is not None:
            result['room_num'] = self.room_num
        if self.room_type is not None:
            result['room_type'] = self.room_type
        if self.thirdpart_apply_id is not None:
            result['thirdpart_apply_id'] = self.thirdpart_apply_id
        if self.thirdpart_itinerary_id is not None:
            result['thirdpart_itinerary_id'] = self.thirdpart_itinerary_id
        if self.thirdpart_project_id is not None:
            result['thirdpart_project_id'] = self.thirdpart_project_id
        result['user_affiliate_list'] = []
        if self.user_affiliate_list is not None:
            for k in self.user_affiliate_list:
                result['user_affiliate_list'].append(k.to_map() if k else None)
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('btrip_title') is not None:
            self.btrip_title = m.get('btrip_title')
        if m.get('check_in') is not None:
            self.check_in = m.get('check_in')
        if m.get('check_out') is not None:
            self.check_out = m.get('check_out')
        if m.get('city') is not None:
            self.city = m.get('city')
        if m.get('contact_name') is not None:
            self.contact_name = m.get('contact_name')
        if m.get('corp_id') is not None:
            self.corp_id = m.get('corp_id')
        if m.get('corp_name') is not None:
            self.corp_name = m.get('corp_name')
        if m.get('cost_center') is not None:
            temp_model = HotelOrderListQueryResponseBodyModuleCostCenter()
            self.cost_center = temp_model.from_map(m['cost_center'])
        if m.get('depart_id') is not None:
            self.depart_id = m.get('depart_id')
        if m.get('depart_name') is not None:
            self.depart_name = m.get('depart_name')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        if m.get('guest') is not None:
            self.guest = m.get('guest')
        if m.get('hotel_name') is not None:
            self.hotel_name = m.get('hotel_name')
        if m.get('hotel_support_vat_invoice_type') is not None:
            self.hotel_support_vat_invoice_type = m.get('hotel_support_vat_invoice_type')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('invoice') is not None:
            temp_model = HotelOrderListQueryResponseBodyModuleInvoice()
            self.invoice = temp_model.from_map(m['invoice'])
        if m.get('night') is not None:
            self.night = m.get('night')
        if m.get('order_status') is not None:
            self.order_status = m.get('order_status')
        if m.get('order_status_desc') is not None:
            self.order_status_desc = m.get('order_status_desc')
        if m.get('order_type') is not None:
            self.order_type = m.get('order_type')
        if m.get('order_type_desc') is not None:
            self.order_type_desc = m.get('order_type_desc')
        self.price_info_list = []
        if m.get('price_info_list') is not None:
            for k in m.get('price_info_list'):
                temp_model = HotelOrderListQueryResponseBodyModulePriceInfoList()
                self.price_info_list.append(temp_model.from_map(k))
        if m.get('project_code') is not None:
            self.project_code = m.get('project_code')
        if m.get('project_id') is not None:
            self.project_id = m.get('project_id')
        if m.get('project_title') is not None:
            self.project_title = m.get('project_title')
        if m.get('room_num') is not None:
            self.room_num = m.get('room_num')
        if m.get('room_type') is not None:
            self.room_type = m.get('room_type')
        if m.get('thirdpart_apply_id') is not None:
            self.thirdpart_apply_id = m.get('thirdpart_apply_id')
        if m.get('thirdpart_itinerary_id') is not None:
            self.thirdpart_itinerary_id = m.get('thirdpart_itinerary_id')
        if m.get('thirdpart_project_id') is not None:
            self.thirdpart_project_id = m.get('thirdpart_project_id')
        self.user_affiliate_list = []
        if m.get('user_affiliate_list') is not None:
            for k in m.get('user_affiliate_list'):
                temp_model = HotelOrderListQueryResponseBodyModuleUserAffiliateList()
                self.user_affiliate_list.append(temp_model.from_map(k))
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        return self


class HotelOrderListQueryResponseBodyPageInfo(TeaModel):
    def __init__(self, page=None, page_size=None, total_number=None):
        self.page = page  # type: int
        self.page_size = page_size  # type: int
        self.total_number = total_number  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(HotelOrderListQueryResponseBodyPageInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page is not None:
            result['page'] = self.page
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.total_number is not None:
            result['total_number'] = self.total_number
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('page') is not None:
            self.page = m.get('page')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('total_number') is not None:
            self.total_number = m.get('total_number')
        return self


class HotelOrderListQueryResponseBody(TeaModel):
    def __init__(self, code=None, message=None, module=None, page_info=None, request_id=None, success=None,
                 trace_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.module = module  # type: list[HotelOrderListQueryResponseBodyModule]
        self.page_info = page_info  # type: HotelOrderListQueryResponseBodyPageInfo
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.trace_id = trace_id  # type: str

    def validate(self):
        if self.module:
            for k in self.module:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super(HotelOrderListQueryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        result['module'] = []
        if self.module is not None:
            for k in self.module:
                result['module'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['page_info'] = self.page_info.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        self.module = []
        if m.get('module') is not None:
            for k in m.get('module'):
                temp_model = HotelOrderListQueryResponseBodyModule()
                self.module.append(temp_model.from_map(k))
        if m.get('page_info') is not None:
            temp_model = HotelOrderListQueryResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['page_info'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class HotelOrderListQueryResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: HotelOrderListQueryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(HotelOrderListQueryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = HotelOrderListQueryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class HotelOrderQueryHeaders(TeaModel):
    def __init__(self, common_headers=None, x_acs_btrip_so_corp_token=None):
        self.common_headers = common_headers  # type: dict[str, str]
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(HotelOrderQueryHeaders, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class HotelOrderQueryRequest(TeaModel):
    def __init__(self, order_id=None):
        self.order_id = order_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(HotelOrderQueryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.order_id is not None:
            result['order_id'] = self.order_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('order_id') is not None:
            self.order_id = m.get('order_id')
        return self


class HotelOrderQueryResponseBodyModuleHotelInfo(TeaModel):
    def __init__(self, check_in=None, check_out=None, city=None, hotel_name=None,
                 hotel_support_vat_invoice_type=None, night=None, room_num=None, room_type=None):
        self.check_in = check_in  # type: long
        self.check_out = check_out  # type: long
        self.city = city  # type: str
        self.hotel_name = hotel_name  # type: str
        self.hotel_support_vat_invoice_type = hotel_support_vat_invoice_type  # type: int
        self.night = night  # type: int
        self.room_num = room_num  # type: int
        self.room_type = room_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(HotelOrderQueryResponseBodyModuleHotelInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_in is not None:
            result['check_in'] = self.check_in
        if self.check_out is not None:
            result['check_out'] = self.check_out
        if self.city is not None:
            result['city'] = self.city
        if self.hotel_name is not None:
            result['hotel_name'] = self.hotel_name
        if self.hotel_support_vat_invoice_type is not None:
            result['hotel_support_vat_invoice_type'] = self.hotel_support_vat_invoice_type
        if self.night is not None:
            result['night'] = self.night
        if self.room_num is not None:
            result['room_num'] = self.room_num
        if self.room_type is not None:
            result['room_type'] = self.room_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('check_in') is not None:
            self.check_in = m.get('check_in')
        if m.get('check_out') is not None:
            self.check_out = m.get('check_out')
        if m.get('city') is not None:
            self.city = m.get('city')
        if m.get('hotel_name') is not None:
            self.hotel_name = m.get('hotel_name')
        if m.get('hotel_support_vat_invoice_type') is not None:
            self.hotel_support_vat_invoice_type = m.get('hotel_support_vat_invoice_type')
        if m.get('night') is not None:
            self.night = m.get('night')
        if m.get('room_num') is not None:
            self.room_num = m.get('room_num')
        if m.get('room_type') is not None:
            self.room_type = m.get('room_type')
        return self


class HotelOrderQueryResponseBodyModuleInvoiceInfo(TeaModel):
    def __init__(self, id=None, title=None):
        self.id = id  # type: long
        self.title = title  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(HotelOrderQueryResponseBodyModuleInvoiceInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class HotelOrderQueryResponseBodyModuleOrderBaseInfo(TeaModel):
    def __init__(self, apply_id=None, btrip_title=None, corp_id=None, corp_name=None, depart_id=None,
                 depart_name=None, gmt_create=None, gmt_modified=None, id=None, itinerary_id=None, order_status=None,
                 order_type=None, thirdpart_apply_id=None, thirdpart_depart_id=None, thirdpart_itinerary_id=None,
                 user_id=None, user_name=None):
        self.apply_id = apply_id  # type: str
        self.btrip_title = btrip_title  # type: str
        self.corp_id = corp_id  # type: str
        self.corp_name = corp_name  # type: str
        self.depart_id = depart_id  # type: str
        self.depart_name = depart_name  # type: str
        self.gmt_create = gmt_create  # type: long
        self.gmt_modified = gmt_modified  # type: long
        self.id = id  # type: long
        self.itinerary_id = itinerary_id  # type: str
        self.order_status = order_status  # type: int
        self.order_type = order_type  # type: int
        self.thirdpart_apply_id = thirdpart_apply_id  # type: str
        self.thirdpart_depart_id = thirdpart_depart_id  # type: str
        self.thirdpart_itinerary_id = thirdpart_itinerary_id  # type: str
        self.user_id = user_id  # type: str
        self.user_name = user_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(HotelOrderQueryResponseBodyModuleOrderBaseInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.btrip_title is not None:
            result['btrip_title'] = self.btrip_title
        if self.corp_id is not None:
            result['corp_id'] = self.corp_id
        if self.corp_name is not None:
            result['corp_name'] = self.corp_name
        if self.depart_id is not None:
            result['depart_id'] = self.depart_id
        if self.depart_name is not None:
            result['depart_name'] = self.depart_name
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        if self.id is not None:
            result['id'] = self.id
        if self.itinerary_id is not None:
            result['itinerary_id'] = self.itinerary_id
        if self.order_status is not None:
            result['order_status'] = self.order_status
        if self.order_type is not None:
            result['order_type'] = self.order_type
        if self.thirdpart_apply_id is not None:
            result['thirdpart_apply_id'] = self.thirdpart_apply_id
        if self.thirdpart_depart_id is not None:
            result['thirdpart_depart_id'] = self.thirdpart_depart_id
        if self.thirdpart_itinerary_id is not None:
            result['thirdpart_itinerary_id'] = self.thirdpart_itinerary_id
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('btrip_title') is not None:
            self.btrip_title = m.get('btrip_title')
        if m.get('corp_id') is not None:
            self.corp_id = m.get('corp_id')
        if m.get('corp_name') is not None:
            self.corp_name = m.get('corp_name')
        if m.get('depart_id') is not None:
            self.depart_id = m.get('depart_id')
        if m.get('depart_name') is not None:
            self.depart_name = m.get('depart_name')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('itinerary_id') is not None:
            self.itinerary_id = m.get('itinerary_id')
        if m.get('order_status') is not None:
            self.order_status = m.get('order_status')
        if m.get('order_type') is not None:
            self.order_type = m.get('order_type')
        if m.get('thirdpart_apply_id') is not None:
            self.thirdpart_apply_id = m.get('thirdpart_apply_id')
        if m.get('thirdpart_depart_id') is not None:
            self.thirdpart_depart_id = m.get('thirdpart_depart_id')
        if m.get('thirdpart_itinerary_id') is not None:
            self.thirdpart_itinerary_id = m.get('thirdpart_itinerary_id')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        return self


class HotelOrderQueryResponseBodyModulePassengerList(TeaModel):
    def __init__(self, cost_center_id=None, cost_center_name=None, cost_center_number=None, project_code=None,
                 project_id=None, project_title=None, thirdpart_cost_center_id=None, thirdpart_project_id=None, user_id=None,
                 user_name=None, user_type=None):
        self.cost_center_id = cost_center_id  # type: long
        self.cost_center_name = cost_center_name  # type: str
        self.cost_center_number = cost_center_number  # type: str
        self.project_code = project_code  # type: str
        self.project_id = project_id  # type: long
        self.project_title = project_title  # type: str
        self.thirdpart_cost_center_id = thirdpart_cost_center_id  # type: str
        self.thirdpart_project_id = thirdpart_project_id  # type: str
        self.user_id = user_id  # type: str
        self.user_name = user_name  # type: str
        self.user_type = user_type  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(HotelOrderQueryResponseBodyModulePassengerList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cost_center_id is not None:
            result['cost_center_id'] = self.cost_center_id
        if self.cost_center_name is not None:
            result['cost_center_name'] = self.cost_center_name
        if self.cost_center_number is not None:
            result['cost_center_number'] = self.cost_center_number
        if self.project_code is not None:
            result['project_code'] = self.project_code
        if self.project_id is not None:
            result['project_id'] = self.project_id
        if self.project_title is not None:
            result['project_title'] = self.project_title
        if self.thirdpart_cost_center_id is not None:
            result['thirdpart_cost_center_id'] = self.thirdpart_cost_center_id
        if self.thirdpart_project_id is not None:
            result['thirdpart_project_id'] = self.thirdpart_project_id
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        if self.user_type is not None:
            result['user_type'] = self.user_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('cost_center_id') is not None:
            self.cost_center_id = m.get('cost_center_id')
        if m.get('cost_center_name') is not None:
            self.cost_center_name = m.get('cost_center_name')
        if m.get('cost_center_number') is not None:
            self.cost_center_number = m.get('cost_center_number')
        if m.get('project_code') is not None:
            self.project_code = m.get('project_code')
        if m.get('project_id') is not None:
            self.project_id = m.get('project_id')
        if m.get('project_title') is not None:
            self.project_title = m.get('project_title')
        if m.get('thirdpart_cost_center_id') is not None:
            self.thirdpart_cost_center_id = m.get('thirdpart_cost_center_id')
        if m.get('thirdpart_project_id') is not None:
            self.thirdpart_project_id = m.get('thirdpart_project_id')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        if m.get('user_type') is not None:
            self.user_type = m.get('user_type')
        return self


class HotelOrderQueryResponseBodyModulePriceInfoList(TeaModel):
    def __init__(self, category_code=None, gmt_create=None, pay_type=None, price=None, trade_id=None, type=None):
        self.category_code = category_code  # type: int
        self.gmt_create = gmt_create  # type: long
        self.pay_type = pay_type  # type: int
        self.price = price  # type: float
        self.trade_id = trade_id  # type: str
        self.type = type  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(HotelOrderQueryResponseBodyModulePriceInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category_code is not None:
            result['category_code'] = self.category_code
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.pay_type is not None:
            result['pay_type'] = self.pay_type
        if self.price is not None:
            result['price'] = self.price
        if self.trade_id is not None:
            result['trade_id'] = self.trade_id
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('category_code') is not None:
            self.category_code = m.get('category_code')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('pay_type') is not None:
            self.pay_type = m.get('pay_type')
        if m.get('price') is not None:
            self.price = m.get('price')
        if m.get('trade_id') is not None:
            self.trade_id = m.get('trade_id')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class HotelOrderQueryResponseBodyModule(TeaModel):
    def __init__(self, hotel_info=None, invoice_info=None, order_base_info=None, passenger_list=None,
                 price_info_list=None):
        self.hotel_info = hotel_info  # type: HotelOrderQueryResponseBodyModuleHotelInfo
        self.invoice_info = invoice_info  # type: HotelOrderQueryResponseBodyModuleInvoiceInfo
        self.order_base_info = order_base_info  # type: HotelOrderQueryResponseBodyModuleOrderBaseInfo
        self.passenger_list = passenger_list  # type: list[HotelOrderQueryResponseBodyModulePassengerList]
        self.price_info_list = price_info_list  # type: list[HotelOrderQueryResponseBodyModulePriceInfoList]

    def validate(self):
        if self.hotel_info:
            self.hotel_info.validate()
        if self.invoice_info:
            self.invoice_info.validate()
        if self.order_base_info:
            self.order_base_info.validate()
        if self.passenger_list:
            for k in self.passenger_list:
                if k:
                    k.validate()
        if self.price_info_list:
            for k in self.price_info_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(HotelOrderQueryResponseBodyModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.hotel_info is not None:
            result['hotel_info'] = self.hotel_info.to_map()
        if self.invoice_info is not None:
            result['invoice_info'] = self.invoice_info.to_map()
        if self.order_base_info is not None:
            result['order_base_info'] = self.order_base_info.to_map()
        result['passenger_list'] = []
        if self.passenger_list is not None:
            for k in self.passenger_list:
                result['passenger_list'].append(k.to_map() if k else None)
        result['price_info_list'] = []
        if self.price_info_list is not None:
            for k in self.price_info_list:
                result['price_info_list'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('hotel_info') is not None:
            temp_model = HotelOrderQueryResponseBodyModuleHotelInfo()
            self.hotel_info = temp_model.from_map(m['hotel_info'])
        if m.get('invoice_info') is not None:
            temp_model = HotelOrderQueryResponseBodyModuleInvoiceInfo()
            self.invoice_info = temp_model.from_map(m['invoice_info'])
        if m.get('order_base_info') is not None:
            temp_model = HotelOrderQueryResponseBodyModuleOrderBaseInfo()
            self.order_base_info = temp_model.from_map(m['order_base_info'])
        self.passenger_list = []
        if m.get('passenger_list') is not None:
            for k in m.get('passenger_list'):
                temp_model = HotelOrderQueryResponseBodyModulePassengerList()
                self.passenger_list.append(temp_model.from_map(k))
        self.price_info_list = []
        if m.get('price_info_list') is not None:
            for k in m.get('price_info_list'):
                temp_model = HotelOrderQueryResponseBodyModulePriceInfoList()
                self.price_info_list.append(temp_model.from_map(k))
        return self


class HotelOrderQueryResponseBody(TeaModel):
    def __init__(self, code=None, message=None, module=None, request_id=None, success=None, trace_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        # module。
        self.module = module  # type: HotelOrderQueryResponseBodyModule
        # requestId
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        # traceId
        self.trace_id = trace_id  # type: str

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super(HotelOrderQueryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = HotelOrderQueryResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class HotelOrderQueryResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: HotelOrderQueryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(HotelOrderQueryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = HotelOrderQueryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class IeFlightBillSettlementQueryHeaders(TeaModel):
    def __init__(self, common_headers=None, x_acs_btrip_so_corp_token=None):
        self.common_headers = common_headers  # type: dict[str, str]
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(IeFlightBillSettlementQueryHeaders, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class IeFlightBillSettlementQueryRequest(TeaModel):
    def __init__(self, page_no=None, page_size=None, period_end=None, period_start=None):
        self.page_no = page_no  # type: int
        self.page_size = page_size  # type: int
        self.period_end = period_end  # type: str
        self.period_start = period_start  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(IeFlightBillSettlementQueryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_no is not None:
            result['page_no'] = self.page_no
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.period_end is not None:
            result['period_end'] = self.period_end
        if self.period_start is not None:
            result['period_start'] = self.period_start
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('page_no') is not None:
            self.page_no = m.get('page_no')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('period_end') is not None:
            self.period_end = m.get('period_end')
        if m.get('period_start') is not None:
            self.period_start = m.get('period_start')
        return self


class IeFlightBillSettlementQueryResponseBodyModuleDataList(TeaModel):
    def __init__(self, advance_day=None, airline_corp_code=None, airline_corp_name=None, alipay_trade_no=None,
                 apply_id=None, arr_airport_code=None, arr_city=None, arr_date=None, arr_station=None, arr_time=None,
                 bill_record_time=None, book_mode=None, book_time=None, booker_id=None, booker_job_no=None, booker_name=None,
                 btrip_coupon_fee=None, cabin=None, cabin_class=None, capital_direction=None, cascade_department=None,
                 change_fee=None, corp_pay_order_fee=None, cost_center=None, cost_center_number=None, coupon=None,
                 dep_airport_code=None, department=None, department_id=None, dept_city=None, dept_date=None, dept_station=None,
                 dept_time=None, discount=None, fee_type=None, flight_no=None, index=None, insurance_fee=None,
                 insurance_number=None, invoice_title=None, most_difference_dept_time=None, most_difference_discount=None,
                 most_difference_flight_no=None, most_difference_price=None, most_difference_reason=None, most_price=None,
                 negotiation_coupon_fee=None, order_id=None, order_status_desc=None, over_apply_id=None, primary_id=None,
                 project_code=None, project_name=None, refund_fee=None, remark=None, repeat_refund=None, seal_price=None,
                 segment_type=None, service_fee=None, settlement_fee=None, settlement_grant_fee=None, settlement_time=None,
                 settlement_type=None, status=None, sub_order_id=None, tax_fee=None, ticket_id=None, trade=None, traveler_id=None,
                 traveler_job_no=None, traveler_name=None, voucher_type=None):
        self.advance_day = advance_day  # type: int
        self.airline_corp_code = airline_corp_code  # type: str
        self.airline_corp_name = airline_corp_name  # type: str
        self.alipay_trade_no = alipay_trade_no  # type: str
        self.apply_id = apply_id  # type: str
        self.arr_airport_code = arr_airport_code  # type: str
        self.arr_city = arr_city  # type: str
        self.arr_date = arr_date  # type: str
        self.arr_station = arr_station  # type: str
        self.arr_time = arr_time  # type: str
        self.bill_record_time = bill_record_time  # type: str
        self.book_mode = book_mode  # type: str
        self.book_time = book_time  # type: str
        self.booker_id = booker_id  # type: str
        self.booker_job_no = booker_job_no  # type: str
        self.booker_name = booker_name  # type: str
        self.btrip_coupon_fee = btrip_coupon_fee  # type: float
        self.cabin = cabin  # type: str
        self.cabin_class = cabin_class  # type: str
        self.capital_direction = capital_direction  # type: str
        self.cascade_department = cascade_department  # type: str
        self.change_fee = change_fee  # type: float
        self.corp_pay_order_fee = corp_pay_order_fee  # type: float
        self.cost_center = cost_center  # type: str
        self.cost_center_number = cost_center_number  # type: str
        self.coupon = coupon  # type: float
        self.dep_airport_code = dep_airport_code  # type: str
        self.department = department  # type: str
        self.department_id = department_id  # type: str
        self.dept_city = dept_city  # type: str
        self.dept_date = dept_date  # type: str
        self.dept_station = dept_station  # type: str
        self.dept_time = dept_time  # type: str
        self.discount = discount  # type: str
        self.fee_type = fee_type  # type: str
        self.flight_no = flight_no  # type: str
        self.index = index  # type: str
        self.insurance_fee = insurance_fee  # type: float
        self.insurance_number = insurance_number  # type: str
        self.invoice_title = invoice_title  # type: str
        self.most_difference_dept_time = most_difference_dept_time  # type: str
        self.most_difference_discount = most_difference_discount  # type: str
        self.most_difference_flight_no = most_difference_flight_no  # type: str
        self.most_difference_price = most_difference_price  # type: float
        self.most_difference_reason = most_difference_reason  # type: str
        self.most_price = most_price  # type: float
        self.negotiation_coupon_fee = negotiation_coupon_fee  # type: float
        self.order_id = order_id  # type: str
        self.order_status_desc = order_status_desc  # type: str
        self.over_apply_id = over_apply_id  # type: str
        self.primary_id = primary_id  # type: long
        self.project_code = project_code  # type: str
        self.project_name = project_name  # type: str
        self.refund_fee = refund_fee  # type: float
        self.remark = remark  # type: str
        self.repeat_refund = repeat_refund  # type: str
        self.seal_price = seal_price  # type: float
        self.segment_type = segment_type  # type: str
        self.service_fee = service_fee  # type: float
        self.settlement_fee = settlement_fee  # type: float
        self.settlement_grant_fee = settlement_grant_fee  # type: float
        self.settlement_time = settlement_time  # type: str
        self.settlement_type = settlement_type  # type: str
        self.status = status  # type: int
        self.sub_order_id = sub_order_id  # type: str
        self.tax_fee = tax_fee  # type: float
        self.ticket_id = ticket_id  # type: str
        self.trade = trade  # type: str
        self.traveler_id = traveler_id  # type: str
        self.traveler_job_no = traveler_job_no  # type: str
        self.traveler_name = traveler_name  # type: str
        self.voucher_type = voucher_type  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(IeFlightBillSettlementQueryResponseBodyModuleDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.advance_day is not None:
            result['advance_day'] = self.advance_day
        if self.airline_corp_code is not None:
            result['airline_corp_code'] = self.airline_corp_code
        if self.airline_corp_name is not None:
            result['airline_corp_name'] = self.airline_corp_name
        if self.alipay_trade_no is not None:
            result['alipay_trade_no'] = self.alipay_trade_no
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.arr_airport_code is not None:
            result['arr_airport_code'] = self.arr_airport_code
        if self.arr_city is not None:
            result['arr_city'] = self.arr_city
        if self.arr_date is not None:
            result['arr_date'] = self.arr_date
        if self.arr_station is not None:
            result['arr_station'] = self.arr_station
        if self.arr_time is not None:
            result['arr_time'] = self.arr_time
        if self.bill_record_time is not None:
            result['bill_record_time'] = self.bill_record_time
        if self.book_mode is not None:
            result['book_mode'] = self.book_mode
        if self.book_time is not None:
            result['book_time'] = self.book_time
        if self.booker_id is not None:
            result['booker_id'] = self.booker_id
        if self.booker_job_no is not None:
            result['booker_job_no'] = self.booker_job_no
        if self.booker_name is not None:
            result['booker_name'] = self.booker_name
        if self.btrip_coupon_fee is not None:
            result['btrip_coupon_fee'] = self.btrip_coupon_fee
        if self.cabin is not None:
            result['cabin'] = self.cabin
        if self.cabin_class is not None:
            result['cabin_class'] = self.cabin_class
        if self.capital_direction is not None:
            result['capital_direction'] = self.capital_direction
        if self.cascade_department is not None:
            result['cascade_department'] = self.cascade_department
        if self.change_fee is not None:
            result['change_fee'] = self.change_fee
        if self.corp_pay_order_fee is not None:
            result['corp_pay_order_fee'] = self.corp_pay_order_fee
        if self.cost_center is not None:
            result['cost_center'] = self.cost_center
        if self.cost_center_number is not None:
            result['cost_center_number'] = self.cost_center_number
        if self.coupon is not None:
            result['coupon'] = self.coupon
        if self.dep_airport_code is not None:
            result['dep_airport_code'] = self.dep_airport_code
        if self.department is not None:
            result['department'] = self.department
        if self.department_id is not None:
            result['department_id'] = self.department_id
        if self.dept_city is not None:
            result['dept_city'] = self.dept_city
        if self.dept_date is not None:
            result['dept_date'] = self.dept_date
        if self.dept_station is not None:
            result['dept_station'] = self.dept_station
        if self.dept_time is not None:
            result['dept_time'] = self.dept_time
        if self.discount is not None:
            result['discount'] = self.discount
        if self.fee_type is not None:
            result['fee_type'] = self.fee_type
        if self.flight_no is not None:
            result['flight_no'] = self.flight_no
        if self.index is not None:
            result['index'] = self.index
        if self.insurance_fee is not None:
            result['insurance_fee'] = self.insurance_fee
        if self.insurance_number is not None:
            result['insurance_number'] = self.insurance_number
        if self.invoice_title is not None:
            result['invoice_title'] = self.invoice_title
        if self.most_difference_dept_time is not None:
            result['most_difference_dept_time'] = self.most_difference_dept_time
        if self.most_difference_discount is not None:
            result['most_difference_discount'] = self.most_difference_discount
        if self.most_difference_flight_no is not None:
            result['most_difference_flight_no'] = self.most_difference_flight_no
        if self.most_difference_price is not None:
            result['most_difference_price'] = self.most_difference_price
        if self.most_difference_reason is not None:
            result['most_difference_reason'] = self.most_difference_reason
        if self.most_price is not None:
            result['most_price'] = self.most_price
        if self.negotiation_coupon_fee is not None:
            result['negotiation_coupon_fee'] = self.negotiation_coupon_fee
        if self.order_id is not None:
            result['order_id'] = self.order_id
        if self.order_status_desc is not None:
            result['order_status_desc'] = self.order_status_desc
        if self.over_apply_id is not None:
            result['over_apply_id'] = self.over_apply_id
        if self.primary_id is not None:
            result['primary_id'] = self.primary_id
        if self.project_code is not None:
            result['project_code'] = self.project_code
        if self.project_name is not None:
            result['project_name'] = self.project_name
        if self.refund_fee is not None:
            result['refund_fee'] = self.refund_fee
        if self.remark is not None:
            result['remark'] = self.remark
        if self.repeat_refund is not None:
            result['repeat_refund'] = self.repeat_refund
        if self.seal_price is not None:
            result['seal_price'] = self.seal_price
        if self.segment_type is not None:
            result['segment_type'] = self.segment_type
        if self.service_fee is not None:
            result['service_fee'] = self.service_fee
        if self.settlement_fee is not None:
            result['settlement_fee'] = self.settlement_fee
        if self.settlement_grant_fee is not None:
            result['settlement_grant_fee'] = self.settlement_grant_fee
        if self.settlement_time is not None:
            result['settlement_time'] = self.settlement_time
        if self.settlement_type is not None:
            result['settlement_type'] = self.settlement_type
        if self.status is not None:
            result['status'] = self.status
        if self.sub_order_id is not None:
            result['sub_order_id'] = self.sub_order_id
        if self.tax_fee is not None:
            result['tax_fee'] = self.tax_fee
        if self.ticket_id is not None:
            result['ticket_id'] = self.ticket_id
        if self.trade is not None:
            result['trade'] = self.trade
        if self.traveler_id is not None:
            result['traveler_id'] = self.traveler_id
        if self.traveler_job_no is not None:
            result['traveler_job_no'] = self.traveler_job_no
        if self.traveler_name is not None:
            result['traveler_name'] = self.traveler_name
        if self.voucher_type is not None:
            result['voucher_type'] = self.voucher_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('advance_day') is not None:
            self.advance_day = m.get('advance_day')
        if m.get('airline_corp_code') is not None:
            self.airline_corp_code = m.get('airline_corp_code')
        if m.get('airline_corp_name') is not None:
            self.airline_corp_name = m.get('airline_corp_name')
        if m.get('alipay_trade_no') is not None:
            self.alipay_trade_no = m.get('alipay_trade_no')
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('arr_airport_code') is not None:
            self.arr_airport_code = m.get('arr_airport_code')
        if m.get('arr_city') is not None:
            self.arr_city = m.get('arr_city')
        if m.get('arr_date') is not None:
            self.arr_date = m.get('arr_date')
        if m.get('arr_station') is not None:
            self.arr_station = m.get('arr_station')
        if m.get('arr_time') is not None:
            self.arr_time = m.get('arr_time')
        if m.get('bill_record_time') is not None:
            self.bill_record_time = m.get('bill_record_time')
        if m.get('book_mode') is not None:
            self.book_mode = m.get('book_mode')
        if m.get('book_time') is not None:
            self.book_time = m.get('book_time')
        if m.get('booker_id') is not None:
            self.booker_id = m.get('booker_id')
        if m.get('booker_job_no') is not None:
            self.booker_job_no = m.get('booker_job_no')
        if m.get('booker_name') is not None:
            self.booker_name = m.get('booker_name')
        if m.get('btrip_coupon_fee') is not None:
            self.btrip_coupon_fee = m.get('btrip_coupon_fee')
        if m.get('cabin') is not None:
            self.cabin = m.get('cabin')
        if m.get('cabin_class') is not None:
            self.cabin_class = m.get('cabin_class')
        if m.get('capital_direction') is not None:
            self.capital_direction = m.get('capital_direction')
        if m.get('cascade_department') is not None:
            self.cascade_department = m.get('cascade_department')
        if m.get('change_fee') is not None:
            self.change_fee = m.get('change_fee')
        if m.get('corp_pay_order_fee') is not None:
            self.corp_pay_order_fee = m.get('corp_pay_order_fee')
        if m.get('cost_center') is not None:
            self.cost_center = m.get('cost_center')
        if m.get('cost_center_number') is not None:
            self.cost_center_number = m.get('cost_center_number')
        if m.get('coupon') is not None:
            self.coupon = m.get('coupon')
        if m.get('dep_airport_code') is not None:
            self.dep_airport_code = m.get('dep_airport_code')
        if m.get('department') is not None:
            self.department = m.get('department')
        if m.get('department_id') is not None:
            self.department_id = m.get('department_id')
        if m.get('dept_city') is not None:
            self.dept_city = m.get('dept_city')
        if m.get('dept_date') is not None:
            self.dept_date = m.get('dept_date')
        if m.get('dept_station') is not None:
            self.dept_station = m.get('dept_station')
        if m.get('dept_time') is not None:
            self.dept_time = m.get('dept_time')
        if m.get('discount') is not None:
            self.discount = m.get('discount')
        if m.get('fee_type') is not None:
            self.fee_type = m.get('fee_type')
        if m.get('flight_no') is not None:
            self.flight_no = m.get('flight_no')
        if m.get('index') is not None:
            self.index = m.get('index')
        if m.get('insurance_fee') is not None:
            self.insurance_fee = m.get('insurance_fee')
        if m.get('insurance_number') is not None:
            self.insurance_number = m.get('insurance_number')
        if m.get('invoice_title') is not None:
            self.invoice_title = m.get('invoice_title')
        if m.get('most_difference_dept_time') is not None:
            self.most_difference_dept_time = m.get('most_difference_dept_time')
        if m.get('most_difference_discount') is not None:
            self.most_difference_discount = m.get('most_difference_discount')
        if m.get('most_difference_flight_no') is not None:
            self.most_difference_flight_no = m.get('most_difference_flight_no')
        if m.get('most_difference_price') is not None:
            self.most_difference_price = m.get('most_difference_price')
        if m.get('most_difference_reason') is not None:
            self.most_difference_reason = m.get('most_difference_reason')
        if m.get('most_price') is not None:
            self.most_price = m.get('most_price')
        if m.get('negotiation_coupon_fee') is not None:
            self.negotiation_coupon_fee = m.get('negotiation_coupon_fee')
        if m.get('order_id') is not None:
            self.order_id = m.get('order_id')
        if m.get('order_status_desc') is not None:
            self.order_status_desc = m.get('order_status_desc')
        if m.get('over_apply_id') is not None:
            self.over_apply_id = m.get('over_apply_id')
        if m.get('primary_id') is not None:
            self.primary_id = m.get('primary_id')
        if m.get('project_code') is not None:
            self.project_code = m.get('project_code')
        if m.get('project_name') is not None:
            self.project_name = m.get('project_name')
        if m.get('refund_fee') is not None:
            self.refund_fee = m.get('refund_fee')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        if m.get('repeat_refund') is not None:
            self.repeat_refund = m.get('repeat_refund')
        if m.get('seal_price') is not None:
            self.seal_price = m.get('seal_price')
        if m.get('segment_type') is not None:
            self.segment_type = m.get('segment_type')
        if m.get('service_fee') is not None:
            self.service_fee = m.get('service_fee')
        if m.get('settlement_fee') is not None:
            self.settlement_fee = m.get('settlement_fee')
        if m.get('settlement_grant_fee') is not None:
            self.settlement_grant_fee = m.get('settlement_grant_fee')
        if m.get('settlement_time') is not None:
            self.settlement_time = m.get('settlement_time')
        if m.get('settlement_type') is not None:
            self.settlement_type = m.get('settlement_type')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('sub_order_id') is not None:
            self.sub_order_id = m.get('sub_order_id')
        if m.get('tax_fee') is not None:
            self.tax_fee = m.get('tax_fee')
        if m.get('ticket_id') is not None:
            self.ticket_id = m.get('ticket_id')
        if m.get('trade') is not None:
            self.trade = m.get('trade')
        if m.get('traveler_id') is not None:
            self.traveler_id = m.get('traveler_id')
        if m.get('traveler_job_no') is not None:
            self.traveler_job_no = m.get('traveler_job_no')
        if m.get('traveler_name') is not None:
            self.traveler_name = m.get('traveler_name')
        if m.get('voucher_type') is not None:
            self.voucher_type = m.get('voucher_type')
        return self


class IeFlightBillSettlementQueryResponseBodyModule(TeaModel):
    def __init__(self, category=None, corp_id=None, data_list=None, period_end=None, period_start=None,
                 total_num=None):
        self.category = category  # type: int
        self.corp_id = corp_id  # type: str
        self.data_list = data_list  # type: list[IeFlightBillSettlementQueryResponseBodyModuleDataList]
        self.period_end = period_end  # type: str
        self.period_start = period_start  # type: str
        self.total_num = total_num  # type: long

    def validate(self):
        if self.data_list:
            for k in self.data_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(IeFlightBillSettlementQueryResponseBodyModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['category'] = self.category
        if self.corp_id is not None:
            result['corp_id'] = self.corp_id
        result['data_list'] = []
        if self.data_list is not None:
            for k in self.data_list:
                result['data_list'].append(k.to_map() if k else None)
        if self.period_end is not None:
            result['period_end'] = self.period_end
        if self.period_start is not None:
            result['period_start'] = self.period_start
        if self.total_num is not None:
            result['total_num'] = self.total_num
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('category') is not None:
            self.category = m.get('category')
        if m.get('corp_id') is not None:
            self.corp_id = m.get('corp_id')
        self.data_list = []
        if m.get('data_list') is not None:
            for k in m.get('data_list'):
                temp_model = IeFlightBillSettlementQueryResponseBodyModuleDataList()
                self.data_list.append(temp_model.from_map(k))
        if m.get('period_end') is not None:
            self.period_end = m.get('period_end')
        if m.get('period_start') is not None:
            self.period_start = m.get('period_start')
        if m.get('total_num') is not None:
            self.total_num = m.get('total_num')
        return self


class IeFlightBillSettlementQueryResponseBody(TeaModel):
    def __init__(self, code=None, message=None, module=None, more_page=None, request_id=None, success=None,
                 trace_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.module = module  # type: IeFlightBillSettlementQueryResponseBodyModule
        self.more_page = more_page  # type: bool
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.trace_id = trace_id  # type: str

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super(IeFlightBillSettlementQueryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.more_page is not None:
            result['more_page'] = self.more_page
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = IeFlightBillSettlementQueryResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('more_page') is not None:
            self.more_page = m.get('more_page')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class IeFlightBillSettlementQueryResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: IeFlightBillSettlementQueryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(IeFlightBillSettlementQueryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = IeFlightBillSettlementQueryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class InvoiceAddHeaders(TeaModel):
    def __init__(self, common_headers=None, x_acs_btrip_so_corp_token=None):
        self.common_headers = common_headers  # type: dict[str, str]
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(InvoiceAddHeaders, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class InvoiceAddRequest(TeaModel):
    def __init__(self, address=None, bank_name=None, bank_no=None, tax_no=None, tel=None, third_part_id=None,
                 title=None, type=None):
        self.address = address  # type: str
        self.bank_name = bank_name  # type: str
        self.bank_no = bank_no  # type: str
        self.tax_no = tax_no  # type: str
        self.tel = tel  # type: str
        self.third_part_id = third_part_id  # type: str
        self.title = title  # type: str
        self.type = type  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(InvoiceAddRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.address is not None:
            result['address'] = self.address
        if self.bank_name is not None:
            result['bank_name'] = self.bank_name
        if self.bank_no is not None:
            result['bank_no'] = self.bank_no
        if self.tax_no is not None:
            result['tax_no'] = self.tax_no
        if self.tel is not None:
            result['tel'] = self.tel
        if self.third_part_id is not None:
            result['third_part_id'] = self.third_part_id
        if self.title is not None:
            result['title'] = self.title
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('address') is not None:
            self.address = m.get('address')
        if m.get('bank_name') is not None:
            self.bank_name = m.get('bank_name')
        if m.get('bank_no') is not None:
            self.bank_no = m.get('bank_no')
        if m.get('tax_no') is not None:
            self.tax_no = m.get('tax_no')
        if m.get('tel') is not None:
            self.tel = m.get('tel')
        if m.get('third_part_id') is not None:
            self.third_part_id = m.get('third_part_id')
        if m.get('title') is not None:
            self.title = m.get('title')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class InvoiceAddResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None, trace_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        # traceId
        self.trace_id = trace_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(InvoiceAddResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class InvoiceAddResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: InvoiceAddResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(InvoiceAddResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = InvoiceAddResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class InvoiceDeleteHeaders(TeaModel):
    def __init__(self, common_headers=None, x_acs_btrip_so_corp_token=None):
        self.common_headers = common_headers  # type: dict[str, str]
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(InvoiceDeleteHeaders, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class InvoiceDeleteRequest(TeaModel):
    def __init__(self, third_part_id=None):
        self.third_part_id = third_part_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(InvoiceDeleteRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.third_part_id is not None:
            result['third_part_id'] = self.third_part_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('third_part_id') is not None:
            self.third_part_id = m.get('third_part_id')
        return self


class InvoiceDeleteResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None, trace_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        # traceId
        self.trace_id = trace_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(InvoiceDeleteResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class InvoiceDeleteResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: InvoiceDeleteResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(InvoiceDeleteResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = InvoiceDeleteResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class InvoiceModifyHeaders(TeaModel):
    def __init__(self, common_headers=None, x_acs_btrip_so_corp_token=None):
        self.common_headers = common_headers  # type: dict[str, str]
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(InvoiceModifyHeaders, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class InvoiceModifyRequest(TeaModel):
    def __init__(self, address=None, bank_name=None, bank_no=None, tax_no=None, tel=None, third_part_id=None,
                 title=None, type=None):
        self.address = address  # type: str
        self.bank_name = bank_name  # type: str
        self.bank_no = bank_no  # type: str
        self.tax_no = tax_no  # type: str
        self.tel = tel  # type: str
        self.third_part_id = third_part_id  # type: str
        self.title = title  # type: str
        self.type = type  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(InvoiceModifyRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.address is not None:
            result['address'] = self.address
        if self.bank_name is not None:
            result['bank_name'] = self.bank_name
        if self.bank_no is not None:
            result['bank_no'] = self.bank_no
        if self.tax_no is not None:
            result['tax_no'] = self.tax_no
        if self.tel is not None:
            result['tel'] = self.tel
        if self.third_part_id is not None:
            result['third_part_id'] = self.third_part_id
        if self.title is not None:
            result['title'] = self.title
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('address') is not None:
            self.address = m.get('address')
        if m.get('bank_name') is not None:
            self.bank_name = m.get('bank_name')
        if m.get('bank_no') is not None:
            self.bank_no = m.get('bank_no')
        if m.get('tax_no') is not None:
            self.tax_no = m.get('tax_no')
        if m.get('tel') is not None:
            self.tel = m.get('tel')
        if m.get('third_part_id') is not None:
            self.third_part_id = m.get('third_part_id')
        if m.get('title') is not None:
            self.title = m.get('title')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class InvoiceModifyResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None, trace_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        # traceId
        self.trace_id = trace_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(InvoiceModifyResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class InvoiceModifyResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: InvoiceModifyResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(InvoiceModifyResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = InvoiceModifyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class InvoiceRuleSaveHeaders(TeaModel):
    def __init__(self, common_headers=None, x_acs_btrip_so_corp_token=None):
        self.common_headers = common_headers  # type: dict[str, str]
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(InvoiceRuleSaveHeaders, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class InvoiceRuleSaveRequestEntities(TeaModel):
    def __init__(self, id=None, name=None, type=None):
        self.id = id  # type: str
        self.name = name  # type: str
        self.type = type  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(InvoiceRuleSaveRequestEntities, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.name is not None:
            result['name'] = self.name
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class InvoiceRuleSaveRequest(TeaModel):
    def __init__(self, all_employe=None, entities=None, third_part_id=None):
        self.all_employe = all_employe  # type: bool
        self.entities = entities  # type: list[InvoiceRuleSaveRequestEntities]
        self.third_part_id = third_part_id  # type: str

    def validate(self):
        if self.entities:
            for k in self.entities:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(InvoiceRuleSaveRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.all_employe is not None:
            result['all_employe'] = self.all_employe
        result['entities'] = []
        if self.entities is not None:
            for k in self.entities:
                result['entities'].append(k.to_map() if k else None)
        if self.third_part_id is not None:
            result['third_part_id'] = self.third_part_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('all_employe') is not None:
            self.all_employe = m.get('all_employe')
        self.entities = []
        if m.get('entities') is not None:
            for k in m.get('entities'):
                temp_model = InvoiceRuleSaveRequestEntities()
                self.entities.append(temp_model.from_map(k))
        if m.get('third_part_id') is not None:
            self.third_part_id = m.get('third_part_id')
        return self


class InvoiceRuleSaveShrinkRequest(TeaModel):
    def __init__(self, all_employe=None, entities_shrink=None, third_part_id=None):
        self.all_employe = all_employe  # type: bool
        self.entities_shrink = entities_shrink  # type: str
        self.third_part_id = third_part_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(InvoiceRuleSaveShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.all_employe is not None:
            result['all_employe'] = self.all_employe
        if self.entities_shrink is not None:
            result['entities'] = self.entities_shrink
        if self.third_part_id is not None:
            result['third_part_id'] = self.third_part_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('all_employe') is not None:
            self.all_employe = m.get('all_employe')
        if m.get('entities') is not None:
            self.entities_shrink = m.get('entities')
        if m.get('third_part_id') is not None:
            self.third_part_id = m.get('third_part_id')
        return self


class InvoiceRuleSaveResponseBodyModule(TeaModel):
    def __init__(self, add_num=None, remove_num=None):
        self.add_num = add_num  # type: int
        self.remove_num = remove_num  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(InvoiceRuleSaveResponseBodyModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.add_num is not None:
            result['add_num'] = self.add_num
        if self.remove_num is not None:
            result['remove_num'] = self.remove_num
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('add_num') is not None:
            self.add_num = m.get('add_num')
        if m.get('remove_num') is not None:
            self.remove_num = m.get('remove_num')
        return self


class InvoiceRuleSaveResponseBody(TeaModel):
    def __init__(self, code=None, message=None, module=None, request_id=None, success=None, trace_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.module = module  # type: InvoiceRuleSaveResponseBodyModule
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.trace_id = trace_id  # type: str

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super(InvoiceRuleSaveResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = InvoiceRuleSaveResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class InvoiceRuleSaveResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: InvoiceRuleSaveResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(InvoiceRuleSaveResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = InvoiceRuleSaveResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class InvoiceSearchHeaders(TeaModel):
    def __init__(self, common_headers=None, x_acs_btrip_so_corp_token=None):
        self.common_headers = common_headers  # type: dict[str, str]
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(InvoiceSearchHeaders, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class InvoiceSearchRequest(TeaModel):
    def __init__(self, title=None, user_id=None):
        self.title = title  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(InvoiceSearchRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.title is not None:
            result['title'] = self.title
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('title') is not None:
            self.title = m.get('title')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class InvoiceSearchResponseBodyModule(TeaModel):
    def __init__(self, id=None, third_part_invoice_id=None, title=None):
        # ID
        self.id = id  # type: long
        self.third_part_invoice_id = third_part_invoice_id  # type: str
        self.title = title  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(InvoiceSearchResponseBodyModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.third_part_invoice_id is not None:
            result['third_part_invoice_id'] = self.third_part_invoice_id
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('third_part_invoice_id') is not None:
            self.third_part_invoice_id = m.get('third_part_invoice_id')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class InvoiceSearchResponseBody(TeaModel):
    def __init__(self, code=None, message=None, module=None, request_id=None, success=None, trace_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.module = module  # type: list[InvoiceSearchResponseBodyModule]
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        # traceId
        self.trace_id = trace_id  # type: str

    def validate(self):
        if self.module:
            for k in self.module:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(InvoiceSearchResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        result['module'] = []
        if self.module is not None:
            for k in self.module:
                result['module'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        self.module = []
        if m.get('module') is not None:
            for k in m.get('module'):
                temp_model = InvoiceSearchResponseBodyModule()
                self.module.append(temp_model.from_map(k))
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class InvoiceSearchResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: InvoiceSearchResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(InvoiceSearchResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = InvoiceSearchResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class IsvUserSaveHeaders(TeaModel):
    def __init__(self, common_headers=None, x_acs_btrip_so_corp_token=None):
        self.common_headers = common_headers  # type: dict[str, str]
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(IsvUserSaveHeaders, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class IsvUserSaveRequestUserList(TeaModel):
    def __init__(self, depart_id=None, email=None, job_no=None, leave_status=None, manager_user_id=None, phone=None,
                 position=None, position_level=None, real_name_en=None, third_depart_id=None, third_depart_id_list=None,
                 user_id=None, user_name=None):
        self.depart_id = depart_id  # type: long
        self.email = email  # type: str
        self.job_no = job_no  # type: str
        self.leave_status = leave_status  # type: int
        self.manager_user_id = manager_user_id  # type: str
        self.phone = phone  # type: str
        self.position = position  # type: str
        self.position_level = position_level  # type: str
        self.real_name_en = real_name_en  # type: str
        self.third_depart_id = third_depart_id  # type: str
        self.third_depart_id_list = third_depart_id_list  # type: list[str]
        self.user_id = user_id  # type: str
        self.user_name = user_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(IsvUserSaveRequestUserList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.depart_id is not None:
            result['depart_id'] = self.depart_id
        if self.email is not None:
            result['email'] = self.email
        if self.job_no is not None:
            result['job_no'] = self.job_no
        if self.leave_status is not None:
            result['leave_status'] = self.leave_status
        if self.manager_user_id is not None:
            result['manager_user_id'] = self.manager_user_id
        if self.phone is not None:
            result['phone'] = self.phone
        if self.position is not None:
            result['position'] = self.position
        if self.position_level is not None:
            result['position_level'] = self.position_level
        if self.real_name_en is not None:
            result['real_name_en'] = self.real_name_en
        if self.third_depart_id is not None:
            result['third_depart_id'] = self.third_depart_id
        if self.third_depart_id_list is not None:
            result['third_depart_id_list'] = self.third_depart_id_list
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('depart_id') is not None:
            self.depart_id = m.get('depart_id')
        if m.get('email') is not None:
            self.email = m.get('email')
        if m.get('job_no') is not None:
            self.job_no = m.get('job_no')
        if m.get('leave_status') is not None:
            self.leave_status = m.get('leave_status')
        if m.get('manager_user_id') is not None:
            self.manager_user_id = m.get('manager_user_id')
        if m.get('phone') is not None:
            self.phone = m.get('phone')
        if m.get('position') is not None:
            self.position = m.get('position')
        if m.get('position_level') is not None:
            self.position_level = m.get('position_level')
        if m.get('real_name_en') is not None:
            self.real_name_en = m.get('real_name_en')
        if m.get('third_depart_id') is not None:
            self.third_depart_id = m.get('third_depart_id')
        if m.get('third_depart_id_list') is not None:
            self.third_depart_id_list = m.get('third_depart_id_list')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        return self


c