/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jgssp2ldap;

import com.teradata.tdgss.jgssp2ldap.LdapDH;
import com.teradata.tdgss.jgssp2ldap.LdapMinorStatus;
import com.teradata.tdgss.jtdgss.TdgssException;
import com.teradata.tdgss.jtdgss.TdgssLogger;
import com.teradata.tdgss.jtdgss.TdgssUtil;
import java.math.BigInteger;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import org.ietf.jgss.GSSException;

public class LdapUtil {
    private static final int BYTESININT = 4;

    public static void prtbuf(int[] nArray, String string, TdgssLogger tdgssLogger) {
        int n = 4;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string + " : ");
        for (int i = 0; i < nArray.length; ++i) {
            if (i % n == 0) {
                stringBuffer.append("\n\t" + i + ") ");
            }
            stringBuffer.append(" " + Integer.toHexString(nArray[i]));
            n2 += nArray[i] + i;
        }
        stringBuffer.append("\n\tTotal " + nArray.length + " integers " + " chksum = " + Integer.toHexString(n2));
        stringBuffer.append("");
        if (tdgssLogger.isDebugEnabled()) {
            tdgssLogger.debug(stringBuffer.toString());
        }
    }

    public static void prtbuf(byte[] byArray, TdgssLogger tdgssLogger) {
        int n;
        int n2 = 16;
        int n3 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < byArray.length; ++n) {
            if (n % n2 == 0) {
                stringBuffer.append("\n\t\t" + n + ") ");
            }
            stringBuffer.append(" " + byArray[n]);
            n3 += byArray[n] + n;
        }
        for (n = 0; n < byArray.length; ++n) {
            if (n % n2 == 0) {
                stringBuffer.append("\n\t\t" + n + ") ");
            }
            stringBuffer.append("" + (char)byArray[n]);
        }
        stringBuffer.append("\n\t\tTotal bytes = " + byArray.length + " chksum = " + n3);
        if (tdgssLogger.isDebugEnabled()) {
            tdgssLogger.debug(stringBuffer.toString());
        }
    }

    public static void bufcpy(byte[] byArray, byte[] byArray2) {
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = byArray2[i];
        }
    }

    public static byte[] inttobytearray(int n) {
        Integer n2 = new Integer(n);
        BigInteger bigInteger = new BigInteger(n2.toString());
        byte[] byArray = bigInteger.toByteArray();
        if (byArray.length < 4) {
            byte[] byArray2 = new byte[4];
            int n3 = byArray.length;
            for (int i = 4; i > 0; --i) {
                if (--n3 >= 0) {
                    byArray2[i] = byArray[n3];
                    continue;
                }
                byArray2[i] = 0;
            }
            return byArray2;
        }
        return byArray;
    }

    public static int ByteAtoInt(byte[] byArray) {
        BigInteger bigInteger = new BigInteger(byArray);
        return bigInteger.intValue();
    }

    public static byte[] encryptBuffer(byte[] byArray, byte[] byArray2, TdgssLogger tdgssLogger) throws GSSException {
        byte[] byArray3;
        int n = 16;
        if (byArray == null || byArray2 == null) {
            return null;
        }
        LdapDH ldapDH = new LdapDH(tdgssLogger);
        String string = "AES/ECB/PKCS5Padding";
        try {
            SecretKey secretKey = ldapDH.BytetoKey("AES", byArray, 0, n);
            Cipher cipher = Cipher.getInstance(string);
            cipher.init(1, secretKey);
            byArray3 = cipher.doFinal(byArray2, 0, byArray2.length);
        }
        catch (Exception exception) {
            throw new TdgssException(11, LdapMinorStatus.LDAPV3_ERR_ENCRYPTION_FAIL, exception);
        }
        return byArray3;
    }

    public static byte[] decryptBuffer(byte[] byArray, byte[] byArray2, TdgssLogger tdgssLogger) throws GSSException {
        int n = 16;
        if (byArray == null || byArray2 == null) {
            return null;
        }
        LdapDH ldapDH = new LdapDH(tdgssLogger);
        byte[] byArray3 = null;
        String string = "AES/ECB/PKCS5Padding";
        try {
            SecretKey secretKey = ldapDH.BytetoKey("AES", byArray, 0, n);
            Cipher cipher = Cipher.getInstance(string);
            cipher.init(2, secretKey);
            byArray3 = cipher.doFinal(byArray2, 0, byArray2.length);
        }
        catch (Exception exception) {
            throw new TdgssException(11, LdapMinorStatus.LDAPV3_ERR_ENCRYPTION_FAIL, exception);
        }
        return byArray3;
    }

    public static byte[] getEDKey(TdgssLogger tdgssLogger) {
        int n = 16;
        SecureRandom secureRandom = new SecureRandom();
        byte[] byArray = new byte[n];
        secureRandom.nextBytes(byArray);
        if (tdgssLogger.isDebugEnabled()) {
            tdgssLogger.debug(TdgssUtil.dump("", byArray));
        }
        return byArray;
    }
}

