"""
    Authentication endpoints - OpenAPI 3.0

    The endpoints for the authentication API.  # noqa: E501

    The version of the OpenAPI document: DRAFT
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from swx_sdk.api_client import ApiClient, Endpoint as _Endpoint
from swx_sdk.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from swx_sdk.model.error_response import ErrorResponse
from swx_sdk.model.publisher_thing_mapping_object import PublisherThingMappingObject
from swx_sdk.model.secret import Secret
from swx_sdk.model.thing_create_response import ThingCreateResponse
from swx_sdk.model.thing_delete_response import ThingDeleteResponse
from swx_sdk.model.thing_list_response import ThingListResponse
from swx_sdk.model.thing_object_delete_response import ThingObjectDeleteResponse
from swx_sdk.model.thing_request import ThingRequest
from swx_sdk.model.thing_response import ThingResponse
from swx_sdk.model.thing_update_request import ThingUpdateRequest
from swx_sdk.model.thing_update_response import ThingUpdateResponse


class ThingsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __add_accounts_thing(
            self,
            account_id,
            thing_request,
            **kwargs
        ):
            """Add a thing description  # noqa: E501

            Add a new thing description to the platform according to WoT specification  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.add_accounts_thing(account_id, thing_request, async_req=True)
            >>> result = thread.get()

            Args:
                account_id (str):
                thing_request (ThingRequest): Create a new thing description in the platform

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ThingCreateResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['account_id'] = \
                account_id
            kwargs['thing_request'] = \
                thing_request
            return self.call_with_http_info(**kwargs)

        self.add_accounts_thing = _Endpoint(
            settings={
                'response_type': (ThingCreateResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/accounts/{account-id}/things',
                'operation_id': 'add_accounts_thing',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'thing_request',
                ],
                'required': [
                    'account_id',
                    'thing_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'thing_request':
                        (ThingRequest,),
                },
                'attribute_map': {
                    'account_id': 'account-id',
                },
                'location_map': {
                    'account_id': 'path',
                    'thing_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__add_accounts_thing
        )

        def __add_exports_mqtt_publishers_publisher_thing_mapping(
            self,
            publisher_id,
            publisher_thing_mapping_object,
            **kwargs
        ):
            """Add Publisher to Thing mappings  # noqa: E501

            Add new publisher to thing mappings to the platform  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.add_exports_mqtt_publishers_publisher_thing_mapping(publisher_id, publisher_thing_mapping_object, async_req=True)
            >>> result = thread.get()

            Args:
                publisher_id (str):
                publisher_thing_mapping_object ([PublisherThingMappingObject]): Create new publisher thing mappings in the platform

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                [PublisherThingMappingObject]
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['publisher_id'] = \
                publisher_id
            kwargs['publisher_thing_mapping_object'] = \
                publisher_thing_mapping_object
            return self.call_with_http_info(**kwargs)

        self.add_exports_mqtt_publishers_publisher_thing_mapping = _Endpoint(
            settings={
                'response_type': ([PublisherThingMappingObject],),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/exports/mqtt/publishers/{publisher_id}/things',
                'operation_id': 'add_exports_mqtt_publishers_publisher_thing_mapping',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'publisher_id',
                    'publisher_thing_mapping_object',
                ],
                'required': [
                    'publisher_id',
                    'publisher_thing_mapping_object',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'publisher_id':
                        (str,),
                    'publisher_thing_mapping_object':
                        ([PublisherThingMappingObject],),
                },
                'attribute_map': {
                    'publisher_id': 'publisher_id',
                },
                'location_map': {
                    'publisher_id': 'path',
                    'publisher_thing_mapping_object': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__add_exports_mqtt_publishers_publisher_thing_mapping
        )

        def __add_spaces_collections_thing(
            self,
            space,
            collection_name,
            thing_request,
            **kwargs
        ):
            """Add a thing description  # noqa: E501

            Add a new thing description to the platform according to WoT specification  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.add_spaces_collections_thing(space, collection_name, thing_request, async_req=True)
            >>> result = thread.get()

            Args:
                space (str):
                collection_name (str):
                thing_request (ThingRequest): Create a new thing description in the platform

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ThingCreateResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['space'] = \
                space
            kwargs['collection_name'] = \
                collection_name
            kwargs['thing_request'] = \
                thing_request
            return self.call_with_http_info(**kwargs)

        self.add_spaces_collections_thing = _Endpoint(
            settings={
                'response_type': (ThingCreateResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/spaces/{space}/collections/{collection-name}/things',
                'operation_id': 'add_spaces_collections_thing',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'space',
                    'collection_name',
                    'thing_request',
                ],
                'required': [
                    'space',
                    'collection_name',
                    'thing_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'space':
                        (str,),
                    'collection_name':
                        (str,),
                    'thing_request':
                        (ThingRequest,),
                },
                'attribute_map': {
                    'space': 'space',
                    'collection_name': 'collection-name',
                },
                'location_map': {
                    'space': 'path',
                    'collection_name': 'path',
                    'thing_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__add_spaces_collections_thing
        )

        def __delete_accounts_thing(
            self,
            account_id,
            thing_id,
            **kwargs
        ):
            """Delete thing  # noqa: E501

            Deletes all the existing information from a thing by Id. It deletes the thing description and the data.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_accounts_thing(account_id, thing_id, async_req=True)
            >>> result = thread.get()

            Args:
                account_id (str):
                thing_id (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ThingDeleteResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['account_id'] = \
                account_id
            kwargs['thing_id'] = \
                thing_id
            return self.call_with_http_info(**kwargs)

        self.delete_accounts_thing = _Endpoint(
            settings={
                'response_type': (ThingDeleteResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/accounts/{account-id}/things/{thing-id}',
                'operation_id': 'delete_accounts_thing',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'thing_id',
                ],
                'required': [
                    'account_id',
                    'thing_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'thing_id':
                        (str,),
                },
                'attribute_map': {
                    'account_id': 'account-id',
                    'thing_id': 'thing-id',
                },
                'location_map': {
                    'account_id': 'path',
                    'thing_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_accounts_thing
        )

        def __delete_exports_mqtt_publishers_publisher_thing_mapping(
            self,
            publisher_id,
            thing_id,
            **kwargs
        ):
            """Delete Publisher to Thing mapping  # noqa: E501

            Delete of publisher to thing mapping  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_exports_mqtt_publishers_publisher_thing_mapping(publisher_id, thing_id, async_req=True)
            >>> result = thread.get()

            Args:
                publisher_id (str):
                thing_id (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['publisher_id'] = \
                publisher_id
            kwargs['thing_id'] = \
                thing_id
            return self.call_with_http_info(**kwargs)

        self.delete_exports_mqtt_publishers_publisher_thing_mapping = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/exports/mqtt/publishers/{publisher_id}/things/{thing_id}',
                'operation_id': 'delete_exports_mqtt_publishers_publisher_thing_mapping',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'publisher_id',
                    'thing_id',
                ],
                'required': [
                    'publisher_id',
                    'thing_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'publisher_id':
                        (str,),
                    'thing_id':
                        (str,),
                },
                'attribute_map': {
                    'publisher_id': 'publisher_id',
                    'thing_id': 'thing_id',
                },
                'location_map': {
                    'publisher_id': 'path',
                    'thing_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_exports_mqtt_publishers_publisher_thing_mapping
        )

        def __delete_spaces_collections_thing(
            self,
            space,
            collection_name,
            thing_id,
            **kwargs
        ):
            """Delete thing  # noqa: E501

            Deletes all the existing information from a thing by Id. It deletes the thing description and the data.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_spaces_collections_thing(space, collection_name, thing_id, async_req=True)
            >>> result = thread.get()

            Args:
                space (str):
                collection_name (str):
                thing_id (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ThingObjectDeleteResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['space'] = \
                space
            kwargs['collection_name'] = \
                collection_name
            kwargs['thing_id'] = \
                thing_id
            return self.call_with_http_info(**kwargs)

        self.delete_spaces_collections_thing = _Endpoint(
            settings={
                'response_type': (ThingObjectDeleteResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/spaces/{space}/collections/{collection-name}/things/{thing-id}',
                'operation_id': 'delete_spaces_collections_thing',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'space',
                    'collection_name',
                    'thing_id',
                ],
                'required': [
                    'space',
                    'collection_name',
                    'thing_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'space':
                        (str,),
                    'collection_name':
                        (str,),
                    'thing_id':
                        (str,),
                },
                'attribute_map': {
                    'space': 'space',
                    'collection_name': 'collection-name',
                    'thing_id': 'thing-id',
                },
                'location_map': {
                    'space': 'path',
                    'collection_name': 'path',
                    'thing_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_spaces_collections_thing
        )

        def __list_accounts_things(
            self,
            account_id,
            **kwargs
        ):
            """List thing descriptions  # noqa: E501

            List all thing descriptions in an array  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_accounts_things(account_id, async_req=True)
            >>> result = thread.get()

            Args:
                account_id (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ThingListResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['account_id'] = \
                account_id
            return self.call_with_http_info(**kwargs)

        self.list_accounts_things = _Endpoint(
            settings={
                'response_type': (ThingListResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/accounts/{account-id}/things',
                'operation_id': 'list_accounts_things',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                ],
                'required': [
                    'account_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                },
                'attribute_map': {
                    'account_id': 'account-id',
                },
                'location_map': {
                    'account_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_accounts_things
        )

        def __list_exports_mqtt_publishers_publisher_thing_mappings(
            self,
            publisher_id,
            **kwargs
        ):
            """List Publisher to Thing mappings  # noqa: E501

            List of publisher to thing mappings in array  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_exports_mqtt_publishers_publisher_thing_mappings(publisher_id, async_req=True)
            >>> result = thread.get()

            Args:
                publisher_id (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                [PublisherThingMappingObject]
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['publisher_id'] = \
                publisher_id
            return self.call_with_http_info(**kwargs)

        self.list_exports_mqtt_publishers_publisher_thing_mappings = _Endpoint(
            settings={
                'response_type': ([PublisherThingMappingObject],),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/exports/mqtt/publishers/{publisher_id}/things',
                'operation_id': 'list_exports_mqtt_publishers_publisher_thing_mappings',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'publisher_id',
                ],
                'required': [
                    'publisher_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'publisher_id':
                        (str,),
                },
                'attribute_map': {
                    'publisher_id': 'publisher_id',
                },
                'location_map': {
                    'publisher_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_exports_mqtt_publishers_publisher_thing_mappings
        )

        def __list_spaces_collections_things(
            self,
            space,
            collection_name,
            **kwargs
        ):
            """List thing descriptions  # noqa: E501

            List all thing descriptions in an array  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_spaces_collections_things(space, collection_name, async_req=True)
            >>> result = thread.get()

            Args:
                space (str):
                collection_name (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ThingListResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['space'] = \
                space
            kwargs['collection_name'] = \
                collection_name
            return self.call_with_http_info(**kwargs)

        self.list_spaces_collections_things = _Endpoint(
            settings={
                'response_type': (ThingListResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/spaces/{space}/collections/{collection-name}/things',
                'operation_id': 'list_spaces_collections_things',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'space',
                    'collection_name',
                ],
                'required': [
                    'space',
                    'collection_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'space':
                        (str,),
                    'collection_name':
                        (str,),
                },
                'attribute_map': {
                    'space': 'space',
                    'collection_name': 'collection-name',
                },
                'location_map': {
                    'space': 'path',
                    'collection_name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_spaces_collections_things
        )

        def __reset_accounts_things_client_secret(
            self,
            account_id,
            thing_id,
            **kwargs
        ):
            """Reset Client Secret  # noqa: E501

            Reset the Client Secret for a specific thing  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.reset_accounts_things_client_secret(account_id, thing_id, async_req=True)
            >>> result = thread.get()

            Args:
                account_id (str):
                thing_id (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Secret
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['account_id'] = \
                account_id
            kwargs['thing_id'] = \
                thing_id
            return self.call_with_http_info(**kwargs)

        self.reset_accounts_things_client_secret = _Endpoint(
            settings={
                'response_type': (Secret,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/accounts/{account-id}/things/{thing-id}/reset-secret',
                'operation_id': 'reset_accounts_things_client_secret',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'thing_id',
                ],
                'required': [
                    'account_id',
                    'thing_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'thing_id':
                        (str,),
                },
                'attribute_map': {
                    'account_id': 'account-id',
                    'thing_id': 'thing-id',
                },
                'location_map': {
                    'account_id': 'path',
                    'thing_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__reset_accounts_things_client_secret
        )

        def __reset_spaces_collections_things_client_secret(
            self,
            space,
            thing_id,
            collection_name,
            **kwargs
        ):
            """Reset Client Secret  # noqa: E501

            Reset the Client Secret for a specific thing  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.reset_spaces_collections_things_client_secret(space, thing_id, collection_name, async_req=True)
            >>> result = thread.get()

            Args:
                space (str):
                thing_id (str):
                collection_name (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Secret
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['space'] = \
                space
            kwargs['thing_id'] = \
                thing_id
            kwargs['collection_name'] = \
                collection_name
            return self.call_with_http_info(**kwargs)

        self.reset_spaces_collections_things_client_secret = _Endpoint(
            settings={
                'response_type': (Secret,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/spaces/{space}/collections/{collection-name}/things/{thing-id}/reset-secret',
                'operation_id': 'reset_spaces_collections_things_client_secret',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'space',
                    'thing_id',
                    'collection_name',
                ],
                'required': [
                    'space',
                    'thing_id',
                    'collection_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'space':
                        (str,),
                    'thing_id':
                        (str,),
                    'collection_name':
                        (str,),
                },
                'attribute_map': {
                    'space': 'space',
                    'thing_id': 'thing-id',
                    'collection_name': 'collection-name',
                },
                'location_map': {
                    'space': 'path',
                    'thing_id': 'path',
                    'collection_name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__reset_spaces_collections_things_client_secret
        )

        def __show_accounts_thing(
            self,
            account_id,
            thing_id,
            **kwargs
        ):
            """Show thing  # noqa: E501

            Show the thing description from a thing  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.show_accounts_thing(account_id, thing_id, async_req=True)
            >>> result = thread.get()

            Args:
                account_id (str):
                thing_id (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ThingResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['account_id'] = \
                account_id
            kwargs['thing_id'] = \
                thing_id
            return self.call_with_http_info(**kwargs)

        self.show_accounts_thing = _Endpoint(
            settings={
                'response_type': (ThingResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/accounts/{account-id}/things/{thing-id}',
                'operation_id': 'show_accounts_thing',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'thing_id',
                ],
                'required': [
                    'account_id',
                    'thing_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'thing_id':
                        (str,),
                },
                'attribute_map': {
                    'account_id': 'account-id',
                    'thing_id': 'thing-id',
                },
                'location_map': {
                    'account_id': 'path',
                    'thing_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__show_accounts_thing
        )

        def __show_exports_mqtt_publishers_publisher_thing_mapping(
            self,
            publisher_id,
            thing_id,
            **kwargs
        ):
            """Show Publisher to Thing mapping  # noqa: E501

            Show of publisher to thing mapping  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.show_exports_mqtt_publishers_publisher_thing_mapping(publisher_id, thing_id, async_req=True)
            >>> result = thread.get()

            Args:
                publisher_id (str):
                thing_id (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                PublisherThingMappingObject
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['publisher_id'] = \
                publisher_id
            kwargs['thing_id'] = \
                thing_id
            return self.call_with_http_info(**kwargs)

        self.show_exports_mqtt_publishers_publisher_thing_mapping = _Endpoint(
            settings={
                'response_type': (PublisherThingMappingObject,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/exports/mqtt/publishers/{publisher_id}/things/{thing_id}',
                'operation_id': 'show_exports_mqtt_publishers_publisher_thing_mapping',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'publisher_id',
                    'thing_id',
                ],
                'required': [
                    'publisher_id',
                    'thing_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'publisher_id':
                        (str,),
                    'thing_id':
                        (str,),
                },
                'attribute_map': {
                    'publisher_id': 'publisher_id',
                    'thing_id': 'thing_id',
                },
                'location_map': {
                    'publisher_id': 'path',
                    'thing_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__show_exports_mqtt_publishers_publisher_thing_mapping
        )

        def __show_spaces_collections_thing(
            self,
            space,
            collection_name,
            thing_id,
            **kwargs
        ):
            """Show thing  # noqa: E501

            Show the thing description from a thing  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.show_spaces_collections_thing(space, collection_name, thing_id, async_req=True)
            >>> result = thread.get()

            Args:
                space (str):
                collection_name (str):
                thing_id (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ThingResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['space'] = \
                space
            kwargs['collection_name'] = \
                collection_name
            kwargs['thing_id'] = \
                thing_id
            return self.call_with_http_info(**kwargs)

        self.show_spaces_collections_thing = _Endpoint(
            settings={
                'response_type': (ThingResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/spaces/{space}/collections/{collection-name}/things/{thing-id}',
                'operation_id': 'show_spaces_collections_thing',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'space',
                    'collection_name',
                    'thing_id',
                ],
                'required': [
                    'space',
                    'collection_name',
                    'thing_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'space':
                        (str,),
                    'collection_name':
                        (str,),
                    'thing_id':
                        (str,),
                },
                'attribute_map': {
                    'space': 'space',
                    'collection_name': 'collection-name',
                    'thing_id': 'thing-id',
                },
                'location_map': {
                    'space': 'path',
                    'collection_name': 'path',
                    'thing_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__show_spaces_collections_thing
        )

        def __update_accounts_thing(
            self,
            account_id,
            thing_id,
            thing_update_request,
            **kwargs
        ):
            """Update thing description  # noqa: E501

            Update the thing description from a thing by Id. You need to include the whole thing description with the modifications to update it.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_accounts_thing(account_id, thing_id, thing_update_request, async_req=True)
            >>> result = thread.get()

            Args:
                account_id (str):
                thing_id (str):
                thing_update_request (ThingUpdateRequest): Update an existent thing description by Id

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ThingUpdateResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['account_id'] = \
                account_id
            kwargs['thing_id'] = \
                thing_id
            kwargs['thing_update_request'] = \
                thing_update_request
            return self.call_with_http_info(**kwargs)

        self.update_accounts_thing = _Endpoint(
            settings={
                'response_type': (ThingUpdateResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/accounts/{account-id}/things/{thing-id}',
                'operation_id': 'update_accounts_thing',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'thing_id',
                    'thing_update_request',
                ],
                'required': [
                    'account_id',
                    'thing_id',
                    'thing_update_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'thing_id':
                        (str,),
                    'thing_update_request':
                        (ThingUpdateRequest,),
                },
                'attribute_map': {
                    'account_id': 'account-id',
                    'thing_id': 'thing-id',
                },
                'location_map': {
                    'account_id': 'path',
                    'thing_id': 'path',
                    'thing_update_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_accounts_thing
        )

        def __update_spaces_collections_thing(
            self,
            space,
            collection_name,
            thing_id,
            thing_update_request,
            **kwargs
        ):
            """Update thing description  # noqa: E501

            Update the thing description from a thing by Id. You need to include the whole thing description with the modifications to update it.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_spaces_collections_thing(space, collection_name, thing_id, thing_update_request, async_req=True)
            >>> result = thread.get()

            Args:
                space (str):
                collection_name (str):
                thing_id (str):
                thing_update_request (ThingUpdateRequest): Update an existent thing description by Id

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ThingUpdateResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['space'] = \
                space
            kwargs['collection_name'] = \
                collection_name
            kwargs['thing_id'] = \
                thing_id
            kwargs['thing_update_request'] = \
                thing_update_request
            return self.call_with_http_info(**kwargs)

        self.update_spaces_collections_thing = _Endpoint(
            settings={
                'response_type': (ThingUpdateResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/spaces/{space}/collections/{collection-name}/things/{thing-id}',
                'operation_id': 'update_spaces_collections_thing',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'space',
                    'collection_name',
                    'thing_id',
                    'thing_update_request',
                ],
                'required': [
                    'space',
                    'collection_name',
                    'thing_id',
                    'thing_update_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'space':
                        (str,),
                    'collection_name':
                        (str,),
                    'thing_id':
                        (str,),
                    'thing_update_request':
                        (ThingUpdateRequest,),
                },
                'attribute_map': {
                    'space': 'space',
                    'collection_name': 'collection-name',
                    'thing_id': 'thing-id',
                },
                'location_map': {
                    'space': 'path',
                    'collection_name': 'path',
                    'thing_id': 'path',
                    'thing_update_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_spaces_collections_thing
        )
