import { CodeDeployClient } from "../CodeDeployClient";
import { ListApplicationsCommand, } from "../commands/ListApplicationsCommand";
const makePagedClientRequest = async (client, input, ...args) => {
    return await client.send(new ListApplicationsCommand(input), ...args);
};
export async function* paginateListApplications(config, input, ...additionalArguments) {
    let token = config.startingToken || undefined;
    let hasNext = true;
    let page;
    while (hasNext) {
        input.nextToken = token;
        if (config.client instanceof CodeDeployClient) {
            page = await makePagedClientRequest(config.client, input, ...additionalArguments);
        }
        else {
            throw new Error("Invalid client, expected CodeDeploy | CodeDeployClient");
        }
        yield page;
        const prevToken = token;
        token = page.nextToken;
        hasNext = !!(token && (!config.stopOnSameToken || token !== prevToken));
    }
    return undefined;
}
