import { getEndpointPlugin } from "@aws-sdk/middleware-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ListDeploymentConfigsInputFilterSensitiveLog, ListDeploymentConfigsOutputFilterSensitiveLog, } from "../models/models_0";
import { deserializeAws_json1_1ListDeploymentConfigsCommand, serializeAws_json1_1ListDeploymentConfigsCommand, } from "../protocols/Aws_json1_1";
export class ListDeploymentConfigsCommand extends $Command {
    constructor(input) {
        super();
        this.input = input;
    }
    static getEndpointParameterInstructions() {
        return {
            UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
            Endpoint: { type: "builtInParams", name: "endpoint" },
            Region: { type: "builtInParams", name: "region" },
            UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" },
        };
    }
    resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getEndpointPlugin(configuration, ListDeploymentConfigsCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "CodeDeployClient";
        const commandName = "ListDeploymentConfigsCommand";
        const handlerExecutionContext = {
            logger,
            clientName,
            commandName,
            inputFilterSensitiveLog: ListDeploymentConfigsInputFilterSensitiveLog,
            outputFilterSensitiveLog: ListDeploymentConfigsOutputFilterSensitiveLog,
        };
        const { requestHandler } = configuration;
        return stack.resolve((request) => requestHandler.handle(request.request, options || {}), handlerExecutionContext);
    }
    serialize(input, context) {
        return serializeAws_json1_1ListDeploymentConfigsCommand(input, context);
    }
    deserialize(output, context) {
        return deserializeAws_json1_1ListDeploymentConfigsCommand(output, context);
    }
}
