"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.paginateListDeploymentConfigs = void 0;
const CodeDeployClient_1 = require("../CodeDeployClient");
const ListDeploymentConfigsCommand_1 = require("../commands/ListDeploymentConfigsCommand");
const makePagedClientRequest = async (client, input, ...args) => {
    return await client.send(new ListDeploymentConfigsCommand_1.ListDeploymentConfigsCommand(input), ...args);
};
async function* paginateListDeploymentConfigs(config, input, ...additionalArguments) {
    let token = config.startingToken || undefined;
    let hasNext = true;
    let page;
    while (hasNext) {
        input.nextToken = token;
        if (config.client instanceof CodeDeployClient_1.CodeDeployClient) {
            page = await makePagedClientRequest(config.client, input, ...additionalArguments);
        }
        else {
            throw new Error("Invalid client, expected CodeDeploy | CodeDeployClient");
        }
        yield page;
        const prevToken = token;
        token = page.nextToken;
        hasNext = !!(token && (!config.stopOnSameToken || token !== prevToken));
    }
    return undefined;
}
exports.paginateListDeploymentConfigs = paginateListDeploymentConfigs;
