"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.paginateListApplications = void 0;
const CodeDeployClient_1 = require("../CodeDeployClient");
const ListApplicationsCommand_1 = require("../commands/ListApplicationsCommand");
const makePagedClientRequest = async (client, input, ...args) => {
    return await client.send(new ListApplicationsCommand_1.ListApplicationsCommand(input), ...args);
};
async function* paginateListApplications(config, input, ...additionalArguments) {
    let token = config.startingToken || undefined;
    let hasNext = true;
    let page;
    while (hasNext) {
        input.nextToken = token;
        if (config.client instanceof CodeDeployClient_1.CodeDeployClient) {
            page = await makePagedClientRequest(config.client, input, ...additionalArguments);
        }
        else {
            throw new Error("Invalid client, expected CodeDeploy | CodeDeployClient");
        }
        yield page;
        const prevToken = token;
        token = page.nextToken;
        hasNext = !!(token && (!config.stopOnSameToken || token !== prevToken));
    }
    return undefined;
}
exports.paginateListApplications = paginateListApplications;
