# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel


class AddVpcHoneyPotRequest(TeaModel):
    def __init__(self, vpc_id=None, vpc_switch_id=None):
        self.vpc_id = vpc_id  # type: str
        self.vpc_switch_id = vpc_switch_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddVpcHoneyPotRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.vpc_switch_id is not None:
            result['VpcSwitchId'] = self.vpc_switch_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('VpcSwitchId') is not None:
            self.vpc_switch_id = m.get('VpcSwitchId')
        return self


class AddVpcHoneyPotResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddVpcHoneyPotResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddVpcHoneyPotResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: AddVpcHoneyPotResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddVpcHoneyPotResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddVpcHoneyPotResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckSecurityEventIdRequest(TeaModel):
    def __init__(self, security_event_ids=None, uuid=None):
        self.security_event_ids = security_event_ids  # type: list[str]
        self.uuid = uuid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CheckSecurityEventIdRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.security_event_ids is not None:
            result['SecurityEventIds'] = self.security_event_ids
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SecurityEventIds') is not None:
            self.security_event_ids = m.get('SecurityEventIds')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class CheckSecurityEventIdResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        self.data = data  # type: bool
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CheckSecurityEventIdResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CheckSecurityEventIdResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CheckSecurityEventIdResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CheckSecurityEventIdResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CheckSecurityEventIdResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateAntiBruteForceRuleRequest(TeaModel):
    def __init__(self, default_rule=None, fail_count=None, forbidden_time=None, name=None, resource_owner_id=None,
                 source_ip=None, span=None, uuid_list=None):
        self.default_rule = default_rule  # type: bool
        self.fail_count = fail_count  # type: int
        self.forbidden_time = forbidden_time  # type: int
        self.name = name  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.source_ip = source_ip  # type: str
        self.span = span  # type: int
        self.uuid_list = uuid_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateAntiBruteForceRuleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.default_rule is not None:
            result['DefaultRule'] = self.default_rule
        if self.fail_count is not None:
            result['FailCount'] = self.fail_count
        if self.forbidden_time is not None:
            result['ForbiddenTime'] = self.forbidden_time
        if self.name is not None:
            result['Name'] = self.name
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.span is not None:
            result['Span'] = self.span
        if self.uuid_list is not None:
            result['UuidList'] = self.uuid_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DefaultRule') is not None:
            self.default_rule = m.get('DefaultRule')
        if m.get('FailCount') is not None:
            self.fail_count = m.get('FailCount')
        if m.get('ForbiddenTime') is not None:
            self.forbidden_time = m.get('ForbiddenTime')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Span') is not None:
            self.span = m.get('Span')
        if m.get('UuidList') is not None:
            self.uuid_list = m.get('UuidList')
        return self


class CreateAntiBruteForceRuleResponseBodyCreateAntiBruteForceRule(TeaModel):
    def __init__(self, rule_id=None):
        self.rule_id = rule_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateAntiBruteForceRuleResponseBodyCreateAntiBruteForceRule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class CreateAntiBruteForceRuleResponseBody(TeaModel):
    def __init__(self, create_anti_brute_force_rule=None, request_id=None):
        self.create_anti_brute_force_rule = create_anti_brute_force_rule  # type: CreateAntiBruteForceRuleResponseBodyCreateAntiBruteForceRule
        self.request_id = request_id  # type: str

    def validate(self):
        if self.create_anti_brute_force_rule:
            self.create_anti_brute_force_rule.validate()

    def to_map(self):
        _map = super(CreateAntiBruteForceRuleResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_anti_brute_force_rule is not None:
            result['CreateAntiBruteForceRule'] = self.create_anti_brute_force_rule.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreateAntiBruteForceRule') is not None:
            temp_model = CreateAntiBruteForceRuleResponseBodyCreateAntiBruteForceRule()
            self.create_anti_brute_force_rule = temp_model.from_map(m['CreateAntiBruteForceRule'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateAntiBruteForceRuleResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateAntiBruteForceRuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateAntiBruteForceRuleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateAntiBruteForceRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateBackupPolicyRequest(TeaModel):
    def __init__(self, name=None, policy=None, policy_region_id=None, policy_version=None, uuid_list=None):
        self.name = name  # type: str
        self.policy = policy  # type: dict[str, any]
        self.policy_region_id = policy_region_id  # type: str
        self.policy_version = policy_version  # type: str
        self.uuid_list = uuid_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateBackupPolicyRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.policy_region_id is not None:
            result['PolicyRegionId'] = self.policy_region_id
        if self.policy_version is not None:
            result['PolicyVersion'] = self.policy_version
        if self.uuid_list is not None:
            result['UuidList'] = self.uuid_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('PolicyRegionId') is not None:
            self.policy_region_id = m.get('PolicyRegionId')
        if m.get('PolicyVersion') is not None:
            self.policy_version = m.get('PolicyVersion')
        if m.get('UuidList') is not None:
            self.uuid_list = m.get('UuidList')
        return self


class CreateBackupPolicyShrinkRequest(TeaModel):
    def __init__(self, name=None, policy_shrink=None, policy_region_id=None, policy_version=None, uuid_list=None):
        self.name = name  # type: str
        self.policy_shrink = policy_shrink  # type: str
        self.policy_region_id = policy_region_id  # type: str
        self.policy_version = policy_version  # type: str
        self.uuid_list = uuid_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateBackupPolicyShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.policy_shrink is not None:
            result['Policy'] = self.policy_shrink
        if self.policy_region_id is not None:
            result['PolicyRegionId'] = self.policy_region_id
        if self.policy_version is not None:
            result['PolicyVersion'] = self.policy_version
        if self.uuid_list is not None:
            result['UuidList'] = self.uuid_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Policy') is not None:
            self.policy_shrink = m.get('Policy')
        if m.get('PolicyRegionId') is not None:
            self.policy_region_id = m.get('PolicyRegionId')
        if m.get('PolicyVersion') is not None:
            self.policy_version = m.get('PolicyVersion')
        if m.get('UuidList') is not None:
            self.uuid_list = m.get('UuidList')
        return self


class CreateBackupPolicyResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateBackupPolicyResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateBackupPolicyResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateBackupPolicyResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateBackupPolicyResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateBackupPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOrUpdateAssetGroupRequest(TeaModel):
    def __init__(self, group_id=None, group_name=None, uuids=None):
        self.group_id = group_id  # type: long
        self.group_name = group_name  # type: str
        self.uuids = uuids  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateOrUpdateAssetGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.uuids is not None:
            result['Uuids'] = self.uuids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('Uuids') is not None:
            self.uuids = m.get('Uuids')
        return self


class CreateOrUpdateAssetGroupResponseBody(TeaModel):
    def __init__(self, group_id=None, request_id=None):
        self.group_id = group_id  # type: long
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateOrUpdateAssetGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateOrUpdateAssetGroupResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateOrUpdateAssetGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateOrUpdateAssetGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateOrUpdateAssetGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateServiceLinkedRoleResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateServiceLinkedRoleResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateServiceLinkedRoleResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateServiceLinkedRoleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateServiceLinkedRoleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateServiceLinkedRoleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSimilarSecurityEventsQueryTaskRequest(TeaModel):
    def __init__(self, resource_owner_id=None, security_event_id=None, similar_event_scenario_code=None,
                 source_ip=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.security_event_id = security_event_id  # type: long
        self.similar_event_scenario_code = similar_event_scenario_code  # type: str
        self.source_ip = source_ip  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateSimilarSecurityEventsQueryTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.security_event_id is not None:
            result['SecurityEventId'] = self.security_event_id
        if self.similar_event_scenario_code is not None:
            result['SimilarEventScenarioCode'] = self.similar_event_scenario_code
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SecurityEventId') is not None:
            self.security_event_id = m.get('SecurityEventId')
        if m.get('SimilarEventScenarioCode') is not None:
            self.similar_event_scenario_code = m.get('SimilarEventScenarioCode')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class CreateSimilarSecurityEventsQueryTaskResponseBodyCreateSimilarSecurityEventsQueryTaskResponse(TeaModel):
    def __init__(self, status=None, task_id=None):
        self.status = status  # type: str
        self.task_id = task_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateSimilarSecurityEventsQueryTaskResponseBodyCreateSimilarSecurityEventsQueryTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class CreateSimilarSecurityEventsQueryTaskResponseBody(TeaModel):
    def __init__(self, create_similar_security_events_query_task_response=None, request_id=None):
        self.create_similar_security_events_query_task_response = create_similar_security_events_query_task_response  # type: CreateSimilarSecurityEventsQueryTaskResponseBodyCreateSimilarSecurityEventsQueryTaskResponse
        self.request_id = request_id  # type: str

    def validate(self):
        if self.create_similar_security_events_query_task_response:
            self.create_similar_security_events_query_task_response.validate()

    def to_map(self):
        _map = super(CreateSimilarSecurityEventsQueryTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_similar_security_events_query_task_response is not None:
            result['CreateSimilarSecurityEventsQueryTaskResponse'] = self.create_similar_security_events_query_task_response.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreateSimilarSecurityEventsQueryTaskResponse') is not None:
            temp_model = CreateSimilarSecurityEventsQueryTaskResponseBodyCreateSimilarSecurityEventsQueryTaskResponse()
            self.create_similar_security_events_query_task_response = temp_model.from_map(m['CreateSimilarSecurityEventsQueryTaskResponse'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateSimilarSecurityEventsQueryTaskResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateSimilarSecurityEventsQueryTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateSimilarSecurityEventsQueryTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateSimilarSecurityEventsQueryTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteBackupPolicyRequest(TeaModel):
    def __init__(self, id=None, policy_version=None):
        self.id = id  # type: long
        self.policy_version = policy_version  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteBackupPolicyRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.policy_version is not None:
            result['PolicyVersion'] = self.policy_version
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('PolicyVersion') is not None:
            self.policy_version = m.get('PolicyVersion')
        return self


class DeleteBackupPolicyResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteBackupPolicyResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteBackupPolicyResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeleteBackupPolicyResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteBackupPolicyResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteBackupPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteBackupPolicyMachineRequest(TeaModel):
    def __init__(self, policy_id=None, policy_version=None, uuid=None, uuid_list=None):
        self.policy_id = policy_id  # type: long
        self.policy_version = policy_version  # type: str
        self.uuid = uuid  # type: str
        self.uuid_list = uuid_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteBackupPolicyMachineRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        if self.policy_version is not None:
            result['PolicyVersion'] = self.policy_version
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.uuid_list is not None:
            result['UuidList'] = self.uuid_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        if m.get('PolicyVersion') is not None:
            self.policy_version = m.get('PolicyVersion')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('UuidList') is not None:
            self.uuid_list = m.get('UuidList')
        return self


class DeleteBackupPolicyMachineResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteBackupPolicyMachineResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteBackupPolicyMachineResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeleteBackupPolicyMachineResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteBackupPolicyMachineResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteBackupPolicyMachineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteGroupRequest(TeaModel):
    def __init__(self, group_id=None, source_ip=None):
        self.group_id = group_id  # type: long
        self.source_ip = source_ip  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DeleteGroupResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteGroupResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeleteGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLoginBaseConfigRequest(TeaModel):
    def __init__(self, config=None, target=None, type=None):
        self.config = config  # type: str
        self.target = target  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLoginBaseConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config is not None:
            result['Config'] = self.config
        if self.target is not None:
            result['Target'] = self.target
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Config') is not None:
            self.config = m.get('Config')
        if m.get('Target') is not None:
            self.target = m.get('Target')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DeleteLoginBaseConfigResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLoginBaseConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLoginBaseConfigResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeleteLoginBaseConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteLoginBaseConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteLoginBaseConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteStrategyRequest(TeaModel):
    def __init__(self, id=None, lang=None, source_ip=None):
        self.id = id  # type: str
        self.lang = lang  # type: str
        self.source_ip = source_ip  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteStrategyRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DeleteStrategyResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteStrategyResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteStrategyResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeleteStrategyResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteStrategyResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteStrategyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteTagWithUuidRequest(TeaModel):
    def __init__(self, tag_name=None, uuid_list=None):
        self.tag_name = tag_name  # type: str
        self.uuid_list = uuid_list  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteTagWithUuidRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_name is not None:
            result['TagName'] = self.tag_name
        if self.uuid_list is not None:
            result['UuidList'] = self.uuid_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TagName') is not None:
            self.tag_name = m.get('TagName')
        if m.get('UuidList') is not None:
            self.uuid_list = m.get('UuidList')
        return self


class DeleteTagWithUuidResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteTagWithUuidResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteTagWithUuidResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeleteTagWithUuidResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteTagWithUuidResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteTagWithUuidResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteVpcHoneyPotRequest(TeaModel):
    def __init__(self, vpc_id=None):
        self.vpc_id = vpc_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteVpcHoneyPotRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class DeleteVpcHoneyPotResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteVpcHoneyPotResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteVpcHoneyPotResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeleteVpcHoneyPotResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteVpcHoneyPotResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteVpcHoneyPotResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAccesskeyLeakListRequest(TeaModel):
    def __init__(self, current_page=None, page_size=None, query=None, start_ts=None, status=None):
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.query = query  # type: str
        self.start_ts = start_ts  # type: long
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAccesskeyLeakListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.query is not None:
            result['Query'] = self.query
        if self.start_ts is not None:
            result['StartTs'] = self.start_ts
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Query') is not None:
            self.query = m.get('Query')
        if m.get('StartTs') is not None:
            self.start_ts = m.get('StartTs')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeAccesskeyLeakListResponseBodyAccessKeyLeakList(TeaModel):
    def __init__(self, accesskey_id=None, ali_user_name=None, asset=None, deal_time=None, deal_type=None,
                 gmt_modified=None, id=None, status=None, type=None, url=None, user_type=None):
        self.accesskey_id = accesskey_id  # type: str
        self.ali_user_name = ali_user_name  # type: str
        self.asset = asset  # type: str
        self.deal_time = deal_time  # type: str
        self.deal_type = deal_type  # type: str
        self.gmt_modified = gmt_modified  # type: long
        self.id = id  # type: long
        self.status = status  # type: str
        self.type = type  # type: str
        self.url = url  # type: str
        self.user_type = user_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAccesskeyLeakListResponseBodyAccessKeyLeakList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accesskey_id is not None:
            result['AccesskeyId'] = self.accesskey_id
        if self.ali_user_name is not None:
            result['AliUserName'] = self.ali_user_name
        if self.asset is not None:
            result['Asset'] = self.asset
        if self.deal_time is not None:
            result['DealTime'] = self.deal_time
        if self.deal_type is not None:
            result['DealType'] = self.deal_type
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.id is not None:
            result['Id'] = self.id
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.url is not None:
            result['Url'] = self.url
        if self.user_type is not None:
            result['UserType'] = self.user_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccesskeyId') is not None:
            self.accesskey_id = m.get('AccesskeyId')
        if m.get('AliUserName') is not None:
            self.ali_user_name = m.get('AliUserName')
        if m.get('Asset') is not None:
            self.asset = m.get('Asset')
        if m.get('DealTime') is not None:
            self.deal_time = m.get('DealTime')
        if m.get('DealType') is not None:
            self.deal_type = m.get('DealType')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        if m.get('UserType') is not None:
            self.user_type = m.get('UserType')
        return self


class DescribeAccesskeyLeakListResponseBody(TeaModel):
    def __init__(self, access_key_leak_list=None, ak_leak_count=None, current_page=None, gmt_last=None,
                 page_size=None, request_id=None, total_count=None):
        self.access_key_leak_list = access_key_leak_list  # type: list[DescribeAccesskeyLeakListResponseBodyAccessKeyLeakList]
        self.ak_leak_count = ak_leak_count  # type: int
        self.current_page = current_page  # type: int
        self.gmt_last = gmt_last  # type: long
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: int

    def validate(self):
        if self.access_key_leak_list:
            for k in self.access_key_leak_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAccesskeyLeakListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AccessKeyLeakList'] = []
        if self.access_key_leak_list is not None:
            for k in self.access_key_leak_list:
                result['AccessKeyLeakList'].append(k.to_map() if k else None)
        if self.ak_leak_count is not None:
            result['AkLeakCount'] = self.ak_leak_count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.gmt_last is not None:
            result['GmtLast'] = self.gmt_last
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.access_key_leak_list = []
        if m.get('AccessKeyLeakList') is not None:
            for k in m.get('AccessKeyLeakList'):
                temp_model = DescribeAccesskeyLeakListResponseBodyAccessKeyLeakList()
                self.access_key_leak_list.append(temp_model.from_map(k))
        if m.get('AkLeakCount') is not None:
            self.ak_leak_count = m.get('AkLeakCount')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('GmtLast') is not None:
            self.gmt_last = m.get('GmtLast')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeAccesskeyLeakListResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeAccesskeyLeakListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeAccesskeyLeakListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeAccesskeyLeakListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAffectedMaliciousFileImagesRequest(TeaModel):
    def __init__(self, current_page=None, image_digest=None, image_layer=None, image_tag=None, lang=None,
                 malicious_md_5=None, page_size=None, repo_id=None, repo_instance_id=None, repo_name=None, repo_namespace=None,
                 repo_region_id=None):
        self.current_page = current_page  # type: int
        self.image_digest = image_digest  # type: str
        self.image_layer = image_layer  # type: str
        self.image_tag = image_tag  # type: str
        self.lang = lang  # type: str
        self.malicious_md_5 = malicious_md_5  # type: str
        self.page_size = page_size  # type: str
        self.repo_id = repo_id  # type: str
        self.repo_instance_id = repo_instance_id  # type: str
        self.repo_name = repo_name  # type: str
        self.repo_namespace = repo_namespace  # type: str
        self.repo_region_id = repo_region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAffectedMaliciousFileImagesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.image_digest is not None:
            result['ImageDigest'] = self.image_digest
        if self.image_layer is not None:
            result['ImageLayer'] = self.image_layer
        if self.image_tag is not None:
            result['ImageTag'] = self.image_tag
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.malicious_md_5 is not None:
            result['MaliciousMd5'] = self.malicious_md_5
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.repo_id is not None:
            result['RepoId'] = self.repo_id
        if self.repo_instance_id is not None:
            result['RepoInstanceId'] = self.repo_instance_id
        if self.repo_name is not None:
            result['RepoName'] = self.repo_name
        if self.repo_namespace is not None:
            result['RepoNamespace'] = self.repo_namespace
        if self.repo_region_id is not None:
            result['RepoRegionId'] = self.repo_region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('ImageDigest') is not None:
            self.image_digest = m.get('ImageDigest')
        if m.get('ImageLayer') is not None:
            self.image_layer = m.get('ImageLayer')
        if m.get('ImageTag') is not None:
            self.image_tag = m.get('ImageTag')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('MaliciousMd5') is not None:
            self.malicious_md_5 = m.get('MaliciousMd5')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RepoId') is not None:
            self.repo_id = m.get('RepoId')
        if m.get('RepoInstanceId') is not None:
            self.repo_instance_id = m.get('RepoInstanceId')
        if m.get('RepoName') is not None:
            self.repo_name = m.get('RepoName')
        if m.get('RepoNamespace') is not None:
            self.repo_namespace = m.get('RepoNamespace')
        if m.get('RepoRegionId') is not None:
            self.repo_region_id = m.get('RepoRegionId')
        return self


class DescribeAffectedMaliciousFileImagesResponseBodyAffectedMaliciousFileImagesResponse(TeaModel):
    def __init__(self, digest=None, file_path=None, first_scan_timestamp=None, image_uuid=None,
                 latest_scan_timestamp=None, latest_verify_timestamp=None, layer=None, level=None, malicious_md_5=None, namespace=None,
                 repo_id=None, repo_instance_id=None, repo_name=None, repo_region_id=None, status=None, tag=None):
        self.digest = digest  # type: str
        self.file_path = file_path  # type: str
        self.first_scan_timestamp = first_scan_timestamp  # type: long
        self.image_uuid = image_uuid  # type: str
        self.latest_scan_timestamp = latest_scan_timestamp  # type: long
        self.latest_verify_timestamp = latest_verify_timestamp  # type: long
        self.layer = layer  # type: str
        self.level = level  # type: str
        self.malicious_md_5 = malicious_md_5  # type: str
        self.namespace = namespace  # type: str
        self.repo_id = repo_id  # type: str
        self.repo_instance_id = repo_instance_id  # type: str
        self.repo_name = repo_name  # type: str
        self.repo_region_id = repo_region_id  # type: str
        self.status = status  # type: int
        self.tag = tag  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAffectedMaliciousFileImagesResponseBodyAffectedMaliciousFileImagesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.digest is not None:
            result['Digest'] = self.digest
        if self.file_path is not None:
            result['FilePath'] = self.file_path
        if self.first_scan_timestamp is not None:
            result['FirstScanTimestamp'] = self.first_scan_timestamp
        if self.image_uuid is not None:
            result['ImageUuid'] = self.image_uuid
        if self.latest_scan_timestamp is not None:
            result['LatestScanTimestamp'] = self.latest_scan_timestamp
        if self.latest_verify_timestamp is not None:
            result['LatestVerifyTimestamp'] = self.latest_verify_timestamp
        if self.layer is not None:
            result['Layer'] = self.layer
        if self.level is not None:
            result['Level'] = self.level
        if self.malicious_md_5 is not None:
            result['MaliciousMd5'] = self.malicious_md_5
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.repo_id is not None:
            result['RepoId'] = self.repo_id
        if self.repo_instance_id is not None:
            result['RepoInstanceId'] = self.repo_instance_id
        if self.repo_name is not None:
            result['RepoName'] = self.repo_name
        if self.repo_region_id is not None:
            result['RepoRegionId'] = self.repo_region_id
        if self.status is not None:
            result['Status'] = self.status
        if self.tag is not None:
            result['Tag'] = self.tag
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Digest') is not None:
            self.digest = m.get('Digest')
        if m.get('FilePath') is not None:
            self.file_path = m.get('FilePath')
        if m.get('FirstScanTimestamp') is not None:
            self.first_scan_timestamp = m.get('FirstScanTimestamp')
        if m.get('ImageUuid') is not None:
            self.image_uuid = m.get('ImageUuid')
        if m.get('LatestScanTimestamp') is not None:
            self.latest_scan_timestamp = m.get('LatestScanTimestamp')
        if m.get('LatestVerifyTimestamp') is not None:
            self.latest_verify_timestamp = m.get('LatestVerifyTimestamp')
        if m.get('Layer') is not None:
            self.layer = m.get('Layer')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('MaliciousMd5') is not None:
            self.malicious_md_5 = m.get('MaliciousMd5')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('RepoId') is not None:
            self.repo_id = m.get('RepoId')
        if m.get('RepoInstanceId') is not None:
            self.repo_instance_id = m.get('RepoInstanceId')
        if m.get('RepoName') is not None:
            self.repo_name = m.get('RepoName')
        if m.get('RepoRegionId') is not None:
            self.repo_region_id = m.get('RepoRegionId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        return self


class DescribeAffectedMaliciousFileImagesResponseBodyPageInfo(TeaModel):
    def __init__(self, count=None, current_page=None, page_size=None, total_count=None):
        self.count = count  # type: int
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAffectedMaliciousFileImagesResponseBodyPageInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeAffectedMaliciousFileImagesResponseBody(TeaModel):
    def __init__(self, affected_malicious_file_images_response=None, page_info=None, request_id=None):
        self.affected_malicious_file_images_response = affected_malicious_file_images_response  # type: list[DescribeAffectedMaliciousFileImagesResponseBodyAffectedMaliciousFileImagesResponse]
        self.page_info = page_info  # type: DescribeAffectedMaliciousFileImagesResponseBodyPageInfo
        self.request_id = request_id  # type: str

    def validate(self):
        if self.affected_malicious_file_images_response:
            for k in self.affected_malicious_file_images_response:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super(DescribeAffectedMaliciousFileImagesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AffectedMaliciousFileImagesResponse'] = []
        if self.affected_malicious_file_images_response is not None:
            for k in self.affected_malicious_file_images_response:
                result['AffectedMaliciousFileImagesResponse'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.affected_malicious_file_images_response = []
        if m.get('AffectedMaliciousFileImagesResponse') is not None:
            for k in m.get('AffectedMaliciousFileImagesResponse'):
                temp_model = DescribeAffectedMaliciousFileImagesResponseBodyAffectedMaliciousFileImagesResponse()
                self.affected_malicious_file_images_response.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeAffectedMaliciousFileImagesResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAffectedMaliciousFileImagesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeAffectedMaliciousFileImagesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeAffectedMaliciousFileImagesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeAffectedMaliciousFileImagesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAlarmEventDetailRequest(TeaModel):
    def __init__(self, alarm_unique_info=None, from_=None, lang=None, source_ip=None):
        self.alarm_unique_info = alarm_unique_info  # type: str
        self.from_ = from_  # type: str
        self.lang = lang  # type: str
        self.source_ip = source_ip  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAlarmEventDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_unique_info is not None:
            result['AlarmUniqueInfo'] = self.alarm_unique_info
        if self.from_ is not None:
            result['From'] = self.from_
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlarmUniqueInfo') is not None:
            self.alarm_unique_info = m.get('AlarmUniqueInfo')
        if m.get('From') is not None:
            self.from_ = m.get('From')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeAlarmEventDetailResponseBodyDataCauseDetailsValue(TeaModel):
    def __init__(self, name=None, type=None, value=None):
        self.name = name  # type: str
        self.type = type  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAlarmEventDetailResponseBodyDataCauseDetailsValue, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeAlarmEventDetailResponseBodyDataCauseDetails(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: list[DescribeAlarmEventDetailResponseBodyDataCauseDetailsValue]

    def validate(self):
        if self.value:
            for k in self.value:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAlarmEventDetailResponseBodyDataCauseDetails, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        result['Value'] = []
        if self.value is not None:
            for k in self.value:
                result['Value'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        self.value = []
        if m.get('Value') is not None:
            for k in m.get('Value'):
                temp_model = DescribeAlarmEventDetailResponseBodyDataCauseDetailsValue()
                self.value.append(temp_model.from_map(k))
        return self


class DescribeAlarmEventDetailResponseBodyData(TeaModel):
    def __init__(self, alarm_event_alias_name=None, alarm_event_desc=None, alarm_unique_info=None, app_name=None,
                 can_be_deal_on_line=None, can_cancel_fault=None, cause_details=None, contain_hw_mode=None, container_id=None,
                 container_image_id=None, container_image_name=None, data_source=None, end_time=None, instance_name=None,
                 internet_ip=None, intranet_ip=None, k_8s_cluster_id=None, k_8s_cluster_name=None, k_8s_namespace=None,
                 k_8s_node_id=None, k_8s_node_name=None, k_8s_pod_name=None, level=None, solution=None, start_time=None,
                 type=None, uuid=None):
        self.alarm_event_alias_name = alarm_event_alias_name  # type: str
        self.alarm_event_desc = alarm_event_desc  # type: str
        self.alarm_unique_info = alarm_unique_info  # type: str
        self.app_name = app_name  # type: str
        self.can_be_deal_on_line = can_be_deal_on_line  # type: bool
        self.can_cancel_fault = can_cancel_fault  # type: bool
        self.cause_details = cause_details  # type: list[DescribeAlarmEventDetailResponseBodyDataCauseDetails]
        self.contain_hw_mode = contain_hw_mode  # type: bool
        self.container_id = container_id  # type: str
        self.container_image_id = container_image_id  # type: str
        self.container_image_name = container_image_name  # type: str
        self.data_source = data_source  # type: str
        self.end_time = end_time  # type: long
        self.instance_name = instance_name  # type: str
        self.internet_ip = internet_ip  # type: str
        self.intranet_ip = intranet_ip  # type: str
        self.k_8s_cluster_id = k_8s_cluster_id  # type: str
        self.k_8s_cluster_name = k_8s_cluster_name  # type: str
        self.k_8s_namespace = k_8s_namespace  # type: str
        self.k_8s_node_id = k_8s_node_id  # type: str
        self.k_8s_node_name = k_8s_node_name  # type: str
        self.k_8s_pod_name = k_8s_pod_name  # type: str
        self.level = level  # type: str
        self.solution = solution  # type: str
        self.start_time = start_time  # type: long
        self.type = type  # type: str
        self.uuid = uuid  # type: str

    def validate(self):
        if self.cause_details:
            for k in self.cause_details:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAlarmEventDetailResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_event_alias_name is not None:
            result['AlarmEventAliasName'] = self.alarm_event_alias_name
        if self.alarm_event_desc is not None:
            result['AlarmEventDesc'] = self.alarm_event_desc
        if self.alarm_unique_info is not None:
            result['AlarmUniqueInfo'] = self.alarm_unique_info
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.can_be_deal_on_line is not None:
            result['CanBeDealOnLine'] = self.can_be_deal_on_line
        if self.can_cancel_fault is not None:
            result['CanCancelFault'] = self.can_cancel_fault
        result['CauseDetails'] = []
        if self.cause_details is not None:
            for k in self.cause_details:
                result['CauseDetails'].append(k.to_map() if k else None)
        if self.contain_hw_mode is not None:
            result['ContainHwMode'] = self.contain_hw_mode
        if self.container_id is not None:
            result['ContainerId'] = self.container_id
        if self.container_image_id is not None:
            result['ContainerImageId'] = self.container_image_id
        if self.container_image_name is not None:
            result['ContainerImageName'] = self.container_image_name
        if self.data_source is not None:
            result['DataSource'] = self.data_source
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.k_8s_cluster_id is not None:
            result['K8sClusterId'] = self.k_8s_cluster_id
        if self.k_8s_cluster_name is not None:
            result['K8sClusterName'] = self.k_8s_cluster_name
        if self.k_8s_namespace is not None:
            result['K8sNamespace'] = self.k_8s_namespace
        if self.k_8s_node_id is not None:
            result['K8sNodeId'] = self.k_8s_node_id
        if self.k_8s_node_name is not None:
            result['K8sNodeName'] = self.k_8s_node_name
        if self.k_8s_pod_name is not None:
            result['K8sPodName'] = self.k_8s_pod_name
        if self.level is not None:
            result['Level'] = self.level
        if self.solution is not None:
            result['Solution'] = self.solution
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.type is not None:
            result['Type'] = self.type
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlarmEventAliasName') is not None:
            self.alarm_event_alias_name = m.get('AlarmEventAliasName')
        if m.get('AlarmEventDesc') is not None:
            self.alarm_event_desc = m.get('AlarmEventDesc')
        if m.get('AlarmUniqueInfo') is not None:
            self.alarm_unique_info = m.get('AlarmUniqueInfo')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('CanBeDealOnLine') is not None:
            self.can_be_deal_on_line = m.get('CanBeDealOnLine')
        if m.get('CanCancelFault') is not None:
            self.can_cancel_fault = m.get('CanCancelFault')
        self.cause_details = []
        if m.get('CauseDetails') is not None:
            for k in m.get('CauseDetails'):
                temp_model = DescribeAlarmEventDetailResponseBodyDataCauseDetails()
                self.cause_details.append(temp_model.from_map(k))
        if m.get('ContainHwMode') is not None:
            self.contain_hw_mode = m.get('ContainHwMode')
        if m.get('ContainerId') is not None:
            self.container_id = m.get('ContainerId')
        if m.get('ContainerImageId') is not None:
            self.container_image_id = m.get('ContainerImageId')
        if m.get('ContainerImageName') is not None:
            self.container_image_name = m.get('ContainerImageName')
        if m.get('DataSource') is not None:
            self.data_source = m.get('DataSource')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('K8sClusterId') is not None:
            self.k_8s_cluster_id = m.get('K8sClusterId')
        if m.get('K8sClusterName') is not None:
            self.k_8s_cluster_name = m.get('K8sClusterName')
        if m.get('K8sNamespace') is not None:
            self.k_8s_namespace = m.get('K8sNamespace')
        if m.get('K8sNodeId') is not None:
            self.k_8s_node_id = m.get('K8sNodeId')
        if m.get('K8sNodeName') is not None:
            self.k_8s_node_name = m.get('K8sNodeName')
        if m.get('K8sPodName') is not None:
            self.k_8s_pod_name = m.get('K8sPodName')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Solution') is not None:
            self.solution = m.get('Solution')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeAlarmEventDetailResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        self.data = data  # type: DescribeAlarmEventDetailResponseBodyData
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(DescribeAlarmEventDetailResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = DescribeAlarmEventDetailResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAlarmEventDetailResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeAlarmEventDetailResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeAlarmEventDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeAlarmEventDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAlarmEventListRequest(TeaModel):
    def __init__(self, alarm_event_name=None, alarm_event_type=None, current_page=None, dealed=None, from_=None,
                 group_id=None, lang=None, levels=None, operate_error_code_list=None, page_size=None, remark=None,
                 source_ip=None):
        self.alarm_event_name = alarm_event_name  # type: str
        self.alarm_event_type = alarm_event_type  # type: str
        self.current_page = current_page  # type: int
        self.dealed = dealed  # type: str
        self.from_ = from_  # type: str
        self.group_id = group_id  # type: str
        self.lang = lang  # type: str
        self.levels = levels  # type: str
        self.operate_error_code_list = operate_error_code_list  # type: list[str]
        self.page_size = page_size  # type: str
        self.remark = remark  # type: str
        self.source_ip = source_ip  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAlarmEventListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_event_name is not None:
            result['AlarmEventName'] = self.alarm_event_name
        if self.alarm_event_type is not None:
            result['AlarmEventType'] = self.alarm_event_type
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dealed is not None:
            result['Dealed'] = self.dealed
        if self.from_ is not None:
            result['From'] = self.from_
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.levels is not None:
            result['Levels'] = self.levels
        if self.operate_error_code_list is not None:
            result['OperateErrorCodeList'] = self.operate_error_code_list
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlarmEventName') is not None:
            self.alarm_event_name = m.get('AlarmEventName')
        if m.get('AlarmEventType') is not None:
            self.alarm_event_type = m.get('AlarmEventType')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Dealed') is not None:
            self.dealed = m.get('Dealed')
        if m.get('From') is not None:
            self.from_ = m.get('From')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Levels') is not None:
            self.levels = m.get('Levels')
        if m.get('OperateErrorCodeList') is not None:
            self.operate_error_code_list = m.get('OperateErrorCodeList')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeAlarmEventListResponseBodyPageInfo(TeaModel):
    def __init__(self, count=None, current_page=None, page_size=None, total_count=None):
        self.count = count  # type: int
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAlarmEventListResponseBodyPageInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeAlarmEventListResponseBodySuspEvents(TeaModel):
    def __init__(self, alarm_event_name=None, alarm_event_name_original=None, alarm_event_type=None,
                 alarm_unique_info=None, can_be_deal_on_line=None, can_cancel_fault=None, data_source=None, dealed=None,
                 description=None, end_time=None, gmt_modified=None, has_trace_info=None, instance_id=None, instance_name=None,
                 internet_ip=None, intranet_ip=None, level=None, operate_error_code=None, operate_time=None, sale_version=None,
                 security_event_ids=None, solution=None, stages=None, start_time=None, suspicious_event_count=None, uuid=None):
        self.alarm_event_name = alarm_event_name  # type: str
        self.alarm_event_name_original = alarm_event_name_original  # type: str
        self.alarm_event_type = alarm_event_type  # type: str
        self.alarm_unique_info = alarm_unique_info  # type: str
        self.can_be_deal_on_line = can_be_deal_on_line  # type: bool
        self.can_cancel_fault = can_cancel_fault  # type: bool
        self.data_source = data_source  # type: str
        self.dealed = dealed  # type: bool
        self.description = description  # type: str
        self.end_time = end_time  # type: long
        self.gmt_modified = gmt_modified  # type: long
        self.has_trace_info = has_trace_info  # type: bool
        self.instance_id = instance_id  # type: str
        self.instance_name = instance_name  # type: str
        self.internet_ip = internet_ip  # type: str
        self.intranet_ip = intranet_ip  # type: str
        self.level = level  # type: str
        self.operate_error_code = operate_error_code  # type: str
        self.operate_time = operate_time  # type: long
        self.sale_version = sale_version  # type: str
        self.security_event_ids = security_event_ids  # type: str
        self.solution = solution  # type: str
        self.stages = stages  # type: str
        self.start_time = start_time  # type: long
        self.suspicious_event_count = suspicious_event_count  # type: int
        self.uuid = uuid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAlarmEventListResponseBodySuspEvents, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_event_name is not None:
            result['AlarmEventName'] = self.alarm_event_name
        if self.alarm_event_name_original is not None:
            result['AlarmEventNameOriginal'] = self.alarm_event_name_original
        if self.alarm_event_type is not None:
            result['AlarmEventType'] = self.alarm_event_type
        if self.alarm_unique_info is not None:
            result['AlarmUniqueInfo'] = self.alarm_unique_info
        if self.can_be_deal_on_line is not None:
            result['CanBeDealOnLine'] = self.can_be_deal_on_line
        if self.can_cancel_fault is not None:
            result['CanCancelFault'] = self.can_cancel_fault
        if self.data_source is not None:
            result['DataSource'] = self.data_source
        if self.dealed is not None:
            result['Dealed'] = self.dealed
        if self.description is not None:
            result['Description'] = self.description
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.has_trace_info is not None:
            result['HasTraceInfo'] = self.has_trace_info
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.level is not None:
            result['Level'] = self.level
        if self.operate_error_code is not None:
            result['OperateErrorCode'] = self.operate_error_code
        if self.operate_time is not None:
            result['OperateTime'] = self.operate_time
        if self.sale_version is not None:
            result['SaleVersion'] = self.sale_version
        if self.security_event_ids is not None:
            result['SecurityEventIds'] = self.security_event_ids
        if self.solution is not None:
            result['Solution'] = self.solution
        if self.stages is not None:
            result['Stages'] = self.stages
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.suspicious_event_count is not None:
            result['SuspiciousEventCount'] = self.suspicious_event_count
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlarmEventName') is not None:
            self.alarm_event_name = m.get('AlarmEventName')
        if m.get('AlarmEventNameOriginal') is not None:
            self.alarm_event_name_original = m.get('AlarmEventNameOriginal')
        if m.get('AlarmEventType') is not None:
            self.alarm_event_type = m.get('AlarmEventType')
        if m.get('AlarmUniqueInfo') is not None:
            self.alarm_unique_info = m.get('AlarmUniqueInfo')
        if m.get('CanBeDealOnLine') is not None:
            self.can_be_deal_on_line = m.get('CanBeDealOnLine')
        if m.get('CanCancelFault') is not None:
            self.can_cancel_fault = m.get('CanCancelFault')
        if m.get('DataSource') is not None:
            self.data_source = m.get('DataSource')
        if m.get('Dealed') is not None:
            self.dealed = m.get('Dealed')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('HasTraceInfo') is not None:
            self.has_trace_info = m.get('HasTraceInfo')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('OperateErrorCode') is not None:
            self.operate_error_code = m.get('OperateErrorCode')
        if m.get('OperateTime') is not None:
            self.operate_time = m.get('OperateTime')
        if m.get('SaleVersion') is not None:
            self.sale_version = m.get('SaleVersion')
        if m.get('SecurityEventIds') is not None:
            self.security_event_ids = m.get('SecurityEventIds')
        if m.get('Solution') is not None:
            self.solution = m.get('Solution')
        if m.get('Stages') is not None:
            self.stages = m.get('Stages')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('SuspiciousEventCount') is not None:
            self.suspicious_event_count = m.get('SuspiciousEventCount')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeAlarmEventListResponseBody(TeaModel):
    def __init__(self, page_info=None, request_id=None, susp_events=None):
        self.page_info = page_info  # type: DescribeAlarmEventListResponseBodyPageInfo
        self.request_id = request_id  # type: str
        self.susp_events = susp_events  # type: list[DescribeAlarmEventListResponseBodySuspEvents]

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.susp_events:
            for k in self.susp_events:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAlarmEventListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['SuspEvents'] = []
        if self.susp_events is not None:
            for k in self.susp_events:
                result['SuspEvents'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageInfo') is not None:
            temp_model = DescribeAlarmEventListResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.susp_events = []
        if m.get('SuspEvents') is not None:
            for k in m.get('SuspEvents'):
                temp_model = DescribeAlarmEventListResponseBodySuspEvents()
                self.susp_events.append(temp_model.from_map(k))
        return self


class DescribeAlarmEventListResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeAlarmEventListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeAlarmEventListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeAlarmEventListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAllEntityResponseBodyEntityList(TeaModel):
    def __init__(self, group_id=None, instance_name=None, internet_ip=None, intranet_ip=None, ip=None, os=None,
                 uuid=None):
        self.group_id = group_id  # type: int
        self.instance_name = instance_name  # type: str
        self.internet_ip = internet_ip  # type: str
        self.intranet_ip = intranet_ip  # type: str
        self.ip = ip  # type: str
        self.os = os  # type: str
        self.uuid = uuid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAllEntityResponseBodyEntityList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.os is not None:
            result['Os'] = self.os
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('Os') is not None:
            self.os = m.get('Os')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeAllEntityResponseBody(TeaModel):
    def __init__(self, entity_list=None, request_id=None):
        self.entity_list = entity_list  # type: list[DescribeAllEntityResponseBodyEntityList]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.entity_list:
            for k in self.entity_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAllEntityResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['EntityList'] = []
        if self.entity_list is not None:
            for k in self.entity_list:
                result['EntityList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.entity_list = []
        if m.get('EntityList') is not None:
            for k in m.get('EntityList'):
                temp_model = DescribeAllEntityResponseBodyEntityList()
                self.entity_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAllEntityResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeAllEntityResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeAllEntityResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeAllEntityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAllGroupsRequest(TeaModel):
    def __init__(self, lang=None):
        self.lang = lang  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAllGroupsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DescribeAllGroupsResponseBodyGroups(TeaModel):
    def __init__(self, group_flag=None, group_id=None, group_name=None):
        self.group_flag = group_flag  # type: int
        self.group_id = group_id  # type: int
        self.group_name = group_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAllGroupsResponseBodyGroups, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_flag is not None:
            result['GroupFlag'] = self.group_flag
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupFlag') is not None:
            self.group_flag = m.get('GroupFlag')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        return self


class DescribeAllGroupsResponseBody(TeaModel):
    def __init__(self, count=None, groups=None, request_id=None):
        self.count = count  # type: int
        self.groups = groups  # type: list[DescribeAllGroupsResponseBodyGroups]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.groups:
            for k in self.groups:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAllGroupsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        result['Groups'] = []
        if self.groups is not None:
            for k in self.groups:
                result['Groups'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        self.groups = []
        if m.get('Groups') is not None:
            for k in m.get('Groups'):
                temp_model = DescribeAllGroupsResponseBodyGroups()
                self.groups.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAllGroupsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeAllGroupsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeAllGroupsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeAllGroupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAntiBruteForceRulesRequest(TeaModel):
    def __init__(self, resource_owner_id=None, source_ip=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.source_ip = source_ip  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAntiBruteForceRulesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeAntiBruteForceRulesResponseBodyPageInfo(TeaModel):
    def __init__(self, count=None, current_page=None, page_size=None, total_count=None):
        self.count = count  # type: int
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAntiBruteForceRulesResponseBodyPageInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeAntiBruteForceRulesResponseBodyRules(TeaModel):
    def __init__(self, default_rule=None, enable_smart_rule=None, fail_count=None, forbidden_time=None, id=None,
                 machine_count=None, name=None, span=None, uuid_list=None):
        self.default_rule = default_rule  # type: bool
        self.enable_smart_rule = enable_smart_rule  # type: bool
        self.fail_count = fail_count  # type: int
        self.forbidden_time = forbidden_time  # type: int
        self.id = id  # type: long
        self.machine_count = machine_count  # type: int
        self.name = name  # type: str
        self.span = span  # type: int
        self.uuid_list = uuid_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAntiBruteForceRulesResponseBodyRules, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.default_rule is not None:
            result['DefaultRule'] = self.default_rule
        if self.enable_smart_rule is not None:
            result['EnableSmartRule'] = self.enable_smart_rule
        if self.fail_count is not None:
            result['FailCount'] = self.fail_count
        if self.forbidden_time is not None:
            result['ForbiddenTime'] = self.forbidden_time
        if self.id is not None:
            result['Id'] = self.id
        if self.machine_count is not None:
            result['MachineCount'] = self.machine_count
        if self.name is not None:
            result['Name'] = self.name
        if self.span is not None:
            result['Span'] = self.span
        if self.uuid_list is not None:
            result['UuidList'] = self.uuid_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DefaultRule') is not None:
            self.default_rule = m.get('DefaultRule')
        if m.get('EnableSmartRule') is not None:
            self.enable_smart_rule = m.get('EnableSmartRule')
        if m.get('FailCount') is not None:
            self.fail_count = m.get('FailCount')
        if m.get('ForbiddenTime') is not None:
            self.forbidden_time = m.get('ForbiddenTime')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MachineCount') is not None:
            self.machine_count = m.get('MachineCount')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Span') is not None:
            self.span = m.get('Span')
        if m.get('UuidList') is not None:
            self.uuid_list = m.get('UuidList')
        return self


class DescribeAntiBruteForceRulesResponseBody(TeaModel):
    def __init__(self, page_info=None, request_id=None, rules=None):
        self.page_info = page_info  # type: DescribeAntiBruteForceRulesResponseBodyPageInfo
        self.request_id = request_id  # type: str
        self.rules = rules  # type: list[DescribeAntiBruteForceRulesResponseBodyRules]

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.rules:
            for k in self.rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAntiBruteForceRulesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Rules'] = []
        if self.rules is not None:
            for k in self.rules:
                result['Rules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageInfo') is not None:
            temp_model = DescribeAntiBruteForceRulesResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.rules = []
        if m.get('Rules') is not None:
            for k in m.get('Rules'):
                temp_model = DescribeAntiBruteForceRulesResponseBodyRules()
                self.rules.append(temp_model.from_map(k))
        return self


class DescribeAntiBruteForceRulesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeAntiBruteForceRulesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeAntiBruteForceRulesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeAntiBruteForceRulesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAssetDetailByUuidRequest(TeaModel):
    def __init__(self, lang=None, source_ip=None, uuid=None):
        self.lang = lang  # type: str
        self.source_ip = source_ip  # type: str
        self.uuid = uuid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAssetDetailByUuidRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeAssetDetailByUuidResponseBodyAssetDetail(TeaModel):
    def __init__(self, asset_type=None, auth_modify_time=None, auth_version=None, bind=None, client_status=None,
                 client_version=None, cpu=None, cpu_info=None, create_time=None, disk_info_list=None, flag=None, group_trace=None,
                 host_name=None, instance_id=None, instance_name=None, internet_ip=None, intranet_ip=None, ip=None,
                 ip_list=None, kernel=None, mac_list=None, mem=None, memory=None, os=None, os_detail=None, os_name=None,
                 region=None, region_id=None, region_name=None, sys_info=None, tag=None, uuid=None, vpc_instance_id=None):
        self.asset_type = asset_type  # type: str
        self.auth_modify_time = auth_modify_time  # type: long
        self.auth_version = auth_version  # type: int
        self.bind = bind  # type: bool
        self.client_status = client_status  # type: str
        self.client_version = client_version  # type: str
        self.cpu = cpu  # type: int
        self.cpu_info = cpu_info  # type: str
        self.create_time = create_time  # type: long
        self.disk_info_list = disk_info_list  # type: list[str]
        self.flag = flag  # type: int
        self.group_trace = group_trace  # type: str
        self.host_name = host_name  # type: str
        self.instance_id = instance_id  # type: str
        self.instance_name = instance_name  # type: str
        self.internet_ip = internet_ip  # type: str
        self.intranet_ip = intranet_ip  # type: str
        self.ip = ip  # type: str
        self.ip_list = ip_list  # type: list[str]
        self.kernel = kernel  # type: str
        self.mac_list = mac_list  # type: list[str]
        self.mem = mem  # type: int
        self.memory = memory  # type: long
        self.os = os  # type: str
        self.os_detail = os_detail  # type: str
        self.os_name = os_name  # type: str
        self.region = region  # type: str
        self.region_id = region_id  # type: str
        self.region_name = region_name  # type: str
        self.sys_info = sys_info  # type: str
        self.tag = tag  # type: str
        self.uuid = uuid  # type: str
        self.vpc_instance_id = vpc_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAssetDetailByUuidResponseBodyAssetDetail, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.asset_type is not None:
            result['AssetType'] = self.asset_type
        if self.auth_modify_time is not None:
            result['AuthModifyTime'] = self.auth_modify_time
        if self.auth_version is not None:
            result['AuthVersion'] = self.auth_version
        if self.bind is not None:
            result['Bind'] = self.bind
        if self.client_status is not None:
            result['ClientStatus'] = self.client_status
        if self.client_version is not None:
            result['ClientVersion'] = self.client_version
        if self.cpu is not None:
            result['Cpu'] = self.cpu
        if self.cpu_info is not None:
            result['CpuInfo'] = self.cpu_info
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.disk_info_list is not None:
            result['DiskInfoList'] = self.disk_info_list
        if self.flag is not None:
            result['Flag'] = self.flag
        if self.group_trace is not None:
            result['GroupTrace'] = self.group_trace
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.ip_list is not None:
            result['IpList'] = self.ip_list
        if self.kernel is not None:
            result['Kernel'] = self.kernel
        if self.mac_list is not None:
            result['MacList'] = self.mac_list
        if self.mem is not None:
            result['Mem'] = self.mem
        if self.memory is not None:
            result['Memory'] = self.memory
        if self.os is not None:
            result['Os'] = self.os
        if self.os_detail is not None:
            result['OsDetail'] = self.os_detail
        if self.os_name is not None:
            result['OsName'] = self.os_name
        if self.region is not None:
            result['Region'] = self.region
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.region_name is not None:
            result['RegionName'] = self.region_name
        if self.sys_info is not None:
            result['SysInfo'] = self.sys_info
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.vpc_instance_id is not None:
            result['VpcInstanceId'] = self.vpc_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AssetType') is not None:
            self.asset_type = m.get('AssetType')
        if m.get('AuthModifyTime') is not None:
            self.auth_modify_time = m.get('AuthModifyTime')
        if m.get('AuthVersion') is not None:
            self.auth_version = m.get('AuthVersion')
        if m.get('Bind') is not None:
            self.bind = m.get('Bind')
        if m.get('ClientStatus') is not None:
            self.client_status = m.get('ClientStatus')
        if m.get('ClientVersion') is not None:
            self.client_version = m.get('ClientVersion')
        if m.get('Cpu') is not None:
            self.cpu = m.get('Cpu')
        if m.get('CpuInfo') is not None:
            self.cpu_info = m.get('CpuInfo')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DiskInfoList') is not None:
            self.disk_info_list = m.get('DiskInfoList')
        if m.get('Flag') is not None:
            self.flag = m.get('Flag')
        if m.get('GroupTrace') is not None:
            self.group_trace = m.get('GroupTrace')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('IpList') is not None:
            self.ip_list = m.get('IpList')
        if m.get('Kernel') is not None:
            self.kernel = m.get('Kernel')
        if m.get('MacList') is not None:
            self.mac_list = m.get('MacList')
        if m.get('Mem') is not None:
            self.mem = m.get('Mem')
        if m.get('Memory') is not None:
            self.memory = m.get('Memory')
        if m.get('Os') is not None:
            self.os = m.get('Os')
        if m.get('OsDetail') is not None:
            self.os_detail = m.get('OsDetail')
        if m.get('OsName') is not None:
            self.os_name = m.get('OsName')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RegionName') is not None:
            self.region_name = m.get('RegionName')
        if m.get('SysInfo') is not None:
            self.sys_info = m.get('SysInfo')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('VpcInstanceId') is not None:
            self.vpc_instance_id = m.get('VpcInstanceId')
        return self


class DescribeAssetDetailByUuidResponseBody(TeaModel):
    def __init__(self, asset_detail=None, request_id=None):
        self.asset_detail = asset_detail  # type: DescribeAssetDetailByUuidResponseBodyAssetDetail
        self.request_id = request_id  # type: str

    def validate(self):
        if self.asset_detail:
            self.asset_detail.validate()

    def to_map(self):
        _map = super(DescribeAssetDetailByUuidResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.asset_detail is not None:
            result['AssetDetail'] = self.asset_detail.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AssetDetail') is not None:
            temp_model = DescribeAssetDetailByUuidResponseBodyAssetDetail()
            self.asset_detail = temp_model.from_map(m['AssetDetail'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAssetDetailByUuidResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeAssetDetailByUuidResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeAssetDetailByUuidResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeAssetDetailByUuidResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAssetDetailByUuidsRequest(TeaModel):
    def __init__(self, uuids=None):
        self.uuids = uuids  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAssetDetailByUuidsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.uuids is not None:
            result['Uuids'] = self.uuids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Uuids') is not None:
            self.uuids = m.get('Uuids')
        return self


class DescribeAssetDetailByUuidsResponseBodyAssetList(TeaModel):
    def __init__(self, asset_type=None, client_status=None, flag=None, instance_id=None, instance_name=None,
                 internet_ip=None, intranet_ip=None, ip=None, os=None, os_name=None, region=None, region_id=None,
                 region_name=None, uuid=None, vpc_instance_id=None):
        self.asset_type = asset_type  # type: str
        self.client_status = client_status  # type: str
        self.flag = flag  # type: int
        self.instance_id = instance_id  # type: str
        self.instance_name = instance_name  # type: str
        self.internet_ip = internet_ip  # type: str
        self.intranet_ip = intranet_ip  # type: str
        self.ip = ip  # type: str
        self.os = os  # type: str
        self.os_name = os_name  # type: str
        self.region = region  # type: str
        self.region_id = region_id  # type: str
        self.region_name = region_name  # type: str
        self.uuid = uuid  # type: str
        self.vpc_instance_id = vpc_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAssetDetailByUuidsResponseBodyAssetList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.asset_type is not None:
            result['AssetType'] = self.asset_type
        if self.client_status is not None:
            result['ClientStatus'] = self.client_status
        if self.flag is not None:
            result['Flag'] = self.flag
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.os is not None:
            result['Os'] = self.os
        if self.os_name is not None:
            result['OsName'] = self.os_name
        if self.region is not None:
            result['Region'] = self.region
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.region_name is not None:
            result['RegionName'] = self.region_name
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.vpc_instance_id is not None:
            result['VpcInstanceId'] = self.vpc_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AssetType') is not None:
            self.asset_type = m.get('AssetType')
        if m.get('ClientStatus') is not None:
            self.client_status = m.get('ClientStatus')
        if m.get('Flag') is not None:
            self.flag = m.get('Flag')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('Os') is not None:
            self.os = m.get('Os')
        if m.get('OsName') is not None:
            self.os_name = m.get('OsName')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RegionName') is not None:
            self.region_name = m.get('RegionName')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('VpcInstanceId') is not None:
            self.vpc_instance_id = m.get('VpcInstanceId')
        return self


class DescribeAssetDetailByUuidsResponseBody(TeaModel):
    def __init__(self, asset_list=None, request_id=None):
        self.asset_list = asset_list  # type: list[DescribeAssetDetailByUuidsResponseBodyAssetList]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.asset_list:
            for k in self.asset_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAssetDetailByUuidsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AssetList'] = []
        if self.asset_list is not None:
            for k in self.asset_list:
                result['AssetList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.asset_list = []
        if m.get('AssetList') is not None:
            for k in m.get('AssetList'):
                temp_model = DescribeAssetDetailByUuidsResponseBodyAssetList()
                self.asset_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAssetDetailByUuidsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeAssetDetailByUuidsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeAssetDetailByUuidsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeAssetDetailByUuidsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAssetSummaryResponseBodyAssetsSummary(TeaModel):
    def __init__(self, total_core_num=None):
        self.total_core_num = total_core_num  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAssetSummaryResponseBodyAssetsSummary, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_core_num is not None:
            result['TotalCoreNum'] = self.total_core_num
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TotalCoreNum') is not None:
            self.total_core_num = m.get('TotalCoreNum')
        return self


class DescribeAssetSummaryResponseBody(TeaModel):
    def __init__(self, assets_summary=None, request_id=None):
        self.assets_summary = assets_summary  # type: DescribeAssetSummaryResponseBodyAssetsSummary
        self.request_id = request_id  # type: str

    def validate(self):
        if self.assets_summary:
            self.assets_summary.validate()

    def to_map(self):
        _map = super(DescribeAssetSummaryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.assets_summary is not None:
            result['AssetsSummary'] = self.assets_summary.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AssetsSummary') is not None:
            temp_model = DescribeAssetSummaryResponseBodyAssetsSummary()
            self.assets_summary = temp_model.from_map(m['AssetsSummary'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAssetSummaryResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeAssetSummaryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeAssetSummaryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeAssetSummaryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAttackAnalysisDataRequest(TeaModel):
    def __init__(self, base_64=None, current_page=None, data=None, end_time=None, lang=None, page_size=None,
                 start_time=None, type=None):
        self.base_64 = base_64  # type: str
        self.current_page = current_page  # type: int
        self.data = data  # type: str
        self.end_time = end_time  # type: long
        self.lang = lang  # type: str
        self.page_size = page_size  # type: int
        self.start_time = start_time  # type: long
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAttackAnalysisDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.base_64 is not None:
            result['Base64'] = self.base_64
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.data is not None:
            result['Data'] = self.data
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Base64') is not None:
            self.base_64 = m.get('Base64')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeAttackAnalysisDataResponseBody(TeaModel):
    def __init__(self, data=None, page=None, page_size=None, request_id=None, total=None):
        self.data = data  # type: str
        self.page = page  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.total = total  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAttackAnalysisDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.page is not None:
            result['Page'] = self.page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeAttackAnalysisDataResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeAttackAnalysisDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeAttackAnalysisDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeAttackAnalysisDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAutoDelConfigResponseBody(TeaModel):
    def __init__(self, days=None, request_id=None):
        self.days = days  # type: int
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAutoDelConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.days is not None:
            result['Days'] = self.days
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Days') is not None:
            self.days = m.get('Days')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAutoDelConfigResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeAutoDelConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeAutoDelConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeAutoDelConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBackupClientsRequest(TeaModel):
    def __init__(self, support_region_id=None):
        self.support_region_id = support_region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBackupClientsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.support_region_id is not None:
            result['SupportRegionId'] = self.support_region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SupportRegionId') is not None:
            self.support_region_id = m.get('SupportRegionId')
        return self


class DescribeBackupClientsResponseBodyClients(TeaModel):
    def __init__(self, client_id=None, client_status=None, instance_id=None, uuid=None):
        self.client_id = client_id  # type: str
        self.client_status = client_status  # type: str
        self.instance_id = instance_id  # type: str
        self.uuid = uuid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBackupClientsResponseBodyClients, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_id is not None:
            result['ClientId'] = self.client_id
        if self.client_status is not None:
            result['ClientStatus'] = self.client_status
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientId') is not None:
            self.client_id = m.get('ClientId')
        if m.get('ClientStatus') is not None:
            self.client_status = m.get('ClientStatus')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeBackupClientsResponseBody(TeaModel):
    def __init__(self, clients=None, request_id=None):
        self.clients = clients  # type: list[DescribeBackupClientsResponseBodyClients]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.clients:
            for k in self.clients:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeBackupClientsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Clients'] = []
        if self.clients is not None:
            for k in self.clients:
                result['Clients'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.clients = []
        if m.get('Clients') is not None:
            for k in m.get('Clients'):
                temp_model = DescribeBackupClientsResponseBodyClients()
                self.clients.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeBackupClientsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeBackupClientsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeBackupClientsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeBackupClientsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBackupFilesRequest(TeaModel):
    def __init__(self, current_page=None, page_size=None, path=None, snapshot_hash=None, uuid=None):
        self.current_page = current_page  # type: str
        self.page_size = page_size  # type: str
        self.path = path  # type: str
        self.snapshot_hash = snapshot_hash  # type: str
        self.uuid = uuid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBackupFilesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.path is not None:
            result['Path'] = self.path
        if self.snapshot_hash is not None:
            result['SnapshotHash'] = self.snapshot_hash
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('SnapshotHash') is not None:
            self.snapshot_hash = m.get('SnapshotHash')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeBackupFilesResponseBodyBackupFiles(TeaModel):
    def __init__(self, name=None, size=None, subtree=None, type=None):
        self.name = name  # type: str
        self.size = size  # type: long
        self.subtree = subtree  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBackupFilesResponseBodyBackupFiles, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.size is not None:
            result['Size'] = self.size
        if self.subtree is not None:
            result['Subtree'] = self.subtree
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('Subtree') is not None:
            self.subtree = m.get('Subtree')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeBackupFilesResponseBodyPageInfo(TeaModel):
    def __init__(self, count=None, current_page=None, page_size=None, total_count=None):
        self.count = count  # type: int
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBackupFilesResponseBodyPageInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeBackupFilesResponseBody(TeaModel):
    def __init__(self, backup_files=None, page_info=None, request_id=None):
        self.backup_files = backup_files  # type: list[DescribeBackupFilesResponseBodyBackupFiles]
        self.page_info = page_info  # type: DescribeBackupFilesResponseBodyPageInfo
        self.request_id = request_id  # type: str

    def validate(self):
        if self.backup_files:
            for k in self.backup_files:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super(DescribeBackupFilesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BackupFiles'] = []
        if self.backup_files is not None:
            for k in self.backup_files:
                result['BackupFiles'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.backup_files = []
        if m.get('BackupFiles') is not None:
            for k in m.get('BackupFiles'):
                temp_model = DescribeBackupFilesResponseBodyBackupFiles()
                self.backup_files.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeBackupFilesResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeBackupFilesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeBackupFilesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeBackupFilesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeBackupFilesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBackupPoliciesRequest(TeaModel):
    def __init__(self, current_page=None, machine_remark=None, name=None, page_size=None, status=None):
        self.current_page = current_page  # type: int
        self.machine_remark = machine_remark  # type: str
        self.name = name  # type: str
        self.page_size = page_size  # type: int
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBackupPoliciesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.machine_remark is not None:
            result['MachineRemark'] = self.machine_remark
        if self.name is not None:
            result['Name'] = self.name
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('MachineRemark') is not None:
            self.machine_remark = m.get('MachineRemark')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeBackupPoliciesResponseBodyPageInfo(TeaModel):
    def __init__(self, count=None, current_page=None, page_size=None, total_count=None):
        self.count = count  # type: int
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBackupPoliciesResponseBodyPageInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeBackupPoliciesResponseBodyPolicies(TeaModel):
    def __init__(self, client_error_count=None, client_error_uuid_list=None, client_status=None,
                 health_client_count=None, health_client_uuid_list=None, id=None, name=None, policy=None, policy_region_id=None,
                 policy_version=None, remarked_uuid_list=None, service_error_count=None, service_error_uuid_list=None,
                 status=None, upgrade_status=None, uuid_list=None):
        self.client_error_count = client_error_count  # type: int
        self.client_error_uuid_list = client_error_uuid_list  # type: list[str]
        self.client_status = client_status  # type: str
        self.health_client_count = health_client_count  # type: int
        self.health_client_uuid_list = health_client_uuid_list  # type: list[str]
        self.id = id  # type: long
        self.name = name  # type: str
        self.policy = policy  # type: str
        self.policy_region_id = policy_region_id  # type: str
        self.policy_version = policy_version  # type: str
        self.remarked_uuid_list = remarked_uuid_list  # type: list[str]
        self.service_error_count = service_error_count  # type: int
        self.service_error_uuid_list = service_error_uuid_list  # type: list[str]
        self.status = status  # type: str
        self.upgrade_status = upgrade_status  # type: str
        self.uuid_list = uuid_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBackupPoliciesResponseBodyPolicies, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_error_count is not None:
            result['ClientErrorCount'] = self.client_error_count
        if self.client_error_uuid_list is not None:
            result['ClientErrorUuidList'] = self.client_error_uuid_list
        if self.client_status is not None:
            result['ClientStatus'] = self.client_status
        if self.health_client_count is not None:
            result['HealthClientCount'] = self.health_client_count
        if self.health_client_uuid_list is not None:
            result['HealthClientUuidList'] = self.health_client_uuid_list
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.policy_region_id is not None:
            result['PolicyRegionId'] = self.policy_region_id
        if self.policy_version is not None:
            result['PolicyVersion'] = self.policy_version
        if self.remarked_uuid_list is not None:
            result['RemarkedUuidList'] = self.remarked_uuid_list
        if self.service_error_count is not None:
            result['ServiceErrorCount'] = self.service_error_count
        if self.service_error_uuid_list is not None:
            result['ServiceErrorUuidList'] = self.service_error_uuid_list
        if self.status is not None:
            result['Status'] = self.status
        if self.upgrade_status is not None:
            result['UpgradeStatus'] = self.upgrade_status
        if self.uuid_list is not None:
            result['UuidList'] = self.uuid_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientErrorCount') is not None:
            self.client_error_count = m.get('ClientErrorCount')
        if m.get('ClientErrorUuidList') is not None:
            self.client_error_uuid_list = m.get('ClientErrorUuidList')
        if m.get('ClientStatus') is not None:
            self.client_status = m.get('ClientStatus')
        if m.get('HealthClientCount') is not None:
            self.health_client_count = m.get('HealthClientCount')
        if m.get('HealthClientUuidList') is not None:
            self.health_client_uuid_list = m.get('HealthClientUuidList')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('PolicyRegionId') is not None:
            self.policy_region_id = m.get('PolicyRegionId')
        if m.get('PolicyVersion') is not None:
            self.policy_version = m.get('PolicyVersion')
        if m.get('RemarkedUuidList') is not None:
            self.remarked_uuid_list = m.get('RemarkedUuidList')
        if m.get('ServiceErrorCount') is not None:
            self.service_error_count = m.get('ServiceErrorCount')
        if m.get('ServiceErrorUuidList') is not None:
            self.service_error_uuid_list = m.get('ServiceErrorUuidList')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UpgradeStatus') is not None:
            self.upgrade_status = m.get('UpgradeStatus')
        if m.get('UuidList') is not None:
            self.uuid_list = m.get('UuidList')
        return self


class DescribeBackupPoliciesResponseBody(TeaModel):
    def __init__(self, page_info=None, policies=None, request_id=None):
        self.page_info = page_info  # type: DescribeBackupPoliciesResponseBodyPageInfo
        self.policies = policies  # type: list[DescribeBackupPoliciesResponseBodyPolicies]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.policies:
            for k in self.policies:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeBackupPoliciesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        result['Policies'] = []
        if self.policies is not None:
            for k in self.policies:
                result['Policies'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageInfo') is not None:
            temp_model = DescribeBackupPoliciesResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        self.policies = []
        if m.get('Policies') is not None:
            for k in m.get('Policies'):
                temp_model = DescribeBackupPoliciesResponseBodyPolicies()
                self.policies.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeBackupPoliciesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeBackupPoliciesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeBackupPoliciesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeBackupPoliciesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBackupRestoreCountResponseBodyBackupRestoreCount(TeaModel):
    def __init__(self, recovering=None, total=None):
        self.recovering = recovering  # type: int
        self.total = total  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBackupRestoreCountResponseBodyBackupRestoreCount, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.recovering is not None:
            result['Recovering'] = self.recovering
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Recovering') is not None:
            self.recovering = m.get('Recovering')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeBackupRestoreCountResponseBody(TeaModel):
    def __init__(self, backup_restore_count=None, request_id=None):
        self.backup_restore_count = backup_restore_count  # type: DescribeBackupRestoreCountResponseBodyBackupRestoreCount
        self.request_id = request_id  # type: str

    def validate(self):
        if self.backup_restore_count:
            self.backup_restore_count.validate()

    def to_map(self):
        _map = super(DescribeBackupRestoreCountResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_restore_count is not None:
            result['BackupRestoreCount'] = self.backup_restore_count.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BackupRestoreCount') is not None:
            temp_model = DescribeBackupRestoreCountResponseBodyBackupRestoreCount()
            self.backup_restore_count = temp_model.from_map(m['BackupRestoreCount'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeBackupRestoreCountResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeBackupRestoreCountResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeBackupRestoreCountResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeBackupRestoreCountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBruteForceSummaryRequest(TeaModel):
    def __init__(self, resource_owner_id=None, source_ip=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.source_ip = source_ip  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBruteForceSummaryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeBruteForceSummaryResponseBodyBruteForceSummary(TeaModel):
    def __init__(self, all_strategy_count=None, effective_count=None):
        self.all_strategy_count = all_strategy_count  # type: int
        self.effective_count = effective_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBruteForceSummaryResponseBodyBruteForceSummary, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.all_strategy_count is not None:
            result['AllStrategyCount'] = self.all_strategy_count
        if self.effective_count is not None:
            result['EffectiveCount'] = self.effective_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AllStrategyCount') is not None:
            self.all_strategy_count = m.get('AllStrategyCount')
        if m.get('EffectiveCount') is not None:
            self.effective_count = m.get('EffectiveCount')
        return self


class DescribeBruteForceSummaryResponseBody(TeaModel):
    def __init__(self, brute_force_summary=None, request_id=None):
        self.brute_force_summary = brute_force_summary  # type: DescribeBruteForceSummaryResponseBodyBruteForceSummary
        self.request_id = request_id  # type: str

    def validate(self):
        if self.brute_force_summary:
            self.brute_force_summary.validate()

    def to_map(self):
        _map = super(DescribeBruteForceSummaryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.brute_force_summary is not None:
            result['BruteForceSummary'] = self.brute_force_summary.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BruteForceSummary') is not None:
            temp_model = DescribeBruteForceSummaryResponseBodyBruteForceSummary()
            self.brute_force_summary = temp_model.from_map(m['BruteForceSummary'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeBruteForceSummaryResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeBruteForceSummaryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeBruteForceSummaryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeBruteForceSummaryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCheckEcsWarningsRequest(TeaModel):
    def __init__(self, source_ip=None):
        self.source_ip = source_ip  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCheckEcsWarningsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeCheckEcsWarningsResponseBody(TeaModel):
    def __init__(self, can_try=None, request_id=None, sas_version=None, weak_password_count=None):
        self.can_try = can_try  # type: str
        self.request_id = request_id  # type: str
        self.sas_version = sas_version  # type: str
        self.weak_password_count = weak_password_count  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCheckEcsWarningsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.can_try is not None:
            result['CanTry'] = self.can_try
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.sas_version is not None:
            result['SasVersion'] = self.sas_version
        if self.weak_password_count is not None:
            result['WeakPasswordCount'] = self.weak_password_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CanTry') is not None:
            self.can_try = m.get('CanTry')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SasVersion') is not None:
            self.sas_version = m.get('SasVersion')
        if m.get('WeakPasswordCount') is not None:
            self.weak_password_count = m.get('WeakPasswordCount')
        return self


class DescribeCheckEcsWarningsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeCheckEcsWarningsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCheckEcsWarningsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeCheckEcsWarningsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCheckWarningDetailRequest(TeaModel):
    def __init__(self, check_warning_id=None, lang=None, source_ip=None):
        self.check_warning_id = check_warning_id  # type: long
        self.lang = lang  # type: str
        self.source_ip = source_ip  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCheckWarningDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_warning_id is not None:
            result['CheckWarningId'] = self.check_warning_id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CheckWarningId') is not None:
            self.check_warning_id = m.get('CheckWarningId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeCheckWarningDetailResponseBody(TeaModel):
    def __init__(self, advice=None, check_id=None, description=None, item=None, level=None, prompt=None,
                 request_id=None, type=None):
        self.advice = advice  # type: str
        self.check_id = check_id  # type: long
        self.description = description  # type: str
        self.item = item  # type: str
        self.level = level  # type: str
        self.prompt = prompt  # type: str
        self.request_id = request_id  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCheckWarningDetailResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.advice is not None:
            result['Advice'] = self.advice
        if self.check_id is not None:
            result['CheckId'] = self.check_id
        if self.description is not None:
            result['Description'] = self.description
        if self.item is not None:
            result['Item'] = self.item
        if self.level is not None:
            result['Level'] = self.level
        if self.prompt is not None:
            result['Prompt'] = self.prompt
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Advice') is not None:
            self.advice = m.get('Advice')
        if m.get('CheckId') is not None:
            self.check_id = m.get('CheckId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Item') is not None:
            self.item = m.get('Item')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Prompt') is not None:
            self.prompt = m.get('Prompt')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeCheckWarningDetailResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeCheckWarningDetailResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCheckWarningDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeCheckWarningDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCheckWarningSummaryRequest(TeaModel):
    def __init__(self, current_page=None, lang=None, page_size=None, risk_name=None, risk_status=None,
                 source_ip=None, status=None, strategy_id=None, type_name=None, uuids=None):
        self.current_page = current_page  # type: int
        self.lang = lang  # type: str
        self.page_size = page_size  # type: int
        self.risk_name = risk_name  # type: str
        self.risk_status = risk_status  # type: int
        self.source_ip = source_ip  # type: str
        self.status = status  # type: str
        self.strategy_id = strategy_id  # type: long
        self.type_name = type_name  # type: str
        self.uuids = uuids  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCheckWarningSummaryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.risk_name is not None:
            result['RiskName'] = self.risk_name
        if self.risk_status is not None:
            result['RiskStatus'] = self.risk_status
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.status is not None:
            result['Status'] = self.status
        if self.strategy_id is not None:
            result['StrategyId'] = self.strategy_id
        if self.type_name is not None:
            result['TypeName'] = self.type_name
        if self.uuids is not None:
            result['Uuids'] = self.uuids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RiskName') is not None:
            self.risk_name = m.get('RiskName')
        if m.get('RiskStatus') is not None:
            self.risk_status = m.get('RiskStatus')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StrategyId') is not None:
            self.strategy_id = m.get('StrategyId')
        if m.get('TypeName') is not None:
            self.type_name = m.get('TypeName')
        if m.get('Uuids') is not None:
            self.uuids = m.get('Uuids')
        return self


class DescribeCheckWarningSummaryResponseBodyWarningSummarys(TeaModel):
    def __init__(self, check_count=None, high_warning_count=None, last_found_time=None, level=None,
                 low_warning_count=None, medium_warning_count=None, risk_id=None, risk_name=None, sub_type_alias=None,
                 type_alias=None, warning_machine_count=None):
        self.check_count = check_count  # type: int
        self.high_warning_count = high_warning_count  # type: int
        self.last_found_time = last_found_time  # type: str
        self.level = level  # type: str
        self.low_warning_count = low_warning_count  # type: int
        self.medium_warning_count = medium_warning_count  # type: int
        self.risk_id = risk_id  # type: long
        self.risk_name = risk_name  # type: str
        self.sub_type_alias = sub_type_alias  # type: str
        self.type_alias = type_alias  # type: str
        self.warning_machine_count = warning_machine_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCheckWarningSummaryResponseBodyWarningSummarys, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_count is not None:
            result['CheckCount'] = self.check_count
        if self.high_warning_count is not None:
            result['HighWarningCount'] = self.high_warning_count
        if self.last_found_time is not None:
            result['LastFoundTime'] = self.last_found_time
        if self.level is not None:
            result['Level'] = self.level
        if self.low_warning_count is not None:
            result['LowWarningCount'] = self.low_warning_count
        if self.medium_warning_count is not None:
            result['MediumWarningCount'] = self.medium_warning_count
        if self.risk_id is not None:
            result['RiskId'] = self.risk_id
        if self.risk_name is not None:
            result['RiskName'] = self.risk_name
        if self.sub_type_alias is not None:
            result['SubTypeAlias'] = self.sub_type_alias
        if self.type_alias is not None:
            result['TypeAlias'] = self.type_alias
        if self.warning_machine_count is not None:
            result['WarningMachineCount'] = self.warning_machine_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CheckCount') is not None:
            self.check_count = m.get('CheckCount')
        if m.get('HighWarningCount') is not None:
            self.high_warning_count = m.get('HighWarningCount')
        if m.get('LastFoundTime') is not None:
            self.last_found_time = m.get('LastFoundTime')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('LowWarningCount') is not None:
            self.low_warning_count = m.get('LowWarningCount')
        if m.get('MediumWarningCount') is not None:
            self.medium_warning_count = m.get('MediumWarningCount')
        if m.get('RiskId') is not None:
            self.risk_id = m.get('RiskId')
        if m.get('RiskName') is not None:
            self.risk_name = m.get('RiskName')
        if m.get('SubTypeAlias') is not None:
            self.sub_type_alias = m.get('SubTypeAlias')
        if m.get('TypeAlias') is not None:
            self.type_alias = m.get('TypeAlias')
        if m.get('WarningMachineCount') is not None:
            self.warning_machine_count = m.get('WarningMachineCount')
        return self


class DescribeCheckWarningSummaryResponseBody(TeaModel):
    def __init__(self, count=None, current_page=None, page_size=None, request_id=None, total_count=None,
                 warning_summarys=None):
        self.count = count  # type: int
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: int
        self.warning_summarys = warning_summarys  # type: list[DescribeCheckWarningSummaryResponseBodyWarningSummarys]

    def validate(self):
        if self.warning_summarys:
            for k in self.warning_summarys:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCheckWarningSummaryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['WarningSummarys'] = []
        if self.warning_summarys is not None:
            for k in self.warning_summarys:
                result['WarningSummarys'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.warning_summarys = []
        if m.get('WarningSummarys') is not None:
            for k in m.get('WarningSummarys'):
                temp_model = DescribeCheckWarningSummaryResponseBodyWarningSummarys()
                self.warning_summarys.append(temp_model.from_map(k))
        return self


class DescribeCheckWarningSummaryResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeCheckWarningSummaryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCheckWarningSummaryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeCheckWarningSummaryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCheckWarningsRequest(TeaModel):
    def __init__(self, check_id=None, current_page=None, lang=None, page_size=None, risk_id=None, source_ip=None,
                 uuid=None):
        self.check_id = check_id  # type: long
        self.current_page = current_page  # type: int
        self.lang = lang  # type: str
        self.page_size = page_size  # type: int
        self.risk_id = risk_id  # type: long
        self.source_ip = source_ip  # type: str
        self.uuid = uuid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCheckWarningsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_id is not None:
            result['CheckId'] = self.check_id
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.risk_id is not None:
            result['RiskId'] = self.risk_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CheckId') is not None:
            self.check_id = m.get('CheckId')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RiskId') is not None:
            self.risk_id = m.get('RiskId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeCheckWarningsResponseBodyCheckWarnings(TeaModel):
    def __init__(self, check_id=None, check_warning_id=None, item=None, level=None, status=None, type=None, uuid=None):
        self.check_id = check_id  # type: long
        self.check_warning_id = check_warning_id  # type: long
        self.item = item  # type: str
        self.level = level  # type: str
        self.status = status  # type: int
        self.type = type  # type: str
        self.uuid = uuid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCheckWarningsResponseBodyCheckWarnings, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_id is not None:
            result['CheckId'] = self.check_id
        if self.check_warning_id is not None:
            result['CheckWarningId'] = self.check_warning_id
        if self.item is not None:
            result['Item'] = self.item
        if self.level is not None:
            result['Level'] = self.level
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CheckId') is not None:
            self.check_id = m.get('CheckId')
        if m.get('CheckWarningId') is not None:
            self.check_warning_id = m.get('CheckWarningId')
        if m.get('Item') is not None:
            self.item = m.get('Item')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeCheckWarningsResponseBody(TeaModel):
    def __init__(self, check_warnings=None, count=None, current_page=None, page_size=None, request_id=None,
                 total_count=None):
        self.check_warnings = check_warnings  # type: list[DescribeCheckWarningsResponseBodyCheckWarnings]
        self.count = count  # type: int
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: int

    def validate(self):
        if self.check_warnings:
            for k in self.check_warnings:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCheckWarningsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CheckWarnings'] = []
        if self.check_warnings is not None:
            for k in self.check_warnings:
                result['CheckWarnings'].append(k.to_map() if k else None)
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.check_warnings = []
        if m.get('CheckWarnings') is not None:
            for k in m.get('CheckWarnings'):
                temp_model = DescribeCheckWarningsResponseBodyCheckWarnings()
                self.check_warnings.append(temp_model.from_map(k))
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeCheckWarningsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeCheckWarningsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCheckWarningsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeCheckWarningsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCloudCenterInstancesRequest(TeaModel):
    def __init__(self, criteria=None, current_page=None, importance=None, logical_exp=None, machine_types=None,
                 no_group_trace=None, page_size=None, region_id=None):
        self.criteria = criteria  # type: str
        self.current_page = current_page  # type: int
        self.importance = importance  # type: int
        self.logical_exp = logical_exp  # type: str
        self.machine_types = machine_types  # type: str
        self.no_group_trace = no_group_trace  # type: bool
        self.page_size = page_size  # type: int
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCloudCenterInstancesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.criteria is not None:
            result['Criteria'] = self.criteria
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.importance is not None:
            result['Importance'] = self.importance
        if self.logical_exp is not None:
            result['LogicalExp'] = self.logical_exp
        if self.machine_types is not None:
            result['MachineTypes'] = self.machine_types
        if self.no_group_trace is not None:
            result['NoGroupTrace'] = self.no_group_trace
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Criteria') is not None:
            self.criteria = m.get('Criteria')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Importance') is not None:
            self.importance = m.get('Importance')
        if m.get('LogicalExp') is not None:
            self.logical_exp = m.get('LogicalExp')
        if m.get('MachineTypes') is not None:
            self.machine_types = m.get('MachineTypes')
        if m.get('NoGroupTrace') is not None:
            self.no_group_trace = m.get('NoGroupTrace')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeCloudCenterInstancesResponseBodyInstances(TeaModel):
    def __init__(self, alarm_status=None, asset_type=None, auth_modify_time=None, auth_version=None,
                 auth_version_name=None, bind=None, client_status=None, cluster_id=None, cluster_name=None, cores=None, cpu_info=None,
                 created_time=None, exposed_status=None, flag=None, group_id=None, group_trace=None, hc_status=None,
                 health_check_count=None, importance=None, instance_id=None, instance_name=None, internet_ip=None, intranet_ip=None,
                 ip=None, ip_list_string=None, kernel=None, last_login_timestamp=None, mac_list_string=None, mem=None,
                 os=None, os_name=None, pod_count=None, region=None, region_id=None, region_name=None, risk_count=None,
                 risk_status=None, safe_event_count=None, status=None, tag=None, tag_id=None, uuid=None, vendor=None,
                 vendor_name=None, vpc_instance_id=None, vul_count=None, vul_status=None):
        self.alarm_status = alarm_status  # type: str
        self.asset_type = asset_type  # type: str
        self.auth_modify_time = auth_modify_time  # type: long
        self.auth_version = auth_version  # type: int
        self.auth_version_name = auth_version_name  # type: str
        self.bind = bind  # type: bool
        self.client_status = client_status  # type: str
        self.cluster_id = cluster_id  # type: str
        self.cluster_name = cluster_name  # type: str
        self.cores = cores  # type: int
        self.cpu_info = cpu_info  # type: str
        self.created_time = created_time  # type: long
        self.exposed_status = exposed_status  # type: int
        self.flag = flag  # type: int
        self.group_id = group_id  # type: long
        self.group_trace = group_trace  # type: str
        self.hc_status = hc_status  # type: str
        self.health_check_count = health_check_count  # type: int
        self.importance = importance  # type: int
        self.instance_id = instance_id  # type: str
        self.instance_name = instance_name  # type: str
        self.internet_ip = internet_ip  # type: str
        self.intranet_ip = intranet_ip  # type: str
        self.ip = ip  # type: str
        self.ip_list_string = ip_list_string  # type: str
        self.kernel = kernel  # type: str
        self.last_login_timestamp = last_login_timestamp  # type: long
        self.mac_list_string = mac_list_string  # type: str
        self.mem = mem  # type: int
        self.os = os  # type: str
        self.os_name = os_name  # type: str
        self.pod_count = pod_count  # type: int
        self.region = region  # type: str
        self.region_id = region_id  # type: str
        self.region_name = region_name  # type: str
        self.risk_count = risk_count  # type: str
        self.risk_status = risk_status  # type: str
        self.safe_event_count = safe_event_count  # type: int
        self.status = status  # type: str
        self.tag = tag  # type: str
        self.tag_id = tag_id  # type: str
        self.uuid = uuid  # type: str
        self.vendor = vendor  # type: int
        self.vendor_name = vendor_name  # type: str
        self.vpc_instance_id = vpc_instance_id  # type: str
        self.vul_count = vul_count  # type: int
        self.vul_status = vul_status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCloudCenterInstancesResponseBodyInstances, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_status is not None:
            result['AlarmStatus'] = self.alarm_status
        if self.asset_type is not None:
            result['AssetType'] = self.asset_type
        if self.auth_modify_time is not None:
            result['AuthModifyTime'] = self.auth_modify_time
        if self.auth_version is not None:
            result['AuthVersion'] = self.auth_version
        if self.auth_version_name is not None:
            result['AuthVersionName'] = self.auth_version_name
        if self.bind is not None:
            result['Bind'] = self.bind
        if self.client_status is not None:
            result['ClientStatus'] = self.client_status
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.cores is not None:
            result['Cores'] = self.cores
        if self.cpu_info is not None:
            result['CpuInfo'] = self.cpu_info
        if self.created_time is not None:
            result['CreatedTime'] = self.created_time
        if self.exposed_status is not None:
            result['ExposedStatus'] = self.exposed_status
        if self.flag is not None:
            result['Flag'] = self.flag
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_trace is not None:
            result['GroupTrace'] = self.group_trace
        if self.hc_status is not None:
            result['HcStatus'] = self.hc_status
        if self.health_check_count is not None:
            result['HealthCheckCount'] = self.health_check_count
        if self.importance is not None:
            result['Importance'] = self.importance
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.ip_list_string is not None:
            result['IpListString'] = self.ip_list_string
        if self.kernel is not None:
            result['Kernel'] = self.kernel
        if self.last_login_timestamp is not None:
            result['LastLoginTimestamp'] = self.last_login_timestamp
        if self.mac_list_string is not None:
            result['MacListString'] = self.mac_list_string
        if self.mem is not None:
            result['Mem'] = self.mem
        if self.os is not None:
            result['Os'] = self.os
        if self.os_name is not None:
            result['OsName'] = self.os_name
        if self.pod_count is not None:
            result['PodCount'] = self.pod_count
        if self.region is not None:
            result['Region'] = self.region
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.region_name is not None:
            result['RegionName'] = self.region_name
        if self.risk_count is not None:
            result['RiskCount'] = self.risk_count
        if self.risk_status is not None:
            result['RiskStatus'] = self.risk_status
        if self.safe_event_count is not None:
            result['SafeEventCount'] = self.safe_event_count
        if self.status is not None:
            result['Status'] = self.status
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.tag_id is not None:
            result['TagId'] = self.tag_id
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        if self.vendor_name is not None:
            result['VendorName'] = self.vendor_name
        if self.vpc_instance_id is not None:
            result['VpcInstanceId'] = self.vpc_instance_id
        if self.vul_count is not None:
            result['VulCount'] = self.vul_count
        if self.vul_status is not None:
            result['VulStatus'] = self.vul_status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlarmStatus') is not None:
            self.alarm_status = m.get('AlarmStatus')
        if m.get('AssetType') is not None:
            self.asset_type = m.get('AssetType')
        if m.get('AuthModifyTime') is not None:
            self.auth_modify_time = m.get('AuthModifyTime')
        if m.get('AuthVersion') is not None:
            self.auth_version = m.get('AuthVersion')
        if m.get('AuthVersionName') is not None:
            self.auth_version_name = m.get('AuthVersionName')
        if m.get('Bind') is not None:
            self.bind = m.get('Bind')
        if m.get('ClientStatus') is not None:
            self.client_status = m.get('ClientStatus')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('Cores') is not None:
            self.cores = m.get('Cores')
        if m.get('CpuInfo') is not None:
            self.cpu_info = m.get('CpuInfo')
        if m.get('CreatedTime') is not None:
            self.created_time = m.get('CreatedTime')
        if m.get('ExposedStatus') is not None:
            self.exposed_status = m.get('ExposedStatus')
        if m.get('Flag') is not None:
            self.flag = m.get('Flag')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupTrace') is not None:
            self.group_trace = m.get('GroupTrace')
        if m.get('HcStatus') is not None:
            self.hc_status = m.get('HcStatus')
        if m.get('HealthCheckCount') is not None:
            self.health_check_count = m.get('HealthCheckCount')
        if m.get('Importance') is not None:
            self.importance = m.get('Importance')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('IpListString') is not None:
            self.ip_list_string = m.get('IpListString')
        if m.get('Kernel') is not None:
            self.kernel = m.get('Kernel')
        if m.get('LastLoginTimestamp') is not None:
            self.last_login_timestamp = m.get('LastLoginTimestamp')
        if m.get('MacListString') is not None:
            self.mac_list_string = m.get('MacListString')
        if m.get('Mem') is not None:
            self.mem = m.get('Mem')
        if m.get('Os') is not None:
            self.os = m.get('Os')
        if m.get('OsName') is not None:
            self.os_name = m.get('OsName')
        if m.get('PodCount') is not None:
            self.pod_count = m.get('PodCount')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RegionName') is not None:
            self.region_name = m.get('RegionName')
        if m.get('RiskCount') is not None:
            self.risk_count = m.get('RiskCount')
        if m.get('RiskStatus') is not None:
            self.risk_status = m.get('RiskStatus')
        if m.get('SafeEventCount') is not None:
            self.safe_event_count = m.get('SafeEventCount')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('TagId') is not None:
            self.tag_id = m.get('TagId')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        if m.get('VendorName') is not None:
            self.vendor_name = m.get('VendorName')
        if m.get('VpcInstanceId') is not None:
            self.vpc_instance_id = m.get('VpcInstanceId')
        if m.get('VulCount') is not None:
            self.vul_count = m.get('VulCount')
        if m.get('VulStatus') is not None:
            self.vul_status = m.get('VulStatus')
        return self


class DescribeCloudCenterInstancesResponseBodyPageInfo(TeaModel):
    def __init__(self, count=None, current_page=None, page_size=None, total_count=None):
        self.count = count  # type: int
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCloudCenterInstancesResponseBodyPageInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeCloudCenterInstancesResponseBody(TeaModel):
    def __init__(self, instances=None, page_info=None, request_id=None, success=None):
        self.instances = instances  # type: list[DescribeCloudCenterInstancesResponseBodyInstances]
        self.page_info = page_info  # type: DescribeCloudCenterInstancesResponseBodyPageInfo
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.instances:
            for k in self.instances:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super(DescribeCloudCenterInstancesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Instances'] = []
        if self.instances is not None:
            for k in self.instances:
                result['Instances'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.instances = []
        if m.get('Instances') is not None:
            for k in m.get('Instances'):
                temp_model = DescribeCloudCenterInstancesResponseBodyInstances()
                self.instances.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeCloudCenterInstancesResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeCloudCenterInstancesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeCloudCenterInstancesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCloudCenterInstancesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeCloudCenterInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCloudProductFieldStatisticsResponseBodyGroupedFields(TeaModel):
    def __init__(self, category_count=None, instance_count=None, risk_instance_count=None):
        self.category_count = category_count  # type: str
        self.instance_count = instance_count  # type: int
        self.risk_instance_count = risk_instance_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCloudProductFieldStatisticsResponseBodyGroupedFields, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category_count is not None:
            result['CategoryCount'] = self.category_count
        if self.instance_count is not None:
            result['InstanceCount'] = self.instance_count
        if self.risk_instance_count is not None:
            result['RiskInstanceCount'] = self.risk_instance_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CategoryCount') is not None:
            self.category_count = m.get('CategoryCount')
        if m.get('InstanceCount') is not None:
            self.instance_count = m.get('InstanceCount')
        if m.get('RiskInstanceCount') is not None:
            self.risk_instance_count = m.get('RiskInstanceCount')
        return self


class DescribeCloudProductFieldStatisticsResponseBody(TeaModel):
    def __init__(self, grouped_fields=None, request_id=None):
        self.grouped_fields = grouped_fields  # type: DescribeCloudProductFieldStatisticsResponseBodyGroupedFields
        self.request_id = request_id  # type: str

    def validate(self):
        if self.grouped_fields:
            self.grouped_fields.validate()

    def to_map(self):
        _map = super(DescribeCloudProductFieldStatisticsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.grouped_fields is not None:
            result['GroupedFields'] = self.grouped_fields.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupedFields') is not None:
            temp_model = DescribeCloudProductFieldStatisticsResponseBodyGroupedFields()
            self.grouped_fields = temp_model.from_map(m['GroupedFields'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeCloudProductFieldStatisticsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeCloudProductFieldStatisticsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCloudProductFieldStatisticsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeCloudProductFieldStatisticsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeConcernNecessityRequest(TeaModel):
    def __init__(self, lang=None):
        self.lang = lang  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeConcernNecessityRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DescribeConcernNecessityResponseBody(TeaModel):
    def __init__(self, concern_necessity=None, request_id=None):
        self.concern_necessity = concern_necessity  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeConcernNecessityResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.concern_necessity is not None:
            result['ConcernNecessity'] = self.concern_necessity
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConcernNecessity') is not None:
            self.concern_necessity = m.get('ConcernNecessity')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeConcernNecessityResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeConcernNecessityResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeConcernNecessityResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeConcernNecessityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeContainerStatisticsRequest(TeaModel):
    def __init__(self, cluster_id=None):
        self.cluster_id = cluster_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeContainerStatisticsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        return self


class DescribeContainerStatisticsResponseBodyData(TeaModel):
    def __init__(self, remind_alarm_count=None, serious_alarm_count=None, suspicious_alarm_count=None,
                 total_alarm_count=None, total_node=None, has_risk_node=None):
        self.remind_alarm_count = remind_alarm_count  # type: int
        self.serious_alarm_count = serious_alarm_count  # type: int
        self.suspicious_alarm_count = suspicious_alarm_count  # type: int
        self.total_alarm_count = total_alarm_count  # type: int
        self.total_node = total_node  # type: int
        self.has_risk_node = has_risk_node  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeContainerStatisticsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.remind_alarm_count is not None:
            result['RemindAlarmCount'] = self.remind_alarm_count
        if self.serious_alarm_count is not None:
            result['SeriousAlarmCount'] = self.serious_alarm_count
        if self.suspicious_alarm_count is not None:
            result['SuspiciousAlarmCount'] = self.suspicious_alarm_count
        if self.total_alarm_count is not None:
            result['TotalAlarmCount'] = self.total_alarm_count
        if self.total_node is not None:
            result['TotalNode'] = self.total_node
        if self.has_risk_node is not None:
            result['hasRiskNode'] = self.has_risk_node
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RemindAlarmCount') is not None:
            self.remind_alarm_count = m.get('RemindAlarmCount')
        if m.get('SeriousAlarmCount') is not None:
            self.serious_alarm_count = m.get('SeriousAlarmCount')
        if m.get('SuspiciousAlarmCount') is not None:
            self.suspicious_alarm_count = m.get('SuspiciousAlarmCount')
        if m.get('TotalAlarmCount') is not None:
            self.total_alarm_count = m.get('TotalAlarmCount')
        if m.get('TotalNode') is not None:
            self.total_node = m.get('TotalNode')
        if m.get('hasRiskNode') is not None:
            self.has_risk_node = m.get('hasRiskNode')
        return self


class DescribeContainerStatisticsResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        self.data = data  # type: DescribeContainerStatisticsResponseBodyData
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(DescribeContainerStatisticsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = DescribeContainerStatisticsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeContainerStatisticsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeContainerStatisticsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeContainerStatisticsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeContainerStatisticsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCriteriaRequest(TeaModel):
    def __init__(self, machine_types=None, support_auto_tag=None, value=None):
        self.machine_types = machine_types  # type: str
        self.support_auto_tag = support_auto_tag  # type: bool
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCriteriaRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.machine_types is not None:
            result['MachineTypes'] = self.machine_types
        if self.support_auto_tag is not None:
            result['SupportAutoTag'] = self.support_auto_tag
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MachineTypes') is not None:
            self.machine_types = m.get('MachineTypes')
        if m.get('SupportAutoTag') is not None:
            self.support_auto_tag = m.get('SupportAutoTag')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeCriteriaResponseBodyCriteriaList(TeaModel):
    def __init__(self, name=None, type=None, values=None):
        self.name = name  # type: str
        self.type = type  # type: str
        self.values = values  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCriteriaResponseBodyCriteriaList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        if self.values is not None:
            result['Values'] = self.values
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Values') is not None:
            self.values = m.get('Values')
        return self


class DescribeCriteriaResponseBody(TeaModel):
    def __init__(self, criteria_list=None, request_id=None):
        self.criteria_list = criteria_list  # type: list[DescribeCriteriaResponseBodyCriteriaList]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.criteria_list:
            for k in self.criteria_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCriteriaResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CriteriaList'] = []
        if self.criteria_list is not None:
            for k in self.criteria_list:
                result['CriteriaList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.criteria_list = []
        if m.get('CriteriaList') is not None:
            for k in m.get('CriteriaList'):
                temp_model = DescribeCriteriaResponseBodyCriteriaList()
                self.criteria_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeCriteriaResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeCriteriaResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCriteriaResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeCriteriaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDialogMessagesRequest(TeaModel):
    def __init__(self, source_ip=None):
        self.source_ip = source_ip  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDialogMessagesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeDialogMessagesResponseBodyDialogList(TeaModel):
    def __init__(self, dialog_key=None, id=None, params=None):
        self.dialog_key = dialog_key  # type: str
        self.id = id  # type: long
        self.params = params  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDialogMessagesResponseBodyDialogList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dialog_key is not None:
            result['DialogKey'] = self.dialog_key
        if self.id is not None:
            result['ID'] = self.id
        if self.params is not None:
            result['Params'] = self.params
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DialogKey') is not None:
            self.dialog_key = m.get('DialogKey')
        if m.get('ID') is not None:
            self.id = m.get('ID')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        return self


class DescribeDialogMessagesResponseBody(TeaModel):
    def __init__(self, dialog_list=None, request_id=None, total_count=None):
        self.dialog_list = dialog_list  # type: list[DescribeDialogMessagesResponseBodyDialogList]
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: int

    def validate(self):
        if self.dialog_list:
            for k in self.dialog_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDialogMessagesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DialogList'] = []
        if self.dialog_list is not None:
            for k in self.dialog_list:
                result['DialogList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.dialog_list = []
        if m.get('DialogList') is not None:
            for k in m.get('DialogList'):
                temp_model = DescribeDialogMessagesResponseBodyDialogList()
                self.dialog_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeDialogMessagesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeDialogMessagesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDialogMessagesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDialogMessagesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDingTalkRequest(TeaModel):
    def __init__(self, current_page=None, page_size=None, rule_action_name=None):
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.rule_action_name = rule_action_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDingTalkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.rule_action_name is not None:
            result['RuleActionName'] = self.rule_action_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RuleActionName') is not None:
            self.rule_action_name = m.get('RuleActionName')
        return self


class DescribeDingTalkResponseBodyActionList(TeaModel):
    def __init__(self, action_name=None, ali_uid=None, config_list=None, ding_talk_lang=None, gmt_create=None,
                 gmt_modified=None, group_id_list=None, id=None, interval_time=None, status=None, url=None):
        self.action_name = action_name  # type: str
        self.ali_uid = ali_uid  # type: long
        self.config_list = config_list  # type: str
        self.ding_talk_lang = ding_talk_lang  # type: str
        self.gmt_create = gmt_create  # type: long
        self.gmt_modified = gmt_modified  # type: long
        self.group_id_list = group_id_list  # type: str
        self.id = id  # type: int
        self.interval_time = interval_time  # type: int
        self.status = status  # type: int
        self.url = url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDingTalkResponseBodyActionList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.action_name is not None:
            result['ActionName'] = self.action_name
        if self.ali_uid is not None:
            result['AliUid'] = self.ali_uid
        if self.config_list is not None:
            result['ConfigList'] = self.config_list
        if self.ding_talk_lang is not None:
            result['DingTalkLang'] = self.ding_talk_lang
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.group_id_list is not None:
            result['GroupIdList'] = self.group_id_list
        if self.id is not None:
            result['Id'] = self.id
        if self.interval_time is not None:
            result['IntervalTime'] = self.interval_time
        if self.status is not None:
            result['Status'] = self.status
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ActionName') is not None:
            self.action_name = m.get('ActionName')
        if m.get('AliUid') is not None:
            self.ali_uid = m.get('AliUid')
        if m.get('ConfigList') is not None:
            self.config_list = m.get('ConfigList')
        if m.get('DingTalkLang') is not None:
            self.ding_talk_lang = m.get('DingTalkLang')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('GroupIdList') is not None:
            self.group_id_list = m.get('GroupIdList')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('IntervalTime') is not None:
            self.interval_time = m.get('IntervalTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class DescribeDingTalkResponseBodyPageInfo(TeaModel):
    def __init__(self, current_page=None, page_size=None, total_count=None):
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDingTalkResponseBodyPageInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeDingTalkResponseBody(TeaModel):
    def __init__(self, action_list=None, page_info=None, request_id=None):
        self.action_list = action_list  # type: list[DescribeDingTalkResponseBodyActionList]
        self.page_info = page_info  # type: DescribeDingTalkResponseBodyPageInfo
        self.request_id = request_id  # type: str

    def validate(self):
        if self.action_list:
            for k in self.action_list:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super(DescribeDingTalkResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ActionList'] = []
        if self.action_list is not None:
            for k in self.action_list:
                result['ActionList'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.action_list = []
        if m.get('ActionList') is not None:
            for k in m.get('ActionList'):
                temp_model = DescribeDingTalkResponseBodyActionList()
                self.action_list.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeDingTalkResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDingTalkResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeDingTalkResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDingTalkResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDingTalkResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDomainCountRequest(TeaModel):
    def __init__(self, source_ip=None):
        self.source_ip = source_ip  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDomainCountRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeDomainCountResponseBody(TeaModel):
    def __init__(self, request_id=None, root_domains_count=None, sub_domains_count=None, total_domains_count=None):
        self.request_id = request_id  # type: str
        self.root_domains_count = root_domains_count  # type: int
        self.sub_domains_count = sub_domains_count  # type: int
        self.total_domains_count = total_domains_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDomainCountResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.root_domains_count is not None:
            result['RootDomainsCount'] = self.root_domains_count
        if self.sub_domains_count is not None:
            result['SubDomainsCount'] = self.sub_domains_count
        if self.total_domains_count is not None:
            result['TotalDomainsCount'] = self.total_domains_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RootDomainsCount') is not None:
            self.root_domains_count = m.get('RootDomainsCount')
        if m.get('SubDomainsCount') is not None:
            self.sub_domains_count = m.get('SubDomainsCount')
        if m.get('TotalDomainsCount') is not None:
            self.total_domains_count = m.get('TotalDomainsCount')
        return self


class DescribeDomainCountResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeDomainCountResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDomainCountResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDomainCountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDomainDetailRequest(TeaModel):
    def __init__(self, domain_name=None, source_ip=None):
        self.domain_name = domain_name  # type: str
        self.source_ip = source_ip  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDomainDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeDomainDetailResponseBodyDomainDetailItems(TeaModel):
    def __init__(self, asset_type=None, instance_id=None, instance_name=None, internet_ip=None, intranet_ip=None,
                 uuid=None):
        self.asset_type = asset_type  # type: str
        self.instance_id = instance_id  # type: str
        self.instance_name = instance_name  # type: str
        self.internet_ip = internet_ip  # type: str
        self.intranet_ip = intranet_ip  # type: str
        self.uuid = uuid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDomainDetailResponseBodyDomainDetailItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.asset_type is not None:
            result['AssetType'] = self.asset_type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AssetType') is not None:
            self.asset_type = m.get('AssetType')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeDomainDetailResponseBody(TeaModel):
    def __init__(self, alarm_count=None, domain=None, domain_detail_items=None, request_id=None, root_domain=None,
                 vul_count=None):
        self.alarm_count = alarm_count  # type: int
        self.domain = domain  # type: str
        self.domain_detail_items = domain_detail_items  # type: list[DescribeDomainDetailResponseBodyDomainDetailItems]
        self.request_id = request_id  # type: str
        self.root_domain = root_domain  # type: str
        self.vul_count = vul_count  # type: int

    def validate(self):
        if self.domain_detail_items:
            for k in self.domain_detail_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDomainDetailResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_count is not None:
            result['AlarmCount'] = self.alarm_count
        if self.domain is not None:
            result['Domain'] = self.domain
        result['DomainDetailItems'] = []
        if self.domain_detail_items is not None:
            for k in self.domain_detail_items:
                result['DomainDetailItems'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.root_domain is not None:
            result['RootDomain'] = self.root_domain
        if self.vul_count is not None:
            result['VulCount'] = self.vul_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlarmCount') is not None:
            self.alarm_count = m.get('AlarmCount')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        self.domain_detail_items = []
        if m.get('DomainDetailItems') is not None:
            for k in m.get('DomainDetailItems'):
                temp_model = DescribeDomainDetailResponseBodyDomainDetailItems()
                self.domain_detail_items.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RootDomain') is not None:
            self.root_domain = m.get('RootDomain')
        if m.get('VulCount') is not None:
            self.vul_count = m.get('VulCount')
        return self


class DescribeDomainDetailResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeDomainDetailResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDomainDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDomainDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDomainListRequest(TeaModel):
    def __init__(self, current_page=None, domain_type=None, fuzzy_domain=None, page_size=None, source_ip=None):
        self.current_page = current_page  # type: int
        self.domain_type = domain_type  # type: str
        self.fuzzy_domain = fuzzy_domain  # type: str
        self.page_size = page_size  # type: int
        self.source_ip = source_ip  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDomainListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.domain_type is not None:
            result['DomainType'] = self.domain_type
        if self.fuzzy_domain is not None:
            result['FuzzyDomain'] = self.fuzzy_domain
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DomainType') is not None:
            self.domain_type = m.get('DomainType')
        if m.get('FuzzyDomain') is not None:
            self.fuzzy_domain = m.get('FuzzyDomain')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeDomainListResponseBodyDomainListResponseList(TeaModel):
    def __init__(self, domain=None, ip_list=None):
        self.domain = domain  # type: str
        self.ip_list = ip_list  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDomainListResponseBodyDomainListResponseList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.ip_list is not None:
            result['IpList'] = self.ip_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('IpList') is not None:
            self.ip_list = m.get('IpList')
        return self


class DescribeDomainListResponseBodyPageInfo(TeaModel):
    def __init__(self, count=None, current_page=None, page_size=None, total_count=None):
        self.count = count  # type: int
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDomainListResponseBodyPageInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeDomainListResponseBody(TeaModel):
    def __init__(self, domain_list_response_list=None, page_info=None, request_id=None):
        self.domain_list_response_list = domain_list_response_list  # type: list[DescribeDomainListResponseBodyDomainListResponseList]
        self.page_info = page_info  # type: DescribeDomainListResponseBodyPageInfo
        self.request_id = request_id  # type: str

    def validate(self):
        if self.domain_list_response_list:
            for k in self.domain_list_response_list:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super(DescribeDomainListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DomainListResponseList'] = []
        if self.domain_list_response_list is not None:
            for k in self.domain_list_response_list:
                result['DomainListResponseList'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.domain_list_response_list = []
        if m.get('DomainListResponseList') is not None:
            for k in m.get('DomainListResponseList'):
                temp_model = DescribeDomainListResponseBodyDomainListResponseList()
                self.domain_list_response_list.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeDomainListResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDomainListResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeDomainListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDomainListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDomainListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeEmgVulItemRequest(TeaModel):
    def __init__(self, current_page=None, lang=None, page_size=None, risk_status=None, scan_type=None, vul_name=None):
        self.current_page = current_page  # type: int
        self.lang = lang  # type: str
        self.page_size = page_size  # type: int
        self.risk_status = risk_status  # type: str
        self.scan_type = scan_type  # type: str
        self.vul_name = vul_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeEmgVulItemRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.risk_status is not None:
            result['RiskStatus'] = self.risk_status
        if self.scan_type is not None:
            result['ScanType'] = self.scan_type
        if self.vul_name is not None:
            result['VulName'] = self.vul_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RiskStatus') is not None:
            self.risk_status = m.get('RiskStatus')
        if m.get('ScanType') is not None:
            self.scan_type = m.get('ScanType')
        if m.get('VulName') is not None:
            self.vul_name = m.get('VulName')
        return self


class DescribeEmgVulItemResponseBodyGroupedVulItems(TeaModel):
    def __init__(self, alias_name=None, gmt_last_check=None, gmt_publish=None, name=None, pending_count=None,
                 progress=None, status=None, type=None):
        self.alias_name = alias_name  # type: str
        self.gmt_last_check = gmt_last_check  # type: long
        self.gmt_publish = gmt_publish  # type: long
        self.name = name  # type: str
        self.pending_count = pending_count  # type: int
        self.progress = progress  # type: int
        self.status = status  # type: int
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeEmgVulItemResponseBodyGroupedVulItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.gmt_last_check is not None:
            result['GmtLastCheck'] = self.gmt_last_check
        if self.gmt_publish is not None:
            result['GmtPublish'] = self.gmt_publish
        if self.name is not None:
            result['Name'] = self.name
        if self.pending_count is not None:
            result['PendingCount'] = self.pending_count
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('GmtLastCheck') is not None:
            self.gmt_last_check = m.get('GmtLastCheck')
        if m.get('GmtPublish') is not None:
            self.gmt_publish = m.get('GmtPublish')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PendingCount') is not None:
            self.pending_count = m.get('PendingCount')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeEmgVulItemResponseBody(TeaModel):
    def __init__(self, current_page=None, grouped_vul_items=None, page_size=None, request_id=None, total_count=None):
        self.current_page = current_page  # type: int
        self.grouped_vul_items = grouped_vul_items  # type: list[DescribeEmgVulItemResponseBodyGroupedVulItems]
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: int

    def validate(self):
        if self.grouped_vul_items:
            for k in self.grouped_vul_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeEmgVulItemResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        result['GroupedVulItems'] = []
        if self.grouped_vul_items is not None:
            for k in self.grouped_vul_items:
                result['GroupedVulItems'].append(k.to_map() if k else None)
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        self.grouped_vul_items = []
        if m.get('GroupedVulItems') is not None:
            for k in m.get('GroupedVulItems'):
                temp_model = DescribeEmgVulItemResponseBodyGroupedVulItems()
                self.grouped_vul_items.append(temp_model.from_map(k))
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeEmgVulItemResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeEmgVulItemResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeEmgVulItemResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeEmgVulItemResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeExportInfoRequest(TeaModel):
    def __init__(self, export_id=None):
        self.export_id = export_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeExportInfoRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.export_id is not None:
            result['ExportId'] = self.export_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ExportId') is not None:
            self.export_id = m.get('ExportId')
        return self


class DescribeExportInfoResponseBody(TeaModel):
    def __init__(self, current_count=None, export_status=None, file_name=None, id=None, link=None, message=None,
                 progress=None, request_id=None, total_count=None):
        self.current_count = current_count  # type: int
        self.export_status = export_status  # type: str
        self.file_name = file_name  # type: str
        self.id = id  # type: long
        self.link = link  # type: str
        self.message = message  # type: str
        self.progress = progress  # type: int
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeExportInfoResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_count is not None:
            result['CurrentCount'] = self.current_count
        if self.export_status is not None:
            result['ExportStatus'] = self.export_status
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.id is not None:
            result['Id'] = self.id
        if self.link is not None:
            result['Link'] = self.link
        if self.message is not None:
            result['Message'] = self.message
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentCount') is not None:
            self.current_count = m.get('CurrentCount')
        if m.get('ExportStatus') is not None:
            self.export_status = m.get('ExportStatus')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Link') is not None:
            self.link = m.get('Link')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeExportInfoResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeExportInfoResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeExportInfoResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeExportInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeExposedInstanceCriteriaRequest(TeaModel):
    def __init__(self, value=None):
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeExposedInstanceCriteriaRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeExposedInstanceCriteriaResponseBodyCriteriaList(TeaModel):
    def __init__(self, name=None, type=None, values=None):
        self.name = name  # type: str
        self.type = type  # type: str
        self.values = values  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeExposedInstanceCriteriaResponseBodyCriteriaList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        if self.values is not None:
            result['Values'] = self.values
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Values') is not None:
            self.values = m.get('Values')
        return self


class DescribeExposedInstanceCriteriaResponseBody(TeaModel):
    def __init__(self, criteria_list=None, request_id=None):
        self.criteria_list = criteria_list  # type: list[DescribeExposedInstanceCriteriaResponseBodyCriteriaList]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.criteria_list:
            for k in self.criteria_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeExposedInstanceCriteriaResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CriteriaList'] = []
        if self.criteria_list is not None:
            for k in self.criteria_list:
                result['CriteriaList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.criteria_list = []
        if m.get('CriteriaList') is not None:
            for k in m.get('CriteriaList'):
                temp_model = DescribeExposedInstanceCriteriaResponseBodyCriteriaList()
                self.criteria_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeExposedInstanceCriteriaResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeExposedInstanceCriteriaResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeExposedInstanceCriteriaResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeExposedInstanceCriteriaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeExposedInstanceDetailRequest(TeaModel):
    def __init__(self, uuid=None):
        self.uuid = uuid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeExposedInstanceDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeExposedInstanceDetailResponseBodyExposedChainsAllVulList(TeaModel):
    def __init__(self, alias_name=None, name=None, necessity=None, type=None, uuid=None):
        self.alias_name = alias_name  # type: str
        self.name = name  # type: str
        self.necessity = necessity  # type: str
        self.type = type  # type: str
        self.uuid = uuid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeExposedInstanceDetailResponseBodyExposedChainsAllVulList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.name is not None:
            result['Name'] = self.name
        if self.necessity is not None:
            result['Necessity'] = self.necessity
        if self.type is not None:
            result['Type'] = self.type
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Necessity') is not None:
            self.necessity = m.get('Necessity')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeExposedInstanceDetailResponseBodyExposedChainsRealVulList(TeaModel):
    def __init__(self, alias_name=None, name=None, necessity=None, type=None, uuid=None):
        self.alias_name = alias_name  # type: str
        self.name = name  # type: str
        self.necessity = necessity  # type: str
        self.type = type  # type: str
        self.uuid = uuid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeExposedInstanceDetailResponseBodyExposedChainsRealVulList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.name is not None:
            result['Name'] = self.name
        if self.necessity is not None:
            result['Necessity'] = self.necessity
        if self.type is not None:
            result['Type'] = self.type
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Necessity') is not None:
            self.necessity = m.get('Necessity')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeExposedInstanceDetailResponseBodyExposedChains(TeaModel):
    def __init__(self, all_vul_list=None, exposure_component=None, exposure_ip=None, exposure_port=None,
                 exposure_type=None, exposure_type_id=None, group_no=None, instance_id=None, instance_name=None, internet_ip=None,
                 intranet_ip=None, real_vul_list=None, region_id=None, uuid=None):
        self.all_vul_list = all_vul_list  # type: list[DescribeExposedInstanceDetailResponseBodyExposedChainsAllVulList]
        self.exposure_component = exposure_component  # type: str
        self.exposure_ip = exposure_ip  # type: str
        self.exposure_port = exposure_port  # type: str
        self.exposure_type = exposure_type  # type: str
        self.exposure_type_id = exposure_type_id  # type: str
        self.group_no = group_no  # type: str
        self.instance_id = instance_id  # type: str
        self.instance_name = instance_name  # type: str
        self.internet_ip = internet_ip  # type: str
        self.intranet_ip = intranet_ip  # type: str
        self.real_vul_list = real_vul_list  # type: list[DescribeExposedInstanceDetailResponseBodyExposedChainsRealVulList]
        self.region_id = region_id  # type: str
        self.uuid = uuid  # type: str

    def validate(self):
        if self.all_vul_list:
            for k in self.all_vul_list:
                if k:
                    k.validate()
        if self.real_vul_list:
            for k in self.real_vul_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeExposedInstanceDetailResponseBodyExposedChains, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AllVulList'] = []
        if self.all_vul_list is not None:
            for k in self.all_vul_list:
                result['AllVulList'].append(k.to_map() if k else None)
        if self.exposure_component is not None:
            result['ExposureComponent'] = self.exposure_component
        if self.exposure_ip is not None:
            result['ExposureIp'] = self.exposure_ip
        if self.exposure_port is not None:
            result['ExposurePort'] = self.exposure_port
        if self.exposure_type is not None:
            result['ExposureType'] = self.exposure_type
        if self.exposure_type_id is not None:
            result['ExposureTypeId'] = self.exposure_type_id
        if self.group_no is not None:
            result['GroupNo'] = self.group_no
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        result['RealVulList'] = []
        if self.real_vul_list is not None:
            for k in self.real_vul_list:
                result['RealVulList'].append(k.to_map() if k else None)
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.all_vul_list = []
        if m.get('AllVulList') is not None:
            for k in m.get('AllVulList'):
                temp_model = DescribeExposedInstanceDetailResponseBodyExposedChainsAllVulList()
                self.all_vul_list.append(temp_model.from_map(k))
        if m.get('ExposureComponent') is not None:
            self.exposure_component = m.get('ExposureComponent')
        if m.get('ExposureIp') is not None:
            self.exposure_ip = m.get('ExposureIp')
        if m.get('ExposurePort') is not None:
            self.exposure_port = m.get('ExposurePort')
        if m.get('ExposureType') is not None:
            self.exposure_type = m.get('ExposureType')
        if m.get('ExposureTypeId') is not None:
            self.exposure_type_id = m.get('ExposureTypeId')
        if m.get('GroupNo') is not None:
            self.group_no = m.get('GroupNo')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        self.real_vul_list = []
        if m.get('RealVulList') is not None:
            for k in m.get('RealVulList'):
                temp_model = DescribeExposedInstanceDetailResponseBodyExposedChainsRealVulList()
                self.real_vul_list.append(temp_model.from_map(k))
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeExposedInstanceDetailResponseBody(TeaModel):
    def __init__(self, exposed_chains=None, request_id=None):
        self.exposed_chains = exposed_chains  # type: list[DescribeExposedInstanceDetailResponseBodyExposedChains]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.exposed_chains:
            for k in self.exposed_chains:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeExposedInstanceDetailResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ExposedChains'] = []
        if self.exposed_chains is not None:
            for k in self.exposed_chains:
                result['ExposedChains'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.exposed_chains = []
        if m.get('ExposedChains') is not None:
            for k in m.get('ExposedChains'):
                temp_model = DescribeExposedInstanceDetailResponseBodyExposedChains()
                self.exposed_chains.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeExposedInstanceDetailResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeExposedInstanceDetailResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeExposedInstanceDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeExposedInstanceDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeExposedInstanceListRequest(TeaModel):
    def __init__(self, current_page=None, exposure_component=None, exposure_ip=None, exposure_port=None,
                 group_id=None, health_status=None, instance_id=None, instance_name=None, page_size=None, vul_status=None):
        self.current_page = current_page  # type: int
        self.exposure_component = exposure_component  # type: str
        self.exposure_ip = exposure_ip  # type: str
        self.exposure_port = exposure_port  # type: str
        self.group_id = group_id  # type: long
        self.health_status = health_status  # type: bool
        self.instance_id = instance_id  # type: str
        self.instance_name = instance_name  # type: str
        self.page_size = page_size  # type: int
        self.vul_status = vul_status  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeExposedInstanceListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.exposure_component is not None:
            result['ExposureComponent'] = self.exposure_component
        if self.exposure_ip is not None:
            result['ExposureIp'] = self.exposure_ip
        if self.exposure_port is not None:
            result['ExposurePort'] = self.exposure_port
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.health_status is not None:
            result['HealthStatus'] = self.health_status
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.vul_status is not None:
            result['VulStatus'] = self.vul_status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('ExposureComponent') is not None:
            self.exposure_component = m.get('ExposureComponent')
        if m.get('ExposureIp') is not None:
            self.exposure_ip = m.get('ExposureIp')
        if m.get('ExposurePort') is not None:
            self.exposure_port = m.get('ExposurePort')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('HealthStatus') is not None:
            self.health_status = m.get('HealthStatus')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('VulStatus') is not None:
            self.vul_status = m.get('VulStatus')
        return self


class DescribeExposedInstanceListResponseBodyExposedInstances(TeaModel):
    def __init__(self, asap_vul_count=None, exploit_health_count=None, exposure_component=None, exposure_ip=None,
                 exposure_port=None, exposure_type=None, exposure_type_id=None, group_id=None, group_name=None, instance_id=None,
                 instance_name=None, internet_ip=None, intranet_ip=None, later_vul_count=None, nntf_vul_count=None,
                 region_id=None, total_vul_count=None, uuid=None):
        self.asap_vul_count = asap_vul_count  # type: int
        self.exploit_health_count = exploit_health_count  # type: int
        self.exposure_component = exposure_component  # type: str
        self.exposure_ip = exposure_ip  # type: str
        self.exposure_port = exposure_port  # type: str
        self.exposure_type = exposure_type  # type: str
        self.exposure_type_id = exposure_type_id  # type: str
        self.group_id = group_id  # type: long
        self.group_name = group_name  # type: str
        self.instance_id = instance_id  # type: str
        self.instance_name = instance_name  # type: str
        self.internet_ip = internet_ip  # type: str
        self.intranet_ip = intranet_ip  # type: str
        self.later_vul_count = later_vul_count  # type: int
        self.nntf_vul_count = nntf_vul_count  # type: int
        self.region_id = region_id  # type: str
        self.total_vul_count = total_vul_count  # type: int
        self.uuid = uuid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeExposedInstanceListResponseBodyExposedInstances, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.asap_vul_count is not None:
            result['AsapVulCount'] = self.asap_vul_count
        if self.exploit_health_count is not None:
            result['ExploitHealthCount'] = self.exploit_health_count
        if self.exposure_component is not None:
            result['ExposureComponent'] = self.exposure_component
        if self.exposure_ip is not None:
            result['ExposureIp'] = self.exposure_ip
        if self.exposure_port is not None:
            result['ExposurePort'] = self.exposure_port
        if self.exposure_type is not None:
            result['ExposureType'] = self.exposure_type
        if self.exposure_type_id is not None:
            result['ExposureTypeId'] = self.exposure_type_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.later_vul_count is not None:
            result['LaterVulCount'] = self.later_vul_count
        if self.nntf_vul_count is not None:
            result['NntfVulCount'] = self.nntf_vul_count
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.total_vul_count is not None:
            result['TotalVulCount'] = self.total_vul_count
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AsapVulCount') is not None:
            self.asap_vul_count = m.get('AsapVulCount')
        if m.get('ExploitHealthCount') is not None:
            self.exploit_health_count = m.get('ExploitHealthCount')
        if m.get('ExposureComponent') is not None:
            self.exposure_component = m.get('ExposureComponent')
        if m.get('ExposureIp') is not None:
            self.exposure_ip = m.get('ExposureIp')
        if m.get('ExposurePort') is not None:
            self.exposure_port = m.get('ExposurePort')
        if m.get('ExposureType') is not None:
            self.exposure_type = m.get('ExposureType')
        if m.get('ExposureTypeId') is not None:
            self.exposure_type_id = m.get('ExposureTypeId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('LaterVulCount') is not None:
            self.later_vul_count = m.get('LaterVulCount')
        if m.get('NntfVulCount') is not None:
            self.nntf_vul_count = m.get('NntfVulCount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TotalVulCount') is not None:
            self.total_vul_count = m.get('TotalVulCount')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeExposedInstanceListResponseBodyPageInfo(TeaModel):
    def __init__(self, count=None, current_page=None, page_size=None, total_count=None):
        self.count = count  # type: int
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeExposedInstanceListResponseBodyPageInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeExposedInstanceListResponseBody(TeaModel):
    def __init__(self, exposed_instances=None, page_info=None, request_id=None):
        self.exposed_instances = exposed_instances  # type: list[DescribeExposedInstanceListResponseBodyExposedInstances]
        self.page_info = page_info  # type: DescribeExposedInstanceListResponseBodyPageInfo
        self.request_id = request_id  # type: str

    def validate(self):
        if self.exposed_instances:
            for k in self.exposed_instances:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super(DescribeExposedInstanceListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ExposedInstances'] = []
        if self.exposed_instances is not None:
            for k in self.exposed_instances:
                result['ExposedInstances'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.exposed_instances = []
        if m.get('ExposedInstances') is not None:
            for k in m.get('ExposedInstances'):
                temp_model = DescribeExposedInstanceListResponseBodyExposedInstances()
                self.exposed_instances.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeExposedInstanceListResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeExposedInstanceListResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeExposedInstanceListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeExposedInstanceListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeExposedInstanceListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeExposedStatisticsResponseBody(TeaModel):
    def __init__(self, exposed_asap_vul_count=None, exposed_component_count=None, exposed_instance_count=None,
                 exposed_ip_count=None, exposed_later_vul_count=None, exposed_nntf_vul_count=None, exposed_port_count=None,
                 exposed_week_password_machine_count=None, gateway_asset_count=None, request_id=None):
        self.exposed_asap_vul_count = exposed_asap_vul_count  # type: int
        self.exposed_component_count = exposed_component_count  # type: int
        self.exposed_instance_count = exposed_instance_count  # type: int
        self.exposed_ip_count = exposed_ip_count  # type: int
        self.exposed_later_vul_count = exposed_later_vul_count  # type: int
        self.exposed_nntf_vul_count = exposed_nntf_vul_count  # type: int
        self.exposed_port_count = exposed_port_count  # type: int
        self.exposed_week_password_machine_count = exposed_week_password_machine_count  # type: int
        self.gateway_asset_count = gateway_asset_count  # type: int
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeExposedStatisticsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.exposed_asap_vul_count is not None:
            result['ExposedAsapVulCount'] = self.exposed_asap_vul_count
        if self.exposed_component_count is not None:
            result['ExposedComponentCount'] = self.exposed_component_count
        if self.exposed_instance_count is not None:
            result['ExposedInstanceCount'] = self.exposed_instance_count
        if self.exposed_ip_count is not None:
            result['ExposedIpCount'] = self.exposed_ip_count
        if self.exposed_later_vul_count is not None:
            result['ExposedLaterVulCount'] = self.exposed_later_vul_count
        if self.exposed_nntf_vul_count is not None:
            result['ExposedNntfVulCount'] = self.exposed_nntf_vul_count
        if self.exposed_port_count is not None:
            result['ExposedPortCount'] = self.exposed_port_count
        if self.exposed_week_password_machine_count is not None:
            result['ExposedWeekPasswordMachineCount'] = self.exposed_week_password_machine_count
        if self.gateway_asset_count is not None:
            result['GatewayAssetCount'] = self.gateway_asset_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ExposedAsapVulCount') is not None:
            self.exposed_asap_vul_count = m.get('ExposedAsapVulCount')
        if m.get('ExposedComponentCount') is not None:
            self.exposed_component_count = m.get('ExposedComponentCount')
        if m.get('ExposedInstanceCount') is not None:
            self.exposed_instance_count = m.get('ExposedInstanceCount')
        if m.get('ExposedIpCount') is not None:
            self.exposed_ip_count = m.get('ExposedIpCount')
        if m.get('ExposedLaterVulCount') is not None:
            self.exposed_later_vul_count = m.get('ExposedLaterVulCount')
        if m.get('ExposedNntfVulCount') is not None:
            self.exposed_nntf_vul_count = m.get('ExposedNntfVulCount')
        if m.get('ExposedPortCount') is not None:
            self.exposed_port_count = m.get('ExposedPortCount')
        if m.get('ExposedWeekPasswordMachineCount') is not None:
            self.exposed_week_password_machine_count = m.get('ExposedWeekPasswordMachineCount')
        if m.get('GatewayAssetCount') is not None:
            self.gateway_asset_count = m.get('GatewayAssetCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeExposedStatisticsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeExposedStatisticsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeExposedStatisticsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeExposedStatisticsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeExposedStatisticsDetailRequest(TeaModel):
    def __init__(self, current_page=None, page_size=None, statistics_type=None, statistics_type_gateway_type=None,
                 statistics_type_instance_value=None):
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.statistics_type = statistics_type  # type: str
        self.statistics_type_gateway_type = statistics_type_gateway_type  # type: str
        self.statistics_type_instance_value = statistics_type_instance_value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeExposedStatisticsDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.statistics_type is not None:
            result['StatisticsType'] = self.statistics_type
        if self.statistics_type_gateway_type is not None:
            result['StatisticsTypeGatewayType'] = self.statistics_type_gateway_type
        if self.statistics_type_instance_value is not None:
            result['StatisticsTypeInstanceValue'] = self.statistics_type_instance_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StatisticsType') is not None:
            self.statistics_type = m.get('StatisticsType')
        if m.get('StatisticsTypeGatewayType') is not None:
            self.statistics_type_gateway_type = m.get('StatisticsTypeGatewayType')
        if m.get('StatisticsTypeInstanceValue') is not None:
            self.statistics_type_instance_value = m.get('StatisticsTypeInstanceValue')
        return self


class DescribeExposedStatisticsDetailResponseBodyPageInfo(TeaModel):
    def __init__(self, count=None, current_page=None, page_size=None, total_count=None):
        self.count = count  # type: int
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeExposedStatisticsDetailResponseBodyPageInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeExposedStatisticsDetailResponseBodyStatisticsDetails(TeaModel):
    def __init__(self, exposed_count=None, exposure_component=None, exposure_ip=None, exposure_port=None,
                 exposure_type=None, exposure_type_id=None, exposure_type_instance_name=None, region_id=None):
        self.exposed_count = exposed_count  # type: int
        self.exposure_component = exposure_component  # type: str
        self.exposure_ip = exposure_ip  # type: str
        self.exposure_port = exposure_port  # type: str
        self.exposure_type = exposure_type  # type: str
        self.exposure_type_id = exposure_type_id  # type: str
        self.exposure_type_instance_name = exposure_type_instance_name  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeExposedStatisticsDetailResponseBodyStatisticsDetails, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.exposed_count is not None:
            result['ExposedCount'] = self.exposed_count
        if self.exposure_component is not None:
            result['ExposureComponent'] = self.exposure_component
        if self.exposure_ip is not None:
            result['ExposureIp'] = self.exposure_ip
        if self.exposure_port is not None:
            result['ExposurePort'] = self.exposure_port
        if self.exposure_type is not None:
            result['ExposureType'] = self.exposure_type
        if self.exposure_type_id is not None:
            result['ExposureTypeId'] = self.exposure_type_id
        if self.exposure_type_instance_name is not None:
            result['ExposureTypeInstanceName'] = self.exposure_type_instance_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ExposedCount') is not None:
            self.exposed_count = m.get('ExposedCount')
        if m.get('ExposureComponent') is not None:
            self.exposure_component = m.get('ExposureComponent')
        if m.get('ExposureIp') is not None:
            self.exposure_ip = m.get('ExposureIp')
        if m.get('ExposurePort') is not None:
            self.exposure_port = m.get('ExposurePort')
        if m.get('ExposureType') is not None:
            self.exposure_type = m.get('ExposureType')
        if m.get('ExposureTypeId') is not None:
            self.exposure_type_id = m.get('ExposureTypeId')
        if m.get('ExposureTypeInstanceName') is not None:
            self.exposure_type_instance_name = m.get('ExposureTypeInstanceName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeExposedStatisticsDetailResponseBody(TeaModel):
    def __init__(self, page_info=None, request_id=None, statistics_details=None):
        self.page_info = page_info  # type: DescribeExposedStatisticsDetailResponseBodyPageInfo
        self.request_id = request_id  # type: str
        self.statistics_details = statistics_details  # type: list[DescribeExposedStatisticsDetailResponseBodyStatisticsDetails]

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.statistics_details:
            for k in self.statistics_details:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeExposedStatisticsDetailResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['StatisticsDetails'] = []
        if self.statistics_details is not None:
            for k in self.statistics_details:
                result['StatisticsDetails'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageInfo') is not None:
            temp_model = DescribeExposedStatisticsDetailResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.statistics_details = []
        if m.get('StatisticsDetails') is not None:
            for k in m.get('StatisticsDetails'):
                temp_model = DescribeExposedStatisticsDetailResponseBodyStatisticsDetails()
                self.statistics_details.append(temp_model.from_map(k))
        return self


class DescribeExposedStatisticsDetailResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeExposedStatisticsDetailResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeExposedStatisticsDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeExposedStatisticsDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeFieldStatisticsRequest(TeaModel):
    def __init__(self, machine_types=None, region_id=None):
        self.machine_types = machine_types  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeFieldStatisticsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.machine_types is not None:
            result['MachineTypes'] = self.machine_types
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MachineTypes') is not None:
            self.machine_types = m.get('MachineTypes')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeFieldStatisticsResponseBodyGroupedFields(TeaModel):
    def __init__(self, ali_yun_instance_count=None, exposed_instance_count=None, general_asset_count=None,
                 group_count=None, huawei_instance_count=None, idc_instance_count=None, important_asset_count=None,
                 instance_count=None, instance_sync_task_count=None, new_instance_count=None, not_running_status_count=None,
                 offline_instance_count=None, pause_instance_count=None, region_count=None, risk_instance_count=None,
                 tencent_instance_count=None, test_asset_count=None, unprotected_instance_count=None, vpc_count=None):
        self.ali_yun_instance_count = ali_yun_instance_count  # type: int
        self.exposed_instance_count = exposed_instance_count  # type: int
        self.general_asset_count = general_asset_count  # type: int
        self.group_count = group_count  # type: int
        self.huawei_instance_count = huawei_instance_count  # type: int
        self.idc_instance_count = idc_instance_count  # type: int
        self.important_asset_count = important_asset_count  # type: int
        self.instance_count = instance_count  # type: int
        self.instance_sync_task_count = instance_sync_task_count  # type: int
        self.new_instance_count = new_instance_count  # type: int
        self.not_running_status_count = not_running_status_count  # type: int
        self.offline_instance_count = offline_instance_count  # type: int
        self.pause_instance_count = pause_instance_count  # type: int
        self.region_count = region_count  # type: int
        self.risk_instance_count = risk_instance_count  # type: int
        self.tencent_instance_count = tencent_instance_count  # type: int
        self.test_asset_count = test_asset_count  # type: int
        self.unprotected_instance_count = unprotected_instance_count  # type: int
        self.vpc_count = vpc_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeFieldStatisticsResponseBodyGroupedFields, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ali_yun_instance_count is not None:
            result['AliYunInstanceCount'] = self.ali_yun_instance_count
        if self.exposed_instance_count is not None:
            result['ExposedInstanceCount'] = self.exposed_instance_count
        if self.general_asset_count is not None:
            result['GeneralAssetCount'] = self.general_asset_count
        if self.group_count is not None:
            result['GroupCount'] = self.group_count
        if self.huawei_instance_count is not None:
            result['HuaweiInstanceCount'] = self.huawei_instance_count
        if self.idc_instance_count is not None:
            result['IdcInstanceCount'] = self.idc_instance_count
        if self.important_asset_count is not None:
            result['ImportantAssetCount'] = self.important_asset_count
        if self.instance_count is not None:
            result['InstanceCount'] = self.instance_count
        if self.instance_sync_task_count is not None:
            result['InstanceSyncTaskCount'] = self.instance_sync_task_count
        if self.new_instance_count is not None:
            result['NewInstanceCount'] = self.new_instance_count
        if self.not_running_status_count is not None:
            result['NotRunningStatusCount'] = self.not_running_status_count
        if self.offline_instance_count is not None:
            result['OfflineInstanceCount'] = self.offline_instance_count
        if self.pause_instance_count is not None:
            result['PauseInstanceCount'] = self.pause_instance_count
        if self.region_count is not None:
            result['RegionCount'] = self.region_count
        if self.risk_instance_count is not None:
            result['RiskInstanceCount'] = self.risk_instance_count
        if self.tencent_instance_count is not None:
            result['TencentInstanceCount'] = self.tencent_instance_count
        if self.test_asset_count is not None:
            result['TestAssetCount'] = self.test_asset_count
        if self.unprotected_instance_count is not None:
            result['UnprotectedInstanceCount'] = self.unprotected_instance_count
        if self.vpc_count is not None:
            result['VpcCount'] = self.vpc_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AliYunInstanceCount') is not None:
            self.ali_yun_instance_count = m.get('AliYunInstanceCount')
        if m.get('ExposedInstanceCount') is not None:
            self.exposed_instance_count = m.get('ExposedInstanceCount')
        if m.get('GeneralAssetCount') is not None:
            self.general_asset_count = m.get('GeneralAssetCount')
        if m.get('GroupCount') is not None:
            self.group_count = m.get('GroupCount')
        if m.get('HuaweiInstanceCount') is not None:
            self.huawei_instance_count = m.get('HuaweiInstanceCount')
        if m.get('IdcInstanceCount') is not None:
            self.idc_instance_count = m.get('IdcInstanceCount')
        if m.get('ImportantAssetCount') is not None:
            self.important_asset_count = m.get('ImportantAssetCount')
        if m.get('InstanceCount') is not None:
            self.instance_count = m.get('InstanceCount')
        if m.get('InstanceSyncTaskCount') is not None:
            self.instance_sync_task_count = m.get('InstanceSyncTaskCount')
        if m.get('NewInstanceCount') is not None:
            self.new_instance_count = m.get('NewInstanceCount')
        if m.get('NotRunningStatusCount') is not None:
            self.not_running_status_count = m.get('NotRunningStatusCount')
        if m.get('OfflineInstanceCount') is not None:
            self.offline_instance_count = m.get('OfflineInstanceCount')
        if m.get('PauseInstanceCount') is not None:
            self.pause_instance_count = m.get('PauseInstanceCount')
        if m.get('RegionCount') is not None:
            self.region_count = m.get('RegionCount')
        if m.get('RiskInstanceCount') is not None:
            self.risk_instance_count = m.get('RiskInstanceCount')
        if m.get('TencentInstanceCount') is not None:
            self.tencent_instance_count = m.get('TencentInstanceCount')
        if m.get('TestAssetCount') is not None:
            self.test_asset_count = m.get('TestAssetCount')
        if m.get('UnprotectedInstanceCount') is not None:
            self.unprotected_instance_count = m.get('UnprotectedInstanceCount')
        if m.get('VpcCount') is not None:
            self.vpc_count = m.get('VpcCount')
        return self


class DescribeFieldStatisticsResponseBody(TeaModel):
    def __init__(self, grouped_fields=None, request_id=None):
        self.grouped_fields = grouped_fields  # type: DescribeFieldStatisticsResponseBodyGroupedFields
        self.request_id = request_id  # type: str

    def validate(self):
        if self.grouped_fields:
            self.grouped_fields.validate()

    def to_map(self):
        _map = super(DescribeFieldStatisticsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.grouped_fields is not None:
            result['GroupedFields'] = self.grouped_fields.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupedFields') is not None:
            temp_model = DescribeFieldStatisticsResponseBodyGroupedFields()
            self.grouped_fields = temp_model.from_map(m['GroupedFields'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeFieldStatisticsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeFieldStatisticsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeFieldStatisticsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeFieldStatisticsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeGroupedContainerInstancesRequest(TeaModel):
    def __init__(self, criteria=None, current_page=None, field_value=None, group_field=None, logical_exp=None,
                 page_size=None):
        self.criteria = criteria  # type: str
        self.current_page = current_page  # type: int
        self.field_value = field_value  # type: str
        self.group_field = group_field  # type: str
        self.logical_exp = logical_exp  # type: str
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeGroupedContainerInstancesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.criteria is not None:
            result['Criteria'] = self.criteria
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.field_value is not None:
            result['FieldValue'] = self.field_value
        if self.group_field is not None:
            result['GroupField'] = self.group_field
        if self.logical_exp is not None:
            result['LogicalExp'] = self.logical_exp
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Criteria') is not None:
            self.criteria = m.get('Criteria')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('FieldValue') is not None:
            self.field_value = m.get('FieldValue')
        if m.get('GroupField') is not None:
            self.group_field = m.get('GroupField')
        if m.get('LogicalExp') is not None:
            self.logical_exp = m.get('LogicalExp')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeGroupedContainerInstancesResponseBodyGroupedContainerInstanceList(TeaModel):
    def __init__(self, alarm_count=None, app_name=None, cluster_id=None, cluster_name=None, cluster_type=None,
                 create_time=None, custer_state=None, host_ip=None, instance_count=None, instance_id=None, namespace=None,
                 pod=None, pod_ip=None, region_id=None, risk_instance_count=None, risk_level=None, risk_status=None,
                 vul_count=None):
        self.alarm_count = alarm_count  # type: int
        self.app_name = app_name  # type: str
        self.cluster_id = cluster_id  # type: str
        self.cluster_name = cluster_name  # type: str
        self.cluster_type = cluster_type  # type: str
        self.create_time = create_time  # type: long
        self.custer_state = custer_state  # type: str
        self.host_ip = host_ip  # type: str
        self.instance_count = instance_count  # type: int
        self.instance_id = instance_id  # type: str
        self.namespace = namespace  # type: str
        self.pod = pod  # type: str
        self.pod_ip = pod_ip  # type: str
        self.region_id = region_id  # type: str
        self.risk_instance_count = risk_instance_count  # type: int
        self.risk_level = risk_level  # type: str
        self.risk_status = risk_status  # type: str
        self.vul_count = vul_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeGroupedContainerInstancesResponseBodyGroupedContainerInstanceList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_count is not None:
            result['AlarmCount'] = self.alarm_count
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.cluster_type is not None:
            result['ClusterType'] = self.cluster_type
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.custer_state is not None:
            result['CusterState'] = self.custer_state
        if self.host_ip is not None:
            result['HostIp'] = self.host_ip
        if self.instance_count is not None:
            result['InstanceCount'] = self.instance_count
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.pod is not None:
            result['Pod'] = self.pod
        if self.pod_ip is not None:
            result['PodIp'] = self.pod_ip
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.risk_instance_count is not None:
            result['RiskInstanceCount'] = self.risk_instance_count
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        if self.risk_status is not None:
            result['RiskStatus'] = self.risk_status
        if self.vul_count is not None:
            result['VulCount'] = self.vul_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlarmCount') is not None:
            self.alarm_count = m.get('AlarmCount')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('ClusterType') is not None:
            self.cluster_type = m.get('ClusterType')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CusterState') is not None:
            self.custer_state = m.get('CusterState')
        if m.get('HostIp') is not None:
            self.host_ip = m.get('HostIp')
        if m.get('InstanceCount') is not None:
            self.instance_count = m.get('InstanceCount')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('Pod') is not None:
            self.pod = m.get('Pod')
        if m.get('PodIp') is not None:
            self.pod_ip = m.get('PodIp')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RiskInstanceCount') is not None:
            self.risk_instance_count = m.get('RiskInstanceCount')
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        if m.get('RiskStatus') is not None:
            self.risk_status = m.get('RiskStatus')
        if m.get('VulCount') is not None:
            self.vul_count = m.get('VulCount')
        return self


class DescribeGroupedContainerInstancesResponseBodyPageInfo(TeaModel):
    def __init__(self, count=None, current_page=None, page_size=None, total_count=None):
        self.count = count  # type: int
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeGroupedContainerInstancesResponseBodyPageInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeGroupedContainerInstancesResponseBody(TeaModel):
    def __init__(self, grouped_container_instance_list=None, page_info=None, request_id=None):
        self.grouped_container_instance_list = grouped_container_instance_list  # type: list[DescribeGroupedContainerInstancesResponseBodyGroupedContainerInstanceList]
        self.page_info = page_info  # type: DescribeGroupedContainerInstancesResponseBodyPageInfo
        self.request_id = request_id  # type: str

    def validate(self):
        if self.grouped_container_instance_list:
            for k in self.grouped_container_instance_list:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super(DescribeGroupedContainerInstancesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['GroupedContainerInstanceList'] = []
        if self.grouped_container_instance_list is not None:
            for k in self.grouped_container_instance_list:
                result['GroupedContainerInstanceList'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.grouped_container_instance_list = []
        if m.get('GroupedContainerInstanceList') is not None:
            for k in m.get('GroupedContainerInstanceList'):
                temp_model = DescribeGroupedContainerInstancesResponseBodyGroupedContainerInstanceList()
                self.grouped_container_instance_list.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeGroupedContainerInstancesResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeGroupedContainerInstancesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeGroupedContainerInstancesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeGroupedContainerInstancesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeGroupedContainerInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeGroupedInstancesRequest(TeaModel):
    def __init__(self, current_page=None, field_value=None, group_field=None, lang=None, machine_types=None,
                 no_page=None, page_size=None):
        self.current_page = current_page  # type: int
        self.field_value = field_value  # type: str
        self.group_field = group_field  # type: str
        self.lang = lang  # type: str
        self.machine_types = machine_types  # type: str
        self.no_page = no_page  # type: bool
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeGroupedInstancesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.field_value is not None:
            result['FieldValue'] = self.field_value
        if self.group_field is not None:
            result['GroupField'] = self.group_field
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.machine_types is not None:
            result['MachineTypes'] = self.machine_types
        if self.no_page is not None:
            result['NoPage'] = self.no_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('FieldValue') is not None:
            self.field_value = m.get('FieldValue')
        if m.get('GroupField') is not None:
            self.group_field = m.get('GroupField')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('MachineTypes') is not None:
            self.machine_types = m.get('MachineTypes')
        if m.get('NoPage') is not None:
            self.no_page = m.get('NoPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeGroupedInstancesResponseBodyInstances(TeaModel):
    def __init__(self, asap_vul_instance_count=None, field_alias_name=None, group_flag=None, instance_count=None,
                 risk_instance_count=None, un_protected_instance_count=None):
        self.asap_vul_instance_count = asap_vul_instance_count  # type: long
        self.field_alias_name = field_alias_name  # type: str
        self.group_flag = group_flag  # type: int
        self.instance_count = instance_count  # type: str
        self.risk_instance_count = risk_instance_count  # type: str
        self.un_protected_instance_count = un_protected_instance_count  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeGroupedInstancesResponseBodyInstances, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.asap_vul_instance_count is not None:
            result['AsapVulInstanceCount'] = self.asap_vul_instance_count
        if self.field_alias_name is not None:
            result['FieldAliasName'] = self.field_alias_name
        if self.group_flag is not None:
            result['GroupFlag'] = self.group_flag
        if self.instance_count is not None:
            result['InstanceCount'] = self.instance_count
        if self.risk_instance_count is not None:
            result['RiskInstanceCount'] = self.risk_instance_count
        if self.un_protected_instance_count is not None:
            result['UnProtectedInstanceCount'] = self.un_protected_instance_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AsapVulInstanceCount') is not None:
            self.asap_vul_instance_count = m.get('AsapVulInstanceCount')
        if m.get('FieldAliasName') is not None:
            self.field_alias_name = m.get('FieldAliasName')
        if m.get('GroupFlag') is not None:
            self.group_flag = m.get('GroupFlag')
        if m.get('InstanceCount') is not None:
            self.instance_count = m.get('InstanceCount')
        if m.get('RiskInstanceCount') is not None:
            self.risk_instance_count = m.get('RiskInstanceCount')
        if m.get('UnProtectedInstanceCount') is not None:
            self.un_protected_instance_count = m.get('UnProtectedInstanceCount')
        return self


class DescribeGroupedInstancesResponseBodyPageInfo(TeaModel):
    def __init__(self, count=None, current_page=None, page_size=None, total_count=None):
        self.count = count  # type: int
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeGroupedInstancesResponseBodyPageInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeGroupedInstancesResponseBody(TeaModel):
    def __init__(self, instances=None, page_info=None, request_id=None):
        self.instances = instances  # type: list[DescribeGroupedInstancesResponseBodyInstances]
        self.page_info = page_info  # type: DescribeGroupedInstancesResponseBodyPageInfo
        self.request_id = request_id  # type: str

    def validate(self):
        if self.instances:
            for k in self.instances:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super(DescribeGroupedInstancesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Instances'] = []
        if self.instances is not None:
            for k in self.instances:
                result['Instances'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.instances = []
        if m.get('Instances') is not None:
            for k in m.get('Instances'):
                temp_model = DescribeGroupedInstancesResponseBodyInstances()
                self.instances.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeGroupedInstancesResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeGroupedInstancesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeGroupedInstancesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeGroupedInstancesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeGroupedInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeGroupedMaliciousFilesRequest(TeaModel):
    def __init__(self, current_page=None, fuzzy_malicious_name=None, image_digest=None, image_layer=None,
                 image_tag=None, lang=None, levels=None, page_size=None, repo_id=None, repo_instance_id=None, repo_name=None,
                 repo_namespace=None, repo_region_id=None):
        self.current_page = current_page  # type: int
        self.fuzzy_malicious_name = fuzzy_malicious_name  # type: str
        self.image_digest = image_digest  # type: str
        self.image_layer = image_layer  # type: str
        self.image_tag = image_tag  # type: str
        self.lang = lang  # type: str
        self.levels = levels  # type: str
        self.page_size = page_size  # type: str
        self.repo_id = repo_id  # type: str
        self.repo_instance_id = repo_instance_id  # type: str
        self.repo_name = repo_name  # type: str
        self.repo_namespace = repo_namespace  # type: str
        self.repo_region_id = repo_region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeGroupedMaliciousFilesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.fuzzy_malicious_name is not None:
            result['FuzzyMaliciousName'] = self.fuzzy_malicious_name
        if self.image_digest is not None:
            result['ImageDigest'] = self.image_digest
        if self.image_layer is not None:
            result['ImageLayer'] = self.image_layer
        if self.image_tag is not None:
            result['ImageTag'] = self.image_tag
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.levels is not None:
            result['Levels'] = self.levels
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.repo_id is not None:
            result['RepoId'] = self.repo_id
        if self.repo_instance_id is not None:
            result['RepoInstanceId'] = self.repo_instance_id
        if self.repo_name is not None:
            result['RepoName'] = self.repo_name
        if self.repo_namespace is not None:
            result['RepoNamespace'] = self.repo_namespace
        if self.repo_region_id is not None:
            result['RepoRegionId'] = self.repo_region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('FuzzyMaliciousName') is not None:
            self.fuzzy_malicious_name = m.get('FuzzyMaliciousName')
        if m.get('ImageDigest') is not None:
            self.image_digest = m.get('ImageDigest')
        if m.get('ImageLayer') is not None:
            self.image_layer = m.get('ImageLayer')
        if m.get('ImageTag') is not None:
            self.image_tag = m.get('ImageTag')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Levels') is not None:
            self.levels = m.get('Levels')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RepoId') is not None:
            self.repo_id = m.get('RepoId')
        if m.get('RepoInstanceId') is not None:
            self.repo_instance_id = m.get('RepoInstanceId')
        if m.get('RepoName') is not None:
            self.repo_name = m.get('RepoName')
        if m.get('RepoNamespace') is not None:
            self.repo_namespace = m.get('RepoNamespace')
        if m.get('RepoRegionId') is not None:
            self.repo_region_id = m.get('RepoRegionId')
        return self


class DescribeGroupedMaliciousFilesResponseBodyGroupedMaliciousFileResponse(TeaModel):
    def __init__(self, first_scan_timestamp=None, image_count=None, latest_scan_timestamp=None, level=None,
                 malicious_md_5=None, malicious_name=None, status=None):
        self.first_scan_timestamp = first_scan_timestamp  # type: long
        self.image_count = image_count  # type: long
        self.latest_scan_timestamp = latest_scan_timestamp  # type: long
        self.level = level  # type: str
        self.malicious_md_5 = malicious_md_5  # type: str
        self.malicious_name = malicious_name  # type: str
        self.status = status  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeGroupedMaliciousFilesResponseBodyGroupedMaliciousFileResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.first_scan_timestamp is not None:
            result['FirstScanTimestamp'] = self.first_scan_timestamp
        if self.image_count is not None:
            result['ImageCount'] = self.image_count
        if self.latest_scan_timestamp is not None:
            result['LatestScanTimestamp'] = self.latest_scan_timestamp
        if self.level is not None:
            result['Level'] = self.level
        if self.malicious_md_5 is not None:
            result['MaliciousMd5'] = self.malicious_md_5
        if self.malicious_name is not None:
            result['MaliciousName'] = self.malicious_name
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FirstScanTimestamp') is not None:
            self.first_scan_timestamp = m.get('FirstScanTimestamp')
        if m.get('ImageCount') is not None:
            self.image_count = m.get('ImageCount')
        if m.get('LatestScanTimestamp') is not None:
            self.latest_scan_timestamp = m.get('LatestScanTimestamp')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('MaliciousMd5') is not None:
            self.malicious_md_5 = m.get('MaliciousMd5')
        if m.get('MaliciousName') is not None:
            self.malicious_name = m.get('MaliciousName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeGroupedMaliciousFilesResponseBodyPageInfo(TeaModel):
    def __init__(self, count=None, current_page=None, page_size=None, total_count=None):
        self.count = count  # type: int
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeGroupedMaliciousFilesResponseBodyPageInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeGroupedMaliciousFilesResponseBody(TeaModel):
    def __init__(self, grouped_malicious_file_response=None, page_info=None, request_id=None):
        self.grouped_malicious_file_response = grouped_malicious_file_response  # type: list[DescribeGroupedMaliciousFilesResponseBodyGroupedMaliciousFileResponse]
        self.page_info = page_info  # type: DescribeGroupedMaliciousFilesResponseBodyPageInfo
        self.request_id = request_id  # type: str

    def validate(self):
        if self.grouped_malicious_file_response:
            for k in self.grouped_malicious_file_response:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super(DescribeGroupedMaliciousFilesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['GroupedMaliciousFileResponse'] = []
        if self.grouped_malicious_file_response is not None:
            for k in self.grouped_malicious_file_response:
                result['GroupedMaliciousFileResponse'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.grouped_malicious_file_response = []
        if m.get('GroupedMaliciousFileResponse') is not None:
            for k in m.get('GroupedMaliciousFileResponse'):
                temp_model = DescribeGroupedMaliciousFilesResponseBodyGroupedMaliciousFileResponse()
                self.grouped_malicious_file_response.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeGroupedMaliciousFilesResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeGroupedMaliciousFilesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeGroupedMaliciousFilesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeGroupedMaliciousFilesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeGroupedMaliciousFilesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeGroupedTagsRequest(TeaModel):
    def __init__(self, machine_types=None):
        self.machine_types = machine_types  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeGroupedTagsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.machine_types is not None:
            result['MachineTypes'] = self.machine_types
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MachineTypes') is not None:
            self.machine_types = m.get('MachineTypes')
        return self


class DescribeGroupedTagsResponseBodyGroupedFileds(TeaModel):
    def __init__(self, count=None, name=None, tag_id=None):
        self.count = count  # type: str
        self.name = name  # type: str
        self.tag_id = tag_id  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeGroupedTagsResponseBodyGroupedFileds, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.name is not None:
            result['Name'] = self.name
        if self.tag_id is not None:
            result['TagId'] = self.tag_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('TagId') is not None:
            self.tag_id = m.get('TagId')
        return self


class DescribeGroupedTagsResponseBody(TeaModel):
    def __init__(self, count=None, grouped_fileds=None, http_status_code=None, request_id=None, success=None):
        self.count = count  # type: int
        self.grouped_fileds = grouped_fileds  # type: list[DescribeGroupedTagsResponseBodyGroupedFileds]
        self.http_status_code = http_status_code  # type: int
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.grouped_fileds:
            for k in self.grouped_fileds:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeGroupedTagsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        result['GroupedFileds'] = []
        if self.grouped_fileds is not None:
            for k in self.grouped_fileds:
                result['GroupedFileds'].append(k.to_map() if k else None)
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        self.grouped_fileds = []
        if m.get('GroupedFileds') is not None:
            for k in m.get('GroupedFileds'):
                temp_model = DescribeGroupedTagsResponseBodyGroupedFileds()
                self.grouped_fileds.append(temp_model.from_map(k))
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeGroupedTagsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeGroupedTagsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeGroupedTagsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeGroupedTagsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeGroupedVulRequest(TeaModel):
    def __init__(self, alias_name=None, current_page=None, dealed=None, group_id=None, lang=None, necessity=None,
                 page_size=None, search_tags=None, type=None, uuids=None):
        self.alias_name = alias_name  # type: str
        self.current_page = current_page  # type: int
        self.dealed = dealed  # type: str
        self.group_id = group_id  # type: str
        self.lang = lang  # type: str
        self.necessity = necessity  # type: str
        self.page_size = page_size  # type: int
        self.search_tags = search_tags  # type: str
        self.type = type  # type: str
        self.uuids = uuids  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeGroupedVulRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dealed is not None:
            result['Dealed'] = self.dealed
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.necessity is not None:
            result['Necessity'] = self.necessity
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.search_tags is not None:
            result['SearchTags'] = self.search_tags
        if self.type is not None:
            result['Type'] = self.type
        if self.uuids is not None:
            result['Uuids'] = self.uuids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Dealed') is not None:
            self.dealed = m.get('Dealed')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Necessity') is not None:
            self.necessity = m.get('Necessity')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SearchTags') is not None:
            self.search_tags = m.get('SearchTags')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Uuids') is not None:
            self.uuids = m.get('Uuids')
        return self


class DescribeGroupedVulResponseBodyGroupedVulItems(TeaModel):
    def __init__(self, alias_name=None, asap_count=None, gmt_last=None, handled_count=None, later_count=None,
                 name=None, nntf_count=None, tags=None, total_fix_count=None, type=None):
        self.alias_name = alias_name  # type: str
        self.asap_count = asap_count  # type: int
        self.gmt_last = gmt_last  # type: long
        self.handled_count = handled_count  # type: int
        self.later_count = later_count  # type: int
        self.name = name  # type: str
        self.nntf_count = nntf_count  # type: int
        self.tags = tags  # type: str
        self.total_fix_count = total_fix_count  # type: long
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeGroupedVulResponseBodyGroupedVulItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.asap_count is not None:
            result['AsapCount'] = self.asap_count
        if self.gmt_last is not None:
            result['GmtLast'] = self.gmt_last
        if self.handled_count is not None:
            result['HandledCount'] = self.handled_count
        if self.later_count is not None:
            result['LaterCount'] = self.later_count
        if self.name is not None:
            result['Name'] = self.name
        if self.nntf_count is not None:
            result['NntfCount'] = self.nntf_count
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.total_fix_count is not None:
            result['TotalFixCount'] = self.total_fix_count
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('AsapCount') is not None:
            self.asap_count = m.get('AsapCount')
        if m.get('GmtLast') is not None:
            self.gmt_last = m.get('GmtLast')
        if m.get('HandledCount') is not None:
            self.handled_count = m.get('HandledCount')
        if m.get('LaterCount') is not None:
            self.later_count = m.get('LaterCount')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NntfCount') is not None:
            self.nntf_count = m.get('NntfCount')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('TotalFixCount') is not None:
            self.total_fix_count = m.get('TotalFixCount')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeGroupedVulResponseBody(TeaModel):
    def __init__(self, current_page=None, grouped_vul_items=None, page_size=None, request_id=None, total_count=None):
        self.current_page = current_page  # type: int
        self.grouped_vul_items = grouped_vul_items  # type: list[DescribeGroupedVulResponseBodyGroupedVulItems]
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: int

    def validate(self):
        if self.grouped_vul_items:
            for k in self.grouped_vul_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeGroupedVulResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        result['GroupedVulItems'] = []
        if self.grouped_vul_items is not None:
            for k in self.grouped_vul_items:
                result['GroupedVulItems'].append(k.to_map() if k else None)
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        self.grouped_vul_items = []
        if m.get('GroupedVulItems') is not None:
            for k in m.get('GroupedVulItems'):
                temp_model = DescribeGroupedVulResponseBodyGroupedVulItems()
                self.grouped_vul_items.append(temp_model.from_map(k))
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeGroupedVulResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeGroupedVulResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeGroupedVulResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeGroupedVulResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeHoneyPotAuthResponseBody(TeaModel):
    def __init__(self, honey_pot_auth_count=None, honey_pot_count=None, request_id=None):
        self.honey_pot_auth_count = honey_pot_auth_count  # type: long
        self.honey_pot_count = honey_pot_count  # type: int
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeHoneyPotAuthResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.honey_pot_auth_count is not None:
            result['HoneyPotAuthCount'] = self.honey_pot_auth_count
        if self.honey_pot_count is not None:
            result['HoneyPotCount'] = self.honey_pot_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HoneyPotAuthCount') is not None:
            self.honey_pot_auth_count = m.get('HoneyPotAuthCount')
        if m.get('HoneyPotCount') is not None:
            self.honey_pot_count = m.get('HoneyPotCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeHoneyPotAuthResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeHoneyPotAuthResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeHoneyPotAuthResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeHoneyPotAuthResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeHoneyPotSuspStatisticsRequest(TeaModel):
    def __init__(self, from_=None, statistics_days=None, statistics_key_type=None):
        self.from_ = from_  # type: str
        self.statistics_days = statistics_days  # type: int
        self.statistics_key_type = statistics_key_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeHoneyPotSuspStatisticsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.from_ is not None:
            result['From'] = self.from_
        if self.statistics_days is not None:
            result['StatisticsDays'] = self.statistics_days
        if self.statistics_key_type is not None:
            result['StatisticsKeyType'] = self.statistics_key_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('From') is not None:
            self.from_ = m.get('From')
        if m.get('StatisticsDays') is not None:
            self.statistics_days = m.get('StatisticsDays')
        if m.get('StatisticsKeyType') is not None:
            self.statistics_key_type = m.get('StatisticsKeyType')
        return self


class DescribeHoneyPotSuspStatisticsResponseBodySuspHoneyPotStatisticsResponse(TeaModel):
    def __init__(self, count=None, instance_id=None, instance_name=None, type=None, vpc_id=None, vpc_name=None):
        self.count = count  # type: int
        self.instance_id = instance_id  # type: str
        self.instance_name = instance_name  # type: str
        self.type = type  # type: str
        self.vpc_id = vpc_id  # type: str
        self.vpc_name = vpc_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeHoneyPotSuspStatisticsResponseBodySuspHoneyPotStatisticsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.type is not None:
            result['Type'] = self.type
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.vpc_name is not None:
            result['VpcName'] = self.vpc_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('VpcName') is not None:
            self.vpc_name = m.get('VpcName')
        return self


class DescribeHoneyPotSuspStatisticsResponseBody(TeaModel):
    def __init__(self, request_id=None, susp_honey_pot_statistics_response=None):
        self.request_id = request_id  # type: str
        self.susp_honey_pot_statistics_response = susp_honey_pot_statistics_response  # type: list[DescribeHoneyPotSuspStatisticsResponseBodySuspHoneyPotStatisticsResponse]

    def validate(self):
        if self.susp_honey_pot_statistics_response:
            for k in self.susp_honey_pot_statistics_response:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeHoneyPotSuspStatisticsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['SuspHoneyPotStatisticsResponse'] = []
        if self.susp_honey_pot_statistics_response is not None:
            for k in self.susp_honey_pot_statistics_response:
                result['SuspHoneyPotStatisticsResponse'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.susp_honey_pot_statistics_response = []
        if m.get('SuspHoneyPotStatisticsResponse') is not None:
            for k in m.get('SuspHoneyPotStatisticsResponse'):
                temp_model = DescribeHoneyPotSuspStatisticsResponseBodySuspHoneyPotStatisticsResponse()
                self.susp_honey_pot_statistics_response.append(temp_model.from_map(k))
        return self


class DescribeHoneyPotSuspStatisticsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeHoneyPotSuspStatisticsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeHoneyPotSuspStatisticsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeHoneyPotSuspStatisticsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeImageBaselineCheckSummaryRequest(TeaModel):
    def __init__(self, criteria=None, criteria_type=None, current_page=None, lang=None, page_size=None,
                 risk_level=None):
        self.criteria = criteria  # type: str
        self.criteria_type = criteria_type  # type: str
        self.current_page = current_page  # type: int
        self.lang = lang  # type: str
        self.page_size = page_size  # type: int
        self.risk_level = risk_level  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeImageBaselineCheckSummaryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.criteria is not None:
            result['Criteria'] = self.criteria
        if self.criteria_type is not None:
            result['CriteriaType'] = self.criteria_type
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Criteria') is not None:
            self.criteria = m.get('Criteria')
        if m.get('CriteriaType') is not None:
            self.criteria_type = m.get('CriteriaType')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        return self


class DescribeImageBaselineCheckSummaryResponseBodyBaselineResultSummary(TeaModel):
    def __init__(self, baseline_class_alias=None, baseline_class_key=None, baseline_name_alias=None,
                 baseline_name_key=None, baseline_name_level=None, first_scan_time=None, high_risk_image=None, last_scan_time=None,
                 low_risk_image=None, middle_risk_image=None, status=None):
        self.baseline_class_alias = baseline_class_alias  # type: str
        self.baseline_class_key = baseline_class_key  # type: str
        self.baseline_name_alias = baseline_name_alias  # type: str
        self.baseline_name_key = baseline_name_key  # type: str
        self.baseline_name_level = baseline_name_level  # type: str
        self.first_scan_time = first_scan_time  # type: long
        self.high_risk_image = high_risk_image  # type: int
        self.last_scan_time = last_scan_time  # type: long
        self.low_risk_image = low_risk_image  # type: int
        self.middle_risk_image = middle_risk_image  # type: int
        self.status = status  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeImageBaselineCheckSummaryResponseBodyBaselineResultSummary, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baseline_class_alias is not None:
            result['BaselineClassAlias'] = self.baseline_class_alias
        if self.baseline_class_key is not None:
            result['BaselineClassKey'] = self.baseline_class_key
        if self.baseline_name_alias is not None:
            result['BaselineNameAlias'] = self.baseline_name_alias
        if self.baseline_name_key is not None:
            result['BaselineNameKey'] = self.baseline_name_key
        if self.baseline_name_level is not None:
            result['BaselineNameLevel'] = self.baseline_name_level
        if self.first_scan_time is not None:
            result['FirstScanTime'] = self.first_scan_time
        if self.high_risk_image is not None:
            result['HighRiskImage'] = self.high_risk_image
        if self.last_scan_time is not None:
            result['LastScanTime'] = self.last_scan_time
        if self.low_risk_image is not None:
            result['LowRiskImage'] = self.low_risk_image
        if self.middle_risk_image is not None:
            result['MiddleRiskImage'] = self.middle_risk_image
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BaselineClassAlias') is not None:
            self.baseline_class_alias = m.get('BaselineClassAlias')
        if m.get('BaselineClassKey') is not None:
            self.baseline_class_key = m.get('BaselineClassKey')
        if m.get('BaselineNameAlias') is not None:
            self.baseline_name_alias = m.get('BaselineNameAlias')
        if m.get('BaselineNameKey') is not None:
            self.baseline_name_key = m.get('BaselineNameKey')
        if m.get('BaselineNameLevel') is not None:
            self.baseline_name_level = m.get('BaselineNameLevel')
        if m.get('FirstScanTime') is not None:
            self.first_scan_time = m.get('FirstScanTime')
        if m.get('HighRiskImage') is not None:
            self.high_risk_image = m.get('HighRiskImage')
        if m.get('LastScanTime') is not None:
            self.last_scan_time = m.get('LastScanTime')
        if m.get('LowRiskImage') is not None:
            self.low_risk_image = m.get('LowRiskImage')
        if m.get('MiddleRiskImage') is not None:
            self.middle_risk_image = m.get('MiddleRiskImage')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeImageBaselineCheckSummaryResponseBodyPageInfo(TeaModel):
    def __init__(self, count=None, current_page=None, page_size=None, total_count=None):
        self.count = count  # type: int
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeImageBaselineCheckSummaryResponseBodyPageInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeImageBaselineCheckSummaryResponseBody(TeaModel):
    def __init__(self, baseline_result_summary=None, page_info=None, request_id=None):
        self.baseline_result_summary = baseline_result_summary  # type: list[DescribeImageBaselineCheckSummaryResponseBodyBaselineResultSummary]
        self.page_info = page_info  # type: DescribeImageBaselineCheckSummaryResponseBodyPageInfo
        self.request_id = request_id  # type: str

    def validate(self):
        if self.baseline_result_summary:
            for k in self.baseline_result_summary:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super(DescribeImageBaselineCheckSummaryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BaselineResultSummary'] = []
        if self.baseline_result_summary is not None:
            for k in self.baseline_result_summary:
                result['BaselineResultSummary'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.baseline_result_summary = []
        if m.get('BaselineResultSummary') is not None:
            for k in m.get('BaselineResultSummary'):
                temp_model = DescribeImageBaselineCheckSummaryResponseBodyBaselineResultSummary()
                self.baseline_result_summary.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeImageBaselineCheckSummaryResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeImageBaselineCheckSummaryResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeImageBaselineCheckSummaryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeImageBaselineCheckSummaryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeImageBaselineCheckSummaryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeImageFixTaskRequest(TeaModel):
    def __init__(self, current_page=None, end_time=None, page_size=None, start_time=None, status=None):
        self.current_page = current_page  # type: int
        self.end_time = end_time  # type: long
        self.page_size = page_size  # type: int
        self.start_time = start_time  # type: long
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeImageFixTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeImageFixTaskResponseBodyBuildTasks(TeaModel):
    def __init__(self, build_task_id=None, finish_time=None, fix_time=None, new_tag=None, new_uuid=None,
                 old_tag=None, old_uuid=None, region_id=None, repo_name=None, repo_namespace=None, status=None,
                 task_type=None):
        self.build_task_id = build_task_id  # type: str
        self.finish_time = finish_time  # type: str
        self.fix_time = fix_time  # type: str
        self.new_tag = new_tag  # type: str
        self.new_uuid = new_uuid  # type: str
        self.old_tag = old_tag  # type: str
        self.old_uuid = old_uuid  # type: str
        self.region_id = region_id  # type: str
        self.repo_name = repo_name  # type: str
        self.repo_namespace = repo_namespace  # type: str
        self.status = status  # type: int
        self.task_type = task_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeImageFixTaskResponseBodyBuildTasks, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.build_task_id is not None:
            result['BuildTaskId'] = self.build_task_id
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.fix_time is not None:
            result['FixTime'] = self.fix_time
        if self.new_tag is not None:
            result['NewTag'] = self.new_tag
        if self.new_uuid is not None:
            result['NewUuid'] = self.new_uuid
        if self.old_tag is not None:
            result['OldTag'] = self.old_tag
        if self.old_uuid is not None:
            result['OldUuid'] = self.old_uuid
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.repo_name is not None:
            result['RepoName'] = self.repo_name
        if self.repo_namespace is not None:
            result['RepoNamespace'] = self.repo_namespace
        if self.status is not None:
            result['Status'] = self.status
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BuildTaskId') is not None:
            self.build_task_id = m.get('BuildTaskId')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('FixTime') is not None:
            self.fix_time = m.get('FixTime')
        if m.get('NewTag') is not None:
            self.new_tag = m.get('NewTag')
        if m.get('NewUuid') is not None:
            self.new_uuid = m.get('NewUuid')
        if m.get('OldTag') is not None:
            self.old_tag = m.get('OldTag')
        if m.get('OldUuid') is not None:
            self.old_uuid = m.get('OldUuid')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RepoName') is not None:
            self.repo_name = m.get('RepoName')
        if m.get('RepoNamespace') is not None:
            self.repo_namespace = m.get('RepoNamespace')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class DescribeImageFixTaskResponseBodyPageInfo(TeaModel):
    def __init__(self, count=None, current_page=None, page_size=None, total_count=None):
        self.count = count  # type: int
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeImageFixTaskResponseBodyPageInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeImageFixTaskResponseBody(TeaModel):
    def __init__(self, build_tasks=None, page_info=None, request_id=None):
        self.build_tasks = build_tasks  # type: list[DescribeImageFixTaskResponseBodyBuildTasks]
        self.page_info = page_info  # type: DescribeImageFixTaskResponseBodyPageInfo
        # Id of the request
        self.request_id = request_id  # type: str

    def validate(self):
        if self.build_tasks:
            for k in self.build_tasks:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super(DescribeImageFixTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BuildTasks'] = []
        if self.build_tasks is not None:
            for k in self.build_tasks:
                result['BuildTasks'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.build_tasks = []
        if m.get('BuildTasks') is not None:
            for k in m.get('BuildTasks'):
                temp_model = DescribeImageFixTaskResponseBodyBuildTasks()
                self.build_tasks.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeImageFixTaskResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeImageFixTaskResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeImageFixTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeImageFixTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeImageFixTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeImageGroupedVulListRequest(TeaModel):
    def __init__(self, alias_name=None, current_page=None, cve_id=None, group_id=None, image_digest=None,
                 image_layer=None, image_tag=None, is_latest=None, lang=None, name=None, necessity=None, page_size=None,
                 patch_id=None, repo_id=None, repo_instance_id=None, repo_name=None, repo_namespace=None,
                 repo_region_id=None, type=None, uuids=None):
        self.alias_name = alias_name  # type: str
        self.current_page = current_page  # type: int
        self.cve_id = cve_id  # type: str
        self.group_id = group_id  # type: str
        self.image_digest = image_digest  # type: str
        self.image_layer = image_layer  # type: str
        self.image_tag = image_tag  # type: str
        self.is_latest = is_latest  # type: int
        self.lang = lang  # type: str
        self.name = name  # type: str
        self.necessity = necessity  # type: str
        self.page_size = page_size  # type: int
        self.patch_id = patch_id  # type: long
        self.repo_id = repo_id  # type: str
        self.repo_instance_id = repo_instance_id  # type: str
        self.repo_name = repo_name  # type: str
        self.repo_namespace = repo_namespace  # type: str
        self.repo_region_id = repo_region_id  # type: str
        self.type = type  # type: str
        self.uuids = uuids  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeImageGroupedVulListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.cve_id is not None:
            result['CveId'] = self.cve_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.image_digest is not None:
            result['ImageDigest'] = self.image_digest
        if self.image_layer is not None:
            result['ImageLayer'] = self.image_layer
        if self.image_tag is not None:
            result['ImageTag'] = self.image_tag
        if self.is_latest is not None:
            result['IsLatest'] = self.is_latest
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.name is not None:
            result['Name'] = self.name
        if self.necessity is not None:
            result['Necessity'] = self.necessity
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.patch_id is not None:
            result['PatchId'] = self.patch_id
        if self.repo_id is not None:
            result['RepoId'] = self.repo_id
        if self.repo_instance_id is not None:
            result['RepoInstanceId'] = self.repo_instance_id
        if self.repo_name is not None:
            result['RepoName'] = self.repo_name
        if self.repo_namespace is not None:
            result['RepoNamespace'] = self.repo_namespace
        if self.repo_region_id is not None:
            result['RepoRegionId'] = self.repo_region_id
        if self.type is not None:
            result['Type'] = self.type
        if self.uuids is not None:
            result['Uuids'] = self.uuids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('CveId') is not None:
            self.cve_id = m.get('CveId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('ImageDigest') is not None:
            self.image_digest = m.get('ImageDigest')
        if m.get('ImageLayer') is not None:
            self.image_layer = m.get('ImageLayer')
        if m.get('ImageTag') is not None:
            self.image_tag = m.get('ImageTag')
        if m.get('IsLatest') is not None:
            self.is_latest = m.get('IsLatest')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Necessity') is not None:
            self.necessity = m.get('Necessity')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PatchId') is not None:
            self.patch_id = m.get('PatchId')
        if m.get('RepoId') is not None:
            self.repo_id = m.get('RepoId')
        if m.get('RepoInstanceId') is not None:
            self.repo_instance_id = m.get('RepoInstanceId')
        if m.get('RepoName') is not None:
            self.repo_name = m.get('RepoName')
        if m.get('RepoNamespace') is not None:
            self.repo_namespace = m.get('RepoNamespace')
        if m.get('RepoRegionId') is not None:
            self.repo_region_id = m.get('RepoRegionId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Uuids') is not None:
            self.uuids = m.get('Uuids')
        return self


class DescribeImageGroupedVulListResponseBodyGroupedVulItems(TeaModel):
    def __init__(self, alias_name=None, asap_count=None, gmt_last=None, last_scan_time=None, later_count=None,
                 name=None, nntf_count=None, status=None, tags=None, type=None):
        self.alias_name = alias_name  # type: str
        self.asap_count = asap_count  # type: int
        self.gmt_last = gmt_last  # type: long
        self.last_scan_time = last_scan_time  # type: long
        self.later_count = later_count  # type: int
        self.name = name  # type: str
        self.nntf_count = nntf_count  # type: int
        self.status = status  # type: int
        self.tags = tags  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeImageGroupedVulListResponseBodyGroupedVulItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.asap_count is not None:
            result['AsapCount'] = self.asap_count
        if self.gmt_last is not None:
            result['GmtLast'] = self.gmt_last
        if self.last_scan_time is not None:
            result['LastScanTime'] = self.last_scan_time
        if self.later_count is not None:
            result['LaterCount'] = self.later_count
        if self.name is not None:
            result['Name'] = self.name
        if self.nntf_count is not None:
            result['NntfCount'] = self.nntf_count
        if self.status is not None:
            result['Status'] = self.status
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('AsapCount') is not None:
            self.asap_count = m.get('AsapCount')
        if m.get('GmtLast') is not None:
            self.gmt_last = m.get('GmtLast')
        if m.get('LastScanTime') is not None:
            self.last_scan_time = m.get('LastScanTime')
        if m.get('LaterCount') is not None:
            self.later_count = m.get('LaterCount')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NntfCount') is not None:
            self.nntf_count = m.get('NntfCount')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeImageGroupedVulListResponseBody(TeaModel):
    def __init__(self, current_page=None, grouped_vul_items=None, page_size=None, request_id=None, total_count=None):
        self.current_page = current_page  # type: int
        self.grouped_vul_items = grouped_vul_items  # type: list[DescribeImageGroupedVulListResponseBodyGroupedVulItems]
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: int

    def validate(self):
        if self.grouped_vul_items:
            for k in self.grouped_vul_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeImageGroupedVulListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        result['GroupedVulItems'] = []
        if self.grouped_vul_items is not None:
            for k in self.grouped_vul_items:
                result['GroupedVulItems'].append(k.to_map() if k else None)
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        self.grouped_vul_items = []
        if m.get('GroupedVulItems') is not None:
            for k in m.get('GroupedVulItems'):
                temp_model = DescribeImageGroupedVulListResponseBodyGroupedVulItems()
                self.grouped_vul_items.append(temp_model.from_map(k))
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeImageGroupedVulListResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeImageGroupedVulListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeImageGroupedVulListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeImageGroupedVulListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeImageListWithBaselineNameRequest(TeaModel):
    def __init__(self, baseline_name_key=None, criteria=None, criteria_type=None, current_page=None,
                 image_digest=None, lang=None, page_size=None, repo_instance_id=None, repo_name=None, repo_namespace=None):
        self.baseline_name_key = baseline_name_key  # type: str
        self.criteria = criteria  # type: str
        self.criteria_type = criteria_type  # type: str
        self.current_page = current_page  # type: int
        self.image_digest = image_digest  # type: str
        self.lang = lang  # type: str
        self.page_size = page_size  # type: int
        self.repo_instance_id = repo_instance_id  # type: str
        self.repo_name = repo_name  # type: str
        self.repo_namespace = repo_namespace  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeImageListWithBaselineNameRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baseline_name_key is not None:
            result['BaselineNameKey'] = self.baseline_name_key
        if self.criteria is not None:
            result['Criteria'] = self.criteria
        if self.criteria_type is not None:
            result['CriteriaType'] = self.criteria_type
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.image_digest is not None:
            result['ImageDigest'] = self.image_digest
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.repo_instance_id is not None:
            result['RepoInstanceId'] = self.repo_instance_id
        if self.repo_name is not None:
            result['RepoName'] = self.repo_name
        if self.repo_namespace is not None:
            result['RepoNamespace'] = self.repo_namespace
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BaselineNameKey') is not None:
            self.baseline_name_key = m.get('BaselineNameKey')
        if m.get('Criteria') is not None:
            self.criteria = m.get('Criteria')
        if m.get('CriteriaType') is not None:
            self.criteria_type = m.get('CriteriaType')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('ImageDigest') is not None:
            self.image_digest = m.get('ImageDigest')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RepoInstanceId') is not None:
            self.repo_instance_id = m.get('RepoInstanceId')
        if m.get('RepoName') is not None:
            self.repo_name = m.get('RepoName')
        if m.get('RepoNamespace') is not None:
            self.repo_namespace = m.get('RepoNamespace')
        return self


class DescribeImageListWithBaselineNameResponseBodyImageInfos(TeaModel):
    def __init__(self, digest=None, high_risk_image=None, image_create=None, image_id=None, image_size=None,
                 image_update=None, instance_id=None, low_risk_image=None, middle_risk_image=None, no_risk_image=None,
                 region_id=None, repo_id=None, repo_name=None, repo_namespace=None, repo_type=None, risk_status=None, tag=None,
                 total_item_count=None, uuid=None):
        self.digest = digest  # type: str
        self.high_risk_image = high_risk_image  # type: int
        self.image_create = image_create  # type: long
        self.image_id = image_id  # type: str
        self.image_size = image_size  # type: int
        self.image_update = image_update  # type: long
        self.instance_id = instance_id  # type: str
        self.low_risk_image = low_risk_image  # type: int
        self.middle_risk_image = middle_risk_image  # type: int
        self.no_risk_image = no_risk_image  # type: int
        self.region_id = region_id  # type: str
        self.repo_id = repo_id  # type: str
        self.repo_name = repo_name  # type: str
        self.repo_namespace = repo_namespace  # type: str
        self.repo_type = repo_type  # type: str
        self.risk_status = risk_status  # type: str
        self.tag = tag  # type: str
        self.total_item_count = total_item_count  # type: int
        self.uuid = uuid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeImageListWithBaselineNameResponseBodyImageInfos, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.digest is not None:
            result['Digest'] = self.digest
        if self.high_risk_image is not None:
            result['HighRiskImage'] = self.high_risk_image
        if self.image_create is not None:
            result['ImageCreate'] = self.image_create
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.image_size is not None:
            result['ImageSize'] = self.image_size
        if self.image_update is not None:
            result['ImageUpdate'] = self.image_update
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.low_risk_image is not None:
            result['LowRiskImage'] = self.low_risk_image
        if self.middle_risk_image is not None:
            result['MiddleRiskImage'] = self.middle_risk_image
        if self.no_risk_image is not None:
            result['NoRiskImage'] = self.no_risk_image
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.repo_id is not None:
            result['RepoId'] = self.repo_id
        if self.repo_name is not None:
            result['RepoName'] = self.repo_name
        if self.repo_namespace is not None:
            result['RepoNamespace'] = self.repo_namespace
        if self.repo_type is not None:
            result['RepoType'] = self.repo_type
        if self.risk_status is not None:
            result['RiskStatus'] = self.risk_status
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.total_item_count is not None:
            result['TotalItemCount'] = self.total_item_count
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Digest') is not None:
            self.digest = m.get('Digest')
        if m.get('HighRiskImage') is not None:
            self.high_risk_image = m.get('HighRiskImage')
        if m.get('ImageCreate') is not None:
            self.image_create = m.get('ImageCreate')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('ImageSize') is not None:
            self.image_size = m.get('ImageSize')
        if m.get('ImageUpdate') is not None:
            self.image_update = m.get('ImageUpdate')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('LowRiskImage') is not None:
            self.low_risk_image = m.get('LowRiskImage')
        if m.get('MiddleRiskImage') is not None:
            self.middle_risk_image = m.get('MiddleRiskImage')
        if m.get('NoRiskImage') is not None:
            self.no_risk_image = m.get('NoRiskImage')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RepoId') is not None:
            self.repo_id = m.get('RepoId')
        if m.get('RepoName') is not None:
            self.repo_name = m.get('RepoName')
        if m.get('RepoNamespace') is not None:
            self.repo_namespace = m.get('RepoNamespace')
        if m.get('RepoType') is not None:
            self.repo_type = m.get('RepoType')
        if m.get('RiskStatus') is not None:
            self.risk_status = m.get('RiskStatus')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('TotalItemCount') is not None:
            self.total_item_count = m.get('TotalItemCount')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeImageListWithBaselineNameResponseBodyPageInfo(TeaModel):
    def __init__(self, count=None, current_page=None, page_size=None, total_count=None):
        self.count = count  # type: int
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeImageListWithBaselineNameResponseBodyPageInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeImageListWithBaselineNameResponseBody(TeaModel):
    def __init__(self, image_infos=None, page_info=None, request_id=None):
        self.image_infos = image_infos  # type: list[DescribeImageListWithBaselineNameResponseBodyImageInfos]
        self.page_info = page_info  # type: DescribeImageListWithBaselineNameResponseBodyPageInfo
        self.request_id = request_id  # type: str

    def validate(self):
        if self.image_infos:
            for k in self.image_infos:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super(DescribeImageListWithBaselineNameResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ImageInfos'] = []
        if self.image_infos is not None:
            for k in self.image_infos:
                result['ImageInfos'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.image_infos = []
        if m.get('ImageInfos') is not None:
            for k in m.get('ImageInfos'):
                temp_model = DescribeImageListWithBaselineNameResponseBodyImageInfos()
                self.image_infos.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeImageListWithBaselineNameResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeImageListWithBaselineNameResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeImageListWithBaselineNameResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeImageListWithBaselineNameResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeImageListWithBaselineNameResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeImageScanAuthCountResponseBodyImageScan(TeaModel):
    def __init__(self, image_scan_capacity=None, instance_id=None, scan_count=None):
        self.image_scan_capacity = image_scan_capacity  # type: long
        self.instance_id = instance_id  # type: str
        self.scan_count = scan_count  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeImageScanAuthCountResponseBodyImageScan, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image_scan_capacity is not None:
            result['ImageScanCapacity'] = self.image_scan_capacity
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.scan_count is not None:
            result['ScanCount'] = self.scan_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ImageScanCapacity') is not None:
            self.image_scan_capacity = m.get('ImageScanCapacity')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ScanCount') is not None:
            self.scan_count = m.get('ScanCount')
        return self


class DescribeImageScanAuthCountResponseBody(TeaModel):
    def __init__(self, image_scan=None, request_id=None):
        self.image_scan = image_scan  # type: DescribeImageScanAuthCountResponseBodyImageScan
        self.request_id = request_id  # type: str

    def validate(self):
        if self.image_scan:
            self.image_scan.validate()

    def to_map(self):
        _map = super(DescribeImageScanAuthCountResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image_scan is not None:
            result['ImageScan'] = self.image_scan.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ImageScan') is not None:
            temp_model = DescribeImageScanAuthCountResponseBodyImageScan()
            self.image_scan = temp_model.from_map(m['ImageScan'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeImageScanAuthCountResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeImageScanAuthCountResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeImageScanAuthCountResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeImageScanAuthCountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeImageStatisticsResponseBody(TeaModel):
    def __init__(self, instance_count=None, request_id=None, risk_instance_count=None):
        self.instance_count = instance_count  # type: int
        self.request_id = request_id  # type: str
        self.risk_instance_count = risk_instance_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeImageStatisticsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_count is not None:
            result['InstanceCount'] = self.instance_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.risk_instance_count is not None:
            result['RiskInstanceCount'] = self.risk_instance_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceCount') is not None:
            self.instance_count = m.get('InstanceCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RiskInstanceCount') is not None:
            self.risk_instance_count = m.get('RiskInstanceCount')
        return self


class DescribeImageStatisticsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeImageStatisticsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeImageStatisticsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeImageStatisticsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeImageVulListRequest(TeaModel):
    def __init__(self, alias_name=None, current_page=None, dealed=None, digest=None, instance_id=None, lang=None,
                 name=None, necessity=None, page_size=None, region_id=None, repo_id=None, repo_instance_id=None,
                 repo_name=None, repo_namespace=None, repo_region_id=None, status_list=None, tag=None, type=None, uuids=None):
        self.alias_name = alias_name  # type: str
        self.current_page = current_page  # type: int
        self.dealed = dealed  # type: str
        self.digest = digest  # type: str
        self.instance_id = instance_id  # type: str
        self.lang = lang  # type: str
        self.name = name  # type: str
        self.necessity = necessity  # type: str
        self.page_size = page_size  # type: int
        self.region_id = region_id  # type: str
        self.repo_id = repo_id  # type: str
        self.repo_instance_id = repo_instance_id  # type: str
        self.repo_name = repo_name  # type: str
        self.repo_namespace = repo_namespace  # type: str
        self.repo_region_id = repo_region_id  # type: str
        self.status_list = status_list  # type: str
        self.tag = tag  # type: str
        self.type = type  # type: str
        self.uuids = uuids  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeImageVulListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dealed is not None:
            result['Dealed'] = self.dealed
        if self.digest is not None:
            result['Digest'] = self.digest
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.name is not None:
            result['Name'] = self.name
        if self.necessity is not None:
            result['Necessity'] = self.necessity
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.repo_id is not None:
            result['RepoId'] = self.repo_id
        if self.repo_instance_id is not None:
            result['RepoInstanceId'] = self.repo_instance_id
        if self.repo_name is not None:
            result['RepoName'] = self.repo_name
        if self.repo_namespace is not None:
            result['RepoNamespace'] = self.repo_namespace
        if self.repo_region_id is not None:
            result['RepoRegionId'] = self.repo_region_id
        if self.status_list is not None:
            result['StatusList'] = self.status_list
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.type is not None:
            result['Type'] = self.type
        if self.uuids is not None:
            result['Uuids'] = self.uuids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Dealed') is not None:
            self.dealed = m.get('Dealed')
        if m.get('Digest') is not None:
            self.digest = m.get('Digest')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Necessity') is not None:
            self.necessity = m.get('Necessity')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RepoId') is not None:
            self.repo_id = m.get('RepoId')
        if m.get('RepoInstanceId') is not None:
            self.repo_instance_id = m.get('RepoInstanceId')
        if m.get('RepoName') is not None:
            self.repo_name = m.get('RepoName')
        if m.get('RepoNamespace') is not None:
            self.repo_namespace = m.get('RepoNamespace')
        if m.get('RepoRegionId') is not None:
            self.repo_region_id = m.get('RepoRegionId')
        if m.get('StatusList') is not None:
            self.status_list = m.get('StatusList')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Uuids') is not None:
            self.uuids = m.get('Uuids')
        return self


class DescribeImageVulListResponseBodyVulRecordsExtendContentJsonRpmEntityList(TeaModel):
    def __init__(self, full_version=None, layer=None, match_detail=None, match_list=None, name=None, path=None,
                 update_cmd=None, version=None):
        self.full_version = full_version  # type: str
        self.layer = layer  # type: str
        self.match_detail = match_detail  # type: str
        self.match_list = match_list  # type: str
        self.name = name  # type: str
        self.path = path  # type: str
        self.update_cmd = update_cmd  # type: str
        self.version = version  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeImageVulListResponseBodyVulRecordsExtendContentJsonRpmEntityList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.full_version is not None:
            result['FullVersion'] = self.full_version
        if self.layer is not None:
            result['Layer'] = self.layer
        if self.match_detail is not None:
            result['MatchDetail'] = self.match_detail
        if self.match_list is not None:
            result['MatchList'] = self.match_list
        if self.name is not None:
            result['Name'] = self.name
        if self.path is not None:
            result['Path'] = self.path
        if self.update_cmd is not None:
            result['UpdateCmd'] = self.update_cmd
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FullVersion') is not None:
            self.full_version = m.get('FullVersion')
        if m.get('Layer') is not None:
            self.layer = m.get('Layer')
        if m.get('MatchDetail') is not None:
            self.match_detail = m.get('MatchDetail')
        if m.get('MatchList') is not None:
            self.match_list = m.get('MatchList')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('UpdateCmd') is not None:
            self.update_cmd = m.get('UpdateCmd')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class DescribeImageVulListResponseBodyVulRecordsExtendContentJson(TeaModel):
    def __init__(self, os=None, os_release=None, rpm_entity_list=None):
        self.os = os  # type: str
        self.os_release = os_release  # type: str
        self.rpm_entity_list = rpm_entity_list  # type: list[DescribeImageVulListResponseBodyVulRecordsExtendContentJsonRpmEntityList]

    def validate(self):
        if self.rpm_entity_list:
            for k in self.rpm_entity_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeImageVulListResponseBodyVulRecordsExtendContentJson, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.os is not None:
            result['Os'] = self.os
        if self.os_release is not None:
            result['OsRelease'] = self.os_release
        result['RpmEntityList'] = []
        if self.rpm_entity_list is not None:
            for k in self.rpm_entity_list:
                result['RpmEntityList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Os') is not None:
            self.os = m.get('Os')
        if m.get('OsRelease') is not None:
            self.os_release = m.get('OsRelease')
        self.rpm_entity_list = []
        if m.get('RpmEntityList') is not None:
            for k in m.get('RpmEntityList'):
                temp_model = DescribeImageVulListResponseBodyVulRecordsExtendContentJsonRpmEntityList()
                self.rpm_entity_list.append(temp_model.from_map(k))
        return self


class DescribeImageVulListResponseBodyVulRecords(TeaModel):
    def __init__(self, alias_name=None, can_update=None, extend_content_json=None, first_ts=None, image_digest=None,
                 last_ts=None, layers=None, modify_ts=None, name=None, necessity=None, primary_id=None, related=None,
                 repo_name=None, repo_namespace=None, status=None, tag=None, type=None, uuid=None):
        self.alias_name = alias_name  # type: str
        self.can_update = can_update  # type: bool
        self.extend_content_json = extend_content_json  # type: DescribeImageVulListResponseBodyVulRecordsExtendContentJson
        self.first_ts = first_ts  # type: long
        self.image_digest = image_digest  # type: str
        self.last_ts = last_ts  # type: long
        self.layers = layers  # type: list[str]
        self.modify_ts = modify_ts  # type: long
        self.name = name  # type: str
        self.necessity = necessity  # type: str
        self.primary_id = primary_id  # type: long
        self.related = related  # type: str
        self.repo_name = repo_name  # type: str
        self.repo_namespace = repo_namespace  # type: str
        self.status = status  # type: int
        self.tag = tag  # type: str
        self.type = type  # type: str
        self.uuid = uuid  # type: str

    def validate(self):
        if self.extend_content_json:
            self.extend_content_json.validate()

    def to_map(self):
        _map = super(DescribeImageVulListResponseBodyVulRecords, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.can_update is not None:
            result['CanUpdate'] = self.can_update
        if self.extend_content_json is not None:
            result['ExtendContentJson'] = self.extend_content_json.to_map()
        if self.first_ts is not None:
            result['FirstTs'] = self.first_ts
        if self.image_digest is not None:
            result['ImageDigest'] = self.image_digest
        if self.last_ts is not None:
            result['LastTs'] = self.last_ts
        if self.layers is not None:
            result['Layers'] = self.layers
        if self.modify_ts is not None:
            result['ModifyTs'] = self.modify_ts
        if self.name is not None:
            result['Name'] = self.name
        if self.necessity is not None:
            result['Necessity'] = self.necessity
        if self.primary_id is not None:
            result['PrimaryId'] = self.primary_id
        if self.related is not None:
            result['Related'] = self.related
        if self.repo_name is not None:
            result['RepoName'] = self.repo_name
        if self.repo_namespace is not None:
            result['RepoNamespace'] = self.repo_namespace
        if self.status is not None:
            result['Status'] = self.status
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.type is not None:
            result['Type'] = self.type
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('CanUpdate') is not None:
            self.can_update = m.get('CanUpdate')
        if m.get('ExtendContentJson') is not None:
            temp_model = DescribeImageVulListResponseBodyVulRecordsExtendContentJson()
            self.extend_content_json = temp_model.from_map(m['ExtendContentJson'])
        if m.get('FirstTs') is not None:
            self.first_ts = m.get('FirstTs')
        if m.get('ImageDigest') is not None:
            self.image_digest = m.get('ImageDigest')
        if m.get('LastTs') is not None:
            self.last_ts = m.get('LastTs')
        if m.get('Layers') is not None:
            self.layers = m.get('Layers')
        if m.get('ModifyTs') is not None:
            self.modify_ts = m.get('ModifyTs')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Necessity') is not None:
            self.necessity = m.get('Necessity')
        if m.get('PrimaryId') is not None:
            self.primary_id = m.get('PrimaryId')
        if m.get('Related') is not None:
            self.related = m.get('Related')
        if m.get('RepoName') is not None:
            self.repo_name = m.get('RepoName')
        if m.get('RepoNamespace') is not None:
            self.repo_namespace = m.get('RepoNamespace')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeImageVulListResponseBody(TeaModel):
    def __init__(self, current_page=None, page_size=None, request_id=None, total_count=None, vul_records=None):
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: int
        self.vul_records = vul_records  # type: list[DescribeImageVulListResponseBodyVulRecords]

    def validate(self):
        if self.vul_records:
            for k in self.vul_records:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeImageVulListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['VulRecords'] = []
        if self.vul_records is not None:
            for k in self.vul_records:
                result['VulRecords'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.vul_records = []
        if m.get('VulRecords') is not None:
            for k in m.get('VulRecords'):
                temp_model = DescribeImageVulListResponseBodyVulRecords()
                self.vul_records.append(temp_model.from_map(k))
        return self


class DescribeImageVulListResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeImageVulListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeImageVulListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeImageVulListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeInstallCaptchaRequest(TeaModel):
    def __init__(self, deadline=None, lang=None, source_ip=None):
        self.deadline = deadline  # type: str
        self.lang = lang  # type: str
        self.source_ip = source_ip  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeInstallCaptchaRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.deadline is not None:
            result['Deadline'] = self.deadline
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Deadline') is not None:
            self.deadline = m.get('Deadline')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeInstallCaptchaResponseBody(TeaModel):
    def __init__(self, captcha_code=None, deadline=None, request_id=None):
        self.captcha_code = captcha_code  # type: str
        self.deadline = deadline  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeInstallCaptchaResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.captcha_code is not None:
            result['CaptchaCode'] = self.captcha_code
        if self.deadline is not None:
            result['Deadline'] = self.deadline
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CaptchaCode') is not None:
            self.captcha_code = m.get('CaptchaCode')
        if m.get('Deadline') is not None:
            self.deadline = m.get('Deadline')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeInstallCaptchaResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeInstallCaptchaResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeInstallCaptchaResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeInstallCaptchaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeInstallCodesResponseBodyInstallCodes(TeaModel):
    def __init__(self, captcha_code=None, expired_date=None, group_id=None, group_name=None, only_image=None,
                 os=None, vendor_name=None):
        self.captcha_code = captcha_code  # type: str
        self.expired_date = expired_date  # type: long
        self.group_id = group_id  # type: long
        self.group_name = group_name  # type: str
        self.only_image = only_image  # type: bool
        self.os = os  # type: str
        self.vendor_name = vendor_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeInstallCodesResponseBodyInstallCodes, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.captcha_code is not None:
            result['CaptchaCode'] = self.captcha_code
        if self.expired_date is not None:
            result['ExpiredDate'] = self.expired_date
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.only_image is not None:
            result['OnlyImage'] = self.only_image
        if self.os is not None:
            result['Os'] = self.os
        if self.vendor_name is not None:
            result['VendorName'] = self.vendor_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CaptchaCode') is not None:
            self.captcha_code = m.get('CaptchaCode')
        if m.get('ExpiredDate') is not None:
            self.expired_date = m.get('ExpiredDate')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('OnlyImage') is not None:
            self.only_image = m.get('OnlyImage')
        if m.get('Os') is not None:
            self.os = m.get('Os')
        if m.get('VendorName') is not None:
            self.vendor_name = m.get('VendorName')
        return self


class DescribeInstallCodesResponseBody(TeaModel):
    def __init__(self, install_codes=None, request_id=None):
        self.install_codes = install_codes  # type: list[DescribeInstallCodesResponseBodyInstallCodes]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.install_codes:
            for k in self.install_codes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeInstallCodesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['InstallCodes'] = []
        if self.install_codes is not None:
            for k in self.install_codes:
                result['InstallCodes'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.install_codes = []
        if m.get('InstallCodes') is not None:
            for k in m.get('InstallCodes'):
                temp_model = DescribeInstallCodesResponseBodyInstallCodes()
                self.install_codes.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeInstallCodesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeInstallCodesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeInstallCodesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeInstallCodesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeInstanceAntiBruteForceRulesRequest(TeaModel):
    def __init__(self, resource_owner_id=None, source_ip=None, uuid_list=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.source_ip = source_ip  # type: str
        self.uuid_list = uuid_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeInstanceAntiBruteForceRulesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.uuid_list is not None:
            result['UuidList'] = self.uuid_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('UuidList') is not None:
            self.uuid_list = m.get('UuidList')
        return self


class DescribeInstanceAntiBruteForceRulesResponseBodyPageInfo(TeaModel):
    def __init__(self, count=None, current_page=None, page_size=None, total_count=None):
        self.count = count  # type: int
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeInstanceAntiBruteForceRulesResponseBodyPageInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeInstanceAntiBruteForceRulesResponseBodyRules(TeaModel):
    def __init__(self, id=None, name=None, uuid=None):
        self.id = id  # type: long
        self.name = name  # type: str
        self.uuid = uuid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeInstanceAntiBruteForceRulesResponseBodyRules, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeInstanceAntiBruteForceRulesResponseBody(TeaModel):
    def __init__(self, page_info=None, request_id=None, rules=None):
        self.page_info = page_info  # type: DescribeInstanceAntiBruteForceRulesResponseBodyPageInfo
        self.request_id = request_id  # type: str
        self.rules = rules  # type: list[DescribeInstanceAntiBruteForceRulesResponseBodyRules]

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.rules:
            for k in self.rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeInstanceAntiBruteForceRulesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Rules'] = []
        if self.rules is not None:
            for k in self.rules:
                result['Rules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageInfo') is not None:
            temp_model = DescribeInstanceAntiBruteForceRulesResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.rules = []
        if m.get('Rules') is not None:
            for k in m.get('Rules'):
                temp_model = DescribeInstanceAntiBruteForceRulesResponseBodyRules()
                self.rules.append(temp_model.from_map(k))
        return self


class DescribeInstanceAntiBruteForceRulesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeInstanceAntiBruteForceRulesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeInstanceAntiBruteForceRulesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeInstanceAntiBruteForceRulesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeInstanceStatisticsRequest(TeaModel):
    def __init__(self, from_=None, lang=None, source_ip=None, uuid=None):
        self.from_ = from_  # type: str
        self.lang = lang  # type: str
        self.source_ip = source_ip  # type: str
        self.uuid = uuid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeInstanceStatisticsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.from_ is not None:
            result['From'] = self.from_
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('From') is not None:
            self.from_ = m.get('From')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeInstanceStatisticsResponseBodyData(TeaModel):
    def __init__(self, account=None, app_num=None, cms_num=None, cve_num=None, emg_num=None, health=None,
                 sca_num=None, suspicious=None, sys_num=None, trojan=None, uuid=None, vul=None):
        self.account = account  # type: int
        self.app_num = app_num  # type: int
        self.cms_num = cms_num  # type: int
        self.cve_num = cve_num  # type: int
        self.emg_num = emg_num  # type: int
        self.health = health  # type: int
        self.sca_num = sca_num  # type: int
        self.suspicious = suspicious  # type: int
        self.sys_num = sys_num  # type: int
        self.trojan = trojan  # type: int
        self.uuid = uuid  # type: str
        self.vul = vul  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeInstanceStatisticsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account is not None:
            result['Account'] = self.account
        if self.app_num is not None:
            result['AppNum'] = self.app_num
        if self.cms_num is not None:
            result['CmsNum'] = self.cms_num
        if self.cve_num is not None:
            result['CveNum'] = self.cve_num
        if self.emg_num is not None:
            result['EmgNum'] = self.emg_num
        if self.health is not None:
            result['Health'] = self.health
        if self.sca_num is not None:
            result['ScaNum'] = self.sca_num
        if self.suspicious is not None:
            result['Suspicious'] = self.suspicious
        if self.sys_num is not None:
            result['SysNum'] = self.sys_num
        if self.trojan is not None:
            result['Trojan'] = self.trojan
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.vul is not None:
            result['Vul'] = self.vul
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Account') is not None:
            self.account = m.get('Account')
        if m.get('AppNum') is not None:
            self.app_num = m.get('AppNum')
        if m.get('CmsNum') is not None:
            self.cms_num = m.get('CmsNum')
        if m.get('CveNum') is not None:
            self.cve_num = m.get('CveNum')
        if m.get('EmgNum') is not None:
            self.emg_num = m.get('EmgNum')
        if m.get('Health') is not None:
            self.health = m.get('Health')
        if m.get('ScaNum') is not None:
            self.sca_num = m.get('ScaNum')
        if m.get('Suspicious') is not None:
            self.suspicious = m.get('Suspicious')
        if m.get('SysNum') is not None:
            self.sys_num = m.get('SysNum')
        if m.get('Trojan') is not None:
            self.trojan = m.get('Trojan')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('Vul') is not None:
            self.vul = m.get('Vul')
        return self


class DescribeInstanceStatisticsResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        self.data = data  # type: list[DescribeInstanceStatisticsResponseBodyData]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeInstanceStatisticsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DescribeInstanceStatisticsResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeInstanceStatisticsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeInstanceStatisticsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeInstanceStatisticsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeInstanceStatisticsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeIpInfoRequest(TeaModel):
    def __init__(self, field=None, ip=None):
        self.field = field  # type: str
        self.ip = ip  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeIpInfoRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.field is not None:
            result['Field'] = self.field
        if self.ip is not None:
            result['Ip'] = self.ip
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Field') is not None:
            self.field = m.get('Field')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        return self


class DescribeIpInfoResponseBody(TeaModel):
    def __init__(self, request_id=None, c_2day_trace=None, city=None, country=None, day_cnt_30d_tor=None,
                 day_cnt_30d_web_attack=None, day_cnt_7d_tor=None, day_cnt_7d_web_attack=None, geo=None, gmt_first_c2=None,
                 gmt_first_mining_pool=None, gmt_last_c2=None, gmt_last_malicious_login=None, gmt_last_malicious_source=None,
                 gmt_last_mining_pool=None, gmt_last_nat=None, gmt_last_proxy=None, gmt_last_tor=None, gmt_last_web_attack=None,
                 idc_name=None, ip=None, is_c2=None, is_c21d=None, is_c27d=None, is_idc=None, is_malicious_login=None,
                 is_malicious_login_1d=None, is_malicious_login_7d=None, is_malicious_source=None, is_malicious_source_1d=None,
                 is_malicious_source_30d=None, is_malicious_source_7d=None, is_mining_pool=None, is_mining_pool_1d=None,
                 is_mining_pool_7d=None, is_nat=None, is_nat_1d=None, is_nat_7d=None, is_proxy=None, is_proxy_1d=None,
                 is_proxy_7d=None, is_tor=None, is_tor_1d=None, is_tor_7d=None, is_web_attack=None, is_web_attack_1d=None,
                 is_web_attack_30d=None, is_web_attack_7d=None, isp=None, malicious_login_day_trace=None, malicious_score=None,
                 malicious_source_day_trace=None, mining_pool_day_trace=None, nat_day_trace=None, province=None, proxy_day_trace=None,
                 rdns=None, tags=None, tor_day_trace=None, total_day_cnt_tor=None, total_day_cnt_web_attack=None,
                 web_attack_day_trace=None):
        self.request_id = request_id  # type: str
        self.c_2day_trace = c_2day_trace  # type: str
        self.city = city  # type: str
        self.country = country  # type: str
        self.day_cnt_30d_tor = day_cnt_30d_tor  # type: str
        self.day_cnt_30d_web_attack = day_cnt_30d_web_attack  # type: str
        self.day_cnt_7d_tor = day_cnt_7d_tor  # type: str
        self.day_cnt_7d_web_attack = day_cnt_7d_web_attack  # type: str
        self.geo = geo  # type: str
        self.gmt_first_c2 = gmt_first_c2  # type: str
        self.gmt_first_mining_pool = gmt_first_mining_pool  # type: str
        self.gmt_last_c2 = gmt_last_c2  # type: str
        self.gmt_last_malicious_login = gmt_last_malicious_login  # type: str
        self.gmt_last_malicious_source = gmt_last_malicious_source  # type: str
        self.gmt_last_mining_pool = gmt_last_mining_pool  # type: str
        self.gmt_last_nat = gmt_last_nat  # type: str
        self.gmt_last_proxy = gmt_last_proxy  # type: str
        self.gmt_last_tor = gmt_last_tor  # type: str
        self.gmt_last_web_attack = gmt_last_web_attack  # type: str
        self.idc_name = idc_name  # type: str
        self.ip = ip  # type: str
        self.is_c2 = is_c2  # type: str
        self.is_c21d = is_c21d  # type: str
        self.is_c27d = is_c27d  # type: str
        self.is_idc = is_idc  # type: str
        self.is_malicious_login = is_malicious_login  # type: str
        self.is_malicious_login_1d = is_malicious_login_1d  # type: str
        self.is_malicious_login_7d = is_malicious_login_7d  # type: str
        self.is_malicious_source = is_malicious_source  # type: str
        self.is_malicious_source_1d = is_malicious_source_1d  # type: str
        self.is_malicious_source_30d = is_malicious_source_30d  # type: str
        self.is_malicious_source_7d = is_malicious_source_7d  # type: str
        self.is_mining_pool = is_mining_pool  # type: str
        self.is_mining_pool_1d = is_mining_pool_1d  # type: str
        self.is_mining_pool_7d = is_mining_pool_7d  # type: str
        self.is_nat = is_nat  # type: str
        self.is_nat_1d = is_nat_1d  # type: str
        self.is_nat_7d = is_nat_7d  # type: str
        self.is_proxy = is_proxy  # type: str
        self.is_proxy_1d = is_proxy_1d  # type: str
        self.is_proxy_7d = is_proxy_7d  # type: str
        self.is_tor = is_tor  # type: str
        self.is_tor_1d = is_tor_1d  # type: str
        self.is_tor_7d = is_tor_7d  # type: str
        self.is_web_attack = is_web_attack  # type: str
        self.is_web_attack_1d = is_web_attack_1d  # type: str
        self.is_web_attack_30d = is_web_attack_30d  # type: str
        self.is_web_attack_7d = is_web_attack_7d  # type: str
        self.isp = isp  # type: str
        self.malicious_login_day_trace = malicious_login_day_trace  # type: str
        self.malicious_score = malicious_score  # type: str
        self.malicious_source_day_trace = malicious_source_day_trace  # type: str
        self.mining_pool_day_trace = mining_pool_day_trace  # type: str
        self.nat_day_trace = nat_day_trace  # type: str
        self.province = province  # type: str
        self.proxy_day_trace = proxy_day_trace  # type: str
        self.rdns = rdns  # type: str
        self.tags = tags  # type: str
        self.tor_day_trace = tor_day_trace  # type: str
        self.total_day_cnt_tor = total_day_cnt_tor  # type: str
        self.total_day_cnt_web_attack = total_day_cnt_web_attack  # type: str
        self.web_attack_day_trace = web_attack_day_trace  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeIpInfoResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.c_2day_trace is not None:
            result['c2_day_trace'] = self.c_2day_trace
        if self.city is not None:
            result['city'] = self.city
        if self.country is not None:
            result['country'] = self.country
        if self.day_cnt_30d_tor is not None:
            result['day_cnt_30d_tor'] = self.day_cnt_30d_tor
        if self.day_cnt_30d_web_attack is not None:
            result['day_cnt_30d_web_attack'] = self.day_cnt_30d_web_attack
        if self.day_cnt_7d_tor is not None:
            result['day_cnt_7d_tor'] = self.day_cnt_7d_tor
        if self.day_cnt_7d_web_attack is not None:
            result['day_cnt_7d_web_attack'] = self.day_cnt_7d_web_attack
        if self.geo is not None:
            result['geo'] = self.geo
        if self.gmt_first_c2 is not None:
            result['gmt_first_c2'] = self.gmt_first_c2
        if self.gmt_first_mining_pool is not None:
            result['gmt_first_mining_pool'] = self.gmt_first_mining_pool
        if self.gmt_last_c2 is not None:
            result['gmt_last_c2'] = self.gmt_last_c2
        if self.gmt_last_malicious_login is not None:
            result['gmt_last_malicious_login'] = self.gmt_last_malicious_login
        if self.gmt_last_malicious_source is not None:
            result['gmt_last_malicious_source'] = self.gmt_last_malicious_source
        if self.gmt_last_mining_pool is not None:
            result['gmt_last_mining_pool'] = self.gmt_last_mining_pool
        if self.gmt_last_nat is not None:
            result['gmt_last_nat'] = self.gmt_last_nat
        if self.gmt_last_proxy is not None:
            result['gmt_last_proxy'] = self.gmt_last_proxy
        if self.gmt_last_tor is not None:
            result['gmt_last_tor'] = self.gmt_last_tor
        if self.gmt_last_web_attack is not None:
            result['gmt_last_web_attack'] = self.gmt_last_web_attack
        if self.idc_name is not None:
            result['idc_name'] = self.idc_name
        if self.ip is not None:
            result['ip'] = self.ip
        if self.is_c2 is not None:
            result['is_c2'] = self.is_c2
        if self.is_c21d is not None:
            result['is_c2_1d'] = self.is_c21d
        if self.is_c27d is not None:
            result['is_c2_7d'] = self.is_c27d
        if self.is_idc is not None:
            result['is_idc'] = self.is_idc
        if self.is_malicious_login is not None:
            result['is_malicious_login'] = self.is_malicious_login
        if self.is_malicious_login_1d is not None:
            result['is_malicious_login_1d'] = self.is_malicious_login_1d
        if self.is_malicious_login_7d is not None:
            result['is_malicious_login_7d'] = self.is_malicious_login_7d
        if self.is_malicious_source is not None:
            result['is_malicious_source'] = self.is_malicious_source
        if self.is_malicious_source_1d is not None:
            result['is_malicious_source_1d'] = self.is_malicious_source_1d
        if self.is_malicious_source_30d is not None:
            result['is_malicious_source_30d'] = self.is_malicious_source_30d
        if self.is_malicious_source_7d is not None:
            result['is_malicious_source_7d'] = self.is_malicious_source_7d
        if self.is_mining_pool is not None:
            result['is_mining_pool'] = self.is_mining_pool
        if self.is_mining_pool_1d is not None:
            result['is_mining_pool_1d'] = self.is_mining_pool_1d
        if self.is_mining_pool_7d is not None:
            result['is_mining_pool_7d'] = self.is_mining_pool_7d
        if self.is_nat is not None:
            result['is_nat'] = self.is_nat
        if self.is_nat_1d is not None:
            result['is_nat_1d'] = self.is_nat_1d
        if self.is_nat_7d is not None:
            result['is_nat_7d'] = self.is_nat_7d
        if self.is_proxy is not None:
            result['is_proxy'] = self.is_proxy
        if self.is_proxy_1d is not None:
            result['is_proxy_1d'] = self.is_proxy_1d
        if self.is_proxy_7d is not None:
            result['is_proxy_7d'] = self.is_proxy_7d
        if self.is_tor is not None:
            result['is_tor'] = self.is_tor
        if self.is_tor_1d is not None:
            result['is_tor_1d'] = self.is_tor_1d
        if self.is_tor_7d is not None:
            result['is_tor_7d'] = self.is_tor_7d
        if self.is_web_attack is not None:
            result['is_web_attack'] = self.is_web_attack
        if self.is_web_attack_1d is not None:
            result['is_web_attack_1d'] = self.is_web_attack_1d
        if self.is_web_attack_30d is not None:
            result['is_web_attack_30d'] = self.is_web_attack_30d
        if self.is_web_attack_7d is not None:
            result['is_web_attack_7d'] = self.is_web_attack_7d
        if self.isp is not None:
            result['isp'] = self.isp
        if self.malicious_login_day_trace is not None:
            result['malicious_login_day_trace'] = self.malicious_login_day_trace
        if self.malicious_score is not None:
            result['malicious_score'] = self.malicious_score
        if self.malicious_source_day_trace is not None:
            result['malicious_source_day_trace'] = self.malicious_source_day_trace
        if self.mining_pool_day_trace is not None:
            result['mining_pool_day_trace'] = self.mining_pool_day_trace
        if self.nat_day_trace is not None:
            result['nat_day_trace'] = self.nat_day_trace
        if self.province is not None:
            result['province'] = self.province
        if self.proxy_day_trace is not None:
            result['proxy_day_trace'] = self.proxy_day_trace
        if self.rdns is not None:
            result['rdns'] = self.rdns
        if self.tags is not None:
            result['tags'] = self.tags
        if self.tor_day_trace is not None:
            result['tor_day_trace'] = self.tor_day_trace
        if self.total_day_cnt_tor is not None:
            result['total_day_cnt_tor'] = self.total_day_cnt_tor
        if self.total_day_cnt_web_attack is not None:
            result['total_day_cnt_web_attack'] = self.total_day_cnt_web_attack
        if self.web_attack_day_trace is not None:
            result['web_attack_day_trace'] = self.web_attack_day_trace
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('c2_day_trace') is not None:
            self.c_2day_trace = m.get('c2_day_trace')
        if m.get('city') is not None:
            self.city = m.get('city')
        if m.get('country') is not None:
            self.country = m.get('country')
        if m.get('day_cnt_30d_tor') is not None:
            self.day_cnt_30d_tor = m.get('day_cnt_30d_tor')
        if m.get('day_cnt_30d_web_attack') is not None:
            self.day_cnt_30d_web_attack = m.get('day_cnt_30d_web_attack')
        if m.get('day_cnt_7d_tor') is not None:
            self.day_cnt_7d_tor = m.get('day_cnt_7d_tor')
        if m.get('day_cnt_7d_web_attack') is not None:
            self.day_cnt_7d_web_attack = m.get('day_cnt_7d_web_attack')
        if m.get('geo') is not None:
            self.geo = m.get('geo')
        if m.get('gmt_first_c2') is not None:
            self.gmt_first_c2 = m.get('gmt_first_c2')
        if m.get('gmt_first_mining_pool') is not None:
            self.gmt_first_mining_pool = m.get('gmt_first_mining_pool')
        if m.get('gmt_last_c2') is not None:
            self.gmt_last_c2 = m.get('gmt_last_c2')
        if m.get('gmt_last_malicious_login') is not None:
            self.gmt_last_malicious_login = m.get('gmt_last_malicious_login')
        if m.get('gmt_last_malicious_source') is not None:
            self.gmt_last_malicious_source = m.get('gmt_last_malicious_source')
        if m.get('gmt_last_mining_pool') is not None:
            self.gmt_last_mining_pool = m.get('gmt_last_mining_pool')
        if m.get('gmt_last_nat') is not None:
            self.gmt_last_nat = m.get('gmt_last_nat')
        if m.get('gmt_last_proxy') is not None:
            self.gmt_last_proxy = m.get('gmt_last_proxy')
        if m.get('gmt_last_tor') is not None:
            self.gmt_last_tor = m.get('gmt_last_tor')
        if m.get('gmt_last_web_attack') is not None:
            self.gmt_last_web_attack = m.get('gmt_last_web_attack')
        if m.get('idc_name') is not None:
            self.idc_name = m.get('idc_name')
        if m.get('ip') is not None:
            self.ip = m.get('ip')
        if m.get('is_c2') is not None:
            self.is_c2 = m.get('is_c2')
        if m.get('is_c2_1d') is not None:
            self.is_c21d = m.get('is_c2_1d')
        if m.get('is_c2_7d') is not None:
            self.is_c27d = m.get('is_c2_7d')
        if m.get('is_idc') is not None:
            self.is_idc = m.get('is_idc')
        if m.get('is_malicious_login') is not None:
            self.is_malicious_login = m.get('is_malicious_login')
        if m.get('is_malicious_login_1d') is not None:
            self.is_malicious_login_1d = m.get('is_malicious_login_1d')
        if m.get('is_malicious_login_7d') is not None:
            self.is_malicious_login_7d = m.get('is_malicious_login_7d')
        if m.get('is_malicious_source') is not None:
            self.is_malicious_source = m.get('is_malicious_source')
        if m.get('is_malicious_source_1d') is not None:
            self.is_malicious_source_1d = m.get('is_malicious_source_1d')
        if m.get('is_malicious_source_30d') is not None:
            self.is_malicious_source_30d = m.get('is_malicious_source_30d')
        if m.get('is_malicious_source_7d') is not None:
            self.is_malicious_source_7d = m.get('is_malicious_source_7d')
        if m.get('is_mining_pool') is not None:
            self.is_mining_pool = m.get('is_mining_pool')
        if m.get('is_mining_pool_1d') is not None:
            self.is_mining_pool_1d = m.get('is_mining_pool_1d')
        if m.get('is_mining_pool_7d') is not None:
            self.is_mining_pool_7d = m.get('is_mining_pool_7d')
        if m.get('is_nat') is not None:
            self.is_nat = m.get('is_nat')
        if m.get('is_nat_1d') is not None:
            self.is_nat_1d = m.get('is_nat_1d')
        if m.get('is_nat_7d') is not None:
            self.is_nat_7d = m.get('is_nat_7d')
        if m.get('is_proxy') is not None:
            self.is_proxy = m.get('is_proxy')
        if m.get('is_proxy_1d') is not None:
            self.is_proxy_1d = m.get('is_proxy_1d')
        if m.get('is_proxy_7d') is not None:
            self.is_proxy_7d = m.get('is_proxy_7d')
        if m.get('is_tor') is not None:
            self.is_tor = m.get('is_tor')
        if m.get('is_tor_1d') is not None:
            self.is_tor_1d = m.get('is_tor_1d')
        if m.get('is_tor_7d') is not None:
            self.is_tor_7d = m.get('is_tor_7d')
        if m.get('is_web_attack') is not None:
            self.is_web_attack = m.get('is_web_attack')
        if m.get('is_web_attack_1d') is not None:
            self.is_web_attack_1d = m.get('is_web_attack_1d')
        if m.get('is_web_attack_30d') is not None:
            self.is_web_attack_30d = m.get('is_web_attack_30d')
        if m.get('is_web_attack_7d') is not None:
            self.is_web_attack_7d = m.get('is_web_attack_7d')
        if m.get('isp') is not None:
            self.isp = m.get('isp')
        if m.get('malicious_login_day_trace') is not None:
            self.malicious_login_day_trace = m.get('malicious_login_day_trace')
        if m.get('malicious_score') is not None:
            self.malicious_score = m.get('malicious_score')
        if m.get('malicious_source_day_trace') is not None:
            self.malicious_source_day_trace = m.get('malicious_source_day_trace')
        if m.get('mining_pool_day_trace') is not None:
            self.mining_pool_day_trace = m.get('mining_pool_day_trace')
        if m.get('nat_day_trace') is not None:
            self.nat_day_trace = m.get('nat_day_trace')
        if m.get('province') is not None:
            self.province = m.get('province')
        if m.get('proxy_day_trace') is not None:
            self.proxy_day_trace = m.get('proxy_day_trace')
        if m.get('rdns') is not None:
            self.rdns = m.get('rdns')
        if m.get('tags') is not None:
            self.tags = m.get('tags')
        if m.get('tor_day_trace') is not None:
            self.tor_day_trace = m.get('tor_day_trace')
        if m.get('total_day_cnt_tor') is not None:
            self.total_day_cnt_tor = m.get('total_day_cnt_tor')
        if m.get('total_day_cnt_web_attack') is not None:
            self.total_day_cnt_web_attack = m.get('total_day_cnt_web_attack')
        if m.get('web_attack_day_trace') is not None:
            self.web_attack_day_trace = m.get('web_attack_day_trace')
        return self


class DescribeIpInfoResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeIpInfoResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeIpInfoResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeIpInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLogstoreStorageRequest(TeaModel):
    def __init__(self, from_=None, lang=None):
        self.from_ = from_  # type: str
        self.lang = lang  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLogstoreStorageRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.from_ is not None:
            result['From'] = self.from_
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('From') is not None:
            self.from_ = m.get('From')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DescribeLogstoreStorageResponseBody(TeaModel):
    def __init__(self, logstore=None, preserve=None, request_id=None, ttl=None, used=None):
        self.logstore = logstore  # type: str
        self.preserve = preserve  # type: long
        self.request_id = request_id  # type: str
        self.ttl = ttl  # type: int
        self.used = used  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLogstoreStorageResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.logstore is not None:
            result['Logstore'] = self.logstore
        if self.preserve is not None:
            result['Preserve'] = self.preserve
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.ttl is not None:
            result['Ttl'] = self.ttl
        if self.used is not None:
            result['Used'] = self.used
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Logstore') is not None:
            self.logstore = m.get('Logstore')
        if m.get('Preserve') is not None:
            self.preserve = m.get('Preserve')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Ttl') is not None:
            self.ttl = m.get('Ttl')
        if m.get('Used') is not None:
            self.used = m.get('Used')
        return self


class DescribeLogstoreStorageResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeLogstoreStorageResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLogstoreStorageResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLogstoreStorageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeModuleConfigResponseBodyModuleConfigListItems(TeaModel):
    def __init__(self, group_id=None, instance_id=None, instance_name=None, ip=None, region=None, uuid=None):
        self.group_id = group_id  # type: int
        self.instance_id = instance_id  # type: str
        self.instance_name = instance_name  # type: str
        self.ip = ip  # type: str
        self.region = region  # type: str
        self.uuid = uuid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeModuleConfigResponseBodyModuleConfigListItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.region is not None:
            result['Region'] = self.region
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeModuleConfigResponseBodyModuleConfigList(TeaModel):
    def __init__(self, config_name=None, items=None, module_name=None):
        self.config_name = config_name  # type: str
        self.items = items  # type: list[DescribeModuleConfigResponseBodyModuleConfigListItems]
        self.module_name = module_name  # type: str

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeModuleConfigResponseBodyModuleConfigList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_name is not None:
            result['ConfigName'] = self.config_name
        result['Items'] = []
        if self.items is not None:
            for k in self.items:
                result['Items'].append(k.to_map() if k else None)
        if self.module_name is not None:
            result['ModuleName'] = self.module_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConfigName') is not None:
            self.config_name = m.get('ConfigName')
        self.items = []
        if m.get('Items') is not None:
            for k in m.get('Items'):
                temp_model = DescribeModuleConfigResponseBodyModuleConfigListItems()
                self.items.append(temp_model.from_map(k))
        if m.get('ModuleName') is not None:
            self.module_name = m.get('ModuleName')
        return self


class DescribeModuleConfigResponseBody(TeaModel):
    def __init__(self, count=None, http_status_code=None, module_config_list=None, request_id=None, success=None):
        self.count = count  # type: int
        self.http_status_code = http_status_code  # type: int
        self.module_config_list = module_config_list  # type: list[DescribeModuleConfigResponseBodyModuleConfigList]
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.module_config_list:
            for k in self.module_config_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeModuleConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        result['ModuleConfigList'] = []
        if self.module_config_list is not None:
            for k in self.module_config_list:
                result['ModuleConfigList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        self.module_config_list = []
        if m.get('ModuleConfigList') is not None:
            for k in m.get('ModuleConfigList'):
                temp_model = DescribeModuleConfigResponseBodyModuleConfigList()
                self.module_config_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeModuleConfigResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeModuleConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeModuleConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeModuleConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeNoticeConfigRequest(TeaModel):
    def __init__(self, source_ip=None):
        self.source_ip = source_ip  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeNoticeConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeNoticeConfigResponseBodyNoticeConfigList(TeaModel):
    def __init__(self, ali_uid=None, current_page=None, project=None, route=None, time_limit=None):
        self.ali_uid = ali_uid  # type: long
        self.current_page = current_page  # type: int
        self.project = project  # type: str
        self.route = route  # type: int
        self.time_limit = time_limit  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeNoticeConfigResponseBodyNoticeConfigList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ali_uid is not None:
            result['AliUid'] = self.ali_uid
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.project is not None:
            result['Project'] = self.project
        if self.route is not None:
            result['Route'] = self.route
        if self.time_limit is not None:
            result['TimeLimit'] = self.time_limit
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AliUid') is not None:
            self.ali_uid = m.get('AliUid')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Project') is not None:
            self.project = m.get('Project')
        if m.get('Route') is not None:
            self.route = m.get('Route')
        if m.get('TimeLimit') is not None:
            self.time_limit = m.get('TimeLimit')
        return self


class DescribeNoticeConfigResponseBody(TeaModel):
    def __init__(self, notice_config_list=None, request_id=None):
        self.notice_config_list = notice_config_list  # type: list[DescribeNoticeConfigResponseBodyNoticeConfigList]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.notice_config_list:
            for k in self.notice_config_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeNoticeConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['NoticeConfigList'] = []
        if self.notice_config_list is not None:
            for k in self.notice_config_list:
                result['NoticeConfigList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.notice_config_list = []
        if m.get('NoticeConfigList') is not None:
            for k in m.get('NoticeConfigList'):
                temp_model = DescribeNoticeConfigResponseBodyNoticeConfigList()
                self.notice_config_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeNoticeConfigResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeNoticeConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeNoticeConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeNoticeConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePropertyCountRequest(TeaModel):
    def __init__(self, type=None, uuid_list=None):
        self.type = type  # type: str
        self.uuid_list = uuid_list  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePropertyCountRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.uuid_list is not None:
            result['UuidList'] = self.uuid_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('UuidList') is not None:
            self.uuid_list = m.get('UuidList')
        return self


class DescribePropertyCountResponseBody(TeaModel):
    def __init__(self, autorun=None, cron=None, database=None, lkm=None, port=None, process=None, request_id=None,
                 sca=None, software=None, user=None, web=None, webserver=None):
        self.autorun = autorun  # type: int
        self.cron = cron  # type: int
        self.database = database  # type: int
        self.lkm = lkm  # type: int
        self.port = port  # type: int
        self.process = process  # type: int
        self.request_id = request_id  # type: str
        self.sca = sca  # type: int
        self.software = software  # type: int
        self.user = user  # type: int
        self.web = web  # type: int
        self.webserver = webserver  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePropertyCountResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.autorun is not None:
            result['Autorun'] = self.autorun
        if self.cron is not None:
            result['Cron'] = self.cron
        if self.database is not None:
            result['Database'] = self.database
        if self.lkm is not None:
            result['Lkm'] = self.lkm
        if self.port is not None:
            result['Port'] = self.port
        if self.process is not None:
            result['Process'] = self.process
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.sca is not None:
            result['Sca'] = self.sca
        if self.software is not None:
            result['Software'] = self.software
        if self.user is not None:
            result['User'] = self.user
        if self.web is not None:
            result['Web'] = self.web
        if self.webserver is not None:
            result['Webserver'] = self.webserver
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Autorun') is not None:
            self.autorun = m.get('Autorun')
        if m.get('Cron') is not None:
            self.cron = m.get('Cron')
        if m.get('Database') is not None:
            self.database = m.get('Database')
        if m.get('Lkm') is not None:
            self.lkm = m.get('Lkm')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('Process') is not None:
            self.process = m.get('Process')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Sca') is not None:
            self.sca = m.get('Sca')
        if m.get('Software') is not None:
            self.software = m.get('Software')
        if m.get('User') is not None:
            self.user = m.get('User')
        if m.get('Web') is not None:
            self.web = m.get('Web')
        if m.get('Webserver') is not None:
            self.webserver = m.get('Webserver')
        return self


class DescribePropertyCountResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribePropertyCountResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribePropertyCountResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribePropertyCountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePropertyCronDetailRequest(TeaModel):
    def __init__(self, current_page=None, page_size=None, remark=None, source=None, user=None, uuid=None):
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.remark = remark  # type: str
        self.source = source  # type: str
        self.user = user  # type: str
        self.uuid = uuid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePropertyCronDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.source is not None:
            result['Source'] = self.source
        if self.user is not None:
            result['User'] = self.user
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('User') is not None:
            self.user = m.get('User')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribePropertyCronDetailResponseBodyPageInfo(TeaModel):
    def __init__(self, count=None, current_page=None, page_size=None, total_count=None):
        self.count = count  # type: int
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePropertyCronDetailResponseBodyPageInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribePropertyCronDetailResponseBodyPropertys(TeaModel):
    def __init__(self, cmd=None, create=None, create_timestamp=None, instance_id=None, instance_name=None,
                 internet_ip=None, intranet_ip=None, ip=None, md_5=None, period=None, source=None, user=None, uuid=None):
        self.cmd = cmd  # type: str
        self.create = create  # type: str
        self.create_timestamp = create_timestamp  # type: long
        self.instance_id = instance_id  # type: str
        self.instance_name = instance_name  # type: str
        self.internet_ip = internet_ip  # type: str
        self.intranet_ip = intranet_ip  # type: str
        self.ip = ip  # type: str
        self.md_5 = md_5  # type: str
        self.period = period  # type: str
        self.source = source  # type: str
        self.user = user  # type: str
        self.uuid = uuid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePropertyCronDetailResponseBodyPropertys, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cmd is not None:
            result['Cmd'] = self.cmd
        if self.create is not None:
            result['Create'] = self.create
        if self.create_timestamp is not None:
            result['CreateTimestamp'] = self.create_timestamp
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.md_5 is not None:
            result['Md5'] = self.md_5
        if self.period is not None:
            result['Period'] = self.period
        if self.source is not None:
            result['Source'] = self.source
        if self.user is not None:
            result['User'] = self.user
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Cmd') is not None:
            self.cmd = m.get('Cmd')
        if m.get('Create') is not None:
            self.create = m.get('Create')
        if m.get('CreateTimestamp') is not None:
            self.create_timestamp = m.get('CreateTimestamp')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('Md5') is not None:
            self.md_5 = m.get('Md5')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('User') is not None:
            self.user = m.get('User')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribePropertyCronDetailResponseBody(TeaModel):
    def __init__(self, page_info=None, propertys=None, request_id=None):
        self.page_info = page_info  # type: DescribePropertyCronDetailResponseBodyPageInfo
        self.propertys = propertys  # type: list[DescribePropertyCronDetailResponseBodyPropertys]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.propertys:
            for k in self.propertys:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribePropertyCronDetailResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        result['Propertys'] = []
        if self.propertys is not None:
            for k in self.propertys:
                result['Propertys'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageInfo') is not None:
            temp_model = DescribePropertyCronDetailResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        self.propertys = []
        if m.get('Propertys') is not None:
            for k in m.get('Propertys'):
                temp_model = DescribePropertyCronDetailResponseBodyPropertys()
                self.propertys.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribePropertyCronDetailResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribePropertyCronDetailResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribePropertyCronDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribePropertyCronDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePropertyPortDetailRequest(TeaModel):
    def __init__(self, bind_ip=None, current_page=None, page_size=None, port=None, proc_name=None, remark=None,
                 uuid=None):
        self.bind_ip = bind_ip  # type: str
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.port = port  # type: str
        self.proc_name = proc_name  # type: str
        self.remark = remark  # type: str
        self.uuid = uuid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePropertyPortDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bind_ip is not None:
            result['BindIp'] = self.bind_ip
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.port is not None:
            result['Port'] = self.port
        if self.proc_name is not None:
            result['ProcName'] = self.proc_name
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BindIp') is not None:
            self.bind_ip = m.get('BindIp')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('ProcName') is not None:
            self.proc_name = m.get('ProcName')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribePropertyPortDetailResponseBodyPageInfo(TeaModel):
    def __init__(self, count=None, current_page=None, page_size=None, total_count=None):
        self.count = count  # type: int
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePropertyPortDetailResponseBodyPageInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribePropertyPortDetailResponseBodyPropertys(TeaModel):
    def __init__(self, bind_ip=None, create=None, create_timestamp=None, instance_id=None, instance_name=None,
                 internet_ip=None, intranet_ip=None, ip=None, pid=None, port=None, proc_name=None, proto=None, uuid=None):
        self.bind_ip = bind_ip  # type: str
        self.create = create  # type: str
        self.create_timestamp = create_timestamp  # type: long
        self.instance_id = instance_id  # type: str
        self.instance_name = instance_name  # type: str
        self.internet_ip = internet_ip  # type: str
        self.intranet_ip = intranet_ip  # type: str
        self.ip = ip  # type: str
        self.pid = pid  # type: str
        self.port = port  # type: str
        self.proc_name = proc_name  # type: str
        self.proto = proto  # type: str
        self.uuid = uuid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePropertyPortDetailResponseBodyPropertys, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bind_ip is not None:
            result['BindIp'] = self.bind_ip
        if self.create is not None:
            result['Create'] = self.create
        if self.create_timestamp is not None:
            result['CreateTimestamp'] = self.create_timestamp
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.pid is not None:
            result['Pid'] = self.pid
        if self.port is not None:
            result['Port'] = self.port
        if self.proc_name is not None:
            result['ProcName'] = self.proc_name
        if self.proto is not None:
            result['Proto'] = self.proto
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BindIp') is not None:
            self.bind_ip = m.get('BindIp')
        if m.get('Create') is not None:
            self.create = m.get('Create')
        if m.get('CreateTimestamp') is not None:
            self.create_timestamp = m.get('CreateTimestamp')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('Pid') is not None:
            self.pid = m.get('Pid')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('ProcName') is not None:
            self.proc_name = m.get('ProcName')
        if m.get('Proto') is not None:
            self.proto = m.get('Proto')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribePropertyPortDetailResponseBody(TeaModel):
    def __init__(self, page_info=None, propertys=None, request_id=None):
        self.page_info = page_info  # type: DescribePropertyPortDetailResponseBodyPageInfo
        self.propertys = propertys  # type: list[DescribePropertyPortDetailResponseBodyPropertys]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.propertys:
            for k in self.propertys:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribePropertyPortDetailResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        result['Propertys'] = []
        if self.propertys is not None:
            for k in self.propertys:
                result['Propertys'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageInfo') is not None:
            temp_model = DescribePropertyPortDetailResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        self.propertys = []
        if m.get('Propertys') is not None:
            for k in m.get('Propertys'):
                temp_model = DescribePropertyPortDetailResponseBodyPropertys()
                self.propertys.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribePropertyPortDetailResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribePropertyPortDetailResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribePropertyPortDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribePropertyPortDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePropertyPortItemRequest(TeaModel):
    def __init__(self, current_page=None, force_flush=None, page_size=None, port=None):
        self.current_page = current_page  # type: int
        self.force_flush = force_flush  # type: bool
        self.page_size = page_size  # type: int
        self.port = port  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePropertyPortItemRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.force_flush is not None:
            result['ForceFlush'] = self.force_flush
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.port is not None:
            result['Port'] = self.port
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('ForceFlush') is not None:
            self.force_flush = m.get('ForceFlush')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        return self


class DescribePropertyPortItemResponseBodyPageInfo(TeaModel):
    def __init__(self, count=None, current_page=None, page_size=None, total_count=None):
        self.count = count  # type: int
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePropertyPortItemResponseBodyPageInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribePropertyPortItemResponseBodyPropertyItems(TeaModel):
    def __init__(self, count=None, port=None, proto=None):
        self.count = count  # type: int
        self.port = port  # type: str
        self.proto = proto  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePropertyPortItemResponseBodyPropertyItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.port is not None:
            result['Port'] = self.port
        if self.proto is not None:
            result['Proto'] = self.proto
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('Proto') is not None:
            self.proto = m.get('Proto')
        return self


class DescribePropertyPortItemResponseBody(TeaModel):
    def __init__(self, page_info=None, property_items=None, request_id=None):
        self.page_info = page_info  # type: DescribePropertyPortItemResponseBodyPageInfo
        self.property_items = property_items  # type: list[DescribePropertyPortItemResponseBodyPropertyItems]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.property_items:
            for k in self.property_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribePropertyPortItemResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        result['PropertyItems'] = []
        if self.property_items is not None:
            for k in self.property_items:
                result['PropertyItems'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageInfo') is not None:
            temp_model = DescribePropertyPortItemResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        self.property_items = []
        if m.get('PropertyItems') is not None:
            for k in m.get('PropertyItems'):
                temp_model = DescribePropertyPortItemResponseBodyPropertyItems()
                self.property_items.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribePropertyPortItemResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribePropertyPortItemResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribePropertyPortItemResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribePropertyPortItemResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePropertyProcDetailRequest(TeaModel):
    def __init__(self, cmdline=None, current_page=None, name=None, page_size=None, proc_time_end=None,
                 proc_time_start=None, remark=None, user=None, uuid=None):
        self.cmdline = cmdline  # type: str
        self.current_page = current_page  # type: int
        self.name = name  # type: str
        self.page_size = page_size  # type: int
        self.proc_time_end = proc_time_end  # type: long
        self.proc_time_start = proc_time_start  # type: long
        self.remark = remark  # type: str
        self.user = user  # type: str
        self.uuid = uuid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePropertyProcDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cmdline is not None:
            result['Cmdline'] = self.cmdline
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.name is not None:
            result['Name'] = self.name
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.proc_time_end is not None:
            result['ProcTimeEnd'] = self.proc_time_end
        if self.proc_time_start is not None:
            result['ProcTimeStart'] = self.proc_time_start
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.user is not None:
            result['User'] = self.user
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Cmdline') is not None:
            self.cmdline = m.get('Cmdline')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProcTimeEnd') is not None:
            self.proc_time_end = m.get('ProcTimeEnd')
        if m.get('ProcTimeStart') is not None:
            self.proc_time_start = m.get('ProcTimeStart')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('User') is not None:
            self.user = m.get('User')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribePropertyProcDetailResponseBodyPageInfo(TeaModel):
    def __init__(self, count=None, current_page=None, page_size=None, total_count=None):
        self.count = count  # type: int
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePropertyProcDetailResponseBodyPageInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribePropertyProcDetailResponseBodyPropertys(TeaModel):
    def __init__(self, cmdline=None, create=None, create_timestamp=None, euid_name=None, instance_id=None,
                 instance_name=None, internet_ip=None, intranet_ip=None, is_package=None, md_5=None, name=None, path=None, pid=None,
                 pname=None, start_time=None, start_time_dt=None, state=None, user=None, uuid=None):
        self.cmdline = cmdline  # type: str
        self.create = create  # type: str
        self.create_timestamp = create_timestamp  # type: long
        self.euid_name = euid_name  # type: str
        self.instance_id = instance_id  # type: str
        self.instance_name = instance_name  # type: str
        self.internet_ip = internet_ip  # type: str
        self.intranet_ip = intranet_ip  # type: str
        self.is_package = is_package  # type: int
        self.md_5 = md_5  # type: str
        self.name = name  # type: str
        self.path = path  # type: str
        self.pid = pid  # type: str
        self.pname = pname  # type: str
        self.start_time = start_time  # type: str
        self.start_time_dt = start_time_dt  # type: long
        self.state = state  # type: str
        self.user = user  # type: str
        self.uuid = uuid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePropertyProcDetailResponseBodyPropertys, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cmdline is not None:
            result['Cmdline'] = self.cmdline
        if self.create is not None:
            result['Create'] = self.create
        if self.create_timestamp is not None:
            result['CreateTimestamp'] = self.create_timestamp
        if self.euid_name is not None:
            result['EuidName'] = self.euid_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.is_package is not None:
            result['IsPackage'] = self.is_package
        if self.md_5 is not None:
            result['Md5'] = self.md_5
        if self.name is not None:
            result['Name'] = self.name
        if self.path is not None:
            result['Path'] = self.path
        if self.pid is not None:
            result['Pid'] = self.pid
        if self.pname is not None:
            result['Pname'] = self.pname
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.start_time_dt is not None:
            result['StartTimeDt'] = self.start_time_dt
        if self.state is not None:
            result['State'] = self.state
        if self.user is not None:
            result['User'] = self.user
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Cmdline') is not None:
            self.cmdline = m.get('Cmdline')
        if m.get('Create') is not None:
            self.create = m.get('Create')
        if m.get('CreateTimestamp') is not None:
            self.create_timestamp = m.get('CreateTimestamp')
        if m.get('EuidName') is not None:
            self.euid_name = m.get('EuidName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('IsPackage') is not None:
            self.is_package = m.get('IsPackage')
        if m.get('Md5') is not None:
            self.md_5 = m.get('Md5')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Pid') is not None:
            self.pid = m.get('Pid')
        if m.get('Pname') is not None:
            self.pname = m.get('Pname')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('StartTimeDt') is not None:
            self.start_time_dt = m.get('StartTimeDt')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('User') is not None:
            self.user = m.get('User')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribePropertyProcDetailResponseBody(TeaModel):
    def __init__(self, page_info=None, propertys=None, request_id=None):
        self.page_info = page_info  # type: DescribePropertyProcDetailResponseBodyPageInfo
        self.propertys = propertys  # type: list[DescribePropertyProcDetailResponseBodyPropertys]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.propertys:
            for k in self.propertys:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribePropertyProcDetailResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        result['Propertys'] = []
        if self.propertys is not None:
            for k in self.propertys:
                result['Propertys'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageInfo') is not None:
            temp_model = DescribePropertyProcDetailResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        self.propertys = []
        if m.get('Propertys') is not None:
            for k in m.get('Propertys'):
                temp_model = DescribePropertyProcDetailResponseBodyPropertys()
                self.propertys.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribePropertyProcDetailResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribePropertyProcDetailResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribePropertyProcDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribePropertyProcDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePropertyProcItemRequest(TeaModel):
    def __init__(self, current_page=None, force_flush=None, name=None, page_size=None):
        self.current_page = current_page  # type: int
        self.force_flush = force_flush  # type: bool
        self.name = name  # type: str
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePropertyProcItemRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.force_flush is not None:
            result['ForceFlush'] = self.force_flush
        if self.name is not None:
            result['Name'] = self.name
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('ForceFlush') is not None:
            self.force_flush = m.get('ForceFlush')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribePropertyProcItemResponseBodyPageInfo(TeaModel):
    def __init__(self, count=None, current_page=None, page_size=None, total_count=None):
        self.count = count  # type: int
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePropertyProcItemResponseBodyPageInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribePropertyProcItemResponseBodyPropertyItems(TeaModel):
    def __init__(self, count=None, name=None):
        self.count = count  # type: int
        self.name = name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePropertyProcItemResponseBodyPropertyItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DescribePropertyProcItemResponseBody(TeaModel):
    def __init__(self, page_info=None, property_items=None, request_id=None):
        self.page_info = page_info  # type: DescribePropertyProcItemResponseBodyPageInfo
        self.property_items = property_items  # type: list[DescribePropertyProcItemResponseBodyPropertyItems]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.property_items:
            for k in self.property_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribePropertyProcItemResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        result['PropertyItems'] = []
        if self.property_items is not None:
            for k in self.property_items:
                result['PropertyItems'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageInfo') is not None:
            temp_model = DescribePropertyProcItemResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        self.property_items = []
        if m.get('PropertyItems') is not None:
            for k in m.get('PropertyItems'):
                temp_model = DescribePropertyProcItemResponseBodyPropertyItems()
                self.property_items.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribePropertyProcItemResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribePropertyProcItemResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribePropertyProcItemResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribePropertyProcItemResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePropertyScaDetailRequest(TeaModel):
    def __init__(self, biz=None, biz_type=None, current_page=None, lang=None, name=None, page_size=None, pid=None,
                 port=None, process_started_end=None, process_started_start=None, remark=None, sca_name=None,
                 sca_name_pattern=None, sca_version=None, search_info=None, search_info_sub=None, search_item=None,
                 search_item_sub=None, user=None, uuid=None):
        self.biz = biz  # type: str
        self.biz_type = biz_type  # type: str
        self.current_page = current_page  # type: int
        self.lang = lang  # type: str
        self.name = name  # type: long
        self.page_size = page_size  # type: int
        self.pid = pid  # type: str
        self.port = port  # type: str
        self.process_started_end = process_started_end  # type: long
        self.process_started_start = process_started_start  # type: long
        self.remark = remark  # type: str
        self.sca_name = sca_name  # type: str
        self.sca_name_pattern = sca_name_pattern  # type: str
        self.sca_version = sca_version  # type: str
        self.search_info = search_info  # type: str
        self.search_info_sub = search_info_sub  # type: str
        self.search_item = search_item  # type: str
        self.search_item_sub = search_item_sub  # type: str
        self.user = user  # type: str
        self.uuid = uuid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePropertyScaDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz is not None:
            result['Biz'] = self.biz
        if self.biz_type is not None:
            result['BizType'] = self.biz_type
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.name is not None:
            result['Name'] = self.name
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.pid is not None:
            result['Pid'] = self.pid
        if self.port is not None:
            result['Port'] = self.port
        if self.process_started_end is not None:
            result['ProcessStartedEnd'] = self.process_started_end
        if self.process_started_start is not None:
            result['ProcessStartedStart'] = self.process_started_start
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.sca_name is not None:
            result['ScaName'] = self.sca_name
        if self.sca_name_pattern is not None:
            result['ScaNamePattern'] = self.sca_name_pattern
        if self.sca_version is not None:
            result['ScaVersion'] = self.sca_version
        if self.search_info is not None:
            result['SearchInfo'] = self.search_info
        if self.search_info_sub is not None:
            result['SearchInfoSub'] = self.search_info_sub
        if self.search_item is not None:
            result['SearchItem'] = self.search_item
        if self.search_item_sub is not None:
            result['SearchItemSub'] = self.search_item_sub
        if self.user is not None:
            result['User'] = self.user
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Biz') is not None:
            self.biz = m.get('Biz')
        if m.get('BizType') is not None:
            self.biz_type = m.get('BizType')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Pid') is not None:
            self.pid = m.get('Pid')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('ProcessStartedEnd') is not None:
            self.process_started_end = m.get('ProcessStartedEnd')
        if m.get('ProcessStartedStart') is not None:
            self.process_started_start = m.get('ProcessStartedStart')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('ScaName') is not None:
            self.sca_name = m.get('ScaName')
        if m.get('ScaNamePattern') is not None:
            self.sca_name_pattern = m.get('ScaNamePattern')
        if m.get('ScaVersion') is not None:
            self.sca_version = m.get('ScaVersion')
        if m.get('SearchInfo') is not None:
            self.search_info = m.get('SearchInfo')
        if m.get('SearchInfoSub') is not None:
            self.search_info_sub = m.get('SearchInfoSub')
        if m.get('SearchItem') is not None:
            self.search_item = m.get('SearchItem')
        if m.get('SearchItemSub') is not None:
            self.search_item_sub = m.get('SearchItemSub')
        if m.get('User') is not None:
            self.user = m.get('User')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribePropertyScaDetailResponseBodyPageInfo(TeaModel):
    def __init__(self, count=None, current_page=None, page_size=None, total_count=None):
        self.count = count  # type: int
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePropertyScaDetailResponseBodyPageInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribePropertyScaDetailResponseBodyPropertys(TeaModel):
    def __init__(self, biz_type=None, biz_type_dispaly=None, cmdline=None, config_path=None, container_name=None,
                 create=None, create_timestamp=None, image_name=None, instance_id=None, instance_name=None,
                 internet_ip=None, intranet_ip=None, ip=None, listen_ip=None, listen_protocol=None, listen_status=None,
                 name=None, path=None, pid=None, port=None, ppid=None, process_started=None, process_user=None, proof=None,
                 type=None, uuid=None, version=None, web_path=None):
        self.biz_type = biz_type  # type: str
        self.biz_type_dispaly = biz_type_dispaly  # type: str
        self.cmdline = cmdline  # type: str
        self.config_path = config_path  # type: str
        self.container_name = container_name  # type: str
        self.create = create  # type: str
        self.create_timestamp = create_timestamp  # type: long
        self.image_name = image_name  # type: str
        self.instance_id = instance_id  # type: str
        self.instance_name = instance_name  # type: str
        self.internet_ip = internet_ip  # type: str
        self.intranet_ip = intranet_ip  # type: str
        self.ip = ip  # type: str
        self.listen_ip = listen_ip  # type: str
        self.listen_protocol = listen_protocol  # type: str
        self.listen_status = listen_status  # type: str
        self.name = name  # type: str
        self.path = path  # type: str
        self.pid = pid  # type: str
        self.port = port  # type: str
        self.ppid = ppid  # type: str
        self.process_started = process_started  # type: long
        self.process_user = process_user  # type: str
        self.proof = proof  # type: str
        self.type = type  # type: str
        self.uuid = uuid  # type: str
        self.version = version  # type: str
        self.web_path = web_path  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePropertyScaDetailResponseBodyPropertys, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_type is not None:
            result['BizType'] = self.biz_type
        if self.biz_type_dispaly is not None:
            result['BizTypeDispaly'] = self.biz_type_dispaly
        if self.cmdline is not None:
            result['Cmdline'] = self.cmdline
        if self.config_path is not None:
            result['ConfigPath'] = self.config_path
        if self.container_name is not None:
            result['ContainerName'] = self.container_name
        if self.create is not None:
            result['Create'] = self.create
        if self.create_timestamp is not None:
            result['CreateTimestamp'] = self.create_timestamp
        if self.image_name is not None:
            result['ImageName'] = self.image_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.listen_ip is not None:
            result['ListenIp'] = self.listen_ip
        if self.listen_protocol is not None:
            result['ListenProtocol'] = self.listen_protocol
        if self.listen_status is not None:
            result['ListenStatus'] = self.listen_status
        if self.name is not None:
            result['Name'] = self.name
        if self.path is not None:
            result['Path'] = self.path
        if self.pid is not None:
            result['Pid'] = self.pid
        if self.port is not None:
            result['Port'] = self.port
        if self.ppid is not None:
            result['Ppid'] = self.ppid
        if self.process_started is not None:
            result['ProcessStarted'] = self.process_started
        if self.process_user is not None:
            result['ProcessUser'] = self.process_user
        if self.proof is not None:
            result['Proof'] = self.proof
        if self.type is not None:
            result['Type'] = self.type
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.version is not None:
            result['Version'] = self.version
        if self.web_path is not None:
            result['WebPath'] = self.web_path
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BizType') is not None:
            self.biz_type = m.get('BizType')
        if m.get('BizTypeDispaly') is not None:
            self.biz_type_dispaly = m.get('BizTypeDispaly')
        if m.get('Cmdline') is not None:
            self.cmdline = m.get('Cmdline')
        if m.get('ConfigPath') is not None:
            self.config_path = m.get('ConfigPath')
        if m.get('ContainerName') is not None:
            self.container_name = m.get('ContainerName')
        if m.get('Create') is not None:
            self.create = m.get('Create')
        if m.get('CreateTimestamp') is not None:
            self.create_timestamp = m.get('CreateTimestamp')
        if m.get('ImageName') is not None:
            self.image_name = m.get('ImageName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('ListenIp') is not None:
            self.listen_ip = m.get('ListenIp')
        if m.get('ListenProtocol') is not None:
            self.listen_protocol = m.get('ListenProtocol')
        if m.get('ListenStatus') is not None:
            self.listen_status = m.get('ListenStatus')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Pid') is not None:
            self.pid = m.get('Pid')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('Ppid') is not None:
            self.ppid = m.get('Ppid')
        if m.get('ProcessStarted') is not None:
            self.process_started = m.get('ProcessStarted')
        if m.get('ProcessUser') is not None:
            self.process_user = m.get('ProcessUser')
        if m.get('Proof') is not None:
            self.proof = m.get('Proof')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        if m.get('WebPath') is not None:
            self.web_path = m.get('WebPath')
        return self


class DescribePropertyScaDetailResponseBody(TeaModel):
    def __init__(self, page_info=None, propertys=None, request_id=None):
        self.page_info = page_info  # type: DescribePropertyScaDetailResponseBodyPageInfo
        self.propertys = propertys  # type: list[DescribePropertyScaDetailResponseBodyPropertys]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.propertys:
            for k in self.propertys:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribePropertyScaDetailResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        result['Propertys'] = []
        if self.propertys is not None:
            for k in self.propertys:
                result['Propertys'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageInfo') is not None:
            temp_model = DescribePropertyScaDetailResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        self.propertys = []
        if m.get('Propertys') is not None:
            for k in m.get('Propertys'):
                temp_model = DescribePropertyScaDetailResponseBodyPropertys()
                self.propertys.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribePropertyScaDetailResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribePropertyScaDetailResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribePropertyScaDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribePropertyScaDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePropertySoftwareDetailRequest(TeaModel):
    def __init__(self, current_page=None, install_time_end=None, install_time_start=None, name=None, page_size=None,
                 path=None, remark=None, software_version=None, uuid=None):
        self.current_page = current_page  # type: int
        self.install_time_end = install_time_end  # type: long
        self.install_time_start = install_time_start  # type: long
        self.name = name  # type: str
        self.page_size = page_size  # type: int
        self.path = path  # type: str
        self.remark = remark  # type: str
        self.software_version = software_version  # type: str
        self.uuid = uuid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePropertySoftwareDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.install_time_end is not None:
            result['InstallTimeEnd'] = self.install_time_end
        if self.install_time_start is not None:
            result['InstallTimeStart'] = self.install_time_start
        if self.name is not None:
            result['Name'] = self.name
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.path is not None:
            result['Path'] = self.path
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.software_version is not None:
            result['SoftwareVersion'] = self.software_version
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('InstallTimeEnd') is not None:
            self.install_time_end = m.get('InstallTimeEnd')
        if m.get('InstallTimeStart') is not None:
            self.install_time_start = m.get('InstallTimeStart')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('SoftwareVersion') is not None:
            self.software_version = m.get('SoftwareVersion')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribePropertySoftwareDetailResponseBodyPageInfo(TeaModel):
    def __init__(self, count=None, current_page=None, page_size=None, total_count=None):
        self.count = count  # type: int
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePropertySoftwareDetailResponseBodyPageInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribePropertySoftwareDetailResponseBodyPropertys(TeaModel):
    def __init__(self, create=None, create_timestamp=None, install_time=None, install_time_dt=None,
                 instance_id=None, instance_name=None, internet_ip=None, intranet_ip=None, ip=None, name=None, path=None,
                 uuid=None, version=None):
        self.create = create  # type: long
        self.create_timestamp = create_timestamp  # type: long
        self.install_time = install_time  # type: str
        self.install_time_dt = install_time_dt  # type: long
        self.instance_id = instance_id  # type: str
        self.instance_name = instance_name  # type: str
        self.internet_ip = internet_ip  # type: str
        self.intranet_ip = intranet_ip  # type: str
        self.ip = ip  # type: str
        self.name = name  # type: str
        self.path = path  # type: str
        self.uuid = uuid  # type: str
        self.version = version  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePropertySoftwareDetailResponseBodyPropertys, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create is not None:
            result['Create'] = self.create
        if self.create_timestamp is not None:
            result['CreateTimestamp'] = self.create_timestamp
        if self.install_time is not None:
            result['InstallTime'] = self.install_time
        if self.install_time_dt is not None:
            result['InstallTimeDt'] = self.install_time_dt
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.name is not None:
            result['Name'] = self.name
        if self.path is not None:
            result['Path'] = self.path
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Create') is not None:
            self.create = m.get('Create')
        if m.get('CreateTimestamp') is not None:
            self.create_timestamp = m.get('CreateTimestamp')
        if m.get('InstallTime') is not None:
            self.install_time = m.get('InstallTime')
        if m.get('InstallTimeDt') is not None:
            self.install_time_dt = m.get('InstallTimeDt')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class DescribePropertySoftwareDetailResponseBody(TeaModel):
    def __init__(self, page_info=None, propertys=None, request_id=None):
        self.page_info = page_info  # type: DescribePropertySoftwareDetailResponseBodyPageInfo
        self.propertys = propertys  # type: list[DescribePropertySoftwareDetailResponseBodyPropertys]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.propertys:
            for k in self.propertys:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribePropertySoftwareDetailResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        result['Propertys'] = []
        if self.propertys is not None:
            for k in self.propertys:
                result['Propertys'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageInfo') is not None:
            temp_model = DescribePropertySoftwareDetailResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        self.propertys = []
        if m.get('Propertys') is not None:
            for k in m.get('Propertys'):
                temp_model = DescribePropertySoftwareDetailResponseBodyPropertys()
                self.propertys.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribePropertySoftwareDetailResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribePropertySoftwareDetailResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribePropertySoftwareDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribePropertySoftwareDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePropertySoftwareItemRequest(TeaModel):
    def __init__(self, current_page=None, force_flush=None, name=None, page_size=None):
        self.current_page = current_page  # type: int
        self.force_flush = force_flush  # type: bool
        self.name = name  # type: str
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePropertySoftwareItemRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.force_flush is not None:
            result['ForceFlush'] = self.force_flush
        if self.name is not None:
            result['Name'] = self.name
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('ForceFlush') is not None:
            self.force_flush = m.get('ForceFlush')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribePropertySoftwareItemResponseBodyPageInfo(TeaModel):
    def __init__(self, count=None, current_page=None, page_size=None, total_count=None):
        self.count = count  # type: int
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePropertySoftwareItemResponseBodyPageInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribePropertySoftwareItemResponseBodyPropertyItems(TeaModel):
    def __init__(self, count=None, name=None):
        self.count = count  # type: int
        self.name = name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePropertySoftwareItemResponseBodyPropertyItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DescribePropertySoftwareItemResponseBody(TeaModel):
    def __init__(self, page_info=None, property_items=None, request_id=None):
        self.page_info = page_info  # type: DescribePropertySoftwareItemResponseBodyPageInfo
        self.property_items = property_items  # type: list[DescribePropertySoftwareItemResponseBodyPropertyItems]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.property_items:
            for k in self.property_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribePropertySoftwareItemResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        result['PropertyItems'] = []
        if self.property_items is not None:
            for k in self.property_items:
                result['PropertyItems'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageInfo') is not None:
            temp_model = DescribePropertySoftwareItemResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        self.property_items = []
        if m.get('PropertyItems') is not None:
            for k in m.get('PropertyItems'):
                temp_model = DescribePropertySoftwareItemResponseBodyPropertyItems()
                self.property_items.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribePropertySoftwareItemResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribePropertySoftwareItemResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribePropertySoftwareItemResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribePropertySoftwareItemResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePropertyUsageNewestRequest(TeaModel):
    def __init__(self, type=None):
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePropertyUsageNewestRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribePropertyUsageNewestResponseBodyNewestStatisticItems(TeaModel):
    def __init__(self, create=None, name=None):
        self.create = create  # type: long
        self.name = name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePropertyUsageNewestResponseBodyNewestStatisticItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create is not None:
            result['Create'] = self.create
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Create') is not None:
            self.create = m.get('Create')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DescribePropertyUsageNewestResponseBody(TeaModel):
    def __init__(self, item_count=None, newest_statistic_items=None, request_id=None, type=None):
        self.item_count = item_count  # type: int
        self.newest_statistic_items = newest_statistic_items  # type: list[DescribePropertyUsageNewestResponseBodyNewestStatisticItems]
        self.request_id = request_id  # type: str
        self.type = type  # type: str

    def validate(self):
        if self.newest_statistic_items:
            for k in self.newest_statistic_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribePropertyUsageNewestResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.item_count is not None:
            result['ItemCount'] = self.item_count
        result['NewestStatisticItems'] = []
        if self.newest_statistic_items is not None:
            for k in self.newest_statistic_items:
                result['NewestStatisticItems'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ItemCount') is not None:
            self.item_count = m.get('ItemCount')
        self.newest_statistic_items = []
        if m.get('NewestStatisticItems') is not None:
            for k in m.get('NewestStatisticItems'):
                temp_model = DescribePropertyUsageNewestResponseBodyNewestStatisticItems()
                self.newest_statistic_items.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribePropertyUsageNewestResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribePropertyUsageNewestResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribePropertyUsageNewestResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribePropertyUsageNewestResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePropertyUserDetailRequest(TeaModel):
    def __init__(self, current_page=None, is_root=None, last_login_time_end=None, last_login_time_start=None,
                 page_size=None, remark=None, user=None, uuid=None):
        self.current_page = current_page  # type: int
        self.is_root = is_root  # type: str
        self.last_login_time_end = last_login_time_end  # type: long
        self.last_login_time_start = last_login_time_start  # type: long
        self.page_size = page_size  # type: int
        self.remark = remark  # type: str
        self.user = user  # type: str
        self.uuid = uuid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePropertyUserDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.is_root is not None:
            result['IsRoot'] = self.is_root
        if self.last_login_time_end is not None:
            result['LastLoginTimeEnd'] = self.last_login_time_end
        if self.last_login_time_start is not None:
            result['LastLoginTimeStart'] = self.last_login_time_start
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.user is not None:
            result['User'] = self.user
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('IsRoot') is not None:
            self.is_root = m.get('IsRoot')
        if m.get('LastLoginTimeEnd') is not None:
            self.last_login_time_end = m.get('LastLoginTimeEnd')
        if m.get('LastLoginTimeStart') is not None:
            self.last_login_time_start = m.get('LastLoginTimeStart')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('User') is not None:
            self.user = m.get('User')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribePropertyUserDetailResponseBodyPageInfo(TeaModel):
    def __init__(self, count=None, current_page=None, page_size=None, total_count=None):
        self.count = count  # type: int
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePropertyUserDetailResponseBodyPageInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribePropertyUserDetailResponseBodyPropertys(TeaModel):
    def __init__(self, accounts_expiration_date=None, create=None, create_timestamp=None, group_names=None,
                 instance_id=None, instance_name=None, internet_ip=None, intranet_ip=None, ip=None, is_could_login=None,
                 is_passwd_expired=None, is_passwd_locked=None, is_root=None, is_sudoer=None, is_user_expired=None,
                 last_login_ip=None, last_login_time=None, last_login_time_dt=None, last_login_timestamp=None,
                 password_expiration_date=None, status=None, user=None, uuid=None):
        self.accounts_expiration_date = accounts_expiration_date  # type: str
        self.create = create  # type: str
        self.create_timestamp = create_timestamp  # type: long
        self.group_names = group_names  # type: list[str]
        self.instance_id = instance_id  # type: str
        self.instance_name = instance_name  # type: str
        self.internet_ip = internet_ip  # type: str
        self.intranet_ip = intranet_ip  # type: str
        self.ip = ip  # type: str
        self.is_could_login = is_could_login  # type: int
        self.is_passwd_expired = is_passwd_expired  # type: int
        self.is_passwd_locked = is_passwd_locked  # type: int
        self.is_root = is_root  # type: str
        self.is_sudoer = is_sudoer  # type: int
        self.is_user_expired = is_user_expired  # type: int
        self.last_login_ip = last_login_ip  # type: str
        self.last_login_time = last_login_time  # type: str
        self.last_login_time_dt = last_login_time_dt  # type: long
        self.last_login_timestamp = last_login_timestamp  # type: long
        self.password_expiration_date = password_expiration_date  # type: str
        self.status = status  # type: str
        self.user = user  # type: str
        self.uuid = uuid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePropertyUserDetailResponseBodyPropertys, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accounts_expiration_date is not None:
            result['AccountsExpirationDate'] = self.accounts_expiration_date
        if self.create is not None:
            result['Create'] = self.create
        if self.create_timestamp is not None:
            result['CreateTimestamp'] = self.create_timestamp
        if self.group_names is not None:
            result['GroupNames'] = self.group_names
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.is_could_login is not None:
            result['IsCouldLogin'] = self.is_could_login
        if self.is_passwd_expired is not None:
            result['IsPasswdExpired'] = self.is_passwd_expired
        if self.is_passwd_locked is not None:
            result['IsPasswdLocked'] = self.is_passwd_locked
        if self.is_root is not None:
            result['IsRoot'] = self.is_root
        if self.is_sudoer is not None:
            result['IsSudoer'] = self.is_sudoer
        if self.is_user_expired is not None:
            result['IsUserExpired'] = self.is_user_expired
        if self.last_login_ip is not None:
            result['LastLoginIp'] = self.last_login_ip
        if self.last_login_time is not None:
            result['LastLoginTime'] = self.last_login_time
        if self.last_login_time_dt is not None:
            result['LastLoginTimeDt'] = self.last_login_time_dt
        if self.last_login_timestamp is not None:
            result['LastLoginTimestamp'] = self.last_login_timestamp
        if self.password_expiration_date is not None:
            result['PasswordExpirationDate'] = self.password_expiration_date
        if self.status is not None:
            result['Status'] = self.status
        if self.user is not None:
            result['User'] = self.user
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountsExpirationDate') is not None:
            self.accounts_expiration_date = m.get('AccountsExpirationDate')
        if m.get('Create') is not None:
            self.create = m.get('Create')
        if m.get('CreateTimestamp') is not None:
            self.create_timestamp = m.get('CreateTimestamp')
        if m.get('GroupNames') is not None:
            self.group_names = m.get('GroupNames')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('IsCouldLogin') is not None:
            self.is_could_login = m.get('IsCouldLogin')
        if m.get('IsPasswdExpired') is not None:
            self.is_passwd_expired = m.get('IsPasswdExpired')
        if m.get('IsPasswdLocked') is not None:
            self.is_passwd_locked = m.get('IsPasswdLocked')
        if m.get('IsRoot') is not None:
            self.is_root = m.get('IsRoot')
        if m.get('IsSudoer') is not None:
            self.is_sudoer = m.get('IsSudoer')
        if m.get('IsUserExpired') is not None:
            self.is_user_expired = m.get('IsUserExpired')
        if m.get('LastLoginIp') is not None:
            self.last_login_ip = m.get('LastLoginIp')
        if m.get('LastLoginTime') is not None:
            self.last_login_time = m.get('LastLoginTime')
        if m.get('LastLoginTimeDt') is not None:
            self.last_login_time_dt = m.get('LastLoginTimeDt')
        if m.get('LastLoginTimestamp') is not None:
            self.last_login_timestamp = m.get('LastLoginTimestamp')
        if m.get('PasswordExpirationDate') is not None:
            self.password_expiration_date = m.get('PasswordExpirationDate')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('User') is not None:
            self.user = m.get('User')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribePropertyUserDetailResponseBody(TeaModel):
    def __init__(self, page_info=None, propertys=None, request_id=None):
        self.page_info = page_info  # type: DescribePropertyUserDetailResponseBodyPageInfo
        self.propertys = propertys  # type: list[DescribePropertyUserDetailResponseBodyPropertys]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.propertys:
            for k in self.propertys:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribePropertyUserDetailResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        result['Propertys'] = []
        if self.propertys is not None:
            for k in self.propertys:
                result['Propertys'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageInfo') is not None:
            temp_model = DescribePropertyUserDetailResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        self.propertys = []
        if m.get('Propertys') is not None:
            for k in m.get('Propertys'):
                temp_model = DescribePropertyUserDetailResponseBodyPropertys()
                self.propertys.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribePropertyUserDetailResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribePropertyUserDetailResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribePropertyUserDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribePropertyUserDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePropertyUserItemRequest(TeaModel):
    def __init__(self, current_page=None, force_flush=None, page_size=None, user=None):
        self.current_page = current_page  # type: int
        self.force_flush = force_flush  # type: bool
        self.page_size = page_size  # type: int
        self.user = user  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePropertyUserItemRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.force_flush is not None:
            result['ForceFlush'] = self.force_flush
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.user is not None:
            result['User'] = self.user
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('ForceFlush') is not None:
            self.force_flush = m.get('ForceFlush')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('User') is not None:
            self.user = m.get('User')
        return self


class DescribePropertyUserItemResponseBodyPageInfo(TeaModel):
    def __init__(self, count=None, current_page=None, page_size=None, total_count=None):
        self.count = count  # type: int
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePropertyUserItemResponseBodyPageInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribePropertyUserItemResponseBodyPropertyItems(TeaModel):
    def __init__(self, count=None, user=None):
        self.count = count  # type: int
        self.user = user  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePropertyUserItemResponseBodyPropertyItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.user is not None:
            result['User'] = self.user
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('User') is not None:
            self.user = m.get('User')
        return self


class DescribePropertyUserItemResponseBody(TeaModel):
    def __init__(self, page_info=None, property_items=None, request_id=None):
        self.page_info = page_info  # type: DescribePropertyUserItemResponseBodyPageInfo
        self.property_items = property_items  # type: list[DescribePropertyUserItemResponseBodyPropertyItems]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.property_items:
            for k in self.property_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribePropertyUserItemResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        result['PropertyItems'] = []
        if self.property_items is not None:
            for k in self.property_items:
                result['PropertyItems'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageInfo') is not None:
            temp_model = DescribePropertyUserItemResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        self.property_items = []
        if m.get('PropertyItems') is not None:
            for k in m.get('PropertyItems'):
                temp_model = DescribePropertyUserItemResponseBodyPropertyItems()
                self.property_items.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribePropertyUserItemResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribePropertyUserItemResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribePropertyUserItemResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribePropertyUserItemResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRestoreJobsRequest(TeaModel):
    def __init__(self, current_page=None, machine_remark=None, page_size=None, status=None):
        self.current_page = current_page  # type: int
        self.machine_remark = machine_remark  # type: str
        self.page_size = page_size  # type: int
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeRestoreJobsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.machine_remark is not None:
            result['MachineRemark'] = self.machine_remark
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('MachineRemark') is not None:
            self.machine_remark = m.get('MachineRemark')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeRestoreJobsResponseBodyPageInfo(TeaModel):
    def __init__(self, count=None, current_page=None, page_size=None, total_count=None):
        self.count = count  # type: int
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeRestoreJobsResponseBodyPageInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeRestoreJobsResponseBodyRestoreJobs(TeaModel):
    def __init__(self, actual_bytes=None, bytes_done=None, bytes_total=None, client_id=None, complete_time=None,
                 created_time=None, duration=None, error_count=None, error_file=None, error_file_url=None, error_type=None,
                 eta=None, excludes=None, exit_code=None, gmt_create=None, gmt_modified=None, includes=None,
                 instance_id=None, instance_name=None, internet_ip=None, intranet_ip=None, items_done=None, items_total=None,
                 message=None, percentage=None, request_id=None, restore_id=None, restore_name=None, restore_type=None,
                 snapshot_hash=None, snapshot_id=None, snapshot_version=None, source=None, source_client_id=None, speed=None,
                 status=None, target=None, updated_time=None, uuid=None, vault_id=None):
        self.actual_bytes = actual_bytes  # type: long
        self.bytes_done = bytes_done  # type: long
        self.bytes_total = bytes_total  # type: long
        self.client_id = client_id  # type: str
        self.complete_time = complete_time  # type: long
        self.created_time = created_time  # type: long
        self.duration = duration  # type: long
        self.error_count = error_count  # type: long
        self.error_file = error_file  # type: str
        self.error_file_url = error_file_url  # type: str
        self.error_type = error_type  # type: str
        self.eta = eta  # type: long
        self.excludes = excludes  # type: str
        self.exit_code = exit_code  # type: str
        self.gmt_create = gmt_create  # type: str
        self.gmt_modified = gmt_modified  # type: str
        self.includes = includes  # type: str
        self.instance_id = instance_id  # type: str
        self.instance_name = instance_name  # type: str
        self.internet_ip = internet_ip  # type: str
        self.intranet_ip = intranet_ip  # type: str
        self.items_done = items_done  # type: long
        self.items_total = items_total  # type: long
        self.message = message  # type: str
        self.percentage = percentage  # type: int
        self.request_id = request_id  # type: str
        self.restore_id = restore_id  # type: str
        self.restore_name = restore_name  # type: str
        self.restore_type = restore_type  # type: str
        self.snapshot_hash = snapshot_hash  # type: str
        self.snapshot_id = snapshot_id  # type: str
        self.snapshot_version = snapshot_version  # type: str
        self.source = source  # type: str
        self.source_client_id = source_client_id  # type: str
        self.speed = speed  # type: long
        self.status = status  # type: str
        self.target = target  # type: str
        self.updated_time = updated_time  # type: long
        self.uuid = uuid  # type: str
        self.vault_id = vault_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeRestoreJobsResponseBodyRestoreJobs, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.actual_bytes is not None:
            result['ActualBytes'] = self.actual_bytes
        if self.bytes_done is not None:
            result['BytesDone'] = self.bytes_done
        if self.bytes_total is not None:
            result['BytesTotal'] = self.bytes_total
        if self.client_id is not None:
            result['ClientId'] = self.client_id
        if self.complete_time is not None:
            result['CompleteTime'] = self.complete_time
        if self.created_time is not None:
            result['CreatedTime'] = self.created_time
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.error_count is not None:
            result['ErrorCount'] = self.error_count
        if self.error_file is not None:
            result['ErrorFile'] = self.error_file
        if self.error_file_url is not None:
            result['ErrorFileUrl'] = self.error_file_url
        if self.error_type is not None:
            result['ErrorType'] = self.error_type
        if self.eta is not None:
            result['Eta'] = self.eta
        if self.excludes is not None:
            result['Excludes'] = self.excludes
        if self.exit_code is not None:
            result['ExitCode'] = self.exit_code
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.includes is not None:
            result['Includes'] = self.includes
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.items_done is not None:
            result['ItemsDone'] = self.items_done
        if self.items_total is not None:
            result['ItemsTotal'] = self.items_total
        if self.message is not None:
            result['Message'] = self.message
        if self.percentage is not None:
            result['Percentage'] = self.percentage
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.restore_id is not None:
            result['RestoreId'] = self.restore_id
        if self.restore_name is not None:
            result['RestoreName'] = self.restore_name
        if self.restore_type is not None:
            result['RestoreType'] = self.restore_type
        if self.snapshot_hash is not None:
            result['SnapshotHash'] = self.snapshot_hash
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        if self.snapshot_version is not None:
            result['SnapshotVersion'] = self.snapshot_version
        if self.source is not None:
            result['Source'] = self.source
        if self.source_client_id is not None:
            result['SourceClientId'] = self.source_client_id
        if self.speed is not None:
            result['Speed'] = self.speed
        if self.status is not None:
            result['Status'] = self.status
        if self.target is not None:
            result['Target'] = self.target
        if self.updated_time is not None:
            result['UpdatedTime'] = self.updated_time
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.vault_id is not None:
            result['VaultId'] = self.vault_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ActualBytes') is not None:
            self.actual_bytes = m.get('ActualBytes')
        if m.get('BytesDone') is not None:
            self.bytes_done = m.get('BytesDone')
        if m.get('BytesTotal') is not None:
            self.bytes_total = m.get('BytesTotal')
        if m.get('ClientId') is not None:
            self.client_id = m.get('ClientId')
        if m.get('CompleteTime') is not None:
            self.complete_time = m.get('CompleteTime')
        if m.get('CreatedTime') is not None:
            self.created_time = m.get('CreatedTime')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('ErrorCount') is not None:
            self.error_count = m.get('ErrorCount')
        if m.get('ErrorFile') is not None:
            self.error_file = m.get('ErrorFile')
        if m.get('ErrorFileUrl') is not None:
            self.error_file_url = m.get('ErrorFileUrl')
        if m.get('ErrorType') is not None:
            self.error_type = m.get('ErrorType')
        if m.get('Eta') is not None:
            self.eta = m.get('Eta')
        if m.get('Excludes') is not None:
            self.excludes = m.get('Excludes')
        if m.get('ExitCode') is not None:
            self.exit_code = m.get('ExitCode')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('Includes') is not None:
            self.includes = m.get('Includes')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('ItemsDone') is not None:
            self.items_done = m.get('ItemsDone')
        if m.get('ItemsTotal') is not None:
            self.items_total = m.get('ItemsTotal')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Percentage') is not None:
            self.percentage = m.get('Percentage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RestoreId') is not None:
            self.restore_id = m.get('RestoreId')
        if m.get('RestoreName') is not None:
            self.restore_name = m.get('RestoreName')
        if m.get('RestoreType') is not None:
            self.restore_type = m.get('RestoreType')
        if m.get('SnapshotHash') is not None:
            self.snapshot_hash = m.get('SnapshotHash')
        if m.get('SnapshotId') is not None:
            self.snapshot_id = m.get('SnapshotId')
        if m.get('SnapshotVersion') is not None:
            self.snapshot_version = m.get('SnapshotVersion')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('SourceClientId') is not None:
            self.source_client_id = m.get('SourceClientId')
        if m.get('Speed') is not None:
            self.speed = m.get('Speed')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Target') is not None:
            self.target = m.get('Target')
        if m.get('UpdatedTime') is not None:
            self.updated_time = m.get('UpdatedTime')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('VaultId') is not None:
            self.vault_id = m.get('VaultId')
        return self


class DescribeRestoreJobsResponseBody(TeaModel):
    def __init__(self, page_info=None, request_id=None, restore_jobs=None):
        self.page_info = page_info  # type: DescribeRestoreJobsResponseBodyPageInfo
        self.request_id = request_id  # type: str
        self.restore_jobs = restore_jobs  # type: list[DescribeRestoreJobsResponseBodyRestoreJobs]

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.restore_jobs:
            for k in self.restore_jobs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeRestoreJobsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['RestoreJobs'] = []
        if self.restore_jobs is not None:
            for k in self.restore_jobs:
                result['RestoreJobs'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageInfo') is not None:
            temp_model = DescribeRestoreJobsResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.restore_jobs = []
        if m.get('RestoreJobs') is not None:
            for k in m.get('RestoreJobs'):
                temp_model = DescribeRestoreJobsResponseBodyRestoreJobs()
                self.restore_jobs.append(temp_model.from_map(k))
        return self


class DescribeRestoreJobsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeRestoreJobsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeRestoreJobsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeRestoreJobsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRiskCheckItemResultRequest(TeaModel):
    def __init__(self, current_page=None, item_id=None, lang=None, page_size=None, resource_owner_id=None,
                 source_ip=None):
        self.current_page = current_page  # type: int
        self.item_id = item_id  # type: long
        self.lang = lang  # type: str
        self.page_size = page_size  # type: int
        self.resource_owner_id = resource_owner_id  # type: long
        self.source_ip = source_ip  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeRiskCheckItemResultRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.item_id is not None:
            result['ItemId'] = self.item_id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('ItemId') is not None:
            self.item_id = m.get('ItemId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeRiskCheckItemResultResponseBodyPageContentResource(TeaModel):
    def __init__(self, content_resource=None, count=None, current_page=None, page_count=None, page_size=None,
                 total_count=None):
        self.content_resource = content_resource  # type: str
        self.count = count  # type: int
        self.current_page = current_page  # type: int
        self.page_count = page_count  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeRiskCheckItemResultResponseBodyPageContentResource, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content_resource is not None:
            result['ContentResource'] = self.content_resource
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContentResource') is not None:
            self.content_resource = m.get('ContentResource')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeRiskCheckItemResultResponseBody(TeaModel):
    def __init__(self, page_content_resource=None, request_id=None):
        self.page_content_resource = page_content_resource  # type: DescribeRiskCheckItemResultResponseBodyPageContentResource
        self.request_id = request_id  # type: str

    def validate(self):
        if self.page_content_resource:
            self.page_content_resource.validate()

    def to_map(self):
        _map = super(DescribeRiskCheckItemResultResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_content_resource is not None:
            result['PageContentResource'] = self.page_content_resource.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageContentResource') is not None:
            temp_model = DescribeRiskCheckItemResultResponseBodyPageContentResource()
            self.page_content_resource = temp_model.from_map(m['PageContentResource'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeRiskCheckItemResultResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeRiskCheckItemResultResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeRiskCheckItemResultResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeRiskCheckItemResultResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRiskCheckResultRequest(TeaModel):
    def __init__(self, asset_type=None, current_page=None, group_id=None, item_ids=None, lang=None, name=None,
                 page_size=None, query_flag=None, resource_owner_id=None, risk_level=None, source_ip=None, status=None):
        self.asset_type = asset_type  # type: str
        self.current_page = current_page  # type: int
        self.group_id = group_id  # type: long
        self.item_ids = item_ids  # type: list[str]
        self.lang = lang  # type: str
        self.name = name  # type: str
        self.page_size = page_size  # type: int
        self.query_flag = query_flag  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.risk_level = risk_level  # type: str
        self.source_ip = source_ip  # type: str
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeRiskCheckResultRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.asset_type is not None:
            result['AssetType'] = self.asset_type
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.item_ids is not None:
            result['ItemIds'] = self.item_ids
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.name is not None:
            result['Name'] = self.name
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.query_flag is not None:
            result['QueryFlag'] = self.query_flag
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AssetType') is not None:
            self.asset_type = m.get('AssetType')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('ItemIds') is not None:
            self.item_ids = m.get('ItemIds')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('QueryFlag') is not None:
            self.query_flag = m.get('QueryFlag')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeRiskCheckResultResponseBodyListRiskItemResources(TeaModel):
    def __init__(self, content_resource=None, resource_name=None):
        self.content_resource = content_resource  # type: str
        self.resource_name = resource_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeRiskCheckResultResponseBodyListRiskItemResources, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content_resource is not None:
            result['ContentResource'] = self.content_resource
        if self.resource_name is not None:
            result['ResourceName'] = self.resource_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContentResource') is not None:
            self.content_resource = m.get('ContentResource')
        if m.get('ResourceName') is not None:
            self.resource_name = m.get('ResourceName')
        return self


class DescribeRiskCheckResultResponseBodyList(TeaModel):
    def __init__(self, affected_count=None, check_time=None, item_id=None, remaining_time=None, repair_status=None,
                 risk_assert_type=None, risk_item_resources=None, risk_level=None, sort=None, start_status=None, status=None,
                 task_id=None, title=None, type=None):
        self.affected_count = affected_count  # type: int
        self.check_time = check_time  # type: long
        self.item_id = item_id  # type: long
        self.remaining_time = remaining_time  # type: int
        self.repair_status = repair_status  # type: str
        self.risk_assert_type = risk_assert_type  # type: str
        self.risk_item_resources = risk_item_resources  # type: list[DescribeRiskCheckResultResponseBodyListRiskItemResources]
        self.risk_level = risk_level  # type: str
        self.sort = sort  # type: int
        self.start_status = start_status  # type: str
        self.status = status  # type: str
        self.task_id = task_id  # type: long
        self.title = title  # type: str
        self.type = type  # type: str

    def validate(self):
        if self.risk_item_resources:
            for k in self.risk_item_resources:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeRiskCheckResultResponseBodyList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.affected_count is not None:
            result['AffectedCount'] = self.affected_count
        if self.check_time is not None:
            result['CheckTime'] = self.check_time
        if self.item_id is not None:
            result['ItemId'] = self.item_id
        if self.remaining_time is not None:
            result['RemainingTime'] = self.remaining_time
        if self.repair_status is not None:
            result['RepairStatus'] = self.repair_status
        if self.risk_assert_type is not None:
            result['RiskAssertType'] = self.risk_assert_type
        result['RiskItemResources'] = []
        if self.risk_item_resources is not None:
            for k in self.risk_item_resources:
                result['RiskItemResources'].append(k.to_map() if k else None)
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        if self.sort is not None:
            result['Sort'] = self.sort
        if self.start_status is not None:
            result['StartStatus'] = self.start_status
        if self.status is not None:
            result['Status'] = self.status
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.title is not None:
            result['Title'] = self.title
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AffectedCount') is not None:
            self.affected_count = m.get('AffectedCount')
        if m.get('CheckTime') is not None:
            self.check_time = m.get('CheckTime')
        if m.get('ItemId') is not None:
            self.item_id = m.get('ItemId')
        if m.get('RemainingTime') is not None:
            self.remaining_time = m.get('RemainingTime')
        if m.get('RepairStatus') is not None:
            self.repair_status = m.get('RepairStatus')
        if m.get('RiskAssertType') is not None:
            self.risk_assert_type = m.get('RiskAssertType')
        self.risk_item_resources = []
        if m.get('RiskItemResources') is not None:
            for k in m.get('RiskItemResources'):
                temp_model = DescribeRiskCheckResultResponseBodyListRiskItemResources()
                self.risk_item_resources.append(temp_model.from_map(k))
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        if m.get('Sort') is not None:
            self.sort = m.get('Sort')
        if m.get('StartStatus') is not None:
            self.start_status = m.get('StartStatus')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeRiskCheckResultResponseBody(TeaModel):
    def __init__(self, count=None, current_page=None, list=None, page_count=None, page_size=None, request_id=None,
                 total_count=None):
        self.count = count  # type: int
        self.current_page = current_page  # type: int
        self.list = list  # type: list[DescribeRiskCheckResultResponseBodyList]
        self.page_count = page_count  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: int

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeRiskCheckResultResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = DescribeRiskCheckResultResponseBodyList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeRiskCheckResultResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeRiskCheckResultResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeRiskCheckResultResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeRiskCheckResultResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRiskCheckSummaryRequest(TeaModel):
    def __init__(self, lang=None, resource_directory_account_id=None, resource_owner_id=None, source_ip=None):
        self.lang = lang  # type: str
        self.resource_directory_account_id = resource_directory_account_id  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.source_ip = source_ip  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeRiskCheckSummaryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.resource_directory_account_id is not None:
            result['ResourceDirectoryAccountId'] = self.resource_directory_account_id
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('ResourceDirectoryAccountId') is not None:
            self.resource_directory_account_id = m.get('ResourceDirectoryAccountId')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeRiskCheckSummaryResponseBodyRiskCheckSummaryGroupsCountByStatus(TeaModel):
    def __init__(self, count=None, status=None):
        self.count = count  # type: int
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeRiskCheckSummaryResponseBodyRiskCheckSummaryGroupsCountByStatus, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeRiskCheckSummaryResponseBodyRiskCheckSummaryGroups(TeaModel):
    def __init__(self, count_by_status=None, id=None, remaining_time=None, sort=None, status=None, title=None):
        self.count_by_status = count_by_status  # type: list[DescribeRiskCheckSummaryResponseBodyRiskCheckSummaryGroupsCountByStatus]
        self.id = id  # type: long
        self.remaining_time = remaining_time  # type: int
        self.sort = sort  # type: int
        self.status = status  # type: str
        self.title = title  # type: str

    def validate(self):
        if self.count_by_status:
            for k in self.count_by_status:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeRiskCheckSummaryResponseBodyRiskCheckSummaryGroups, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CountByStatus'] = []
        if self.count_by_status is not None:
            for k in self.count_by_status:
                result['CountByStatus'].append(k.to_map() if k else None)
        if self.id is not None:
            result['Id'] = self.id
        if self.remaining_time is not None:
            result['RemainingTime'] = self.remaining_time
        if self.sort is not None:
            result['Sort'] = self.sort
        if self.status is not None:
            result['Status'] = self.status
        if self.title is not None:
            result['Title'] = self.title
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.count_by_status = []
        if m.get('CountByStatus') is not None:
            for k in m.get('CountByStatus'):
                temp_model = DescribeRiskCheckSummaryResponseBodyRiskCheckSummaryGroupsCountByStatus()
                self.count_by_status.append(temp_model.from_map(k))
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RemainingTime') is not None:
            self.remaining_time = m.get('RemainingTime')
        if m.get('Sort') is not None:
            self.sort = m.get('Sort')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        return self


class DescribeRiskCheckSummaryResponseBodyRiskCheckSummaryRiskLevelCount(TeaModel):
    def __init__(self, count=None, key=None):
        self.count = count  # type: int
        self.key = key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeRiskCheckSummaryResponseBodyRiskCheckSummaryRiskLevelCount, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.key is not None:
            result['Key'] = self.key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        return self


class DescribeRiskCheckSummaryResponseBodyRiskCheckSummary(TeaModel):
    def __init__(self, affected_asset_count=None, disabled_risk_count=None, enabled_risk_count=None, groups=None,
                 item_count=None, previous_count=None, previous_time=None, risk_count=None, risk_level_count=None,
                 risk_rate=None):
        self.affected_asset_count = affected_asset_count  # type: int
        self.disabled_risk_count = disabled_risk_count  # type: int
        self.enabled_risk_count = enabled_risk_count  # type: int
        self.groups = groups  # type: list[DescribeRiskCheckSummaryResponseBodyRiskCheckSummaryGroups]
        self.item_count = item_count  # type: int
        self.previous_count = previous_count  # type: int
        self.previous_time = previous_time  # type: long
        self.risk_count = risk_count  # type: int
        self.risk_level_count = risk_level_count  # type: list[DescribeRiskCheckSummaryResponseBodyRiskCheckSummaryRiskLevelCount]
        self.risk_rate = risk_rate  # type: float

    def validate(self):
        if self.groups:
            for k in self.groups:
                if k:
                    k.validate()
        if self.risk_level_count:
            for k in self.risk_level_count:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeRiskCheckSummaryResponseBodyRiskCheckSummary, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.affected_asset_count is not None:
            result['AffectedAssetCount'] = self.affected_asset_count
        if self.disabled_risk_count is not None:
            result['DisabledRiskCount'] = self.disabled_risk_count
        if self.enabled_risk_count is not None:
            result['EnabledRiskCount'] = self.enabled_risk_count
        result['Groups'] = []
        if self.groups is not None:
            for k in self.groups:
                result['Groups'].append(k.to_map() if k else None)
        if self.item_count is not None:
            result['ItemCount'] = self.item_count
        if self.previous_count is not None:
            result['PreviousCount'] = self.previous_count
        if self.previous_time is not None:
            result['PreviousTime'] = self.previous_time
        if self.risk_count is not None:
            result['RiskCount'] = self.risk_count
        result['RiskLevelCount'] = []
        if self.risk_level_count is not None:
            for k in self.risk_level_count:
                result['RiskLevelCount'].append(k.to_map() if k else None)
        if self.risk_rate is not None:
            result['RiskRate'] = self.risk_rate
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AffectedAssetCount') is not None:
            self.affected_asset_count = m.get('AffectedAssetCount')
        if m.get('DisabledRiskCount') is not None:
            self.disabled_risk_count = m.get('DisabledRiskCount')
        if m.get('EnabledRiskCount') is not None:
            self.enabled_risk_count = m.get('EnabledRiskCount')
        self.groups = []
        if m.get('Groups') is not None:
            for k in m.get('Groups'):
                temp_model = DescribeRiskCheckSummaryResponseBodyRiskCheckSummaryGroups()
                self.groups.append(temp_model.from_map(k))
        if m.get('ItemCount') is not None:
            self.item_count = m.get('ItemCount')
        if m.get('PreviousCount') is not None:
            self.previous_count = m.get('PreviousCount')
        if m.get('PreviousTime') is not None:
            self.previous_time = m.get('PreviousTime')
        if m.get('RiskCount') is not None:
            self.risk_count = m.get('RiskCount')
        self.risk_level_count = []
        if m.get('RiskLevelCount') is not None:
            for k in m.get('RiskLevelCount'):
                temp_model = DescribeRiskCheckSummaryResponseBodyRiskCheckSummaryRiskLevelCount()
                self.risk_level_count.append(temp_model.from_map(k))
        if m.get('RiskRate') is not None:
            self.risk_rate = m.get('RiskRate')
        return self


class DescribeRiskCheckSummaryResponseBody(TeaModel):
    def __init__(self, request_id=None, risk_check_summary=None):
        self.request_id = request_id  # type: str
        self.risk_check_summary = risk_check_summary  # type: DescribeRiskCheckSummaryResponseBodyRiskCheckSummary

    def validate(self):
        if self.risk_check_summary:
            self.risk_check_summary.validate()

    def to_map(self):
        _map = super(DescribeRiskCheckSummaryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.risk_check_summary is not None:
            result['RiskCheckSummary'] = self.risk_check_summary.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RiskCheckSummary') is not None:
            temp_model = DescribeRiskCheckSummaryResponseBodyRiskCheckSummary()
            self.risk_check_summary = temp_model.from_map(m['RiskCheckSummary'])
        return self


class DescribeRiskCheckSummaryResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeRiskCheckSummaryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeRiskCheckSummaryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeRiskCheckSummaryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRiskItemTypeRequest(TeaModel):
    def __init__(self, lang=None, resource_owner_id=None, source_ip=None):
        self.lang = lang  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.source_ip = source_ip  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeRiskItemTypeRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeRiskItemTypeResponseBodyList(TeaModel):
    def __init__(self, id=None, title=None):
        self.id = id  # type: long
        self.title = title  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeRiskItemTypeResponseBodyList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.title is not None:
            result['Title'] = self.title
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        return self


class DescribeRiskItemTypeResponseBody(TeaModel):
    def __init__(self, list=None, request_id=None):
        self.list = list  # type: list[DescribeRiskItemTypeResponseBodyList]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeRiskItemTypeResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = DescribeRiskItemTypeResponseBodyList()
                self.list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeRiskItemTypeResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeRiskItemTypeResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeRiskItemTypeResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeRiskItemTypeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRiskListCheckResultRequest(TeaModel):
    def __init__(self, current_page=None, instance_ids=None, lang=None, page_size=None, resource_owner_id=None,
                 source_ip=None):
        self.current_page = current_page  # type: int
        self.instance_ids = instance_ids  # type: list[str]
        self.lang = lang  # type: str
        self.page_size = page_size  # type: int
        self.resource_owner_id = resource_owner_id  # type: long
        self.source_ip = source_ip  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeRiskListCheckResultRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('InstanceIds') is not None:
            self.instance_ids = m.get('InstanceIds')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeRiskListCheckResultResponseBodyList(TeaModel):
    def __init__(self, instance_id=None, risk_count=None):
        self.instance_id = instance_id  # type: str
        self.risk_count = risk_count  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeRiskListCheckResultResponseBodyList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.risk_count is not None:
            result['riskCount'] = self.risk_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('riskCount') is not None:
            self.risk_count = m.get('riskCount')
        return self


class DescribeRiskListCheckResultResponseBody(TeaModel):
    def __init__(self, list=None, request_id=None):
        self.list = list  # type: list[DescribeRiskListCheckResultResponseBodyList]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeRiskListCheckResultResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = DescribeRiskListCheckResultResponseBodyList()
                self.list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeRiskListCheckResultResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeRiskListCheckResultResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeRiskListCheckResultResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeRiskListCheckResultResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeScanTaskProgressRequest(TeaModel):
    def __init__(self, task_id=None):
        self.task_id = task_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeScanTaskProgressRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class DescribeScanTaskProgressResponseBody(TeaModel):
    def __init__(self, request_id=None, scan_task_progress=None, target_info=None):
        self.request_id = request_id  # type: str
        self.scan_task_progress = scan_task_progress  # type: str
        self.target_info = target_info  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeScanTaskProgressResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.scan_task_progress is not None:
            result['ScanTaskProgress'] = self.scan_task_progress
        if self.target_info is not None:
            result['TargetInfo'] = self.target_info
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ScanTaskProgress') is not None:
            self.scan_task_progress = m.get('ScanTaskProgress')
        if m.get('TargetInfo') is not None:
            self.target_info = m.get('TargetInfo')
        return self


class DescribeScanTaskProgressResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeScanTaskProgressResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeScanTaskProgressResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeScanTaskProgressResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSearchConditionRequest(TeaModel):
    def __init__(self, lang=None, source_ip=None, type=None):
        self.lang = lang  # type: str
        self.source_ip = source_ip  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSearchConditionRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeSearchConditionResponseBodyConditionList(TeaModel):
    def __init__(self, condition_type=None, filter_conditions=None, name=None, name_key=None):
        self.condition_type = condition_type  # type: str
        self.filter_conditions = filter_conditions  # type: str
        self.name = name  # type: str
        self.name_key = name_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSearchConditionResponseBodyConditionList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.condition_type is not None:
            result['ConditionType'] = self.condition_type
        if self.filter_conditions is not None:
            result['FilterConditions'] = self.filter_conditions
        if self.name is not None:
            result['Name'] = self.name
        if self.name_key is not None:
            result['NameKey'] = self.name_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConditionType') is not None:
            self.condition_type = m.get('ConditionType')
        if m.get('FilterConditions') is not None:
            self.filter_conditions = m.get('FilterConditions')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NameKey') is not None:
            self.name_key = m.get('NameKey')
        return self


class DescribeSearchConditionResponseBody(TeaModel):
    def __init__(self, condition_list=None, request_id=None):
        self.condition_list = condition_list  # type: list[DescribeSearchConditionResponseBodyConditionList]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.condition_list:
            for k in self.condition_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeSearchConditionResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ConditionList'] = []
        if self.condition_list is not None:
            for k in self.condition_list:
                result['ConditionList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.condition_list = []
        if m.get('ConditionList') is not None:
            for k in m.get('ConditionList'):
                temp_model = DescribeSearchConditionResponseBodyConditionList()
                self.condition_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeSearchConditionResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeSearchConditionResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeSearchConditionResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSearchConditionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSecureSuggestionRequest(TeaModel):
    def __init__(self, lang=None, source_ip=None):
        self.lang = lang  # type: str
        self.source_ip = source_ip  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSecureSuggestionRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeSecureSuggestionResponseBodySuggestionsDetail(TeaModel):
    def __init__(self, description=None, sub_type=None, title=None):
        self.description = description  # type: str
        self.sub_type = sub_type  # type: str
        self.title = title  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSecureSuggestionResponseBodySuggestionsDetail, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.sub_type is not None:
            result['SubType'] = self.sub_type
        if self.title is not None:
            result['Title'] = self.title
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('SubType') is not None:
            self.sub_type = m.get('SubType')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        return self


class DescribeSecureSuggestionResponseBodySuggestions(TeaModel):
    def __init__(self, detail=None, points=None, suggest_type=None):
        self.detail = detail  # type: list[DescribeSecureSuggestionResponseBodySuggestionsDetail]
        self.points = points  # type: int
        self.suggest_type = suggest_type  # type: str

    def validate(self):
        if self.detail:
            for k in self.detail:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeSecureSuggestionResponseBodySuggestions, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Detail'] = []
        if self.detail is not None:
            for k in self.detail:
                result['Detail'].append(k.to_map() if k else None)
        if self.points is not None:
            result['Points'] = self.points
        if self.suggest_type is not None:
            result['SuggestType'] = self.suggest_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.detail = []
        if m.get('Detail') is not None:
            for k in m.get('Detail'):
                temp_model = DescribeSecureSuggestionResponseBodySuggestionsDetail()
                self.detail.append(temp_model.from_map(k))
        if m.get('Points') is not None:
            self.points = m.get('Points')
        if m.get('SuggestType') is not None:
            self.suggest_type = m.get('SuggestType')
        return self


class DescribeSecureSuggestionResponseBody(TeaModel):
    def __init__(self, request_id=None, suggestions=None, total_count=None):
        self.request_id = request_id  # type: str
        self.suggestions = suggestions  # type: list[DescribeSecureSuggestionResponseBodySuggestions]
        self.total_count = total_count  # type: int

    def validate(self):
        if self.suggestions:
            for k in self.suggestions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeSecureSuggestionResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Suggestions'] = []
        if self.suggestions is not None:
            for k in self.suggestions:
                result['Suggestions'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.suggestions = []
        if m.get('Suggestions') is not None:
            for k in m.get('Suggestions'):
                temp_model = DescribeSecureSuggestionResponseBodySuggestions()
                self.suggestions.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeSecureSuggestionResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeSecureSuggestionResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeSecureSuggestionResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSecureSuggestionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSecurityCheckScheduleConfigRequest(TeaModel):
    def __init__(self, lang=None, resource_owner_id=None, source_ip=None):
        self.lang = lang  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.source_ip = source_ip  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSecurityCheckScheduleConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeSecurityCheckScheduleConfigResponseBodyRiskCheckJobConfig(TeaModel):
    def __init__(self, days_of_week=None, end_time=None, start_time=None):
        self.days_of_week = days_of_week  # type: str
        self.end_time = end_time  # type: int
        self.start_time = start_time  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSecurityCheckScheduleConfigResponseBodyRiskCheckJobConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.days_of_week is not None:
            result['DaysOfWeek'] = self.days_of_week
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DaysOfWeek') is not None:
            self.days_of_week = m.get('DaysOfWeek')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeSecurityCheckScheduleConfigResponseBody(TeaModel):
    def __init__(self, request_id=None, risk_check_job_config=None):
        self.request_id = request_id  # type: str
        self.risk_check_job_config = risk_check_job_config  # type: DescribeSecurityCheckScheduleConfigResponseBodyRiskCheckJobConfig

    def validate(self):
        if self.risk_check_job_config:
            self.risk_check_job_config.validate()

    def to_map(self):
        _map = super(DescribeSecurityCheckScheduleConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.risk_check_job_config is not None:
            result['RiskCheckJobConfig'] = self.risk_check_job_config.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RiskCheckJobConfig') is not None:
            temp_model = DescribeSecurityCheckScheduleConfigResponseBodyRiskCheckJobConfig()
            self.risk_check_job_config = temp_model.from_map(m['RiskCheckJobConfig'])
        return self


class DescribeSecurityCheckScheduleConfigResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeSecurityCheckScheduleConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeSecurityCheckScheduleConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSecurityCheckScheduleConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSecurityEventOperationStatusRequest(TeaModel):
    def __init__(self, resource_owner_id=None, security_event_ids=None, source_ip=None, task_id=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.security_event_ids = security_event_ids  # type: list[str]
        self.source_ip = source_ip  # type: str
        self.task_id = task_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSecurityEventOperationStatusRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.security_event_ids is not None:
            result['SecurityEventIds'] = self.security_event_ids
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SecurityEventIds') is not None:
            self.security_event_ids = m.get('SecurityEventIds')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class DescribeSecurityEventOperationStatusResponseBodySecurityEventOperationStatusResponseSecurityEventOperationStatuses(TeaModel):
    def __init__(self, error_code=None, security_event_id=None, status=None):
        self.error_code = error_code  # type: str
        self.security_event_id = security_event_id  # type: str
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSecurityEventOperationStatusResponseBodySecurityEventOperationStatusResponseSecurityEventOperationStatuses, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.security_event_id is not None:
            result['SecurityEventId'] = self.security_event_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('SecurityEventId') is not None:
            self.security_event_id = m.get('SecurityEventId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeSecurityEventOperationStatusResponseBodySecurityEventOperationStatusResponse(TeaModel):
    def __init__(self, security_event_operation_statuses=None, task_status=None):
        self.security_event_operation_statuses = security_event_operation_statuses  # type: list[DescribeSecurityEventOperationStatusResponseBodySecurityEventOperationStatusResponseSecurityEventOperationStatuses]
        self.task_status = task_status  # type: str

    def validate(self):
        if self.security_event_operation_statuses:
            for k in self.security_event_operation_statuses:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeSecurityEventOperationStatusResponseBodySecurityEventOperationStatusResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SecurityEventOperationStatuses'] = []
        if self.security_event_operation_statuses is not None:
            for k in self.security_event_operation_statuses:
                result['SecurityEventOperationStatuses'].append(k.to_map() if k else None)
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.security_event_operation_statuses = []
        if m.get('SecurityEventOperationStatuses') is not None:
            for k in m.get('SecurityEventOperationStatuses'):
                temp_model = DescribeSecurityEventOperationStatusResponseBodySecurityEventOperationStatusResponseSecurityEventOperationStatuses()
                self.security_event_operation_statuses.append(temp_model.from_map(k))
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        return self


class DescribeSecurityEventOperationStatusResponseBody(TeaModel):
    def __init__(self, request_id=None, security_event_operation_status_response=None):
        self.request_id = request_id  # type: str
        self.security_event_operation_status_response = security_event_operation_status_response  # type: DescribeSecurityEventOperationStatusResponseBodySecurityEventOperationStatusResponse

    def validate(self):
        if self.security_event_operation_status_response:
            self.security_event_operation_status_response.validate()

    def to_map(self):
        _map = super(DescribeSecurityEventOperationStatusResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.security_event_operation_status_response is not None:
            result['SecurityEventOperationStatusResponse'] = self.security_event_operation_status_response.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SecurityEventOperationStatusResponse') is not None:
            temp_model = DescribeSecurityEventOperationStatusResponseBodySecurityEventOperationStatusResponse()
            self.security_event_operation_status_response = temp_model.from_map(m['SecurityEventOperationStatusResponse'])
        return self


class DescribeSecurityEventOperationStatusResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeSecurityEventOperationStatusResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeSecurityEventOperationStatusResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSecurityEventOperationStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSecurityEventOperationsRequest(TeaModel):
    def __init__(self, lang=None, resource_owner_id=None, security_event_id=None, source_ip=None):
        self.lang = lang  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.security_event_id = security_event_id  # type: long
        self.source_ip = source_ip  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSecurityEventOperationsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.security_event_id is not None:
            result['SecurityEventId'] = self.security_event_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SecurityEventId') is not None:
            self.security_event_id = m.get('SecurityEventId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeSecurityEventOperationsResponseBodySecurityEventOperationsResponseMarkField(TeaModel):
    def __init__(self, filed_alias_name=None, filed_name=None, mark_mis_type=None, mark_mis_value=None,
                 supported_mis_type=None):
        self.filed_alias_name = filed_alias_name  # type: str
        self.filed_name = filed_name  # type: str
        self.mark_mis_type = mark_mis_type  # type: str
        self.mark_mis_value = mark_mis_value  # type: str
        self.supported_mis_type = supported_mis_type  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSecurityEventOperationsResponseBodySecurityEventOperationsResponseMarkField, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.filed_alias_name is not None:
            result['FiledAliasName'] = self.filed_alias_name
        if self.filed_name is not None:
            result['FiledName'] = self.filed_name
        if self.mark_mis_type is not None:
            result['MarkMisType'] = self.mark_mis_type
        if self.mark_mis_value is not None:
            result['MarkMisValue'] = self.mark_mis_value
        if self.supported_mis_type is not None:
            result['SupportedMisType'] = self.supported_mis_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FiledAliasName') is not None:
            self.filed_alias_name = m.get('FiledAliasName')
        if m.get('FiledName') is not None:
            self.filed_name = m.get('FiledName')
        if m.get('MarkMisType') is not None:
            self.mark_mis_type = m.get('MarkMisType')
        if m.get('MarkMisValue') is not None:
            self.mark_mis_value = m.get('MarkMisValue')
        if m.get('SupportedMisType') is not None:
            self.supported_mis_type = m.get('SupportedMisType')
        return self


class DescribeSecurityEventOperationsResponseBodySecurityEventOperationsResponseMarkFieldsSource(TeaModel):
    def __init__(self, filed_alias_name=None, filed_name=None, mark_mis_value=None, supported_mis_type=None):
        self.filed_alias_name = filed_alias_name  # type: str
        self.filed_name = filed_name  # type: str
        self.mark_mis_value = mark_mis_value  # type: str
        self.supported_mis_type = supported_mis_type  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSecurityEventOperationsResponseBodySecurityEventOperationsResponseMarkFieldsSource, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.filed_alias_name is not None:
            result['FiledAliasName'] = self.filed_alias_name
        if self.filed_name is not None:
            result['FiledName'] = self.filed_name
        if self.mark_mis_value is not None:
            result['MarkMisValue'] = self.mark_mis_value
        if self.supported_mis_type is not None:
            result['SupportedMisType'] = self.supported_mis_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FiledAliasName') is not None:
            self.filed_alias_name = m.get('FiledAliasName')
        if m.get('FiledName') is not None:
            self.filed_name = m.get('FiledName')
        if m.get('MarkMisValue') is not None:
            self.mark_mis_value = m.get('MarkMisValue')
        if m.get('SupportedMisType') is not None:
            self.supported_mis_type = m.get('SupportedMisType')
        return self


class DescribeSecurityEventOperationsResponseBodySecurityEventOperationsResponse(TeaModel):
    def __init__(self, mark_field=None, mark_fields_source=None, operation_code=None, operation_params=None,
                 user_can_operate=None):
        self.mark_field = mark_field  # type: list[DescribeSecurityEventOperationsResponseBodySecurityEventOperationsResponseMarkField]
        self.mark_fields_source = mark_fields_source  # type: list[DescribeSecurityEventOperationsResponseBodySecurityEventOperationsResponseMarkFieldsSource]
        self.operation_code = operation_code  # type: str
        self.operation_params = operation_params  # type: str
        self.user_can_operate = user_can_operate  # type: bool

    def validate(self):
        if self.mark_field:
            for k in self.mark_field:
                if k:
                    k.validate()
        if self.mark_fields_source:
            for k in self.mark_fields_source:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeSecurityEventOperationsResponseBodySecurityEventOperationsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['MarkField'] = []
        if self.mark_field is not None:
            for k in self.mark_field:
                result['MarkField'].append(k.to_map() if k else None)
        result['MarkFieldsSource'] = []
        if self.mark_fields_source is not None:
            for k in self.mark_fields_source:
                result['MarkFieldsSource'].append(k.to_map() if k else None)
        if self.operation_code is not None:
            result['OperationCode'] = self.operation_code
        if self.operation_params is not None:
            result['OperationParams'] = self.operation_params
        if self.user_can_operate is not None:
            result['UserCanOperate'] = self.user_can_operate
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.mark_field = []
        if m.get('MarkField') is not None:
            for k in m.get('MarkField'):
                temp_model = DescribeSecurityEventOperationsResponseBodySecurityEventOperationsResponseMarkField()
                self.mark_field.append(temp_model.from_map(k))
        self.mark_fields_source = []
        if m.get('MarkFieldsSource') is not None:
            for k in m.get('MarkFieldsSource'):
                temp_model = DescribeSecurityEventOperationsResponseBodySecurityEventOperationsResponseMarkFieldsSource()
                self.mark_fields_source.append(temp_model.from_map(k))
        if m.get('OperationCode') is not None:
            self.operation_code = m.get('OperationCode')
        if m.get('OperationParams') is not None:
            self.operation_params = m.get('OperationParams')
        if m.get('UserCanOperate') is not None:
            self.user_can_operate = m.get('UserCanOperate')
        return self


class DescribeSecurityEventOperationsResponseBody(TeaModel):
    def __init__(self, request_id=None, security_event_operations_response=None):
        self.request_id = request_id  # type: str
        self.security_event_operations_response = security_event_operations_response  # type: list[DescribeSecurityEventOperationsResponseBodySecurityEventOperationsResponse]

    def validate(self):
        if self.security_event_operations_response:
            for k in self.security_event_operations_response:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeSecurityEventOperationsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['SecurityEventOperationsResponse'] = []
        if self.security_event_operations_response is not None:
            for k in self.security_event_operations_response:
                result['SecurityEventOperationsResponse'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.security_event_operations_response = []
        if m.get('SecurityEventOperationsResponse') is not None:
            for k in m.get('SecurityEventOperationsResponse'):
                temp_model = DescribeSecurityEventOperationsResponseBodySecurityEventOperationsResponse()
                self.security_event_operations_response.append(temp_model.from_map(k))
        return self


class DescribeSecurityEventOperationsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeSecurityEventOperationsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeSecurityEventOperationsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSecurityEventOperationsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSecurityStatInfoRequest(TeaModel):
    def __init__(self, lang=None, resource_directory_account_id=None, source_ip=None):
        self.lang = lang  # type: str
        self.resource_directory_account_id = resource_directory_account_id  # type: str
        self.source_ip = source_ip  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSecurityStatInfoRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.resource_directory_account_id is not None:
            result['ResourceDirectoryAccountId'] = self.resource_directory_account_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('ResourceDirectoryAccountId') is not None:
            self.resource_directory_account_id = m.get('ResourceDirectoryAccountId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeSecurityStatInfoResponseBodyAttackEvent(TeaModel):
    def __init__(self, date_array=None, total_count=None, value_array=None):
        self.date_array = date_array  # type: list[str]
        self.total_count = total_count  # type: int
        self.value_array = value_array  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSecurityStatInfoResponseBodyAttackEvent, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.date_array is not None:
            result['DateArray'] = self.date_array
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.value_array is not None:
            result['ValueArray'] = self.value_array
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DateArray') is not None:
            self.date_array = m.get('DateArray')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('ValueArray') is not None:
            self.value_array = m.get('ValueArray')
        return self


class DescribeSecurityStatInfoResponseBodyHealthCheck(TeaModel):
    def __init__(self, date_array=None, high_count=None, high_list=None, levels_on=None, low_count=None,
                 low_list=None, medium_count=None, medium_list=None, time_array=None, total_count=None, value_array=None):
        self.date_array = date_array  # type: list[str]
        self.high_count = high_count  # type: int
        self.high_list = high_list  # type: list[str]
        self.levels_on = levels_on  # type: list[str]
        self.low_count = low_count  # type: int
        self.low_list = low_list  # type: list[str]
        self.medium_count = medium_count  # type: int
        self.medium_list = medium_list  # type: list[str]
        self.time_array = time_array  # type: list[str]
        self.total_count = total_count  # type: int
        self.value_array = value_array  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSecurityStatInfoResponseBodyHealthCheck, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.date_array is not None:
            result['DateArray'] = self.date_array
        if self.high_count is not None:
            result['HighCount'] = self.high_count
        if self.high_list is not None:
            result['HighList'] = self.high_list
        if self.levels_on is not None:
            result['LevelsOn'] = self.levels_on
        if self.low_count is not None:
            result['LowCount'] = self.low_count
        if self.low_list is not None:
            result['LowList'] = self.low_list
        if self.medium_count is not None:
            result['MediumCount'] = self.medium_count
        if self.medium_list is not None:
            result['MediumList'] = self.medium_list
        if self.time_array is not None:
            result['TimeArray'] = self.time_array
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.value_array is not None:
            result['ValueArray'] = self.value_array
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DateArray') is not None:
            self.date_array = m.get('DateArray')
        if m.get('HighCount') is not None:
            self.high_count = m.get('HighCount')
        if m.get('HighList') is not None:
            self.high_list = m.get('HighList')
        if m.get('LevelsOn') is not None:
            self.levels_on = m.get('LevelsOn')
        if m.get('LowCount') is not None:
            self.low_count = m.get('LowCount')
        if m.get('LowList') is not None:
            self.low_list = m.get('LowList')
        if m.get('MediumCount') is not None:
            self.medium_count = m.get('MediumCount')
        if m.get('MediumList') is not None:
            self.medium_list = m.get('MediumList')
        if m.get('TimeArray') is not None:
            self.time_array = m.get('TimeArray')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('ValueArray') is not None:
            self.value_array = m.get('ValueArray')
        return self


class DescribeSecurityStatInfoResponseBodySecurityEvent(TeaModel):
    def __init__(self, date_array=None, levels_on=None, remind_count=None, remind_list=None, serious_count=None,
                 serious_list=None, suspicious_count=None, suspicious_list=None, time_array=None, total_count=None,
                 value_array=None):
        self.date_array = date_array  # type: list[str]
        self.levels_on = levels_on  # type: list[str]
        self.remind_count = remind_count  # type: int
        self.remind_list = remind_list  # type: list[str]
        self.serious_count = serious_count  # type: int
        self.serious_list = serious_list  # type: list[str]
        self.suspicious_count = suspicious_count  # type: int
        self.suspicious_list = suspicious_list  # type: list[str]
        self.time_array = time_array  # type: list[str]
        self.total_count = total_count  # type: int
        self.value_array = value_array  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSecurityStatInfoResponseBodySecurityEvent, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.date_array is not None:
            result['DateArray'] = self.date_array
        if self.levels_on is not None:
            result['LevelsOn'] = self.levels_on
        if self.remind_count is not None:
            result['RemindCount'] = self.remind_count
        if self.remind_list is not None:
            result['RemindList'] = self.remind_list
        if self.serious_count is not None:
            result['SeriousCount'] = self.serious_count
        if self.serious_list is not None:
            result['SeriousList'] = self.serious_list
        if self.suspicious_count is not None:
            result['SuspiciousCount'] = self.suspicious_count
        if self.suspicious_list is not None:
            result['SuspiciousList'] = self.suspicious_list
        if self.time_array is not None:
            result['TimeArray'] = self.time_array
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.value_array is not None:
            result['ValueArray'] = self.value_array
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DateArray') is not None:
            self.date_array = m.get('DateArray')
        if m.get('LevelsOn') is not None:
            self.levels_on = m.get('LevelsOn')
        if m.get('RemindCount') is not None:
            self.remind_count = m.get('RemindCount')
        if m.get('RemindList') is not None:
            self.remind_list = m.get('RemindList')
        if m.get('SeriousCount') is not None:
            self.serious_count = m.get('SeriousCount')
        if m.get('SeriousList') is not None:
            self.serious_list = m.get('SeriousList')
        if m.get('SuspiciousCount') is not None:
            self.suspicious_count = m.get('SuspiciousCount')
        if m.get('SuspiciousList') is not None:
            self.suspicious_list = m.get('SuspiciousList')
        if m.get('TimeArray') is not None:
            self.time_array = m.get('TimeArray')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('ValueArray') is not None:
            self.value_array = m.get('ValueArray')
        return self


class DescribeSecurityStatInfoResponseBodyVulnerability(TeaModel):
    def __init__(self, asap_count=None, asap_list=None, date_array=None, later_count=None, later_list=None,
                 levels_on=None, nntf_count=None, nntf_list=None, time_array=None, total_count=None, value_array=None):
        self.asap_count = asap_count  # type: int
        self.asap_list = asap_list  # type: list[str]
        self.date_array = date_array  # type: list[str]
        self.later_count = later_count  # type: int
        self.later_list = later_list  # type: list[str]
        self.levels_on = levels_on  # type: list[str]
        self.nntf_count = nntf_count  # type: int
        self.nntf_list = nntf_list  # type: list[str]
        self.time_array = time_array  # type: list[str]
        self.total_count = total_count  # type: int
        self.value_array = value_array  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSecurityStatInfoResponseBodyVulnerability, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.asap_count is not None:
            result['AsapCount'] = self.asap_count
        if self.asap_list is not None:
            result['AsapList'] = self.asap_list
        if self.date_array is not None:
            result['DateArray'] = self.date_array
        if self.later_count is not None:
            result['LaterCount'] = self.later_count
        if self.later_list is not None:
            result['LaterList'] = self.later_list
        if self.levels_on is not None:
            result['LevelsOn'] = self.levels_on
        if self.nntf_count is not None:
            result['NntfCount'] = self.nntf_count
        if self.nntf_list is not None:
            result['NntfList'] = self.nntf_list
        if self.time_array is not None:
            result['TimeArray'] = self.time_array
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.value_array is not None:
            result['ValueArray'] = self.value_array
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AsapCount') is not None:
            self.asap_count = m.get('AsapCount')
        if m.get('AsapList') is not None:
            self.asap_list = m.get('AsapList')
        if m.get('DateArray') is not None:
            self.date_array = m.get('DateArray')
        if m.get('LaterCount') is not None:
            self.later_count = m.get('LaterCount')
        if m.get('LaterList') is not None:
            self.later_list = m.get('LaterList')
        if m.get('LevelsOn') is not None:
            self.levels_on = m.get('LevelsOn')
        if m.get('NntfCount') is not None:
            self.nntf_count = m.get('NntfCount')
        if m.get('NntfList') is not None:
            self.nntf_list = m.get('NntfList')
        if m.get('TimeArray') is not None:
            self.time_array = m.get('TimeArray')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('ValueArray') is not None:
            self.value_array = m.get('ValueArray')
        return self


class DescribeSecurityStatInfoResponseBody(TeaModel):
    def __init__(self, attack_event=None, health_check=None, request_id=None, security_event=None, success=None,
                 vulnerability=None):
        self.attack_event = attack_event  # type: DescribeSecurityStatInfoResponseBodyAttackEvent
        self.health_check = health_check  # type: DescribeSecurityStatInfoResponseBodyHealthCheck
        self.request_id = request_id  # type: str
        self.security_event = security_event  # type: DescribeSecurityStatInfoResponseBodySecurityEvent
        self.success = success  # type: bool
        self.vulnerability = vulnerability  # type: DescribeSecurityStatInfoResponseBodyVulnerability

    def validate(self):
        if self.attack_event:
            self.attack_event.validate()
        if self.health_check:
            self.health_check.validate()
        if self.security_event:
            self.security_event.validate()
        if self.vulnerability:
            self.vulnerability.validate()

    def to_map(self):
        _map = super(DescribeSecurityStatInfoResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attack_event is not None:
            result['AttackEvent'] = self.attack_event.to_map()
        if self.health_check is not None:
            result['HealthCheck'] = self.health_check.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.security_event is not None:
            result['SecurityEvent'] = self.security_event.to_map()
        if self.success is not None:
            result['Success'] = self.success
        if self.vulnerability is not None:
            result['Vulnerability'] = self.vulnerability.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AttackEvent') is not None:
            temp_model = DescribeSecurityStatInfoResponseBodyAttackEvent()
            self.attack_event = temp_model.from_map(m['AttackEvent'])
        if m.get('HealthCheck') is not None:
            temp_model = DescribeSecurityStatInfoResponseBodyHealthCheck()
            self.health_check = temp_model.from_map(m['HealthCheck'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SecurityEvent') is not None:
            temp_model = DescribeSecurityStatInfoResponseBodySecurityEvent()
            self.security_event = temp_model.from_map(m['SecurityEvent'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Vulnerability') is not None:
            temp_model = DescribeSecurityStatInfoResponseBodyVulnerability()
            self.vulnerability = temp_model.from_map(m['Vulnerability'])
        return self


class DescribeSecurityStatInfoResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeSecurityStatInfoResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeSecurityStatInfoResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSecurityStatInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeServiceLinkedRoleStatusResponseBodyRoleStatus(TeaModel):
    def __init__(self, status=None):
        self.status = status  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeServiceLinkedRoleStatusResponseBodyRoleStatus, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeServiceLinkedRoleStatusResponseBody(TeaModel):
    def __init__(self, request_id=None, role_status=None):
        self.request_id = request_id  # type: str
        self.role_status = role_status  # type: DescribeServiceLinkedRoleStatusResponseBodyRoleStatus

    def validate(self):
        if self.role_status:
            self.role_status.validate()

    def to_map(self):
        _map = super(DescribeServiceLinkedRoleStatusResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.role_status is not None:
            result['RoleStatus'] = self.role_status.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RoleStatus') is not None:
            temp_model = DescribeServiceLinkedRoleStatusResponseBodyRoleStatus()
            self.role_status = temp_model.from_map(m['RoleStatus'])
        return self


class DescribeServiceLinkedRoleStatusResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeServiceLinkedRoleStatusResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeServiceLinkedRoleStatusResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeServiceLinkedRoleStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSimilarEventScenariosRequest(TeaModel):
    def __init__(self, resource_owner_id=None, security_event_id=None, source_ip=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.security_event_id = security_event_id  # type: long
        self.source_ip = source_ip  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSimilarEventScenariosRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.security_event_id is not None:
            result['SecurityEventId'] = self.security_event_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SecurityEventId') is not None:
            self.security_event_id = m.get('SecurityEventId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeSimilarEventScenariosResponseBodyScenarios(TeaModel):
    def __init__(self, code=None):
        self.code = code  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSimilarEventScenariosResponseBodyScenarios, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        return self


class DescribeSimilarEventScenariosResponseBody(TeaModel):
    def __init__(self, request_id=None, scenarios=None):
        self.request_id = request_id  # type: str
        self.scenarios = scenarios  # type: list[DescribeSimilarEventScenariosResponseBodyScenarios]

    def validate(self):
        if self.scenarios:
            for k in self.scenarios:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeSimilarEventScenariosResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Scenarios'] = []
        if self.scenarios is not None:
            for k in self.scenarios:
                result['Scenarios'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.scenarios = []
        if m.get('Scenarios') is not None:
            for k in m.get('Scenarios'):
                temp_model = DescribeSimilarEventScenariosResponseBodyScenarios()
                self.scenarios.append(temp_model.from_map(k))
        return self


class DescribeSimilarEventScenariosResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeSimilarEventScenariosResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeSimilarEventScenariosResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSimilarEventScenariosResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSimilarSecurityEventsRequest(TeaModel):
    def __init__(self, current_page=None, lang=None, page_size=None, resource_owner_id=None, source_ip=None,
                 task_id=None):
        self.current_page = current_page  # type: int
        self.lang = lang  # type: str
        self.page_size = page_size  # type: int
        self.resource_owner_id = resource_owner_id  # type: long
        self.source_ip = source_ip  # type: str
        self.task_id = task_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSimilarSecurityEventsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class DescribeSimilarSecurityEventsResponseBodyPageInfo(TeaModel):
    def __init__(self, count=None, current_page=None, page_size=None, total_count=None):
        self.count = count  # type: int
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSimilarSecurityEventsResponseBodyPageInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeSimilarSecurityEventsResponseBodySecurityEventsResponse(TeaModel):
    def __init__(self, event_name=None, event_type=None, last_time=None, occurrence_time=None,
                 security_event_id=None, uuid=None):
        self.event_name = event_name  # type: str
        self.event_type = event_type  # type: str
        self.last_time = last_time  # type: long
        self.occurrence_time = occurrence_time  # type: long
        self.security_event_id = security_event_id  # type: long
        self.uuid = uuid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSimilarSecurityEventsResponseBodySecurityEventsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event_name is not None:
            result['EventName'] = self.event_name
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.last_time is not None:
            result['LastTime'] = self.last_time
        if self.occurrence_time is not None:
            result['OccurrenceTime'] = self.occurrence_time
        if self.security_event_id is not None:
            result['SecurityEventId'] = self.security_event_id
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EventName') is not None:
            self.event_name = m.get('EventName')
        if m.get('EventType') is not None:
            self.event_type = m.get('EventType')
        if m.get('LastTime') is not None:
            self.last_time = m.get('LastTime')
        if m.get('OccurrenceTime') is not None:
            self.occurrence_time = m.get('OccurrenceTime')
        if m.get('SecurityEventId') is not None:
            self.security_event_id = m.get('SecurityEventId')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeSimilarSecurityEventsResponseBody(TeaModel):
    def __init__(self, page_info=None, request_id=None, security_events_response=None):
        self.page_info = page_info  # type: DescribeSimilarSecurityEventsResponseBodyPageInfo
        self.request_id = request_id  # type: str
        self.security_events_response = security_events_response  # type: list[DescribeSimilarSecurityEventsResponseBodySecurityEventsResponse]

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.security_events_response:
            for k in self.security_events_response:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeSimilarSecurityEventsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['SecurityEventsResponse'] = []
        if self.security_events_response is not None:
            for k in self.security_events_response:
                result['SecurityEventsResponse'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageInfo') is not None:
            temp_model = DescribeSimilarSecurityEventsResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.security_events_response = []
        if m.get('SecurityEventsResponse') is not None:
            for k in m.get('SecurityEventsResponse'):
                temp_model = DescribeSimilarSecurityEventsResponseBodySecurityEventsResponse()
                self.security_events_response.append(temp_model.from_map(k))
        return self


class DescribeSimilarSecurityEventsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeSimilarSecurityEventsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeSimilarSecurityEventsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSimilarSecurityEventsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeStrategyRequest(TeaModel):
    def __init__(self, custom_type=None, lang=None, source_ip=None, strategy_ids=None):
        self.custom_type = custom_type  # type: str
        self.lang = lang  # type: str
        self.source_ip = source_ip  # type: str
        self.strategy_ids = strategy_ids  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeStrategyRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.custom_type is not None:
            result['CustomType'] = self.custom_type
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.strategy_ids is not None:
            result['StrategyIds'] = self.strategy_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CustomType') is not None:
            self.custom_type = m.get('CustomType')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('StrategyIds') is not None:
            self.strategy_ids = m.get('StrategyIds')
        return self


class DescribeStrategyResponseBodyStrategiesConfigTargets(TeaModel):
    def __init__(self, flag=None, target=None, target_type=None):
        self.flag = flag  # type: str
        self.target = target  # type: str
        self.target_type = target_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeStrategyResponseBodyStrategiesConfigTargets, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.flag is not None:
            result['Flag'] = self.flag
        if self.target is not None:
            result['Target'] = self.target
        if self.target_type is not None:
            result['TargetType'] = self.target_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Flag') is not None:
            self.flag = m.get('Flag')
        if m.get('Target') is not None:
            self.target = m.get('Target')
        if m.get('TargetType') is not None:
            self.target_type = m.get('TargetType')
        return self


class DescribeStrategyResponseBodyStrategies(TeaModel):
    def __init__(self, config_targets=None, custom_type=None, cycle_days=None, cycle_start_time=None,
                 ecs_count=None, exec_status=None, id=None, name=None, pass_rate=None, process_rate=None, risk_count=None,
                 type=None):
        self.config_targets = config_targets  # type: list[DescribeStrategyResponseBodyStrategiesConfigTargets]
        self.custom_type = custom_type  # type: str
        self.cycle_days = cycle_days  # type: int
        self.cycle_start_time = cycle_start_time  # type: int
        self.ecs_count = ecs_count  # type: int
        self.exec_status = exec_status  # type: int
        self.id = id  # type: int
        self.name = name  # type: str
        self.pass_rate = pass_rate  # type: int
        self.process_rate = process_rate  # type: int
        self.risk_count = risk_count  # type: int
        self.type = type  # type: int

    def validate(self):
        if self.config_targets:
            for k in self.config_targets:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeStrategyResponseBodyStrategies, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ConfigTargets'] = []
        if self.config_targets is not None:
            for k in self.config_targets:
                result['ConfigTargets'].append(k.to_map() if k else None)
        if self.custom_type is not None:
            result['CustomType'] = self.custom_type
        if self.cycle_days is not None:
            result['CycleDays'] = self.cycle_days
        if self.cycle_start_time is not None:
            result['CycleStartTime'] = self.cycle_start_time
        if self.ecs_count is not None:
            result['EcsCount'] = self.ecs_count
        if self.exec_status is not None:
            result['ExecStatus'] = self.exec_status
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.pass_rate is not None:
            result['PassRate'] = self.pass_rate
        if self.process_rate is not None:
            result['ProcessRate'] = self.process_rate
        if self.risk_count is not None:
            result['RiskCount'] = self.risk_count
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.config_targets = []
        if m.get('ConfigTargets') is not None:
            for k in m.get('ConfigTargets'):
                temp_model = DescribeStrategyResponseBodyStrategiesConfigTargets()
                self.config_targets.append(temp_model.from_map(k))
        if m.get('CustomType') is not None:
            self.custom_type = m.get('CustomType')
        if m.get('CycleDays') is not None:
            self.cycle_days = m.get('CycleDays')
        if m.get('CycleStartTime') is not None:
            self.cycle_start_time = m.get('CycleStartTime')
        if m.get('EcsCount') is not None:
            self.ecs_count = m.get('EcsCount')
        if m.get('ExecStatus') is not None:
            self.exec_status = m.get('ExecStatus')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PassRate') is not None:
            self.pass_rate = m.get('PassRate')
        if m.get('ProcessRate') is not None:
            self.process_rate = m.get('ProcessRate')
        if m.get('RiskCount') is not None:
            self.risk_count = m.get('RiskCount')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeStrategyResponseBody(TeaModel):
    def __init__(self, request_id=None, strategies=None):
        self.request_id = request_id  # type: str
        self.strategies = strategies  # type: list[DescribeStrategyResponseBodyStrategies]

    def validate(self):
        if self.strategies:
            for k in self.strategies:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeStrategyResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Strategies'] = []
        if self.strategies is not None:
            for k in self.strategies:
                result['Strategies'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.strategies = []
        if m.get('Strategies') is not None:
            for k in m.get('Strategies'):
                temp_model = DescribeStrategyResponseBodyStrategies()
                self.strategies.append(temp_model.from_map(k))
        return self


class DescribeStrategyResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeStrategyResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeStrategyResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeStrategyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeStrategyExecDetailRequest(TeaModel):
    def __init__(self, current_page=None, page_size=None, source_ip=None, strategy_id=None):
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.source_ip = source_ip  # type: str
        self.strategy_id = strategy_id  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeStrategyExecDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.strategy_id is not None:
            result['StrategyId'] = self.strategy_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('StrategyId') is not None:
            self.strategy_id = m.get('StrategyId')
        return self


class DescribeStrategyExecDetailResponseBodyFailedEcsList(TeaModel):
    def __init__(self, ip=None, instance_name=None, internet_ip=None, intranet_ip=None, reason=None):
        self.ip = ip  # type: str
        self.instance_name = instance_name  # type: str
        self.internet_ip = internet_ip  # type: str
        self.intranet_ip = intranet_ip  # type: str
        self.reason = reason  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeStrategyExecDetailResponseBodyFailedEcsList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ip is not None:
            result['IP'] = self.ip
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.reason is not None:
            result['Reason'] = self.reason
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IP') is not None:
            self.ip = m.get('IP')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('Reason') is not None:
            self.reason = m.get('Reason')
        return self


class DescribeStrategyExecDetailResponseBody(TeaModel):
    def __init__(self, end_time=None, fail_count=None, failed_ecs_list=None, in_process_count=None, percent=None,
                 request_id=None, source=None, start_time=None, success_count=None):
        self.end_time = end_time  # type: str
        self.fail_count = fail_count  # type: int
        self.failed_ecs_list = failed_ecs_list  # type: list[DescribeStrategyExecDetailResponseBodyFailedEcsList]
        self.in_process_count = in_process_count  # type: int
        self.percent = percent  # type: str
        self.request_id = request_id  # type: str
        self.source = source  # type: str
        self.start_time = start_time  # type: str
        self.success_count = success_count  # type: int

    def validate(self):
        if self.failed_ecs_list:
            for k in self.failed_ecs_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeStrategyExecDetailResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.fail_count is not None:
            result['FailCount'] = self.fail_count
        result['FailedEcsList'] = []
        if self.failed_ecs_list is not None:
            for k in self.failed_ecs_list:
                result['FailedEcsList'].append(k.to_map() if k else None)
        if self.in_process_count is not None:
            result['InProcessCount'] = self.in_process_count
        if self.percent is not None:
            result['Percent'] = self.percent
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.source is not None:
            result['Source'] = self.source
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.success_count is not None:
            result['SuccessCount'] = self.success_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('FailCount') is not None:
            self.fail_count = m.get('FailCount')
        self.failed_ecs_list = []
        if m.get('FailedEcsList') is not None:
            for k in m.get('FailedEcsList'):
                temp_model = DescribeStrategyExecDetailResponseBodyFailedEcsList()
                self.failed_ecs_list.append(temp_model.from_map(k))
        if m.get('InProcessCount') is not None:
            self.in_process_count = m.get('InProcessCount')
        if m.get('Percent') is not None:
            self.percent = m.get('Percent')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('SuccessCount') is not None:
            self.success_count = m.get('SuccessCount')
        return self


class DescribeStrategyExecDetailResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeStrategyExecDetailResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeStrategyExecDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeStrategyExecDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeStrategyTargetRequest(TeaModel):
    def __init__(self, config=None, source_ip=None, type=None):
        self.config = config  # type: str
        self.source_ip = source_ip  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeStrategyTargetRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config is not None:
            result['Config'] = self.config
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Config') is not None:
            self.config = m.get('Config')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeStrategyTargetResponseBodyStrategyTargets(TeaModel):
    def __init__(self, bind_uuid_count=None, flag=None, target=None, target_type=None):
        self.bind_uuid_count = bind_uuid_count  # type: int
        self.flag = flag  # type: str
        self.target = target  # type: str
        self.target_type = target_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeStrategyTargetResponseBodyStrategyTargets, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bind_uuid_count is not None:
            result['BindUuidCount'] = self.bind_uuid_count
        if self.flag is not None:
            result['Flag'] = self.flag
        if self.target is not None:
            result['Target'] = self.target
        if self.target_type is not None:
            result['TargetType'] = self.target_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BindUuidCount') is not None:
            self.bind_uuid_count = m.get('BindUuidCount')
        if m.get('Flag') is not None:
            self.flag = m.get('Flag')
        if m.get('Target') is not None:
            self.target = m.get('Target')
        if m.get('TargetType') is not None:
            self.target_type = m.get('TargetType')
        return self


class DescribeStrategyTargetResponseBody(TeaModel):
    def __init__(self, request_id=None, strategy_targets=None):
        self.request_id = request_id  # type: str
        self.strategy_targets = strategy_targets  # type: list[DescribeStrategyTargetResponseBodyStrategyTargets]

    def validate(self):
        if self.strategy_targets:
            for k in self.strategy_targets:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeStrategyTargetResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['StrategyTargets'] = []
        if self.strategy_targets is not None:
            for k in self.strategy_targets:
                result['StrategyTargets'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.strategy_targets = []
        if m.get('StrategyTargets') is not None:
            for k in m.get('StrategyTargets'):
                temp_model = DescribeStrategyTargetResponseBodyStrategyTargets()
                self.strategy_targets.append(temp_model.from_map(k))
        return self


class DescribeStrategyTargetResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeStrategyTargetResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeStrategyTargetResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeStrategyTargetResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSummaryInfoRequest(TeaModel):
    def __init__(self, lang=None, resource_directory_account_id=None, source_ip=None):
        self.lang = lang  # type: str
        self.resource_directory_account_id = resource_directory_account_id  # type: str
        self.source_ip = source_ip  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSummaryInfoRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.resource_directory_account_id is not None:
            result['ResourceDirectoryAccountId'] = self.resource_directory_account_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('ResourceDirectoryAccountId') is not None:
            self.resource_directory_account_id = m.get('ResourceDirectoryAccountId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeSummaryInfoResponseBody(TeaModel):
    def __init__(self, aegis_client_offline_count=None, aegis_client_online_count=None, request_id=None,
                 security_score=None, success=None):
        self.aegis_client_offline_count = aegis_client_offline_count  # type: int
        self.aegis_client_online_count = aegis_client_online_count  # type: int
        self.request_id = request_id  # type: str
        self.security_score = security_score  # type: int
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSummaryInfoResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aegis_client_offline_count is not None:
            result['AegisClientOfflineCount'] = self.aegis_client_offline_count
        if self.aegis_client_online_count is not None:
            result['AegisClientOnlineCount'] = self.aegis_client_online_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.security_score is not None:
            result['SecurityScore'] = self.security_score
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AegisClientOfflineCount') is not None:
            self.aegis_client_offline_count = m.get('AegisClientOfflineCount')
        if m.get('AegisClientOnlineCount') is not None:
            self.aegis_client_online_count = m.get('AegisClientOnlineCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SecurityScore') is not None:
            self.security_score = m.get('SecurityScore')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeSummaryInfoResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeSummaryInfoResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeSummaryInfoResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSummaryInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSupportRegionResponseBody(TeaModel):
    def __init__(self, request_id=None, support_region=None):
        self.request_id = request_id  # type: str
        self.support_region = support_region  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSupportRegionResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.support_region is not None:
            result['SupportRegion'] = self.support_region
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SupportRegion') is not None:
            self.support_region = m.get('SupportRegion')
        return self


class DescribeSupportRegionResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeSupportRegionResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeSupportRegionResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSupportRegionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSuspEventDetailRequest(TeaModel):
    def __init__(self, from_=None, lang=None, source_ip=None, suspicious_event_id=None):
        self.from_ = from_  # type: str
        self.lang = lang  # type: str
        self.source_ip = source_ip  # type: str
        self.suspicious_event_id = suspicious_event_id  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSuspEventDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.from_ is not None:
            result['From'] = self.from_
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.suspicious_event_id is not None:
            result['SuspiciousEventId'] = self.suspicious_event_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('From') is not None:
            self.from_ = m.get('From')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('SuspiciousEventId') is not None:
            self.suspicious_event_id = m.get('SuspiciousEventId')
        return self


class DescribeSuspEventDetailResponseBodyDetails(TeaModel):
    def __init__(self, name_display=None, type=None, value=None):
        self.name_display = name_display  # type: str
        self.type = type  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSuspEventDetailResponseBodyDetails, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name_display is not None:
            result['NameDisplay'] = self.name_display
        if self.type is not None:
            result['Type'] = self.type
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NameDisplay') is not None:
            self.name_display = m.get('NameDisplay')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeSuspEventDetailResponseBody(TeaModel):
    def __init__(self, can_be_deal_on_line=None, data_source=None, details=None, event_desc=None, event_name=None,
                 event_status=None, event_type_desc=None, id=None, instance_name=None, internet_ip=None, intranet_ip=None,
                 last_time=None, level=None, operate_error_code=None, operate_msg=None, request_id=None, sale_version=None,
                 uuid=None):
        self.can_be_deal_on_line = can_be_deal_on_line  # type: bool
        self.data_source = data_source  # type: str
        self.details = details  # type: list[DescribeSuspEventDetailResponseBodyDetails]
        self.event_desc = event_desc  # type: str
        self.event_name = event_name  # type: str
        self.event_status = event_status  # type: str
        self.event_type_desc = event_type_desc  # type: str
        self.id = id  # type: int
        self.instance_name = instance_name  # type: str
        self.internet_ip = internet_ip  # type: str
        self.intranet_ip = intranet_ip  # type: str
        self.last_time = last_time  # type: str
        self.level = level  # type: str
        self.operate_error_code = operate_error_code  # type: str
        self.operate_msg = operate_msg  # type: str
        self.request_id = request_id  # type: str
        self.sale_version = sale_version  # type: str
        self.uuid = uuid  # type: str

    def validate(self):
        if self.details:
            for k in self.details:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeSuspEventDetailResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.can_be_deal_on_line is not None:
            result['CanBeDealOnLine'] = self.can_be_deal_on_line
        if self.data_source is not None:
            result['DataSource'] = self.data_source
        result['Details'] = []
        if self.details is not None:
            for k in self.details:
                result['Details'].append(k.to_map() if k else None)
        if self.event_desc is not None:
            result['EventDesc'] = self.event_desc
        if self.event_name is not None:
            result['EventName'] = self.event_name
        if self.event_status is not None:
            result['EventStatus'] = self.event_status
        if self.event_type_desc is not None:
            result['EventTypeDesc'] = self.event_type_desc
        if self.id is not None:
            result['Id'] = self.id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.last_time is not None:
            result['LastTime'] = self.last_time
        if self.level is not None:
            result['Level'] = self.level
        if self.operate_error_code is not None:
            result['OperateErrorCode'] = self.operate_error_code
        if self.operate_msg is not None:
            result['OperateMsg'] = self.operate_msg
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.sale_version is not None:
            result['SaleVersion'] = self.sale_version
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CanBeDealOnLine') is not None:
            self.can_be_deal_on_line = m.get('CanBeDealOnLine')
        if m.get('DataSource') is not None:
            self.data_source = m.get('DataSource')
        self.details = []
        if m.get('Details') is not None:
            for k in m.get('Details'):
                temp_model = DescribeSuspEventDetailResponseBodyDetails()
                self.details.append(temp_model.from_map(k))
        if m.get('EventDesc') is not None:
            self.event_desc = m.get('EventDesc')
        if m.get('EventName') is not None:
            self.event_name = m.get('EventName')
        if m.get('EventStatus') is not None:
            self.event_status = m.get('EventStatus')
        if m.get('EventTypeDesc') is not None:
            self.event_type_desc = m.get('EventTypeDesc')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('LastTime') is not None:
            self.last_time = m.get('LastTime')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('OperateErrorCode') is not None:
            self.operate_error_code = m.get('OperateErrorCode')
        if m.get('OperateMsg') is not None:
            self.operate_msg = m.get('OperateMsg')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SaleVersion') is not None:
            self.sale_version = m.get('SaleVersion')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeSuspEventDetailResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeSuspEventDetailResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeSuspEventDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSuspEventDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSuspEventQuaraFilesRequest(TeaModel):
    def __init__(self, current_page=None, from_=None, group_id=None, grouping_id=None, page_size=None,
                 quara_tag=None, source_ip=None, status=None):
        self.current_page = current_page  # type: str
        self.from_ = from_  # type: str
        self.group_id = group_id  # type: str
        self.grouping_id = grouping_id  # type: long
        self.page_size = page_size  # type: str
        self.quara_tag = quara_tag  # type: str
        self.source_ip = source_ip  # type: str
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSuspEventQuaraFilesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.from_ is not None:
            result['From'] = self.from_
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.grouping_id is not None:
            result['GroupingId'] = self.grouping_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.quara_tag is not None:
            result['QuaraTag'] = self.quara_tag
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('From') is not None:
            self.from_ = m.get('From')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupingId') is not None:
            self.grouping_id = m.get('GroupingId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('QuaraTag') is not None:
            self.quara_tag = m.get('QuaraTag')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeSuspEventQuaraFilesResponseBodyQuaraFiles(TeaModel):
    def __init__(self, event_name=None, event_type=None, id=None, instance_id=None, instance_name=None,
                 internet_ip=None, ip=None, link=None, md_5=None, modify_time=None, path=None, status=None, tag=None, uuid=None):
        self.event_name = event_name  # type: str
        self.event_type = event_type  # type: str
        self.id = id  # type: int
        self.instance_id = instance_id  # type: str
        self.instance_name = instance_name  # type: str
        self.internet_ip = internet_ip  # type: str
        self.ip = ip  # type: str
        self.link = link  # type: str
        self.md_5 = md_5  # type: str
        self.modify_time = modify_time  # type: str
        self.path = path  # type: str
        self.status = status  # type: str
        self.tag = tag  # type: str
        self.uuid = uuid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSuspEventQuaraFilesResponseBodyQuaraFiles, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event_name is not None:
            result['EventName'] = self.event_name
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.id is not None:
            result['Id'] = self.id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.link is not None:
            result['Link'] = self.link
        if self.md_5 is not None:
            result['Md5'] = self.md_5
        if self.modify_time is not None:
            result['ModifyTime'] = self.modify_time
        if self.path is not None:
            result['Path'] = self.path
        if self.status is not None:
            result['Status'] = self.status
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EventName') is not None:
            self.event_name = m.get('EventName')
        if m.get('EventType') is not None:
            self.event_type = m.get('EventType')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('Link') is not None:
            self.link = m.get('Link')
        if m.get('Md5') is not None:
            self.md_5 = m.get('Md5')
        if m.get('ModifyTime') is not None:
            self.modify_time = m.get('ModifyTime')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeSuspEventQuaraFilesResponseBody(TeaModel):
    def __init__(self, count=None, current_page=None, page_size=None, quara_files=None, request_id=None,
                 total_count=None):
        self.count = count  # type: int
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.quara_files = quara_files  # type: list[DescribeSuspEventQuaraFilesResponseBodyQuaraFiles]
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: int

    def validate(self):
        if self.quara_files:
            for k in self.quara_files:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeSuspEventQuaraFilesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['QuaraFiles'] = []
        if self.quara_files is not None:
            for k in self.quara_files:
                result['QuaraFiles'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.quara_files = []
        if m.get('QuaraFiles') is not None:
            for k in m.get('QuaraFiles'):
                temp_model = DescribeSuspEventQuaraFilesResponseBodyQuaraFiles()
                self.quara_files.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeSuspEventQuaraFilesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeSuspEventQuaraFilesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeSuspEventQuaraFilesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSuspEventQuaraFilesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSuspEventsRequest(TeaModel):
    def __init__(self, alarm_unique_info=None, cluster_id=None, container_field_name=None,
                 container_field_value=None, current_page=None, dealed=None, event_names=None, from_=None, group_id=None, lang=None,
                 levels=None, name=None, operate_error_code_list=None, page_size=None, parent_event_types=None,
                 remark=None, source=None, source_ip=None, status=None, target_type=None, unique_info=None, uuids=None):
        self.alarm_unique_info = alarm_unique_info  # type: str
        self.cluster_id = cluster_id  # type: str
        self.container_field_name = container_field_name  # type: str
        self.container_field_value = container_field_value  # type: str
        self.current_page = current_page  # type: str
        self.dealed = dealed  # type: str
        self.event_names = event_names  # type: str
        self.from_ = from_  # type: str
        self.group_id = group_id  # type: long
        self.lang = lang  # type: str
        self.levels = levels  # type: str
        self.name = name  # type: str
        self.operate_error_code_list = operate_error_code_list  # type: list[str]
        self.page_size = page_size  # type: str
        self.parent_event_types = parent_event_types  # type: str
        self.remark = remark  # type: str
        self.source = source  # type: str
        self.source_ip = source_ip  # type: str
        self.status = status  # type: str
        self.target_type = target_type  # type: str
        self.unique_info = unique_info  # type: str
        self.uuids = uuids  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSuspEventsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_unique_info is not None:
            result['AlarmUniqueInfo'] = self.alarm_unique_info
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.container_field_name is not None:
            result['ContainerFieldName'] = self.container_field_name
        if self.container_field_value is not None:
            result['ContainerFieldValue'] = self.container_field_value
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dealed is not None:
            result['Dealed'] = self.dealed
        if self.event_names is not None:
            result['EventNames'] = self.event_names
        if self.from_ is not None:
            result['From'] = self.from_
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.levels is not None:
            result['Levels'] = self.levels
        if self.name is not None:
            result['Name'] = self.name
        if self.operate_error_code_list is not None:
            result['OperateErrorCodeList'] = self.operate_error_code_list
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.parent_event_types is not None:
            result['ParentEventTypes'] = self.parent_event_types
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.source is not None:
            result['Source'] = self.source
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.status is not None:
            result['Status'] = self.status
        if self.target_type is not None:
            result['TargetType'] = self.target_type
        if self.unique_info is not None:
            result['UniqueInfo'] = self.unique_info
        if self.uuids is not None:
            result['Uuids'] = self.uuids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlarmUniqueInfo') is not None:
            self.alarm_unique_info = m.get('AlarmUniqueInfo')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ContainerFieldName') is not None:
            self.container_field_name = m.get('ContainerFieldName')
        if m.get('ContainerFieldValue') is not None:
            self.container_field_value = m.get('ContainerFieldValue')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Dealed') is not None:
            self.dealed = m.get('Dealed')
        if m.get('EventNames') is not None:
            self.event_names = m.get('EventNames')
        if m.get('From') is not None:
            self.from_ = m.get('From')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Levels') is not None:
            self.levels = m.get('Levels')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OperateErrorCodeList') is not None:
            self.operate_error_code_list = m.get('OperateErrorCodeList')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ParentEventTypes') is not None:
            self.parent_event_types = m.get('ParentEventTypes')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TargetType') is not None:
            self.target_type = m.get('TargetType')
        if m.get('UniqueInfo') is not None:
            self.unique_info = m.get('UniqueInfo')
        if m.get('Uuids') is not None:
            self.uuids = m.get('Uuids')
        return self


class DescribeSuspEventsResponseBodySuspEventsDetails(TeaModel):
    def __init__(self, name_display=None, type=None, value=None, value_display=None):
        self.name_display = name_display  # type: str
        self.type = type  # type: str
        self.value = value  # type: str
        self.value_display = value_display  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSuspEventsResponseBodySuspEventsDetails, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name_display is not None:
            result['NameDisplay'] = self.name_display
        if self.type is not None:
            result['Type'] = self.type
        if self.value is not None:
            result['Value'] = self.value
        if self.value_display is not None:
            result['ValueDisplay'] = self.value_display
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NameDisplay') is not None:
            self.name_display = m.get('NameDisplay')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('ValueDisplay') is not None:
            self.value_display = m.get('ValueDisplay')
        return self


class DescribeSuspEventsResponseBodySuspEventsEventNotes(TeaModel):
    def __init__(self, note=None, note_id=None, note_time=None):
        self.note = note  # type: str
        self.note_id = note_id  # type: long
        self.note_time = note_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSuspEventsResponseBodySuspEventsEventNotes, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.note is not None:
            result['Note'] = self.note
        if self.note_id is not None:
            result['NoteId'] = self.note_id
        if self.note_time is not None:
            result['NoteTime'] = self.note_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Note') is not None:
            self.note = m.get('Note')
        if m.get('NoteId') is not None:
            self.note_id = m.get('NoteId')
        if m.get('NoteTime') is not None:
            self.note_time = m.get('NoteTime')
        return self


class DescribeSuspEventsResponseBodySuspEvents(TeaModel):
    def __init__(self, advanced=None, alarm_event_name=None, alarm_event_name_display=None, alarm_event_type=None,
                 alarm_event_type_display=None, alarm_unique_info=None, app_name=None, auto_breaking=None, can_be_deal_on_line=None,
                 can_cancel_fault=None, contain_hw_mode=None, container_id=None, container_image_id=None, container_image_name=None,
                 data_source=None, desc=None, details=None, event_notes=None, event_status=None, event_sub_type=None,
                 has_trace_info=None, id=None, instance_id=None, instance_name=None, internet_ip=None, intranet_ip=None,
                 k_8s_cluster_id=None, k_8s_cluster_name=None, k_8s_namespace=None, k_8s_node_id=None, k_8s_node_name=None,
                 k_8s_pod_name=None, last_time=None, last_time_stamp=None, level=None, mark_mis_rules=None, name=None,
                 occurrence_time=None, occurrence_time_stamp=None, operate_error_code=None, operate_msg=None, operate_time=None,
                 sale_version=None, security_event_ids=None, stages=None, unique_info=None, uuid=None):
        self.advanced = advanced  # type: bool
        self.alarm_event_name = alarm_event_name  # type: str
        self.alarm_event_name_display = alarm_event_name_display  # type: str
        self.alarm_event_type = alarm_event_type  # type: str
        self.alarm_event_type_display = alarm_event_type_display  # type: str
        self.alarm_unique_info = alarm_unique_info  # type: str
        self.app_name = app_name  # type: str
        self.auto_breaking = auto_breaking  # type: bool
        self.can_be_deal_on_line = can_be_deal_on_line  # type: bool
        self.can_cancel_fault = can_cancel_fault  # type: bool
        self.contain_hw_mode = contain_hw_mode  # type: bool
        self.container_id = container_id  # type: str
        self.container_image_id = container_image_id  # type: str
        self.container_image_name = container_image_name  # type: str
        self.data_source = data_source  # type: str
        self.desc = desc  # type: str
        self.details = details  # type: list[DescribeSuspEventsResponseBodySuspEventsDetails]
        self.event_notes = event_notes  # type: list[DescribeSuspEventsResponseBodySuspEventsEventNotes]
        self.event_status = event_status  # type: int
        self.event_sub_type = event_sub_type  # type: str
        self.has_trace_info = has_trace_info  # type: bool
        self.id = id  # type: long
        self.instance_id = instance_id  # type: str
        self.instance_name = instance_name  # type: str
        self.internet_ip = internet_ip  # type: str
        self.intranet_ip = intranet_ip  # type: str
        self.k_8s_cluster_id = k_8s_cluster_id  # type: str
        self.k_8s_cluster_name = k_8s_cluster_name  # type: str
        self.k_8s_namespace = k_8s_namespace  # type: str
        self.k_8s_node_id = k_8s_node_id  # type: str
        self.k_8s_node_name = k_8s_node_name  # type: str
        self.k_8s_pod_name = k_8s_pod_name  # type: str
        self.last_time = last_time  # type: str
        self.last_time_stamp = last_time_stamp  # type: long
        self.level = level  # type: str
        self.mark_mis_rules = mark_mis_rules  # type: str
        self.name = name  # type: str
        self.occurrence_time = occurrence_time  # type: str
        self.occurrence_time_stamp = occurrence_time_stamp  # type: long
        self.operate_error_code = operate_error_code  # type: str
        self.operate_msg = operate_msg  # type: str
        self.operate_time = operate_time  # type: long
        self.sale_version = sale_version  # type: str
        self.security_event_ids = security_event_ids  # type: str
        self.stages = stages  # type: str
        self.unique_info = unique_info  # type: str
        self.uuid = uuid  # type: str

    def validate(self):
        if self.details:
            for k in self.details:
                if k:
                    k.validate()
        if self.event_notes:
            for k in self.event_notes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeSuspEventsResponseBodySuspEvents, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.advanced is not None:
            result['Advanced'] = self.advanced
        if self.alarm_event_name is not None:
            result['AlarmEventName'] = self.alarm_event_name
        if self.alarm_event_name_display is not None:
            result['AlarmEventNameDisplay'] = self.alarm_event_name_display
        if self.alarm_event_type is not None:
            result['AlarmEventType'] = self.alarm_event_type
        if self.alarm_event_type_display is not None:
            result['AlarmEventTypeDisplay'] = self.alarm_event_type_display
        if self.alarm_unique_info is not None:
            result['AlarmUniqueInfo'] = self.alarm_unique_info
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.auto_breaking is not None:
            result['AutoBreaking'] = self.auto_breaking
        if self.can_be_deal_on_line is not None:
            result['CanBeDealOnLine'] = self.can_be_deal_on_line
        if self.can_cancel_fault is not None:
            result['CanCancelFault'] = self.can_cancel_fault
        if self.contain_hw_mode is not None:
            result['ContainHwMode'] = self.contain_hw_mode
        if self.container_id is not None:
            result['ContainerId'] = self.container_id
        if self.container_image_id is not None:
            result['ContainerImageId'] = self.container_image_id
        if self.container_image_name is not None:
            result['ContainerImageName'] = self.container_image_name
        if self.data_source is not None:
            result['DataSource'] = self.data_source
        if self.desc is not None:
            result['Desc'] = self.desc
        result['Details'] = []
        if self.details is not None:
            for k in self.details:
                result['Details'].append(k.to_map() if k else None)
        result['EventNotes'] = []
        if self.event_notes is not None:
            for k in self.event_notes:
                result['EventNotes'].append(k.to_map() if k else None)
        if self.event_status is not None:
            result['EventStatus'] = self.event_status
        if self.event_sub_type is not None:
            result['EventSubType'] = self.event_sub_type
        if self.has_trace_info is not None:
            result['HasTraceInfo'] = self.has_trace_info
        if self.id is not None:
            result['Id'] = self.id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.k_8s_cluster_id is not None:
            result['K8sClusterId'] = self.k_8s_cluster_id
        if self.k_8s_cluster_name is not None:
            result['K8sClusterName'] = self.k_8s_cluster_name
        if self.k_8s_namespace is not None:
            result['K8sNamespace'] = self.k_8s_namespace
        if self.k_8s_node_id is not None:
            result['K8sNodeId'] = self.k_8s_node_id
        if self.k_8s_node_name is not None:
            result['K8sNodeName'] = self.k_8s_node_name
        if self.k_8s_pod_name is not None:
            result['K8sPodName'] = self.k_8s_pod_name
        if self.last_time is not None:
            result['LastTime'] = self.last_time
        if self.last_time_stamp is not None:
            result['LastTimeStamp'] = self.last_time_stamp
        if self.level is not None:
            result['Level'] = self.level
        if self.mark_mis_rules is not None:
            result['MarkMisRules'] = self.mark_mis_rules
        if self.name is not None:
            result['Name'] = self.name
        if self.occurrence_time is not None:
            result['OccurrenceTime'] = self.occurrence_time
        if self.occurrence_time_stamp is not None:
            result['OccurrenceTimeStamp'] = self.occurrence_time_stamp
        if self.operate_error_code is not None:
            result['OperateErrorCode'] = self.operate_error_code
        if self.operate_msg is not None:
            result['OperateMsg'] = self.operate_msg
        if self.operate_time is not None:
            result['OperateTime'] = self.operate_time
        if self.sale_version is not None:
            result['SaleVersion'] = self.sale_version
        if self.security_event_ids is not None:
            result['SecurityEventIds'] = self.security_event_ids
        if self.stages is not None:
            result['Stages'] = self.stages
        if self.unique_info is not None:
            result['UniqueInfo'] = self.unique_info
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Advanced') is not None:
            self.advanced = m.get('Advanced')
        if m.get('AlarmEventName') is not None:
            self.alarm_event_name = m.get('AlarmEventName')
        if m.get('AlarmEventNameDisplay') is not None:
            self.alarm_event_name_display = m.get('AlarmEventNameDisplay')
        if m.get('AlarmEventType') is not None:
            self.alarm_event_type = m.get('AlarmEventType')
        if m.get('AlarmEventTypeDisplay') is not None:
            self.alarm_event_type_display = m.get('AlarmEventTypeDisplay')
        if m.get('AlarmUniqueInfo') is not None:
            self.alarm_unique_info = m.get('AlarmUniqueInfo')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('AutoBreaking') is not None:
            self.auto_breaking = m.get('AutoBreaking')
        if m.get('CanBeDealOnLine') is not None:
            self.can_be_deal_on_line = m.get('CanBeDealOnLine')
        if m.get('CanCancelFault') is not None:
            self.can_cancel_fault = m.get('CanCancelFault')
        if m.get('ContainHwMode') is not None:
            self.contain_hw_mode = m.get('ContainHwMode')
        if m.get('ContainerId') is not None:
            self.container_id = m.get('ContainerId')
        if m.get('ContainerImageId') is not None:
            self.container_image_id = m.get('ContainerImageId')
        if m.get('ContainerImageName') is not None:
            self.container_image_name = m.get('ContainerImageName')
        if m.get('DataSource') is not None:
            self.data_source = m.get('DataSource')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        self.details = []
        if m.get('Details') is not None:
            for k in m.get('Details'):
                temp_model = DescribeSuspEventsResponseBodySuspEventsDetails()
                self.details.append(temp_model.from_map(k))
        self.event_notes = []
        if m.get('EventNotes') is not None:
            for k in m.get('EventNotes'):
                temp_model = DescribeSuspEventsResponseBodySuspEventsEventNotes()
                self.event_notes.append(temp_model.from_map(k))
        if m.get('EventStatus') is not None:
            self.event_status = m.get('EventStatus')
        if m.get('EventSubType') is not None:
            self.event_sub_type = m.get('EventSubType')
        if m.get('HasTraceInfo') is not None:
            self.has_trace_info = m.get('HasTraceInfo')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('K8sClusterId') is not None:
            self.k_8s_cluster_id = m.get('K8sClusterId')
        if m.get('K8sClusterName') is not None:
            self.k_8s_cluster_name = m.get('K8sClusterName')
        if m.get('K8sNamespace') is not None:
            self.k_8s_namespace = m.get('K8sNamespace')
        if m.get('K8sNodeId') is not None:
            self.k_8s_node_id = m.get('K8sNodeId')
        if m.get('K8sNodeName') is not None:
            self.k_8s_node_name = m.get('K8sNodeName')
        if m.get('K8sPodName') is not None:
            self.k_8s_pod_name = m.get('K8sPodName')
        if m.get('LastTime') is not None:
            self.last_time = m.get('LastTime')
        if m.get('LastTimeStamp') is not None:
            self.last_time_stamp = m.get('LastTimeStamp')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('MarkMisRules') is not None:
            self.mark_mis_rules = m.get('MarkMisRules')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OccurrenceTime') is not None:
            self.occurrence_time = m.get('OccurrenceTime')
        if m.get('OccurrenceTimeStamp') is not None:
            self.occurrence_time_stamp = m.get('OccurrenceTimeStamp')
        if m.get('OperateErrorCode') is not None:
            self.operate_error_code = m.get('OperateErrorCode')
        if m.get('OperateMsg') is not None:
            self.operate_msg = m.get('OperateMsg')
        if m.get('OperateTime') is not None:
            self.operate_time = m.get('OperateTime')
        if m.get('SaleVersion') is not None:
            self.sale_version = m.get('SaleVersion')
        if m.get('SecurityEventIds') is not None:
            self.security_event_ids = m.get('SecurityEventIds')
        if m.get('Stages') is not None:
            self.stages = m.get('Stages')
        if m.get('UniqueInfo') is not None:
            self.unique_info = m.get('UniqueInfo')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeSuspEventsResponseBody(TeaModel):
    def __init__(self, count=None, current_page=None, page_size=None, request_id=None, susp_events=None,
                 total_count=None):
        self.count = count  # type: int
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.susp_events = susp_events  # type: list[DescribeSuspEventsResponseBodySuspEvents]
        self.total_count = total_count  # type: int

    def validate(self):
        if self.susp_events:
            for k in self.susp_events:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeSuspEventsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['SuspEvents'] = []
        if self.susp_events is not None:
            for k in self.susp_events:
                result['SuspEvents'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.susp_events = []
        if m.get('SuspEvents') is not None:
            for k in m.get('SuspEvents'):
                temp_model = DescribeSuspEventsResponseBodySuspEvents()
                self.susp_events.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeSuspEventsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeSuspEventsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeSuspEventsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSuspEventsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSuspiciousUUIDConfigRequest(TeaModel):
    def __init__(self, type=None):
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSuspiciousUUIDConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeSuspiciousUUIDConfigResponseBody(TeaModel):
    def __init__(self, count=None, request_id=None, uuidlist=None):
        self.count = count  # type: int
        self.request_id = request_id  # type: str
        self.uuidlist = uuidlist  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSuspiciousUUIDConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.uuidlist is not None:
            result['UUIDList'] = self.uuidlist
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('UUIDList') is not None:
            self.uuidlist = m.get('UUIDList')
        return self


class DescribeSuspiciousUUIDConfigResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeSuspiciousUUIDConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeSuspiciousUUIDConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSuspiciousUUIDConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeUserBackupMachinesResponseBodyMachines(TeaModel):
    def __init__(self, id=None, policy_name=None, uuid=None):
        self.id = id  # type: long
        self.policy_name = policy_name  # type: str
        self.uuid = uuid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeUserBackupMachinesResponseBodyMachines, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.policy_name is not None:
            result['PolicyName'] = self.policy_name
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('PolicyName') is not None:
            self.policy_name = m.get('PolicyName')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeUserBackupMachinesResponseBody(TeaModel):
    def __init__(self, machines=None, request_id=None):
        self.machines = machines  # type: list[DescribeUserBackupMachinesResponseBodyMachines]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.machines:
            for k in self.machines:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeUserBackupMachinesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Machines'] = []
        if self.machines is not None:
            for k in self.machines:
                result['Machines'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.machines = []
        if m.get('Machines') is not None:
            for k in m.get('Machines'):
                temp_model = DescribeUserBackupMachinesResponseBodyMachines()
                self.machines.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeUserBackupMachinesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeUserBackupMachinesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeUserBackupMachinesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeUserBackupMachinesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeUserBaselineAuthorizationRequest(TeaModel):
    def __init__(self, lang=None, resource_owner_id=None, source_ip=None):
        self.lang = lang  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.source_ip = source_ip  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeUserBaselineAuthorizationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeUserBaselineAuthorizationResponseBodyUserBaselineAuthorization(TeaModel):
    def __init__(self, status=None):
        self.status = status  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeUserBaselineAuthorizationResponseBodyUserBaselineAuthorization, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeUserBaselineAuthorizationResponseBody(TeaModel):
    def __init__(self, request_id=None, user_baseline_authorization=None):
        self.request_id = request_id  # type: str
        self.user_baseline_authorization = user_baseline_authorization  # type: DescribeUserBaselineAuthorizationResponseBodyUserBaselineAuthorization

    def validate(self):
        if self.user_baseline_authorization:
            self.user_baseline_authorization.validate()

    def to_map(self):
        _map = super(DescribeUserBaselineAuthorizationResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.user_baseline_authorization is not None:
            result['UserBaselineAuthorization'] = self.user_baseline_authorization.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('UserBaselineAuthorization') is not None:
            temp_model = DescribeUserBaselineAuthorizationResponseBodyUserBaselineAuthorization()
            self.user_baseline_authorization = temp_model.from_map(m['UserBaselineAuthorization'])
        return self


class DescribeUserBaselineAuthorizationResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeUserBaselineAuthorizationResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeUserBaselineAuthorizationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeUserBaselineAuthorizationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeUserLayoutAuthorizationRequest(TeaModel):
    def __init__(self, lang=None, resource_owner_id=None, source_ip=None):
        self.lang = lang  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.source_ip = source_ip  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeUserLayoutAuthorizationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeUserLayoutAuthorizationResponseBody(TeaModel):
    def __init__(self, authorized=None, request_id=None):
        self.authorized = authorized  # type: bool
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeUserLayoutAuthorizationResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.authorized is not None:
            result['Authorized'] = self.authorized
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Authorized') is not None:
            self.authorized = m.get('Authorized')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeUserLayoutAuthorizationResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeUserLayoutAuthorizationResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeUserLayoutAuthorizationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeUserLayoutAuthorizationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeVersionConfigRequest(TeaModel):
    def __init__(self, resource_directory_account_id=None, source_ip=None):
        self.resource_directory_account_id = resource_directory_account_id  # type: str
        self.source_ip = source_ip  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeVersionConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_directory_account_id is not None:
            result['ResourceDirectoryAccountId'] = self.resource_directory_account_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceDirectoryAccountId') is not None:
            self.resource_directory_account_id = m.get('ResourceDirectoryAccountId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeVersionConfigResponseBody(TeaModel):
    def __init__(self, allow_partial_buy=None, app_white_list=None, app_white_list_auth_count=None,
                 asset_level=None, highest_version=None, honeypot_capacity=None, image_scan_capacity=None, instance_id=None,
                 is_over_balance=None, is_trial_version=None, last_trail_end_time=None, mvauth_count=None,
                 mvunused_auth_count=None, release_time=None, request_id=None, sas_log=None, sas_screen=None, sls_capacity=None,
                 user_defined_alarms=None, version=None, vm_cores=None, web_lock=None, web_lock_auth_count=None):
        self.allow_partial_buy = allow_partial_buy  # type: int
        self.app_white_list = app_white_list  # type: int
        self.app_white_list_auth_count = app_white_list_auth_count  # type: long
        self.asset_level = asset_level  # type: int
        self.highest_version = highest_version  # type: int
        self.honeypot_capacity = honeypot_capacity  # type: long
        self.image_scan_capacity = image_scan_capacity  # type: long
        self.instance_id = instance_id  # type: str
        self.is_over_balance = is_over_balance  # type: bool
        self.is_trial_version = is_trial_version  # type: int
        self.last_trail_end_time = last_trail_end_time  # type: long
        self.mvauth_count = mvauth_count  # type: int
        self.mvunused_auth_count = mvunused_auth_count  # type: int
        self.release_time = release_time  # type: long
        self.request_id = request_id  # type: str
        self.sas_log = sas_log  # type: int
        self.sas_screen = sas_screen  # type: int
        self.sls_capacity = sls_capacity  # type: long
        self.user_defined_alarms = user_defined_alarms  # type: int
        self.version = version  # type: int
        self.vm_cores = vm_cores  # type: int
        self.web_lock = web_lock  # type: int
        self.web_lock_auth_count = web_lock_auth_count  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeVersionConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.allow_partial_buy is not None:
            result['AllowPartialBuy'] = self.allow_partial_buy
        if self.app_white_list is not None:
            result['AppWhiteList'] = self.app_white_list
        if self.app_white_list_auth_count is not None:
            result['AppWhiteListAuthCount'] = self.app_white_list_auth_count
        if self.asset_level is not None:
            result['AssetLevel'] = self.asset_level
        if self.highest_version is not None:
            result['HighestVersion'] = self.highest_version
        if self.honeypot_capacity is not None:
            result['HoneypotCapacity'] = self.honeypot_capacity
        if self.image_scan_capacity is not None:
            result['ImageScanCapacity'] = self.image_scan_capacity
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.is_over_balance is not None:
            result['IsOverBalance'] = self.is_over_balance
        if self.is_trial_version is not None:
            result['IsTrialVersion'] = self.is_trial_version
        if self.last_trail_end_time is not None:
            result['LastTrailEndTime'] = self.last_trail_end_time
        if self.mvauth_count is not None:
            result['MVAuthCount'] = self.mvauth_count
        if self.mvunused_auth_count is not None:
            result['MVUnusedAuthCount'] = self.mvunused_auth_count
        if self.release_time is not None:
            result['ReleaseTime'] = self.release_time
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.sas_log is not None:
            result['SasLog'] = self.sas_log
        if self.sas_screen is not None:
            result['SasScreen'] = self.sas_screen
        if self.sls_capacity is not None:
            result['SlsCapacity'] = self.sls_capacity
        if self.user_defined_alarms is not None:
            result['UserDefinedAlarms'] = self.user_defined_alarms
        if self.version is not None:
            result['Version'] = self.version
        if self.vm_cores is not None:
            result['VmCores'] = self.vm_cores
        if self.web_lock is not None:
            result['WebLock'] = self.web_lock
        if self.web_lock_auth_count is not None:
            result['WebLockAuthCount'] = self.web_lock_auth_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AllowPartialBuy') is not None:
            self.allow_partial_buy = m.get('AllowPartialBuy')
        if m.get('AppWhiteList') is not None:
            self.app_white_list = m.get('AppWhiteList')
        if m.get('AppWhiteListAuthCount') is not None:
            self.app_white_list_auth_count = m.get('AppWhiteListAuthCount')
        if m.get('AssetLevel') is not None:
            self.asset_level = m.get('AssetLevel')
        if m.get('HighestVersion') is not None:
            self.highest_version = m.get('HighestVersion')
        if m.get('HoneypotCapacity') is not None:
            self.honeypot_capacity = m.get('HoneypotCapacity')
        if m.get('ImageScanCapacity') is not None:
            self.image_scan_capacity = m.get('ImageScanCapacity')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IsOverBalance') is not None:
            self.is_over_balance = m.get('IsOverBalance')
        if m.get('IsTrialVersion') is not None:
            self.is_trial_version = m.get('IsTrialVersion')
        if m.get('LastTrailEndTime') is not None:
            self.last_trail_end_time = m.get('LastTrailEndTime')
        if m.get('MVAuthCount') is not None:
            self.mvauth_count = m.get('MVAuthCount')
        if m.get('MVUnusedAuthCount') is not None:
            self.mvunused_auth_count = m.get('MVUnusedAuthCount')
        if m.get('ReleaseTime') is not None:
            self.release_time = m.get('ReleaseTime')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SasLog') is not None:
            self.sas_log = m.get('SasLog')
        if m.get('SasScreen') is not None:
            self.sas_screen = m.get('SasScreen')
        if m.get('SlsCapacity') is not None:
            self.sls_capacity = m.get('SlsCapacity')
        if m.get('UserDefinedAlarms') is not None:
            self.user_defined_alarms = m.get('UserDefinedAlarms')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        if m.get('VmCores') is not None:
            self.vm_cores = m.get('VmCores')
        if m.get('WebLock') is not None:
            self.web_lock = m.get('WebLock')
        if m.get('WebLockAuthCount') is not None:
            self.web_lock_auth_count = m.get('WebLockAuthCount')
        return self


class DescribeVersionConfigResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeVersionConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeVersionConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeVersionConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeVolDingdingMessageRequest(TeaModel):
    def __init__(self, lang=None, source_ip=None):
        self.lang = lang  # type: str
        self.source_ip = source_ip  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeVolDingdingMessageRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeVolDingdingMessageResponseBody(TeaModel):
    def __init__(self, dingding_url=None, request_id=None):
        self.dingding_url = dingding_url  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeVolDingdingMessageResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dingding_url is not None:
            result['DingdingUrl'] = self.dingding_url
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DingdingUrl') is not None:
            self.dingding_url = m.get('DingdingUrl')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeVolDingdingMessageResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeVolDingdingMessageResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeVolDingdingMessageResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeVolDingdingMessageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeVpcHoneyPotCriteriaResponseBodyCriteriaList(TeaModel):
    def __init__(self, name=None, type=None, values=None):
        self.name = name  # type: str
        self.type = type  # type: str
        self.values = values  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeVpcHoneyPotCriteriaResponseBodyCriteriaList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        if self.values is not None:
            result['Values'] = self.values
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Values') is not None:
            self.values = m.get('Values')
        return self


class DescribeVpcHoneyPotCriteriaResponseBody(TeaModel):
    def __init__(self, criteria_list=None, request_id=None):
        self.criteria_list = criteria_list  # type: list[DescribeVpcHoneyPotCriteriaResponseBodyCriteriaList]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.criteria_list:
            for k in self.criteria_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeVpcHoneyPotCriteriaResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CriteriaList'] = []
        if self.criteria_list is not None:
            for k in self.criteria_list:
                result['CriteriaList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.criteria_list = []
        if m.get('CriteriaList') is not None:
            for k in m.get('CriteriaList'):
                temp_model = DescribeVpcHoneyPotCriteriaResponseBodyCriteriaList()
                self.criteria_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeVpcHoneyPotCriteriaResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeVpcHoneyPotCriteriaResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeVpcHoneyPotCriteriaResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeVpcHoneyPotCriteriaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeVpcHoneyPotListRequest(TeaModel):
    def __init__(self, current_page=None, honey_pot_existence=None, page_size=None, vpc_id=None, vpc_name=None,
                 vpc_region_id=None):
        self.current_page = current_page  # type: int
        self.honey_pot_existence = honey_pot_existence  # type: bool
        self.page_size = page_size  # type: int
        self.vpc_id = vpc_id  # type: str
        self.vpc_name = vpc_name  # type: str
        self.vpc_region_id = vpc_region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeVpcHoneyPotListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.honey_pot_existence is not None:
            result['HoneyPotExistence'] = self.honey_pot_existence
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.vpc_name is not None:
            result['VpcName'] = self.vpc_name
        if self.vpc_region_id is not None:
            result['VpcRegionId'] = self.vpc_region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('HoneyPotExistence') is not None:
            self.honey_pot_existence = m.get('HoneyPotExistence')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('VpcName') is not None:
            self.vpc_name = m.get('VpcName')
        if m.get('VpcRegionId') is not None:
            self.vpc_region_id = m.get('VpcRegionId')
        return self


class DescribeVpcHoneyPotListResponseBodyPageInfo(TeaModel):
    def __init__(self, count=None, current_page=None, page_size=None, total_count=None):
        self.count = count  # type: int
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeVpcHoneyPotListResponseBodyPageInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeVpcHoneyPotListResponseBodyVpcHoneyPotDTOListVpcSwitchIdList(TeaModel):
    def __init__(self, vpc_switch_id=None, vpc_switch_name=None, zone_id=None):
        self.vpc_switch_id = vpc_switch_id  # type: str
        self.vpc_switch_name = vpc_switch_name  # type: str
        self.zone_id = zone_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeVpcHoneyPotListResponseBodyVpcHoneyPotDTOListVpcSwitchIdList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.vpc_switch_id is not None:
            result['VpcSwitchId'] = self.vpc_switch_id
        if self.vpc_switch_name is not None:
            result['VpcSwitchName'] = self.vpc_switch_name
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('VpcSwitchId') is not None:
            self.vpc_switch_id = m.get('VpcSwitchId')
        if m.get('VpcSwitchName') is not None:
            self.vpc_switch_name = m.get('VpcSwitchName')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeVpcHoneyPotListResponseBodyVpcHoneyPotDTOList(TeaModel):
    def __init__(self, cidr_block=None, create_time=None, honey_pot_ecs_instance_status=None,
                 honey_pot_eni_instance_id=None, honey_pot_existence=None, honey_pot_instance_status=None, honey_pot_vpc_switch_id=None,
                 vpc_id=None, vpc_name=None, vpc_region_id=None, vpc_status=None, vpc_switch_id_list=None):
        self.cidr_block = cidr_block  # type: str
        self.create_time = create_time  # type: long
        self.honey_pot_ecs_instance_status = honey_pot_ecs_instance_status  # type: str
        self.honey_pot_eni_instance_id = honey_pot_eni_instance_id  # type: str
        self.honey_pot_existence = honey_pot_existence  # type: bool
        self.honey_pot_instance_status = honey_pot_instance_status  # type: str
        self.honey_pot_vpc_switch_id = honey_pot_vpc_switch_id  # type: str
        self.vpc_id = vpc_id  # type: str
        self.vpc_name = vpc_name  # type: str
        self.vpc_region_id = vpc_region_id  # type: str
        self.vpc_status = vpc_status  # type: str
        self.vpc_switch_id_list = vpc_switch_id_list  # type: list[DescribeVpcHoneyPotListResponseBodyVpcHoneyPotDTOListVpcSwitchIdList]

    def validate(self):
        if self.vpc_switch_id_list:
            for k in self.vpc_switch_id_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeVpcHoneyPotListResponseBodyVpcHoneyPotDTOList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cidr_block is not None:
            result['CidrBlock'] = self.cidr_block
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.honey_pot_ecs_instance_status is not None:
            result['HoneyPotEcsInstanceStatus'] = self.honey_pot_ecs_instance_status
        if self.honey_pot_eni_instance_id is not None:
            result['HoneyPotEniInstanceId'] = self.honey_pot_eni_instance_id
        if self.honey_pot_existence is not None:
            result['HoneyPotExistence'] = self.honey_pot_existence
        if self.honey_pot_instance_status is not None:
            result['HoneyPotInstanceStatus'] = self.honey_pot_instance_status
        if self.honey_pot_vpc_switch_id is not None:
            result['HoneyPotVpcSwitchId'] = self.honey_pot_vpc_switch_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.vpc_name is not None:
            result['VpcName'] = self.vpc_name
        if self.vpc_region_id is not None:
            result['VpcRegionId'] = self.vpc_region_id
        if self.vpc_status is not None:
            result['VpcStatus'] = self.vpc_status
        result['VpcSwitchIdList'] = []
        if self.vpc_switch_id_list is not None:
            for k in self.vpc_switch_id_list:
                result['VpcSwitchIdList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CidrBlock') is not None:
            self.cidr_block = m.get('CidrBlock')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('HoneyPotEcsInstanceStatus') is not None:
            self.honey_pot_ecs_instance_status = m.get('HoneyPotEcsInstanceStatus')
        if m.get('HoneyPotEniInstanceId') is not None:
            self.honey_pot_eni_instance_id = m.get('HoneyPotEniInstanceId')
        if m.get('HoneyPotExistence') is not None:
            self.honey_pot_existence = m.get('HoneyPotExistence')
        if m.get('HoneyPotInstanceStatus') is not None:
            self.honey_pot_instance_status = m.get('HoneyPotInstanceStatus')
        if m.get('HoneyPotVpcSwitchId') is not None:
            self.honey_pot_vpc_switch_id = m.get('HoneyPotVpcSwitchId')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('VpcName') is not None:
            self.vpc_name = m.get('VpcName')
        if m.get('VpcRegionId') is not None:
            self.vpc_region_id = m.get('VpcRegionId')
        if m.get('VpcStatus') is not None:
            self.vpc_status = m.get('VpcStatus')
        self.vpc_switch_id_list = []
        if m.get('VpcSwitchIdList') is not None:
            for k in m.get('VpcSwitchIdList'):
                temp_model = DescribeVpcHoneyPotListResponseBodyVpcHoneyPotDTOListVpcSwitchIdList()
                self.vpc_switch_id_list.append(temp_model.from_map(k))
        return self


class DescribeVpcHoneyPotListResponseBody(TeaModel):
    def __init__(self, page_info=None, request_id=None, vpc_honey_pot_dtolist=None):
        self.page_info = page_info  # type: DescribeVpcHoneyPotListResponseBodyPageInfo
        self.request_id = request_id  # type: str
        self.vpc_honey_pot_dtolist = vpc_honey_pot_dtolist  # type: list[DescribeVpcHoneyPotListResponseBodyVpcHoneyPotDTOList]

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.vpc_honey_pot_dtolist:
            for k in self.vpc_honey_pot_dtolist:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeVpcHoneyPotListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['VpcHoneyPotDTOList'] = []
        if self.vpc_honey_pot_dtolist is not None:
            for k in self.vpc_honey_pot_dtolist:
                result['VpcHoneyPotDTOList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageInfo') is not None:
            temp_model = DescribeVpcHoneyPotListResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.vpc_honey_pot_dtolist = []
        if m.get('VpcHoneyPotDTOList') is not None:
            for k in m.get('VpcHoneyPotDTOList'):
                temp_model = DescribeVpcHoneyPotListResponseBodyVpcHoneyPotDTOList()
                self.vpc_honey_pot_dtolist.append(temp_model.from_map(k))
        return self


class DescribeVpcHoneyPotListResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeVpcHoneyPotListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeVpcHoneyPotListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeVpcHoneyPotListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeVpcListResponseBodyVpcList(TeaModel):
    def __init__(self, ecs_count=None, instance_desc=None, instance_id=None, instance_name=None, region_id=None):
        self.ecs_count = ecs_count  # type: int
        self.instance_desc = instance_desc  # type: str
        self.instance_id = instance_id  # type: str
        self.instance_name = instance_name  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeVpcListResponseBodyVpcList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ecs_count is not None:
            result['EcsCount'] = self.ecs_count
        if self.instance_desc is not None:
            result['InstanceDesc'] = self.instance_desc
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EcsCount') is not None:
            self.ecs_count = m.get('EcsCount')
        if m.get('InstanceDesc') is not None:
            self.instance_desc = m.get('InstanceDesc')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeVpcListResponseBody(TeaModel):
    def __init__(self, count=None, request_id=None, vpc_list=None):
        self.count = count  # type: int
        self.request_id = request_id  # type: str
        self.vpc_list = vpc_list  # type: list[DescribeVpcListResponseBodyVpcList]

    def validate(self):
        if self.vpc_list:
            for k in self.vpc_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeVpcListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['VpcList'] = []
        if self.vpc_list is not None:
            for k in self.vpc_list:
                result['VpcList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.vpc_list = []
        if m.get('VpcList') is not None:
            for k in m.get('VpcList'):
                temp_model = DescribeVpcListResponseBodyVpcList()
                self.vpc_list.append(temp_model.from_map(k))
        return self


class DescribeVpcListResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeVpcListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeVpcListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeVpcListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeVulDetailsRequest(TeaModel):
    def __init__(self, alias_name=None, lang=None, name=None, type=None):
        self.alias_name = alias_name  # type: str
        self.lang = lang  # type: str
        self.name = name  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeVulDetailsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeVulDetailsResponseBodyCvesClassifys(TeaModel):
    def __init__(self, classify=None, demo_video_url=None, description=None):
        self.classify = classify  # type: str
        self.demo_video_url = demo_video_url  # type: str
        self.description = description  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeVulDetailsResponseBodyCvesClassifys, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.classify is not None:
            result['Classify'] = self.classify
        if self.demo_video_url is not None:
            result['DemoVideoUrl'] = self.demo_video_url
        if self.description is not None:
            result['Description'] = self.description
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Classify') is not None:
            self.classify = m.get('Classify')
        if m.get('DemoVideoUrl') is not None:
            self.demo_video_url = m.get('DemoVideoUrl')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        return self


class DescribeVulDetailsResponseBodyCves(TeaModel):
    def __init__(self, classify=None, classifys=None, cnvd_id=None, complexity=None, content=None, cve_id=None,
                 cvss_score=None, cvss_vector=None, poc=None, poc_create_time=None, poc_disclosure_time=None, product=None,
                 reference=None, release_time=None, solution=None, summary=None, title=None, vendor=None, vul_level=None):
        self.classify = classify  # type: str
        self.classifys = classifys  # type: list[DescribeVulDetailsResponseBodyCvesClassifys]
        self.cnvd_id = cnvd_id  # type: str
        self.complexity = complexity  # type: str
        self.content = content  # type: str
        self.cve_id = cve_id  # type: str
        self.cvss_score = cvss_score  # type: str
        self.cvss_vector = cvss_vector  # type: str
        self.poc = poc  # type: str
        self.poc_create_time = poc_create_time  # type: long
        self.poc_disclosure_time = poc_disclosure_time  # type: long
        self.product = product  # type: str
        self.reference = reference  # type: str
        self.release_time = release_time  # type: long
        self.solution = solution  # type: str
        self.summary = summary  # type: str
        self.title = title  # type: str
        self.vendor = vendor  # type: str
        self.vul_level = vul_level  # type: str

    def validate(self):
        if self.classifys:
            for k in self.classifys:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeVulDetailsResponseBodyCves, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.classify is not None:
            result['Classify'] = self.classify
        result['Classifys'] = []
        if self.classifys is not None:
            for k in self.classifys:
                result['Classifys'].append(k.to_map() if k else None)
        if self.cnvd_id is not None:
            result['CnvdId'] = self.cnvd_id
        if self.complexity is not None:
            result['Complexity'] = self.complexity
        if self.content is not None:
            result['Content'] = self.content
        if self.cve_id is not None:
            result['CveId'] = self.cve_id
        if self.cvss_score is not None:
            result['CvssScore'] = self.cvss_score
        if self.cvss_vector is not None:
            result['CvssVector'] = self.cvss_vector
        if self.poc is not None:
            result['Poc'] = self.poc
        if self.poc_create_time is not None:
            result['PocCreateTime'] = self.poc_create_time
        if self.poc_disclosure_time is not None:
            result['PocDisclosureTime'] = self.poc_disclosure_time
        if self.product is not None:
            result['Product'] = self.product
        if self.reference is not None:
            result['Reference'] = self.reference
        if self.release_time is not None:
            result['ReleaseTime'] = self.release_time
        if self.solution is not None:
            result['Solution'] = self.solution
        if self.summary is not None:
            result['Summary'] = self.summary
        if self.title is not None:
            result['Title'] = self.title
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        if self.vul_level is not None:
            result['VulLevel'] = self.vul_level
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Classify') is not None:
            self.classify = m.get('Classify')
        self.classifys = []
        if m.get('Classifys') is not None:
            for k in m.get('Classifys'):
                temp_model = DescribeVulDetailsResponseBodyCvesClassifys()
                self.classifys.append(temp_model.from_map(k))
        if m.get('CnvdId') is not None:
            self.cnvd_id = m.get('CnvdId')
        if m.get('Complexity') is not None:
            self.complexity = m.get('Complexity')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('CveId') is not None:
            self.cve_id = m.get('CveId')
        if m.get('CvssScore') is not None:
            self.cvss_score = m.get('CvssScore')
        if m.get('CvssVector') is not None:
            self.cvss_vector = m.get('CvssVector')
        if m.get('Poc') is not None:
            self.poc = m.get('Poc')
        if m.get('PocCreateTime') is not None:
            self.poc_create_time = m.get('PocCreateTime')
        if m.get('PocDisclosureTime') is not None:
            self.poc_disclosure_time = m.get('PocDisclosureTime')
        if m.get('Product') is not None:
            self.product = m.get('Product')
        if m.get('Reference') is not None:
            self.reference = m.get('Reference')
        if m.get('ReleaseTime') is not None:
            self.release_time = m.get('ReleaseTime')
        if m.get('Solution') is not None:
            self.solution = m.get('Solution')
        if m.get('Summary') is not None:
            self.summary = m.get('Summary')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        if m.get('VulLevel') is not None:
            self.vul_level = m.get('VulLevel')
        return self


class DescribeVulDetailsResponseBody(TeaModel):
    def __init__(self, cves=None, request_id=None):
        self.cves = cves  # type: list[DescribeVulDetailsResponseBodyCves]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.cves:
            for k in self.cves:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeVulDetailsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Cves'] = []
        if self.cves is not None:
            for k in self.cves:
                result['Cves'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.cves = []
        if m.get('Cves') is not None:
            for k in m.get('Cves'):
                temp_model = DescribeVulDetailsResponseBodyCves()
                self.cves.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeVulDetailsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeVulDetailsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeVulDetailsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeVulDetailsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeVulExportInfoRequest(TeaModel):
    def __init__(self, export_id=None):
        self.export_id = export_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeVulExportInfoRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.export_id is not None:
            result['ExportId'] = self.export_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ExportId') is not None:
            self.export_id = m.get('ExportId')
        return self


class DescribeVulExportInfoResponseBody(TeaModel):
    def __init__(self, current_count=None, export_status=None, file_name=None, id=None, link=None, message=None,
                 progress=None, request_id=None, total_count=None):
        self.current_count = current_count  # type: int
        self.export_status = export_status  # type: str
        self.file_name = file_name  # type: str
        self.id = id  # type: long
        self.link = link  # type: str
        self.message = message  # type: str
        self.progress = progress  # type: int
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeVulExportInfoResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_count is not None:
            result['CurrentCount'] = self.current_count
        if self.export_status is not None:
            result['ExportStatus'] = self.export_status
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.id is not None:
            result['Id'] = self.id
        if self.link is not None:
            result['Link'] = self.link
        if self.message is not None:
            result['Message'] = self.message
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentCount') is not None:
            self.current_count = m.get('CurrentCount')
        if m.get('ExportStatus') is not None:
            self.export_status = m.get('ExportStatus')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Link') is not None:
            self.link = m.get('Link')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeVulExportInfoResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeVulExportInfoResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeVulExportInfoResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeVulExportInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeVulListRequest(TeaModel):
    def __init__(self, alias_name=None, attach_types=None, current_page=None, dealed=None, group_id=None, lang=None,
                 necessity=None, page_size=None, remark=None, type=None, uuids=None, vpc_instance_ids=None):
        self.alias_name = alias_name  # type: str
        self.attach_types = attach_types  # type: str
        self.current_page = current_page  # type: int
        self.dealed = dealed  # type: str
        self.group_id = group_id  # type: str
        self.lang = lang  # type: str
        self.necessity = necessity  # type: str
        self.page_size = page_size  # type: int
        self.remark = remark  # type: str
        self.type = type  # type: str
        self.uuids = uuids  # type: str
        self.vpc_instance_ids = vpc_instance_ids  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeVulListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.attach_types is not None:
            result['AttachTypes'] = self.attach_types
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dealed is not None:
            result['Dealed'] = self.dealed
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.necessity is not None:
            result['Necessity'] = self.necessity
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.type is not None:
            result['Type'] = self.type
        if self.uuids is not None:
            result['Uuids'] = self.uuids
        if self.vpc_instance_ids is not None:
            result['VpcInstanceIds'] = self.vpc_instance_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('AttachTypes') is not None:
            self.attach_types = m.get('AttachTypes')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Dealed') is not None:
            self.dealed = m.get('Dealed')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Necessity') is not None:
            self.necessity = m.get('Necessity')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Uuids') is not None:
            self.uuids = m.get('Uuids')
        if m.get('VpcInstanceIds') is not None:
            self.vpc_instance_ids = m.get('VpcInstanceIds')
        return self


class DescribeVulListResponseBodyVulRecordsExtendContentJsonNecessity(TeaModel):
    def __init__(self, assets_factor=None, cvss_factor=None, enviroment_factor=None, is_calc=None, status=None,
                 time_factor=None, total_score=None):
        self.assets_factor = assets_factor  # type: str
        self.cvss_factor = cvss_factor  # type: str
        self.enviroment_factor = enviroment_factor  # type: str
        self.is_calc = is_calc  # type: str
        self.status = status  # type: str
        self.time_factor = time_factor  # type: str
        self.total_score = total_score  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeVulListResponseBodyVulRecordsExtendContentJsonNecessity, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.assets_factor is not None:
            result['Assets_factor'] = self.assets_factor
        if self.cvss_factor is not None:
            result['Cvss_factor'] = self.cvss_factor
        if self.enviroment_factor is not None:
            result['Enviroment_factor'] = self.enviroment_factor
        if self.is_calc is not None:
            result['Is_calc'] = self.is_calc
        if self.status is not None:
            result['Status'] = self.status
        if self.time_factor is not None:
            result['Time_factor'] = self.time_factor
        if self.total_score is not None:
            result['Total_score'] = self.total_score
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Assets_factor') is not None:
            self.assets_factor = m.get('Assets_factor')
        if m.get('Cvss_factor') is not None:
            self.cvss_factor = m.get('Cvss_factor')
        if m.get('Enviroment_factor') is not None:
            self.enviroment_factor = m.get('Enviroment_factor')
        if m.get('Is_calc') is not None:
            self.is_calc = m.get('Is_calc')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Time_factor') is not None:
            self.time_factor = m.get('Time_factor')
        if m.get('Total_score') is not None:
            self.total_score = m.get('Total_score')
        return self


class DescribeVulListResponseBodyVulRecordsExtendContentJsonRpmEntityList(TeaModel):
    def __init__(self, container_name=None, full_version=None, image_name=None, match_detail=None, match_list=None,
                 name=None, path=None, pid=None, update_cmd=None, version=None):
        self.container_name = container_name  # type: str
        self.full_version = full_version  # type: str
        self.image_name = image_name  # type: str
        self.match_detail = match_detail  # type: str
        self.match_list = match_list  # type: str
        self.name = name  # type: str
        self.path = path  # type: str
        self.pid = pid  # type: str
        self.update_cmd = update_cmd  # type: str
        self.version = version  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeVulListResponseBodyVulRecordsExtendContentJsonRpmEntityList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.container_name is not None:
            result['ContainerName'] = self.container_name
        if self.full_version is not None:
            result['FullVersion'] = self.full_version
        if self.image_name is not None:
            result['ImageName'] = self.image_name
        if self.match_detail is not None:
            result['MatchDetail'] = self.match_detail
        if self.match_list is not None:
            result['MatchList'] = self.match_list
        if self.name is not None:
            result['Name'] = self.name
        if self.path is not None:
            result['Path'] = self.path
        if self.pid is not None:
            result['Pid'] = self.pid
        if self.update_cmd is not None:
            result['UpdateCmd'] = self.update_cmd
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContainerName') is not None:
            self.container_name = m.get('ContainerName')
        if m.get('FullVersion') is not None:
            self.full_version = m.get('FullVersion')
        if m.get('ImageName') is not None:
            self.image_name = m.get('ImageName')
        if m.get('MatchDetail') is not None:
            self.match_detail = m.get('MatchDetail')
        if m.get('MatchList') is not None:
            self.match_list = m.get('MatchList')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Pid') is not None:
            self.pid = m.get('Pid')
        if m.get('UpdateCmd') is not None:
            self.update_cmd = m.get('UpdateCmd')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class DescribeVulListResponseBodyVulRecordsExtendContentJson(TeaModel):
    def __init__(self, absolute_path=None, alias_name=None, description=None, ip=None, last_ts=None, necessity=None,
                 os=None, os_release=None, primary_id=None, rpm_entity_list=None, status=None, tag=None, cve_list=None):
        self.absolute_path = absolute_path  # type: str
        self.alias_name = alias_name  # type: str
        self.description = description  # type: str
        self.ip = ip  # type: str
        self.last_ts = last_ts  # type: long
        self.necessity = necessity  # type: DescribeVulListResponseBodyVulRecordsExtendContentJsonNecessity
        self.os = os  # type: str
        self.os_release = os_release  # type: str
        self.primary_id = primary_id  # type: long
        self.rpm_entity_list = rpm_entity_list  # type: list[DescribeVulListResponseBodyVulRecordsExtendContentJsonRpmEntityList]
        self.status = status  # type: str
        self.tag = tag  # type: str
        self.cve_list = cve_list  # type: list[str]

    def validate(self):
        if self.necessity:
            self.necessity.validate()
        if self.rpm_entity_list:
            for k in self.rpm_entity_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeVulListResponseBodyVulRecordsExtendContentJson, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.absolute_path is not None:
            result['AbsolutePath'] = self.absolute_path
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.description is not None:
            result['Description'] = self.description
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.last_ts is not None:
            result['LastTs'] = self.last_ts
        if self.necessity is not None:
            result['Necessity'] = self.necessity.to_map()
        if self.os is not None:
            result['Os'] = self.os
        if self.os_release is not None:
            result['OsRelease'] = self.os_release
        if self.primary_id is not None:
            result['PrimaryId'] = self.primary_id
        result['RpmEntityList'] = []
        if self.rpm_entity_list is not None:
            for k in self.rpm_entity_list:
                result['RpmEntityList'].append(k.to_map() if k else None)
        if self.status is not None:
            result['Status'] = self.status
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.cve_list is not None:
            result['cveList'] = self.cve_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AbsolutePath') is not None:
            self.absolute_path = m.get('AbsolutePath')
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('LastTs') is not None:
            self.last_ts = m.get('LastTs')
        if m.get('Necessity') is not None:
            temp_model = DescribeVulListResponseBodyVulRecordsExtendContentJsonNecessity()
            self.necessity = temp_model.from_map(m['Necessity'])
        if m.get('Os') is not None:
            self.os = m.get('Os')
        if m.get('OsRelease') is not None:
            self.os_release = m.get('OsRelease')
        if m.get('PrimaryId') is not None:
            self.primary_id = m.get('PrimaryId')
        self.rpm_entity_list = []
        if m.get('RpmEntityList') is not None:
            for k in m.get('RpmEntityList'):
                temp_model = DescribeVulListResponseBodyVulRecordsExtendContentJsonRpmEntityList()
                self.rpm_entity_list.append(temp_model.from_map(k))
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('cveList') is not None:
            self.cve_list = m.get('cveList')
        return self


class DescribeVulListResponseBodyVulRecords(TeaModel):
    def __init__(self, alias_name=None, extend_content_json=None, first_ts=None, group_id=None, instance_id=None,
                 instance_name=None, internet_ip=None, intranet_ip=None, last_ts=None, modify_ts=None, name=None, necessity=None,
                 online=None, os_version=None, primary_id=None, region_id=None, related=None, repair_ts=None,
                 result_code=None, result_message=None, status=None, tag=None, type=None, uuid=None):
        self.alias_name = alias_name  # type: str
        self.extend_content_json = extend_content_json  # type: DescribeVulListResponseBodyVulRecordsExtendContentJson
        self.first_ts = first_ts  # type: long
        self.group_id = group_id  # type: int
        self.instance_id = instance_id  # type: str
        self.instance_name = instance_name  # type: str
        self.internet_ip = internet_ip  # type: str
        self.intranet_ip = intranet_ip  # type: str
        self.last_ts = last_ts  # type: long
        self.modify_ts = modify_ts  # type: long
        self.name = name  # type: str
        self.necessity = necessity  # type: str
        self.online = online  # type: bool
        self.os_version = os_version  # type: str
        self.primary_id = primary_id  # type: long
        self.region_id = region_id  # type: str
        self.related = related  # type: str
        self.repair_ts = repair_ts  # type: long
        self.result_code = result_code  # type: str
        self.result_message = result_message  # type: str
        self.status = status  # type: int
        self.tag = tag  # type: str
        self.type = type  # type: str
        self.uuid = uuid  # type: str

    def validate(self):
        if self.extend_content_json:
            self.extend_content_json.validate()

    def to_map(self):
        _map = super(DescribeVulListResponseBodyVulRecords, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.extend_content_json is not None:
            result['ExtendContentJson'] = self.extend_content_json.to_map()
        if self.first_ts is not None:
            result['FirstTs'] = self.first_ts
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.last_ts is not None:
            result['LastTs'] = self.last_ts
        if self.modify_ts is not None:
            result['ModifyTs'] = self.modify_ts
        if self.name is not None:
            result['Name'] = self.name
        if self.necessity is not None:
            result['Necessity'] = self.necessity
        if self.online is not None:
            result['Online'] = self.online
        if self.os_version is not None:
            result['OsVersion'] = self.os_version
        if self.primary_id is not None:
            result['PrimaryId'] = self.primary_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.related is not None:
            result['Related'] = self.related
        if self.repair_ts is not None:
            result['RepairTs'] = self.repair_ts
        if self.result_code is not None:
            result['ResultCode'] = self.result_code
        if self.result_message is not None:
            result['ResultMessage'] = self.result_message
        if self.status is not None:
            result['Status'] = self.status
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.type is not None:
            result['Type'] = self.type
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('ExtendContentJson') is not None:
            temp_model = DescribeVulListResponseBodyVulRecordsExtendContentJson()
            self.extend_content_json = temp_model.from_map(m['ExtendContentJson'])
        if m.get('FirstTs') is not None:
            self.first_ts = m.get('FirstTs')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('LastTs') is not None:
            self.last_ts = m.get('LastTs')
        if m.get('ModifyTs') is not None:
            self.modify_ts = m.get('ModifyTs')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Necessity') is not None:
            self.necessity = m.get('Necessity')
        if m.get('Online') is not None:
            self.online = m.get('Online')
        if m.get('OsVersion') is not None:
            self.os_version = m.get('OsVersion')
        if m.get('PrimaryId') is not None:
            self.primary_id = m.get('PrimaryId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Related') is not None:
            self.related = m.get('Related')
        if m.get('RepairTs') is not None:
            self.repair_ts = m.get('RepairTs')
        if m.get('ResultCode') is not None:
            self.result_code = m.get('ResultCode')
        if m.get('ResultMessage') is not None:
            self.result_message = m.get('ResultMessage')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeVulListResponseBody(TeaModel):
    def __init__(self, current_page=None, page_size=None, request_id=None, total_count=None, vul_records=None):
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: int
        self.vul_records = vul_records  # type: list[DescribeVulListResponseBodyVulRecords]

    def validate(self):
        if self.vul_records:
            for k in self.vul_records:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeVulListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['VulRecords'] = []
        if self.vul_records is not None:
            for k in self.vul_records:
                result['VulRecords'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.vul_records = []
        if m.get('VulRecords') is not None:
            for k in m.get('VulRecords'):
                temp_model = DescribeVulListResponseBodyVulRecords()
                self.vul_records.append(temp_model.from_map(k))
        return self


class DescribeVulListResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeVulListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeVulListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeVulListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeVulWhitelistRequest(TeaModel):
    def __init__(self, current_page=None, page_size=None):
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeVulWhitelistRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeVulWhitelistResponseBodyVulWhitelists(TeaModel):
    def __init__(self, alias_name=None, id=None, name=None, reason=None, target_info=None, type=None):
        self.alias_name = alias_name  # type: str
        self.id = id  # type: str
        self.name = name  # type: str
        self.reason = reason  # type: str
        self.target_info = target_info  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeVulWhitelistResponseBodyVulWhitelists, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.reason is not None:
            result['Reason'] = self.reason
        if self.target_info is not None:
            result['TargetInfo'] = self.target_info
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Reason') is not None:
            self.reason = m.get('Reason')
        if m.get('TargetInfo') is not None:
            self.target_info = m.get('TargetInfo')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeVulWhitelistResponseBody(TeaModel):
    def __init__(self, current_page=None, page_size=None, request_id=None, total_count=None, vul_whitelists=None):
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: int
        self.vul_whitelists = vul_whitelists  # type: list[DescribeVulWhitelistResponseBodyVulWhitelists]

    def validate(self):
        if self.vul_whitelists:
            for k in self.vul_whitelists:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeVulWhitelistResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['VulWhitelists'] = []
        if self.vul_whitelists is not None:
            for k in self.vul_whitelists:
                result['VulWhitelists'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.vul_whitelists = []
        if m.get('VulWhitelists') is not None:
            for k in m.get('VulWhitelists'):
                temp_model = DescribeVulWhitelistResponseBodyVulWhitelists()
                self.vul_whitelists.append(temp_model.from_map(k))
        return self


class DescribeVulWhitelistResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeVulWhitelistResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeVulWhitelistResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeVulWhitelistResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeWarningMachinesRequest(TeaModel):
    def __init__(self, current_page=None, lang=None, machine_name=None, page_size=None, risk_id=None, source_ip=None,
                 strategy_id=None, uuids=None):
        self.current_page = current_page  # type: int
        self.lang = lang  # type: str
        self.machine_name = machine_name  # type: str
        self.page_size = page_size  # type: int
        self.risk_id = risk_id  # type: long
        self.source_ip = source_ip  # type: str
        self.strategy_id = strategy_id  # type: long
        self.uuids = uuids  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeWarningMachinesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.machine_name is not None:
            result['MachineName'] = self.machine_name
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.risk_id is not None:
            result['RiskId'] = self.risk_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.strategy_id is not None:
            result['StrategyId'] = self.strategy_id
        if self.uuids is not None:
            result['Uuids'] = self.uuids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('MachineName') is not None:
            self.machine_name = m.get('MachineName')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RiskId') is not None:
            self.risk_id = m.get('RiskId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('StrategyId') is not None:
            self.strategy_id = m.get('StrategyId')
        if m.get('Uuids') is not None:
            self.uuids = m.get('Uuids')
        return self


class DescribeWarningMachinesResponseBodyWarningMachines(TeaModel):
    def __init__(self, high_warning_count=None, instance_id=None, instance_name=None, internet_ip=None,
                 intranet_ip=None, low_warning_count=None, medium_warning_count=None, pass_count=None, port_open=None,
                 region_id=None, status=None, uuid=None):
        self.high_warning_count = high_warning_count  # type: int
        self.instance_id = instance_id  # type: str
        self.instance_name = instance_name  # type: str
        self.internet_ip = internet_ip  # type: str
        self.intranet_ip = intranet_ip  # type: str
        self.low_warning_count = low_warning_count  # type: int
        self.medium_warning_count = medium_warning_count  # type: int
        self.pass_count = pass_count  # type: int
        self.port_open = port_open  # type: bool
        self.region_id = region_id  # type: str
        self.status = status  # type: int
        self.uuid = uuid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeWarningMachinesResponseBodyWarningMachines, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.high_warning_count is not None:
            result['HighWarningCount'] = self.high_warning_count
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.low_warning_count is not None:
            result['LowWarningCount'] = self.low_warning_count
        if self.medium_warning_count is not None:
            result['MediumWarningCount'] = self.medium_warning_count
        if self.pass_count is not None:
            result['PassCount'] = self.pass_count
        if self.port_open is not None:
            result['PortOpen'] = self.port_open
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.status is not None:
            result['Status'] = self.status
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HighWarningCount') is not None:
            self.high_warning_count = m.get('HighWarningCount')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('LowWarningCount') is not None:
            self.low_warning_count = m.get('LowWarningCount')
        if m.get('MediumWarningCount') is not None:
            self.medium_warning_count = m.get('MediumWarningCount')
        if m.get('PassCount') is not None:
            self.pass_count = m.get('PassCount')
        if m.get('PortOpen') is not None:
            self.port_open = m.get('PortOpen')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeWarningMachinesResponseBody(TeaModel):
    def __init__(self, count=None, current_page=None, page_size=None, request_id=None, total_count=None,
                 warning_machines=None):
        self.count = count  # type: int
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: int
        self.warning_machines = warning_machines  # type: list[DescribeWarningMachinesResponseBodyWarningMachines]

    def validate(self):
        if self.warning_machines:
            for k in self.warning_machines:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeWarningMachinesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['WarningMachines'] = []
        if self.warning_machines is not None:
            for k in self.warning_machines:
                result['WarningMachines'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.warning_machines = []
        if m.get('WarningMachines') is not None:
            for k in m.get('WarningMachines'):
                temp_model = DescribeWarningMachinesResponseBodyWarningMachines()
                self.warning_machines.append(temp_model.from_map(k))
        return self


class DescribeWarningMachinesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeWarningMachinesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeWarningMachinesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeWarningMachinesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeWebLockBindListRequest(TeaModel):
    def __init__(self, current_page=None, lang=None, page_size=None, remark=None, source_ip=None, status=None):
        self.current_page = current_page  # type: int
        self.lang = lang  # type: str
        self.page_size = page_size  # type: int
        self.remark = remark  # type: str
        self.source_ip = source_ip  # type: str
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeWebLockBindListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeWebLockBindListResponseBodyBindList(TeaModel):
    def __init__(self, audit_count=None, block_count=None, dir_count=None, instance_name=None, internet_ip=None,
                 intranet_ip=None, os=None, percent=None, service_code=None, service_detail=None, service_status=None,
                 status=None, uuid=None):
        self.audit_count = audit_count  # type: str
        self.block_count = block_count  # type: str
        self.dir_count = dir_count  # type: str
        self.instance_name = instance_name  # type: str
        self.internet_ip = internet_ip  # type: str
        self.intranet_ip = intranet_ip  # type: str
        self.os = os  # type: str
        self.percent = percent  # type: int
        self.service_code = service_code  # type: str
        self.service_detail = service_detail  # type: str
        self.service_status = service_status  # type: str
        self.status = status  # type: str
        self.uuid = uuid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeWebLockBindListResponseBodyBindList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audit_count is not None:
            result['AuditCount'] = self.audit_count
        if self.block_count is not None:
            result['BlockCount'] = self.block_count
        if self.dir_count is not None:
            result['DirCount'] = self.dir_count
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.os is not None:
            result['Os'] = self.os
        if self.percent is not None:
            result['Percent'] = self.percent
        if self.service_code is not None:
            result['ServiceCode'] = self.service_code
        if self.service_detail is not None:
            result['ServiceDetail'] = self.service_detail
        if self.service_status is not None:
            result['ServiceStatus'] = self.service_status
        if self.status is not None:
            result['Status'] = self.status
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AuditCount') is not None:
            self.audit_count = m.get('AuditCount')
        if m.get('BlockCount') is not None:
            self.block_count = m.get('BlockCount')
        if m.get('DirCount') is not None:
            self.dir_count = m.get('DirCount')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('Os') is not None:
            self.os = m.get('Os')
        if m.get('Percent') is not None:
            self.percent = m.get('Percent')
        if m.get('ServiceCode') is not None:
            self.service_code = m.get('ServiceCode')
        if m.get('ServiceDetail') is not None:
            self.service_detail = m.get('ServiceDetail')
        if m.get('ServiceStatus') is not None:
            self.service_status = m.get('ServiceStatus')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeWebLockBindListResponseBody(TeaModel):
    def __init__(self, bind_list=None, current_page=None, page_size=None, request_id=None, total_count=None):
        self.bind_list = bind_list  # type: list[DescribeWebLockBindListResponseBodyBindList]
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: int

    def validate(self):
        if self.bind_list:
            for k in self.bind_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeWebLockBindListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BindList'] = []
        if self.bind_list is not None:
            for k in self.bind_list:
                result['BindList'].append(k.to_map() if k else None)
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.bind_list = []
        if m.get('BindList') is not None:
            for k in m.get('BindList'):
                temp_model = DescribeWebLockBindListResponseBodyBindList()
                self.bind_list.append(temp_model.from_map(k))
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeWebLockBindListResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeWebLockBindListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeWebLockBindListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeWebLockBindListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeWebLockConfigListRequest(TeaModel):
    def __init__(self, lang=None, source_ip=None, uuid=None):
        self.lang = lang  # type: str
        self.source_ip = source_ip  # type: str
        self.uuid = uuid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeWebLockConfigListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeWebLockConfigListResponseBodyConfigList(TeaModel):
    def __init__(self, defence_mode=None, dir=None, exclusive_dir=None, exclusive_file=None,
                 exclusive_file_type=None, id=None, inclusive_file=None, inclusive_file_type=None, local_backup_dir=None, mode=None,
                 uuid=None):
        self.defence_mode = defence_mode  # type: str
        self.dir = dir  # type: str
        self.exclusive_dir = exclusive_dir  # type: str
        self.exclusive_file = exclusive_file  # type: str
        self.exclusive_file_type = exclusive_file_type  # type: str
        self.id = id  # type: str
        self.inclusive_file = inclusive_file  # type: str
        self.inclusive_file_type = inclusive_file_type  # type: str
        self.local_backup_dir = local_backup_dir  # type: str
        self.mode = mode  # type: str
        self.uuid = uuid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeWebLockConfigListResponseBodyConfigList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.defence_mode is not None:
            result['DefenceMode'] = self.defence_mode
        if self.dir is not None:
            result['Dir'] = self.dir
        if self.exclusive_dir is not None:
            result['ExclusiveDir'] = self.exclusive_dir
        if self.exclusive_file is not None:
            result['ExclusiveFile'] = self.exclusive_file
        if self.exclusive_file_type is not None:
            result['ExclusiveFileType'] = self.exclusive_file_type
        if self.id is not None:
            result['Id'] = self.id
        if self.inclusive_file is not None:
            result['InclusiveFile'] = self.inclusive_file
        if self.inclusive_file_type is not None:
            result['InclusiveFileType'] = self.inclusive_file_type
        if self.local_backup_dir is not None:
            result['LocalBackupDir'] = self.local_backup_dir
        if self.mode is not None:
            result['Mode'] = self.mode
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DefenceMode') is not None:
            self.defence_mode = m.get('DefenceMode')
        if m.get('Dir') is not None:
            self.dir = m.get('Dir')
        if m.get('ExclusiveDir') is not None:
            self.exclusive_dir = m.get('ExclusiveDir')
        if m.get('ExclusiveFile') is not None:
            self.exclusive_file = m.get('ExclusiveFile')
        if m.get('ExclusiveFileType') is not None:
            self.exclusive_file_type = m.get('ExclusiveFileType')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('InclusiveFile') is not None:
            self.inclusive_file = m.get('InclusiveFile')
        if m.get('InclusiveFileType') is not None:
            self.inclusive_file_type = m.get('InclusiveFileType')
        if m.get('LocalBackupDir') is not None:
            self.local_backup_dir = m.get('LocalBackupDir')
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeWebLockConfigListResponseBody(TeaModel):
    def __init__(self, config_list=None, request_id=None, total_count=None):
        self.config_list = config_list  # type: list[DescribeWebLockConfigListResponseBodyConfigList]
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: int

    def validate(self):
        if self.config_list:
            for k in self.config_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeWebLockConfigListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ConfigList'] = []
        if self.config_list is not None:
            for k in self.config_list:
                result['ConfigList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.config_list = []
        if m.get('ConfigList') is not None:
            for k in m.get('ConfigList'):
                temp_model = DescribeWebLockConfigListResponseBodyConfigList()
                self.config_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeWebLockConfigListResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeWebLockConfigListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeWebLockConfigListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeWebLockConfigListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ExportRecordRequest(TeaModel):
    def __init__(self, export_type=None, lang=None, params=None):
        self.export_type = export_type  # type: str
        self.lang = lang  # type: str
        self.params = params  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ExportRecordRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.export_type is not None:
            result['ExportType'] = self.export_type
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.params is not None:
            result['Params'] = self.params
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ExportType') is not None:
            self.export_type = m.get('ExportType')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        return self


class ExportRecordResponseBody(TeaModel):
    def __init__(self, file_name=None, id=None, request_id=None):
        self.file_name = file_name  # type: str
        self.id = id  # type: long
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ExportRecordResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.id is not None:
            result['Id'] = self.id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ExportRecordResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ExportRecordResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ExportRecordResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ExportRecordResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ExportVulRequest(TeaModel):
    def __init__(self, alias_name=None, attach_types=None, dealed=None, group_id=None, lang=None, necessity=None,
                 search_tags=None, type=None, uuids=None, vpc_instance_ids=None):
        self.alias_name = alias_name  # type: str
        self.attach_types = attach_types  # type: str
        self.dealed = dealed  # type: str
        self.group_id = group_id  # type: str
        self.lang = lang  # type: str
        self.necessity = necessity  # type: str
        self.search_tags = search_tags  # type: str
        self.type = type  # type: str
        self.uuids = uuids  # type: str
        self.vpc_instance_ids = vpc_instance_ids  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ExportVulRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.attach_types is not None:
            result['AttachTypes'] = self.attach_types
        if self.dealed is not None:
            result['Dealed'] = self.dealed
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.necessity is not None:
            result['Necessity'] = self.necessity
        if self.search_tags is not None:
            result['SearchTags'] = self.search_tags
        if self.type is not None:
            result['Type'] = self.type
        if self.uuids is not None:
            result['Uuids'] = self.uuids
        if self.vpc_instance_ids is not None:
            result['VpcInstanceIds'] = self.vpc_instance_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('AttachTypes') is not None:
            self.attach_types = m.get('AttachTypes')
        if m.get('Dealed') is not None:
            self.dealed = m.get('Dealed')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Necessity') is not None:
            self.necessity = m.get('Necessity')
        if m.get('SearchTags') is not None:
            self.search_tags = m.get('SearchTags')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Uuids') is not None:
            self.uuids = m.get('Uuids')
        if m.get('VpcInstanceIds') is not None:
            self.vpc_instance_ids = m.get('VpcInstanceIds')
        return self


class ExportVulResponseBody(TeaModel):
    def __init__(self, file_name=None, id=None, request_id=None):
        self.file_name = file_name  # type: str
        self.id = id  # type: long
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ExportVulResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.id is not None:
            result['Id'] = self.id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ExportVulResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ExportVulResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ExportVulResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ExportVulResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class FixCheckWarningsRequest(TeaModel):
    def __init__(self, check_params=None, lang=None, risk_id=None, source_ip=None, uuids=None):
        self.check_params = check_params  # type: str
        self.lang = lang  # type: str
        self.risk_id = risk_id  # type: long
        self.source_ip = source_ip  # type: str
        self.uuids = uuids  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FixCheckWarningsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_params is not None:
            result['CheckParams'] = self.check_params
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.risk_id is not None:
            result['RiskId'] = self.risk_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.uuids is not None:
            result['Uuids'] = self.uuids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CheckParams') is not None:
            self.check_params = m.get('CheckParams')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('RiskId') is not None:
            self.risk_id = m.get('RiskId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Uuids') is not None:
            self.uuids = m.get('Uuids')
        return self


class FixCheckWarningsResponseBody(TeaModel):
    def __init__(self, batch_id=None, request_id=None):
        self.batch_id = batch_id  # type: long
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FixCheckWarningsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.batch_id is not None:
            result['BatchId'] = self.batch_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BatchId') is not None:
            self.batch_id = m.get('BatchId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class FixCheckWarningsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: FixCheckWarningsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(FixCheckWarningsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = FixCheckWarningsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetBackupStorageCountResponseBodyBackupStorageCount(TeaModel):
    def __init__(self, buy_storage_byte=None, ecs_usage_storage_byte=None, overflow=None,
                 uni_usage_storage_byte=None, usage_storage_byte=None):
        self.buy_storage_byte = buy_storage_byte  # type: long
        self.ecs_usage_storage_byte = ecs_usage_storage_byte  # type: long
        self.overflow = overflow  # type: int
        self.uni_usage_storage_byte = uni_usage_storage_byte  # type: long
        self.usage_storage_byte = usage_storage_byte  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetBackupStorageCountResponseBodyBackupStorageCount, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.buy_storage_byte is not None:
            result['BuyStorageByte'] = self.buy_storage_byte
        if self.ecs_usage_storage_byte is not None:
            result['EcsUsageStorageByte'] = self.ecs_usage_storage_byte
        if self.overflow is not None:
            result['Overflow'] = self.overflow
        if self.uni_usage_storage_byte is not None:
            result['UniUsageStorageByte'] = self.uni_usage_storage_byte
        if self.usage_storage_byte is not None:
            result['UsageStorageByte'] = self.usage_storage_byte
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BuyStorageByte') is not None:
            self.buy_storage_byte = m.get('BuyStorageByte')
        if m.get('EcsUsageStorageByte') is not None:
            self.ecs_usage_storage_byte = m.get('EcsUsageStorageByte')
        if m.get('Overflow') is not None:
            self.overflow = m.get('Overflow')
        if m.get('UniUsageStorageByte') is not None:
            self.uni_usage_storage_byte = m.get('UniUsageStorageByte')
        if m.get('UsageStorageByte') is not None:
            self.usage_storage_byte = m.get('UsageStorageByte')
        return self


class GetBackupStorageCountResponseBody(TeaModel):
    def __init__(self, backup_storage_count=None, request_id=None):
        self.backup_storage_count = backup_storage_count  # type: GetBackupStorageCountResponseBodyBackupStorageCount
        self.request_id = request_id  # type: str

    def validate(self):
        if self.backup_storage_count:
            self.backup_storage_count.validate()

    def to_map(self):
        _map = super(GetBackupStorageCountResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_storage_count is not None:
            result['BackupStorageCount'] = self.backup_storage_count.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BackupStorageCount') is not None:
            temp_model = GetBackupStorageCountResponseBodyBackupStorageCount()
            self.backup_storage_count = temp_model.from_map(m['BackupStorageCount'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetBackupStorageCountResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetBackupStorageCountResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetBackupStorageCountResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetBackupStorageCountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSuspiciousStatisticsRequest(TeaModel):
    def __init__(self, group_id_list=None, source_ip=None):
        self.group_id_list = group_id_list  # type: str
        self.source_ip = source_ip  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSuspiciousStatisticsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id_list is not None:
            result['GroupIdList'] = self.group_id_list
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupIdList') is not None:
            self.group_id_list = m.get('GroupIdList')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class GetSuspiciousStatisticsResponseBody(TeaModel):
    def __init__(self, remind_count=None, request_id=None, serious_count=None, suspicious_count=None,
                 total_count=None):
        self.remind_count = remind_count  # type: int
        self.request_id = request_id  # type: str
        self.serious_count = serious_count  # type: int
        self.suspicious_count = suspicious_count  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSuspiciousStatisticsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.remind_count is not None:
            result['RemindCount'] = self.remind_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.serious_count is not None:
            result['SeriousCount'] = self.serious_count
        if self.suspicious_count is not None:
            result['SuspiciousCount'] = self.suspicious_count
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RemindCount') is not None:
            self.remind_count = m.get('RemindCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SeriousCount') is not None:
            self.serious_count = m.get('SeriousCount')
        if m.get('SuspiciousCount') is not None:
            self.suspicious_count = m.get('SuspiciousCount')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class GetSuspiciousStatisticsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetSuspiciousStatisticsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetSuspiciousStatisticsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetSuspiciousStatisticsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetVulStatisticsRequest(TeaModel):
    def __init__(self, group_id_list=None, source_ip=None, type_list=None):
        self.group_id_list = group_id_list  # type: str
        self.source_ip = source_ip  # type: str
        self.type_list = type_list  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetVulStatisticsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id_list is not None:
            result['GroupIdList'] = self.group_id_list
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.type_list is not None:
            result['TypeList'] = self.type_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupIdList') is not None:
            self.group_id_list = m.get('GroupIdList')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('TypeList') is not None:
            self.type_list = m.get('TypeList')
        return self


class GetVulStatisticsResponseBody(TeaModel):
    def __init__(self, request_id=None, vul_asap_sum=None, vul_later_sum=None, vul_nntf_sum=None):
        self.request_id = request_id  # type: str
        self.vul_asap_sum = vul_asap_sum  # type: int
        self.vul_later_sum = vul_later_sum  # type: int
        self.vul_nntf_sum = vul_nntf_sum  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetVulStatisticsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.vul_asap_sum is not None:
            result['VulAsapSum'] = self.vul_asap_sum
        if self.vul_later_sum is not None:
            result['VulLaterSum'] = self.vul_later_sum
        if self.vul_nntf_sum is not None:
            result['VulNntfSum'] = self.vul_nntf_sum
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('VulAsapSum') is not None:
            self.vul_asap_sum = m.get('VulAsapSum')
        if m.get('VulLaterSum') is not None:
            self.vul_later_sum = m.get('VulLaterSum')
        if m.get('VulNntfSum') is not None:
            self.vul_nntf_sum = m.get('VulNntfSum')
        return self


class GetVulStatisticsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetVulStatisticsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetVulStatisticsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetVulStatisticsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class HandleSecurityEventsRequest(TeaModel):
    def __init__(self, mark_batch=None, mark_miss_param=None, operation_code=None, operation_params=None,
                 security_event_ids=None, source_ip=None):
        self.mark_batch = mark_batch  # type: str
        self.mark_miss_param = mark_miss_param  # type: str
        self.operation_code = operation_code  # type: str
        self.operation_params = operation_params  # type: str
        self.security_event_ids = security_event_ids  # type: list[str]
        self.source_ip = source_ip  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(HandleSecurityEventsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.mark_batch is not None:
            result['MarkBatch'] = self.mark_batch
        if self.mark_miss_param is not None:
            result['MarkMissParam'] = self.mark_miss_param
        if self.operation_code is not None:
            result['OperationCode'] = self.operation_code
        if self.operation_params is not None:
            result['OperationParams'] = self.operation_params
        if self.security_event_ids is not None:
            result['SecurityEventIds'] = self.security_event_ids
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MarkBatch') is not None:
            self.mark_batch = m.get('MarkBatch')
        if m.get('MarkMissParam') is not None:
            self.mark_miss_param = m.get('MarkMissParam')
        if m.get('OperationCode') is not None:
            self.operation_code = m.get('OperationCode')
        if m.get('OperationParams') is not None:
            self.operation_params = m.get('OperationParams')
        if m.get('SecurityEventIds') is not None:
            self.security_event_ids = m.get('SecurityEventIds')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class HandleSecurityEventsResponseBodyHandleSecurityEventsResponse(TeaModel):
    def __init__(self, task_id=None):
        self.task_id = task_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(HandleSecurityEventsResponseBodyHandleSecurityEventsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class HandleSecurityEventsResponseBody(TeaModel):
    def __init__(self, handle_security_events_response=None, request_id=None):
        self.handle_security_events_response = handle_security_events_response  # type: HandleSecurityEventsResponseBodyHandleSecurityEventsResponse
        self.request_id = request_id  # type: str

    def validate(self):
        if self.handle_security_events_response:
            self.handle_security_events_response.validate()

    def to_map(self):
        _map = super(HandleSecurityEventsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.handle_security_events_response is not None:
            result['HandleSecurityEventsResponse'] = self.handle_security_events_response.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HandleSecurityEventsResponse') is not None:
            temp_model = HandleSecurityEventsResponseBodyHandleSecurityEventsResponse()
            self.handle_security_events_response = temp_model.from_map(m['HandleSecurityEventsResponse'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class HandleSecurityEventsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: HandleSecurityEventsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(HandleSecurityEventsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = HandleSecurityEventsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class HandleSimilarSecurityEventsRequest(TeaModel):
    def __init__(self, mark_miss_param=None, operation_code=None, operation_params=None, resource_owner_id=None,
                 source_ip=None, task_id=None):
        self.mark_miss_param = mark_miss_param  # type: str
        self.operation_code = operation_code  # type: str
        self.operation_params = operation_params  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.source_ip = source_ip  # type: str
        self.task_id = task_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(HandleSimilarSecurityEventsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.mark_miss_param is not None:
            result['MarkMissParam'] = self.mark_miss_param
        if self.operation_code is not None:
            result['OperationCode'] = self.operation_code
        if self.operation_params is not None:
            result['OperationParams'] = self.operation_params
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MarkMissParam') is not None:
            self.mark_miss_param = m.get('MarkMissParam')
        if m.get('OperationCode') is not None:
            self.operation_code = m.get('OperationCode')
        if m.get('OperationParams') is not None:
            self.operation_params = m.get('OperationParams')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class HandleSimilarSecurityEventsResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(HandleSimilarSecurityEventsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class HandleSimilarSecurityEventsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: HandleSimilarSecurityEventsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(HandleSimilarSecurityEventsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = HandleSimilarSecurityEventsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class IgnoreHcCheckWarningsRequest(TeaModel):
    def __init__(self, check_ids=None, check_warning_ids=None, reason=None, risk_id=None, source_ip=None, type=None):
        self.check_ids = check_ids  # type: str
        self.check_warning_ids = check_warning_ids  # type: str
        self.reason = reason  # type: str
        self.risk_id = risk_id  # type: str
        self.source_ip = source_ip  # type: str
        self.type = type  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(IgnoreHcCheckWarningsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_ids is not None:
            result['CheckIds'] = self.check_ids
        if self.check_warning_ids is not None:
            result['CheckWarningIds'] = self.check_warning_ids
        if self.reason is not None:
            result['Reason'] = self.reason
        if self.risk_id is not None:
            result['RiskId'] = self.risk_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CheckIds') is not None:
            self.check_ids = m.get('CheckIds')
        if m.get('CheckWarningIds') is not None:
            self.check_warning_ids = m.get('CheckWarningIds')
        if m.get('Reason') is not None:
            self.reason = m.get('Reason')
        if m.get('RiskId') is not None:
            self.risk_id = m.get('RiskId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class IgnoreHcCheckWarningsResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(IgnoreHcCheckWarningsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class IgnoreHcCheckWarningsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: IgnoreHcCheckWarningsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(IgnoreHcCheckWarningsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = IgnoreHcCheckWarningsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class InstallBackupClientRequest(TeaModel):
    def __init__(self, policy_version=None, uuid=None, uuid_list=None):
        self.policy_version = policy_version  # type: str
        self.uuid = uuid  # type: str
        self.uuid_list = uuid_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(InstallBackupClientRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_version is not None:
            result['PolicyVersion'] = self.policy_version
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.uuid_list is not None:
            result['UuidList'] = self.uuid_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PolicyVersion') is not None:
            self.policy_version = m.get('PolicyVersion')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('UuidList') is not None:
            self.uuid_list = m.get('UuidList')
        return self


class InstallBackupClientResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(InstallBackupClientResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class InstallBackupClientResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: InstallBackupClientResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(InstallBackupClientResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = InstallBackupClientResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyAntiBruteForceRuleRequest(TeaModel):
    def __init__(self, default_rule=None, fail_count=None, forbidden_time=None, id=None, name=None,
                 resource_owner_id=None, source_ip=None, span=None, uuid_list=None):
        self.default_rule = default_rule  # type: bool
        self.fail_count = fail_count  # type: int
        self.forbidden_time = forbidden_time  # type: int
        self.id = id  # type: long
        self.name = name  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.source_ip = source_ip  # type: str
        self.span = span  # type: int
        self.uuid_list = uuid_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyAntiBruteForceRuleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.default_rule is not None:
            result['DefaultRule'] = self.default_rule
        if self.fail_count is not None:
            result['FailCount'] = self.fail_count
        if self.forbidden_time is not None:
            result['ForbiddenTime'] = self.forbidden_time
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.span is not None:
            result['Span'] = self.span
        if self.uuid_list is not None:
            result['UuidList'] = self.uuid_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DefaultRule') is not None:
            self.default_rule = m.get('DefaultRule')
        if m.get('FailCount') is not None:
            self.fail_count = m.get('FailCount')
        if m.get('ForbiddenTime') is not None:
            self.forbidden_time = m.get('ForbiddenTime')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Span') is not None:
            self.span = m.get('Span')
        if m.get('UuidList') is not None:
            self.uuid_list = m.get('UuidList')
        return self


class ModifyAntiBruteForceRuleResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyAntiBruteForceRuleResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyAntiBruteForceRuleResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ModifyAntiBruteForceRuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ModifyAntiBruteForceRuleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyAntiBruteForceRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyAssetGroupRequest(TeaModel):
    def __init__(self, group_id=None, source_ip=None, uuids=None):
        self.group_id = group_id  # type: long
        self.source_ip = source_ip  # type: str
        self.uuids = uuids  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyAssetGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.uuids is not None:
            result['Uuids'] = self.uuids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Uuids') is not None:
            self.uuids = m.get('Uuids')
        return self


class ModifyAssetGroupResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyAssetGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyAssetGroupResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ModifyAssetGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ModifyAssetGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyAssetGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyBackupPolicyRequest(TeaModel):
    def __init__(self, id=None, name=None, policy=None, policy_region_id=None, policy_version=None, uuid_list=None):
        self.id = id  # type: long
        self.name = name  # type: str
        self.policy = policy  # type: dict[str, any]
        self.policy_region_id = policy_region_id  # type: str
        self.policy_version = policy_version  # type: str
        self.uuid_list = uuid_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyBackupPolicyRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.policy_region_id is not None:
            result['PolicyRegionId'] = self.policy_region_id
        if self.policy_version is not None:
            result['PolicyVersion'] = self.policy_version
        if self.uuid_list is not None:
            result['UuidList'] = self.uuid_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('PolicyRegionId') is not None:
            self.policy_region_id = m.get('PolicyRegionId')
        if m.get('PolicyVersion') is not None:
            self.policy_version = m.get('PolicyVersion')
        if m.get('UuidList') is not None:
            self.uuid_list = m.get('UuidList')
        return self


class ModifyBackupPolicyShrinkRequest(TeaModel):
    def __init__(self, id=None, name=None, policy_shrink=None, policy_region_id=None, policy_version=None,
                 uuid_list=None):
        self.id = id  # type: long
        self.name = name  # type: str
        self.policy_shrink = policy_shrink  # type: str
        self.policy_region_id = policy_region_id  # type: str
        self.policy_version = policy_version  # type: str
        self.uuid_list = uuid_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyBackupPolicyShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.policy_shrink is not None:
            result['Policy'] = self.policy_shrink
        if self.policy_region_id is not None:
            result['PolicyRegionId'] = self.policy_region_id
        if self.policy_version is not None:
            result['PolicyVersion'] = self.policy_version
        if self.uuid_list is not None:
            result['UuidList'] = self.uuid_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Policy') is not None:
            self.policy_shrink = m.get('Policy')
        if m.get('PolicyRegionId') is not None:
            self.policy_region_id = m.get('PolicyRegionId')
        if m.get('PolicyVersion') is not None:
            self.policy_version = m.get('PolicyVersion')
        if m.get('UuidList') is not None:
            self.uuid_list = m.get('UuidList')
        return self


class ModifyBackupPolicyResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyBackupPolicyResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyBackupPolicyResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ModifyBackupPolicyResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ModifyBackupPolicyResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyBackupPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyBackupPolicyStatusRequest(TeaModel):
    def __init__(self, id=None, policy_version=None, status=None):
        self.id = id  # type: long
        self.policy_version = policy_version  # type: str
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyBackupPolicyStatusRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.policy_version is not None:
            result['PolicyVersion'] = self.policy_version
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('PolicyVersion') is not None:
            self.policy_version = m.get('PolicyVersion')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ModifyBackupPolicyStatusResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyBackupPolicyStatusResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyBackupPolicyStatusResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ModifyBackupPolicyStatusResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ModifyBackupPolicyStatusResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyBackupPolicyStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyCreateVulWhitelistRequest(TeaModel):
    def __init__(self, reason=None, target_info=None, whitelist=None):
        self.reason = reason  # type: str
        self.target_info = target_info  # type: str
        self.whitelist = whitelist  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyCreateVulWhitelistRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.reason is not None:
            result['Reason'] = self.reason
        if self.target_info is not None:
            result['TargetInfo'] = self.target_info
        if self.whitelist is not None:
            result['Whitelist'] = self.whitelist
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Reason') is not None:
            self.reason = m.get('Reason')
        if m.get('TargetInfo') is not None:
            self.target_info = m.get('TargetInfo')
        if m.get('Whitelist') is not None:
            self.whitelist = m.get('Whitelist')
        return self


class ModifyCreateVulWhitelistResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyCreateVulWhitelistResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyCreateVulWhitelistResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ModifyCreateVulWhitelistResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ModifyCreateVulWhitelistResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyCreateVulWhitelistResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyEmgVulSubmitRequest(TeaModel):
    def __init__(self, lang=None, name=None, user_agreement=None):
        self.lang = lang  # type: str
        self.name = name  # type: str
        self.user_agreement = user_agreement  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyEmgVulSubmitRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.name is not None:
            result['Name'] = self.name
        if self.user_agreement is not None:
            result['UserAgreement'] = self.user_agreement
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('UserAgreement') is not None:
            self.user_agreement = m.get('UserAgreement')
        return self


class ModifyEmgVulSubmitResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyEmgVulSubmitResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyEmgVulSubmitResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ModifyEmgVulSubmitResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ModifyEmgVulSubmitResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyEmgVulSubmitResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyGroupPropertyRequest(TeaModel):
    def __init__(self, data=None):
        self.data = data  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyGroupPropertyRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class ModifyGroupPropertyResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyGroupPropertyResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyGroupPropertyResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ModifyGroupPropertyResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ModifyGroupPropertyResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyGroupPropertyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyInstanceAntiBruteForceRuleRequest(TeaModel):
    def __init__(self, new_rule_id=None, resource_owner_id=None, source_ip=None, uuid=None):
        self.new_rule_id = new_rule_id  # type: long
        self.resource_owner_id = resource_owner_id  # type: long
        self.source_ip = source_ip  # type: str
        self.uuid = uuid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyInstanceAntiBruteForceRuleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.new_rule_id is not None:
            result['NewRuleId'] = self.new_rule_id
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NewRuleId') is not None:
            self.new_rule_id = m.get('NewRuleId')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class ModifyInstanceAntiBruteForceRuleResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyInstanceAntiBruteForceRuleResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyInstanceAntiBruteForceRuleResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ModifyInstanceAntiBruteForceRuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ModifyInstanceAntiBruteForceRuleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyInstanceAntiBruteForceRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyLoginBaseConfigRequest(TeaModel):
    def __init__(self, config=None, target=None, type=None):
        self.config = config  # type: str
        self.target = target  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyLoginBaseConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config is not None:
            result['Config'] = self.config
        if self.target is not None:
            result['Target'] = self.target
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Config') is not None:
            self.config = m.get('Config')
        if m.get('Target') is not None:
            self.target = m.get('Target')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ModifyLoginBaseConfigResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyLoginBaseConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyLoginBaseConfigResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ModifyLoginBaseConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ModifyLoginBaseConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyLoginBaseConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyLoginSwitchConfigRequest(TeaModel):
    def __init__(self, item=None, status=None):
        self.item = item  # type: str
        self.status = status  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyLoginSwitchConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.item is not None:
            result['Item'] = self.item
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Item') is not None:
            self.item = m.get('Item')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ModifyLoginSwitchConfigResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyLoginSwitchConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyLoginSwitchConfigResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ModifyLoginSwitchConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ModifyLoginSwitchConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyLoginSwitchConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyOpenLogShipperRequest(TeaModel):
    def __init__(self, from_=None):
        self.from_ = from_  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyOpenLogShipperRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.from_ is not None:
            result['From'] = self.from_
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('From') is not None:
            self.from_ = m.get('From')
        return self


class ModifyOpenLogShipperResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyOpenLogShipperResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyOpenLogShipperResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ModifyOpenLogShipperResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ModifyOpenLogShipperResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyOpenLogShipperResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyOperateVulRequest(TeaModel):
    def __init__(self, info=None, operate_type=None, reason=None, type=None):
        self.info = info  # type: str
        self.operate_type = operate_type  # type: str
        self.reason = reason  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyOperateVulRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.info is not None:
            result['Info'] = self.info
        if self.operate_type is not None:
            result['OperateType'] = self.operate_type
        if self.reason is not None:
            result['Reason'] = self.reason
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Info') is not None:
            self.info = m.get('Info')
        if m.get('OperateType') is not None:
            self.operate_type = m.get('OperateType')
        if m.get('Reason') is not None:
            self.reason = m.get('Reason')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ModifyOperateVulResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyOperateVulResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyOperateVulResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ModifyOperateVulResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ModifyOperateVulResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyOperateVulResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyPushAllTaskRequest(TeaModel):
    def __init__(self, source_ip=None, tasks=None, uuids=None):
        self.source_ip = source_ip  # type: str
        self.tasks = tasks  # type: str
        self.uuids = uuids  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyPushAllTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.tasks is not None:
            result['Tasks'] = self.tasks
        if self.uuids is not None:
            result['Uuids'] = self.uuids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Tasks') is not None:
            self.tasks = m.get('Tasks')
        if m.get('Uuids') is not None:
            self.uuids = m.get('Uuids')
        return self


class ModifyPushAllTaskResponseBodyPushTaskRspPushTaskResultList(TeaModel):
    def __init__(self, group_id=None, instance_id=None, instance_name=None, ip=None, message=None, online=None,
                 os_version=None, region=None, success=None, uuid=None):
        self.group_id = group_id  # type: long
        self.instance_id = instance_id  # type: str
        self.instance_name = instance_name  # type: str
        self.ip = ip  # type: str
        self.message = message  # type: str
        self.online = online  # type: bool
        self.os_version = os_version  # type: str
        self.region = region  # type: str
        self.success = success  # type: bool
        self.uuid = uuid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyPushAllTaskResponseBodyPushTaskRspPushTaskResultList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.message is not None:
            result['Message'] = self.message
        if self.online is not None:
            result['Online'] = self.online
        if self.os_version is not None:
            result['OsVersion'] = self.os_version
        if self.region is not None:
            result['Region'] = self.region
        if self.success is not None:
            result['Success'] = self.success
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Online') is not None:
            self.online = m.get('Online')
        if m.get('OsVersion') is not None:
            self.os_version = m.get('OsVersion')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class ModifyPushAllTaskResponseBodyPushTaskRsp(TeaModel):
    def __init__(self, push_task_result_list=None):
        self.push_task_result_list = push_task_result_list  # type: list[ModifyPushAllTaskResponseBodyPushTaskRspPushTaskResultList]

    def validate(self):
        if self.push_task_result_list:
            for k in self.push_task_result_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ModifyPushAllTaskResponseBodyPushTaskRsp, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['PushTaskResultList'] = []
        if self.push_task_result_list is not None:
            for k in self.push_task_result_list:
                result['PushTaskResultList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.push_task_result_list = []
        if m.get('PushTaskResultList') is not None:
            for k in m.get('PushTaskResultList'):
                temp_model = ModifyPushAllTaskResponseBodyPushTaskRspPushTaskResultList()
                self.push_task_result_list.append(temp_model.from_map(k))
        return self


class ModifyPushAllTaskResponseBody(TeaModel):
    def __init__(self, push_task_rsp=None, request_id=None):
        self.push_task_rsp = push_task_rsp  # type: ModifyPushAllTaskResponseBodyPushTaskRsp
        self.request_id = request_id  # type: str

    def validate(self):
        if self.push_task_rsp:
            self.push_task_rsp.validate()

    def to_map(self):
        _map = super(ModifyPushAllTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.push_task_rsp is not None:
            result['PushTaskRsp'] = self.push_task_rsp.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PushTaskRsp') is not None:
            temp_model = ModifyPushAllTaskResponseBodyPushTaskRsp()
            self.push_task_rsp = temp_model.from_map(m['PushTaskRsp'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyPushAllTaskResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ModifyPushAllTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ModifyPushAllTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyPushAllTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyRiskCheckStatusRequest(TeaModel):
    def __init__(self, item_id=None, lang=None, resource_owner_id=None, source_ip=None, status=None, task_id=None):
        self.item_id = item_id  # type: long
        self.lang = lang  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.source_ip = source_ip  # type: str
        self.status = status  # type: str
        self.task_id = task_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyRiskCheckStatusRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.item_id is not None:
            result['ItemId'] = self.item_id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.status is not None:
            result['Status'] = self.status
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ItemId') is not None:
            self.item_id = m.get('ItemId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class ModifyRiskCheckStatusResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyRiskCheckStatusResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyRiskCheckStatusResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ModifyRiskCheckStatusResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ModifyRiskCheckStatusResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyRiskCheckStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyRiskSingleResultStatusRequest(TeaModel):
    def __init__(self, ids=None, lang=None, resource_owner_id=None, source_ip=None, status=None, task_id=None):
        self.ids = ids  # type: list[str]
        self.lang = lang  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.source_ip = source_ip  # type: str
        self.status = status  # type: str
        self.task_id = task_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyRiskSingleResultStatusRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ids is not None:
            result['Ids'] = self.ids
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.status is not None:
            result['Status'] = self.status
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Ids') is not None:
            self.ids = m.get('Ids')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class ModifyRiskSingleResultStatusResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyRiskSingleResultStatusResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyRiskSingleResultStatusResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ModifyRiskSingleResultStatusResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ModifyRiskSingleResultStatusResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyRiskSingleResultStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifySecurityCheckScheduleConfigRequest(TeaModel):
    def __init__(self, days_of_week=None, end_time=None, lang=None, resource_owner_id=None, source_ip=None,
                 start_time=None):
        self.days_of_week = days_of_week  # type: str
        self.end_time = end_time  # type: int
        self.lang = lang  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.source_ip = source_ip  # type: str
        self.start_time = start_time  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifySecurityCheckScheduleConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.days_of_week is not None:
            result['DaysOfWeek'] = self.days_of_week
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DaysOfWeek') is not None:
            self.days_of_week = m.get('DaysOfWeek')
        if m.get('EndTime') is