"""
This type stub file was generated by pyright.
"""

class Bunch(dict):
    """Container object exposing keys as attributes.

    Bunch objects are sometimes used as an output for functions and methods.
    They extend dictionaries by enabling values to be accessed by key,
    `bunch["value_key"]`, or by an attribute, `bunch.value_key`.

    Examples
    --------
    >>> from sklearn.utils import Bunch
    >>> b = Bunch(a=1, b=2)
    >>> b['b']
    2
    >>> b.b
    2
    >>> b.a = 3
    >>> b['a']
    3
    >>> b.c = 6
    >>> b['c']
    6
    """
    def __init__(self, **kwargs) -> None:
        ...
    
    def __setattr__(self, key, value): # -> None:
        ...
    
    def __dir__(self): # -> dict_keys[Unknown, Unknown]:
        ...
    
    def __getattr__(self, key):
        ...
    
    def __setstate__(self, state): # -> None:
        ...
    


