"""
This type stub file was generated by pyright.
"""

from ..base import TransformerMixin

"""
Feature agglomeration. Base classes and functions for performing feature
agglomeration.
"""
class AgglomerationTransform(TransformerMixin):
    """
    A class for feature agglomeration via the transform interface.
    """
    def transform(self, X): # -> NDArray[float64] | NDArray[Unknown]:
        """
        Transform a new matrix using the built clustering.

        Parameters
        ----------
        X : array-like of shape (n_samples, n_features) or \
                (n_samples, n_samples)
            A M by N array of M observations in N dimensions or a length
            M array of M one-dimensional observations.

        Returns
        -------
        Y : ndarray of shape (n_samples, n_clusters) or (n_clusters,)
            The pooled values for each feature cluster.
        """
        ...
    
    def inverse_transform(self, Xred):
        """
        Inverse the transformation and return a vector of size `n_features`.

        Parameters
        ----------
        Xred : array-like of shape (n_samples, n_clusters) or (n_clusters,)
            The values to be assigned to each cluster of samples.

        Returns
        -------
        X : ndarray of shape (n_samples, n_features) or (n_features,)
            A vector of size `n_samples` with the values of `Xred` assigned to
            each of the cluster of samples.
        """
        ...
    


