"""
This type stub file was generated by pyright.
"""

import logging
from typing import Optional

""" Logging utilities. """
log_levels = ...
_default_log_level = ...
def get_logger(name: Optional[str] = ...) -> logging.Logger:
    """Return a logger with the specified name.
    This function can be used in dataset and metrics scripts.
    """
    ...

def get_verbosity() -> int:
    """Return the current level for the HuggingFace datasets library's root logger.
    Returns:
        Logging level, e.g., ``evaluate.logging.DEBUG`` and ``evaluate.logging.INFO``.

    <Tip>

        HuggingFace datasets library has following logging levels:
        - `evaluate.logging.CRITICAL`, `evaluate.logging.FATAL`
        - `evaluate.logging.ERROR`
        - `evaluate.logging.WARNING`, `evaluate.logging.WARN`
        - `evaluate.logging.INFO`
        - `evaluate.logging.DEBUG`

    </Tip>
    """
    ...

def set_verbosity(verbosity: int) -> None:
    """Set the level for the HuggingFace datasets library's root logger.
    Args:
        verbosity:
            Logging level, e.g., ``evaluate.logging.DEBUG`` and ``evaluate.logging.INFO``.
    """
    ...

def set_verbosity_info(): # -> None:
    """Set the level for the HuggingFace datasets library's root logger to INFO.

    This will display most of the logging information and tqdm bars.

    Shortcut to ``evaluate.logging.set_verbosity(evaluate.logging.INFO)``
    """
    ...

def set_verbosity_warning(): # -> None:
    """Set the level for the HuggingFace datasets library's root logger to WARNING.

    This will display only the warning and errors logging information and tqdm bars.

    Shortcut to ``evaluate.logging.set_verbosity(evaluate.logging.WARNING)``
    """
    ...

def set_verbosity_debug(): # -> None:
    """Set the level for the HuggingFace datasets library's root logger to DEBUG.

    This will display all the logging information and tqdm bars.

    Shortcut to ``evaluate.logging.set_verbosity(evaluate.logging.DEBUG)``
    """
    ...

def set_verbosity_error(): # -> None:
    """Set the level for the HuggingFace datasets library's root logger to ERROR.

    This will display only the errors logging information and tqdm bars.

    Shortcut to ``evaluate.logging.set_verbosity(evaluate.logging.ERROR)``
    """
    ...

def disable_propagation() -> None:
    """Disable propagation of the library log outputs.
    Note that log propagation is disabled by default.
    """
    ...

def enable_propagation() -> None:
    """Enable propagation of the library log outputs.
    Please disable the HuggingFace datasets library's default handler to prevent double logging if the root logger has
    been configured.
    """
    ...

class EmptyTqdm:
    """Dummy tqdm which doesn't do anything."""
    def __init__(self, *args, **kwargs) -> None:
        ...
    
    def __iter__(self):
        ...
    
    def __getattr__(self, _): # -> (*args: Unknown, **kwargs: Unknown) -> None:
        """Return empty function."""
        ...
    
    def __enter__(self): # -> Self@EmptyTqdm:
        ...
    
    def __exit__(self, type_, value, traceback): # -> None:
        ...
    


_tqdm_active = ...
class _tqdm_cls:
    def __call__(self, *args, **kwargs): # -> tqdm | EmptyTqdm:
        ...
    
    def set_lock(self, *args, **kwargs): # -> None:
        ...
    
    def get_lock(self): # -> TqdmDefaultWriteLock | None:
        ...
    


tqdm = ...
def is_progress_bar_enabled() -> bool:
    """Return a boolean indicating whether tqdm progress bars are enabled."""
    ...

def enable_progress_bar(): # -> None:
    """Enable tqdm progress bar."""
    ...

def disable_progress_bar(): # -> None:
    """Enable tqdm progress bar."""
    ...

