"""
This type stub file was generated by pyright.
"""

from dataclasses import dataclass
from typing import List, Optional, Union
from datasets.features import Features

""" EvaluationModuleInfo records information we know about a dataset and a metric.
"""
logger = ...
@dataclass
class EvaluationModuleInfo:
    """Information about a metric.

    `EvaluationModuleInfo` documents a metric, including its name, version, and features.
    See the constructor arguments and properties for a full list.

    Note: Not all fields are known on construction and may be updated later.
    """
    description: str
    citation: str
    features: Union[Features, List[Features]]
    inputs_description: str = ...
    homepage: str = ...
    license: str = ...
    codebase_urls: List[str] = ...
    reference_urls: List[str] = ...
    streamable: bool = ...
    format: Optional[str] = ...
    module_type: str = ...
    metric_name: Optional[str] = ...
    config_name: Optional[str] = ...
    experiment_id: Optional[str] = ...
    def __post_init__(self): # -> None:
        ...
    
    def write_to_directory(self, metric_info_dir): # -> None:
        """Write `EvaluationModuleInfo` as JSON to `metric_info_dir`.
        Also save the license separately in LICENCE.
        """
        ...
    
    @classmethod
    def from_directory(cls, metric_info_dir) -> EvaluationModuleInfo:
        """Create EvaluationModuleInfo from the JSON file in `metric_info_dir`.

        Args:
            metric_info_dir: `str` The directory containing the metadata file. This
                should be the root directory of a specific dataset version.
        """
        ...
    
    @classmethod
    def from_dict(cls, metric_info_dict: dict) -> EvaluationModuleInfo:
        ...
    


