# coding: utf-8

"""
    Patch API V2

    The core API used to integrate with Patch's service  # noqa: E501

    The version of the OpenAPI document: 2
    Contact: engineering@usepatch.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from patch_api.exceptions import ApiTypeError, ApiValueError


class OrderLineItemsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    ALLOWED_QUERY_PARAMS = [
        "mass_g",
        "total_price_cents_usd",
        "project_id",
        "page",
        "distance_m",
        "transportation_method",
        "package_mass_g",
        "create_order",
        "model",
        "make",
        "year",
        "transaction_value_btc_sats",
        "transaction_value_eth_gwei",
        "gas_used",
        "average_daily_balance_btc_sats",
        "average_daily_balance_eth_gwei",
        "timestamp",
        "origin_airport",
        "destination_airport",
        "aircraft_code",
        "cabin_class",
        "passenger_count",
        "state",
        "country_code",
        "city",
        "region",
        "star_rating",
        "number_of_nights",
        "number_of_rooms",
        "vintage_year",
        "total_price",
        "currency",
        "amount",
        "unit",
        "issued_to",
        "cargo_type",
        "container_size_code",
        "destination_country_code",
        "destination_locode",
        "destination_postal_code",
        "emissions_scope",
        "freight_mass_g",
        "freight_volume_cubic_m",
        "fuel_type",
        "number_of_containers",
        "origin_country_code",
        "origin_locode",
        "origin_postal_code",
        "truck_weight_t",
        "vessel_imo",
    ]

    def __init__(self, api_client=None):
        self.api_client = api_client

    def create_order_line_item(
        self, order_id={}, create_order_line_item_request={}, **kwargs
    ):  # noqa: E501
        """Creates an order line item  # noqa: E501

        Creates a line item on an order that is in the `draft` state.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_order_line_item(order_id, create_order_line_item_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str order_id: (required)
        :param CreateOrderLineItemRequest create_order_line_item_request: (required)
        :param int patch_version:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OrderLineItemResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.create_order_line_item_with_http_info(
            order_id, create_order_line_item_request, **kwargs
        )  # noqa: E501

    def create_order_line_item_with_http_info(
        self, order_id, create_order_line_item_request, **kwargs
    ):  # noqa: E501
        """Creates an order line item  # noqa: E501

        Creates a line item on an order that is in the `draft` state.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_order_line_item_with_http_info(order_id, create_order_line_item_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str order_id: (required)
        :param CreateOrderLineItemRequest create_order_line_item_request: (required)
        :param int patch_version:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OrderLineItemResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            "order_id",
            "create_order_line_item_request",
            "patch_version",
        ]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")
        all_params.append("mass_g")
        all_params.append("total_price_cents_usd")
        all_params.append("project_id")
        all_params.append("metadata")
        all_params.append("distance_m")
        all_params.append("transportation_method")
        all_params.append("package_mass_g")
        all_params.append("create_order")
        all_params.append("make")
        all_params.append("model")
        all_params.append("year")
        all_params.append("transaction_value_btc_sats")
        all_params.append("transaction_value_eth_gwei")
        all_params.append("gas_used")
        all_params.append("transaction_value_btc_sats")
        all_params.append("average_daily_balance_btc_sats")
        all_params.append("average_daily_balance_eth_gwei")
        all_params.append("timestamp")
        all_params.append("origin_airport")
        all_params.append("destination_airport")
        all_params.append("aircraft_code")
        all_params.append("cabin_class")
        all_params.append("passenger_count")
        all_params.append("state")
        all_params.append("country_code")
        all_params.append("city")
        all_params.append("region")
        all_params.append("star_rating")
        all_params.append("number_of_nights")
        all_params.append("number_of_rooms")
        all_params.append("vintage_year")
        all_params.append("total_price")
        all_params.append("currency")
        all_params.append("amount")
        all_params.append("unit")
        all_params.append("issued_to")
        all_params.append("cargo_type")
        all_params.append("container_size_code")
        all_params.append("destination_country_code")
        all_params.append("destination_locode")
        all_params.append("destination_postal_code")
        all_params.append("emissions_scope")
        all_params.append("freight_mass_g")
        all_params.append("freight_volume_cubic_m")
        all_params.append("fuel_type")
        all_params.append("number_of_containers")
        all_params.append("origin_country_code")
        all_params.append("origin_locode")
        all_params.append("origin_postal_code")
        all_params.append("truck_weight_t")
        all_params.append("vessel_imo")

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_order_line_item" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'order_id' is set
        if "order_id" not in local_var_params or local_var_params["order_id"] is None:
            raise ApiValueError(
                "Missing the required parameter `order_id` when calling `create_order_line_item`"
            )  # noqa: E501
        # verify the required parameter 'create_order_line_item_request' is set
        if (
            "create_order_line_item_request" not in local_var_params
            or local_var_params["create_order_line_item_request"] is None
        ):
            raise ApiValueError(
                "Missing the required parameter `create_order_line_item_request` when calling `create_order_line_item`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "order_id" in local_var_params:
            path_params["order_id"] = local_var_params["order_id"]  # noqa: E501

        query_params = []

        # do not add duplicate keys to query_params list
        existing_keys = []
        for param in query_params:
            existing_keys.append(param[0])

        for key in kwargs:
            if key not in existing_keys:
                query_params.append([key, kwargs.get(key)])

        header_params = {}
        if "patch_version" in local_var_params:
            header_params["Patch-Version"] = local_var_params[
                "patch_version"
            ]  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if "create_order_line_item_request" in local_var_params:
            body_params = local_var_params["create_order_line_item_request"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["bearer_auth"]  # noqa: E501

        return self.api_client.call_api(
            "/v1/orders/{order_id}/line_items",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="OrderLineItemResponse",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def delete_order_line_item(
        self, order_id={}, serial_number={}, **kwargs
    ):  # noqa: E501
        """Deletes an order line item  # noqa: E501

        Deletes a line item on an order that is in the `draft` state.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_order_line_item(order_id, serial_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str order_id: (required)
        :param str serial_number: (required)
        :param int patch_version:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DeleteOrderResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.delete_order_line_item_with_http_info(
            order_id, serial_number, **kwargs
        )  # noqa: E501

    def delete_order_line_item_with_http_info(
        self, order_id, serial_number, **kwargs
    ):  # noqa: E501
        """Deletes an order line item  # noqa: E501

        Deletes a line item on an order that is in the `draft` state.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_order_line_item_with_http_info(order_id, serial_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str order_id: (required)
        :param str serial_number: (required)
        :param int patch_version:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DeleteOrderResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["order_id", "serial_number", "patch_version"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")
        all_params.append("mass_g")
        all_params.append("total_price_cents_usd")
        all_params.append("project_id")
        all_params.append("metadata")
        all_params.append("distance_m")
        all_params.append("transportation_method")
        all_params.append("package_mass_g")
        all_params.append("create_order")
        all_params.append("make")
        all_params.append("model")
        all_params.append("year")
        all_params.append("transaction_value_btc_sats")
        all_params.append("transaction_value_eth_gwei")
        all_params.append("gas_used")
        all_params.append("transaction_value_btc_sats")
        all_params.append("average_daily_balance_btc_sats")
        all_params.append("average_daily_balance_eth_gwei")
        all_params.append("timestamp")
        all_params.append("origin_airport")
        all_params.append("destination_airport")
        all_params.append("aircraft_code")
        all_params.append("cabin_class")
        all_params.append("passenger_count")
        all_params.append("state")
        all_params.append("country_code")
        all_params.append("city")
        all_params.append("region")
        all_params.append("star_rating")
        all_params.append("number_of_nights")
        all_params.append("number_of_rooms")
        all_params.append("vintage_year")
        all_params.append("total_price")
        all_params.append("currency")
        all_params.append("amount")
        all_params.append("unit")
        all_params.append("issued_to")
        all_params.append("cargo_type")
        all_params.append("container_size_code")
        all_params.append("destination_country_code")
        all_params.append("destination_locode")
        all_params.append("destination_postal_code")
        all_params.append("emissions_scope")
        all_params.append("freight_mass_g")
        all_params.append("freight_volume_cubic_m")
        all_params.append("fuel_type")
        all_params.append("number_of_containers")
        all_params.append("origin_country_code")
        all_params.append("origin_locode")
        all_params.append("origin_postal_code")
        all_params.append("truck_weight_t")
        all_params.append("vessel_imo")

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_order_line_item" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'order_id' is set
        if "order_id" not in local_var_params or local_var_params["order_id"] is None:
            raise ApiValueError(
                "Missing the required parameter `order_id` when calling `delete_order_line_item`"
            )  # noqa: E501
        # verify the required parameter 'serial_number' is set
        if (
            "serial_number" not in local_var_params
            or local_var_params["serial_number"] is None
        ):
            raise ApiValueError(
                "Missing the required parameter `serial_number` when calling `delete_order_line_item`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "order_id" in local_var_params:
            path_params["order_id"] = local_var_params["order_id"]  # noqa: E501
        if "serial_number" in local_var_params:
            path_params["serial_number"] = local_var_params[
                "serial_number"
            ]  # noqa: E501

        query_params = []

        # do not add duplicate keys to query_params list
        existing_keys = []
        for param in query_params:
            existing_keys.append(param[0])

        for key in kwargs:
            if key not in existing_keys:
                query_params.append([key, kwargs.get(key)])

        header_params = {}
        if "patch_version" in local_var_params:
            header_params["Patch-Version"] = local_var_params[
                "patch_version"
            ]  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["bearer_auth"]  # noqa: E501

        return self.api_client.call_api(
            "/v1/orders/{order_id}/line_items/{serial_number}",
            "DELETE",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="DeleteOrderResponse",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def update_order_line_item(
        self, order_id={}, serial_number={}, update_order_line_item_request={}, **kwargs
    ):  # noqa: E501
        """Updates an order line item  # noqa: E501

        Updates a line item on an order that is in the `draft` state.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_order_line_item(order_id, serial_number, update_order_line_item_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str order_id: (required)
        :param str serial_number: (required)
        :param UpdateOrderLineItemRequest update_order_line_item_request: (required)
        :param int patch_version:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OrderLineItemResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.update_order_line_item_with_http_info(
            order_id, serial_number, update_order_line_item_request, **kwargs
        )  # noqa: E501

    def update_order_line_item_with_http_info(
        self, order_id, serial_number, update_order_line_item_request, **kwargs
    ):  # noqa: E501
        """Updates an order line item  # noqa: E501

        Updates a line item on an order that is in the `draft` state.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_order_line_item_with_http_info(order_id, serial_number, update_order_line_item_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str order_id: (required)
        :param str serial_number: (required)
        :param UpdateOrderLineItemRequest update_order_line_item_request: (required)
        :param int patch_version:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OrderLineItemResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            "order_id",
            "serial_number",
            "update_order_line_item_request",
            "patch_version",
        ]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")
        all_params.append("mass_g")
        all_params.append("total_price_cents_usd")
        all_params.append("project_id")
        all_params.append("metadata")
        all_params.append("distance_m")
        all_params.append("transportation_method")
        all_params.append("package_mass_g")
        all_params.append("create_order")
        all_params.append("make")
        all_params.append("model")
        all_params.append("year")
        all_params.append("transaction_value_btc_sats")
        all_params.append("transaction_value_eth_gwei")
        all_params.append("gas_used")
        all_params.append("transaction_value_btc_sats")
        all_params.append("average_daily_balance_btc_sats")
        all_params.append("average_daily_balance_eth_gwei")
        all_params.append("timestamp")
        all_params.append("origin_airport")
        all_params.append("destination_airport")
        all_params.append("aircraft_code")
        all_params.append("cabin_class")
        all_params.append("passenger_count")
        all_params.append("state")
        all_params.append("country_code")
        all_params.append("city")
        all_params.append("region")
        all_params.append("star_rating")
        all_params.append("number_of_nights")
        all_params.append("number_of_rooms")
        all_params.append("vintage_year")
        all_params.append("total_price")
        all_params.append("currency")
        all_params.append("amount")
        all_params.append("unit")
        all_params.append("issued_to")
        all_params.append("cargo_type")
        all_params.append("container_size_code")
        all_params.append("destination_country_code")
        all_params.append("destination_locode")
        all_params.append("destination_postal_code")
        all_params.append("emissions_scope")
        all_params.append("freight_mass_g")
        all_params.append("freight_volume_cubic_m")
        all_params.append("fuel_type")
        all_params.append("number_of_containers")
        all_params.append("origin_country_code")
        all_params.append("origin_locode")
        all_params.append("origin_postal_code")
        all_params.append("truck_weight_t")
        all_params.append("vessel_imo")

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_order_line_item" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'order_id' is set
        if "order_id" not in local_var_params or local_var_params["order_id"] is None:
            raise ApiValueError(
                "Missing the required parameter `order_id` when calling `update_order_line_item`"
            )  # noqa: E501
        # verify the required parameter 'serial_number' is set
        if (
            "serial_number" not in local_var_params
            or local_var_params["serial_number"] is None
        ):
            raise ApiValueError(
                "Missing the required parameter `serial_number` when calling `update_order_line_item`"
            )  # noqa: E501
        # verify the required parameter 'update_order_line_item_request' is set
        if (
            "update_order_line_item_request" not in local_var_params
            or local_var_params["update_order_line_item_request"] is None
        ):
            raise ApiValueError(
                "Missing the required parameter `update_order_line_item_request` when calling `update_order_line_item`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "order_id" in local_var_params:
            path_params["order_id"] = local_var_params["order_id"]  # noqa: E501
        if "serial_number" in local_var_params:
            path_params["serial_number"] = local_var_params[
                "serial_number"
            ]  # noqa: E501

        query_params = []

        # do not add duplicate keys to query_params list
        existing_keys = []
        for param in query_params:
            existing_keys.append(param[0])

        for key in kwargs:
            if key not in existing_keys:
                query_params.append([key, kwargs.get(key)])

        header_params = {}
        if "patch_version" in local_var_params:
            header_params["Patch-Version"] = local_var_params[
                "patch_version"
            ]  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if "update_order_line_item_request" in local_var_params:
            body_params = local_var_params["update_order_line_item_request"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["bearer_auth"]  # noqa: E501

        return self.api_client.call_api(
            "/v1/orders/{order_id}/line_items/{serial_number}",
            "PATCH",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="OrderLineItemResponse",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )
