/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
import { Project, ProjectOptions } from "projen";
import { DocumentationFormatConfig } from "../client-config";
import { DocumentationFormat } from "../languages";
import { GeneratedHtml2Docs } from "./components/docs/generated-html2-docs";
import { GeneratedMarkdownDocs } from "./components/docs/generated-markdown-docs";
import { GeneratedPlantUmlDocs } from "./components/docs/generated-plantuml-docs";
/**
 * Configuration for the OpenAPI docs project
 */
export interface DocsProjectOptions extends ProjectOptions {
    /**
     * The absolute path to the OpenAPI specification (spec.yaml) from which to generate docs
     */
    readonly specPath: string;
    /**
     * The formats to generate documentation in
     */
    readonly formatConfigs: DocumentationFormatConfig[];
}
/**
 * Project containing generated OpenApi docs
 */
export declare class DocsProject extends Project {
    constructor(options: DocsProjectOptions);
    /**
     * Generates the docs in the given format
     */
    generateDocs(format: DocumentationFormat, specPath: string): GeneratedHtml2Docs | GeneratedMarkdownDocs | GeneratedPlantUmlDocs;
}
