/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.ifsupport;

import com.teradata.jdbc.ComUtil;
import com.teradata.jdbc.jdbc_4.ifsupport.ConvertNoArgScalarFunction;
import com.teradata.jdbc.jdbc_4.ifsupport.EscapeConverter;
import com.teradata.jdbc.jdbc_4.ifsupport.EscapeStringUtil;
import com.teradata.jdbc.jdbc_4.ifsupport.LocalEscapeFunctions;
import com.teradata.jdbc.jdbc_4.ifsupport.ManageEscapeState;
import com.teradata.jdbc.jdbc_4.parcel.ConfigRspParcel;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class EscapeUtil {
    private static Map sm_mapEscFuncNameToClass = EscapeUtil.initClassTable();
    static /* synthetic */ Class class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertDateTimeLiterals;
    static /* synthetic */ Class class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction;
    static /* synthetic */ Class class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction;
    static /* synthetic */ Class class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertSplitScalarFunction;
    static /* synthetic */ Class class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertSwitchArgsScalarFunction;
    static /* synthetic */ Class class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertSubStringScalarFunction;
    static /* synthetic */ Class class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertTimestampAddScalarFunction;
    static /* synthetic */ Class class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertTimestampDiffScalarFunction;
    static /* synthetic */ Class class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertIfNullScalarFunction;
    static /* synthetic */ Class class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertCastScalarFunction;
    static /* synthetic */ Class class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertExtraTextScalarFunction;

    public static String nativeSQL(String string, LocalEscapeFunctions localEscapeFunctions) throws SQLException {
        return EscapeUtil.nativeSQL(string, true, localEscapeFunctions, null);
    }

    public static String nativeSQL(String string, boolean bl, LocalEscapeFunctions localEscapeFunctions, Map map) throws SQLException {
        if (map != null) {
            map.clear();
        }
        if (string == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ395", "null");
        }
        string = ComUtil.remLineFeeds(string);
        string = string.trim();
        if (bl) {
            string = EscapeUtil.processString(string, localEscapeFunctions, map);
        }
        return string;
    }

    private static String processScalarFunction(StringTokenizer stringTokenizer, String string, LocalEscapeFunctions localEscapeFunctions, Map map) throws SQLException {
        String string2 = null;
        ManageEscapeState manageEscapeState = new ManageEscapeState();
        CommentContext commentContext = new CommentContext();
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (EscapeUtil.ignore(string3, manageEscapeState, commentContext)) continue;
            string2 = EscapeUtil.callEscapeInterface(string3, stringTokenizer, true, string, localEscapeFunctions, map);
            break;
        }
        if (string2 == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ383");
        }
        return EscapeUtil.restoreComments(string2, commentContext);
    }

    private static String convertToNativeSql(String string, String string2, LocalEscapeFunctions localEscapeFunctions, Map map) throws SQLException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\"'(), \t\n\r\f/*-", true);
        ManageEscapeState manageEscapeState = new ManageEscapeState();
        CommentContext commentContext = new CommentContext();
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (EscapeUtil.ignore(string3, manageEscapeState, commentContext)) continue;
            if ("FN".equals(string3.toUpperCase())) {
                string = EscapeUtil.processScalarFunction(stringTokenizer, string2, localEscapeFunctions, map);
                break;
            }
            string = EscapeUtil.callEscapeInterface(string3, stringTokenizer, false, string2, localEscapeFunctions, map);
            break;
        }
        return EscapeUtil.restoreComments(string, commentContext);
    }

    private static String processString(String string, LocalEscapeFunctions localEscapeFunctions, Map map) throws SQLException {
        int n;
        String string2 = string;
        int n2 = ComUtil.lastIndexOf(string2, "{");
        if (n2 == -1 && (n = ComUtil.indexOf(string2, "}", n2)) != -1) {
            throw ErrorFactory.makeDriverJDBCException("TJ384");
        }
        while (n2 != -1) {
            n = ComUtil.indexOf(string2, "}", n2);
            if (n == -1) {
                throw ErrorFactory.makeDriverJDBCException("TJ384");
            }
            String string3 = string2.substring(n2 + 1, n);
            string3 = EscapeUtil.convertToNativeSql(string3, string, localEscapeFunctions, map);
            boolean bl = n2 == 0 && n + "}".length() == string2.length();
            string2 = EscapeStringUtil.replace(n2, n, string2, string3);
            if (bl) break;
            n2 = ComUtil.lastIndexOf(string2, "{");
        }
        return string2;
    }

    private static String callEscapeInterface(String string, StringTokenizer stringTokenizer, boolean bl, String string2, LocalEscapeFunctions localEscapeFunctions, Map map) throws SQLException {
        string = string.toUpperCase();
        Class clazz = (Class)sm_mapEscFuncNameToClass.get(string);
        int n = localEscapeFunctions.getTeradataDatabaseVersionNumber();
        if (clazz != null && n >= 1510 && "RIGHT".equals(string)) {
            clazz = null;
        }
        ConfigRspParcel configRspParcel = localEscapeFunctions.getConfigResponse();
        if (clazz != null && configRspParcel != null && configRspParcel.getODBCScalarFunctionLevel() >= 2) {
            if ("CURDATE".equals(string) || "CURTIME".equals(string) || "NOW".equals(string)) {
                return ConvertNoArgScalarFunction.createNativeSQL(string, string + "()", stringTokenizer);
            }
            if ("CONCAT".equals(string) || "DAYOFMONTH".equals(string) || "HOUR".equals(string) || "LEFT".equals(string) || "LENGTH".equals(string) || "LOCATE".equals(string) || "LTRIM".equals(string) || "MINUTE".equals(string) || "MOD".equals(string) || "MONTH".equals(string) || "RTRIM".equals(string) || "SECOND".equals(string) || "SUBSTRING".equals(string) || "UCASE".equals(string) || "YEAR".equals(string)) {
                clazz = null;
            }
        }
        if (clazz != null) {
            Object var9_9 = null;
            try {
                var9_9 = clazz.newInstance();
            }
            catch (Exception exception) {
                SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ157", clazz.getName());
                sQLException.initCause(exception);
                throw sQLException;
            }
            EscapeConverter escapeConverter = var9_9;
            return escapeConverter.processTokens(string, stringTokenizer, localEscapeFunctions, map);
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (bl || "ESCAPE".equals(string) || "CALL".equals(string)) {
            stringBuffer.append(string);
        } else if (!"OJ".equals(string)) {
            throw ErrorFactory.makeDriverJDBCException("TJ385", string2);
        }
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(stringTokenizer.nextToken());
        }
        String string3 = stringBuffer.toString();
        if ("CALL".equals(string) && ComUtil.lastIndexOf(string3, ")") == -1) {
            if (string3.endsWith(";")) {
                string3 = string3.substring(0, string3.length() - 1);
            }
            string3 = string3 + "()";
        }
        return string3;
    }

    private static Map initClassTable() {
        LinkedHashMap<String, Class> linkedHashMap = new LinkedHashMap<String, Class>();
        linkedHashMap.put("T", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertDateTimeLiterals == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertDateTimeLiterals = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertDateTimeLiterals")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertDateTimeLiterals);
        linkedHashMap.put("D", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertDateTimeLiterals == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertDateTimeLiterals = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertDateTimeLiterals")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertDateTimeLiterals);
        linkedHashMap.put("TS", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertDateTimeLiterals == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertDateTimeLiterals = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertDateTimeLiterals")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertDateTimeLiterals);
        linkedHashMap.put("SECOND", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction);
        linkedHashMap.put("PI", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertNoArgScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction);
        linkedHashMap.put("MOD", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertSplitScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertSplitScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertSplitScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertSplitScalarFunction);
        linkedHashMap.put("LENGTH", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction);
        linkedHashMap.put("LOCATE", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertSwitchArgsScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertSwitchArgsScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertSwitchArgsScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertSwitchArgsScalarFunction);
        linkedHashMap.put("ATAN2", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertSwitchArgsScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertSwitchArgsScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertSwitchArgsScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertSwitchArgsScalarFunction);
        linkedHashMap.put("LTRIM", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction);
        linkedHashMap.put("RTRIM", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction);
        linkedHashMap.put("LCASE", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction);
        linkedHashMap.put("UCASE", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction);
        linkedHashMap.put("SUBSTRING", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertSubStringScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertSubStringScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertSubStringScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertSubStringScalarFunction);
        linkedHashMap.put("CONCAT", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertSplitScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertSplitScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertSplitScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertSplitScalarFunction);
        linkedHashMap.put("CURDATE", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertNoArgScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction);
        linkedHashMap.put("CURTIME", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertNoArgScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction);
        linkedHashMap.put("NOW", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertNoArgScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction);
        linkedHashMap.put("MINUTE", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction);
        linkedHashMap.put("HOUR", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction);
        linkedHashMap.put("DAYOFMONTH", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction);
        linkedHashMap.put("MONTH", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction);
        linkedHashMap.put("YEAR", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction);
        linkedHashMap.put("TIMESTAMPADD", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertTimestampAddScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertTimestampAddScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertTimestampAddScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertTimestampAddScalarFunction);
        linkedHashMap.put("TIMESTAMPDIFF", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertTimestampDiffScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertTimestampDiffScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertTimestampDiffScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertTimestampDiffScalarFunction);
        linkedHashMap.put("DATABASE", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertNoArgScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction);
        linkedHashMap.put("USER", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertNoArgScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction);
        linkedHashMap.put("IFNULL", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertIfNullScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertIfNullScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertIfNullScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertIfNullScalarFunction);
        linkedHashMap.put("CONVERT", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertCastScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertCastScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertCastScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertCastScalarFunction);
        linkedHashMap.put("TERADATA_LOGON_SEQUENCE_NUMBER", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertNoArgScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction);
        linkedHashMap.put("TERADATA_AMP_COUNT", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertNoArgScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction);
        linkedHashMap.put("TERADATA_GETLOGLEVEL", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertNoArgScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction);
        linkedHashMap.put("TERADATA_SETLOGLEVEL", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction);
        linkedHashMap.put("TERADATA_PROVIDE", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction);
        linkedHashMap.put("TERADATA_USEANSIDATE", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertNoArgScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction);
        linkedHashMap.put("TERADATA_USEINTEGERDATE", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertNoArgScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction);
        linkedHashMap.put("TERADATA_SESSION_NUMBER", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertNoArgScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction);
        linkedHashMap.put("TERADATA_SOCKET_INFO", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertNoArgScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction);
        linkedHashMap.put("TERADATA_UNTRUSTED", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertNoArgScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction);
        linkedHashMap.put("TERADATA_NOPREPARE", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertNoArgScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction);
        linkedHashMap.put("TERADATA_FAILFAST", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertNoArgScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction);
        linkedHashMap.put("TERADATA_CALL_PARAM_RS", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertNoArgScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction);
        linkedHashMap.put("TERADATA_AUTO_OUT_PARAM", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertNoArgScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction);
        linkedHashMap.put("LOG", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction);
        linkedHashMap.put("CHAR", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction);
        linkedHashMap.put("COT", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction);
        linkedHashMap.put("CURRENT_DATE", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertNoArgScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction);
        linkedHashMap.put("CURRENT_TIME", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertNoArgScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction);
        linkedHashMap.put("CURRENT_TIMESTAMP", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertNoArgScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction);
        linkedHashMap.put("DIFFERENCE", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertExtraTextScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertExtraTextScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertExtraTextScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertExtraTextScalarFunction);
        linkedHashMap.put("INSERT", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction);
        linkedHashMap.put("LEFT", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertExtraTextScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertExtraTextScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertExtraTextScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertExtraTextScalarFunction);
        linkedHashMap.put("LOG10", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction);
        linkedHashMap.put("RAND", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction);
        linkedHashMap.put("REPEAT", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction);
        linkedHashMap.put("REPLACE", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction);
        linkedHashMap.put("RIGHT", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction);
        linkedHashMap.put("SPACE", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction);
        linkedHashMap.put("TRUNCATE", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction);
        return linkedHashMap;
    }

    private static boolean ignore(String string, ManageEscapeState manageEscapeState, CommentContext commentContext) throws SQLException {
        if (" \t\n\r\f".indexOf(string) != -1) {
            return true;
        }
        boolean bl = true;
        manageEscapeState.setManageEscapeState(string, bl);
        if (!manageEscapeState.inEscapeState() && "/-".indexOf(string) != -1) {
            commentContext.lastToken = string;
            commentContext.commentBuffer = new StringBuffer(string);
            return true;
        }
        if (!manageEscapeState.inEscapeState() && commentContext.lastToken != null) {
            throw ErrorFactory.makeDriverJDBCException("TJ385", commentContext.lastToken);
        }
        commentContext.lastToken = null;
        if (manageEscapeState.inEscapeState()) {
            commentContext.commentBuffer.append(string);
        }
        return manageEscapeState.inEscapeState();
    }

    private static String restoreComments(String string, CommentContext commentContext) {
        if (commentContext.commentBuffer != null) {
            string = commentContext.commentBuffer + " " + string;
            commentContext.commentBuffer = null;
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class CommentContext {
        public String lastToken = null;
        public StringBuffer commentBuffer = null;

        private CommentContext() {
        }
    }
}

