/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc;

import com.teradata.jdbc.encode.Decoder;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class DecryptPass {
    public static final int RESTYPE_PASSKEY = 1;
    public static final int RESTYPE_ENCPASS = 2;
    public static final int RESTYPE_ELICIT = 3;
    private static final String PASSKEY = "PassKey";
    private static final String ENCPASS = "EncPass";
    private static final String PREFIX = "ENCRYPTED_PASSWORD(";
    private static final String ARGSEP = ",";
    private static final String SUFFIX = ")";
    static /* synthetic */ Class class$com$teradata$jdbc$jdbc$DecryptPass;

    public static String decryptPass(String string, boolean bl, Log log) throws SQLException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        byte[] byArray;
        boolean bl2;
        int n;
        if (log.isDebugEnabled()) {
            log.debug("DecryptPass: bMatchEntireString=" + bl + " sInput=\"" + string + "\" length=" + string.length());
        }
        if ((n = string.indexOf(PREFIX)) < 0) {
            if (log.isDebugEnabled()) {
                log.debug("DecryptPass: input string does not contain encrypted password prefix ENCRYPTED_PASSWORD(");
            }
            return string;
        }
        int n2 = string.indexOf(SUFFIX, n + PREFIX.length());
        if (n2 < 0) {
            throw DecryptPass.logEx(log, ErrorFactory.makeDriverJDBCException("TJ821", PREFIX, SUFFIX));
        }
        int n3 = n2 + SUFFIX.length();
        int n4 = string.length() - n3;
        boolean bl3 = bl2 = n != 0 || n4 != 0;
        if (bl && bl2) {
            throw DecryptPass.logEx(log, ErrorFactory.makeDriverJDBCException("TJ831", n, n4));
        }
        String string2 = string.substring(n + PREFIX.length(), n2);
        String[] stringArray = string2.split(ARGSEP, -1);
        if (stringArray.length != 2) {
            throw DecryptPass.logEx(log, ErrorFactory.makeDriverJDBCException("TJ832", stringArray.length));
        }
        String string3 = stringArray[0];
        String string4 = stringArray[1];
        if (!string3.trim().equals(string3)) {
            throw DecryptPass.logEx(log, ErrorFactory.makeDriverJDBCException("TJ833"));
        }
        if (!string4.trim().equals(string4)) {
            throw DecryptPass.logEx(log, ErrorFactory.makeDriverJDBCException("TJ834"));
        }
        if (string3.length() == 0) {
            throw DecryptPass.logEx(log, ErrorFactory.makeDriverJDBCException("TJ835"));
        }
        if (string4.length() == 0) {
            throw DecryptPass.logEx(log, ErrorFactory.makeDriverJDBCException("TJ836"));
        }
        if (log.isDebugEnabled()) {
            log.debug("DecryptPass: sPasswordEncryptionKeyResourceName=" + string3 + " sEncryptedPasswordResourceName=" + string4);
        }
        Properties properties = DecryptPass.loadPropertiesFromResource(1, string3, log);
        Properties properties2 = DecryptPass.loadPropertiesFromResource(2, string4, log);
        String string5 = properties.getProperty("version");
        String string6 = properties.getProperty("match");
        String string7 = properties.getProperty("transformation");
        String string8 = properties.getProperty("algorithm");
        String string9 = properties.getProperty("key");
        String string10 = properties.getProperty("mac");
        String string11 = properties.getProperty("mackey");
        String string12 = properties2.getProperty("version");
        String string13 = properties2.getProperty("match");
        String string14 = properties2.getProperty("password");
        String string15 = properties2.getProperty("hash");
        String string16 = properties2.getProperty("params");
        if (!"1".equals(string5)) {
            throw DecryptPass.logEx(log, ErrorFactory.makeDriverJDBCException("TJ822", string3, string5));
        }
        if (!"1".equals(string12)) {
            throw DecryptPass.logEx(log, ErrorFactory.makeDriverJDBCException("TJ822", string4, string12));
        }
        if (string6 == null || string6.length() == 0) {
            throw DecryptPass.logEx(log, ErrorFactory.makeDriverJDBCException("TJ823", string3, "match"));
        }
        if (string13 == null || string13.length() == 0) {
            throw DecryptPass.logEx(log, ErrorFactory.makeDriverJDBCException("TJ823", string4, "match"));
        }
        if (!string6.equals(string13)) {
            throw DecryptPass.logEx(log, ErrorFactory.makeDriverJDBCException("TJ824", string3, string6, string4, string13));
        }
        if (string7 == null || string7.length() == 0) {
            throw DecryptPass.logEx(log, ErrorFactory.makeDriverJDBCException("TJ823", string3, "transformation"));
        }
        if (string8 == null || string8.length() == 0) {
            throw DecryptPass.logEx(log, ErrorFactory.makeDriverJDBCException("TJ823", string3, "algorithm"));
        }
        if (string9 == null || string9.length() == 0) {
            throw DecryptPass.logEx(log, ErrorFactory.makeDriverJDBCException("TJ823", string3, "key"));
        }
        byte[] byArray2 = DecryptPass.parseFromHexDigits(string3, "key", string9, log);
        if (string10 == null || string10.length() == 0) {
            throw DecryptPass.logEx(log, ErrorFactory.makeDriverJDBCException("TJ823", string3, "mac"));
        }
        if (string11 == null || string11.length() == 0) {
            throw DecryptPass.logEx(log, ErrorFactory.makeDriverJDBCException("TJ823", string3, "mackey"));
        }
        byte[] byArray3 = DecryptPass.parseFromHexDigits(string3, "mackey", string11, log);
        if (string14 == null || string14.length() == 0) {
            throw DecryptPass.logEx(log, ErrorFactory.makeDriverJDBCException("TJ823", string4, "password"));
        }
        byte[] byArray4 = DecryptPass.parseFromHexDigits(string4, "password", string14, log);
        byte[] byArray5 = byArray = string16 != null ? DecryptPass.parseFromHexDigits(string4, "params", string16, log) : null;
        if (string15 == null || string15.length() == 0) {
            throw DecryptPass.logEx(log, ErrorFactory.makeDriverJDBCException("TJ823", string4, "hash"));
        }
        byte[] byArray6 = DecryptPass.parseFromHexDigits(string4, "hash", string15, log);
        if (log.isDebugEnabled()) {
            log.debug("DecryptPass: sTransformation=" + string7 + " sAlgorithm=" + string8 + " abyKey.length=" + byArray2.length + " sMac=" + string10 + " abyMacKey.length=" + byArray3.length + " abyCiphertext.length=" + byArray4.length + " abyParams" + (byArray != null ? ".length=" + byArray.length : "=null") + " abyExpectedHash.length=" + byArray6.length);
        }
        boolean bl4 = false;
        long l = System.currentTimeMillis();
        try {
            try {
                object4 = new ByteArrayOutputStream();
                ((OutputStream)object4).write(byArray4);
                ((OutputStream)object4).write(string7.getBytes("UTF-8"));
                if (byArray != null) {
                    ((OutputStream)object4).write(byArray);
                }
                object3 = new SecretKeySpec(byArray3, string10);
                object2 = Mac.getInstance(string10);
                ((Mac)object2).init((Key)object3);
                object = ((Mac)object2).doFinal(((ByteArrayOutputStream)object4).toByteArray());
                bl4 = Arrays.equals(byArray6, (byte[])object);
            }
            catch (Exception exception) {
                throw DecryptPass.logEx(log, DecryptPass.wrapEx(exception, ErrorFactory.makeDriverJDBCException("TJ837", string4)));
            }
            Object var39_40 = null;
            if (log.isTimingEnabled()) {
                log.timing("Password hash verification took " + (System.currentTimeMillis() - l) + " ms and " + (bl4 ? "succeeded" : "failed"));
            }
        }
        catch (Throwable throwable) {
            Object var39_41 = null;
            if (log.isTimingEnabled()) {
                log.timing("Password hash verification took " + (System.currentTimeMillis() - l) + " ms and " + (bl4 ? "succeeded" : "failed"));
            }
            throw throwable;
        }
        if (!bl4) {
            throw DecryptPass.logEx(log, ErrorFactory.makeDriverJDBCException("TJ838", string3, string4));
        }
        object4 = null;
        l = System.currentTimeMillis();
        try {
            try {
                object3 = Cipher.getInstance(string7);
                object2 = new SecretKeySpec(byArray2, string8);
                object = byArray != null ? AlgorithmParameters.getInstance(string8) : null;
                if (object != null) {
                    ((AlgorithmParameters)object).init(byArray);
                }
                ((Cipher)object3).init(2, (Key)object2, (AlgorithmParameters)object);
                object4 = ((Cipher)object3).doFinal(byArray4);
            }
            catch (Exception exception) {
                throw DecryptPass.logEx(log, DecryptPass.wrapEx(exception, ErrorFactory.makeDriverJDBCException("TJ825", string4)));
            }
            Object var41_43 = null;
            if (log.isTimingEnabled()) {
                log.timing("Password decryption took " + (System.currentTimeMillis() - l) + " ms and " + (object4 != null ? "succeeded" : "failed"));
            }
        }
        catch (Throwable throwable) {
            Object var41_44 = null;
            if (log.isTimingEnabled()) {
                log.timing("Password decryption took " + (System.currentTimeMillis() - l) + " ms and " + (object4 != null ? "succeeded" : "failed"));
            }
            throw throwable;
        }
        int n5 = 0;
        while (object4[n5] != false) {
            ++n5;
        }
        object2 = Decoder.getUTF8DecodedString((byte[])object4, 0, n5);
        return string.substring(0, n) + (String)object2 + string.substring(n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadPropertiesFromResource(int n, String string, Log log) throws SQLException {
        InputStream inputStream = null;
        if (string.startsWith("classpath:")) {
            inputStream = DecryptPass.getInputStreamFromResource(n, string = string.substring("classpath:".length()), log);
            if (inputStream == null) {
                throw DecryptPass.logEx(log, ErrorFactory.makeDriverJDBCException("TJ826", string));
            }
        } else {
            long l = System.currentTimeMillis();
            try {
                try {
                    inputStream = new URL(string).openStream();
                    Object var8_6 = null;
                    if (log.isTimingEnabled()) {
                        log.timing("Obtaining resource " + string + " took " + (System.currentTimeMillis() - l) + " ms and " + (inputStream != null ? "succeeded" : "failed"));
                    }
                }
                catch (Throwable throwable) {
                    Object var8_7 = null;
                    if (log.isTimingEnabled()) {
                        log.timing("Obtaining resource " + string + " took " + (System.currentTimeMillis() - l) + " ms and " + (inputStream != null ? "succeeded" : "failed"));
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                throw DecryptPass.logEx(log, DecryptPass.wrapEx(iOException, ErrorFactory.makeDriverJDBCException("TJ827", string)));
            }
        }
        Properties properties = new Properties();
        try {
            boolean bl = false;
            long l = System.currentTimeMillis();
            try {
                try {
                    properties.load(inputStream);
                }
                finally {
                    inputStream.close();
                }
                bl = true;
                Object var11_14 = null;
                if (log.isTimingEnabled()) {
                    log.timing("Loading properties from resource " + string + " took " + (System.currentTimeMillis() - l) + " ms and " + (bl ? "succeeded" : "failed"));
                }
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                if (log.isTimingEnabled()) {
                    log.timing("Loading properties from resource " + string + " took " + (System.currentTimeMillis() - l) + " ms and " + (bl ? "succeeded" : "failed"));
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            throw DecryptPass.logEx(log, DecryptPass.wrapEx(iOException, ErrorFactory.makeDriverJDBCException("TJ829", string)));
        }
        return properties;
    }

    public static InputStream getInputStreamFromResource(int n, String string, Log log) throws SQLException {
        if (n == 1) {
            if (!string.startsWith(PASSKEY)) {
                throw DecryptPass.logEx(log, ErrorFactory.makeDriverJDBCException("TJ828", string, PASSKEY));
            }
        } else if (n == 2) {
            if (!string.startsWith(ENCPASS)) {
                throw DecryptPass.logEx(log, ErrorFactory.makeDriverJDBCException("TJ828", string, ENCPASS));
            }
        } else if (DecryptPass.startsWithIgnoreCase(string, PASSKEY) || DecryptPass.startsWithIgnoreCase(string, ENCPASS)) {
            throw DecryptPass.logEx(log, ErrorFactory.makeDriverJDBCException("TJ830", string, PASSKEY, ENCPASS));
        }
        long l = System.currentTimeMillis();
        InputStream inputStream = (class$com$teradata$jdbc$jdbc$DecryptPass == null ? (class$com$teradata$jdbc$jdbc$DecryptPass = DecryptPass.class$("com.teradata.jdbc.jdbc.DecryptPass")) : class$com$teradata$jdbc$jdbc$DecryptPass).getResourceAsStream("/" + string);
        if (log.isTimingEnabled()) {
            log.timing("Obtaining resource " + string + " from default classpath took " + (System.currentTimeMillis() - l) + " ms and " + (inputStream != null ? "succeeded" : "failed"));
        }
        if (inputStream == null) {
            l = System.currentTimeMillis();
            inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(string);
            if (log.isTimingEnabled()) {
                log.timing("Obtaining resource " + string + " from thread context classloader took " + (System.currentTimeMillis() - l) + " ms and " + (inputStream != null ? "succeeded" : "failed"));
            }
        }
        return inputStream;
    }

    private static boolean startsWithIgnoreCase(String string, String string2) {
        return string.regionMatches(true, 0, string2, 0, string2.length());
    }

    private static byte[] parseFromHexDigits(String string, String string2, String string3, Log log) throws SQLException {
        boolean bl;
        boolean bl2 = bl = (string3.length() & 1) != 0;
        if (bl) {
            throw DecryptPass.logEx(log, ErrorFactory.makeDriverJDBCException("TJ820", string, string2, string3));
        }
        byte[] byArray = new byte[string3.length() / 2];
        for (int i = 0; i < byArray.length; ++i) {
            try {
                byArray[i] = (byte)Integer.parseInt(string3.substring(i * 2, i * 2 + 2), 16);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                throw DecryptPass.logEx(log, DecryptPass.wrapEx(numberFormatException, ErrorFactory.makeDriverJDBCException("TJ820", string, string2, string3)));
            }
        }
        return byArray;
    }

    private static int parseIntValue(String string, String string2, String string3, Log log) throws SQLException {
        try {
            return Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            throw DecryptPass.logEx(log, DecryptPass.wrapEx(numberFormatException, ErrorFactory.makeDriverJDBCException("TJ820", string, string2, string3)));
        }
    }

    private static SQLException wrapEx(Throwable throwable, SQLException sQLException) {
        sQLException.initCause(throwable);
        return sQLException;
    }

    private static SQLException logEx(Log log, SQLException sQLException) {
        if (log.isDebugEnabled()) {
            for (Throwable throwable = sQLException; throwable != null; throwable = throwable.getCause()) {
                log.debug("DecryptPass: " + throwable.getMessage());
            }
        }
        return sQLException;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

