"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeneratedJavaClientProject = void 0;
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
const java_1 = require("projen/lib/java");
const generated_java_client_source_code_1 = require("./components/generated-java-client-source-code");
const open_api_generator_ignore_file_1 = require("./components/open-api-generator-ignore-file");
const DEPENDENCIES = [
    // Required for open api generated client
    "io.swagger/swagger-annotations@1.6.5",
    "com.google.code.findbugs/jsr305@3.0.2",
    "com.squareup.okhttp3/okhttp@4.9.3",
    "com.squareup.okhttp3/logging-interceptor@4.9.3",
    "com.google.code.gson/gson@2.9.0",
    "io.gsonfire/gson-fire@1.8.5",
    "org.apache.commons/commons-lang3@3.12.0",
    "jakarta.annotation/jakarta.annotation-api@1.3.5",
    "org.openapitools/jackson-databind-nullable@0.2.2",
    "javax.ws.rs/jsr311-api@1.1.1",
    "javax.ws.rs/javax.ws.rs-api@2.1.1",
    // For handler wrappers
    "com.amazonaws/aws-lambda-java-core@1.2.1",
    "com.amazonaws/aws-lambda-java-events@3.11.0",
    // Lombok is used to add the builder pattern to models for neater construction
    "org.projectlombok/lombok@1.18.24",
];
const TEST_DEPENDENCIES = [
    "org.junit.jupiter/junit-jupiter-api@5.8.2",
    "org.mockito/mockito-core@3.12.4",
];
/**
 * Java project containing a java client (and lambda handler wrappers) generated using OpenAPI Generator CLI
 */
class GeneratedJavaClientProject extends java_1.JavaProject {
    constructor(options) {
        super({
            sample: false,
            junit: false,
            ...options,
        });
        // Store whether we've synthesized the project
        this.synthed = false;
        // Ignore files that we will control via projen
        const ignoreFile = new open_api_generator_ignore_file_1.OpenApiGeneratorIgnoreFile(this);
        ignoreFile.addPatterns("pom.xml");
        // Add dependencies
        DEPENDENCIES.forEach((dep) => this.addDependency(dep));
        TEST_DEPENDENCIES.forEach((dep) => this.addTestDependency(dep));
        new generated_java_client_source_code_1.GeneratedJavaClientSourceCode(this, {
            specPath: options.specPath,
            invokeGenerator: options.generateClient,
        });
    }
    /**
     * @inheritDoc
     */
    synth() {
        // Save some time by only synthesizing once. We synthesize this project early so that it's available for the parent
        // project's install phase (pre-synth). Projen will call this method again at the usual time to synthesize this,
        // project, at which point we're already done so can skip.
        if (this.synthed) {
            return;
        }
        super.synth();
        this.synthed = true;
    }
}
exports.GeneratedJavaClientProject = GeneratedJavaClientProject;
//# sourceMappingURL=data:application/json;base64,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