"use strict";
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeneratedTypescriptClientSourceCode = void 0;
const path = require("path");
const fs_extra_1 = require("fs-extra");
const log4js_1 = require("log4js");
const projen_1 = require("projen");
const languages_1 = require("../../languages");
const utils_1 = require("./utils");
const logger = log4js_1.getLogger();
/**
 * Generates the typescript client using OpenAPI Generator
 */
class GeneratedTypescriptClientSourceCode extends projen_1.Component {
    constructor(project, options) {
        super(project);
        this.options = options;
    }
    /**
     * @inheritDoc
     */
    synthesize() {
        super.synthesize();
        if (this.options.invokeGenerator) {
            // Generate the typescript client
            logger.debug("Generating typescript client...");
            utils_1.invokeOpenApiGenerator({
                generator: "typescript-fetch",
                specPath: this.options.specPath,
                outputPath: this.project.outdir,
                generatorDirectory: languages_1.ClientLanguage.TYPESCRIPT,
                additionalProperties: {
                    npmName: this.project.package.packageName,
                    typescriptThreePlus: "true",
                    useSingleParameter: "true",
                    supportsES6: "true",
                },
            });
            // Write an index.ts which exposes the additional generated file OperationConfig.ts, which contains handler wrappers
            // and other generated code used by the construct.
            fs_extra_1.writeFileSync(path.join(this.project.outdir, "src", "index.ts"), [
                "/* tslint:disable */",
                "/* eslint-disable */",
                "export * from './runtime';",
                "export * from './apis';",
                "export * from './models';",
                "export * from './apis/DefaultApi/OperationConfig';",
            ].join("\n"));
        }
    }
}
exports.GeneratedTypescriptClientSourceCode = GeneratedTypescriptClientSourceCode;
//# sourceMappingURL=data:application/json;base64,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