# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['render_static',
 'render_static.management',
 'render_static.management.commands',
 'render_static.templatetags']

package_data = \
{'': ['*'], 'render_static': ['static/render_static/*']}

install_requires = \
['Django>=2.2,<4.0']

setup_kwargs = {
    'name': 'django-render-static',
    'version': '1.0.1',
    'description': "Use Django's template engine to render static files at deployment time. Extend Django's url reverse mechanism to JavaScript.",
    'long_description': '|MIT license| |PyPI version fury.io| |PyPI pyversions| |PyPI status| |Documentation Status|\n|Code Cov| |Test Status|\n\n.. |MIT license| image:: https://img.shields.io/badge/License-MIT-blue.svg\n   :target: https://lbesson.mit-license.org/\n\n.. |PyPI version fury.io| image:: https://badge.fury.io/py/django-render-static.svg\n   :target: https://pypi.python.org/pypi/django-render-static/\n\n.. |PyPI pyversions| image:: https://img.shields.io/pypi/pyversions/django-render-static.svg\n   :target: https://pypi.python.org/pypi/django-render-static/\n\n.. |PyPI status| image:: https://img.shields.io/pypi/status/django-render-static.svg\n   :target: https://pypi.python.org/pypi/django-render-static\n\n.. |Documentation Status| image:: https://readthedocs.org/projects/django-render-static/badge/?version=latest\n   :target: http://django-render-static.readthedocs.io/?badge=latest/\n\n.. |Code Cov| image:: https://codecov.io/gh/bckohan/django-render-static/branch/main/graph/badge.svg?token=0IZOKN2DYL\n   :target: https://codecov.io/gh/bckohan/django-render-static\n\n.. |Test Status| image:: https://github.com/bckohan/django-render-static/workflows/test/badge.svg\n   :target: https://github.com/bckohan/django-render-static/actions\n\ndjango-render-static\n#######################\n\nUse Django\'s dynamic templates to render static files. That is, files that are collected\nduring the ``collectstatic`` routine and likely served above Django on the stack. Static\ntemplates should be rendered preceding any run of ``collectstatic``. Files rendered by\ndjango-render-static are immediately available to participate in the normal static file pipeline.\n\nFor example, a frequently occurring pattern that violates the DRY principle is the presence of\ndefines, or enum like structures in server side Python code that are simply replicated in client\nside JavaScript. Single-sourcing these structures by generating client side code from the server\nside code keeps the stack bone DRY.\n\nHave you ever wished you could replicate Django\'s ``reverse`` function in a JavaScript library for\nyour site? Now you can with the ``urls_to_js`` template tag included with `django-render-static`.\n\nYou can report bugs and discuss features on the\n`issues page <https://github.com/bckohan/django-render-static/issues>`_.\n\n`Contributions <https://github.com/bckohan/django-render-static/blob/main/CONTRIBUTING.rst>`_ are\nencouraged! Especially additional template tags and filters!\n\n`Full documentation at read the docs. <https://django-render-static.readthedocs.io/en/latest/>`_\n\nInstallation\n------------\n\n1. Clone django-render-static from GitHub_ or install a release off PyPI_ :\n\n.. code:: bash\n\n       pip install django-render-static\n\n\n2. Add \'render_static\' to your ``INSTALLED_APPS`` :\n\n.. code:: python\n\n       INSTALLED_APPS = [\n           \'render_static\',\n       ]\n\n\n3. Add a ``STATIC_TEMPLATES`` configuration directive to your settings file:\n\n.. code:: python\n\n        STATIC_TEMPLATES = {\n            \'templates\' : {\n                \'path/to/template\': {\n                    \'context\' { \'variable\': \'value\' }\n                }\n        }\n\n\n4. Run ``render_static`` preceding every run of ``collectstatic`` :\n\n.. code:: bash\n\n        $> manage.py render_static\n        $> manage.py collectstatic\n\n\n.. _GitHub: http://github.com/bckohan/django-render-static\n.. _PyPI: http://pypi.python.org/pypi/django-render-static\n\n\nUsage\n-----\n\nGenerating Javascript Defines\n-----------------------------\n\nYou have an app with a model with a character field that has several valid choices defined in an\nenumeration type way, and you\'d like to export those defines to JavaScript. You\'d like to include\na template for other\'s using your app to use to generate a defines.js file. Say your app structure\nlooks like this::\n\n    .\n    └── my_app\n        ├── __init__.py\n        ├── apps.py\n        ├── defines.py\n        ├── models.py\n        ├── static_templates\n        │\xa0\xa0 └── my_app\n        │\xa0\xa0     └── defines.js\n        └── urls.py\n\n\nYour defines/model classes might look like this:\n\n.. code:: python\n\n    class Defines:\n\n        DEFINE1 = \'D1\'\n        DEFINE2 = \'D2\'\n        DEFINE3 = \'D3\'\n        DEFINES = (\n            (DEFINE1, \'Define 1\'),\n            (DEFINE2, \'Define 2\'),\n            (DEFINE3, \'Define 3\')\n        )\n\n    class MyModel(Defines, models.Model):\n\n        define_field = models.CharField(choices=Defines.DEFINES, max_length=2)\n\n\nAnd your defines.js template might look like this::\n\n    var defines = {\n        {{ "my_app.defines.Defines"|split|classes_to_js }}\n    };\n\n\nIf someone wanted to use your defines template to generate a JavaScript version of your Python\nclass their settings file might look like this:\n\n.. code:: python\n\n    STATIC_TEMPLATES = {\n        \'templates\': {\n            \'my_app/defines.js\': {}\n        }\n    }\n\n\nAnd then of course they would call `render_static` before `collectstatic`:\n\n.. code:: bash\n\n    $> ./manage.py render_static\n    $> ./manage.py collectstatic\n\n\nThis would create the following file::\n\n    .\n    └── my_app\n        └── static\n            └── my_app\n                └── defines.js\n\nWhich would look like this:\n\n.. code:: javascript\n\n    var defines = {\n        Defines: {\n            DEFINE1: \'D1\'\n            DEFINE2: \'D2\'\n            DEFINE3: \'D3\'\n            DEFINES: [\n                [\'D1\', \'Define 1\'],\n                [\'D2\', \'Define 2\'],\n                [\'D3\', \'Define 3\']\n            ]\n        }\n    };\n\n\nURL reverse functions\n---------------------\n\nYou\'d like to be able to call something like `reverse` on path names from your client JavaScript\ncode the same way you do from Python Django code. You don\'t want to expose your admin paths though.\n\nYour settings file might look like:\n\n.. code:: python\n\n    from pathlib import Path\n\n    BASE_DIR = Path(__file__).parent\n\n    STATICFILES_DIRS = [\n        BASE_DIR / \'more_static\'\n    ]\n\n    STATIC_TEMPLATES = {\n        \'ENGINES\': [{\n            \'BACKEND\': \'render_static.backends.StaticDjangoTemplates\',\n            \'OPTIONS\': {\n                \'loaders\': [\n                    (\'render_static.loaders.StaticLocMemLoader\', {\n                        \'urls.js\': (\n                            \'{% urls_to_js visitor="render_static.ClassURLWriter" \'\n                            \'exclude=exclude %}\'\n                        )\n                    })\n                 ],\n                \'builtins\': [\'render_static.templatetags.render_static\']\n            },\n        }],\n        \'templates\': {\n            \'urls.js\': {\n                \'dest\': BASE_DIR / \'more_static\' / \'urls.js\',\n                \'context\': {\n                    \'exclude\': [\'admin\']\n                }\n            }\n        }\n    }\n\n\nThen call `render_static` before `collectstatic`::\n\n    $> ./manage.py render_static\n    $> ./manage.py collectstatic\n\nIf your root urls.py looks like this:\n\n.. code:: python\n\n    from django.contrib import admin\n    from django.urls import include, path\n\n    from .views import MyView\n\n    urlpatterns = [\n        path(\'admin/\', admin.site.urls),\n        path(\'simple\', MyView.as_view(), name=\'simple\'),\n        path(\'simple/<int:arg1>\', MyView.as_view(), name=\'simple\'),\n        path(\'different/<int:arg1>/<str:arg2>\', MyView.as_view(), name=\'different\'),\n    ]\n\n\nThen urls.js will look like this:\n\n.. code:: javascript\n\n    class URLResolver {\n\n        match(kwargs, args, expected) {\n            if (Array.isArray(expected)) {\n                return Object.keys(kwargs).length === expected.length &&\n                    expected.every(value => kwargs.hasOwnProperty(value));\n            } else if (expected) {\n                return args.length === expected;\n            } else {\n                return Object.keys(kwargs).length === 0 && args.length === 0;\n            }\n        }\n\n        reverse(qname, kwargs={}, args=[]) {\n            let url = this.urls;\n            for (const ns of qname.split(\':\')) {\n                if (ns && url) { url = url.hasOwnProperty(ns) ? url[ns] : null; }\n            }\n            if (url) {\n                let pth = url(kwargs, args);\n                if (typeof pth === "string") { return pth; }\n            }\n            throw new TypeError(`No reversal available for parameters at path: ${qname}`);\n        }\n\n        urls = {\n            "simple": (kwargs={}, args=[]) => {\n                if (this.match(kwargs, args)) { return "/simple/"; }\n                if (this.match(kwargs, args, [\'arg1\'])) { return `/simple/${kwargs["arg1"]}`; }\n            },\n            "different": (kwargs={}, args=[]) => {\n                if (this.match(kwargs, args, [\'arg1\',\'arg2\'])) {\n                    return `/different/${kwargs["arg1"]}/${kwargs["arg2"]}`;\n                }\n            },\n        }\n    };\n\n\nSo you can now fetch paths like this:\n\n.. code:: javascript\n\n    // /different/143/emma\n    const urls = new URLResolver();\n    urls.reverse(\'different\', {\'arg1\': 143, \'arg2\': \'emma\'});\n    \n    \nURLGenerationFailed Exceptions & Placeholders\n---------------------------------------------\n\nIf you encounter a ``URLGenerationFailed`` exception, not to worry. You most likely need to register a placeholder for the argument in question. A placeholder is just a string or object that can be coerced to a string that matches the regular expression for the argument:\n\n.. code:: python\n   \n   from render_static.placeholders import register_variable_placeholder\n\n   app_name = \'year_app\'\n   urlpatterns = [\n       re_path(r\'^fetch/(?P<year>\\d{4})/$\', YearView.as_view(), name=\'fetch_year\')\n   ]\n\n   register_variable_placeholder(\'year\', 2000, app_name=app_name)\n\ndjango-render-static avoids overly complex string parsing logic by reversing the urls and using the resultant regular expression match objects to determine where argument substitutions are made. This keeps the code simple, reliable and avoids deep dependencies on Django\'s url configuration code. Placeholders are the price paid for that reliability. Common default placeholders are attempted after all registered placeholders fail, and all of Django\'s native path converters are supported. This should allow most urls to work out of the box. \n\nUsers are **strongly** encouraged to use path instead of re_path and register their own custom converters when needed. Placeholders can be directly registered on the converter (and are then conveniently available to users of your app!):\n\n.. code:: python\n\n   from django.urls.converters import register_converter\n\n   class YearConverter:\n       regex = \'[0-9]{4}\'\n       placeholder = 2000  # this attribute is used by `url_to_js` to reverse paths\n\n       def to_python(self, value):\n           return int(value)\n\n       def to_url(self, value):\n           return str(value)\n\n\n   register_converter(YearConverter, \'year\')\n\n   urlpatterns = [\n       path(\'fetch/<year:year>\', YearView.as_view(), name=\'fetch_year\')\n   ]\n\n\n',
    'author': 'Brian Kohan',
    'author_email': 'bckohan@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://django-render-static.readthedocs.io',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
