"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaPowertoolsLayer = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * Defines a new Lambda Layer with Powertools for python library.
 */
class LambdaPowertoolsLayer extends aws_cdk_lib_1.aws_lambda.LayerVersion {
    constructor(scope, id, props) {
        super(scope, id, {
            code: aws_cdk_lib_1.aws_lambda.Code.fromDockerBuild(path.join(__dirname, '../layer'), {
                buildArgs: {
                    PACKAGE_SUFFIX: LambdaPowertoolsLayer.constructBuildArgs(props === null || props === void 0 ? void 0 : props.includeExtras, props === null || props === void 0 ? void 0 : props.version),
                },
            }),
            layerVersionName: (props === null || props === void 0 ? void 0 : props.layerVersionName) ? props === null || props === void 0 ? void 0 : props.layerVersionName : undefined,
            license: 'MIT-0',
            compatibleRuntimes: [
                aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_6,
                aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_7,
                aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_8,
                aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_9,
            ],
            description: `Lambda Powertools for Python${(props === null || props === void 0 ? void 0 : props.includeExtras) ? ' with Pydantic' : ''} ${(props === null || props === void 0 ? void 0 : props.version) ? `version ${props.version}` : 'latest version'}`.trim(),
        });
    }
    /**
     * creates build argument for the Dockerfile.
     * There are multiple combinations between version and extras package that results in different suffix for the installation.
     * With and without version, with and without extras flag.
     * We construct one suffix here because it is easier to do in code than inside the Dockerfile with bash commands.
     * For example, if we set extras=true and version=1.22.0 we get '[pydantic]==1.22.0'.
     *
     */
    static constructBuildArgs(includeExtras, version) {
        let suffix = '';
        if (includeExtras) {
            suffix = '[pydantic]';
        }
        if (version) {
            suffix = `${suffix}==${version}`;
        }
        return suffix;
    }
    ;
}
exports.LambdaPowertoolsLayer = LambdaPowertoolsLayer;
_a = JSII_RTTI_SYMBOL_1;
LambdaPowertoolsLayer[_a] = { fqn: "cdk-lambda-powertools-python-layer.LambdaPowertoolsLayer", version: "2.0.34" };
//# sourceMappingURL=data:application/json;base64,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