"""
    MetaFab API

     Complete MetaFab API references and guides can be found at: https://trymetafab.com  # noqa: E501

    The version of the OpenAPI document: 1.1.3
    Contact: metafabproject@gmail.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from metafab_python.api_client import ApiClient, Endpoint as _Endpoint
from metafab_python.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from metafab_python.model.batch_transfer_currency_request import BatchTransferCurrencyRequest
from metafab_python.model.burn_currency_request import BurnCurrencyRequest
from metafab_python.model.create_currency200_response import CreateCurrency200Response
from metafab_python.model.create_currency_request import CreateCurrencyRequest
from metafab_python.model.get_currencies200_response_inner import GetCurrencies200ResponseInner
from metafab_python.model.get_currency_fees200_response import GetCurrencyFees200Response
from metafab_python.model.mint_currency_request import MintCurrencyRequest
from metafab_python.model.set_currency_fees_request import SetCurrencyFeesRequest
from metafab_python.model.transaction_model import TransactionModel
from metafab_python.model.transfer_currency_request import TransferCurrencyRequest


class CurrenciesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.batch_transfer_currency_endpoint = _Endpoint(
            settings={
                'response_type': (TransactionModel,),
                'auth': [],
                'endpoint_path': '/v1/currencies/{currencyId}/batchTransfers',
                'operation_id': 'batch_transfer_currency',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'currency_id',
                    'x_authorization',
                    'x_password',
                    'batch_transfer_currency_request',
                ],
                'required': [
                    'currency_id',
                    'x_authorization',
                    'x_password',
                    'batch_transfer_currency_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'currency_id':
                        (str,),
                    'x_authorization':
                        (str,),
                    'x_password':
                        (str,),
                    'batch_transfer_currency_request':
                        (BatchTransferCurrencyRequest,),
                },
                'attribute_map': {
                    'currency_id': 'currencyId',
                    'x_authorization': 'X-Authorization',
                    'x_password': 'X-Password',
                },
                'location_map': {
                    'currency_id': 'path',
                    'x_authorization': 'header',
                    'x_password': 'header',
                    'batch_transfer_currency_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.burn_currency_endpoint = _Endpoint(
            settings={
                'response_type': (TransactionModel,),
                'auth': [],
                'endpoint_path': '/v1/currencies/{currencyId}/burns',
                'operation_id': 'burn_currency',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'currency_id',
                    'x_authorization',
                    'x_password',
                    'burn_currency_request',
                ],
                'required': [
                    'currency_id',
                    'x_authorization',
                    'x_password',
                    'burn_currency_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'currency_id':
                        (str,),
                    'x_authorization':
                        (str,),
                    'x_password':
                        (str,),
                    'burn_currency_request':
                        (BurnCurrencyRequest,),
                },
                'attribute_map': {
                    'currency_id': 'currencyId',
                    'x_authorization': 'X-Authorization',
                    'x_password': 'X-Password',
                },
                'location_map': {
                    'currency_id': 'path',
                    'x_authorization': 'header',
                    'x_password': 'header',
                    'burn_currency_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_currency_endpoint = _Endpoint(
            settings={
                'response_type': (CreateCurrency200Response,),
                'auth': [],
                'endpoint_path': '/v1/currencies',
                'operation_id': 'create_currency',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'x_authorization',
                    'x_password',
                    'create_currency_request',
                ],
                'required': [
                    'x_authorization',
                    'x_password',
                    'create_currency_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'x_authorization':
                        (str,),
                    'x_password':
                        (str,),
                    'create_currency_request':
                        (CreateCurrencyRequest,),
                },
                'attribute_map': {
                    'x_authorization': 'X-Authorization',
                    'x_password': 'X-Password',
                },
                'location_map': {
                    'x_authorization': 'header',
                    'x_password': 'header',
                    'create_currency_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.get_currencies_endpoint = _Endpoint(
            settings={
                'response_type': ([GetCurrencies200ResponseInner],),
                'auth': [],
                'endpoint_path': '/v1/currencies',
                'operation_id': 'get_currencies',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'x_game_key',
                ],
                'required': [
                    'x_game_key',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'x_game_key':
                        (str,),
                },
                'attribute_map': {
                    'x_game_key': 'X-Game-Key',
                },
                'location_map': {
                    'x_game_key': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_currency_balance_endpoint = _Endpoint(
            settings={
                'response_type': (float,),
                'auth': [],
                'endpoint_path': '/v1/currencies/{currencyId}/balances',
                'operation_id': 'get_currency_balance',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'currency_id',
                    'address',
                    'wallet_id',
                ],
                'required': [
                    'currency_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'currency_id':
                        (str,),
                    'address':
                        (str,),
                    'wallet_id':
                        (str,),
                },
                'attribute_map': {
                    'currency_id': 'currencyId',
                    'address': 'address',
                    'wallet_id': 'walletId',
                },
                'location_map': {
                    'currency_id': 'path',
                    'address': 'query',
                    'wallet_id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_currency_fees_endpoint = _Endpoint(
            settings={
                'response_type': (GetCurrencyFees200Response,),
                'auth': [],
                'endpoint_path': '/v1/currencies/{currencyId}/fees',
                'operation_id': 'get_currency_fees',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'currency_id',
                ],
                'required': [
                    'currency_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'currency_id':
                        (str,),
                },
                'attribute_map': {
                    'currency_id': 'currencyId',
                },
                'location_map': {
                    'currency_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.mint_currency_endpoint = _Endpoint(
            settings={
                'response_type': (TransactionModel,),
                'auth': [],
                'endpoint_path': '/v1/currencies/{currencyId}/mints',
                'operation_id': 'mint_currency',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'currency_id',
                    'x_authorization',
                    'x_password',
                    'mint_currency_request',
                ],
                'required': [
                    'currency_id',
                    'x_authorization',
                    'x_password',
                    'mint_currency_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'currency_id':
                        (str,),
                    'x_authorization':
                        (str,),
                    'x_password':
                        (str,),
                    'mint_currency_request':
                        (MintCurrencyRequest,),
                },
                'attribute_map': {
                    'currency_id': 'currencyId',
                    'x_authorization': 'X-Authorization',
                    'x_password': 'X-Password',
                },
                'location_map': {
                    'currency_id': 'path',
                    'x_authorization': 'header',
                    'x_password': 'header',
                    'mint_currency_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.set_currency_fees_endpoint = _Endpoint(
            settings={
                'response_type': (TransactionModel,),
                'auth': [],
                'endpoint_path': '/v1/currencies/{currencyId}/fees',
                'operation_id': 'set_currency_fees',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'currency_id',
                    'x_authorization',
                    'x_password',
                    'set_currency_fees_request',
                ],
                'required': [
                    'currency_id',
                    'x_authorization',
                    'x_password',
                    'set_currency_fees_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'currency_id':
                        (str,),
                    'x_authorization':
                        (str,),
                    'x_password':
                        (str,),
                    'set_currency_fees_request':
                        (SetCurrencyFeesRequest,),
                },
                'attribute_map': {
                    'currency_id': 'currencyId',
                    'x_authorization': 'X-Authorization',
                    'x_password': 'X-Password',
                },
                'location_map': {
                    'currency_id': 'path',
                    'x_authorization': 'header',
                    'x_password': 'header',
                    'set_currency_fees_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.transfer_currency_endpoint = _Endpoint(
            settings={
                'response_type': (TransactionModel,),
                'auth': [],
                'endpoint_path': '/v1/currencies/{currencyId}/transfers',
                'operation_id': 'transfer_currency',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'currency_id',
                    'x_authorization',
                    'x_password',
                    'transfer_currency_request',
                ],
                'required': [
                    'currency_id',
                    'x_authorization',
                    'x_password',
                    'transfer_currency_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'currency_id':
                        (str,),
                    'x_authorization':
                        (str,),
                    'x_password':
                        (str,),
                    'transfer_currency_request':
                        (TransferCurrencyRequest,),
                },
                'attribute_map': {
                    'currency_id': 'currencyId',
                    'x_authorization': 'X-Authorization',
                    'x_password': 'X-Password',
                },
                'location_map': {
                    'currency_id': 'path',
                    'x_authorization': 'header',
                    'x_password': 'header',
                    'transfer_currency_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def batch_transfer_currency(
        self,
        currency_id,
        x_authorization,
        x_password,
        batch_transfer_currency_request,
        **kwargs
    ):
        """Batch transfer currency  # noqa: E501

        Transfers multiple amounts of currency to multiple provided wallet addresses or wallet addresses associated with the provided walletIds. You may also provide a combination of addresses and walletIds in one request, the proper receipients will be automatically determined, with `addresses` getting `amounts` order priority first.  Optional references may be included for the transfer. References are useful for identifying transfers intended to pay for items, trades, services and more.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.batch_transfer_currency(currency_id, x_authorization, x_password, batch_transfer_currency_request, async_req=True)
        >>> result = thread.get()

        Args:
            currency_id (str): Any currency id within the MetaFab ecosystem.
            x_authorization (str): The `secretKey` of a specific game or the `accessToken` of a specific player.
            x_password (str): The password of the authenticating game or player. Required to decrypt and perform blockchain transactions with the game or player primary wallet.
            batch_transfer_currency_request (BatchTransferCurrencyRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            TransactionModel
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['currency_id'] = \
            currency_id
        kwargs['x_authorization'] = \
            x_authorization
        kwargs['x_password'] = \
            x_password
        kwargs['batch_transfer_currency_request'] = \
            batch_transfer_currency_request
        return self.batch_transfer_currency_endpoint.call_with_http_info(**kwargs)

    def burn_currency(
        self,
        currency_id,
        x_authorization,
        x_password,
        burn_currency_request,
        **kwargs
    ):
        """Burn currency  # noqa: E501

        Removes (burns) the provided amount of currency from the authenticating game or players wallet. The currency amount is permanently removed from the circulating supply of the currency.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.burn_currency(currency_id, x_authorization, x_password, burn_currency_request, async_req=True)
        >>> result = thread.get()

        Args:
            currency_id (str): Any currency id within the MetaFab ecosystem.
            x_authorization (str): The `secretKey` of a specific game or the `accessToken` of a specific player.
            x_password (str): The password of the authenticating game or player. Required to decrypt and perform blockchain transactions with the game or player primary wallet.
            burn_currency_request (BurnCurrencyRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            TransactionModel
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['currency_id'] = \
            currency_id
        kwargs['x_authorization'] = \
            x_authorization
        kwargs['x_password'] = \
            x_password
        kwargs['burn_currency_request'] = \
            burn_currency_request
        return self.burn_currency_endpoint.call_with_http_info(**kwargs)

    def create_currency(
        self,
        x_authorization,
        x_password,
        create_currency_request,
        **kwargs
    ):
        """Create currency  # noqa: E501

        Creates a new game currency and deploys an ERC20 token contract on behalf of the authenticating game's primary wallet. The deployed ERC20 contract is preconfigured to fully support bridging across blockchains, batched transfers and gasless transactions on any supported blockchain as well as full support for gasless transactions from player managed wallets.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_currency(x_authorization, x_password, create_currency_request, async_req=True)
        >>> result = thread.get()

        Args:
            x_authorization (str): The `secretKey` of the authenticating game.
            x_password (str): The password of the authenticating game. Required to decrypt and perform blockchain transactions with the game primary wallet.
            create_currency_request (CreateCurrencyRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CreateCurrency200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['x_authorization'] = \
            x_authorization
        kwargs['x_password'] = \
            x_password
        kwargs['create_currency_request'] = \
            create_currency_request
        return self.create_currency_endpoint.call_with_http_info(**kwargs)

    def get_currencies(
        self,
        x_game_key,
        **kwargs
    ):
        """Get currencies  # noqa: E501

        Returns an array of active currencies for the game associated with the provided `X-Game-Key`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_currencies(x_game_key, async_req=True)
        >>> result = thread.get()

        Args:
            x_game_key (str): The `publishedKey` of a specific game. This can be shared or included in game clients, websites, etc.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [GetCurrencies200ResponseInner]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['x_game_key'] = \
            x_game_key
        return self.get_currencies_endpoint.call_with_http_info(**kwargs)

    def get_currency_balance(
        self,
        currency_id,
        **kwargs
    ):
        """Get currency balance  # noqa: E501

        Returns the current currency balance of the provided wallet address or or the wallet address associated with the provided walletId.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_currency_balance(currency_id, async_req=True)
        >>> result = thread.get()

        Args:
            currency_id (str): Any currency id within the MetaFab ecosystem.

        Keyword Args:
            address (str): A valid EVM based address. For example, `0x39cb70F972E0EE920088AeF97Dbe5c6251a9c25D`.. [optional]
            wallet_id (str): Any wallet id within the MetaFab ecosystem.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            float
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['currency_id'] = \
            currency_id
        return self.get_currency_balance_endpoint.call_with_http_info(**kwargs)

    def get_currency_fees(
        self,
        currency_id,
        **kwargs
    ):
        """Get currency fees  # noqa: E501

        Returns the current fee recipient address and fees of the currency for the provided currencyId. Fees are only applicable for gasless transactions performed by default by players.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_currency_fees(currency_id, async_req=True)
        >>> result = thread.get()

        Args:
            currency_id (str): Any currency id within the MetaFab ecosystem.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GetCurrencyFees200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['currency_id'] = \
            currency_id
        return self.get_currency_fees_endpoint.call_with_http_info(**kwargs)

    def mint_currency(
        self,
        currency_id,
        x_authorization,
        x_password,
        mint_currency_request,
        **kwargs
    ):
        """Mint currency  # noqa: E501

        Creates (mints) the provided amount of currency to the provided wallet address or wallet address associated with the provided walletId.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.mint_currency(currency_id, x_authorization, x_password, mint_currency_request, async_req=True)
        >>> result = thread.get()

        Args:
            currency_id (str): Any currency id within the MetaFab ecosystem.
            x_authorization (str): The `secretKey` of the authenticating game.
            x_password (str): The password of the authenticating game. Required to decrypt and perform blockchain transactions with the game primary wallet.
            mint_currency_request (MintCurrencyRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            TransactionModel
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['currency_id'] = \
            currency_id
        kwargs['x_authorization'] = \
            x_authorization
        kwargs['x_password'] = \
            x_password
        kwargs['mint_currency_request'] = \
            mint_currency_request
        return self.mint_currency_endpoint.call_with_http_info(**kwargs)

    def set_currency_fees(
        self,
        currency_id,
        x_authorization,
        x_password,
        set_currency_fees_request,
        **kwargs
    ):
        """Set currency fees  # noqa: E501

        Sets the recipient address, basis points, fixed amount and cap amount for a currency's fees.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_currency_fees(currency_id, x_authorization, x_password, set_currency_fees_request, async_req=True)
        >>> result = thread.get()

        Args:
            currency_id (str): Any currency id within the MetaFab ecosystem.
            x_authorization (str): The `secretKey` of the authenticating game.
            x_password (str): The password of the authenticating game. Required to decrypt and perform blockchain transactions with the game primary wallet.
            set_currency_fees_request (SetCurrencyFeesRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            TransactionModel
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['currency_id'] = \
            currency_id
        kwargs['x_authorization'] = \
            x_authorization
        kwargs['x_password'] = \
            x_password
        kwargs['set_currency_fees_request'] = \
            set_currency_fees_request
        return self.set_currency_fees_endpoint.call_with_http_info(**kwargs)

    def transfer_currency(
        self,
        currency_id,
        x_authorization,
        x_password,
        transfer_currency_request,
        **kwargs
    ):
        """Transfer currency  # noqa: E501

        Transfers an amount of currency to the provided wallet address or wallet address associated with the provided walletId. If you want to transfer to multiple wallets with different amounts and optional references in one API request, please see the Batch transfer currency documentation.  An optional reference may be included for the transfer. References are useful for identifying transfers intended to pay for items, trades, services and more.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.transfer_currency(currency_id, x_authorization, x_password, transfer_currency_request, async_req=True)
        >>> result = thread.get()

        Args:
            currency_id (str): Any currency id within the MetaFab ecosystem.
            x_authorization (str): The `secretKey` of a specific game or the `accessToken` of a specific player.
            x_password (str): The password of the authenticating game or player. Required to decrypt and perform blockchain transactions with the game or player primary wallet.
            transfer_currency_request (TransferCurrencyRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            TransactionModel
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['currency_id'] = \
            currency_id
        kwargs['x_authorization'] = \
            x_authorization
        kwargs['x_password'] = \
            x_password
        kwargs['transfer_currency_request'] = \
            transfer_currency_request
        return self.transfer_currency_endpoint.call_with_http_info(**kwargs)

