#!/usr/bin/env python

"""The setup script."""

from setuptools import find_packages, setup

with open("README.md") as readme_file:
    readme = readme_file.read()

requirements = [
    "Click>=7.0,<8",
    "python-igraph>=0.8.0,<1",
    "wostools>=3.0.2,<4",
]

setup_requirements = [
    "pytest-runner",
]

test_requirements = [
    "pytest>=3",
]

setup(
    author="Juan David Alzate Cardona",
    author_email="jdalzatec@unal.edu.co",
    python_requires=">=3.6",
    classifiers=[
        "Development Status :: 5 - Production/Stable",
        "Environment :: Console",
        "Intended Audience :: Developers",
        "Intended Audience :: Education",
        "License :: OSI Approved :: MIT License",
        "Natural Language :: English",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
    ],
    description="Python Tree of Science package",
    entry_points={"console_scripts": ["sap=sap.cli:main"]},
    install_requires=requirements,
    license="MIT license",
    long_description=readme,
    long_description_content_type="text/markdown",
    include_package_data=True,
    keywords="python-sap",
    name="python-sap",
    packages=find_packages(where="src"),
    package_dir={"": "src/", "sap": "src/sap"},
    package_data={"sap": ["template.html"]},
    setup_requires=setup_requirements,
    test_suite="tests",
    tests_require=test_requirements,
    url="https://github.com/coreofscience/python-sap",
    version="2.0.0",
    zip_safe=False,
)
