# coding: utf-8

"""
    Patch API V1

    The core API used to integrate with Patch's service  # noqa: E501

    The version of the OpenAPI document: v1
    Contact: developers@usepatch.com
    Generated by: https://openapi-generator.tech
"""

from __future__ import absolute_import

import unittest
import os
import datetime

from patch_api.api_client import ApiClient


class TestOrdersApi(unittest.TestCase):
    """OrdersApi unit test stubs"""

    def setUp(self):
        api_client = ApiClient(api_key=os.environ.get("SANDBOX_API_KEY"))
        self.api = api_client.orders  # noqa: E501

    def tearDown(self):
        self.api = None

    def test_interactions_with_an_order(self):
        """Test case for create_order"""

        """Create an order
        """
        order = self.api.create_order(mass_g=100)

        self.assertTrue(order)

        self.assertIsInstance(order.data.created_at, datetime.datetime)

        self.assertEqual(order.data.mass_g, 100)

        """Create an order on price
        """
        order = self.api.create_order(total_price_cents_usd=100)

        self.assertTrue(order)
        self.assertEqual(
            order.data.price_cents_usd + order.data.patch_fee_cents_usd, 100
        )

        """Create an order in draft state
        """
        order = self.api.create_order(mass_g=100, state="draft")

        self.assertTrue(order)
        self.assertEqual(order.data.mass_g, 100)
        self.assertEqual(order.data.state, "draft")

    def test_retrieve_order(self):
        """Test case for retrieve_order"""

        """Retrieve an order
        """
        order = self.api.create_order(mass_g=100)
        retrieved_order = self.api.retrieve_order(id=order.data.id)

        self.assertTrue(retrieved_order)
        self.assertEqual(retrieved_order.data.mass_g, 100)

    def test_retrieve_orders(self):
        """Test case for retrieve_orders

        Retrieves a list of orders  # noqa: E501
        """
        orders = self.api.retrieve_orders().data
        self.assertTrue(isinstance(orders, list))

        if len(orders) > 1:
            retrieved_order = orders[0]

            self.assertTrue(retrieved_order.id)
            self.assertEqual(retrieved_order.production, False)
            self.assertEqual(retrieved_order.state, "placed")
            self.assertEqual(retrieved_order.metadata, {})
            self.assertTrue(isinstance(retrieved_order.allocations, list))

    def test_create_and_retrieve_order_via_metadata(self):
        """Test case for create_order and retrieve_orders with metadata"""
        mass_g = 100
        metadata = {"external_id": "abc-123"}
        order = self.api.create_order(mass_g=mass_g, metadata=metadata)

        self.assertTrue(order)
        self.assertEqual(order.data.mass_g, 100)
        self.assertEqual(order.data.metadata, {"external_id": "abc-123"})

        retrieved_orders = self.api.retrieve_orders(
            metadata={"external_id": "abc-"}
        ).data
        self.assertGreater(len(retrieved_orders), 0)
        for retrieved_order in retrieved_orders:
            self.assertTrue("external_id" in retrieved_order.metadata)

    def test_cancel_order_in_draft_state(self):
        """Test case for cancel_order on draft orders"""
        order = self.api.create_order(mass_g=100, state="draft")
        self.assertEqual(order.data.state, "draft")

        cancelled_order = self.api.cancel_order(id=order.data.id)
        self.assertEqual(cancelled_order.data.state, "cancelled")

    def test_create_order_with_vintage_year(self):
        """Test case for vintage_year on create order"""
        order = self.api.create_order(mass_g=100, vintage_year=2022)

        self.assertTrue(order)


if __name__ == "__main__":
    unittest.main()
