import { Architecture, AssetCode, Runtime } from 'aws-cdk-lib/aws-lambda';
import { BundlingOptions as CdkBundlingOptions, DockerImage } from 'aws-cdk-lib';
import { BundlingOptions } from './types';
/**
 * Dependency files to exclude from the asset hash.
 */
export declare const DEPENDENCY_EXCLUDES: string[];
/**
 * The location in the image that the bundler image caches dependencies.
 */
export declare const BUNDLER_DEPENDENCIES_CACHE = "/var/dependencies";
/**
 * Options for bundling
 */
export interface BundlingProps extends BundlingOptions {
    /**
     * Entry path
     */
    readonly entry: string;
    /**
     * The runtime environment.
     */
    readonly runtime: Runtime;
    /**
     * The system architecture of the lambda function
     *
     * @default Architecture.X86_64
     */
    readonly architecture?: Architecture;
}
/**
 * Produce bundled Lambda asset code
 */
export declare class Bundling implements CdkBundlingOptions {
    static bundle(options: BundlingProps): AssetCode;
    readonly image: DockerImage;
    readonly command: string[];
    constructor(props: BundlingProps);
    private createBundlingCommand;
}
