"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const path = require("path");
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
const core_1 = require("@aws-cdk/core");
const lambda = require("../lib");
class TestStack extends core_1.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        // This function uses aws-sdk but it will not be included
        new lambda.NodejsFunction(this, 'external', {
            entry: path.join(__dirname, 'integ-handlers/dependencies.ts'),
            runtime: aws_lambda_1.Runtime.NODEJS_12_X,
            minify: true,
            // Will be installed, not bundled
            // (delay is a zero dependency package and its version is fixed
            // in the package.json to ensure a stable hash for this integ test)
            nodeModules: ['delay'],
            forceDockerBundling: true,
        });
    }
}
const app = new core_1.App();
new TestStack(app, 'cdk-integ-lambda-nodejs-dependencies');
app.synth();
//# sourceMappingURL=data:application/json;base64,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