"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaPowertoolsLayer = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * Defines a new Lambda Layer with Powertools for python library.
 */
class LambdaPowertoolsLayer extends aws_cdk_lib_1.aws_lambda.LayerVersion {
    constructor(scope, id, props) {
        const runtimeFamily = props?.runtimeFamily ?? aws_cdk_lib_1.aws_lambda.RuntimeFamily.PYTHON;
        const languageName = getLanguageNameFromRuntimeFamily(runtimeFamily);
        const dockerFilePath = path.join(__dirname, `../layer/${languageName}`);
        console.log(`path ${dockerFilePath}`);
        super(scope, id, {
            code: aws_cdk_lib_1.aws_lambda.Code.fromDockerBuild(dockerFilePath, {
                buildArgs: {
                    PACKAGE_SUFFIX: LambdaPowertoolsLayer.constructBuildArgs(runtimeFamily, props?.includeExtras, props?.version),
                },
            }),
            layerVersionName: props?.layerVersionName ? props?.layerVersionName : undefined,
            license: 'MIT-0',
            compatibleRuntimes: getRuntimesFromRuntimeFamily(runtimeFamily),
            description: `Lambda Powertools for ${languageName}${props?.includeExtras ? ' with Pydantic' : ''} ${props?.version ? `version ${props?.version}` : 'latest version'}`.trim(),
        });
    }
    /**
     * creates build argument for the Dockerfile.
     * There are multiple combinations between version and extras package that results in different suffix for the installation.
     * With and without version, with and without extras flag.
     * We construct one suffix here because it is easier to do in code than inside the Dockerfile with bash commands.
     * For example, if we set extras=true and version=1.22.0 we get '[pydantic]==1.22.0'.
     *
     */
    static constructBuildArgs(runtimeFamily, includeExtras, version) {
        let suffix = '';
        switch (runtimeFamily) {
            case aws_cdk_lib_1.aws_lambda.RuntimeFamily.PYTHON:
                if (includeExtras) {
                    suffix = '[pydantic]';
                }
                if (version) {
                    suffix = `${suffix}==${version}`;
                }
                break;
            case aws_cdk_lib_1.aws_lambda.RuntimeFamily.NODEJS:
                if (version) {
                    suffix = `@${version}`;
                }
                break;
            default:
                break;
        }
        return suffix;
    }
}
exports.LambdaPowertoolsLayer = LambdaPowertoolsLayer;
_a = JSII_RTTI_SYMBOL_1;
LambdaPowertoolsLayer[_a] = { fqn: "cdk-aws-lambda-powertools-layer.LambdaPowertoolsLayer", version: "2.0.0" };
function getRuntimesFromRuntimeFamily(runtimeFamily) {
    switch (runtimeFamily) {
        case aws_cdk_lib_1.aws_lambda.RuntimeFamily.PYTHON:
            return [
                aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_6,
                aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_7,
                aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_8,
                aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_9,
            ];
        case aws_cdk_lib_1.aws_lambda.RuntimeFamily.NODEJS:
            return [
                aws_cdk_lib_1.aws_lambda.Runtime.NODEJS_12_X,
                aws_cdk_lib_1.aws_lambda.Runtime.NODEJS_14_X,
                aws_cdk_lib_1.aws_lambda.Runtime.NODEJS_16_X,
            ];
        default:
            return [];
    }
}
function getLanguageNameFromRuntimeFamily(runtimeFamily) {
    switch (runtimeFamily) {
        case aws_cdk_lib_1.aws_lambda.RuntimeFamily.PYTHON:
            return 'Python';
        case aws_cdk_lib_1.aws_lambda.RuntimeFamily.NODEJS:
            return 'TypeScript';
        default:
            return 'Unknown';
    }
}
//# sourceMappingURL=data:application/json;base64,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