# flink-sql-gateway-client
Flink SQL Rest API

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: v1
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python >= 3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import flink_sql_gateway_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import flink_sql_gateway_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

from flink_sql_gateway_client.flink_sql_magic import FlinkSQLMagic

tester = FlinkSQLMagic(None)
tester.connect_flink_sql("--host <host_ip_url> --port 8083 --session_name <your_session_name>")
tester.flink_sql(
    "--catalog <catalog_name> --execution_timeout 1000000 --num_fetches 10 --max_fetch_size 1",
    "<your_sql_statement>",
)

```

If you would like to use non-magic syntax, here is an example:

```python

from flink_sql_gateway_client.flink_sql_client import FlinkSQLClient

flink_sql_client = FlinkSQLClient("<host_ip_url>", 8083, "<your_session_name>")
job = flink_sql_client.execute_statement("<your_sql_statement>", 1000000)
    if job:
        for _ in range(0, 10):
            results = job.fetch_job_results(1)
            print(results)

```

If you would like to use the raw rest api, here is an example:

```python

import time
import flink_sql_gateway_client
from flink_sql_gateway_client.api import default_api
from flink_sql_gateway_client.model.info_response import InfoResponse
# Defining the host is optional and defaults to http://10.130.0.45:8083/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = flink_sql_gateway_client.Configuration(
    host = "http://10.130.0.45:8083/v1"
)



# Enter a context with an instance of the API client
with flink_sql_gateway_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = default_api.DefaultApi(api_client)
    
    try:
        api_response = api_instance.info_get()
        print(api_response)
    except flink_sql_gateway_client.ApiException as e:
        print("Exception when calling DefaultApi->info_get: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *http://10.130.0.45:8083/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**info_get**](docs/DefaultApi.md#info_get) | **GET** /info | 
*FlinkSqlApi* | [**cancel_job**](docs/FlinkSqlApi.md#cancel_job) | **DELETE** /sessions/{session_id}/jobs/{job_id} | Cancel Flink SQL job in session.
*FlinkSqlApi* | [**cancel_session**](docs/FlinkSqlApi.md#cancel_session) | **DELETE** /sessions/{session_id} | Cancel Flink SQL job in session.
*FlinkSqlApi* | [**create_session**](docs/FlinkSqlApi.md#create_session) | **POST** /sessions | Creates a session to run flink sql jobs
*FlinkSqlApi* | [**execute_statement**](docs/FlinkSqlApi.md#execute_statement) | **POST** /sessions/{session_id}/statements | Executes Flink SQL statement in session.
*FlinkSqlApi* | [**get_job_results**](docs/FlinkSqlApi.md#get_job_results) | **GET** /sessions/{session_id}/jobs/{job_id}/result/{token} | Get results of a Flink SQL job.
*FlinkSqlApi* | [**get_job_status**](docs/FlinkSqlApi.md#get_job_status) | **GET** /sessions/{session_id}/jobs/{job_id}/status | Get Flink SQL job status in session.
*FlinkSqlApi* | [**heartbeat_session**](docs/FlinkSqlApi.md#heartbeat_session) | **POST** /sessions/{session_id}/heartbeat | Executes Flink SQL heartbeat to keep session alive.


## Documentation For Models

 - [CreateSessionRequest](docs/CreateSessionRequest.md)
 - [CreateSessionResponse](docs/CreateSessionResponse.md)
 - [ExecuteStatementRequest](docs/ExecuteStatementRequest.md)
 - [ExecuteStatementResponse](docs/ExecuteStatementResponse.md)
 - [InfoResponse](docs/InfoResponse.md)
 - [JobStatusResponse](docs/JobStatusResponse.md)
 - [ResultColumn](docs/ResultColumn.md)
 - [ResultFetchRequest](docs/ResultFetchRequest.md)
 - [ResultFetchResponse](docs/ResultFetchResponse.md)
 - [ResultSet](docs/ResultSet.md)
 - [SessionStatusResponse](docs/SessionStatusResponse.md)


## Documentation For Authorization

 All endpoints do not require authorization.

## Author




## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in flink_sql_gateway_client.apis and flink_sql_gateway_client.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from flink_sql_gateway_client.api.default_api import DefaultApi`
- `from flink_sql_gateway_client.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import flink_sql_gateway_client
from flink_sql_gateway_client.apis import *
from flink_sql_gateway_client.models import *
```

