"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.S3EventSource = void 0;
const notifs = require("@aws-cdk/aws-s3-notifications");
/**
 * Use S3 bucket notifications as an event source for AWS Lambda.
 */
class S3EventSource {
    constructor(bucket, props) {
        this.bucket = bucket;
        this.props = props;
    }
    bind(target) {
        const filters = this.props.filters || [];
        for (const event of this.props.events) {
            this.bucket.addEventNotification(event, new notifs.LambdaDestination(target), ...filters);
        }
    }
}
exports.S3EventSource = S3EventSource;
//# sourceMappingURL=data:application/json;base64,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