# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel


class ActivateMigrationTargetInstanceRequest(TeaModel):
    def __init__(self, dbinstance_name=None, force_switch=None, resource_owner_id=None, switch_time=None,
                 switch_time_mode=None):
        # The ID of the instance. You can call the [DescribeDBInstances](~~26232~~) operation to query the ID of the instance.
        self.dbinstance_name = dbinstance_name  # type: str
        # Specifies whether to forcefully perform a switchover. Set the value to 1. The value 1 specifies that a forceful switchover is performed.
        self.force_switch = force_switch  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # A reserved parameter. This parameter does not take effect.
        self.switch_time = switch_time  # type: str
        # The time when you want to perform the switchover.
        # 
        # Set the value to 0. The value 0 specifies that an immediate switchover is performed.
        self.switch_time_mode = switch_time_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ActivateMigrationTargetInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_name is not None:
            result['DBInstanceName'] = self.dbinstance_name
        if self.force_switch is not None:
            result['ForceSwitch'] = self.force_switch
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.switch_time is not None:
            result['SwitchTime'] = self.switch_time
        if self.switch_time_mode is not None:
            result['SwitchTimeMode'] = self.switch_time_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DBInstanceName') is not None:
            self.dbinstance_name = m.get('DBInstanceName')
        if m.get('ForceSwitch') is not None:
            self.force_switch = m.get('ForceSwitch')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SwitchTime') is not None:
            self.switch_time = m.get('SwitchTime')
        if m.get('SwitchTimeMode') is not None:
            self.switch_time_mode = m.get('SwitchTimeMode')
        return self


class ActivateMigrationTargetInstanceResponseBody(TeaModel):
    def __init__(self, dbinstance_name=None, request_id=None, source_ip_address=None, source_port=None,
                 task_id=None):
        # The name of the instance.
        self.dbinstance_name = dbinstance_name  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The private or public IP address that is used to connect to the self-managed PostgreSQL instance.
        self.source_ip_address = source_ip_address  # type: str
        # The port number that is used to connect to the self-managed PostgreSQL instance.
        self.source_port = source_port  # type: long
        # The ID of the job.
        self.task_id = task_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ActivateMigrationTargetInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_name is not None:
            result['DBInstanceName'] = self.dbinstance_name
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.source_ip_address is not None:
            result['SourceIpAddress'] = self.source_ip_address
        if self.source_port is not None:
            result['SourcePort'] = self.source_port
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DBInstanceName') is not None:
            self.dbinstance_name = m.get('DBInstanceName')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SourceIpAddress') is not None:
            self.source_ip_address = m.get('SourceIpAddress')
        if m.get('SourcePort') is not None:
            self.source_port = m.get('SourcePort')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class ActivateMigrationTargetInstanceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ActivateMigrationTargetInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ActivateMigrationTargetInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ActivateMigrationTargetInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddTagsToResourceRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        # The TagKey of the first tag that you want to bind. Each tag consists of a TagKey and a TagValue. You can specify up to five tags in a single request. The TagKey is required, and the TagValue is optional.
        self.key = key  # type: str
        # The TagValue of the first tag that you want to bind. Each tag consists of a TagKey and a TagValue. You can specify up to five tags in a single request. The TagKey is required, and the TagValue is optional.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddTagsToResourceRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['key'] = self.key
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class AddTagsToResourceRequest(TeaModel):
    def __init__(self, tag=None, client_token=None, dbinstance_id=None, owner_account=None, owner_id=None,
                 region_id=None, resource_owner_account=None, resource_owner_id=None, tags=None, proxy_id=None):
        self.tag = tag  # type: list[AddTagsToResourceRequestTag]
        # The client token that is used to ensure the idempotence of the request. You can use the client to generate the value, but you must ensure that it is unique among different requests. The token can only contain ASCII characters and cannot exceed 64 characters in length.
        self.client_token = client_token  # type: str
        # The ID of the instance.
        # 
        # >  You can enter up to 30 instance IDs in a single request. If you enter more than one instance ID, you must separate the instance IDs with commas (,).
        self.dbinstance_id = dbinstance_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The region ID of the instance. You can call the [DescribeRegions](~~26243~~) operation to query the most recent region list.
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The tags that you want to bind. Each tag consists of a TagKey and a TagValue. You can specify up to five tags in a single request. Format: {"key1":"value1","key2":"value2"...}.
        # 
        # >  The TagKey is required, and the TagValue is optional.
        self.tags = tags  # type: str
        # The ID of the proxy pattern.
        self.proxy_id = proxy_id  # type: str

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(AddTagsToResourceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.proxy_id is not None:
            result['proxyId'] = self.proxy_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = AddTagsToResourceRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('proxyId') is not None:
            self.proxy_id = m.get('proxyId')
        return self


class AddTagsToResourceResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddTagsToResourceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddTagsToResourceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddTagsToResourceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddTagsToResourceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddTagsToResourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AllocateInstancePublicConnectionRequest(TeaModel):
    def __init__(self, babelfish_port=None, connection_string_prefix=None, dbinstance_id=None,
                 general_group_name=None, owner_account=None, owner_id=None, port=None, resource_owner_account=None,
                 resource_owner_id=None):
        # The Tabular Data Stream (TDS) port of the instance for which Babelfish is enabled.
        # 
        # > This parameter applies only to ApsaraDB RDS for PostgreSQL instances. For more information about Babelfish for ApsaraDB RDS for PostgreSQL, see [Introduction to Babelfish](~~428613~~).
        self.babelfish_port = babelfish_port  # type: str
        # The prefix of the public endpoint. A valid public endpoint is in the following format: Prefix.Database engine.rds.aliyuncs.com. Example: test1234.mysql.rds.aliyuncs.com.
        # 
        # > The value can be 5 to 40 characters in length and can contain letters, digits, and hyphens (-). The value cannot contain any of the following characters: ~ ! # % ^ & \* = + | {} ; : \" " , <> / ?
        self.connection_string_prefix = connection_string_prefix  # type: str
        # The ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        # The name of the dedicated cluster to which the instance belongs. This parameter is returned only when the instance is created in an ApsaraDB MyBase cluster that runs MySQL on Standard Edition.
        self.general_group_name = general_group_name  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The public port of the instance. Valid values: **1000 to 5999**.
        self.port = port  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(AllocateInstancePublicConnectionRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.babelfish_port is not None:
            result['BabelfishPort'] = self.babelfish_port
        if self.connection_string_prefix is not None:
            result['ConnectionStringPrefix'] = self.connection_string_prefix
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.general_group_name is not None:
            result['GeneralGroupName'] = self.general_group_name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.port is not None:
            result['Port'] = self.port
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BabelfishPort') is not None:
            self.babelfish_port = m.get('BabelfishPort')
        if m.get('ConnectionStringPrefix') is not None:
            self.connection_string_prefix = m.get('ConnectionStringPrefix')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('GeneralGroupName') is not None:
            self.general_group_name = m.get('GeneralGroupName')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class AllocateInstancePublicConnectionResponseBody(TeaModel):
    def __init__(self, connection_string=None, db_instance_name=None, request_id=None):
        # The endpoint of the instance.
        self.connection_string = connection_string  # type: str
        # The ID of the instance.
        self.db_instance_name = db_instance_name  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AllocateInstancePublicConnectionResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.connection_string is not None:
            result['ConnectionString'] = self.connection_string
        if self.db_instance_name is not None:
            result['DbInstanceName'] = self.db_instance_name
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConnectionString') is not None:
            self.connection_string = m.get('ConnectionString')
        if m.get('DbInstanceName') is not None:
            self.db_instance_name = m.get('DbInstanceName')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AllocateInstancePublicConnectionResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AllocateInstancePublicConnectionResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AllocateInstancePublicConnectionResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AllocateInstancePublicConnectionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AllocateReadWriteSplittingConnectionRequest(TeaModel):
    def __init__(self, connection_string_prefix=None, dbinstance_id=None, distribution_type=None,
                 max_delay_time=None, net_type=None, owner_account=None, owner_id=None, port=None, resource_owner_account=None,
                 resource_owner_id=None, weight=None):
        # The prefix of the read-only routing endpoint. The prefix must be unique. It can be up to 30 characters in length and can contain lowercase letters and hyphens (-). It must start with a lowercase letter.
        # 
        # >  The default prefix consists of the name of the primary instance followed by the letters rw.
        self.connection_string_prefix = connection_string_prefix  # type: str
        # The ID of the primary instance. You can call the [DescribeDBInstances](~~26232~~) operation to query the ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        # The method that is used to assign read weights. Valid values:
        # 
        # *   **Standard**: ApsaraDB RDS automatically assigns read weights to the primary and read-only instances based on the specifications of these instances.
        # *   **Custom**: You must manually assign a read weight to each instance.
        self.distribution_type = distribution_type  # type: str
        # The threshold of the latency that is allowed on the read-only instances. Valid values: 0 to 7200. Default value: 30. Unit: seconds.
        # 
        # >  If the latency on a read-only instance exceeds the specified threshold, ApsaraDB RDS does not forward read requests to the read-only instance.
        self.max_delay_time = max_delay_time  # type: str
        # The network type of the read-only routing endpoint. Valid values:
        # 
        # *   **Internet**: Internet
        # *   **Intranet**: internal network
        # 
        # >  The default value is Intranet. Make sure that the network type of the read-only routing endpoint is the same as that of the primary instance.
        self.net_type = net_type  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The port that is associated with the read-only routing endpoint. Valid values: 1000 to 5999. Default value: 1433.
        self.port = port  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The read weights of the primary instance and its read-only instances. The read weight is increased in increments of 100. The maximum value is 10000.
        # 
        # * For ApsaraDB RDS instances, the value of this parameter is in the following format: `{"<ID of the read-only instance >":<Weight>,"master":<Weight>,"slave":<Weight>}`.
        # * For ApsaraDB MyBase instances, the value of this parameter is in the following format: `[{"instanceName":"<ID of the primary instance>","weight":<Weight>,"role":"master"},{"instanceName":"<ID of the primary instance>","weight":<Weight>,"role":"slave"},{"instanceName":"<ID of the read-only instance>","weight":<Weight>,"role":"master"}]`
        # 
        # > * If you set the **DistributionType** parameter to **Custom**, you must also specify this parameter.
        # > * If you set the **DistributionType** parameter to **Standard**, this parameter is invalid.
        self.weight = weight  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AllocateReadWriteSplittingConnectionRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.connection_string_prefix is not None:
            result['ConnectionStringPrefix'] = self.connection_string_prefix
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.distribution_type is not None:
            result['DistributionType'] = self.distribution_type
        if self.max_delay_time is not None:
            result['MaxDelayTime'] = self.max_delay_time
        if self.net_type is not None:
            result['NetType'] = self.net_type
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.port is not None:
            result['Port'] = self.port
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.weight is not None:
            result['Weight'] = self.weight
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConnectionStringPrefix') is not None:
            self.connection_string_prefix = m.get('ConnectionStringPrefix')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DistributionType') is not None:
            self.distribution_type = m.get('DistributionType')
        if m.get('MaxDelayTime') is not None:
            self.max_delay_time = m.get('MaxDelayTime')
        if m.get('NetType') is not None:
            self.net_type = m.get('NetType')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Weight') is not None:
            self.weight = m.get('Weight')
        return self


class AllocateReadWriteSplittingConnectionResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AllocateReadWriteSplittingConnectionResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AllocateReadWriteSplittingConnectionResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AllocateReadWriteSplittingConnectionResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AllocateReadWriteSplittingConnectionResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AllocateReadWriteSplittingConnectionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CalculateDBInstanceWeightRequest(TeaModel):
    def __init__(self, dbinstance_id=None, resource_owner_id=None):
        # The ID of the primary instance.
        self.dbinstance_id = dbinstance_id  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CalculateDBInstanceWeightRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class CalculateDBInstanceWeightResponseBodyItemsDBInstanceWeight(TeaModel):
    def __init__(self, dbinstance_id=None, dbinstance_type=None, readonly_instance_sqldelayed_time=None,
                 weight=None):
        # The ID of instance.
        self.dbinstance_id = dbinstance_id  # type: str
        # The role of the instance. Valid values:
        # 
        # *   **Master**: primary instance
        # *   **Readonly**: read-only instance
        self.dbinstance_type = dbinstance_type  # type: str
        # The threshold for the latency of data replication from the primary instance to the read-only instances. The read-only instances start to synchronize data from the primary instance after the time specified by the **ReadonlyInstanceSQLDelayedTime** parameter elapses. Unit: seconds.
        self.readonly_instance_sqldelayed_time = readonly_instance_sqldelayed_time  # type: str
        # The read weight that ApsaraDB RDS calculates in real time for the instance.
        self.weight = weight  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CalculateDBInstanceWeightResponseBodyItemsDBInstanceWeight, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dbinstance_type is not None:
            result['DBInstanceType'] = self.dbinstance_type
        if self.readonly_instance_sqldelayed_time is not None:
            result['ReadonlyInstanceSQLDelayedTime'] = self.readonly_instance_sqldelayed_time
        if self.weight is not None:
            result['Weight'] = self.weight
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DBInstanceType') is not None:
            self.dbinstance_type = m.get('DBInstanceType')
        if m.get('ReadonlyInstanceSQLDelayedTime') is not None:
            self.readonly_instance_sqldelayed_time = m.get('ReadonlyInstanceSQLDelayedTime')
        if m.get('Weight') is not None:
            self.weight = m.get('Weight')
        return self


class CalculateDBInstanceWeightResponseBodyItems(TeaModel):
    def __init__(self, dbinstance_weight=None):
        self.dbinstance_weight = dbinstance_weight  # type: list[CalculateDBInstanceWeightResponseBodyItemsDBInstanceWeight]

    def validate(self):
        if self.dbinstance_weight:
            for k in self.dbinstance_weight:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CalculateDBInstanceWeightResponseBodyItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DBInstanceWeight'] = []
        if self.dbinstance_weight is not None:
            for k in self.dbinstance_weight:
                result['DBInstanceWeight'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.dbinstance_weight = []
        if m.get('DBInstanceWeight') is not None:
            for k in m.get('DBInstanceWeight'):
                temp_model = CalculateDBInstanceWeightResponseBodyItemsDBInstanceWeight()
                self.dbinstance_weight.append(temp_model.from_map(k))
        return self


class CalculateDBInstanceWeightResponseBody(TeaModel):
    def __init__(self, items=None, request_id=None):
        # An array that consists of the system-assigned read weights.
        self.items = items  # type: CalculateDBInstanceWeightResponseBodyItems
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super(CalculateDBInstanceWeightResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.items is not None:
            result['Items'] = self.items.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Items') is not None:
            temp_model = CalculateDBInstanceWeightResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CalculateDBInstanceWeightResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CalculateDBInstanceWeightResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CalculateDBInstanceWeightResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CalculateDBInstanceWeightResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelImportRequest(TeaModel):
    def __init__(self, dbinstance_id=None, import_id=None, owner_account=None, owner_id=None,
                 resource_owner_account=None, resource_owner_id=None):
        # The ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        # The ID of the migration task that you want to cancel.
        # 
        # >  This parameter is returned when the migration task is started. For more information, see [ImportDatabaseBetweenInstances](~~26301~~).
        self.import_id = import_id  # type: int
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CancelImportRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.import_id is not None:
            result['ImportId'] = self.import_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('ImportId') is not None:
            self.import_id = m.get('ImportId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class CancelImportResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CancelImportResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CancelImportResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CancelImportResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CancelImportResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CancelImportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckAccountNameAvailableRequest(TeaModel):
    def __init__(self, account_name=None, client_token=None, dbinstance_id=None, owner_account=None, owner_id=None,
                 resource_owner_account=None):
        # The name of the account that you want to create.
        self.account_name = account_name  # type: str
        # The client token that is used to ensure the idempotence of the request. You can use the client to generate the value, but you must ensure that the value is unique among different requests. The token can contain only ASCII characters and cannot exceed 64 characters in length.
        self.client_token = client_token  # type: str
        # The ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CheckAccountNameAvailableRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        return self


class CheckAccountNameAvailableResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CheckAccountNameAvailableResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CheckAccountNameAvailableResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CheckAccountNameAvailableResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CheckAccountNameAvailableResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CheckAccountNameAvailableResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckCloudResourceAuthorizedRequest(TeaModel):
    def __init__(self, dbinstance_id=None, owner_account=None, owner_id=None, region_id=None,
                 resource_group_id=None, resource_owner_account=None, resource_owner_id=None, security_token=None,
                 target_region_id=None):
        # The ID of the instance. You can call the [DescribeDBInstances](~~26232~~) operation to query the ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The region ID of the instance. You can call the [DescribeRegions](~~26243~~) operation to query the most recent region list.
        self.region_id = region_id  # type: str
        # The ID of the resource group.
        self.resource_group_id = resource_group_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.security_token = security_token  # type: str
        # The ID of the destination region. You can call the [DescribeRegions](~~26243~~) operation to query the most recent region list.
        self.target_region_id = target_region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CheckCloudResourceAuthorizedRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.target_region_id is not None:
            result['TargetRegionId'] = self.target_region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('TargetRegionId') is not None:
            self.target_region_id = m.get('TargetRegionId')
        return self


class CheckCloudResourceAuthorizedResponseBody(TeaModel):
    def __init__(self, authorization_state=None, request_id=None, role_arn=None):
        # The authorization status. Valid values:
        # 
        # *   **1**: authorized
        # *   **0**: not authorized
        self.authorization_state = authorization_state  # type: int
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The Alibaba Cloud Resource Name (ARN) of the RAM role. A RAM role is a virtual identity that you can create within your Alibaba Cloud account. For more information, see [RAM role overview](~~93689~~).
        # 
        # >  This parameter is available only when the instance runs MySQL.
        self.role_arn = role_arn  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CheckCloudResourceAuthorizedResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.authorization_state is not None:
            result['AuthorizationState'] = self.authorization_state
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.role_arn is not None:
            result['RoleArn'] = self.role_arn
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AuthorizationState') is not None:
            self.authorization_state = m.get('AuthorizationState')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RoleArn') is not None:
            self.role_arn = m.get('RoleArn')
        return self


class CheckCloudResourceAuthorizedResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CheckCloudResourceAuthorizedResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CheckCloudResourceAuthorizedResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CheckCloudResourceAuthorizedResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckCreateDdrDBInstanceRequest(TeaModel):
    def __init__(self, backup_set_id=None, dbinstance_class=None, dbinstance_storage=None, engine=None,
                 engine_version=None, owner_id=None, region_id=None, resource_owner_account=None, resource_owner_id=None,
                 restore_time=None, restore_type=None, source_dbinstance_name=None, source_region=None):
        # The ID of the data backup file that is used for the restoration. You can call the [DescribeCrossRegionBackups](~~121733~~) operation to query backup set IDs.
        # 
        # >  If you set the **RestoreType** parameter to **0**, you must also specify this parameter.
        self.backup_set_id = backup_set_id  # type: str
        # The type of the destination instance. For more information, see [Primary instance types](~~26312~~).
        self.dbinstance_class = dbinstance_class  # type: str
        # The storage capacity of the destination instance. Valid values: **5 to 2000**. Unit: GB.
        # 
        # The storage capacity increases at increments of 5 GB. For more information, see [Primary instance types](~~26312~~).
        self.dbinstance_storage = dbinstance_storage  # type: int
        # The database engine that is run on the destination instance. Valid values:
        # 
        # *   **MySQL**\
        # *   **SQLServer**\
        # *   **PostgreSQL**\
        self.engine = engine  # type: str
        # The version of the database engine that is run on the destination the instance. The value of this parameter varies based on the value of the **Engine** parameter. Valid values:
        # 
        # *   MySQL: **5.5, 5.6, 5.7, and 8.0**\
        # *   SQL Server: **2008r2, 08r2\_ent_ha, 2012, 2012\_ent_ha, 2012\_std_ha, 2012\_web, 2014\_std_ha, 2016\_ent_ha, 2016\_std_ha, 2016\_web, 2017\_std_ha, 2017\_ent, 2019\_std_ha, and 2019\_ent**\
        # *   PostgreSQL: **9.4, 10.0, 11.0, 12.0, and 13.0**\
        self.engine_version = engine_version  # type: str
        self.owner_id = owner_id  # type: long
        # The region ID of the destination instance. You can call the [DescribeRegions](~~26243~~) operation to query the most recent region list of region IDs.
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The point in time to which you want to restore data. The point in time that you specify must be earlier than the current time. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time must be in UTC.
        # 
        # >  If you set the **RestoreType** parameter to **1**, you must also specify this parameter.
        self.restore_time = restore_time  # type: str
        # The restoration method that you want to use. Valid values:
        # 
        # *   **0**: restores data from a data backup file. If you select this value, you must also specify the **BackupSetId** parameter.
        # *   **1**: restores data to a point in time. If you select this value, you must also specify the **RestoreTime**, **SourceRegion** and **SourceDBInstanceName** parameters.
        # 
        # Default value: **0**.
        self.restore_type = restore_type  # type: str
        # The ID of the source instance if you want to restore data to a point in time.
        # 
        # >  If you set the **RestoreType** parameter to **1**, you must also specify this parameter.
        self.source_dbinstance_name = source_dbinstance_name  # type: str
        # The region ID of the source instance if you want to restore data to a point in time.
        # 
        # >  If you set the **RestoreType** parameter to **1**, you must also specify this parameter.
        self.source_region = source_region  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CheckCreateDdrDBInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_set_id is not None:
            result['BackupSetId'] = self.backup_set_id
        if self.dbinstance_class is not None:
            result['DBInstanceClass'] = self.dbinstance_class
        if self.dbinstance_storage is not None:
            result['DBInstanceStorage'] = self.dbinstance_storage
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.engine_version is not None:
            result['EngineVersion'] = self.engine_version
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.restore_time is not None:
            result['RestoreTime'] = self.restore_time
        if self.restore_type is not None:
            result['RestoreType'] = self.restore_type
        if self.source_dbinstance_name is not None:
            result['SourceDBInstanceName'] = self.source_dbinstance_name
        if self.source_region is not None:
            result['SourceRegion'] = self.source_region
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BackupSetId') is not None:
            self.backup_set_id = m.get('BackupSetId')
        if m.get('DBInstanceClass') is not None:
            self.dbinstance_class = m.get('DBInstanceClass')
        if m.get('DBInstanceStorage') is not None:
            self.dbinstance_storage = m.get('DBInstanceStorage')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('EngineVersion') is not None:
            self.engine_version = m.get('EngineVersion')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RestoreTime') is not None:
            self.restore_time = m.get('RestoreTime')
        if m.get('RestoreType') is not None:
            self.restore_type = m.get('RestoreType')
        if m.get('SourceDBInstanceName') is not None:
            self.source_dbinstance_name = m.get('SourceDBInstanceName')
        if m.get('SourceRegion') is not None:
            self.source_region = m.get('SourceRegion')
        return self


class CheckCreateDdrDBInstanceResponseBody(TeaModel):
    def __init__(self, is_valid=None, request_id=None):
        # Indicates whether the data of the source instance can be restored across regions. Valid values:** true and false**\
        self.is_valid = is_valid  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CheckCreateDdrDBInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_valid is not None:
            result['IsValid'] = self.is_valid
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IsValid') is not None:
            self.is_valid = m.get('IsValid')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CheckCreateDdrDBInstanceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CheckCreateDdrDBInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CheckCreateDdrDBInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CheckCreateDdrDBInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckDBNameAvailableRequest(TeaModel):
    def __init__(self, client_token=None, dbinstance_id=None, dbname=None, owner_account=None, owner_id=None,
                 resource_owner_account=None, resource_owner_id=None):
        # The client token that is used to ensure the idempotence of the request. You can use the client to generate the token, but you must make sure that the generated token is unique among different requests. The token can contain only ASCII characters and cannot exceed 64 characters in length.
        self.client_token = client_token  # type: str
        # The ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        # The database name that you want to check.
        self.dbname = dbname  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CheckDBNameAvailableRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dbname is not None:
            result['DBName'] = self.dbname
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DBName') is not None:
            self.dbname = m.get('DBName')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class CheckDBNameAvailableResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        # 
        # > If this operation returns only the ID of the request, the database name can be used. Otherwise, an error message is returned to indicate that the database name is duplicate or does not conform to the naming conventions.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CheckDBNameAvailableResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CheckDBNameAvailableResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CheckDBNameAvailableResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CheckDBNameAvailableResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CheckDBNameAvailableResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckInstanceExistRequest(TeaModel):
    def __init__(self, dbinstance_id=None, owner_id=None, resource_owner_account=None, resource_owner_id=None):
        # The ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CheckInstanceExistRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class CheckInstanceExistResponseBody(TeaModel):
    def __init__(self, is_exist_instance=None, request_id=None):
        # Indicates whether the instance exists. Valid values:
        # 
        # *   **true**: The instance exists.
        # *   **false**: The instance does not exist.
        self.is_exist_instance = is_exist_instance  # type: bool
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CheckInstanceExistResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_exist_instance is not None:
            result['IsExistInstance'] = self.is_exist_instance
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IsExistInstance') is not None:
            self.is_exist_instance = m.get('IsExistInstance')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CheckInstanceExistResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CheckInstanceExistResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CheckInstanceExistResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CheckInstanceExistResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckServiceLinkedRoleRequest(TeaModel):
    def __init__(self, owner_id=None, region_id=None, resource_group_id=None, resource_owner_account=None,
                 resource_owner_id=None, service_linked_role=None):
        self.owner_id = owner_id  # type: long
        # The region ID of the instance.
        # 
        # >  The configuration of the RegionId parameter does not affect your query results. You can configure any region for this parameter. You can call the [DescribeRegions](~~26243~~) operation to query the most recent region list.
        self.region_id = region_id  # type: str
        # The ID of the resource group to which the instance belongs.
        self.resource_group_id = resource_group_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The name of the SLR.
        # 
        # >  For more information about the SLRs supported by ApsaraDB RDS, see [Service-linked roles](~~342840~~).
        self.service_linked_role = service_linked_role  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CheckServiceLinkedRoleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.service_linked_role is not None:
            result['ServiceLinkedRole'] = self.service_linked_role
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ServiceLinkedRole') is not None:
            self.service_linked_role = m.get('ServiceLinkedRole')
        return self


class CheckServiceLinkedRoleResponseBody(TeaModel):
    def __init__(self, has_service_linked_role=None, request_id=None):
        # Indicates whether an SLR is created.
        self.has_service_linked_role = has_service_linked_role  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CheckServiceLinkedRoleResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.has_service_linked_role is not None:
            result['HasServiceLinkedRole'] = self.has_service_linked_role
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HasServiceLinkedRole') is not None:
            self.has_service_linked_role = m.get('HasServiceLinkedRole')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CheckServiceLinkedRoleResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CheckServiceLinkedRoleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CheckServiceLinkedRoleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CheckServiceLinkedRoleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CloneDBInstanceRequestServerlessConfig(TeaModel):
    def __init__(self, auto_pause=None, max_capacity=None, min_capacity=None, switch_force=None):
        # Specifies whether to enable the automatic start and stop feature for the serverless instance. After the automatic start and stop feature is enabled, if no connections to the instance are established within 10 minutes, the instance is suspended. After a connection is established to the instance, the instance is automatically resumed. Valid values:
        # 
        # *   true: enables the feature.
        # *   false: disables the feature. This is the default value.
        self.auto_pause = auto_pause  # type: bool
        # The maximum number of RDS Capacity Units (RCUs).
        self.max_capacity = max_capacity  # type: float
        # The minimum number of RCUs.
        self.min_capacity = min_capacity  # type: float
        # Specifies whether to enable the forced scaling feature for the serverless instance. In most cases, ApsaraDB RDS automatically scales in or out the RCUs of a serverless instance based on business requirements in real time. In rare cases, the scaling does not take effect in real time. You can enable the forced scaling feature to forcefully scales in or out the RCUs of the instance. Valid values:
        # 
        # *   true: enables the feature.
        # *   false: disables the feature. This is the default value.
        self.switch_force = switch_force  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CloneDBInstanceRequestServerlessConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_pause is not None:
            result['AutoPause'] = self.auto_pause
        if self.max_capacity is not None:
            result['MaxCapacity'] = self.max_capacity
        if self.min_capacity is not None:
            result['MinCapacity'] = self.min_capacity
        if self.switch_force is not None:
            result['SwitchForce'] = self.switch_force
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AutoPause') is not None:
            self.auto_pause = m.get('AutoPause')
        if m.get('MaxCapacity') is not None:
            self.max_capacity = m.get('MaxCapacity')
        if m.get('MinCapacity') is not None:
            self.min_capacity = m.get('MinCapacity')
        if m.get('SwitchForce') is not None:
            self.switch_force = m.get('SwitchForce')
        return self


class CloneDBInstanceRequest(TeaModel):
    def __init__(self, backup_id=None, backup_type=None, category=None, dbinstance_class=None, dbinstance_id=None,
                 dbinstance_storage=None, dbinstance_storage_type=None, db_names=None, dedicated_host_group_id=None,
                 deletion_protection=None, instance_network_type=None, pay_type=None, period=None, private_ip_address=None,
                 region_id=None, resource_owner_id=None, restore_table=None, restore_time=None, serverless_config=None,
                 table_meta=None, used_time=None, vpcid=None, v_switch_id=None, zone_id=None, zone_id_slave_1=None,
                 zone_id_slave_2=None):
        # The ID of the backup set.
        # 
        # You can call the [DescribeBackups](~~26273~~) operation to query the backup sets.
        # 
        # > You must specify at least one of the **BackupId** and **RestoreTime** parameters.
        self.backup_id = backup_id  # type: str
        # The backup type. Valid values:
        # 
        # *   **FullBackup**: full backup
        # *   **IncrementalBackup**: incremental backup
        self.backup_type = backup_type  # type: str
        # The RDS edition of the new instance. Valid values:
        # 
        # *   **Basic**: RDS Basic Edition.
        # *   **HighAvailability**: RDS High-availability Edition.
        # *   **AlwaysOn**: RDS Cluster Edition for SQL Server.
        # *   **cluster**: RDS Cluster Edition for MySQL.
        # *   **Finance**: RDS Enterprise Edition. This edition is available only on the China site (aliyun.com).
        self.category = category  # type: str
        # The instance type of the new instance. For information, see [Primary ApsaraDB RDS instance types](~~26312~~).
        # 
        # > By default, the new instance uses the same instance type as the original primary instance.
        self.dbinstance_class = dbinstance_class  # type: str
        # The ID of the new instance.
        self.dbinstance_id = dbinstance_id  # type: str
        # The storage capacity of the new instance. Unit: GB. You can increase the storage capacity in increments of 5 GB. For more information, see [Primary ApsaraDB RDS instance types](~~26312~~).
        # 
        # > By default, the new instance has the same storage capacity as the original primary instance.
        self.dbinstance_storage = dbinstance_storage  # type: int
        # The storage type of the new instance. Valid values:
        # 
        # *   **local_ssd**: local SSDs
        # *   **cloud_ssd**: standard SSDs
        # *   **cloud_essd**: enhanced SSDs (ESSDs) of performance level 1 (PL1)
        # *   **cloud_essd2**: ESSDs of PL2
        # *   **cloud_essd3**: ESSDs of PL3
        self.dbinstance_storage_type = dbinstance_storage_type  # type: str
        # The name of the database. If you specify more than one database, the value is in the following format: `Original database name 1,Original database name 2`.
        self.db_names = db_names  # type: str
        # The ID of the dedicated cluster.
        self.dedicated_host_group_id = dedicated_host_group_id  # type: str
        # Specifies whether to enable the release protection feature for the new instance. Valid values:
        # 
        # *   **true**: enables the feature.
        # *   **false**: disables the feature.
        # 
        # Default value: **false**.
        self.deletion_protection = deletion_protection  # type: bool
        # The network type of the new instance. Valid values:
        # 
        # *   **VPC**\
        # *   **Classic**\
        # 
        # > By default, the new instance has the same network type as the original primary instance.
        self.instance_network_type = instance_network_type  # type: str
        # The billing method of the new instance. Valid values:
        # 
        # *   **Postpaid**: pay-as-you-go
        # *   **Prepaid**: subscription
        self.pay_type = pay_type  # type: str
        # The unit that is used to calculate the billing cycle of the new instance. Valid values:
        # 
        # *   **Year**\
        # *   **Month**\
        # 
        # > If you set the PayType parameter to **Prepaid**, you must specify the UsedTime parameter.
        self.period = period  # type: str
        # The internal IP address of the new instance, which must be within the CIDR block supported by the specified vSwitch. The system automatically assigns an internal IP address to the new instance based on the values of the **VPCId** and **VSwitchId** parameters.
        self.private_ip_address = private_ip_address  # type: str
        # The region ID of the new instance. You can call the [DescribeRegions](~~26243~~) operation to query the most recent region list.
        self.region_id = region_id  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # Specifies whether to restore only the databases and tables that you specify. The value **1** specifies to restore only the specified databases and tables. If you do not want to restore only the specified databases or tables, you can choose not to specify this parameter.
        self.restore_table = restore_table  # type: str
        # The point in time to which you want to restore data. The point in time must fall within the specified backup retention period. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time must be in UTC.
        # 
        # > You must specify at least one of the **BackupId** and **RestoreTime** parameters.
        self.restore_time = restore_time  # type: str
        # The configuration of a serverless instance. You must specify this parameter when you restore data to a new serverless instance.
        self.serverless_config = serverless_config  # type: CloneDBInstanceRequestServerlessConfig
        # The information about the database and table that you want to restore. Syntax: `[{"type":"db","name":"Name of Database 1","newname":"New name of Database 1","tables":[{"type":"table","name":"Name of Table 1 in Database 1","newname":"New name of Table 1"},{"type":"table","name":"Name of Table 2 in Database 1","newname":"New name of Table 2"}]},{"type":"db","name":"Name of Database 2","newname":"New name of Database 2","tables":[{"type":"table","name":"Name of Table 1 in Database 2","newname":"New name of Table 1"},{"type":"table","name":"Name of Table 2 in Database 2","newname":"New name of Table 2"}]}]`
        self.table_meta = table_meta  # type: str
        # The subscription duration of the new instance. Valid values:
        # 
        # *   If you set the **Period** parameter to **Year**, the value of the UsedTime parameter ranges from **1 to 3**.
        # *   If you set the **Period** parameter to **Month**, the value of the UsedTime parameter ranges from **1 to 9**.
        # 
        # > If you set the PayType parameter to **Prepaid**, you must specify the UsedTime parameter.
        self.used_time = used_time  # type: int
        # The ID of the virtual private cloud (VPC).
        # 
        # > Make sure that the VPC belongs to the required region.
        self.vpcid = vpcid  # type: str
        # The ID of the vSwitch that is associated with the specified VPC. The vSwitch must belong to the zone that is specified by the **ZoneId** parameter.
        # 
        # > 
        # 
        # *   If you set the **InstanceNetworkType** parameter to **VPC**, you must also specify the VSwitchId parameter.
        # 
        # *   If you specify the **ZoneSlaveId1** parameter, you must specify the IDs of two vSwitches for this parameter and separate the IDs with a comma (,).
        self.v_switch_id = v_switch_id  # type: str
        # The zone ID of the primary instance. You can call the [DescribeRegions](~~26243~~) operation to query the most recent zone list.
        # 
        # > By default, the new instance resides in the same region as the original instance.
        self.zone_id = zone_id  # type: str
        # The zone ID of the secondary instance. If you set the ZoneIdSlave1 parameter to the same value as the **ZoneId** parameter, the single-zone deployment method is used. If you set the ZoneIdSlave1 parameter to a different value from the **ZoneId** parameter, the multi-zone deployment method is used.
        self.zone_id_slave_1 = zone_id_slave_1  # type: str
        # The zone ID of the logger instance. If you set the ZoneIdSlave1 parameter to the same value as the **ZoneId** parameter, the single-zone deployment method is used. If you set the ZoneIdSlave1 parameter to a different value from the **ZoneId** parameter, the multi-zone deployment method is used.
        self.zone_id_slave_2 = zone_id_slave_2  # type: str

    def validate(self):
        if self.serverless_config:
            self.serverless_config.validate()

    def to_map(self):
        _map = super(CloneDBInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_id is not None:
            result['BackupId'] = self.backup_id
        if self.backup_type is not None:
            result['BackupType'] = self.backup_type
        if self.category is not None:
            result['Category'] = self.category
        if self.dbinstance_class is not None:
            result['DBInstanceClass'] = self.dbinstance_class
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dbinstance_storage is not None:
            result['DBInstanceStorage'] = self.dbinstance_storage
        if self.dbinstance_storage_type is not None:
            result['DBInstanceStorageType'] = self.dbinstance_storage_type
        if self.db_names is not None:
            result['DbNames'] = self.db_names
        if self.dedicated_host_group_id is not None:
            result['DedicatedHostGroupId'] = self.dedicated_host_group_id
        if self.deletion_protection is not None:
            result['DeletionProtection'] = self.deletion_protection
        if self.instance_network_type is not None:
            result['InstanceNetworkType'] = self.instance_network_type
        if self.pay_type is not None:
            result['PayType'] = self.pay_type
        if self.period is not None:
            result['Period'] = self.period
        if self.private_ip_address is not None:
            result['PrivateIpAddress'] = self.private_ip_address
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.restore_table is not None:
            result['RestoreTable'] = self.restore_table
        if self.restore_time is not None:
            result['RestoreTime'] = self.restore_time
        if self.serverless_config is not None:
            result['ServerlessConfig'] = self.serverless_config.to_map()
        if self.table_meta is not None:
            result['TableMeta'] = self.table_meta
        if self.used_time is not None:
            result['UsedTime'] = self.used_time
        if self.vpcid is not None:
            result['VPCId'] = self.vpcid
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.zone_id_slave_1 is not None:
            result['ZoneIdSlave1'] = self.zone_id_slave_1
        if self.zone_id_slave_2 is not None:
            result['ZoneIdSlave2'] = self.zone_id_slave_2
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BackupId') is not None:
            self.backup_id = m.get('BackupId')
        if m.get('BackupType') is not None:
            self.backup_type = m.get('BackupType')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('DBInstanceClass') is not None:
            self.dbinstance_class = m.get('DBInstanceClass')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DBInstanceStorage') is not None:
            self.dbinstance_storage = m.get('DBInstanceStorage')
        if m.get('DBInstanceStorageType') is not None:
            self.dbinstance_storage_type = m.get('DBInstanceStorageType')
        if m.get('DbNames') is not None:
            self.db_names = m.get('DbNames')
        if m.get('DedicatedHostGroupId') is not None:
            self.dedicated_host_group_id = m.get('DedicatedHostGroupId')
        if m.get('DeletionProtection') is not None:
            self.deletion_protection = m.get('DeletionProtection')
        if m.get('InstanceNetworkType') is not None:
            self.instance_network_type = m.get('InstanceNetworkType')
        if m.get('PayType') is not None:
            self.pay_type = m.get('PayType')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('PrivateIpAddress') is not None:
            self.private_ip_address = m.get('PrivateIpAddress')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RestoreTable') is not None:
            self.restore_table = m.get('RestoreTable')
        if m.get('RestoreTime') is not None:
            self.restore_time = m.get('RestoreTime')
        if m.get('ServerlessConfig') is not None:
            temp_model = CloneDBInstanceRequestServerlessConfig()
            self.serverless_config = temp_model.from_map(m['ServerlessConfig'])
        if m.get('TableMeta') is not None:
            self.table_meta = m.get('TableMeta')
        if m.get('UsedTime') is not None:
            self.used_time = m.get('UsedTime')
        if m.get('VPCId') is not None:
            self.vpcid = m.get('VPCId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('ZoneIdSlave1') is not None:
            self.zone_id_slave_1 = m.get('ZoneIdSlave1')
        if m.get('ZoneIdSlave2') is not None:
            self.zone_id_slave_2 = m.get('ZoneIdSlave2')
        return self


class CloneDBInstanceShrinkRequest(TeaModel):
    def __init__(self, backup_id=None, backup_type=None, category=None, dbinstance_class=None, dbinstance_id=None,
                 dbinstance_storage=None, dbinstance_storage_type=None, db_names=None, dedicated_host_group_id=None,
                 deletion_protection=None, instance_network_type=None, pay_type=None, period=None, private_ip_address=None,
                 region_id=None, resource_owner_id=None, restore_table=None, restore_time=None,
                 serverless_config_shrink=None, table_meta=None, used_time=None, vpcid=None, v_switch_id=None, zone_id=None,
                 zone_id_slave_1=None, zone_id_slave_2=None):
        # The ID of the backup set.
        # 
        # You can call the [DescribeBackups](~~26273~~) operation to query the backup sets.
        # 
        # > You must specify at least one of the **BackupId** and **RestoreTime** parameters.
        self.backup_id = backup_id  # type: str
        # The backup type. Valid values:
        # 
        # *   **FullBackup**: full backup
        # *   **IncrementalBackup**: incremental backup
        self.backup_type = backup_type  # type: str
        # The RDS edition of the new instance. Valid values:
        # 
        # *   **Basic**: RDS Basic Edition.
        # *   **HighAvailability**: RDS High-availability Edition.
        # *   **AlwaysOn**: RDS Cluster Edition for SQL Server.
        # *   **cluster**: RDS Cluster Edition for MySQL.
        # *   **Finance**: RDS Enterprise Edition. This edition is available only on the China site (aliyun.com).
        self.category = category  # type: str
        # The instance type of the new instance. For information, see [Primary ApsaraDB RDS instance types](~~26312~~).
        # 
        # > By default, the new instance uses the same instance type as the original primary instance.
        self.dbinstance_class = dbinstance_class  # type: str
        # The ID of the new instance.
        self.dbinstance_id = dbinstance_id  # type: str
        # The storage capacity of the new instance. Unit: GB. You can increase the storage capacity in increments of 5 GB. For more information, see [Primary ApsaraDB RDS instance types](~~26312~~).
        # 
        # > By default, the new instance has the same storage capacity as the original primary instance.
        self.dbinstance_storage = dbinstance_storage  # type: int
        # The storage type of the new instance. Valid values:
        # 
        # *   **local_ssd**: local SSDs
        # *   **cloud_ssd**: standard SSDs
        # *   **cloud_essd**: enhanced SSDs (ESSDs) of performance level 1 (PL1)
        # *   **cloud_essd2**: ESSDs of PL2
        # *   **cloud_essd3**: ESSDs of PL3
        self.dbinstance_storage_type = dbinstance_storage_type  # type: str
        # The name of the database. If you specify more than one database, the value is in the following format: `Original database name 1,Original database name 2`.
        self.db_names = db_names  # type: str
        # The ID of the dedicated cluster.
        self.dedicated_host_group_id = dedicated_host_group_id  # type: str
        # Specifies whether to enable the release protection feature for the new instance. Valid values:
        # 
        # *   **true**: enables the feature.
        # *   **false**: disables the feature.
        # 
        # Default value: **false**.
        self.deletion_protection = deletion_protection  # type: bool
        # The network type of the new instance. Valid values:
        # 
        # *   **VPC**\
        # *   **Classic**\
        # 
        # > By default, the new instance has the same network type as the original primary instance.
        self.instance_network_type = instance_network_type  # type: str
        # The billing method of the new instance. Valid values:
        # 
        # *   **Postpaid**: pay-as-you-go
        # *   **Prepaid**: subscription
        self.pay_type = pay_type  # type: str
        # The unit that is used to calculate the billing cycle of the new instance. Valid values:
        # 
        # *   **Year**\
        # *   **Month**\
        # 
        # > If you set the PayType parameter to **Prepaid**, you must specify the UsedTime parameter.
        self.period = period  # type: str
        # The internal IP address of the new instance, which must be within the CIDR block supported by the specified vSwitch. The system automatically assigns an internal IP address to the new instance based on the values of the **VPCId** and **VSwitchId** parameters.
        self.private_ip_address = private_ip_address  # type: str
        # The region ID of the new instance. You can call the [DescribeRegions](~~26243~~) operation to query the most recent region list.
        self.region_id = region_id  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # Specifies whether to restore only the databases and tables that you specify. The value **1** specifies to restore only the specified databases and tables. If you do not want to restore only the specified databases or tables, you can choose not to specify this parameter.
        self.restore_table = restore_table  # type: str
        # The point in time to which you want to restore data. The point in time must fall within the specified backup retention period. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time must be in UTC.
        # 
        # > You must specify at least one of the **BackupId** and **RestoreTime** parameters.
        self.restore_time = restore_time  # type: str
        # The configuration of a serverless instance. You must specify this parameter when you restore data to a new serverless instance.
        self.serverless_config_shrink = serverless_config_shrink  # type: str
        # The information about the database and table that you want to restore. Syntax: `[{"type":"db","name":"Name of Database 1","newname":"New name of Database 1","tables":[{"type":"table","name":"Name of Table 1 in Database 1","newname":"New name of Table 1"},{"type":"table","name":"Name of Table 2 in Database 1","newname":"New name of Table 2"}]},{"type":"db","name":"Name of Database 2","newname":"New name of Database 2","tables":[{"type":"table","name":"Name of Table 1 in Database 2","newname":"New name of Table 1"},{"type":"table","name":"Name of Table 2 in Database 2","newname":"New name of Table 2"}]}]`
        self.table_meta = table_meta  # type: str
        # The subscription duration of the new instance. Valid values:
        # 
        # *   If you set the **Period** parameter to **Year**, the value of the UsedTime parameter ranges from **1 to 3**.
        # *   If you set the **Period** parameter to **Month**, the value of the UsedTime parameter ranges from **1 to 9**.
        # 
        # > If you set the PayType parameter to **Prepaid**, you must specify the UsedTime parameter.
        self.used_time = used_time  # type: int
        # The ID of the virtual private cloud (VPC).
        # 
        # > Make sure that the VPC belongs to the required region.
        self.vpcid = vpcid  # type: str
        # The ID of the vSwitch that is associated with the specified VPC. The vSwitch must belong to the zone that is specified by the **ZoneId** parameter.
        # 
        # > 
        # 
        # *   If you set the **InstanceNetworkType** parameter to **VPC**, you must also specify the VSwitchId parameter.
        # 
        # *   If you specify the **ZoneSlaveId1** parameter, you must specify the IDs of two vSwitches for this parameter and separate the IDs with a comma (,).
        self.v_switch_id = v_switch_id  # type: str
        # The zone ID of the primary instance. You can call the [DescribeRegions](~~26243~~) operation to query the most recent zone list.
        # 
        # > By default, the new instance resides in the same region as the original instance.
        self.zone_id = zone_id  # type: str
        # The zone ID of the secondary instance. If you set the ZoneIdSlave1 parameter to the same value as the **ZoneId** parameter, the single-zone deployment method is used. If you set the ZoneIdSlave1 parameter to a different value from the **ZoneId** parameter, the multi-zone deployment method is used.
        self.zone_id_slave_1 = zone_id_slave_1  # type: str
        # The zone ID of the logger instance. If you set the ZoneIdSlave1 parameter to the same value as the **ZoneId** parameter, the single-zone deployment method is used. If you set the ZoneIdSlave1 parameter to a different value from the **ZoneId** parameter, the multi-zone deployment method is used.
        self.zone_id_slave_2 = zone_id_slave_2  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CloneDBInstanceShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_id is not None:
            result['BackupId'] = self.backup_id
        if self.backup_type is not None:
            result['BackupType'] = self.backup_type
        if self.category is not None:
            result['Category'] = self.category
        if self.dbinstance_class is not None:
            result['DBInstanceClass'] = self.dbinstance_class
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dbinstance_storage is not None:
            result['DBInstanceStorage'] = self.dbinstance_storage
        if self.dbinstance_storage_type is not None:
            result['DBInstanceStorageType'] = self.dbinstance_storage_type
        if self.db_names is not None:
            result['DbNames'] = self.db_names
        if self.dedicated_host_group_id is not None:
            result['DedicatedHostGroupId'] = self.dedicated_host_group_id
        if self.deletion_protection is not None:
            result['DeletionProtection'] = self.deletion_protection
        if self.instance_network_type is not None:
            result['InstanceNetworkType'] = self.instance_network_type
        if self.pay_type is not None:
            result['PayType'] = self.pay_type
        if self.period is not None:
            result['Period'] = self.period
        if self.private_ip_address is not None:
            result['PrivateIpAddress'] = self.private_ip_address
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.restore_table is not None:
            result['RestoreTable'] = self.restore_table
        if self.restore_time is not None:
            result['RestoreTime'] = self.restore_time
        if self.serverless_config_shrink is not None:
            result['ServerlessConfig'] = self.serverless_config_shrink
        if self.table_meta is not None:
            result['TableMeta'] = self.table_meta
        if self.used_time is not None:
            result['UsedTime'] = self.used_time
        if self.vpcid is not None:
            result['VPCId'] = self.vpcid
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.zone_id_slave_1 is not None:
            result['ZoneIdSlave1'] = self.zone_id_slave_1
        if self.zone_id_slave_2 is not None:
            result['ZoneIdSlave2'] = self.zone_id_slave_2
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BackupId') is not None:
            self.backup_id = m.get('BackupId')
        if m.get('BackupType') is not None:
            self.backup_type = m.get('BackupType')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('DBInstanceClass') is not None:
            self.dbinstance_class = m.get('DBInstanceClass')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DBInstanceStorage') is not None:
            self.dbinstance_storage = m.get('DBInstanceStorage')
        if m.get('DBInstanceStorageType') is not None:
            self.dbinstance_storage_type = m.get('DBInstanceStorageType')
        if m.get('DbNames') is not None:
            self.db_names = m.get('DbNames')
        if m.get('DedicatedHostGroupId') is not None:
            self.dedicated_host_group_id = m.get('DedicatedHostGroupId')
        if m.get('DeletionProtection') is not None:
            self.deletion_protection = m.get('DeletionProtection')
        if m.get('InstanceNetworkType') is not None:
            self.instance_network_type = m.get('InstanceNetworkType')
        if m.get('PayType') is not None:
            self.pay_type = m.get('PayType')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('PrivateIpAddress') is not None:
            self.private_ip_address = m.get('PrivateIpAddress')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RestoreTable') is not None:
            self.restore_table = m.get('RestoreTable')
        if m.get('RestoreTime') is not None:
            self.restore_time = m.get('RestoreTime')
        if m.get('ServerlessConfig') is not None:
            self.serverless_config_shrink = m.get('ServerlessConfig')
        if m.get('TableMeta') is not None:
            self.table_meta = m.get('TableMeta')
        if m.get('UsedTime') is not None:
            self.used_time = m.get('UsedTime')
        if m.get('VPCId') is not None:
            self.vpcid = m.get('VPCId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('ZoneIdSlave1') is not None:
            self.zone_id_slave_1 = m.get('ZoneIdSlave1')
        if m.get('ZoneIdSlave2') is not None:
            self.zone_id_slave_2 = m.get('ZoneIdSlave2')
        return self


class CloneDBInstanceResponseBody(TeaModel):
    def __init__(self, dbinstance_id=None, order_id=None, request_id=None):
        # The ID of the new instance.
        self.dbinstance_id = dbinstance_id  # type: str
        # The ID of the order.
        self.order_id = order_id  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CloneDBInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CloneDBInstanceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CloneDBInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CloneDBInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CloneDBInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CloneParameterGroupRequest(TeaModel):
    def __init__(self, owner_id=None, parameter_group_desc=None, parameter_group_id=None,
                 parameter_group_name=None, region_id=None, resource_owner_account=None, resource_owner_id=None, target_region_id=None):
        self.owner_id = owner_id  # type: long
        # The description of the parameter template in the destination region.
        self.parameter_group_desc = parameter_group_desc  # type: str
        # The ID of the parameter template. You can call the [DescribeParameterGroups](~~144491~~) operation to query the most recent parameter templates in a region.
        self.parameter_group_id = parameter_group_id  # type: str
        # The name of the parameter template in the destination region.
        self.parameter_group_name = parameter_group_name  # type: str
        # The ID of the source region to which the parameter template belongs. You can call the [DescribeRegions](~~26243~~) operation to query the most recent region list.
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The ID of the destination region. You can call the [DescribeRegions](~~26243~~) operation to query the most recent region list.
        self.target_region_id = target_region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CloneParameterGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.parameter_group_desc is not None:
            result['ParameterGroupDesc'] = self.parameter_group_desc
        if self.parameter_group_id is not None:
            result['ParameterGroupId'] = self.parameter_group_id
        if self.parameter_group_name is not None:
            result['ParameterGroupName'] = self.parameter_group_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.target_region_id is not None:
            result['TargetRegionId'] = self.target_region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ParameterGroupDesc') is not None:
            self.parameter_group_desc = m.get('ParameterGroupDesc')
        if m.get('ParameterGroupId') is not None:
            self.parameter_group_id = m.get('ParameterGroupId')
        if m.get('ParameterGroupName') is not None:
            self.parameter_group_name = m.get('ParameterGroupName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TargetRegionId') is not None:
            self.target_region_id = m.get('TargetRegionId')
        return self


class CloneParameterGroupResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CloneParameterGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CloneParameterGroupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CloneParameterGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CloneParameterGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CloneParameterGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ConfirmNotifyRequest(TeaModel):
    def __init__(self, confirmor=None, notify_id_list=None):
        # The ID of the Alibaba Cloud account that is used to confirm the notification. You can set this parameter to **0**, which indicates that the notification is confirmed by the system.
        self.confirmor = confirmor  # type: long
        # The IDs of the notifications that needs to be confirmed. You can call the [QueryNotify](~~427959~~) operation to query notifications for an instance.
        self.notify_id_list = notify_id_list  # type: list[long]

    def validate(self):
        pass

    def to_map(self):
        _map = super(ConfirmNotifyRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.confirmor is not None:
            result['Confirmor'] = self.confirmor
        if self.notify_id_list is not None:
            result['NotifyIdList'] = self.notify_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Confirmor') is not None:
            self.confirmor = m.get('Confirmor')
        if m.get('NotifyIdList') is not None:
            self.notify_id_list = m.get('NotifyIdList')
        return self


class ConfirmNotifyShrinkRequest(TeaModel):
    def __init__(self, confirmor=None, notify_id_list_shrink=None):
        # The ID of the Alibaba Cloud account that is used to confirm the notification. You can set this parameter to **0**, which indicates that the notification is confirmed by the system.
        self.confirmor = confirmor  # type: long
        # The IDs of the notifications that needs to be confirmed. You can call the [QueryNotify](~~427959~~) operation to query notifications for an instance.
        self.notify_id_list_shrink = notify_id_list_shrink  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ConfirmNotifyShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.confirmor is not None:
            result['Confirmor'] = self.confirmor
        if self.notify_id_list_shrink is not None:
            result['NotifyIdList'] = self.notify_id_list_shrink
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Confirmor') is not None:
            self.confirmor = m.get('Confirmor')
        if m.get('NotifyIdList') is not None:
            self.notify_id_list_shrink = m.get('NotifyIdList')
        return self


class ConfirmNotifyResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ConfirmNotifyResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ConfirmNotifyResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ConfirmNotifyResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ConfirmNotifyResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ConfirmNotifyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CopyDatabaseRequest(TeaModel):
    def __init__(self, owner_id=None, resource_owner_account=None, resource_owner_id=None):
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CopyDatabaseRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class CopyDatabaseResponseBody(TeaModel):
    def __init__(self, dbname=None, dbstatus=None, request_id=None, task_id=None):
        # The name of the database.
        self.dbname = dbname  # type: str
        # The status of the database. Valid values:
        # 
        # *   **Creating**\
        # *   **Running**\
        # *   **Deleting**\
        self.dbstatus = dbstatus  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The ID of the task.
        self.task_id = task_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CopyDatabaseResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbname is not None:
            result['DBName'] = self.dbname
        if self.dbstatus is not None:
            result['DBStatus'] = self.dbstatus
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DBName') is not None:
            self.dbname = m.get('DBName')
        if m.get('DBStatus') is not None:
            self.dbstatus = m.get('DBStatus')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class CopyDatabaseResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CopyDatabaseResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CopyDatabaseResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CopyDatabaseResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CopyDatabaseBetweenInstancesRequest(TeaModel):
    def __init__(self, backup_id=None, dbinstance_id=None, db_names=None, resource_owner_id=None, restore_time=None,
                 sync_user_privilege=None, target_dbinstance_id=None):
        # The ID of the backup set by which you want to restore databases of the source instance. You can call the [DescribeBackups](~~26273~~) operation to obtain the IDs of backup sets.
        # 
        # > You must specify one of the **BackupId** and **RestoreTime** parameters.
        self.backup_id = backup_id  # type: str
        # The ID of the source instance.
        self.dbinstance_id = dbinstance_id  # type: str
        # The names of the databases. Format: `{"Original database name 1":"New database name 1","Original database name 2":"New database name 2"}`.
        self.db_names = db_names  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The point in time when the system replicates databases. You can select a point in time within the backup retention period. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time must be in UTC.
        # 
        # > You must specify one of the **BackupId** and **RestoreTime** parameters.
        self.restore_time = restore_time  # type: str
        # Specifies whether to copy users and permissions.
        # 
        # *   **YES**: copies users and permissions. If the destination instance has a user whose name is the same as a user in the source instance, the permissions of the user in the source instance will also be granted to the user in the destination instance after you copy user permissions.
        # *   **NO**: does not copy users and permissions.
        # 
        # Default value: **NO**.
        self.sync_user_privilege = sync_user_privilege  # type: str
        # The ID of the destination instance, which must differ from the ID of the source instance.
        self.target_dbinstance_id = target_dbinstance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CopyDatabaseBetweenInstancesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_id is not None:
            result['BackupId'] = self.backup_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.db_names is not None:
            result['DbNames'] = self.db_names
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.restore_time is not None:
            result['RestoreTime'] = self.restore_time
        if self.sync_user_privilege is not None:
            result['SyncUserPrivilege'] = self.sync_user_privilege
        if self.target_dbinstance_id is not None:
            result['TargetDBInstanceId'] = self.target_dbinstance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BackupId') is not None:
            self.backup_id = m.get('BackupId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DbNames') is not None:
            self.db_names = m.get('DbNames')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RestoreTime') is not None:
            self.restore_time = m.get('RestoreTime')
        if m.get('SyncUserPrivilege') is not None:
            self.sync_user_privilege = m.get('SyncUserPrivilege')
        if m.get('TargetDBInstanceId') is not None:
            self.target_dbinstance_id = m.get('TargetDBInstanceId')
        return self


class CopyDatabaseBetweenInstancesResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CopyDatabaseBetweenInstancesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CopyDatabaseBetweenInstancesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CopyDatabaseBetweenInstancesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CopyDatabaseBetweenInstancesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CopyDatabaseBetweenInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateAccountRequest(TeaModel):
    def __init__(self, account_description=None, account_name=None, account_password=None, account_type=None,
                 dbinstance_id=None, owner_account=None, owner_id=None, resource_owner_account=None, resource_owner_id=None):
        # The description of the account. The value must be 2 to 256 characters in length The value can contain letters, digits, underscores (\_), and hyphens (-). The value must start with a letter.
        # 
        # > The value cannot start with http:// or https://.
        self.account_description = account_description  # type: str
        # The username of the account.
        # 
        # > 
        # 
        # *   The value must be unique.
        # 
        # *   The value starts with a lowercase letter and ends with a lowercase letter or a digit.
        # 
        # *   The value can contain lowercase letters, digits, and underscores (\_).
        # 
        # *   The length of the value must meet the following requirements:
        # 
        #     *   If the instance runs MySQL 5.7 or MySQL 8.0, the value must be 2 to 32 characters in length.
        #     *   If the instance runs MySQL 5.6, the value must be 2 to 16 characters in length.
        #     *   If the instance runs SQL Server, the value must be 2 to 64 characters in length.
        #     *   If the instance runs PostgreSQL with standard SSDs or enhanced ESSDs (ESSDs), the value must be 2 to 63 characters in length.
        #     *   If the instance runs PostgreSQL with local SSDs, the value must be 2 to 16 characters in length.
        #     *   If the instance runs MariaDB, the value must be 2 to 16 characters in length.
        # 
        # *   For more information about invalid characters, see [Forbidden keywords table](~~26317~~).
        self.account_name = account_name  # type: str
        # The password of the account.
        # 
        # > 
        # 
        # *   The value must be 8 to 32 characters in length.
        # 
        # *   The value must contain at least three types of the following characters: uppercase letters, lowercase letters, digits, and special characters.
        # *   The value can contain the following special characters: ! @ # $ % ^ & \* ( ) \_ + - =\
        self.account_password = account_password  # type: str
        # The type of the account. Valid values:
        # 
        # *   **Normal**: standard account
        # *   **Super**: privileged account
        # 
        # Default value: **Normal**.
        self.account_type = account_type  # type: str
        # The ID of the instance. You can call the [DescribeDBInstances](~~26232~~) operation to query the ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateAccountRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_description is not None:
            result['AccountDescription'] = self.account_description
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.account_password is not None:
            result['AccountPassword'] = self.account_password
        if self.account_type is not None:
            result['AccountType'] = self.account_type
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountDescription') is not None:
            self.account_description = m.get('AccountDescription')
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('AccountPassword') is not None:
            self.account_password = m.get('AccountPassword')
        if m.get('AccountType') is not None:
            self.account_type = m.get('AccountType')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class CreateAccountResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateAccountResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateAccountResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateAccountResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateAccountResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateAccountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateBackupRequest(TeaModel):
    def __init__(self, backup_method=None, backup_strategy=None, backup_type=None, dbinstance_id=None, dbname=None,
                 resource_group_id=None, resource_owner_id=None):
        # The backup type. Valid values:
        # 
        # *   **Logical**: logical backup
        # *   **Physical**: physical backup
        # *   **Snapshot**: snapshot backup
        # 
        # Default value: **Physical**.
        # 
        # > * You can perform a logical backup only when databases are created on the instance.
        # > * When you perform a snapshot backup on an ApsaraDB RDS for MariaDB instance, you must set this parameter to **Physical**.
        # > *   For more information about the supported backup types, see [Back up an ApsaraDB RDS for MySQL instance](~~98818~~).
        # > *   When you perform a snapshot backup on an ApsaraDB RDS for SQL Server instance that uses standard SSDs or enhanced SSDs (ESSD), you must set this parameter to **Snapshot**.
        self.backup_method = backup_method  # type: str
        # The policy that you want to use for the backup file. Valid values:
        # 
        # *   **db**: a database-level backup.
        # *   **instance**: an instance-level backup.
        # 
        # > You can specify this parameter when you perform a logical backup on an ApsaraDB RDS for MySQL instance. You can also specify this parameter when you perform a full physical backup on an ApsaraDB RDS for SQL Server instance.
        self.backup_strategy = backup_strategy  # type: str
        # The backup method. Valid values:
        # 
        # *   **Auto**: full or incremental backup that is automatically selected
        # *   **FullBackup**: full backup
        # 
        # Default value: **Auto**.
        # 
        # > * You must set this parameter only when the instance runs the SQL Server database engine.
        # > * This parameter is valid only when you set the **BackupMethod** parameter to **Physical**.
        self.backup_type = backup_type  # type: str
        # The ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        # The names of the databases whose data you want to back up. Separate the names of the databases with commas (,).
        # 
        # > You can specify this parameter when you perform a logical backup on individual databases of an ApsaraDB RDS for MySQL instance. You can also specify this parameter when you perform a full physical backup on individual databases of an ApsaraDB RDS for SQL Server instance.
        self.dbname = dbname  # type: str
        # The ID of the resource group.
        self.resource_group_id = resource_group_id  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateBackupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_method is not None:
            result['BackupMethod'] = self.backup_method
        if self.backup_strategy is not None:
            result['BackupStrategy'] = self.backup_strategy
        if self.backup_type is not None:
            result['BackupType'] = self.backup_type
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dbname is not None:
            result['DBName'] = self.dbname
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BackupMethod') is not None:
            self.backup_method = m.get('BackupMethod')
        if m.get('BackupStrategy') is not None:
            self.backup_strategy = m.get('BackupStrategy')
        if m.get('BackupType') is not None:
            self.backup_type = m.get('BackupType')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DBName') is not None:
            self.dbname = m.get('DBName')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class CreateBackupResponseBody(TeaModel):
    def __init__(self, backup_job_id=None, request_id=None):
        # The ID of the backup task.
        self.backup_job_id = backup_job_id  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateBackupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_job_id is not None:
            result['BackupJobId'] = self.backup_job_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BackupJobId') is not None:
            self.backup_job_id = m.get('BackupJobId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateBackupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateBackupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateBackupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateBackupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCloudMigrationPrecheckTaskRequest(TeaModel):
    def __init__(self, dbinstance_name=None, resource_owner_id=None, source_account=None, source_category=None,
                 source_ip_address=None, source_password=None, source_port=None, task_name=None):
        # The ID of the instance. You can call the [DescribeDBInstances](~~26232~~) operation to query the IDs of instances.
        self.dbinstance_name = dbinstance_name  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The username of the account that is used to connect to the self-managed PostgreSQL instance. Enter the username of the account that you created in the [Create an account for cloud migration on a self-managed PostgreSQL instance](~~369500~~) topic.
        self.source_account = source_account  # type: str
        # The environment in which the self-managed PostgreSQL instance runs.
        # 
        # *   **idcOnVpc**: The self-managed PostgreSQL instance resides in a data center, which can communicate with the VPC to which the ApsaraDB RDS for PostgreSQL instance belongs.
        # *   **ecsOnVpc**: The self-managed PostgreSQL instance resides on an ECS instance.
        # *   **internet**: The self-managed PostgreSQL instance resides on a device that is connected over the Internet.
        self.source_category = source_category  # type: str
        # The private or public IP address that is used to connect to the self-managed PostgreSQL instance.
        # 
        # *   If the self-managed PostgreSQL instance resides on an ECS instance, enter the private IP address of the ECS instance. For more information about how to obtain the private IP address of an ECS instance, see [View IP addresses](~~273914~~).
        # *   If the self-managed PostgreSQL instance resides in a data center, enter the IP address of the DNS server.
        self.source_ip_address = source_ip_address  # type: str
        # The password of the account that is used to connect to the self-managed PostgreSQL instance. Enter the password of the account that you created in the [Create an account for cloud migration on a self-managed PostgreSQL instance](~~369500~~) topic.
        self.source_password = source_password  # type: str
        # The port that is used to connect to the self-managed PostgreSQL instance. You can run the `netstat -a grep PGSQL` command to view the port.
        self.source_port = source_port  # type: long
        # The name of the cloud migration task. If you do not specify this parameter, ApsaraDB RDS automatically generates a name for the cloud migration task.
        self.task_name = task_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCloudMigrationPrecheckTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_name is not None:
            result['DBInstanceName'] = self.dbinstance_name
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.source_account is not None:
            result['SourceAccount'] = self.source_account
        if self.source_category is not None:
            result['SourceCategory'] = self.source_category
        if self.source_ip_address is not None:
            result['SourceIpAddress'] = self.source_ip_address
        if self.source_password is not None:
            result['SourcePassword'] = self.source_password
        if self.source_port is not None:
            result['SourcePort'] = self.source_port
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DBInstanceName') is not None:
            self.dbinstance_name = m.get('DBInstanceName')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SourceAccount') is not None:
            self.source_account = m.get('SourceAccount')
        if m.get('SourceCategory') is not None:
            self.source_category = m.get('SourceCategory')
        if m.get('SourceIpAddress') is not None:
            self.source_ip_address = m.get('SourceIpAddress')
        if m.get('SourcePassword') is not None:
            self.source_password = m.get('SourcePassword')
        if m.get('SourcePort') is not None:
            self.source_port = m.get('SourcePort')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        return self


class CreateCloudMigrationPrecheckTaskResponseBody(TeaModel):
    def __init__(self, dbinstance_name=None, request_id=None, task_id=None, task_name=None):
        # The name of the instance.
        self.dbinstance_name = dbinstance_name  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The ID of the cloud migration task.
        self.task_id = task_id  # type: long
        # The name of the cloud migration task.
        self.task_name = task_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCloudMigrationPrecheckTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_name is not None:
            result['DBInstanceName'] = self.dbinstance_name
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DBInstanceName') is not None:
            self.dbinstance_name = m.get('DBInstanceName')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        return self


class CreateCloudMigrationPrecheckTaskResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateCloudMigrationPrecheckTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateCloudMigrationPrecheckTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateCloudMigrationPrecheckTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCloudMigrationTaskRequest(TeaModel):
    def __init__(self, dbinstance_name=None, resource_owner_id=None, source_account=None, source_category=None,
                 source_ip_address=None, source_password=None, source_port=None, task_name=None):
        # The ID of the ApsaraDB RDS for PostgreSQL instance. You can call the [DescribeDBInstances](~~26232~~) operation to query the ID of the instance.
        self.dbinstance_name = dbinstance_name  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The username of the account that is used for cloud migration. For more information, see [Create an account for cloud migration on a self-managed PostgreSQL instance](~~369500~~).
        self.source_account = source_account  # type: str
        # The environment in which the self-managed PostgreSQL instance runs.
        # 
        # *   **idcOnVpc**: The self-managed PostgreSQL instance resides in an on-premises data center, which can communicate with the virtual private cloud (VPC) to which the ApsaraDB RDS for PostgreSQL instance belongs.
        # *   **ecsOnVpc**: The self-managed PostgreSQL instance resides on an ECS instance.
        # *   **internet**: The self-managed PostgreSQL instance resides on a device that is connected over the Internet.
        self.source_category = source_category  # type: str
        # The private or public IP address that is used to connect to the self-managed PostgreSQL instance.
        # 
        # *   If the self-managed PostgreSQL instance resides on an Elastic Compute Service (ECS) instance, enter the private IP address of the ECS instance. For more information, see [View IP addresses](~~273914~~).
        # *   If the self-managed PostgreSQL instance resides in an on-premises data center, enter the private IP address of the on-premises data center.
        # *   In the self-managed PostgreSQL instance resides on a device that is connected over the Internet, enter the public IP address of the device.
        self.source_ip_address = source_ip_address  # type: str
        # The password of the preceding account. For more information, see [Create an account for cloud migration on a self-managed PostgreSQL instance](~~369500~~).
        self.source_password = source_password  # type: str
        # The port number that is used to connect to the self-managed PostgreSQL instance. You can run the `netstat -a grep PGSQL` command to obtain the port number.
        self.source_port = source_port  # type: long
        # The name of the task. You can specify a custom task name. If you do not specify this parameter, ApsaraDB RDS automatically generates a task name.
        self.task_name = task_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCloudMigrationTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_name is not None:
            result['DBInstanceName'] = self.dbinstance_name
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.source_account is not None:
            result['SourceAccount'] = self.source_account
        if self.source_category is not None:
            result['SourceCategory'] = self.source_category
        if self.source_ip_address is not None:
            result['SourceIpAddress'] = self.source_ip_address
        if self.source_password is not None:
            result['SourcePassword'] = self.source_password
        if self.source_port is not None:
            result['SourcePort'] = self.source_port
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DBInstanceName') is not None:
            self.dbinstance_name = m.get('DBInstanceName')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SourceAccount') is not None:
            self.source_account = m.get('SourceAccount')
        if m.get('SourceCategory') is not None:
            self.source_category = m.get('SourceCategory')
        if m.get('SourceIpAddress') is not None:
            self.source_ip_address = m.get('SourceIpAddress')
        if m.get('SourcePassword') is not None:
            self.source_password = m.get('SourcePassword')
        if m.get('SourcePort') is not None:
            self.source_port = m.get('SourcePort')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        return self


class CreateCloudMigrationTaskResponseBody(TeaModel):
    def __init__(self, dbinstance_name=None, request_id=None, task_id=None, task_name=None):
        # The name of the ApsaraDB RDS for PostgreSQL instance.
        self.dbinstance_name = dbinstance_name  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The ID of the task.
        self.task_id = task_id  # type: long
        # The name of the task.
        self.task_name = task_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCloudMigrationTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_name is not None:
            result['DBInstanceName'] = self.dbinstance_name
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DBInstanceName') is not None:
            self.dbinstance_name = m.get('DBInstanceName')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        return self


class CreateCloudMigrationTaskResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateCloudMigrationTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateCloudMigrationTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateCloudMigrationTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDBInstanceRequestServerlessConfig(TeaModel):
    def __init__(self, auto_pause=None, max_capacity=None, min_capacity=None, switch_force=None):
        # Specifies whether to enable the smart startup and stop feature for the serverless instance. Valid values:
        # 
        # *   **true**: enables the feature.
        # *   **false**: disables the feature. This is the default value.
        # 
        # > After the smart startup and suspension feature is enabled, if no connections to the instance are established within 10 minutes, the instance is suspended. After a connection to the instance is established, the instance is resumed.
        self.auto_pause = auto_pause  # type: bool
        # The maximum number of RDS Capacity Units (RCUs). Valid values: **0.5 to 8**.
        # 
        # > The value of this parameter must be greater than or equal to the value of the **MinCapacity property** parameter.
        self.max_capacity = max_capacity  # type: float
        # The minimum number of RCUs. Valid values: **0.5 to 8**.
        # 
        # > The value of this parameter must be less than or equal to the value of the **MaxCapacity** parameter.
        self.min_capacity = min_capacity  # type: float
        # Specifies whether to enable the forced scaling feature for the serverless instance. Valid values:
        # 
        # *   **true**: enables the feature.
        # *   **false**: disables the feature. This is the default value.
        # 
        # 
        # 
        # > *   If you set this parameter to true, a transient connection that lasts approximately 1 minute occurs during forced scaling. Process with caution.
        # 
        # > *   The RCU scaling for a serverless instance immediately takes effect. In some cases, such as the execution of large transactions, the scaling does not immediately take effect. In this case, you can enable this feature to forcefully scale the RCUs of the instance.
        self.switch_force = switch_force  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDBInstanceRequestServerlessConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_pause is not None:
            result['AutoPause'] = self.auto_pause
        if self.max_capacity is not None:
            result['MaxCapacity'] = self.max_capacity
        if self.min_capacity is not None:
            result['MinCapacity'] = self.min_capacity
        if self.switch_force is not None:
            result['SwitchForce'] = self.switch_force
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AutoPause') is not None:
            self.auto_pause = m.get('AutoPause')
        if m.get('MaxCapacity') is not None:
            self.max_capacity = m.get('MaxCapacity')
        if m.get('MinCapacity') is not None:
            self.min_capacity = m.get('MinCapacity')
        if m.get('SwitchForce') is not None:
            self.switch_force = m.get('SwitchForce')
        return self


class CreateDBInstanceRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        # The key of the tag. You can use this parameter to add tags to the instance.
        # 
        # 
        # 
        # > *   If the specified tag key is an existing key, the system directly adds the tag key to the instance. You can call the [ListTagResources](~~141258~~) operation to query the details about the existing tags.
        # > 
        # *   If the specified tag key is not an existing key, the system creates the tag key and adds the tag key to the instance.
        # > *   The value of this parameter cannot be an empty string.
        # > *   This parameter must be used together with the **Tag.Value** parameter.
        self.key = key  # type: str
        # The tag value that is associated with the specified tag key. You can use this parameter to add tags to the instance.
        # 
        # 
        # 
        # > *   If the specified tag value is found in the specified tag key, the system directly adds the tag value to the instance. You can call the [ListTagResources](~~141258~~) operation to query the details about the existing tags.
        # 
        # > *   If the specified tag value is not found in the specified tag key, the system creates the tag value and adds the tag value to the instance.
        # > *   This parameter must be used together with the **Tag.Key** parameter.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDBInstanceRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateDBInstanceRequest(TeaModel):
    def __init__(self, amount=None, auto_renew=None, babelfish_config=None, business_info=None, category=None,
                 client_token=None, connection_mode=None, connection_string=None, create_strategy=None, dbinstance_class=None,
                 dbinstance_description=None, dbinstance_net_type=None, dbinstance_storage=None, dbinstance_storage_type=None,
                 dbis_ignore_case=None, dbparam_group_id=None, dbtime_zone=None, dedicated_host_group_id=None,
                 deletion_protection=None, dry_run=None, encryption_key=None, engine=None, engine_version=None,
                 instance_network_type=None, pay_type=None, period=None, port=None, private_ip_address=None, region_id=None,
                 resource_group_id=None, resource_owner_id=None, role_arn=None, security_iplist=None, serverless_config=None,
                 storage_auto_scale=None, storage_threshold=None, storage_upper_bound=None, system_dbcharset=None, tag=None,
                 target_dedicated_host_id_for_log=None, target_dedicated_host_id_for_master=None, target_dedicated_host_id_for_slave=None,
                 target_minor_version=None, used_time=None, user_backup_id=None, vpcid=None, v_switch_id=None, zone_id=None,
                 zone_id_slave_1=None, zone_id_slave_2=None):
        # The number of ApsaraDB RDS for MySQL instances that you want to create. The parameter takes effect only when you create multiple ApsaraDB RDS for MySQL instances at a time by using a single request.
        # 
        # Valid values: **1** to **20**. Default value: **1**.
        # 
        # 
        # 
        # > *   If you want to create multiple ApsaraDB RDS for MySQL instances at a time by using a single request, you can add tags to all the instances by using the **Tag.Key** parameter and the **Tag.Value** parameter. After the instances are created, you can manage the instances based on the tags.
        # 
        # > *   After you submit a request to create multiple ApsaraDB RDS for MySQL instances, this operation returns the **TaskId**, **RequestId**, and **Message** parameters. You can call the [DescribeDBInstanceAttribute](~~26231~~) operation to query the details about an instance.
        # > *   If the value of the **Engine** parameter is not **MySQL** and the value of the Amount parameter is greater than **1**, this operation fails and returns an error code `InvalidParam.Engine`.
        self.amount = amount  # type: int
        # Specifies whether to enable auto-renewal for the instance. You must specify this parameter only when the instance uses the subscription billing method. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        # 
        # 
        # 
        # >   If you set the Period parameter to Month, the auto-renewal cycle is one month. If you set the Period parameter to Year, the auto-renewal cycle is one year.
        self.auto_renew = auto_renew  # type: str
        # The configuration of the Babelfish feature for the instance that runs PostgreSQL.
        # 
        # Format:{"babelfishEnabled":"true","migrationMode":"xxxxxxx","masterUsername":"xxxxxxx","masterUserPassword":"xxxxxxxx"}
        # 
        # The following list describes the fields in the format:
        # 
        # *   **babelfishEnabled**: specifies whether to enable Babelfish for the instance. If you set this field to **true**, you enable Babelfish for the instance. If you leave this parameter empty, Babelfish is disabled for the instance.
        # *   **migrationMode**: The migration mode of the instance. Valid values: **single-db** and **multi-db**.
        # *   **masterUsername**: The username of the administrator account. The username can contain lowercase letters, digits, and underscores (\_). It must start with a letter and end with a letter or digit. It can be up to 63 characters in length and cannot start with pg.
        # *   **masterUserPassword**: The password of the administrator account. The password must contain at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters. It must be 8 to 32 characters in length. The password can contain any of the following characters: `! @ # $ % ^ & * ( ) _ + - =`.
        # 
        # > This parameter applies only to instances that run PostgreSQL. For more information about Babelfish for ApsaraDB RDS for PostgreSQL, see [Introduction to Babelfish](~~428613~~).
        self.babelfish_config = babelfish_config  # type: str
        # The additional business information about the instance.
        self.business_info = business_info  # type: str
        # The RDS edition of the instance. Valid values:
        # 
        # *   **Basic**: RDS Basic Edition
        # *   **HighAvailability**: RDS High-availability Edition
        # *   **AlwaysOn**: RDS Cluster Edition for SQL Server
        # *   **Finance**: RDS Enterprise Edition
        # *   **Serverless_basic**: RDS Serverless Basic Edition
        self.category = category  # type: str
        # The client token that is used to ensure the idempotence of the request. You can use the client to generate the value, but you must ensure that it is unique among different requests. The token can contain only ASCII characters and cannot exceed 64 characters in length.
        self.client_token = client_token  # type: str
        # The connection mode of the instance. Valid values:
        # 
        # *   **Standard**: standard mode
        # *   **Safe**: database proxy mode
        # 
        # ApsaraDB RDS automatically assigns a connection mode to the instance.
        # 
        # > If the RDS instance runs SQL Server 2012, SQL Server 2016, or SQL Server 2017, you must set this parameter to Standard.
        self.connection_mode = connection_mode  # type: str
        # The endpoint of the instance.
        # 
        # > The **DBInstanceNetType** parameter specifies whether the endpoint is internal or public.
        self.connection_string = connection_string  # type: str
        # The policy based on which multiple instances are created. The parameter takes effect only when the value of the **Amount** parameter is greater than 1.
        # 
        # *   **Atomicity**: atomicity. The instances are all created. If one instance cannot be created, none of the instances is created.
        # *   **Partial**: non-atomicity. Each instance is independently created. The failure in creating an instance does not affect the creation of the other instances.
        # 
        # > The default value of this parameter is **Atomicity**.
        self.create_strategy = create_strategy  # type: str
        # The instance type of the instance. For more information, see [Primary ApsaraDB RDS instance types](~~26312~~). You can also call the [DescribeAvailableResource](~~134039~~) operation to query the available instance types in a region.
        # 
        # > To create a serverless instance, you must set this parameter to **mysql.n2.serverless.1c**.
        self.dbinstance_class = dbinstance_class  # type: str
        # The name of the instance. The name must be 2 to 255 characters in length and can contain letters, digits, underscores (\_), and hyphens (-). The name must start with a letter.
        # 
        # > The value cannot start with http:// or https://.
        self.dbinstance_description = dbinstance_description  # type: str
        # The type of network connection to the instance. Valid values:
        # 
        # *   **Internet**\
        # *   **Intranet**\
        self.dbinstance_net_type = dbinstance_net_type  # type: str
        # The storage capacity of the instance. Unit: GB. The storage capacity increases in increments of 5 GB. For more information, see [Primary ApsaraDB RDS instance types](~~26312~~). You can also call the [DescribeAvailableResource](~~134039~~) operation to query the storage capacity range that is supported for a specified instance type in a region.
        self.dbinstance_storage = dbinstance_storage  # type: int
        # The storage type that is used by the instance. Valid values:
        # 
        # *   **local_ssd**: local SSD (recommended).
        # *   **cloud_ssd** :standard SSD. This storage type is not recommended. Standard SSDs are no longer available for purchase in some Alibaba Cloud regions.
        # *   **cloud_essd**: ESSD of performance level 1 (PL1).
        # *   **cloud_essd2**: ESSD of PL2.
        # *   **cloud_essd3**: ESSD of PL3.
        # 
        # > The default value of this parameter is determined by the instance type specified by the **DBInstanceClass** parameter.
        # 
        # *   If the instance type specifies the local SSD storage type, the default value of this parameter is **local_ssd**.
        # *   If the instance type specifies the standard SSD or ESSD storage type, the default value of this parameter is **cloud_essd**.
        self.dbinstance_storage_type = dbinstance_storage_type  # type: str
        # Specifies whether the table name is case-sensitive. Valid values:
        # 
        # *   **true**: Table names are not case-sensitive. This is the default value.
        # *   **false**: Table names are case-sensitive.
        self.dbis_ignore_case = dbis_ignore_case  # type: str
        # The ID of the parameter template that is used for the instance. You can call the [DescribeParameterGroups](~~144491~~) operation to query ID of the parameter template.
        # 
        # 
        # 
        # >    If you want to create an instance that runs MySQL on RDS Basic Edition and uses the X-Engine storage engine, you must call the preceding operation, locate the **mysql_xengine\_8.0\_basic_normal_safe** field in the response, find the ID of the required system parameter template, and then use the ID as the value for this parameter. \* If you want to create an instance that runs MySQL on RDS High-availability Edition and uses the X-Engine storage engine, you must call the preceding operation, locate the **mysql_xengine\_8.0\_standard_normal_safe** field in the response, find the ID of the required system parameter template, and then use the ID as the value for this parameter.
        self.dbparam_group_id = dbparam_group_id  # type: str
        # The time zone of the instance. This parameter takes effect only when you set the **Engine** parameter to **MySQL** or **PostgreSQL**.
        # 
        # *   If you set the **Engine** parameter to **MySQL**:
        # 
        #     *   The time zone of the instance is in UTC. Valid values: \*\*-12:59\*\* to **+13:00**.
        #     *   If the instance uses local SSDs, you can specify the name of the time zone. For example, you can specify the Asia/Hong_Kong time zone. For more information, see [Time zones](~~297356~~).
        # 
        # *   If you set the **Engine** parameter to **PostgreSQL**:
        # 
        #     *   The time zone of the instance is not in UTC. For more information, see [Time zones](~~297356~~).
        #     *   You can specify this parameter only when the instance runs PostgreSQL with standard SSDs or ESSDs.
        # 
        # > If the instance is a primary instance, you can specify this parameter. If the instance is a read-only instance, you cannot specify this parameter. A read-only instance inherits the time zone of its primary instance. - If you do not specify this parameter, the system assigns the default time zone of the region in which the instance resides to the instance.
        self.dbtime_zone = dbtime_zone  # type: str
        # The ID of the dedicated cluster to which the instance belongs.
        # 
        # If you create the instance in a dedicated cluster, you must specify this parameter.
        # 
        # 
        # 
        # > *   You can call the [DescribeDedicatedHostGroups](~~141946~~) operation to query the details about a dedicated cluster.
        # 
        # > *   If no dedicated clusters are created, you can call the [CreateDedicatedHostGroup](~~209828~~) operation to create a dedicated cluster.
        self.dedicated_host_group_id = dedicated_host_group_id  # type: str
        # Specifies whether to enable the release protection feature for the instance.
        # 
        # *   **true**: enables the feature.
        # *   **false**: disables the feature. This is the default value.
        self.deletion_protection = deletion_protection  # type: bool
        # Specifies whether to perform a precheck before the system creates the instance. Valid values:
        # 
        # *   **true**: The system prechecks the request and does not create the instance. The system prechecks items such as the request parameters, request format, service limits, and available resources.
        # *   **false**: The system sends the request without a precheck. If the request passes verification, the system creates the instance.
        self.dry_run = dry_run  # type: bool
        # The ID of the key that is used for disk encryption in the region in which the instance resides. If you specify the EncryptionKey parameter, disk encryption is automatically enabled. In this case, you must also specify the **RoleARN** parameter. Disk encryption cannot be disabled after it is enabled.
        # 
        # You can obtain the ID of the key from the Key Management Service (KMS) console. You can also create a key. For more information, see [Create a CMK](~~181610~~).
        self.encryption_key = encryption_key  # type: str
        # The database engine of the instance. Valid values:
        # 
        # *   **MySQL**\
        # *   **SQLServer**\
        # *   **PostgreSQL**\
        # *   **MariaDB**\
        # 
        # > To create a serverless instance, you must set this parameter to **MySQL**.
        self.engine = engine  # type: str
        # The database engine version of the instance.
        # 
        # *   Valid values when you set the Engine parameter to MySQL: **5.5**, **5.6**, **5.7**, and **8.0**\
        # *   Valid values when you set the Engine parameter to SQLServer: **2008r2**, **08r2\_ent_ha**, **2012**, **2012\_ent_ha**, **2012\_std_ha**, **2012\_web**, **2014\_std_ha**, **2016\_ent_ha**, **2016\_std_ha**, **2016\_web**, **2017\_std_ha**, **2017\_ent**, **2019\_std_ha**, and **2019\_ent**\
        # *   Valid values when you set the Engine parameter to PostgreSQL: **10.0**, **11.0**, **12.0**, **13.0**, **14.0**, and **15.0**\
        # *   Valid value when you set the Engine parameter to MariaDB: **10.3**\
        # 
        # > To create a serverless instance, you must set this parameter to **8.0**.
        self.engine_version = engine_version  # type: str
        # The network type of the instance. Valid values:
        # 
        # *   **VPC**: specifies a virtual private cloud (VPC).
        # *   **Classic**: specifies the.classic network. This is the default value.
        # 
        # > *   If the instance runs MySQL and uses standard SSDs or enhanced SSDs (ESSDs), you must set this parameter to **VPC**.
        # 
        # > *   If the instance runs PostgreSQL and MariaDB. you must set this parameter to **VPC**.
        # > *   If the instance runs SQL Server Basic or SQL Server Web, you can set this parameter to VPC or Classic. If the instance runs other database engines, you must set this parameter to **VPC**.
        self.instance_network_type = instance_network_type  # type: str
        # The billing method of the instance. Valid values:
        # 
        # *   **Postpaid**: pay-as-you-go.
        # *   **Prepaid**: subscription.
        # *   **Serverless**: serverless. This value is supported only for instances that run MySQL. For more information, see [Overview](~~411291~~).
        # 
        # > ApsaraDB RDS automatically generates a purchase order and completes the payment.
        self.pay_type = pay_type  # type: str
        # The unit of the subscription duration. Valid values:
        # 
        # *   **Year**: specifies year as the unit of the subscription duration.
        # *   **Month**: specifies month as the unit of the subscription duration.
        # 
        # > If you set the PayType parameter to **Prepaid**, you must specify the UsedTime parameter.
        self.period = period  # type: str
        # You can initialize the port when you create the RDS instance.
        # Valid values: 1000 to 599.
        self.port = port  # type: str
        # The private IP address of the instance. The private IP address must be within the CIDR block that is supported by the specified vSwitch. ApsaraDB RDS automatically assigns a private IP address to the instance based on the values of the **VPCId** and **vSwitchId** parameters.
        self.private_ip_address = private_ip_address  # type: str
        # The ID of the region. You can call the [DescribeRegions](~~26243~~) operation to query the most recent region list.
        self.region_id = region_id  # type: str
        # The ID of the resource group.
        self.resource_group_id = resource_group_id  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The Alibaba Cloud Resource Name (ARN) that is provided by your Alibaba Cloud account for RAM users. RAM users can use the ARN to connect ApsaraDB RDS to KMS. You can call the [CheckCloudResourceAuthorized](~~446261~~) operation to query the ARN.
        self.role_arn = role_arn  # type: str
        # The IP address whitelist of the instance. For more information, see [Use a database client or the CLI to connect to an ApsaraDB RDS for MySQL instance](~~43185~~). If the IP address whitelist contains more than one entry, separate the entries with commas (,). Each entry must be unique. The IP address whitelist can contain up to 1,000 entries. The entries in the IP address whitelist must be in one of the following formats:
        # 
        # *   IP addresses, such as 10.10.XX.XX.
        # *   CIDR blocks, such as 10.10.XX.XX/24. In this example, 24 indicates that the prefix of each IP address in the IP address whitelist is 24 bits in length. You can replace 24 with a value within the range of 1 to 32.
        self.security_iplist = security_iplist  # type: str
        # The settings of the serverless instance. This parameter is required when you create a serverless instance.
        # 
        # > This parameter takes effect only when you create an instance that runs MySQL.
        self.serverless_config = serverless_config  # type: CreateDBInstanceRequestServerlessConfig
        # Specifies whether to enable automatic storage expansion for the instance. Valid values:
        # 
        # *   **Enable**.
        # *   **Disable**. This is the default value.
        # 
        # > After the instance is created, you can call the [ModifyDasInstanceConfig](~~199281~~) operation to adjust the settings of automatic storage expansion for the instance. For more information, see [Configure automatic storage expansion for an ApsaraDB RDS for MySQL instance](~~173826~~).
        self.storage_auto_scale = storage_auto_scale  # type: str
        # The threshold based on which automatic storage expansion is triggered. Unit: percent. Valid values:
        # 
        # *   **10**\
        # *   **20**\
        # *   **30**\
        # *   **40**\
        # *   **50**\
        # 
        # > If you set the **StorageAutoScale** parameter to **Enable**, you must specify this parameter.
        self.storage_threshold = storage_threshold  # type: int
        # The maximum storage capacity that is allowed for automatic storage expansion. The storage capacity of the instance cannot exceed the maximum storage capacity. Unit: GB.
        # 
        # *   Valid values: an integer greater than or equal to 0.
        # *   If you set the **StorageAutoScale** parameter to **Enable**, you must also specify this parameter.
        self.storage_upper_bound = storage_upper_bound  # type: int
        # The character set that is used by the instance. This parameter is no longer used.
        self.system_dbcharset = system_dbcharset  # type: str
        # An array that consists of details of the tag.
        self.tag = tag  # type: list[CreateDBInstanceRequestTag]
        # The ID of the host to which the logger instance belongs in the specified dedicated cluster.
        # 
        # If the instance runs RDS Enterprise Edition and you create the instance in a dedicated cluster, you must specify this parameter. If you do not specify this parameter, the system automatically assigns a host.
        # 
        # 
        # 
        # > *   You can call the [DescribeDedicatedHosts](~~141948~~) operation to query the details about the hosts in a dedicated cluster.
        # > 
        # *   If no hosts are created, you can call the [CreateDedicatedHost](~~210864~~) operation to create a host.
        self.target_dedicated_host_id_for_log = target_dedicated_host_id_for_log  # type: str
        # The ID of the host to which the instance belongs in the specified dedicated cluster.
        # 
        # If you create the instance in a dedicated cluster, you must specify this parameter. If you do not specify this parameter, the system automatically assigns a host.
        # 
        # 
        # 
        # > *   You can call the [DescribeDedicatedHostGroups](~~141948~~) operation to query the details about a dedicated cluster.
        # 
        # > *   If no hosts are created, you can call the [CreateDedicatedHost](~~210864~~) operation to create a host.
        self.target_dedicated_host_id_for_master = target_dedicated_host_id_for_master  # type: str
        # The ID of the host to which the secondary instance belongs in the specified dedicated cluster.
        # 
        # If the instance runs RDS High-availability Edition or RDS Enterprise Edition and you create the instance in a dedicated cluster, you must specify this parameter. If you do not specify this parameter, the system automatically assigns a host.
        # 
        #  
        # 
        # >*   You can call the [DescribeDedicatedHosts](~~141948~~) operation to query the details about the hosts in a dedicated cluster.
        # 
        # >*   If no hosts are created, you can call the [CreateDedicatedHost](~~210864~~) operation to create a host.
        self.target_dedicated_host_id_for_slave = target_dedicated_host_id_for_slave  # type: str
        # The minor engine version of the instance. This parameter is required only when you create an instance that runs MySQL or PostgreSQL. The value format varies based on the database engine of the instance.
        # 
        # *   If you create an instance that runs MySQL, the value is in the following format: `<RDS edition>_<Minor engine version>`. Examples: `rds_20200229`, `xcluster_20200229`, and `xcluster80_20200229`. The following list describes the fields in the example values:
        # 
        #     *   rds: The instance runs RDS Basic Edition or High-availability Edition.
        #     *   xcluster: The instance runs MySQL 5.7 on RDS Enterprise Edition.
        #     *   xcluster80: The instance runs MySQL 8.0 on RDS Enterprise Edition.
        # 
        # > You can call the [DescribeDBMiniEngineVersions](~~445835~~) operation to query the minor engine version. For more information about minor engine versions, see [Release notes of minor AliSQL versions](~~96060~~).
        # 
        # *   If you create an instance that runs PostgreSQL, the value is in the following format: `rds_postgres_<Major engine version>00_<Minor engine version>`. Example: `rds_postgres_1400_20220830`. The following list describes the fields in the example value:
        # 
        #     *   1400: The major engine version is PostgreSQL 14.
        #     *   20220830: the AliPG version. You can call the [DescribeDBMiniEngineVersions](~~445835~~) operation to query the AliPG version. For more information about minor engine versions, see [Release notes for AliPG](~~126002~~).
        # 
        # > If you configure the **BabelfishConfig** parameter for your instance that runs PostgreSQL and set the babelfishEnabled field to true, the value of this parameter is in the following format: `rds_postgres_Major engine version00_AliPG version_babelfish`.
        self.target_minor_version = target_minor_version  # type: str
        # The subscription duration of the instance.
        # 
        # *   If you set the **Period** parameter to **Year**, the value of the **UsedTime** parameter ranges from **1 to 5**.
        # *   If you set the **Period** parameter to **Month**, the value of the **UsedTime** parameter ranges from **1 to 11**.
        # 
        # > If you set the PayType parameter to **Prepaid**, you must specify the UsedTime parameter.
        self.used_time = used_time  # type: str
        # The ID of the backup file. You can call the [ListUserBackupFiles](~~257821~~) operation to query backup files. If you create the instance by using a backup file, you must specify this parameter.
        # 
        # > You can specify this parameter only when the following requirements are met:
        # 
        # *   The **PayType** parameter is set to **Postpaid**.
        # *   The **Engine** parameter is set to **MySQL**.
        # *   The **EngineVersion** parameter is set to **5.7**.
        # *   The **Category** parameter is set to **Basic**.
        self.user_backup_id = user_backup_id  # type: str
        # The ID of the VPC to which the instance belongs.
        # 
        # > This parameter is available when you set the **InstanceNetworkType** parameter to **VPC**.
        self.vpcid = vpcid  # type: str
        # The ID of the vSwitch. The vSwitch must belong to the zone that is specified by the **ZoneId** parameter.
        # 
        #  
        # 
        # >*   If you set the **InstanceNetworkType** parameter to **VPC**, you must specify this parameter.
        # >
        # *   If you specify the ZoneSlaveId1 parameter, you must specify the IDs of two vSwitches for this parameter and separate the IDs with a comma (,).
        self.v_switch_id = v_switch_id  # type: str
        # The zone ID of the primary instance.
        # 
        # *   If you specify a VPC and a vSwitch, you must specify the ID of the zone to which the specified vSwitch belongs. Otherwise, the instance cannot be created.
        # 
        # *   If the instance runs RDS High-availability Edition, you must specify the **ZoneIdSlave1** parameter, which specifies whether to use the single-zone deployment method or the multi-zone deployment method.
        # *   If the instance runs RDS Enterprise Edition, you must specify the **ZoneIdSlave1** and **ZoneIdSlave2** parameters, which specify whether to use the single-zone deployment method or the multi-zone deployment method.
        self.zone_id = zone_id  # type: str
        # The ID of the zone in which the secondary instance resides. If you set the ZoneIdSlave1 parameter and the **ZoneId** parameter to the same value, the single-zone deployment method is used. If you set the ZoneIdSlave1 parameter and the **ZoneId** parameter to different values, the multi-zone deployment method is used.
        self.zone_id_slave_1 = zone_id_slave_1  # type: str
        # The ID of the zone in which the logger instance resides. If you set the ZoneIdSlave2 parameter and the **ZoneId** parameter to the same value, the single-zone deployment method is used. If you set the ZoneIdSlave2 parameter and the **ZoneId** parameter to different values, the multi-zone deployment method is used.
        self.zone_id_slave_2 = zone_id_slave_2  # type: str

    def validate(self):
        if self.serverless_config:
            self.serverless_config.validate()
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateDBInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.amount is not None:
            result['Amount'] = self.amount
        if self.auto_renew is not None:
            result['AutoRenew'] = self.auto_renew
        if self.babelfish_config is not None:
            result['BabelfishConfig'] = self.babelfish_config
        if self.business_info is not None:
            result['BusinessInfo'] = self.business_info
        if self.category is not None:
            result['Category'] = self.category
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.connection_mode is not None:
            result['ConnectionMode'] = self.connection_mode
        if self.connection_string is not None:
            result['ConnectionString'] = self.connection_string
        if self.create_strategy is not None:
            result['CreateStrategy'] = self.create_strategy
        if self.dbinstance_class is not None:
            result['DBInstanceClass'] = self.dbinstance_class
        if self.dbinstance_description is not None:
            result['DBInstanceDescription'] = self.dbinstance_description
        if self.dbinstance_net_type is not None:
            result['DBInstanceNetType'] = self.dbinstance_net_type
        if self.dbinstance_storage is not None:
            result['DBInstanceStorage'] = self.dbinstance_storage
        if self.dbinstance_storage_type is not None:
            result['DBInstanceStorageType'] = self.dbinstance_storage_type
        if self.dbis_ignore_case is not None:
            result['DBIsIgnoreCase'] = self.dbis_ignore_case
        if self.dbparam_group_id is not None:
            result['DBParamGroupId'] = self.dbparam_group_id
        if self.dbtime_zone is not None:
            result['DBTimeZone'] = self.dbtime_zone
        if self.dedicated_host_group_id is not None:
            result['DedicatedHostGroupId'] = self.dedicated_host_group_id
        if self.deletion_protection is not None:
            result['DeletionProtection'] = self.deletion_protection
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.encryption_key is not None:
            result['EncryptionKey'] = self.encryption_key
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.engine_version is not None:
            result['EngineVersion'] = self.engine_version
        if self.instance_network_type is not None:
            result['InstanceNetworkType'] = self.instance_network_type
        if self.pay_type is not None:
            result['PayType'] = self.pay_type
        if self.period is not None:
            result['Period'] = self.period
        if self.port is not None:
            result['Port'] = self.port
        if self.private_ip_address is not None:
            result['PrivateIpAddress'] = self.private_ip_address
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.role_arn is not None:
            result['RoleARN'] = self.role_arn
        if self.security_iplist is not None:
            result['SecurityIPList'] = self.security_iplist
        if self.serverless_config is not None:
            result['ServerlessConfig'] = self.serverless_config.to_map()
        if self.storage_auto_scale is not None:
            result['StorageAutoScale'] = self.storage_auto_scale
        if self.storage_threshold is not None:
            result['StorageThreshold'] = self.storage_threshold
        if self.storage_upper_bound is not None:
            result['StorageUpperBound'] = self.storage_upper_bound
        if self.system_dbcharset is not None:
            result['SystemDBCharset'] = self.system_dbcharset
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.target_dedicated_host_id_for_log is not None:
            result['TargetDedicatedHostIdForLog'] = self.target_dedicated_host_id_for_log
        if self.target_dedicated_host_id_for_master is not None:
            result['TargetDedicatedHostIdForMaster'] = self.target_dedicated_host_id_for_master
        if self.target_dedicated_host_id_for_slave is not None:
            result['TargetDedicatedHostIdForSlave'] = self.target_dedicated_host_id_for_slave
        if self.target_minor_version is not None:
            result['TargetMinorVersion'] = self.target_minor_version
        if self.used_time is not None:
            result['UsedTime'] = self.used_time
        if self.user_backup_id is not None:
            result['UserBackupId'] = self.user_backup_id
        if self.vpcid is not None:
            result['VPCId'] = self.vpcid
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.zone_id_slave_1 is not None:
            result['ZoneIdSlave1'] = self.zone_id_slave_1
        if self.zone_id_slave_2 is not None:
            result['ZoneIdSlave2'] = self.zone_id_slave_2
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Amount') is not None:
            self.amount = m.get('Amount')
        if m.get('AutoRenew') is not None:
            self.auto_renew = m.get('AutoRenew')
        if m.get('BabelfishConfig') is not None:
            self.babelfish_config = m.get('BabelfishConfig')
        if m.get('BusinessInfo') is not None:
            self.business_info = m.get('BusinessInfo')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('ConnectionMode') is not None:
            self.connection_mode = m.get('ConnectionMode')
        if m.get('ConnectionString') is not None:
            self.connection_string = m.get('ConnectionString')
        if m.get('CreateStrategy') is not None:
            self.create_strategy = m.get('CreateStrategy')
        if m.get('DBInstanceClass') is not None:
            self.dbinstance_class = m.get('DBInstanceClass')
        if m.get('DBInstanceDescription') is not None:
            self.dbinstance_description = m.get('DBInstanceDescription')
        if m.get('DBInstanceNetType') is not None:
            self.dbinstance_net_type = m.get('DBInstanceNetType')
        if m.get('DBInstanceStorage') is not None:
            self.dbinstance_storage = m.get('DBInstanceStorage')
        if m.get('DBInstanceStorageType') is not None:
            self.dbinstance_storage_type = m.get('DBInstanceStorageType')
        if m.get('DBIsIgnoreCase') is not None:
            self.dbis_ignore_case = m.get('DBIsIgnoreCase')
        if m.get('DBParamGroupId') is not None:
            self.dbparam_group_id = m.get('DBParamGroupId')
        if m.get('DBTimeZone') is not None:
            self.dbtime_zone = m.get('DBTimeZone')
        if m.get('DedicatedHostGroupId') is not None:
            self.dedicated_host_group_id = m.get('DedicatedHostGroupId')
        if m.get('DeletionProtection') is not None:
            self.deletion_protection = m.get('DeletionProtection')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('EncryptionKey') is not None:
            self.encryption_key = m.get('EncryptionKey')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('EngineVersion') is not None:
            self.engine_version = m.get('EngineVersion')
        if m.get('InstanceNetworkType') is not None:
            self.instance_network_type = m.get('InstanceNetworkType')
        if m.get('PayType') is not None:
            self.pay_type = m.get('PayType')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('PrivateIpAddress') is not None:
            self.private_ip_address = m.get('PrivateIpAddress')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RoleARN') is not None:
            self.role_arn = m.get('RoleARN')
        if m.get('SecurityIPList') is not None:
            self.security_iplist = m.get('SecurityIPList')
        if m.get('ServerlessConfig') is not None:
            temp_model = CreateDBInstanceRequestServerlessConfig()
            self.serverless_config = temp_model.from_map(m['ServerlessConfig'])
        if m.get('StorageAutoScale') is not None:
            self.storage_auto_scale = m.get('StorageAutoScale')
        if m.get('StorageThreshold') is not None:
            self.storage_threshold = m.get('StorageThreshold')
        if m.get('StorageUpperBound') is not None:
            self.storage_upper_bound = m.get('StorageUpperBound')
        if m.get('SystemDBCharset') is not None:
            self.system_dbcharset = m.get('SystemDBCharset')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateDBInstanceRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('TargetDedicatedHostIdForLog') is not None:
            self.target_dedicated_host_id_for_log = m.get('TargetDedicatedHostIdForLog')
        if m.get('TargetDedicatedHostIdForMaster') is not None:
            self.target_dedicated_host_id_for_master = m.get('TargetDedicatedHostIdForMaster')
        if m.get('TargetDedicatedHostIdForSlave') is not None:
            self.target_dedicated_host_id_for_slave = m.get('TargetDedicatedHostIdForSlave')
        if m.get('TargetMinorVersion') is not None:
            self.target_minor_version = m.get('TargetMinorVersion')
        if m.get('UsedTime') is not None:
            self.used_time = m.get('UsedTime')
        if m.get('UserBackupId') is not None:
            self.user_backup_id = m.get('UserBackupId')
        if m.get('VPCId') is not None:
            self.vpcid = m.get('VPCId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('ZoneIdSlave1') is not None:
            self.zone_id_slave_1 = m.get('ZoneIdSlave1')
        if m.get('ZoneIdSlave2') is not None:
            self.zone_id_slave_2 = m.get('ZoneIdSlave2')
        return self


class CreateDBInstanceShrinkRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        # The key of the tag. You can use this parameter to add tags to the instance.
        # 
        # 
        # 
        # > *   If the specified tag key is an existing key, the system directly adds the tag key to the instance. You can call the [ListTagResources](~~141258~~) operation to query the details about the existing tags.
        # > 
        # *   If the specified tag key is not an existing key, the system creates the tag key and adds the tag key to the instance.
        # > *   The value of this parameter cannot be an empty string.
        # > *   This parameter must be used together with the **Tag.Value** parameter.
        self.key = key  # type: str
        # The tag value that is associated with the specified tag key. You can use this parameter to add tags to the instance.
        # 
        # 
        # 
        # > *   If the specified tag value is found in the specified tag key, the system directly adds the tag value to the instance. You can call the [ListTagResources](~~141258~~) operation to query the details about the existing tags.
        # 
        # > *   If the specified tag value is not found in the specified tag key, the system creates the tag value and adds the tag value to the instance.
        # > *   This parameter must be used together with the **Tag.Key** parameter.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDBInstanceShrinkRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateDBInstanceShrinkRequest(TeaModel):
    def __init__(self, amount=None, auto_renew=None, babelfish_config=None, business_info=None, category=None,
                 client_token=None, connection_mode=None, connection_string=None, create_strategy=None, dbinstance_class=None,
                 dbinstance_description=None, dbinstance_net_type=None, dbinstance_storage=None, dbinstance_storage_type=None,
                 dbis_ignore_case=None, dbparam_group_id=None, dbtime_zone=None, dedicated_host_group_id=None,
                 deletion_protection=None, dry_run=None, encryption_key=None, engine=None, engine_version=None,
                 instance_network_type=None, pay_type=None, period=None, port=None, private_ip_address=None, region_id=None,
                 resource_group_id=None, resource_owner_id=None, role_arn=None, security_iplist=None, serverless_config_shrink=None,
                 storage_auto_scale=None, storage_threshold=None, storage_upper_bound=None, system_dbcharset=None, tag=None,
                 target_dedicated_host_id_for_log=None, target_dedicated_host_id_for_master=None, target_dedicated_host_id_for_slave=None,
                 target_minor_version=None, used_time=None, user_backup_id=None, vpcid=None, v_switch_id=None, zone_id=None,
                 zone_id_slave_1=None, zone_id_slave_2=None):
        # The number of ApsaraDB RDS for MySQL instances that you want to create. The parameter takes effect only when you create multiple ApsaraDB RDS for MySQL instances at a time by using a single request.
        # 
        # Valid values: **1** to **20**. Default value: **1**.
        # 
        # 
        # 
        # > *   If you want to create multiple ApsaraDB RDS for MySQL instances at a time by using a single request, you can add tags to all the instances by using the **Tag.Key** parameter and the **Tag.Value** parameter. After the instances are created, you can manage the instances based on the tags.
        # 
        # > *   After you submit a request to create multiple ApsaraDB RDS for MySQL instances, this operation returns the **TaskId**, **RequestId**, and **Message** parameters. You can call the [DescribeDBInstanceAttribute](~~26231~~) operation to query the details about an instance.
        # > *   If the value of the **Engine** parameter is not **MySQL** and the value of the Amount parameter is greater than **1**, this operation fails and returns an error code `InvalidParam.Engine`.
        self.amount = amount  # type: int
        # Specifies whether to enable auto-renewal for the instance. You must specify this parameter only when the instance uses the subscription billing method. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        # 
        # 
        # 
        # >   If you set the Period parameter to Month, the auto-renewal cycle is one month. If you set the Period parameter to Year, the auto-renewal cycle is one year.
        self.auto_renew = auto_renew  # type: str
        # The configuration of the Babelfish feature for the instance that runs PostgreSQL.
        # 
        # Format:{"babelfishEnabled":"true","migrationMode":"xxxxxxx","masterUsername":"xxxxxxx","masterUserPassword":"xxxxxxxx"}
        # 
        # The following list describes the fields in the format:
        # 
        # *   **babelfishEnabled**: specifies whether to enable Babelfish for the instance. If you set this field to **true**, you enable Babelfish for the instance. If you leave this parameter empty, Babelfish is disabled for the instance.
        # *   **migrationMode**: The migration mode of the instance. Valid values: **single-db** and **multi-db**.
        # *   **masterUsername**: The username of the administrator account. The username can contain lowercase letters, digits, and underscores (\_). It must start with a letter and end with a letter or digit. It can be up to 63 characters in length and cannot start with pg.
        # *   **masterUserPassword**: The password of the administrator account. The password must contain at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters. It must be 8 to 32 characters in length. The password can contain any of the following characters: `! @ # $ % ^ & * ( ) _ + - =`.
        # 
        # > This parameter applies only to instances that run PostgreSQL. For more information about Babelfish for ApsaraDB RDS for PostgreSQL, see [Introduction to Babelfish](~~428613~~).
        self.babelfish_config = babelfish_config  # type: str
        # The additional business information about the instance.
        self.business_info = business_info  # type: str
        # The RDS edition of the instance. Valid values:
        # 
        # *   **Basic**: RDS Basic Edition
        # *   **HighAvailability**: RDS High-availability Edition
        # *   **AlwaysOn**: RDS Cluster Edition for SQL Server
        # *   **Finance**: RDS Enterprise Edition
        # *   **Serverless_basic**: RDS Serverless Basic Edition
        self.category = category  # type: str
        # The client token that is used to ensure the idempotence of the request. You can use the client to generate the value, but you must ensure that it is unique among different requests. The token can contain only ASCII characters and cannot exceed 64 characters in length.
        self.client_token = client_token  # type: str
        # The connection mode of the instance. Valid values:
        # 
        # *   **Standard**: standard mode
        # *   **Safe**: database proxy mode
        # 
        # ApsaraDB RDS automatically assigns a connection mode to the instance.
        # 
        # > If the RDS instance runs SQL Server 2012, SQL Server 2016, or SQL Server 2017, you must set this parameter to Standard.
        self.connection_mode = connection_mode  # type: str
        # The endpoint of the instance.
        # 
        # > The **DBInstanceNetType** parameter specifies whether the endpoint is internal or public.
        self.connection_string = connection_string  # type: str
        # The policy based on which multiple instances are created. The parameter takes effect only when the value of the **Amount** parameter is greater than 1.
        # 
        # *   **Atomicity**: atomicity. The instances are all created. If one instance cannot be created, none of the instances is created.
        # *   **Partial**: non-atomicity. Each instance is independently created. The failure in creating an instance does not affect the creation of the other instances.
        # 
        # > The default value of this parameter is **Atomicity**.
        self.create_strategy = create_strategy  # type: str
        # The instance type of the instance. For more information, see [Primary ApsaraDB RDS instance types](~~26312~~). You can also call the [DescribeAvailableResource](~~134039~~) operation to query the available instance types in a region.
        # 
        # > To create a serverless instance, you must set this parameter to **mysql.n2.serverless.1c**.
        self.dbinstance_class = dbinstance_class  # type: str
        # The name of the instance. The name must be 2 to 255 characters in length and can contain letters, digits, underscores (\_), and hyphens (-). The name must start with a letter.
        # 
        # > The value cannot start with http:// or https://.
        self.dbinstance_description = dbinstance_description  # type: str
        # The type of network connection to the instance. Valid values:
        # 
        # *   **Internet**\
        # *   **Intranet**\
        self.dbinstance_net_type = dbinstance_net_type  # type: str
        # The storage capacity of the instance. Unit: GB. The storage capacity increases in increments of 5 GB. For more information, see [Primary ApsaraDB RDS instance types](~~26312~~). You can also call the [DescribeAvailableResource](~~134039~~) operation to query the storage capacity range that is supported for a specified instance type in a region.
        self.dbinstance_storage = dbinstance_storage  # type: int
        # The storage type that is used by the instance. Valid values:
        # 
        # *   **local_ssd**: local SSD (recommended).
        # *   **cloud_ssd** :standard SSD. This storage type is not recommended. Standard SSDs are no longer available for purchase in some Alibaba Cloud regions.
        # *   **cloud_essd**: ESSD of performance level 1 (PL1).
        # *   **cloud_essd2**: ESSD of PL2.
        # *   **cloud_essd3**: ESSD of PL3.
        # 
        # > The default value of this parameter is determined by the instance type specified by the **DBInstanceClass** parameter.
        # 
        # *   If the instance type specifies the local SSD storage type, the default value of this parameter is **local_ssd**.
        # *   If the instance type specifies the standard SSD or ESSD storage type, the default value of this parameter is **cloud_essd**.
        self.dbinstance_storage_type = dbinstance_storage_type  # type: str
        # Specifies whether the table name is case-sensitive. Valid values:
        # 
        # *   **true**: Table names are not case-sensitive. This is the default value.
        # *   **false**: Table names are case-sensitive.
        self.dbis_ignore_case = dbis_ignore_case  # type: str
        # The ID of the parameter template that is used for the instance. You can call the [DescribeParameterGroups](~~144491~~) operation to query ID of the parameter template.
        # 
        # 
        # 
        # >    If you want to create an instance that runs MySQL on RDS Basic Edition and uses the X-Engine storage engine, you must call the preceding operation, locate the **mysql_xengine\_8.0\_basic_normal_safe** field in the response, find the ID of the required system parameter template, and then use the ID as the value for this parameter. \* If you want to create an instance that runs MySQL on RDS High-availability Edition and uses the X-Engine storage engine, you must call the preceding operation, locate the **mysql_xengine\_8.0\_standard_normal_safe** field in the response, find the ID of the required system parameter template, and then use the ID as the value for this parameter.
        self.dbparam_group_id = dbparam_group_id  # type: str
        # The time zone of the instance. This parameter takes effect only when you set the **Engine** parameter to **MySQL** or **PostgreSQL**.
        # 
        # *   If you set the **Engine** parameter to **MySQL**:
        # 
        #     *   The time zone of the instance is in UTC. Valid values: \*\*-12:59\*\* to **+13:00**.
        #     *   If the instance uses local SSDs, you can specify the name of the time zone. For example, you can specify the Asia/Hong_Kong time zone. For more information, see [Time zones](~~297356~~).
        # 
        # *   If you set the **Engine** parameter to **PostgreSQL**:
        # 
        #     *   The time zone of the instance is not in UTC. For more information, see [Time zones](~~297356~~).
        #     *   You can specify this parameter only when the instance runs PostgreSQL with standard SSDs or ESSDs.
        # 
        # > If the instance is a primary instance, you can specify this parameter. If the instance is a read-only instance, you cannot specify this parameter. A read-only instance inherits the time zone of its primary instance. - If you do not specify this parameter, the system assigns the default time zone of the region in which the instance resides to the instance.
        self.dbtime_zone = dbtime_zone  # type: str
        # The ID of the dedicated cluster to which the instance belongs.
        # 
        # If you create the instance in a dedicated cluster, you must specify this parameter.
        # 
        # 
        # 
        # > *   You can call the [DescribeDedicatedHostGroups](~~141946~~) operation to query the details about a dedicated cluster.
        # 
        # > *   If no dedicated clusters are created, you can call the [CreateDedicatedHostGroup](~~209828~~) operation to create a dedicated cluster.
        self.dedicated_host_group_id = dedicated_host_group_id  # type: str
        # Specifies whether to enable the release protection feature for the instance.
        # 
        # *   **true**: enables the feature.
        # *   **false**: disables the feature. This is the default value.
        self.deletion_protection = deletion_protection  # type: bool
        # Specifies whether to perform a precheck before the system creates the instance. Valid values:
        # 
        # *   **true**: The system prechecks the request and does not create the instance. The system prechecks items such as the request parameters, request format, service limits, and available resources.
        # *   **false**: The system sends the request without a precheck. If the request passes verification, the system creates the instance.
        self.dry_run = dry_run  # type: bool
        # The ID of the key that is used for disk encryption in the region in which the instance resides. If you specify the EncryptionKey parameter, disk encryption is automatically enabled. In this case, you must also specify the **RoleARN** parameter. Disk encryption cannot be disabled after it is enabled.
        # 
        # You can obtain the ID of the key from the Key Management Service (KMS) console. You can also create a key. For more information, see [Create a CMK](~~181610~~).
        self.encryption_key = encryption_key  # type: str
        # The database engine of the instance. Valid values:
        # 
        # *   **MySQL**\
        # *   **SQLServer**\
        # *   **PostgreSQL**\
        # *   **MariaDB**\
        # 
        # > To create a serverless instance, you must set this parameter to **MySQL**.
        self.engine = engine  # type: str
        # The database engine version of the instance.
        # 
        # *   Valid values when you set the Engine parameter to MySQL: **5.5**, **5.6**, **5.7**, and **8.0**\
        # *   Valid values when you set the Engine parameter to SQLServer: **2008r2**, **08r2\_ent_ha**, **2012**, **2012\_ent_ha**, **2012\_std_ha**, **2012\_web**, **2014\_std_ha**, **2016\_ent_ha**, **2016\_std_ha**, **2016\_web**, **2017\_std_ha**, **2017\_ent**, **2019\_std_ha**, and **2019\_ent**\
        # *   Valid values when you set the Engine parameter to PostgreSQL: **10.0**, **11.0**, **12.0**, **13.0**, **14.0**, and **15.0**\
        # *   Valid value when you set the Engine parameter to MariaDB: **10.3**\
        # 
        # > To create a serverless instance, you must set this parameter to **8.0**.
        self.engine_version = engine_version  # type: str
        # The network type of the instance. Valid values:
        # 
        # *   **VPC**: specifies a virtual private cloud (VPC).
        # *   **Classic**: specifies the.classic network. This is the default value.
        # 
        # > *   If the instance runs MySQL and uses standard SSDs or enhanced SSDs (ESSDs), you must set this parameter to **VPC**.
        # 
        # > *   If the instance runs PostgreSQL and MariaDB. you must set this parameter to **VPC**.
        # > *   If the instance runs SQL Server Basic or SQL Server Web, you can set this parameter to VPC or Classic. If the instance runs other database engines, you must set this parameter to **VPC**.
        self.instance_network_type = instance_network_type  # type: str
        # The billing method of the instance. Valid values:
        # 
        # *   **Postpaid**: pay-as-you-go.
        # *   **Prepaid**: subscription.
        # *   **Serverless**: serverless. This value is supported only for instances that run MySQL. For more information, see [Overview](~~411291~~).
        # 
        # > ApsaraDB RDS automatically generates a purchase order and completes the payment.
        self.pay_type = pay_type  # type: str
        # The unit of the subscription duration. Valid values:
        # 
        # *   **Year**: specifies year as the unit of the subscription duration.
        # *   **Month**: specifies month as the unit of the subscription duration.
        # 
        # > If you set the PayType parameter to **Prepaid**, you must specify the UsedTime parameter.
        self.period = period  # type: str
        # You can initialize the port when you create the RDS instance.
        # Valid values: 1000 to 599.
        self.port = port  # type: str
        # The private IP address of the instance. The private IP address must be within the CIDR block that is supported by the specified vSwitch. ApsaraDB RDS automatically assigns a private IP address to the instance based on the values of the **VPCId** and **vSwitchId** parameters.
        self.private_ip_address = private_ip_address  # type: str
        # The ID of the region. You can call the [DescribeRegions](~~26243~~) operation to query the most recent region list.
        self.region_id = region_id  # type: str
        # The ID of the resource group.
        self.resource_group_id = resource_group_id  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The Alibaba Cloud Resource Name (ARN) that is provided by your Alibaba Cloud account for RAM users. RAM users can use the ARN to connect ApsaraDB RDS to KMS. You can call the [CheckCloudResourceAuthorized](~~446261~~) operation to query the ARN.
        self.role_arn = role_arn  # type: str
        # The IP address whitelist of the instance. For more information, see [Use a database client or the CLI to connect to an ApsaraDB RDS for MySQL instance](~~43185~~). If the IP address whitelist contains more than one entry, separate the entries with commas (,). Each entry must be unique. The IP address whitelist can contain up to 1,000 entries. The entries in the IP address whitelist must be in one of the following formats:
        # 
        # *   IP addresses, such as 10.10.XX.XX.
        # *   CIDR blocks, such as 10.10.XX.XX/24. In this example, 24 indicates that the prefix of each IP address in the IP address whitelist is 24 bits in length. You can replace 24 with a value within the range of 1 to 32.
        self.security_iplist = security_iplist  # type: str
        # The settings of the serverless instance. This parameter is required when you create a serverless instance.
        # 
        # > This parameter takes effect only when you create an instance that runs MySQL.
        self.serverless_config_shrink = serverless_config_shrink  # type: str
        # Specifies whether to enable automatic storage expansion for the instance. Valid values:
        # 
        # *   **Enable**.
        # *   **Disable**. This is the default value.
        # 
        # > After the instance is created, you can call the [ModifyDasInstanceConfig](~~199281~~) operation to adjust the settings of automatic storage expansion for the instance. For more information, see [Configure automatic storage expansion for an ApsaraDB RDS for MySQL instance](~~173826~~).
        self.storage_auto_scale = storage_auto_scale  # type: str
        # The threshold based on which automatic storage expansion is triggered. Unit: percent. Valid values:
        # 
        # *   **10**\
        # *   **20**\
        # *   **30**\
        # *   **40**\
        # *   **50**\
        # 
        # > If you set the **StorageAutoScale** parameter to **Enable**, you must specify this parameter.
        self.storage_threshold = storage_threshold  # type: int
        # The maximum storage capacity that is allowed for automatic storage expansion. The storage capacity of the instance cannot exceed the maximum storage capacity. Unit: GB.
        # 
        # *   Valid values: an integer greater than or equal to 0.
        # *   If you set the **StorageAutoScale** parameter to **Enable**, you must also specify this parameter.
        self.storage_upper_bound = storage_upper_bound  # type: int
        # The character set that is used by the instance. This parameter is no longer used.
        self.system_dbcharset = system_dbcharset  # type: str
        # An array that consists of details of the tag.
        self.tag = tag  # type: list[CreateDBInstanceShrinkRequestTag]
        # The ID of the host to which the logger instance belongs in the specified dedicated cluster.
        # 
        # If the instance runs RDS Enterprise Edition and you create the instance in a dedicated cluster, you must specify this parameter. If you do not specify this parameter, the system automatically assigns a host.
        # 
        # 
        # 
        # > *   You can call the [DescribeDedicatedHosts](~~141948~~) operation to query the details about the hosts in a dedicated cluster.
        # > 
        # *   If no hosts are created, you can call the [CreateDedicatedHost](~~210864~~) operation to create a host.
        self.target_dedicated_host_id_for_log = target_dedicated_host_id_for_log  # type: str
        # The ID of the host to which the instance belongs in the specified dedicated cluster.
        # 
        # If you create the instance in a dedicated cluster, you must specify this parameter. If you do not specify this parameter, the system automatically assigns a host.
        # 
        # 
        # 
        # > *   You can call the [DescribeDedicatedHostGroups](~~141948~~) operation to query the details about a dedicated cluster.
        # 
        # > *   If no hosts are created, you can call the [CreateDedicatedHost](~~210864~~) operation to create a host.
        self.target_dedicated_host_id_for_master = target_dedicated_host_id_for_master  # type: str
        # The ID of the host to which the secondary instance belongs in the specified dedicated cluster.
        # 
        # If the instance runs RDS High-availability Edition or RDS Enterprise Edition and you create the instance in a dedicated cluster, you must specify this parameter. If you do not specify this parameter, the system automatically assigns a host.
        # 
        #  
        # 
        # >*   You can call the [DescribeDedicatedHosts](~~141948~~) operation to query the details about the hosts in a dedicated cluster.
        # 
        # >*   If no hosts are created, you can call the [CreateDedicatedHost](~~210864~~) operation to create a host.
        self.target_dedicated_host_id_for_slave = target_dedicated_host_id_for_slave  # type: str
        # The minor engine version of the instance. This parameter is required only when you create an instance that runs MySQL or PostgreSQL. The value format varies based on the database engine of the instance.
        # 
        # *   If you create an instance that runs MySQL, the value is in the following format: `<RDS edition>_<Minor engine version>`. Examples: `rds_20200229`, `xcluster_20200229`, and `xcluster80_20200229`. The following list describes the fields in the example values:
        # 
        #     *   rds: The instance runs RDS Basic Edition or High-availability Edition.
        #     *   xcluster: The instance runs MySQL 5.7 on RDS Enterprise Edition.
        #     *   xcluster80: The instance runs MySQL 8.0 on RDS Enterprise Edition.
        # 
        # > You can call the [DescribeDBMiniEngineVersions](~~445835~~) operation to query the minor engine version. For more information about minor engine versions, see [Release notes of minor AliSQL versions](~~96060~~).
        # 
        # *   If you create an instance that runs PostgreSQL, the value is in the following format: `rds_postgres_<Major engine version>00_<Minor engine version>`. Example: `rds_postgres_1400_20220830`. The following list describes the fields in the example value:
        # 
        #     *   1400: The major engine version is PostgreSQL 14.
        #     *   20220830: the AliPG version. You can call the [DescribeDBMiniEngineVersions](~~445835~~) operation to query the AliPG version. For more information about minor engine versions, see [Release notes for AliPG](~~126002~~).
        # 
        # > If you configure the **BabelfishConfig** parameter for your instance that runs PostgreSQL and set the babelfishEnabled field to true, the value of this parameter is in the following format: `rds_postgres_Major engine version00_AliPG version_babelfish`.
        self.target_minor_version = target_minor_version  # type: str
        # The subscription duration of the instance.
        # 
        # *   If you set the **Period** parameter to **Year**, the value of the **UsedTime** parameter ranges from **1 to 5**.
        # *   If you set the **Period** parameter to **Month**, the value of the **UsedTime** parameter ranges from **1 to 11**.
        # 
        # > If you set the PayType parameter to **Prepaid**, you must specify the UsedTime parameter.
        self.used_time = used_time  # type: str
        # The ID of the backup file. You can call the [ListUserBackupFiles](~~257821~~) operation to query backup files. If you create the instance by using a backup file, you must specify this parameter.
        # 
        # > You can specify this parameter only when the following requirements are met:
        # 
        # *   The **PayType** parameter is set to **Postpaid**.
        # *   The **Engine** parameter is set to **MySQL**.
        # *   The **EngineVersion** parameter is set to **5.7**.
        # *   The **Category** parameter is set to **Basic**.
        self.user_backup_id = user_backup_id  # type: str
        # The ID of the VPC to which the instance belongs.
        # 
        # > This parameter is available when you set the **InstanceNetworkType** parameter to **VPC**.
        self.vpcid = vpcid  # type: str
        # The ID of the vSwitch. The vSwitch must belong to the zone that is specified by the **ZoneId** parameter.
        # 
        #  
        # 
        # >*   If you set the **InstanceNetworkType** parameter to **VPC**, you must specify this parameter.
        # >
        # *   If you specify the ZoneSlaveId1 parameter, you must specify the IDs of two vSwitches for this parameter and separate the IDs with a comma (,).
        self.v_switch_id = v_switch_id  # type: str
        # The zone ID of the primary instance.
        # 
        # *   If you specify a VPC and a vSwitch, you must specify the ID of the zone to which the specified vSwitch belongs. Otherwise, the instance cannot be created.
        # 
        # *   If the instance runs RDS High-availability Edition, you must specify the **ZoneIdSlave1** parameter, which specifies whether to use the single-zone deployment method or the multi-zone deployment method.
        # *   If the instance runs RDS Enterprise Edition, you must specify the **ZoneIdSlave1** and **ZoneIdSlave2** parameters, which specify whether to use the single-zone deployment method or the multi-zone deployment method.
        self.zone_id = zone_id  # type: str
        # The ID of the zone in which the secondary instance resides. If you set the ZoneIdSlave1 parameter and the **ZoneId** parameter to the same value, the single-zone deployment method is used. If you set the ZoneIdSlave1 parameter and the **ZoneId** parameter to different values, the multi-zone deployment method is used.
        self.zone_id_slave_1 = zone_id_slave_1  # type: str
        # The ID of the zone in which the logger instance resides. If you set the ZoneIdSlave2 parameter and the **ZoneId** parameter to the same value, the single-zone deployment method is used. If you set the ZoneIdSlave2 parameter and the **ZoneId** parameter to different values, the multi-zone deployment method is used.
        self.zone_id_slave_2 = zone_id_slave_2  # type: str

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateDBInstanceShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.amount is not None:
            result['Amount'] = self.amount
        if self.auto_renew is not None:
            result['AutoRenew'] = self.auto_renew
        if self.babelfish_config is not None:
            result['BabelfishConfig'] = self.babelfish_config
        if self.business_info is not None:
            result['BusinessInfo'] = self.business_info
        if self.category is not None:
            result['Category'] = self.category
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.connection_mode is not None:
            result['ConnectionMode'] = self.connection_mode
        if self.connection_string is not None:
            result['ConnectionString'] = self.connection_string
        if self.create_strategy is not None:
            result['CreateStrategy'] = self.create_strategy
        if self.dbinstance_class is not None:
            result['DBInstanceClass'] = self.dbinstance_class
        if self.dbinstance_description is not None:
            result['DBInstanceDescription'] = self.dbinstance_description
        if self.dbinstance_net_type is not None:
            result['DBInstanceNetType'] = self.dbinstance_net_type
        if self.dbinstance_storage is not None:
            result['DBInstanceStorage'] = self.dbinstance_storage
        if self.dbinstance_storage_type is not None:
            result['DBInstanceStorageType'] = self.dbinstance_storage_type
        if self.dbis_ignore_case is not None:
            result['DBIsIgnoreCase'] = self.dbis_ignore_case
        if self.dbparam_group_id is not None:
            result['DBParamGroupId'] = self.dbparam_group_id
        if self.dbtime_zone is not None:
            result['DBTimeZone'] = self.dbtime_zone
        if self.dedicated_host_group_id is not None:
            result['DedicatedHostGroupId'] = self.dedicated_host_group_id
        if self.deletion_protection is not None:
            result['DeletionProtection'] = self.deletion_protection
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.encryption_key is not None:
            result['EncryptionKey'] = self.encryption_key
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.engine_version is not None:
            result['EngineVersion'] = self.engine_version
        if self.instance_network_type is not None:
            result['InstanceNetworkType'] = self.instance_network_type
        if self.pay_type is not None:
            result['PayType'] = self.pay_type
        if self.period is not None:
            result['Period'] = self.period
        if self.port is not None:
            result['Port'] = self.port
        if self.private_ip_address is not None:
            result['PrivateIpAddress'] = self.private_ip_address
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.role_arn is not None:
            result['RoleARN'] = self.role_arn
        if self.security_iplist is not None:
            result['SecurityIPList'] = self.security_iplist
        if self.serverless_config_shrink is not None:
            result['ServerlessConfig'] = self.serverless_config_shrink
        if self.storage_auto_scale is not None:
            result['StorageAutoScale'] = self.storage_auto_scale
        if self.storage_threshold is not None:
            result['StorageThreshold'] = self.storage_threshold
        if self.storage_upper_bound is not None:
            result['StorageUpperBound'] = self.storage_upper_bound
        if self.system_dbcharset is not None:
            result['SystemDBCharset'] = self.system_dbcharset
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.target_dedicated_host_id_for_log is not None:
            result['TargetDedicatedHostIdForLog'] = self.target_dedicated_host_id_for_log
        if self.target_dedicated_host_id_for_master is not None:
            result['TargetDedicatedHostIdForMaster'] = self.target_dedicated_host_id_for_master
        if self.target_dedicated_host_id_for_slave is not None:
            result['TargetDedicatedHostIdForSlave'] = self.target_dedicated_host_id_for_slave
        if self.target_minor_version is not None:
            result['TargetMinorVersion'] = self.target_minor_version
        if self.used_time is not None:
            result['UsedTime'] = self.used_time
        if self.user_backup_id is not None:
            result['UserBackupId'] = self.user_backup_id
        if self.vpcid is not None:
            result['VPCId'] = self.vpcid
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.zone_id_slave_1 is not None:
            result['ZoneIdSlave1'] = self.zone_id_slave_1
        if self.zone_id_slave_2 is not None:
            result['ZoneIdSlave2'] = self.zone_id_slave_2
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Amount') is not None:
            self.amount = m.get('Amount')
        if m.get('AutoRenew') is not None:
            self.auto_renew = m.get('AutoRenew')
        if m.get('BabelfishConfig') is not None:
            self.babelfish_config = m.get('BabelfishConfig')
        if m.get('BusinessInfo') is not None:
            self.business_info = m.get('BusinessInfo')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('ConnectionMode') is not None:
            self.connection_mode = m.get('ConnectionMode')
        if m.get('ConnectionString') is not None:
            self.connection_string = m.get('ConnectionString')
        if m.get('CreateStrategy') is not None:
            self.create_strategy = m.get('CreateStrategy')
        if m.get('DBInstanceClass') is not None:
            self.dbinstance_class = m.get('DBInstanceClass')
        if m.get('DBInstanceDescription') is not None:
            self.dbinstance_description = m.get('DBInstanceDescription')
        if m.get('DBInstanceNetType') is not None:
            self.dbinstance_net_type = m.get('DBInstanceNetType')
        if m.get('DBInstanceStorage') is not None:
            self.dbinstance_storage = m.get('DBInstanceStorage')
        if m.get('DBInstanceStorageType') is not None:
            self.dbinstance_storage_type = m.get('DBInstanceStorageType')
        if m.get('DBIsIgnoreCase') is not None:
            self.dbis_ignore_case = m.get('DBIsIgnoreCase')
        if m.get('DBParamGroupId') is not None:
            self.dbparam_group_id = m.get('DBParamGroupId')
        if m.get('DBTimeZone') is not None:
            self.dbtime_zone = m.get('DBTimeZone')
        if m.get('DedicatedHostGroupId') is not None:
            self.dedicated_host_group_id = m.get('DedicatedHostGroupId')
        if m.get('DeletionProtection') is not None:
            self.deletion_protection = m.get('DeletionProtection')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('EncryptionKey') is not None:
            self.encryption_key = m.get('EncryptionKey')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('EngineVersion') is not None:
            self.engine_version = m.get('EngineVersion')
        if m.get('InstanceNetworkType') is not None:
            self.instance_network_type = m.get('InstanceNetworkType')
        if m.get('PayType') is not None:
            self.pay_type = m.get('PayType')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('PrivateIpAddress') is not None:
            self.private_ip_address = m.get('PrivateIpAddress')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RoleARN') is not None:
            self.role_arn = m.get('RoleARN')
        if m.get('SecurityIPList') is not None:
            self.security_iplist = m.get('SecurityIPList')
        if m.get('ServerlessConfig') is not None:
            self.serverless_config_shrink = m.get('ServerlessConfig')
        if m.get('StorageAutoScale') is not None:
            self.storage_auto_scale = m.get('StorageAutoScale')
        if m.get('StorageThreshold') is not None:
            self.storage_threshold = m.get('StorageThreshold')
        if m.get('StorageUpperBound') is not None:
            self.storage_upper_bound = m.get('StorageUpperBound')
        if m.get('SystemDBCharset') is not None:
            self.system_dbcharset = m.get('SystemDBCharset')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateDBInstanceShrinkRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('TargetDedicatedHostIdForLog') is not None:
            self.target_dedicated_host_id_for_log = m.get('TargetDedicatedHostIdForLog')
        if m.get('TargetDedicatedHostIdForMaster') is not None:
            self.target_dedicated_host_id_for_master = m.get('TargetDedicatedHostIdForMaster')
        if m.get('TargetDedicatedHostIdForSlave') is not None:
            self.target_dedicated_host_id_for_slave = m.get('TargetDedicatedHostIdForSlave')
        if m.get('TargetMinorVersion') is not None:
            self.target_minor_version = m.get('TargetMinorVersion')
        if m.get('UsedTime') is not None:
            self.used_time = m.get('UsedTime')
        if m.get('UserBackupId') is not None:
            self.user_backup_id = m.get('UserBackupId')
        if m.get('VPCId') is not None:
            self.vpcid = m.get('VPCId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('ZoneIdSlave1') is not None:
            self.zone_id_slave_1 = m.get('ZoneIdSlave1')
        if m.get('ZoneIdSlave2') is not None:
            self.zone_id_slave_2 = m.get('ZoneIdSlave2')
        return self


class CreateDBInstanceResponseBody(TeaModel):
    def __init__(self, connection_string=None, dbinstance_id=None, dry_run=None, dry_run_result=None, message=None,
                 order_id=None, port=None, request_id=None, tag_result=None, task_id=None):
        # The endpoint of the instance.
        # 
        # > The **DBInstanceNetType** parameter indicates whether the endpoint is internal or public.
        self.connection_string = connection_string  # type: str
        # The ID of the instance If the value of the **Amount** parameter is greater than **1**, more than one instance ID is returned. The number of instance IDs that are returned is the same as the value of the Amount parameter. The returned instance IDs are separated by commas (,).
        # 
        # For example, if the value of the **Amount** parameter is **3**, three instance IDs are returned. Example: `rm-uf6wjk5*****1,rm-uf6wjk5*****2,rm-uf6wjk5*****3`
        self.dbinstance_id = dbinstance_id  # type: str
        # Indicates that the system prechecks the request before the system creates the instance.
        # 
        # 
        # 
        # > *   The return value is fixed as **true**.
        # 
        # > *   If the system does not perform a precheck, this parameter is not returned.
        self.dry_run = dry_run  # type: bool
        # Indicates whether the request passed the precheck. Valid values:
        # 
        # *   **true**: The request passed the precheck.
        # *   **false**: The request failed the precheck.
        # 
        # 
        # > 
        # *   If the system does not perform a precheck, this parameter is not returned.
        # > 
        # *   If the request failed the precheck, an error is returned.
        self.dry_run_result = dry_run_result  # type: bool
        # The message that indicates whether multiple instances are created.
        # 
        # > The parameter is returned only when the value of the **Amount** parameter is greater than 1.
        self.message = message  # type: str
        # The ID of the order.
        self.order_id = order_id  # type: str
        # The port that is used to connect to the instance.
        # 
        # > The **DBInstanceNetType** parameter indicates whether the port number is internal or public.
        self.port = port  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # Indicates whether the specified tag is added to the instance. Valid values:
        # 
        # *   **true**: The specified tag is added to the instance.
        # *   **false**: The specified tag fails to be added to the instance.
        # 
        # > If you do not add a tag to the instance, this parameter is not returned.
        self.tag_result = tag_result  # type: bool
        # The ID of the task that is run to create multiple instances.
        # 
        # 
        # 
        # > *   This parameter is returned only when the value of the **Amount** parameter is greater than 1.
        # 
        # > *   The **TaskID** parameter cannot be used to query a task.
        self.task_id = task_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDBInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.connection_string is not None:
            result['ConnectionString'] = self.connection_string
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.dry_run_result is not None:
            result['DryRunResult'] = self.dry_run_result
        if self.message is not None:
            result['Message'] = self.message
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.port is not None:
            result['Port'] = self.port
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.tag_result is not None:
            result['TagResult'] = self.tag_result
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConnectionString') is not None:
            self.connection_string = m.get('ConnectionString')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('DryRunResult') is not None:
            self.dry_run_result = m.get('DryRunResult')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TagResult') is not None:
            self.tag_result = m.get('TagResult')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class CreateDBInstanceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateDBInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateDBInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDBInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDBInstanceEndpointRequestNodeItems(TeaModel):
    def __init__(self, dbinstance_id=None, node_id=None, weight=None):
        # The ID of the instance. You can call the [DescribeDBInstances](~~26232~~) operation to query the ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        # The ID of the node.
        self.node_id = node_id  # type: str
        # The weight of the node. Read requests are distributed based on the weight.
        # 
        # Valid values: 0 to 100.
        self.weight = weight  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDBInstanceEndpointRequestNodeItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.weight is not None:
            result['Weight'] = self.weight
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('Weight') is not None:
            self.weight = m.get('Weight')
        return self


class CreateDBInstanceEndpointRequest(TeaModel):
    def __init__(self, client_token=None, connection_string_prefix=None, dbinstance_endpoint_description=None,
                 dbinstance_endpoint_type=None, dbinstance_id=None, node_items=None, port=None, private_ip_address=None,
                 resource_owner_id=None, v_switch_id=None, vpc_id=None):
        # The client token that is used to ensure the idempotence of the request. You can use the client to generate the token, but you must make sure that the token is unique among different requests.
        # 
        # The token can contain only ASCII characters and cannot exceed 64 characters in length.
        self.client_token = client_token  # type: str
        # The prefix of the internal endpoint.
        # 
        # When you create any type of endpoint, an internal endpoint is automatically created for the endpoint. This parameter specifies the prefix of the internal endpoint.
        self.connection_string_prefix = connection_string_prefix  # type: str
        # The user-defined description of the endpoint.
        self.dbinstance_endpoint_description = dbinstance_endpoint_description  # type: str
        # The type of the endpoint. Valid values:
        # 
        # *   Primary: the read/write endpoint of the instance.
        # *   Readonly: the read-only endpoint of the instance.
        self.dbinstance_endpoint_type = dbinstance_endpoint_type  # type: str
        # The ID of the instance. You can call the [DescribeDBInstances](~~26232~~) operation to query the ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        # The information about the node that is configured for the endpoint.
        self.node_items = node_items  # type: list[CreateDBInstanceEndpointRequestNodeItems]
        # The port number of the internal endpoint. You can specify the port number for the internal endpoint.
        # 
        # Valid values: 3000 to 5999.
        self.port = port  # type: str
        # The IP address of the internal endpoint.
        self.private_ip_address = private_ip_address  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The vSwitch ID of the internal endpoint.
        self.v_switch_id = v_switch_id  # type: str
        # The virtual private cloud (VPC) ID of the internal endpoint.
        self.vpc_id = vpc_id  # type: str

    def validate(self):
        if self.node_items:
            for k in self.node_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateDBInstanceEndpointRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.connection_string_prefix is not None:
            result['ConnectionStringPrefix'] = self.connection_string_prefix
        if self.dbinstance_endpoint_description is not None:
            result['DBInstanceEndpointDescription'] = self.dbinstance_endpoint_description
        if self.dbinstance_endpoint_type is not None:
            result['DBInstanceEndpointType'] = self.dbinstance_endpoint_type
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        result['NodeItems'] = []
        if self.node_items is not None:
            for k in self.node_items:
                result['NodeItems'].append(k.to_map() if k else None)
        if self.port is not None:
            result['Port'] = self.port
        if self.private_ip_address is not None:
            result['PrivateIpAddress'] = self.private_ip_address
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('ConnectionStringPrefix') is not None:
            self.connection_string_prefix = m.get('ConnectionStringPrefix')
        if m.get('DBInstanceEndpointDescription') is not None:
            self.dbinstance_endpoint_description = m.get('DBInstanceEndpointDescription')
        if m.get('DBInstanceEndpointType') is not None:
            self.dbinstance_endpoint_type = m.get('DBInstanceEndpointType')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        self.node_items = []
        if m.get('NodeItems') is not None:
            for k in m.get('NodeItems'):
                temp_model = CreateDBInstanceEndpointRequestNodeItems()
                self.node_items.append(temp_model.from_map(k))
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('PrivateIpAddress') is not None:
            self.private_ip_address = m.get('PrivateIpAddress')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class CreateDBInstanceEndpointShrinkRequest(TeaModel):
    def __init__(self, client_token=None, connection_string_prefix=None, dbinstance_endpoint_description=None,
                 dbinstance_endpoint_type=None, dbinstance_id=None, node_items_shrink=None, port=None, private_ip_address=None,
                 resource_owner_id=None, v_switch_id=None, vpc_id=None):
        # The client token that is used to ensure the idempotence of the request. You can use the client to generate the token, but you must make sure that the token is unique among different requests.
        # 
        # The token can contain only ASCII characters and cannot exceed 64 characters in length.
        self.client_token = client_token  # type: str
        # The prefix of the internal endpoint.
        # 
        # When you create any type of endpoint, an internal endpoint is automatically created for the endpoint. This parameter specifies the prefix of the internal endpoint.
        self.connection_string_prefix = connection_string_prefix  # type: str
        # The user-defined description of the endpoint.
        self.dbinstance_endpoint_description = dbinstance_endpoint_description  # type: str
        # The type of the endpoint. Valid values:
        # 
        # *   Primary: the read/write endpoint of the instance.
        # *   Readonly: the read-only endpoint of the instance.
        self.dbinstance_endpoint_type = dbinstance_endpoint_type  # type: str
        # The ID of the instance. You can call the [DescribeDBInstances](~~26232~~) operation to query the ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        # The information about the node that is configured for the endpoint.
        self.node_items_shrink = node_items_shrink  # type: str
        # The port number of the internal endpoint. You can specify the port number for the internal endpoint.
        # 
        # Valid values: 3000 to 5999.
        self.port = port  # type: str
        # The IP address of the internal endpoint.
        self.private_ip_address = private_ip_address  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The vSwitch ID of the internal endpoint.
        self.v_switch_id = v_switch_id  # type: str
        # The virtual private cloud (VPC) ID of the internal endpoint.
        self.vpc_id = vpc_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDBInstanceEndpointShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.connection_string_prefix is not None:
            result['ConnectionStringPrefix'] = self.connection_string_prefix
        if self.dbinstance_endpoint_description is not None:
            result['DBInstanceEndpointDescription'] = self.dbinstance_endpoint_description
        if self.dbinstance_endpoint_type is not None:
            result['DBInstanceEndpointType'] = self.dbinstance_endpoint_type
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.node_items_shrink is not None:
            result['NodeItems'] = self.node_items_shrink
        if self.port is not None:
            result['Port'] = self.port
        if self.private_ip_address is not None:
            result['PrivateIpAddress'] = self.private_ip_address
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('ConnectionStringPrefix') is not None:
            self.connection_string_prefix = m.get('ConnectionStringPrefix')
        if m.get('DBInstanceEndpointDescription') is not None:
            self.dbinstance_endpoint_description = m.get('DBInstanceEndpointDescription')
        if m.get('DBInstanceEndpointType') is not None:
            self.dbinstance_endpoint_type = m.get('DBInstanceEndpointType')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('NodeItems') is not None:
            self.node_items_shrink = m.get('NodeItems')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('PrivateIpAddress') is not None:
            self.private_ip_address = m.get('PrivateIpAddress')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class CreateDBInstanceEndpointResponseBodyData(TeaModel):
    def __init__(self, connection_string=None, dbinstance_endpoint_id=None, dbinstance_name=None):
        # The internal endpoint.
        self.connection_string = connection_string  # type: str
        # The endpoint ID of the instance.
        self.dbinstance_endpoint_id = dbinstance_endpoint_id  # type: str
        # The ID of the instance.
        self.dbinstance_name = dbinstance_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDBInstanceEndpointResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.connection_string is not None:
            result['ConnectionString'] = self.connection_string
        if self.dbinstance_endpoint_id is not None:
            result['DBInstanceEndpointId'] = self.dbinstance_endpoint_id
        if self.dbinstance_name is not None:
            result['DBInstanceName'] = self.dbinstance_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConnectionString') is not None:
            self.connection_string = m.get('ConnectionString')
        if m.get('DBInstanceEndpointId') is not None:
            self.dbinstance_endpoint_id = m.get('DBInstanceEndpointId')
        if m.get('DBInstanceName') is not None:
            self.dbinstance_name = m.get('DBInstanceName')
        return self


class CreateDBInstanceEndpointResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        # The returned data.
        self.data = data  # type: CreateDBInstanceEndpointResponseBodyData
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CreateDBInstanceEndpointResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = CreateDBInstanceEndpointResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDBInstanceEndpointResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateDBInstanceEndpointResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateDBInstanceEndpointResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDBInstanceEndpointResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDBInstanceEndpointAddressRequest(TeaModel):
    def __init__(self, client_token=None, connection_string_prefix=None, dbinstance_endpoint_id=None,
                 dbinstance_id=None, ip_type=None, port=None, resource_owner_id=None):
        # The client token that is used to ensure the idempotence of the request. You can use the client to generate the value, but you must make sure that it is unique among different requests.
        # 
        # The token can only contain ASCII characters and cannot exceed 64 characters in length.
        self.client_token = client_token  # type: str
        # The prefix of the public endpoint.
        self.connection_string_prefix = connection_string_prefix  # type: str
        # The endpoint ID of the instance. You can call the [DescribeDBInstanceEndpoints](~~464397~~) operation to query the endpoint ID of the instance.
        self.dbinstance_endpoint_id = dbinstance_endpoint_id  # type: str
        # The ID of the instance You can call the [DescribeDBInstances](~~26232~~) operation to query the ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        # The network type of the endpoint. Only Internet is supported. Set the value to **Public**.
        self.ip_type = ip_type  # type: str
        # The port number of the public endpoint.
        self.port = port  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDBInstanceEndpointAddressRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.connection_string_prefix is not None:
            result['ConnectionStringPrefix'] = self.connection_string_prefix
        if self.dbinstance_endpoint_id is not None:
            result['DBInstanceEndpointId'] = self.dbinstance_endpoint_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.ip_type is not None:
            result['IpType'] = self.ip_type
        if self.port is not None:
            result['Port'] = self.port
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('ConnectionStringPrefix') is not None:
            self.connection_string_prefix = m.get('ConnectionStringPrefix')
        if m.get('DBInstanceEndpointId') is not None:
            self.dbinstance_endpoint_id = m.get('DBInstanceEndpointId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('IpType') is not None:
            self.ip_type = m.get('IpType')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class CreateDBInstanceEndpointAddressResponseBodyData(TeaModel):
    def __init__(self, connection_string=None, dbinstance_endpoint_id=None, dbinstance_name=None):
        # The public endpoint.
        self.connection_string = connection_string  # type: str
        # The endpoint ID of the instance.
        self.dbinstance_endpoint_id = dbinstance_endpoint_id  # type: str
        # The ID of the instance.
        self.dbinstance_name = dbinstance_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDBInstanceEndpointAddressResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.connection_string is not None:
            result['ConnectionString'] = self.connection_string
        if self.dbinstance_endpoint_id is not None:
            result['DBInstanceEndpointId'] = self.dbinstance_endpoint_id
        if self.dbinstance_name is not None:
            result['DBInstanceName'] = self.dbinstance_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConnectionString') is not None:
            self.connection_string = m.get('ConnectionString')
        if m.get('DBInstanceEndpointId') is not None:
            self.dbinstance_endpoint_id = m.get('DBInstanceEndpointId')
        if m.get('DBInstanceName') is not None:
            self.dbinstance_name = m.get('DBInstanceName')
        return self


class CreateDBInstanceEndpointAddressResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        # The returned data.
        self.data = data  # type: CreateDBInstanceEndpointAddressResponseBodyData
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CreateDBInstanceEndpointAddressResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = CreateDBInstanceEndpointAddressResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDBInstanceEndpointAddressResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateDBInstanceEndpointAddressResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateDBInstanceEndpointAddressResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDBInstanceEndpointAddressResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDBInstanceForRebuildRequest(TeaModel):
    def __init__(self, client_token=None, dbinstance_description=None, dbinstance_id=None,
                 dbinstance_net_type=None, instance_network_type=None, owner_account=None, owner_id=None, pay_type=None, period=None,
                 region_id=None, resource_group_id=None, resource_owner_account=None, resource_owner_id=None,
                 security_iplist=None, security_token=None, used_time=None, vpcid=None, v_switch_id=None, zone_id=None,
                 zone_id_slave_1=None, zone_id_slave_2=None):
        # The client token that is used to ensure the idempotence of the request. You can use the client to generate the token, but you must make sure that the token is unique among different requests.
        # 
        # The token can contain only ASCII characters and cannot exceed 64 characters in length.
        self.client_token = client_token  # type: str
        # The name of the instance. The name must be 2 to 256 characters in length. The name can contain letters, digits, underscores (\_), and hyphens (-). The name must start with a letter.
        # 
        # > The name cannot start with http:// or https://.
        self.dbinstance_description = dbinstance_description  # type: str
        # The ID of the instance that you want to rebuild.
        self.dbinstance_id = dbinstance_id  # type: str
        # The type of network connection to the instance. Valid values:
        # 
        # *   **Internet**: Internet
        # *   **Intranet**: internal network
        self.dbinstance_net_type = dbinstance_net_type  # type: str
        # The network type of the instance. Valid values:
        # 
        # *   **VPC**\
        # *   **Classic**\
        # 
        # Default value: Classic.
        # 
        # > If you set this parameter to **VPC**, you must also specify the **VpcId** and **VSwitchId** parameters.
        self.instance_network_type = instance_network_type  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The billing method of the instance. Valid values:
        # 
        # *   **Postpaid**: pay-as-you-go
        # *   **Prepaid**: subscription
        self.pay_type = pay_type  # type: str
        # Specifies whether to use yearly subscription or monthly subscription for the instance. Valid values:
        # 
        # *   **Year**\
        # *   **Month**\
        # 
        # > If you set the PayType parameter to **Prepaid**, you must specify this parameter.
        self.period = period  # type: str
        # The region ID of the instance.
        self.region_id = region_id  # type: str
        # The ID of the resource group to which the instance you want to rebuild belongs. The value of this parameter can be NULL.
        self.resource_group_id = resource_group_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The IP address whitelist of the instance. For more information, see [Use a database client or the CLI to connect to an ApsaraDB RDS for MySQL instance](~~43185~~). If the IP address whitelist contains more than one entry, separate the entries with commas (,). Each entry must be unique. The IP address whitelist can contain up to 1,000 entries. The entries in the IP address whitelist must be in one of the following formats:
        # 
        # *   IP addresses, such as 10.10.XX.XX.
        # *   CIDR blocks, such as 10.10.XX.XX/24. In this example, 24 indicates that the prefix of each IP address in the IP address whitelist is 24 bits in length. You can replace 24 with a value within the range of 1 to 32.
        self.security_iplist = security_iplist  # type: str
        self.security_token = security_token  # type: str
        # The subscription duration of the instance. Valid values:
        # 
        # *   If you set the **Period** parameter to **Year**, the value of the **UsedTime** parameter ranges from **1** to **5**.
        # *   If you set the **Period** parameter to **Month**, the value of the **UsedTime** parameter ranges from **1** to **11**.
        # 
        # > If you set the **PayType** parameter to **Prepaid**, you must specify this parameter.
        self.used_time = used_time  # type: str
        # The VPC ID of the instance. This parameter is available only when you set the **InstanceNetworkType** parameter to **VPC**.
        # 
        # > If you specify this parameter, you must also specify the **ZoneId** parameter.
        self.vpcid = vpcid  # type: str
        # The ID of the vSwitch. The vSwitch must belong to the zone that is specified by the **ZoneId** parameter.
        # 
        # > 
        # 
        # *   If you set the **InstanceNetworkType** parameter to **VPC**, you must specify this parameter.
        # 
        # *   If you specify the ZoneSlaveId1 parameter, you must specify the IDs of two vSwitches for this parameter and separate the IDs with a comma (,).
        self.v_switch_id = v_switch_id  # type: str
        # The zone ID of the primary instance. You can call the [DescribeRegions](~~26243~~) operation to query the most recent zone list.
        # 
        # > This parameter is required to identify the zone for a vSwitch if you have specified the virtual private cloud (VPC) and the vSwitch.
        self.zone_id = zone_id  # type: str
        # The zone of the secondary instance.
        # 
        # > You must specify this parameter when the instance does not run RDS Basic Edition.
        self.zone_id_slave_1 = zone_id_slave_1  # type: str
        # The zone of the logger instance.
        # 
        # > You can specify this parameter only when the instance runs RDS Enterprise Edition.
        self.zone_id_slave_2 = zone_id_slave_2  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDBInstanceForRebuildRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dbinstance_description is not None:
            result['DBInstanceDescription'] = self.dbinstance_description
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dbinstance_net_type is not None:
            result['DBInstanceNetType'] = self.dbinstance_net_type
        if self.instance_network_type is not None:
            result['InstanceNetworkType'] = self.instance_network_type
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.pay_type is not None:
            result['PayType'] = self.pay_type
        if self.period is not None:
            result['Period'] = self.period
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.security_iplist is not None:
            result['SecurityIPList'] = self.security_iplist
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.used_time is not None:
            result['UsedTime'] = self.used_time
        if self.vpcid is not None:
            result['VPCId'] = self.vpcid
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.zone_id_slave_1 is not None:
            result['ZoneIdSlave1'] = self.zone_id_slave_1
        if self.zone_id_slave_2 is not None:
            result['ZoneIdSlave2'] = self.zone_id_slave_2
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DBInstanceDescription') is not None:
            self.dbinstance_description = m.get('DBInstanceDescription')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DBInstanceNetType') is not None:
            self.dbinstance_net_type = m.get('DBInstanceNetType')
        if m.get('InstanceNetworkType') is not None:
            self.instance_network_type = m.get('InstanceNetworkType')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PayType') is not None:
            self.pay_type = m.get('PayType')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SecurityIPList') is not None:
            self.security_iplist = m.get('SecurityIPList')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('UsedTime') is not None:
            self.used_time = m.get('UsedTime')
        if m.get('VPCId') is not None:
            self.vpcid = m.get('VPCId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('ZoneIdSlave1') is not None:
            self.zone_id_slave_1 = m.get('ZoneIdSlave1')
        if m.get('ZoneIdSlave2') is not None:
            self.zone_id_slave_2 = m.get('ZoneIdSlave2')
        return self


class CreateDBInstanceForRebuildResponseBody(TeaModel):
    def __init__(self, dbinstance_id=None, message=None, order_id=None, request_id=None, task_id=None):
        # The ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        # The error message returned.
        self.message = message  # type: str
        # The ID of the order.
        self.order_id = order_id  # type: str
        # Id of the request
        self.request_id = request_id  # type: str
        # The ID of the task.
        self.task_id = task_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDBInstanceForRebuildResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.message is not None:
            result['Message'] = self.message
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class CreateDBInstanceForRebuildResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateDBInstanceForRebuildResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateDBInstanceForRebuildResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDBInstanceForRebuildResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDBNodesRequestDBNode(TeaModel):
    def __init__(self, class_code=None, zone_id=None):
        # The specification information of the node.
        self.class_code = class_code  # type: str
        # The zone ID of the node.
        self.zone_id = zone_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDBNodesRequestDBNode, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.class_code is not None:
            result['classCode'] = self.class_code
        if self.zone_id is not None:
            result['zoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('classCode') is not None:
            self.class_code = m.get('classCode')
        if m.get('zoneId') is not None:
            self.zone_id = m.get('zoneId')
        return self


class CreateDBNodesRequest(TeaModel):
    def __init__(self, client_token=None, dbinstance_id=None, dbnode=None, owner_account=None, owner_id=None,
                 resource_owner_account=None, resource_owner_id=None):
        # The client token that is used to ensure the idempotence of the request. You can use the client to generate the value, but you must make sure that it is unique among different requests.
        # 
        # The token can only contain ASCII characters and cannot exceed 64 characters in length.
        self.client_token = client_token  # type: str
        # The ID of the instance. You can call the [DescribeDBInstances](~~26232~~) operation to query the ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        # An array that consists of the nodes of the cluster.
        self.dbnode = dbnode  # type: list[CreateDBNodesRequestDBNode]
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        if self.dbnode:
            for k in self.dbnode:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateDBNodesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        result['DBNode'] = []
        if self.dbnode is not None:
            for k in self.dbnode:
                result['DBNode'].append(k.to_map() if k else None)
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        self.dbnode = []
        if m.get('DBNode') is not None:
            for k in m.get('DBNode'):
                temp_model = CreateDBNodesRequestDBNode()
                self.dbnode.append(temp_model.from_map(k))
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class CreateDBNodesShrinkRequest(TeaModel):
    def __init__(self, client_token=None, dbinstance_id=None, dbnode_shrink=None, owner_account=None, owner_id=None,
                 resource_owner_account=None, resource_owner_id=None):
        # The client token that is used to ensure the idempotence of the request. You can use the client to generate the value, but you must make sure that it is unique among different requests.
        # 
        # The token can only contain ASCII characters and cannot exceed 64 characters in length.
        self.client_token = client_token  # type: str
        # The ID of the instance. You can call the [DescribeDBInstances](~~26232~~) operation to query the ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        # An array that consists of the nodes of the cluster.
        self.dbnode_shrink = dbnode_shrink  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDBNodesShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dbnode_shrink is not None:
            result['DBNode'] = self.dbnode_shrink
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DBNode') is not None:
            self.dbnode_shrink = m.get('DBNode')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class CreateDBNodesResponseBody(TeaModel):
    def __init__(self, dbinstance_id=None, node_ids=None, order_id=None, request_id=None):
        # The ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        self.node_ids = node_ids  # type: str
        # The ID of the order.
        self.order_id = order_id  # type: long
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDBNodesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.node_ids is not None:
            result['NodeIds'] = self.node_ids
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('NodeIds') is not None:
            self.node_ids = m.get('NodeIds')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDBNodesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateDBNodesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateDBNodesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDBNodesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDBProxyEndpointAddressRequest(TeaModel):
    def __init__(self, connection_string_prefix=None, dbinstance_id=None, dbproxy_connect_string_net_type=None,
                 dbproxy_endpoint_id=None, dbproxy_engine_type=None, dbproxy_new_connect_string_port=None, region_id=None,
                 resource_group_id=None, vpcid=None, v_switch_id=None):
        # The prefix of the proxy endpoint. Enter a custom prefix.
        self.connection_string_prefix = connection_string_prefix  # type: str
        # The ID of the instance. You can call the [DescribeDBInstances](~~26232~~) operation to query the ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        # The network type of the proxy endpoint. Valid values:
        # 
        # *   **Public**\
        # *   **VPC**\
        # *   **Classic**\
        # 
        # Default value: **Classic**.
        self.dbproxy_connect_string_net_type = dbproxy_connect_string_net_type  # type: str
        # The ID of the proxy endpoint. You can call the [DescribeDBProxyEndpoint](~~140955~~) operation to query the ID of the proxy endpoint.
        self.dbproxy_endpoint_id = dbproxy_endpoint_id  # type: str
        # An internal parameter. You do not need to specify this parameter.
        self.dbproxy_engine_type = dbproxy_engine_type  # type: str
        # The port number that is associated with the proxy endpoint.
        # 
        # *   If the instance runs MySQL, the default value is **3306**.
        # *   If the instance runs PostgreSQL, the default value is **5432**.
        self.dbproxy_new_connect_string_port = dbproxy_new_connect_string_port  # type: str
        # The ID of the region where the instance resides. You can call the [DescribeRegions](~~26243~~) operation to query the most recent region list.
        self.region_id = region_id  # type: str
        # The ID of the resource group.
        self.resource_group_id = resource_group_id  # type: str
        # The ID of the virtual private cloud (VPC) to which the proxy endpoint belongs. You can call the [DescribeDBInstanceAttribute](~~26231~~) operation to query the ID of the VPC.
        # 
        # >  If you set the **DBProxyConnectStringNetType** parameter to **VPC**, you must also specify the VPCId parameter.
        self.vpcid = vpcid  # type: str
        # The ID of the vSwitch associated with the specified VPC. You can call the [DescribeDBInstanceAttribute](~~26231~~) operation to query the ID of the vSwitch.
        # 
        # >  If you set the **DBProxyConnectStringNetType** parameter to **VPC**, you must also specify the VSwitchId parameter.
        self.v_switch_id = v_switch_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDBProxyEndpointAddressRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.connection_string_prefix is not None:
            result['ConnectionStringPrefix'] = self.connection_string_prefix
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dbproxy_connect_string_net_type is not None:
            result['DBProxyConnectStringNetType'] = self.dbproxy_connect_string_net_type
        if self.dbproxy_endpoint_id is not None:
            result['DBProxyEndpointId'] = self.dbproxy_endpoint_id
        if self.dbproxy_engine_type is not None:
            result['DBProxyEngineType'] = self.dbproxy_engine_type
        if self.dbproxy_new_connect_string_port is not None:
            result['DBProxyNewConnectStringPort'] = self.dbproxy_new_connect_string_port
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.vpcid is not None:
            result['VPCId'] = self.vpcid
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConnectionStringPrefix') is not None:
            self.connection_string_prefix = m.get('ConnectionStringPrefix')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DBProxyConnectStringNetType') is not None:
            self.dbproxy_connect_string_net_type = m.get('DBProxyConnectStringNetType')
        if m.get('DBProxyEndpointId') is not None:
            self.dbproxy_endpoint_id = m.get('DBProxyEndpointId')
        if m.get('DBProxyEngineType') is not None:
            self.dbproxy_engine_type = m.get('DBProxyEngineType')
        if m.get('DBProxyNewConnectStringPort') is not None:
            self.dbproxy_new_connect_string_port = m.get('DBProxyNewConnectStringPort')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('VPCId') is not None:
            self.vpcid = m.get('VPCId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        return self


class CreateDBProxyEndpointAddressResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDBProxyEndpointAddressResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDBProxyEndpointAddressResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateDBProxyEndpointAddressResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateDBProxyEndpointAddressResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDBProxyEndpointAddressResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDatabaseRequest(TeaModel):
    def __init__(self, character_set_name=None, dbdescription=None, dbinstance_id=None, dbname=None,
                 owner_account=None, owner_id=None, resource_group_id=None, resource_owner_account=None, resource_owner_id=None):
        # The character set.
        # 
        # *   Valid values for MySQL or MariaDB databases: **utf8, gbk, latin1, and utf8mb4**\
        # 
        # *   Valid values for SQL Server databases: **Chinese_PRC_CI_AS, Chinese_PRC_CS_AS, SQL_Latin1\_General_CP1\_CI_AS, SQL_Latin1\_General_CP1\_CS_AS, and Chinese_PRC_BIN**\
        # 
        # *   Valid values for PostgreSQL databases: a value in the `Character set,<Collate>,<Ctype>` format. Example: `UTF8,C,en_US.utf8`.
        # 
        #     *   Valid values for the character set: **KOI8U, UTF8, WIN866, WIN874, WIN1250, WIN1251, WIN1252, WIN1253, WIN1254, WIN1255, WIN1256, WIN1257, WIN1258, EUC_CN, EUC_KR, EUC_TW, EUC_JP, EUC_JIS\_2004, KOI8R, MULE_INTERNAL, LATIN1, LATIN2, LATIN3, LATIN4, LATIN5, LATIN6, LATIN7, LATIN8, LATIN9, LATIN10, ISO\_8859\_5, ISO\_8859\_6, ISO\_8859\_7, ISO\_8859\_8, and SQL_ASCII**\
        #     *   Valid values for the **Collate** field: You can execute the `SELECT DISTINCT collname FROM pg_collation;` statement to obtain the field value. The default value is **C**.
        #     *   Valid values for the **Ctype** field: You can execute the `SELECT DISTINCT collctype FROM pg_collation;` statement to obtain the field value. The default value is **en_US.utf8**.
        self.character_set_name = character_set_name  # type: str
        # The description of the database. The description must be 2 to 256 characters in length and can contain letters, digits, underscores (\_), and hyphens (-). The description must start with a letter.
        # 
        # > The value cannot start with `http://` or `https://`.
        self.dbdescription = dbdescription  # type: str
        # The ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        # The name of the database.
        # 
        # > 
        # 
        # *   The name must be 2 to 64 characters in length.
        # 
        # *   The name must start with a lowercase letter and end with a lowercase letter or digit.
        # *   The name can contain lowercase letters, digits, underscores (\_), and hyphens (-).
        # *   The name must be unique within the instance.
        # *   For more information about invalid characters, see [Forbidden keywords table](~~26317~~).
        self.dbname = dbname  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The ID of the resource group.
        self.resource_group_id = resource_group_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDatabaseRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.character_set_name is not None:
            result['CharacterSetName'] = self.character_set_name
        if self.dbdescription is not None:
            result['DBDescription'] = self.dbdescription
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dbname is not None:
            result['DBName'] = self.dbname
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CharacterSetName') is not None:
            self.character_set_name = m.get('CharacterSetName')
        if m.get('DBDescription') is not None:
            self.dbdescription = m.get('DBDescription')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DBName') is not None:
            self.dbname = m.get('DBName')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class CreateDatabaseResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDatabaseResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDatabaseResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateDatabaseResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateDatabaseResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDatabaseResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDdrInstanceRequest(TeaModel):
    def __init__(self, backup_set_id=None, client_token=None, connection_mode=None, dbinstance_class=None,
                 dbinstance_description=None, dbinstance_net_type=None, dbinstance_storage=None, dbinstance_storage_type=None,
                 engine=None, engine_version=None, instance_network_type=None, owner_account=None, owner_id=None,
                 pay_type=None, period=None, private_ip_address=None, region_id=None, resource_group_id=None,
                 resource_owner_account=None, resource_owner_id=None, restore_time=None, restore_type=None, security_iplist=None,
                 source_dbinstance_name=None, source_region=None, system_dbcharset=None, used_time=None, vpcid=None, v_switch_id=None,
                 zone_id=None):
        # The ID of the backup set that is used for the restoration. You can call the [DescribeCrossRegionBackups](~~121733~~) operation to query the ID of the backup set.
        # 
        # > If you set the **RestoreType** parameter to **BackupSet**, you must specify this parameter.
        self.backup_set_id = backup_set_id  # type: str
        # The client token that is used to ensure the idempotence of the request. You can use the client to generate the value, but you must make sure that the generated token is unique among different requests. The token can only contain ASCII characters and cannot exceed 64 characters in length.
        self.client_token = client_token  # type: str
        # The connection mode of the destination instance. Valid values:
        # 
        # *   **Standard**: standard mode
        # *   **Safe**: database proxy mode
        # 
        # Default value: **Standard**.
        self.connection_mode = connection_mode  # type: str
        # The instance type of the destination instance. For more information, see [Primary ApsaraDB RDS instance types](~~26312~~).
        self.dbinstance_class = dbinstance_class  # type: str
        # The name of the destination instance. The name must be 2 to 256 characters in length. The name can contain letters, digits, underscores (\_), and hyphens (-). The name must start with a letter.
        # 
        # > The name cannot start with http:// or https://.
        self.dbinstance_description = dbinstance_description  # type: str
        # The network connection type of the destination instance. Valid values:
        # 
        # *   **Internet**\
        # *   **Intranet**\
        self.dbinstance_net_type = dbinstance_net_type  # type: str
        # The storage capacity of the destination instance. Valid values: **5 to 2000**. Unit: GB. You can increase the storage capacity at a step size of 5 GB. For more information, see [Primary instance types](~~26312~~).
        self.dbinstance_storage = dbinstance_storage  # type: int
        # The storage type of the destination instance. Only the local SSD storage type is supported. Default value: **local_ssd**.
        self.dbinstance_storage_type = dbinstance_storage_type  # type: str
        # The database engine of the destination instance. Valid values:
        # 
        # *   **MySQL**\
        # *   **SQLServer**\
        # *   **PostgreSQL**\
        self.engine = engine  # type: str
        # The major engine version of the destination instance. The value of this parameter varies based on the value of the **Engine** parameter.
        # 
        # *   Valid values when Engine is set to MySQL: **5.5, 5.6, 5.7, and 8.0**\
        # *   Valid values when Engine is set to SQLServer: **2008r2, 08r2\_ent_ha, 2012, 2012\_ent_ha, 2012\_std_ha, 2012\_web, 2014\_std_ha, 2016\_ent_ha, 2016\_std_ha, 2016\_web, 2017\_std_ha, 2017\_ent, 2019\_std_ha, and 2019\_ent**\
        # *   Valid values when Engine is set to PostgreSQL: **9.4, 10.0, 11.0, 12.0, and 13.0**\
        self.engine_version = engine_version  # type: str
        # The network type of the destination instance. Valid values:
        # 
        # *   **VPC**\
        # *   **Classic**\
        # 
        # Default value: Classic.
        # 
        # > If you set this parameter to **VPC**, you must also specify the **VpcId** and **VSwitchId** parameters.
        self.instance_network_type = instance_network_type  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The billing method of the destination instance. Valid values:
        # 
        # *   **Postpaid**: pay-as-you-go
        # *   **Prepaid**: subscription
        self.pay_type = pay_type  # type: str
        # The unit that is used to measure the subscription duration of the destination instance. Valid values:
        # 
        # *   **Year**\
        # *   **Month**\
        # 
        # > If you set the PayType parameter to **Prepaid**, you must specify the UsedTime parameter.
        self.period = period  # type: str
        # The private IP address of the destination instance. The private IP address must be within the CIDR block that is supported by the specified vSwitch. The system automatically assigns a private IP address to an instance based on the values of the **VPCId** and **VSwitchId** parameters.
        self.private_ip_address = private_ip_address  # type: str
        # The region ID of the destination instance. You can call the [DescribeRegions](~~26243~~) operation to query the most recent region list.
        self.region_id = region_id  # type: str
        # The ID of the resource group.
        self.resource_group_id = resource_group_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The point in time to which you want to restore data. The point in time that you specify must be earlier than the current time. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time must be in UTC.
        # 
        # > If the **RestoreType** parameter is set to **BackupTime**, you must specify this parameter.
        self.restore_time = restore_time  # type: str
        # The method that is used to restore data. Valid values:
        # 
        # *   **BackupSet**: Data is restored from a backup set. If you use this value, you must also specify the **BackupSetID** parameter.
        # *   **BackupTime**: restores data to a point in time. You must also specify the **RestoreTime**, **SourceRegion**, and **SourceDBInstanceName** parameters.
        self.restore_type = restore_type  # type: str
        # The IP address whitelist of the destination instance. If you want to add more than one entry to the IP address whitelist, separate the entries with commas (,). Each entry must be unique. You can add a maximum of 1,000 entries. For more information, see [Configure an IP address whitelist for an ApsaraDB RDS for MySQL instance](~~43185~~). The entries in the IP address whitelist must be in one of the following formats:
        # 
        # *   IP address. Example: 10.23.12.24.
        # *   CIDR block. Example: 10.23.12.24/24. In this example, 24 indicates that the prefix of the CIDR block is 24 bits in length. You can replace 24 with a value that ranges from 1 to 32.
        self.security_iplist = security_iplist  # type: str
        # The ID of the source instance if you want to restore data to a point in time.
        # 
        # > If you set the **RestoreType** parameter to **BackupTime**, you must specify this parameter.
        self.source_dbinstance_name = source_dbinstance_name  # type: str
        # The region ID of the source instance if you want to restore data to a point in time.
        # 
        # > If you set the **RestoreType** parameter to **BackupTime**, you must specify this parameter.
        self.source_region = source_region  # type: str
        # The character set of the destination instance. Valid values:
        # 
        # *   **utf8**\
        # *   **gbk**\
        # *   **latin1**\
        # *   **utf8mb4**\
        self.system_dbcharset = system_dbcharset  # type: str
        # The subscription duration of the instance. Valid values:
        # 
        # *   If you set the **Period** parameter to **Year**, the value of the UsedTime parameter ranges from **1 to 3**.
        # *   If you set the **Period** parameter to **Month**, the value of the UsedTime parameter ranges from **1 to 9**.
        # 
        # > If you set the PayType parameter to **Prepaid**, you must specify the UsedTime parameter.
        self.used_time = used_time  # type: str
        # The VPC ID of the destination instance. This parameter is available only when you set the **InstanceNetworkType** parameter to **VPC**.
        # 
        # > If you specify this parameter, you must also specify the **ZoneId** parameter.
        self.vpcid = vpcid  # type: str
        # The vSwitch ID of the destination instance. If you specify more than one vSwitch, separate the IDs of the vSwitches with commas (,). This parameter is available only when you set the **InstanceNetworkType** parameter to **VPC**.
        # 
        # > If you specify this parameter, you must also specify the **ZoneId** parameter.
        self.v_switch_id = v_switch_id  # type: str
        # The zone ID of the destination instance. If the destination instance is deployed in multiple zones, separate the IDs of the zones with colons (:).
        # 
        # > If you specify a virtual private cloud (VPC) and a vSwitch, you must specify this parameter to identify the zone for the vSwitch.
        self.zone_id = zone_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDdrInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_set_id is not None:
            result['BackupSetId'] = self.backup_set_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.connection_mode is not None:
            result['ConnectionMode'] = self.connection_mode
        if self.dbinstance_class is not None:
            result['DBInstanceClass'] = self.dbinstance_class
        if self.dbinstance_description is not None:
            result['DBInstanceDescription'] = self.dbinstance_description
        if self.dbinstance_net_type is not None:
            result['DBInstanceNetType'] = self.dbinstance_net_type
        if self.dbinstance_storage is not None:
            result['DBInstanceStorage'] = self.dbinstance_storage
        if self.dbinstance_storage_type is not None:
            result['DBInstanceStorageType'] = self.dbinstance_storage_type
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.engine_version is not None:
            result['EngineVersion'] = self.engine_version
        if self.instance_network_type is not None:
            result['InstanceNetworkType'] = self.instance_network_type
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.pay_type is not None:
            result['PayType'] = self.pay_type
        if self.period is not None:
            result['Period'] = self.period
        if self.private_ip_address is not None:
            result['PrivateIpAddress'] = self.private_ip_address
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.restore_time is not None:
            result['RestoreTime'] = self.restore_time
        if self.restore_type is not None:
            result['RestoreType'] = self.restore_type
        if self.security_iplist is not None:
            result['SecurityIPList'] = self.security_iplist
        if self.source_dbinstance_name is not None:
            result['SourceDBInstanceName'] = self.source_dbinstance_name
        if self.source_region is not None:
            result['SourceRegion'] = self.source_region
        if self.system_dbcharset is not None:
            result['SystemDBCharset'] = self.system_dbcharset
        if self.used_time is not None:
            result['UsedTime'] = self.used_time
        if self.vpcid is not None:
            result['VPCId'] = self.vpcid
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BackupSetId') is not None:
            self.backup_set_id = m.get('BackupSetId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('ConnectionMode') is not None:
            self.connection_mode = m.get('ConnectionMode')
        if m.get('DBInstanceClass') is not None:
            self.dbinstance_class = m.get('DBInstanceClass')
        if m.get('DBInstanceDescription') is not None:
            self.dbinstance_description = m.get('DBInstanceDescription')
        if m.get('DBInstanceNetType') is not None:
            self.dbinstance_net_type = m.get('DBInstanceNetType')
        if m.get('DBInstanceStorage') is not None:
            self.dbinstance_storage = m.get('DBInstanceStorage')
        if m.get('DBInstanceStorageType') is not None:
            self.dbinstance_storage_type = m.get('DBInstanceStorageType')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('EngineVersion') is not None:
            self.engine_version = m.get('EngineVersion')
        if m.get('InstanceNetworkType') is not None:
            self.instance_network_type = m.get('InstanceNetworkType')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PayType') is not None:
            self.pay_type = m.get('PayType')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('PrivateIpAddress') is not None:
            self.private_ip_address = m.get('PrivateIpAddress')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RestoreTime') is not None:
            self.restore_time = m.get('RestoreTime')
        if m.get('RestoreType') is not None:
            self.restore_type = m.get('RestoreType')
        if m.get('SecurityIPList') is not None:
            self.security_iplist = m.get('SecurityIPList')
        if m.get('SourceDBInstanceName') is not None:
            self.source_dbinstance_name = m.get('SourceDBInstanceName')
        if m.get('SourceRegion') is not None:
            self.source_region = m.get('SourceRegion')
        if m.get('SystemDBCharset') is not None:
            self.system_dbcharset = m.get('SystemDBCharset')
        if m.get('UsedTime') is not None:
            self.used_time = m.get('UsedTime')
        if m.get('VPCId') is not None:
            self.vpcid = m.get('VPCId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class CreateDdrInstanceResponseBody(TeaModel):
    def __init__(self, connection_string=None, dbinstance_id=None, order_id=None, port=None, request_id=None):
        # The endpoint that is used to connect to the destination instance.
        # 
        # > The **DBInstanceNetType** parameter indicates whether the endpoint is internal or public.
        self.connection_string = connection_string  # type: str
        # The ID of the destination instance.
        self.dbinstance_id = dbinstance_id  # type: str
        # The ID of the order.
        self.order_id = order_id  # type: str
        # The port number that is used to connect to the destination instance.
        # 
        # > The **DBInstanceNetType** parameter indicates whether the port is internal or public.
        self.port = port  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDdrInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.connection_string is not None:
            result['ConnectionString'] = self.connection_string
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.port is not None:
            result['Port'] = self.port
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConnectionString') is not None:
            self.connection_string = m.get('ConnectionString')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDdrInstanceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateDdrInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateDdrInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDdrInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDiagnosticReportRequest(TeaModel):
    def __init__(self, dbinstance_id=None, end_time=None, start_time=None):
        # The ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        # The end time of the monitored data that is used to generate the diagnostic report. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm*Z format. The time must be in UTC.
        self.end_time = end_time  # type: str
        # The start time of the monitored data that is used to generate the diagnostic report. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm*Z format. The time must be in UTC.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDiagnosticReportRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class CreateDiagnosticReportResponseBody(TeaModel):
    def __init__(self, report_id=None, request_id=None):
        # The ID of the diagnostic report.
        self.report_id = report_id  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDiagnosticReportResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.report_id is not None:
            result['ReportId'] = self.report_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ReportId') is not None:
            self.report_id = m.get('ReportId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDiagnosticReportResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateDiagnosticReportResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateDiagnosticReportResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDiagnosticReportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateGADInstanceRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        # The key of the tag. You can create N tag keys at a time. Valid values of N: **1 to 20**. The value of this parameter cannot be an empty string.
        self.key = key  # type: str
        # The value of the tag. You can create N tag values at a time. Valid values of N: **1 to 20**. The value of this parameter can be an empty string.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateGADInstanceRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateGADInstanceRequestUnitNode(TeaModel):
    def __init__(self, dbinstance_description=None, dbinstance_storage=None, dbinstance_storage_type=None,
                 db_instance_class=None, dts_conflict=None, dts_instance_class=None, engine=None, engine_version=None, pay_type=None,
                 region_id=None, security_iplist=None, v_switch_id=None, vpc_id=None, zone_id=None, zone_idslave_1=None,
                 zone_idslave_2=None):
        # The name of the unit node that you want to create. The name must meet the following requirements:
        # 
        # *   The name must be **2 to 255** characters in length.
        # *   The name can contain letters, digits, underscores (\_), and hyphens (-) and must start with a letter.
        # *   The name cannot start with `http://` or `https://`.
        # 
        # **N** in this parameter specifies unit node N. The value of N is an integer within the range of **1 to 10**. You can create up to 10 unit nodes in a global active database cluster.
        self.dbinstance_description = dbinstance_description  # type: str
        # The storage capacity of the unit node that you want to create. Unit: GB. The storage capacity increases at a step size of 5 GB. For more information, see [Primary ApsaraDB RDS instance types](~~26312~~). You can also call the [DescribeAvailableResource](~~134039~~) operation to query the storage capacity range that is supported for a specified instance type in a region.
        # 
        # **N** in this parameter specifies unit node N. The value of N is an integer within the range of **1 to 10**. You can create up to 10 unit nodes in a global active database cluster.
        self.dbinstance_storage = dbinstance_storage  # type: long
        # The storage type of the instance. Valid values:
        # 
        # *   **local_ssd**: local SSD. This is the recommended storage type.
        # *   **cloud_ssd**: standard SSD. This storage type is not recommended. Standard SSDs are no longer available for purchase in some Alibaba Cloud regions.
        # *   **cloud_essd**: ESSD of performance level 1 (PL1).
        # *   **cloud_essd2**: ESSD of PL2.
        # *   **cloud_essd3**: ESSD of PL3.
        # 
        # > The default value of this parameter varies based on the instance type specified by the **DBInstanceClass** parameter.
        # 
        # *   If the instance type specifies the local SSD storage type, the default value of this parameter is **local_ssd**.
        # 
        # *   If the instance type specifies the standard SSD or ESSD storage type, the default value of this parameter is **cloud_essd**.
        self.dbinstance_storage_type = dbinstance_storage_type  # type: str
        # The instance type of the unit node that you want to create. For more information, see [Primary ApsaraDB RDS instance types](~~26312~~). You can call the [DescribeAvailableResource](~~134039~~) operation to query the available instance types in a region.
        # 
        # **N** in this parameter specifies unit node N. The value of N is an integer within the range of **1 to 10**. You can create up to 10 unit nodes in a global active database cluster.
        self.db_instance_class = db_instance_class  # type: str
        # The conflict resolution policy based on which Data Transmission Service (DTS) responds to primary key conflicts during data synchronization to the unit node that you want to create. Valid values:
        # 
        # *   **overwrite**: DTS overwrites the conflicting primary key on the destination node.
        # *   **interrupt**: DTS stops the synchronization task, reports an error, and then exits.
        # *   **ignore**: DTS hides the conflicting primary key on the node.
        # 
        # **N** in this parameter specifies unit node N. The value of N is an integer within the range of **1 to 10**. You can create up to 10 unit nodes in a global active database cluster.
        self.dts_conflict = dts_conflict  # type: str
        # The specifications of the data synchronization task for the unit node that you want to create. Valid values:
        # 
        # *   **small**\
        # *   **medium**\
        # *   **large**\
        # *   **micro**\
        # 
        # > For more information, see [Specifications of data synchronization tasks](~~26605~~).
        # 
        # **N** in this parameter specifies unit node N. The value of N is an integer within the range of **1 to 10**. You can create up to 10 unit nodes in a global active database cluster.
        self.dts_instance_class = dts_instance_class  # type: str
        # The database engine of the unit node that you want to create. Set the value to **MySQL**.
        # 
        # **N** in this parameter specifies unit node N. The value of N is an integer within the range of **1 to 10**. You can create up to 10 unit nodes in a global active database cluster.
        self.engine = engine  # type: str
        # The database engine version of the unit node that you want to create. Valid values:
        # 
        # *   **8.0**\
        # *   **5.7**\
        # *   **5.6**\
        # *   **5.5**\
        # 
        # **N** in this parameter specifies unit node N. The value of N is an integer within the range of **1 to 10**. You can create up to 10 unit nodes in a global active database cluster.
        self.engine_version = engine_version  # type: str
        # The billing method of the unit node that you want to create. Valid values:
        # 
        # *   **Postpaid**: pay-as-you-go
        # *   **Prepaid**: subscription
        # 
        # > The system automatically generates a purchase order and completes the payment.
        # 
        # **N** in this parameter specifies unit node N. The value of N is an integer within the range of **1 to 10**. You can create up to 10 unit nodes in a global active database cluster.
        self.pay_type = pay_type  # type: str
        # The region ID of the unit node that you want to create. You can call the [DescribeRegions](~~26243~~) operation to query the most recent region list.
        # 
        # **N** in this parameter specifies unit node N. The value of N is an integer within the range of **1 to 10**. You can create up to 10 unit nodes in a global active database cluster.
        self.region_id = region_id  # type: str
        # The IP address whitelist of the unit node that you want to create. For more information, see [IP address whitelist](~~43185~~). If the IP address whitelist contains more than one entry, separate the entries with commas (,). Each entry must be unique. The IP address whitelist can contain up to 1,000 entries. The entries in the IP address whitelist must be in one of the following formats:
        # 
        # *   IP addresses, such as `10.10.10.10`.
        # *   CIDR blocks, such as `10.10.10.10/24`. In this example, **24** indicates that the prefix of each IP address in the IP address whitelist is 24 bits in length. You can replace 24 with a value within the range of **1 to 32**.
        # 
        # **N** in this parameter specifies unit node N. The value of N is an integer within the range of **1 to 10**. You can create up to 10 unit nodes in a global active database cluster.
        self.security_iplist = security_iplist  # type: str
        # The vSwitch ID of the unit node that you want to create.
        # 
        # **N** in this parameter specifies unit node N. The value of N is an integer within the range of **1 to 10**. You can create up to 10 unit nodes in a global active database cluster.
        self.v_switch_id = v_switch_id  # type: str
        # The virtual private cloud (VPC) ID of the unit node that you want to create.
        # 
        # **N** in this parameter specifies unit node N. The value of N is an integer within the range of **1 to 10**. You can create up to 10 unit nodes in a global active database cluster.
        self.vpc_id = vpc_id  # type: str
        # The zone ID of the unit node that you want to create. You can call the [DescribeRegions](~~26243~~) operation to query the ID of the zone.
        # 
        # **N** in this parameter specifies unit node N. The value of N is an integer within the range of **1 to 10**. You can create up to 10 unit nodes in a global active database cluster.
        self.zone_id = zone_id  # type: str
        # The zone ID of the secondary node of the unit node that you want to create. You can call the [DescribeRegions](~~26243~~) operation to query the ID of the zone ID.
        # 
        # *   If the value of this parameter is the same as the **zone ID** of the unit node that you want to create, the single-zone deployment method is used.
        # *   If the value of this parameter is different from the **zone ID** of the unit node that you want to create, the multiple-zone deployment method is used.
        # 
        # **N** in this parameter specifies unit node N. The value of N is an integer within the range of **1 to 10**. You can create up to 10 unit nodes in a global active database cluster.
        self.zone_idslave_1 = zone_idslave_1  # type: str
        # The zone ID of the logger node of the unit node that you want to create. You can call the [DescribeRegions](~~26243~~) operation to query the ID of the zone.
        # 
        # *   If the value of this parameter is the same as the **zone ID** of the unit node that you want to create, the single-zone deployment method is used.
        # *   If the value of this parameter is different from the **zone ID** of the unit node that you want to create, the multiple-zone deployment method is used.
        # 
        # **N** in this parameter specifies unit node N. The value of N is an integer within the range of **1 to 10**. You can create up to 10 unit nodes in a global active database cluster.
        self.zone_idslave_2 = zone_idslave_2  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateGADInstanceRequestUnitNode, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_description is not None:
            result['DBInstanceDescription'] = self.dbinstance_description
        if self.dbinstance_storage is not None:
            result['DBInstanceStorage'] = self.dbinstance_storage
        if self.dbinstance_storage_type is not None:
            result['DBInstanceStorageType'] = self.dbinstance_storage_type
        if self.db_instance_class is not None:
            result['DbInstanceClass'] = self.db_instance_class
        if self.dts_conflict is not None:
            result['DtsConflict'] = self.dts_conflict
        if self.dts_instance_class is not None:
            result['DtsInstanceClass'] = self.dts_instance_class
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.engine_version is not None:
            result['EngineVersion'] = self.engine_version
        if self.pay_type is not None:
            result['PayType'] = self.pay_type
        if self.region_id is not None:
            result['RegionID'] = self.region_id
        if self.security_iplist is not None:
            result['SecurityIPList'] = self.security_iplist
        if self.v_switch_id is not None:
            result['VSwitchID'] = self.v_switch_id
        if self.vpc_id is not None:
            result['VpcID'] = self.vpc_id
        if self.zone_id is not None:
            result['ZoneID'] = self.zone_id
        if self.zone_idslave_1 is not None:
            result['ZoneIDSlave1'] = self.zone_idslave_1
        if self.zone_idslave_2 is not None:
            result['ZoneIDSlave2'] = self.zone_idslave_2
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DBInstanceDescription') is not None:
            self.dbinstance_description = m.get('DBInstanceDescription')
        if m.get('DBInstanceStorage') is not None:
            self.dbinstance_storage = m.get('DBInstanceStorage')
        if m.get('DBInstanceStorageType') is not None:
            self.dbinstance_storage_type = m.get('DBInstanceStorageType')
        if m.get('DbInstanceClass') is not None:
            self.db_instance_class = m.get('DbInstanceClass')
        if m.get('DtsConflict') is not None:
            self.dts_conflict = m.get('DtsConflict')
        if m.get('DtsInstanceClass') is not None:
            self.dts_instance_class = m.get('DtsInstanceClass')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('EngineVersion') is not None:
            self.engine_version = m.get('EngineVersion')
        if m.get('PayType') is not None:
            self.pay_type = m.get('PayType')
        if m.get('RegionID') is not None:
            self.region_id = m.get('RegionID')
        if m.get('SecurityIPList') is not None:
            self.security_iplist = m.get('SecurityIPList')
        if m.get('VSwitchID') is not None:
            self.v_switch_id = m.get('VSwitchID')
        if m.get('VpcID') is not None:
            self.vpc_id = m.get('VpcID')
        if m.get('ZoneID') is not None:
            self.zone_id = m.get('ZoneID')
        if m.get('ZoneIDSlave1') is not None:
            self.zone_idslave_1 = m.get('ZoneIDSlave1')
        if m.get('ZoneIDSlave2') is not None:
            self.zone_idslave_2 = m.get('ZoneIDSlave2')
        return self


class CreateGADInstanceRequest(TeaModel):
    def __init__(self, central_dbinstance_id=None, central_rds_dts_admin_account=None,
                 central_rds_dts_admin_password=None, central_region_id=None, dblist=None, description=None, resource_group_id=None, tag=None,
                 unit_node=None):
        # The ID of the primary instance. You can call the [DescribeDBInstances](~~26232~~) operation to query the ID of instance. The primary instance serves as the central node of the global active database cluster.
        # 
        # > 
        # 
        # *   A primary instance can serve as the central node only of a single global active database cluster.
        # 
        # *   Only a primary instance that is created in one of the following regions can serve as the central node of a global active database cluster: China (Hangzhou), China (Shanghai), China (Qingdao), China (Beijing), China (Zhangjiakou), China (Shenzhen), and China (Chengdu).
        self.central_dbinstance_id = central_dbinstance_id  # type: str
        # The username of the privileged account of the central node. You can call the [DescribeAccounts](~~26265~~) operation to query the privileged account of the central node.
        self.central_rds_dts_admin_account = central_rds_dts_admin_account  # type: str
        # The password of the privileged account of the central node.
        self.central_rds_dts_admin_password = central_rds_dts_admin_password  # type: str
        # The region ID of the central node. You can call the [DescribeRegions](~~26243~~) operation to query the most recent region list.
        self.central_region_id = central_region_id  # type: str
        # A JSON array that consists of the information about a specified database on the central node. All database information that you specify in this array is synchronized to the unit nodes of the global active database cluster. The JSON array contains the following fields:
        # 
        # *   **name**: the name of the database.
        # *   **all**: specifies whether to synchronize all data in the database or the table. Valid values: **true** and **false**.
        # *   **Table**: the name of the table. If you set the **all** field to **false**, you must nest the name of the table that you want to synchronize into the JSON array.
        # 
        # Example: `{ "testdb": { "name": "testdb", "all": false, "Table": { "order": { "name": "order", "all": true }, "ordernew": { "name": "ordernew", "all": true } } } }`
        self.dblist = dblist  # type: str
        # The name of the global active database cluster.
        self.description = description  # type: str
        # The ID of the resource group to which the instance belongs.
        self.resource_group_id = resource_group_id  # type: str
        # The details of the tag that is added to the instance.
        self.tag = tag  # type: list[CreateGADInstanceRequestTag]
        # The information about the unit node.
        self.unit_node = unit_node  # type: list[CreateGADInstanceRequestUnitNode]

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()
        if self.unit_node:
            for k in self.unit_node:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateGADInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.central_dbinstance_id is not None:
            result['CentralDBInstanceId'] = self.central_dbinstance_id
        if self.central_rds_dts_admin_account is not None:
            result['CentralRdsDtsAdminAccount'] = self.central_rds_dts_admin_account
        if self.central_rds_dts_admin_password is not None:
            result['CentralRdsDtsAdminPassword'] = self.central_rds_dts_admin_password
        if self.central_region_id is not None:
            result['CentralRegionId'] = self.central_region_id
        if self.dblist is not None:
            result['DBList'] = self.dblist
        if self.description is not None:
            result['Description'] = self.description
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        result['UnitNode'] = []
        if self.unit_node is not None:
            for k in self.unit_node:
                result['UnitNode'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CentralDBInstanceId') is not None:
            self.central_dbinstance_id = m.get('CentralDBInstanceId')
        if m.get('CentralRdsDtsAdminAccount') is not None:
            self.central_rds_dts_admin_account = m.get('CentralRdsDtsAdminAccount')
        if m.get('CentralRdsDtsAdminPassword') is not None:
            self.central_rds_dts_admin_password = m.get('CentralRdsDtsAdminPassword')
        if m.get('CentralRegionId') is not None:
            self.central_region_id = m.get('CentralRegionId')
        if m.get('DBList') is not None:
            self.dblist = m.get('DBList')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateGADInstanceRequestTag()
                self.tag.append(temp_model.from_map(k))
        self.unit_node = []
        if m.get('UnitNode') is not None:
            for k in m.get('UnitNode'):
                temp_model = CreateGADInstanceRequestUnitNode()
                self.unit_node.append(temp_model.from_map(k))
        return self


class CreateGADInstanceResponseBodyResult(TeaModel):
    def __init__(self, create_member_count=None, gad_instance_name=None, task_id=None):
        # The number of unit nodes that are created by calling this operation.
        self.create_member_count = create_member_count  # type: str
        # The ID of the global active database cluster.
        self.gad_instance_name = gad_instance_name  # type: str
        # The ID of the task.
        self.task_id = task_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateGADInstanceResponseBodyResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_member_count is not None:
            result['CreateMemberCount'] = self.create_member_count
        if self.gad_instance_name is not None:
            result['GadInstanceName'] = self.gad_instance_name
        if self.task_id is not None:
            result['TaskID'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreateMemberCount') is not None:
            self.create_member_count = m.get('CreateMemberCount')
        if m.get('GadInstanceName') is not None:
            self.gad_instance_name = m.get('GadInstanceName')
        if m.get('TaskID') is not None:
            self.task_id = m.get('TaskID')
        return self


class CreateGADInstanceResponseBody(TeaModel):
    def __init__(self, request_id=None, result=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # An array that consists of the information returned.
        self.result = result  # type: CreateGADInstanceResponseBodyResult

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super(CreateGADInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result is not None:
            result['Result'] = self.result.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Result') is not None:
            temp_model = CreateGADInstanceResponseBodyResult()
            self.result = temp_model.from_map(m['Result'])
        return self


class CreateGADInstanceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateGADInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateGADInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateGADInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateGadInstanceMemberRequestUnitNode(TeaModel):
    def __init__(self, dbinstance_description=None, dbinstance_storage=None, dbinstance_storage_type=None,
                 db_instance_class=None, dts_conflict=None, dts_instance_class=None, engine=None, engine_version=None, region_id=None,
                 security_iplist=None, v_switch_id=None, vpc_id=None, zone_id=None, zone_idslave_1=None, zone_idslave_2=None):
        # The name of the unit node that you want to create. The name must meet the following requirements:
        # 
        # *   The name must be **2 to 255** characters in length.
        # *   The name can contain letters, digits, underscores (\_), and hyphens (-) and must start with a letter.
        # *   The name cannot start with `http://` or `https://`.
        # 
        # **N** in this parameter specifies the Nth unit node. The value of N is an integer within the range of **1 to 10**. You can create up to 10 unit nodes in a global active database cluster.
        self.dbinstance_description = dbinstance_description  # type: str
        # The storage capacity of the unit node that you want to create. Unit: GB. You can adjust the storage capacity in increments of 5 GB. For more information, see [Primary ApsaraDB RDS instance types](~~26312~~). You can call the [DescribeAvailableResource](~~134039~~) operation to query the storage capacity range that is supported for a specified instance type in a region.
        # 
        # **N** in this parameter specifies the Nth unit node. The value of N is an integer within the range of **1 to 10**. You can create up to 10 unit nodes in a global active database cluster.
        self.dbinstance_storage = dbinstance_storage  # type: long
        # The type of storage media that is used for the instance. Valid values:
        # 
        # * **local_ssd**: local SSDs. This is the recommended storage type.
        # * **cloud_ssd**: standard SSDs.
        # * **cloud_essd**: enhanced SSDs (ESSDs) of performance level 1 (PL1).
        # * **cloud_essd2**: ESSDs of PL2.
        # * **cloud_essd3**: ESSDs of PL3.
        self.dbinstance_storage_type = dbinstance_storage_type  # type: str
        # The instance type of the unit node that you want to create. For more information, see [Primary ApsaraDB RDS instance types](~~26312~~). You can call the [DescribeAvailableResource](~~134039~~) operation to query the available instance types in a region.
        # 
        # **N** in this parameter specifies the Nth unit node. The value of N is an integer within the range of **1 to 10**. You can create up to 10 unit nodes in a global active database cluster.
        self.db_instance_class = db_instance_class  # type: str
        # The conflict resolution policy of the unit node that you want to create. This policy is based on which Data Transmission Service (DTS) responds to primary key conflicts during data synchronization to the new unit node. Valid values:
        # 
        # *   **overwrite**: DTS overwrites the conflicting primary key on the destination node.
        # *   **interrupt**: DTS stops the synchronization task, reports an error, and then exits.
        # *   **ignore**: DTS overwrites the conflicting primary key on the logger node.
        # 
        # **N** in this parameter specifies unit node N. The value of N is an integer within the range of **1 to 10**. You can create up to 10 unit nodes in a global active database cluster.
        self.dts_conflict = dts_conflict  # type: str
        # The specifications of the data synchronization task for the unit node that you want to create. Valid values:
        # 
        # *   **small**\
        # *   **medium**\
        # *   **large**\
        # *   **micro**\
        # 
        # >  For more information, see [Specifications of data synchronization tasks](~~26605~~).
        # 
        # **N** in this parameter specifies the Nth unit node. The value of N is an integer within the range of **1 to 10**. You can create up to 10 unit nodes in a global active database cluster.
        self.dts_instance_class = dts_instance_class  # type: str
        # The database engine of the unit node that you want to create. Set the value to **MySQL**.
        # 
        # **N** in this parameter specifies the Nth unit node. The value of N is an integer within the range of **1 to 10**. You can create up to 10 unit nodes in a global active database cluster.
        self.engine = engine  # type: str
        # The database engine version of the unit node that you want to create. Valid values:
        # 
        # *   **8.0**\
        # *   **5.7**\
        # *   **5.6**\
        # *   **5.5**\
        # 
        # **N** in this parameter specifies the Nth unit node. The value of N is an integer within the range of **1 to 10**. You can create up to 10 unit nodes in a global active database cluster.
        self.engine_version = engine_version  # type: str
        # The region ID of the unit node that you want to create. You can call the [DescribeRegions](~~26243~~) operation to query the most recent region list.
        # 
        # **N** in this parameter specifies the Nth unit node. The value of N is an integer within the range of **1 to 10**. You can create up to 10 unit nodes in a global active database cluster.
        self.region_id = region_id  # type: str
        # The IP address allowlist of the unit node that you want to create. For more information, see [IP address allowlist](~~43185~~). If the IP address allowlist contains more than one entry, separate the entries with commas (,). Each entry must be unique. The IP address allowlist can contain up to 1,000 entries. The entries in the IP address allowlist must be in one of the following formats:
        # 
        # *   IP addresses, such as `10.10.XX.XX`.
        # *   CIDR blocks, such as `10.10.XX.XX/24`. In this example, **24** indicates that the prefix of each IP address in the IP address allowlist is 24 bits in length. You can replace 24 with a value within the range of **1 to 32**.
        # 
        # **N** in this parameter specifies the Nth unit node. The value of N is an integer within the range of **1 to 10**. You can create up to 10 unit nodes in a global active database cluster.
        self.security_iplist = security_iplist  # type: str
        # The vSwitch ID of the unit node that you want to create.
        # 
        # **N** in this parameter specifies the Nth unit node. The value of N is an integer within the range of **1 to 10**. You can create up to 10 unit nodes in a global active database cluster.
        self.v_switch_id = v_switch_id  # type: str
        # The virtual private cloud (VPC) ID of the unit node that you want to create.
        # 
        # **N** in this parameter specifies the Nth unit node. The value of N is an integer within the range of **1 to 10**. You can create up to 10 unit nodes in a global active database cluster.
        self.vpc_id = vpc_id  # type: str
        # The zone ID of the unit node that you want to create. You can call the [DescribeRegions](~~26243~~) operation to query zone IDs.
        # 
        # **N** in this parameter specifies the Nth unit node. The value of N is an integer within the range of **1 to 10**. You can create up to 10 unit nodes in a global active database cluster.
        self.zone_id = zone_id  # type: str
        # The zone ID of the secondary node of the unit node that you want to create. You can call the [DescribeRegions](~~26243~~) operation to query zone IDs.
        # 
        # *   If the **zone ID** of the unit node that you want to create is the same as the zone ID of its logger node, the single-zone deployment method is used.
        # *   If the **zone ID** of the unit node that you want to create is different from the zone ID of its logger node, the multiple-zone deployment method is used.
        # 
        # **N** in this parameter specifies the Nth unit node. The value of N is an integer within the range of **1 to 10**. You can create up to 10 unit nodes in a global active database cluster.
        self.zone_idslave_1 = zone_idslave_1  # type: str
        # The zone ID of the logger node of the unit node that you want to create. You can call the [DescribeRegions](~~26243~~) operation to query zone IDs.
        # 
        # *   If the **zone ID** of the unit node that you want to create is the same as the zone ID of its logger node, the single-zone deployment method is used.
        # *   If the **zone ID** of the unit node that you want to create is different from the zone ID of its logger node, the multiple-zone deployment method is used.
        # 
        # **N** in this parameter specifies the Nth unit node. The value of N is an integer within the range of **1 to 10**. You can create up to 10 unit nodes in a global active database cluster.
        self.zone_idslave_2 = zone_idslave_2  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateGadInstanceMemberRequestUnitNode, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_description is not None:
            result['DBInstanceDescription'] = self.dbinstance_description
        if self.dbinstance_storage is not None:
            result['DBInstanceStorage'] = self.dbinstance_storage
        if self.dbinstance_storage_type is not None:
            result['DBInstanceStorageType'] = self.dbinstance_storage_type
        if self.db_instance_class is not None:
            result['DbInstanceClass'] = self.db_instance_class
        if self.dts_conflict is not None:
            result['DtsConflict'] = self.dts_conflict
        if self.dts_instance_class is not None:
            result['DtsInstanceClass'] = self.dts_instance_class
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.engine_version is not None:
            result['EngineVersion'] = self.engine_version
        if self.region_id is not None:
            result['RegionID'] = self.region_id
        if self.security_iplist is not None:
            result['SecurityIPList'] = self.security_iplist
        if self.v_switch_id is not None:
            result['VSwitchID'] = self.v_switch_id
        if self.vpc_id is not None:
            result['VpcID'] = self.vpc_id
        if self.zone_id is not None:
            result['ZoneID'] = self.zone_id
        if self.zone_idslave_1 is not None:
            result['ZoneIDSlave1'] = self.zone_idslave_1
        if self.zone_idslave_2 is not None:
            result['ZoneIDSlave2'] = self.zone_idslave_2
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DBInstanceDescription') is not None:
            self.dbinstance_description = m.get('DBInstanceDescription')
        if m.get('DBInstanceStorage') is not None:
            self.dbinstance_storage = m.get('DBInstanceStorage')
        if m.get('DBInstanceStorageType') is not None:
            self.dbinstance_storage_type = m.get('DBInstanceStorageType')
        if m.get('DbInstanceClass') is not None:
            self.db_instance_class = m.get('DbInstanceClass')
        if m.get('DtsConflict') is not None:
            self.dts_conflict = m.get('DtsConflict')
        if m.get('DtsInstanceClass') is not None:
            self.dts_instance_class = m.get('DtsInstanceClass')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('EngineVersion') is not None:
            self.engine_version = m.get('EngineVersion')
        if m.get('RegionID') is not None:
            self.region_id = m.get('RegionID')
        if m.get('SecurityIPList') is not None:
            self.security_iplist = m.get('SecurityIPList')
        if m.get('VSwitchID') is not None:
            self.v_switch_id = m.get('VSwitchID')
        if m.get('VpcID') is not None:
            self.vpc_id = m.get('VpcID')
        if m.get('ZoneID') is not None:
            self.zone_id = m.get('ZoneID')
        if m.get('ZoneIDSlave1') is not None:
            self.zone_idslave_1 = m.get('ZoneIDSlave1')
        if m.get('ZoneIDSlave2') is not None:
            self.zone_idslave_2 = m.get('ZoneIDSlave2')
        return self


class CreateGadInstanceMemberRequest(TeaModel):
    def __init__(self, central_dbinstance_id=None, central_rds_dts_admin_account=None,
                 central_rds_dts_admin_password=None, central_region_id=None, dblist=None, gad_instance_id=None, unit_node=None):
        # The ID of the central node. You can call the [DescribeGadInstances](~~330105~~) operation to query the ID of the central node.
        self.central_dbinstance_id = central_dbinstance_id  # type: str
        # The username of the privileged account of the central node. You can call the [DescribeAccounts](~~26265~~) operation to query the privileged account of the central node.
        self.central_rds_dts_admin_account = central_rds_dts_admin_account  # type: str
        # The password of the privileged account of the central node.
        self.central_rds_dts_admin_password = central_rds_dts_admin_password  # type: str
        # The region ID of the central node. You can call the [DescribeRegions](~~26243~~) operation to query the most recent region list.
        self.central_region_id = central_region_id  # type: str
        # A JSON array that consists of the information about the databases on the central node. All database information that you specify in this array is synchronized to the unit nodes of the global active database cluster. The JSON array contains the following parameters:
        # 
        # *   **name**: the name of the database.
        # *   **all**: specifies whether to synchronize all data in the database or the table. Valid values: **true** and **false**.
        # *   **Table**: the name of the table. If you set the **all** parameter to **false**, you must nest the name of the table that you want to synchronize into the JSON array.
        # 
        # Example: `{ "testdb": { "name": "testdb", "all": false, "Table": { "order": { "name": "order", "all": true }, "ordernew": { "name": "ordernew", "all": true } } } }`
        # 
        # >  For more information, see [Objects of DTS tasks](~~209545~~).
        self.dblist = dblist  # type: str
        # The ID of the global active database cluster. You can call the [DescribeGadInstances](~~330105~~) operation to query the ID of the global active database cluster.
        self.gad_instance_id = gad_instance_id  # type: str
        # The list of the unit nodes.
        self.unit_node = unit_node  # type: list[CreateGadInstanceMemberRequestUnitNode]

    def validate(self):
        if self.unit_node:
            for k in self.unit_node:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateGadInstanceMemberRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.central_dbinstance_id is not None:
            result['CentralDBInstanceId'] = self.central_dbinstance_id
        if self.central_rds_dts_admin_account is not None:
            result['CentralRdsDtsAdminAccount'] = self.central_rds_dts_admin_account
        if self.central_rds_dts_admin_password is not None:
            result['CentralRdsDtsAdminPassword'] = self.central_rds_dts_admin_password
        if self.central_region_id is not None:
            result['CentralRegionId'] = self.central_region_id
        if self.dblist is not None:
            result['DBList'] = self.dblist
        if self.gad_instance_id is not None:
            result['GadInstanceId'] = self.gad_instance_id
        result['UnitNode'] = []
        if self.unit_node is not None:
            for k in self.unit_node:
                result['UnitNode'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CentralDBInstanceId') is not None:
            self.central_dbinstance_id = m.get('CentralDBInstanceId')
        if m.get('CentralRdsDtsAdminAccount') is not None:
            self.central_rds_dts_admin_account = m.get('CentralRdsDtsAdminAccount')
        if m.get('CentralRdsDtsAdminPassword') is not None:
            self.central_rds_dts_admin_password = m.get('CentralRdsDtsAdminPassword')
        if m.get('CentralRegionId') is not None:
            self.central_region_id = m.get('CentralRegionId')
        if m.get('DBList') is not None:
            self.dblist = m.get('DBList')
        if m.get('GadInstanceId') is not None:
            self.gad_instance_id = m.get('GadInstanceId')
        self.unit_node = []
        if m.get('UnitNode') is not None:
            for k in m.get('UnitNode'):
                temp_model = CreateGadInstanceMemberRequestUnitNode()
                self.unit_node.append(temp_model.from_map(k))
        return self


class CreateGadInstanceMemberResponseBodyResult(TeaModel):
    def __init__(self, create_count=None, gad_instance_name=None):
        # The number of unit nodes that are created by calling this operation.
        self.create_count = create_count  # type: str
        # The ID of the global active database cluster.
        self.gad_instance_name = gad_instance_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateGadInstanceMemberResponseBodyResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_count is not None:
            result['CreateCount'] = self.create_count
        if self.gad_instance_name is not None:
            result['GadInstanceName'] = self.gad_instance_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreateCount') is not None:
            self.create_count = m.get('CreateCount')
        if m.get('GadInstanceName') is not None:
            self.gad_instance_name = m.get('GadInstanceName')
        return self


class CreateGadInstanceMemberResponseBody(TeaModel):
    def __init__(self, request_id=None, result=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # An array that consists of the information returned.
        self.result = result  # type: CreateGadInstanceMemberResponseBodyResult

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super(CreateGadInstanceMemberResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result is not None:
            result['Result'] = self.result.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Result') is not None:
            temp_model = CreateGadInstanceMemberResponseBodyResult()
            self.result = temp_model.from_map(m['Result'])
        return self


class CreateGadInstanceMemberResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateGadInstanceMemberResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateGadInstanceMemberResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateGadInstanceMemberResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateMigrateTaskRequest(TeaModel):
    def __init__(self, backup_mode=None, check_dbmode=None, dbinstance_id=None, dbname=None, is_online_db=None,
                 migrate_task_id=None, ossurls=None, oss_object_positions=None, owner_id=None, resource_owner_account=None,
                 resource_owner_id=None):
        # The type of the migration task. Valid values:
        # 
        # *   **FULL**: The migration task migrates full backup files.
        # *   **UPDF**: The migration task migrates incremental or log backup files.
        self.backup_mode = backup_mode  # type: str
        # The consistency check method for the database. Valid values:
        # 
        # *   **SyncExecuteDBCheck**: synchronous database check
        # *   **AsyncExecuteDBCheck**: asynchronous database check
        # 
        # Default value: **AsyncExecuteDBCheck** (compatible with SQL Server 2008 R2).
        # 
        # > When you set the **IsOnlineDB** parameter to **True**, the value of this parameter is valid.
        self.check_dbmode = check_dbmode  # type: str
        # The ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        # The name of the database.
        self.dbname = dbname  # type: str
        # Specifies whether to make the restored database data available for user access. Valid values:
        # 
        # *   **True**\
        # *   **False**\
        # 
        # > Set the value to **True** for instances that run SQL Server 2008 R2.
        self.is_online_db = is_online_db  # type: str
        # The ID of the migration task.
        # 
        # *   If you set the **BackupMode** parameter to **FULL**, the value of this parameter is empty. The full backup mode is compatible with instance that runs SQL Server 2008 R2.
        # *   If you set the **BackupMode** parameter to **UPDF**, the value of this parameter is the ID of the required full migration task.
        # 
        # > 
        # 
        # *   If you set the **IsOnlineDB** parameter to **True**, the value of the **BackupMode** parameter must be **FULL**.
        # 
        # *   If you set the **IsOnlineDB** parameter to **False**, the value of the **BackupMode** parameter must be **UPDF**.
        self.migrate_task_id = migrate_task_id  # type: str
        # The shared URL of the backup file in the OSS bucket. The URL must be encoded.
        # 
        # If you specify multiple URLs, separate them with vertical bars (|) and then encode them.
        # 
        # > This parameter is required for instances that run SQL Server 2008 R2.
        self.ossurls = ossurls  # type: str
        # The information about the backup file in the OSS bucket.
        # 
        # The values consist of three parts that are separated by colons (:):
        # 
        # *   The OSS endpoint: oss-ap-southeast-1.aliyuncs.com.
        # *   The name of the OSS bucket: rdsmssqlsingapore.
        # *   The key of the backup file in the OSS bucket: autotest\_2008R2\_TestMigration_FULL.bak.
        # 
        # > 
        # 
        # *   This parameter is optional for instances that run SQL Server 2008 R2.
        # 
        # *   This parameter is required for instances that run a database engine later than SQL Server 2008 R2.
        self.oss_object_positions = oss_object_positions  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateMigrateTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_mode is not None:
            result['BackupMode'] = self.backup_mode
        if self.check_dbmode is not None:
            result['CheckDBMode'] = self.check_dbmode
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dbname is not None:
            result['DBName'] = self.dbname
        if self.is_online_db is not None:
            result['IsOnlineDB'] = self.is_online_db
        if self.migrate_task_id is not None:
            result['MigrateTaskId'] = self.migrate_task_id
        if self.ossurls is not None:
            result['OSSUrls'] = self.ossurls
        if self.oss_object_positions is not None:
            result['OssObjectPositions'] = self.oss_object_positions
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BackupMode') is not None:
            self.backup_mode = m.get('BackupMode')
        if m.get('CheckDBMode') is not None:
            self.check_dbmode = m.get('CheckDBMode')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DBName') is not None:
            self.dbname = m.get('DBName')
        if m.get('IsOnlineDB') is not None:
            self.is_online_db = m.get('IsOnlineDB')
        if m.get('MigrateTaskId') is not None:
            self.migrate_task_id = m.get('MigrateTaskId')
        if m.get('OSSUrls') is not None:
            self.ossurls = m.get('OSSUrls')
        if m.get('OssObjectPositions') is not None:
            self.oss_object_positions = m.get('OssObjectPositions')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class CreateMigrateTaskResponseBody(TeaModel):
    def __init__(self, backup_mode=None, dbinstance_id=None, dbname=None, migrate_task_id=None, request_id=None,
                 task_id=None):
        # The type of the migration task. Valid values:
        # 
        # *   **FULL**: The migration task migrates full backup files.
        # *   **UPDF**: The migration task migrates incremental or log backup files.
        self.backup_mode = backup_mode  # type: str
        # The ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        # The name of the database.
        self.dbname = dbname  # type: str
        # The ID of the migration task.
        self.migrate_task_id = migrate_task_id  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The ID of the task.
        self.task_id = task_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateMigrateTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_mode is not None:
            result['BackupMode'] = self.backup_mode
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dbname is not None:
            result['DBName'] = self.dbname
        if self.migrate_task_id is not None:
            result['MigrateTaskId'] = self.migrate_task_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BackupMode') is not None:
            self.backup_mode = m.get('BackupMode')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DBName') is not None:
            self.dbname = m.get('DBName')
        if m.get('MigrateTaskId') is not None:
            self.migrate_task_id = m.get('MigrateTaskId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class CreateMigrateTaskResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateMigrateTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateMigrateTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateMigrateTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOnlineDatabaseTaskRequest(TeaModel):
    def __init__(self, check_dbmode=None, client_token=None, dbinstance_id=None, dbname=None, migrate_task_id=None,
                 owner_account=None, owner_id=None, resource_owner_account=None, resource_owner_id=None):
        # The consistency check method after the database is open. Valid values:
        # 
        # *   **SyncExecuteDBCheck**: synchronous database check
        # *   **AsyncExecuteDBCheck**: asynchronous database check
        # 
        # >  The check methods are supported for RDS instances that run SQL Server 2008 R2.
        self.check_dbmode = check_dbmode  # type: str
        # The client token that is used to ensure the idempotency of the request. You can use the client to generate the value, but you must ensure that it is unique among different requests. The token can only contain ASCII characters and cannot exceed 64 characters in length.
        self.client_token = client_token  # type: str
        # The ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        # The name of the database.
        self.dbname = dbname  # type: str
        # The ID of the migration task.
        self.migrate_task_id = migrate_task_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateOnlineDatabaseTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_dbmode is not None:
            result['CheckDBMode'] = self.check_dbmode
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dbname is not None:
            result['DBName'] = self.dbname
        if self.migrate_task_id is not None:
            result['MigrateTaskId'] = self.migrate_task_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CheckDBMode') is not None:
            self.check_dbmode = m.get('CheckDBMode')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DBName') is not None:
            self.dbname = m.get('DBName')
        if m.get('MigrateTaskId') is not None:
            self.migrate_task_id = m.get('MigrateTaskId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class CreateOnlineDatabaseTaskResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateOnlineDatabaseTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateOnlineDatabaseTaskResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateOnlineDatabaseTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateOnlineDatabaseTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateOnlineDatabaseTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateParameterGroupRequest(TeaModel):
    def __init__(self, engine=None, engine_version=None, owner_id=None, parameter_group_desc=None,
                 parameter_group_name=None, parameters=None, region_id=None, resource_owner_account=None, resource_owner_id=None):
        # The database engine. Valid values:
        # 
        # *   **mysql**\
        # *   **PostgreSQL**\
        self.engine = engine  # type: str
        # The database engine version that is run on the instance. Valid values:
        # 
        # *   If the instance runs MySQL, the instance must run one of the following MySQL versions:
        # 
        #     *   **5.6**\
        #     *   **5.7**\
        #     *   **8.0**\
        # 
        # *   If the instance runs PostgreSQL, the instance must run one of the following PostgreSQL versions:
        # 
        #     *   **10.0**\
        #     *   **11.0**\
        #     *   **12.0**\
        #     *   **13.0**\
        #     *   **14.0**\
        self.engine_version = engine_version  # type: str
        self.owner_id = owner_id  # type: long
        # The description of the parameter template. The description can be up to 200 characters in length.
        self.parameter_group_desc = parameter_group_desc  # type: str
        # The name of the parameter template.
        # 
        # *   The name can contain letters, digits, periods (.), and underscores (\_) and must start with a letter.
        # *   The name can be 8 to 64 characters in length.
        self.parameter_group_name = parameter_group_name  # type: str
        # A JSON string that consists of parameters and their values in the parameter template. Format: {"Parameter 1":"Value of Parameter 1","Parameter 2":"Value of Parameter 2"...}. For more information about the parameters that can be modified, see [Modify the parameters of an ApsaraDB RDS for MySQL instance](~~96063~~) or [Modify the parameters of an ApsaraDB RDS for PostgreSQL instance](~~96751~~).
        self.parameters = parameters  # type: str
        # The region ID of the parameter template. You can call the [DescribeRegions](~~26243~~) operation to query the most recent region list.
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateParameterGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.engine_version is not None:
            result['EngineVersion'] = self.engine_version
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.parameter_group_desc is not None:
            result['ParameterGroupDesc'] = self.parameter_group_desc
        if self.parameter_group_name is not None:
            result['ParameterGroupName'] = self.parameter_group_name
        if self.parameters is not None:
            result['Parameters'] = self.parameters
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('EngineVersion') is not None:
            self.engine_version = m.get('EngineVersion')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ParameterGroupDesc') is not None:
            self.parameter_group_desc = m.get('ParameterGroupDesc')
        if m.get('ParameterGroupName') is not None:
            self.parameter_group_name = m.get('ParameterGroupName')
        if m.get('Parameters') is not None:
            self.parameters = m.get('Parameters')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class CreateParameterGroupResponseBody(TeaModel):
    def __init__(self, parameter_group_id=None, request_id=None):
        # The ID of the parameter template. You can call the [DescribeParameterGroups](~~144491~~) operation to query the IDs of parameter templates.
        self.parameter_group_id = parameter_group_id  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateParameterGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.parameter_group_id is not None:
            result['ParameterGroupId'] = self.parameter_group_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ParameterGroupId') is not None:
            self.parameter_group_id = m.get('ParameterGroupId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateParameterGroupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateParameterGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateParameterGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateParameterGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateReadOnlyDBInstanceRequest(TeaModel):
    def __init__(self, auto_renew=None, category=None, client_token=None, dbinstance_class=None,
                 dbinstance_description=None, dbinstance_id=None, dbinstance_storage=None, dbinstance_storage_type=None,
                 dedicated_host_group_id=None, deletion_protection=None, engine_version=None, gdn_instance_name=None,
                 instance_network_type=None, instruction_set_arch=None, owner_account=None, owner_id=None, pay_type=None, period=None,
                 private_ip_address=None, region_id=None, resource_group_id=None, resource_owner_account=None, resource_owner_id=None,
                 target_dedicated_host_id_for_master=None, tddl_biz_type=None, tddl_region_config=None, used_time=None, vpcid=None, v_switch_id=None,
                 zone_id=None):
        # Specifies whether to enable auto-renewal for the read-only instance. If you set the PayType parameter to Prepaid, you must also specify this parameter. Valid values:
        # 
        # *   **true**: enables auto-renewal for the read-only instance.
        # *   **false**: disables auto-renewal for the read-only instance.
        # 
        # > *   If you set the Period parameter to Month, the auto-renewal cycle is one month.
        # > *   If you set the Period parameter to Year, the auto-renewal cycle is one year.
        self.auto_renew = auto_renew  # type: str
        # The RDS edition of the read-only instance. Valid values:
        # 
        # *   **Basic**: RDS Basic Edition.
        # *   **HighAvailability**: RDS High-availability Edition. This is the default value.
        # *   **AlwaysOn**: RDS Cluster Edition.
        # 
        # > If the primary instance runs PostgreSQL with standard SSDs or ESSDs, you must set this parameter to **Basic**.
        self.category = category  # type: str
        # The client token that is used to ensure the idempotence of the request. You can use the client to generate the token, but you must make sure that the generated token is unique among different requests. The token can contain only ASCII characters and cannot exceed 64 characters in length.
        self.client_token = client_token  # type: str
        # The instance type of the read-only instance. For more information, see [Read-only ApsaraDB RDS instance types](~~145759~~). We recommend that you specify an instance type whose specifications are higher than or equal to the specifications of the instance type of the primary instance. If the specifications of the read-only instance are lower than the specifications of the primary instance, the read-only instance may encounter issues such as high latency and heavy load.
        self.dbinstance_class = dbinstance_class  # type: str
        # The description of the read-only instance. The description must be 2 to 256 characters in length and can contain letters, digits, underscores (\_), and hyphens (-). The value must start with a letter
        # 
        # > The value cannot start with `http://` or `https://`.
        self.dbinstance_description = dbinstance_description  # type: str
        # The ID of the primary instance.
        self.dbinstance_id = dbinstance_id  # type: str
        # The storage capacity of the read-only instance. For more information, see the **Storage space** column in [Read-only instance types](~~145759~~). This value must be a multiple of 5 GB. Unit: GB.
        self.dbinstance_storage = dbinstance_storage  # type: int
        # The storage type of the read-only instance. Valid values:
        # 
        # *   **local_ssd**: local SSDs
        # *   **cloud_ssd**: standard SSDs
        # *   **cloud_essd**: ESSDs of performance level 1 (PL1)
        # *   **cloud_essd2**: ESSDs of PL2
        # *   **cloud_essd3**: ESSDs of PL3
        # 
        # > *   If the primary instance runs MySQL with local SSDs, you must set this parameter to **local_ssd**. If the primary instance runs MySQL with standard SSDs or ESSDs, you must set this parameter to cloud_ssd, cloud_essd, cloud_essd2, or cloud_essd3.
        # > *   If the primary instance runs SQL Server, you must set this parameter to cloud_ssd, cloud_essd, cloud_essd2, or cloud_essd3.
        self.dbinstance_storage_type = dbinstance_storage_type  # type: str
        # The ID of the dedicated cluster to which the read-only instance belongs. This parameter is valid when you create the read-only instance in a dedicated cluster.
        self.dedicated_host_group_id = dedicated_host_group_id  # type: str
        # Specifies whether to enable the release protection feature for the read-only instance. Valid values:
        # 
        # *   **true**: enables the feature.
        # *   **false**: disables the feature. This is the default value.
        # 
        # > This feature can be enabled only when you set the **PayType** parameter to **Postpaid**.
        self.deletion_protection = deletion_protection  # type: bool
        # The major engine version of the read-only instance. The read-only instance and the primary instance must run the same major engine version.
        # 
        # *   If the read-only instance runs MySQL, set this parameter to **5.6**, **5.7**, or **8.0**.
        # *   If the read-only instance runs SQL Server, set this parameter to **2017\_ent or 2019\_ent**.
        # *   If the read-only instance runs PostgreSQL, set this parameter to **10.0, 11.0, 12.0, 13.0, 14.0, or 15.0**\
        self.engine_version = engine_version  # type: str
        # A reserved parameter.
        self.gdn_instance_name = gdn_instance_name  # type: str
        # The network type of the read-only instance. Valid values:
        # 
        # *   **VPC**\
        # *   **Classic**\
        # 
        # Default value: VPC. If you set this parameter to VPC, you must also specify the **VPCId** and **VSwitchId** parameters.
        # 
        # > The network type of the read-only instance can be different from the network type of the primary instance.
        self.instance_network_type = instance_network_type  # type: str
        # A reserved parameter.
        self.instruction_set_arch = instruction_set_arch  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The billing method of the read-only instance. Valid values:
        # 
        # *   **Postpaid**: pay-as-you-go
        # *   **Prepaid**: subscription
        self.pay_type = pay_type  # type: str
        # The renewal cycle of the read-only instance. Valid values:
        # 
        # *   **Year**\
        # *   **Month**\
        self.period = period  # type: str
        # The private IP address of the read-only instance. The private IP address must be within the CIDR block that is supported by the specified vSwitch. The system assigns a private IP address to the read-only instance based on the values of the **VPCId** and **VSwitchId** parameters.
        self.private_ip_address = private_ip_address  # type: str
        # The region ID of the read-only instance. The read-only instance and the primary instance must reside in the same region. You can call the [DescribeRegions](~~26243~~) operation to query the most recent region list.
        self.region_id = region_id  # type: str
        # The ID of the resource group to which the read-only instance belongs.
        self.resource_group_id = resource_group_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The ID of the host to which the read-only instance belongs. This parameter is valid when you create the read-only instance in a dedicated cluster.
        self.target_dedicated_host_id_for_master = target_dedicated_host_id_for_master  # type: str
        # A reserved parameter.
        self.tddl_biz_type = tddl_biz_type  # type: str
        # A reserved parameter.
        self.tddl_region_config = tddl_region_config  # type: str
        # The subscription duration of the read-only instance. Valid values:
        # 
        # *   If you set the **Period** parameter to **Year**, the value of the **UsedTime** parameter ranges from **1** to **5**.
        # *   If you set the **Period** parameter to **Month**, the value of the **UsedTime** parameter ranges from **1** to **9**.
        # 
        # > If you set the **PayType** parameter to **Prepaid**, you must specify the UsedTime parameter.
        self.used_time = used_time  # type: str
        # The ID of the virtual private cloud (VPC) to which the read-only instance belongs. If you leave the **InstanceNetworkType** parameter empty or set it to **VPC**, you must also specify this parameter.
        # 
        # > *   If the primary instance uses local SSDs, the read-only instance and the primary instance can belong to the same VPC or different VPCs.
        # > *   If the primary instance uses standard SSDs or ESSDs, the read-only instance and the primary instance must belong to the same VPC.
        self.vpcid = vpcid  # type: str
        # The ID of the vSwitch to which the read-only instance belongs. If you leave the **InstanceNetworkType** parameter empty or set it to **VPC**, you must specify the VSwitchId parameter.
        self.v_switch_id = v_switch_id  # type: str
        # The zone ID of the read-only instance. You can call the [DescribeRegions](~~26243~~) operation to query the most recent zone list.
        self.zone_id = zone_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateReadOnlyDBInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_renew is not None:
            result['AutoRenew'] = self.auto_renew
        if self.category is not None:
            result['Category'] = self.category
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dbinstance_class is not None:
            result['DBInstanceClass'] = self.dbinstance_class
        if self.dbinstance_description is not None:
            result['DBInstanceDescription'] = self.dbinstance_description
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dbinstance_storage is not None:
            result['DBInstanceStorage'] = self.dbinstance_storage
        if self.dbinstance_storage_type is not None:
            result['DBInstanceStorageType'] = self.dbinstance_storage_type
        if self.dedicated_host_group_id is not None:
            result['DedicatedHostGroupId'] = self.dedicated_host_group_id
        if self.deletion_protection is not None:
            result['DeletionProtection'] = self.deletion_protection
        if self.engine_version is not None:
            result['EngineVersion'] = self.engine_version
        if self.gdn_instance_name is not None:
            result['GdnInstanceName'] = self.gdn_instance_name
        if self.instance_network_type is not None:
            result['InstanceNetworkType'] = self.instance_network_type
        if self.instruction_set_arch is not None:
            result['InstructionSetArch'] = self.instruction_set_arch
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.pay_type is not None:
            result['PayType'] = self.pay_type
        if self.period is not None:
            result['Period'] = self.period
        if self.private_ip_address is not None:
            result['PrivateIpAddress'] = self.private_ip_address
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.target_dedicated_host_id_for_master is not None:
            result['TargetDedicatedHostIdForMaster'] = self.target_dedicated_host_id_for_master
        if self.tddl_biz_type is not None:
            result['TddlBizType'] = self.tddl_biz_type
        if self.tddl_region_config is not None:
            result['TddlRegionConfig'] = self.tddl_region_config
        if self.used_time is not None:
            result['UsedTime'] = self.used_time
        if self.vpcid is not None:
            result['VPCId'] = self.vpcid
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AutoRenew') is not None:
            self.auto_renew = m.get('AutoRenew')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DBInstanceClass') is not None:
            self.dbinstance_class = m.get('DBInstanceClass')
        if m.get('DBInstanceDescription') is not None:
            self.dbinstance_description = m.get('DBInstanceDescription')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DBInstanceStorage') is not None:
            self.dbinstance_storage = m.get('DBInstanceStorage')
        if m.get('DBInstanceStorageType') is not None:
            self.dbinstance_storage_type = m.get('DBInstanceStorageType')
        if m.get('DedicatedHostGroupId') is not None:
            self.dedicated_host_group_id = m.get('DedicatedHostGroupId')
        if m.get('DeletionProtection') is not None:
            self.deletion_protection = m.get('DeletionProtection')
        if m.get('EngineVersion') is not None:
            self.engine_version = m.get('EngineVersion')
        if m.get('GdnInstanceName') is not None:
            self.gdn_instance_name = m.get('GdnInstanceName')
        if m.get('InstanceNetworkType') is not None:
            self.instance_network_type = m.get('InstanceNetworkType')
        if m.get('InstructionSetArch') is not None:
            self.instruction_set_arch = m.get('InstructionSetArch')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PayType') is not None:
            self.pay_type = m.get('PayType')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('PrivateIpAddress') is not None:
            self.private_ip_address = m.get('PrivateIpAddress')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TargetDedicatedHostIdForMaster') is not None:
            self.target_dedicated_host_id_for_master = m.get('TargetDedicatedHostIdForMaster')
        if m.get('TddlBizType') is not None:
            self.tddl_biz_type = m.get('TddlBizType')
        if m.get('TddlRegionConfig') is not None:
            self.tddl_region_config = m.get('TddlRegionConfig')
        if m.get('UsedTime') is not None:
            self.used_time = m.get('UsedTime')
        if m.get('VPCId') is not None:
            self.vpcid = m.get('VPCId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class CreateReadOnlyDBInstanceResponseBody(TeaModel):
    def __init__(self, connection_string=None, dbinstance_id=None, order_id=None, port=None, request_id=None):
        # The internal endpoint that is used to connect to the read-only instance.
        self.connection_string = connection_string  # type: str
        # The ID of the read-only instance.
        self.dbinstance_id = dbinstance_id  # type: str
        # The ID of the order.
        self.order_id = order_id  # type: str
        # The internal port number that is used to connect to the read-only instance.
        self.port = port  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateReadOnlyDBInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.connection_string is not None:
            result['ConnectionString'] = self.connection_string
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.port is not None:
            result['Port'] = self.port
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConnectionString') is not None:
            self.connection_string = m.get('ConnectionString')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateReadOnlyDBInstanceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateReadOnlyDBInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateReadOnlyDBInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateReadOnlyDBInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSecretRequest(TeaModel):
    def __init__(self, client_token=None, db_instance_id=None, db_names=None, description=None, engine=None,
                 owner_id=None, password=None, region_id=None, resource_group_id=None, resource_owner_account=None,
                 resource_owner_id=None, secret_name=None, username=None):
        # The client token that is used to ensure the idempotence of the request. You can use the client to generate the value, but you must ensure that it is unique among different requests. The token can contain only ASCII characters and cannot exceed 64 characters in length.
        self.client_token = client_token  # type: str
        # The ID of the instance. You can call the [DescribeDBInstances](~~26232~~) operation to query the ID of the instance.
        self.db_instance_id = db_instance_id  # type: str
        # The name of the database.
        self.db_names = db_names  # type: str
        # The description of the credential.
        self.description = description  # type: str
        # The engine of the database.
        # 
        # > Only MySQL is supported.
        self.engine = engine  # type: str
        self.owner_id = owner_id  # type: long
        # The password that is used to access the database.
        self.password = password  # type: str
        # The region ID of the instance. You can call the [DescribeDBInstanceAttribute](~~26231~~) operation to query region ID of the instance.
        self.region_id = region_id  # type: str
        # The ID of the resource group to which the instance belongs. You can call the [DescribeDBInstanceAttribute](~~26231~~) operation to query the ID of the resource group.
        self.resource_group_id = resource_group_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The name of the credential.
        self.secret_name = secret_name  # type: str
        # The username that is used to access the database.
        self.username = username  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateSecretRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.db_instance_id is not None:
            result['DbInstanceId'] = self.db_instance_id
        if self.db_names is not None:
            result['DbNames'] = self.db_names
        if self.description is not None:
            result['Description'] = self.description
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.password is not None:
            result['Password'] = self.password
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.secret_name is not None:
            result['SecretName'] = self.secret_name
        if self.username is not None:
            result['Username'] = self.username
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DbInstanceId') is not None:
            self.db_instance_id = m.get('DbInstanceId')
        if m.get('DbNames') is not None:
            self.db_names = m.get('DbNames')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SecretName') is not None:
            self.secret_name = m.get('SecretName')
        if m.get('Username') is not None:
            self.username = m.get('Username')
        return self


class CreateSecretResponseBody(TeaModel):
    def __init__(self, request_id=None, secret_arn=None, secret_name=None, success=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The ARN of the credential for the created Data API account.
        self.secret_arn = secret_arn  # type: str
        # The name of the credential.
        self.secret_name = secret_name  # type: str
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**: The request was successful.
        # *   **false**: The request failed.
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateSecretResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.secret_arn is not None:
            result['SecretArn'] = self.secret_arn
        if self.secret_name is not None:
            result['SecretName'] = self.secret_name
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SecretArn') is not None:
            self.secret_arn = m.get('SecretArn')
        if m.get('SecretName') is not None:
            self.secret_name = m.get('SecretName')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateSecretResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateSecretResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateSecretResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateSecretResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateServiceLinkedRoleRequest(TeaModel):
    def __init__(self, owner_id=None, region_id=None, resource_owner_account=None, resource_owner_id=None,
                 service_linked_role=None):
        self.owner_id = owner_id  # type: long
        # The ID of the region where the instance resides. You can call the [DescribeRegions](~~26243~~) operation to query the most recent region list.
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The name of the service-linked role.
        # 
        # *   **AliyunServiceRoleForRdsPgsqlOnEcs**: the service-linked role for ApsaraDB RDS for PostgreSQL instances.
        # *   **AliyunServiceRoleForRDSProxyOnEcs**: the service-linked role for the database proxy feature of ApsaraDB RDS instances.
        self.service_linked_role = service_linked_role  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateServiceLinkedRoleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.service_linked_role is not None:
            result['ServiceLinkedRole'] = self.service_linked_role
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ServiceLinkedRole') is not None:
            self.service_linked_role = m.get('ServiceLinkedRole')
        return self


class CreateServiceLinkedRoleResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateServiceLinkedRoleResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateServiceLinkedRoleResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateServiceLinkedRoleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateServiceLinkedRoleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateServiceLinkedRoleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateTempDBInstanceRequest(TeaModel):
    def __init__(self, backup_id=None, dbinstance_id=None, owner_account=None, owner_id=None,
                 resource_group_id=None, resource_owner_account=None, resource_owner_id=None, restore_time=None):
        # The ID of the backup file.
        # 
        # >  You must specify the **BackupId** or **RestoreTime** parameter.
        self.backup_id = backup_id  # type: int
        # The ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The ID of the resource group.
        self.resource_group_id = resource_group_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The specified point in time within the backup retention period. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time must be in UTC.
        # 
        # > * The time can be set to a point in time within the past seven days and must be more than 30 minutes earlier than the current time. The default time zone is UTC.
        # > * You must specify the **BackupId** or **RestoreTime** parameter.
        self.restore_time = restore_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateTempDBInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_id is not None:
            result['BackupId'] = self.backup_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.restore_time is not None:
            result['RestoreTime'] = self.restore_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BackupId') is not None:
            self.backup_id = m.get('BackupId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RestoreTime') is not None:
            self.restore_time = m.get('RestoreTime')
        return self


class CreateTempDBInstanceResponseBody(TeaModel):
    def __init__(self, request_id=None, temp_dbinstance_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The ID of the temporary instance.
        self.temp_dbinstance_id = temp_dbinstance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateTempDBInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.temp_dbinstance_id is not None:
            result['TempDBInstanceId'] = self.temp_dbinstance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TempDBInstanceId') is not None:
            self.temp_dbinstance_id = m.get('TempDBInstanceId')
        return self


class CreateTempDBInstanceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateTempDBInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateTempDBInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateTempDBInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteADSettingRequest(TeaModel):
    def __init__(self, client_token=None, dbinstance_id=None, owner_id=None, region_id=None,
                 resource_owner_account=None, resource_owner_id=None):
        # The client token that is used to ensure the idempotence of the request. You can use the client to generate the value, but you must make sure that the generated token is unique among different requests. The token can only contain ASCII characters and cannot exceed 64 characters in length.
        self.client_token = client_token  # type: str
        # The ID of the instance. You can call the [DescribeDBInstances](~~26232~~) operation to query the instance ID.
        self.dbinstance_id = dbinstance_id  # type: str
        self.owner_id = owner_id  # type: long
        # The region ID of the instance.
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteADSettingRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteADSettingResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteADSettingResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteADSettingResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteADSettingResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteADSettingResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteADSettingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteAccountRequest(TeaModel):
    def __init__(self, account_name=None, dbinstance_id=None, owner_account=None, owner_id=None,
                 resource_owner_account=None, resource_owner_id=None):
        # The name of the account.
        self.account_name = account_name  # type: str
        # The ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteAccountRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteAccountResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteAccountResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteAccountResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteAccountResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteAccountResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteAccountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteBackupRequest(TeaModel):
    def __init__(self, backup_id=None, dbinstance_id=None, owner_account=None, owner_id=None,
                 resource_owner_account=None, resource_owner_id=None):
        # The ID of the backup set. You can call the [DescribeBackups](~~26273~~) operation to query backup set IDs. Separate multiple values with commas (,). You can specify a maximum of 100 values in a single request.
        # 
        # > After you call the [DescribeBackups](~~26273~~) operation, the returned backup sets whose **StoreStatus** is **Enabled** can be deleted.
        self.backup_id = backup_id  # type: str
        # The ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteBackupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_id is not None:
            result['BackupId'] = self.backup_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BackupId') is not None:
            self.backup_id = m.get('BackupId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteBackupResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteBackupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteBackupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteBackupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteBackupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteBackupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteBackupFileRequest(TeaModel):
    def __init__(self, backup_id=None, backup_time=None, dbinstance_id=None, dbname=None, owner_id=None,
                 region_id=None, resource_owner_account=None, resource_owner_id=None):
        # The ID of the backup set. You can specify the IDs of up to 100 backup files at a time. Separate the IDs with commas (,).
        # 
        # > * Only the IDs of the backup files for the database is supported.
        # > * You can call the [DescribeBackups](~~26273~~) operation to query the IDs of backup files.
        self.backup_id = backup_id  # type: str
        # Specifies whether to delete the backup files that are generated before the specified point in time. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        self.backup_time = backup_time  # type: str
        # The ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        # The name of the database.
        self.dbname = dbname  # type: str
        self.owner_id = owner_id  # type: long
        # The region ID of the instance. You can call the [DescribeRegions](~~26243~~) operation to query the most recent region list.
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteBackupFileRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_id is not None:
            result['BackupId'] = self.backup_id
        if self.backup_time is not None:
            result['BackupTime'] = self.backup_time
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dbname is not None:
            result['DBName'] = self.dbname
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BackupId') is not None:
            self.backup_id = m.get('BackupId')
        if m.get('BackupTime') is not None:
            self.backup_time = m.get('BackupTime')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DBName') is not None:
            self.dbname = m.get('DBName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteBackupFileResponseBodyDeletedBaksetIds(TeaModel):
    def __init__(self, deleted_bakset_ids=None):
        self.deleted_bakset_ids = deleted_bakset_ids  # type: list[int]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteBackupFileResponseBodyDeletedBaksetIds, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.deleted_bakset_ids is not None:
            result['DeletedBaksetIds'] = self.deleted_bakset_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeletedBaksetIds') is not None:
            self.deleted_bakset_ids = m.get('DeletedBaksetIds')
        return self


class DeleteBackupFileResponseBody(TeaModel):
    def __init__(self, deleted_bakset_ids=None, request_id=None):
        # An array that consists of the IDs of deleted backup files.
        self.deleted_bakset_ids = deleted_bakset_ids  # type: DeleteBackupFileResponseBodyDeletedBaksetIds
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.deleted_bakset_ids:
            self.deleted_bakset_ids.validate()

    def to_map(self):
        _map = super(DeleteBackupFileResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.deleted_bakset_ids is not None:
            result['DeletedBaksetIds'] = self.deleted_bakset_ids.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeletedBaksetIds') is not None:
            temp_model = DeleteBackupFileResponseBodyDeletedBaksetIds()
            self.deleted_bakset_ids = temp_model.from_map(m['DeletedBaksetIds'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteBackupFileResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteBackupFileResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteBackupFileResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteBackupFileResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDBInstanceRequest(TeaModel):
    def __init__(self, dbinstance_id=None, owner_account=None, owner_id=None, released_keep_policy=None,
                 resource_owner_account=None, resource_owner_id=None):
        # The ID of the instance. You can call the [DescribeDBInstances](~~26232~~) operation to query the ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The policy that is used to retain archived backup files if the instance is released Valid values:
        # 
        # *   **None**: No archived backup files are retained.
        # *   **Lastest**: Only the last archived backup file is retained.
        # *   **All**: All archived backup files are retained.
        # 
        # > This parameter is supported only when the instance runs MySQL and uses local SSDs.
        self.released_keep_policy = released_keep_policy  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDBInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.released_keep_policy is not None:
            result['ReleasedKeepPolicy'] = self.released_keep_policy
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ReleasedKeepPolicy') is not None:
            self.released_keep_policy = m.get('ReleasedKeepPolicy')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteDBInstanceResponseBody(TeaModel):
    def __init__(self, region_id=None, request_id=None):
        # The region ID of the instance.
        self.region_id = region_id  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDBInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDBInstanceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteDBInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteDBInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDBInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDBInstanceEndpointRequest(TeaModel):
    def __init__(self, client_token=None, dbinstance_endpoint_id=None, dbinstance_id=None, resource_owner_id=None):
        # The client token that is used to ensure the idempotence of the request. You can use the client to generate the value, but you must make sure that it is unique among different requests.
        # 
        # The token can only contain ASCII characters and cannot exceed 64 characters in length.
        self.client_token = client_token  # type: str
        # The endpoint ID of the instance. You can call the [DescribeDBInstanceEndpoints](~~464397~~) operation to query the endpoint ID of the instance.
        self.dbinstance_endpoint_id = dbinstance_endpoint_id  # type: str
        # The ID of the instance. You can call the [DescribeDBInstances](~~26232~~) operation to query the ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDBInstanceEndpointRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dbinstance_endpoint_id is not None:
            result['DBInstanceEndpointId'] = self.dbinstance_endpoint_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DBInstanceEndpointId') is not None:
            self.dbinstance_endpoint_id = m.get('DBInstanceEndpointId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteDBInstanceEndpointResponseBodyData(TeaModel):
    def __init__(self, dbinstance_endpoint_id=None, dbinstance_name=None):
        # The endpoint ID of the instance.
        self.dbinstance_endpoint_id = dbinstance_endpoint_id  # type: str
        # The ID of the instance.
        self.dbinstance_name = dbinstance_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDBInstanceEndpointResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_endpoint_id is not None:
            result['DBInstanceEndpointId'] = self.dbinstance_endpoint_id
        if self.dbinstance_name is not None:
            result['DBInstanceName'] = self.dbinstance_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DBInstanceEndpointId') is not None:
            self.dbinstance_endpoint_id = m.get('DBInstanceEndpointId')
        if m.get('DBInstanceName') is not None:
            self.dbinstance_name = m.get('DBInstanceName')
        return self


class DeleteDBInstanceEndpointResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        # The returned data.
        self.data = data  # type: DeleteDBInstanceEndpointResponseBodyData
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(DeleteDBInstanceEndpointResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = DeleteDBInstanceEndpointResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDBInstanceEndpointResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteDBInstanceEndpointResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteDBInstanceEndpointResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDBInstanceEndpointResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDBInstanceEndpointAddressRequest(TeaModel):
    def __init__(self, client_token=None, connection_string=None, dbinstance_endpoint_id=None, dbinstance_id=None,
                 resource_owner_id=None):
        # The client token that is used to ensure the idempotence of the request. You can use the client to generate the value, but you must make sure that it is unique among different requests.
        # 
        # The token can only contain ASCII characters and cannot exceed 64 characters in length.
        self.client_token = client_token  # type: str
        # The public endpoint.
        self.connection_string = connection_string  # type: str
        # The endpoint ID of the instance. You can call the [DescribeDBInstanceEndpoints](~~464397~~) operation to query the endpoint ID of the instance.
        self.dbinstance_endpoint_id = dbinstance_endpoint_id  # type: str
        # The ID of the instance. You can call the [DescribeDBInstances](~~26232~~) operation to query the ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDBInstanceEndpointAddressRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.connection_string is not None:
            result['ConnectionString'] = self.connection_string
        if self.dbinstance_endpoint_id is not None:
            result['DBInstanceEndpointId'] = self.dbinstance_endpoint_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('ConnectionString') is not None:
            self.connection_string = m.get('ConnectionString')
        if m.get('DBInstanceEndpointId') is not None:
            self.dbinstance_endpoint_id = m.get('DBInstanceEndpointId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteDBInstanceEndpointAddressResponseBodyData(TeaModel):
    def __init__(self, dbinstance_endpoint_id=None, dbinstance_name=None):
        # The endpoint ID of the instance.
        self.dbinstance_endpoint_id = dbinstance_endpoint_id  # type: str
        # The ID of the instance.
        self.dbinstance_name = dbinstance_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDBInstanceEndpointAddressResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_endpoint_id is not None:
            result['DBInstanceEndpointId'] = self.dbinstance_endpoint_id
        if self.dbinstance_name is not None:
            result['DBInstanceName'] = self.dbinstance_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DBInstanceEndpointId') is not None:
            self.dbinstance_endpoint_id = m.get('DBInstanceEndpointId')
        if m.get('DBInstanceName') is not None:
            self.dbinstance_name = m.get('DBInstanceName')
        return self


class DeleteDBInstanceEndpointAddressResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        # The returned data.
        self.data = data  # type: DeleteDBInstanceEndpointAddressResponseBodyData
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(DeleteDBInstanceEndpointAddressResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = DeleteDBInstanceEndpointAddressResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDBInstanceEndpointAddressResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteDBInstanceEndpointAddressResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteDBInstanceEndpointAddressResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDBInstanceEndpointAddressResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDBNodesRequest(TeaModel):
    def __init__(self, client_token=None, dbinstance_id=None, dbnode_id=None, owner_account=None, owner_id=None,
                 resource_owner_account=None, resource_owner_id=None):
        # The client token that is used to ensure the idempotence of the request. You can use the client to generate the value, but you must make sure that it is unique among different requests.
        # 
        # The token can only contain ASCII characters and cannot exceed 64 characters in length.
        self.client_token = client_token  # type: str
        # The ID of the instance. You can call the [DescribeDBInstances](~~26232~~) operation to query the ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        # An array that consists of information about the ID of the node.
        self.dbnode_id = dbnode_id  # type: list[str]
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDBNodesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dbnode_id is not None:
            result['DBNodeId'] = self.dbnode_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DBNodeId') is not None:
            self.dbnode_id = m.get('DBNodeId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteDBNodesShrinkRequest(TeaModel):
    def __init__(self, client_token=None, dbinstance_id=None, dbnode_id_shrink=None, owner_account=None,
                 owner_id=None, resource_owner_account=None, resource_owner_id=None):
        # The client token that is used to ensure the idempotence of the request. You can use the client to generate the value, but you must make sure that it is unique among different requests.
        # 
        # The token can only contain ASCII characters and cannot exceed 64 characters in length.
        self.client_token = client_token  # type: str
        # The ID of the instance. You can call the [DescribeDBInstances](~~26232~~) operation to query the ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        # An array that consists of information about the ID of the node.
        self.dbnode_id_shrink = dbnode_id_shrink  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDBNodesShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dbnode_id_shrink is not None:
            result['DBNodeId'] = self.dbnode_id_shrink
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DBNodeId') is not None:
            self.dbnode_id_shrink = m.get('DBNodeId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteDBNodesResponseBody(TeaModel):
    def __init__(self, dbinstance_id=None, order_id=None, request_id=None):
        # The ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        # The ID of the order.
        self.order_id = order_id  # type: long
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDBNodesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDBNodesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteDBNodesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteDBNodesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDBNodesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDBProxyEndpointAddressRequest(TeaModel):
    def __init__(self, dbinstance_id=None, dbproxy_connect_string_net_type=None, dbproxy_endpoint_id=None,
                 dbproxy_engine_type=None, region_id=None):
        # The ID of the instance. You can call the [DescribeDBInstances](~~26232~~) operation to query the ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        # The network type of the proxy endpoint. Valid values:
        # 
        # *   **Public**: Internet
        # *   **VPC**: virtual private cloud (VPC)
        # *   **Classic**: classic network
        # 
        # Default value: **Classic**.
        # 
        # > 
        # 
        # *   If the instance uses standard SSDs or enhanced SSDs (ESSDs) and the network type of the proxy endpoint is VPC, you cannot delete the proxy endpoint.
        # 
        # *   If the instance runs PostgreSQL, you can set this parameter to **Public** or **VPC**.
        self.dbproxy_connect_string_net_type = dbproxy_connect_string_net_type  # type: str
        # The ID of the proxy endpoint. You can call the [DescribeDBProxyEndpoint](~~140955~~) operation to query the ID of the proxy endpoint.
        self.dbproxy_endpoint_id = dbproxy_endpoint_id  # type: str
        # An internal parameter. You do not need to specify this parameter.
        self.dbproxy_engine_type = dbproxy_engine_type  # type: str
        # The region ID of the instance. You can call the [DescribeRegions](~~26243~~) operation to query most recent region list.
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDBProxyEndpointAddressRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dbproxy_connect_string_net_type is not None:
            result['DBProxyConnectStringNetType'] = self.dbproxy_connect_string_net_type
        if self.dbproxy_endpoint_id is not None:
            result['DBProxyEndpointId'] = self.dbproxy_endpoint_id
        if self.dbproxy_engine_type is not None:
            result['DBProxyEngineType'] = self.dbproxy_engine_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DBProxyConnectStringNetType') is not None:
            self.dbproxy_connect_string_net_type = m.get('DBProxyConnectStringNetType')
        if m.get('DBProxyEndpointId') is not None:
            self.dbproxy_endpoint_id = m.get('DBProxyEndpointId')
        if m.get('DBProxyEngineType') is not None:
            self.dbproxy_engine_type = m.get('DBProxyEngineType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteDBProxyEndpointAddressResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDBProxyEndpointAddressResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDBProxyEndpointAddressResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteDBProxyEndpointAddressResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteDBProxyEndpointAddressResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDBProxyEndpointAddressResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDatabaseRequest(TeaModel):
    def __init__(self, dbinstance_id=None, dbname=None, resource_owner_id=None):
        # The ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        # The name of the database.
        self.dbname = dbname  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDatabaseRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dbname is not None:
            result['DBName'] = self.dbname
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DBName') is not None:
            self.dbname = m.get('DBName')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteDatabaseResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDatabaseResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDatabaseResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteDatabaseResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteDatabaseResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDatabaseResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteGadInstanceRequest(TeaModel):
    def __init__(self, gad_instance_name=None, region_id=None):
        # The ID of the global active database cluster. You can call the [DescribeGadInstances](~~330105~~) operation to query the IDs of global active database clusters.
        self.gad_instance_name = gad_instance_name  # type: str
        # The region ID of the central node of the global active database cluster. You can call the [DescribeGadInstances](~~330105~~) operation to query the region IDs of global active database clusters.
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteGadInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gad_instance_name is not None:
            result['GadInstanceName'] = self.gad_instance_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GadInstanceName') is not None:
            self.gad_instance_name = m.get('GadInstanceName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteGadInstanceResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteGadInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteGadInstanceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteGadInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteGadInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteGadInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteParameterGroupRequest(TeaModel):
    def __init__(self, owner_id=None, parameter_group_id=None, region_id=None, resource_owner_account=None,
                 resource_owner_id=None):
        self.owner_id = owner_id  # type: long
        # The ID of the parameter template. You can call the [DescribeParameterGroups](~~144491~~) operation to query the ID of the parameter template.
        self.parameter_group_id = parameter_group_id  # type: str
        # The region ID of the instance. You can call the [DescribeRegions](~~26243~~) operation to query the most recent region list.
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteParameterGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.parameter_group_id is not None:
            result['ParameterGroupId'] = self.parameter_group_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ParameterGroupId') is not None:
            self.parameter_group_id = m.get('ParameterGroupId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteParameterGroupResponseBody(TeaModel):
    def __init__(self, parameter_group_id=None, request_id=None):
        # The ID of the parameter template.
        self.parameter_group_id = parameter_group_id  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteParameterGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.parameter_group_id is not None:
            result['ParameterGroupId'] = self.parameter_group_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ParameterGroupId') is not None:
            self.parameter_group_id = m.get('ParameterGroupId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteParameterGroupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteParameterGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteParameterGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteParameterGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSecretRequest(TeaModel):
    def __init__(self, client_token=None, db_instance_id=None, engine=None, owner_id=None, region_id=None,
                 resource_owner_account=None, resource_owner_id=None, secret_arn=None, secret_name=None):
        # The client token that is used to ensure the idempotence of the request. You can use the client to generate the value, but you must ensure that it is unique among different requests. The token can only contain ASCII characters and cannot exceed 64 characters in length.
        self.client_token = client_token  # type: str
        # The ID of the instance. You can call the [DescribeDBInstances](~~26232~~) operation to query the ID of the instance.
        # 
        # > If you specify this parameter, you must also specify the **SecretName** parameter.
        self.db_instance_id = db_instance_id  # type: str
        # The engine of the database.
        # 
        # > Only MySQL is supported.
        self.engine = engine  # type: str
        self.owner_id = owner_id  # type: long
        # The region ID of the instance. You can call the [DescribeRegions](~~446624~~) operation to query the most recent region list.
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The ARN of the credential for the created Data API account. You can call the [CreateSecret](~~446607~~) operation to obtain the value of this parameter.
        # 
        # > You must specify one of the **SecretName** and SecretArn parameters.
        self.secret_arn = secret_arn  # type: str
        # The name of the credential.
        # 
        # > 
        # 
        # *   You must specify one of the **SecretArn** and SecretName parameters.
        # 
        # *   If you specify this parameter, you must also specify the **DbInstanceId** parameter.
        self.secret_name = secret_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteSecretRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.db_instance_id is not None:
            result['DbInstanceId'] = self.db_instance_id
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.secret_arn is not None:
            result['SecretArn'] = self.secret_arn
        if self.secret_name is not None:
            result['SecretName'] = self.secret_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DbInstanceId') is not None:
            self.db_instance_id = m.get('DbInstanceId')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SecretArn') is not None:
            self.secret_arn = m.get('SecretArn')
        if m.get('SecretName') is not None:
            self.secret_name = m.get('SecretName')
        return self


class DeleteSecretResponseBody(TeaModel):
    def __init__(self, request_id=None, secret_arn=None, secret_name=None, success=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The ARN of the credential for the Data API account.
        self.secret_arn = secret_arn  # type: str
        # The name of the credential.
        self.secret_name = secret_name  # type: str
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**: The request was successful.
        # *   **false**: The request failed.
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteSecretResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.secret_arn is not None:
            result['SecretArn'] = self.secret_arn
        if self.secret_name is not None:
            result['SecretName'] = self.secret_name
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SecretArn') is not None:
            self.secret_arn = m.get('SecretArn')
        if m.get('SecretName') is not None:
            self.secret_name = m.get('SecretName')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteSecretResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteSecretResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteSecretResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteSecretResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteUserBackupFileRequest(TeaModel):
    def __init__(self, backup_id=None, owner_id=None, region_id=None, resource_owner_account=None,
                 resource_owner_id=None):
        # The ID of the full backup file. You can call the [ListUserBackupFiles](~~257821~~) operation to query the information about all full backup files in the region.
        self.backup_id = backup_id  # type: str
        self.owner_id = owner_id  # type: long
        # The region ID of the full backup file. You can call the [DescribeRegions](~~26243~~) operation to query the most recent region list.
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteUserBackupFileRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_id is not None:
            result['BackupId'] = self.backup_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BackupId') is not None:
            self.backup_id = m.get('BackupId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteUserBackupFileResponseBody(TeaModel):
    def __init__(self, backup_id=None, request_id=None):
        # The ID of the deleted full backup file.
        self.backup_id = backup_id  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteUserBackupFileResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_id is not None:
            result['BackupId'] = self.backup_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BackupId') is not None:
            self.backup_id = m.get('BackupId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteUserBackupFileResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteUserBackupFileResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteUserBackupFileResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteUserBackupFileResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescibeImportsFromDatabaseRequest(TeaModel):
    def __init__(self, client_token=None, dbinstance_id=None, end_time=None, engine=None, import_id=None,
                 owner_account=None, owner_id=None, page_number=None, page_size=None, resource_owner_account=None,
                 resource_owner_id=None, start_time=None):
        # The client token that is used to ensure the idempotence of the request. You can use the client to generate the value, but you must ensure that it is unique among different requests. The token can only contain ASCII characters and cannot exceed 64 characters in length.
        self.client_token = client_token  # type: str
        # The ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        # The end of the time range to query. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm*Z format. The time must be in UTC.
        self.end_time = end_time  # type: str
        # The database engine of the instance. Valid values:
        # 
        # *   **MySQL**\
        # *   **SQL Server**\
        self.engine = engine  # type: str
        # The ID of the migration task.
        self.import_id = import_id  # type: int
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The number of the page to return. Valid values: any non-zero positive integer.
        # 
        # Default value: **1**.
        self.page_number = page_number  # type: int
        # The number of entries to return on each page. Valid values:
        # 
        # *   **30**\
        # *   **50**\
        # *   **100**\
        # 
        # Default value: **30**.
        self.page_size = page_size  # type: int
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The beginning of the time range to query. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm*Z format. The time must be in UTC.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescibeImportsFromDatabaseRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.import_id is not None:
            result['ImportId'] = self.import_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('ImportId') is not None:
            self.import_id = m.get('ImportId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescibeImportsFromDatabaseResponseBodyItemsImportResultFromDB(TeaModel):
    def __init__(self, import_data_status=None, import_data_status_description=None, import_data_type=None,
                 import_id=None, incremental_importing_time=None):
        # The status of the migration task. Valid values:
        # 
        # *   **NotStart**: The migration task has not started.
        # *   **FullExporting**: The migration task is exporting full data.
        # *   **FullImporting**: The migration task is importing full data.
        # *   **Success**: The migration task is successful.
        # *   **Failed**: The migration task fails.
        # *   **Canceled**: The migration task is canceled.
        # *   **Canceling**: The migration task is being canceled.
        # *   **IncrementalWaiting**: The migration task is waiting to synchronize incremental data.
        # *   **IncrementalImporting**: The migration task is synchronizing incremental data.
        # *   **StopSyncing**: The migration task stops synchronizing data.
        self.import_data_status = import_data_status  # type: str
        # The description of the migration task.
        self.import_data_status_description = import_data_status_description  # type: str
        # The type of the migration task. Valid values:
        # 
        # *   **Full**: full migration
        # *   **Incremental:**: incremental migration
        self.import_data_type = import_data_type  # type: str
        # The ID of the migration task.
        self.import_id = import_id  # type: int
        # The time when the migration task synchronized incremental data. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.incremental_importing_time = incremental_importing_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescibeImportsFromDatabaseResponseBodyItemsImportResultFromDB, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.import_data_status is not None:
            result['ImportDataStatus'] = self.import_data_status
        if self.import_data_status_description is not None:
            result['ImportDataStatusDescription'] = self.import_data_status_description
        if self.import_data_type is not None:
            result['ImportDataType'] = self.import_data_type
        if self.import_id is not None:
            result['ImportId'] = self.import_id
        if self.incremental_importing_time is not None:
            result['IncrementalImportingTime'] = self.incremental_importing_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ImportDataStatus') is not None:
            self.import_data_status = m.get('ImportDataStatus')
        if m.get('ImportDataStatusDescription') is not None:
            self.import_data_status_description = m.get('ImportDataStatusDescription')
        if m.get('ImportDataType') is not None:
            self.import_data_type = m.get('ImportDataType')
        if m.get('ImportId') is not None:
            self.import_id = m.get('ImportId')
        if m.get('IncrementalImportingTime') is not None:
            self.incremental_importing_time = m.get('IncrementalImportingTime')
        return self


class DescibeImportsFromDatabaseResponseBodyItems(TeaModel):
    def __init__(self, import_result_from_db=None):
        self.import_result_from_db = import_result_from_db  # type: list[DescibeImportsFromDatabaseResponseBodyItemsImportResultFromDB]

    def validate(self):
        if self.import_result_from_db:
            for k in self.import_result_from_db:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescibeImportsFromDatabaseResponseBodyItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ImportResultFromDB'] = []
        if self.import_result_from_db is not None:
            for k in self.import_result_from_db:
                result['ImportResultFromDB'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.import_result_from_db = []
        if m.get('ImportResultFromDB') is not None:
            for k in m.get('ImportResultFromDB'):
                temp_model = DescibeImportsFromDatabaseResponseBodyItemsImportResultFromDB()
                self.import_result_from_db.append(temp_model.from_map(k))
        return self


class DescibeImportsFromDatabaseResponseBody(TeaModel):
    def __init__(self, items=None, page_number=None, page_record_count=None, request_id=None,
                 total_record_count=None):
        # An array that consists of migration tasks.
        self.items = items  # type: DescibeImportsFromDatabaseResponseBodyItems
        # The page number of the returned page.
        self.page_number = page_number  # type: int
        # The number of entries returned per page.
        self.page_record_count = page_record_count  # type: int
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The total number of entries returned.
        self.total_record_count = total_record_count  # type: int

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super(DescibeImportsFromDatabaseResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.items is not None:
            result['Items'] = self.items.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_record_count is not None:
            result['PageRecordCount'] = self.page_record_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_record_count is not None:
            result['TotalRecordCount'] = self.total_record_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Items') is not None:
            temp_model = DescibeImportsFromDatabaseResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageRecordCount') is not None:
            self.page_record_count = m.get('PageRecordCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalRecordCount') is not None:
            self.total_record_count = m.get('TotalRecordCount')
        return self


class DescibeImportsFromDatabaseResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescibeImportsFromDatabaseResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescibeImportsFromDatabaseResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescibeImportsFromDatabaseResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeADInfoRequest(TeaModel):
    def __init__(self, client_token=None, dbinstance_id=None, owner_id=None, region_id=None,
                 resource_owner_account=None, resource_owner_id=None):
        # The client token that is used to ensure the idempotence of the request. You can use the client to generate the value, but you must ensure that it is unique among different requests. The token can only contain ASCII characters and cannot exceed 64 characters in length.
        self.client_token = client_token  # type: str
        # The ID of the instance. You can call the [DescribeDBInstances](~~26232~~) operation to query the ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        self.owner_id = owner_id  # type: long
        # The ID of the region.
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeADInfoRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeADInfoResponseBody(TeaModel):
    def __init__(self, addns=None, adserver_ip_address=None, adstatus=None, abnormal_reason=None, request_id=None,
                 user_name=None):
        # The DNS information about the AD domain.
        self.addns = addns  # type: str
        # The service IP address of the AD domain.
        self.adserver_ip_address = adserver_ip_address  # type: str
        # The status of the AD domain. Valid values:
        # 
        # *   **-1**: The instance is being added to the AD domain.
        # *   **0**: The instance fails to be added to the AD domain.
        # *   **1**: The instance is added to the AD domain.
        self.adstatus = adstatus  # type: str
        # The cause of the exception.
        self.abnormal_reason = abnormal_reason  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The username of the AD domain.
        self.user_name = user_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeADInfoResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.addns is not None:
            result['ADDNS'] = self.addns
        if self.adserver_ip_address is not None:
            result['ADServerIpAddress'] = self.adserver_ip_address
        if self.adstatus is not None:
            result['ADStatus'] = self.adstatus
        if self.abnormal_reason is not None:
            result['AbnormalReason'] = self.abnormal_reason
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.user_name is not None:
            result['UserName'] = self.user_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ADDNS') is not None:
            self.addns = m.get('ADDNS')
        if m.get('ADServerIpAddress') is not None:
            self.adserver_ip_address = m.get('ADServerIpAddress')
        if m.get('ADStatus') is not None:
            self.adstatus = m.get('ADStatus')
        if m.get('AbnormalReason') is not None:
            self.abnormal_reason = m.get('AbnormalReason')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        return self


class DescribeADInfoResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeADInfoResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeADInfoResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeADInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAccountsRequest(TeaModel):
    def __init__(self, account_name=None, dbinstance_id=None, page_number=None, page_size=None,
                 resource_owner_account=None, resource_owner_id=None):
        # The name of the account.
        self.account_name = account_name  # type: str
        # The ID of the instance.
        # 
        # >  This operation is not supported for instances that run SQL Server 2017 (cluster edition).
        self.dbinstance_id = dbinstance_id  # type: str
        # The number of the page to return. Default value: **1**. Valid values: any non-zero positive integer.
        self.page_number = page_number  # type: int
        # The number of entries to return on each page. Valid value: **30 to 200**. Default value: **30**.
        self.page_size = page_size  # type: int
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAccountsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeAccountsResponseBodyAccountsDBInstanceAccountDatabasePrivilegesDatabasePrivilege(TeaModel):
    def __init__(self, account_privilege=None, account_privilege_detail=None, dbname=None):
        # The type of the permissions. Valid values:
        # 
        # *   **ReadWrite**: read and write permissions
        # *   **ReadOnly**: read-only permissions
        # *   **DDLOnly**: DDL-only permissions
        # *   **DMLOnly**: DML-only permissions
        # *   **Custom**: custom permissions (which can be modified by using SQL statements)
        self.account_privilege = account_privilege  # type: str
        # The permissions that are granted to the account. For more information, see [Account permissions](~~146395~~).
        self.account_privilege_detail = account_privilege_detail  # type: str
        # The name of the database.
        self.dbname = dbname  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAccountsResponseBodyAccountsDBInstanceAccountDatabasePrivilegesDatabasePrivilege, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_privilege is not None:
            result['AccountPrivilege'] = self.account_privilege
        if self.account_privilege_detail is not None:
            result['AccountPrivilegeDetail'] = self.account_privilege_detail
        if self.dbname is not None:
            result['DBName'] = self.dbname
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountPrivilege') is not None:
            self.account_privilege = m.get('AccountPrivilege')
        if m.get('AccountPrivilegeDetail') is not None:
            self.account_privilege_detail = m.get('AccountPrivilegeDetail')
        if m.get('DBName') is not None:
            self.dbname = m.get('DBName')
        return self


class DescribeAccountsResponseBodyAccountsDBInstanceAccountDatabasePrivileges(TeaModel):
    def __init__(self, database_privilege=None):
        self.database_privilege = database_privilege  # type: list[DescribeAccountsResponseBodyAccountsDBInstanceAccountDatabasePrivilegesDatabasePrivilege]

    def validate(self):
        if self.database_privilege:
            for k in self.database_privilege:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAccountsResponseBodyAccountsDBInstanceAccountDatabasePrivileges, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DatabasePrivilege'] = []
        if self.database_privilege is not None:
            for k in self.database_privilege:
                result['DatabasePrivilege'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.database_privilege = []
        if m.get('DatabasePrivilege') is not None:
            for k in m.get('DatabasePrivilege'):
                temp_model = DescribeAccountsResponseBodyAccountsDBInstanceAccountDatabasePrivilegesDatabasePrivilege()
                self.database_privilege.append(temp_model.from_map(k))
        return self


class DescribeAccountsResponseBodyAccountsDBInstanceAccount(TeaModel):
    def __init__(self, account_description=None, account_name=None, account_status=None, account_type=None,
                 bypass_rls=None, create_db=None, create_role=None, dbinstance_id=None, database_privileges=None,
                 priv_exceeded=None, replication=None, valid_until=None):
        # The description of the account.
        self.account_description = account_description  # type: str
        # The name of the account.
        self.account_name = account_name  # type: str
        # The state of the account. Valid values:
        # 
        # *   **Unavailable**\
        # *   **Available**\
        self.account_status = account_status  # type: str
        # The type of the account. Valid values:
        # 
        # *   **Normal**: standard account
        # *   **Super**: privileged account
        # *   **Sysadmin**: superuser account that has the system administrator permissions
        self.account_type = account_type  # type: str
        # Indicates whether the account has the row-level security (RLS) permissions. Valid values: 
        # 
        # - **t**: The account has the RLS permissions.
        # - **f**: The account does not have the RLS permissions.
        # 
        # >  This parameter is returned only for ApsaraDB RDS for PostgreSQL instances.
        self.bypass_rls = bypass_rls  # type: str
        # Indicates whether the account has the permissions to create databases. Valid values:
        # 
        # - **t**: The account has the permissions to create databases.
        # - **f**: The account does not have the permissions to create databases.
        # 
        # >  This parameter is returned only for ApsaraDB RDS for PostgreSQL instances.
        self.create_db = create_db  # type: str
        # Indicates whether the account has the permissions to create roles. Valid values:
        # 
        # - **t**: The account has the permissions to create roles.
        # - **f**: The account does not have the permissions to create roles.
        # 
        # >  This parameter is returned only for ApsaraDB RDS for PostgreSQL instances.
        self.create_role = create_role  # type: str
        # The ID of the instance to which the account belongs.
        self.dbinstance_id = dbinstance_id  # type: str
        # Details of the permissions that are granted to the account.
        self.database_privileges = database_privileges  # type: DescribeAccountsResponseBodyAccountsDBInstanceAccountDatabasePrivileges
        # Indicates whether the number of databases that are managed by the account exceeds the upper limit. Valid values:
        # 
        # *   **1**: The number of databases that are managed by the account exceeds the upper limit.
        # *   **0**: The number of databases that are managed by the account does not exceed the upper limit.
        self.priv_exceeded = priv_exceeded  # type: str
        # Indicates whether the account has the replication permissions. Valid values:
        # 
        # - **t**: The account has the replication permissions.
        # - **f**: The account does not have the replication permissions.
        # 
        # >  This parameter is returned only for ApsaraDB RDS for PostgreSQL instances.
        self.replication = replication  # type: str
        # The expiration time of the password. Valid values:
        # 
        # - **infinity**: The password never expires.
        # - **Empty**: The expiration time is not specified.
        # - **Actual expiration time** in the format of *yyyy-MM-dd*T*HH:mm:ss*Z in UTC. Example: 2022-10-01T00:00:00Z.
        # 
        # >  This parameter is returned only for ApsaraDB RDS for PostgreSQL instances.
        self.valid_until = valid_until  # type: str

    def validate(self):
        if self.database_privileges:
            self.database_privileges.validate()

    def to_map(self):
        _map = super(DescribeAccountsResponseBodyAccountsDBInstanceAccount, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_description is not None:
            result['AccountDescription'] = self.account_description
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.account_status is not None:
            result['AccountStatus'] = self.account_status
        if self.account_type is not None:
            result['AccountType'] = self.account_type
        if self.bypass_rls is not None:
            result['BypassRLS'] = self.bypass_rls
        if self.create_db is not None:
            result['CreateDB'] = self.create_db
        if self.create_role is not None:
            result['CreateRole'] = self.create_role
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.database_privileges is not None:
            result['DatabasePrivileges'] = self.database_privileges.to_map()
        if self.priv_exceeded is not None:
            result['PrivExceeded'] = self.priv_exceeded
        if self.replication is not None:
            result['Replication'] = self.replication
        if self.valid_until is not None:
            result['ValidUntil'] = self.valid_until
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountDescription') is not None:
            self.account_description = m.get('AccountDescription')
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('AccountStatus') is not None:
            self.account_status = m.get('AccountStatus')
        if m.get('AccountType') is not None:
            self.account_type = m.get('AccountType')
        if m.get('BypassRLS') is not None:
            self.bypass_rls = m.get('BypassRLS')
        if m.get('CreateDB') is not None:
            self.create_db = m.get('CreateDB')
        if m.get('CreateRole') is not None:
            self.create_role = m.get('CreateRole')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DatabasePrivileges') is not None:
            temp_model = DescribeAccountsResponseBodyAccountsDBInstanceAccountDatabasePrivileges()
            self.database_privileges = temp_model.from_map(m['DatabasePrivileges'])
        if m.get('PrivExceeded') is not None:
            self.priv_exceeded = m.get('PrivExceeded')
        if m.get('Replication') is not None:
            self.replication = m.get('Replication')
        if m.get('ValidUntil') is not None:
            self.valid_until = m.get('ValidUntil')
        return self


class DescribeAccountsResponseBodyAccounts(TeaModel):
    def __init__(self, dbinstance_account=None):
        self.dbinstance_account = dbinstance_account  # type: list[DescribeAccountsResponseBodyAccountsDBInstanceAccount]

    def validate(self):
        if self.dbinstance_account:
            for k in self.dbinstance_account:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAccountsResponseBodyAccounts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DBInstanceAccount'] = []
        if self.dbinstance_account is not None:
            for k in self.dbinstance_account:
                result['DBInstanceAccount'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.dbinstance_account = []
        if m.get('DBInstanceAccount') is not None:
            for k in m.get('DBInstanceAccount'):
                temp_model = DescribeAccountsResponseBodyAccountsDBInstanceAccount()
                self.dbinstance_account.append(temp_model.from_map(k))
        return self


class DescribeAccountsResponseBody(TeaModel):
    def __init__(self, accounts=None, page_number=None, request_id=None,
                 system_admin_account_first_activation_time=None, system_admin_account_status=None, total_record_count=None):
        # Details of the account.
        self.accounts = accounts  # type: DescribeAccountsResponseBodyAccounts
        # The page number of the returned page.
        self.page_number = page_number  # type: int
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The first time when the superuser account was enabled. The time follows the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.system_admin_account_first_activation_time = system_admin_account_first_activation_time  # type: str
        # Indicates whether the superuser account is enabled.
        self.system_admin_account_status = system_admin_account_status  # type: str
        # The total number of entries.
        self.total_record_count = total_record_count  # type: int

    def validate(self):
        if self.accounts:
            self.accounts.validate()

    def to_map(self):
        _map = super(DescribeAccountsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accounts is not None:
            result['Accounts'] = self.accounts.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.system_admin_account_first_activation_time is not None:
            result['SystemAdminAccountFirstActivationTime'] = self.system_admin_account_first_activation_time
        if self.system_admin_account_status is not None:
            result['SystemAdminAccountStatus'] = self.system_admin_account_status
        if self.total_record_count is not None:
            result['TotalRecordCount'] = self.total_record_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Accounts') is not None:
            temp_model = DescribeAccountsResponseBodyAccounts()
            self.accounts = temp_model.from_map(m['Accounts'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SystemAdminAccountFirstActivationTime') is not None:
            self.system_admin_account_first_activation_time = m.get('SystemAdminAccountFirstActivationTime')
        if m.get('SystemAdminAccountStatus') is not None:
            self.system_admin_account_status = m.get('SystemAdminAccountStatus')
        if m.get('TotalRecordCount') is not None:
            self.total_record_count = m.get('TotalRecordCount')
        return self


class DescribeAccountsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeAccountsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeAccountsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAccountsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeActionEventPolicyRequest(TeaModel):
    def __init__(self, owner_id=None, region_id=None, resource_owner_account=None, resource_owner_id=None):
        self.owner_id = owner_id  # type: long
        # The ID of the region. You can call the [DescribeRegions](~~26243~~) operation to query the most recent region list.
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeActionEventPolicyRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeActionEventPolicyResponseBody(TeaModel):
    def __init__(self, enable_event_log=None, region_id=None, request_id=None):
        # Indicates whether the event history feature is enabled.
        self.enable_event_log = enable_event_log  # type: str
        # The ID of the region.
        self.region_id = region_id  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeActionEventPolicyResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enable_event_log is not None:
            result['EnableEventLog'] = self.enable_event_log
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EnableEventLog') is not None:
            self.enable_event_log = m.get('EnableEventLog')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeActionEventPolicyResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeActionEventPolicyResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeActionEventPolicyResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeActionEventPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeActiveOperationTasksRequest(TeaModel):
    def __init__(self, allow_cancel=None, allow_change=None, change_level=None, db_type=None, ins_name=None,
                 owner_account=None, owner_id=None, page_number=None, page_size=None, product_id=None, region=None,
                 resource_owner_account=None, resource_owner_id=None, security_token=None, status=None, task_type=None):
        self.allow_cancel = allow_cancel  # type: int
        self.allow_change = allow_change  # type: int
        self.change_level = change_level  # type: str
        self.db_type = db_type  # type: str
        self.ins_name = ins_name  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.product_id = product_id  # type: str
        self.region = region  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.security_token = security_token  # type: str
        self.status = status  # type: int
        self.task_type = task_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeActiveOperationTasksRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.allow_cancel is not None:
            result['AllowCancel'] = self.allow_cancel
        if self.allow_change is not None:
            result['AllowChange'] = self.allow_change
        if self.change_level is not None:
            result['ChangeLevel'] = self.change_level
        if self.db_type is not None:
            result['DbType'] = self.db_type
        if self.ins_name is not None:
            result['InsName'] = self.ins_name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_id is not None:
            result['ProductId'] = self.product_id
        if self.region is not None:
            result['Region'] = self.region
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.status is not None:
            result['Status'] = self.status
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AllowCancel') is not None:
            self.allow_cancel = m.get('AllowCancel')
        if m.get('AllowChange') is not None:
            self.allow_change = m.get('AllowChange')
        if m.get('ChangeLevel') is not None:
            self.change_level = m.get('ChangeLevel')
        if m.get('DbType') is not None:
            self.db_type = m.get('DbType')
        if m.get('InsName') is not None:
            self.ins_name = m.get('InsName')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductId') is not None:
            self.product_id = m.get('ProductId')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class DescribeActiveOperationTasksResponseBodyItems(TeaModel):
    def __init__(self, allow_cancel=None, allow_change=None, change_level=None, change_level_en=None,
                 change_level_zh=None, created_time=None, current_avz=None, db_type=None, db_version=None, deadline=None, id=None,
                 impact=None, impact_en=None, impact_zh=None, ins_comment=None, ins_name=None, modified_time=None,
                 prepare_interval=None, region=None, result_info=None, start_time=None, status=None, sub_ins_names=None,
                 switch_time=None, task_type=None, task_type_en=None, task_type_zh=None):
        self.allow_cancel = allow_cancel  # type: str
        self.allow_change = allow_change  # type: str
        self.change_level = change_level  # type: str
        self.change_level_en = change_level_en  # type: str
        self.change_level_zh = change_level_zh  # type: str
        self.created_time = created_time  # type: str
        self.current_avz = current_avz  # type: str
        self.db_type = db_type  # type: str
        self.db_version = db_version  # type: str
        self.deadline = deadline  # type: str
        self.id = id  # type: int
        self.impact = impact  # type: str
        self.impact_en = impact_en  # type: str
        self.impact_zh = impact_zh  # type: str
        self.ins_comment = ins_comment  # type: str
        self.ins_name = ins_name  # type: str
        self.modified_time = modified_time  # type: str
        self.prepare_interval = prepare_interval  # type: str
        self.region = region  # type: str
        self.result_info = result_info  # type: str
        self.start_time = start_time  # type: str
        self.status = status  # type: int
        self.sub_ins_names = sub_ins_names  # type: list[str]
        self.switch_time = switch_time  # type: str
        self.task_type = task_type  # type: str
        self.task_type_en = task_type_en  # type: str
        self.task_type_zh = task_type_zh  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeActiveOperationTasksResponseBodyItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.allow_cancel is not None:
            result['AllowCancel'] = self.allow_cancel
        if self.allow_change is not None:
            result['AllowChange'] = self.allow_change
        if self.change_level is not None:
            result['ChangeLevel'] = self.change_level
        if self.change_level_en is not None:
            result['ChangeLevelEn'] = self.change_level_en
        if self.change_level_zh is not None:
            result['ChangeLevelZh'] = self.change_level_zh
        if self.created_time is not None:
            result['CreatedTime'] = self.created_time
        if self.current_avz is not None:
            result['CurrentAVZ'] = self.current_avz
        if self.db_type is not None:
            result['DbType'] = self.db_type
        if self.db_version is not None:
            result['DbVersion'] = self.db_version
        if self.deadline is not None:
            result['Deadline'] = self.deadline
        if self.id is not None:
            result['Id'] = self.id
        if self.impact is not None:
            result['Impact'] = self.impact
        if self.impact_en is not None:
            result['ImpactEn'] = self.impact_en
        if self.impact_zh is not None:
            result['ImpactZh'] = self.impact_zh
        if self.ins_comment is not None:
            result['InsComment'] = self.ins_comment
        if self.ins_name is not None:
            result['InsName'] = self.ins_name
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.prepare_interval is not None:
            result['PrepareInterval'] = self.prepare_interval
        if self.region is not None:
            result['Region'] = self.region
        if self.result_info is not None:
            result['ResultInfo'] = self.result_info
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        if self.sub_ins_names is not None:
            result['SubInsNames'] = self.sub_ins_names
        if self.switch_time is not None:
            result['SwitchTime'] = self.switch_time
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.task_type_en is not None:
            result['TaskTypeEn'] = self.task_type_en
        if self.task_type_zh is not None:
            result['TaskTypeZh'] = self.task_type_zh
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AllowCancel') is not None:
            self.allow_cancel = m.get('AllowCancel')
        if m.get('AllowChange') is not None:
            self.allow_change = m.get('AllowChange')
        if m.get('ChangeLevel') is not None:
            self.change_level = m.get('ChangeLevel')
        if m.get('ChangeLevelEn') is not None:
            self.change_level_en = m.get('ChangeLevelEn')
        if m.get('ChangeLevelZh') is not None:
            self.change_level_zh = m.get('ChangeLevelZh')
        if m.get('CreatedTime') is not None:
            self.created_time = m.get('CreatedTime')
        if m.get('CurrentAVZ') is not None:
            self.current_avz = m.get('CurrentAVZ')
        if m.get('DbType') is not None:
            self.db_type = m.get('DbType')
        if m.get('DbVersion') is not None:
            self.db_version = m.get('DbVersion')
        if m.get('Deadline') is not None:
            self.deadline = m.get('Deadline')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Impact') is not None:
            self.impact = m.get('Impact')
        if m.get('ImpactEn') is not None:
            self.impact_en = m.get('ImpactEn')
        if m.get('ImpactZh') is not None:
            self.impact_zh = m.get('ImpactZh')
        if m.get('InsComment') is not None:
            self.ins_comment = m.get('InsComment')
        if m.get('InsName') is not None:
            self.ins_name = m.get('InsName')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('PrepareInterval') is not None:
            self.prepare_interval = m.get('PrepareInterval')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('ResultInfo') is not None:
            self.result_info = m.get('ResultInfo')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SubInsNames') is not None:
            self.sub_ins_names = m.get('SubInsNames')
        if m.get('SwitchTime') is not None:
            self.switch_time = m.get('SwitchTime')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('TaskTypeEn') is not None:
            self.task_type_en = m.get('TaskTypeEn')
        if m.get('TaskTypeZh') is not None:
            self.task_type_zh = m.get('TaskTypeZh')
        return self


class DescribeActiveOperationTasksResponseBody(TeaModel):
    def __init__(self, items=None, page_number=None, page_size=None, request_id=None, total_record_count=None):
        self.items = items  # type: list[DescribeActiveOperationTasksResponseBodyItems]
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.total_record_count = total_record_count  # type: int

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeActiveOperationTasksResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Items'] = []
        if self.items is not None:
            for k in self.items:
                result['Items'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_record_count is not None:
            result['TotalRecordCount'] = self.total_record_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.items = []
        if m.get('Items') is not None:
            for k in m.get('Items'):
                temp_model = DescribeActiveOperationTasksResponseBodyItems()
                self.items.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalRecordCount') is not None:
            self.total_record_count = m.get('TotalRecordCount')
        return self


class DescribeActiveOperationTasksResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeActiveOperationTasksResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeActiveOperationTasksResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeActiveOperationTasksResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAnalyticdbByPrimaryDBInstanceRequest(TeaModel):
    def __init__(self, dbinstance_id=None, owner_id=None, region_id=None, resource_owner_account=None,
                 resource_owner_id=None):
        # The ID of the instance. You can call the [DescribeDBInstances](~~26232~~) operation to query the ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        self.owner_id = owner_id  # type: long
        # The region ID of the instance. You can call the [DescribeRegions](~~26243~~) operation to query the most recent region list.
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAnalyticdbByPrimaryDBInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeAnalyticdbByPrimaryDBInstanceResponseBody(TeaModel):
    def __init__(self, analytic_dbcount=None, request_id=None):
        # The number of associated analytic instances.
        self.analytic_dbcount = analytic_dbcount  # type: int
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAnalyticdbByPrimaryDBInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.analytic_dbcount is not None:
            result['AnalyticDBCount'] = self.analytic_dbcount
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AnalyticDBCount') is not None:
            self.analytic_dbcount = m.get('AnalyticDBCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAnalyticdbByPrimaryDBInstanceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeAnalyticdbByPrimaryDBInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeAnalyticdbByPrimaryDBInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAnalyticdbByPrimaryDBInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAvailableClassesRequest(TeaModel):
    def __init__(self, category=None, commodity_code=None, dbinstance_id=None, dbinstance_storage_type=None,
                 engine=None, engine_version=None, instance_charge_type=None, order_type=None, region_id=None,
                 resource_owner_id=None, zone_id=None):
        # The RDS edition that is run by the instance. Valid values:
        # 
        # * **Basic**: Basic Edition
        # * **HighAvailability**: High-availability Edition
        # * **AlwaysOn**: Cluster Edition
        # * **Finance**: Enterprise Edition
        self.category = category  # type: str
        # The commodity code of the instance. Valid values:
        # 
        # * **bards**: The instance is a pay-as-you-go primary instance. This value is available on the China site (aliyun.com).
        # * **rds**: The instance is a subscription primary instance. This value is available on the China site (aliyun.com).
        # * **rords**: The instance is a pay-as-you-go read-only instance. This value is available on the China site (aliyun.com).
        # * **rds\_rordspre\_public\_cn**: The instance is a subscription read-only instance. This value is available on the China site (aliyun.com).
        # * **bards_intl**: The instance is a pay-as-you-go primary instance. This value is available on the International site (alibabacloud.com).
        # * **rds_intl**: The instance is a subscription primary instance. This value is available on the International site (alibabacloud.com).
        # * **rords_intl**: The instance is a pay-as-you-go read-only instance. This value is available on the International site (alibabacloud.com).
        # * **rds\_rordspre\_public\_intl**: The instance is a subscription read-only instance. This value is available on the International site (alibabacloud.com).
        # 
        # > If the instance is a read-only instance, you must specify the CommodityCode parameter.
        self.commodity_code = commodity_code  # type: str
        # The ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        # The type of storage media that is used for the instance. Valid values:
        # 
        # * **local_ssd**: local SSDs. This is the recommended storage type.
        # * **cloud_ssd**: standard SSDs.
        # * **cloud_essd**: enhanced SSDs (ESSDs) of performance level 1 (PL1).
        # * **cloud_essd2**: ESSDs of PL2.
        # * **cloud_essd3**: ESSDs of PL3.
        self.dbinstance_storage_type = dbinstance_storage_type  # type: str
        # The database engine that is run by the instance. Valid values:
        # 
        # * **MySQL**\
        # * **SQLServer**\
        # * **PostgreSQL**\
        # * **MariaDB**\
        self.engine = engine  # type: str
        # The version of the database engine that is run by the instance. Valid values:
        # 
        # * Values that are valid if you set the Engine parameter to MySQL: **5.5, 5.6, 5.7, and 8.0**\
        # * Values that are valid if you set the Engine parameter to SQL Server: **2008r2, 08r2\_ent\_ha, 2012, 2012\_ent\_ha, 2012\_std\_ha, 2012\_web, 2014\_std\_ha, 2016\_ent_ha, 2016\_std\_ha, 2016\_web, 2017\_std\_ha, 2017\_ent, 2019\_std\_ha, and 2019\_ent**\
        # * Values that are valid if you set the Engine parameter to PostgreSQL: **10.0, 11.0, 12.0, 13.0 and 14.0**\
        # * Values that are valid if you set the Engine parameter to MariaDB: **10.3**\
        self.engine_version = engine_version  # type: str
        # The billing method of the instance. Valid values:
        # 
        # * **Prepaid**: subscription
        # * **Postpaid**: pay-as-you-go
        self.instance_charge_type = instance_charge_type  # type: str
        # The type of the order. Set the value to **BUY**\
        self.order_type = order_type  # type: str
        # The region ID of the instance. You can call the [DescribeDBInstanceAttribute](~~26231~~) operation to query the region ID of an instance.
        self.region_id = region_id  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The zone ID of the instance. You can call the [DescribeDBInstanceAttribute](~~26231~~) operation to query the zone ID of an instance.
        # 
        # > If the DescribeDBInstanceAttribute operation returns multiple zones, you must specify only one of the returned zones. For example, if the DescribeDBInstanceAttribute operation returns `cn-hangzhou-MAZ9(g,h)`, you can set the ZoneId parameter to `cn-hangzhou-g` or `cn-hangzhou-h`.
        self.zone_id = zone_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAvailableClassesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.commodity_code is not None:
            result['CommodityCode'] = self.commodity_code
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dbinstance_storage_type is not None:
            result['DBInstanceStorageType'] = self.dbinstance_storage_type
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.engine_version is not None:
            result['EngineVersion'] = self.engine_version
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        if self.order_type is not None:
            result['OrderType'] = self.order_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('CommodityCode') is not None:
            self.commodity_code = m.get('CommodityCode')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DBInstanceStorageType') is not None:
            self.dbinstance_storage_type = m.get('DBInstanceStorageType')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('EngineVersion') is not None:
            self.engine_version = m.get('EngineVersion')
        if m.get('InstanceChargeType') is not None:
            self.instance_charge_type = m.get('InstanceChargeType')
        if m.get('OrderType') is not None:
            self.order_type = m.get('OrderType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeAvailableClassesResponseBodyDBInstanceClassesDBInstanceStorageRange(TeaModel):
    def __init__(self, max_value=None, min_value=None, step=None):
        # The maximum storage capacity that is supported for the instance. Unit: GB.
        self.max_value = max_value  # type: int
        # The minimum storage capacity that is supported for the instance. Unit: GB.
        self.min_value = min_value  # type: int
        # The minimum step size at which you can adjust the storage capacity of the instance. The minimum step size is 5 GB.
        self.step = step  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAvailableClassesResponseBodyDBInstanceClassesDBInstanceStorageRange, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_value is not None:
            result['MaxValue'] = self.max_value
        if self.min_value is not None:
            result['MinValue'] = self.min_value
        if self.step is not None:
            result['Step'] = self.step
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MaxValue') is not None:
            self.max_value = m.get('MaxValue')
        if m.get('MinValue') is not None:
            self.min_value = m.get('MinValue')
        if m.get('Step') is not None:
            self.step = m.get('Step')
        return self


class DescribeAvailableClassesResponseBodyDBInstanceClasses(TeaModel):
    def __init__(self, dbinstance_class=None, dbinstance_storage_range=None):
        # The instance type of the instance.
        self.dbinstance_class = dbinstance_class  # type: str
        # The storage capacity range that is supported for the instance.
        self.dbinstance_storage_range = dbinstance_storage_range  # type: DescribeAvailableClassesResponseBodyDBInstanceClassesDBInstanceStorageRange

    def validate(self):
        if self.dbinstance_storage_range:
            self.dbinstance_storage_range.validate()

    def to_map(self):
        _map = super(DescribeAvailableClassesResponseBodyDBInstanceClasses, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_class is not None:
            result['DBInstanceClass'] = self.dbinstance_class
        if self.dbinstance_storage_range is not None:
            result['DBInstanceStorageRange'] = self.dbinstance_storage_range.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DBInstanceClass') is not None:
            self.dbinstance_class = m.get('DBInstanceClass')
        if m.get('DBInstanceStorageRange') is not None:
            temp_model = DescribeAvailableClassesResponseBodyDBInstanceClassesDBInstanceStorageRange()
            self.dbinstance_storage_range = temp_model.from_map(m['DBInstanceStorageRange'])
        return self


class DescribeAvailableClassesResponseBody(TeaModel):
    def __init__(self, dbinstance_classes=None, request_id=None):
        # An array that consists of the instance types available for the instance.
        self.dbinstance_classes = dbinstance_classes  # type: list[DescribeAvailableClassesResponseBodyDBInstanceClasses]
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.dbinstance_classes:
            for k in self.dbinstance_classes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAvailableClassesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DBInstanceClasses'] = []
        if self.dbinstance_classes is not None:
            for k in self.dbinstance_classes:
                result['DBInstanceClasses'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.dbinstance_classes = []
        if m.get('DBInstanceClasses') is not None:
            for k in m.get('DBInstanceClasses'):
                temp_model = DescribeAvailableClassesResponseBodyDBInstanceClasses()
                self.dbinstance_classes.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAvailableClassesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeAvailableClassesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeAvailableClassesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAvailableClassesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAvailableCrossRegionRequest(TeaModel):
    def __init__(self, owner_id=None, region_id=None, resource_owner_account=None, resource_owner_id=None):
        self.owner_id = owner_id  # type: long
        # The ID of the region. You can call the [DescribeRegions](~~26243~~) operation to query the most recent region list.
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAvailableCrossRegionRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeAvailableCrossRegionResponseBodyRegions(TeaModel):
    def __init__(self, region=None):
        self.region = region  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAvailableCrossRegionResponseBodyRegions, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region is not None:
            result['Region'] = self.region
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Region') is not None:
            self.region = m.get('Region')
        return self


class DescribeAvailableCrossRegionResponseBody(TeaModel):
    def __init__(self, regions=None, request_id=None):
        # An array that consists of destination regions for cross-region backups.
        self.regions = regions  # type: DescribeAvailableCrossRegionResponseBodyRegions
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.regions:
            self.regions.validate()

    def to_map(self):
        _map = super(DescribeAvailableCrossRegionResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.regions is not None:
            result['Regions'] = self.regions.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Regions') is not None:
            temp_model = DescribeAvailableCrossRegionResponseBodyRegions()
            self.regions = temp_model.from_map(m['Regions'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAvailableCrossRegionResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeAvailableCrossRegionResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeAvailableCrossRegionResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAvailableCrossRegionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAvailableMetricsRequest(TeaModel):
    def __init__(self, dbinstance_name=None, resource_group_id=None, resource_owner_id=None):
        # The ID of the instance. You can call the [DescribeDBInstances](~~26232~~) operation to query the IDs of instances.
        self.dbinstance_name = dbinstance_name  # type: str
        # The ID of the resource group.
        self.resource_group_id = resource_group_id  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAvailableMetricsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_name is not None:
            result['DBInstanceName'] = self.dbinstance_name
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DBInstanceName') is not None:
            self.dbinstance_name = m.get('DBInstanceName')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeAvailableMetricsResponseBodyItems(TeaModel):
    def __init__(self, description=None, dimension=None, group_key=None, group_key_type=None, method=None,
                 metrics_key=None, metrics_key_alias=None, sort_rule=None, unit=None):
        # The description of the enhanced monitoring metric.
        self.description = description  # type: str
        # The category of the enhanced monitoring metric. Valid values:
        # 
        # *   **os**: OS metric
        # *   **db**: database metric
        self.dimension = dimension  # type: str
        # The key of the group to which the enhanced monitoring metric belongs.
        self.group_key = group_key  # type: str
        # The name of the group to which the enhanced monitoring metric belongs.
        self.group_key_type = group_key_type  # type: str
        # The method that is used to aggregate the monitoring data of the enhanced monitoring metric. Valid values:
        # 
        # *   **avg**: The system calculates the average value of the enhanced monitoring metric.
        # *   **min**: The system calculates the minimum value of the enhanced monitoring metric.
        # *   **max**: The system calculates the maximum value of the enhanced monitoring metric.
        self.method = method  # type: str
        # The key of the enhanced monitoring metric.
        self.metrics_key = metrics_key  # type: str
        # The alias of the enhanced monitoring metric.
        self.metrics_key_alias = metrics_key_alias  # type: str
        # The serial number of the enhanced monitoring metric.
        self.sort_rule = sort_rule  # type: int
        # The unit of the enhanced monitoring metric.
        self.unit = unit  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAvailableMetricsResponseBodyItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.dimension is not None:
            result['Dimension'] = self.dimension
        if self.group_key is not None:
            result['GroupKey'] = self.group_key
        if self.group_key_type is not None:
            result['GroupKeyType'] = self.group_key_type
        if self.method is not None:
            result['Method'] = self.method
        if self.metrics_key is not None:
            result['MetricsKey'] = self.metrics_key
        if self.metrics_key_alias is not None:
            result['MetricsKeyAlias'] = self.metrics_key_alias
        if self.sort_rule is not None:
            result['SortRule'] = self.sort_rule
        if self.unit is not None:
            result['Unit'] = self.unit
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Dimension') is not None:
            self.dimension = m.get('Dimension')
        if m.get('GroupKey') is not None:
            self.group_key = m.get('GroupKey')
        if m.get('GroupKeyType') is not None:
            self.group_key_type = m.get('GroupKeyType')
        if m.get('Method') is not None:
            self.method = m.get('Method')
        if m.get('MetricsKey') is not None:
            self.metrics_key = m.get('MetricsKey')
        if m.get('MetricsKeyAlias') is not None:
            self.metrics_key_alias = m.get('MetricsKeyAlias')
        if m.get('SortRule') is not None:
            self.sort_rule = m.get('SortRule')
        if m.get('Unit') is not None:
            self.unit = m.get('Unit')
        return self


class DescribeAvailableMetricsResponseBody(TeaModel):
    def __init__(self, dbinstance_name=None, items=None, request_id=None, total_record_count=None):
        # The ID of the instance.
        self.dbinstance_name = dbinstance_name  # type: str
        # An array that consists of the details of the enhanced monitoring metric.
        self.items = items  # type: list[DescribeAvailableMetricsResponseBodyItems]
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The total number of enhanced monitoring metrics that are available for the instance.
        self.total_record_count = total_record_count  # type: int

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAvailableMetricsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_name is not None:
            result['DBInstanceName'] = self.dbinstance_name
        result['Items'] = []
        if self.items is not None:
            for k in self.items:
                result['Items'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_record_count is not None:
            result['TotalRecordCount'] = self.total_record_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DBInstanceName') is not None:
            self.dbinstance_name = m.get('DBInstanceName')
        self.items = []
        if m.get('Items') is not None:
            for k in m.get('Items'):
                temp_model = DescribeAvailableMetricsResponseBodyItems()
                self.items.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalRecordCount') is not None:
            self.total_record_count = m.get('TotalRecordCount')
        return self


class DescribeAvailableMetricsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeAvailableMetricsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeAvailableMetricsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAvailableMetricsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAvailableRecoveryTimeRequest(TeaModel):
    def __init__(self, cross_backup_id=None, dbinstance_id=None, owner_id=None, region_id=None,
                 resource_group_id=None, resource_owner_account=None, resource_owner_id=None):
        # The ID of the cross-region backup file. You can call the [DescribeCrossRegionBackups](~~121733~~) operation to query IDs of backup files.
        self.cross_backup_id = cross_backup_id  # type: int
        # The ID of the instance. You can call the [DescribeDBInstances](~~26232~~) operation to query the ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        self.owner_id = owner_id  # type: long
        # The ID of the region.
        self.region_id = region_id  # type: str
        # The ID of the resource group.
        self.resource_group_id = resource_group_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAvailableRecoveryTimeRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cross_backup_id is not None:
            result['CrossBackupId'] = self.cross_backup_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CrossBackupId') is not None:
            self.cross_backup_id = m.get('CrossBackupId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeAvailableRecoveryTimeResponseBody(TeaModel):
    def __init__(self, cross_backup_id=None, recovery_begin_time=None, recovery_end_time=None, region_id=None,
                 request_id=None):
        # The ID of the cross-region backup file.
        self.cross_backup_id = cross_backup_id  # type: int
        # The start time to which data can be restored. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        self.recovery_begin_time = recovery_begin_time  # type: str
        # The end time to which data can be restored. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        self.recovery_end_time = recovery_end_time  # type: str
        # The region ID of the source instance.
        self.region_id = region_id  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAvailableRecoveryTimeResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cross_backup_id is not None:
            result['CrossBackupId'] = self.cross_backup_id
        if self.recovery_begin_time is not None:
            result['RecoveryBeginTime'] = self.recovery_begin_time
        if self.recovery_end_time is not None:
            result['RecoveryEndTime'] = self.recovery_end_time
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CrossBackupId') is not None:
            self.cross_backup_id = m.get('CrossBackupId')
        if m.get('RecoveryBeginTime') is not None:
            self.recovery_begin_time = m.get('RecoveryBeginTime')
        if m.get('RecoveryEndTime') is not None:
            self.recovery_end_time = m.get('RecoveryEndTime')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAvailableRecoveryTimeResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeAvailableRecoveryTimeResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeAvailableRecoveryTimeResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAvailableRecoveryTimeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAvailableZonesRequest(TeaModel):
    def __init__(self, category=None, commodity_code=None, dbinstance_name=None, dispense_mode=None, engine=None,
                 engine_version=None, region_id=None, resource_owner_id=None, zone_id=None):
        # The RDS edition of the instance. Valid values:
        # 
        # *   **Basic**: RDS Basic Edition
        # *   **HighAvailability**: RDS High-availability Edition
        # *   **AlwaysOn**: RDS Cluster Edition for SQL Server
        # *   **Finance**: RDS Enterprise Edition
        # *   **serverless_basic**: RDS Serverless Basic Edition
        self.category = category  # type: str
        # The commodity code of the instance. This operation can return the resources that you can purchase based on the specified commodity code. Valid values:
        # 
        # *   **bards**: The instance is a pay-as-you-go primary instance. This value is available at the China site (aliyun.com).
        # *   **rds**: The instance is a subscription primary instance. This value is available at the China site (aliyun.com).
        # *   **rords**: The instance is a pay-as-you-go read-only instance. This value is available at the China site (aliyun.com).
        # *   **rds_rordspre_public_cn**: The instance is a subscription read-only instance. This value is available at the China site (aliyun.com).
        # *   **bards_intl**: The instance is a pay-as-you-go primary instance. This value is available at the International site (alibabacloud.com).
        # *   **rds_intl**: The instance is a subscription primary instance. This value is available at the International site (alibabacloud.com).
        # *   **rords_intl**: The instance is a pay-as-you-go read-only instance. This value is available at the International site (alibabacloud.com).
        # *   **rds_rordspre_public_intl**: The instance is a subscription read-only instance. This value is available at the International site (alibabacloud.com).
        # *   **rds_serverless_public_cn**: The instance is a serverless instance. This value is available at the China site (aliyun.com).
        # *   **rds_serverless_public_intl**: The instance is a serverless instance. This value is available at the International site (alibabacloud.com).
        self.commodity_code = commodity_code  # type: str
        # The ID of the primary instance. If you want to query the read-only instances that you can purchase for a primary instance, you can specify this parameter.
        # 
        # If you set the **CommodityCode** parameter to one of the following values, you must specify this parameter:
        # 
        # *   **rords_intl**\
        # *   **rds_rordspre_public_intl**\
        # *   **rords**\
        # *   **rds_rordspre_public_cn**\
        self.dbinstance_name = dbinstance_name  # type: str
        # Specifies whether to return the zones in which the single-zone deployment method is supported. Valid values:
        # 
        # *   **1**: returns the zones.
        # *   **0**: does not return the zones.
        # 
        # Default value: **0**.
        # 
        # > The single-zone deployment method allows you to deploy an instance that runs RDS Enterprise Edition in a single zone.
        self.dispense_mode = dispense_mode  # type: str
        # The database engine of the instance. Valid values:
        # 
        # *   **MySQL**\
        # *   **SQLServer**\
        # *   **PostgreSQL**\
        # *   **MariaDB**\
        self.engine = engine  # type: str
        # The database engine version of the instance. Valid values:
        # 
        # *   Valid values when you set the Engine parameter to MySQL: **5.5, 5.6, 5.7, and 8.0**\
        # *   Valid values when you set the Engine parameter to SQLServer: **2008r2, 08r2\_ent_ha, 2012, 2012\_ent_ha, 2012\_std_ha, 2012\_web, 2014\_std_ha, 2016\_ent_ha, 2016\_std_ha, 2016\_web, 2017\_std_ha, 2017\_ent, 2019\_std_ha, and 2019\_ent**\
        # *   Valid values when you set the Engine parameter to PostgreSQL: **10.0, 11.0, 12.0, 13.0, 14.0, and 15.0**\
        # *   Valid values when you set the Engine parameter to MariaDB: **10.3**\
        self.engine_version = engine_version  # type: str
        # The region ID of the instance. You can call the [DescribeRegions](~~26243~~) operation to query the most recent region list.
        self.region_id = region_id  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The zone ID of the instance. If the instance spans more than one zone, the value of this parameter contains an `MAZ` part, such as `cn-hangzhou-MAZ6(b,f)` and `cn-hangzhou-MAZ5(b,e,f)`. You can call the [DescribeRegions](~~26243~~) operation to query the most recent zone list.
        self.zone_id = zone_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAvailableZonesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.commodity_code is not None:
            result['CommodityCode'] = self.commodity_code
        if self.dbinstance_name is not None:
            result['DBInstanceName'] = self.dbinstance_name
        if self.dispense_mode is not None:
            result['DispenseMode'] = self.dispense_mode
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.engine_version is not None:
            result['EngineVersion'] = self.engine_version
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('CommodityCode') is not None:
            self.commodity_code = m.get('CommodityCode')
        if m.get('DBInstanceName') is not None:
            self.dbinstance_name = m.get('DBInstanceName')
        if m.get('DispenseMode') is not None:
            self.dispense_mode = m.get('DispenseMode')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('EngineVersion') is not None:
            self.engine_version = m.get('EngineVersion')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeAvailableZonesResponseBodyAvailableZonesSupportedEnginesSupportedEngineVersionsSupportedCategorysSupportedStorageTypes(TeaModel):
    def __init__(self, storage_type=None):
        # The storage type of the instance.
        self.storage_type = storage_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAvailableZonesResponseBodyAvailableZonesSupportedEnginesSupportedEngineVersionsSupportedCategorysSupportedStorageTypes, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.storage_type is not None:
            result['StorageType'] = self.storage_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('StorageType') is not None:
            self.storage_type = m.get('StorageType')
        return self


class DescribeAvailableZonesResponseBodyAvailableZonesSupportedEnginesSupportedEngineVersionsSupportedCategorys(TeaModel):
    def __init__(self, category=None, supported_storage_types=None):
        # The RDS edition of the instance.
        self.category = category  # type: str
        # An array that consists of the storage types available in the zone.
        self.supported_storage_types = supported_storage_types  # type: list[DescribeAvailableZonesResponseBodyAvailableZonesSupportedEnginesSupportedEngineVersionsSupportedCategorysSupportedStorageTypes]

    def validate(self):
        if self.supported_storage_types:
            for k in self.supported_storage_types:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAvailableZonesResponseBodyAvailableZonesSupportedEnginesSupportedEngineVersionsSupportedCategorys, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        result['SupportedStorageTypes'] = []
        if self.supported_storage_types is not None:
            for k in self.supported_storage_types:
                result['SupportedStorageTypes'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        self.supported_storage_types = []
        if m.get('SupportedStorageTypes') is not None:
            for k in m.get('SupportedStorageTypes'):
                temp_model = DescribeAvailableZonesResponseBodyAvailableZonesSupportedEnginesSupportedEngineVersionsSupportedCategorysSupportedStorageTypes()
                self.supported_storage_types.append(temp_model.from_map(k))
        return self


class DescribeAvailableZonesResponseBodyAvailableZonesSupportedEnginesSupportedEngineVersions(TeaModel):
    def __init__(self, supported_categorys=None, version=None):
        # An array that consists of the RDS editions available in the zone.
        self.supported_categorys = supported_categorys  # type: list[DescribeAvailableZonesResponseBodyAvailableZonesSupportedEnginesSupportedEngineVersionsSupportedCategorys]
        # The database engine version of the instance.
        self.version = version  # type: str

    def validate(self):
        if self.supported_categorys:
            for k in self.supported_categorys:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAvailableZonesResponseBodyAvailableZonesSupportedEnginesSupportedEngineVersions, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SupportedCategorys'] = []
        if self.supported_categorys is not None:
            for k in self.supported_categorys:
                result['SupportedCategorys'].append(k.to_map() if k else None)
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.supported_categorys = []
        if m.get('SupportedCategorys') is not None:
            for k in m.get('SupportedCategorys'):
                temp_model = DescribeAvailableZonesResponseBodyAvailableZonesSupportedEnginesSupportedEngineVersionsSupportedCategorys()
                self.supported_categorys.append(temp_model.from_map(k))
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class DescribeAvailableZonesResponseBodyAvailableZonesSupportedEngines(TeaModel):
    def __init__(self, engine=None, supported_engine_versions=None):
        # The database engine of the instance.
        self.engine = engine  # type: str
        # An array that consists of the database engine versions available in the zone.
        self.supported_engine_versions = supported_engine_versions  # type: list[DescribeAvailableZonesResponseBodyAvailableZonesSupportedEnginesSupportedEngineVersions]

    def validate(self):
        if self.supported_engine_versions:
            for k in self.supported_engine_versions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAvailableZonesResponseBodyAvailableZonesSupportedEngines, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.engine is not None:
            result['Engine'] = self.engine
        result['SupportedEngineVersions'] = []
        if self.supported_engine_versions is not None:
            for k in self.supported_engine_versions:
                result['SupportedEngineVersions'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        self.supported_engine_versions = []
        if m.get('SupportedEngineVersions') is not None:
            for k in m.get('SupportedEngineVersions'):
                temp_model = DescribeAvailableZonesResponseBodyAvailableZonesSupportedEnginesSupportedEngineVersions()
                self.supported_engine_versions.append(temp_model.from_map(k))
        return self


class DescribeAvailableZonesResponseBodyAvailableZones(TeaModel):
    def __init__(self, region_id=None, supported_engines=None, zone_id=None):
        # The region ID of the instance.
        self.region_id = region_id  # type: str
        # An array that consists of the database engines available in the zone.
        self.supported_engines = supported_engines  # type: list[DescribeAvailableZonesResponseBodyAvailableZonesSupportedEngines]
        # The zone ID of the instance.
        self.zone_id = zone_id  # type: str

    def validate(self):
        if self.supported_engines:
            for k in self.supported_engines:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAvailableZonesResponseBodyAvailableZones, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        result['SupportedEngines'] = []
        if self.supported_engines is not None:
            for k in self.supported_engines:
                result['SupportedEngines'].append(k.to_map() if k else None)
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        self.supported_engines = []
        if m.get('SupportedEngines') is not None:
            for k in m.get('SupportedEngines'):
                temp_model = DescribeAvailableZonesResponseBodyAvailableZonesSupportedEngines()
                self.supported_engines.append(temp_model.from_map(k))
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeAvailableZonesResponseBody(TeaModel):
    def __init__(self, available_zones=None, request_id=None):
        # An array that consists of available zones and resources available in the zones.
        self.available_zones = available_zones  # type: list[DescribeAvailableZonesResponseBodyAvailableZones]
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.available_zones:
            for k in self.available_zones:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAvailableZonesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AvailableZones'] = []
        if self.available_zones is not None:
            for k in self.available_zones:
                result['AvailableZones'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.available_zones = []
        if m.get('AvailableZones') is not None:
            for k in m.get('AvailableZones'):
                temp_model = DescribeAvailableZonesResponseBodyAvailableZones()
                self.available_zones.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAvailableZonesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeAvailableZonesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeAvailableZonesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAvailableZonesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBackupDatabaseRequest(TeaModel):
    def __init__(self, backup_id=None, dbinstance_id=None, owner_id=None, resource_owner_account=None,
                 resource_owner_id=None):
        # The ID of the backup file.
        self.backup_id = backup_id  # type: str
        # The ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBackupDatabaseRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_id is not None:
            result['BackupId'] = self.backup_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BackupId') is not None:
            self.backup_id = m.get('BackupId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeBackupDatabaseResponseBody(TeaModel):
    def __init__(self, database_names=None, request_id=None):
        # The name of the database. Format: "db1,db2".
        self.database_names = database_names  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBackupDatabaseResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.database_names is not None:
            result['DatabaseNames'] = self.database_names
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DatabaseNames') is not None:
            self.database_names = m.get('DatabaseNames')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeBackupDatabaseResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeBackupDatabaseResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeBackupDatabaseResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeBackupDatabaseResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBackupPolicyRequest(TeaModel):
    def __init__(self, backup_policy_mode=None, compress_type=None, dbinstance_id=None, owner_account=None,
                 owner_id=None, released_keep_policy=None, resource_owner_account=None, resource_owner_id=None):
        # The backup type. Valid values:
        # 
        # *   **DataBackupPolicy**: data backup
        # *   **LogBackupPolicy**: log backup
        self.backup_policy_mode = backup_policy_mode  # type: str
        # The method that is used to compress backup data. Valid values:
        # 
        # *   **0**: Backup data is not compressed.
        # *   **1**: Backup data is compressed by using zlib.
        # *   **2**: Backup data is compressed by using zlib that invokes more than one thread in parallel for each backup.
        # *   **4**: Backup data is compressed by using QuickLZ and can be used to restore individual databases and tables.
        # *   **8**: Backup data is compressed by using QuickLZ but cannot be used to restore individual databases or tables. This value is available only when the instance runs MySQL 8.0.
        self.compress_type = compress_type  # type: str
        # The ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The policy that is used to retain archived backup files if the instance is released. Valid values:
        # 
        # *   **None**: No archived backup files are retained.
        # *   **Lastest**: Only the last archived backup file is retained.
        # *   **All**: All archived backup files are retained.
        self.released_keep_policy = released_keep_policy  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBackupPolicyRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_policy_mode is not None:
            result['BackupPolicyMode'] = self.backup_policy_mode
        if self.compress_type is not None:
            result['CompressType'] = self.compress_type
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.released_keep_policy is not None:
            result['ReleasedKeepPolicy'] = self.released_keep_policy
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BackupPolicyMode') is not None:
            self.backup_policy_mode = m.get('BackupPolicyMode')
        if m.get('CompressType') is not None:
            self.compress_type = m.get('CompressType')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ReleasedKeepPolicy') is not None:
            self.released_keep_policy = m.get('ReleasedKeepPolicy')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeBackupPolicyResponseBody(TeaModel):
    def __init__(self, archive_backup_keep_count=None, archive_backup_keep_policy=None,
                 archive_backup_retention_period=None, backup_interval=None, backup_log=None, backup_method=None, backup_retention_period=None,
                 category=None, compress_type=None, enable_backup_log=None, enable_increment_data_backup=None,
                 high_space_usage_protection=None, local_log_retention_hours=None, local_log_retention_space=None, log_backup_frequency=None,
                 log_backup_local_retention_number=None, log_backup_retention_period=None, preferred_backup_period=None, preferred_backup_time=None,
                 preferred_next_backup_time=None, released_keep_policy=None, request_id=None, support_released_keep=None,
                 support_volume_shadow_copy=None):
        # The number of archived backup files that are retained.
        self.archive_backup_keep_count = archive_backup_keep_count  # type: str
        # The cycle based on which archived backup files are retained.
        self.archive_backup_keep_policy = archive_backup_keep_policy  # type: str
        # The number of days for which archived backup files are retained.
        self.archive_backup_retention_period = archive_backup_retention_period  # type: str
        # The backup interval. Unit: minutes.
        # 
        # *   If the instance runs MySQL, the interval is the same as the value of the Snapshot Backup Start Time parameter (not the Snapshot Backup Period parameter) in the ApsaraDB RDS console. For more information, see [Back up an ApsaraDB RDS for MySQL instance](~~98818~~).
        # *   If the instance runs SQL Server, the interval is the same as the log backup frequency.
        self.backup_interval = backup_interval  # type: str
        # Indicates whether the log backup feature is enabled. Valid values:
        # 
        # *   **Enable**\
        # *   **Disabled**\
        self.backup_log = backup_log  # type: str
        # The backup method of the instance. Valid values:
        # 
        # *   **Physical**: physical backup
        # *   **Snapshot**: snapshot backup
        # 
        # >  This parameter is returned only when the instance runs SQL Server and uses standard SSDs or enhanced SSDs (ESSDs).
        self.backup_method = backup_method  # type: str
        # The number of days for which data backup files are retained.
        self.backup_retention_period = backup_retention_period  # type: int
        # Indicates whether to enable the single-digit second backup feature. This feature allows ApsaraDB RDS to complete a backup within single-digit seconds. Valid values:
        # 
        # *   **Flash**: The single-digit second backup feature is enabled.
        # *   **Standard**: The single-digit second backup feature is disabled.
        # 
        # >  This parameter takes effect only when you set the **BackupPolicyMode** parameter to **DataBackupPolicy**.
        self.category = category  # type: str
        # The method that is used to compress backup data. Valid values:
        # 
        # *   **0**: Backup data is not compressed.
        # *   **1**: Backup data is compressed by using zlib.
        # *   **2**: Backup data is compressed by using zlib that invokes more than one thread in parallel for each backup.
        # *   **4**: Backup data is compressed by using QuickLZ and can be used to restore individual databases and tables.
        # *   **8**: Backup data is compressed by using QuickLZ but cannot be used to restore individual databases or tables. This value is available only when the instance runs MySQL 8.0.
        self.compress_type = compress_type  # type: str
        # Indicates whether the log backup feature is enabled. Valid values:
        # 
        # *   **1**: The log backup feature is enabled.
        # *   **0**: The log backup feature is disabled.
        self.enable_backup_log = enable_backup_log  # type: str
        # Indicates whether incremental backup is enabled. Valid values:
        # 
        # *   **True**: Incremental backup is enabled.
        # *   **False**: Incremental backup is disabled.
        self.enable_increment_data_backup = enable_increment_data_backup  # type: bool
        # Indicates whether the log backup deletion feature is enabled. If the disk usage exceeds 80% or the remaining disk space is less than 5 GB on the instance, this feature deletes binary log files. Valid values:
        # 
        # *   **Disable**\
        # *   **Enable**\
        self.high_space_usage_protection = high_space_usage_protection  # type: str
        # The number of hours for which log backup files are retained on the instance.
        self.local_log_retention_hours = local_log_retention_hours  # type: int
        # The maximum disk usage that is allowed for log backup files on the instance.
        self.local_log_retention_space = local_log_retention_space  # type: str
        # The backup frequency of logs. Valid values:
        # 
        # *   **LogInterval**: Log backups are performed every 30 minutes.
        # *   Default value: same as the value of the **PreferredBackupPeriod** parameter.
        # 
        # >  The **LogBackupFrequency** parameter is returned only when the instance runs **SQL Server**.
        self.log_backup_frequency = log_backup_frequency  # type: str
        # The number of binary log files that are retained on the instance.
        self.log_backup_local_retention_number = log_backup_local_retention_number  # type: int
        # The number of days for which log backup files are retained.
        self.log_backup_retention_period = log_backup_retention_period  # type: int
        # The cycle based on which you want to perform a backup. Separate multiple values with commas (,). Valid values:
        # 
        # *   **Monday**\
        # *   **Tuesday**\
        # *   **Wednesday**\
        # *   **Thursday**\
        # *   **Friday**\
        # *   **Saturday**\
        # *   **Sunday**\
        self.preferred_backup_period = preferred_backup_period  # type: str
        # The time when a data backup is performed. The time follows the ISO 8601 standard in the *HH:mm*Z-*HH:mm*Z format. The time is displayed in UTC.
        self.preferred_backup_time = preferred_backup_time  # type: str
        # The time when the next backup is performed. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm*Z format. The time is displayed in UTC.
        self.preferred_next_backup_time = preferred_next_backup_time  # type: str
        # The policy that is used to retain archived backup files if the instance is released. Valid values:
        # 
        # *   **None**: No archived backup files are retained.
        # *   **Lastest**: Only the last archived backup file is retained.
        # *   **All**: All archived backup files are retained.
        self.released_keep_policy = released_keep_policy  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # A reserved parameter.
        self.support_released_keep = support_released_keep  # type: int
        # Indicates whether the instance supports snapshot backups. Valid values:
        # 
        # *   **1**: The instance supports snapshot backups.
        # *   **0**: The instance does not support snapshot backups.
        # 
        # >  This parameter is returned only when the instance runs SQL Server.
        self.support_volume_shadow_copy = support_volume_shadow_copy  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBackupPolicyResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.archive_backup_keep_count is not None:
            result['ArchiveBackupKeepCount'] = self.archive_backup_keep_count
        if self.archive_backup_keep_policy is not None:
            result['ArchiveBackupKeepPolicy'] = self.archive_backup_keep_policy
        if self.archive_backup_retention_period is not None:
            result['ArchiveBackupRetentionPeriod'] = self.archive_backup_retention_period
        if self.backup_interval is not None:
            result['BackupInterval'] = self.backup_interval
        if self.backup_log is not None:
            result['BackupLog'] = self.backup_log
        if self.backup_method is not None:
            result['BackupMethod'] = self.backup_method
        if self.backup_retention_period is not None:
            result['BackupRetentionPeriod'] = self.backup_retention_period
        if self.category is not None:
            result['Category'] = self.category
        if self.compress_type is not None:
            result['CompressType'] = self.compress_type
        if self.enable_backup_log is not None:
            result['EnableBackupLog'] = self.enable_backup_log
        if self.enable_increment_data_backup is not None:
            result['EnableIncrementDataBackup'] = self.enable_increment_data_backup
        if self.high_space_usage_protection is not None:
            result['HighSpaceUsageProtection'] = self.high_space_usage_protection
        if self.local_log_retention_hours is not None:
            result['LocalLogRetentionHours'] = self.local_log_retention_hours
        if self.local_log_retention_space is not None:
            result['LocalLogRetentionSpace'] = self.local_log_retention_space
        if self.log_backup_frequency is not None:
            result['LogBackupFrequency'] = self.log_backup_frequency
        if self.log_backup_local_retention_number is not None:
            result['LogBackupLocalRetentionNumber'] = self.log_backup_local_retention_number
        if self.log_backup_retention_period is not None:
            result['LogBackupRetentionPeriod'] = self.log_backup_retention_period
        if self.preferred_backup_period is not None:
            result['PreferredBackupPeriod'] = self.preferred_backup_period
        if self.preferred_backup_time is not None:
            result['PreferredBackupTime'] = self.preferred_backup_time
        if self.preferred_next_backup_time is not None:
            result['PreferredNextBackupTime'] = self.preferred_next_backup_time
        if self.released_keep_policy is not None:
            result['ReleasedKeepPolicy'] = self.released_keep_policy
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.support_released_keep is not None:
            result['SupportReleasedKeep'] = self.support_released_keep
        if self.support_volume_shadow_copy is not None:
            result['SupportVolumeShadowCopy'] = self.support_volume_shadow_copy
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ArchiveBackupKeepCount') is not None:
            self.archive_backup_keep_count = m.get('ArchiveBackupKeepCount')
        if m.get('ArchiveBackupKeepPolicy') is not None:
            self.archive_backup_keep_policy = m.get('ArchiveBackupKeepPolicy')
        if m.get('ArchiveBackupRetentionPeriod') is not None:
            self.archive_backup_retention_period = m.get('ArchiveBackupRetentionPeriod')
        if m.get('BackupInterval') is not None:
            self.backup_interval = m.get('BackupInterval')
        if m.get('BackupLog') is not None:
            self.backup_log = m.get('BackupLog')
        if m.get('BackupMethod') is not None:
            self.backup_method = m.get('BackupMethod')
        if m.get('BackupRetentionPeriod') is not None:
            self.backup_retention_period = m.get('BackupRetentionPeriod')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('CompressType') is not None:
            self.compress_type = m.get('CompressType')
        if m.get('EnableBackupLog') is not None:
            self.enable_backup_log = m.get('EnableBackupLog')
        if m.get('EnableIncrementDataBackup') is not None:
            self.enable_increment_data_backup = m.get('EnableIncrementDataBackup')
        if m.get('HighSpaceUsageProtection') is not None:
            self.high_space_usage_protection = m.get('HighSpaceUsageProtection')
        if m.get('LocalLogRetentionHours') is not None:
            self.local_log_retention_hours = m.get('LocalLogRetentionHours')
        if m.get('LocalLogRetentionSpace') is not None:
            self.local_log_retention_space = m.get('LocalLogRetentionSpace')
        if m.get('LogBackupFrequency') is not None:
            self.log_backup_frequency = m.get('LogBackupFrequency')
        if m.get('LogBackupLocalRetentionNumber') is not None:
            self.log_backup_local_retention_number = m.get('LogBackupLocalRetentionNumber')
        if m.get('LogBackupRetentionPeriod') is not None:
            self.log_backup_retention_period = m.get('LogBackupRetentionPeriod')
        if m.get('PreferredBackupPeriod') is not None:
            self.preferred_backup_period = m.get('PreferredBackupPeriod')
        if m.get('PreferredBackupTime') is not None:
            self.preferred_backup_time = m.get('PreferredBackupTime')
        if m.get('PreferredNextBackupTime') is not None:
            self.preferred_next_backup_time = m.get('PreferredNextBackupTime')
        if m.get('ReleasedKeepPolicy') is not None:
            self.released_keep_policy = m.get('ReleasedKeepPolicy')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SupportReleasedKeep') is not None:
            self.support_released_keep = m.get('SupportReleasedKeep')
        if m.get('SupportVolumeShadowCopy') is not None:
            self.support_volume_shadow_copy = m.get('SupportVolumeShadowCopy')
        return self


class DescribeBackupPolicyResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeBackupPolicyResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeBackupPolicyResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeBackupPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBackupTasksRequest(TeaModel):
    def __init__(self, backup_job_id=None, backup_job_status=None, backup_mode=None, client_token=None,
                 dbinstance_id=None, flag=None, owner_account=None, owner_id=None, resource_owner_account=None,
                 resource_owner_id=None):
        # The ID of the backup task.
        self.backup_job_id = backup_job_id  # type: int
        # The status of the backup task. Valid values:
        # 
        # *   **NoStart**: The backup task is not started.
        # *   **Progressing**: The backup task is in progress.
        # 
        # By default, this operation returns backup tasks in both states.
        self.backup_job_status = backup_job_status  # type: str
        # The backup mode. Valid values:
        # 
        # *   **Automated**\
        # *   **Manual**\
        self.backup_mode = backup_mode  # type: str
        # The client token that is used to ensure the idempotence of the request. You can use the client to generate the token, but you must make sure that the generated token is unique among different requests. The token can contain only ASCII characters and cannot exceed 64 characters in length.
        self.client_token = client_token  # type: str
        # The ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        # A reserved parameter.
        self.flag = flag  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBackupTasksRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_job_id is not None:
            result['BackupJobId'] = self.backup_job_id
        if self.backup_job_status is not None:
            result['BackupJobStatus'] = self.backup_job_status
        if self.backup_mode is not None:
            result['BackupMode'] = self.backup_mode
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.flag is not None:
            result['Flag'] = self.flag
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BackupJobId') is not None:
            self.backup_job_id = m.get('BackupJobId')
        if m.get('BackupJobStatus') is not None:
            self.backup_job_status = m.get('BackupJobStatus')
        if m.get('BackupMode') is not None:
            self.backup_mode = m.get('BackupMode')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('Flag') is not None:
            self.flag = m.get('Flag')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeBackupTasksResponseBodyItemsBackupJob(TeaModel):
    def __init__(self, backup_id=None, backup_job_id=None, backup_progress_status=None, backup_status=None,
                 job_mode=None, process=None, task_action=None):
        # The ID of the backup set that is generated by the backup task.
        # 
        # > If the return value of the **BackupStatus** parameter is **Finished**, you must specify the **BackupJobId** parameter to obtain the ID of the generated backup set.
        self.backup_id = backup_id  # type: str
        # The ID of the backup task.
        self.backup_job_id = backup_job_id  # type: str
        # The status of the backup program. Valid values:
        # 
        # *   **NoStart**\
        # *   **Preparing**\
        # *   **Waiting**\
        # *   **Uploading**\
        # *   **Checking**\
        # *   **Finished**\
        self.backup_progress_status = backup_progress_status  # type: str
        # The status of the backup task. Valid values:
        # 
        # *   **NoStart**\
        # *   **Checking**\
        # *   **Preparing**\
        # *   **Waiting**\
        # *   **Uploading**\
        # *   **Finished**\
        # *   **Failed**\
        # 
        # > This parameter is returned only after a backup task is run.
        self.backup_status = backup_status  # type: str
        # The backup mode. Valid values:
        # 
        # *   **Automated**\
        # *   **Manual**\
        self.job_mode = job_mode  # type: str
        # The progress of the task in percentage.
        self.process = process  # type: str
        # The type of the backup task. Valid values:
        # 
        # *   **TempBackupTask**: The backup task is an adhoc backup task.
        # *   **NormalBackupTask**: The backup task is a common backup task.
        self.task_action = task_action  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBackupTasksResponseBodyItemsBackupJob, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_id is not None:
            result['BackupId'] = self.backup_id
        if self.backup_job_id is not None:
            result['BackupJobId'] = self.backup_job_id
        if self.backup_progress_status is not None:
            result['BackupProgressStatus'] = self.backup_progress_status
        if self.backup_status is not None:
            result['BackupStatus'] = self.backup_status
        if self.job_mode is not None:
            result['JobMode'] = self.job_mode
        if self.process is not None:
            result['Process'] = self.process
        if self.task_action is not None:
            result['TaskAction'] = self.task_action
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BackupId') is not None:
            self.backup_id = m.get('BackupId')
        if m.get('BackupJobId') is not None:
            self.backup_job_id = m.get('BackupJobId')
        if m.get('BackupProgressStatus') is not None:
            self.backup_progress_status = m.get('BackupProgressStatus')
        if m.get('BackupStatus') is not None:
            self.backup_status = m.get('BackupStatus')
        if m.get('JobMode') is not None:
            self.job_mode = m.get('JobMode')
        if m.get('Process') is not None:
            self.process = m.get('Process')
        if m.get('TaskAction') is not None:
            self.task_action = m.get('TaskAction')
        return self


class DescribeBackupTasksResponseBodyItems(TeaModel):
    def __init__(self, backup_job=None):
        self.backup_job = backup_job  # type: list[DescribeBackupTasksResponseBodyItemsBackupJob]

    def validate(self):
        if self.backup_job:
            for k in self.backup_job:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeBackupTasksResponseBodyItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BackupJob'] = []
        if self.backup_job is not None:
            for k in self.backup_job:
                result['BackupJob'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.backup_job = []
        if m.get('BackupJob') is not None:
            for k in m.get('BackupJob'):
                temp_model = DescribeBackupTasksResponseBodyItemsBackupJob()
                self.backup_job.append(temp_model.from_map(k))
        return self


class DescribeBackupTasksResponseBody(TeaModel):
    def __init__(self, items=None, request_id=None):
        # An array that consists of the details of the backup task.
        self.items = items  # type: DescribeBackupTasksResponseBodyItems
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super(DescribeBackupTasksResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.items is not None:
            result['Items'] = self.items.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Items') is not None:
            temp_model = DescribeBackupTasksResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeBackupTasksResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeBackupTasksResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeBackupTasksResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeBackupTasksResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBackupsRequest(TeaModel):
    def __init__(self, backup_id=None, backup_mode=None, backup_status=None, backup_type=None, dbinstance_id=None,
                 end_time=None, page_number=None, page_size=None, resource_group_id=None, resource_owner_id=None,
                 start_time=None):
        # The ID of the data backup file.
        self.backup_id = backup_id  # type: str
        # The backup mode of the data backup file. Valid values:
        # 
        # *   **Automated**\
        # *   **Manual**\
        self.backup_mode = backup_mode  # type: str
        # The status of the data backup file. Valid values:
        # 
        # *   **Success**\
        # *   **Failed**\
        self.backup_status = backup_status  # type: str
        # The backup type of the data backup file. Valid values:
        # 
        # *   **FullBackup**\
        # *   **IncrementalBackup**\
        self.backup_type = backup_type  # type: str
        # The ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        # The end of the time range to query. The end time must be later than the start time. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm*Z format. The time must be in UTC.
        self.end_time = end_time  # type: str
        # The number of the page to return. Valid values: any non-zero positive integer.
        # 
        # Default value: **1**.
        self.page_number = page_number  # type: int
        # The number of entries to return on each page. Valid values:
        # 
        # *   **30**\
        # *   **50**\
        # *   **100**\
        # 
        # Default value: **30**.
        self.page_size = page_size  # type: int
        # The ID of the resource group.
        self.resource_group_id = resource_group_id  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The beginning of the time range to query. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm*Z format. The time must be in UTC.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBackupsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_id is not None:
            result['BackupId'] = self.backup_id
        if self.backup_mode is not None:
            result['BackupMode'] = self.backup_mode
        if self.backup_status is not None:
            result['BackupStatus'] = self.backup_status
        if self.backup_type is not None:
            result['BackupType'] = self.backup_type
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BackupId') is not None:
            self.backup_id = m.get('BackupId')
        if m.get('BackupMode') is not None:
            self.backup_mode = m.get('BackupMode')
        if m.get('BackupStatus') is not None:
            self.backup_status = m.get('BackupStatus')
        if m.get('BackupType') is not None:
            self.backup_type = m.get('BackupType')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeBackupsResponseBodyItemsBackupBackupDownloadLinkByDBBackupDownloadLinkByDB(TeaModel):
    def __init__(self, data_base=None, download_link=None, intranet_download_link=None):
        # The name of the database.
        self.data_base = data_base  # type: str
        # The public URL from which you can download the data backup file.
        self.download_link = download_link  # type: str
        # The internal URL from which you can download the data backup file.
        self.intranet_download_link = intranet_download_link  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBackupsResponseBodyItemsBackupBackupDownloadLinkByDBBackupDownloadLinkByDB, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_base is not None:
            result['DataBase'] = self.data_base
        if self.download_link is not None:
            result['DownloadLink'] = self.download_link
        if self.intranet_download_link is not None:
            result['IntranetDownloadLink'] = self.intranet_download_link
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DataBase') is not None:
            self.data_base = m.get('DataBase')
        if m.get('DownloadLink') is not None:
            self.download_link = m.get('DownloadLink')
        if m.get('IntranetDownloadLink') is not None:
            self.intranet_download_link = m.get('IntranetDownloadLink')
        return self


class DescribeBackupsResponseBodyItemsBackupBackupDownloadLinkByDB(TeaModel):
    def __init__(self, backup_download_link_by_db=None):
        self.backup_download_link_by_db = backup_download_link_by_db  # type: list[DescribeBackupsResponseBodyItemsBackupBackupDownloadLinkByDBBackupDownloadLinkByDB]

    def validate(self):
        if self.backup_download_link_by_db:
            for k in self.backup_download_link_by_db:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeBackupsResponseBodyItemsBackupBackupDownloadLinkByDB, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BackupDownloadLinkByDB'] = []
        if self.backup_download_link_by_db is not None:
            for k in self.backup_download_link_by_db:
                result['BackupDownloadLinkByDB'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.backup_download_link_by_db = []
        if m.get('BackupDownloadLinkByDB') is not None:
            for k in m.get('BackupDownloadLinkByDB'):
                temp_model = DescribeBackupsResponseBodyItemsBackupBackupDownloadLinkByDBBackupDownloadLinkByDB()
                self.backup_download_link_by_db.append(temp_model.from_map(k))
        return self


class DescribeBackupsResponseBodyItemsBackup(TeaModel):
    def __init__(self, backup_download_link_by_db=None, backup_download_url=None, backup_end_time=None,
                 backup_id=None, backup_initiator=None, backup_intranet_download_url=None, backup_method=None,
                 backup_mode=None, backup_size=None, backup_start_time=None, backup_status=None, backup_type=None,
                 checksum=None, consistent_time=None, copy_only_backup=None, dbinstance_id=None, encryption=None,
                 host_instance_id=None, is_avail=None, meta_status=None, resource_group_id=None, storage_class=None,
                 store_status=None):
        # The URL from which you can download the data backup file of the individual database.
        self.backup_download_link_by_db = backup_download_link_by_db  # type: DescribeBackupsResponseBodyItemsBackupBackupDownloadLinkByDB
        # The URL that is used to download the data backup file over the Internet. If the data backup file cannot be downloaded, null is returned.
        # 
        # >  For example, if the instance runs SQL Server and the BackupMethod parameter is set to **Snapshot**, null is returned.
        self.backup_download_url = backup_download_url  # type: str
        # The end time of the backup task. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm*Z format. The time is displayed in UTC.
        self.backup_end_time = backup_end_time  # type: str
        # The ID of the data backup file.
        self.backup_id = backup_id  # type: str
        # The initiator of the backup task. Valid values:
        # 
        # *   **System**\
        # *   **User**\
        self.backup_initiator = backup_initiator  # type: str
        # The URL that is used to download the data backup file over an internal network. If the data backup file cannot be downloaded, null is returned.
        # 
        # >  For example, if the instance runs SQL Server and the BackupMethod parameter is set to **Snapshot**, null is returned.
        self.backup_intranet_download_url = backup_intranet_download_url  # type: str
        # The method that is used to generate the data backup file. Valid values:
        # 
        # *   **Logical**: logical backup
        # *   **Physical**: physical backup
        # *   **Snapshot**: snapshot backup
        self.backup_method = backup_method  # type: str
        # The backup mode of the data backup file. Valid values:
        # 
        # *   **Automated**\
        # *   **Manual**\
        self.backup_mode = backup_mode  # type: str
        # The size of the data backup file. Unit: bytes.
        self.backup_size = backup_size  # type: long
        # The start time of the backup task. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm*Z format. The time is displayed in UTC.
        self.backup_start_time = backup_start_time  # type: str
        # The status of the data backup file.
        self.backup_status = backup_status  # type: str
        # The backup type of the data backup file. Valid values:
        # 
        # *   **FullBackup**\
        # *   **IncrementalBackup**\
        self.backup_type = backup_type  # type: str
        # The checksum. The value of this parameter is calculated by using the CRC64 algorithm.
        self.checksum = checksum  # type: str
        # The point in time at which the data in the data backup file is consistent. The return value of this parameter is a timestamp.
        # 
        # >  If the instance runs MySQL 5.6, a timestamp is returned. Otherwise, the value 0 is returned.
        self.consistent_time = consistent_time  # type: long
        # The backup mode of the data backup file. Valid values:
        # 
        # *   0: the standard mode. This mode supports full backups and incremental backups.
        # 
        # *   1: the copy-only mode. This mode supports only full backups.
        # 
        # > This parameter is returned only when the instance runs SQL Server.
        self.copy_only_backup = copy_only_backup  # type: str
        # The ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        # The encryption information of the data backup file.
        self.encryption = encryption  # type: str
        # The No. of the instance that generates the data backup file. This parameter is used to indicate whether the instance that generates the data backup file is a primary instance or a secondary instance.
        self.host_instance_id = host_instance_id  # type: str
        # Indicates whether the data backup file is available. Valid values:
        # 
        # *   **0**: The data backup file is unavailable.
        # *   **1**: The data backup file is available.
        self.is_avail = is_avail  # type: int
        # The status of the data backup file that is used to restore individual databases or tables. Valid values:
        # 
        # *   **OK**: The data backup file is normal.
        # *   **LARGE**: The data backup file contains an abnormally large number of tables. It cannot be used to restore individual databases or tables.
        # *   **EMPTY**: The data backup file is generated from a failed backup task.
        # 
        # >  If an empty string is returned, the data backup file cannot be used to restore individual databases or tables.
        self.meta_status = meta_status  # type: str
        # The ID of the resource group.
        self.resource_group_id = resource_group_id  # type: str
        # The storage class of the data backup file. Valid values:
        # 
        # *   **0**: regular storage
        # *   **1**: archive storage
        self.storage_class = storage_class  # type: str
        # Indicates whether the data backup file can be deleted. Valid values:
        # 
        # *   **Enabled**: The data backup file can be deleted.
        # *   **Disabled**: The data backup file cannot be deleted.
        self.store_status = store_status  # type: str

    def validate(self):
        if self.backup_download_link_by_db:
            self.backup_download_link_by_db.validate()

    def to_map(self):
        _map = super(DescribeBackupsResponseBodyItemsBackup, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_download_link_by_db is not None:
            result['BackupDownloadLinkByDB'] = self.backup_download_link_by_db.to_map()
        if self.backup_download_url is not None:
            result['BackupDownloadURL'] = self.backup_download_url
        if self.backup_end_time is not None:
            result['BackupEndTime'] = self.backup_end_time
        if self.backup_id is not None:
            result['BackupId'] = self.backup_id
        if self.backup_initiator is not None:
            result['BackupInitiator'] = self.backup_initiator
        if self.backup_intranet_download_url is not None:
            result['BackupIntranetDownloadURL'] = self.backup_intranet_download_url
        if self.backup_method is not None:
            result['BackupMethod'] = self.backup_method
        if self.backup_mode is not None:
            result['BackupMode'] = self.backup_mode
        if self.backup_size is not None:
            result['BackupSize'] = self.backup_size
        if self.backup_start_time is not None:
            result['BackupStartTime'] = self.backup_start_time
        if self.backup_status is not None:
            result['BackupStatus'] = self.backup_status
        if self.backup_type is not None:
            result['BackupType'] = self.backup_type
        if self.checksum is not None:
            result['Checksum'] = self.checksum
        if self.consistent_time is not None:
            result['ConsistentTime'] = self.consistent_time
        if self.copy_only_backup is not None:
            result['CopyOnlyBackup'] = self.copy_only_backup
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.encryption is not None:
            result['Encryption'] = self.encryption
        if self.host_instance_id is not None:
            result['HostInstanceID'] = self.host_instance_id
        if self.is_avail is not None:
            result['IsAvail'] = self.is_avail
        if self.meta_status is not None:
            result['MetaStatus'] = self.meta_status
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.storage_class is not None:
            result['StorageClass'] = self.storage_class
        if self.store_status is not None:
            result['StoreStatus'] = self.store_status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BackupDownloadLinkByDB') is not None:
            temp_model = DescribeBackupsResponseBodyItemsBackupBackupDownloadLinkByDB()
            self.backup_download_link_by_db = temp_model.from_map(m['BackupDownloadLinkByDB'])
        if m.get('BackupDownloadURL') is not None:
            self.backup_download_url = m.get('BackupDownloadURL')
        if m.get('BackupEndTime') is not None:
            self.backup_end_time = m.get('BackupEndTime')
        if m.get('BackupId') is not None:
            self.backup_id = m.get('BackupId')
        if m.get('BackupInitiator') is not None:
            self.backup_initiator = m.get('BackupInitiator')
        if m.get('BackupIntranetDownloadURL') is not None:
            self.backup_intranet_download_url = m.get('BackupIntranetDownloadURL')
        if m.get('BackupMethod') is not None:
            self.backup_method = m.get('BackupMethod')
        if m.get('BackupMode') is not None:
            self.backup_mode = m.get('BackupMode')
        if m.get('BackupSize') is not None:
            self.backup_size = m.get('BackupSize')
        if m.get('BackupStartTime') is not None:
            self.backup_start_time = m.get('BackupStartTime')
        if m.get('BackupStatus') is not None:
            self.backup_status = m.get('BackupStatus')
        if m.get('BackupType') is not None:
            self.backup_type = m.get('BackupType')
        if m.get('Checksum') is not None:
            self.checksum = m.get('Checksum')
        if m.get('ConsistentTime') is not None:
            self.consistent_time = m.get('ConsistentTime')
        if m.get('CopyOnlyBackup') is not None:
            self.copy_only_backup = m.get('CopyOnlyBackup')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('Encryption') is not None:
            self.encryption = m.get('Encryption')
        if m.get('HostInstanceID') is not None:
            self.host_instance_id = m.get('HostInstanceID')
        if m.get('IsAvail') is not None:
            self.is_avail = m.get('IsAvail')
        if m.get('MetaStatus') is not None:
            self.meta_status = m.get('MetaStatus')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('StorageClass') is not None:
            self.storage_class = m.get('StorageClass')
        if m.get('StoreStatus') is not None:
            self.store_status = m.get('StoreStatus')
        return self


class DescribeBackupsResponseBodyItems(TeaModel):
    def __init__(self, backup=None):
        self.backup = backup  # type: list[DescribeBackupsResponseBodyItemsBackup]

    def validate(self):
        if self.backup:
            for k in self.backup:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeBackupsResponseBodyItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Backup'] = []
        if self.backup is not None:
            for k in self.backup:
                result['Backup'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.backup = []
        if m.get('Backup') is not None:
            for k in m.get('Backup'):
                temp_model = DescribeBackupsResponseBodyItemsBackup()
                self.backup.append(temp_model.from_map(k))
        return self


class DescribeBackupsResponseBody(TeaModel):
    def __init__(self, items=None, page_number=None, page_record_count=None, request_id=None,
                 total_ecs_snapshot_size=None, total_record_count=None):
        # An array that consists of the details of the returned data backup files.
        self.items = items  # type: DescribeBackupsResponseBodyItems
        # The page number of the returned page.
        self.page_number = page_number  # type: str
        # The number of data backup files on the page.
        self.page_record_count = page_record_count  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The size of the snapshot chain of the instance. Unit: bytes.
        self.total_ecs_snapshot_size = total_ecs_snapshot_size  # type: long
        # The total number of entries returned.
        self.total_record_count = total_record_count  # type: str

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super(DescribeBackupsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.items is not None:
            result['Items'] = self.items.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_record_count is not None:
            result['PageRecordCount'] = self.page_record_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_ecs_snapshot_size is not None:
            result['TotalEcsSnapshotSize'] = self.total_ecs_snapshot_size
        if self.total_record_count is not None:
            result['TotalRecordCount'] = self.total_record_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Items') is not None:
            temp_model = DescribeBackupsResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageRecordCount') is not None:
            self.page_record_count = m.get('PageRecordCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalEcsSnapshotSize') is not None:
            self.total_ecs_snapshot_size = m.get('TotalEcsSnapshotSize')
        if m.get('TotalRecordCount') is not None:
            self.total_record_count = m.get('TotalRecordCount')
        return self


class DescribeBackupsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeBackupsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeBackupsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeBackupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBinlogFilesRequest(TeaModel):
    def __init__(self, dbinstance_id=None, end_time=None, owner_account=None, owner_id=None, page_number=None,
                 page_size=None, resource_owner_account=None, resource_owner_id=None, start_time=None):
        # The ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        # The end time of the query. The end time must be later than the start time. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time must be in UTC.
        self.end_time = end_time  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The number of the page to return. Valid values: any non-zero positive integer.
        # 
        # Default value: **1**.
        self.page_number = page_number  # type: int
        # The number of entries to return on each page. Valid values: **30** to **100**. Default value: **30**.
        self.page_size = page_size  # type: int
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The start time of the query. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time must be in UTC.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBinlogFilesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeBinlogFilesResponseBodyItemsBinLogFile(TeaModel):
    def __init__(self, checksum=None, download_link=None, file_size=None, host_instance_id=None,
                 intranet_download_link=None, link_expired_time=None, log_begin_time=None, log_end_time=None, log_file_name=None,
                 remote_status=None):
        # The checksum. The value of this parameter is calculated by using the CRC64 algorithm.
        self.checksum = checksum  # type: str
        # The HTTP-based download URL of the binary log file. If the return value of this parameter is NULL, ApsaraDB RDS does not provide a download URL for the file.
        self.download_link = download_link  # type: str
        # The size of the binary log file. Unit: bytes.
        self.file_size = file_size  # type: long
        # The ID of the instance to which the binary log file belongs. This parameter is used to distinguish between the binary log files that are generated on a primary instance and those that are generated on a secondary instance.
        self.host_instance_id = host_instance_id  # type: str
        # The download URL that is used over an internal network.
        self.intranet_download_link = intranet_download_link  # type: str
        # The expiration time of the URL. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.link_expired_time = link_expired_time  # type: str
        # The start time of the log data recorded in the binary log file. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.log_begin_time = log_begin_time  # type: str
        # The end time of the log data recorded in the binary log file. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.log_end_time = log_end_time  # type: str
        # The name of the binary log file.
        self.log_file_name = log_file_name  # type: str
        # The status of the binary log file that is stored in the Object Storage Service (OSS) bucket. Valid values:
        # 
        # *   **Uploading**\
        # *   **Completed**\
        self.remote_status = remote_status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBinlogFilesResponseBodyItemsBinLogFile, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.checksum is not None:
            result['Checksum'] = self.checksum
        if self.download_link is not None:
            result['DownloadLink'] = self.download_link
        if self.file_size is not None:
            result['FileSize'] = self.file_size
        if self.host_instance_id is not None:
            result['HostInstanceID'] = self.host_instance_id
        if self.intranet_download_link is not None:
            result['IntranetDownloadLink'] = self.intranet_download_link
        if self.link_expired_time is not None:
            result['LinkExpiredTime'] = self.link_expired_time
        if self.log_begin_time is not None:
            result['LogBeginTime'] = self.log_begin_time
        if self.log_end_time is not None:
            result['LogEndTime'] = self.log_end_time
        if self.log_file_name is not None:
            result['LogFileName'] = self.log_file_name
        if self.remote_status is not None:
            result['RemoteStatus'] = self.remote_status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Checksum') is not None:
            self.checksum = m.get('Checksum')
        if m.get('DownloadLink') is not None:
            self.download_link = m.get('DownloadLink')
        if m.get('FileSize') is not None:
            self.file_size = m.get('FileSize')
        if m.get('HostInstanceID') is not None:
            self.host_instance_id = m.get('HostInstanceID')
        if m.get('IntranetDownloadLink') is not None:
            self.intranet_download_link = m.get('IntranetDownloadLink')
        if m.get('LinkExpiredTime') is not None:
            self.link_expired_time = m.get('LinkExpiredTime')
        if m.get('LogBeginTime') is not None:
            self.log_begin_time = m.get('LogBeginTime')
        if m.get('LogEndTime') is not None:
            self.log_end_time = m.get('LogEndTime')
        if m.get('LogFileName') is not None:
            self.log_file_name = m.get('LogFileName')
        if m.get('RemoteStatus') is not None:
            self.remote_status = m.get('RemoteStatus')
        return self


class DescribeBinlogFilesResponseBodyItems(TeaModel):
    def __init__(self, bin_log_file=None):
        self.bin_log_file = bin_log_file  # type: list[DescribeBinlogFilesResponseBodyItemsBinLogFile]

    def validate(self):
        if self.bin_log_file:
            for k in self.bin_log_file:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeBinlogFilesResponseBodyItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BinLogFile'] = []
        if self.bin_log_file is not None:
            for k in self.bin_log_file:
                result['BinLogFile'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.bin_log_file = []
        if m.get('BinLogFile') is not None:
            for k in m.get('BinLogFile'):
                temp_model = DescribeBinlogFilesResponseBodyItemsBinLogFile()
                self.bin_log_file.append(temp_model.from_map(k))
        return self


class DescribeBinlogFilesResponseBody(TeaModel):
    def __init__(self, items=None, page_number=None, page_record_count=None, request_id=None, total_file_size=None,
                 total_record_count=None):
        # An array that consists of information about the binary log file.
        self.items = items  # type: DescribeBinlogFilesResponseBodyItems
        # The page number of the returned page.
        self.page_number = page_number  # type: int
        # The number of binary log files returned on the current page.
        self.page_record_count = page_record_count  # type: int
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The total size of the binary log files.
        self.total_file_size = total_file_size  # type: long
        # The total number of binary log files returned.
        self.total_record_count = total_record_count  # type: int

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super(DescribeBinlogFilesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.items is not None:
            result['Items'] = self.items.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_record_count is not None:
            result['PageRecordCount'] = self.page_record_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_file_size is not None:
            result['TotalFileSize'] = self.total_file_size
        if self.total_record_count is not None:
            result['TotalRecordCount'] = self.total_record_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Items') is not None:
            temp_model = DescribeBinlogFilesResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageRecordCount') is not None:
            self.page_record_count = m.get('PageRecordCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalFileSize') is not None:
            self.total_file_size = m.get('TotalFileSize')
        if m.get('TotalRecordCount') is not None:
            self.total_record_count = m.get('TotalRecordCount')
        return self


class DescribeBinlogFilesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeBinlogFilesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeBinlogFilesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeBinlogFilesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCharacterSetNameRequest(TeaModel):
    def __init__(self, engine=None, owner_account=None, owner_id=None, region_id=None, resource_owner_account=None,
                 resource_owner_id=None):
        # The database engine that is run on the instance. Valid values:
        # 
        # *   **mysql**: MySQL
        # *   **mssql**: SQL Server
        # *   **PostgreSQL**: PostgreSQL
        # *   **MariaDB**: MariaDB
        self.engine = engine  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The region ID of the instance. You can call the [DescribeRegions](~~26243~~) operation to query the most recent region list.
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCharacterSetNameRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeCharacterSetNameResponseBodyCharacterSetNameItems(TeaModel):
    def __init__(self, character_set_name=None):
        self.character_set_name = character_set_name  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCharacterSetNameResponseBodyCharacterSetNameItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.character_set_name is not None:
            result['CharacterSetName'] = self.character_set_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CharacterSetName') is not None:
            self.character_set_name = m.get('CharacterSetName')
        return self


class DescribeCharacterSetNameResponseBody(TeaModel):
    def __init__(self, character_set_name_items=None, engine=None, request_id=None):
        # An array that consists of the character sets that are supported for the instance.
        self.character_set_name_items = character_set_name_items  # type: DescribeCharacterSetNameResponseBodyCharacterSetNameItems
        # The database engine that is run on the instance.
        self.engine = engine  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.character_set_name_items:
            self.character_set_name_items.validate()

    def to_map(self):
        _map = super(DescribeCharacterSetNameResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.character_set_name_items is not None:
            result['CharacterSetNameItems'] = self.character_set_name_items.to_map()
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CharacterSetNameItems') is not None:
            temp_model = DescribeCharacterSetNameResponseBodyCharacterSetNameItems()
            self.character_set_name_items = temp_model.from_map(m['CharacterSetNameItems'])
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeCharacterSetNameResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeCharacterSetNameResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCharacterSetNameResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCharacterSetNameResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCloudMigrationPrecheckResultRequest(TeaModel):
    def __init__(self, dbinstance_name=None, page_number=None, page_size=None, resource_owner_id=None,
                 source_ip_address=None, source_port=None, task_id=None, task_name=None):
        # The ID of the instance. You can call the [DescribeDBInstances](~~26232~~) operation to query the ID of the instance.
        self.dbinstance_name = dbinstance_name  # type: str
        # The number of the page to return.
        self.page_number = page_number  # type: long
        # The number of entries to return on each page.
        self.page_size = page_size  # type: long
        self.resource_owner_id = resource_owner_id  # type: long
        # The private or public IP address that is used to connect to the self-managed PostgreSQL instance.
        # 
        # *   If the self-managed PostgreSQL instance resides on an Elastic Compute Service (ECS) instance, enter the private IP address of the ECS instance. For more information, see [View IP addresses](~~273914~~).
        # *   If the self-managed PostgreSQL instance resides in an on-premises data center, enter the private IP address of the on-premises data center.
        # *   If the self-managed PostgreSQL instance resides on a device that is connected over the Internet, enter the public IP address of the device.
        self.source_ip_address = source_ip_address  # type: str
        # The port number that is used to connect to the self-managed PostgreSQL instance. You can run the netstat -a | grep PGSQL command to obtain the port number.
        self.source_port = source_port  # type: long
        # The ID of the cloud migration task. You can obtain the ID of the task from the response that is returned after you call the [CreateCloudMigrationPrecheckTask](~~409831~~) operation to create the task.
        self.task_id = task_id  # type: long
        # The name of the cloud migration task. You can obtain the name of the task from the response that is returned after you call the [CreateCloudMigrationPrecheckTask](~~409831~~) operation to create the task.
        self.task_name = task_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCloudMigrationPrecheckResultRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_name is not None:
            result['DBInstanceName'] = self.dbinstance_name
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.source_ip_address is not None:
            result['SourceIpAddress'] = self.source_ip_address
        if self.source_port is not None:
            result['SourcePort'] = self.source_port
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DBInstanceName') is not None:
            self.dbinstance_name = m.get('DBInstanceName')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SourceIpAddress') is not None:
            self.source_ip_address = m.get('SourceIpAddress')
        if m.get('SourcePort') is not None:
            self.source_port = m.get('SourcePort')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        return self


class DescribeCloudMigrationPrecheckResultResponseBodyItems(TeaModel):
    def __init__(self, detail=None, gmt_created=None, gmt_modified=None, source_account=None, source_category=None,
                 source_ip_address=None, source_password=None, source_port=None, target_eip=None, target_instance_name=None,
                 task_id=None, task_name=None):
        # The content of the assessment report.
        self.detail = detail  # type: str
        # The time when the task was created.
        self.gmt_created = gmt_created  # type: str
        # The time when the task was modified.
        self.gmt_modified = gmt_modified  # type: str
        # The username of the account.
        self.source_account = source_account  # type: str
        # The environment in which the self-managed PostgreSQL instance runs.
        # 
        # *   **idcOnVpc**: The self-managed PostgreSQL instance resides in an on-premises data center that can communicate with the virtual private cloud (VPC) in which the ApsaraDB RDS for PostgreSQL instance resides.
        # *   **ecsOnVpc**: The self-managed PostgreSQL instance resides on an ECS instance.
        # *   **internet**: The self-managed PostgreSQL instance resides on a device that is connected over the Internet.
        self.source_category = source_category  # type: str
        # The private public IP address that is used to connect to the self-managed PostgreSQL instance.
        self.source_ip_address = source_ip_address  # type: str
        # The password of the account.
        self.source_password = source_password  # type: str
        # The port number that is used to connect to the self-managed PostgreSQL instance.
        self.source_port = source_port  # type: long
        # A reserved parameter. The return value of this parameter is null.
        self.target_eip = target_eip  # type: str
        # The ID of the instance.
        self.target_instance_name = target_instance_name  # type: str
        # The ID of the cloud migration task.
        self.task_id = task_id  # type: long
        # The name of the cloud migration task.
        self.task_name = task_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCloudMigrationPrecheckResultResponseBodyItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.detail is not None:
            result['Detail'] = self.detail
        if self.gmt_created is not None:
            result['GmtCreated'] = self.gmt_created
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.source_account is not None:
            result['SourceAccount'] = self.source_account
        if self.source_category is not None:
            result['SourceCategory'] = self.source_category
        if self.source_ip_address is not None:
            result['SourceIpAddress'] = self.source_ip_address
        if self.source_password is not None:
            result['SourcePassword'] = self.source_password
        if self.source_port is not None:
            result['SourcePort'] = self.source_port
        if self.target_eip is not None:
            result['TargetEip'] = self.target_eip
        if self.target_instance_name is not None:
            result['TargetInstanceName'] = self.target_instance_name
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Detail') is not None:
            self.detail = m.get('Detail')
        if m.get('GmtCreated') is not None:
            self.gmt_created = m.get('GmtCreated')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('SourceAccount') is not None:
            self.source_account = m.get('SourceAccount')
        if m.get('SourceCategory') is not None:
            self.source_category = m.get('SourceCategory')
        if m.get('SourceIpAddress') is not None:
            self.source_ip_address = m.get('SourceIpAddress')
        if m.get('SourcePassword') is not None:
            self.source_password = m.get('SourcePassword')
        if m.get('SourcePort') is not None:
            self.source_port = m.get('SourcePort')
        if m.get('TargetEip') is not None:
            self.target_eip = m.get('TargetEip')
        if m.get('TargetInstanceName') is not None:
            self.target_instance_name = m.get('TargetInstanceName')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        return self


class DescribeCloudMigrationPrecheckResultResponseBody(TeaModel):
    def __init__(self, items=None, page_number=None, page_size=None, request_id=None, total_size=None):
        # Details of the assessment report.
        self.items = items  # type: list[DescribeCloudMigrationPrecheckResultResponseBodyItems]
        # The page number of the returned page.
        self.page_number = page_number  # type: long
        # The number of entries returned per page.
        self.page_size = page_size  # type: long
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The total number of entries.
        self.total_size = total_size  # type: int

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCloudMigrationPrecheckResultResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Items'] = []
        if self.items is not None:
            for k in self.items:
                result['Items'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_size is not None:
            result['TotalSize'] = self.total_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.items = []
        if m.get('Items') is not None:
            for k in m.get('Items'):
                temp_model = DescribeCloudMigrationPrecheckResultResponseBodyItems()
                self.items.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalSize') is not None:
            self.total_size = m.get('TotalSize')
        return self


class DescribeCloudMigrationPrecheckResultResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeCloudMigrationPrecheckResultResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCloudMigrationPrecheckResultResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCloudMigrationPrecheckResultResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCloudMigrationResultRequest(TeaModel):
    def __init__(self, dbinstance_name=None, page_number=None, page_size=None, resource_owner_id=None,
                 source_ip_address=None, source_port=None, task_id=None, task_name=None):
        # The ID of the instance. You can call the [DescribeDBInstances](~~26232~~) operation to query the ID of the instance.
        self.dbinstance_name = dbinstance_name  # type: str
        # The maximum number of entries to return on each page.
        self.page_number = page_number  # type: long
        # The number of the page to return.
        self.page_size = page_size  # type: long
        self.resource_owner_id = resource_owner_id  # type: long
        # The private IP address that is used to connect to the self-managed PostgreSQL instance.
        # 
        # *   If the self-managed PostgreSQL instance resides on an ECS instance, enter the private IP address of the ECS instance. For more information about how to obtain the private IP address of an ECS instance, see [View IP addresses](~~273914~~).
        # *   If the self-managed PostgreSQL instance resides in an on-premises data center, enter the private IP address of the on-premises data center.
        # *   If the self-managed PostgreSQL instance resides on a device that is connected over the Internet, enter the public IP address of the device.
        self.source_ip_address = source_ip_address  # type: str
        # The port number that is used to connect to the self-managed PostgreSQL instance. You can run the netstat -a | grep PGSQL command to obtain the port number.
        self.source_port = source_port  # type: long
        # The ID of the task. You can obtain the ID of a task from the response that is returned when you call the [CreateCloudMigrationTask](~~411690~~) operation to create the task.
        self.task_id = task_id  # type: long
        # The name of the task. You can obtain the name of a task from the response that is returned when you call the [CreateCloudMigrationTask](~~411690~~) operation to create the task.
        self.task_name = task_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCloudMigrationResultRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_name is not None:
            result['DBInstanceName'] = self.dbinstance_name
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.source_ip_address is not None:
            result['SourceIpAddress'] = self.source_ip_address
        if self.source_port is not None:
            result['SourcePort'] = self.source_port
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DBInstanceName') is not None:
            self.dbinstance_name = m.get('DBInstanceName')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SourceIpAddress') is not None:
            self.source_ip_address = m.get('SourceIpAddress')
        if m.get('SourcePort') is not None:
            self.source_port = m.get('SourcePort')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        return self


class DescribeCloudMigrationResultResponseBodyItems(TeaModel):
    def __init__(self, detail=None, gmt_created=None, gmt_modified=None, migrate_stage=None, replication_info=None,
                 replication_state=None, source_account=None, source_category=None, source_ip_address=None, source_password=None,
                 source_port=None, switch_time=None, target_eip=None, target_instance_name=None, task_id=None, task_name=None):
        # The details about the task.
        self.detail = detail  # type: str
        # The time when the task was created.
        self.gmt_created = gmt_created  # type: str
        # The time when the task was modified.
        self.gmt_modified = gmt_modified  # type: str
        # The migration phase in which the task stays.
        # 
        # *   **precheck**: precheck
        # *   **basebackup**: full data backup
        # *   **startup**: link establishment
        # *   **increment**: incremental data synchronization
        # *   **switch**: cloud migration-triggered switchover
        # *   **success**: cloud migration completed
        self.migrate_stage = migrate_stage  # type: str
        # The information about the replication link.
        self.replication_info = replication_info  # type: str
        # The status of data replication.
        # 
        # *   **unstarted**\
        # *   **catchup**\
        # *   **streaming**\
        # *   **disconnect**\
        # *   **finish**\
        self.replication_state = replication_state  # type: str
        # The username of the account.
        self.source_account = source_account  # type: str
        # The environment in which the self-managed PostgreSQL instance runs.
        # 
        # *   **idcOnVpc**: The self-managed PostgreSQL instance resides in a data center, which can communicate with the VPC to which the ApsaraDB RDS for PostgreSQL instance belongs.
        # *   **ecsOnVpc**: The self-managed PostgreSQL instance resides on an ECS instance.
        # *   **internet**: The self-managed PostgreSQL instance resides on a device that is connected over the Internet.
        self.source_category = source_category  # type: str
        # The private IP address that is used to connect to the self-managed PostgreSQL instance.
        self.source_ip_address = source_ip_address  # type: str
        # The password of the account.
        self.source_password = source_password  # type: str
        # The port number that is used to connect to the self-managed PostgreSQL instance.
        self.source_port = source_port  # type: long
        # The time when a switchover was performed.
        self.switch_time = switch_time  # type: str
        # A reserved parameter. The return value of this parameter is null.
        self.target_eip = target_eip  # type: str
        # The ID of the instance.
        self.target_instance_name = target_instance_name  # type: str
        # The ID of the task.
        self.task_id = task_id  # type: long
        # The name of the task.
        self.task_name = task_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCloudMigrationResultResponseBodyItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.detail is not None:
            result['Detail'] = self.detail
        if self.gmt_created is not None:
            result['GmtCreated'] = self.gmt_created
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.migrate_stage is not None:
            result['MigrateStage'] = self.migrate_stage
        if self.replication_info is not None:
            result['ReplicationInfo'] = self.replication_info
        if self.replication_state is not None:
            result['ReplicationState'] = self.replication_state
        if self.source_account is not None:
            result['SourceAccount'] = self.source_account
        if self.source_category is not None:
            result['SourceCategory'] = self.source_category
        if self.source_ip_address is not None:
            result['SourceIpAddress'] = self.source_ip_address
        if self.source_password is not None:
            result['SourcePassword'] = self.source_password
        if self.source_port is not None:
            result['SourcePort'] = self.source_port
        if self.switch_time is not None:
            result['SwitchTime'] = self.switch_time
        if self.target_eip is not None:
            result['TargetEip'] = self.target_eip
        if self.target_instance_name is not None:
            result['TargetInstanceName'] = self.target_instance_name
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Detail') is not None:
            self.detail = m.get('Detail')
        if m.get('GmtCreated') is not None:
            self.gmt_created = m.get('GmtCreated')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('MigrateStage') is not None:
            self.migrate_stage = m.get('MigrateStage')
        if m.get('ReplicationInfo') is not None:
            self.replication_info = m.get('ReplicationInfo')
        if m.get('ReplicationState') is not None:
            self.replication_state = m.get('ReplicationState')
        if m.get('SourceAccount') is not None:
            self.source_account = m.get('SourceAccount')
        if m.get('SourceCategory') is not None:
            self.source_category = m.get('SourceCategory')
        if m.get('SourceIpAddress') is not None:
            self.source_ip_address = m.get('SourceIpAddress')
        if m.get('SourcePassword') is not None:
            self.source_password = m.get('SourcePassword')
        if m.get('SourcePort') is not None:
            self.source_port = m.get('SourcePort')
        if m.get('SwitchTime') is not None:
            self.switch_time = m.get('SwitchTime')
        if m.get('TargetEip') is not None:
            self.target_eip = m.get('TargetEip')
        if m.get('TargetInstanceName') is not None:
            self.target_instance_name = m.get('TargetInstanceName')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        return self


class DescribeCloudMigrationResultResponseBody(TeaModel):
    def __init__(self, items=None, page_number=None, page_size=None, request_id=None, total_size=None):
        # An array that consists of the details about the cloud migration task.
        self.items = items  # type: list[DescribeCloudMigrationResultResponseBodyItems]
        # The number of returned pages.
        self.page_number = page_number  # type: long
        # The number of entries returned on each page.
        self.page_size = page_size  # type: long
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The total number of entries.
        self.total_size = total_size  # type: int

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCloudMigrationResultResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Items'] = []
        if self.items is not None:
            for k in self.items:
                result['Items'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_size is not None:
            result['TotalSize'] = self.total_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.items = []
        if m.get('Items') is not None:
            for k in m.get('Items'):
                temp_model = DescribeCloudMigrationResultResponseBodyItems()
                self.items.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalSize') is not None:
            self.total_size = m.get('TotalSize')
        return self


class DescribeCloudMigrationResultResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeCloudMigrationResultResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCloudMigrationResultResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCloudMigrationResultResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCollationTimeZonesRequest(TeaModel):
    def __init__(self, owner_id=None, resource_owner_account=None, resource_owner_id=None):
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCollationTimeZonesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeCollationTimeZonesResponseBodyCollationTimeZonesCollationTimeZone(TeaModel):
    def __init__(self, description=None, standard_time_offset=None, time_zone=None):
        # The description of the character set collations and time zones.
        self.description = description  # type: str
        # The offset of the UTC time. The offset is in the following format: (UTC+\<i>HH:mm\</i>).
        self.standard_time_offset = standard_time_offset  # type: str
        # The time zone that is available for use in ApsaraDB RDS.
        self.time_zone = time_zone  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCollationTimeZonesResponseBodyCollationTimeZonesCollationTimeZone, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.standard_time_offset is not None:
            result['StandardTimeOffset'] = self.standard_time_offset
        if self.time_zone is not None:
            result['TimeZone'] = self.time_zone
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('StandardTimeOffset') is not None:
            self.standard_time_offset = m.get('StandardTimeOffset')
        if m.get('TimeZone') is not None:
            self.time_zone = m.get('TimeZone')
        return self


class DescribeCollationTimeZonesResponseBodyCollationTimeZones(TeaModel):
    def __init__(self, collation_time_zone=None):
        self.collation_time_zone = collation_time_zone  # type: list[DescribeCollationTimeZonesResponseBodyCollationTimeZonesCollationTimeZone]

    def validate(self):
        if self.collation_time_zone:
            for k in self.collation_time_zone:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCollationTimeZonesResponseBodyCollationTimeZones, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CollationTimeZone'] = []
        if self.collation_time_zone is not None:
            for k in self.collation_time_zone:
                result['CollationTimeZone'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.collation_time_zone = []
        if m.get('CollationTimeZone') is not None:
            for k in m.get('CollationTimeZone'):
                temp_model = DescribeCollationTimeZonesResponseBodyCollationTimeZonesCollationTimeZone()
                self.collation_time_zone.append(temp_model.from_map(k))
        return self


class DescribeCollationTimeZonesResponseBody(TeaModel):
    def __init__(self, collation_time_zones=None, request_id=None):
        # An array that consists of the character set collations and time zones that are available for use in ApsaraDB RDS.
        self.collation_time_zones = collation_time_zones  # type: DescribeCollationTimeZonesResponseBodyCollationTimeZones
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.collation_time_zones:
            self.collation_time_zones.validate()

    def to_map(self):
        _map = super(DescribeCollationTimeZonesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.collation_time_zones is not None:
            result['CollationTimeZones'] = self.collation_time_zones.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CollationTimeZones') is not None:
            temp_model = DescribeCollationTimeZonesResponseBodyCollationTimeZones()
            self.collation_time_zones = temp_model.from_map(m['CollationTimeZones'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeCollationTimeZonesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeCollationTimeZonesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCollationTimeZonesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCollationTimeZonesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCrossBackupMetaListRequest(TeaModel):
    def __init__(self, backup_set_id=None, get_db_name=None, owner_id=None, page_index=None, page_size=None,
                 pattern=None, region=None, resource_group_id=None, resource_owner_account=None, resource_owner_id=None):
        # The ID of the cross-region backup file that you want to use. You can call the [DescribeCrossRegionBackups](~~121733~~) operation to query the ID of the cross-region backup file.
        self.backup_set_id = backup_set_id  # type: str
        # The name of the database to query. The system implements exact match based on the value of this parameter and returns the name of the matched database and the names of the tables in the matched database.
        self.get_db_name = get_db_name  # type: str
        self.owner_id = owner_id  # type: long
        # The number of the page to return. Valid values: any non-zero positive integer.
        # 
        # >  This parameter is valid only when you specify the **PageSize** parameter.
        self.page_index = page_index  # type: str
        # The number of entries to return on each page. Default value: **1**.
        # 
        # >  This parameter is valid only when you specify the **PageIndex** parameter.
        self.page_size = page_size  # type: str
        # The name of the database to query. The system implements fuzzy match based on the value of this parameter and returns only the name of the matched database.
        # 
        # >  You can implement fuzzy match and then exact match. For example, you can set the Pattern parameter to test to query the testdb1 and testdb2 databases. Then, you can specify the **GetDbName** parameter to query only the matched database and the tables in the matched database.
        self.pattern = pattern  # type: str
        # The region ID of the instance.
        self.region = region  # type: str
        # The ID of the resource group.
        self.resource_group_id = resource_group_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCrossBackupMetaListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_set_id is not None:
            result['BackupSetId'] = self.backup_set_id
        if self.get_db_name is not None:
            result['GetDbName'] = self.get_db_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_index is not None:
            result['PageIndex'] = self.page_index
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.pattern is not None:
            result['Pattern'] = self.pattern
        if self.region is not None:
            result['Region'] = self.region
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BackupSetId') is not None:
            self.backup_set_id = m.get('BackupSetId')
        if m.get('GetDbName') is not None:
            self.get_db_name = m.get('GetDbName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageIndex') is not None:
            self.page_index = m.get('PageIndex')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Pattern') is not None:
            self.pattern = m.get('Pattern')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeCrossBackupMetaListResponseBodyItemsMeta(TeaModel):
    def __init__(self, database=None, size=None, tables=None):
        # The name of the database.
        self.database = database  # type: str
        # The size of the table. Unit: KB. If the database contains more than one table, the names of these tables are separated by commas (,).
        self.size = size  # type: str
        # An array that consists of the names of the tables that the database contains. If the database contains more than one table, the names of these tables are separated by commas (,).
        self.tables = tables  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCrossBackupMetaListResponseBodyItemsMeta, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.database is not None:
            result['Database'] = self.database
        if self.size is not None:
            result['Size'] = self.size
        if self.tables is not None:
            result['Tables'] = self.tables
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Database') is not None:
            self.database = m.get('Database')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('Tables') is not None:
            self.tables = m.get('Tables')
        return self


class DescribeCrossBackupMetaListResponseBodyItems(TeaModel):
    def __init__(self, meta=None):
        self.meta = meta  # type: list[DescribeCrossBackupMetaListResponseBodyItemsMeta]

    def validate(self):
        if self.meta:
            for k in self.meta:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCrossBackupMetaListResponseBodyItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Meta'] = []
        if self.meta is not None:
            for k in self.meta:
                result['Meta'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.meta = []
        if m.get('Meta') is not None:
            for k in m.get('Meta'):
                temp_model = DescribeCrossBackupMetaListResponseBodyItemsMeta()
                self.meta.append(temp_model.from_map(k))
        return self


class DescribeCrossBackupMetaListResponseBody(TeaModel):
    def __init__(self, dbinstance_name=None, items=None, page_number=None, page_record_count=None, request_id=None,
                 total_page_count=None, total_record_count=None):
        # The instance to which the cross-region backup file belongs.
        self.dbinstance_name = dbinstance_name  # type: str
        # An array that consists of the information about the databases and tables whose data is included in the cross-region backup file.
        self.items = items  # type: DescribeCrossBackupMetaListResponseBodyItems
        # The page number of the returned page.
        self.page_number = page_number  # type: int
        # The number of entries returned on the current page.
        self.page_record_count = page_record_count  # type: int
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The total number of returned pages.
        self.total_page_count = total_page_count  # type: int
        # The total number of entries returned.
        self.total_record_count = total_record_count  # type: int

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super(DescribeCrossBackupMetaListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_name is not None:
            result['DBInstanceName'] = self.dbinstance_name
        if self.items is not None:
            result['Items'] = self.items.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_record_count is not None:
            result['PageRecordCount'] = self.page_record_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_page_count is not None:
            result['TotalPageCount'] = self.total_page_count
        if self.total_record_count is not None:
            result['TotalRecordCount'] = self.total_record_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DBInstanceName') is not None:
            self.dbinstance_name = m.get('DBInstanceName')
        if m.get('Items') is not None:
            temp_model = DescribeCrossBackupMetaListResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageRecordCount') is not None:
            self.page_record_count = m.get('PageRecordCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalPageCount') is not None:
            self.total_page_count = m.get('TotalPageCount')
        if m.get('TotalRecordCount') is not None:
            self.total_record_count = m.get('TotalRecordCount')
        return self


class DescribeCrossBackupMetaListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeCrossBackupMetaListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCrossBackupMetaListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCrossBackupMetaListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCrossRegionBackupDBInstanceRequest(TeaModel):
    def __init__(self, dbinstance_id=None, owner_id=None, page_number=None, page_size=None, region_id=None,
                 resource_owner_account=None, resource_owner_id=None):
        # The ID of the instance. Up to 30 instance IDs are allowed in a single request. If you enter more than one instance ID, separate them with commas (,).
        self.dbinstance_id = dbinstance_id  # type: str
        self.owner_id = owner_id  # type: long
        # The number of the page to return. Valid values: any non-zero positive integer.
        # 
        # Default value: **1**.
        self.page_number = page_number  # type: int
        # The number of entries to return per page. Default value: 30.
        self.page_size = page_size  # type: int
        # The ID of the region.
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCrossRegionBackupDBInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeCrossRegionBackupDBInstanceResponseBodyItemsItem(TeaModel):
    def __init__(self, backup_enabled=None, backup_enabled_time=None, cross_backup_region=None,
                 cross_backup_type=None, dbinstance_description=None, dbinstance_id=None, dbinstance_status=None, engine=None,
                 engine_version=None, lock_mode=None, log_backup_enabled=None, log_backup_enabled_time=None, retent_type=None,
                 retention=None):
        # The status of the cross-region backup feature on the instance. Valid values:
        # 
        # *   **Disable**\
        # *   **Enable**\
        self.backup_enabled = backup_enabled  # type: str
        # The time when cross-region backup was enabled on the instance. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.backup_enabled_time = backup_enabled_time  # type: str
        # The ID of the region in which the cross-region data backup file is stored.
        self.cross_backup_region = cross_backup_region  # type: str
        # The policy that is used to save the cross-region backup files of the instance. Default value: **1**. The value 1 indicates that all cross-region backup files are saved.
        self.cross_backup_type = cross_backup_type  # type: str
        # The name of the instance. It must be 2 to 256 characters in length. The name can contain letters, digits, underscores (\_), and hyphens (-). The name must start with a letter.
        # 
        # > The value cannot start with http:// or https://.
        self.dbinstance_description = dbinstance_description  # type: str
        # The ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        # The status of the instance. For more information, see [Instance states](~~26315~~).
        self.dbinstance_status = dbinstance_status  # type: str
        # The database engine of the instance.
        self.engine = engine  # type: str
        # The database engine version of the instance.
        self.engine_version = engine_version  # type: str
        # The lock status of the instance. Valid values:
        # 
        # *   **Unlock**: The instance is not locked.
        # *   **ManualLock**: The instance is manually locked.
        # *   **LockByExpiration**: The instance is automatically locked after it expires.
        # *   **LockByRestoration**: The instance is automatically locked before it is rolled back.
        # *   **LockByDiskQuota**: The instance is automatically locked because its storage capacity is exhausted and the instance is inaccessible.
        self.lock_mode = lock_mode  # type: str
        # The status of the cross-region log backup feature on the instance. Valid values:
        # 
        # *   **Disable**\
        # *   **Enable**\
        self.log_backup_enabled = log_backup_enabled  # type: str
        # The time when cross-region log backup was enabled on the instance. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.log_backup_enabled_time = log_backup_enabled_time  # type: str
        # The policy that is used to retain the cross-region backup files of the instance. Cross-region backups can be retained only based on the specified retention period. Default value: **1**.
        self.retent_type = retent_type  # type: int
        # The number of days for which the cross-region backup files of the instance are retained. Valid values: **7 to 1825**.
        self.retention = retention  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCrossRegionBackupDBInstanceResponseBodyItemsItem, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_enabled is not None:
            result['BackupEnabled'] = self.backup_enabled
        if self.backup_enabled_time is not None:
            result['BackupEnabledTime'] = self.backup_enabled_time
        if self.cross_backup_region is not None:
            result['CrossBackupRegion'] = self.cross_backup_region
        if self.cross_backup_type is not None:
            result['CrossBackupType'] = self.cross_backup_type
        if self.dbinstance_description is not None:
            result['DBInstanceDescription'] = self.dbinstance_description
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dbinstance_status is not None:
            result['DBInstanceStatus'] = self.dbinstance_status
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.engine_version is not None:
            result['EngineVersion'] = self.engine_version
        if self.lock_mode is not None:
            result['LockMode'] = self.lock_mode
        if self.log_backup_enabled is not None:
            result['LogBackupEnabled'] = self.log_backup_enabled
        if self.log_backup_enabled_time is not None:
            result['LogBackupEnabledTime'] = self.log_backup_enabled_time
        if self.retent_type is not None:
            result['RetentType'] = self.retent_type
        if self.retention is not None:
            result['Retention'] = self.retention
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BackupEnabled') is not None:
            self.backup_enabled = m.get('BackupEnabled')
        if m.get('BackupEnabledTime') is not None:
            self.backup_enabled_time = m.get('BackupEnabledTime')
        if m.get('CrossBackupRegion') is not None:
            self.cross_backup_region = m.get('CrossBackupRegion')
        if m.get('CrossBackupType') is not None:
            self.cross_backup_type = m.get('CrossBackupType')
        if m.get('DBInstanceDescription') is not None:
            self.dbinstance_description = m.get('DBInstanceDescription')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DBInstanceStatus') is not None:
            self.dbinstance_status = m.get('DBInstanceStatus')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('EngineVersion') is not None:
            self.engine_version = m.get('EngineVersion')
        if m.get('LockMode') is not None:
            self.lock_mode = m.get('LockMode')
        if m.get('LogBackupEnabled') is not None:
            self.log_backup_enabled = m.get('LogBackupEnabled')
        if m.get('LogBackupEnabledTime') is not None:
            self.log_backup_enabled_time = m.get('LogBackupEnabledTime')
        if m.get('RetentType') is not None:
            self.retent_type = m.get('RetentType')
        if m.get('Retention') is not None:
            self.retention = m.get('Retention')
        return self


class DescribeCrossRegionBackupDBInstanceResponseBodyItems(TeaModel):
    def __init__(self, item=None):
        self.item = item  # type: list[DescribeCrossRegionBackupDBInstanceResponseBodyItemsItem]

    def validate(self):
        if self.item:
            for k in self.item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCrossRegionBackupDBInstanceResponseBodyItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Item'] = []
        if self.item is not None:
            for k in self.item:
                result['Item'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.item = []
        if m.get('Item') is not None:
            for k in m.get('Item'):
                temp_model = DescribeCrossRegionBackupDBInstanceResponseBodyItemsItem()
                self.item.append(temp_model.from_map(k))
        return self


class DescribeCrossRegionBackupDBInstanceResponseBody(TeaModel):
    def __init__(self, items=None, items_numbers=None, page_number=None, page_size=None, region_id=None,
                 request_id=None, total_records=None):
        # An array that consists of instances and their cross-region backup settings.
        self.items = items  # type: DescribeCrossRegionBackupDBInstanceResponseBodyItems
        # The total number of items returned for cross-region backup settings.
        self.items_numbers = items_numbers  # type: int
        # The page number of the returned page. Valid values: any non-zero positive integer.
        # 
        # Default value: **1**.
        self.page_number = page_number  # type: int
        # The number of entries returned per page. Default value: 30.
        self.page_size = page_size  # type: int
        # The ID of the region.
        self.region_id = region_id  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The total number of returned entries.
        self.total_records = total_records  # type: int

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super(DescribeCrossRegionBackupDBInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.items is not None:
            result['Items'] = self.items.to_map()
        if self.items_numbers is not None:
            result['ItemsNumbers'] = self.items_numbers
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_records is not None:
            result['TotalRecords'] = self.total_records
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Items') is not None:
            temp_model = DescribeCrossRegionBackupDBInstanceResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        if m.get('ItemsNumbers') is not None:
            self.items_numbers = m.get('ItemsNumbers')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalRecords') is not None:
            self.total_records = m.get('TotalRecords')
        return self


class DescribeCrossRegionBackupDBInstanceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeCrossRegionBackupDBInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCrossRegionBackupDBInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCrossRegionBackupDBInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCrossRegionBackupsRequest(TeaModel):
    def __init__(self, backup_id=None, cross_backup_id=None, cross_backup_region=None, dbinstance_id=None,
                 end_time=None, owner_id=None, page_number=None, page_size=None, region_id=None, resource_group_id=None,
                 resource_owner_account=None, resource_owner_id=None, start_time=None):
        # The ID of the cross-region data backup file.
        self.backup_id = backup_id  # type: int
        # The ID of the cross-region data backup file.
        # 
        # >  You must specify the **CrossBackupId** parameter. Alternatively, you must specify the **StartTime** and **EndTime** parameters.
        self.cross_backup_id = cross_backup_id  # type: int
        # The ID of the destination region where the cross-region data backup file is stored.
        self.cross_backup_region = cross_backup_region  # type: str
        # The ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        # The end of the time range to query. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time must be in UTC.
        self.end_time = end_time  # type: str
        self.owner_id = owner_id  # type: long
        # The number of the page to return. Valid values: any non-zero positive integer.
        # 
        # Default value: **1**.
        self.page_number = page_number  # type: int
        # The number of entries to return on each page. Valid values:
        # 
        # *   **30**\
        # *   **50**\
        # *   **100**\
        # 
        # Default value: 30.
        self.page_size = page_size  # type: int
        # The region ID of the instance.
        self.region_id = region_id  # type: str
        # The ID of the resource group.
        self.resource_group_id = resource_group_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The beginning of the time range to query. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time must be in UTC.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCrossRegionBackupsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_id is not None:
            result['BackupId'] = self.backup_id
        if self.cross_backup_id is not None:
            result['CrossBackupId'] = self.cross_backup_id
        if self.cross_backup_region is not None:
            result['CrossBackupRegion'] = self.cross_backup_region
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BackupId') is not None:
            self.backup_id = m.get('BackupId')
        if m.get('CrossBackupId') is not None:
            self.cross_backup_id = m.get('CrossBackupId')
        if m.get('CrossBackupRegion') is not None:
            self.cross_backup_region = m.get('CrossBackupRegion')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeCrossRegionBackupsResponseBodyItemsItemRestoreRegions(TeaModel):
    def __init__(self, restore_region=None):
        self.restore_region = restore_region  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCrossRegionBackupsResponseBodyItemsItemRestoreRegions, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.restore_region is not None:
            result['RestoreRegion'] = self.restore_region
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RestoreRegion') is not None:
            self.restore_region = m.get('RestoreRegion')
        return self


class DescribeCrossRegionBackupsResponseBodyItemsItem(TeaModel):
    def __init__(self, backup_end_time=None, backup_method=None, backup_set_scale=None, backup_set_status=None,
                 backup_start_time=None, backup_type=None, category=None, consistent_time=None, cross_backup_download_link=None,
                 cross_backup_id=None, cross_backup_region=None, cross_backup_set_file=None, cross_backup_set_location=None,
                 cross_backup_set_size=None, dbinstance_storage_type=None, engine=None, engine_version=None, instance_id=None,
                 restore_regions=None):
        # The time when the cross-region data backup file was generated.
        self.backup_end_time = backup_end_time  # type: str
        # The method that is used to generate the cross-region data backup file. Valid values:
        # 
        # *   **L**: logical backup
        # *   **P**: physical backup
        self.backup_method = backup_method  # type: str
        # The level at which the cross-region data backup file is generated.
        # 
        # *   **0**: instance-level backup
        # *   **1**: database-level backup
        self.backup_set_scale = backup_set_scale  # type: int
        # The status of the cross-region data backup. Valid values:
        # 
        # *   **0**: The cross-region data backup is successful.
        # *   **1**: The cross-region data backup failed.
        self.backup_set_status = backup_set_status  # type: int
        # The time when the cross-region data backup started.
        self.backup_start_time = backup_start_time  # type: str
        # The type of the cross-region data backup. Valid values:
        # 
        # *   **F**: full data backup
        # *   **I**: incremental data backup
        self.backup_type = backup_type  # type: str
        # The RDS edition of the instance. Valid values:
        # 
        # *   **Basic**: Basic Edition.
        # *   **HighAvailability**: High-availability Edition.
        # *   **Finance**: Enterprise Edition. This edition is supported only by the China site (aliyun.com).
        self.category = category  # type: str
        # The point in time that is indicated by the data in the cross-region data backup file.
        self.consistent_time = consistent_time  # type: str
        # The external URL from which you can download the cross-region data backup file.
        self.cross_backup_download_link = cross_backup_download_link  # type: str
        # The ID of the cross-region data backup file.
        self.cross_backup_id = cross_backup_id  # type: int
        # The ID of the destination region where the cross-region data backup file of the instance is stored.
        self.cross_backup_region = cross_backup_region  # type: str
        # The name of the compressed package that contains the cross-region data backup file.
        self.cross_backup_set_file = cross_backup_set_file  # type: str
        # The location where the cross-region data backup file is stored.
        self.cross_backup_set_location = cross_backup_set_location  # type: str
        # The size of the cross-region data backup file. Unit: bytes.
        self.cross_backup_set_size = cross_backup_set_size  # type: long
        # The storage type. Valid values:
        # 
        # *   **local_ssd**: local SSD. This is the recommended storage type.
        # *   **cloud_ssd**: standard SSD.
        # *   **cloud_essd**: enhanced SSD (ESSD).
        self.dbinstance_storage_type = dbinstance_storage_type  # type: str
        # The engine of the database.
        self.engine = engine  # type: str
        # The version of the database engine.
        self.engine_version = engine_version  # type: str
        # The ID of the instance. This parameter is used to determine whether the instance that generates the cross-region data backup file is a primary or secondary instance.
        self.instance_id = instance_id  # type: int
        # An array that consists of the regions to which the cross-region data backup file can be restored.
        self.restore_regions = restore_regions  # type: DescribeCrossRegionBackupsResponseBodyItemsItemRestoreRegions

    def validate(self):
        if self.restore_regions:
            self.restore_regions.validate()

    def to_map(self):
        _map = super(DescribeCrossRegionBackupsResponseBodyItemsItem, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_end_time is not None:
            result['BackupEndTime'] = self.backup_end_time
        if self.backup_method is not None:
            result['BackupMethod'] = self.backup_method
        if self.backup_set_scale is not None:
            result['BackupSetScale'] = self.backup_set_scale
        if self.backup_set_status is not None:
            result['BackupSetStatus'] = self.backup_set_status
        if self.backup_start_time is not None:
            result['BackupStartTime'] = self.backup_start_time
        if self.backup_type is not None:
            result['BackupType'] = self.backup_type
        if self.category is not None:
            result['Category'] = self.category
        if self.consistent_time is not None:
            result['ConsistentTime'] = self.consistent_time
        if self.cross_backup_download_link is not None:
            result['CrossBackupDownloadLink'] = self.cross_backup_download_link
        if self.cross_backup_id is not None:
            result['CrossBackupId'] = self.cross_backup_id
        if self.cross_backup_region is not None:
            result['CrossBackupRegion'] = self.cross_backup_region
        if self.cross_backup_set_file is not None:
            result['CrossBackupSetFile'] = self.cross_backup_set_file
        if self.cross_backup_set_location is not None:
            result['CrossBackupSetLocation'] = self.cross_backup_set_location
        if self.cross_backup_set_size is not None:
            result['CrossBackupSetSize'] = self.cross_backup_set_size
        if self.dbinstance_storage_type is not None:
            result['DBInstanceStorageType'] = self.dbinstance_storage_type
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.engine_version is not None:
            result['EngineVersion'] = self.engine_version
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.restore_regions is not None:
            result['RestoreRegions'] = self.restore_regions.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BackupEndTime') is not None:
            self.backup_end_time = m.get('BackupEndTime')
        if m.get('BackupMethod') is not None:
            self.backup_method = m.get('BackupMethod')
        if m.get('BackupSetScale') is not None:
            self.backup_set_scale = m.get('BackupSetScale')
        if m.get('BackupSetStatus') is not None:
            self.backup_set_status = m.get('BackupSetStatus')
        if m.get('BackupStartTime') is not None:
            self.backup_start_time = m.get('BackupStartTime')
        if m.get('BackupType') is not None:
            self.backup_type = m.get('BackupType')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('ConsistentTime') is not None:
            self.consistent_time = m.get('ConsistentTime')
        if m.get('CrossBackupDownloadLink') is not None:
            self.cross_backup_download_link = m.get('CrossBackupDownloadLink')
        if m.get('CrossBackupId') is not None:
            self.cross_backup_id = m.get('CrossBackupId')
        if m.get('CrossBackupRegion') is not None:
            self.cross_backup_region = m.get('CrossBackupRegion')
        if m.get('CrossBackupSetFile') is not None:
            self.cross_backup_set_file = m.get('CrossBackupSetFile')
        if m.get('CrossBackupSetLocation') is not None:
            self.cross_backup_set_location = m.get('CrossBackupSetLocation')
        if m.get('CrossBackupSetSize') is not None:
            self.cross_backup_set_size = m.get('CrossBackupSetSize')
        if m.get('DBInstanceStorageType') is not None:
            self.dbinstance_storage_type = m.get('DBInstanceStorageType')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('EngineVersion') is not None:
            self.engine_version = m.get('EngineVersion')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RestoreRegions') is not None:
            temp_model = DescribeCrossRegionBackupsResponseBodyItemsItemRestoreRegions()
            self.restore_regions = temp_model.from_map(m['RestoreRegions'])
        return self


class DescribeCrossRegionBackupsResponseBodyItems(TeaModel):
    def __init__(self, item=None):
        self.item = item  # type: list[DescribeCrossRegionBackupsResponseBodyItemsItem]

    def validate(self):
        if self.item:
            for k in self.item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCrossRegionBackupsResponseBodyItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Item'] = []
        if self.item is not None:
            for k in self.item:
                result['Item'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.item = []
        if m.get('Item') is not None:
            for k in m.get('Item'):
                temp_model = DescribeCrossRegionBackupsResponseBodyItemsItem()
                self.item.append(temp_model.from_map(k))
        return self


class DescribeCrossRegionBackupsResponseBody(TeaModel):
    def __init__(self, end_time=None, items=None, page_number=None, page_record_count=None, region_id=None,
                 request_id=None, start_time=None, total_record_count=None):
        # The end of the time range that is queried.
        self.end_time = end_time  # type: str
        # An array that consists of details of the cross-region data backup files.
        self.items = items  # type: DescribeCrossRegionBackupsResponseBodyItems
        # The page number of the returned page. Valid values: any non-zero positive integer.
        # 
        # Default value: **1**.
        self.page_number = page_number  # type: int
        # The number of cross-region data backup files on the current page.
        self.page_record_count = page_record_count  # type: int
        # The region ID of the instance.
        self.region_id = region_id  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The beginning of the time range that is queried.
        self.start_time = start_time  # type: str
        # The total number of entries returned.
        self.total_record_count = total_record_count  # type: int

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super(DescribeCrossRegionBackupsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.items is not None:
            result['Items'] = self.items.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_record_count is not None:
            result['PageRecordCount'] = self.page_record_count
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.total_record_count is not None:
            result['TotalRecordCount'] = self.total_record_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Items') is not None:
            temp_model = DescribeCrossRegionBackupsResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageRecordCount') is not None:
            self.page_record_count = m.get('PageRecordCount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TotalRecordCount') is not None:
            self.total_record_count = m.get('TotalRecordCount')
        return self


class DescribeCrossRegionBackupsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeCrossRegionBackupsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCrossRegionBackupsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCrossRegionBackupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCrossRegionLogBackupFilesRequest(TeaModel):
    def __init__(self, cross_backup_region=None, dbinstance_id=None, end_time=None, owner_id=None, page_number=None,
                 page_size=None, region_id=None, resource_owner_account=None, resource_owner_id=None, start_time=None):
        # The ID of the destination region where the cross-region backup files of the instance are stored. You can call the [DescribeCrossRegionBackupDBInstance](~~121737~~) operation to query the most recent region list.
        self.cross_backup_region = cross_backup_region  # type: str
        # The ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        # The end of the time range to query. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time must be in UTC.
        self.end_time = end_time  # type: str
        self.owner_id = owner_id  # type: long
        # The number of the page to return. Pages start from page 1.
        # 
        # Default value: **1**.
        self.page_number = page_number  # type: int
        # The number of entries to return on each page. Valid values:
        # 
        # *   **30**\
        # *   **50**\
        # *   **100**\
        # 
        # Default value: 30.
        self.page_size = page_size  # type: int
        # The region ID of the instance. You can call the [DescribeRegions](~~26243~~) operation to query the most recent region list.
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The beginning of the time range to query. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time must be in UTC.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCrossRegionLogBackupFilesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cross_backup_region is not None:
            result['CrossBackupRegion'] = self.cross_backup_region
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CrossBackupRegion') is not None:
            self.cross_backup_region = m.get('CrossBackupRegion')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeCrossRegionLogBackupFilesResponseBodyItemsItem(TeaModel):
    def __init__(self, cross_backup_region=None, cross_download_link=None, cross_intranet_download_link=None,
                 cross_log_backup_id=None, cross_log_backup_size=None, instance_id=None, link_expired_time=None, log_begin_time=None,
                 log_end_time=None, log_file_name=None):
        # The ID of the destination region where the cross-region log backup file is stored.
        self.cross_backup_region = cross_backup_region  # type: str
        # The external URL from which you can download the cross-region log backup file.
        self.cross_download_link = cross_download_link  # type: str
        # The internal URL from which you can download the cross-region log backup file.
        self.cross_intranet_download_link = cross_intranet_download_link  # type: str
        # The ID of the cross-region log backup file.
        self.cross_log_backup_id = cross_log_backup_id  # type: int
        # The size of the cross-region log backup file. Unit: bytes.
        self.cross_log_backup_size = cross_log_backup_size  # type: long
        # The ID of the instance.
        self.instance_id = instance_id  # type: int
        # The time when the download URL of the cross-region log backup file expires. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*hh:mm:ss*Z format. The time is displayed in UTC.
        self.link_expired_time = link_expired_time  # type: str
        # The start time of the cross-region log backup file. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*hh:mm:ss*Z format. The time is displayed in UTC.
        self.log_begin_time = log_begin_time  # type: str
        # The end time of the cross-region log backup file. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*hh:mm:ss*Z format. The time is displayed in UTC.
        self.log_end_time = log_end_time  # type: str
        # The name of the cross-region log backup file.
        self.log_file_name = log_file_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCrossRegionLogBackupFilesResponseBodyItemsItem, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cross_backup_region is not None:
            result['CrossBackupRegion'] = self.cross_backup_region
        if self.cross_download_link is not None:
            result['CrossDownloadLink'] = self.cross_download_link
        if self.cross_intranet_download_link is not None:
            result['CrossIntranetDownloadLink'] = self.cross_intranet_download_link
        if self.cross_log_backup_id is not None:
            result['CrossLogBackupId'] = self.cross_log_backup_id
        if self.cross_log_backup_size is not None:
            result['CrossLogBackupSize'] = self.cross_log_backup_size
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.link_expired_time is not None:
            result['LinkExpiredTime'] = self.link_expired_time
        if self.log_begin_time is not None:
            result['LogBeginTime'] = self.log_begin_time
        if self.log_end_time is not None:
            result['LogEndTime'] = self.log_end_time
        if self.log_file_name is not None:
            result['LogFileName'] = self.log_file_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CrossBackupRegion') is not None:
            self.cross_backup_region = m.get('CrossBackupRegion')
        if m.get('CrossDownloadLink') is not None:
            self.cross_download_link = m.get('CrossDownloadLink')
        if m.get('CrossIntranetDownloadLink') is not None:
            self.cross_intranet_download_link = m.get('CrossIntranetDownloadLink')
        if m.get('CrossLogBackupId') is not None:
            self.cross_log_backup_id = m.get('CrossLogBackupId')
        if m.get('CrossLogBackupSize') is not None:
            self.cross_log_backup_size = m.get('CrossLogBackupSize')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('LinkExpiredTime') is not None:
            self.link_expired_time = m.get('LinkExpiredTime')
        if m.get('LogBeginTime') is not None:
            self.log_begin_time = m.get('LogBeginTime')
        if m.get('LogEndTime') is not None:
            self.log_end_time = m.get('LogEndTime')
        if m.get('LogFileName') is not None:
            self.log_file_name = m.get('LogFileName')
        return self


class DescribeCrossRegionLogBackupFilesResponseBodyItems(TeaModel):
    def __init__(self, item=None):
        self.item = item  # type: list[DescribeCrossRegionLogBackupFilesResponseBodyItemsItem]

    def validate(self):
        if self.item:
            for k in self.item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCrossRegionLogBackupFilesResponseBodyItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Item'] = []
        if self.item is not None:
            for k in self.item:
                result['Item'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.item = []
        if m.get('Item') is not None:
            for k in m.get('Item'):
                temp_model = DescribeCrossRegionLogBackupFilesResponseBodyItemsItem()
                self.item.append(temp_model.from_map(k))
        return self


class DescribeCrossRegionLogBackupFilesResponseBody(TeaModel):
    def __init__(self, dbinstance_id=None, end_time=None, items=None, page_number=None, page_record_count=None,
                 region_id=None, request_id=None, start_time=None, total_record_count=None):
        # The ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        # The end of the time range queried. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*hh:mm:ss*Z format. The time is displayed in UTC.
        self.end_time = end_time  # type: str
        # An array that consists of cross-region log backup files.
        self.items = items  # type: DescribeCrossRegionLogBackupFilesResponseBodyItems
        # The page number of the returned page. Pages start from page 1.
        # 
        # Default value: **1**.
        self.page_number = page_number  # type: int
        # The number of cross-region log backup files on the current page.
        self.page_record_count = page_record_count  # type: int
        # The region ID of the instance.
        self.region_id = region_id  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The beginning of the time range queried. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*hh:mm:ss*Z format. The time is displayed in UTC.
        self.start_time = start_time  # type: str
        # The total number of entries returned.
        self.total_record_count = total_record_count  # type: int

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super(DescribeCrossRegionLogBackupFilesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.items is not None:
            result['Items'] = self.items.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_record_count is not None:
            result['PageRecordCount'] = self.page_record_count
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.total_record_count is not None:
            result['TotalRecordCount'] = self.total_record_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Items') is not None:
            temp_model = DescribeCrossRegionLogBackupFilesResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageRecordCount') is not None:
            self.page_record_count = m.get('PageRecordCount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TotalRecordCount') is not None:
            self.total_record_count = m.get('TotalRecordCount')
        return self


class DescribeCrossRegionLogBackupFilesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeCrossRegionLogBackupFilesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCrossRegionLogBackupFilesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCrossRegionLogBackupFilesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDBInstanceAttributeRequest(TeaModel):
    def __init__(self, dbinstance_id=None, expired=None, resource_owner_id=None):
        # The ID of the instance. You can specify up to 30 instance IDs in a single request. If you specify multiple instance IDs, separate the instance IDs with commas (,).
        self.dbinstance_id = dbinstance_id  # type: str
        # Specifies whether the instance expires. Valid values:
        # 
        # *   **True**: The instance expires.
        # *   **False**: The instance does not expire.
        self.expired = expired  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDBInstanceAttributeRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.expired is not None:
            result['Expired'] = self.expired
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('Expired') is not None:
            self.expired = m.get('Expired')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeBabelfishConfig(TeaModel):
    def __init__(self, babelfish_enabled=None, migration_mode=None):
        # The switch to enable or disable Babelfish. 
        # 
        # >  If Babelfish is enabled when you purchase an ApsaraDB RDS for PostgreSQL instance, this parameter is fixed as **true**.
        self.babelfish_enabled = babelfish_enabled  # type: str
        # The migration mode for Babelfish. Valid values:
        # 
        # - **single-db**\
        # - **multi-db**\
        # 
        # >  For more information about migration modes for Babelfish, see [Migration modes](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/babelfish-for-pg).
        self.migration_mode = migration_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeBabelfishConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.babelfish_enabled is not None:
            result['BabelfishEnabled'] = self.babelfish_enabled
        if self.migration_mode is not None:
            result['MigrationMode'] = self.migration_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BabelfishEnabled') is not None:
            self.babelfish_enabled = m.get('BabelfishEnabled')
        if m.get('MigrationMode') is not None:
            self.migration_mode = m.get('MigrationMode')
        return self


class DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeDBClusterNodesDBClusterNode(TeaModel):
    def __init__(self, class_code=None, node_id=None, node_region_id=None, node_role=None, node_zone_id=None):
        # The specification of the node.
        self.class_code = class_code  # type: str
        # The ID of the node.
        self.node_id = node_id  # type: str
        # The region ID of the node.
        self.node_region_id = node_region_id  # type: str
        # The role of node. The valid values:
        # 
        # - **primary**: primary node.
        # - **secondary**: standby node.
        self.node_role = node_role  # type: str
        # The zone ID of the node.
        self.node_zone_id = node_zone_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeDBClusterNodesDBClusterNode, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.class_code is not None:
            result['ClassCode'] = self.class_code
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.node_region_id is not None:
            result['NodeRegionId'] = self.node_region_id
        if self.node_role is not None:
            result['NodeRole'] = self.node_role
        if self.node_zone_id is not None:
            result['NodeZoneId'] = self.node_zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClassCode') is not None:
            self.class_code = m.get('ClassCode')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('NodeRegionId') is not None:
            self.node_region_id = m.get('NodeRegionId')
        if m.get('NodeRole') is not None:
            self.node_role = m.get('NodeRole')
        if m.get('NodeZoneId') is not None:
            self.node_zone_id = m.get('NodeZoneId')
        return self


class DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeDBClusterNodes(TeaModel):
    def __init__(self, dbcluster_node=None):
        self.dbcluster_node = dbcluster_node  # type: list[DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeDBClusterNodesDBClusterNode]

    def validate(self):
        if self.dbcluster_node:
            for k in self.dbcluster_node:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeDBClusterNodes, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DBClusterNode'] = []
        if self.dbcluster_node is not None:
            for k in self.dbcluster_node:
                result['DBClusterNode'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.dbcluster_node = []
        if m.get('DBClusterNode') is not None:
            for k in m.get('DBClusterNode'):
                temp_model = DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeDBClusterNodesDBClusterNode()
                self.dbcluster_node.append(temp_model.from_map(k))
        return self


class DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeExtraDBInstanceIds(TeaModel):
    def __init__(self, dbinstance_id=None):
        self.dbinstance_id = dbinstance_id  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeExtraDBInstanceIds, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        return self


class DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeExtra(TeaModel):
    def __init__(self, dbinstance_ids=None):
        # The IDs of the instances.
        self.dbinstance_ids = dbinstance_ids  # type: DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeExtraDBInstanceIds

    def validate(self):
        if self.dbinstance_ids:
            self.dbinstance_ids.validate()

    def to_map(self):
        _map = super(DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeExtra, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_ids is not None:
            result['DBInstanceIds'] = self.dbinstance_ids.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DBInstanceIds') is not None:
            temp_model = DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeExtraDBInstanceIds()
            self.dbinstance_ids = temp_model.from_map(m['DBInstanceIds'])
        return self


class DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeReadOnlyDBInstanceIdsReadOnlyDBInstanceId(TeaModel):
    def __init__(self, dbinstance_id=None):
        # The ID of the read-only RDS instance.
        self.dbinstance_id = dbinstance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeReadOnlyDBInstanceIdsReadOnlyDBInstanceId, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        return self


class DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeReadOnlyDBInstanceIds(TeaModel):
    def __init__(self, read_only_dbinstance_id=None):
        self.read_only_dbinstance_id = read_only_dbinstance_id  # type: list[DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeReadOnlyDBInstanceIdsReadOnlyDBInstanceId]

    def validate(self):
        if self.read_only_dbinstance_id:
            for k in self.read_only_dbinstance_id:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeReadOnlyDBInstanceIds, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ReadOnlyDBInstanceId'] = []
        if self.read_only_dbinstance_id is not None:
            for k in self.read_only_dbinstance_id:
                result['ReadOnlyDBInstanceId'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.read_only_dbinstance_id = []
        if m.get('ReadOnlyDBInstanceId') is not None:
            for k in m.get('ReadOnlyDBInstanceId'):
                temp_model = DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeReadOnlyDBInstanceIdsReadOnlyDBInstanceId()
                self.read_only_dbinstance_id.append(temp_model.from_map(k))
        return self


class DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeServerlessConfig(TeaModel):
    def __init__(self, auto_pause=None, scale_max=None, scale_min=None, switch_force=None):
        # Indicates whether the automatic suspension feature is enabled for the serverless instance. Valid values: 
        # 
        # - **true**: The feature is enabled.
        # - **false**: The feature is disabled. This is the default value.
        # 
        # >  After the automatic suspension feature is enabled, if no connections to the instance are established within 10 minutes, the instance is suspended. After a connection is established to the instance, the instance is automatically resumed.
        self.auto_pause = auto_pause  # type: bool
        # The maximum value of RCU.
        self.scale_max = scale_max  # type: float
        # The minimum value of RDS Capacity Unit (RCU).
        self.scale_min = scale_min  # type: float
        # Indicates whether the forced scaling feature is enabled for the serverless instance.
        # 
        # - **true**: The feature is enabled.
        # - **false**: The feature is disabled. This is the default value.
        # 
        # >  In most cases, ApsaraDB RDS automatically scales in or out the RCUs of a serverless instance based on business requirements in real time. In some cases, the scaling does not take effect in real time. You can enable the forced scaling feature to forcefully scales in or out the RCUs of the instance.
        self.switch_force = switch_force  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeServerlessConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_pause is not None:
            result['AutoPause'] = self.auto_pause
        if self.scale_max is not None:
            result['ScaleMax'] = self.scale_max
        if self.scale_min is not None:
            result['ScaleMin'] = self.scale_min
        if self.switch_force is not None:
            result['SwitchForce'] = self.switch_force
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AutoPause') is not None:
            self.auto_pause = m.get('AutoPause')
        if m.get('ScaleMax') is not None:
            self.scale_max = m.get('ScaleMax')
        if m.get('ScaleMin') is not None:
            self.scale_min = m.get('ScaleMin')
        if m.get('SwitchForce') is not None:
            self.switch_force = m.get('SwitchForce')
        return self


class DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeSlaveZonesSlaveZone(TeaModel):
    def __init__(self, zone_id=None):
        # The ID of the zone.
        self.zone_id = zone_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeSlaveZonesSlaveZone, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeSlaveZones(TeaModel):
    def __init__(self, slave_zone=None):
        self.slave_zone = slave_zone  # type: list[DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeSlaveZonesSlaveZone]

    def validate(self):
        if self.slave_zone:
            for k in self.slave_zone:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeSlaveZones, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SlaveZone'] = []
        if self.slave_zone is not None:
            for k in self.slave_zone:
                result['SlaveZone'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.slave_zone = []
        if m.get('SlaveZone') is not None:
            for k in m.get('SlaveZone'):
                temp_model = DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeSlaveZonesSlaveZone()
                self.slave_zone.append(temp_model.from_map(k))
        return self


class DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttribute(TeaModel):
    def __init__(self, account_max_quantity=None, advanced_features=None, auto_upgrade_minor_version=None,
                 availability_value=None, babelfish_config=None, category=None, collation=None, connection_mode=None,
                 connection_string=None, console_version=None, creation_time=None, current_kernel_version=None, dbcluster_nodes=None,
                 dbinstance_cpu=None, dbinstance_class=None, dbinstance_class_type=None, dbinstance_description=None,
                 dbinstance_id=None, dbinstance_memory=None, dbinstance_net_type=None, dbinstance_status=None,
                 dbinstance_storage=None, dbinstance_storage_type=None, dbinstance_type=None, dbmax_quantity=None,
                 dedicated_host_group_id=None, deletion_protection=None, engine=None, engine_version=None, expire_time=None, extra=None,
                 general_group_name=None, guard_dbinstance_id=None, iptype=None, increment_source_dbinstance_id=None,
                 instance_network_type=None, instruction_set_arch=None, latest_kernel_version=None, lock_mode=None, lock_reason=None,
                 maintain_time=None, master_instance_id=None, master_zone=None, max_connections=None, max_iombps=None,
                 max_iops=None, pay_type=None, port=None, proxy_type=None, read_only_dbinstance_ids=None,
                 readonly_instance_sqldelayed_time=None, region_id=None, resource_group_id=None, security_iplist=None, security_ipmode=None,
                 serverless_config=None, slave_zones=None, super_permission_mode=None, temp_dbinstance_id=None, time_zone=None,
                 tips=None, tips_level=None, v_switch_id=None, vpc_cloud_instance_id=None, vpc_id=None, zone_id=None,
                 kind_code=None):
        # The maximum number of accounts that can be created on an instance.
        self.account_max_quantity = account_max_quantity  # type: int
        # The advanced features that are enabled for the instance. If multiple advanced features are enabled, the advanced features are separated by commas (,). This parameter is available only to instances that run **SQL Server**. Valid values:
        # 
        # *   **LinkedServer**\
        # *   **DistributeTransaction**\
        self.advanced_features = advanced_features  # type: str
        # The method that is used to update the minor engine version of the instance. Valid values:
        # 
        # *   **Auto:** automatic update.
        # *   **Manual**: manual update. ApsaraDB RDS automatically updates the minor engine version of the instance only when the minor engine version is phased out.
        self.auto_upgrade_minor_version = auto_upgrade_minor_version  # type: str
        # The availability status of the instance in percentage.
        self.availability_value = availability_value  # type: str
        # The configuration of Babelfish for the instance. 
        # 
        # >  This parameter applies only to ApsaraDB RDS for PostgreSQL instances for which Babelfish is enabled. For more information, see [Introduction to Babelfish](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/babelfish-for-pg).
        self.babelfish_config = babelfish_config  # type: DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeBabelfishConfig
        # The RDS edition of the instance. Valid values:
        # 
        # *   **Basic**: RDS Basic Edition
        # *   **HighAvailability**: RDS High-availability Edition
        # *   **AlwaysOn**: RDS Cluster Edition
        # *   **Finance**: RDS Enterprise Edition
        self.category = category  # type: str
        # The character set collation of the instance.
        self.collation = collation  # type: str
        # The connection mode of the instance. Valid values:
        # 
        # *   **Standard**: standard mode
        # *   **Safe**: proxy mode
        self.connection_mode = connection_mode  # type: str
        # The internal endpoint of the instance.
        self.connection_string = connection_string  # type: str
        # The type of the proxy that is used by the instance. Valid values:
        # 
        # *   **1**: shared proxy
        # *   **2**: dedicated proxy
        # 
        # >  We recommend that you use the **ProxyType** parameter instead of this parameter.
        self.console_version = console_version  # type: str
        # The time when the instance was created. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.creation_time = creation_time  # type: str
        # The minor engine version of the instance.
        self.current_kernel_version = current_kernel_version  # type: str
        # The nodes of cluster.
        self.dbcluster_nodes = dbcluster_nodes  # type: DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeDBClusterNodes
        # The number of cores that are configured for the instance.
        self.dbinstance_cpu = dbinstance_cpu  # type: str
        # The instance type of the instance. For more information, see [Primary ApsaraDB RDS instance types](~~26312~~).
        self.dbinstance_class = dbinstance_class  # type: str
        # The instance family to which the instance belongs. Valid values:
        # 
        # *   **s**: shared instance family
        # *   **x**: general-purpose instance family
        # *   **d**: dedicated instance family
        # *   **h**: dedicated host instance family
        self.dbinstance_class_type = dbinstance_class_type  # type: str
        # The description of the instance.
        self.dbinstance_description = dbinstance_description  # type: str
        # The ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        # The memory size of the instance. Unit: MB.
        self.dbinstance_memory = dbinstance_memory  # type: long
        # The type of the network over which the instance is connected. Valid values:
        # 
        # *   **Internet**\
        # *   **Intranet**\
        self.dbinstance_net_type = dbinstance_net_type  # type: str
        # The status of the instance. For more information, see [Instance states](~~26315~~).
        self.dbinstance_status = dbinstance_status  # type: str
        # The storage capacity of the instance. Unit: GB.
        self.dbinstance_storage = dbinstance_storage  # type: int
        # The storage type of the instance. Valid values:
        # 
        # *   **local_ssd** and **ephemeral_ssd**: local SSD
        # *   **cloud_ssd**: standard SSD
        # *   **cloud_essd**: enhanced SSD (ESSD)
        self.dbinstance_storage_type = dbinstance_storage_type  # type: str
        # The type of the instance. Valid values:
        # 
        # *   **Primary**: primary instance
        # *   **Readonly**: read-only instance
        # *   **Guard**: disaster recovery instance
        # *   **Temp**: temporary instance
        self.dbinstance_type = dbinstance_type  # type: str
        # The maximum number of databases that can be created on the instance.
        self.dbmax_quantity = dbmax_quantity  # type: int
        # The ID of the dedicated cluster to which the instance belongs.
        self.dedicated_host_group_id = dedicated_host_group_id  # type: str
        # Indicates whether the release protection feature is enabled. Valid values:
        # 
        # - **true**: The feature is enabled.
        # - **false**: The feature is disabled.
        self.deletion_protection = deletion_protection  # type: bool
        # The database engine of the instance. Valid values:
        # 
        # *   **MySQL**\
        # *   **PostgreSQL**\
        # *   **SQLServer**\
        # *   **MariaDB**\
        self.engine = engine  # type: str
        # The database engine version of the instance.
        self.engine_version = engine_version  # type: str
        # The time at which the instance expires. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        # 
        # >  Pay-as-you-go instances never expire.
        self.expire_time = expire_time  # type: str
        # The extended information of the instance.
        self.extra = extra  # type: DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeExtra
        # The name of the dedicated cluster to which the instance belongs. This parameter is returned only when the instance runs MySQL on RDS Standard Edition and is created in a dedicated cluster.
        self.general_group_name = general_group_name  # type: str
        # The ID of the disaster recovery instance that is attached to the instance.
        self.guard_dbinstance_id = guard_dbinstance_id  # type: str
        # The type of the IP address that is used by the instance. The value is fixed as **IPv4**.
        self.iptype = iptype  # type: str
        # The ID of the instance from which incremental data comes. The incremental data of a disaster recovery instance or read-only instance comes from its primary instance. If this parameter is not returned, the instance is a primary instance.
        self.increment_source_dbinstance_id = increment_source_dbinstance_id  # type: str
        # The network type of the instance. Valid values:
        # 
        # *   **Classic**\
        # *   **VPC**\
        self.instance_network_type = instance_network_type  # type: str
        # The architecture type of the instance. Valid values:
        # 
        # - **x86**\
        # - **arm**\
        self.instruction_set_arch = instruction_set_arch  # type: str
        # The latest minor engine version that is supported by the instance.
        self.latest_kernel_version = latest_kernel_version  # type: str
        # The lock mode of the instance. Valid values:
        # 
        # *   **Unlock**: The instance is not locked.
        # *   **ManualLock**: The instance is manually locked.
        # *   **LockByExpiration**: The instance is automatically locked due to instance expiration.
        # *   **LockByRestoration**: The instance is automatically locked due to instance restoration.
        # *   **LockByDiskQuota**: The instance is automatically locked due to exhausted storage.
        # *   **LockReadInstanceByDiskQuota**: The instance is a read-only instance and is automatically locked when the disk space is exhausted.
        self.lock_mode = lock_mode  # type: str
        # The reason why the instance was locked.
        self.lock_reason = lock_reason  # type: str
        # The maintenance window of the instance. The time is displayed in UTC. Take note that the maintenance window displayed in the ApsaraDB RDS console is equal to the value of this parameter plus 8 hours.
        self.maintain_time = maintain_time  # type: str
        # The ID of the primary instance.
        # 
        # >  If this parameter is not returned, the instance is the primary instance.
        self.master_instance_id = master_instance_id  # type: str
        # The ID of the primary zone.
        self.master_zone = master_zone  # type: str
        # The maximum number of concurrent connections that are allowed by the instance.
        self.max_connections = max_connections  # type: int
        # The maximum I/O throughput. Unit: MB/s.
        self.max_iombps = max_iombps  # type: int
        # The maximum number of I/O requests that can be processed by the instance per second.
        self.max_iops = max_iops  # type: int
        # The billing method of the instance. Valid values:
        # 
        # *   **Postpaid**: pay-as-you-go
        # *   **Prepaid**: subscription
        self.pay_type = pay_type  # type: str
        # The internal port number that is used to connect to the instance.
        self.port = port  # type: str
        # The type of the proxy that is supported by the instance. Valid values:
        # 
        # *   **0**: The instance does not support database proxies.
        # *   **1**: The instance supports shared proxies, with which the instance runs in multi-tenant mode.
        # *   **2**: The instance supports dedicated proxies, with which the instance runs in single-tenant mode.
        self.proxy_type = proxy_type  # type: int
        # An array that consists of the IDs of the read-only instances that are attached to the primary instance.
        self.read_only_dbinstance_ids = read_only_dbinstance_ids  # type: DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeReadOnlyDBInstanceIds
        # The latency at which the read-only instances replicate data. The read-only instances replicate data from the primary instance at the latency that is specified by the **ReadonlyInstanceSQLDelayedTime** parameter. Unit: seconds.
        self.readonly_instance_sqldelayed_time = readonly_instance_sqldelayed_time  # type: str
        # The region ID of the instance.
        self.region_id = region_id  # type: str
        # The ID of the resource group to which the instance belongs.
        self.resource_group_id = resource_group_id  # type: str
        # The IP addresses in the IP address whitelist.
        self.security_iplist = security_iplist  # type: str
        # The whitelist mode of the instance. Valid values:
        # 
        # *   **normal**: standard whitelist mode
        # *   **safety**: enhanced whitelist mode
        self.security_ipmode = security_ipmode  # type: str
        # The settings of the serverless instance.
        self.serverless_config = serverless_config  # type: DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeServerlessConfig
        # An array that consists of the details about the secondary zones.
        self.slave_zones = slave_zones  # type: DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeSlaveZones
        # Indicates whether the instance supports superuser accounts, such as the system administrator (SA) account, the Active Directory (AD) account, and the host account.
        # 
        # *   **Enable**: Superuser accounts are supported.
        # *   **Disabled**: Superuser accounts are not supported.
        self.super_permission_mode = super_permission_mode  # type: str
        # The ID of the temporary instance that is attached to the instance.
        self.temp_dbinstance_id = temp_dbinstance_id  # type: str
        # The time zone of the instance.
        self.time_zone = time_zone  # type: str
        # The information about the exception that is detected on the instance. This parameter is returned only when the instance runs MySQL on RDS Standard Edition and is created in a dedicated cluster.
        self.tips = tips  # type: str
        # The severity level of the exception that is detected on the instance. This parameter is returned only when the instance runs MySQL on RDS Standard Edition and is created in a dedicated cluster. Valid values:
        # 
        # *   **1**: The instance is normal.
        # *   **2**: The specifications of the read-only instances do not match the specifications of the primary instance. You must adjust the specifications of these instances based on your business requirements.
        self.tips_level = tips_level  # type: int
        # The ID of the vSwitch that serves the instance.
        self.v_switch_id = v_switch_id  # type: str
        # The ID of the VPC to which the instance belongs. This parameter is returned only when the instance resides in a VPC.
        self.vpc_cloud_instance_id = vpc_cloud_instance_id  # type: str
        # The ID of the virtual private cloud (VPC) to which the instance belongs.
        self.vpc_id = vpc_id  # type: str
        # The ID of the zone to which the instances belong.
        self.zone_id = zone_id  # type: str
        # An internal parameter. This operation does not return a value for this parameter.
        self.kind_code = kind_code  # type: str

    def validate(self):
        if self.babelfish_config:
            self.babelfish_config.validate()
        if self.dbcluster_nodes:
            self.dbcluster_nodes.validate()
        if self.extra:
            self.extra.validate()
        if self.read_only_dbinstance_ids:
            self.read_only_dbinstance_ids.validate()
        if self.serverless_config:
            self.serverless_config.validate()
        if self.slave_zones:
            self.slave_zones.validate()

    def to_map(self):
        _map = super(DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttribute, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_max_quantity is not None:
            result['AccountMaxQuantity'] = self.account_max_quantity
        if self.advanced_features is not None:
            result['AdvancedFeatures'] = self.advanced_features
        if self.auto_upgrade_minor_version is not None:
            result['AutoUpgradeMinorVersion'] = self.auto_upgrade_minor_version
        if self.availability_value is not None:
            result['AvailabilityValue'] = self.availability_value
        if self.babelfish_config is not None:
            result['BabelfishConfig'] = self.babelfish_config.to_map()
        if self.category is not None:
            result['Category'] = self.category
        if self.collation is not None:
            result['Collation'] = self.collation
        if self.connection_mode is not None:
            result['ConnectionMode'] = self.connection_mode
        if self.connection_string is not None:
            result['ConnectionString'] = self.connection_string
        if self.console_version is not None:
            result['ConsoleVersion'] = self.console_version
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.current_kernel_version is not None:
            result['CurrentKernelVersion'] = self.current_kernel_version
        if self.dbcluster_nodes is not None:
            result['DBClusterNodes'] = self.dbcluster_nodes.to_map()
        if self.dbinstance_cpu is not None:
            result['DBInstanceCPU'] = self.dbinstance_cpu
        if self.dbinstance_class is not None:
            result['DBInstanceClass'] = self.dbinstance_class
        if self.dbinstance_class_type is not None:
            result['DBInstanceClassType'] = self.dbinstance_class_type
        if self.dbinstance_description is not None:
            result['DBInstanceDescription'] = self.dbinstance_description
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dbinstance_memory is not None:
            result['DBInstanceMemory'] = self.dbinstance_memory
        if self.dbinstance_net_type is not None:
            result['DBInstanceNetType'] = self.dbinstance_net_type
        if self.dbinstance_status is not None:
            result['DBInstanceStatus'] = self.dbinstance_status
        if self.dbinstance_storage is not None:
            result['DBInstanceStorage'] = self.dbinstance_storage
        if self.dbinstance_storage_type is not None:
            result['DBInstanceStorageType'] = self.dbinstance_storage_type
        if self.dbinstance_type is not None:
            result['DBInstanceType'] = self.dbinstance_type
        if self.dbmax_quantity is not None:
            result['DBMaxQuantity'] = self.dbmax_quantity
        if self.dedicated_host_group_id is not None:
            result['DedicatedHostGroupId'] = self.dedicated_host_group_id
        if self.deletion_protection is not None:
            result['DeletionProtection'] = self.deletion_protection
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.engine_version is not None:
            result['EngineVersion'] = self.engine_version
        if self.expire_time is not None:
            result['ExpireTime'] = self.expire_time
        if self.extra is not None:
            result['Extra'] = self.extra.to_map()
        if self.general_group_name is not None:
            result['GeneralGroupName'] = self.general_group_name
        if self.guard_dbinstance_id is not None:
            result['GuardDBInstanceId'] = self.guard_dbinstance_id
        if self.iptype is not None:
            result['IPType'] = self.iptype
        if self.increment_source_dbinstance_id is not None:
            result['IncrementSourceDBInstanceId'] = self.increment_source_dbinstance_id
        if self.instance_network_type is not None:
            result['InstanceNetworkType'] = self.instance_network_type
        if self.instruction_set_arch is not None:
            result['InstructionSetArch'] = self.instruction_set_arch
        if self.latest_kernel_version is not None:
            result['LatestKernelVersion'] = self.latest_kernel_version
        if self.lock_mode is not None:
            result['LockMode'] = self.lock_mode
        if self.lock_reason is not None:
            result['LockReason'] = self.lock_reason
        if self.maintain_time is not None:
            result['MaintainTime'] = self.maintain_time
        if self.master_instance_id is not None:
            result['MasterInstanceId'] = self.master_instance_id
        if self.master_zone is not None:
            result['MasterZone'] = self.master_zone
        if self.max_connections is not None:
            result['MaxConnections'] = self.max_connections
        if self.max_iombps is not None:
            result['MaxIOMBPS'] = self.max_iombps
        if self.max_iops is not None:
            result['MaxIOPS'] = self.max_iops
        if self.pay_type is not None:
            result['PayType'] = self.pay_type
        if self.port is not None:
            result['Port'] = self.port
        if self.proxy_type is not None:
            result['ProxyType'] = self.proxy_type
        if self.read_only_dbinstance_ids is not None:
            result['ReadOnlyDBInstanceIds'] = self.read_only_dbinstance_ids.to_map()
        if self.readonly_instance_sqldelayed_time is not None:
            result['ReadonlyInstanceSQLDelayedTime'] = self.readonly_instance_sqldelayed_time
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.security_iplist is not None:
            result['SecurityIPList'] = self.security_iplist
        if self.security_ipmode is not None:
            result['SecurityIPMode'] = self.security_ipmode
        if self.serverless_config is not None:
            result['ServerlessConfig'] = self.serverless_config.to_map()
        if self.slave_zones is not None:
            result['SlaveZones'] = self.slave_zones.to_map()
        if self.super_permission_mode is not None:
            result['SuperPermissionMode'] = self.super_permission_mode
        if self.temp_dbinstance_id is not None:
            result['TempDBInstanceId'] = self.temp_dbinstance_id
        if self.time_zone is not None:
            result['TimeZone'] = self.time_zone
        if self.tips is not None:
            result['Tips'] = self.tips
        if self.tips_level is not None:
            result['TipsLevel'] = self.tips_level
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.vpc_cloud_instance_id is not None:
            result['VpcCloudInstanceId'] = self.vpc_cloud_instance_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.kind_code is not None:
            result['kindCode'] = self.kind_code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountMaxQuantity') is not None:
            self.account_max_quantity = m.get('AccountMaxQuantity')
        if m.get('AdvancedFeatures') is not None:
            self.advanced_features = m.get('AdvancedFeatures')
        if m.get('AutoUpgradeMinorVersion') is not None:
            self.auto_upgrade_minor_version = m.get('AutoUpgradeMinorVersion')
        if m.get('AvailabilityValue') is not None:
            self.availability_value = m.get('AvailabilityValue')
        if m.get('BabelfishConfig') is not None:
            temp_model = DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeBabelfishConfig()
            self.babelfish_config = temp_model.from_map(m['BabelfishConfig'])
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('Collation') is not None:
            self.collation = m.get('Collation')
        if m.get('ConnectionMode') is not None:
            self.connection_mode = m.get('ConnectionMode')
        if m.get('ConnectionString') is not None:
            self.connection_string = m.get('ConnectionString')
        if m.get('ConsoleVersion') is not None:
            self.console_version = m.get('ConsoleVersion')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('CurrentKernelVersion') is not None:
            self.current_kernel_version = m.get('CurrentKernelVersion')
        if m.get('DBClusterNodes') is not None:
            temp_model = DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeDBClusterNodes()
            self.dbcluster_nodes = temp_model.from_map(m['DBClusterNodes'])
        if m.get('DBInstanceCPU') is not None:
            self.dbinstance_cpu = m.get('DBInstanceCPU')
        if m.get('DBInstanceClass') is not None:
            self.dbinstance_class = m.get('DBInstanceClass')
        if m.get('DBInstanceClassType') is not None:
            self.dbinstance_class_type = m.get('DBInstanceClassType')
        if m.get('DBInstanceDescription') is not None:
            self.dbinstance_description = m.get('DBInstanceDescription')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DBInstanceMemory') is not None:
            self.dbinstance_memory = m.get('DBInstanceMemory')
        if m.get('DBInstanceNetType') is not None:
            self.dbinstance_net_type = m.get('DBInstanceNetType')
        if m.get('DBInstanceStatus') is not None:
            self.dbinstance_status = m.get('DBInstanceStatus')
        if m.get('DBInstanceStorage') is not None:
            self.dbinstance_storage = m.get('DBInstanceStorage')
        if m.get('DBInstanceStorageType') is not None:
            self.dbinstance_storage_type = m.get('DBInstanceStorageType')
        if m.get('DBInstanceType') is not None:
            self.dbinstance_type = m.get('DBInstanceType')
        if m.get('DBMaxQuantity') is not None:
            self.dbmax_quantity = m.get('DBMaxQuantity')
        if m.get('DedicatedHostGroupId') is not None:
            self.dedicated_host_group_id = m.get('DedicatedHostGroupId')
        if m.get('DeletionProtection') is not None:
            self.deletion_protection = m.get('DeletionProtection')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('EngineVersion') is not None:
            self.engine_version = m.get('EngineVersion')
        if m.get('ExpireTime') is not None:
            self.expire_time = m.get('ExpireTime')
        if m.get('Extra') is not None:
            temp_model = DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeExtra()
            self.extra = temp_model.from_map(m['Extra'])
        if m.get('GeneralGroupName') is not None:
            self.general_group_name = m.get('GeneralGroupName')
        if m.get('GuardDBInstanceId') is not None:
            self.guard_dbinstance_id = m.get('GuardDBInstanceId')
        if m.get('IPType') is not None:
            self.iptype = m.get('IPType')
        if m.get('IncrementSourceDBInstanceId') is not None:
            self.increment_source_dbinstance_id = m.get('IncrementSourceDBInstanceId')
        if m.get('InstanceNetworkType') is not None:
            self.instance_network_type = m.get('InstanceNetworkType')
        if m.get('InstructionSetArch') is not None:
            self.instruction_set_arch = m.get('InstructionSetArch')
        if m.get('LatestKernelVersion') is not None:
            self.latest_kernel_version = m.get('LatestKernelVersion')
        if m.get('LockMode') is not None:
            self.lock_mode = m.get('LockMode')
        if m.get('LockReason') is not None:
            self.lock_reason = m.get('LockReason')
        if m.get('MaintainTime') is not None:
            self.maintain_time = m.get('MaintainTime')
        if m.get('MasterInstanceId') is not None:
            self.master_instance_id = m.get('MasterInstanceId')
        if m.get('MasterZone') is not None:
            self.master_zone = m.get('MasterZone')
        if m.get('MaxConnections') is not None:
            self.max_connections = m.get('MaxConnections')
        if m.get('MaxIOMBPS') is not None:
            self.max_iombps = m.get('MaxIOMBPS')
        if m.get('MaxIOPS') is not None:
            self.max_iops = m.get('MaxIOPS')
        if m.get('PayType') is not None:
            self.pay_type = m.get('PayType')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('ProxyType') is not None:
            self.proxy_type = m.get('ProxyType')
        if m.get('ReadOnlyDBInstanceIds') is not None:
            temp_model = DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeReadOnlyDBInstanceIds()
            self.read_only_dbinstance_ids = temp_model.from_map(m['ReadOnlyDBInstanceIds'])
        if m.get('ReadonlyInstanceSQLDelayedTime') is not None:
            self.readonly_instance_sqldelayed_time = m.get('ReadonlyInstanceSQLDelayedTime')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('SecurityIPList') is not None:
            self.security_iplist = m.get('SecurityIPList')
        if m.get('SecurityIPMode') is not None:
            self.security_ipmode = m.get('SecurityIPMode')
        if m.get('ServerlessConfig') is not None:
            temp_model = DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeServerlessConfig()
            self.serverless_config = temp_model.from_map(m['ServerlessConfig'])
        if m.get('SlaveZones') is not None:
            temp_model = DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeSlaveZones()
            self.slave_zones = temp_model.from_map(m['SlaveZones'])
        if m.get('SuperPermissionMode') is not None:
            self.super_permission_mode = m.get('SuperPermissionMode')
        if m.get('TempDBInstanceId') is not None:
            self.temp_dbinstance_id = m.get('TempDBInstanceId')
        if m.get('TimeZone') is not None:
            self.time_zone = m.get('TimeZone')
        if m.get('Tips') is not None:
            self.tips = m.get('Tips')
        if m.get('TipsLevel') is not None:
            self.tips_level = m.get('TipsLevel')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('VpcCloudInstanceId') is not None:
            self.vpc_cloud_instance_id = m.get('VpcCloudInstanceId')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('kindCode') is not None:
            self.kind_code = m.get('kindCode')
        return self


class DescribeDBInstanceAttributeResponseBodyItems(TeaModel):
    def __init__(self, dbinstance_attribute=None):
        self.dbinstance_attribute = dbinstance_attribute  # type: list[DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttribute]

    def validate(self):
        if self.dbinstance_attribute:
            for k in self.dbinstance_attribute:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDBInstanceAttributeResponseBodyItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DBInstanceAttribute'] = []
        if self.dbinstance_attribute is not None:
            for k in self.dbinstance_attribute:
                result['DBInstanceAttribute'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.dbinstance_attribute = []
        if m.get('DBInstanceAttribute') is not None:
            for k in m.get('DBInstanceAttribute'):
                temp_model = DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttribute()
                self.dbinstance_attribute.append(temp_model.from_map(k))
        return self


class DescribeDBInstanceAttributeResponseBody(TeaModel):
    def __init__(self, items=None, request_id=None):
        # An array that consists of the details about the instance.
        self.items = items  # type: DescribeDBInstanceAttributeResponseBodyItems
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super(DescribeDBInstanceAttributeResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.items is not None:
            result['Items'] = self.items.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Items') is not None:
            temp_model = DescribeDBInstanceAttributeResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDBInstanceAttributeResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDBInstanceAttributeResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDBInstanceAttributeResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDBInstanceAttributeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDBInstanceByTagsRequest(TeaModel):
    def __init__(self, client_token=None, dbinstance_id=None, owner_account=None, owner_id=None, page_number=None,
                 page_size=None, region_id=None, resource_owner_account=None, resource_owner_id=None, proxy_id=None):
        # The client token that is used to ensure the idempotence of the request. You can use the client to generate the value, but you must make sure that the generated token is unique among different requests. The token can only contain ASCII characters and cannot exceed 64 characters in length.
        self.client_token = client_token  # type: str
        # The ID of the instance. You can call the [DescribeDBInstances](~~26232~~) operation to query the ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The number of the page to return. Valid values: any non-zero positive integer.
        # 
        # Default value: **1**.
        self.page_number = page_number  # type: int
        # The number of entries to return on each page. Valid values: **30 to 100**. Default value: **30**.
        self.page_size = page_size  # type: int
        # The region ID of the instance. You can call the [DescribeRegions](~~26243~~) operation to query the most recent region list.
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # A deprecated parameter.
        self.proxy_id = proxy_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDBInstanceByTagsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.proxy_id is not None:
            result['proxyId'] = self.proxy_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('proxyId') is not None:
            self.proxy_id = m.get('proxyId')
        return self


class DescribeDBInstanceByTagsResponseBodyItemsDBInstanceTagTagsTag(TeaModel):
    def __init__(self, tag_key=None, tag_value=None):
        # The tag key.
        self.tag_key = tag_key  # type: str
        # The tag value.
        self.tag_value = tag_value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDBInstanceByTagsResponseBodyItemsDBInstanceTagTagsTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class DescribeDBInstanceByTagsResponseBodyItemsDBInstanceTagTags(TeaModel):
    def __init__(self, tag=None):
        self.tag = tag  # type: list[DescribeDBInstanceByTagsResponseBodyItemsDBInstanceTagTagsTag]

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDBInstanceByTagsResponseBodyItemsDBInstanceTagTags, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeDBInstanceByTagsResponseBodyItemsDBInstanceTagTagsTag()
                self.tag.append(temp_model.from_map(k))
        return self


class DescribeDBInstanceByTagsResponseBodyItemsDBInstanceTag(TeaModel):
    def __init__(self, dbinstance_id=None, tags=None):
        # The ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        # An array that consists of the queried tags.
        self.tags = tags  # type: DescribeDBInstanceByTagsResponseBodyItemsDBInstanceTagTags

    def validate(self):
        if self.tags:
            self.tags.validate()

    def to_map(self):
        _map = super(DescribeDBInstanceByTagsResponseBodyItemsDBInstanceTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('Tags') is not None:
            temp_model = DescribeDBInstanceByTagsResponseBodyItemsDBInstanceTagTags()
            self.tags = temp_model.from_map(m['Tags'])
        return self


class DescribeDBInstanceByTagsResponseBodyItems(TeaModel):
    def __init__(self, dbinstance_tag=None):
        self.dbinstance_tag = dbinstance_tag  # type: list[DescribeDBInstanceByTagsResponseBodyItemsDBInstanceTag]

    def validate(self):
        if self.dbinstance_tag:
            for k in self.dbinstance_tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDBInstanceByTagsResponseBodyItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DBInstanceTag'] = []
        if self.dbinstance_tag is not None:
            for k in self.dbinstance_tag:
                result['DBInstanceTag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.dbinstance_tag = []
        if m.get('DBInstanceTag') is not None:
            for k in m.get('DBInstanceTag'):
                temp_model = DescribeDBInstanceByTagsResponseBodyItemsDBInstanceTag()
                self.dbinstance_tag.append(temp_model.from_map(k))
        return self


class DescribeDBInstanceByTagsResponseBody(TeaModel):
    def __init__(self, items=None, page_number=None, page_record_count=None, request_id=None,
                 total_record_count=None):
        # An array that consists of the information about the instance.
        self.items = items  # type: DescribeDBInstanceByTagsResponseBodyItems
        # The page number of the page returned.
        self.page_number = page_number  # type: int
        # The number of entries returned on each page.
        self.page_record_count = page_record_count  # type: int
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The total number of entries returned.
        self.total_record_count = total_record_count  # type: int

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super(DescribeDBInstanceByTagsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.items is not None:
            result['Items'] = self.items.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_record_count is not None:
            result['PageRecordCount'] = self.page_record_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_record_count is not None:
            result['TotalRecordCount'] = self.total_record_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Items') is not None:
            temp_model = DescribeDBInstanceByTagsResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageRecordCount') is not None:
            self.page_record_count = m.get('PageRecordCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalRecordCount') is not None:
            self.total_record_count = m.get('TotalRecordCount')
        return self


class DescribeDBInstanceByTagsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDBInstanceByTagsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDBInstanceByTagsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDBInstanceByTagsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDBInstanceDetailRequest(TeaModel):
    def __init__(self, client_token=None, dbinstance_id=None, owner_id=None, resource_group_id=None,
                 resource_owner_account=None, resource_owner_id=None):
        # The client token that is used to ensure the idempotence of the request.
        # 
        # > You can use the client to generate the value, but you must ensure that it is unique among different requests. The token can contain only ASCII characters and cannot exceed 64 characters in length.
        self.client_token = client_token  # type: str
        # The ID of the instance. You can call the [DescribeDBInstances](~~26232~~) operation to query the ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        self.owner_id = owner_id  # type: long
        # The ID of the resource group.
        self.resource_group_id = resource_group_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDBInstanceDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeDBInstanceDetailResponseBody(TeaModel):
    def __init__(self, activation_state=None, dbinstance_id=None, license_type=None, region_id=None,
                 request_id=None):
        # Indicates whether the instance is in the active state.
        self.activation_state = activation_state  # type: str
        # The ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        # The type of the license.
        self.license_type = license_type  # type: str
        # The region ID of the instance.
        self.region_id = region_id  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDBInstanceDetailResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.activation_state is not None:
            result['ActivationState'] = self.activation_state
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.license_type is not None:
            result['LicenseType'] = self.license_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ActivationState') is not None:
            self.activation_state = m.get('ActivationState')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('LicenseType') is not None:
            self.license_type = m.get('LicenseType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDBInstanceDetailResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDBInstanceDetailResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDBInstanceDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDBInstanceDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDBInstanceEncryptionKeyRequest(TeaModel):
    def __init__(self, dbinstance_id=None, encryption_key=None, owner_account=None, owner_id=None, region_id=None,
                 resource_owner_account=None, resource_owner_id=None, security_token=None, target_region_id=None):
        # The ID of the instance You can call the [DescribeDBInstances](~~26232~~) operation to query the IDs of instances.
        self.dbinstance_id = dbinstance_id  # type: str
        # The ID of the custom key.
        self.encryption_key = encryption_key  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The region ID of the instance. You can call the [DescribeRegions](~~26243~~) operation to query the most recent region list.
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.security_token = security_token  # type: str
        # The ID of the destination region. You can call the [DescribeRegions](~~26243~~) operation to query the most recent region list.
        self.target_region_id = target_region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDBInstanceEncryptionKeyRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.encryption_key is not None:
            result['EncryptionKey'] = self.encryption_key
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.target_region_id is not None:
            result['TargetRegionId'] = self.target_region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('EncryptionKey') is not None:
            self.encryption_key = m.get('EncryptionKey')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('TargetRegionId') is not None:
            self.target_region_id = m.get('TargetRegionId')
        return self


class DescribeDBInstanceEncryptionKeyResponseBodyEncryptionKeyList(TeaModel):
    def __init__(self, alias_name=None, creator=None, delete_date=None, description=None, encryption_key=None,
                 encryption_key_status=None, key_type=None, key_usage=None, material_expire_time=None, origin=None, used_by=None):
        # The alias of the key.
        self.alias_name = alias_name  # type: str
        # The user who created the key.
        self.creator = creator  # type: str
        # The scheduled time at which the key is deleted. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        self.delete_date = delete_date  # type: str
        # The description of the key.
        self.description = description  # type: str
        # The ID of the key.
        self.encryption_key = encryption_key  # type: str
        # The status of the key. Valid values:
        # 
        # *   Enabled
        # *   Disabled
        self.encryption_key_status = encryption_key_status  # type: str
        # The type of the key.
        self.key_type = key_type  # type: str
        # The purpose of the key.
        self.key_usage = key_usage  # type: str
        # The time at which the key expires. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        self.material_expire_time = material_expire_time  # type: str
        # The source of the key.
        self.origin = origin  # type: str
        # The role of the instance that uses the key. Valid values: ***master**: primary instance*. **slave**: read-only instance.
        self.used_by = used_by  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDBInstanceEncryptionKeyResponseBodyEncryptionKeyList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.creator is not None:
            result['Creator'] = self.creator
        if self.delete_date is not None:
            result['DeleteDate'] = self.delete_date
        if self.description is not None:
            result['Description'] = self.description
        if self.encryption_key is not None:
            result['EncryptionKey'] = self.encryption_key
        if self.encryption_key_status is not None:
            result['EncryptionKeyStatus'] = self.encryption_key_status
        if self.key_type is not None:
            result['KeyType'] = self.key_type
        if self.key_usage is not None:
            result['KeyUsage'] = self.key_usage
        if self.material_expire_time is not None:
            result['MaterialExpireTime'] = self.material_expire_time
        if self.origin is not None:
            result['Origin'] = self.origin
        if self.used_by is not None:
            result['UsedBy'] = self.used_by
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('Creator') is not None:
            self.creator = m.get('Creator')
        if m.get('DeleteDate') is not None:
            self.delete_date = m.get('DeleteDate')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EncryptionKey') is not None:
            self.encryption_key = m.get('EncryptionKey')
        if m.get('EncryptionKeyStatus') is not None:
            self.encryption_key_status = m.get('EncryptionKeyStatus')
        if m.get('KeyType') is not None:
            self.key_type = m.get('KeyType')
        if m.get('KeyUsage') is not None:
            self.key_usage = m.get('KeyUsage')
        if m.get('MaterialExpireTime') is not None:
            self.material_expire_time = m.get('MaterialExpireTime')
        if m.get('Origin') is not None:
            self.origin = m.get('Origin')
        if m.get('UsedBy') is not None:
            self.used_by = m.get('UsedBy')
        return self


class DescribeDBInstanceEncryptionKeyResponseBody(TeaModel):
    def __init__(self, creator=None, delete_date=None, description=None, encryption_key=None,
                 encryption_key_list=None, encryption_key_status=None, key_usage=None, material_expire_time=None, origin=None,
                 request_id=None):
        # The user who created the key.
        self.creator = creator  # type: str
        # The scheduled time at which the key is deleted. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        self.delete_date = delete_date  # type: str
        # The description of the key.
        self.description = description  # type: str
        # The ID of the key.
        self.encryption_key = encryption_key  # type: str
        # An array that consists of keys.
        self.encryption_key_list = encryption_key_list  # type: list[DescribeDBInstanceEncryptionKeyResponseBodyEncryptionKeyList]
        # The status of the key. Valid values:
        # 
        # *   Enabled
        # *   Disabled
        self.encryption_key_status = encryption_key_status  # type: str
        # The purpose of the key.
        self.key_usage = key_usage  # type: str
        # The time at which the key expires. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        self.material_expire_time = material_expire_time  # type: str
        # The source of the key.
        self.origin = origin  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.encryption_key_list:
            for k in self.encryption_key_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDBInstanceEncryptionKeyResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creator is not None:
            result['Creator'] = self.creator
        if self.delete_date is not None:
            result['DeleteDate'] = self.delete_date
        if self.description is not None:
            result['Description'] = self.description
        if self.encryption_key is not None:
            result['EncryptionKey'] = self.encryption_key
        result['EncryptionKeyList'] = []
        if self.encryption_key_list is not None:
            for k in self.encryption_key_list:
                result['EncryptionKeyList'].append(k.to_map() if k else None)
        if self.encryption_key_status is not None:
            result['EncryptionKeyStatus'] = self.encryption_key_status
        if self.key_usage is not None:
            result['KeyUsage'] = self.key_usage
        if self.material_expire_time is not None:
            result['MaterialExpireTime'] = self.material_expire_time
        if self.origin is not None:
            result['Origin'] = self.origin
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Creator') is not None:
            self.creator = m.get('Creator')
        if m.get('DeleteDate') is not None:
            self.delete_date = m.get('DeleteDate')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EncryptionKey') is not None:
            self.encryption_key = m.get('EncryptionKey')
        self.encryption_key_list = []
        if m.get('EncryptionKeyList') is not None:
            for k in m.get('EncryptionKeyList'):
                temp_model = DescribeDBInstanceEncryptionKeyResponseBodyEncryptionKeyList()
                self.encryption_key_list.append(temp_model.from_map(k))
        if m.get('EncryptionKeyStatus') is not None:
            self.encryption_key_status = m.get('EncryptionKeyStatus')
        if m.get('KeyUsage') is not None:
            self.key_usage = m.get('KeyUsage')
        if m.get('MaterialExpireTime') is not None:
            self.material_expire_time = m.get('MaterialExpireTime')
        if m.get('Origin') is not None:
            self.origin = m.get('Origin')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDBInstanceEncryptionKeyResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDBInstanceEncryptionKeyResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDBInstanceEncryptionKeyResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDBInstanceEncryptionKeyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDBInstanceEndpointsRequest(TeaModel):
    def __init__(self, client_token=None, dbinstance_endpoint_id=None, dbinstance_id=None, resource_owner_id=None):
        # The client token that is used to ensure the idempotence of the request. You can use the client to generate the value, but you must make sure that it is unique among different requests.
        # 
        # The token can only contain ASCII characters and cannot exceed 64 characters in length.
        self.client_token = client_token  # type: str
        # The endpoint ID of the instance.
        # 
        # If this parameter is not specified, the information about all endpoints is returned.
        self.dbinstance_endpoint_id = dbinstance_endpoint_id  # type: str
        # The ID of the instance. You can call the [DescribeDBInstances](~~26232~~) operation to query the ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDBInstanceEndpointsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dbinstance_endpoint_id is not None:
            result['DBInstanceEndpointId'] = self.dbinstance_endpoint_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DBInstanceEndpointId') is not None:
            self.dbinstance_endpoint_id = m.get('DBInstanceEndpointId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeDBInstanceEndpointsResponseBodyDataDBInstanceEndpointsDBInstanceEndpointAddressItemsAddressItem(TeaModel):
    def __init__(self, connection_string=None, ip_address=None, ip_type=None, port=None, v_switch_id=None,
                 vpc_id=None):
        # The endpoint of the instance.
        self.connection_string = connection_string  # type: str
        # The IP address of the endpoint.
        self.ip_address = ip_address  # type: str
        # The type of the IP address. Valid values:
        # 
        # *   **Public**: Internet
        # *   **Private**: internal network
        self.ip_type = ip_type  # type: str
        # The port number of the endpoint.
        self.port = port  # type: str
        # The ID of the vSwitch.
        self.v_switch_id = v_switch_id  # type: str
        # The virtual private cloud (VPC) ID of the endpoint.
        self.vpc_id = vpc_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDBInstanceEndpointsResponseBodyDataDBInstanceEndpointsDBInstanceEndpointAddressItemsAddressItem, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.connection_string is not None:
            result['ConnectionString'] = self.connection_string
        if self.ip_address is not None:
            result['IpAddress'] = self.ip_address
        if self.ip_type is not None:
            result['IpType'] = self.ip_type
        if self.port is not None:
            result['Port'] = self.port
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConnectionString') is not None:
            self.connection_string = m.get('ConnectionString')
        if m.get('IpAddress') is not None:
            self.ip_address = m.get('IpAddress')
        if m.get('IpType') is not None:
            self.ip_type = m.get('IpType')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class DescribeDBInstanceEndpointsResponseBodyDataDBInstanceEndpointsDBInstanceEndpointAddressItems(TeaModel):
    def __init__(self, address_item=None):
        self.address_item = address_item  # type: list[DescribeDBInstanceEndpointsResponseBodyDataDBInstanceEndpointsDBInstanceEndpointAddressItemsAddressItem]

    def validate(self):
        if self.address_item:
            for k in self.address_item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDBInstanceEndpointsResponseBodyDataDBInstanceEndpointsDBInstanceEndpointAddressItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AddressItem'] = []
        if self.address_item is not None:
            for k in self.address_item:
                result['AddressItem'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.address_item = []
        if m.get('AddressItem') is not None:
            for k in m.get('AddressItem'):
                temp_model = DescribeDBInstanceEndpointsResponseBodyDataDBInstanceEndpointsDBInstanceEndpointAddressItemsAddressItem()
                self.address_item.append(temp_model.from_map(k))
        return self


class DescribeDBInstanceEndpointsResponseBodyDataDBInstanceEndpointsDBInstanceEndpointNodeItemsNodeItem(TeaModel):
    def __init__(self, dbinstance_id=None, node_id=None, weight=None):
        # The ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        # The ID of the node.
        self.node_id = node_id  # type: str
        # The weight of the node. Read requests are distributed based on the weight.
        # 
        # Valid values: 0 to 100.
        self.weight = weight  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDBInstanceEndpointsResponseBodyDataDBInstanceEndpointsDBInstanceEndpointNodeItemsNodeItem, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.weight is not None:
            result['Weight'] = self.weight
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('Weight') is not None:
            self.weight = m.get('Weight')
        return self


class DescribeDBInstanceEndpointsResponseBodyDataDBInstanceEndpointsDBInstanceEndpointNodeItems(TeaModel):
    def __init__(self, node_item=None):
        self.node_item = node_item  # type: list[DescribeDBInstanceEndpointsResponseBodyDataDBInstanceEndpointsDBInstanceEndpointNodeItemsNodeItem]

    def validate(self):
        if self.node_item:
            for k in self.node_item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDBInstanceEndpointsResponseBodyDataDBInstanceEndpointsDBInstanceEndpointNodeItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['NodeItem'] = []
        if self.node_item is not None:
            for k in self.node_item:
                result['NodeItem'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.node_item = []
        if m.get('NodeItem') is not None:
            for k in m.get('NodeItem'):
                temp_model = DescribeDBInstanceEndpointsResponseBodyDataDBInstanceEndpointsDBInstanceEndpointNodeItemsNodeItem()
                self.node_item.append(temp_model.from_map(k))
        return self


class DescribeDBInstanceEndpointsResponseBodyDataDBInstanceEndpointsDBInstanceEndpoint(TeaModel):
    def __init__(self, address_items=None, endpoint_description=None, endpoint_id=None, endpoint_type=None,
                 node_items=None):
        # The information about the endpoint.
        self.address_items = address_items  # type: DescribeDBInstanceEndpointsResponseBodyDataDBInstanceEndpointsDBInstanceEndpointAddressItems
        # The user-defined description of the endpoint.
        self.endpoint_description = endpoint_description  # type: str
        # The endpoint ID of the instance.
        self.endpoint_id = endpoint_id  # type: str
        # The type of the endpoint. Valid values:
        # 
        # *   **Primary**: the read/write endpoint of the instance.
        # *   **Readonly**: the read-only endpoint of the instance
        self.endpoint_type = endpoint_type  # type: str
        # The details about the node that is configured for the endpoint.
        self.node_items = node_items  # type: DescribeDBInstanceEndpointsResponseBodyDataDBInstanceEndpointsDBInstanceEndpointNodeItems

    def validate(self):
        if self.address_items:
            self.address_items.validate()
        if self.node_items:
            self.node_items.validate()

    def to_map(self):
        _map = super(DescribeDBInstanceEndpointsResponseBodyDataDBInstanceEndpointsDBInstanceEndpoint, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.address_items is not None:
            result['AddressItems'] = self.address_items.to_map()
        if self.endpoint_description is not None:
            result['EndpointDescription'] = self.endpoint_description
        if self.endpoint_id is not None:
            result['EndpointId'] = self.endpoint_id
        if self.endpoint_type is not None:
            result['EndpointType'] = self.endpoint_type
        if self.node_items is not None:
            result['NodeItems'] = self.node_items.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AddressItems') is not None:
            temp_model = DescribeDBInstanceEndpointsResponseBodyDataDBInstanceEndpointsDBInstanceEndpointAddressItems()
            self.address_items = temp_model.from_map(m['AddressItems'])
        if m.get('EndpointDescription') is not None:
            self.endpoint_description = m.get('EndpointDescription')
        if m.get('EndpointId') is not None:
            self.endpoint_id = m.get('EndpointId')
        if m.get('EndpointType') is not None:
            self.endpoint_type = m.get('EndpointType')
        if m.get('NodeItems') is not None:
            temp_model = DescribeDBInstanceEndpointsResponseBodyDataDBInstanceEndpointsDBInstanceEndpointNodeItems()
            self.node_items = temp_model.from_map(m['NodeItems'])
        return self


class DescribeDBInstanceEndpointsResponseBodyDataDBInstanceEndpoints(TeaModel):
    def __init__(self, dbinstance_endpoint=None):
        self.dbinstance_endpoint = dbinstance_endpoint  # type: list[DescribeDBInstanceEndpointsResponseBodyDataDBInstanceEndpointsDBInstanceEndpoint]

    def validate(self):
        if self.dbinstance_endpoint:
            for k in self.dbinstance_endpoint:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDBInstanceEndpointsResponseBodyDataDBInstanceEndpoints, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DBInstanceEndpoint'] = []
        if self.dbinstance_endpoint is not None:
            for k in self.dbinstance_endpoint:
                result['DBInstanceEndpoint'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.dbinstance_endpoint = []
        if m.get('DBInstanceEndpoint') is not None:
            for k in m.get('DBInstanceEndpoint'):
                temp_model = DescribeDBInstanceEndpointsResponseBodyDataDBInstanceEndpointsDBInstanceEndpoint()
                self.dbinstance_endpoint.append(temp_model.from_map(k))
        return self


class DescribeDBInstanceEndpointsResponseBodyData(TeaModel):
    def __init__(self, dbinstance_endpoints=None, dbinstance_name=None, ip_version=None):
        # The information about the endpoint of the instance.
        self.dbinstance_endpoints = dbinstance_endpoints  # type: DescribeDBInstanceEndpointsResponseBodyDataDBInstanceEndpoints
        # The name of the instance.
        self.dbinstance_name = dbinstance_name  # type: str
        # The version of the IP protocol. Valid values:
        # 
        # *   **ipv4**\
        # *   **ipv6**\
        self.ip_version = ip_version  # type: str

    def validate(self):
        if self.dbinstance_endpoints:
            self.dbinstance_endpoints.validate()

    def to_map(self):
        _map = super(DescribeDBInstanceEndpointsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_endpoints is not None:
            result['DBInstanceEndpoints'] = self.dbinstance_endpoints.to_map()
        if self.dbinstance_name is not None:
            result['DBInstanceName'] = self.dbinstance_name
        if self.ip_version is not None:
            result['IpVersion'] = self.ip_version
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DBInstanceEndpoints') is not None:
            temp_model = DescribeDBInstanceEndpointsResponseBodyDataDBInstanceEndpoints()
            self.dbinstance_endpoints = temp_model.from_map(m['DBInstanceEndpoints'])
        if m.get('DBInstanceName') is not None:
            self.dbinstance_name = m.get('DBInstanceName')
        if m.get('IpVersion') is not None:
            self.ip_version = m.get('IpVersion')
        return self


class DescribeDBInstanceEndpointsResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        # The returned data.
        self.data = data  # type: DescribeDBInstanceEndpointsResponseBodyData
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(DescribeDBInstanceEndpointsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = DescribeDBInstanceEndpointsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDBInstanceEndpointsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDBInstanceEndpointsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDBInstanceEndpointsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDBInstanceEndpointsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDBInstanceHAConfigRequest(TeaModel):
    def __init__(self, dbinstance_id=None, owner_account=None, owner_id=None, resource_owner_account=None,
                 resource_owner_id=None):
        # The ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDBInstanceHAConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeDBInstanceHAConfigResponseBodyHostInstanceInfosNodeInfo(TeaModel):
    def __init__(self, data_sync_time=None, log_sync_time=None, node_id=None, node_type=None, region_id=None,
                 sync_status=None, zone_id=None):
        # The time when the secondary instance completed the synchronization of data from the primary instance. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.data_sync_time = data_sync_time  # type: str
        # The time when the secondary instance received logs from the primary instance. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.log_sync_time = log_sync_time  # type: str
        # The ID of the instance.
        self.node_id = node_id  # type: str
        # The type of the node. Valid values:
        # 
        # *   **Master**: the primary node
        # *   **Slave**: the secondary node
        self.node_type = node_type  # type: str
        # The region ID of the instance.
        self.region_id = region_id  # type: str
        # The synchronization status. Valid values:
        # 
        # *   **NotAvailable**: The synchronization fails. This means that faults occur.
        # *   **Syncing**: The synchronization is in process. In this case, a primary/secondary switchover may cause data losses.
        # *   **Synchronized**: The synchronization is complete.
        # *   **NotSupport**: The database engine or version does not involve the synchronization between the primary and secondary instances.
        self.sync_status = sync_status  # type: str
        # The zone ID of the instance.
        self.zone_id = zone_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDBInstanceHAConfigResponseBodyHostInstanceInfosNodeInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_sync_time is not None:
            result['DataSyncTime'] = self.data_sync_time
        if self.log_sync_time is not None:
            result['LogSyncTime'] = self.log_sync_time
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.node_type is not None:
            result['NodeType'] = self.node_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.sync_status is not None:
            result['SyncStatus'] = self.sync_status
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DataSyncTime') is not None:
            self.data_sync_time = m.get('DataSyncTime')
        if m.get('LogSyncTime') is not None:
            self.log_sync_time = m.get('LogSyncTime')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('NodeType') is not None:
            self.node_type = m.get('NodeType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SyncStatus') is not None:
            self.sync_status = m.get('SyncStatus')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeDBInstanceHAConfigResponseBodyHostInstanceInfos(TeaModel):
    def __init__(self, node_info=None):
        self.node_info = node_info  # type: list[DescribeDBInstanceHAConfigResponseBodyHostInstanceInfosNodeInfo]

    def validate(self):
        if self.node_info:
            for k in self.node_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDBInstanceHAConfigResponseBodyHostInstanceInfos, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['NodeInfo'] = []
        if self.node_info is not None:
            for k in self.node_info:
                result['NodeInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.node_info = []
        if m.get('NodeInfo') is not None:
            for k in m.get('NodeInfo'):
                temp_model = DescribeDBInstanceHAConfigResponseBodyHostInstanceInfosNodeInfo()
                self.node_info.append(temp_model.from_map(k))
        return self


class DescribeDBInstanceHAConfigResponseBody(TeaModel):
    def __init__(self, dbinstance_id=None, hamode=None, host_instance_infos=None, request_id=None, sync_mode=None):
        # The ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        # The high availability mode of the instance. Valid values:
        # 
        # *   **RPO**: Data consistency is preferred. The instance ensures data reliability to minimize data losses. If you have high requirements on data consistency, select this mode.
        # *   **RTO**: Instance availability is preferred. The instance restores the database service at the earliest opportunity to ensure instance availability. If you have high requirements on instance availability, select this mode.
        # 
        # > This parameter is returned only for instances that run MySQL.
        self.hamode = hamode  # type: str
        # An array that consists of the information of the primary and secondary instances.
        self.host_instance_infos = host_instance_infos  # type: DescribeDBInstanceHAConfigResponseBodyHostInstanceInfos
        # The ID of the request.
        self.request_id = request_id  # type: str
        # [The data replication mode of the instance.](~~96055~~) Valid values:
        # 
        # *   **Sync**: the synchronous mode
        # *   **Semi-sync**: the semi-synchronous mode
        # *   **Async**: the asynchronous mode
        # 
        # > This parameter is returned only for instances that run MySQL.
        self.sync_mode = sync_mode  # type: str

    def validate(self):
        if self.host_instance_infos:
            self.host_instance_infos.validate()

    def to_map(self):
        _map = super(DescribeDBInstanceHAConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.hamode is not None:
            result['HAMode'] = self.hamode
        if self.host_instance_infos is not None:
            result['HostInstanceInfos'] = self.host_instance_infos.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.sync_mode is not None:
            result['SyncMode'] = self.sync_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('HAMode') is not None:
            self.hamode = m.get('HAMode')
        if m.get('HostInstanceInfos') is not None:
            temp_model = DescribeDBInstanceHAConfigResponseBodyHostInstanceInfos()
            self.host_instance_infos = temp_model.from_map(m['HostInstanceInfos'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SyncMode') is not None:
            self.sync_mode = m.get('SyncMode')
        return self


class DescribeDBInstanceHAConfigResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDBInstanceHAConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDBInstanceHAConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDBInstanceHAConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDBInstanceIPArrayListRequest(TeaModel):
    def __init__(self, dbinstance_id=None, owner_account=None, resource_owner_id=None, whitelist_network_type=None):
        # The ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        self.owner_account = owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The network type of IP address whitelist to query. Valid values:
        # 
        # *   **Classic**: classic network type. This value applies in enhanced whitelist mode.
        # *   **VPC**: VPC network type. This value applies in enhanced whitelist mode.
        # *   **MIX**: classic and VPC network types. This value applies in standard whitelist mode.
        # 
        # This operation returns IP address whitelists of all network types by default.
        self.whitelist_network_type = whitelist_network_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDBInstanceIPArrayListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.whitelist_network_type is not None:
            result['WhitelistNetworkType'] = self.whitelist_network_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('WhitelistNetworkType') is not None:
            self.whitelist_network_type = m.get('WhitelistNetworkType')
        return self


class DescribeDBInstanceIPArrayListResponseBodyItemsDBInstanceIPArray(TeaModel):
    def __init__(self, dbinstance_iparray_attribute=None, dbinstance_iparray_name=None, security_iplist=None,
                 security_iptype=None):
        # The attribute of the IP address whitelist. This parameter is empty by default.
        # 
        # >  The IP address whitelists that have the hidden attribute are not displayed in the ApsaraDB RDS console. These IP address whitelists are used to access Alibaba Cloud services such as Data Transmission Service (DTS).
        self.dbinstance_iparray_attribute = dbinstance_iparray_attribute  # type: str
        # The name of the IP address whitelist.
        self.dbinstance_iparray_name = dbinstance_iparray_name  # type: str
        # An array that consists of IP addresses in the IP address whitelist.
        self.security_iplist = security_iplist  # type: str
        # The type of the IP address.
        self.security_iptype = security_iptype  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDBInstanceIPArrayListResponseBodyItemsDBInstanceIPArray, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_iparray_attribute is not None:
            result['DBInstanceIPArrayAttribute'] = self.dbinstance_iparray_attribute
        if self.dbinstance_iparray_name is not None:
            result['DBInstanceIPArrayName'] = self.dbinstance_iparray_name
        if self.security_iplist is not None:
            result['SecurityIPList'] = self.security_iplist
        if self.security_iptype is not None:
            result['SecurityIPType'] = self.security_iptype
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DBInstanceIPArrayAttribute') is not None:
            self.dbinstance_iparray_attribute = m.get('DBInstanceIPArrayAttribute')
        if m.get('DBInstanceIPArrayName') is not None:
            self.dbinstance_iparray_name = m.get('DBInstanceIPArrayName')
        if m.get('SecurityIPList') is not None:
            self.security_iplist = m.get('SecurityIPList')
        if m.get('SecurityIPType') is not None:
            self.security_iptype = m.get('SecurityIPType')
        return self


class DescribeDBInstanceIPArrayListResponseBodyItems(TeaModel):
    def __init__(self, dbinstance_iparray=None):
        self.dbinstance_iparray = dbinstance_iparray  # type: list[DescribeDBInstanceIPArrayListResponseBodyItemsDBInstanceIPArray]

    def validate(self):
        if self.dbinstance_iparray:
            for k in self.dbinstance_iparray:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDBInstanceIPArrayListResponseBodyItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DBInstanceIPArray'] = []
        if self.dbinstance_iparray is not None:
            for k in self.dbinstance_iparray:
                result['DBInstanceIPArray'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.dbinstance_iparray = []
        if m.get('DBInstanceIPArray') is not None:
            for k in m.get('DBInstanceIPArray'):
                temp_model = DescribeDBInstanceIPArrayListResponseBodyItemsDBInstanceIPArray()
                self.dbinstance_iparray.append(temp_model.from_map(k))
        return self


class DescribeDBInstanceIPArrayListResponseBody(TeaModel):
    def __init__(self, items=None, request_id=None):
        # An array that consists of IP address whitelists.
        self.items = items  # type: DescribeDBInstanceIPArrayListResponseBodyItems
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super(DescribeDBInstanceIPArrayListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.items is not None:
            result['Items'] = self.items.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Items') is not None:
            temp_model = DescribeDBInstanceIPArrayListResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDBInstanceIPArrayListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDBInstanceIPArrayListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDBInstanceIPArrayListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDBInstanceIPArrayListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDBInstanceIpHostnameRequest(TeaModel):
    def __init__(self, dbinstance_id=None, owner_account=None, owner_id=None, region_id=None,
                 resource_owner_account=None, resource_owner_id=None, security_token=None):
        # The ID of the RDS instance.
        self.dbinstance_id = dbinstance_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The region ID of the RDS instance. You can call the [DescribeRegions](~~26243~~) operation to query the most recent region list.
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.security_token = security_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDBInstanceIpHostnameRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class DescribeDBInstanceIpHostnameResponseBody(TeaModel):
    def __init__(self, dbinstance_id=None, ip_hostname_infos=None, request_id=None):
        # The ID of the RDS instance.
        self.dbinstance_id = dbinstance_id  # type: str
        # The private IP addresses and hostnames of the primary and standby RDS instances. Format: IP address 1,Hostname 1;IP address 2,Hostname 2.
        self.ip_hostname_infos = ip_hostname_infos  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDBInstanceIpHostnameResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.ip_hostname_infos is not None:
            result['IpHostnameInfos'] = self.ip_hostname_infos
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('IpHostnameInfos') is not None:
            self.ip_hostname_infos = m.get('IpHostnameInfos')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDBInstanceIpHostnameResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDBInstanceIpHostnameResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDBInstanceIpHostnameResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDBInstanceIpHostnameResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDBInstanceMetricsRequest(TeaModel):
    def __init__(self, dbinstance_name=None, resource_group_id=None, resource_owner_id=None):
        # The ID of the instance. You can call the [DescribeDBInstances](~~26232~~) operation to query the ID of the instance.
        self.dbinstance_name = dbinstance_name  # type: str
        # The ID of the resource group.
        self.resource_group_id = resource_group_id  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDBInstanceMetricsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_name is not None:
            result['DBInstanceName'] = self.dbinstance_name
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DBInstanceName') is not None:
            self.dbinstance_name = m.get('DBInstanceName')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeDBInstanceMetricsResponseBodyItems(TeaModel):
    def __init__(self, description=None, dimension=None, group_key=None, group_key_type=None, method=None,
                 metrics_key=None, metrics_key_alias=None, sort_rule=None, unit=None):
        # The description of the enhanced monitoring metric.
        self.description = description  # type: str
        # The category of the enhanced monitoring metric. Valid values:
        # 
        # *   **os**: OS metric
        # *   **db**: database metric
        self.dimension = dimension  # type: str
        # The key of the group to which the enhanced monitoring metric belongs.
        self.group_key = group_key  # type: str
        # The name of the group to which the enhanced monitoring metric belongs.
        self.group_key_type = group_key_type  # type: str
        # The method that is used to aggregate the monitoring data of the enhanced monitoring metric. Valid values:
        # 
        # *   **avg**: The system calculates the average value of the enhanced monitoring metric.
        # *   **min**: The system calculates the minimum value of the enhanced monitoring metric.
        # *   **max**: The system calculates the maximum value of the enhanced monitoring metric.
        self.method = method  # type: str
        # The key of the enhanced monitoring metric.
        self.metrics_key = metrics_key  # type: str
        # The alias of the enhanced monitoring metric.
        self.metrics_key_alias = metrics_key_alias  # type: str
        # The serial number of the enhanced monitoring metric.
        self.sort_rule = sort_rule  # type: int
        # The unit of the enhanced monitoring metric.
        self.unit = unit  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDBInstanceMetricsResponseBodyItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.dimension is not None:
            result['Dimension'] = self.dimension
        if self.group_key is not None:
            result['GroupKey'] = self.group_key
        if self.group_key_type is not None:
            result['GroupKeyType'] = self.group_key_type
        if self.method is not None:
            result['Method'] = self.method
        if self.metrics_key is not None:
            result['MetricsKey'] = self.metrics_key
        if self.metrics_key_alias is not None:
            result['MetricsKeyAlias'] = self.metrics_key_alias
        if self.sort_rule is not None:
            result['SortRule'] = self.sort_rule
        if self.unit is not None:
            result['Unit'] = self.unit
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Dimension') is not None:
            self.dimension = m.get('Dimension')
        if m.get('GroupKey') is not None:
            self.group_key = m.get('GroupKey')
        if m.get('GroupKeyType') is not None:
            self.group_key_type = m.get('GroupKeyType')
        if m.get('Method') is not None:
            self.method = m.get('Method')
        if m.get('MetricsKey') is not None:
            self.metrics_key = m.get('MetricsKey')
        if m.get('MetricsKeyAlias') is not None:
            self.metrics_key_alias = m.get('MetricsKeyAlias')
        if m.get('SortRule') is not None:
            self.sort_rule = m.get('SortRule')
        if m.get('Unit') is not None:
            self.unit = m.get('Unit')
        return self


class DescribeDBInstanceMetricsResponseBody(TeaModel):
    def __init__(self, dbinstance_name=None, items=None, request_id=None, total_record_count=None):
        # The ID of the instance.
        self.dbinstance_name = dbinstance_name  # type: str
        # An array consisting of the enhanced monitoring metrics that are enabled for the instance.
        self.items = items  # type: list[DescribeDBInstanceMetricsResponseBodyItems]
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The total number of enhanced monitoring metrics that are enabled for the instance.
        self.total_record_count = total_record_count  # type: int

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDBInstanceMetricsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_name is not None:
            result['DBInstanceName'] = self.dbinstance_name
        result['Items'] = []
        if self.items is not None:
            for k in self.items:
                result['Items'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_record_count is not None:
            result['TotalRecordCount'] = self.total_record_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DBInstanceName') is not None:
            self.dbinstance_name = m.get('DBInstanceName')
        self.items = []
        if m.get('Items') is not None:
            for k in m.get('Items'):
                temp_model = DescribeDBInstanceMetricsResponseBodyItems()
                self.items.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalRecordCount') is not None:
            self.total_record_count = m.get('TotalRecordCount')
        return self


class DescribeDBInstanceMetricsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDBInstanceMetricsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDBInstanceMetricsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDBInstanceMetricsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDBInstanceMonitorRequest(TeaModel):
    def __init__(self, client_token=None, dbinstance_id=None, owner_account=None, owner_id=None,
                 resource_owner_account=None, resource_owner_id=None):
        # The client token that is used to ensure the idempotence of the request. You can use the client to generate the value, but you must ensure that it is unique among different requests. The token can only contain ASCII characters and cannot exceed 64 characters in length.
        self.client_token = client_token  # type: str
        # The ID of the instance. You can call the [DescribeDBInstances](~~26232~~) operation to query the IDs of instances.
        self.dbinstance_id = dbinstance_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDBInstanceMonitorRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeDBInstanceMonitorResponseBody(TeaModel):
    def __init__(self, period=None, request_id=None):
        # The monitoring frequency. Unit: seconds.
        self.period = period  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDBInstanceMonitorResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.period is not None:
            result['Period'] = self.period
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDBInstanceMonitorResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDBInstanceMonitorResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDBInstanceMonitorResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDBInstanceMonitorResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDBInstanceNetInfoRequest(TeaModel):
    def __init__(self, client_token=None, dbinstance_id=None, dbinstance_net_rwsplit_type=None, flag=None,
                 general_group_name=None, owner_account=None, owner_id=None, resource_owner_account=None, resource_owner_id=None):
        # The client token that is used to ensure the idempotence of the request. You can use the client to generate the token, but you must make sure that the generated token is unique among different requests. The token can contain only ASCII characters and cannot exceed 64 characters in length.
        self.client_token = client_token  # type: str
        # The ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        # The type of the endpoint. Valid values:
        # 
        # *   **Normal**: regular endpoint
        # *   **ReadWriteSplitting**: read/write splitting endpoint
        # 
        # >  By default, the system returns both types of endpoints.
        self.dbinstance_net_rwsplit_type = dbinstance_net_rwsplit_type  # type: str
        # A reserved parameter.
        self.flag = flag  # type: int
        # The name of the dedicated cluster to which the instance belongs. This parameter takes effect only when the instance runs MySQL on RDS Standard Edition and is created in a dedicated cluster.
        self.general_group_name = general_group_name  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDBInstanceNetInfoRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dbinstance_net_rwsplit_type is not None:
            result['DBInstanceNetRWSplitType'] = self.dbinstance_net_rwsplit_type
        if self.flag is not None:
            result['Flag'] = self.flag
        if self.general_group_name is not None:
            result['GeneralGroupName'] = self.general_group_name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DBInstanceNetRWSplitType') is not None:
            self.dbinstance_net_rwsplit_type = m.get('DBInstanceNetRWSplitType')
        if m.get('Flag') is not None:
            self.flag = m.get('Flag')
        if m.get('GeneralGroupName') is not None:
            self.general_group_name = m.get('GeneralGroupName')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeDBInstanceNetInfoResponseBodyDBInstanceNetInfosDBInstanceNetInfoDBInstanceWeightsDBInstanceWeight(TeaModel):
    def __init__(self, availability=None, dbinstance_id=None, dbinstance_type=None, role=None, weight=None):
        # The availability of the instance. Valid values:
        # 
        # - **Unavailable**\
        # - **Available**\
        self.availability = availability  # type: str
        # The ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        # The role of the instance. Valid values:
        # 
        # - **Master**: primary instance
        # - **Readonly**: read-only instance
        self.dbinstance_type = dbinstance_type  # type: str
        # A deprecated parameter.
        self.role = role  # type: str
        # The weight of the instance.
        self.weight = weight  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDBInstanceNetInfoResponseBodyDBInstanceNetInfosDBInstanceNetInfoDBInstanceWeightsDBInstanceWeight, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.availability is not None:
            result['Availability'] = self.availability
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dbinstance_type is not None:
            result['DBInstanceType'] = self.dbinstance_type
        if self.role is not None:
            result['Role'] = self.role
        if self.weight is not None:
            result['Weight'] = self.weight
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Availability') is not None:
            self.availability = m.get('Availability')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DBInstanceType') is not None:
            self.dbinstance_type = m.get('DBInstanceType')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('Weight') is not None:
            self.weight = m.get('Weight')
        return self


class DescribeDBInstanceNetInfoResponseBodyDBInstanceNetInfosDBInstanceNetInfoDBInstanceWeights(TeaModel):
    def __init__(self, dbinstance_weight=None):
        self.dbinstance_weight = dbinstance_weight  # type: list[DescribeDBInstanceNetInfoResponseBodyDBInstanceNetInfosDBInstanceNetInfoDBInstanceWeightsDBInstanceWeight]

    def validate(self):
        if self.dbinstance_weight:
            for k in self.dbinstance_weight:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDBInstanceNetInfoResponseBodyDBInstanceNetInfosDBInstanceNetInfoDBInstanceWeights, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DBInstanceWeight'] = []
        if self.dbinstance_weight is not None:
            for k in self.dbinstance_weight:
                result['DBInstanceWeight'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.dbinstance_weight = []
        if m.get('DBInstanceWeight') is not None:
            for k in m.get('DBInstanceWeight'):
                temp_model = DescribeDBInstanceNetInfoResponseBodyDBInstanceNetInfosDBInstanceNetInfoDBInstanceWeightsDBInstanceWeight()
                self.dbinstance_weight.append(temp_model.from_map(k))
        return self


class DescribeDBInstanceNetInfoResponseBodyDBInstanceNetInfosDBInstanceNetInfoSecurityIPGroupsSecurityIPGroup(TeaModel):
    def __init__(self, security_ipgroup_name=None, security_ips=None):
        # The name of the IP address whitelist.
        self.security_ipgroup_name = security_ipgroup_name  # type: str
        # The IP addresses contained in the IP address whitelist.
        self.security_ips = security_ips  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDBInstanceNetInfoResponseBodyDBInstanceNetInfosDBInstanceNetInfoSecurityIPGroupsSecurityIPGroup, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.security_ipgroup_name is not None:
            result['SecurityIPGroupName'] = self.security_ipgroup_name
        if self.security_ips is not None:
            result['SecurityIPs'] = self.security_ips
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SecurityIPGroupName') is not None:
            self.security_ipgroup_name = m.get('SecurityIPGroupName')
        if m.get('SecurityIPs') is not None:
            self.security_ips = m.get('SecurityIPs')
        return self


class DescribeDBInstanceNetInfoResponseBodyDBInstanceNetInfosDBInstanceNetInfoSecurityIPGroups(TeaModel):
    def __init__(self, security_ipgroup=None):
        self.security_ipgroup = security_ipgroup  # type: list[DescribeDBInstanceNetInfoResponseBodyDBInstanceNetInfosDBInstanceNetInfoSecurityIPGroupsSecurityIPGroup]

    def validate(self):
        if self.security_ipgroup:
            for k in self.security_ipgroup:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDBInstanceNetInfoResponseBodyDBInstanceNetInfosDBInstanceNetInfoSecurityIPGroups, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['securityIPGroup'] = []
        if self.security_ipgroup is not None:
            for k in self.security_ipgroup:
                result['securityIPGroup'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.security_ipgroup = []
        if m.get('securityIPGroup') is not None:
            for k in m.get('securityIPGroup'):
                temp_model = DescribeDBInstanceNetInfoResponseBodyDBInstanceNetInfosDBInstanceNetInfoSecurityIPGroupsSecurityIPGroup()
                self.security_ipgroup.append(temp_model.from_map(k))
        return self


class DescribeDBInstanceNetInfoResponseBodyDBInstanceNetInfosDBInstanceNetInfo(TeaModel):
    def __init__(self, babelfish_port=None, connection_string=None, connection_string_type=None,
                 dbinstance_weights=None, distribution_type=None, expired_time=None, ipaddress=None, iptype=None, max_delay_time=None,
                 port=None, security_ipgroups=None, upgradeable=None, vpcid=None, v_switch_id=None):
        # The Tabular Data Stream (TDS) port of the instance for which Babelfish is enabled.
        # 
        # >  This parameter applies only to ApsaraDB RDS for PostgreSQL instances. For more information about Babelfish for ApsaraDB RDS for PostgreSQL, see [Introduction to Babelfish](~~428613~~).
        self.babelfish_port = babelfish_port  # type: str
        # The endpoint of the instance.
        self.connection_string = connection_string  # type: str
        # The type of the endpoint. Valid values:
        # 
        # *   **Normal**: regular endpoint
        # *   **ReadWriteSplitting**: read/write splitting endpoint
        self.connection_string_type = connection_string_type  # type: str
        # Details of the weight. This parameter is returned only when the read/write splitting feature is enabled for the instance.
        self.dbinstance_weights = dbinstance_weights  # type: DescribeDBInstanceNetInfoResponseBodyDBInstanceNetInfosDBInstanceNetInfoDBInstanceWeights
        # The policy that is used to assign read weights. This parameter is returned only for a read/write splitting endpoint. Valid values:
        # 
        # *   **Standard**: ApsaraDB RDS automatically assigns read weights to the instance and its read-only instances based on the specifications of these instances.
        # *   **Custom**: You must manually assign read weights to the instance and its read-only instances.
        self.distribution_type = distribution_type  # type: str
        # The remaining validity period of the instance of the classic network in hybrid access mode. Unit: seconds.
        self.expired_time = expired_time  # type: str
        # The IP address of the instance.
        self.ipaddress = ipaddress  # type: str
        # The network type.
        # 
        # *   Valid values when the instance resides in the classic network:
        # 
        #     *   **Inner:**: internal network
        #     *   **Public**: Internet
        # 
        # *   Valid values when the instance resides in a virtual private cloud (VPC):
        # 
        #     *   **Private**: internal network
        #     *   **Public**: Internet
        self.iptype = iptype  # type: str
        # The latency threshold. This parameter is returned only for a read/write splitting endpoint. Unit: seconds.
        # 
        # >  If the latency on a read-only instance exceeds the specified threshold, ApsaraDB RDS no longer forwards read requests to the read-only instance.
        self.max_delay_time = max_delay_time  # type: str
        # The port that is used to connect to the instance.
        self.port = port  # type: str
        # Details about the IP whitelists of the instance.
        self.security_ipgroups = security_ipgroups  # type: DescribeDBInstanceNetInfoResponseBodyDBInstanceNetInfosDBInstanceNetInfoSecurityIPGroups
        # Indicates whether the IP version can be updated. Valid values:
        # 
        # *   **Enable**: The IP version can be updated.
        # 
        # *   **Disabled**: The IP version cannot be updated.
        # 
        # > The IP version can be updated from IPv4 to IPv6.
        self.upgradeable = upgradeable  # type: str
        # The ID of the VPC to which the instance belongs.
        self.vpcid = vpcid  # type: str
        # The ID of the vSwitch.
        self.v_switch_id = v_switch_id  # type: str

    def validate(self):
        if self.dbinstance_weights:
            self.dbinstance_weights.validate()
        if self.security_ipgroups:
            self.security_ipgroups.validate()

    def to_map(self):
        _map = super(DescribeDBInstanceNetInfoResponseBodyDBInstanceNetInfosDBInstanceNetInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.babelfish_port is not None:
            result['BabelfishPort'] = self.babelfish_port
        if self.connection_string is not None:
            result['ConnectionString'] = self.connection_string
        if self.connection_string_type is not None:
            result['ConnectionStringType'] = self.connection_string_type
        if self.dbinstance_weights is not None:
            result['DBInstanceWeights'] = self.dbinstance_weights.to_map()
        if self.distribution_type is not None:
            result['DistributionType'] = self.distribution_type
        if self.expired_time is not None:
            result['ExpiredTime'] = self.expired_time
        if self.ipaddress is not None:
            result['IPAddress'] = self.ipaddress
        if self.iptype is not None:
            result['IPType'] = self.iptype
        if self.max_delay_time is not None:
            result['MaxDelayTime'] = self.max_delay_time
        if self.port is not None:
            result['Port'] = self.port
        if self.security_ipgroups is not None:
            result['SecurityIPGroups'] = self.security_ipgroups.to_map()
        if self.upgradeable is not None:
            result['Upgradeable'] = self.upgradeable
        if self.vpcid is not None:
            result['VPCId'] = self.vpcid
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BabelfishPort') is not None:
            self.babelfish_port = m.get('BabelfishPort')
        if m.get('ConnectionString') is not None:
            self.connection_string = m.get('ConnectionString')
        if m.get('ConnectionStringType') is not None:
            self.connection_string_type = m.get('ConnectionStringType')
        if m.get('DBInstanceWeights') is not None:
            temp_model = DescribeDBInstanceNetInfoResponseBodyDBInstanceNetInfosDBInstanceNetInfoDBInstanceWeights()
            self.dbinstance_weights = temp_model.from_map(m['DBInstanceWeights'])
        if m.get('DistributionType') is not None:
            self.distribution_type = m.get('DistributionType')
        if m.get('ExpiredTime') is not None:
            self.expired_time = m.get('ExpiredTime')
        if m.get('IPAddress') is not None:
            self.ipaddress = m.get('IPAddress')
        if m.get('IPType') is not None:
            self.iptype = m.get('IPType')
        if m.get('MaxDelayTime') is not None:
            self.max_delay_time = m.get('MaxDelayTime')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('SecurityIPGroups') is not None:
            temp_model = DescribeDBInstanceNetInfoResponseBodyDBInstanceNetInfosDBInstanceNetInfoSecurityIPGroups()
            self.security_ipgroups = temp_model.from_map(m['SecurityIPGroups'])
        if m.get('Upgradeable') is not None:
            self.upgradeable = m.get('Upgradeable')
        if m.get('VPCId') is not None:
            self.vpcid = m.get('VPCId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        return self


class DescribeDBInstanceNetInfoResponseBodyDBInstanceNetInfos(TeaModel):
    def __init__(self, dbinstance_net_info=None):
        self.dbinstance_net_info = dbinstance_net_info  # type: list[DescribeDBInstanceNetInfoResponseBodyDBInstanceNetInfosDBInstanceNetInfo]

    def validate(self):
        if self.dbinstance_net_info:
            for k in self.dbinstance_net_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDBInstanceNetInfoResponseBodyDBInstanceNetInfos, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DBInstanceNetInfo'] = []
        if self.dbinstance_net_info is not None:
            for k in self.dbinstance_net_info:
                result['DBInstanceNetInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.dbinstance_net_info = []
        if m.get('DBInstanceNetInfo') is not None:
            for k in m.get('DBInstanceNetInfo'):
                temp_model = DescribeDBInstanceNetInfoResponseBodyDBInstanceNetInfosDBInstanceNetInfo()
                self.dbinstance_net_info.append(temp_model.from_map(k))
        return self


class DescribeDBInstanceNetInfoResponseBody(TeaModel):
    def __init__(self, dbinstance_net_infos=None, instance_network_type=None, request_id=None,
                 security_ipmode=None):
        # Details of the endpoints of the instance.
        self.dbinstance_net_infos = dbinstance_net_infos  # type: DescribeDBInstanceNetInfoResponseBodyDBInstanceNetInfos
        # The network type of the instance. Valid values:
        # 
        # *   **Classic**\
        # *   **VPC**\
        self.instance_network_type = instance_network_type  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The whitelist mode of the instance. Valid values:
        # 
        # *   **normal**: standard whitelist mode
        # *   **safety**: enhanced whitelist mode
        self.security_ipmode = security_ipmode  # type: str

    def validate(self):
        if self.dbinstance_net_infos:
            self.dbinstance_net_infos.validate()

    def to_map(self):
        _map = super(DescribeDBInstanceNetInfoResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_net_infos is not None:
            result['DBInstanceNetInfos'] = self.dbinstance_net_infos.to_map()
        if self.instance_network_type is not None:
            result['InstanceNetworkType'] = self.instance_network_type
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.security_ipmode is not None:
            result['SecurityIPMode'] = self.security_ipmode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DBInstanceNetInfos') is not None:
            temp_model = DescribeDBInstanceNetInfoResponseBodyDBInstanceNetInfos()
            self.dbinstance_net_infos = temp_model.from_map(m['DBInstanceNetInfos'])
        if m.get('InstanceNetworkType') is not None:
            self.instance_network_type = m.get('InstanceNetworkType')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SecurityIPMode') is not None:
            self.security_ipmode = m.get('SecurityIPMode')
        return self


class DescribeDBInstanceNetInfoResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDBInstanceNetInfoResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDBInstanceNetInfoResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDBInstanceNetInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDBInstanceNetInfoForChannelRequest(TeaModel):
    def __init__(self, client_token=None, dbinstance_id=None, dbinstance_net_rwsplit_type=None, flag=None,
                 owner_account=None, owner_id=None, resource_owner_account=None, resource_owner_id=None):
        # The client token that is used to ensure the idempotence of the request. You can use the client to generate the token, but you must make sure that the generated token is unique among different requests. The token can contain only ASCII characters and cannot exceed 64 characters in length.
        self.client_token = client_token  # type: str
        # The ID of the instance. You can call the [DescribeDBInstances](~~26232~~) operation to query the ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        # The type of the endpoint to query. Valid values:
        # 
        # *   **0**: a regular endpoint. This is the default value.
        # *   **1**: a read/write splitting endpoint that is assigned after the shared proxy feature is enabled.
        self.dbinstance_net_rwsplit_type = dbinstance_net_rwsplit_type  # type: str
        # An internal parameter. You do not need to specify this parameter.
        self.flag = flag  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDBInstanceNetInfoForChannelRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dbinstance_net_rwsplit_type is not None:
            result['DBInstanceNetRWSplitType'] = self.dbinstance_net_rwsplit_type
        if self.flag is not None:
            result['Flag'] = self.flag
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DBInstanceNetRWSplitType') is not None:
            self.dbinstance_net_rwsplit_type = m.get('DBInstanceNetRWSplitType')
        if m.get('Flag') is not None:
            self.flag = m.get('Flag')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeDBInstanceNetInfoForChannelResponseBodyDBInstanceNetInfosDBInstanceNetInfoDBInstanceWeightsDBInstanceWeight(TeaModel):
    def __init__(self, availability=None, dbinstance_id=None, dbinstance_type=None, weight=None):
        # The availability of the instance. Valid values:
        # 
        # *   **Unavailable**\
        # *   **Available**\
        self.availability = availability  # type: str
        # The ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        # The type of the instance. Valid values:
        # 
        # *   **Master**: primary instance
        # *   **Readonly**: read-only instance
        self.dbinstance_type = dbinstance_type  # type: str
        # The weight of the instance.
        self.weight = weight  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDBInstanceNetInfoForChannelResponseBodyDBInstanceNetInfosDBInstanceNetInfoDBInstanceWeightsDBInstanceWeight, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.availability is not None:
            result['Availability'] = self.availability
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dbinstance_type is not None:
            result['DBInstanceType'] = self.dbinstance_type
        if self.weight is not None:
            result['Weight'] = self.weight
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Availability') is not None:
            self.availability = m.get('Availability')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DBInstanceType') is not None:
            self.dbinstance_type = m.get('DBInstanceType')
        if m.get('Weight') is not None:
            self.weight = m.get('Weight')
        return self


class DescribeDBInstanceNetInfoForChannelResponseBodyDBInstanceNetInfosDBInstanceNetInfoDBInstanceWeights(TeaModel):
    def __init__(self, dbinstance_weight=None):
        self.dbinstance_weight = dbinstance_weight  # type: list[DescribeDBInstanceNetInfoForChannelResponseBodyDBInstanceNetInfosDBInstanceNetInfoDBInstanceWeightsDBInstanceWeight]

    def validate(self):
        if self.dbinstance_weight:
            for k in self.dbinstance_weight:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDBInstanceNetInfoForChannelResponseBodyDBInstanceNetInfosDBInstanceNetInfoDBInstanceWeights, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DBInstanceWeight'] = []
        if self.dbinstance_weight is not None:
            for k in self.dbinstance_weight:
                result['DBInstanceWeight'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.dbinstance_weight = []
        if m.get('DBInstanceWeight') is not None:
            for k in m.get('DBInstanceWeight'):
                temp_model = DescribeDBInstanceNetInfoForChannelResponseBodyDBInstanceNetInfosDBInstanceNetInfoDBInstanceWeightsDBInstanceWeight()
                self.dbinstance_weight.append(temp_model.from_map(k))
        return self


class DescribeDBInstanceNetInfoForChannelResponseBodyDBInstanceNetInfosDBInstanceNetInfoSecurityIPGroupsSecurityIPGroup(TeaModel):
    def __init__(self, security_ipgroup_name=None, security_ips=None):
        # The name of the IP address whitelist.
        self.security_ipgroup_name = security_ipgroup_name  # type: str
        # The IP addresses contained in the IP address whitelist.
        self.security_ips = security_ips  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDBInstanceNetInfoForChannelResponseBodyDBInstanceNetInfosDBInstanceNetInfoSecurityIPGroupsSecurityIPGroup, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.security_ipgroup_name is not None:
            result['SecurityIPGroupName'] = self.security_ipgroup_name
        if self.security_ips is not None:
            result['SecurityIPs'] = self.security_ips
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SecurityIPGroupName') is not None:
            self.security_ipgroup_name = m.get('SecurityIPGroupName')
        if m.get('SecurityIPs') is not None:
            self.security_ips = m.get('SecurityIPs')
        return self


class DescribeDBInstanceNetInfoForChannelResponseBodyDBInstanceNetInfosDBInstanceNetInfoSecurityIPGroups(TeaModel):
    def __init__(self, security_ipgroup=None):
        self.security_ipgroup = security_ipgroup  # type: list[DescribeDBInstanceNetInfoForChannelResponseBodyDBInstanceNetInfosDBInstanceNetInfoSecurityIPGroupsSecurityIPGroup]

    def validate(self):
        if self.security_ipgroup:
            for k in self.security_ipgroup:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDBInstanceNetInfoForChannelResponseBodyDBInstanceNetInfosDBInstanceNetInfoSecurityIPGroups, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['securityIPGroup'] = []
        if self.security_ipgroup is not None:
            for k in self.security_ipgroup:
                result['securityIPGroup'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.security_ipgroup = []
        if m.get('securityIPGroup') is not None:
            for k in m.get('securityIPGroup'):
                temp_model = DescribeDBInstanceNetInfoForChannelResponseBodyDBInstanceNetInfosDBInstanceNetInfoSecurityIPGroupsSecurityIPGroup()
                self.security_ipgroup.append(temp_model.from_map(k))
        return self


class DescribeDBInstanceNetInfoForChannelResponseBodyDBInstanceNetInfosDBInstanceNetInfo(TeaModel):
    def __init__(self, availability=None, connection_string=None, connection_string_type=None,
                 dbinstance_weights=None, distribution_type=None, ipaddress=None, iptype=None, max_delay_time=None, port=None,
                 security_ipgroups=None, upgradeable=None, vpcid=None, v_switch_id=None, expired_time=None):
        # The availability of the instance. Valid values:
        # 
        # *   **Unavailable**\
        # *   **Available**\
        self.availability = availability  # type: str
        # The endpoint of the instance.
        self.connection_string = connection_string  # type: str
        # The type of the endpoint. Valid values:
        # 
        # *   **Normal**: a regular endpoint
        # *   **ReadWriteSplitting**: a read/write splitting endpoint that is assigned after the shared proxy feature is enabled.
        self.connection_string_type = connection_string_type  # type: str
        # An array that consists of the information about read weights to implement read/write splitting after the shared proxy feature is enabled.
        self.dbinstance_weights = dbinstance_weights  # type: DescribeDBInstanceNetInfoForChannelResponseBodyDBInstanceNetInfosDBInstanceNetInfoDBInstanceWeights
        # The policy that is used to assign read weights. This parameter is returned only for a read/write splitting endpoint that is assigned after the shared proxy feature is enabled. Valid values:
        # 
        # *   **Standard**: ApsaraDB RDS automatically allocates read weights to the instance and its read-only instances based on the specifications of the instances.
        # *   **Custom**: You must manually allocate read weights to the instance and its read-only instances.
        self.distribution_type = distribution_type  # type: str
        # The IP address of the instance.
        self.ipaddress = ipaddress  # type: str
        # The network type of the IP address. Valid values:
        # 
        # *   **Public**: the Internet
        # *   **Inner**: the classic network
        # *   **Private**: a virtual private cloud (VPC)
        self.iptype = iptype  # type: str
        # The latency threshold that is allowed for read/write splitting of the shared proxy feature. Unit: seconds
        # 
        # > This parameter is returned only when the **ConnectionStringType** parameter is set to **ReadWriteSplitting**.
        self.max_delay_time = max_delay_time  # type: str
        # The port number of the instance.
        self.port = port  # type: str
        # Details of the IP address whitelist.
        self.security_ipgroups = security_ipgroups  # type: DescribeDBInstanceNetInfoForChannelResponseBodyDBInstanceNetInfosDBInstanceNetInfoSecurityIPGroups
        # An internal parameter. You can ignore this parameter.
        self.upgradeable = upgradeable  # type: str
        # The VPC ID of the instance.
        self.vpcid = vpcid  # type: str
        # The vSwitch ID of the instance.
        self.v_switch_id = v_switch_id  # type: str
        # The expiration time of the endpoint of the classic network type. Unit: seconds.
        self.expired_time = expired_time  # type: str

    def validate(self):
        if self.dbinstance_weights:
            self.dbinstance_weights.validate()
        if self.security_ipgroups:
            self.security_ipgroups.validate()

    def to_map(self):
        _map = super(DescribeDBInstanceNetInfoForChannelResponseBodyDBInstanceNetInfosDBInstanceNetInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.availability is not None:
            result['Availability'] = self.availability
        if self.connection_string is not None:
            result['ConnectionString'] = self.connection_string
        if self.connection_string_type is not None:
            result['ConnectionStringType'] = self.connection_string_type
        if self.dbinstance_weights is not None:
            result['DBInstanceWeights'] = self.dbinstance_weights.to_map()
        if self.distribution_type is not None:
            result['DistributionType'] = self.distribution_type
        if self.ipaddress is not None:
            result['IPAddress'] = self.ipaddress
        if self.iptype is not None:
            result['IPType'] = self.iptype
        if self.max_delay_time is not None:
            result['MaxDelayTime'] = self.max_delay_time
        if self.port is not None:
            result['Port'] = self.port
        if self.security_ipgroups is not None:
            result['SecurityIPGroups'] = self.security_ipgroups.to_map()
        if self.upgradeable is not None:
            result['Upgradeable'] = self.upgradeable
        if self.vpcid is not None:
            result['VPCId'] = self.vpcid
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.expired_time is not None:
            result['expiredTime'] = self.expired_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Availability') is not None:
            self.availability = m.get('Availability')
        if m.get('ConnectionString') is not None:
            self.connection_string = m.get('ConnectionString')
        if m.get('ConnectionStringType') is not None:
            self.connection_string_type = m.get('ConnectionStringType')
        if m.get('DBInstanceWeights') is not None:
            temp_model = DescribeDBInstanceNetInfoForChannelResponseBodyDBInstanceNetInfosDBInstanceNetInfoDBInstanceWeights()
            self.dbinstance_weights = temp_model.from_map(m['DBInstanceWeights'])
        if m.get('DistributionType') is not None:
            self.distribution_type = m.get('DistributionType')
        if m.get('IPAddress') is not None:
            self.ipaddress = m.get('IPAddress')
        if m.get('IPType') is not None:
            self.iptype = m.get('IPType')
        if m.get('MaxDelayTime') is not None:
            self.max_delay_time = m.get('MaxDelayTime')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('SecurityIPGroups') is not None:
            temp_model = DescribeDBInstanceNetInfoForChannelResponseBodyDBInstanceNetInfosDBInstanceNetInfoSecurityIPGroups()
            self.security_ipgroups = temp_model.from_map(m['SecurityIPGroups'])
        if m.get('Upgradeable') is not None:
            self.upgradeable = m.get('Upgradeable')
        if m.get('VPCId') is not None:
            self.vpcid = m.get('VPCId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('expiredTime') is not None:
            self.expired_time = m.get('expiredTime')
        return self


class DescribeDBInstanceNetInfoForChannelResponseBodyDBInstanceNetInfos(TeaModel):
    def __init__(self, dbinstance_net_info=None):
        self.dbinstance_net_info = dbinstance_net_info  # type: list[DescribeDBInstanceNetInfoForChannelResponseBodyDBInstanceNetInfosDBInstanceNetInfo]

    def validate(self):
        if self.dbinstance_net_info:
            for k in self.dbinstance_net_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDBInstanceNetInfoForChannelResponseBodyDBInstanceNetInfos, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DBInstanceNetInfo'] = []
        if self.dbinstance_net_info is not None:
            for k in self.dbinstance_net_info:
                result['DBInstanceNetInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.dbinstance_net_info = []
        if m.get('DBInstanceNetInfo') is not None:
            for k in m.get('DBInstanceNetInfo'):
                temp_model = DescribeDBInstanceNetInfoForChannelResponseBodyDBInstanceNetInfosDBInstanceNetInfo()
                self.dbinstance_net_info.append(temp_model.from_map(k))
        return self


class DescribeDBInstanceNetInfoForChannelResponseBody(TeaModel):
    def __init__(self, dbinstance_net_infos=None, instance_network_type=None, request_id=None):
        # An array that consists of the network information about the instance.
        self.dbinstance_net_infos = dbinstance_net_infos  # type: DescribeDBInstanceNetInfoForChannelResponseBodyDBInstanceNetInfos
        # The network type of the instance. Valid values:
        # 
        # *   **VPC**\
        # *   **Classic**\
        self.instance_network_type = instance_network_type  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.dbinstance_net_infos:
            self.dbinstance_net_infos.validate()

    def to_map(self):
        _map = super(DescribeDBInstanceNetInfoForChannelResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_net_infos is not None:
            result['DBInstanceNetInfos'] = self.dbinstance_net_infos.to_map()
        if self.instance_network_type is not None:
            result['InstanceNetworkType'] = self.instance_network_type
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DBInstanceNetInfos') is not None:
            temp_model = DescribeDBInstanceNetInfoForChannelResponseBodyDBInstanceNetInfos()
            self.dbinstance_net_infos = temp_model.from_map(m['DBInstanceNetInfos'])
        if m.get('InstanceNetworkType') is not None:
            self.instance_network_type = m.get('InstanceNetworkType')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDBInstanceNetInfoForChannelResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDBInstanceNetInfoForChannelResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDBInstanceNetInfoForChannelResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDBInstanceNetInfoForChannelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDBInstancePerformanceRequest(TeaModel):
    def __init__(self, dbinstance_id=None, end_time=None, key=None, node_id=None, resource_owner_id=None,
                 start_time=None):
        # The ID of the instance. You can call the [DescribeDBInstances](~~26232~~) operation to query the ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        # The end of the time range to query. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm*Z format. The time is displayed in UTC.
        # 
        # >  The time span between the beginning time and the end time must be longer than the monitoring frequency. Otherwise, this operation may return an empty array.
        self.end_time = end_time  # type: str
        # The performance metric that you want to query. If you enter more than one performance metric, separate them with commas (,). You can enter up to 30 performance metrics. For more information, see [Performance parameters](~~26316~~).
        # 
        # >  If you set the **Key** parameter to **MySQL_SpaceUsage** or **SQLServer_SpaceUsage**, you can query the performance metric only over one day.
        self.key = key  # type: str
        # The unique ID of the instance.
        self.node_id = node_id  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The beginning of the time range to query. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm*Z format. The time must be in UTC.
        # 
        # >  The time span between the beginning time and the end time must be longer than the monitoring frequency. Otherwise, this operation may return an empty array.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDBInstancePerformanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.key is not None:
            result['Key'] = self.key
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDBInstancePerformanceResponseBodyPerformanceKeysPerformanceKeyValuesPerformanceValue(TeaModel):
    def __init__(self, date=None, value=None):
        # The date and time when the value of the performance metric was recorded. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.date = date  # type: str
        # The value of the performance metric.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDBInstancePerformanceResponseBodyPerformanceKeysPerformanceKeyValuesPerformanceValue, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.date is not None:
            result['Date'] = self.date
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Date') is not None:
            self.date = m.get('Date')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeDBInstancePerformanceResponseBodyPerformanceKeysPerformanceKeyValues(TeaModel):
    def __init__(self, performance_value=None):
        self.performance_value = performance_value  # type: list[DescribeDBInstancePerformanceResponseBodyPerformanceKeysPerformanceKeyValuesPerformanceValue]

    def validate(self):
        if self.performance_value:
            for k in self.performance_value:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDBInstancePerformanceResponseBodyPerformanceKeysPerformanceKeyValues, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['PerformanceValue'] = []
        if self.performance_value is not None:
            for k in self.performance_value:
                result['PerformanceValue'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.performance_value = []
        if m.get('PerformanceValue') is not None:
            for k in m.get('PerformanceValue'):
                temp_model = DescribeDBInstancePerformanceResponseBodyPerformanceKeysPerformanceKeyValuesPerformanceValue()
                self.performance_value.append(temp_model.from_map(k))
        return self


class DescribeDBInstancePerformanceResponseBodyPerformanceKeysPerformanceKey(TeaModel):
    def __init__(self, key=None, unit=None, value_format=None, values=None):
        # The name of the performance metric.
        self.key = key  # type: str
        # The unit of the performance metric.
        self.unit = unit  # type: str
        # The format in which the value of the performance metric is returned. Multiple values of the performance metric are separated by the \&amp; string. Example: com_delete\&amp;com_insert\&amp;com_insert_select\&amp;com_replace.
        self.value_format = value_format  # type: str
        # An array that consists of the values of the performance metric in the following format: {value1, value2, ...}.
        self.values = values  # type: DescribeDBInstancePerformanceResponseBodyPerformanceKeysPerformanceKeyValues

    def validate(self):
        if self.values:
            self.values.validate()

    def to_map(self):
        _map = super(DescribeDBInstancePerformanceResponseBodyPerformanceKeysPerformanceKey, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.unit is not None:
            result['Unit'] = self.unit
        if self.value_format is not None:
            result['ValueFormat'] = self.value_format
        if self.values is not None:
            result['Values'] = self.values.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Unit') is not None:
            self.unit = m.get('Unit')
        if m.get('ValueFormat') is not None:
            self.value_format = m.get('ValueFormat')
        if m.get('Values') is not None:
            temp_model = DescribeDBInstancePerformanceResponseBodyPerformanceKeysPerformanceKeyValues()
            self.values = temp_model.from_map(m['Values'])
        return self


class DescribeDBInstancePerformanceResponseBodyPerformanceKeys(TeaModel):
    def __init__(self, performance_key=None):
        self.performance_key = performance_key  # type: list[DescribeDBInstancePerformanceResponseBodyPerformanceKeysPerformanceKey]

    def validate(self):
        if self.performance_key:
            for k in self.performance_key:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDBInstancePerformanceResponseBodyPerformanceKeys, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['PerformanceKey'] = []
        if self.performance_key is not None:
            for k in self.performance_key:
                result['PerformanceKey'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.performance_key = []
        if m.get('PerformanceKey') is not None:
            for k in m.get('PerformanceKey'):
                temp_model = DescribeDBInstancePerformanceResponseBodyPerformanceKeysPerformanceKey()
                self.performance_key.append(temp_model.from_map(k))
        return self


class DescribeDBInstancePerformanceResponseBody(TeaModel):
    def __init__(self, dbinstance_id=None, end_time=None, engine=None, performance_keys=None, request_id=None,
                 start_time=None):
        # The ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        # The end of the time range that is queried. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm*Z format. The time is displayed in UTC.
        self.end_time = end_time  # type: str
        # The database engine of the instance.
        self.engine = engine  # type: str
        # An array that consists of performance metrics.
        self.performance_keys = performance_keys  # type: DescribeDBInstancePerformanceResponseBodyPerformanceKeys
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The beginning of the time range that is queried. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm*Z format. The time is displayed in UTC.
        self.start_time = start_time  # type: str

    def validate(self):
        if self.performance_keys:
            self.performance_keys.validate()

    def to_map(self):
        _map = super(DescribeDBInstancePerformanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.performance_keys is not None:
            result['PerformanceKeys'] = self.performance_keys.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('PerformanceKeys') is not None:
            temp_model = DescribeDBInstancePerformanceResponseBodyPerformanceKeys()
            self.performance_keys = temp_model.from_map(m['PerformanceKeys'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDBInstancePerformanceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDBInstancePerformanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDBInstancePerformanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDBInstancePerformanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDBInstancePromoteActivityRequest(TeaModel):
    def __init__(self, ali_uid=None, db_instance_name=None, owner_id=None, resource_group_id=None,
                 resource_owner_account=None, resource_owner_id=None):
        self.ali_uid = ali_uid  # type: str
        self.db_instance_name = db_instance_name  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_group_id = resource_group_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDBInstancePromoteActivityRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ali_uid is not None:
            result['AliUid'] = self.ali_uid
        if self.db_instance_name is not None:
            result['DbInstanceName'] = self.db_instance_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AliUid') is not None:
            self.ali_uid = m.get('AliUid')
        if m.get('DbInstanceName') is not None:
            self.db_instance_name = m.get('DbInstanceName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeDBInstancePromoteActivityResponseBody(TeaModel):
    def __init__(self, ali_uid=None, bid=None, dbinstance_id=None, dbinstance_name=None, dbtype=None,
                 is_activity=None, request_id=None):
        self.ali_uid = ali_uid  # type: str
        self.bid = bid  # type: str
        self.dbinstance_id = dbinstance_id  # type: str
        self.dbinstance_name = dbinstance_name  # type: str
        self.dbtype = dbtype  # type: str
        self.is_activity = is_activity  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDBInstancePromoteActivityResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ali_uid is not None:
            result['AliUid'] = self.ali_uid
        if self.bid is not None:
            result['Bid'] = self.bid
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dbinstance_name is not None:
            result['DBInstanceName'] = self.dbinstance_name
        if self.dbtype is not None:
            result['DBType'] = self.dbtype
        if self.is_activity is not None:
            result['IsActivity'] = self.is_activity
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AliUid') is not None:
            self.ali_uid = m.get('AliUid')
        if m.get('Bid') is not None:
            self.bid = m.get('Bid')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DBInstanceName') is not None:
            self.dbinstance_name = m.get('DBInstanceName')
        if m.get('DBType') is not None:
            self.dbtype = m.get('DBType')
        if m.get('IsActivity') is not None:
            self.is_activity = m.get('IsActivity')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDBInstancePromoteActivityResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDBInstancePromoteActivityResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDBInstancePromoteActivityResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDBInstancePromoteActivityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDBInstanceProxyConfigurationRequest(TeaModel):
    def __init__(self, dbinstance_id=None, owner_id=None, resource_owner_account=None, resource_owner_id=None):
        # The ID of the instance.
        self.dbinstance_id = dbinstance_id  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDBInstanceProxyConfigurationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeDBInstanceProxyConfigurationResponseBody(TeaModel):
    def __init__(self, attacks_protection_configuration=None, persistent_connections_configuration=None,
                 request_id=None, transparent_switch_configuration=None):
        # Indicates whether the mechanism that is used to mitigate brute-force attacks is enabled:
        # 
        # *   **Enable**\
        # *   **Disable**\
        # 
        # The return value is a JSON string. Examples:
        # 
        # {"status":"Disable", "check_interval_seconds": 60,
        # 
        # "max_failed_login_attempts": 60, "blocking_seconds": 600}
        # 
        # Description:
        # 
        # *   Each client allows {max_failed_login_attempts} logon attempts that fail due to incorrect passwords within {check_interval_seconds} seconds. If one more such attempt is conducted, the client must wait for {blocking_seconds} seconds before you can try again.
        # 
        # *   Valid values:
        # 
        #     *   check_interval_seconds: **30 to 600**. Unit: seconds.
        #     *   max_failed_login_attempts: **10 to 5000**. Unit: times.
        #     *   blocking_seconds: **30 to 3600**. Unit: seconds.
        self.attacks_protection_configuration = attacks_protection_configuration  # type: str
        # Indicates whether the short-lived connection optimization feature is enabled.
        # 
        # *   **Enable**\
        # *   **Disable**\
        # 
        # The return value is a JSON string. Example:
        # 
        # {"status":"Disable"}.
        self.persistent_connections_configuration = persistent_connections_configuration  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # Indicates whether the transparent switchover feature is enabled.
        # 
        # *   **Enable**\
        # *   **Disable**\
        # 
        # The return value is a JSON string. Example:
        # 
        # {"status":"Enable"}.
        self.transparent_switch_configuration = transparent_switch_configuration  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDBInstanceProxyConfigurationResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attacks_protection_configuration is not None:
            result['AttacksProtectionConfiguration'] = self.attacks_protection_configuration
        if self.persistent_connections_configuration is not None:
            result['PersistentConnectionsConfiguration'] = self.persistent_connections_configuration
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.transparent_switch_configuration is not None:
            result['TransparentSwitchConfiguration'] = self.transparent_switch_configuration
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AttacksProtectionConfiguration') is not None:
            self.attacks_protection_configuration = m.get('AttacksProtectionConfiguration')
        if m.get('PersistentConnectionsConfiguration') is not None:
            self.persistent_connections_configuration = m.get('PersistentConnectionsConfiguration')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TransparentSwitchConfiguration') is not None:
            self.transparent_switch_configuration = m.get('TransparentSwitchConfiguration')
        return self


class DescribeDBInstanceProxyConfigurationResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDBInstanceProxyConfigurationResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDBInstanceProxyConfigurationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.stat