"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.hasDependencies = exports.bundle = exports.BUNDLER_DEPENDENCIES_CACHE = exports.DEPENDENCY_EXCLUDES = void 0;
const fs = require("fs");
const path = require("path");
const lambda = require("@aws-cdk/aws-lambda");
const cdk = require("@aws-cdk/core");
/**
 * Dependency files to exclude from the asset hash.
 */
exports.DEPENDENCY_EXCLUDES = ['*.pyc'];
/**
 * The location in the image that the bundler image caches dependencies.
 */
exports.BUNDLER_DEPENDENCIES_CACHE = '/var/dependencies';
/**
 * Produce bundled Lambda asset code
 */
function bundle(options) {
    const { entry, runtime, outputPathSuffix } = options;
    const hasDeps = hasDependencies(entry);
    const depsCommand = chain([
        hasDeps ? `rsync -r ${exports.BUNDLER_DEPENDENCIES_CACHE}/. ${cdk.AssetStaging.BUNDLING_OUTPUT_DIR}/${outputPathSuffix}` : '',
        `rsync -r . ${cdk.AssetStaging.BUNDLING_OUTPUT_DIR}/${outputPathSuffix}`,
    ]);
    // Determine which dockerfile to use. When dependencies are present, we use a
    // Dockerfile that can create a cacheable layer. We can't use this Dockerfile
    // if there aren't dependencies or the Dockerfile will complain about missing
    // sources.
    const dockerfile = hasDeps
        ? 'Dockerfile.dependencies'
        : 'Dockerfile';
    const image = cdk.BundlingDockerImage.fromAsset(entry, {
        buildArgs: {
            IMAGE: runtime.bundlingDockerImage.image,
        },
        file: path.join(__dirname, dockerfile),
    });
    return lambda.Code.fromAsset(entry, {
        assetHashType: cdk.AssetHashType.BUNDLE,
        exclude: exports.DEPENDENCY_EXCLUDES,
        bundling: {
            image,
            command: ['bash', '-c', depsCommand],
        },
    });
}
exports.bundle = bundle;
/**
 * Checks to see if the `entry` directory contains a type of dependency that
 * we know how to install.
 */
function hasDependencies(entry) {
    if (fs.existsSync(path.join(entry, 'Pipfile'))) {
        return true;
    }
    if (fs.existsSync(path.join(entry, 'requirements.txt'))) {
        return true;
    }
    return false;
}
exports.hasDependencies = hasDependencies;
function chain(commands) {
    return commands.filter(c => !!c).join(' && ');
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYnVuZGxpbmcuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJidW5kbGluZy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSx5QkFBeUI7QUFDekIsNkJBQTZCO0FBQzdCLDhDQUE4QztBQUM5QyxxQ0FBcUM7QUFFckM7O0dBRUc7QUFDVSxRQUFBLG1CQUFtQixHQUFHLENBQUMsT0FBTyxDQUFDLENBQUM7QUFFN0M7O0dBRUc7QUFDVSxRQUFBLDBCQUEwQixHQUFHLG1CQUFtQixDQUFDO0FBc0I5RDs7R0FFRztBQUNILFNBQWdCLE1BQU0sQ0FBQyxPQUF3QjtJQUM3QyxNQUFNLEVBQUUsS0FBSyxFQUFFLE9BQU8sRUFBRSxnQkFBZ0IsRUFBRSxHQUFHLE9BQU8sQ0FBQztJQUVyRCxNQUFNLE9BQU8sR0FBRyxlQUFlLENBQUMsS0FBSyxDQUFDLENBQUM7SUFFdkMsTUFBTSxXQUFXLEdBQUcsS0FBSyxDQUFDO1FBQ3hCLE9BQU8sQ0FBQyxDQUFDLENBQUMsWUFBWSxrQ0FBMEIsTUFBTSxHQUFHLENBQUMsWUFBWSxDQUFDLG1CQUFtQixJQUFJLGdCQUFnQixFQUFFLENBQUMsQ0FBQyxDQUFDLEVBQUU7UUFDckgsY0FBYyxHQUFHLENBQUMsWUFBWSxDQUFDLG1CQUFtQixJQUFJLGdCQUFnQixFQUFFO0tBQ3pFLENBQUMsQ0FBQztJQUVILDZFQUE2RTtJQUM3RSw2RUFBNkU7SUFDN0UsNkVBQTZFO0lBQzdFLFdBQVc7SUFDWCxNQUFNLFVBQVUsR0FBRyxPQUFPO1FBQ3hCLENBQUMsQ0FBQyx5QkFBeUI7UUFDM0IsQ0FBQyxDQUFDLFlBQVksQ0FBQztJQUVqQixNQUFNLEtBQUssR0FBRyxHQUFHLENBQUMsbUJBQW1CLENBQUMsU0FBUyxDQUFDLEtBQUssRUFBRTtRQUNyRCxTQUFTLEVBQUU7WUFDVCxLQUFLLEVBQUUsT0FBTyxDQUFDLG1CQUFtQixDQUFDLEtBQUs7U0FDekM7UUFDRCxJQUFJLEVBQUUsSUFBSSxDQUFDLElBQUksQ0FBQyxTQUFTLEVBQUUsVUFBVSxDQUFDO0tBQ3ZDLENBQUMsQ0FBQztJQUVILE9BQU8sTUFBTSxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsS0FBSyxFQUFFO1FBQ2xDLGFBQWEsRUFBRSxHQUFHLENBQUMsYUFBYSxDQUFDLE1BQU07UUFDdkMsT0FBTyxFQUFFLDJCQUFtQjtRQUM1QixRQUFRLEVBQUU7WUFDUixLQUFLO1lBQ0wsT0FBTyxFQUFFLENBQUMsTUFBTSxFQUFFLElBQUksRUFBRSxXQUFXLENBQUM7U0FDckM7S0FDRixDQUFDLENBQUM7QUFDTCxDQUFDO0FBakNELHdCQWlDQztBQUVEOzs7R0FHRztBQUNILFNBQWdCLGVBQWUsQ0FBQyxLQUFhO0lBQzNDLElBQUksRUFBRSxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLEtBQUssRUFBRSxTQUFTLENBQUMsQ0FBQyxFQUFFO1FBQzlDLE9BQU8sSUFBSSxDQUFDO0tBQ2I7SUFFRCxJQUFJLEVBQUUsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxLQUFLLEVBQUUsa0JBQWtCLENBQUMsQ0FBQyxFQUFFO1FBQ3ZELE9BQU8sSUFBSSxDQUFDO0tBQ2I7SUFFRCxPQUFPLEtBQUssQ0FBQztBQUNmLENBQUM7QUFWRCwwQ0FVQztBQUVELFNBQVMsS0FBSyxDQUFDLFFBQWtCO0lBQy9CLE9BQU8sUUFBUSxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLENBQUM7QUFDaEQsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGZzIGZyb20gJ2ZzJztcbmltcG9ydCAqIGFzIHBhdGggZnJvbSAncGF0aCc7XG5pbXBvcnQgKiBhcyBsYW1iZGEgZnJvbSAnQGF3cy1jZGsvYXdzLWxhbWJkYSc7XG5pbXBvcnQgKiBhcyBjZGsgZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5cbi8qKlxuICogRGVwZW5kZW5jeSBmaWxlcyB0byBleGNsdWRlIGZyb20gdGhlIGFzc2V0IGhhc2guXG4gKi9cbmV4cG9ydCBjb25zdCBERVBFTkRFTkNZX0VYQ0xVREVTID0gWycqLnB5YyddO1xuXG4vKipcbiAqIFRoZSBsb2NhdGlvbiBpbiB0aGUgaW1hZ2UgdGhhdCB0aGUgYnVuZGxlciBpbWFnZSBjYWNoZXMgZGVwZW5kZW5jaWVzLlxuICovXG5leHBvcnQgY29uc3QgQlVORExFUl9ERVBFTkRFTkNJRVNfQ0FDSEUgPSAnL3Zhci9kZXBlbmRlbmNpZXMnO1xuXG4vKipcbiAqIE9wdGlvbnMgZm9yIGJ1bmRsaW5nXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgQnVuZGxpbmdPcHRpb25zIHtcbiAgLyoqXG4gICAqIEVudHJ5IHBhdGhcbiAgICovXG4gIHJlYWRvbmx5IGVudHJ5OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSBydW50aW1lIG9mIHRoZSBsYW1iZGEgZnVuY3Rpb25cbiAgICovXG4gIHJlYWRvbmx5IHJ1bnRpbWU6IGxhbWJkYS5SdW50aW1lO1xuXG4gIC8qKlxuICAgKiBPdXRwdXQgcGF0aCBzdWZmaXggKCdweXRob24nIGZvciBhIGxheWVyLCAnLicgb3RoZXJ3aXNlKVxuICAgKi9cbiAgcmVhZG9ubHkgb3V0cHV0UGF0aFN1ZmZpeDogc3RyaW5nO1xufVxuXG4vKipcbiAqIFByb2R1Y2UgYnVuZGxlZCBMYW1iZGEgYXNzZXQgY29kZVxuICovXG5leHBvcnQgZnVuY3Rpb24gYnVuZGxlKG9wdGlvbnM6IEJ1bmRsaW5nT3B0aW9ucyk6IGxhbWJkYS5Bc3NldENvZGUge1xuICBjb25zdCB7IGVudHJ5LCBydW50aW1lLCBvdXRwdXRQYXRoU3VmZml4IH0gPSBvcHRpb25zO1xuXG4gIGNvbnN0IGhhc0RlcHMgPSBoYXNEZXBlbmRlbmNpZXMoZW50cnkpO1xuXG4gIGNvbnN0IGRlcHNDb21tYW5kID0gY2hhaW4oW1xuICAgIGhhc0RlcHMgPyBgcnN5bmMgLXIgJHtCVU5ETEVSX0RFUEVOREVOQ0lFU19DQUNIRX0vLiAke2Nkay5Bc3NldFN0YWdpbmcuQlVORExJTkdfT1VUUFVUX0RJUn0vJHtvdXRwdXRQYXRoU3VmZml4fWAgOiAnJyxcbiAgICBgcnN5bmMgLXIgLiAke2Nkay5Bc3NldFN0YWdpbmcuQlVORExJTkdfT1VUUFVUX0RJUn0vJHtvdXRwdXRQYXRoU3VmZml4fWAsXG4gIF0pO1xuXG4gIC8vIERldGVybWluZSB3aGljaCBkb2NrZXJmaWxlIHRvIHVzZS4gV2hlbiBkZXBlbmRlbmNpZXMgYXJlIHByZXNlbnQsIHdlIHVzZSBhXG4gIC8vIERvY2tlcmZpbGUgdGhhdCBjYW4gY3JlYXRlIGEgY2FjaGVhYmxlIGxheWVyLiBXZSBjYW4ndCB1c2UgdGhpcyBEb2NrZXJmaWxlXG4gIC8vIGlmIHRoZXJlIGFyZW4ndCBkZXBlbmRlbmNpZXMgb3IgdGhlIERvY2tlcmZpbGUgd2lsbCBjb21wbGFpbiBhYm91dCBtaXNzaW5nXG4gIC8vIHNvdXJjZXMuXG4gIGNvbnN0IGRvY2tlcmZpbGUgPSBoYXNEZXBzXG4gICAgPyAnRG9ja2VyZmlsZS5kZXBlbmRlbmNpZXMnXG4gICAgOiAnRG9ja2VyZmlsZSc7XG5cbiAgY29uc3QgaW1hZ2UgPSBjZGsuQnVuZGxpbmdEb2NrZXJJbWFnZS5mcm9tQXNzZXQoZW50cnksIHtcbiAgICBidWlsZEFyZ3M6IHtcbiAgICAgIElNQUdFOiBydW50aW1lLmJ1bmRsaW5nRG9ja2VySW1hZ2UuaW1hZ2UsXG4gICAgfSxcbiAgICBmaWxlOiBwYXRoLmpvaW4oX19kaXJuYW1lLCBkb2NrZXJmaWxlKSxcbiAgfSk7XG5cbiAgcmV0dXJuIGxhbWJkYS5Db2RlLmZyb21Bc3NldChlbnRyeSwge1xuICAgIGFzc2V0SGFzaFR5cGU6IGNkay5Bc3NldEhhc2hUeXBlLkJVTkRMRSxcbiAgICBleGNsdWRlOiBERVBFTkRFTkNZX0VYQ0xVREVTLFxuICAgIGJ1bmRsaW5nOiB7XG4gICAgICBpbWFnZSxcbiAgICAgIGNvbW1hbmQ6IFsnYmFzaCcsICctYycsIGRlcHNDb21tYW5kXSxcbiAgICB9LFxuICB9KTtcbn1cblxuLyoqXG4gKiBDaGVja3MgdG8gc2VlIGlmIHRoZSBgZW50cnlgIGRpcmVjdG9yeSBjb250YWlucyBhIHR5cGUgb2YgZGVwZW5kZW5jeSB0aGF0XG4gKiB3ZSBrbm93IGhvdyB0byBpbnN0YWxsLlxuICovXG5leHBvcnQgZnVuY3Rpb24gaGFzRGVwZW5kZW5jaWVzKGVudHJ5OiBzdHJpbmcpOiBib29sZWFuIHtcbiAgaWYgKGZzLmV4aXN0c1N5bmMocGF0aC5qb2luKGVudHJ5LCAnUGlwZmlsZScpKSkge1xuICAgIHJldHVybiB0cnVlO1xuICB9XG5cbiAgaWYgKGZzLmV4aXN0c1N5bmMocGF0aC5qb2luKGVudHJ5LCAncmVxdWlyZW1lbnRzLnR4dCcpKSkge1xuICAgIHJldHVybiB0cnVlO1xuICB9XG5cbiAgcmV0dXJuIGZhbHNlO1xufVxuXG5mdW5jdGlvbiBjaGFpbihjb21tYW5kczogc3RyaW5nW10pOiBzdHJpbmcge1xuICByZXR1cm4gY29tbWFuZHMuZmlsdGVyKGMgPT4gISFjKS5qb2luKCcgJiYgJyk7XG59XG4iXX0=