# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: proto/queue/v1/queue.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import (
    TYPE_CHECKING,
    Dict,
    List,
    Optional,
)

import betterproto
import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf
import grpclib
from betterproto.grpc.grpclib_server import ServiceBase


if TYPE_CHECKING:
    import grpclib.server
    from betterproto.grpc.grpclib_client import MetadataLike
    from grpclib.metadata import Deadline


@dataclass(eq=False, repr=False)
class QueueSendRequest(betterproto.Message):
    """Request to push a single event to a queue"""

    queue: str = betterproto.string_field(1)
    """
    The Nitric name for the queue this will automatically be resolved to the
    provider specific queue identifier.
    """

    task: "NitricTask" = betterproto.message_field(2)
    """The task to push to the queue"""


@dataclass(eq=False, repr=False)
class QueueSendResponse(betterproto.Message):
    """Result of pushing a single task to a queue"""

    pass


@dataclass(eq=False, repr=False)
class QueueSendBatchRequest(betterproto.Message):
    queue: str = betterproto.string_field(1)
    """
    The Nitric name for the queue this will automatically be resolved to the
    provider specific queue identifier.
    """

    tasks: List["NitricTask"] = betterproto.message_field(2)
    """Array of tasks to push to the queue"""


@dataclass(eq=False, repr=False)
class QueueSendBatchResponse(betterproto.Message):
    """Response for sending a collection of tasks"""

    failed_tasks: List["FailedTask"] = betterproto.message_field(1)
    """A list of tasks that failed to be queued"""


@dataclass(eq=False, repr=False)
class QueueReceiveRequest(betterproto.Message):
    queue: str = betterproto.string_field(1)
    """
    The nitric name for the queue this will automatically be resolved to the
    provider specific queue identifier.
    """

    depth: int = betterproto.int32_field(2)
    """
    The max number of items to pop off the queue, may be capped by provider
    specific limitations
    """


@dataclass(eq=False, repr=False)
class QueueReceiveResponse(betterproto.Message):
    tasks: List["NitricTask"] = betterproto.message_field(1)
    """Array of tasks popped off the queue"""


@dataclass(eq=False, repr=False)
class QueueCompleteRequest(betterproto.Message):
    queue: str = betterproto.string_field(1)
    """
    The nitric name for the queue  this will automatically be resolved to the
    provider specific queue identifier.
    """

    lease_id: str = betterproto.string_field(2)
    """Lease id of the task to be completed"""


@dataclass(eq=False, repr=False)
class QueueCompleteResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class FailedTask(betterproto.Message):
    task: "NitricTask" = betterproto.message_field(1)
    """The task that failed to be pushed"""

    message: str = betterproto.string_field(2)
    """A message describing the failure"""


@dataclass(eq=False, repr=False)
class NitricTask(betterproto.Message):
    """A task to be sent or received from a queue."""

    id: str = betterproto.string_field(1)
    """A unique id for the task"""

    lease_id: str = betterproto.string_field(2)
    """
    The lease id unique to the pop request, this must be used to complete,
    extend the lease or release the task.
    """

    payload_type: str = betterproto.string_field(3)
    """A content hint for the tasks payload"""

    payload: "betterproto_lib_google_protobuf.Struct" = betterproto.message_field(4)
    """The payload of the task"""


class QueueServiceStub(betterproto.ServiceStub):
    async def send(
        self,
        queue_send_request: "QueueSendRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueueSendResponse":
        return await self._unary_unary(
            "/nitric.queue.v1.QueueService/Send",
            queue_send_request,
            QueueSendResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def send_batch(
        self,
        queue_send_batch_request: "QueueSendBatchRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueueSendBatchResponse":
        return await self._unary_unary(
            "/nitric.queue.v1.QueueService/SendBatch",
            queue_send_batch_request,
            QueueSendBatchResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def receive(
        self,
        queue_receive_request: "QueueReceiveRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueueReceiveResponse":
        return await self._unary_unary(
            "/nitric.queue.v1.QueueService/Receive",
            queue_receive_request,
            QueueReceiveResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def complete(
        self,
        queue_complete_request: "QueueCompleteRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueueCompleteResponse":
        return await self._unary_unary(
            "/nitric.queue.v1.QueueService/Complete",
            queue_complete_request,
            QueueCompleteResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class QueueServiceBase(ServiceBase):
    async def send(self, queue_send_request: "QueueSendRequest") -> "QueueSendResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def send_batch(
        self, queue_send_batch_request: "QueueSendBatchRequest"
    ) -> "QueueSendBatchResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def receive(
        self, queue_receive_request: "QueueReceiveRequest"
    ) -> "QueueReceiveResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def complete(
        self, queue_complete_request: "QueueCompleteRequest"
    ) -> "QueueCompleteResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_send(
        self, stream: "grpclib.server.Stream[QueueSendRequest, QueueSendResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.send(request)
        await stream.send_message(response)

    async def __rpc_send_batch(
        self,
        stream: "grpclib.server.Stream[QueueSendBatchRequest, QueueSendBatchResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.send_batch(request)
        await stream.send_message(response)

    async def __rpc_receive(
        self, stream: "grpclib.server.Stream[QueueReceiveRequest, QueueReceiveResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.receive(request)
        await stream.send_message(response)

    async def __rpc_complete(
        self,
        stream: "grpclib.server.Stream[QueueCompleteRequest, QueueCompleteResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.complete(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/nitric.queue.v1.QueueService/Send": grpclib.const.Handler(
                self.__rpc_send,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueueSendRequest,
                QueueSendResponse,
            ),
            "/nitric.queue.v1.QueueService/SendBatch": grpclib.const.Handler(
                self.__rpc_send_batch,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueueSendBatchRequest,
                QueueSendBatchResponse,
            ),
            "/nitric.queue.v1.QueueService/Receive": grpclib.const.Handler(
                self.__rpc_receive,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueueReceiveRequest,
                QueueReceiveResponse,
            ),
            "/nitric.queue.v1.QueueService/Complete": grpclib.const.Handler(
                self.__rpc_complete,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueueCompleteRequest,
                QueueCompleteResponse,
            ),
        }
