/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.lib.tar;

import com.datapps.linkoopdb.jdbc.lib.InputStreamInterface;
import com.datapps.linkoopdb.jdbc.lib.InputStreamWrapper;
import com.datapps.linkoopdb.jdbc.lib.StringUtil;
import com.datapps.linkoopdb.jdbc.lib.tar.PIFGenerator;
import com.datapps.linkoopdb.jdbc.lib.tar.RB;
import com.datapps.linkoopdb.jdbc.lib.tar.TarFileOutputStream;
import com.datapps.linkoopdb.jdbc.lib.tar.TarHeaderField;
import com.datapps.linkoopdb.jdbc.lib.tar.TarMalformatException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class TarGenerator {
    protected TarFileOutputStream archive;
    protected List<TarEntrySupplicant> entryQueue = new ArrayList<TarEntrySupplicant>();
    protected long paxThreshold = 0x200000000L;

    public TarGenerator(File inFile, boolean overWrite, Integer blocksPerRecord) throws IOException {
        File archiveFile = inFile.getAbsoluteFile();
        int compression = 0;
        if (archiveFile.getName().endsWith(".tgz") || archiveFile.getName().endsWith(".tar.gz")) {
            compression = 1;
        } else if (!archiveFile.getName().endsWith(".tar")) {
            throw new IllegalArgumentException(RB.unsupported_ext.getString(this.getClass().getName(), archiveFile.getPath()));
        }
        if (archiveFile.exists()) {
            if (!overWrite) {
                throw new IOException(RB.dest_exists.getString(archiveFile.getPath()));
            }
        } else {
            File parentDir = archiveFile.getParentFile();
            if (parentDir.exists()) {
                if (!parentDir.isDirectory()) {
                    throw new IOException(RB.parent_not_dir.getString(parentDir.getPath()));
                }
                if (!parentDir.canWrite()) {
                    throw new IOException(RB.cant_write_parent.getString(parentDir.getPath()));
                }
            } else if (!parentDir.mkdirs()) {
                throw new IOException(RB.parent_create_fail.getString(parentDir.getPath()));
            }
        }
        TarFileOutputStream tarFileOutputStream = this.archive = blocksPerRecord == null ? new TarFileOutputStream(archiveFile, compression) : new TarFileOutputStream(archiveFile, compression, blocksPerRecord);
        if (blocksPerRecord != null && TarFileOutputStream.debug) {
            System.out.println(RB.bpr_write.getString(blocksPerRecord));
        }
    }

    public long getPaxThreshold() {
        return this.paxThreshold;
    }

    public void setPaxThreshold(long paxThreshold) {
        this.paxThreshold = paxThreshold;
    }

    public void queueEntry(File file) throws FileNotFoundException, TarMalformatException {
        this.queueEntry(null, file);
    }

    public void queueEntry(String entryPath, File file) throws FileNotFoundException, TarMalformatException {
        this.entryQueue.add(new TarEntrySupplicant(entryPath, file, this.archive, this.paxThreshold));
    }

    public void queueEntry(String entryPath, InputStreamInterface is) throws FileNotFoundException, TarMalformatException {
        this.entryQueue.add(new TarEntrySupplicant(entryPath, is, this.archive, this.paxThreshold));
    }

    public void queueEntry(String entryPath, InputStream inStream, int maxBytes) throws IOException, TarMalformatException {
        this.entryQueue.add(new TarEntrySupplicant(entryPath, inStream, maxBytes, '0', this.archive));
    }

    public void write() throws IOException, TarMalformatException {
        if (TarFileOutputStream.debug) {
            System.out.println(RB.write_queue_report.getString(this.entryQueue.size()));
        }
        try {
            for (int i = 0; i < this.entryQueue.size(); ++i) {
                System.out.print(Integer.toString(i + 1) + " / " + this.entryQueue.size() + ' ');
                TarEntrySupplicant entry = this.entryQueue.get(i);
                System.out.print(entry.getPath() + "... ");
                entry.write();
                this.archive.assertAtBlockBoundary();
                System.out.println();
            }
            this.archive.finish();
        }
        catch (IOException ioe) {
            System.out.println();
            try {
                for (TarEntrySupplicant sup : this.entryQueue) {
                    sup.close();
                }
                this.archive.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw ioe;
        }
    }

    protected static class TarEntrySupplicant {
        public static final String DEFAULT_FILE_MODES = "600";
        static final byte[] HEADER_TEMPLATE = (byte[])TarFileOutputStream.ZERO_BLOCK.clone();
        static final byte[] ustarBytes = new byte[]{117, 115, 116, 97, 114};
        static Character swapOutDelim = null;
        protected final long paxThreshold;
        protected byte[] rawHeader = (byte[])HEADER_TEMPLATE.clone();
        protected String fileMode = "600";
        protected InputStreamInterface inputStream;
        protected String path;
        protected long modTime;
        protected TarFileOutputStream tarStream;
        protected long dataSize;
        protected boolean paxSized = false;

        protected TarEntrySupplicant(String path, char typeFlag, TarFileOutputStream tarStream, long paxThreshold) throws TarMalformatException {
            this.paxThreshold = paxThreshold;
            if (path == null) {
                throw new IllegalArgumentException(RB.missing_supp_path.getString());
            }
            this.path = swapOutDelim == null ? path : path.replace(swapOutDelim.charValue(), '/');
            this.tarStream = tarStream;
            this.writeField(TarHeaderField.typeflag, typeFlag);
            if (typeFlag == '\u0000' || typeFlag == ' ') {
                TarEntrySupplicant.writeField(TarHeaderField.uname, System.getProperty("user.name"), HEADER_TEMPLATE);
                TarEntrySupplicant.writeField(TarHeaderField.gname, "root", HEADER_TEMPLATE);
            }
        }

        public TarEntrySupplicant(String path, File file, TarFileOutputStream tarStream, long paxThreshold) throws FileNotFoundException, TarMalformatException {
            this(path == null ? file.getPath() : path, '0', tarStream, paxThreshold);
            if (!file.isFile()) {
                throw new IllegalArgumentException(RB.nonfile_entry.getString());
            }
            if (!file.canRead()) {
                throw new IllegalArgumentException(RB.read_denied.getString(file.getAbsolutePath()));
            }
            this.modTime = file.lastModified() / 1000L;
            this.fileMode = TarEntrySupplicant.getLameMode(file);
            this.dataSize = file.length();
            this.inputStream = new InputStreamWrapper(new FileInputStream(file));
        }

        public TarEntrySupplicant(String path, InputStreamInterface is, TarFileOutputStream tarStream, long paxThreshold) throws FileNotFoundException, TarMalformatException {
            this(path, '0', tarStream, paxThreshold);
            this.modTime = System.currentTimeMillis() / 1000L;
            this.fileMode = DEFAULT_FILE_MODES;
            this.inputStream = is;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TarEntrySupplicant(String path, InputStream origStream, int maxBytes, char typeFlag, TarFileOutputStream tarStream) throws IOException, TarMalformatException {
            this(path, typeFlag, tarStream, 0x200000000L);
            if (maxBytes < 1) {
                throw new IllegalArgumentException(RB.read_lt_1.getString());
            }
            PipedOutputStream outPipe = new PipedOutputStream();
            try {
                int i;
                this.inputStream = new InputStreamWrapper(new PipedInputStream(outPipe));
                while ((i = origStream.read(tarStream.writeBuffer, 0, tarStream.writeBuffer.length)) > 0) {
                    outPipe.write(tarStream.writeBuffer, 0, i);
                }
                outPipe.flush();
                this.dataSize = this.inputStream.available();
                if (TarFileOutputStream.debug) {
                    System.out.println(RB.stream_buffer_report.getString(Long.toString(this.dataSize)));
                }
            }
            catch (IOException ioe) {
                this.close();
                throw ioe;
            }
            finally {
                try {
                    outPipe.close();
                }
                finally {
                    outPipe = null;
                }
            }
            this.modTime = new Date().getTime() / 1000L;
        }

        protected static void writeField(TarHeaderField field, String newValue, byte[] target) throws TarMalformatException {
            byte[] ba;
            int start = field.getStart();
            int stop = field.getStop();
            try {
                ba = newValue.getBytes("ISO-8859-1");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            if (ba.length > stop - start) {
                throw new TarMalformatException(RB.tar_field_toobig.getString(field.toString(), newValue));
            }
            for (int i = 0; i < ba.length; ++i) {
                target[start + i] = ba[i];
            }
        }

        protected static void clearField(TarHeaderField field, byte[] target) {
            int start = field.getStart();
            int stop = field.getStop();
            for (int i = start; i < stop; ++i) {
                target[i] = 0;
            }
        }

        protected static void writeField(TarHeaderField field, long newValue, byte[] target) throws TarMalformatException {
            TarEntrySupplicant.writeField(field, TarEntrySupplicant.prePaddedOctalString(newValue, field.getStop() - field.getStart()), target);
        }

        public static String prePaddedOctalString(long val, int width) {
            return StringUtil.toPaddedString(Long.toOctalString(val), width, '0', false);
        }

        protected static String getLameMode(File file) {
            int umod = 0;
            if (file.canExecute()) {
                umod = 1;
            }
            if (file.canWrite()) {
                umod += 2;
            }
            if (file.canRead()) {
                umod += 4;
            }
            return "0" + umod + "00";
        }

        public String getPath() {
            return this.path;
        }

        public long getDataSize() {
            return this.dataSize;
        }

        public TarEntrySupplicant makeXentry() throws IOException, TarMalformatException {
            PIFGenerator pif = new PIFGenerator(new File(this.path));
            pif.addRecord("size", this.dataSize);
            return new TarEntrySupplicant(pif.getName(), new ByteArrayInputStream(pif.toByteArray()), pif.size(), 'x', this.tarStream);
        }

        public void close() throws IOException {
            if (this.inputStream == null) {
                return;
            }
            try {
                this.inputStream.close();
            }
            finally {
                this.inputStream = null;
            }
        }

        protected long headerChecksum() {
            long sum = 0L;
            for (int i = 0; i < this.rawHeader.length; ++i) {
                boolean isInRange = i >= TarHeaderField.checksum.getStart() && i < TarHeaderField.checksum.getStop();
                sum += isInRange ? 32L : (long)(0xFF & this.rawHeader[i]);
            }
            return sum;
        }

        protected void clearField(TarHeaderField field) {
            TarEntrySupplicant.clearField(field, this.rawHeader);
        }

        protected void writeField(TarHeaderField field, String newValue) throws TarMalformatException {
            TarEntrySupplicant.writeField(field, newValue, this.rawHeader);
        }

        protected void writeField(TarHeaderField field, long newValue) throws TarMalformatException {
            TarEntrySupplicant.writeField(field, newValue, this.rawHeader);
        }

        protected void writeField(TarHeaderField field, char c) throws TarMalformatException {
            TarEntrySupplicant.writeField(field, Character.toString(c), this.rawHeader);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write() throws IOException, TarMalformatException {
            try {
                int i;
                long sizeLimit = this.inputStream.getSizeLimit();
                if (sizeLimit == 0L) {
                    return;
                }
                if (sizeLimit > 0L) {
                    this.dataSize = sizeLimit;
                }
                if (this.dataSize >= this.paxThreshold) {
                    this.paxSized = true;
                    this.makeXentry().write();
                    System.out.print("x... ");
                }
                this.writeField(TarHeaderField.name, this.path);
                this.writeField(TarHeaderField.mode, this.fileMode);
                if (!this.paxSized) {
                    this.writeField(TarHeaderField.size, this.dataSize);
                }
                this.writeField(TarHeaderField.mtime, this.modTime);
                this.writeField(TarHeaderField.checksum, TarEntrySupplicant.prePaddedOctalString(this.headerChecksum(), 6) + "\u0000 ");
                this.tarStream.writeBlock(this.rawHeader);
                long dataStart = this.tarStream.getBytesWritten();
                while ((i = this.inputStream.read(this.tarStream.writeBuffer)) > 0) {
                    this.tarStream.write(i);
                }
                if (dataStart + this.dataSize != this.tarStream.getBytesWritten()) {
                    throw new IOException(RB.data_changed.getString(Long.toString(this.dataSize), Long.toString(this.tarStream.getBytesWritten() - dataStart)));
                }
                this.tarStream.padCurrentBlock();
            }
            finally {
                this.close();
            }
        }

        static {
            char c = System.getProperty("file.separator").charAt(0);
            if (c != '/') {
                swapOutDelim = Character.valueOf(c);
            }
            try {
                TarEntrySupplicant.writeField(TarHeaderField.uid, 0L, HEADER_TEMPLATE);
                TarEntrySupplicant.writeField(TarHeaderField.gid, 0L, HEADER_TEMPLATE);
            }
            catch (TarMalformatException tme) {
                throw new RuntimeException(tme);
            }
            int magicStart = TarHeaderField.magic.getStart();
            for (int i = 0; i < ustarBytes.length; ++i) {
                TarEntrySupplicant.HEADER_TEMPLATE[magicStart + i] = ustarBytes[i];
            }
            TarEntrySupplicant.HEADER_TEMPLATE[263] = 48;
            TarEntrySupplicant.HEADER_TEMPLATE[264] = 48;
        }
    }
}

