"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PhaseChangeEvent = exports.StateChangeEvent = void 0;
const events = require("@aws-cdk/aws-events");
/**
 * Event fields for the CodeBuild "state change" event.
 *
 * @see https://docs.aws.amazon.com/codebuild/latest/userguide/sample-build-notifications.html#sample-build-notifications-ref
 */
class StateChangeEvent {
    /**
     * The triggering build's status.
     */
    static get buildStatus() {
        return events.EventField.fromPath('$.detail.build-status');
    }
    /**
     * The triggering build's project name.
     */
    static get projectName() {
        return events.EventField.fromPath('$.detail.project-name');
    }
    /**
     * Return the build id.
     */
    static get buildId() {
        return events.EventField.fromPath('$.detail.build-id');
    }
    /**
     *
     */
    static get currentPhase() {
        return events.EventField.fromPath('$.detail.current-phase');
    }
    constructor() {
    }
}
exports.StateChangeEvent = StateChangeEvent;
/**
 * Event fields for the CodeBuild "phase change" event.
 *
 * @see https://docs.aws.amazon.com/codebuild/latest/userguide/sample-build-notifications.html#sample-build-notifications-ref
 */
class PhaseChangeEvent {
    /**
     * The triggering build's project name.
     */
    static get projectName() {
        return events.EventField.fromPath('$.detail.project-name');
    }
    /**
     * The triggering build's id.
     */
    static get buildId() {
        return events.EventField.fromPath('$.detail.build-id');
    }
    /**
     * The phase that was just completed.
     */
    static get completedPhase() {
        return events.EventField.fromPath('$.detail.completed-phase');
    }
    /**
     * The status of the completed phase.
     */
    static get completedPhaseStatus() {
        return events.EventField.fromPath('$.detail.completed-phase-status');
    }
    /**
     * The duration of the completed phase.
     */
    static get completedPhaseDurationSeconds() {
        return events.EventField.fromPath('$.detail.completed-phase-duration-seconds');
    }
    /**
     * Whether the build is complete.
     */
    static get buildComplete() {
        return events.EventField.fromPath('$.detail.build-complete');
    }
    constructor() {
    }
}
exports.PhaseChangeEvent = PhaseChangeEvent;
//# sourceMappingURL=data:application/json;base64,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