"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SnsEventSource = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const subs = require("@aws-cdk/aws-sns-subscriptions");
/**
 * Use an Amazon SNS topic as an event source for AWS Lambda.
 */
class SnsEventSource {
    constructor(topic, props) {
        this.topic = topic;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_lambda_event_sources_SnsEventSourceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, SnsEventSource);
            }
            throw error;
        }
        this.props = props;
    }
    bind(target) {
        this.topic.addSubscription(new subs.LambdaSubscription(target, this.props));
    }
}
exports.SnsEventSource = SnsEventSource;
_a = JSII_RTTI_SYMBOL_1;
SnsEventSource[_a] = { fqn: "@aws-cdk/aws-lambda-event-sources.SnsEventSource", version: "1.186.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic25zLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsic25zLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7OztBQUVBLHVEQUF1RDtBQVF2RDs7R0FFRztBQUNILE1BQWEsY0FBYztJQUd6QixZQUFxQixLQUFpQixFQUFFLEtBQTJCO1FBQTlDLFVBQUssR0FBTCxLQUFLLENBQVk7Ozs7OzsrQ0FIM0IsY0FBYzs7OztRQUl2QixJQUFJLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQztLQUNwQjtJQUVNLElBQUksQ0FBQyxNQUF3QjtRQUNsQyxJQUFJLENBQUMsS0FBSyxDQUFDLGVBQWUsQ0FBQyxJQUFJLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxNQUFNLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUM7S0FDN0U7O0FBVEgsd0NBVUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBsYW1iZGEgZnJvbSAnQGF3cy1jZGsvYXdzLWxhbWJkYSc7XG5pbXBvcnQgKiBhcyBzbnMgZnJvbSAnQGF3cy1jZGsvYXdzLXNucyc7XG5pbXBvcnQgKiBhcyBzdWJzIGZyb20gJ0Bhd3MtY2RrL2F3cy1zbnMtc3Vic2NyaXB0aW9ucyc7XG5cbi8qKlxuICogUHJvcGVydGllcyBmb3J3YXJkZWQgdG8gdGhlIExhbWJkYSBTdWJzY3JpcHRpb24uXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgU25zRXZlbnRTb3VyY2VQcm9wcyBleHRlbmRzIHN1YnMuTGFtYmRhU3Vic2NyaXB0aW9uUHJvcHMge1xufVxuXG4vKipcbiAqIFVzZSBhbiBBbWF6b24gU05TIHRvcGljIGFzIGFuIGV2ZW50IHNvdXJjZSBmb3IgQVdTIExhbWJkYS5cbiAqL1xuZXhwb3J0IGNsYXNzIFNuc0V2ZW50U291cmNlIGltcGxlbWVudHMgbGFtYmRhLklFdmVudFNvdXJjZSB7XG4gIHByaXZhdGUgcmVhZG9ubHkgcHJvcHM/OiBTbnNFdmVudFNvdXJjZVByb3BzO1xuXG4gIGNvbnN0cnVjdG9yKHJlYWRvbmx5IHRvcGljOiBzbnMuSVRvcGljLCBwcm9wcz86IFNuc0V2ZW50U291cmNlUHJvcHMpIHtcbiAgICB0aGlzLnByb3BzID0gcHJvcHM7XG4gIH1cblxuICBwdWJsaWMgYmluZCh0YXJnZXQ6IGxhbWJkYS5JRnVuY3Rpb24pIHtcbiAgICB0aGlzLnRvcGljLmFkZFN1YnNjcmlwdGlvbihuZXcgc3Vicy5MYW1iZGFTdWJzY3JpcHRpb24odGFyZ2V0LCB0aGlzLnByb3BzKSk7XG4gIH1cbn1cbiJdfQ==