/**
 * Event fields for the CodeBuild "state change" event.
 *
 * @see https://docs.aws.amazon.com/codebuild/latest/userguide/sample-build-notifications.html#sample-build-notifications-ref
 * @stability stable
 */
export declare class StateChangeEvent {
    /**
     * The triggering build's status.
     *
     * @stability stable
     */
    static get buildStatus(): string;
    /**
     * The triggering build's project name.
     *
     * @stability stable
     */
    static get projectName(): string;
    /**
     * Return the build id.
     *
     * @stability stable
     */
    static get buildId(): string;
    /**
     * @stability stable
     */
    static get currentPhase(): string;
    private constructor();
}
/**
 * Event fields for the CodeBuild "phase change" event.
 *
 * @see https://docs.aws.amazon.com/codebuild/latest/userguide/sample-build-notifications.html#sample-build-notifications-ref
 * @stability stable
 */
export declare class PhaseChangeEvent {
    /**
     * The triggering build's project name.
     *
     * @stability stable
     */
    static get projectName(): string;
    /**
     * The triggering build's id.
     *
     * @stability stable
     */
    static get buildId(): string;
    /**
     * The phase that was just completed.
     *
     * @stability stable
     */
    static get completedPhase(): string;
    /**
     * The status of the completed phase.
     *
     * @stability stable
     */
    static get completedPhaseStatus(): string;
    /**
     * The duration of the completed phase.
     *
     * @stability stable
     */
    static get completedPhaseDurationSeconds(): string;
    /**
     * Whether the build is complete.
     *
     * @stability stable
     */
    static get buildComplete(): string;
    private constructor();
}
