import { IBucket } from '@aws-cdk/aws-s3';
import { CfnProject } from './codebuild.generated';
import { IProject } from './project';
/**
 * @stability stable
 */
export interface BucketCacheOptions {
    /**
     * The prefix to use to store the cache in the bucket.
     *
     * @stability stable
     */
    readonly prefix?: string;
}
/**
 * Local cache modes to enable for the CodeBuild Project.
 *
 * @stability stable
 */
export declare enum LocalCacheMode {
    /**
     * Caches Git metadata for primary and secondary sources.
     *
     * @stability stable
     */
    SOURCE = "LOCAL_SOURCE_CACHE",
    /**
     * Caches existing Docker layers.
     *
     * @stability stable
     */
    DOCKER_LAYER = "LOCAL_DOCKER_LAYER_CACHE",
    /**
     * Caches directories you specify in the buildspec file.
     *
     * @stability stable
     */
    CUSTOM = "LOCAL_CUSTOM_CACHE"
}
/**
 * Cache options for CodeBuild Project.
 *
 * A cache can store reusable pieces of your build environment and use them across multiple builds.
 *
 * @see https://docs.aws.amazon.com/codebuild/latest/userguide/build-caching.html
 * @stability stable
 */
export declare abstract class Cache {
    /**
     * @stability stable
     */
    static none(): Cache;
    /**
     * Create a local caching strategy.
     *
     * @param modes the mode(s) to enable for local caching.
     * @stability stable
     */
    static local(...modes: LocalCacheMode[]): Cache;
    /**
     * Create an S3 caching strategy.
     *
     * @param bucket the S3 bucket to use for caching.
     * @param options additional options to pass to the S3 caching.
     * @stability stable
     */
    static bucket(bucket: IBucket, options?: BucketCacheOptions): Cache;
    /**
     * @internal
     */
    abstract _toCloudFormation(): CfnProject.ProjectCacheProperty | undefined;
    /**
     * @internal
     */
    abstract _bind(project: IProject): void;
}
