#!/usr/bin/env python
"""drop postgres database"""
# -*- coding: utf-8 -*-
import click
import django
from django.conf import settings
import subprocess
import os
import sys

MODULE_NAME = "django_postgres_dropdb"
PROG_NAME = 'python -m %s' % MODULE_NAME
USAGE = 'python -m %s [alias]' % MODULE_NAME


@click.command()
@click.argument('alias',required=False)
def _cli(alias=None):
    if not alias:
        alias = "default"
    django.setup()
    db_settings = settings.DATABASES[alias]
    args = ['dropdb']
    if 'USER' in db_settings:
        args+=["-U",db_settings['USER']]
    if 'HOST' in db_settings:
        args+=["-h",db_settings['HOST']]
    if 'PORT' in db_settings:
        args+=["-p",str(db_settings['PORT'])]
    args.append(db_settings['NAME'])
    subprocess.check_call(args)


if __name__ == '__main__':
    _cli(prog_name=PROG_NAME)
