"use strict";
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeneratedJavaClientSourceCode = void 0;
const projen_1 = require("projen");
const languages_1 = require("../../languages");
const utils_1 = require("./utils");
/**
 * Generates the java client using OpenAPI Generator
 */
class GeneratedJavaClientSourceCode extends projen_1.Component {
    constructor(project, options) {
        super(project);
        this.options = options;
    }
    /**
     * @inheritDoc
     */
    synthesize() {
        super.synthesize();
        const javaProject = this.project;
        const invokerPackage = `${javaProject.pom.groupId}.${javaProject.name}.client`;
        // Generate the java client
        utils_1.invokeOpenApiGenerator({
            generator: "java",
            specPath: this.options.specPath,
            outputPath: this.project.outdir,
            generatorDirectory: languages_1.ClientLanguage.JAVA,
            additionalProperties: {
                // TODO: Upgrade to openapi-generator 6.0.1 when released so that useSingleRequestParameter is honoured
                // https://github.com/OpenAPITools/openapi-generator/milestone/42
                // https://github.com/OpenAPITools/openapi-generator/pull/12580
                // This will be required for generating java lambda handler wrappers
                useSingleRequestParameter: "true",
                groupId: javaProject.pom.groupId,
                artifactId: javaProject.pom.artifactId,
                artifactVersion: javaProject.pom.version,
                invokerPackage,
                apiPackage: `${invokerPackage}.api`,
                modelPackage: `${invokerPackage}.model`,
                hideGenerationTimestamp: "true",
            },
        });
    }
}
exports.GeneratedJavaClientSourceCode = GeneratedJavaClientSourceCode;
//# sourceMappingURL=data:application/json;base64,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