/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.AppDTVImpl;
import com.microsoft.sqlserver.jdbc.CryptoMetadata;
import com.microsoft.sqlserver.jdbc.DDC;
import com.microsoft.sqlserver.jdbc.DTV;
import com.microsoft.sqlserver.jdbc.DTVImpl;
import com.microsoft.sqlserver.jdbc.DataTypes;
import com.microsoft.sqlserver.jdbc.InputStreamGetterArgs;
import com.microsoft.sqlserver.jdbc.JDBCType;
import com.microsoft.sqlserver.jdbc.JavaType;
import com.microsoft.sqlserver.jdbc.PLPInputStream;
import com.microsoft.sqlserver.jdbc.PLPXMLInputStream;
import com.microsoft.sqlserver.jdbc.SQLCollation;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerSecurityUtility;
import com.microsoft.sqlserver.jdbc.SSLenType;
import com.microsoft.sqlserver.jdbc.SSType;
import com.microsoft.sqlserver.jdbc.SimpleInputStream;
import com.microsoft.sqlserver.jdbc.StreamSetterArgs;
import com.microsoft.sqlserver.jdbc.TDSReader;
import com.microsoft.sqlserver.jdbc.TDSReaderMark;
import com.microsoft.sqlserver.jdbc.TypeInfo;
import com.microsoft.sqlserver.jdbc.Util;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;

final class ServerDTVImpl
extends DTVImpl {
    private int valueLength;
    private TDSReaderMark valueMark;
    private boolean isNull;
    private static final int STREAMCONSUMED = -2;
    private static final Logger aeLogger = Logger.getLogger("com.microsoft.sqlserver.jdbc.DTV");

    ServerDTVImpl() {
    }

    @Override
    void setValue(DTV dTV, SQLCollation sQLCollation, JDBCType jDBCType, Object object, JavaType javaType, StreamSetterArgs streamSetterArgs, Calendar calendar, Integer n, SQLServerConnection sQLServerConnection, boolean bl) throws SQLServerException {
        dTV.setImpl(new AppDTVImpl());
        dTV.setValue(sQLCollation, jDBCType, object, javaType, streamSetterArgs, calendar, n, sQLServerConnection, bl);
    }

    @Override
    void setValue(Object object, JavaType javaType) {
        assert (false);
    }

    void setPositionAfterStreamed(TDSReader tDSReader) {
        this.valueMark = tDSReader.mark();
        this.valueLength = -2;
    }

    @Override
    void setStreamSetterArgs(StreamSetterArgs streamSetterArgs) {
        assert (false);
    }

    @Override
    void setCalendar(Calendar calendar) {
        assert (false);
    }

    @Override
    void setScale(Integer n) {
        assert (false);
    }

    @Override
    void setForceEncrypt(boolean bl) {
        assert (false);
    }

    @Override
    StreamSetterArgs getStreamSetterArgs() {
        assert (false);
        return null;
    }

    @Override
    Calendar getCalendar() {
        assert (false);
        return null;
    }

    @Override
    Integer getScale() {
        assert (false);
        return null;
    }

    @Override
    boolean isNull() {
        return this.isNull;
    }

    @Override
    void setJdbcType(JDBCType jDBCType) {
        assert (false);
    }

    @Override
    JDBCType getJdbcType() {
        assert (false);
        return JDBCType.UNKNOWN;
    }

    @Override
    JavaType getJavaType() {
        assert (false);
        return JavaType.OBJECT;
    }

    @Override
    final void initFromCompressedNull() {
        assert (this.valueMark == null);
        this.isNull = true;
    }

    @Override
    final void skipValue(TypeInfo typeInfo, TDSReader tDSReader, boolean bl) throws SQLServerException {
        if (null == this.valueMark && this.isNull) {
            return;
        }
        if (null == this.valueMark) {
            this.getValuePrep(typeInfo, tDSReader);
        }
        tDSReader.reset(this.valueMark);
        if (this.valueLength != -2) {
            if (this.valueLength == -1) {
                assert (SSLenType.PARTLENTYPE == typeInfo.getSSLenType());
                PLPInputStream pLPInputStream = PLPInputStream.makeTempStream(tDSReader, bl, this);
                try {
                    if (null != pLPInputStream) {
                        pLPInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    tDSReader.getConnection().terminate(3, iOException.getMessage());
                }
            } else {
                assert (this.valueLength >= 0);
                tDSReader.skip(this.valueLength);
            }
        }
    }

    private final void getValuePrep(TypeInfo typeInfo, TDSReader tDSReader) throws SQLServerException {
        assert (null == this.valueMark);
        switch (typeInfo.getSSLenType()) {
            case PARTLENTYPE: {
                this.valueLength = -1;
                this.isNull = PLPInputStream.isNull(tDSReader);
                break;
            }
            case FIXEDLENTYPE: {
                this.valueLength = typeInfo.getMaxLength();
                this.isNull = 0 == this.valueLength;
                break;
            }
            case BYTELENTYPE: {
                this.valueLength = tDSReader.readUnsignedByte();
                this.isNull = 0 == this.valueLength;
                break;
            }
            case USHORTLENTYPE: {
                this.valueLength = tDSReader.readUnsignedShort();
                boolean bl = this.isNull = 65535 == this.valueLength;
                if (!this.isNull) break;
                this.valueLength = 0;
                break;
            }
            case LONGLENTYPE: {
                if (SSType.TEXT == typeInfo.getSSType() || SSType.IMAGE == typeInfo.getSSType() || SSType.NTEXT == typeInfo.getSSType()) {
                    boolean bl = this.isNull = 0 == tDSReader.readUnsignedByte();
                    if (this.isNull) {
                        this.valueLength = 0;
                        break;
                    }
                    tDSReader.skip(24);
                    this.valueLength = tDSReader.readInt();
                    break;
                }
                this.valueLength = tDSReader.readInt();
                boolean bl = this.isNull = 0 == this.valueLength;
            }
        }
        if (this.valueLength > typeInfo.getMaxLength()) {
            tDSReader.throwInvalidTDS();
        }
        this.valueMark = tDSReader.mark();
    }

    Object denormalizedValue(byte[] byArray, JDBCType jDBCType, TypeInfo typeInfo, SQLServerConnection sQLServerConnection, InputStreamGetterArgs inputStreamGetterArgs, byte by, Calendar calendar) throws SQLServerException {
        if (1 != by) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_UnsupportedNormalizationVersionAE"));
            throw new SQLServerException(messageFormat.format(new Object[]{by, 1}), null, 0, null);
        }
        if (aeLogger.isLoggable(Level.FINE)) {
            aeLogger.fine("Denormalizing decrypted data based on its SQL Server type(" + (Object)((Object)typeInfo.getSSType()) + ") and JDBC type(" + (Object)((Object)jDBCType) + ").");
        }
        SSType sSType = typeInfo.getSSType();
        switch (sSType) {
            case CHAR: 
            case VARCHAR: 
            case NCHAR: 
            case NVARCHAR: 
            case VARCHARMAX: 
            case NVARCHARMAX: {
                try {
                    String string = new String(byArray, 0, byArray.length, null == typeInfo.getCharset() ? sQLServerConnection.getDatabaseCollation().getCharset() : typeInfo.getCharset());
                    if (SSType.CHAR == sSType || SSType.NCHAR == sSType) {
                        StringBuffer stringBuffer = new StringBuffer(string);
                        int n = typeInfo.getPrecision() - string.length();
                        for (int i = 0; i < n; ++i) {
                            stringBuffer.append(' ');
                        }
                        string = stringBuffer.toString();
                    }
                    return DDC.convertStringToObject(string, typeInfo.getCharset(), jDBCType, inputStreamGetterArgs.streamType);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_errorConvertingValue"));
                    throw new SQLServerException(messageFormat.format(new Object[]{sSType, jDBCType}), null, 0, (Throwable)illegalArgumentException);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_unsupportedEncoding"));
                    throw new SQLServerException(messageFormat.format(new Object[]{typeInfo.getCharset()}), null, 0, null);
                }
            }
            case BIT: 
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: {
                if (8 != byArray.length) {
                    MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_NormalizationErrorAE"));
                    throw new SQLServerException(messageFormat.format(new Object[]{sSType}), null, 0, null);
                }
                return DDC.convertLongToObject(Util.readLong(byArray, 0), jDBCType, sSType, inputStreamGetterArgs.streamType);
            }
            case REAL: 
            case FLOAT: {
                if (8 == byArray.length) {
                    return DDC.convertDoubleToObject(ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getDouble(), JDBCType.VARBINARY == jDBCType ? sSType.getJDBCType() : jDBCType, inputStreamGetterArgs.streamType);
                }
                if (4 == byArray.length) {
                    return DDC.convertFloatToObject(ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getFloat(), JDBCType.VARBINARY == jDBCType ? sSType.getJDBCType() : jDBCType, inputStreamGetterArgs.streamType);
                }
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_NormalizationErrorAE"));
                throw new SQLServerException(messageFormat.format(new Object[]{sSType}), null, 0, null);
            }
            case SMALLMONEY: {
                return DDC.convertMoneyToObject(new BigDecimal(BigInteger.valueOf(Util.readInt(byArray, 4)), 4), JDBCType.VARBINARY == jDBCType ? sSType.getJDBCType() : jDBCType, inputStreamGetterArgs.streamType, 4);
            }
            case MONEY: {
                BigInteger bigInteger = BigInteger.valueOf((long)Util.readInt(byArray, 0) << 32 | (long)Util.readInt(byArray, 4) & 0xFFFFFFFFL);
                return DDC.convertMoneyToObject(new BigDecimal(bigInteger, 4), JDBCType.VARBINARY == jDBCType ? sSType.getJDBCType() : jDBCType, inputStreamGetterArgs.streamType, 8);
            }
            case NUMERIC: 
            case DECIMAL: {
                return DDC.convertBigDecimalToObject(Util.readBigDecimal(byArray, byArray.length, typeInfo.getScale()), JDBCType.VARBINARY == jDBCType ? sSType.getJDBCType() : jDBCType, inputStreamGetterArgs.streamType);
            }
            case BINARY: 
            case VARBINARY: 
            case VARBINARYMAX: {
                return DDC.convertBytesToObject(byArray, jDBCType, typeInfo);
            }
            case DATE: {
                if (3 != byArray.length) {
                    MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_NormalizationErrorAE"));
                    throw new SQLServerException(messageFormat.format(new Object[]{sSType}), null, 0, null);
                }
                int n = this.getDaysIntoCE(byArray, sSType);
                return DDC.convertTemporalToObject(jDBCType, sSType, calendar, n, 0L, 0);
            }
            case TIME: {
                long l = this.readNanosSinceMidnightAE(byArray, typeInfo.getScale(), sSType);
                return DDC.convertTemporalToObject(jDBCType, SSType.TIME, calendar, 0, l, typeInfo.getScale());
            }
            case DATETIME2: {
                if (8 != byArray.length) {
                    MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_NormalizationErrorAE"));
                    throw new SQLServerException(messageFormat.format(new Object[]{sSType}), null, 0, null);
                }
                int n = byArray.length - 3;
                byte[] byArray2 = new byte[n];
                byte[] byArray3 = new byte[3];
                System.arraycopy(byArray, 0, byArray2, 0, n);
                System.arraycopy(byArray, n, byArray3, 0, 3);
                long l = this.readNanosSinceMidnightAE(byArray2, typeInfo.getScale(), sSType);
                int n2 = this.getDaysIntoCE(byArray3, sSType);
                return DDC.convertTemporalToObject(jDBCType, SSType.DATETIME2, calendar, n2, l, typeInfo.getScale());
            }
            case SMALLDATETIME: {
                if (4 != byArray.length) {
                    MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_NormalizationErrorAE"));
                    throw new SQLServerException(messageFormat.format(new Object[]{sSType}), null, 0, null);
                }
                return DDC.convertTemporalToObject(jDBCType, SSType.DATETIME, calendar, Util.readUnsignedShort(byArray, 0), (long)Util.readUnsignedShort(byArray, 2) * 60L * 1000L, 0);
            }
            case DATETIME: {
                if (8 != byArray.length) {
                    MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_NormalizationErrorAE"));
                    throw new SQLServerException(messageFormat.format(new Object[]{sSType}), null, 0, null);
                }
                return DDC.convertTemporalToObject(jDBCType, SSType.DATETIME, calendar, Util.readInt(byArray, 0), (Util.readInt(byArray, 4) * 10 + 1) / 3, 0);
            }
            case DATETIMEOFFSET: {
                int n = byArray.length - 5;
                byte[] byArray4 = new byte[n];
                byte[] byArray5 = new byte[3];
                byte[] byArray6 = new byte[2];
                System.arraycopy(byArray, 0, byArray4, 0, n);
                System.arraycopy(byArray, n, byArray5, 0, 3);
                System.arraycopy(byArray, n + 3, byArray6, 0, 2);
                long l = this.readNanosSinceMidnightAE(byArray4, typeInfo.getScale(), sSType);
                int n3 = this.getDaysIntoCE(byArray5, sSType);
                short s = ByteBuffer.wrap(byArray6).order(ByteOrder.LITTLE_ENDIAN).getShort();
                return DDC.convertTemporalToObject(jDBCType, SSType.DATETIMEOFFSET, new GregorianCalendar(new SimpleTimeZone(s * 60 * 1000, ""), Locale.US), n3, l, typeInfo.getScale());
            }
            case GUID: {
                return Util.readGUID(byArray);
            }
        }
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_UnsupportedDataTypeAE"));
        throw new SQLServerException(messageFormat.format(new Object[]{sSType}), null, 0, null);
    }

    @Override
    Object getValue(DTV dTV, JDBCType jDBCType, int n, InputStreamGetterArgs inputStreamGetterArgs, Calendar calendar, TypeInfo typeInfo, CryptoMetadata cryptoMetadata, TDSReader tDSReader) throws SQLServerException {
        SQLServerConnection sQLServerConnection = tDSReader.getConnection();
        Object object = null;
        byte[] byArray = null;
        boolean bl = false;
        SSType sSType = typeInfo.getSSType();
        if (null != cryptoMetadata) {
            assert (SSType.VARBINARY == typeInfo.getSSType() || SSType.VARBINARYMAX == typeInfo.getSSType());
            sSType = cryptoMetadata.baseTypeInfo.getSSType();
            bl = true;
            if (aeLogger.isLoggable(Level.FINE)) {
                aeLogger.fine("Data is encrypted, SQL Server Data Type: " + (Object)((Object)sSType) + ", Encryption Type: " + (Object)((Object)cryptoMetadata.getEncryptionType()));
            }
        }
        if (null == this.valueMark && !this.isNull) {
            this.getValuePrep(typeInfo, tDSReader);
        }
        assert (this.valueMark != null || this.valueMark == null && this.isNull);
        boolean bl2 = false;
        if (null != inputStreamGetterArgs) {
            if (!inputStreamGetterArgs.streamType.convertsFrom(typeInfo)) {
                DataTypes.throwConversionError(typeInfo.getSSType().toString(), inputStreamGetterArgs.streamType.toString());
            }
        } else {
            if (!sSType.convertsTo(jDBCType)) {
                if (bl) {
                    if (!Util.isBinaryType(jDBCType.getIntValue()).booleanValue()) {
                        DataTypes.throwConversionError(sSType.toString(), jDBCType.toString());
                    }
                } else {
                    DataTypes.throwConversionError(sSType.toString(), jDBCType.toString());
                }
            }
            inputStreamGetterArgs = InputStreamGetterArgs.getDefaultArgs();
        }
        if (-2 == this.valueLength) {
            throw new SQLServerException(null, SQLServerException.getErrString("R_dataAlreadyAccessed"), null, 0, false);
        }
        if (!this.isNull) {
            tDSReader.reset(this.valueMark);
            if (bl) {
                object = -1 == this.valueLength ? DDC.convertStreamToObject(PLPInputStream.makeStream(tDSReader, inputStreamGetterArgs, this), typeInfo, JDBCType.VARBINARY, inputStreamGetterArgs) : DDC.convertStreamToObject(new SimpleInputStream(tDSReader, this.valueLength, inputStreamGetterArgs, this), typeInfo, JDBCType.VARBINARY, inputStreamGetterArgs);
                if (aeLogger.isLoggable(Level.FINE)) {
                    aeLogger.fine("Encrypted data is retrieved.");
                }
                if (object instanceof SimpleInputStream) {
                    throw new SQLServerException(SQLServerException.getErrString("R_notSupported"), null);
                }
                byArray = SQLServerSecurityUtility.decryptWithKey((byte[])object, cryptoMetadata, sQLServerConnection);
                return this.denormalizedValue(byArray, jDBCType, cryptoMetadata.baseTypeInfo, sQLServerConnection, inputStreamGetterArgs, cryptoMetadata.normalizationRuleVersion, calendar);
            }
            block0 : switch (sSType) {
                case VARCHARMAX: 
                case NVARCHARMAX: 
                case VARBINARYMAX: 
                case UDT: {
                    object = DDC.convertStreamToObject(PLPInputStream.makeStream(tDSReader, inputStreamGetterArgs, this), typeInfo, jDBCType, inputStreamGetterArgs);
                    break;
                }
                case XML: {
                    object = DDC.convertStreamToObject(jDBCType.isBinary() || jDBCType == JDBCType.SQLXML ? PLPXMLInputStream.makeXMLStream(tDSReader, inputStreamGetterArgs, this) : PLPInputStream.makeStream(tDSReader, inputStreamGetterArgs, this), typeInfo, jDBCType, inputStreamGetterArgs);
                    break;
                }
                case CHAR: 
                case VARCHAR: 
                case NCHAR: 
                case NVARCHAR: 
                case BINARY: 
                case VARBINARY: 
                case TEXT: 
                case NTEXT: 
                case IMAGE: 
                case TIMESTAMP: {
                    object = DDC.convertStreamToObject(new SimpleInputStream(tDSReader, this.valueLength, inputStreamGetterArgs, this), typeInfo, jDBCType, inputStreamGetterArgs);
                    break;
                }
                case BIT: 
                case TINYINT: 
                case SMALLINT: 
                case INTEGER: 
                case BIGINT: {
                    switch (this.valueLength) {
                        case 8: {
                            object = DDC.convertLongToObject(tDSReader.readLong(), jDBCType, sSType, inputStreamGetterArgs.streamType);
                            break block0;
                        }
                        case 4: {
                            object = DDC.convertIntegerToObject(tDSReader.readInt(), this.valueLength, jDBCType, inputStreamGetterArgs.streamType);
                            break block0;
                        }
                        case 2: {
                            object = DDC.convertIntegerToObject(tDSReader.readShort(), this.valueLength, jDBCType, inputStreamGetterArgs.streamType);
                            break block0;
                        }
                        case 1: {
                            object = DDC.convertIntegerToObject(tDSReader.readUnsignedByte(), this.valueLength, jDBCType, inputStreamGetterArgs.streamType);
                            break block0;
                        }
                    }
                    assert (false) : "Unexpected valueLength" + this.valueLength;
                    break;
                }
                case NUMERIC: 
                case DECIMAL: {
                    object = tDSReader.readDecimal(this.valueLength, typeInfo, jDBCType, inputStreamGetterArgs.streamType);
                    break;
                }
                case SMALLMONEY: 
                case MONEY: {
                    object = tDSReader.readMoney(this.valueLength, jDBCType, inputStreamGetterArgs.streamType);
                    break;
                }
                case FLOAT: {
                    object = tDSReader.readFloat(this.valueLength, jDBCType, inputStreamGetterArgs.streamType);
                    break;
                }
                case REAL: {
                    object = tDSReader.readReal(this.valueLength, jDBCType, inputStreamGetterArgs.streamType);
                    break;
                }
                case SMALLDATETIME: 
                case DATETIME: {
                    object = tDSReader.readDateTime(this.valueLength, calendar, jDBCType, inputStreamGetterArgs.streamType);
                    break;
                }
                case DATE: {
                    object = tDSReader.readDate(this.valueLength, calendar, jDBCType);
                    break;
                }
                case TIME: {
                    object = tDSReader.readTime(this.valueLength, typeInfo, calendar, jDBCType);
                    break;
                }
                case DATETIME2: {
                    object = tDSReader.readDateTime2(this.valueLength, typeInfo, calendar, jDBCType);
                    break;
                }
                case DATETIMEOFFSET: {
                    object = tDSReader.readDateTimeOffset(this.valueLength, typeInfo, jDBCType);
                    break;
                }
                case GUID: {
                    object = tDSReader.readGUID(this.valueLength, jDBCType, inputStreamGetterArgs.streamType);
                    break;
                }
                default: {
                    assert (false) : "Unexpected SSType " + (Object)((Object)typeInfo.getSSType());
                    break;
                }
            }
        }
        assert (this.isNull || null != object);
        return object;
    }

    @Override
    Object getSetterValue() {
        assert (false);
        return null;
    }

    private long readNanosSinceMidnightAE(byte[] byArray, int n, SSType sSType) throws SQLServerException {
        long l = 0L;
        for (int i = 0; i < byArray.length; ++i) {
            l |= ((long)byArray[i] & 0xFFL) << 8 * i;
        }
        if (0L > l || l >= 864000000000L) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_NormalizationErrorAE"));
            throw new SQLServerException(messageFormat.format(new Object[]{sSType}), null, 0, null);
        }
        return 100L * l;
    }

    private int getDaysIntoCE(byte[] byArray, SSType sSType) throws SQLServerException {
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            n |= (byArray[i] & 0xFF) << 8 * i;
        }
        if (n < 0) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_NormalizationErrorAE"));
            throw new SQLServerException(messageFormat.format(new Object[]{sSType}), null, 0, null);
        }
        return n;
    }
}

