# sqlc-python-runtime

A small runtime library for python code generated by [sqlc](https://github.com/kyleconroy/sqlc)

## Installation

Add the `sqlc-python-runtime` package to your project's dependencies.

## Usage

All query functions generated by sqlc take a database connection object as their first argument.
This connection object must conform to the `Connection`/`AsyncConnection` interface defined in this package.
This package also provides wrappers for `psycopg2` and `asyncpg` that conform to this interface.

`psycopg2` example:
```python
import psycopg2
from sqlc_runtime.psycopg2 import build_psycopg2_connection


conn = build_psycopg2_connection(psycopg2.connect("postgresql://localhost:5432/mydatabase"))
```

Also note that the generated query functions can use either a `Connection` or an `AsyncConnection`.
If an `AsyncConnection` is passed the result must be awaited. The function type hints communicate this so any type
checkers (like mypy) will raise errors if any are missed or incorrectly used.
