# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: api.proto
# plugin: python-betterproto
from dataclasses import dataclass
from datetime import datetime
from typing import AsyncGenerator, Dict, List, Optional

import betterproto
import grpclib

from . import common


class MarketStatus(betterproto.Enum):
    MS_UNKNOWN = 0
    MS_ONLINE = 1


class MarketProgram(betterproto.Enum):
    MP_SERUM = 0
    MP_OPENBOOK = 1


class Side(betterproto.Enum):
    S_UNKNOWN = 0
    S_BID = 1
    S_ASK = 2


class OrderType(betterproto.Enum):
    OT_MARKET = 0
    OT_LIMIT = 1
    OT_IOC = 2
    OT_POST = 3


class OrderStatus(betterproto.Enum):
    OS_UNKNOWN = 0
    OS_OPEN = 1
    OS_PARTIAL_FILL = 2
    OS_CANCELLED = 3
    OS_FILLED = 4


class Direction(betterproto.Enum):
    D_ASCENDING = 0
    D_DESCENDING = 1


class SubmitStrategy(betterproto.Enum):
    P_UKNOWN = 0
    P_SUBMIT_ALL = 1
    P_ABORT_ON_FIRST_ERROR = 2
    P_WAIT_FOR_CONFIRMATION = 3


class Step(betterproto.Enum):
    STEP0 = 0
    STEP1 = 1
    STEP2 = 2
    STEP3 = 3


class Project(betterproto.Enum):
    P_UNKNOWN = 0
    P_JUPITER = 1
    P_RAYDIUM = 2
    P_SERUM = 3
    P_ALL = 4


@dataclass
class GetMarketsRequest(betterproto.Message):
    pass


@dataclass
class GetMarketsResponse(betterproto.Message):
    markets: Dict[str, "Market"] = betterproto.map_field(
        1, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE
    )


@dataclass
class Market(betterproto.Message):
    market: str = betterproto.string_field(1)
    status: "MarketStatus" = betterproto.enum_field(2)
    address: str = betterproto.string_field(3)
    base_mint: str = betterproto.string_field(4)
    quoted_mint: str = betterproto.string_field(5)
    base_decimals: int = betterproto.int64_field(6)
    quote_decimals: int = betterproto.int64_field(7)
    program: "MarketProgram" = betterproto.enum_field(8)


@dataclass
class GetTickersRequest(betterproto.Message):
    market: str = betterproto.string_field(1)
    program: "MarketProgram" = betterproto.enum_field(2)


@dataclass
class GetTickersResponse(betterproto.Message):
    tickers: List["Ticker"] = betterproto.message_field(1)


@dataclass
class Ticker(betterproto.Message):
    market: str = betterproto.string_field(1)
    market_address: str = betterproto.string_field(2)
    bid: float = betterproto.double_field(3)
    bid_size: float = betterproto.double_field(4)
    ask: float = betterproto.double_field(5)
    ask_size: float = betterproto.double_field(6)
    program: "MarketProgram" = betterproto.enum_field(7)


@dataclass
class GetKlineRequest(betterproto.Message):
    market: str = betterproto.string_field(1)
    from_: datetime = betterproto.message_field(2)
    to: datetime = betterproto.message_field(3)
    resolution: str = betterproto.string_field(4)
    limit: int = betterproto.uint32_field(5)


@dataclass
class GetKlineResponse(betterproto.Message):
    market: str = betterproto.string_field(1)
    timestamp: datetime = betterproto.message_field(2)
    candles: List["Candle"] = betterproto.message_field(3)


@dataclass
class Candle(betterproto.Message):
    start_time: datetime = betterproto.message_field(1)
    update_time: datetime = betterproto.message_field(2)
    open: float = betterproto.double_field(3)
    close: float = betterproto.double_field(4)
    low: float = betterproto.double_field(5)
    high: float = betterproto.double_field(6)
    amount: float = betterproto.double_field(7)
    volume: float = betterproto.double_field(8)
    count: float = betterproto.double_field(9)


@dataclass
class GetOrderbookRequest(betterproto.Message):
    market: str = betterproto.string_field(1)
    limit: int = betterproto.uint32_field(2)
    program: "MarketProgram" = betterproto.enum_field(3)


@dataclass
class GetOrderbooksRequest(betterproto.Message):
    markets: List[str] = betterproto.string_field(1)
    limit: int = betterproto.uint32_field(2)
    program: "MarketProgram" = betterproto.enum_field(3)


@dataclass
class GetOrderbookResponse(betterproto.Message):
    market: str = betterproto.string_field(1)
    market_address: str = betterproto.string_field(2)
    bids: List["OrderbookItem"] = betterproto.message_field(3)
    asks: List["OrderbookItem"] = betterproto.message_field(4)


@dataclass
class OrderbookItem(betterproto.Message):
    price: float = betterproto.double_field(1)
    size: float = betterproto.double_field(2)


@dataclass
class GetTradesRequest(betterproto.Message):
    market: str = betterproto.string_field(1)
    limit: int = betterproto.uint32_field(2)
    program: "MarketProgram" = betterproto.enum_field(3)


@dataclass
class GetTradesResponse(betterproto.Message):
    trades: List["Trade"] = betterproto.message_field(1)


@dataclass
class Trade(betterproto.Message):
    side: "Side" = betterproto.enum_field(1)
    size: float = betterproto.double_field(2)
    fill_price: float = betterproto.double_field(3)
    order_i_d: str = betterproto.string_field(4)
    is_maker: bool = betterproto.bool_field(5)
    address: str = betterproto.string_field(6)
    fee_or_rebate: float = betterproto.double_field(7)
    order_price: float = betterproto.double_field(8)


@dataclass
class GetServerTimeRequest(betterproto.Message):
    pass


@dataclass
class GetServerTimeResponse(betterproto.Message):
    timestamp: str = betterproto.string_field(1)


@dataclass
class GetAccountBalanceRequest(betterproto.Message):
    owner_address: str = betterproto.string_field(1)


@dataclass
class GetAccountBalanceResponse(betterproto.Message):
    tokens: List["TokenBalance"] = betterproto.message_field(1)


@dataclass
class TokenBalance(betterproto.Message):
    symbol: str = betterproto.string_field(1)
    address: str = betterproto.string_field(2)
    wallet_amount: float = betterproto.double_field(3)
    unsettled_amount: float = betterproto.double_field(4)
    open_orders_amount: float = betterproto.double_field(5)


@dataclass
class PostOrderRequest(betterproto.Message):
    owner_address: str = betterproto.string_field(1)
    payer_address: str = betterproto.string_field(2)
    market: str = betterproto.string_field(3)
    side: "Side" = betterproto.enum_field(4)
    type: List["OrderType"] = betterproto.enum_field(5)
    amount: float = betterproto.double_field(6)
    price: float = betterproto.double_field(7)
    open_orders_address: str = betterproto.string_field(8)
    client_order_i_d: int = betterproto.uint64_field(9)
    program: "MarketProgram" = betterproto.enum_field(10)


@dataclass
class PostReplaceOrderRequest(betterproto.Message):
    owner_address: str = betterproto.string_field(1)
    payer_address: str = betterproto.string_field(2)
    market: str = betterproto.string_field(3)
    side: "Side" = betterproto.enum_field(4)
    type: List["OrderType"] = betterproto.enum_field(5)
    amount: float = betterproto.double_field(6)
    price: float = betterproto.double_field(7)
    open_orders_address: str = betterproto.string_field(8)
    client_order_i_d: int = betterproto.uint64_field(9)
    order_i_d: str = betterproto.string_field(10)
    program: "MarketProgram" = betterproto.enum_field(11)


@dataclass
class PostOrderResponse(betterproto.Message):
    transaction: "TransactionMessage" = betterproto.message_field(1)
    open_orders_address: str = betterproto.string_field(2)


@dataclass
class PostCancelOrderRequest(betterproto.Message):
    order_i_d: str = betterproto.string_field(1)
    side: "Side" = betterproto.enum_field(2)
    market_address: str = betterproto.string_field(3)
    owner_address: str = betterproto.string_field(4)
    open_orders_address: str = betterproto.string_field(5)
    program: "MarketProgram" = betterproto.enum_field(6)


@dataclass
class PostCancelByClientOrderIDRequest(betterproto.Message):
    client_order_i_d: int = betterproto.uint64_field(1)
    market_address: str = betterproto.string_field(2)
    owner_address: str = betterproto.string_field(3)
    open_orders_address: str = betterproto.string_field(4)
    program: "MarketProgram" = betterproto.enum_field(5)


@dataclass
class PostCancelOrderResponse(betterproto.Message):
    transaction: "TransactionMessage" = betterproto.message_field(1)


@dataclass
class PostCancelAllRequest(betterproto.Message):
    market: str = betterproto.string_field(1)
    owner_address: str = betterproto.string_field(2)
    open_orders_addresses: List[str] = betterproto.string_field(3)
    program: "MarketProgram" = betterproto.enum_field(4)


@dataclass
class TransactionMessage(betterproto.Message):
    content: str = betterproto.string_field(1)
    is_cleanup: bool = betterproto.bool_field(2)


@dataclass
class PostCancelAllResponse(betterproto.Message):
    transactions: List["TransactionMessage"] = betterproto.message_field(1)


@dataclass
class PostSettleRequest(betterproto.Message):
    owner_address: str = betterproto.string_field(1)
    market: str = betterproto.string_field(2)
    base_token_wallet: str = betterproto.string_field(3)
    quote_token_wallet: str = betterproto.string_field(4)
    open_orders_address: str = betterproto.string_field(5)
    program: "MarketProgram" = betterproto.enum_field(6)


@dataclass
class PostSettleResponse(betterproto.Message):
    transaction: "TransactionMessage" = betterproto.message_field(1)


@dataclass
class Settlement(betterproto.Message):
    symbol: str = betterproto.string_field(1)
    unsettled: float = betterproto.double_field(2)
    amount: float = betterproto.double_field(3)


@dataclass
class GetOrdersRequest(betterproto.Message):
    market: str = betterproto.string_field(1)
    status: "OrderStatus" = betterproto.enum_field(2)
    side: "Side" = betterproto.enum_field(3)
    types: List["OrderType"] = betterproto.enum_field(4)
    from_: datetime = betterproto.message_field(5)
    limit: int = betterproto.uint32_field(6)
    direction: "Direction" = betterproto.enum_field(7)
    address: str = betterproto.string_field(8)
    open_orders_address: str = betterproto.string_field(9)
    program: "MarketProgram" = betterproto.enum_field(10)


@dataclass
class GetOrdersResponse(betterproto.Message):
    orders: List["Order"] = betterproto.message_field(1)


@dataclass
class Order(betterproto.Message):
    order_i_d: str = betterproto.string_field(1)
    market: str = betterproto.string_field(2)
    side: "Side" = betterproto.enum_field(3)
    types: List["OrderType"] = betterproto.enum_field(4)
    price: float = betterproto.double_field(5)
    remaining_size: float = betterproto.double_field(6)
    created_at: datetime = betterproto.message_field(7)
    client_order_i_d: str = betterproto.string_field(8)
    open_order_account: str = betterproto.string_field(9)


@dataclass
class GetOrderStatusStreamRequest(betterproto.Message):
    market: str = betterproto.string_field(1)
    owner_address: str = betterproto.string_field(2)
    program: "MarketProgram" = betterproto.enum_field(3)


@dataclass
class GetOrderStatusStreamResponse(betterproto.Message):
    slot: int = betterproto.int64_field(1)
    order_info: "GetOrderStatusResponse" = betterproto.message_field(2)


@dataclass
class GetOrderStatusResponse(betterproto.Message):
    market: str = betterproto.string_field(1)
    open_order_address: str = betterproto.string_field(2)
    order_i_d: str = betterproto.string_field(3)
    client_order_i_d: int = betterproto.uint64_field(4)
    quantity_released: float = betterproto.float_field(5)
    quantity_remaining: float = betterproto.float_field(6)
    fill_price: float = betterproto.float_field(7)
    side: "Side" = betterproto.enum_field(8)
    order_status: "OrderStatus" = betterproto.enum_field(9)
    order_price: float = betterproto.float_field(10)


@dataclass
class PostSubmitRequest(betterproto.Message):
    transaction: "TransactionMessage" = betterproto.message_field(1)
    skip_pre_flight: bool = betterproto.bool_field(2)


@dataclass
class PostSubmitRequestEntry(betterproto.Message):
    transaction: "TransactionMessage" = betterproto.message_field(1)
    skip_pre_flight: bool = betterproto.bool_field(2)


@dataclass
class PostSubmitBatchRequest(betterproto.Message):
    entries: List["PostSubmitRequestEntry"] = betterproto.message_field(1)
    submit_strategy: "SubmitStrategy" = betterproto.enum_field(2)


@dataclass
class PostSubmitResponse(betterproto.Message):
    signature: str = betterproto.string_field(1)


@dataclass
class PostSubmitBatchResponseEntry(betterproto.Message):
    signature: str = betterproto.string_field(1)
    error: str = betterproto.string_field(2)
    submitted: bool = betterproto.bool_field(3)


@dataclass
class PostSubmitBatchResponse(betterproto.Message):
    transactions: List["PostSubmitBatchResponseEntry"] = betterproto.message_field(1)


@dataclass
class GetOpenOrdersRequest(betterproto.Message):
    market: str = betterproto.string_field(1)
    limit: int = betterproto.uint32_field(2)
    address: str = betterproto.string_field(3)
    open_orders_address: str = betterproto.string_field(4)
    program: "MarketProgram" = betterproto.enum_field(5)


@dataclass
class GetOpenOrdersResponse(betterproto.Message):
    orders: List["Order"] = betterproto.message_field(1)


@dataclass
class GetOrderByIDRequest(betterproto.Message):
    order_i_d: str = betterproto.string_field(1)
    market: str = betterproto.string_field(2)
    program: "MarketProgram" = betterproto.enum_field(3)


@dataclass
class GetOrderByIDResponse(betterproto.Message):
    order: "Order" = betterproto.message_field(1)


@dataclass
class GetUnsettledRequest(betterproto.Message):
    market: str = betterproto.string_field(1)
    owner_address: str = betterproto.string_field(2)
    program: "MarketProgram" = betterproto.enum_field(3)


@dataclass
class UnsettledAccountToken(betterproto.Message):
    address: str = betterproto.string_field(1)
    amount: float = betterproto.double_field(2)


@dataclass
class UnsettledAccount(betterproto.Message):
    account: str = betterproto.string_field(1)
    base_token: "UnsettledAccountToken" = betterproto.message_field(2)
    quote_token: "UnsettledAccountToken" = betterproto.message_field(3)


@dataclass
class GetUnsettledResponse(betterproto.Message):
    market: str = betterproto.string_field(1)
    unsettled: List["UnsettledAccount"] = betterproto.message_field(2)


@dataclass
class GetOrderbooksStreamResponse(betterproto.Message):
    slot: int = betterproto.int64_field(1)
    orderbook: "GetOrderbookResponse" = betterproto.message_field(2)


@dataclass
class GetTickersStreamResponse(betterproto.Message):
    slot: int = betterproto.int64_field(1)
    ticker: "GetTickersResponse" = betterproto.message_field(2)


@dataclass
class GetMarketDepthRequest(betterproto.Message):
    market: str = betterproto.string_field(1)
    depth: int = betterproto.int32_field(2)
    step: "Step" = betterproto.enum_field(3)
    program: "MarketProgram" = betterproto.enum_field(4)


@dataclass
class GetMarketDepthStreamResponse(betterproto.Message):
    slot: int = betterproto.int64_field(1)
    tick: "MarketDepthTick" = betterproto.message_field(2)


@dataclass
class MarketDepthTick(betterproto.Message):
    prev_slot: int = betterproto.int64_field(1)
    asks: List["OrderbookItem"] = betterproto.message_field(2)
    bids: List["OrderbookItem"] = betterproto.message_field(3)


@dataclass
class GetTradesStreamResponse(betterproto.Message):
    slot: int = betterproto.int64_field(1)
    trades: "GetTradesResponse" = betterproto.message_field(2)


@dataclass
class GetQuotesRequest(betterproto.Message):
    in_token: str = betterproto.string_field(1)
    out_token: str = betterproto.string_field(2)
    in_amount: float = betterproto.double_field(3)
    slippage: float = betterproto.double_field(4)
    limit: int = betterproto.int32_field(5)
    projects: List["Project"] = betterproto.enum_field(6)


@dataclass
class GetQuotesResponse(betterproto.Message):
    in_token: str = betterproto.string_field(1)
    in_token_address: str = betterproto.string_field(2)
    out_token: str = betterproto.string_field(3)
    out_token_address: str = betterproto.string_field(4)
    in_amount: float = betterproto.double_field(5)
    quotes: List["ProjectQuote"] = betterproto.message_field(6)


@dataclass
class ProjectQuote(betterproto.Message):
    project: "Project" = betterproto.enum_field(1)
    routes: List["QuoteRoute"] = betterproto.message_field(2)


@dataclass
class TradeSwapRequest(betterproto.Message):
    project: "Project" = betterproto.enum_field(1)
    owner_address: str = betterproto.string_field(2)
    in_token: str = betterproto.string_field(3)
    out_token: str = betterproto.string_field(4)
    in_amount: float = betterproto.double_field(5)
    slippage: float = betterproto.double_field(6)


@dataclass
class RouteTradeSwapRequest(betterproto.Message):
    project: "Project" = betterproto.enum_field(1)
    owner_address: str = betterproto.string_field(2)
    steps: List["RouteStep"] = betterproto.message_field(3)


@dataclass
class RouteStep(betterproto.Message):
    in_token: str = betterproto.string_field(1)
    in_amount: float = betterproto.double_field(2)
    out_token: str = betterproto.string_field(3)
    out_amount: float = betterproto.double_field(4)
    out_amount_min: float = betterproto.double_field(5)
    project: "StepProject" = betterproto.message_field(6)


@dataclass
class TradeSwapResponse(betterproto.Message):
    project: "Project" = betterproto.enum_field(1)
    transactions: List["TransactionMessage"] = betterproto.message_field(2)
    out_amount: float = betterproto.double_field(3)
    out_amount_min: float = betterproto.double_field(4)
    price_impact: common.PriceImpactPercent = betterproto.message_field(5)
    fees: List[common.Fee] = betterproto.message_field(6)


@dataclass
class QuoteRoute(betterproto.Message):
    in_amount: float = betterproto.double_field(1)
    out_amount: float = betterproto.double_field(2)
    out_amount_min: float = betterproto.double_field(3)
    steps: List["QuoteStep"] = betterproto.message_field(4)


@dataclass
class QuoteStep(betterproto.Message):
    project: "StepProject" = betterproto.message_field(1)
    in_token: str = betterproto.string_field(2)
    in_token_address: str = betterproto.string_field(3)
    out_token: str = betterproto.string_field(4)
    out_token_address: str = betterproto.string_field(5)
    in_amount: float = betterproto.double_field(6)
    out_amount: float = betterproto.double_field(7)
    slippage: float = betterproto.double_field(8)
    price_impact_percent: common.PriceImpactPercent = betterproto.message_field(9)
    fee: common.Fee = betterproto.message_field(10)
    out_amount_min: float = betterproto.double_field(11)
    pool_address: str = betterproto.string_field(12)


@dataclass
class StepProject(betterproto.Message):
    label: str = betterproto.string_field(1)
    id: str = betterproto.string_field(2)


@dataclass
class GetRecentBlockHashRequest(betterproto.Message):
    pass


@dataclass
class GetRecentBlockHashResponse(betterproto.Message):
    block_hash: str = betterproto.string_field(1)


@dataclass
class GetPoolsRequest(betterproto.Message):
    projects: List["Project"] = betterproto.enum_field(1)


@dataclass
class GetPoolsResponse(betterproto.Message):
    projects: List["ProjectPools"] = betterproto.message_field(1)


@dataclass
class ProjectPools(betterproto.Message):
    project: "Project" = betterproto.enum_field(1)
    pools: List["ProjectPool"] = betterproto.message_field(2)


@dataclass
class ProjectPool(betterproto.Message):
    pool: str = betterproto.string_field(1)
    pool_address: str = betterproto.string_field(2)
    token1_reserves: int = betterproto.int64_field(3)
    token1_mint_address: str = betterproto.string_field(4)
    token1_mint_symbol: str = betterproto.string_field(5)
    token2_reserves: int = betterproto.int64_field(6)
    token2_mint_address: str = betterproto.string_field(7)
    token2_mint_symbol: str = betterproto.string_field(8)


@dataclass
class GetQuotesStreamRequest(betterproto.Message):
    projects: List["Project"] = betterproto.enum_field(1)
    token_pairs: List["TokenPair"] = betterproto.message_field(2)


@dataclass
class GetQuotesStreamResponse(betterproto.Message):
    slot: int = betterproto.int64_field(1)
    quote: "GetQuotesStreamUpdate" = betterproto.message_field(2)


@dataclass
class GetQuotesStreamUpdate(betterproto.Message):
    in_token: str = betterproto.string_field(1)
    in_token_address: str = betterproto.string_field(2)
    out_token: str = betterproto.string_field(3)
    out_token_address: str = betterproto.string_field(4)
    in_amount: float = betterproto.double_field(5)
    out_amount: float = betterproto.double_field(6)
    project: "Project" = betterproto.enum_field(7)


@dataclass
class GetSwapsStreamRequest(betterproto.Message):
    projects: List["Project"] = betterproto.enum_field(1)
    pools: List[str] = betterproto.string_field(2)
    include_failed: bool = betterproto.bool_field(3)


@dataclass
class GetSwapsStreamResponse(betterproto.Message):
    slot: int = betterproto.int64_field(1)
    swap: "GetSwapsStreamUpdate" = betterproto.message_field(2)


@dataclass
class GetSwapsStreamUpdate(betterproto.Message):
    success: bool = betterproto.bool_field(1)
    project: "Project" = betterproto.enum_field(2)
    pool_address: str = betterproto.string_field(3)
    base_token: str = betterproto.string_field(4)
    base_token_address: str = betterproto.string_field(5)
    quote_token: str = betterproto.string_field(6)
    quote_token_address: str = betterproto.string_field(7)
    in_amount: int = betterproto.uint64_field(8)
    out_amount_min: int = betterproto.uint64_field(9)
    source_account: str = betterproto.string_field(10)
    destination_account: str = betterproto.string_field(11)
    owner_account: str = betterproto.string_field(12)
    signature: str = betterproto.string_field(13)


@dataclass
class TokenPair(betterproto.Message):
    in_token: str = betterproto.string_field(1)
    out_token: str = betterproto.string_field(2)
    in_amount: float = betterproto.double_field(3)


@dataclass
class GetPriceRequest(betterproto.Message):
    tokens: List[str] = betterproto.string_field(1)


@dataclass
class GetPriceResponse(betterproto.Message):
    token_prices: List["TokenPrice"] = betterproto.message_field(1)


@dataclass
class TokenPrice(betterproto.Message):
    token: str = betterproto.string_field(1)
    token_address: str = betterproto.string_field(2)
    project: "Project" = betterproto.enum_field(3)
    buy: float = betterproto.double_field(4)
    buy_size: float = betterproto.double_field(5)
    sell: float = betterproto.double_field(6)
    sell_size: float = betterproto.double_field(7)


@dataclass
class GetPoolReservesStreamResponse(betterproto.Message):
    slot: int = betterproto.int64_field(1)
    reserves: "PoolReserves" = betterproto.message_field(2)


@dataclass
class PoolReserves(betterproto.Message):
    token1_reserves: str = betterproto.string_field(1)
    token1_address: str = betterproto.string_field(2)
    token2_reserves: str = betterproto.string_field(3)
    token2_address: str = betterproto.string_field(4)
    pool_address: str = betterproto.string_field(5)
    project: "Project" = betterproto.enum_field(6)


@dataclass
class GetPoolReservesStreamRequest(betterproto.Message):
    projects: List["Project"] = betterproto.enum_field(1)


@dataclass
class GetPricesStreamRequest(betterproto.Message):
    projects: List["Project"] = betterproto.enum_field(1)
    tokens: List[str] = betterproto.string_field(2)


@dataclass
class GetPricesStreamResponse(betterproto.Message):
    slot: int = betterproto.int64_field(1)
    price: "TokenPrice" = betterproto.message_field(2)


class ApiStub(betterproto.ServiceStub):
    async def get_price(self, *, tokens: List[str] = []) -> GetPriceResponse:
        request = GetPriceRequest()
        request.tokens = tokens

        return await self._unary_unary(
            "/api.Api/GetPrice",
            request,
            GetPriceResponse,
        )

    async def get_markets(self) -> GetMarketsResponse:
        request = GetMarketsRequest()

        return await self._unary_unary(
            "/api.Api/GetMarkets",
            request,
            GetMarketsResponse,
        )

    async def get_pools(self, *, projects: List["Project"] = []) -> GetPoolsResponse:
        request = GetPoolsRequest()
        request.projects = projects

        return await self._unary_unary(
            "/api.Api/GetPools",
            request,
            GetPoolsResponse,
        )

    async def get_tickers(
        self, *, market: str = "", program: "MarketProgram" = 0
    ) -> GetTickersResponse:
        request = GetTickersRequest()
        request.market = market
        request.program = program

        return await self._unary_unary(
            "/api.Api/GetTickers",
            request,
            GetTickersResponse,
        )

    async def get_kline(
        self,
        *,
        market: str = "",
        from_: Optional[datetime] = None,
        to: Optional[datetime] = None,
        resolution: str = "",
        limit: int = 0,
    ) -> GetKlineResponse:
        request = GetKlineRequest()
        request.market = market
        if from_ is not None:
            request.from_ = from_
        if to is not None:
            request.to = to
        request.resolution = resolution
        request.limit = limit

        return await self._unary_unary(
            "/api.Api/GetKline",
            request,
            GetKlineResponse,
        )

    async def get_orderbook(
        self, *, market: str = "", limit: int = 0, program: "MarketProgram" = 0
    ) -> GetOrderbookResponse:
        request = GetOrderbookRequest()
        request.market = market
        request.limit = limit
        request.program = program

        return await self._unary_unary(
            "/api.Api/GetOrderbook",
            request,
            GetOrderbookResponse,
        )

    async def get_trades(
        self, *, market: str = "", limit: int = 0, program: "MarketProgram" = 0
    ) -> GetTradesResponse:
        request = GetTradesRequest()
        request.market = market
        request.limit = limit
        request.program = program

        return await self._unary_unary(
            "/api.Api/GetTrades",
            request,
            GetTradesResponse,
        )

    async def get_quotes(
        self,
        *,
        in_token: str = "",
        out_token: str = "",
        in_amount: float = 0,
        slippage: float = 0,
        limit: int = 0,
        projects: List["Project"] = [],
    ) -> GetQuotesResponse:
        request = GetQuotesRequest()
        request.in_token = in_token
        request.out_token = out_token
        request.in_amount = in_amount
        request.slippage = slippage
        request.limit = limit
        request.projects = projects

        return await self._unary_unary(
            "/api.Api/GetQuotes",
            request,
            GetQuotesResponse,
        )

    async def get_server_time(self) -> GetServerTimeResponse:
        """system API"""

        request = GetServerTimeRequest()

        return await self._unary_unary(
            "/api.Api/GetServerTime",
            request,
            GetServerTimeResponse,
        )

    async def get_recent_block_hash(self) -> GetRecentBlockHashResponse:
        request = GetRecentBlockHashRequest()

        return await self._unary_unary(
            "/api.Api/GetRecentBlockHash",
            request,
            GetRecentBlockHashResponse,
        )

    async def get_account_balance(
        self, *, owner_address: str = ""
    ) -> GetAccountBalanceResponse:
        """account endpoints"""

        request = GetAccountBalanceRequest()
        request.owner_address = owner_address

        return await self._unary_unary(
            "/api.Api/GetAccountBalance",
            request,
            GetAccountBalanceResponse,
        )

    async def post_order(
        self,
        *,
        owner_address: str = "",
        payer_address: str = "",
        market: str = "",
        side: "Side" = 0,
        type: List["OrderType"] = [],
        amount: float = 0,
        price: float = 0,
        open_orders_address: str = "",
        client_order_i_d: int = 0,
        program: "MarketProgram" = 0,
    ) -> PostOrderResponse:
        """trade endpoints"""

        request = PostOrderRequest()
        request.owner_address = owner_address
        request.payer_address = payer_address
        request.market = market
        request.side = side
        request.type = type
        request.amount = amount
        request.price = price
        request.open_orders_address = open_orders_address
        request.client_order_i_d = client_order_i_d
        request.program = program

        return await self._unary_unary(
            "/api.Api/PostOrder",
            request,
            PostOrderResponse,
        )

    async def post_submit(
        self,
        *,
        transaction: Optional["TransactionMessage"] = None,
        skip_pre_flight: bool = False,
    ) -> PostSubmitResponse:
        request = PostSubmitRequest()
        if transaction is not None:
            request.transaction = transaction
        request.skip_pre_flight = skip_pre_flight

        return await self._unary_unary(
            "/api.Api/PostSubmit",
            request,
            PostSubmitResponse,
        )

    async def post_submit_batch(
        self,
        *,
        entries: List["PostSubmitRequestEntry"] = [],
        submit_strategy: "SubmitStrategy" = 0,
    ) -> PostSubmitBatchResponse:
        request = PostSubmitBatchRequest()
        if entries is not None:
            request.entries = entries
        request.submit_strategy = submit_strategy

        return await self._unary_unary(
            "/api.Api/PostSubmitBatch",
            request,
            PostSubmitBatchResponse,
        )

    async def post_cancel_order(
        self,
        *,
        order_i_d: str = "",
        side: "Side" = 0,
        market_address: str = "",
        owner_address: str = "",
        open_orders_address: str = "",
        program: "MarketProgram" = 0,
    ) -> PostCancelOrderResponse:
        request = PostCancelOrderRequest()
        request.order_i_d = order_i_d
        request.side = side
        request.market_address = market_address
        request.owner_address = owner_address
        request.open_orders_address = open_orders_address
        request.program = program

        return await self._unary_unary(
            "/api.Api/PostCancelOrder",
            request,
            PostCancelOrderResponse,
        )

    async def post_cancel_by_client_order_i_d(
        self,
        *,
        client_order_i_d: int = 0,
        market_address: str = "",
        owner_address: str = "",
        open_orders_address: str = "",
        program: "MarketProgram" = 0,
    ) -> PostCancelOrderResponse:
        request = PostCancelByClientOrderIDRequest()
        request.client_order_i_d = client_order_i_d
        request.market_address = market_address
        request.owner_address = owner_address
        request.open_orders_address = open_orders_address
        request.program = program

        return await self._unary_unary(
            "/api.Api/PostCancelByClientOrderID",
            request,
            PostCancelOrderResponse,
        )

    async def post_cancel_all(
        self,
        *,
        market: str = "",
        owner_address: str = "",
        open_orders_addresses: List[str] = [],
        program: "MarketProgram" = 0,
    ) -> PostCancelAllResponse:
        request = PostCancelAllRequest()
        request.market = market
        request.owner_address = owner_address
        request.open_orders_addresses = open_orders_addresses
        request.program = program

        return await self._unary_unary(
            "/api.Api/PostCancelAll",
            request,
            PostCancelAllResponse,
        )

    async def post_replace_by_client_order_i_d(
        self,
        *,
        owner_address: str = "",
        payer_address: str = "",
        market: str = "",
        side: "Side" = 0,
        type: List["OrderType"] = [],
        amount: float = 0,
        price: float = 0,
        open_orders_address: str = "",
        client_order_i_d: int = 0,
        program: "MarketProgram" = 0,
    ) -> PostOrderResponse:
        request = PostOrderRequest()
        request.owner_address = owner_address
        request.payer_address = payer_address
        request.market = market
        request.side = side
        request.type = type
        request.amount = amount
        request.price = price
        request.open_orders_address = open_orders_address
        request.client_order_i_d = client_order_i_d
        request.program = program

        return await self._unary_unary(
            "/api.Api/PostReplaceByClientOrderID",
            request,
            PostOrderResponse,
        )

    async def post_replace_order(
        self,
        *,
        owner_address: str = "",
        payer_address: str = "",
        market: str = "",
        side: "Side" = 0,
        type: List["OrderType"] = [],
        amount: float = 0,
        price: float = 0,
        open_orders_address: str = "",
        client_order_i_d: int = 0,
        order_i_d: str = "",
        program: "MarketProgram" = 0,
    ) -> PostOrderResponse:
        request = PostReplaceOrderRequest()
        request.owner_address = owner_address
        request.payer_address = payer_address
        request.market = market
        request.side = side
        request.type = type
        request.amount = amount
        request.price = price
        request.open_orders_address = open_orders_address
        request.client_order_i_d = client_order_i_d
        request.order_i_d = order_i_d
        request.program = program

        return await self._unary_unary(
            "/api.Api/PostReplaceOrder",
            request,
            PostOrderResponse,
        )

    async def post_settle(
        self,
        *,
        owner_address: str = "",
        market: str = "",
        base_token_wallet: str = "",
        quote_token_wallet: str = "",
        open_orders_address: str = "",
        program: "MarketProgram" = 0,
    ) -> PostSettleResponse:
        request = PostSettleRequest()
        request.owner_address = owner_address
        request.market = market
        request.base_token_wallet = base_token_wallet
        request.quote_token_wallet = quote_token_wallet
        request.open_orders_address = open_orders_address
        request.program = program

        return await self._unary_unary(
            "/api.Api/PostSettle",
            request,
            PostSettleResponse,
        )

    async def post_trade_swap(
        self,
        *,
        project: "Project" = 0,
        owner_address: str = "",
        in_token: str = "",
        out_token: str = "",
        in_amount: float = 0,
        slippage: float = 0,
    ) -> TradeSwapResponse:
        request = TradeSwapRequest()
        request.project = project
        request.owner_address = owner_address
        request.in_token = in_token
        request.out_token = out_token
        request.in_amount = in_amount
        request.slippage = slippage

        return await self._unary_unary(
            "/api.Api/PostTradeSwap",
            request,
            TradeSwapResponse,
        )

    async def get_orders(
        self,
        *,
        market: str = "",
        status: "OrderStatus" = 0,
        side: "Side" = 0,
        types: List["OrderType"] = [],
        from_: Optional[datetime] = None,
        limit: int = 0,
        direction: "Direction" = 0,
        address: str = "",
        open_orders_address: str = "",
        program: "MarketProgram" = 0,
    ) -> GetOrdersResponse:
        request = GetOrdersRequest()
        request.market = market
        request.status = status
        request.side = side
        request.types = types
        if from_ is not None:
            request.from_ = from_
        request.limit = limit
        request.direction = direction
        request.address = address
        request.open_orders_address = open_orders_address
        request.program = program

        return await self._unary_unary(
            "/api.Api/GetOrders",
            request,
            GetOrdersResponse,
        )

    async def get_open_orders(
        self,
        *,
        market: str = "",
        limit: int = 0,
        address: str = "",
        open_orders_address: str = "",
        program: "MarketProgram" = 0,
    ) -> GetOpenOrdersResponse:
        request = GetOpenOrdersRequest()
        request.market = market
        request.limit = limit
        request.address = address
        request.open_orders_address = open_orders_address
        request.program = program

        return await self._unary_unary(
            "/api.Api/GetOpenOrders",
            request,
            GetOpenOrdersResponse,
        )

    async def get_order_by_i_d(
        self, *, order_i_d: str = "", market: str = "", program: "MarketProgram" = 0
    ) -> GetOrderByIDResponse:
        request = GetOrderByIDRequest()
        request.order_i_d = order_i_d
        request.market = market
        request.program = program

        return await self._unary_unary(
            "/api.Api/GetOrderByID",
            request,
            GetOrderByIDResponse,
        )

    async def get_unsettled(
        self, *, market: str = "", owner_address: str = "", program: "MarketProgram" = 0
    ) -> GetUnsettledResponse:
        request = GetUnsettledRequest()
        request.market = market
        request.owner_address = owner_address
        request.program = program

        return await self._unary_unary(
            "/api.Api/GetUnsettled",
            request,
            GetUnsettledResponse,
        )

    async def post_route_trade_swap(
        self,
        *,
        project: "Project" = 0,
        owner_address: str = "",
        steps: List["RouteStep"] = [],
    ) -> TradeSwapResponse:
        request = RouteTradeSwapRequest()
        request.project = project
        request.owner_address = owner_address
        if steps is not None:
            request.steps = steps

        return await self._unary_unary(
            "/api.Api/PostRouteTradeSwap",
            request,
            TradeSwapResponse,
        )

    async def get_orderbooks_stream(
        self, *, markets: List[str] = [], limit: int = 0, program: "MarketProgram" = 0
    ) -> AsyncGenerator[GetOrderbooksStreamResponse, None]:
        """streaming endpoints"""

        request = GetOrderbooksRequest()
        request.markets = markets
        request.limit = limit
        request.program = program

        async for response in self._unary_stream(
            "/api.Api/GetOrderbooksStream",
            request,
            GetOrderbooksStreamResponse,
        ):
            yield response

    async def get_tickers_stream(
        self, *, market: str = "", program: "MarketProgram" = 0
    ) -> AsyncGenerator[GetTickersStreamResponse, None]:
        request = GetTickersRequest()
        request.market = market
        request.program = program

        async for response in self._unary_stream(
            "/api.Api/GetTickersStream",
            request,
            GetTickersStreamResponse,
        ):
            yield response

    async def get_market_depth_stream(
        self,
    ) -> AsyncGenerator[GetMarketDepthStreamResponse, None]:
        request = GetMarketsRequest()

        async for response in self._unary_stream(
            "/api.Api/GetMarketDepthStream",
            request,
            GetMarketDepthStreamResponse,
        ):
            yield response

    async def get_trades_stream(
        self, *, market: str = "", limit: int = 0, program: "MarketProgram" = 0
    ) -> AsyncGenerator[GetTradesStreamResponse, None]:
        request = GetTradesRequest()
        request.market = market
        request.limit = limit
        request.program = program

        async for response in self._unary_stream(
            "/api.Api/GetTradesStream",
            request,
            GetTradesStreamResponse,
        ):
            yield response

    async def get_order_status_stream(
        self, *, market: str = "", owner_address: str = "", program: "MarketProgram" = 0
    ) -> AsyncGenerator[GetOrderStatusStreamResponse, None]:
        request = GetOrderStatusStreamRequest()
        request.market = market
        request.owner_address = owner_address
        request.program = program

        async for response in self._unary_stream(
            "/api.Api/GetOrderStatusStream",
            request,
            GetOrderStatusStreamResponse,
        ):
            yield response

    async def get_recent_block_hash_stream(
        self,
    ) -> AsyncGenerator[GetRecentBlockHashResponse, None]:
        request = GetRecentBlockHashRequest()

        async for response in self._unary_stream(
            "/api.Api/GetRecentBlockHashStream",
            request,
            GetRecentBlockHashResponse,
        ):
            yield response

    async def get_quotes_stream(
        self, *, projects: List["Project"] = [], token_pairs: List["TokenPair"] = []
    ) -> AsyncGenerator[GetQuotesStreamResponse, None]:
        request = GetQuotesStreamRequest()
        request.projects = projects
        if token_pairs is not None:
            request.token_pairs = token_pairs

        async for response in self._unary_stream(
            "/api.Api/GetQuotesStream",
            request,
            GetQuotesStreamResponse,
        ):
            yield response

    async def get_pool_reserves_stream(
        self, *, projects: List["Project"] = []
    ) -> AsyncGenerator[GetPoolReservesStreamResponse, None]:
        request = GetPoolReservesStreamRequest()
        request.projects = projects

        async for response in self._unary_stream(
            "/api.Api/GetPoolReservesStream",
            request,
            GetPoolReservesStreamResponse,
        ):
            yield response

    async def get_prices_stream(
        self, *, projects: List["Project"] = [], tokens: List[str] = []
    ) -> AsyncGenerator[GetPricesStreamResponse, None]:
        request = GetPricesStreamRequest()
        request.projects = projects
        request.tokens = tokens

        async for response in self._unary_stream(
            "/api.Api/GetPricesStream",
            request,
            GetPricesStreamResponse,
        ):
            yield response

    async def get_swaps_stream(
        self,
        *,
        projects: List["Project"] = [],
        pools: List[str] = [],
        include_failed: bool = False,
    ) -> AsyncGenerator[GetSwapsStreamResponse, None]:
        request = GetSwapsStreamRequest()
        request.projects = projects
        request.pools = pools
        request.include_failed = include_failed

        async for response in self._unary_stream(
            "/api.Api/GetSwapsStream",
            request,
            GetSwapsStreamResponse,
        ):
            yield response
