/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc;

import com.teradata.jdbc.Const;
import com.teradata.jdbc.TeraSQLXML;
import com.teradata.jdbc.URLParameters;
import com.teradata.jdbc.encode.ConnectionCharsetInfo;
import com.teradata.jdbc.jdbc.DecryptPass;
import com.teradata.jdbc.jdbc.GenericTeraEncrypt;
import com.teradata.jdbc.jdbc.SerialNumber;
import com.teradata.jdbc.jdbc_4.LogonInformation;
import com.teradata.jdbc.jdbc_4.ifsupport.LocalEscapeFunctions;
import com.teradata.jdbc.jdbc_4.io.TDNetworkIOIF;
import com.teradata.jdbc.jdbc_4.io.TDPacket;
import com.teradata.jdbc.jdbc_4.io.WireProtocol;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.AssignRspParcel;
import com.teradata.jdbc.jdbc_4.parcel.ConfigRspParcel;
import com.teradata.jdbc.jdbc_4.parcel.GtwConfigParcel;
import com.teradata.jdbc.jdbc_4.parcel.LogonSequenceNumberParcel;
import com.teradata.jdbc.jdbc_4.parcel.RecoverableNPSupportedParcel;
import com.teradata.jdbc.jdbc_4.parcel.RedriveParcel;
import com.teradata.jdbc.jdbc_4.parcel.RedriveSupportedParcel;
import com.teradata.jdbc.jdbc_4.parcel.SecurityPolicyParcel;
import com.teradata.jdbc.jdbc_4.parcel.StatementStatusParcel;
import com.teradata.jdbc.jdbc_4.statemachine.StatementReceiveState;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.Mutex;
import com.teradata.jdbc.jdbc_4.util.SizeConstrainedMap;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Collections;
import java.util.Map;

public abstract class GenericTeradataConnection
implements LocalEscapeFunctions {
    public static final char ANSI_SEMANTICS = 'A';
    public static final char TD_SEMANTICS = 'T';
    public static final char DEFAULT_SEMANTICS = 'D';
    protected TDNetworkIOIF io;
    protected String machineName;
    protected URLParameters urlParams;
    protected Log log;
    private LogonInformation logonInformation;
    protected Mutex sessionLock;
    private ConnectionCharsetInfo m_charsetInfo;
    private long m_nLoginEndTime = 0L;
    private SQLWarning m_sqlWarningChain = null;
    private final Object m_oWarningChainMutex = new Object();
    protected ConfigRspParcel configRsp;
    protected AssignRspParcel assignRsp;
    private GenericTeraEncrypt myEncrypt = null;
    private LogonSequenceNumberParcel logonSeqNumParcel = null;
    private SerialNumber m_requestNum = new SerialNumber();
    private SerialNumber m_authenticationNonce = new SerialNumber();
    private boolean m_bSuppressReconnect = false;
    private GtwConfigParcel m_gtwConfig;
    private boolean m_bSessionShouldUseRedrive;
    private boolean m_bSessionSupportsRedrive;
    private boolean m_bSessionSupportsRecoverableNP;
    private SecurityPolicyParcel m_securityPolicyParcel;
    private String m_sTeradataDatabaseVersion = null;
    private int[] m_anTeradataDatabaseVersionNumbers = null;
    private boolean m_bRequestTracking = false;
    private Map m_mapRequests = Collections.synchronizedMap(new SizeConstrainedMap(10));
    public static final int PACKET_64KB = 1;
    public static final int PACKET_BIG = 2;

    protected GenericTeradataConnection(String string, String string2, String string3, URLParameters uRLParameters) throws SQLException {
        this.machineName = string;
        this.log = new Log(this.toString());
        this.myEncrypt = new GenericTeraEncrypt(this.log);
        this.updateURLParameters(uRLParameters);
        if (this.log.canLog(2)) {
            this.log.timing("Teradata JDBC Driver " + Const.DRIVER_VERSION);
        }
        if (string3 != null) {
            string3 = DecryptPass.decryptPass(string3, true, this.log);
        }
        if (this.urlParams.getNewPassword() != null) {
            this.urlParams.setNewPassword(DecryptPass.decryptPass(this.urlParams.getNewPassword(), true, this.log));
        }
        if (this.urlParams.getLogData() != null) {
            this.urlParams.setLogData(DecryptPass.decryptPass(this.urlParams.getLogData(), false, this.log));
        }
        this.logonInformation = new LogonInformation(string2, string3);
        if (this.urlParams.getAccountId().compareTo("NO_ACCOUNT_ID") != 0) {
            this.logonInformation.setAccount(this.urlParams.getAccountId());
        }
        this.sessionLock = new Mutex("SessionLock", this.log);
        if (this.urlParams.getLoginTimeout() != 0) {
            this.m_nLoginEndTime = System.currentTimeMillis() + (long)(this.urlParams.getLoginTimeout() * 1000);
        }
    }

    public LogonInformation getLogonInformation() {
        return this.logonInformation;
    }

    public TDNetworkIOIF getIO() throws SQLException {
        if (this.io == null) {
            this.io = new TDNetworkIOIF(this);
        }
        return this.io;
    }

    public String getlogmech() {
        return this.urlParams.getLogMech();
    }

    public String getlogdata() {
        return this.urlParams.getLogData();
    }

    public GenericTeraEncrypt getTeraEncrypt() {
        return this.myEncrypt;
    }

    public void setAssignRspParcel(AssignRspParcel assignRspParcel) {
        this.assignRsp = assignRspParcel;
    }

    protected LocalEscapeFunctions getLocalEscapeFunctions() {
        return this;
    }

    public String getLogonSequenceNumber() {
        if (this.logonSeqNumParcel != null) {
            return String.valueOf(this.logonSeqNumParcel.getLogonSequenceNumber());
        }
        if (this.urlParams.getLogonSequenceNumber() != null) {
            return this.urlParams.getLogonSequenceNumber().toString();
        }
        return "";
    }

    public void setLogonSequenceNumberParcel(LogonSequenceNumberParcel logonSequenceNumberParcel) {
        this.logonSeqNumParcel = logonSequenceNumberParcel;
    }

    public String getAMPCount() {
        return this.configRsp == null ? "" : String.valueOf(this.configRsp.getAMPCount());
    }

    public String getLogLevel() {
        return this.log.getLogLevel();
    }

    public String setLogLevel(String string) {
        this.log.setLogLevel(string);
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyStatementSuccess(StatementReceiveState statementReceiveState, StatementStatusParcel statementStatusParcel) {
        boolean bl;
        StringBuffer stringBuffer;
        if (!this.m_bRequestTracking) {
            return;
        }
        Integer n = new Integer(statementReceiveState.getRequestNum());
        Map map = this.m_mapRequests;
        synchronized (map) {
            stringBuffer = (StringBuffer)this.m_mapRequests.get(n);
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
                this.m_mapRequests.put(n, stringBuffer);
            }
        }
        byte by = statementReceiveState.getController().getMode();
        boolean bl2 = bl = by == 66 || by == 69;
        if (stringBuffer.length() == 0) {
            stringBuffer.append("request_" + statementReceiveState.getRequestNum() + "_origin=" + statementReceiveState.getController().getRequestOrigin() + Log.LINE_SEP);
            stringBuffer.append("request_" + statementReceiveState.getRequestNum() + "_processing_option=" + (bl ? "execute" : "prepare") + " " + (char)by + Log.LINE_SEP);
        }
        stringBuffer.append("request_" + statementReceiveState.getRequestNum() + "_statement_" + statementStatusParcel.getStatementNumber() + "_activity_type=" + statementStatusParcel.getActivityType() + " " + WireProtocol.activityType(statementStatusParcel.getActivityType()) + Log.LINE_SEP);
        if (bl) {
            stringBuffer.append("request_" + statementReceiveState.getRequestNum() + "_statement_" + statementStatusParcel.getStatementNumber() + "_activity_count=" + statementStatusParcel.getActivityCount() + Log.LINE_SEP);
        }
    }

    public String teradataProvide(String string, Map map) throws SQLException {
        String string2 = string.trim().toUpperCase();
        if ("REQUESTS".equals(string2)) {
            StringBuffer stringBuffer = new StringBuffer();
            Map.Entry[] entryArray = this.m_mapRequests.entrySet().toArray(new Map.Entry[0]);
            if (entryArray.length > 0) {
                stringBuffer.append("first_request_number=" + entryArray[0].getKey() + Log.LINE_SEP);
            }
            for (int i = 0; i < entryArray.length; ++i) {
                stringBuffer.append((StringBuffer)entryArray[i].getValue());
            }
            return stringBuffer.toString();
        }
        if ("CLEAR_REQUESTS".equals(string2)) {
            this.m_mapRequests.clear();
            return "";
        }
        if ("REQUEST_TRACKING".equals(string2)) {
            return this.m_bRequestTracking ? "ON" : "OFF";
        }
        if ("REQUEST_TRACKING_ON".equals(string2)) {
            this.m_bRequestTracking = true;
            return "";
        }
        if ("REQUEST_TRACKING_OFF".equals(string2)) {
            this.m_bRequestTracking = false;
            return "";
        }
        if ("SESSION_CHARSET_NAME".equals(string2)) {
            return this.urlParams.getCharSet();
        }
        if ("SESSION_CHARSET_CODE".equals(string2)) {
            return "" + (this.getTdSessionCharSetCode() & 0xFF);
        }
        if ("JAVA_CHARSET_NAME".equals(string2)) {
            return this.m_charsetInfo.getClientCharsetNameForClientAttributes();
        }
        if ("TRANSACTION_MODE".equals(string2)) {
            return this.isAnsiMode() ? "ANSI" : "TERA";
        }
        if ("HOST_ID".equals(string2)) {
            return "" + (this.assignRsp.getHostID() & 0xFFFF);
        }
        if ("REQUEST_SCOPE_MAYBENULL_ON".equals(string2)) {
            if (map != null) {
                map.put("REQUEST_SCOPE_MAYBENULL_ON", "");
            }
            return "";
        }
        if ("REQUEST_SCOPE_COLUMN_NAME_ON".equals(string2)) {
            if (map != null) {
                map.put("REQUEST_SCOPE_COLUMN_NAME_ON", "");
            }
            return "";
        }
        if ("REQUEST_SCOPE_COLUMN_NAME_OFF".equals(string2)) {
            if (map != null) {
                map.put("REQUEST_SCOPE_COLUMN_NAME_OFF", "");
            }
            return "";
        }
        if ("REQUEST_SCOPE_REFRESH_RSMD".equals(string2)) {
            if (map != null) {
                map.put("REQUEST_SCOPE_REFRESH_RSMD", "");
            }
            return "";
        }
        if ("DEFAULT_CONNECTION".equals(string2)) {
            return Boolean.toString(this.getIO().isJavaSPDefaultConnection());
        }
        if ("ORIGINAL_HOSTNAME".equals(string2)) {
            return this.getIO().isJavaSPDefaultConnection() ? "" : this.getIO().getOriginalHostName();
        }
        if ("REMOTE_ADDRESS".equals(string2)) {
            return this.getIO().isJavaSPDefaultConnection() ? "" : "" + this.getIO().getRemoteAddress();
        }
        if ("REMOTE_PORT".equals(string2)) {
            return this.getIO().isJavaSPDefaultConnection() ? "" : "" + this.getIO().getRemotePort();
        }
        if ("LOCAL_ADDRESS".equals(string2)) {
            return this.getIO().isJavaSPDefaultConnection() ? "" : "" + this.getIO().getLocalAddress();
        }
        if ("LOCAL_PORT".equals(string2)) {
            return this.getIO().isJavaSPDefaultConnection() ? "" : "" + this.getIO().getLocalPort();
        }
        if ("CONNECTION_ID".equals(string2)) {
            return this.getIO().getConnectionID();
        }
        if ("RNP_ACTIVE".equals(string2)) {
            return Boolean.toString(this.isRecoverableNPActive());
        }
        if ("REDRIVE_ACTIVE".equals(string2)) {
            return Boolean.toString(this.isRedriveActive());
        }
        return "";
    }

    public String useAnsiDate() {
        return "";
    }

    public String useIntegerDate() {
        return "";
    }

    public String getSessionNumber() {
        return this.io != null ? String.valueOf(this.io.getSessionNum()) : "";
    }

    public String getSocketInfo() {
        return this.io != null ? this.io.toString() : "";
    }

    public byte getTdSessionCharSetCode() throws SQLException {
        return this.configRsp.getTDCharSetCodeFromName(this.urlParams.getCharSet());
    }

    public int getSessionNum() {
        return this.io.getSessionNum();
    }

    public void setSessionNum(int n) {
        this.io.setSessionNum(n);
    }

    public char getTransactionSemantics() {
        return this.urlParams.getTransactMode().charAt(0);
    }

    public boolean isAnsiMode() {
        return this.getTransactionSemantics() == 'A' || this.getTransactionSemantics() == 'D' && this.configRsp.getDefaultTransactionSemantics() == 'A';
    }

    public int getMaxMessageSize(boolean bl, boolean bl2) {
        int n = bl ? this.configRsp.getMaxRequestMessageBodySize() : this.configRsp.getMaxResponseMessageBodySize();
        int n2 = this.urlParams.getMaxMessageBody();
        int n3 = Math.min(n, n2);
        return (bl2 ? 52 : 0) + n3;
    }

    public TDPacket createPacket(int n) {
        switch (n) {
            case 1: {
                return new TDPacket(65156);
            }
            case 2: {
                return new TDPacket(this.getMaxMessageSize(true, true));
            }
        }
        throw new IllegalArgumentException("Invalid value for nPacketOption=" + n);
    }

    public String getMachineName() {
        return this.machineName;
    }

    public int getMachinePort() {
        return this.urlParams.getDbsPort();
    }

    public URLParameters getURLParameters() {
        return this.urlParams;
    }

    public Log getLog() {
        return this.log;
    }

    public int checkRemainingLoginTime() throws SQLException {
        if (this.m_nLoginEndTime == 0L) {
            return 0;
        }
        long l = this.m_nLoginEndTime - System.currentTimeMillis();
        if (l <= 0L) {
            throw ErrorFactory.makeDriverJDBCException("TJ589", this.machineName);
        }
        if (l > Integer.MAX_VALUE) {
            l = Integer.MAX_VALUE;
        }
        if (this.log.canLog(2)) {
            this.log.timing("Login time remaining is " + l + " ms");
        }
        return (int)l;
    }

    public boolean isClosed() throws SQLException {
        return this.io == null || this.io.isClosed();
    }

    protected void abortIfClosed() throws SQLException {
        if (this.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ408");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLWarning getWarnings() throws SQLException {
        this.abortIfClosed();
        Object object = this.m_oWarningChainMutex;
        synchronized (object) {
            return this.m_sqlWarningChain;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearWarnings() throws SQLException {
        this.abortIfClosed();
        Object object = this.m_oWarningChainMutex;
        synchronized (object) {
            this.m_sqlWarningChain = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWarning(SQLWarning sQLWarning) {
        Object object = this.m_oWarningChainMutex;
        synchronized (object) {
            if (this.m_sqlWarningChain != null) {
                this.m_sqlWarningChain.setNextWarning(sQLWarning);
            } else {
                this.m_sqlWarningChain = sQLWarning;
            }
        }
    }

    public boolean supportsPasswordChange() {
        return false;
    }

    public void setNeedNewPassword(boolean bl) {
    }

    public void updateURLParameters(URLParameters uRLParameters) throws SQLException {
        this.log.setLogLevel(uRLParameters.getLogLevel());
        if (this.urlParams == null) {
            this.urlParams = uRLParameters;
        } else {
            URLParameters.updateForDefaultConnection(this.urlParams, uRLParameters);
        }
        this.m_charsetInfo = new ConnectionCharsetInfo(this);
    }

    public boolean isExtObjectNameParcelSupported() {
        return this.configRsp != null && this.configRsp.isExtObjectNameParcelSupported();
    }

    public int getRequestNum() {
        return this.m_requestNum.getIntNextValue();
    }

    public int getCurrentRequestNum() {
        return this.m_requestNum.getIntCurrentValue();
    }

    public void setCurrentRequestNum(int n) {
        this.m_requestNum.setLongCurrentValue(n);
    }

    public long getAuthenticationNonce() {
        return this.m_authenticationNonce.getLongNextValue();
    }

    public long readAuthenticationNonce() {
        return this.m_authenticationNonce.getLongCurrentValue();
    }

    public void setAuthenticationNonce(long l) {
        this.m_authenticationNonce.setLongCurrentValue(l);
    }

    public ConfigRspParcel getConfigResponse() {
        return this.configRsp;
    }

    public void setConfigResponse(ConfigRspParcel configRspParcel) {
        this.configRsp = configRspParcel;
        if (this.log.canLog(2)) {
            this.log.timing(this.getTeradataDatabaseVersion());
        }
    }

    public Blob constructLocatorBlob(long l, byte[] byArray, boolean bl) {
        return null;
    }

    public Clob constructLocatorClob(long l, byte[] byArray, boolean bl) {
        return null;
    }

    public TeraSQLXML constructLocatorSQLXML(short s, long l, byte[] byArray) {
        return null;
    }

    public boolean hasResponseNullIndicatorBits() {
        return true;
    }

    public boolean isLobSupported() {
        return this.configRsp.getLOBSupport() && this.urlParams.isLobSupported();
    }

    public boolean isStatementInfoSupported() {
        return this.configRsp.isStatementInfoSupported() && this.urlParams.sipSupport();
    }

    public void suppressReconnect() {
        this.m_bSuppressReconnect = true;
    }

    public boolean isReconnectEnabled() {
        return (this.isRecoverableNPActive() || this.urlParams.getReconnectCount() != 0 || this.urlParams.getReconnectInterval() != 0) && !this.m_bSuppressReconnect;
    }

    public boolean dynamicResultSetsSupported() {
        return this.configRsp.isDynamicResultSetsSupported();
    }

    public boolean isPeriodAsStructSupported() {
        return this.configRsp.isPeriodAsStructSupported() && this.isStatementInfoSupported();
    }

    public boolean isArrayDataTypeSupported() {
        return this.configRsp.isArrayDataTypeSupported() && this.isStatementInfoSupported();
    }

    public boolean isXMLDataTypeSupported() {
        return this.configRsp.isXMLSupported() && this.isStatementInfoSupported();
    }

    public ConnectionCharsetInfo getCharsetInfo() {
        return this.m_charsetInfo;
    }

    public boolean isStrictEncode() {
        return this.urlParams.getStrictEncode() == Boolean.TRUE;
    }

    public void setGtwConfig(GtwConfigParcel gtwConfigParcel) {
        this.m_gtwConfig = gtwConfigParcel;
    }

    public GtwConfigParcel getGtwConfig() {
        return this.m_gtwConfig;
    }

    public void notifyRedrive(RedriveParcel redriveParcel) {
        this.m_bSessionShouldUseRedrive = redriveParcel.getValue() != 0;
    }

    public void notifyRedriveSupported(RedriveSupportedParcel redriveSupportedParcel) {
        this.m_bSessionSupportsRedrive = redriveSupportedParcel.getValue() != 0;
    }

    public void notifyRecoverableNPSupported(RecoverableNPSupportedParcel recoverableNPSupportedParcel) {
        this.m_bSessionSupportsRecoverableNP = recoverableNPSupportedParcel.getValue() != 0;
    }

    public int databaseCapableOfRedriveLevel() {
        if (!this.m_gtwConfig.isControlDataSupported() || !this.configRsp.isControlDataSupported()) {
            return 0;
        }
        if (!this.m_gtwConfig.isRecoverableNPSupported() || !this.configRsp.isRecoverableNPSupported()) {
            return 1;
        }
        if (!this.m_gtwConfig.isRedriveSupported() || !this.configRsp.isRedriveSupported()) {
            return 2;
        }
        return 3;
    }

    public int desiredRedriveLevel() {
        Integer n = this.urlParams.getRedrive();
        return n == null ? this.connectionTypeDefaultRedriveLevel() : n.intValue();
    }

    protected int connectionTypeDefaultRedriveLevel() {
        return 3;
    }

    public boolean isRecoverableNPActive() {
        return this.m_bSessionSupportsRecoverableNP && this.desiredRedriveLevel() >= 2;
    }

    public boolean isRedriveActive() {
        return this.m_bSessionShouldUseRedrive && this.m_bSessionSupportsRedrive && this.desiredRedriveLevel() >= 3;
    }

    public boolean getEncryptData() {
        return this.urlParams.getEncryptData();
    }

    public void notifySecurityPolicy(SecurityPolicyParcel securityPolicyParcel) {
        this.m_securityPolicyParcel = securityPolicyParcel;
    }

    public SecurityPolicyParcel getSecurityPolicy() {
        return this.m_securityPolicyParcel;
    }

    public String getTeradataDatabaseVersion() {
        if (this.m_sTeradataDatabaseVersion == null) {
            String string;
            String string2;
            if (this.configRsp.getTeradataDatabaseRelease() != null) {
                string2 = this.configRsp.getTeradataDatabaseRelease();
                string = this.configRsp.getTeradataDatabaseVersion();
            } else {
                string2 = this.assignRsp.getDBSRelease();
                string = this.assignRsp.getDBSVersion();
            }
            if (string.startsWith("0")) {
                string = string2.substring(0, 3) + string;
            }
            this.m_sTeradataDatabaseVersion = "Teradata Database " + string;
        }
        return this.m_sTeradataDatabaseVersion;
    }

    public int[] getTeradataDatabaseVersionNumbers() {
        if (this.m_anTeradataDatabaseVersionNumbers == null) {
            String[] stringArray = this.getTeradataDatabaseVersion().replaceAll("\\D+", " ").trim().split(" ");
            this.m_anTeradataDatabaseVersionNumbers = new int[]{Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2])};
        }
        return this.m_anTeradataDatabaseVersionNumbers;
    }

    public int getTeradataDatabaseVersionNumber() {
        int[] nArray = this.getTeradataDatabaseVersionNumbers();
        if (nArray[0] < 12) {
            return nArray[1] * 10 + nArray[2];
        }
        return nArray[0] * 100 + nArray[1];
    }
}

