# Generated by Django 2.2.23 on 2021-06-01 14:53

from django.contrib.auth.models import Group
from django.db import migrations
from guardian.shortcuts import assign_perm, get_objects_for_group


def update_repo_perms(apps, schema_editor):
    """ Assign push repo perms to the namespace and distribution groups. """
    AccessPolicy = apps.get_model('core', 'AccessPolicy')
    push_repo_viewset = 'repositories/container/container-push'
    dist_viewset = 'distributions/container/container'
    namespace_viewset = 'pulp_container/namespaces'
    viewset_names = (dist_viewset, namespace_viewset, push_repo_viewset)
    existing_perms = (
        'container.modify_content_containerpushrepository',
        'container.namespace_modify_content_containerpushrepository',
    )
    groups_ns = Group.objects.filter(
        name__regex=r'container.(distribution|namespace).(collaborators|owners)'
    )

    for viewset_name in viewset_names:
        try:
            db_access_policy = AccessPolicy.objects.get(viewset_name=viewset_name)
        except AccessPolicy.DoesNotExist:
            pass
        else:
            if not db_access_policy.customized:
                for perm in existing_perms:
                    for group in groups_ns:
                        objs = get_objects_for_group(group, perm, accept_global_perms=False)
                        for obj in objs:
                            if obj.ACCESS_POLICY_VIEWSET_NAME == namespace_viewset:
                                assign_perm('container.namespace_change_containerpushrepository', group, obj)
                            elif obj.ACCESS_POLICY_VIEWSET_NAME == push_repo_viewset:
                                assign_perm('container.change_containerpushrepository', group, obj)


def add_new_perms(apps, schema_editor):
    """
    Add new permission to the table.
    Permissions are being created in a signal after all migrations are run.
    To avoid emitting post_migrate signal in the migration, as a workaround,
    the permission is being added manually so it can be assigned as part of the migration.
    """
    ContentType = apps.get_model('contenttypes', 'ContentType')
    Permission = apps.get_model('auth', 'Permission')
    ctype_ns = ContentType.objects.filter(app_label='container', model='containernamespace')
    if ctype_ns:
        p = Permission.objects.create(
            codename='namespace_change_containerpushrepository',
            name='Update any existing push repository in a namespace',
            content_type_id=ctype_ns[0].id,
        )
        p.save()


class Migration(migrations.Migration):

    dependencies = [
        ('container', '0019_DATA_distribution_model_swap'),
    ]

    operations = [
        migrations.AlterModelOptions(
            name='containernamespace',
            options={'permissions': [('namespace_add_containerdistribution', 'Add any distribution to a namespace'), ('namespace_delete_containerdistribution', 'Delete any distribution from a namespace'), ('namespace_view_containerdistribution', 'View any distribution in a namespace'), ('namespace_pull_containerdistribution', 'Pull from any distribution in a namespace'), ('namespace_push_containerdistribution', 'Push to any distribution in a namespace'), ('namespace_change_containerdistribution', 'Change any distribution in a namespace'), ('namespace_view_containerpushrepository', 'View any push repository in a namespace'), ('namespace_modify_content_containerpushrepository', 'Modify content in any push repository in a namespace'), ('namespace_change_containerpushrepository', 'Update any existing push repository in a namespace')]},
        ),
        migrations.RunPython(add_new_perms, reverse_code=migrations.RunPython.noop),
        migrations.RunPython(update_repo_perms, reverse_code=migrations.RunPython.noop),
    ]
